<?php
$dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
$pdf = ($reporte == 'pdf') ? true : false;
if ($reporte == 'excel') {
    header("Content-type: application/vnd.ms-excel; name='Reporte_horas_extras'");
    header("Content-Disposition: filename=Reporte_horas_extras.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6" >
                    <h4>
                        <?= mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') ?>
                        <br />
                        <span>Reporte de Horas Extras</span>
                    </h4>
                    <br>
                    <?php echo $subtitle; ?>
                </td>
            </tr>
        </table>
    </div>
    <br>
    <?php    
}
if ($reporte == 'pdf') {
    ?>
    <style type="text/css">
        table th{
            text-align: center;
            font-weight: bold;
        }
    </style>
    <?php
}
?>
<table id="checkAll" cellpadding="2" border="1" class="responsive display  table table-bordered" width="100%">
    <thead>
        <tr>
            <th <?php echo ($pdf) ? 'width="4%"' : ""; ?>>#</th>
            <th <?php echo ($pdf) ? 'width="7%"' : ""; ?>>Código</th> 
            <th <?php echo ($pdf) ? 'width="22%"' : ""; ?>>Empleado</th> 
            <th <?php echo ($pdf) ? 'width="10%"' : ""; ?>>Fecha Registro</th>  
            <th <?php echo ($pdf) ? 'width="20%"' : ""; ?>>Periodo</th>
            <th <?php echo ($pdf) ? 'width="15%"' : ""; ?>>Tipo hora</th>
            <th <?php echo ($pdf) ? 'width="11%"' : ""; ?>>Nº Horas</th>
            <th <?php echo ($pdf) ? 'width="11%"' : ""; ?>>Monto</th>
        </tr>
    </thead>
    <tbody>
    <?php 
    if (count($horas_extra) > 0) {
        $i = 1;
        foreach ($horas_extra as $key => $val) {
            $total_h += $val['ctdad_horas']; 
            $total += $val['monto'];
            $plani = ($val['pla_fecha_inicio'] != "" && $val['pla_fecha_fin'] != "") ? formatear_fecha('d-m-Y', $val['pla_fecha_inicio']) . ' al ' . formatear_fecha('d-m-Y', $val['pla_fecha_fin']) : "";
            ?>
            <tr>
                <td <?php echo ($pdf) ? 'width="4%"' : ""; ?>><?php echo $i; ?></td>
                <td <?php echo ($pdf) ? 'width="7%"' : ""; ?>><?php echo $val['emp_codigo'];?></td>
                <td <?php echo ($pdf) ? 'width="22%"' : ""; ?>><?php echo $val['nombre'];?></td>
                <td <?php echo ($pdf) ? 'width="10%"' : ""; ?>><?php echo ($val['hxe_fecha'] != "") ? formatear_fecha('d-m-Y', $val['hxe_fecha']) : "";?></td>
                <td <?php echo ($pdf) ? 'width="20%"' : ""; ?>><?php echo $plani; ?></td>
                <td <?php echo ($pdf) ? 'width="15%"' : ""; ?>><?php echo $val['the_nombre'];?></td>
                <td <?php echo ($pdf) ? 'width="11%"' : ""; ?> style="text-align:right; "><?php echo number_format($val['ctdad_horas'], $dec); ?></td>
                <td <?php echo ($pdf) ? 'width="11%"' : ""; ?> style="text-align:right; "><?php echo ($val['monto'] > 0) ? "$" . number_format($val['monto'], 2) : ""; ?></td>
            </tr>
            <?php
            $i++;
        }
    } else {
        if ($reporte != "") {
            ?>
            <tr>
                <td colspan="8" style=" text-align: center; ">No se encontraron resultados.</td>
            </tr>
            <?php
        }
    }
    ?>
    </tbody>
    <?php if (count($horas_extra) > 0) {
        ?>
        <tfoot>
            <tr>
                <td colspan="6" style="text-align: right;"><b>Totales</b></td>
                <td style="text-align: right;"><b><?php echo number_format($total_h, $dec); ?></b></td>
                <td style="text-align: right;"><b>$<?php echo number_format($total, 2); ?></b></td>
            </tr>
        </tfoot>
        <?php
    } ?>
 </table>