<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Utm_model extends CI_Model
{

    function __construct()
    {
        $this->load->database();
        //$this->db->db_debug=false;
    }

    function anexo_empleado($emp_id)
    {
        $anexos = $this->db->select()
            ->from('axe_anexoxempleado')
            ->join('anx_anexo', 'anx_id = axe_id_anx')
            ->where('axe_id_emp', $emp_id);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function obtener_periodo_planilla($t_planilla)
    {
        $this->db->select()
            ->from('pla_planilla')
            ->where('pla_id_tpl', $t_planilla);
        $periodos = $this->db->get();
        return $periodos->result_array();
    }

    function tipo_descuento()
    {
        $tipos = $this->db->select()
            ->from('tdc_tipo_descuento')
            ->where('tdc_id !=', 3)
            ->where('tdc_id !=', 1)
            ->where('tdc_id !=', 6);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function tipo_ingreso()
    {
        $tipos = $this->db->select()
            ->from('tig_tipo_ingreso')
            ->where('tig_id !=', 3)
            ->where('tig_id !=', 1)
            ->where('tig_id !=', 6);
        $resultado = $this->db->get();

        return $resultado->result_array();
    }

    function listado_empleados()
    {
        $empleados = $this->db->select()
            ->from('emp_empleado')
            ->join('pto_puesto', 'pto_id=emp_id_pto')
            ->get();
        return $empleados->result_array();
    }

    function get_departamento()
    {
        $area = $this->db->select()
            ->from('are_area')
            ->get();
        return $area->result_array();
    }

    function info_empleado($id)
    {
        $emp = $this->db->select()
            ->where('emp_id', $id)
            ->from('emp_empleado')
            ->get();
        return $emp->result_array();
    }

    function descuentos_empleado($id)
    {
        $desc = $this->db->select()
            ->where('dss_id_emp', $id)
            ->from('dss_descuento')
            ->join('tdc_tipo_descuento', 'tdc_id=dss_id_tdc')
            ->get();
        return $desc->result_array();
    }

    function ingresos_empleado($id)
    {
        $inn = $this->db->select()
            ->where('inn_id_emp', $id)
            ->from('inn_ingreso')
            ->join('tig_tipo_ingreso', 'tig_id=inn_id_tig')
            ->get();
        return $inn->result_array();
    }

    public function editar_empleado($id_emp)
    {
        $query = "SELECT * FROM emp_empleado
        LEFT JOIN txe_tipo_planillaxempleado ON txe_id_emp = emp_id
        LEFT JOIN tpl_tipo_planilla ON tpl_id = txe_id_tpl
        WHERE emp_id = " . $id_emp;
        $resultado = $this->db->query($query);
        return $resultado->result_array();
    }

    public function editar_tel_empleado($id_emp)
    {
        $query = "SELECT * FROM txm_telefonoxempleado
        INNER JOIN tel_telefono ON tel_id = txm_id_tel
        LEFT JOIN tit_tipo_telefono ON tit_id = tel_id_tit
        WHERE txm_id_emp = " . $id_emp;
        $resultado = $this->db->query($query);
        return $resultado->result_array();
    }

    public function editar_doc_empleado($id_emp)
    {
        $query = "SELECT * FROM dce_documento_emp
        INNER JOIN tde_tipo_documento ON tde_id = dce_id_tde
        WHERE dce_id_emp = " . $id_emp;
        $resultado = $this->db->query($query);
        return $resultado->result_array();
    }

    function get_afp()
    {
        $afp = $this->db->select()
            ->from('afp_afp')
            ->get();
        return $afp->result_array();
    }

    function get_documentos()
    {
        $tipo_documento = $this->db->select()
            ->from('tde_tipo_documento')
            ->get();
        return $tipo_documento->result_array();
    }

    function get_sucursal()
    {
        $sucursal = $this->db->select()
            ->from('suc_sucursal')
            ->get();
        return $sucursal->result_array();
    }

    function get_puesto()
    {
        $puesto = $this->db->select()
            ->from('pto_puesto')
            ->get();
        return $puesto->result_array();
    }

    function get_tipo_puesto()
    {
        $tipo_puesto = $this->db->select()
            ->from('tpt_tipo_puesto')
            ->get();
        return $tipo_puesto->result_array();
    }

    function get_tipo_contrato()
    {
        $puesto = $this->db->select()
            ->from('tpl_tipo_planilla')
            ->get();
        return $puesto->result_array();
    }

    function get_tipotelefono()
    {
        $tipo_telefono = $this->db->select()
            ->from('tit_tipo_telefono')
            ->get();
        return $tipo_telefono->result_array();
    }

    function get_genero()
    {
        $generos = $this->db->select()
            ->from('gen_genero')
            ->get();
        return $generos->result_array();
    }

    function get_profesion()
    {
        $profesion = $this->db->select()
            ->from('pro_profesion')
            ->get();
        return $profesion->result_array();
    }

    function get_nacionalidad()
    {
        $nacionalidad = $this->db->select()
            ->from('pai_pais')
            ->get();
        return $nacionalidad->result_array();
    }

    function get_estado_civil()
    {
        $estado = $this->db->select()
            ->from('esc_estado_civil')
            ->get();
        return $estado->result_array();
    }

    //caja

    /**
     * Utm_model::get_funo_detalle_print()
     *
     * @param int $fun_id
     * @return array de objetos
     */
    function get_funo_detalle_print($fun_id)
    {
        $detalle = array();

        $funo = $this->db->get_where('fun_funo', array('fun_id' => $fun_id), 1)->row();

        if (isset($funo->fun_id) && $funo->fun_id == $fun_id) {


            switch ($funo->fun_tipo) {
                    //Generado
                case 1:

                    $this->db->select('cpr_numero AS numero, cpr_nombre As nombre, SUM(det_monto) As monto');
                    $this->db->from('fxd_funoxdetalle_cntc');
                    $this->db->join('det_detalle_cntc', 'fxd_id_det = det_id', 'left');
                    $this->db->join('cpr_cuenta_presupuesto', 'det_id_cpr = cpr_id', 'left');
                    $this->db->where('fxd_id_fun', $fun_id);
                    $this->db->group_by('cpr_id');
                    $detalle = $this->db->get()->result();
                    //detalle de f1
                    if ($funo->fun_multa > 0) {
                        $detalle[] = (object) array('numero' => '15301', 'nombre' => 'MULTA', 'monto' => $funo->fun_multa);
                    }
                    if ($funo->fun_interes > 0) {
                        $detalle[] = (object) array('numero' => '15302', 'nombre' => 'INTERES', 'monto' => $funo->fun_interes);
                    }
                    if ($funo->fun_impuesto > 0) {
                        $detalle[] = (object) array('numero' => '12114', 'nombre' => 'FIESTAS', 'monto' => $funo->fun_impuesto);
                    }
                    break;
                    //Libre
                case 2:
                case 3:
                    $this->db->select('cpr_numero AS numero, cpr_nombre As nombre, fud_monto As monto');
                    $this->db->from('fud_funo_deta_libre');
                    $this->db->join('cpr_cuenta_presupuesto', 'fud_id_cpr = cpr_id', 'left');
                    $this->db->where('fud_id_fun', $fun_id);
                    $detalle = $this->db->get()->result();
                    break;
                    //Especie
                case 3:

                    break;
            }
        }
        #print_r($this->db->last_query()); exit;
        return $detalle;
    }

    // Reporteria

    function getSaldoAFecha($cub_id, $fecha)
    {

        $saldoInicial = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_saldo_inicial', array('cub_id' => $cub_id));

        $saldo = $this->db
            ->select('SUM(tra_monto) as valor')
            ->from('tra_transaccion')
            ->where('tra_id_cub', $cub_id)
            ->where('DATE(tra_fecha) <', $fecha)
            //->where('tra_hecho <>', -1)
            ->get()
            ->row();

        return (count($saldo) == 1) ? $saldoInicial + $saldo->valor : 0;
    }

    function obtener_proceso($caja, $usuario = null)
    {
        $tipo = $this->gsatelite->get_campo('cxu_cajaxusuario', 'cxu_tipo', array('cxu_id_caj' => $caja, 'cxu_fecha_proceso' => date('Y-m-d')));

        $reaperturar = 0;
        foreach ($tipo as $valor) {
            if ($valor->cxu_tipo = 2) {
                $reaperturar = 1;
            }
        }
        if ($reaperturar == 1) {




            if ($usuario != null) {
                $this->db->where('cxu_id_usu', $usuario);
            }
            $this->db->select('');
            $this->db->from('cxu_cajaxusuario');
            $this->db->where('cxu_id_caj', $caja);
            //$this->db->where('(cxu_fecha)',date("Y-m-d"));
            $this->db->where('cxu_fecha_proceso', date("Y-m-d"));
            $resultados = $this->db->get();
        } else {


            $this->db->select('');
            $this->db->from('cxu_cajaxusuario');
            $this->db->where('cxu_id_caj', $caja);
            //$this->db->where('(cxu_fecha)',date("Y-m-d"));
            $this->db->where('cxu_fecha_proceso', date("Y-m-d"));
            $resultados = $this->db->get();
        }




        /*  print_r($this->db->last_query());exit; */
        return $resultados->result_array();
    }

    /**
     * @author Boris Estrada
     * @param
     */
    function secuencia($caja, $usuario = null)
    {
        $consulta = $this->db->query('SELECT max(cxu_sec) as secuencia FROM cxu_cajaxusuario WHERE cxu_id_usu="' . $usuario . '" AND cxu_id_caj=' . $caja . ' AND cxu_fecha_proceso="' . date('Y-m-d') . '" AND cxu_estado=1');
        #$consulta=$this->db->query('SELECT max(cxu_sec) as secuencia FROM cxu_cajaxusuario WHERE cxu_id_usu="'.$usuario.'" AND cxu_id_caj='.$caja.' AND cxu_fecha_proceso="'.date('Y-m-d').'"');
        return $consulta->result_array();
    }

    /**
     *
     */
    public function caja($usuario)
    {
        $consulta = $this->db->select('caj_id')
            ->from('cxu_cajaxusuario')
            ->join('caj_caja', 'caj_id=cxu_id_caj')
            ->where('cxu_estado', 1)
            ->where('caj_estado', 1)
            ->where('cxu_fecha_proceso', date('Y-m-d'))
            ->where('cxu_tipo', 1)
            ->where('cxu_id_usu', $usuario)->get();
        $caja = $consulta->row();
        return $caja->caj_id;
    }

    function get_cuenta($where = null)
    {
        // $query = 'SELECT
        //         chq_id,chq_numero,ban_id,ban_nombre,cub_numero,cub_nombre,
        //         (chq_cantidad - (SELECT  count(*) FROM che_cheque WHERE che_id_chq=chq_id) )
        //         disponibles
        //         FROM
        //         chq_chequera
        //         INNER JOIN cub_cuenta_bancaria ON
        //         cub_id=chq_id_cub
        //         INNER JOIN ban_banco
        //         ON ban_id=cub_id_ban
        //         WHERE chq_estado = 1
        //         AND ban_id=' . $id_ban;

        $this->db->select('chq_id,chq_numero,ban_id,ban_nombre,cub_numero,cub_nombre,
                (chq_cantidad - (SELECT  count(*) FROM che_cheque WHERE che_id_chq=chq_id) )
                disponibles', false)
            ->from('chq_chequera')
            ->join('cub_cuenta_bancaria', 'cub_id=chq_id_cub')
            ->join('ban_banco', 'ban_id=cub_id_ban');

        if ($where != null) {
            $this->db->where($where);
        }

        //$this->db->join('cub_cuenta_bancaria', 'cub_id=chq_id_cub');
        $query = $this->db->get();
        return $query->result_array();
        // $cuentas = $this->db->query($query)->result_array();
        // return $cuentas;
    }

    function get_disponible($cod = 0)
    {
        $query = 'SELECT
                chq_id,chq_numero,ban_id,ban_nombre,cub_numero,
                (chq_cantidad -(SELECT  count(*) FROM che_cheque WHERE che_id_chq=chq_id))
                disponibles
                FROM
                chq_chequera
                INNER JOIN cub_cuenta_bancaria ON
                cub_id=chq_id_cub
                INNER JOIN ban_banco
                ON ban_id=cub_id_ban
                WHERE chq_id=' . $cod;

        $cuentas = $this->db->query($query)->result_array();
        return $cuentas;
    }

    function get_banco()
    {
        $query = 'SELECT
                    chq_numero,ban_nombre,ban_id,chq_id
                FROM
                    chq_chequera
                    INNER JOIN cub_cuenta_bancaria ON
                    cub_id=chq_id_cub
                    INNER JOIN ban_banco
                    ON ban_id=cub_id_ban
                    WHERE ban_estado = 1
                GROUP BY ban_nombre ';
        $banco = $this->db->query($query)->result_array();
        return $banco;
    }

    function get_numero_che($cod)
    {
        $query = "SELECT MAX(CAST(che_numero AS UNSIGNED)) AS numero FROM che_cheque WHERE che_id_chq = " . $cod;
        $query .= "  ORDER BY che_id DESC limit 1";
        $numero = $this->db->query($query)->row();
        return $numero;
    }

    function get_prefijo($cod)
    {
        $query = 'SELECT * FROM chq_chequera AS chq

                 INNER JOIN `cub_cuenta_bancaria` cub ON cub.`cub_id` = chq.`chq_id_cub`
                     INNER JOIN ban_banco ban ON ban.`ban_id` = cub.`cub_id_ban`
                    WHERE chq.`chq_id`=' . $cod;
        $info_prefijo_sufijo = $this->db->query($query)->row();
        return $info_prefijo_sufijo;
    }

    function get_orden_compra($where = null)
    {
        $db2 = $this->load->database('conexion_mun', true);

        $where1 = array('orc_estado' => 1, 'pag_estado' => 1);
        if ($where) {
            $where1 = array_merge($where1, $where);
        }
        $q_orden = $db2->select()->from('orc_orden_compra')
            ->join('prp_proceso_compra', 'prp_id=orc_id_prp', 'left')
            ->join('req_requisicion', 'req_id=prp_id_req', 'left')
            ->join('pag_pago', 'pag_id_orc=orc_id')
            ->join('prv_proveedor', 'prv_id=orc_id_prv')
            ->join('ace_actividad_economica', 'ace_id=prv_id_ace')
            ->where($where1)
            ->get()->result_array();

        return $q_orden;
    }

    function update_estado_pago($id_pago = 0)
    { //actualizar a estado pagado los pagos
        $db2 = $this->load->database('conexion_mun', true);
        $db2->query("UPDATE pag_pago SET pag_estado=0  WHERE pag_id=$id_pago");
    }

    public function rango_num_cheq($id_chequera)
    {
        $this->db->select('chq_numero_inicio, chq_cantidad')
            ->from('chq_chequera')
            ->where('chq_id', $id_chequera);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function num_usados_chequera($id_chequera)
    {
        $this->db->select('che_numero')
            ->from('che_cheque')
            ->where('che_id_chq', $id_chequera);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_factura_like($like = null, $where = null, $groupby = null, $facturas_emitidas = null)
    {
        // $this->db->select("*, (dpv_monto_pendiente - SUM(agp_apagar)) as pendiente,"
        //         . "(SELECT COUNT(chp_id) FROM chp_cheque_pendiente WHERE "
        //         . " chp_id_dpv = dpv_id and chp_generado = 0) as cheques_pendientes", FALSE);
        // $this->db->from('dpv_documento_proveedor');
        // $this->db->join('tif_tipo_factura', 'tif_id = dpv_id_tif');
        // $this->db->join('agp_agenda_pago', 'agp_id_dpv = dpv_id', 'left');

        $this->db->select("*, (dpv_monto_pendiente - SUM(agp_apagar)) as pendiente,"
            . "(SELECT COUNT(chp_id) FROM chp_cheque_pendiente WHERE "
            . " chp_id_dpv = dpv_id and chp_generado = 0 and chp_estado = 1) as cheques_pendientes", FALSE);
        $this->db->from('dpv_documento_proveedor');
        $this->db->join('tif_tipo_factura', 'tif_id = dpv_id_tif');
        $this->db->join('agp_agenda_pago', 'agp_id_dpv = dpv_id', 'left');

        //$this->db->limit(500);

        if ($like != null) {
            $this->db->like('dpv_numero_documento', $like);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        if ($facturas_emitidas != null) {
            $array_dpv = array(0);
            for ($i = 0; $i < count($facturas_emitidas); $i++) {
                if ($facturas_emitidas[$i]['chp_id_dpv'] > 0) $array_dpv[] = $facturas_emitidas[$i]['chp_id_dpv'];
                //$this->db->where("dpv_id !=", $facturas_emitidas[$i]['chp_id_dpv']);
            }
            $this->db->where("dpv_id not in (" . implode(',', $array_dpv) . ")", null, false);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_cheques_pendientes($where = null)
    {

        $query = $this->db->select()
            ->from('chp_cheque_pendiente')
            ->join('emp_empleado', 'emp_id = chp_id_emp', 'left')
            ->join('pla_planilla', 'pla_id = chp_id_pla', 'left')
            ->join('dpv_documento_proveedor', 'dpv_id = chp_id_dpv', 'left')
            ->join('agp_agenda_pago', 'agp_id = chp_id_agp', 'left');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_cheques_emitidos($where = null, $order_by = null)
    {

        $query = $this->db->select()
            ->from('che_cheque')
            ->join('chq_chequera', 'chq_id = che_id_chq', 'inner')
            ->join('cub_cuenta_bancaria', 'chq_id_cub = cub_id', 'inner')
            ->join('ban_banco', 'ban_id = cub_id_ban', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }
    /**
     * @author Manuel Anzora
     * @since 2018-12-06
     * @return reporte consolidado de conciliacion bancaria
     */
    public function get_conciliaciones_bancarias($where = null, $order_by = null)
    {
        /**
        SELECT tra_id, cub_id, tra_fecha, tra_comprobante, tra_operacion, tra_monto,
        (        
    SELECT
    (IF(SUM( tra_monto ) >0, SUM( tra_monto ), 0) + cub_saldo_inicial) saldo
    FROM cub_cuenta_bancaria
    LEFT JOIN tra_transaccion ON (cub_id = tra_id_cub AND DATE( tra_fecha ) < '2015-08-01' 
    AND tra_conciliado = 1) WHERE
    cub_id = 14
    GROUP BY
    cub_id  ) as saldo
        FROM tra_transaccion 
        left join che_cheque on che_id_tra = tra_id
        inner join cub_cuenta_bancaria on cub_id = tra_id_cub
        inner join ttb_tipo_transact_bancaria on ttb_id = tra_id_ttb
        where date(tra_fecha) >= '2018-04-01' AND date(tra_fecha) <= '2018-04-30'
        AND tra_conciliado = 1 AND tra_id_cub = 56
         */
        $fecha_final = date('Y-m-d');
        if ($where && isset($where['DATE(tra_fecha) >='])) {
            $fecha_final = $where['DATE(tra_fecha) >='];
        }
        $id_cuenta_banco = 0;
        if ($where && isset($where['cub_id'])) {
            $id_cuenta_banco = $where['cub_id'];
        }
        $query = $this->db->select('
            cub_cuenta_bancaria.*, tra_id, tra_fecha,tra_comprobante,tra_operacion,
            CASE WHEN che_estado = 0 THEN 0.00 ELSE tra_monto END AS tra_monto,
            che_numero, (SELECT 
        (IF(SUM(tra_monto)>0,SUM(tra_monto),0) + cub_saldo_inicial)
        FROM cub_cuenta_bancaria 
        left join tra_transaccion on (cub_id = tra_id_cub AND DATE(tra_fecha) < "' . $fecha_final . '"
        AND tra_conciliado = 1 AND tra_estado = 1)
        where cub_id = ' . $id_cuenta_banco . '
        GROUP BY cub_id) as saldo', false)
            ->from('tra_transaccion')
            ->join('che_cheque', 'che_id_tra = tra_id', 'left')
            ->join('cub_cuenta_bancaria', 'tra_id_cub = cub_id', 'inner')
            ->join('ttb_tipo_transact_bancaria', 'ttb_id = tra_id_ttb', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Manuel Anzora
     * @since 2018-12-06
     * @return saldo de la cuenta bancaria
     */
    public function get_resumen_conciliaciones_bancarias($where = null, $order_by = null)
    {
        /**
           SELECT
            tra_id,
            cub_id,
            IF(ttb_retiro = 1, SUM(tra_monto), SUM(0)) saldo_banco,
            IF(ttb_deposito = 1 OR ttb_transferencia = 1 AND tra_aplicar = 1, SUM(tra_monto),SUM(0)) saldo_empresa,
            ttb_nombre
        FROM
            (tra_transaccion)
            LEFT JOIN che_cheque ON che_id_tra = tra_id
            INNER JOIN cub_cuenta_bancaria ON tra_id_cub = cub_id
            INNER JOIN ttb_tipo_transact_bancaria ON ttb_id = tra_id_ttb 
        WHERE
            cub_id = 3 
            AND DATE( tra_fecha ) >= '2015-07-01' 
            AND DATE( tra_fecha ) <= '2015-07-31' 
            AND tra_conciliado = 1
            GROUP BY ttb_id
         */

        $query = $this->db->select('tra_id,
    cub_id,
    IF(ttb_deposito = 1, SUM(tra_monto), SUM(0)) saldo_banco,
    IF(ttb_deposito = 1 OR ttb_retiro = 1 OR  ttb_transferencia = 1, SUM(tra_monto),SUM(0)) saldo_empresa,
    ttb_nombre', false)
            ->from('tra_transaccion')
            ->join('che_cheque', 'che_id_tra = tra_id', 'left')
            ->join('cub_cuenta_bancaria', 'tra_id_cub = cub_id', 'inner')
            ->join('ttb_tipo_transact_bancaria', 'ttb_id = tra_id_ttb', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }


        $this->db->order_by('ttb_nombre');
        $this->db->group_by('ttb_id');

        return $query->get()->result_array();
    }
    /**
     * @author Manuel Anzora
     * @since 2018-12-07
     * @return reporte consolidado de conciliacion bancaria
     * $flag = 1 si se accede desde ajax
     */
    public function get_saldos_resumen_consolidacion($condition = null)
    {
        /**
            SELECT 
                tra_monto, tra_aplicar, ttb_retiro, ttb_deposito, ttb_transferencia, cub_saldo_inicial
            FROM cub_cuenta_bancaria
            LEFT JOIN tra_transaccion ON (tra_id_cub = cub_id)
            INNER JOIN ttb_tipo_transact_bancaria ON ttb_id = tra_id_ttb
            WHERE cub_id = 61 AND DATE(tra_fecha) < "2018-12-31" AND tra_conciliado = 1
         **/
        $query = $this->db->select('tra_monto, tra_aplicar, ttb_retiro, ttb_deposito, ttb_transferencia, cub_saldo_inicial', false)
            ->from('cub_cuenta_bancaria')
            ->join('tra_transaccion', 'tra_id_cub = cub_id  AND DATE( tra_fecha ) < "' . $condition['fecha'] . '" AND tra_conciliado = 1', 'left')
            ->join('ttb_tipo_transact_bancaria', 'ttb_id = tra_id_ttb', 'inner');


        $query = $this->db->where('cub_id = ' . $condition['cub_id']);
        return $query->get()->result_array();
    }

    public function get_retencion_cheques($where = null, $order_by = null)
    {
        $nit = $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NIT_PROVEEDOR', 2);
        $query = $this->db->select("*,(SELECT ban_nombre FROM tra_transaccion left join cub_cuenta_bancaria on tra_id_cub = cub_id left join ban_banco on cub_id_ban = ban_id where che_id_tra = tra_id) as banco")
            ->from("che_cheque")
            ->join("dch_detalle_cheque", "dch_id_che = che_id", "inner")
            ->join("prv_proveedor", "prv_id = che_id_prv", "left")
            ->join("dpv_documento_proveedor", "dch_id_dpv = dpv_id", "left")
            ->join("dcp_documento_proveedor", "dcp_id_prv = prv_id AND dcp_id_tde = $nit", "left");

        if ($where != null) {
            $this->db->where($where);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_libro_bancos($where = null, $order_by = null)
    {
        $query = $this->db->select('*, CASE
                WHEN che_id_pct IS NOT NULL THEN 
                    IFNULL((SELECT pct_codigo FROM pct_partida_contable WHERE pct_id = che_id_pct),"")
                WHEN nta_id_pct IS NOT NULL THEN 
                    IFNULL((SELECT pct_codigo FROM pct_partida_contable WHERE pct_id = nta_id_pct),"")
                WHEN abc_id_pct IS NOT NULL THEN
                    IFNULL((SELECT pct_codigo FROM pct_partida_contable WHERE pct_id = abc_id_pct),"")
                ELSE 
                    IFNULL((SELECT pct_codigo FROM pct_partida_contable WHERE pct_id = tra_id_pct),"")
                END AS partida', FALSE)
            ->from('tra_transaccion')
            ->join('che_cheque', 'che_id_tra = tra_id AND che_estado > 0', 'left')
            ->join('nta_nota_abono', 'nta_id_tra = tra_id AND nta_estado > 0', 'left')
            ->join('dab_detalle_abono', 'dab_id_tra = tra_id AND dab_estado > 0', 'left')
            ->join('abc_abono_cliente', 'dab_id_abc = abc_id AND abc_estado > 0', 'left')
            ->join('cub_cuenta_bancaria', 'tra_id_cub = cub_id AND cub_estado > 0', 'inner')
            ->join('ttb_tipo_transact_bancaria', 'ttb_id = tra_id_ttb AND ttb_estado > 0', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_cheque($where = null)
    {
        $query = $this->db->select('*, group_concat(rdc_porcentaje) as porcentajes, group_concat(rdc_id_ret) as retenciones')
            ->from('dch_detalle_cheque')
            ->join('rdc_retencion_detalle_cheque', 'rdc_id_dch = dch_id', 'left')
            ->join('dpv_documento_proveedor', 'dpv_id = dch_id_dpv', 'left')
            ->join('tif_tipo_factura', 'tif_id = dpv_id_tif', 'left')
            ->join('cnt_cuenta_contable', 'cnt_id=dch_id_cnt', 'left')
            ->group_by('dch_id');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_conciliaciones($where = null)
    {

        $query = $this->db->select()
            ->from('tra_transaccion')
            ->join('ttb_tipo_transact_bancaria', 'tra_id_ttb = ttb_id', 'left')
            ->join('che_cheque', 'tra_id = che_id_tra', 'left')
            ->join('nta_nota_abono', 'nta_id_tra = tra_id', 'left')
            ->join('vw_cuentas_bancarias', 'tra_id_cub = cub_id', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_notas_abono_pendientes($where = null)
    {

        $query = $this->db->select()
            ->from('ntp_nota_abono_pendiente')
            ->join('dpv_documento_proveedor', 'dpv_id = ntp_id_dpv', 'left')
            ->join('agp_agenda_pago', 'agp_id = ntp_id_agp', 'left');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_notas_abono($where = null)
    {
        $query = $this->db->select("*,
            (SELECT SUM(dna_retencion_calculada) FROM dna_detalle_nota_abono WHERE dna_id_nta = nta_id)as monto_retenido
            ", false)
            ->from('nta_nota_abono')
            ->join('cub_cuenta_bancaria', 'nta_id_cub = cub_id', 'inner')
            ->join('tra_transaccion', 'nta_id_tra = tra_id', 'inner')
            ->join('ttb_tipo_transact_bancaria', 'ttb_id = tra_id_ttb', 'inner');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_cuentas_like($where = null, $like = null)
    {
        $this->db->select("*,CONCAT_WS(' ',cnt_cuenta,' - ',cnt_nombre) as cuenta_contable", false);
        $this->db->from('cnt_cuenta_contable');

        if ($like != null) {
            $this->db->like($like);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    /*
     * @author: Mario Marquez
     * @since: 2017-07=28
     * @return Detalle de una nota de abono
     */

    public function get_detalle_nota_abono($where = null, $select = "*", $group_by = null)
    {
        $query = $this->db->select($select, false)
            ->from('dna_detalle_nota_abono')
            ->join('cnt_cuenta_contable', 'cnt_id = dna_id_cnt', 'left')
            ->join('dpv_documento_proveedor', 'dpv_id  = dna_id_dpv', 'left')
            ->join('tif_tipo_factura', 'tif_id = dpv_id_tif', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }

        return $query->get()->result_array();
    }

    public function get_info_cheque($id_cheque)
    {
        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $tcn_id     = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CUENTA_POR_PAGAR'));
        $query = $this->db->select("
                che_id,
                che_numero,
                che_concepto,
                che_orden,
                che_fecha,
                che_monto,
                (
                    SELECT cnt_id FROM cxb_cuentaxcuenta_bancaria
                    JOIN cnt_cuenta_contable ON cnt_id = cxb_id_cnt
                    WHERE cxb_id_cub = cub_id AND cxb_id_tcn = " . $tcn_id . "
                ) as cnt_id,
                (
                    SELECT cnt_cuenta FROM cxb_cuentaxcuenta_bancaria
                    JOIN cnt_cuenta_contable ON cnt_id = cxb_id_cnt
                    WHERE cxb_id_cub = cub_id AND cxb_id_tcn = " . $tcn_id . "
                ) as cnt_cuenta,
                (
                    SELECT cnt_nombre FROM cxb_cuentaxcuenta_bancaria
                    JOIN cnt_cuenta_contable ON cnt_id = cxb_id_cnt
                    WHERE cxb_id_cub = cub_id AND cxb_id_tcn = " . $tcn_id . "
                ) as cnt_nombre,
                che_id_tra,
                dch_id_cnt,
                dch_id,
                SUM(dch_subtotal) AS subtotal,
                SUM(dch_valor) AS valor,
                IFNULL(dch_id_cnt, '$cuenta_defecto') AS id_cuenta_contable,
                dch_concepto
                ", false)
            ->from('che_cheque')
            ->join('chq_chequera', 'chq_id =che_id_chq')
            ->join('cub_cuenta_bancaria', 'chq_id_cub = cub_id')
            ->join('dch_detalle_cheque', 'dch_id_che = che_id');
        if ($id_cheque != null) {
            $this->db->where('che_id', $id_cheque);
        }
        $this->db->group_by('dch_id');

        return $query->get()->result_array();
    }

    public function get_retenciones_detalle_nota($where = null, $select = "*")
    {
        $query = $this->db->select($select)
            ->from('rdn_retencion_detalle_nota')
            ->join('ret_retencion', 'ret_id = rdn_id_ret', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_retenciones_cheque($id_cheque)
    {
        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $query = $this->db->select(" SUM(rdc_monto) as retencion, IFNULL(dcr_id_cnt,'$cuenta_defecto') AS cuenta, cnt_nombre, ret_nombre", false)
            ->from('che_cheque')
            ->join('dch_detalle_cheque', 'dch_id_che = che_id')
            ->join('rdc_retencion_detalle_cheque', 'rdc_id_dch =dch_id')
            ->join('ret_retencion', 'ret_id = rdc_id_ret')
            ->join('dcr_detalle_cuenta_retencion', 'dcr_id_ret=ret_id', 'left')
            ->join('cnt_cuenta_contable', 'dcr_id_cnt = cnt_id', 'left');
        if ($id_cheque != null) {
            $this->db->where('che_id', $id_cheque);
        }
        $this->db->group_by('rdc_id_ret');

        return $query->get()->result_array();
    }

    public function get_prov_che_con($where)
    {
        $query = $this->db->select('prv_id, prv_nombre, prv_apellido, prv_tipo_pers')
            ->distinct('prv_id')
            ->from('prv_proveedor')
            ->join('dpv_documento_proveedor', 'prv_id = dpv_id_prv')
            ->where($where);
        return $query->get()->result_array();
    }

    public function get_cheque_pendiente_proveedor($where)
    {

        $query = $this->db->select()
            ->from('chp_cheque_pendiente')
            ->join('emp_empleado', 'emp_id = chp_id_emp', 'left')
            ->join('pla_planilla', 'pla_id = chp_id_pla', 'left')
            ->join('dpv_documento_proveedor', 'dpv_id = chp_id_dpv', 'left')
            ->join('agp_agenda_pago', 'agp_id = chp_id_agp', 'left');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_documento_proyecto_detalle($where = null)
    {
        /*
            SELECT
                che_id,
                ban_nombre,
                CONCAT(chq_numero, '-', cub_numero) chequera,
                che_numero,
                che_fecha,
                CONCAT(
                    pcl_codigo,
                    ' - ',
                    pcl_nombre
                ) proyecto,
                CONCAT(
                    tif_abreviacion,
                    '-',
                    dpv_numero_documento
                ) Ndocumento,
                che_orden,
                che_concepto,
                che_monto
            FROM
                che_cheque
            INNER JOIN chq_chequera ON chq_id = che_id_chq
            INNER JOIN cub_cuenta_bancaria ON cub_id = chq_id_cub
            INNER JOIN ban_banco ON ban_id = cub_id_ban
            INNER JOIN dch_detalle_cheque ON dch_id_che = che_id
            INNER JOIN dpv_documento_proveedor ON dpv_id = dch_id_dpv
            INNER JOIN pcl_proyecto_cliente ON pcl_id = dpv_id_pcl
            INNER JOIN tif_tipo_factura ON tif_id = dpv_id_tif
        */
        $query = $this->db->select("
            che_id,
            ban_nombre,
            CONCAT(chq_numero, '-', cub_numero) chequera,
            che_numero,
            che_fecha,
            CONCAT(
                pcl_codigo,
                ' - ',
                pcl_nombre
            ) proyecto,
            CONCAT(
                tif_abreviacion,
                '-',
                dpv_numero_documento
            ) Ndocumento,
            che_orden,
            che_concepto,
            (SUM(dch_subtotal) + SUM(dch_retencion_calculada)) total", false)
            ->from('che_cheque')
            ->join('chq_chequera', 'chq_id = che_id_chq', 'inner')
            ->join('cub_cuenta_bancaria', 'cub_id = chq_id_cub', 'inner')
            ->join('ban_banco', 'ban_id = cub_id_ban', 'inner')
            ->join('dch_detalle_cheque', 'dch_id_che = che_id', 'inner')
            ->join('dpv_documento_proveedor', 'dpv_id = dch_id_dpv', 'inner')
            ->join('pcl_proyecto_cliente', 'pcl_id = dpv_id_pcl', 'inner')
            ->join('tif_tipo_factura', 'tif_id = dpv_id_tif', 'inner')
            ->group_by('che_id');;
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since 26/03/2018
     * @return: Array con los datos de las cuentas bancarias
     */
    public function get_cuentas_bancarias($where = null, $orderby = null)
    {
        $query = $this->db->select()
            ->from('cub_cuenta_bancaria')
            ->join('ban_banco', 'ban_id = cub_id_ban', 'left')
            ->join('orf_origen_fondos', 'orf_id = cub_id_orf', 'left')
            ->join('tpc_tipo_cuenta', 'tpc_id = cub_id_tpc', 'left');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        return $query->get()->result_array();
    }

    /**
     * @author: Luis Navarro
     * @since 26/03/2018
     * @descripcion: Se obtienen las cuentas contables relacionadas a una cuenta bancaria
     * @return: Array con los datos de la cuenta
     */
    public function get_cuentas_x_cuentas_bancarias($where = null, $orderby = null)
    {
        $query = $this->db->select()
            ->from('cxb_cuentaxcuenta_bancaria')
            ->join('cnt_cuenta_contable', 'cxb_id_cnt = cnt_id')
            ->join('cec_centro_costo', 'cxb_id_cec = cec_id')
            ->join('tcn_tipo_cuenta', 'cxb_id_tcn = tcn_id');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }

    /**
     * @author: Luis Navarro
     * @since 26/03/2018
     * @descripcion: Se obtienen los proveedores con sus respectivas cuentas contables para partida de cheques
     * @return: Array con los datos de la cuenta
     */
    public function get_cuentas_x_proveedores_cheque($where = null, $groupby = null, $orderby = null)
    {
        // Tipo de Cuenta parametrizada
        $tcn_id     = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CUENTA_POR_PAGAR'));
        $tcn_cch_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('FONDOS_CAJA_CHICA'));
        $consultar  = $this->gsatelite->get_tabla('tcn_tipo_cuenta', array('tcn_id' => $tcn_id, 'tcn_estado' => 1));
        $cch_cnsult = $this->gsatelite->get_tabla('tcn_tipo_cuenta', array('tcn_id' => $tcn_cch_id, 'tcn_estado' => 1));
        $tcn_id     = (count($consultar) > 0) ? $tcn_id : 0;
        $tcn_cch_id = (count($cch_cnsult) > 0) ? $tcn_cch_id : 0;
        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $reg_cntdef = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $cuenta_defecto));
        $reg_cntdef = ($reg_cntdef) ? $reg_cntdef[0] : array();

        $query = $this->db->select('
            che_id,
            che_id_cch,
            SUM(dch_subtotal) as che_monto,
            GROUP_CONCAT(che_id) as cheques,
            che_concepto,
            che_numero,
            IF(che_id_cch IS NULL,
                (IFNULL(
                    (SELECT cnt_id FROM dfp_detalle_finanza_proveedor JOIN cnt_cuenta_contable ON cnt_id = dfp_id_cnt
                        WHERE dfp_id_prv = prv_id AND dfp_id_tcn = ' . $tcn_id . ' and IFNULL(dpv_id_tpg, 1) = IFNULL(dfp_id_tpg, 1) LIMIT 1), 
                    ' . $reg_cntdef['cnt_id'] . ')
                ), 
                (IFNULL(
                    (SELECT cnt_id FROM cnj_cuenta_caja_chica JOIN cnt_cuenta_contable ON cnt_id = cnj_id_cnt 
                        WHERE cnj_id_cch = che_id_cch AND cnj_tipo_proceso = 2 AND cnj_id_tcn = ' . $tcn_cch_id . ' LIMIT 1),
                    ' . $reg_cntdef['cnt_id'] . ')
                )
            ) AS cnt_id,
            IF(che_id_cch IS NULL,
                (IFNULL(
                    (SELECT cnt_cuenta FROM dfp_detalle_finanza_proveedor JOIN cnt_cuenta_contable ON cnt_id = dfp_id_cnt
                        WHERE dfp_id_prv = prv_id AND dfp_id_tcn = ' . $tcn_id . ' and IFNULL(dpv_id_tpg,1) = IFNULL(dfp_id_tpg,1) LIMIT 1),
                    "' . $reg_cntdef['cnt_cuenta'] . '")
                ),
                (IFNULL(
                    (SELECT cnt_cuenta FROM cnj_cuenta_caja_chica JOIN cnt_cuenta_contable ON cnt_id = cnj_id_cnt 
                        WHERE cnj_id_cch = che_id_cch AND cnj_tipo_proceso = 2 AND cnj_id_tcn = ' . $tcn_cch_id . ' LIMIT 1),
                    "' . $reg_cntdef['cnt_cuenta'] . '")
                )
            ) AS cnt_cuenta,
            IF(che_id_cch IS NULL,
                (IFNULL(
                    (SELECT cnt_nombre FROM dfp_detalle_finanza_proveedor JOIN cnt_cuenta_contable ON cnt_id = dfp_id_cnt
                        WHERE dfp_id_prv = prv_id AND dfp_id_tcn = ' . $tcn_id . ' and IFNULL(dpv_id_tpg,1) = IFNULL(dfp_id_tpg,1) LIMIT 1),
                    "' . $reg_cntdef['cnt_nombre'] . '")
                ),
                (IFNULL(
                    (SELECT cnt_nombre FROM cnj_cuenta_caja_chica JOIN cnt_cuenta_contable ON cnt_id = cnj_id_cnt 
                        WHERE cnj_id_cch = che_id_cch AND cnj_tipo_proceso = 2 AND cnj_id_tcn = ' . $tcn_cch_id . ' LIMIT 1),
                    "' . $reg_cntdef['cnt_nombre'] . '")
                )
            ) AS cnt_nombre
            ', false)
            ->from('che_cheque')
            ->join('dch_detalle_cheque', 'dch_id_che = che_id')
            ->join('dpv_documento_proveedor', 'dpv_id = dch_id_dpv', 'left')
            ->join('prv_proveedor', 'che_id_prv = prv_id', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        $datos_q = $query->get()->result_array();
        return $datos_q;
    }
    /**
     * @author: Luis Navarro
     * @since 26/03/2018
     * @descripcion: Se obtienen los Bancos con sus respectivas cuentas contables para partida de cheques
     * @return: Array con los datos de la cuenta
     */
    public function get_cuentas_x_bancos_cheque($where = null, $groupby = null, $orderby = null)
    {
        // Tipo de Cuenta parametrizada
        $tcn_id         = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('BANCOS'));
        $consultar      = $this->gsatelite->get_tabla('tcn_tipo_cuenta', array('tcn_id' => $tcn_id, 'tcn_estado' => 1));
        $tcn_id         = (count($consultar) > 0) ? $tcn_id : 0;

        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $reg_cntdef     = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $cuenta_defecto));
        $reg_cntdef     = ($reg_cntdef) ? $reg_cntdef[0] : array();

        $query = $this->db->select(
            '
                che_id,
                /*SUM(IF(che_id_prv>0,che_monto,0)) as che_monto,*/
                SUM((dch_subtotal /* + IFNULL(dch_retencion_calculada,0) */)) as che_monto,
                GROUP_CONCAT(che_id) as cheques,
                che_concepto,
                che_numero,
                che_fecha,
                IFNULL((
                    SELECT cnt_id FROM cxb_cuentaxcuenta_bancaria
                    JOIN cnt_cuenta_contable ON cnt_id = cxb_id_cnt
                    WHERE cxb_id_cub = cub_id AND cxb_id_tcn = ' . $tcn_id . ' 
                    LIMIT 1
                ),' . $reg_cntdef['cnt_id'] . ') AS cnt_id,
                IFNULL((
                    SELECT cnt_cuenta FROM cxb_cuentaxcuenta_bancaria
                    JOIN cnt_cuenta_contable ON cnt_id = cxb_id_cnt
                    WHERE cxb_id_cub = cub_id AND cxb_id_tcn = ' . $tcn_id . ' 
                    LIMIT 1
                ), "' . $reg_cntdef['cnt_cuenta'] . '") AS cnt_cuenta,
                IFNULL((
                    SELECT cnt_nombre FROM cxb_cuentaxcuenta_bancaria
                    JOIN cnt_cuenta_contable ON cnt_id = cxb_id_cnt
                    WHERE cxb_id_cub = cub_id AND cxb_id_tcn = ' . $tcn_id . '
                    LIMIT 1
                ), "' . $reg_cntdef['cnt_nombre'] . '") AS cnt_nombre
                ',
            false
        )
            ->from('che_cheque')
            ->join('dch_detalle_cheque', 'dch_id_che = che_id')
            ->join('chq_chequera', 'che_id_chq = chq_id')
            ->join('cub_cuenta_bancaria', 'chq_id_cub = cub_id');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        return $query->get()->result_array();
    }

    function get_cuentas_bancarias_rpt($where = null)
    {
        /*
            SELECT
                cub_id,
                concat(ban_nombre, ': ', cub_numero) AS cuenta,
                cub_nombre nombre,
                IF (
                    (count(tra_monto) > 0),
                    (
                        cub_saldo_inicial + sum(tra_monto)
                    ),
                    cub_saldo_inicial
                ) saldo,
                cub_saldo_inicial
            FROM
                cub_cuenta_bancaria
            LEFT JOIN tra_transaccion ON tra_id_cub = cub_id AND tra_aplicar = 1
            LEFT JOIN ban_banco ON ban_id = cub_id_ban
            GROUP BY
                cub_id
            ORDER BY
                cub_id
        */
        $this->db->select("cub_id,
                concat(ban_nombre, ': ', cub_numero) AS cuenta,
                ban_nombre banco,
                cub_nombre nombre,
                cub_numero numero,
                concat('',IF (
                    (count(tra_monto) > 0),
                    (
                        cub_saldo_inicial + sum(tra_monto)
                    ),
                    cub_saldo_inicial
                )) saldo,
                concat('',cub_saldo_inicial) 'saldo_inicial'", false)
            ->from('cub_cuenta_bancaria')
            ->join('tra_transaccion', 'tra_id_cub = cub_id AND tra_aplicar = 1', 'LEFT')
            ->join('ban_banco', 'ban_id = cub_id_ban', 'LEFT')
            ->group_by('cub_id')
            ->order_by('cub_id', 'DESC');

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * @Elman Ortiz
     */
    public function get_tipo_cheque_defecto($where = null)
    {
        $query = $this->db->select('*')
            ->from('che_cheque')
            ->join('chq_chequera', 'che_id_chq = chq_id')
            ->join('cub_cuenta_bancaria', 'cub_id = chq_id_cub');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**********************************************************/
    /**
     * @author: Elman Ortiz
     * @since 26/06/2018
     * @descripcion: Se obtienen los proveedores con sus respectivas cuentas contables para partida de notas de abono
     * @return: Array con los datos de la cuenta
     */
    public function get_cuentas_x_proveedores_nota_abono($where = null, $groupby = null, $orderby = null)
    {
        // Tipo de Cuenta parametrizada
        $tcn_id     = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CUENTA_POR_PAGAR'));
        $consultar  = $this->gsatelite->get_tabla('tcn_tipo_cuenta', array('tcn_id' => $tcn_id, 'tcn_estado' => 1));
        $tcn_id     = (count($consultar) > 0) ? $tcn_id : null;

        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $reg_cntdef = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $cuenta_defecto));
        $reg_cntdef = ($reg_cntdef) ? $reg_cntdef[0] : array();

        $query = $this->db->select(
            '
                nta_id AS che_id,
                SUM(dna_subtotal) AS che_monto,
                GROUP_CONCAT(nta_id) AS cheques,
                nta_concepto AS che_concepto,
                nta_codigo AS che_numero,

                IFNULL((
                        SELECT cnt_id
                        FROM dfp_detalle_finanza_proveedor
                        JOIN cnt_cuenta_contable ON cnt_id = dfp_id_cnt
                        WHERE dfp_id_prv = prv_id AND dfp_id_tcn = ' . $tcn_id . '  and IFNULL(dpv_id_tpg,1) = IFNULL(dfp_id_tpg,1)
                        LIMIT 1
                ),' . $reg_cntdef['cnt_id'] . ') as cnt_id,
                IFNULL((
                        SELECT cnt_cuenta
                        FROM dfp_detalle_finanza_proveedor
                        JOIN cnt_cuenta_contable ON cnt_id = dfp_id_cnt
                        WHERE dfp_id_prv = prv_id AND dfp_id_tcn = ' . $tcn_id . '  and IFNULL(dpv_id_tpg,1) = IFNULL(dfp_id_tpg,1)
                        LIMIT 1
                ),"' . $reg_cntdef['cnt_cuenta'] . '") as cnt_cuenta,
                IFNULL((
                        SELECT cnt_nombre
                        FROM dfp_detalle_finanza_proveedor
                        JOIN cnt_cuenta_contable ON cnt_id = dfp_id_cnt
                        WHERE dfp_id_prv = prv_id AND dfp_id_tcn = ' . $tcn_id . ' and IFNULL(dpv_id_tpg,1) = IFNULL(dfp_id_tpg,1)
                        LIMIT 1
                ),"' . $reg_cntdef['cnt_nombre'] . '") as cnt_nombre
            ',
            false
        )
            ->from('nta_nota_abono')
            ->join('dna_detalle_nota_abono', 'dna_id_nta = nta_id', 'LEFT')
            ->join('dpv_documento_proveedor', 'dpv_id = dna_id_dpv', 'LEFT')
            ->join('prv_proveedor', 'prv_id = dpv_id_prv', 'LEFT');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        return $query->get()->result_array();
        //print_r($this->db->last_query());die();
        //return $this->db->last_query();
    }

    /**
     * @author: Elman Ortiz
     * @since 28/03/2018
     * @descripcion: Se obtienen los Bancos con sus respectivas cuentas contables para partida de notas de abono
     * @return: Array con los datos de la cuenta
     */
    public function get_cuentas_x_bancos_nota_abono($where = null, $groupby = null, $orderby = null, $where2)
    {
        // Tipo de Cuenta parametrizada
        $tcn_id         = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('BANCOS'));
        $consultar      = $this->gsatelite->get_tabla('tcn_tipo_cuenta', array('tcn_id' => $tcn_id, 'tcn_estado' => 1));
        $tcn_id         = (count($consultar) > 0) ? $tcn_id : null;

        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $reg_cntdef     = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $cuenta_defecto));
        $reg_cntdef     = ($reg_cntdef) ? $reg_cntdef[0] : array();


        $tcn_id     = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('BANCOS'));
        $consultar  = $this->gsatelite->get_tabla('tcn_tipo_cuenta', array('tcn_id' => $tcn_id, 'tcn_estado' => 1));
        $tcn_id     = (count($consultar) > 0) ? $tcn_id : null;
        $cub_id     = ($where2['cub_id'] != '') ? 'cxb_id_cub = ' . $cub_id . ' AND' : '';
        $query = $this->db->select(
            '
                nta_id AS che_id,
                SUM((dna_subtotal )) as che_monto,
                GROUP_CONCAT(nta_id) as cheques,
                nta_concepto AS che_concepto,
                nta_codigo AS che_numero,
                nta_fecha AS che_fecha,

                IFNULL((
                        SELECT cnt_id FROM cxb_cuentaxcuenta_bancaria
                        JOIN cnt_cuenta_contable ON cnt_id = cxb_id_cnt
                        WHERE cxb_id_cub = cub_id AND cxb_id_tcn = ' . $tcn_id . ' 
                        LIMIT 1
                ),' . $reg_cntdef['cnt_id'] . ') AS cnt_id,
                IFNULL((
                        SELECT cnt_cuenta FROM cxb_cuentaxcuenta_bancaria
                        JOIN cnt_cuenta_contable ON cnt_id = cxb_id_cnt
                        WHERE cxb_id_cub = cub_id AND cxb_id_tcn = ' . $tcn_id . ' 
                        LIMIT 1
                ), "' . $reg_cntdef['cnt_cuenta'] . '") AS cnt_cuenta,
                IFNULL((
                        SELECT cnt_nombre FROM cxb_cuentaxcuenta_bancaria
                        JOIN cnt_cuenta_contable ON cnt_id = cxb_id_cnt
                        WHERE cxb_id_cub = cub_id AND cxb_id_tcn = ' . $tcn_id . '
                        LIMIT 1
                ), "' . $reg_cntdef['cnt_nombre'] . '") AS cnt_nombre
                ',
            false
        )
            ->from('nta_nota_abono')
            //->join('chq_chequera', 'che_id_chq = chq_id')
            ->join('dna_detalle_nota_abono', 'dna_id_nta = nta_id')
            ->join('dpv_documento_proveedor', 'dpv_id = dna_id_dpv')
            ->join('prv_proveedor', 'prv_id = dpv_id_prv')
            ->join('cub_cuenta_bancaria', 'nta_id_cub = cub_id');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        return $query->get()->result_array();
        //print_r($this->db->last_query());die();
        //return $this->db->last_query();
    }

    /**
     * @author Mario Marquez
     * @since 29/08/2018
     * @method Se obtiene la Cuenta contable para el debe al hacer pago de una factura
     */
    public function get_cuenta_contable_transaccion($transaccion_id, $tipo_cuenta)
    {
        // Cuenta contable por defecto
        $defecto_cnt = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
        $defecto_cnt = $defecto_cnt[0]['cnt_id'];
        $defecto_cnt_nombre = $this->gsatelite->get_campo('cnt_cuenta_contable', 'cnt_nombre', array('cnt_id' => $defecto_cnt));

        $query = "
            SELECT 
            a.total_abonar,
            IF(ISNULL(a.cnt_id)," . $defecto_cnt . ",a.cnt_id) AS cnt_id,
            IF(ISNULL(a.cnt_id),'" . $defecto_cnt_nombre . "',a.cnt_nombre) AS cnt_nombre
            FROM
            (
            SELECT
                tra.tra_monto AS total_abonar,
                (
                   SELECT
                        cnt_id
                    FROM cxb_cuentaxcuenta_bancaria
                    JOIN cnt_cuenta_contable ON cxb_id_cnt = cnt_id
                    WHERE 
                    cxb_id_tcn = " . $tipo_cuenta . "
                    AND cxb_id_cub = cub.cub_id
                ) AS cnt_id,
                (
                    SELECT
                        cnt_nombre
                    FROM cxb_cuentaxcuenta_bancaria
                    JOIN cnt_cuenta_contable ON cxb_id_cnt = cnt_id
                    WHERE 
                    cxb_id_tcn = " . $tipo_cuenta . "
                    AND cxb_id_cub = cub.cub_id
                ) AS cnt_nombre
            FROM tra_transaccion tra
            JOIN cub_cuenta_bancaria cub on cub.cub_id = tra.tra_id_cub
            WHERE tra.tra_id = " . $transaccion_id . "
            ) AS a            
        ";
        return $this->db->query($query)->result_array();
    }

    public function get_info_trans($where = null)
    {
        $query =  $this->db->select('tra_fecha, tra_operacion, tra_monto, cub_nombre, cub_numero, ban_nombre, tra_comprobante,
          cub_saldo_inicial,ttb_nombre,cub_saldo,tra_id_cub,tra_id')
            ->from('tra_transaccion')
            ->join('cub_cuenta_bancaria', 'cub_id = tra_id_cub')
            ->join('ban_banco', 'ban_id = cub_id_ban')
            ->join('ttb_tipo_transact_bancaria', 'ttb_id = tra_id_ttb');

        if ($where != null) {
            $this->db->where($where);
        }
        $res =  $query->get()->row_array();

        $cuenta = $res['tra_id_cub'];
        $tra_id = $res['tra_id'];

        $query = $this->db->select('saldo, tra_monto, cub_saldo_inicial, SUM(tra_monto) as suma')
            ->from('vw_cuentas_bancarias')
            ->join('tra_transaccion', 'vw_cuentas_bancarias.cub_id=tra_transaccion.tra_id_cub')
            ->join('cub_cuenta_bancaria', 'tra_id_cub=cub_cuenta_bancaria.cub_id')
            ->where('tra_id_cub', $cuenta)
            ->where('tra_id <=', $tra_id)
            ->get();
        $resultado = $query->row_array();

        $sld = ($resultado['cub_saldo_inicial'] + $resultado['suma']);
        $saldo_final = number_format($sld, 2);
        $res['saldo'] =   $saldo_final;
        return $res;
    }

    //Obtiene las cuentas de gasto del prorrateo de acuerdo a lo configurado en la categoria
    public function get_cuentas_like_prorrateo($where = null, $like = null)
    {
        $this->db->select("*,CONCAT_WS(' ',cnt_cuenta,' - ',cnt_nombre) as cuenta_contable", false);
        $this->db->from('cnt_cuenta_contable');
        $this->db->join('dta_detalle_tipoarticulo', 'cnt_id = dta_id_cnt');
        $this->db->join('tia_tipo_articulo', 'tia_id = dta_id_tia');

        if ($like != null) {
            $this->db->like($like);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    //Obtiene las cuentas de gasto del prorrateo de acuerdo a lo configurado en la categoria
    public function get_cuentas_like_prorrateo_gral($where = null)
    {
        $this->db->select("*,CONCAT_WS(' ',cnt_cuenta,' - ',cnt_nombre) as cuenta_contable", false);
        $this->db->from('cnt_cuenta_contable');

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    //Obtiene las cuentas de gasto del prorrateo al editar de acuerdo a lo configurado en la categoria
    public function get_cuentas_like_prorrateo_gral_edit($where = null)
    {
        $this->db->select("*,CONCAT_WS(' ',cnt_cuenta,' - ',cnt_nombre) as cuenta_contable", false);
        $this->db->from('cnt_cuenta_contable');
        $this->db->join('dta_detalle_tipoarticulo', 'cnt_id = dta_id_cnt');
        $this->db->join('tia_tipo_articulo', 'tia_id = dta_id_tia');

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    public function ultimo_saldo($cuenta = null, $fecha = null)
    {
        $this->db->select('cub_saldo');
        $this->db->from('cub_cuenta_bancaria');
        $this->db->join('tra_transaccion', 'tra_id_cub = cub_id');
        $this->db->order_by('tra_fecha', 'DESC');
        $this->db->limit(1);
        if ($cuenta != null && fecha != null) {
            $this->db->where('cub_id', $cuenta);
            $this->db->where('tra_fecha <=', $fecha . ' 00:00:00');
        }
        $query = $this->db->get()->row_array();
        return $query['cub_saldo'];
    }

    public function ingresos_cuenta($where = null)
    {
        $this->db->select("ttb_nombre, tra_operacion, tra_monto, tra_fecha", false);
        $this->db->from('tra_transaccion');
        $this->db->join('ttb_tipo_transact_bancaria', 'tra_id_ttb = ttb_id');
        $this->db->join('cub_cuenta_bancaria', 'tra_id_cub = cub_id');
        $this->db->join('ban_banco', 'ban_id = cub_id_ban');
        $this->db->where('ttb_deposito', 1);
        $this->db->order_by('tra_fecha', 'ASC');
        //$this->db->group_by('ttb_id');
        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function egresos_x_rubro($where = null)
    {
        $this->db->select("
            psp_total,
            psp_fecha_desde,
            psp_fecha_hasta,
            CONCAT(acg_codigo, ' - ', acg_nombre) AS acg_nombre,
            CONCAT(ace_codigo, ' - ', ace_nombre) AS ace_nombre,
            CONCAT(psp_codigo, ' - ', psp_nombre) AS psp_nombre,
            dps_presupuesto_actividad, 
            sum(che_monto) as che_monto,
            tra_fecha,
            cub_numero, 
            ban_nombre
            ", false);
        $this->db->from('dch_detalle_cheque');
        $this->db->join('acg_actividad_general', 'dch_id_acg = acg_id');
        $this->db->join('ace_actividad_especifica', 'dch_id_ace = ace_id');
        $this->db->join('psp_presupuesto', 'dch_id_psp = psp_id');
        $this->db->join('dps_detalle_presupuesto', 'dps_id_ace = ace_id');
        $this->db->join('che_cheque', 'dch_id_che = che_id');
        $this->db->join('tra_transaccion', 'che_id_tra = tra_id');
        $this->db->join('ttb_tipo_transact_bancaria', 'tra_id_ttb = ttb_id');
        $this->db->join('cub_cuenta_bancaria', 'tra_id_cub = cub_id');
        $this->db->join('ban_banco', 'cub_id_ban = ban_id');
        $this->db->where('ttb_retiro', 1);
        $this->db->group_by('ace_id');
        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function egresos_cuenta($where = null)
    {
        $this->db->select("ttb_nombre, tra_operacion, tra_monto, tra_fecha", false);
        $this->db->from('tra_transaccion');
        $this->db->join('ttb_tipo_transact_bancaria', 'tra_id_ttb = ttb_id');
        $this->db->join('cub_cuenta_bancaria', 'tra_id_cub = cub_id');
        $this->db->join('ban_banco', 'ban_id = cub_id_ban');
        $this->db->where('ttb_retiro ', 1);
        $this->db->order_by('tra_fecha', 'ASC');
        //$this->db->group_by('ttb_id');
        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function pagos_dpv_pdtes()
    {
        $this->db->select("
            prv_codigo,
            IF(prv_tipo_pers = 1, CONCAT(prv_nombre,' ',prv_apellido), prv_nombre) as prv_nombre, 
            SUM(dpv_total) as dpv_total,
            SUM(dpv_monto_abono) as dpv_monto_abono,
            ", false);
        $this->db->from('dpv_documento_proveedor');
        $this->db->join('prv_proveedor', 'dpv_id_prv = prv_id');
        $this->db->where('dpv_monto_abono < dpv_total');
        $this->db->group_by('prv_id');
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * @author Nelson Soriano
     * @since  26-04-2019
     * @return retorna los cheques que no han sido cobrados aun
     */
    public function get_no_pagados($where = null, $groupby = null)
    {
        $this->db->select(
            '
                    che_fecha as fecha,
                    che_numero as numero,
                    che_concepto as descripcion,
                    che_monto as monto',
            false
        )
            ->from('che_cheque')
            ->join('chq_chequera', 'che_id_chq = chq_id', 'INNER')
            ->join('cub_cuenta_bancaria', 'chq_id_cub = cub_id', 'INNER')
            ->join('tra_transaccion', 'tra_id_cub = cub_id', "INNER");
        if ($where !== null) {
            $this->db->where($where);
        }
        if ($groupby !== null) {
            $this->db->group_by($groupby);
        }
        return $this->db->get()->result_array();
    }

    public function get_cuentasx($where = null)
    {
        $this->db->select(
            'cub_id as id,
                     concat(ban_nombre, ": ", cub_numero) AS cuenta,
                    ',
            false
        )
            ->from('cub_cuenta_bancaria')
            ->join('ban_banco', 'ban_id = cub_id_ban', 'INNER');
        if ($where !== null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }
    /**
     * @author Nelson Soriano
     * @since  30-04-2019
     * @return retorna el saldo contable de una cuenta x en un periodo x
     */
    public function get_saldo_contable($desde, $fin, $cuenta)
    {
        $this->db->select('
                    IFNULL((
                      select 
                        SUM( tra_monto )
                        FROM
                            tra_transaccion
                        WHERE
                            date_format( tra_fecha, "%Y-%m-%d" ) <= "' . $desde . '" 
                            AND tra_id_cub = ' . $cuenta . ' AND tra_conciliado = 0 AND tra_estado = 1
                    ),0) +
                    IFNULL(
                    (
                      select 
                        SUM(tra_monto) 
                        FROM
                            tra_transaccion
                        WHERE
                            (date_format( tra_fecha, "%Y-%m-%d" ) >= "' . $desde . '"  AND date_format( tra_fecha, "%Y-%m-%d" ) <= "' . $fin . '")
                            AND tra_id_cub = ' . $cuenta . ' AND tra_conciliado = 1 AND tra_estado = 1
                    ),0)AS saldo_contable       
                    ', false)
            ->from('tra_transaccion')
            ->where(array('tra_id_cub' => $cuenta))
            ->group_by('tra_id_cub');
        return $this->db->get()->result_array();
    }

    /**
     * @author Nelson Soriano
     * @since  26-04-2019
     * @return retorna los cheques que no han sido cobrados aun
     */

    public function get_transact_no_conciliadas($where)
    {
        $this->db->select('
                  ttb_nombre as tipo,
                  sum(tra_monto) as total
         ', false)->from('tra_transaccion')
            ->join('ttb_tipo_transact_bancaria', 'ttb_id = tra_id_ttb', 'INNER')
            ->join('cub_cuenta_bancaria', 'cub_id = tra_id_cub', 'INNER')
            ->where($where)
            ->group_by('ttb_id');
        return $this->db->get()->result_array();
    }

    public function get_detalle_nota($where = null)
    {
        $query = $this->db->select('
                    tif_abreviacion,
                    dpv_serie_documento,
                    dpv_numero_documento,
                    dna_concepto,
                    dna_valor,
                    dna_retencion,
                    dna_retencion_calculada,
                    dna_subtotal

                ')
            ->from('nta_nota_abono')
            ->join('dna_detalle_nota_abono', 'dna_id_nta = nta_id', 'INNER')
            ->join('rdn_retencion_detalle_nota', 'rdn_id_dna = dna_id', 'LEFT')
            ->join('dpv_documento_proveedor', 'dpv_id = dna_id_dpv', 'LEFT')
            ->join('tif_tipo_factura', 'tif_id = dpv_id_tif', 'left')
            ->group_by('dna_id');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author: Francisco Orozco
     * @since: 07-08-2019
     * @method Obtener cuentas de banco de un cheque
     * @param: where
     * @return: cuentas del banco.
     **/
    function get_cuentas_banco_cheque($where = null)
    {
        $query = $this->db->select()
            ->from('che_cheque')
            ->join('chq_chequera', 'chq_id = che_id_chq', 'INNER')
            ->join('cub_cuenta_bancaria', 'cub_id = chq_id_cub', 'INNER')
            ->join('cxb_cuentaxcuenta_bancaria', 'cxb_id_cub = cub_id', 'INNER')
            ->join('cnt_cuenta_contable', 'cnt_id = cxb_id_cnt', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author: Francisco Orozco
     * @since: 07-08-2019
     * @method Obtener cuentas de banco de una nota de abono
     * @param: where
     * @return: cuentas del banco.
     **/
    function get_cuentas_banco_nota_abono($where = null)
    {
        $query = $this->db->select()
            ->from('nta_nota_abono')
            ->join('cub_cuenta_bancaria', 'cub_id = nta_id_cub', 'INNER')
            ->join('cxb_cuentaxcuenta_bancaria', 'cxb_id_cub = cub_id', 'INNER')
            ->join('cnt_cuenta_contable', 'cnt_id = cxb_id_cnt', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author: Francisco Orozco
     * @since: 07-08-2019
     * @method Obtener partidas contables
     * @param: where
     * @return: detalle de documentos del proveedor apartir de un cheque
     **/
    public function get_partida_contable_cheque($where = null)
    {
        $query = $this->db->select()
            ->from('pct_partida_contable')
            ->join('dpc_detalle_partida', 'dpc_id_pct = pct_id', 'INNER')
            ->join('dpv_documento_proveedor', 'dpv_id_pct = pct_id', 'INNER')
            ->join('dch_detalle_cheque', 'dch_id_dpv = dpv_id', 'INNER')
            ->join('pcc_partida_centro_costo', 'pcc_id = dpc_id_pcc', 'LEFT')
            ->order_by("pcc_id_cec, dpc_id_cnt", "ASC");

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author: Francisco Orozco
     * @since: 07-08-2019
     * @method Obtener partidas contables
     * @param: where
     * @return: detalle de documentos del proveedor apartir de una nota de abono
     **/
    public function get_partida_contable_nota_abono($where = null)
    {
        $query = $this->db->select()
            ->from('pct_partida_contable')
            ->join('dpc_detalle_partida', 'dpc_id_pct = pct_id', 'INNER')
            ->join('dpv_documento_proveedor', 'dpv_id_pct = pct_id', 'INNER')
            ->join('dna_detalle_nota_abono', 'dna_id_dpv = dpv_id', 'INNER')
            ->join('pcc_partida_centro_costo', 'pcc_id = dpc_id_pcc', 'LEFT')
            ->order_by("pcc_id_cec, dpc_id_cnt", "ASC");

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function verifica_chequera($cuenta, $numero, $tipo, $actual = 0)
    {
        if ($actual > 0) {
            $this->db->select('*')
                ->from('chq_chequera')
                ->where('chq_id_cub', $cuenta)
                ->where('chq_numero', $numero)
                ->where('chq_tipo', $tipo)
                ->where('chq_id !=', $actual);
            $nregistros = $this->db->count_all_results();
        } else {
            $this->db->select('*')
                ->from('chq_chequera')
                ->where('chq_id_cub', $cuenta)
                ->where('chq_numero', $numero)
                ->where('chq_tipo', $tipo);
            $nregistros = $this->db->count_all_results();
        }
        return $nregistros;
    }
}
