<?php

/**
 * 
 */
class Transporte_model extends CI_Model
{

    /**
     * Entradas_model::__construct()
     * 
     * @return
     */
    function __construct()
    {
        $this->load->database();
        date_default_timezone_set('America/El_Salvador');
    }

    public function cupones_combustible()
    {
        $this->db->select('gtc_id,
                            vxc_id,
                            vxc_inicio,
                            vxc_fin,
                            (vxc_fin - vxc_inicio +1) as cantidad,
                            srv_nombre,
                            srv_valor,
                            (srv_valor * (vxc_fin - vxc_inicio)) as total,
                            dtc_periodo_desde,
                            dtc_destino,
                            dtc_id_tkt,
                            gtc_fecha_creacion,
                            veh_placa'
                    )
                ->from('gtc_gestion_combustible')
                ->join('vxc_valesxgestion_comb', 'vxc_id_gtc = gtc_id', 'INNER')
                ->join('srv_serie_vale', 'srv_id = vxc_id_srv', 'INNER')
                ->join('dtc_detalle_ticket_combustible', 'dtc_id = gtc_id_dtc', 'INNER')
                ->join('veh_vehiculo', 'veh_id = dtc_id_veh', 'INNER')
                //->where('con_id', $con_id)
            ;
        $query = $this->db->get()->result_array();
        return $query;
    }

   /**
   * @author Christian Menendez
   * @return 
   */

  function get_solicitud_transporte($id_solicitud=null)
  {

    $query="
   SELECT
    date_format(
        dtt.dtt_fecha_salida,
        '%d/%m/%Y'
    ) fecha,
    dtt_hora_salida,
    dtt_id_tkt,
    dtt_fecha_creacion,
    dtt.dtt_cantidad_per,
    dtt.dtt_actividad AS destino_actividad,
    dtt.dtt_actividad AS destino,
    dtt.dtt_descripcion,
    esk.esk_nombre,
    mrc.mrc_nombre,
    
    (SELECT
      GROUP_CONCAT(ubt_nombre SEPARATOR ', ')
        FROM
            uxt_ubicaxticket
          INNER JOIN ubt_ubicacion_tarea ON ubt_id = uxt_id_ubt AND ubt_estado = 1
        WHERE
            uxt_id_dtt = dtt.dtt_id
  GROUP BY 'all') AS ubicaciones
FROM
 dtt_detalle_ticket_trans AS dtt

LEFT JOIN tkt_ticket as tkt
ON tkt_id = dtt.dtt_id_tkt

LEFT JOIN esk_estado_ticket as esk
on esk_id = tkt.tkt_id_esk

LEFT JOIN mrc_medio_recepcion AS mrc
ON mrc_id = tkt.tkt_id_mrc

WHERE
    dtt.dtt_id = ".$id_solicitud."";

    $resultado=$this->db->query($query)->result_array();
    return $resultado;
  }


/**
   * @author Christian Menendez
   * @return 
   */

  function get_control_combustible()
  {

    $query1="

SELECT
    Date_format(
        vxc.vxc_fecha_creacion,
        '%Y/%m/%d'
    ) fecha,
    tkt.tkt_id num_solicitud,
    Date_format(
        dtc.dtc_periodo_desde,
        '%Y/%m/%d'
    ) fecha_inicio,
    HOUR (dtc.dtc_periodo_desde) AS hora,
    CONCAT_WS(
        ' ',
        emp.emp_nombre,
        emp.emp_apellido
    ) AS solicitante,
    veh.veh_placa,
    srv.srv_inicio serie_inicio,
    srv.srv_fin serie_fin,
    (vxc.vxc_fin - vxc.vxc_inicio) AS cantidad,
    (
        srv.srv_valor * (vxc.vxc_fin - vxc.vxc_inicio)
    ) AS total,
    dtc.dtc_destino,
    (vxc.vxc_fin - vxc.vxc_inicio) AS salida,
    ddt.ddt_actividad
FROM
    (
        (
            (
                (
                    (
                        (
                            (srv_serie_vale srv)
                            LEFT JOIN vxc_valesxgestion_comb vxc ON srv.srv_id = vxc.vxc_id_srv
                        )
                        LEFT JOIN gtc_gestion_combustible gtc ON gtc.gtc_id = vxc.vxc_id_gtc
                    )
                    LEFT JOIN dtc_detalle_ticket_combustible dtc ON dtc.dtc_id = gtc.gtc_id_dtc
                )
                LEFT JOIN veh_vehiculo veh ON veh.veh_id = dtc.dtc_id_veh
            )
            LEFT JOIN tkt_ticket tkt ON tkt.tkt_id = dtc.dtc_id_tkt
        )
        LEFT JOIN emp_empleado emp ON emp.emp_id = tkt.tkt_usuario_solicita
    )
LEFT JOIN ddt_detalle_destino ddt ON ddt.ddt_id_dtc = dtc.dtc_id;";

      $resultado=$this->db->query($query1)->result_array();
        return $resultado;

  }

  /**
  * @author René Castaneda
  * @since 2020-12-03
  * @param array where 
  * @return array query asignación
   */
  function get_asignacion_last($where = null) {
      $q = $this->db->select()
          ->from('asv_asignacion_vehiculo')
          ->join('mot_motorista', 'mot_id = asv_id_mot')
          ->join('emp_empleado', 'emp_id = mot_empleado')
          ->order_by('asv_fecha','DESC')
          ->order_by('asv_id','DESC')
          ->limit('1')
          ->group_by('asv_id')
          ;

      if ($where) {
          $this->db->where($where);
      }
      $resultado = $q->get()->row_array();
      return $resultado;
  }
  
  /**
  * @author René Castaneda
  * @since 2020-12-10
  * @param array where 
  * @return array query 
   */
  function get_vehiculo($where = null) {
      $q = $this->db->select()
          ->from('veh_vehiculo')
          ->join('mrv_marca', 'mrv_id = veh_id_mrv','left')
          ->join('mdv_modelo_veh', 'mdv_id = veh_id_mdv','left')
          ->join('tvh_tipo_vehiculo', 'tvh_id = veh_id_tvh','left')
          ->join('tpm_tipo_motor', 'tpm_id = veh_id_tpm','left')
          ->join('clv_color_vehiculo', 'clv_id = veh_id_clv','left')
          ->join('trm_transmision', 'trm_id = veh_id_trm','left')
          ->join('trc_traccion', 'trc_id = veh_id_trc','left')
          ->join('tpl_tipo_llanta', 'tpl_id = veh_id_tpl','left')
          ->join('tpc_tipo_combustible', 'tpc_id = veh_id_tpc','left')
          ->join('cfv_clasif_vehiculo', 'cfv_id = veh_id_cfv','left')
          ->join('stv_status_vehiculo', 'stv_id = veh_id_stv','left')
          ->join('cms_compania_seguro', 'cms_id = veh_id_cms','left')
          ->join('tpf_tipo_fondo', 'tpf_id = veh_id_tpf','left')
          ->join('ach_aceite_vehiculo', 'ach_id = veh_id_ach','left')
          ->join('emp_empleado', 'emp_id = veh_id_emp','left')
          ->group_by('veh_id')
          ;
      if ($where) {
          $this->db->where($where);
      }
      $resultado = $q->get()->result_array();
      return $resultado;
  }

  /**
  * @author René Castaneda
  * @since 2020-12-10
  * @param array where 
  * @return array query 
   */
  function get_mtto_vehiculo($where = null) {
      $q = $this->db->select("*, 
          (SELECT rev_km_final from rev_registro_vehiculo WHERE rev_id_veh = veh_id
           ORDER BY rev_fecha DESC LIMIT 1) ultimo_kilometraje",false)
          ->from('gmt_gestion_mantto')
          ->join('veh_vehiculo','veh_id=gmt_id_veh','left')
          ->join('opm_operacion_mantto','opm_id=gmt_id_opm','left')
          ->join('tmn_tipo_mantto','tmn_id=opm_id_tmn','left')
          ->join('prv_proveedor','prv_id=gmt_id_prv','left')
          ->join('mrv_marca', 'mrv_id = veh_id_mrv','left')
          ->join('mdv_modelo_veh', 'mdv_id = veh_id_mdv','left')
          ->join('tvh_tipo_vehiculo', 'tvh_id = veh_id_tvh','left')
          ->join('tpm_tipo_motor', 'tpm_id = veh_id_tpm','left')
          ->join('clv_color_vehiculo', 'clv_id = veh_id_clv','left')
          ->join('trm_transmision', 'trm_id = veh_id_trm','left')
          ->join('trc_traccion', 'trc_id = veh_id_trc','left')
          ->join('tpl_tipo_llanta', 'tpl_id = veh_id_tpl','left')
          ->join('tpc_tipo_combustible', 'tpc_id = veh_id_tpc','left')
          ->join('cfv_clasif_vehiculo', 'cfv_id = veh_id_cfv','left')
          ->join('stv_status_vehiculo', 'stv_id = veh_id_stv','left')
          ->join('cms_compania_seguro', 'cms_id = veh_id_cms','left')
          ->join('tpf_tipo_fondo', 'tpf_id = veh_id_tpf','left')
          ->join('ach_aceite_vehiculo', 'ach_id = veh_id_ach','left')
          ->join('emt_estado_mantenimiento', 'emt_id = gmt_id_emt','left')
          ->join('emp_empleado', 'emp_id = veh_id_emp','left')
          ->group_by('veh_id')
          ;
      if ($where) {
          $this->db->where($where);
      }
      $resultado = $q->get()->result_array();
      return $resultado;
  }

  /**
  * @author René Castaneda
  * @since 2021-04-17
  * @param array where 
  * @return array query 
   */
  function get_seguimiento_mtto($where = null, $where_string = null) {
      $q = $this->db->select("*, 
          (SELECT rev_km_final from rev_registro_vehiculo WHERE rev_id_veh = veh_id
           ORDER BY rev_fecha DESC LIMIT 1) ultimo_kilometraje",false)
          ->from('gmt_gestion_mantto')
          ->join('veh_vehiculo','veh_id=gmt_id_veh','left')
          ->join('opm_operacion_mantto','opm_id=gmt_id_opm','left')
          ->join('tmn_tipo_mantto','tmn_id=opm_id_tmn','left')
          ->join('prv_proveedor','prv_id=gmt_id_prv','left')
          ->join('mrv_marca', 'mrv_id = veh_id_mrv','left')
          ->join('mdv_modelo_veh', 'mdv_id = veh_id_mdv','left')
          ->join('tvh_tipo_vehiculo', 'tvh_id = veh_id_tvh','left')
          ->join('tpm_tipo_motor', 'tpm_id = veh_id_tpm','left')
          ->join('clv_color_vehiculo', 'clv_id = veh_id_clv','left')
          ->join('trm_transmision', 'trm_id = veh_id_trm','left')
          ->join('trc_traccion', 'trc_id = veh_id_trc','left')
          ->join('tpl_tipo_llanta', 'tpl_id = veh_id_tpl','left')
          ->join('tpc_tipo_combustible', 'tpc_id = veh_id_tpc','left')
          ->join('cfv_clasif_vehiculo', 'cfv_id = veh_id_cfv','left')
          ->join('stv_status_vehiculo', 'stv_id = veh_id_stv','left')
          ->join('cms_compania_seguro', 'cms_id = veh_id_cms','left')
          ->join('tpf_tipo_fondo', 'tpf_id = veh_id_tpf','left')
          ->join('ach_aceite_vehiculo', 'ach_id = veh_id_ach','left')
          ->join('emt_estado_mantenimiento', 'emt_id = gmt_id_emt','left')
          ->join('emp_empleado', 'emp_id = veh_id_emp','left')
          ->group_by('veh_id')
          ;
      if ($where) {
          $this->db->where($where);
      }
      if ($where_string) {
          $this->db->or_where($where_string,null, false);
      }
      $resultado = $q->get()->result_array();
      return $resultado;
  }

} // End entradas_model

