<?php 
class Tarificador_model extends CI_Model{
	
	function __construct(){
        $this->load->database();
        //$this->load->library('database');
  }

  function get_info($id_plan=null)
  {
        $query=$this->db->select('src_id,src_nombre, pln_nombre, pln_id')
        			->from('pln_plan_promocion')
  					->join('src_servicio','src_id=pln_id_src','left')
        			->where('pln_id',$id_plan)
        			->get();
        return $query->row();
  }

  function get_productoxcliente($id_cliente=null){
        $query=$this->db->select('src_id, cli_id, sxc_fecha_contrato,sxc_id_pcn, pcn_nombre, src_nombre, cli_nombre, sxc_id, pcn_duracion')
              ->from('src_servicio')
              ->join('sxc_servicioxcliente','src_id= sxc_id_src')
              ->join('cli_cliente','cli_id= sxc_id_cli')
              //->join('txs_telefonoxservicio','txs_id_sxc = sxc_id','left')
              ->join('pcn_periodo_contrato','pcn_id=sxc_id_pcn')
              ->where('cli_id',$id_cliente)
              ->get();
          $result=$query->result_array();
          //die(print_r($result));
        return $result;
  }
  
  function get_codigos_llamada_gratis($plan=null)
  {
      $this->db->select('ppa_id, ppa_nombre, ppa_desde_codigo')
              ->from('pxp_parametro_paixplan')
              ->join('ppa_parametro_pais', 'ppa_id = pxp_id_ppa')
              ->where('pxp_estado',1)
              ->where('pxp_id_pln',$plan)
              ;
      $result = $this->db->get()->result_array();
      return $result;
  }
          
  function get_promoxcliente($id_sxc=null){
        $query=$this->db->select('sxc_id,sxc_id_cli, cli_nombre, sxc_id_src, src_nombre')
              ->from('sxc_servicioxcliente')
              ->join('cli_cliente','cli_id= sxc_id_cli')
              ->join('src_servicio','src_id= sxc_id_src')
              ->where('sxc_id',$id_sxc)
              ->get();
          $result=$query->result_array();
          //die(print_r($result));
        return $result;
  }

  function get_planes_cliente($id_sxc=null){
      $query=$this->db->select('sxc_id, pxl_id, pxl_id_pln, pxl_fecha_inicio, pxl_fecha_fin, pln_tipo, pln_nombre')
              ->from('sxc_servicioxcliente')
              ->join('pxl_plan_promoxcliente','pxl_id_sxc=sxc_id')
              ->join('pln_plan_promocion','pxl_id_pln=pln_id')
              ->where('sxc_id',$id_sxc)
              ->get();
          $result=$query->result_array();
          //die(print_r($result));
        return $result;
  }

  function get_codigo_pais_length($prefijo=null){
    $query = "
      SELECT MAX(CHAR_LENGTH(ppa_desde_codigo)) AS tamanio FROM ppa_parametro_pais WHERE  ppa_desde_codigo LIKE '".$prefijo."%';
    ";
      $resultado = $this->db->query($query)->row_array();
      return $resultado['tamanio'];
  }

  function get_codigo_pais($cadena=null)
  {
    $query = "
      SELECT COUNT(ppa_id) AS contador FROM ppa_parametro_pais WHERE ppa_desde_codigo = '".$cadena."';
    ";
    $existe = $this->db->query($query)->row_array();
    return $existe['contador'];
  }

  function get_info_cargos($id_pxc=null)
  {
     $query=$this->db->select('sxc_id, cli_id, src_id, sxc_fecha_contrato, cli_nombre, src_nombre')
              ->from('sxc_servicioxcliente')
              ->join('cli_cliente','cli_id=sxc_id_cli')
              ->join('src_servicio','src_id=sxc_id_src')
              ->where('sxc_id',$id_pxc)
              ->get();
          $result=$query->result_array();
          //die(print_r($result));
        return $result;
  }

  function get_info_cargoxfac($id_pxc=null, $fijo=null, $consumo=null)
  {

     $this->db->select('sxc_id, sxc_fecha_contrato, caf_valor, caf_fecha, tcs_id, caf_id, tcs_nombre, caf_estado')
              ->from('sxc_servicioxcliente')
              ->join('caf_cargo_facturacion','caf_id_sxc=sxc_id')
              ->join('tcs_tipo_cargo_servicio','tcs_id=caf_id_tcs')
              ->where('sxc_id',$id_pxc);
              if($fijo!=null && $consumo!=null){
                $this->db->where('caf_id_tcs !=',$fijo);
                $this->db->where('caf_id_tcs !=',$consumo);
              }

            $result=$this->db->get()->result_array();
          //die(print_r($this->db->last_query()));
        return $result;
  }

  function get_info_cliente_cdr($where=null){

    $query = $this->db->select()
          ->from('cli_cliente')
          ->join('sxc_servicioxcliente','sxc_servicioxcliente.sxc_id_cli = cli_cliente.cli_id','inner')
          ->join('src_servicio','src_servicio.src_id = sxc_servicioxcliente.sxc_id_src','inner')
          ->join('pcn_periodo_contrato','pcn_periodo_contrato.pcn_id = sxc_servicioxcliente.sxc_id_pcn','inner')
    ;

    if($where!=null){
      $this->db->where($where);
    }
    return $query->get()->result_array();
  }

  function get_cdr_cliente_servicio($where=null){

    $query = "
      SELECT REPLACE(txs.txs_numero,'-','') as numero_origen  FROM txs_telefonoxservicio AS txs
      INNER JOIN sxc_servicioxcliente AS sxc
      ON sxc.sxc_id = txs.txs_id_sxc LEFT JOIN cli_cliente AS cli 
      ON cli.cli_id = sxc.sxc_id_cli LEFT JOIN src_servicio AS src 
      ON src.src_id = sxc.sxc_id_src "
    ;

    if($where!=null){
      $query.='WHERE '.$where;
    }

    $query.=' GROUP BY txs.txs_numero';

    $result = $this->db->query($query);

    return $result->result_array();
  }

  function get_listado_cdr($cdr="",$fecha_inicio="",$fecha_fin="",$procesados=""){

    $query = $this->db->query('call sp_reporte_cdr("'.$cdr.'","'.$fecha_inicio.'","'.$fecha_fin.'","'.$procesados.'")');    
    
    clean_mysqli_connection($this->db->conn_id);

    return $query->result_array();
  }

  function reporte_detalle_facturacion($factura){
    $query = $this->db->query('call sp_reporte_costo_fac('.$factura.')');

    clean_mysqli_connection($this->db->conn_id);

    return $query->result_array();
  }

  function reporte_clientes($tipo=0){
    $query = $this->db->query('call sp_reporte_cli('.$tipo.')');

    clean_mysqli_connection($this->db->conn_id);

    return $query->result_array();
  }

  function get_planes_minutos_incluidos($fecha_inicio, $fecha_fin, $numero=null)
  {
    $query = "
      SELECT REPLACE(txs_numero,'-','') txs_numero, ppa_desde_codigo, pln_minuto, pxl_fecha_fin, pln_tipo, pln_id, pln_nombre
        FROM 
          pln_plan_promocion
        INNER JOIN pxl_plan_promoxcliente ON pxl_id_pln = pln_id
        INNER JOIN sxc_servicioxcliente ON sxc_id = pxl_id_sxc
        INNER JOIN txs_telefonoxservicio ON txs_id_sxc = sxc_id
        INNER JOIN pxp_parametro_paixplan ON pxp_id_pln = pln_id
        INNER JOIN ppa_parametro_pais ON ppa_id = pxp_id_ppa
        WHERE
        sxc_estado = 1  
        AND pln_estado = 1
        AND pxl_estado = 1
        AND pxl_fecha_fin >= '".$fecha_inicio."'
        AND pln_hasta >= '".$fecha_inicio."'
        ";

    if($numero>=0 && $numero_cli!=''){
      $query.=" AND REPLACE(txs_numero,'-','') = '".$numero."'";
    }
      $query.=" ORDER BY txs_numero, ppa_desde_codigo, pln_tipo ASC";
    
    $result = $this->db->query($query)->result_array();
      return $result;
  }

  function get_cdr($fecha_inicio, $fecha_fin, $numero_cli=null)
  {
    $this->db->select('cdd_id, cdd_numero_origen, cdd_destino, cdd_duracion_min, cdd_fecha_inicio, cdd_fecha_fin, cdd_costo_unit, cdd_costo_total, NULL AS flag', false)
              ->from('cdd_cdr_detalle')
              ->where('cdd_estado',1)
              ->where('cdd_procesado',0)
              ->where('cdd_fecha_inicio >=', $fecha_inicio)
              ->where('cdd_fecha_inicio <=', date('Y-m-d 23:59:59', strtotime($fecha_fin)))

              ;

              if($numero_cli>=0 && $numero_cli!=''){
                $this->db->where('cdd_numero_origen', $numero_cli);
              }

       $result = $this->db->get()->result_array();
       //die(print_r($this->db->last_query()));
       return $result;       
  }

  function get_promociones($fecha_inicio, $fecha_fin, $numero_cli=null)
  {
    $query = "
      SELECT REPLACE(txs_numero,'-','') txs_numero, ppa_desde_codigo, trf_id_dia_desde, trf_id_dia_hasta, trf_costo,
          trf_desde, trf_hasta, trf_desde_minuto, trf_hasta_minuto, trf_desde_horario, trf_hasta_horario, pxl_fecha_inicio,
          pxl_fecha_fin, pln_tipo, pln_nombre, trf_nombre
        FROM  
          pln_plan_promocion
        INNER JOIN pxl_plan_promoxcliente ON pxl_id_pln = pln_id
        INNER JOIN sxc_servicioxcliente ON sxc_id = pxl_id_sxc
        INNER JOIN txs_telefonoxservicio ON txs_id_sxc = sxc_id
        INNER JOIN trf_tarifa ON trf_id_pln = pln_id
        INNER JOIN ppa_parametro_pais ON ppa_id = trf_id_ppa
        WHERE 
          pxl_estado = 1
        AND trf_estado = 1  
        AND sxc_estado = 1  
        AND pln_tipo = 2  
        AND pln_estado = 1
        AND pxl_fecha_fin >= '".$fecha_inicio."'
        AND pln_hasta >= '".$fecha_inicio."'";
        if($numero_cli>=0 && $numero_cli!=''){
          $query.=" AND REPLACE(txs_numero,'-','') = '".$numero_cli."'";
        }
        $query.=" ORDER BY txs_numero, ppa_desde_codigo, trf_desde_minuto ASC
                ";
    $result = $this->db->query($query)->result_array();
    return $result;    
  } // End get_promociones

    function get_planes($fecha_inicio, $fecha_fin, $numero_cli=null)
  {
    $query = "
      SELECT REPLACE(txs_numero,'-','') txs_numero, ppa_desde_codigo, trf_id_dia_desde, trf_id_dia_hasta, trf_costo,
          trf_desde, trf_hasta, trf_desde_minuto, trf_hasta_minuto, trf_desde_horario, trf_hasta_horario, pxl_fecha_inicio,
          pxl_fecha_fin, trf_id, pln_tipo, pln_nombre, trf_nombre,
          CASE 
		WHEN trf_hasta_minuto IS NULL OR trf_hasta_minuto = ''
		THEN (trf_desde_minuto+1)*10
		ELSE trf_hasta_minuto - trf_desde_minuto
          END AS minutos
        FROM  
          pln_plan_promocion
        INNER JOIN pxl_plan_promoxcliente ON pxl_id_pln = pln_id
        INNER JOIN sxc_servicioxcliente ON sxc_id = pxl_id_sxc
        INNER JOIN txs_telefonoxservicio ON txs_id_sxc = sxc_id
        INNER JOIN trf_tarifa ON trf_id_pln = pln_id
        INNER JOIN ppa_parametro_pais ON ppa_id = trf_id_ppa
        WHERE 
        trf_estado = 1 
        AND pxl_estado = 1
        AND pln_tipo = 1
        AND pln_estado = 1
        AND pxl_fecha_fin >= '".$fecha_inicio."' ";
        if($numero_cli>=0 && $numero_cli!=''){
          $query.=" AND REPLACE(txs_numero,'-','') = '".$numero_cli."'";
        }
        $query.="ORDER BY txs_numero, minutos ASC
        ";
    $result = $this->db->query($query)->result_array();
    return $result;    
  } // End get_planes
  
  
     function get_planesPromociones($fecha_inicio, $fecha_fin, $numero_cli=null)
  {
    $query = "
      SELECT REPLACE(txs_numero,'-','') txs_numero, ppa_desde_codigo, trf_id_dia_desde, trf_id_dia_hasta,
          trf_desde, trf_hasta, trf_desde_minuto, trf_hasta_minuto, trf_desde_horario, trf_hasta_horario, pxl_fecha_inicio,
          pxl_fecha_fin, trf_id, pln_tipo, pln_nombre, trf_nombre, pln_id, pln_estado
        FROM  
          pln_plan_promocion
        LEFT JOIN pxl_plan_promoxcliente ON pxl_id_pln = pln_id
        LEFT JOIN sxc_servicioxcliente ON sxc_id = pxl_id_sxc
        LEFT JOIN txs_telefonoxservicio ON txs_id_sxc = sxc_id
        LEFT JOIN trf_tarifa ON trf_id_pln = pln_id
        LEFT JOIN ppa_parametro_pais ON ppa_id = trf_id_ppa
        WHERE 
        pxl_fecha_fin >= '".$fecha_inicio."' ";
        if($numero_cli>=0 && $numero_cli!=''){
          $query.=" AND REPLACE(txs_numero,'-','') = '".$numero_cli."'";
        }
        $query.="ORDER BY pxl_fecha_inicio DESC, txs_numero ASC
        ";
        
        return $this->db->query($query)->result_array();
     
  } // End get_planesPromociones

  function get_codigo_paises($prefijo=null)
  {

    $prefijo = trim($prefijo);
     $this->db->select("ppa_id, ppa_nombre, ppa_desde_codigo")
              ->from('ppa_parametro_pais')
              ->where("ppa_estado",1)
              ->like("TRIM(ppa_nombre)", $prefijo, 'after')
              ->or_like("TRIM(ppa_desde_codigo)", $prefijo, 'after')
              ->limit(5000)
      ;
     return $this->db->get()->result_array();
  }

  function buscar_duplicados($tabla ,$where=NULL)
  {
    $this->db->select()
              ->from($tabla)
              ->where($where)
          ;
    return $this->db->count_all_results();

  }


  function get_cargos_factura($factura=0,$tipo_cargo=null, $fecha_ini= null,$fec_fin=null){
    $query = $this->db->query("call sp_cargos_fac(".$factura.",".$tipo_cargo.",'".$fecha_ini."','".$fec_fin."')");
    clean_mysqli_connection($this->db->conn_id);

    return $query->result_array();
  }

  function get_consolidado_min($dep_id=0,$fecha_inicio='',$fecha_fin=''){
    
    $query = $this->db->query('call sp_reporte_consolidado_min('.$dep_id.',"'.$fecha_inicio.'","'.$fecha_fin.'")');

    clean_mysqli_connection($this->db->conn_id);

    return $query->result_array();
  }

  function get_consolidado_prod($prod_id=0,$dep_id=0,$fecha_inicio='',$fecha_fin=''){
    
    $query = $this->db->query('call sp_reporte_consolidado_pro('.$prod_id.','.$dep_id.',"'.$fecha_inicio.'","'.$fecha_fin.'")');

    clean_mysqli_connection($this->db->conn_id);

    return $query->result_array();
  }

  function get_paises()
  {
    $this->db->select('pai_id, pai_nombre')
          ->FROM('pai_pais')
          ->WHERE('pai_estado',1)
          ;
    $query = $this->db->get()->result();
    return $query;      
  }

  function get_plan_promocion()
  {
    $this->db->select('pln_id, pln_nombre')
          ->FROM('pln_plan_promocion')
          ->WHERE('pln_estado',1)
          ;
    $query = $this->db->get()->result();
    return $query;       
  }

  function get_info_cliente_factura($where=null){
    $query = $this->db->select()
            ->from('cli_cliente')
            ->join('sxc_servicioxcliente','sxc_servicioxcliente.sxc_id_cli = cli_cliente.cli_id','inner')
            ->join('fxs_facturaxservicio','fxs_facturaxservicio.fxs_id_sxc = sxc_servicioxcliente.sxc_id','inner')
            ->join('fac_factura','fac_factura.fac_id = fxs_facturaxservicio.fxs_id_fac','inner')
    ;

    if($where!=null){
      $this->db->where($where);
    }

    return $query->get()->result_array();
  }

  function get_consolidado_vend($vend_id=0,$prod_id=0,$dep_id=0,$fecha_inicio='',$fecha_fin=''){
    
    $query = $this->db->query('call sp_reporte_consolidado_vendedores('.$vend_id.','.$prod_id.','.$dep_id.',"'.$fecha_inicio.'","'.$fecha_fin.'")');

    clean_mysqli_connection($this->db->conn_id);

    return $query->result_array();
  }

  function get_consolidado_promo($dep_id=0,$prom_id=0,$fecha_inicio='',$fecha_fin=''){
    
    $query = $this->db->query('call sp_reporte_consolidado_promociones('.$dep_id.','.$prom_id.',"'.$fecha_inicio.'","'.$fecha_fin.'")');

    clean_mysqli_connection($this->db->conn_id);

    return $query->result_array();
  }

  function get_factura_min_consumidos($factura=0,$agrupar=0){
    
    $query = $this->db->query('call sp_factura_min_consumidos('.$factura.','.$agrupar.')');

    clean_mysqli_connection($this->db->conn_id);

    return $query->result_array();
  }



  function get_facturas_cliente($where){
    $query = $this->db->select()
          ->from('fac_factura')
          ->join('fxs_facturaxservicio','fxs_facturaxservicio.fxs_id_fac = fac_factura.fac_id','inner')
          ->join('sxc_servicioxcliente','sxc_servicioxcliente.sxc_id = fxs_facturaxservicio.fxs_id_sxc','inner')
          ->join('cli_cliente','cli_cliente.cli_id = sxc_servicioxcliente.sxc_id_cli','inner')
          ->join('src_servicio','src_servicio.src_id = sxc_servicioxcliente.sxc_id_src','inner')
    ; 

    if($where!=null){
      $this->db->where($where);
    }

    return $query->get()->result_array();
  }

  function get_listado_planes_pago(){
    
    $query = $this->db->query('call sp_listado_planes_pago()');

    clean_mysqli_connection($this->db->conn_id);

    return $query->result_array();
  }

  function get_facturas_plan_pago($where=null){
    $query = $this->db->select()
        ->from('fac_factura')
        ->join('fxp_facturaxplan_pago','fxp_facturaxplan_pago.fxp_id_fac = fac_factura.fac_id','inner')
        ->join('plg_plan_pago','plg_plan_pago.plg_id = fxp_facturaxplan_pago.fxp_id_plg','inner')
        //->join('fxs_facturaxservicio','fxs_facturaxservicio.fxs_id_fac = fac_factura.fac_id','inner')
        //->join('sxc_servicioxcliente','sxc_servicioxcliente.sxc_id = fxs_facturaxservicio.fxs_id_sxc','inner')
        //->join('src_servicio','src_servicio.src_id = sxc_servicioxcliente.sxc_id_src','inner')
        //->join('cli_cliente','cli_cliente.cli_id = sxc_servicioxcliente.sxc_id_cli','inner')
    ;

    if($where!=null){
      $this->db->where($where);
    }

    return $query->get()->result_array();
  }

  function get_cuotas_plan_pago($where=null){
    $query = $this->db->select()
        ->from('cpl_cuota_plan_pago')
        ->join('plg_plan_pago','plg_plan_pago.plg_id = cpl_cuota_plan_pago.cpl_id_plg','inner')
        ->join('paf_pago_factura', 'paf_id_cpl=cpl_id', 'left')
    ;

    if($where!=null){
      $this->db->where($where);
    }

    return $query->get()->result_array();
  }

  function get_facturas_pendientes($factura = 0,$cliente = 0){
    
    $query = $this->db->query('call sp_facturas_anteriores_cli('.$factura.','.$cliente.')');

    clean_mysqli_connection($this->db->conn_id);

    return $query->result_array();
  }

  /**
  * @author: Mario Marquez
  * @param: tabla_principal = string;
  * @param: where = array OR string;
  * @param: tabla_dependiente = string;
  * @param: campo_fk = string;
  * @param: $tipo = string;
    */
   function get_data_intermediarias($tabla_principal=null,$where=null,$tabla_dependiente=null,$campo_fk=null,$tipo='inner'){
        if($tabla_principal!=null){

          $this->db->select()
                ->from($tabla_principal)
          ;

          if($tabla_dependiente!=null && $campo_fk!=null){

            $primary_principal = $this->db->primary($tabla_principal);

            $this->db->join($tabla_dependiente,$tabla_principal.".".$primary_principal." = ".$tabla_dependiente.".".$campo_fk,$tipo);
          }

          if($where!=null){
            $this->db->where($where);
          }

          $query = $this->db->get()->result_array();

          return $query;
        }
        else{
          return false;
        }
    }

    function get_numeros($where)
    {
       $query = $this->db->select('GROUP_CONCAT(" ",txs_numero) as numeros', FALSE)
          ->from('sxc_servicioxcliente') 
          ->join('txs_telefonoxservicio','txs_id_sxc = sxc_id')
      ;

      if($where!=null){
        $this->db->where($where);
      }
      return $query->get()->row_array();
    }
    
    function get_numeros_favoritos($where)
    {
       $query = $this->db->select('GROUP_CONCAT(" ",txp_numero) as numeros', FALSE)
          ->from('pxl_plan_promoxcliente') 
          ->join('txp_telefonoxplan','txp_id_pxl = pxl_id')
      ;

      if($where!=null){
        $this->db->where($where);
      }
      return $query->get()->row_array();
    }

    

    function get_facturas_pagada_cliente($where){
    $query = $this->db->select()
          ->from('fac_factura')
          ->join('fxs_facturaxservicio','fxs_facturaxservicio.fxs_id_fac = fac_factura.fac_id','inner')
          ->join('sxc_servicioxcliente','sxc_servicioxcliente.sxc_id = fxs_facturaxservicio.fxs_id_sxc','inner')
          ->join('paf_pago_factura','paf_pago_factura.paf_id_fac = fac_factura.fac_id','inner')
          ->join('cli_cliente','cli_cliente.cli_id = sxc_servicioxcliente.sxc_id_cli','inner')
          ->join('src_servicio','src_servicio.src_id = sxc_servicioxcliente.sxc_id_src','inner')
    ; 

    if($where!=null){
      $this->db->where($where);
    }

    return $query->get()->result_array();
  }

 

  function get_listado_tarifas($where){
    $query = $this->db->select()
          ->from('trf_tarifa')
    ;

    if($where!=null){
      $this->db->where($where);  
    }

    return $query->get()->result_array();
  }

  function comprobante_pago($id_factura=NULL, $id_cpl=NULL){

    if(!empty($id_factura)){
        
        $this->db->select('paf_id, paf_numero AS correlativo, cli_codigo AS codigo, paf_total, NULL AS caja, fac_numero AS documento, src_nombre, cli_apellido, cli_nombre, cli_personeria, txs_numero, fac_fecha_cont AS mes_factura', false)
            ->from('paf_pago_factura')
            ->join('fac_factura', 'fac_id = paf_id_fac')
            ->join('fxs_facturaxservicio', 'fxs_id_fac = fac_id')
            ->join('sxc_servicioxcliente', 'sxc_id = fxs_id_sxc')
            ->join('src_servicio', 'src_id = sxc_id_src')
            ->join('cli_cliente', 'cli_id = fac_id_cli')  
            ->join('txs_telefonoxservicio', ' txs_id_sxc = sxc_id')
            ->where('txs_principal',1)
            ->where('paf_id_fac',$id_factura)
            ->group_by('paf_id') 
        ;
            
    } else
    if(!empty($id_cpl)){
        
        $this->db->select('paf_id, paf_numero AS correlativo, cli_codigo AS codigo, paf_total, NULL AS caja, fac_numero AS documento, src_nombre, cli_apellido, cli_nombre, cli_personeria, txs_numero, cpl_fecha_vencimiento AS mes_factura',false)
              ->from('paf_pago_factura')
              ->join('cpl_cuota_plan_pago', 'cpl_id = paf_id_cpl')
              ->join('plg_plan_pago', 'plg_id = cpl_id_plg')
              ->join('fxp_facturaxplan_pago', 'fxp_id_plg = plg_id')
              ->join('fac_factura', 'fac_id = fxp_id_fac')
              ->join('fxs_facturaxservicio', 'fxs_id_fac = fac_id')
              ->join('sxc_servicioxcliente', 'sxc_id = fxs_id_sxc')
              ->join('src_servicio', 'src_id = sxc_id_src')
              ->join('cli_cliente', 'cli_id = fac_id_cli')  
              ->join('txs_telefonoxservicio', ' txs_id_sxc = sxc_id')
              ->where('txs_principal',1)
              ->where('paf_id_cpl',$id_cpl)
              ->group_by('paf_id') 
          ;  

    }
    
    return $this->db->get()->row();

  }


  function get_numero_cliente($cliente){

    $query=" 
        SELECT cli_id, cdd_numero_origen from cli_cliente INNER JOIN sxc_servicioxcliente ON sxc_id_cli=cli_id
        INNER JOIN txs_telefonoxservicio on txs_id_sxc=sxc_id AND txs_principal=1
        INNER JOIN cdd_cdr_detalle on REPLACE(txs_numero,'-','') = cdd_numero_origen
        WHERE cli_id=".$cliente." 
        LIMIT 1
          ";
      
      $resultado=$this->db->query($query)->result_array();
      //die(print_r($this->db->last_query()));
      return $resultado;
     
  }

  function get_codigos_pais_excel($ppa_id=null, $codigo=null){
          $this->db->select("ppa_id, pai_nombre, ppa_fecha_efectiva, ppa_local, ppa_nombre, ppa_desde_codigo, ppa_comentario")
              ->from('ppa_parametro_pais')
              ->join('pai_pais', 'ppa_id_pai=pai_id')
              ->where("ppa_estado",1)
      ;

      if($codigo>0){ $this->db->where("ppa_desde_codigo like '".$codigo."%'"); }
      if($ppa_id>0){ $this->db->where('ppa_id',$ppa_id); }
      if($codigo==0 && $ppa_id==0){  $this->db->where('ppa_id',null); }
    
    return $this->db->get()->result_array();
  }
  
  function getTarifasCdrActivo($where)
  {
      $this->db->select('cdd_numero_origen, cdd_numero_destino, cdd_destino, cdd_id, cdd_id_coe, cdd_detalle_costo_factura, cdd_costo_unit, cdd_fecha_inicio, cdd_duracion_min, cdd_costo_total')
              ->from('cdd_cdr_detalle')
              ->join('cdr_resumen', 'cdr_id = cdd_id_cdr')
              ->where($where)
              ->order_by('cdd_numero_origen, cdd_fecha_inicio')
          ;
      return $this->db->get()->result_array();
  }
  
  function getDetalleCosto($where)
  {
      $this->db->select()
              ->from('cdd_cdr_detalle')
              ->join('coe_codigo_error', 'coe_id = cdd_id_coe','left')
              ->where($where)
          ;
      return $this->db->get()->row();
  }
          
  function get_minutosIncluidosEnFactura($fechaInicio, $fechaFin, $cliente, $factura)
  {
      $this->db->select('pln_minuto minutosIncluidos')
              ->from('fxs_facturaxservicio')
              ->join('sxc_servicioxcliente', 'sxc_id = fxs_id_sxc')
              ->join('pxl_plan_promoxcliente', 'pxl_id_sxc = sxc_id')
              ->join('pln_plan_promocion', 'pln_id = pxl_id_pln')
              ->join('pxp_parametro_paixplan', 'pxp_id_pln = pln_id')
              ->where('fxs_id_fac',$factura)
              ->where('sxc_id_cli',$cliente)
              ->where("DATE_FORMAT(sxc_fecha_contrato,'%Y-%m-%d') <=",$fechaInicio)
              ->where("DATE_FORMAT(pln_desde,'%Y-%m-%d') <=",$fechaFin)
              ->where('pln_estado',1)
              ->group_by('pln_id')
          ;
      return $this->db->get()->result_array();
  }
  
  function favoritosCliente($fechaInicio, $fechaFin)
  {
    $query=" 
        SELECT
	txp.txp_numero favorito,
	txs.txs_numero cliente,
	cdd_id

        FROM
            txp_telefonoxplan txp
        INNER JOIN pxl_plan_promoxcliente pxl ON pxl.pxl_id = txp.txp_id_pxl
        INNER JOIN sxc_servicioxcliente sxc ON sxc.sxc_id = pxl.pxl_id_sxc
        INNER JOIN txs_telefonoxservicio txs ON txs_id_sxc = sxc.sxc_id
        INNER JOIN cdd_cdr_detalle cdd ON LTRIM(LOWER(cdd.cdd_numero_origen)) = LTRIM(LOWER(REPLACE(txs.txs_numero,'-','')))	
                AND LTRIM(LOWER(cdd.cdd_numero_destino)) = LTRIM(LOWER(REPLACE(txp.txp_numero,'-','')))	
        WHERE 
            DATE_FORMAT(cdd.cdd_fecha_inicio,'%Y-%m-%d') >= '".$fechaInicio."' AND
            DATE_FORMAT(cdd.cdd_fecha_inicio,'%Y-%m-%d') <= '".$fechaFin."'     
        GROUP BY cdd_id
          ";
      
      return $this->db->query($query)->result_array();
  }

}
?>