<?php
/**
 * 
 */
class Sqlserver_model extends CI_Model
{

    /**
     * Gsatelite::__construct()
     * 
     * @return
     */
    private $db2;

    function __construct()
    {
        $this->db2 = $this->load->database('sqlserver', true);
        date_default_timezone_set('America/El_Salvador');
    }

    function get_all_vw_cli(){
        // $query = "SELECT * FROM CLIENTES";
        $query = "SELECT * FROM Fac_Vi_Clientes ";
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());
    }

    function get_all_vw_fac(){
        // $query = "SELECT * from RESUMEN_PAGOS";
        $query = "SELECT * from Fac_Vi_Resumen_Pagos ";
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());
    }

    /**
    * @author R.Escalante
    * @since 2024-05-01
    * @return datos de la vista segun where
     */
    function get_vw_fac_fechas($where_array = null){
        $where = "";
        // $query = "SELECT * from RESUMEN_PAGOS ";
        $query = "SELECT * from Fac_Vi_Resumen_Pagos ";
        if ($where_array) {
            $where = implode(" AND ", $where_array);
        }
        $query .= $where;
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());
    }

    function get_all_vw_defC($refpago = null){
        // $query = "SELECT * from DETALLE_PAGOS ";
        $query = "SELECT * from Fac_Vi_Detalle_Pagos ";
        if ($refpago) {
            $query .= "WHERE NUMERO_PAGO = '$refpago' ";
        }
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());
    }

    function get_vw_clifac($where_array = null, $fkcliente = null){
        $where = "";
        $cli_key = ($fkcliente) ? $fkcliente : "CODIGO_CLIENTE";
        $query = "SELECT Fac_Vi_Clientes.* FROM Fac_Vi_Resumen_Pagos JOIN Fac_Vi_Clientes ON Fac_Vi_Clientes.$cli_key = Fac_Vi_Resumen_Pagos.CODIGO_CLIENTE ";
        if ($where_array) {
            $where = implode(" AND ", $where_array);
        }
        $query .= $where;
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());
    }

    public function get_tabla($tabla){
        if(!$tabla && !is_string($tabla)){
            return null;
        }
        $query = "SELECT * FROM $tabla;";
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());
    }


    public function get_vw_fac_fechas_param($consulta = null, $where_array = null){
        $where = "";
        $query = ($consulta) ? "SELECT $consulta FROM Fac_Vi_Resumen_Pagos " : "SELECT * FROM Fac_Vi_Resumen_Pagos ";
        if ($where_array) {
            $where = implode(" AND ", $where_array);
        }
        $query .= $where;
        // var_dump($query);die();
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());
    }


/*

    function getArticuloxproveedor(){   
      //CREATE VIEW Vista_articuloxproveedor AS SELECT Articulo_Id codigo_articulo, Prov_Id codigo_proveedor, CONCAT(Articulo_Id , '-',Prov_Id) as artxprov FROM Articulo_x_Proveedor 
      $query = "SELECT * from Vista_articuloxproveedor";
      $result = $this->db2->query($query);
      return utf8_converter($result->result_array());
    }


    public function ingresar($tabla, $cadena,  $tipo = false)
    {
        if($tipo) { //insetar varios registros
            $this->db2->insert_batch($tabla, $cadena);
            return $this->db2->affected_rows();     //retornar la cantidad de registros insertados
        }else {
            $this->db2->insert($tabla, $cadena);
            return $this->db2->insert_id();
        }
    } 

     public function actualizar_array($tabla, $cadena, $condiciones)
    {
        $this->db2->where($condiciones);
        $this->db2->update($tabla, $cadena);
       // return $this->db2->affected_rows();
        return 1;
    }


    
    public function insert_traslado_SP($sucursal, $bodega, $usuario, $suc_destino, $bodega_destino, $ListaArticulosId, $ListaCantidades, $comentario = '')
    {

      if (!is_array($ListaArticulosId) || !is_array($ListaCantidades) || ( count($ListaArticulosId) != count($ListaCantidades) )) {
        return 'Lista de articulo y cantidades deben ser arrays, y de igual dimensión';
      }
      $ListaArticulosId = implode(',', $ListaArticulosId);
      $ListaCantidades = implode(',', $ListaCantidades);
      $respuesta = '';
      if ($this->db2->dbdriver == 'mysqli') { //para que no de error en vps
       $query =  $this->db->query("CALL Mov_Traslado_AP2(1,?,?,?,?,?,?,?,?,?);",array($sucursal,$bodega, $usuario, $suc_destino, $bodega_destino, $ListaArticulosId, $ListaCantidades, $comentario,$respuesta))->result();

      } else {  //conexión a MSSQL
      $query = $this->db2->query("EXEC Mov_Traslado_AP2 1,?,?,?,?,?,?,?,?",array($sucursal,$bodega, $usuario, $suc_destino, $bodega_destino, $ListaArticulosId, $ListaCantidades, $comentario))->result();
      }
      if ($query) 
      {
         $respuesta = $query;
      }

      if ($this->db2->dbdriver != 'mysqli') { //guardar la bitacora del traslado en nuetra base de datos.
        $respuesta_ = print_r($respuesta); //log
        //$query =  $this->db->query("CALL Mov_Traslado_AP2(1,?,?,?,?,?,?,?,?,?);",array($sucursal,$bodega, $usuario, $suc_destino, $bodega_destino, $ListaArticulosId, $ListaCantidades, $comentario,$respuesta))->result();
      }

      return $respuesta;
    }

    


*/

    // Defensoria SINCO
    public function getEmpleadosSinco($codigoEmpleadoSinco = null){
        if ($codigoEmpleadoSinco) {
            $query = "SELECT V_empleadosActivos.* FROM V_empleadosActivos WHERE IDEMPLEADO = {$codigoEmpleadoSinco}";
        } else {
            $query = "SELECT V_empleadosActivos.* FROM V_empleadosActivos";
        }

        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());        
    }

    // Defensoria SINCO
    public function getJefeArea($area = null){
        $query = "SELECT V_empleadosActivos.* FROM V_empleadosActivos WHERE IDSUBDIRECCION = {$area} AND JEFE = 1";
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());        
    }    

    public function actualizarEmpleadoMigrado($idEmpleadoSinco) {
        return $this->db2->query("EXEC sp_MigracionERP ?", array($idEmpleadoSinco));
    }

    // Método para comprobar la conexión
    public function check_connection() {
        // Si la conexión es exitosa, esto devuelve TRUE
        if ($this->db2->conn_id) {
            return true;
        } else {
            return false;
        }
    }

    public function getEmpleadoByCorreo($correo){
        $query = "SELECT V_empleadosActivos.* FROM V_empleadosActivos WHERE CORREO = {$correo}";
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());        
    }

}