<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class Sistema extends CI_Model
{

	function __construct()
	{
		$this->load->database();
		$this->lang->load('tank_auth');
	}

	public function cargar_menus($id,$nivel,$padre=0)
	{
		$where=array('opc_nivel'=>$nivel);
   		if($padre!=0)
   			$where=array('opc_padre'=>$padre);
		$this->db->select()
			->where('uxr_id_usu',$id)
      ->where('oxr_id_emr',$this->tank_auth->get_empresa_id())
			->from('uxr_usuarioxrol')
			->join('oxr_opcionxrol','oxr_id_rol=uxr_id_rol')
			->join('opc_opcion','opc_id=oxr_id_opc')
		  
      ->group_by('oxr_id_opc')
		    //->order_by('oxr_id')
                    ->order_by('opc_orden, opc_nombre')
		    ->where('opc_estado',1)
			->where($where);
		$query=$this->db->get();
		return $query->result_array();
   	}

   	public function cargar_menus0(){
   		$this->db->select()
   			->where('opc_nivel',0)
   			->from('opc_opcion')
   			->order_by('opc_orden')
   			->where('opc_estado',1);
		$query=$this->db->get();				
		return $query->result_array();   	
   	}

   	public function cargar_opciones($rol, $empresa)
   	{   		
   		$this->db->select()
   		->from('oxr_opcionxrol')
   		->join('opc_opcion','opc_id=oxr_id_opc')
   		->join('emr_empresa', 'oxr_id_emr = emr_id')
   		->where('opc_estado',1)
   		->where('oxr_id_rol',$rol)
   		->where('oxr_id_emr',$empresa)

   		->order_by('opc_orden, opc_nombre')
   		->group_by('oxr_id_opc');
   		$query=$this->db->get();
   		return $query->result_array();
   	}

   	public function add_opc($rol, $opc, $empresa){
   		$this->db->select('opc_id, opc_nombre, opc_nivel, opc_hijo')
   			->from('opc_opcion')
			->where('opc_id',$opc);			
		$query1=$this->db->get()->row_array();
			
   		if($query1['opc_nivel']=='1' && $query1['opc_hijo']=='1'){
   			$this->db->select('opc_id, opc_nombre,opc_nivel,opc_hijo')
   				->from('opc_opcion')
   				->where('opc_id',$opc)
   				->or_where('opc_padre',$opc);
   			$query2=$this->db->get()->result_array();

   			if(count($query2)>0){
   				foreach ($query2 as $key) {
   					$opc_array = array(
   						'oxr_id_rol'=>$rol,
   						'oxr_id_emr'=>$empresa,
   						'oxr_id_opc'=>$key['opc_id'],
   						'oxr_insertar'=>0,
   						'oxr_eliminar'=>0,
   						'oxr_editar'=>0,
   						'oxr_ver'=>0,
   						'oxr_estado'=>1,
   						'oxr_usu_creacion'=>$this->tank_auth->get_user_id(),
   						'oxr_usu_modificacion'=>$this->tank_auth->get_user_id(),
   						'oxr_fecha_creacion'=>date('Y-m-d H:i:s'),
   						'oxr_fecha_modificacion'=>date('Y-m-d H:i:s')
   					);   					
   					$this->db->insert('oxr_opcionxrol',$opc_array);
   				}
   			}
   		}else{
   			$opc_array = array(
   				'oxr_id_rol'=>$rol,
   				'oxr_id_emr'=>$empresa,
   				'oxr_id_opc'=>$opc,
   				'oxr_insertar'=>0,
   				'oxr_eliminar'=>0,
   				'oxr_editar'=>0,
   				'oxr_ver'=>0,
   				'oxr_estado'=>1,
   				'oxr_usu_creacion'=>$this->tank_auth->get_user_id(),
   				'oxr_usu_modificacion'=>$this->tank_auth->get_user_id(),
   				'oxr_fecha_creacion'=>date('Y-m-d H:i:s'),
   				'oxr_fecha_modificacion'=>date('Y-m-d H:i:s')
   			);   			
   			$this->db->insert('oxr_opcionxrol',$opc_array);
   		}
   		return $this->db->affected_rows();
   	}

	public function del_opc($rol,$opc, $empresa)
	{	
		$this->db->select('opc_id, opc_nombre, opc_nivel, opc_hijo')
			->from('opc_opcion')
			->where('opc_id',$opc);
			
		$query1=$this->db->get()->row_array();
			
			if($query1['opc_nivel']=='1' && $query1['opc_hijo']=='1'){
				
				$this->db->select('opc_id, opc_nombre,opc_nivel,opc_hijo')
						->from('opc_opcion')
						->where('opc_id',$opc)
						->or_where('opc_padre',$opc);

				$query2=$this->db->get()->result_array();

				if(count($query2)>0){
					foreach ($query2 as $key) {
						$this->db->delete('oxr_opcionxrol',array('oxr_id_rol'=>$rol,'oxr_id_emr'=>$empresa, 'oxr_id_opc'=>$key['opc_id']));
					}
				}
			}else{
				$this->db->delete('oxr_opcionxrol',array('oxr_id_rol'=>$rol,'oxr_id_emr'=>$empresa,'oxr_id_opc'=>$opc));
			}

		return $this->db->affected_rows();
	}

	public function del_registro($tabla,$where)
	{		
		$this->db->delete($tabla,$where);
		return $this->db->affected_rows();	
	}

   public function modulo_actual($modulo)
   {
   		$this->db->select()
			->where('opc_funcion',$modulo)
			->from('opc_opcion');
		$query=$this->db->get();		
		if($query->num_rows()>0)
			return $query->row_array();
		else 
			return array('opc_id'=>-1);
   }

   public function cargar_tabla($tabla,$where=null, $order=null)
   {   		
   	$this->db->select()->from($tabla);
		if($where){
			$this->db->where($where);
		}
    if($order){
      $this->db->order_by($order);
    }
		$query=$this->db->get();				
		return $query->result_array();   	
   }

   public function get_tabla($tabla,$where=0)
   {
		$this->db->select();
		if($where!=0)
		$this->db->where($where);
		$this->db->from($tabla);			
		$query=$this->db->get();
		return $query->result_array();
   }

   
   public function get_registro($tabla,$where)
   {   		
		$this->db->select()
			->where($where)
			->from($tabla);			
		$query=$this->db->get();
		return $query->row_array();
   }

   public function add_registro($tabla,$cadena)
   {   		
		$this->db->insert($tabla,$cadena);
		return $this->db->affected_rows();
   }

   public function mod_registro($tabla, $where, $set)
  {
    $this->db->where($where);
    $this->db->update($tabla, $set); 
   return $this->db->affected_rows(); 
  }

  public function refrescar_padre()
  {
  	$this->db->select()
				->from('reg_region');
	$query = $this->db->get();
    return $query->result_array();
  }

   public function obtenerNickUser($userID)
   {
       	$this->db->select('username')	
       		->where('id = '.$userID)
       		->from('users');
       	$query = $this->db->get();
       	return $query->row();
   }

   public function get_tabla_reg($tabla, $where=0, $campo='', $where2=0,$param=0)
    {
        //Obtiene todos los campos de una tabla con opcion a condicional WHERE

        $this->db->select();
       
        if($where!=0) {
         $this->db->where($where);
        }

        if($where2!=0) {
          $array_val=array();

          //Extrae la lista de regiones admitidas para el usuario
          foreach ($where2 as $key) {
            $array_val=array_merge($array_val,array(array_pop($where2)));
          }

          if($param!=0){
            $this->db->order_by("cam_nombre", "asc"); 
          }

          //Establece las condicionales de regiones
          $this->db->where_in($campo,$array_val);
        }

       $this->db->from($tabla);			
       $query=$this->db->get();

       return $query->result_array();
   }

   public function empleado_usuario($id_empleado=0)
   {
      $id_empleado = ($id_empleado > 0)? $id_empleado:0;
   		$query = $this->db->select()
   				->from('emp_empleado')
   				->where("(emp_estado = 1 or emp_id = $id_empleado) and emp_id not in (select usu_id_emp from users where usu_id_emp !=  $id_empleado )",null)
   				->get()->result_array();

   		return $query;

   }

  	public function vencimiento_password($usuario, $dias){
	    // SELECT
	    //   *, DATE_FORMAT(
	    //     date_add(usu_actualiza_contrasena, INTERVAL 30 DAY),
	    //     '%Y-%m-%d'
	    //   )
	    // FROM
	    //   users
	    // WHERE
	    //   username = 'admin'
	    // AND DATE_FORMAT(
	    //   date_add(usu_actualiza_contrasena, INTERVAL 1 DAY),
	    //   '%Y-%m-%d'
	    // ) < DATE(NOW())
	    $where = "username = '".$usuario."' AND DATE_FORMAT(date_add(usu_actualiza_contrasena, INTERVAL ".$dias." DAY), '%Y-%m-%d') < DATE(NOW())";
	    $query = $this->db->select()
	        ->from('users')
	        ->where($where)
	    ;
	    return $query->get()->result_array();
	}

	public function cargar_opcs_validas(){
		$query = $this->db->select('opc_id')
            ->from('opc_opcion')
            ->where('opc_nivel', 0)
            ->where('opc_estado', 1)
		;
		$result = $query->get()->result_array();
        $query_1 = $this->db->last_query();
        $nivel_cero = array_column($result, "opc_id");

        $query = $this->db->select('opc_id')
            ->from('opc_opcion')
            ->where('opc_nivel', 1)
            ->where('opc_estado', 1)
            ->where_in('opc_padre', $nivel_cero)
		;
        $result = $query->get()->result_array();
        $query_2 = $this->db->last_query();

        $query_final = "(" . $query_1 . ") UNION (" . $query_2 . ")";
        $resultado = $this->db->query($query_final);
        return $resultado->result_array();
	}








public function get_modulos()
{
    $query = $this->db
        ->distinct()
        ->select('cfp_modulo', FALSE)
        ->from('cfp_configuracion_formularios_pantalla')   // << forzado
        ->where('cfp_estado', 1)
        ->order_by('cfp_modulo', 'ASC')
        ->get();

    $modulos = array();
    foreach ($query->result() as $row) {
        if ($row->cfp_modulo !== '') $modulos[] = $row->cfp_modulo;
    }
    return $modulos;
}

public function get_formularios($modulo = null)
{
    $this->db->distinct();
    $this->db->select('cfp_formulario', FALSE);
    $this->db->from('cfp_configuracion_formularios_pantalla'); // << forzado
    $this->db->where('cfp_estado', 1);
    if (!empty($modulo)) {
        $this->db->where('cfp_modulo', $modulo);
    }
    $this->db->order_by('cfp_formulario', 'ASC');

    $query = $this->db->get();
    $formularios = array();
    foreach ($query->result() as $row) {
        if ($row->cfp_formulario !== '') $formularios[] = $row->cfp_formulario;
    }
    return $formularios;
}

public function listar($modulo = null, $formulario = null)
{
    $this->db->from('cfp_configuracion_formularios_pantalla'); // << forzado
    $this->db->where('cfp_estado', 1);

    if (!empty($modulo)) {
        $this->db->where('cfp_modulo', $modulo);
    }
    if (!empty($formulario)) {
        $this->db->where('cfp_formulario', $formulario);
    }

    $this->db->order_by('cfp_modulo, cfp_formulario, cfp_label', 'ASC');
    return $this->db->get()->result();
}



public function update_campo($id, $campo, $valor, $usuario = null)
    {
        $data = array(
            $campo => $valor,
            'cfp_fecha_modificacion' => date('Y-m-d H:i:s')
        );

        if ($usuario) {
            $data['cfp_usu_modificacion'] = $usuario;
        }

        $this->db->where('cfp_id', $id);
        return $this->db->update('cfp_configuracion_formularios_pantalla', $data);
    }





}

