<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class Seleccion_personal_model extends CI_Model
{

     function __construct()
    {
        parent::__construct();
    }

    public function get_solicitantes($where = null){
    	$this->db->select('
    			sle_codigo as cod,
    			sle_nombre as name,
    			sle_apellido as apellido,
    			plz_nombre as plaza,
    			sle_estado as estado,
                sle_id as id
    		')->from('sle_solicitante_empleo',false)->join('plz_plaza' ,'plz_id = sle_id_plz' ,'LEFT');
    		if ($where !== null) {
    			$this->db->where($where);
    		}
            $this->db->where('sle_estado <> 2');
    		return $this->db->get()->result_array();
    }	

    public function get_solicitantesxconcurso($where = null){
        $this->db->select('*')
                 ->from('sle_solicitante_empleo',false)
                 ->join('csp_concurso_xsolicitante_empleo' ,'csp_id_sle = sle_id','INNER')
                 ->join('cnp_concurso_plaza' ,'csp_id_cnp = cnp_id' ,'INNER');
            if ($where !== null) {
                $this->db->where($where);
            }
            return $this->db->get()->result_array();
    }   

    public function get_cantidad_plazas_ap($id){
        $this->db->select(
            'IFNULL(COUNT(csp_id_cnp),0) as total'
                ,false)
                 ->from('csp_concurso_xsolicitante_empleo')
                 ->where(array('csp_id_cnp' => $id,'csp_seleccionado' =>1))
                 ->group_by('csp_id_cnp');
        return $this->db->get()->result_array();
    }

    public function get_concursos($where = null){
        $this->db->select("*,
                IFNULL( GROUP_CONCAT( DISTINCT TRIM(CONCAT(pro_nombre,' ')) SEPARATOR ','),'' ) AS profeciones
            ",false)
             ->from('cnp_concurso_plaza')
             ->join('are_area','are_id = cnp_id_are','LEFT')
             ->join('pto_puesto','pto_id = cnp_id_pto', 'LEFT')
             ->join('plz_plaza','plz_id = cnp_id_plz','LEFT')
             ->join('tie_tipo_educacion','tie_id = cnp_id_tie','LEFT')
             ->join('ted_titulo_educacion',' ted_id = cnp_id_ted','LEFT')
             ->join('gen_genero','gen_id = cnp_id_gen','LEFT')
             ->join('pai_pais','pai_id = cnp_id_pai','LEFT')
             ->join('dep_departamento',' dep_id = cnp_id_dep','LEFT')
             ->join('tic_tipo_contrato',' tic_id = cnp_id_tic','LEFT')
             ->join('pxp_profesionxconcurso_plaza', 'pxp_id_cnp = cnp_id','LEFT')
             ->join('pro_profesion' ,'pro_id = pxp_id_pro','LEFT');
             if ($where !== null) {
                $this->db->where($where);
             }

             $this->db->group_by('cnp_id');
             return $this->db->get()->result_array();

    }	
    
}
/* End of file seleccion.php */
/* Location: ./application/models/ */