<?php
class Rpt_solicitado extends CI_model
{
	public function __construct()
	{
		parent::__construct();
	}

	public function obtenerApellidosPareja($llave)
	{
		$consultaNovio = "select per_persona.per_apellido as novio
							from per_persona
							where per_persona.per_id = 
							(
							select bod_boda.bod_id_novio from bod_boda where bod_boda.bod_id = ?
							)";
		$queryNovio = $this->db->query($consultaNovio, array($llave))->row();

		$consultaNovia = "select per_persona.per_apellido as novia
							from per_persona
							where per_persona.per_id = 
							(
							select bod_boda.bod_id_novia from bod_boda where bod_boda.bod_id = ?
							)";
		$queryNovia = $this->db->query($consultaNovia, array($llave))->row();
		$novio = ($queryNovio && $queryNovio->novio)? $queryNovio->novio : null;
		$novia = ($queryNovia && $queryNovia->novia)? $queryNovia->novia : null;
		return $novio.' - '.$novia;
	}

	public function obtenerDetalle($llave)
	{
		$consulta = "select 
					pro_producto.pro_codigo as codigo, 
					concat(mar_marca.mar_nombre, ' ', mod_modelo.mod_nombre, ' ', pro_producto.pro_nombre) as nombre,
					round((dbd_detalle_boda.dbd_cantidad*pro_producto.pro_precio_actual),2) as precio,

					if (dbd_detalle_boda.dbd_cantidad = (select count(dep_descargo_producto.dep_id) from dep_descargo_producto where dep_descargo_producto.dep_id_dbd = dbd_detalle_boda.dbd_id),
					'x', ' ') as estado
					from dbd_detalle_boda, mar_marca, mod_modelo, pro_producto
					where (dbd_detalle_boda.dbd_id_bod = ?)
					and (dbd_detalle_boda.dbd_id_pro = pro_producto.pro_id)
					and (pro_producto.pro_id_mod = mod_modelo.mod_id)
					and (mod_modelo.mod_id_mar = mar_marca.mar_id)
					order by codigo";
		$query = $this->db->query($consulta, array($llave))->result();
		$registros = ($query)? $query : null;
		return $registros;
	}

	public function obtenerTotalSolicitado($llave)
	{
		$consulta = "select 
					sum(round((dbd_detalle_boda.dbd_cantidad*pro_producto.pro_precio_actual),2)) as total_solicitado
					from dbd_detalle_boda, pro_producto
					where (dbd_detalle_boda.dbd_id_bod = ?)
					and (dbd_detalle_boda.dbd_id_pro = pro_producto.pro_id)";
		$query = $this->db->query($consulta, array($llave))->row();
		$total = ($query && $query->total_solicitado)? $query->total_solicitado : null;
		return $total;
	}

	public function obtenerTotalAcumulado($llave)
	{
		$consulta = "select 
					sum(round(pro.pro_precio_actual, 2)) as total_acumulado
					from dep_descargo_producto dep, pro_producto pro, dbd_detalle_boda dbd
					where dep.dep_id_dbd in
					(
					select dbd.dbd_id from dbd_detalle_boda dbd
					where dbd.dbd_id_bod = ?
					)
					and dep.dep_id_dbd = dbd.dbd_id
					and dbd.dbd_id_pro  = pro.pro_id";
		$query = $this->db->query($consulta, array($llave))->row();
		$total = ($query && $query->total_acumulado)? $query->total_acumulado : null;
		return $total;
	}
}
?>