<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class Registro_academico_model extends CI_Model
{

	function __construct()
	{
		$this->load->database();
	}

	// All your methods goes here

	public function contar_tabla($tabla,$where=null){
		if($where!=null){
			$this->db->where($where);
			$this->from($tabla);	
			$count = $this->db->count_all_results();
		}	
		else{
			$count = $this->db->count_all($tabla);
		}

		return $count;
	}

	public function obtener_grupos($where=NULL){
		$query = $this->db->select()
	        ->from('gra_grupo_academico')
	        ->join('pyc_proyeccion', 'pyc_id = gra_id_pyc')
	        ->join('ard_area_academica', 'pyc_id_ard = ard_id', 'left')
	        ->join('aul_aula','gra_id_aul = aul_id','left')
	       	->join('dct_docente','gra_id_dct = dct_id','left')
	       	->join('emp_empleado','emp_id = dct_id_emp','left')
	        ->join('frh_frecuencia_horario', 'frh_id = gra_id_frh', 'left')
            ->join('scc_seccion', 'scc_id=gra_id_scc', 'left')
	        ->join('pen_pensum','pen_id = gra_id_pen','left')
	        ->join('mod_modulo','mod_id = pen_id_mod','left')
	        ->join('grd_grado','gra_id_grd = grd_id','left')
	        ;

	      if($where!=null){
	            $this->db->where($where);
	      }
	      $this->db->order_by('gra_id', 'asc');
		  return $query->get()->result_array();    
	}

	public function obtener_alumnos($where=NULL, $group=null){
		$query = $this->db->select()
	        ->from('alm_alumno')
	        ->join('pro_profesion', 'pro_id = alm_id_pro','left')
	        ->join('lxa_alumnoxarea', 'lxa_id_alm = alm_id','left')
	        ->join('lxp_alumnoxpensum', 'lxa_id = lxp_id_lxa','left')
	        ->join('ard_area_academica', 'lxa_id_ard = ard_id','left')
	        ->join('gra_grupo_academico', 'lxp_id_gra = gra_id','left')
	        ->join('grd_grado', 'grd_id = gra_id_grd','left')
	        ->join('pen_pensum', 'pen_id = gra_id_pen','left')
	        ->join('mod_modulo', 'pen_id_mod = mod_id','left')
	        
	        ;
	      	
	      	if($where!=null){
	            $this->db->where($where);
	        }

	        if($group!=null){
	            $this->db->group_by($group);
	        }
	        $this->db->order_by('alm_id','desc');
	    return $query->get()->result_array();    
	}

	/**
     * Obtener Programas
     * 
     * @author Mario Marquez
     * @since 3/12/2015
     */
	public function obtener_programas($where=NULL){
		$query = $this->db->select('prg_programa_estudio.*')
					  ->from('prg_programa_estudio')
		;
		if($where!=null){
			$this->db->where($where);
		}

		return $query->get()->result_array();

	}

	public function obtener_nva_x_programa($where=null){
		$query = $this->db->select('nva_nivel_area_academ.*')
					  ->from('nva_nivel_area_academ')
					  ->join('ard_area_academica','ard_area_academica.ard_id_nva = nva_nivel_area_academ.nva_id','left')
					  ->join('prg_programa_estudio','prg_programa_estudio.prg_id_ard = ard_area_academica.ard_id','left');
		if($where!=null){
			$this->db->where($where);
		}

		$this->db->group_by('nva_nivel_area_academ.nva_id');
		 $num = $query->get()->result();
		if(count($num)>0){
			$opciones = '<option value="0">Seleccione</option>';
			foreach($num as $row){
				$opciones.= '<option value="'.$row->nva_id.'">'.$row->nva_nombre.'</option>';
			}
		}
		else{
			$opciones = '<option value=""></option>';
		}
		return $opciones;

		//return $query->get()->result();
	}

	public function obtener_modulos_x_nva($where=NULL){
		$query = $this->db->select('mod_modulo.*')
			->from('mod_modulo')
			->join('pen_pensum','pen_pensum.pen_id_mod=mod_modulo.mod_id','left')
			->join('ard_area_academica','ard_area_academica.ard_id=pen_pensum.pen_id_ard','left')
			->join('nva_nivel_area_academ','nva_nivel_area_academ.nva_id=ard_area_academica.ard_id_nva','left');
			if($where!=null){
	            $this->db->where($where);
	        }
	        $this->db->group_by('mod_modulo.mod_id');
			
	        $num = $query->get()->result();
	        if(count($num)>0){
	        	$opciones = '<option value="0">Seleccione</option>';
	        	foreach($num as $row){
	        		$opciones .=  '<option value="'.$row->mod_id.'">'.$row->mod_nombre.'</option>';
	        	}
	        }
	        else{
				$opciones = '<option value=""></option>';
			}
	        return $opciones;
	}

	/** 
	*@author Edith Herrera - Grupo Satélite
	*@return Dropdown o array de materias según pensum, de acuerdo al parámetro tipo.
	*@param  Se detallan a continuacion
	*	$where --------------> cualquier condicional enviada a la consula.
	*	$edit
	*	$where_not_in -------> Array de materias que NO deben ser incluidas.
	*	$where_in -----------> Array de materias que pueden ser incluidas.
	*	$pre_no -------------> Array de prerrequisitos que NO deben ser incluidos.
	*	$arr_drop -----------> Cuando se necesita un dropdown como respuesta.
	*	$tipo ---------------> tipo 1 para curso libre y tipo 2 para bachillerato. 
	*	$grupo --------------> Valida que la materia/curso esté asociada a un grupo. 
	**/
	public function obtener_pensum_x_ard($where=NULL, $edit=null, $where_not_in=null, $where_in=null, $pre_no=[], $arr_drop=null, $tipo = null, $grupo=null){
		
		$query = $this->db->select()
			->from('pen_pensum')
			->join('ard_area_academica','ard_id = pen_id_ard','inner')
			->join('mod_modulo','mod_id = pen_id_mod','inner')
		;

			if($grupo!=null){
				$this->db->join('gra_grupo_academico', 'pen_id = gra_id_pen', 'inner');
				$this->db->join('pyc_proyeccion', 'gra_id_pyc = pyc_id', 'inner');
				$this->db->join('pre_prerrequisito', 'pen_id = pre_id_pen', 'left');
				$this->db->join('grd_grado', 'grd_id = gra_id_grd', 'left');
			}else{
				$this->db->join('gra_grupo_academico', 'pen_id = gra_id_pen', 'left');
				$this->db->join('pre_prerrequisito', 'pen_id = pre_id_pen', 'left');
				$this->db->join('grd_grado', 'grd_id = gra_id_grd', 'left');
			}		
	
			if($where!=null){
	            $this->db->where($where);
	        }
	        $this->db->where('mod_estado',1);

	        if($where_not_in!=null && !empty($where_not_in)){
	            $this->db->where_not_in('pen_id', $where_not_in);
	        }

	        if($where_in!=null && !empty($where_in)){
	        	$where_i = implode(',', $where_in);
		        $this->db->where("(pen_id IN(".$where_i.") OR pre_id IS NULL)", null, FALSE);
	        }

	        if($arr_drop!=null && $pre_no!=null && !empty($pre_no)){
	        	$pre_n = implode(',', $pre_no); 

	        	$this->db->where("(pre_id_mod NOT IN(".$pre_n.") OR pre_id_mod IS NULL)", null, FALSE);
	        }

	        if($tipo!=null && $tipo==1){
	        	$this->db->where('gra_id_grd IS NULL', null, FALSE);
	        	$this->db->group_by('pen_id');
	        }else if($tipo!=null && $tipo==2){
	        	$this->db->where('gra_id_grd IS NOT NULL', null, FALSE);
	        	$this->db->group_by('gra_id_grd');
	        }else{
	        	$this->db->group_by('pen_id');
	        }

	        $this->db->order_by('mod_nombre');
	        $num = $query->get()->result();
	        if(count($num)>0){
	        	$opciones = "<option value=''></option>";
	        	foreach($num as $row){
	        		if($edit==$row->pen_id){
	        			$select="selected='selected'";
	        		}else{ $select=''; }

	        		if($tipo!=null && $tipo==1){
			        	$nombre = $row->mod_nombre;
						$grado = 0;
			        }else if($tipo!=null && $tipo==2){
			        	$nombre = $row->grd_nombre;
						$grado = $row->grd_id;
			        }else{
			        	$nombre = $row->mod_nombre;
			        	$grado = 0;
			        }
	        		if(is_array($pre_no) && count($pre_no)>0 && !in_array($row->pre_id_mod, $pre_no)){
	        			$opciones .=  "<option value='".$row->pen_id."' pen='".$row->pen_id."' grado='".$grado."' " .$select." >".$nombre."</option>";
	        		}else if(!is_array($pre_no) || count($pre_no)<=0){
	        			$opciones .=  "<option value='".$row->pen_id."' pen='".$row->pen_id."' grado='".$grado."' " .$select." >".$nombre."</option>";
	        		}
	        	}
	        }else{
				$opciones = "<option value=''></option>";
			}

			if($arr_drop!=null){
				return $num;
			}else{
	        	return $opciones;
			}
	}

	public function obtener_ard_x_pensum($where=NULL){
		$query = $this->db->select()
			->from('pen_pensum')
			->join('ard_area_academica','ard_area_academica.ard_id=pen_pensum.pen_id_ard','inner')
			->join('mod_modulo','mod_modulo.mod_id=pen_pensum.pen_id_mod','inner')
		;
			if($where!=null){
	            $this->db->where($where);
	        }
	        $this->db->group_by('pen_pensum.pen_id');
			
	        
			return $query->get()->result_array();
	}

	public function obtener_mat_x_lxp($where=NULL){
		$query = $this->db->select('*, (SELECT art_id_tia FROM art_articulo WHERE art_id = mod_id_art) AS id_tia, (SELECT alm_id_cli 
			FROM lxa_alumnoxarea JOIN alm_alumno  on alm_id = lxa_id_alm WHERE lxa_id = lxp_id_lxa) as id_cli ', false)
			->from('lxp_alumnoxpensum')
			->join('gra_grupo_academico','gra_id = lxp_id_gra')
			->join('pen_pensum','pen_id = gra_id_pen')
			->join('mod_modulo','mod_id = pen_id_mod')
		;
		if($where){
			$this->db->where($where);
		}
		$this->db->group_by('mod_id_art');	        
		return $query->get()->result_array();
	}

	public function obtener_programa_x_modulo($where=null){
		$query = $this->db->select('prg_programa_estudio.*')
				->from('prg_programa_estudio')
				->join('ard_area_academica','ard_area_academica.ard_id=prg_programa_estudio.prg_id_ard','left')
				->join('pen_pensum','pen_pensum.pen_id_ard=ard_area_academica.ard_id','left')
				->join('mod_modulo','mod_modulo.mod_id=pen_pensum.pen_id_mod','left');

		if($where!=null){
			$this->db->where($where);
		}

		$this->db->group_by('prg_programa_estudio.prg_id');
		
		$result = $query->get()->result();

		return $result[0]->prg_id;
	}

	public function obtener_nva_x_modulo($where=null){
		$query = $this->db->select('nva_nivel_area_academ.*')
				->from('nva_nivel_area_academ')
				->join('ard_area_academica','ard_area_academica.ard_id_nva=nva_nivel_area_academ.nva_id','left')
				->join('prg_programa_estudio','prg_programa_estudio.prg_id_ard=ard_area_academica.ard_id','left')
				->join('pen_pensum','pen_pensum.pen_id_ard=ard_area_academica.ard_id','left')
				->join('mod_modulo','mod_modulo.mod_id=pen_pensum.pen_id_mod','left');

		if($where!=null){
			$this->db->where($where);
		}

		$this->db->group_by('nva_nivel_area_academ.nva_id');
		
		$result = $query->get()->result();

		return $result[0]->nva_id;
	}

	function anexo_alumno($alm_id)
	{
	    $anexos = $this->db->select()
	    ->from('axl_anexoxalumno')
	    ->where('axl_id_alm',$alm_id)
	    ->where('axl_img_perfil',0);
	    
	    return $anexos->get()->result_array();
	}

	public function foto_alumno($alm_id)
	{
		$query = $this->db->select()
					->from('alm_alumno')
					->join('axl_anexoxalumno', 'axl_anexoxalumno.axl_id_alm = alm_id','left')
					->where('axl_img_perfil',1)
					->where('alm_id', $alm_id)
					;

		return $query->get()->result_array();			
	}

	public function editar_tel_alumno($id_alm)
	{
	$query = $this->db->select()
				->from('txa_telefonoxalumno')
				->join('tit_tipo_telefono', 'tit_tipo_telefono.tit_id = txa_id_tit','left')
				->where('txa_id_alm', $id_alm)
				;
	
	return $query->get()->result_array();    				
	}

	public function editar_doc_alumno($id_alm)
	{
		$query = $this->db->select()
						->from('dca_documento_alum')
						->join('tde_tipo_documento', 'tde_tipo_documento.tde_id = dca_id_tde','left')
						->where('dca_id_alm', $id_alm)
						;

		return $query->get()->result_array();
	}

	public function editar_alumno($id_alm)
	{
		$query = $this->db->select()
					->from('alm_alumno')
					->where('alm_id', $id_alm)
					;

		return $query->get()->row_array();
	}

	public function obtener_modulos($where=NULL){
		$query = $this->db->select()
			->from('mod_modulo');

			if($where!=null){
	            $this->db->where($where);
	        }
			return $query->get()->result_array();
	}

	public function obtener_proyecciones($where=NULL) {

		$query = $this->db->select("pyc.*, IF(pyc.pyc_id_ard IS NOT NULL, ard_pyc.ard_nombre, GROUP_CONCAT(ard_axy.ard_nombre SEPARATOR ', ')) as nombre_areas", FALSE)
			->from("pyc_proyeccion as pyc")
			->join("ard_area_academica as ard_pyc", "ard_pyc.ard_id = pyc.pyc_id_ard", "LEFT")
			->join("axy_areas_x_proyecion", "axy_id_pyc = pyc.pyc_id", "LEFT")
			->join("ard_area_academica as ard_axy", "ard_axy.ard_id = axy_id_ard", "LEFT")
		;

		if($where!=null){
			$this->db->where($where);
		}

		$this->db->group_by('pyc_id');

		return $query->get()->result_array();

	}

	public function obtener_requisitos($where=NULL){
		$query = $this->db->select('pre_id_mod_requisito')
			->from('pre_prerrequisito')
			;

		if($where!=null){
            $this->db->where($where);
	    }
		return $query->get()->result_array();
	}

	public function obtener_areas_x_alumno($where=null){
		$query = $this->db->select('ard_area_academica.*')
			->from('ard_area_academica')
			->join('lxa_alumnoxarea','lxa_alumnoxarea.lxa_id_ard=ard_area_academica.ard_id','left')
			->join('alm_alumno','alm_alumno.alm_id=lxa_alumnoxarea.lxa_id_alm','left')
		;

		if($where!=null){
			$this->db->where($where);
		}

		return $query->get()->result_array();
	}

	public function obtener_ard_sin_asingar($where=null,$campo=null,$not_in=null,$order_by=null){
		$query = $this->db->select('ard_area_academica.*')
			->from('ard_area_academica')
			->join('lxa_alumnoxarea','lxa_alumnoxarea.lxa_id_ard=ard_area_academica.ard_id','left')
			->join('alm_alumno','alm_alumno.alm_id=lxa_alumnoxarea.lxa_id_alm','left')
			->group_by('ard_id')
		;

		if($where!=null){
			$this->db->where($where);
		}

		if($campo!=null && $not_in!=null){
			$this->db->where_not_in($campo,$not_in);
		}

		if($order_by!=null){
			$this->db->order_by($order_by);
		}

		return $query->get()->result_array();
	}

	public function obtener_lxp_x_alumno($where=null){
		$query = $this->db->select()
			->from('lxp_alumnoxpensum')
			->join('lxa_alumnoxarea','lxa_alumnoxarea.lxa_id=lxp_alumnoxpensum.lxp_id_lxa','left')
			->join('gra_grupo_academico','gra_grupo_academico.gra_id=lxp_alumnoxpensum.lxp_id_gra','inner')
			//->join('hrg_horario_grupo','gra_grupo_academico.gra_id_hrg=hrg_horario_grupo.hrg_id','inner')	
			->join('pen_pensum','pen_pensum.pen_id=gra_grupo_academico.gra_id_pen','inner')
			->join('mod_modulo','mod_modulo.mod_id=pen_pensum.pen_id_mod','inner')
		;
		$this->db->where('lxp_estado',1);

		if($where!=null){
			$this->db->where($where);
		}
		return $query->get()->result_array();
	}

	public function facturas_registradas($id_alum)
	{
		$fac_estado = 1;
		$query = $this->db->select('fac_id')
			->from('alm_alumno')
			->join('cli_cliente','cli_id = alm_id_cli')
			->join('fac_factura','fac_id_cli = cli_id')
			->join('lxp_alumnoxpensum','fac_id=lxp_id_fac')
			;
	

		if($id_alum!=null){
			$this->db->where('alm_id', $id_alum);
		}
		$this->db->where('fac_estado', $fac_estado);
		$this->db->group_by('fac_id');

		 return $query->get()->result_array();
	}

	public function obtener_becado($id_alum)
	{
		$fac_estado = 1;
		$query = "SELECT DISTINCT alm_becado
			FROM alm_alumno
			left JOIN cli_cliente ON cli_id = alm_id_cli
			left JOIN fac_factura ON fac_id_cli = cli_id
			Where alm_id= ".$id_alum ;
		$result = $this->db->query($query);
		return $result->result_array();
	}

	public function obtener_modulos_no_aprobados($alum_id,$lxa_id){
			$query = "SELECT * FROM mod_modulo AS md INNER JOIN pen_pensum AS pen ON pen.pen_id_mod = md.mod_id 
			LEFT JOIN ard_area_academica AS ard ON ard.ard_id=pen.pen_id_ard INNER JOIN lxa_alumnoxarea AS lxa
			ON lxa.lxa_id_ard=ard.ard_id 
			WHERE lxa.lxa_id=".$lxa_id." AND md.mod_id IN
			(
				
				SELECT md.mod_id FROM mod_modulo AS md INNER JOIN pen_pensum AS pen 
				ON pen.pen_id_mod=md.mod_id INNER JOIN ard_area_academica AS ard
				ON ard.ard_id=pen.pen_id_ard INNER JOIN lxa_alumnoxarea AS lxa
				ON lxa.lxa_id_ard=ard.ard_id
				WHERE lxa.lxa_id=".$lxa_id." AND pen.pen_id NOT IN 
				(
					SELECT pen.pen_id FROM pen_pensum AS pen INNER JOIN lxp_alumnoxpensum AS lxp
					ON lxp.lxp_id_pen=pen.pen_id WHERE lxp.lxp_condicion IN (1,2) AND lxp.lxp_id_lxa = ".$lxa_id."
				)
			)	AND md.mod_estado=1  GROUP BY md.mod_id"
			;

		$result = $this->db->query($query);

		return $result->result_array();
	}

	public function obtener_pensum_sin_prerequisito($lxa_id){
		$query = "SELECT pen.* FROM pen_pensum AS pen INNER JOIN ard_area_academica AS ard
				ON ard.ard_id=pen.pen_id_ard INNER JOIN lxa_alumnoxarea AS lxa
				ON lxa.lxa_id_ard=ard.ard_id WHERE lxa.lxa_id=".$lxa_id." AND pen.pen_id NOT IN 
				(
					SELECT pen.pen_id FROM pre_prerrequisito AS pre LEFT JOIN pen_pensum AS pen 
					ON pen.pen_id=pre.pre_id_pen INNER JOIN ard_area_academica AS ard
					ON ard.ard_id=pen.pen_id_ard INNER JOIN lxa_alumnoxarea AS lxa 
					ON lxa.lxa_id_ard=ard.ard_id WHERE lxa.lxa_id=".$lxa_id."
				)
				AND pen.pen_id NOT IN 
				(
					SELECT lxp.lxp_id_pen FROM lxp_alumnoxpensum AS lxp WHERE lxp.lxp_condicion IN(1,2) AND lxp.lxp_id_lxa=".$lxa_id."
				)
				OR 
				pen.pen_id IN 
				(
					SELECT pen.pen_id FROM pen_pensum AS pen LEFT JOIN pre_prerrequisito AS pre 
					ON pre.pre_id_pen = pen.pen_id INNER JOIN mod_modulo AS md ON md.mod_id=pen.pen_id_mod WHERE pre.pre_id_mod IN 
					(
						SELECT md.mod_id FROM lxp_alumnoxpensum AS lxp 
						INNER JOIN pen_pensum as pen ON pen.pen_id=lxp.lxp_id_pen
						LEFT JOIN mod_modulo AS md ON md.mod_id = pen.pen_id_mod
						WHERE  lxp.lxp_condicion IN (2) AND lxp.lxp_id_lxa = ".$lxa_id."
					)
				)
				"
		;

		$result = $this->db->query($query);

		return $result->result_array();
	}

	public function obtener_materias_no_cursadas($alum_id,$lxa_id){
		$query = "SELECT * FROM mod_modulo AS md INNER JOIN pen_pensum AS pen ON pen.pen_id_mod = md.mod_id 
			LEFT JOIN ard_area_academica AS ard ON ard.ard_id=pen.pen_id_ard INNER JOIN lxa_alumnoxarea AS lxa
			ON lxa.lxa_id_ard=ard.ard_id INNER JOIN gra_grupo_academico AS gra ON gra.gra_id_pen = pen.pen_id
			WHERE lxa.lxa_id=".$lxa_id." AND md.mod_id IN
			( 
				SELECT md.mod_id FROM mod_modulo AS md INNER JOIN pen_pensum AS pen 
				ON pen.pen_id_mod=md.mod_id INNER JOIN ard_area_academica AS ard
				ON ard.ard_id=pen.pen_id_ard INNER JOIN lxa_alumnoxarea AS lxa
				ON lxa.lxa_id_ard=ard.ard_id
				WHERE pen.pen_id NOT IN 
				(
					SELECT pen.pen_id FROM pen_pensum AS pen INNER JOIN gra_grupo_academico AS gra 
					ON gra.gra_id_pen = pen.pen_id INNER JOIN lxp_alumnoxpensum AS lxp
					ON lxp.lxp_id_gra=gra.gra_id WHERE gra.gra_id NOT IN (SELECT lxp.lxp_id_gra FROM lxp_alumnoxpensum AS lxp WHERE lxp.lxp_id_lxa=".$lxa_id." 
						AND lxp.lxp_condicion NOT IN (1,2))
				)
				AND lxa.lxa_id=".$lxa_id." AND md.mod_estado=1
			)";
	}

	public function obtener_prerrequisitos($where){
		$this->db->select();
		$this->db->from('pen_pensum');
		$this->db->join('pre_prerrequisito','pre_prerrequisito.pre_id_pen = pen_pensum.pen_id','inner');
		$this->db->join('mod_modulo','mod_modulo.mod_id = pre_prerrequisito.pre_id_mod','inner');
		
		if($where!=null){
			$this->db->where($where);
		}

		return $this->db->get()->result_array();
	}

	public function validar_prerrequisito($where=null,$campo=null,$type=null,$not_in=null){
		/*$query  = $this->db->select()
			->from('mod_modulo')
			->join('pen_pensum','pen_pensum.pen_id_mod = mod_modulo.mod_id','inner')
			->join('lxp_alumnoxpensum','lxp_alumnoxpensum.lxp_id_pen = pen_pensum.pen_id','inner')
		;*/

		$query = $this->db->select()
			 	->from('lxp_alumnoxpensum')
			 	->join('gra_grupo_academico','gra_grupo_academico.gra_id = lxp_alumnoxpensum.lxp_id_gra','inner')
			 	->join('pen_pensum','pen_pensum.pen_id = gra_grupo_academico.gra_id_pen','inner')
		;

		if($where!=null){
			$this->db->where($where);	
		}

		if($type == 'not'){
			if($campo!=null && $not_in!=null){
				$this->db->where_not_in($campo,$not_in);
			}	
		}
		else if ($type == 'in'){
			if($campo!=null && $not_in!=null){
				$this->db->where_in($campo,$not_in);
			}
		}
		

		return $query->get()->result_array();
	}


	public function get_AlumnosxAreaAcademica($where=null,$dropdown=null){
		$query = $this->db->select()
			->from('alm_alumno')
			->join('lxa_alumnoxarea','lxa_alumnoxarea.lxa_id_alm=alm_alumno.alm_id','inner')
			->join('ard_area_academica','ard_area_academica.ard_id=lxa_alumnoxarea.lxa_id_ard','inner')
		;

		if($where!=null){
			$this->db->where($where);
		}

		if($dropdown!=null){
			$data =  $query->get()->result();

			if(count($data)>0){
				$result = '<option value="0">Seleccione</option>';

				foreach ($data as $opc) {
					$result.= '<option value="'.$opc->alm_id.'">'.$opc->alm_nombre." ".$opc->alm_apellido.'</option>';
				}
			}
			else{
				$result = "<option></option>";
			}
		}
		else{
			$result = $query->get()->result_array();
		}

		return $result;
	}

	public function get_ModulosxAlumno($where=null){
		
		$query = $this->db->select()
			->from('lxa_alumnoxarea')
			->join('alm_alumno','alm_alumno.alm_id = lxa_alumnoxarea.lxa_id_alm','inner')
			->join('lxp_alumnoxpensum','lxp_alumnoxpensum.lxp_id_lxa = lxa_alumnoxarea.lxa_id','inner')
			->join('noa_nota_alumno','noa_nota_alumno.noa_id_lxp = lxp_alumnoxpensum.lxp_id','left')
			->join('pen_pensum','pen_pensum.pen_id = lxp_alumnoxpensum.lxp_id_pen','inner')
			->join('mod_modulo','mod_modulo.mod_id = pen_pensum.pen_id_mod','inner')
		;

		if($where!=null){
			$this->db->where($where);
		}

		return $query->get()->result_array();
	}

	public function get_GruposAcademicosxArea($where=null,$dropdown=null){
		$query = $this->db->select()
			->from('gra_grupo_academico')
			->join('pen_pensum','pen_pensum.pen_id=gra_grupo_academico.gra_id_pen','inner')
			->join('mod_modulo','mod_modulo.mod_id=pen_pensum.pen_id_mod','inner')
			->join('ard_area_academica','ard_area_academica.ard_id=pen_pensum.pen_id_ard','inner')
			->join('hrg_horario_grupo', 'hrg_id = gra_id_hrg','left')
			->join('aul_aula', 'aul_id = gra_id_aul','left')
		;

		if($where!=null){
			$this->db->where($where);
		}

		if($dropdown!=null){
			$data =  $query->get()->result();

			if(count($data)>0){
				$result = '<option value=""></option>';

				foreach ($data as $gra) {
					$result.= '<option value="'.$gra->gra_id.'" data-mod="'.$gra->mod_nombre.'" >'.$gra->gra_nombre.'</option>';
				}
			}
			else{
				$result = '<option value=""></option>';
			}
		}
		else{
			$result = $query->get()->result_array();
		}

		return $result;
	}

	/**
	 * Utilizado también para el informe de notas
	 * @author Edith Herrera 
	 * @since  2018-04-10
	 * @return Información del alumno 
	**/
	public function get_AlumnosxGruposAcademicos($where=null, $dropdown=null, $group=null, $order=null){
		$query = $this->db->select("alm_id, alm_codigo, alm_nombre, alm_apellido, gra_nombre, mod_id, mod_nombre, pev_nombre, evm_porcentaje, evm_fecha_inicio, evm_fecha_fin, noa_nota, noa_observacion, noa_id, tev_nombre, evm_porcentaje,  pyc_fecha_limite_nota, evm_fecha_inicio, evm_fecha_fin, lxp_id, evm_id, IFNULL(lxp_promedio,0) AS promedio, evm_fecha_max_nota, gra_id_grd, gra_id, scc_nombre, pen_id, pyc_id, pyc_id_ard, evm_porcentaje_periodo, lxa_id", FALSE)
			->from('alm_alumno')
			->join('lxa_alumnoxarea','lxa_id_alm=alm_id','inner')
			->join('lxp_alumnoxpensum','lxp_id_lxa=lxa_id','inner')
			->join('gra_grupo_academico','gra_id = lxp_id_gra','inner')
			->join('pen_pensum','pen_id=gra_id_pen','inner')
			->join('mod_modulo','mod_id=pen_id_mod','inner')
			->join('evm_evaluacion_modulo','evm_id_pen = pen_id','inner')
			->join('pev_periodo_evaluacion','evm_id_pev = pev_id','inner')
			->join('tev_tipo_evaluacion','evm_id_tev = tev_id','inner')
			->join('pyc_proyeccion', 'evm_id_pyc = pyc_id AND gra_id_pyc = pyc_id', 'inner')
			->join('noa_nota_alumno','evm_id = noa_id_evm AND noa_id_lxp = lxp_id','left')
			->join('scc_seccion','scc_id = gra_id_scc ','left')
			->where('lxp_estado', 1)
		;
			

		if($where!=null){
			$this->db->where($where);
		}

		/*************** Se construye un dropdown de alumnos o un array como resultado según parámetros ******************/
		if($dropdown!=null){
					 $this->db->group_by('alm_id');
			$data =  $query->get()->result();

			if(count($data)>0){
				$result = '<option value=""></option>';

				foreach ($data as $value) {
					$result.= '<option value="'.$value->alm_id.'">'.$value->alm_nombre.' '.$value->alm_apellido.'</option>';
				}
			}
			else{
				$result = "<option></option>";
			}
		}else{
			if($group!=null){
				$this->db->group_by($group);
			}else{
				$this->db->group_by('evm_id, alm_id');
			}

			if($order!=null){
				$this->db->order_by($order, 'ASC');
			}else{
				$this->db->order_by('alm_id');
			}
			$result = $query->get()->result_array();
		}

		return $result;
	}

	public function get_NotasxAlumno($where=null){
		$query = $this->db->select()
			->from('noa_nota_alumno')
			->join('lxp_alumnoxpensum','lxp_id = noa_id_lxp','inner')
			->join('lxa_alumnoxarea','lxa_id = lxp_id_lxa','inner')
			->join('ard_area_academica','lxa_id_ard = ard_id','inner')
			->join('gra_grupo_academico','lxp_id_gra = gra_id','inner')
			->join('evm_evaluacion_modulo','gra_id_pen = evm_id_pen AND evm_id = noa_id_evm','inner')
		;

		if($where!=null){
			$this->db->where($where);
		}

		$this->db->group_by('noa_id');
		$this->db->order_by('evm_orden', 'asc');

		return $query->get()->result_array();
	}

	public function alumo_becado_cmc($where = null){
		$query = $this->db->select("apb_porcentaje, apb_inicio_beneficio, slb_id_alm, slb_id_pen, slb_id_frh, slb_id_ard, slb_id_tpb, slb_id_tbs")
			->from('apb_aprobacion_beca')
			->join('slb_solicitud_beca','slb_id = apb_id_slb')
			->join('tbf_tipo_beneficio','tbf_id = apb_id_tbf')
		;
		if($where){
			$this->db->where($where);
		}
		return $query->get()->row_array();
	}

	public function buscar_cmc_becados($where = null){
		$query = $this->db->select('cmc_cargo_alumnoxcurso.*, (SELECT art_id_tia FROM art_articulo WHERE art_id = mod_id_art) AS id_tia', false)
			->from('cmc_cargo_alumnoxcurso')
			->join('lxp_alumnoxpensum','lxp_id = cmc_id_lxp')
			->join('lxa_alumnoxarea','lxa_id = lxp_id_lxa')
			->join('gra_grupo_academico','gra_id = lxp_id_gra')
			->join('pen_pensum','pen_id = gra_id_pen')
			->join('mod_modulo','mod_id = pen_id_mod')
			->where('cmc_estado', 1)
			->where('lxp_estado', 1)
			->where('gra_estado', 1)
			->where('lxa_estado', 1)
		;
		if($where){
			$this->db->where($where);
		}
		return $query->get()->result_array();
	}

	public function obtener_info_grupos($fecha_ini=null, $fecha_fin=null, $programa=null, $where=null, $alumno=null, $group=null){
			$this->db->distinct()
		 	->select('ard_nombre as Nivel,mod_nombre as Modulo,mod_id, gra_fecha_inicio as Fecha, pre_id, alm_id,gra_id,alm_codigo as Codigo, alm_becado, frh_nombre, CONCAT(alm_nombre,space(1),alm_apellido) AS Participante, 
							gra_nombre as Grupo, lxp_id as lxp_id, lxp_condicion as condicion, ard_nombre, emp_nombre, emp_apellido, gen_nombre, pro_prefijo_m, pro_prefijo_f, pen_id, gra_id_pyc, lxp_promedio, ard_nota_minima AS minima, pen_aplica_diploma, pen_num_horas, gra_nombre, aul_nombre, alm_codigo, alm_nombre, alm_apellido, ard_id', false)
			->from('ard_area_academica')
			->join('pen_pensum','pen_id_ard=ard_id')
			->join('mod_modulo','mod_id=pen_id_mod')
			->join('gra_grupo_academico','gra_id_pen=pen_id')
			->join('frh_frecuencia_horario', 'frh_id=gra_id_frh')
			->join('lxp_alumnoxpensum','lxp_id_gra=gra_id')
			->join('lxa_alumnoxarea','lxp_id_lxa=lxa_id')
			->join('alm_alumno','alm_id=lxa_id_alm')
			->join('pre_prerrequisito','pre_id_mod=mod_id', 'left')
			->join('dct_docente', 'gra_id_dct=dct_id', 'left')
			->join('emp_empleado', 'dct_id_emp=emp_id', 'left')
			->join('pro_profesion', 'emp_id_pro=pro_id', 'left')
			->join('gen_genero', 'emp_id_gen=gen_id', 'left')
			->join('aul_aula', 'gra_id_aul=aul_id', 'left')
			->where('lxp_estado', 1)
		;

		if($fecha_ini != null && $fecha_fin != null ){
			$this->db->where('date_format(gra_fecha_inicio, "%Y-%m-%d") >= date_format("'.$fecha_ini.'", "%Y-%m-%d")', null, FALSE);
			$this->db->where('date_format(gra_fecha_inicio, "%Y-%m-%d") <= date_format("'.$fecha_fin.'", "%Y-%m-%d")', null, FALSE);	
		}
		if($programa!=null && $programa > 0){
			$this->db->where('ard_id', $programa);	
		}
		if($where!=null){
			$this->db->where($where);
		}
		if($alumno!=null && !is_array($alumno)){
			$this->db->where('alm_id', $alumno);
		}

		if($group!=null){
			$this->db->group_by($group);
		}
		
		$this->db->order_by('gra_nombre');

		return $this->db->get()->result_array();
	}


	public function obtener_alumnos_grupos($programa=null, $where=null){
		$this->db->distinct()
		 ->select('ard_nombre as Nivel,mod_nombre as Modulo,gra_fecha_inicio as Fecha, alm_id,gra_id,
							CONCAT(hrg_inicio,"-",hrg_fin) as Horario,alm_codigo as Codigo, 
							CONCAT(alm_nombre,space(1),alm_apellido) AS Participante, 
							gra_nombre as Grupo, lxp_id as lxp_id, lxp_condicion as condicion, alm_estado, lxa_id, lxp_exam_ubicacion,lxp_id_crt, lxp_id_fac, lxp_id_def, lxp_observacion, lxp_promedio', false)
			->from('ard_area_academica')
			->join('pen_pensum','pen_id_ard=ard_id')
			->join('mod_modulo','mod_id=pen_id_mod')
			->join('gra_grupo_academico','gra_id_pen=pen_id')
			->join('lxp_alumnoxpensum','lxp_id_gra=gra_id')
			->join('lxa_alumnoxarea','lxp_id_lxa=lxa_id')
			->join('alm_alumno','alm_id=lxa_id_alm')
			->join('pre_prerrequisito','pre_id_mod=mod_id', 'left')
			->join('hrg_horario_grupo','hrg_id=gra_id_hrg', 'left')
			->order_by('alm_nombre','asc')
			->group_by('alm_id')
		;
		
		if($programa!=null && $programa > 0){
			$this->db->where('ard_id', $programa);	
		}
		if($where!=null){
			$this->db->where($where);
		}
		
		$this->db->order_by('gra_nombre');

		return $this->db->get()->result_array();
	}

	public function onbtener_info_grupo_individual($gra_id, $alm_id)
	{
		$this->db->distinct()
		 ->select('ard_nombre AS Nivel,alm_id,gra_id, mod_nombre AS Modulo, gra_fecha_inicio AS Fecha, gra_horario AS Horario, alm_codigo AS Codigo, CONCAT( alm_nombre, space(1), alm_apellido) AS Participante, gra_nombre AS Grupo, lxp_id AS lxp_id, lxp_condicion AS condicion', false)
			->from('ard_area_academica')
			->join('pen_pensum','pen_id_ard=ard_id')
			->join('mod_modulo','mod_id=pen_id_mod')
			->join('gra_grupo_academico','gra_id_pen=pen_id')
			->join('lxp_alumnoxpensum','lxp_id_gra=gra_id')
			->join('lxa_alumnoxarea','lxp_id_lxa=lxa_id')
			->join('alm_alumno','alm_id=lxa_id_alm')
			->join('pre_prerrequisito','pre_id_mod=mod_id', 'left')
			->where('gra_id', $gra_id);
	$this->db->where('alm_id',$alm_id)
			->order_by('alm_nombre','asc');
		return $this->db->get()->result_array();
	}
	
	public function grupos_modulo($where){
		
		$query = $this->db->select('ard_nombre as Nivel, mod_nombre as Modulo, gra_fecha_inicio as fecha, gra_nombre as Grupo, ard_edad_maxima as edad_maxima, ard_edad_minima as edad_minima,
							(
								SELECT COUNT(*) FROM alm_alumno AS alm 
								INNER JOIN lxa_alumnoxarea AS lxa ON lxa.lxa_id_alm = alm_id
								INNER JOIN lxp_alumnoxpensum AS lxp ON lxp.lxp_id_lxa = lxa_id
								WHERE lxp_id_gra = gra_id AND alm_becado = 1 AND lxp_estado=1
							) as becados,
							(
								SELECT COUNT(*) FROM alm_alumno AS alm 
								INNER JOIN lxa_alumnoxarea AS lxa ON lxa.lxa_id_alm = alm_id
								INNER JOIN lxp_alumnoxpensum AS lxp ON lxp.lxp_id_lxa = lxa_id
								WHERE lxp_id_gra = gra_id AND alm_becado = 0 AND lxp_estado=1
							) as no_becados,
							(SELECT COUNT(*) FROM alm_alumno 
										INNER JOIN lxa_alumnoxarea ON lxa_id_alm = alm_id
										WHERE lxa_id_ard = ard_id AND lxa_estado=1
									) as alumnos_inscritos',false)
			->from('ard_area_academica')
			->join('pen_pensum','pen_id_ard=ard_id')
			->join('mod_modulo','mod_id=pen_id_mod')
			->join('gra_grupo_academico','gra_id_pen=pen_id')
			->where($where)
			->order_by('ard_nombre')
		;

		return $query->get()->result_array();
	}

	public function reporte_listado_alumno($where=null){
		$query = $this->db->select()
				->from('alm_alumno')
				->join('mun_municipio','mun_municipio.mun_id = alm_alumno.alm_id_mun','left')
				->join('dep_departamento','dep_departamento.dep_id = mun_municipio.mun_id_dep','left')
				->join('esc_estado_civil','esc_estado_civil.esc_id = alm_alumno.alm_id_esc','left')
				->join('pro_profesion','pro_profesion.pro_id = alm_alumno.alm_id_pro','left')
				->join('fin_financiamiento','fin_financiamiento.fin_id = alm_alumno.alm_id_fin','left')
				->order_by('alm_id','desc')
		;

		if($where!=null){
			$this->db->where($where);
		}
		$this->db->where('alm_estado', 1);

		return $query->get()->result_array();
	}

	public function reporte_listado_alumno_individual($alm_id_fin=null, $alm_id=null){
		$query = $this->db->select()
				->from('alm_alumno')
				->join('mun_municipio','mun_municipio.mun_id = alm_alumno.alm_id_mun','left')
				->join('dep_departamento','dep_departamento.dep_id = mun_municipio.mun_id_dep','left')
				->join('esc_estado_civil','esc_estado_civil.esc_id = alm_alumno.alm_id_esc','left')
				->join('pro_profesion','pro_profesion.pro_id = alm_alumno.alm_id_pro','left')
				->join('fin_financiamiento','fin_financiamiento.fin_id = alm_alumno.alm_id_fin','left')
			;
			if($alm_id_fin!=null){
				$this->db->where('alm_id_fin', $alm_id_fin);
			}
			
			if($alm_id_fin!=null){
				$this->db->where('alm_id', $alm_id);
			}
				$this->db->order_by('alm_id','desc');

		return $query->get()->result_array();
	}

	/**
	* Función uitlizada en los reportes de causa de retiro (Prolingua) y alumnos retirados (CCSA)
	**/
	public function reporte_causas($where=null, $order_by=null){
		$query = $this->db->select("IF(gra_id_grd IS NULL,gra_nombre,grd_nombre) AS grupo, gra_nombre, alm_id,gra_id, alm_codigo, alm_nombre, alm_apellido, crt_nombre, lxp_observacion, DATE_FORMAT (lxp_fecha_retiro, '%d-%m-%Y') AS lxp_fecha_retiro1, pyc_nombre, ard_nombre, mod_nombre", FALSE )
				->from('lxp_alumnoxpensum')
				->join('crt_causa_retiro','crt_causa_retiro.crt_id = lxp_alumnoxpensum.lxp_id_crt','inner')
				->join('lxa_alumnoxarea','lxa_alumnoxarea.lxa_id = lxp_alumnoxpensum.lxp_id_lxa','inner')
				->join('alm_alumno','alm_alumno.alm_id = lxa_alumnoxarea.lxa_id_alm','inner')
				->join('gra_grupo_academico','lxp_alumnoxpensum.lxp_id_gra = gra_grupo_academico.gra_id','inner')
				->join('pyc_proyeccion', 'gra_id_pyc=pyc_id', 'inner')
				->join('ard_area_academica', 'pyc_id_ard=ard_id', 'inner')
				->join('pen_pensum', 'pen_id=gra_id_pen', 'inner')
				->join('mod_modulo', 'pen_id_mod=mod_id', 'inner')
				->join('mun_municipio','mun_id = alm_id_mun','left')
				->join('dep_departamento','dep_id = mun_id_dep','left')
				->join('grd_grado','gra_id_grd = grd_id','left')
		;

		if($where!=null){
			$this->db->where($where);
		}
		
		$this->db->group_by('alm_id, grupo');
		$this->db->order_by('alm_nombre');
		return $query->get()->result_array();
	}


	public function reporte_causas_alumnos(){
		$query = $this->db->select("gra_nombre, alm_id,gra_id, alm_codigo, alm_nombre, alm_apellido, crt_nombre, lxp_observacion, DATE_FORMAT (lxp_fecha_retiro, '%d-%m-%Y') AS lxp_fecha_retiro1", FALSE )
				->from('lxp_alumnoxpensum')
				->join('crt_causa_retiro','crt_causa_retiro.crt_id = lxp_alumnoxpensum.lxp_id_crt','inner')
				->join('lxa_alumnoxarea','lxa_alumnoxarea.lxa_id = lxp_alumnoxpensum.lxp_id_lxa','inner')
				->join('alm_alumno','alm_alumno.alm_id = lxa_alumnoxarea.lxa_id_alm','inner')
				->join('gra_grupo_academico','lxp_alumnoxpensum.lxp_id_gra = gra_grupo_academico.gra_id','inner')
				->join('mun_municipio','mun_municipio.mun_id = alm_alumno.alm_id_mun','left')
				->join('dep_departamento','dep_departamento.dep_id = mun_municipio.mun_id_dep','left')
				->where('lxp_fecha_retiro IS NOT NULL', null, FALSE)
				->group_by('alm_id')
		;


		$this->db->order_by('alm_nombre');
		return $query->get()->result_array();
	}


	public function reporte_causas_individual($gra_id, $alm_id){
		$query = $this->db->select("gra_nombre, alm_id,gra_id, alm_codigo, alm_nombre, alm_apellido, crt_nombre, lxp_observacion, DATE_FORMAT (lxp_fecha_retiro, '%d-%m-%Y') AS lxp_fecha_retiro1", FALSE )
				->from('lxp_alumnoxpensum')
				->join('crt_causa_retiro','crt_causa_retiro.crt_id = lxp_alumnoxpensum.lxp_id_crt','inner')
				->join('lxa_alumnoxarea','lxa_alumnoxarea.lxa_id = lxp_alumnoxpensum.lxp_id_lxa','inner')
				->join('alm_alumno','alm_alumno.alm_id = lxa_alumnoxarea.lxa_id_alm','inner')
				->join('gra_grupo_academico','lxp_alumnoxpensum.lxp_id_gra = gra_grupo_academico.gra_id','inner')
				->join('mun_municipio','mun_municipio.mun_id = alm_alumno.alm_id_mun','left')
				->join('dep_departamento','dep_departamento.dep_id = mun_municipio.mun_id_dep','left')
				->where('gra_id', $gra_id);
	   $this->db->where('alm_id', $alm_id);

		return $query->get()->result_array();
	}

	public function obtener_docentes($where=null,$order_by=null){
		$query = $this->db->select()
			->from('dct_docente')
			->join('emp_empleado','emp_id = dct_id_emp','inner')
			->order_by('dct_id','desc')
		;

		if($where!=null){
			$this->db->where($where);
		}

		if($order_by!=null){
			$this->db->order_by($order_by);
		}

		return $query->get()->result_array();
	}

	public function get_info_grupo($gra_id=null){
		$query=$this->db->select('emp_nombre, emp_apellido, aul_nombre, gra_fecha_inicio, gra_fecha_fin, CONCAT(hrg_inicio,"-",hrg_fin) as Horario, gra_nombre, ard_nombre, mod_nombre, pyc_nombre', FALSE)
				 ->from('gra_grupo_academico')
				 ->join('aul_aula', 'gra_id_aul=aul_id')
				 ->join('ard_area_academica', 'gra_id_ard=ard_id')
				 ->join('pyc_proyeccion', 'gra_id_pyc = pyc_id')
				 ->join('pen_pensum', 'gra_id_pen = pen_id', 'left')
				 ->join('mod_modulo', 'pen_id_mod = mod_id', 'left')
				 ->join('dct_docente', 'gra_id_dct=dct_id', 'left')
				 ->join('emp_empleado', 'dct_id_emp=emp_id', 'left')
				 ->join('hrg_horario_grupo','hrg_id=gra_id_hrg','left')
				 ->where('gra_id', $gra_id)
				 ->get();

		return $query->row();
	}

	public function get_modulo_siguiente($where=null){
				$query=$this->db->select('mod_nombre as materia')
				 ->from('pre_prerrequisito')
				 ->join('pen_pensum', 'pre_id_pen=pen_id')
				 ->join('mod_modulo', 'mod_id=pen_id_mod');

				if($where!=null){
				   $this->db->where($where);
				}
				
				$result=$query->get()->row();

				return $result;
	}
	public function obtenerCodigo($cod_alumno, $opc = null){
		$query= $this->db->select('MAX(alm_id) AS resul')
				 	 ->from('alm_alumno')
		;
		if($opc != null){
			//$this->db->like('alm_codigo', $cod_alumno);
		} else{
			$this->db->like('alm_codigo', $cod_alumno, 'after');
		}
	 	return $query->get()->result_array();
		/*$result=$query->get()->row();
		return $result;*/
	}

	//verifica si existe el codigo en la base
	public function verificar_codigo($where = null){
		$query = $this->db->select('COUNT(alm_codigo) AS resultado')
				 	 	->from('alm_alumno')
		;
		if($where!=null){
		   $this->db->where($where);
		}
	 	return $query->get()->result_array();
		/*
		SELECT COUNT(alm_codigo) as resultado from alm_alumno where alm_codigo = "20170026"

		$result=$query->get()->row();
		return $result;*/
	}

	public function obtener_pensum_nivel($where)
	{
	   $this->db->select('ard_nombre as Area,modl.mod_nombre as Modulo, 
	pen_uni_valorativa as UV,pre.mod_nombre as nombre');

	        $this->db->from('ard_area_academica ');

	        $this->db->join('pen_pensum', 'pen_id_ard=ard_id');

	        $this->db->join('mod_modulo modl', 'modl.mod_id=pen_id_mod ');


	        $this->db->join('pre_prerrequisito', 'pre_id_pen=pen_id', 'left');

	       $this->db->join('mod_modulo pre', 'pre.mod_id=pre_id_mod', 'left');
	         $this->db->where($where);
	        
	        $query = $this->db->get();

	        
	        return $query->result_array();
	}

	public function get_moduloxarea($area=null){
		 	$this->db->select();
	        $this->db->from('pen_pensum');
	        $this->db->join('mod_modulo ', 'mod_id=pen_id_mod');
	        
	        if($area!=null){
	        	$this->db->where('pen_id_ard',$area);
	        }

	        $this->db->group_by('mod_id');
	        
	        $query = $this->db->get();
	        
	        return $query->result_array();
	}
	//Cambia los horarios del select al cambiar alguno de los select de area o nivel
	public function get_horarioxarea($where = null){
		 	$this->db->select('hrg_id, hrg_inicio, hrg_fin');
	        $this->db->from('gra_grupo_academico');
	        $this->db->join('hrg_horario_grupo ','gra_id_hrg=hrg_id');
	        $this->db->join('pen_pensum','gra_id_pen=pen_id');
	        $this->db->join('ard_area_academica','ard_id=pen_id_ard');
	        if($where!=null){
	        	$this->db->where($where);
	        }
	        //$this->db->group_by('mod_id');
	        $this->db->order_by('hrg_inicio', 'asc');
	        $query = $this->db->get();
	        return $query->result_array();
	}

	public function unidades_modulo($mod_id)
	{
		$this->db->select('*')
				 ->from('mod_modulo')
				 ->join('uxm_unidadxmodulo', 'uxm_id_mod = mod_id')
				 ->join('unm_unidad_modulo', 'unm_id = uxm_id_unm')
				 ->where('mod_id',$mod_id);
		$this->db->where('uxm_estado',1);
		$query = $this->db->get();
		return $query->result_array();
	}

	public function get_ultimo_id()
	{
		$this->db->select('max(gra_id) as id_gra')
					->from('gra_grupo_academico');
					$query = $this->db->get();
		return $query->result_array();
	}

public function unidades_grupo($id_grupo)
	{
		$this->db->select('*')
				 ->from('gra_grupo_academico')
				 ->join('uxg_uni_grupo', 'uxg_id_gra = gra_id')
				 ->join('unm_unidad_modulo', 'unm_id = uxg_id_unm')
				 ->where('gra_id',$id_grupo);
		$this->db->where('uxg_estado',1);
		$query = $this->db->get();
		return $query->result_array();
	}

/*	public function docente_grupo($id_grupo)
	{
		$this->db->select('emp_nombre, emp_apellido')
				 ->from('gra_grupo_academico')
				 ->join('dct_docente', 'dct_id = gra_id_dct')
				 ->join('emp_empleado', 'emp_id = dct_id_emp')
				 ->where('gra_id',$id_grupo);
		//$this->db->where('uxg_estado',1);
		$query = $this->db->get();
		return $query->result_array();
	}

	public function modulo_grupo($id_grupo)
	{
		$this->db->select('mod_nombre')
				 ->from('gra_grupo_academico')
				 ->join('pen_pensum', 'pen_id = gra_id_pen')
				 ->join('mod_modulo', 'mod_id = pen_id_mod')
				 ->where('gra_id',$id_grupo);
		//$this->db->where('uxg_estado',1);
		$query = $this->db->get();
		return $query->result_array();
	}
	public function horario_grupo($id_grupo)
	{
		$this->db->select('hg_nombre')
				 ->from('gra_grupo_academico')
				 ->join('hg_horario_grupo', 'hg_id = gra_id_hg')
				 ->where('gra_id',$id_grupo);
		//$this->db->where('uxg_estado',1);
		$query = $this->db->get();
		return $query->result_array();
	}

	public function cargarUnidades_grupo($id_grupo)
	{
		$this->db->select('unm_id, unm_nombre')
				 ->from('gra_grupo_academico')
				 ->join('pen_pensum', 'pen_id = gra_id_pen')
				 ->join('mod_modulo', 'mod_id = pen_id_mod')
				 ->join('uxm_unidadxmodulo', 'uxm_id_mod = mod_id')
				 ->join('unm_unidad_modulo', 'unm_id = uxm_id_unm')
				 ->where('gra_id',$id_grupo);
		//$this->db->where('uxg_estado',1);
		$query = $this->db->get();
		return $query->result_array();
	} */

	

	public function grupos_por_area($area, $modulo=null)
	{
		$this->db->select('mod_nombre, gra_id, gra_nombre, gra_horario, gra_fecha_inicio, gra_fecha_fin, gra_fecha_peruno, gra_fecha_perdos, CONCAT( emp_nombre,space(1), emp_apellido ) AS docente' )
				 ->from('ard_area_academica') 
				 ->join('pen_pensum', 'pen_id_ard = ard_id')
				 ->join('gra_grupo_academico', 'gra_id_pen = pen_id')
				 ->join('mod_modulo', 'mod_id = pen_id_mod')
				 ->join('dct_docente', 'dct_id = gra_id_dct')
				 ->join('emp_empleado', 'emp_id = dct_id_emp')
				 ->where('pen_id_ard',$area);
		if ($modulo!=null) {
			$this->db->where('mod_id',$modulo);
		}
		$this->db->order_by('mod_nombre');
		//$this->db->where('uxg_estado',1);
		$query = $this->db->get();
		return $query->result_array();
	}

	public function alumos_por_grupo($area, $modulo=null)
	{
		$this->db->select('gra_id, alm_becado, COUNT(alm_becado) AS total')
				 ->from('ard_area_academica')
				 ->join('pen_pensum', 'pen_id_ard = ard_id')
				 ->join('gra_grupo_academico', 'gra_id_pen = pen_id')
				 ->join('mod_modulo', 'mod_id = pen_id_mod')
				 ->join('dct_docente', 'dct_id = gra_id_dct')
				 ->join('emp_empleado', 'emp_id = dct_id_emp')
				 ->join('lxp_alumnoxpensum', 'lxp_id_gra = gra_id', 'left')
				 ->join('lxa_alumnoxarea', 'lxa_id = lxp_id_lxa', 'left')
				 ->join('alm_alumno', 'alm_id = lxa_id_alm')
				 ->where('pen_id_ard',$area);
		if ($modulo!=null) {
			$this->db->where('mod_id',$modulo);
		}
		$this->db->group_by('gra_id,alm_becado')
				 ->order_by('gra_id','asc');
		$this->db->order_by('alm_becado','desc');
		//$this->db->where('uxg_estado',1);
		$query = $this->db->get();
		return $query->result_array();
	}

	public function id_grupos_por_area($area, $modulo=null)
	{
		$this->db->select('gra_id')
				 ->from('ard_area_academica')
				 ->join('pen_pensum', 'pen_id_ard = ard_id')
				 ->join('gra_grupo_academico', 'gra_id_pen = pen_id')
				 ->join('mod_modulo', 'mod_id = pen_id_mod')
				 ->join('dct_docente', 'dct_id = gra_id_dct')
				 ->join('emp_empleado', 'emp_id = dct_id_emp')
				 ->join('lxp_alumnoxpensum', 'lxp_id_gra = gra_id', 'left')
				 ->join('lxa_alumnoxarea', 'lxa_id = lxp_id_lxa', 'left')
				 ->join('alm_alumno', 'alm_id = lxa_id_alm')
				 ->where('pen_id_ard',$area);
		if ($modulo!=null) {
			$this->db->where('mod_id',$modulo);
		}
		$this->db->group_by('gra_id, alm_becado')
				 ->order_by('alm_becado','desc');
		//$this->db->where('uxg_estado',1);
		$query = $this->db->get();
		return $query->result_array();
	}

	public function unidades_grupo_x_area($area)
	{
		$this->db->select('gra_id, unm_nombre')
				 ->from('ard_area_academica')
				 ->join('pen_pensum', 'pen_id_ard = ard_id')
				 ->join('gra_grupo_academico', 'gra_id_pen = pen_id')
				 ->join('mod_modulo', 'mod_id = pen_id_mod')
				 ->join('uxm_unidadxmodulo', 'uxm_id_mod = mod_id')
				 ->join('unm_unidad_modulo', 'unm_id = uxm_id_unm')
				 ->where('pen_id_ard',$area)
				 ->order_by('gra_id, unm_nombre');
		//$this->db->where('uxg_estado',1);
		$query = $this->db->get();
		return $query->result_array();
	}


	public function ig_grupo_unidades_grupo_x_area($area)
	{
		$this->db->select('gra_id')
				 ->from('ard_area_academica')
				 ->join('pen_pensum', 'pen_id_ard = ard_id')
				 ->join('gra_grupo_academico', 'gra_id_pen = pen_id')
				 ->join('mod_modulo', 'mod_id = pen_id_mod')
				 ->join('uxm_unidadxmodulo', 'uxm_id_mod = mod_id')
				 ->join('unm_unidad_modulo', 'unm_id = uxm_id_unm')
				 ->where('pen_id_ard',$area)
				 ->group_by('gra_id')
				 ->order_by('gra_id, unm_nombre');
		//$this->db->where('uxg_estado',1);
		$query = $this->db->get();
		return $query->result_array();
	}

	public function cargarUnidades_grupo($id_grupo)
	{
		$this->db->select('unm_id, unm_nombre')
				 ->from('gra_grupo_academico')
				 ->join('pen_pensum', 'pen_id = gra_id_pen')
				 ->join('mod_modulo', 'mod_id = pen_id_mod')
				 ->join('uxm_unidadxmodulo', 'uxm_id_mod = mod_id')
				 ->join('unm_unidad_modulo', 'unm_id = uxm_id_unm')
				 ->where('gra_id',$id_grupo);
		//$this->db->where('uxg_estado',1);
		$query = $this->db->get();
		return $query->result_array();
	}

	public function obtener_info_grupos_certificados($where=null, $alumno_in=null){
		$this->db->distinct()
		 ->select('ard_nombre as Nivel, ard_id_ard_padre as padre, pyc_ultima_fecha_pago as fecha_pago, md.mod_id, md.mod_nombre as Modulo, md.mod_codigo as curso, sm.mod_nombre as siguiente_mod, ROUND(AVG(noa_nota),1) prom, SUM(ROUND(noa_nota*(evm_porcentaje/100), 1)) as Promedio, gra_fecha_inicio as Fecha, alm_id, alm_codigo, alm_apellido, alm_nombre, alm_codigo_nie, gra_id, CONCAT(hrg_inicio,"-",hrg_fin) as Horario,alm_codigo as Codigo, pre_id, CONCAT(alm_nombre,space(1),alm_apellido) AS Participante, gra_nombre as Grupo, lxp_id as lxp_id, lxp_condicion as condicion, ard_id_trd, ard_nota_minima, ard_codigo, pen_id, pen_num_horas, alm_id, gra_id_pyc, lxp_promedio, CONCAT(emp_nombre,space(1),emp_apellido) AS docente, frh_descripcion, pen_id_mod_siguiente, (SELECT lip_precio FROM art_articulo INNER JOIN lip_listado_precio ON lip_id_art = art_id WHERE md.mod_id_art = art_id ) as precio_art', false)
			->from('ard_area_academica')
			->join('pyc_proyeccion', 'ard_id = pyc_id_ard')
			->join('pen_pensum','pen_id_ard = ard_id')
			->join('mod_modulo as md','md.mod_id = pen_id_mod')
			->join('gra_grupo_academico','gra_id_pen = pen_id')
			->join('lxp_alumnoxpensum','lxp_id_gra = gra_id')
			->join('dct_docente', 'gra_id_dct = dct_id')
			->join('emp_empleado', 'dct_id_emp = emp_id')
			->join('frh_frecuencia_horario', 'gra_id_frh = frh_id')
			->join('lxa_alumnoxarea','lxp_id_lxa = lxa_id')
			->join('alm_alumno','alm_id=lxa_id_alm')
			->join('noa_nota_alumno', 'noa_id_lxp = lxp_id')
			->join('evm_evaluacion_modulo', 'gra_id_pen = evm_id_pen AND evm_id = noa_id_evm ')
			->join('mod_modulo AS sm', 'sm.mod_id = pen_id_mod_siguiente', 'left')
			->join('pre_prerrequisito','pre_id_mod = md.mod_id', 'left')
			->join('hrg_horario_grupo','hrg_id=gra_id_hrg','left')
			->order_by('alm_nombre','asc');
		
		if($where!=null){
			$this->db->where($where);
		}
		if($alumno_in!=null && $alumno_in!='null'){
			$this->db->where_in('alm_id',$alumno_in);
		}
		$this->db->group_by('mod_id,gra_id, alm_id, lxp_id');
		$this->db->order_by('gra_nombre');
		return $this->db->get()->result_array();
	}

	public function get_modulo_siguiente_certificado(){
		$this->db->select('mod_nombre as materia, pre_id')
				 ->from('pre_prerrequisito')
				 ->join('pen_pensum', 'pre_id_pen=pen_id')
				 ->join('mod_modulo', 'mod_id=pen_id_mod')
				 ->group_by('pre_id');
				return $this->db->get()->result_array();
	}

	public function get_materia_siguiente ()
	{
		$this->db->select(' mod_id, mod_nombre, pre_id, pre_id_mod, pre_id_pen')
				 ->from('mod_modulo')
				 ->join('pen_pensum', 'pen_id_mod = mod_id')
				 ->join('pre_prerrequisito', 'pre_id_pen = pen_id')
				 ->group_by('pre_id');

		return $this->db->get()->result_array();
	}

	public function get_horarios_x_area($where = null){
		$query = $this->db->select("ard_nombre AS Nivel, mod_nombre AS Modulo, frh_id, CONCAT_WS('-',frh_nombre,frh_descripcion) AS horario", false)
			->from('ard_area_academica')
			->join('pen_pensum', 'pen_id_ard = ard_id','inner')
			->join('mod_modulo', 'mod_id = pen_id_mod','inner')
			->join('gra_grupo_academico', 'gra_id_pen = pen_id','inner')
			->join('frh_frecuencia_horario', 'gra_id_frh = frh_id')
            ->order_by('frh_nombre','asc')
		;

		if($where!=null){
			$this->db->where($where);
		}

		$this->db->group_by('frh_id');

		return $query->get()->result_array();
	}

	public function get_gruposacademicos_area($where = null){

		$query = $this->db->select("
			ard_nombre AS Nivel,
			mod_id,
			mod_nombre AS Modulo,
            mod_descripcion AS descripcion,
			gra_fecha_inicio AS fecha,
			gra_nombre AS Grupo,
			gra_id,
			aul_nombre AS aula,
			emp_nombre,emp_apellido,
            frh_id,
			CONCAT_WS('-',frh_nombre,frh_descripcion) AS Horario,
			(SELECT GROUP_CONCAT(art_nombre) FROM cma_combo_articulo JOIN art_articulo ON art_id = cma_id_art_combo WHERE cma_id_art = modulo.mod_id_art) AS libros", false)
			->from('ard_area_academica')
			->join('pen_pensum','pen_id_ard = ard_id','inner')
			->join('mod_modulo AS modulo','modulo.mod_id = pen_id_mod','inner')
			->join('gra_grupo_academico','gra_id_pen = pen_id','inner')
			->join('frh_frecuencia_horario', 'gra_id_frh = frh_id')
			->join('dct_docente','dct_id = gra_id_dct','left')
			->join('emp_empleado','emp_id = dct_id_emp','left')
			->join('aul_aula','aul_id = gra_id_aul','left')
		;

		if($where!=null){
			$this->db->where($where);
		}
        $this->db->order_by('ard_id', 'asc');
        $this->db->order_by('mod_nombre', 'asc');
		return $query->get()->result_array();
	}
	
	function obtener_habilidad($where = null){
		$query = $this->db->select()
              ->from('hab_habilidad')
              ->where('hab_estado',1);
        if($where != null){
        	$this->db->where($where);
        }
      	return $query->get()->result_array();
	}

	function obtener_grupo_habilidad($where = null){
		$query = $this->db->select()
              ->from('grh_grupo_habilidad')
              ->where('grh_estado',1);
        if($where != null){
        	$this->db->where($where);
        }
      	return $query->get()->result_array();
	}

	public function obtener_facturas_resp($where, $facturas_reg=null){
		/*
			SELECT fac_id, fac_numero, alm_nombre
			FROM alm_alumno
			INNER JOIN cli_cliente ON cli_id = alm_id_cli
			INNER JOIN fac_factura ON fac_id_cli = cli_id
			INNER JOIN def_detalle_fact ON def_id_fac = fac_id
			INNER JOIN art_articulo ON def_id_art = art_id
			INNER JOIN tia_tipo_articulo ON art_id_tia = tia_id
			LEFT JOIN lxp_alumnoxpensum ON lxp_id_fac = fac_id
			INNER JOIN mod_modulo ON mod_id_art = art_id
			where alm_id = 27
		*/
		$fac_estado = 2; //Factura pagada
		$query = $this->db->select('fac_id, fac_numero, lxp_id_fac')
			->from('alm_alumno')
			->join('cli_cliente','cli_id = alm_id_cli','inner')
			->join('fac_factura','fac_id_cli = cli_id','inner')
			->join('def_detalle_fact','def_id_fac = fac_id','inner')
			->join('art_articulo','art_id = def_id_art','inner')
			->join('tia_tipo_articulo','tia_id = art_id_tia','inner')
			->join('lxp_alumnoxpensum', 'lxp_id_fac = fac_id', 'left')
			->join('mod_modulo', 'mod_id_art = art_id', 'inner')
			;
	
		//$this->db->where('tia_id', $cat_inscripcion);
		$this->db->where('fac_estado', $fac_estado);

		if($where!=null){
			$this->db->where('alm_id', $id_alum);
		}

		/*if($facturas_reg!=null){
			$this->db->where_not_in('fac_id',$facturas_reg);
		}*/
		
		return $query->get()->result_array();
	}

	public function obtener_facturas($where, $group_by = null, $facturas_reg=null){
		/*
			SELECT fac_id, fac_numero, lxp_id_def, mod_nombre
			FROM alm_alumno
			INNER JOIN cli_cliente ON cli_id = alm_id_cli
			INNER JOIN fac_factura ON fac_id_cli = cli_id

			INNER JOIN def_detalle_fact ON def_id_fac = fac_id
			INNER JOIN art_articulo ON def_id_art = art_id
			INNER JOIN tia_tipo_articulo ON art_id_tia = tia_id

			LEFT JOIN lxp_alumnoxpensum ON lxp_id_fac = fac_id and lxp_id_def = def_id
			LEFT JOIN gra_grupo_academico ON gra_id = lxp_id_gra
			INNER JOIN mod_modulo ON mod_id_art = art_id
			
			INNER JOIN pen_pensum ON pen_id_mod = mod_id

			where alm_id = 27 and fac_id = 11265 and lxp_id_def is null and pen_id_ard = 37
			GROUP BY fac_id

			SELECT
				fac_id,
				fac_numero,
				lxp_id_def,
				mod_nombre,
				lxp_condicion,
				mod_id,
				(
					SELECT
						lxp_condicion
					FROM
						lxp_alumnoxpensum AS lxp_alumxpen
					INNER JOIN gra_grupo_academico AS gra_grupo ON gra_grupo.gra_id = lxp_alumxpen.lxp_id_gra
					INNER JOIN pen_pensum AS pen_pen ON pen_pen.pen_id = gra_grupo.gra_id_pen
					WHERE
						pen_pen.pen_id_mod = mod_id and gra_grupo.gra_id = gra_id
				)
			FROM
				alm_alumno
			INNER JOIN cli_cliente ON cli_id = alm_id_cli
			INNER JOIN fac_factura ON fac_id_cli = cli_id
			INNER JOIN def_detalle_fact ON def_id_fac = fac_id
			INNER JOIN art_articulo ON def_id_art = art_id
			INNER JOIN tia_tipo_articulo ON art_id_tia = tia_id
			LEFT JOIN lxp_alumnoxpensum ON lxp_id_def = def_id
			LEFT JOIN gra_grupo_academico ON gra_id = lxp_id_gra
			INNER JOIN mod_modulo ON mod_id_art = art_id
			INNER JOIN pen_pensum ON pen_id_mod = mod_id
			LEFT JOIN pre_prerrequisito ON pre_id_pen = pen_id
			WHERE
				alm_id = 27
			AND pen_id_ard = 37
			AND lxp_id_def is null
		*/
		$fac_estado = 2; //Factura pagada
		$campos = '	fac_id,
					fac_numero,
					lxp_id_def,
					mod_nombre,
					pen_id,
					ard_id, 
					alm_id,
					(SELECT MIN(lxp.lxp_condicion) FROM lxp_alumnoxpensum as lxp WHERE lxp.lxp_id = lxp_id and lxp.lxp_id_fac = fac_id LIMIT 1) lxp_condicion,
					mod_id,
					GROUP_CONCAT(mod_id) as id_mod,
					GROUP_CONCAT(DISTINCT pre_id_mod) as prereq,
					gra_id,
				COUNT(fac_id) as products,
				GROUP_CONCAT((
					SELECT
						GROUP_CONCAT(CONCAT_WS("-",detalle_fac.def_id_art, lxp_alumxpen.lxp_condicion))
					FROM
						lxp_alumnoxpensum AS lxp_alumxpen
					INNER JOIN def_detalle_fact AS detalle_fac ON detalle_fac.def_id = lxp_alumxpen.lxp_id_def
					INNER JOIN fac_factura as factura_con ON factura_con.fac_id = detalle_fac.def_id_fac
					WHERE
						detalle_fac.def_id_art = art_id
						AND factura_con.fac_id_cli = cli_id
					ORDER BY lxp_alumxpen.lxp_id desc
				)) as condicion,
				GROUP_CONCAT((
					SELECT
						GROUP_CONCAT(CONCAT_WS("-",detalle_fac2.def_id_art, lxp_alumxpen2.lxp_condicion, modulo.mod_id))
					FROM
						lxp_alumnoxpensum AS lxp_alumxpen2
					INNER JOIN def_detalle_fact AS detalle_fac2 ON detalle_fac2.def_id = lxp_alumxpen2.lxp_id_def
					INNER JOIN mod_modulo AS modulo ON modulo.mod_id_art = detalle_fac2.def_id_art
					INNER JOIN fac_factura as factura_con2 ON factura_con2.fac_id = detalle_fac2.def_id_fac
					WHERE
						modulo.mod_id = pre_id_mod
						AND factura_con2.fac_id_cli = cli_id
					ORDER BY lxp_alumxpen2.lxp_id desc
				)) AS condicion2,
				GROUP_CONCAT((
						SELECT
							GROUP_CONCAT(CONCAT_WS("-",pen_pre.pen_id_mod, pre2.pre_id_mod))
						FROM
							pen_pensum AS pen_pre
						left JOIN pre_prerrequisito AS pre2 ON pre2.pre_id_pen = pen_pre.pen_id
						WHERE
							pen_pre.pen_id_mod = mod_id
					)) AS condicion3';
		if($group_by == null || $group_by == 'def_id'){
			$campos = 'fac_id,
				fac_numero,
				lxp_id_def,
				mod_nombre,
				lxp_condicion,
				def_id,
				pen_id,
				ard_id, 
				alm_id,
				mod_id,
				(
					SELECT
						lxp_condicion
					FROM
						lxp_alumnoxpensum AS lxp_alumxpen
					INNER JOIN def_detalle_fact AS detalle_fac ON detalle_fac.def_id = lxp_alumxpen.lxp_id_def
					INNER JOIN fac_factura as factura_con ON factura_con.fac_id = detalle_fac.def_id_fac
					WHERE
						detalle_fac.def_id_art = art_id
						AND factura_con.fac_id_cli = cli_id
					ORDER BY lxp_alumxpen.lxp_id desc LIMIT 1
				) as condicion,
				(
					SELECT
						lxp_condicion
					FROM
						lxp_alumnoxpensum AS lxp_alumxpen2
					INNER JOIN def_detalle_fact AS detalle_fac2 ON detalle_fac2.def_id = lxp_alumxpen2.lxp_id_def
					INNER JOIN mod_modulo AS modulo ON modulo.mod_id_art = detalle_fac2.def_id_art
					INNER JOIN fac_factura as factura_con2 ON factura_con2.fac_id = detalle_fac2.def_id_fac
					WHERE
						modulo.mod_id = pre_id_mod
						AND factura_con2.fac_id_cli = cli_id
					ORDER BY lxp_alumxpen2.lxp_id desc LIMIT 1
				) AS condicion2,
	(
		SELECT
			pre2.pre_id_mod
		FROM
			pen_pensum AS pen_pre
		LEFT JOIN pre_prerrequisito AS pre2 ON pre2.pre_id_pen = pen_pre.pen_id
		WHERE
			pen_pre.pen_id_mod = mod_id LIMIT 1
	) AS condicion3';
		}

		$query = $this->db->select($campos,false)
			->from('alm_alumno')
			->join('cli_cliente','cli_id = alm_id_cli','inner')
			->join('fac_factura','fac_id_cli = cli_id','inner')
			->join('def_detalle_fact','def_id_fac = fac_id','inner')
			->join('art_articulo','art_id = def_id_art','inner')
			->join('tia_tipo_articulo','tia_id = art_id_tia','inner')
			->join('lxp_alumnoxpensum', 'lxp_id_def = def_id', 'left')
			->join('gra_grupo_academico', 'gra_id = lxp_id_gra', 'left')
			//->join('lxp_alumnoxpensum', 'lxp_id_fac = fac_id and lxp_id_def = def_id', 'left')
			->join('mod_modulo', 'mod_id_art = art_id', 'inner')
			->join('pen_pensum', 'pen_id_mod = mod_id', 'inner')
			->join('ard_area_academica', 'pen_id_ard = ard_id')
			->join('pre_prerrequisito', 'pre_id_pen = pen_id', 'left')
			;
	
		//$this->db->where('tia_id', $cat_inscripcion);
		$this->db->where('fac_estado', $fac_estado);
		$this->db->where('(lxp_id_def is null || lxp_condicion = 4)');
		$this->db->order_by('mod_id');
		if($where != null){
			$this->db->where($where);
		}

		if($group_by != null){
			$this->db->group_by($group_by);
		}

		/*if($facturas_reg!=null){
			$this->db->where_not_in('fac_id',$facturas_reg);
		}*/
		
		return $query->get()->result_array();
	}

	public function obtener_niveles($where = null){
		/*
			SELECT
				mod_nombre,
				mod_id,
				pre_id_mod AS requisito,
				art_id
			FROM
				mod_modulo
			INNER JOIN pen_pensum ON pen_id_mod = mod_id
			INNER JOIN ard_area_academica ON ard_id = pen_id_ard
			INNER JOIN art_articulo ON art_id = mod_id_art
			LEFT JOIN pre_prerrequisito ON pre_id_pen = pen_id
			WHERE
				pen_id_ard = 37
			ORDER BY mod_id asc
		*/
		$query = $this->db->select('mod_nombre,
				mod_id,
				pre_id_mod AS requisito,
				art_id, pen_id',false)
			->from('mod_modulo')
			->join('pen_pensum','pen_id_mod = mod_id','inner')
			->join('ard_area_academica','ard_id = pen_id_ard','inner')
			->join('art_articulo','art_id = mod_id_art','inner')
			->join('pre_prerrequisito','pre_id_pen = pen_id','left')
			->order_by('mod_id','asc')
			;
		if($where != null){
			$this->db->where($where);
		}

		return $query->get()->result_array();
	}

	public function obtener_det_alumns($where = null){
		/*
			SELECT
				lxp_id,
				mod_id,
				mod_nombre,
				mod_id_art,
				lxp_condicion,
				alm_nombre
			FROM
				lxp_alumnoxpensum
			INNER JOIN lxa_alumnoxarea ON lxa_id = lxp_id_lxa
			INNER JOIN alm_alumno ON alm_id = lxa_id_alm
			INNER JOIN gra_grupo_academico ON gra_id = lxp_id_gra
			INNER JOIN pen_pensum ON pen_id = gra_id_pen
			INNER JOIN mod_modulo ON mod_id = pen_id_mod
			WHERE
				lxa_id_ard = 37
			AND alm_id = 78
		*/
		$query = $this->db->select('lxp_id,
				mod_id,
				mod_nombre,
				mod_id_art,
				lxp_condicion,
				alm_nombre',false)
			->from('lxp_alumnoxpensum')
			->join('lxa_alumnoxarea','lxa_id = lxp_id_lxa','inner')
			->join('alm_alumno','alm_id = lxa_id_alm','inner')
			->join('gra_grupo_academico','gra_id = lxp_id_gra','inner')
			->join('pen_pensum','pen_id = gra_id_pen','inner')
			->join('mod_modulo','mod_id = pen_id_mod','inner')
			;
		if($where != null){
			$this->db->where($where);
		}

		return $query->get()->result_array();
	}

	public function obtener_grupo($where = null){
		/*
			SELECT * 
			FROM gra_grupo_academico
			INNER JOIN pen_pensum on pen_id = gra_id_pen
			INNER JOIN mod_modulo ON mod_id = pen_id_mod
			WHERE mod_id = 119

			SELECT
				*, (
					SELECT
						(gra_cupo - COUNT(lxp_id))
					FROM
						lxp_alumnoxpensum
					INNER JOIN lxa_alumnoxarea ON lxa_id = lxp_id_lxa
					WHERE
						lxp_id_gra = gra_id
				) as cupo_rest
			FROM
				gra_grupo_academico
			INNER JOIN pen_pensum ON pen_id = gra_id_pen
			INNER JOIN mod_modulo ON mod_id = pen_id_mod
			WHERE
				mod_id = 119
		*/
		$fac_estado = 2; //Factura pagada
		$query = $this->db->select('*, (
					SELECT
						(gra_cupo - COUNT(lxp_id))
					FROM
						lxp_alumnoxpensum
					INNER JOIN lxa_alumnoxarea ON lxa_id = lxp_id_lxa
					WHERE
						lxp_id_gra = gra_id and lxp_condicion = 1
				) as cupo_rest',false)
			->from('gra_grupo_academico')
			->join('pen_pensum','pen_id = gra_id_pen','inner')
			->join('mod_modulo','mod_id = pen_id_mod','inner')
			;
		if($where != null){
			$this->db->where($where);
		}

		return $query->get()->result_array();
	}


	public function get_categoria_like($categoria, $servicio, $where = null, $where_in = null) {
        $this->db->select();
        $this->db->from('tia_tipo_articulo');
        $this->db->like('CONCAT(tia_codigo,tia_nombre)', $categoria);
        $this->db->limit(100);

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->where('tia_estado', 1);
        $query = $this->db->get();

        return $query->result_array();
    }

	// Obtiene el horario de forma asc para que se muestre de la menor hora hasta la mayor
	public function get_horario_order($where=null)
    {
    if($where){
        $this->db->where($where);
    }
    $this->db->order_by('hrg_inicio', 'asc');
    $results=$this->db->get('hrg_horario_grupo')->result_array();
    return $results;
    }

    public function get_frecuencias($where = null) {
        $query = $this->db->select()
        	 ->from('frh_frecuencia_horario')
        	 ->join('gra_grupo_academico', 'gra_id_frh = frh_id','LEFT')
        	 ->join('pyc_proyeccion', 'gra_id_pyc = pyc_id','LEFT')
        	 ->join('dfr_detalle_frecuencia', 'dfr_id_frh=frh_id','LEFT')
        	 ->join('hrg_horario_grupo', 'dfr_id_hrg=hrg_id','LEFT')
        	 ->join('dia_dia', 'dfr_id_dia= dia_id','LEFT')
        	 ->join('hrc_horario_receso', 'dfr_id_hrc=hrc_id', 'LEFT')
        	;

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('dfr_id');

        return $query->get()->result_array();    
    }

    public function get_evaluaciones($where = null, $group=false, $group2=false, $order=null) {
        $query = $this->db->select()
        	 ->from('evm_evaluacion_modulo')
        	 ->join('pyc_proyeccion', 'evm_id_pyc=pyc_id')
        	 ->join('tev_tipo_evaluacion', 'evm_id_tev=tev_id')
        	 ->join('pen_pensum', 'pen_id=evm_id_pen')
        	 ->join('mod_modulo', 'pen_id_mod= mod_id')
        	 ->join('pev_periodo_evaluacion', 'pev_id=evm_id_pev')
        	 ->join('noa_nota_alumno', 'evm_id = noa_id_evm', 'left')
        	;

        if ($where != null) {
            $this->db->where($where);
        }

        if($group==true){
        	$this->db->group_by('mod_id');
        }

        if($group2==true){
        	$this->db->group_by('evm_id');
        }

        if($order!=null){
        	$this->db->order_by($order, 'ASC');
        }

        return $query->get()->result_array();    
    }

    public function get_info_empleado($where=null){
    	$query = $this->db->select('emp_fecha_nac, emp_email, emp_id_pro, pro_nombre, emp_direccion, emp_salario, dac_id_ina, gen_nombre, emp_nombre, emp_apellido, suc_nombre, suc_direccion')
        	 ->from('emp_empleado')
        	 ->join('suc_sucursal', 'suc_id = emp_id_suc', 'left')
        	 ->join('pro_profesion', 'emp_id_pro=pro_id', 'left')
        	 ->join('dac_dato_academico', 'emp_id= dac_id_emp', 'left')
        	 ->join('ina_institucion_academica', 'dac_id_ina=ina_id', 'left')
        	 ->join('gen_genero','emp_id_gen=gen_id', 'left')
        	;

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->limit(1);

        return $query->get()->row();   
    }

    public function get_info_alumno($where=null){
    	$query = $this->db->select('alm_fecha_nacimiento, alm_id_pro, alm_email, alm_direccion, pro_nombre, eda_id_ina')
        	 ->from('alm_alumno')
        	 ->join('pro_profesion', 'alm_id_pro=pro_id', 'left')
        	 ->join('eda_educacion_alumno', 'alm_id= eda_id_alm', 'left')
        	 ->join('ina_institucion_academica', 'ina_id = eda_id_ina', 'left')
        	;

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->limit(1);

        return $query->get()->row();   
    }

    public function get_alumnos_inscritos($where=null){
		$query = $this->db->select("COUNT( lxp_id ) as inscritos, gra_cupo", FALSE)
			->from('alm_alumno')
			->join('lxa_alumnoxarea','lxa_id_alm=alm_id','inner')
			->join('lxp_alumnoxpensum','lxa_id=lxp_id_lxa','left')
			->join('gra_grupo_academico','lxp_id_gra = gra_id','inner')
			
		;

		if($where!=null){
			$this->db->where($where);
		}

		return $query->get()->row();
	}

	/**
     * @author Edith Herrera
     * @since  06-11-2017
     * @return Carga grupos a los que se ha inscrito cada alumno (desde traslado de alumnos).
    * */
	public function get_grupos_asignados($where=null){
		$query = $this->db->select("alm_id, gra_id, lxp_id, gra_nombre", FALSE)
			->from('alm_alumno')
			->join('lxa_alumnoxarea','lxa_id_alm=alm_id','inner')
			->join('lxp_alumnoxpensum','lxa_id=lxp_id_lxa','inner')
			->join('gra_grupo_academico','lxp_id_gra = gra_id','inner')	
			->where('lxp_condicion', 1)
			->where('lxp_estado', 1)
		;



		if($where!=null){
			$this->db->where($where);
		}

		$this->db->group_by('gra_id');

		return $query->get()->result_array();
	}

	/**
     * @author Edith Herrera
     * @since  06-11-2017
     * @return Carga grupos en los que no ha sido inscrito el alumno (desde traslado de alumnos).
    * */
	public function grupos_alumnoxarea($where=null, $not_in=null){
		
		$query = $this->db->select("alm_id, gra_id, gra_nombre", FALSE)
			->from('alm_alumno')
			->join('lxa_alumnoxarea','lxa_id_alm=alm_id','inner')
			->join('gra_grupo_academico','lxa_id_ard = gra_id_ard','inner')	
		;

		if($where!=null){
			$this->db->where($where);
		}

		if($not_in!=null){
			$this->db->where_not_in('gra_id',$not_in);
		}


		$this->db->group_by('gra_id');

		return $query->get()->result_array();
	}

	/**
     * @author Edith Herrera
     * @since  07-11-2017
     * @return Carga alumnos para dropdown Ajax.
    * */
    function get_alumnos_like($where = null, $like = null) {
            $query = $this->db->select()
                    ->from('alm_alumno')
            ;
            if ($where != null) {
                $this->db->where($where);
            }

            if ($like != null) {
                $this->db->or_like($like);
            }
            $this->db->group_by('alm_id');
        return $query->get()->result_array();
    }

	function get_gfa_like($where = null, $like = null) {
            $query = $this->db->select()
                    ->from('gfa_grupo_familiar')
            ;
            if ($where != null) {
                $this->db->where($where);
            }

            if ($like != null) {
                $this->db->or_like($like);
            }
            $this->db->group_by('gfa_id');
        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera
     * @since  08-11-2017
     * @return Carga información de la entrevista.
    * */
    function get_info_entrevista($where = null) {
            $query = $this->db->select()
                    ->from('alm_alumno')
            ;
            if ($where != null) {
                $this->db->where($where);
            }

        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera
     * @since  08-11-2017
     * @return obtener áreas de acuerdo al área padre e hijo.
    * */
    function get_areas_padre($where = null) {
            $query = $this->db->select('padre.ard_id as ard_padre, padre.ard_nombre as nombre, hijo.ard_id_ard_padre as hijo', FALSE)
                    ->from('ard_area_academica as padre')
                    ->join('ard_area_academica as hijo', 'padre.ard_id = hijo.ard_id_ard_padre','left')
                    //->where('padre.ard_estado', 1)
            ;
            if ($where != null) {
                $this->db->where($where);
            }
            $this->db->group_by('padre.ard_id');

        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera
     * @since  2017-11-13
     * @return obtener docentes/disponibilidad.
    * */
    function get_docentes($where = null, $group = null, $having = null) {
    	$query = $this->db->select('dct_id, emp_nombre, emp_apellido, emp_id_gen, emp_id, gen_nombre, pro_nombre, emp_codigo, mpd_id_pen, pen_id, mod_nombre, 
    		area_nv.ard_id AS id_ard_mpd, area_nv.ard_nombre AS area_nivel, dct_estado, ctf_id, ctf_nombre, tbe_clase, tbe_id, exd_id, fxd_id_frh,
    		IF(fxd_id_fxa IS NOT NULL, ard_fxa.ard_nombre, area_fr.ard_nombre) AS area_fre, IF(fxd_id_fxa IS NOT NULL, ard_fxa.ard_id, area_fr.ard_id) AS id_ard_frh,
    		IF(fxd_id_fxa IS NOT NULL, frh_fxa.frh_id, frh_fxd.frh_id) AS frh_id, IF(fxd_id_fxa IS NOT NULL, frh_fxa.frh_nombre, frh_fxd.frh_nombre) AS frh_nombre,
    		fxd_id, mpd_id',
    		FALSE
    	)
    		->from('dct_docente')
    		->join('emp_empleado', 'emp_id=dct_id_emp','inner')
    		->join('fxd_frecuenciaxdocente', 'fxd_id_dct=dct_id', 'left')
    		->join('fxa_frecuenciaxarea', 'fxa_id=fxd_id_fxa', 'left')
    		->join('frh_frecuencia_horario AS frh_fxa', 'frh_fxa.frh_id=fxa_id_frh', 'left')
    		->join('ard_area_academica AS ard_fxa', 'ard_fxa.ard_id=fxa_id_ard', 'left')
    		->join('mpd_modulo_pensumxdocente', 'mpd_id_dct=dct_id', 'left')
    		->join('frh_frecuencia_horario AS frh_fxd', 'frh_fxd.frh_id=fxd_id_frh', 'left')
    		->join('ard_area_academica AS area_fr', 'area_fr.ard_id=frh_fxd.frh_id_ard', 'left')
    		->join('pen_pensum', 'pen_id=mpd_id_pen', 'left')
    		->join('mod_modulo', 'mod_id=pen_id_mod', 'left')
    		->join('ard_area_academica as area_nv', 'area_nv.ard_id=pen_id_ard', 'left')
    		->join('gen_genero', 'emp_id_gen=gen_id', 'left')
    		->join('pro_profesion', 'emp_id_pro=pro_id', 'left')
    		->join('exd_escalafonxdocente', 'exd_id_dct=dct_id', 'left')
    		->join('tbe_tabla_escalafon', 'exd_id_tbe=tbe_id', 'left')
    		->join('ctf_categoria_escalafon', 'tbe_id_ctf=ctf_id', 'left')
    		->where('dct_estado', 1)
    	;
    	if ($where != null) {
    		$this->db->where($where);
    	}
    	if ($group != null) {
    		if($group==1){
    			$this->db->group_by('fxd_id');
    		}else if($group==2){
    			$this->db->group_by('mpd_id');
    		}else if($group==3){
    			$this->db->group_by('exd_id');
    		}
    	}else{
    		$this->db->group_by('dct_id');
    	}
    	if ($having != null) {
    		$this->db->having($having);
    	}
        return $query->get()->result_array();
    }


    /**
     * @author Edith Herrera
     * @since  14-11-2017
     * @return Obtener información de la solicitud de becas.
    * */
    function get_info_solicitud($where = null) {
            $query = $this->db->select()
                    ->from('slb_solicitud_beca')
                    ->join('alm_alumno', 'alm_id = slb_id_alm')
                    ->join('emp_empleado', 'emp_id = slb_id_emp_referencia', 'left')
                    ->join('apb_aprobacion_beca', 'apb_id_slb = slb_id', 'left')
                    ->join('tbf_tipo_beneficio', 'apb_id_tbf = tbf_id', 'left')
                    ->join('pro_profesion', 'alm_id_pro = pro_id', 'left')
                    ->join('tpb_tipo_beca', 'slb_id_tpb = tpb_id', 'left')
                    ->join('ard_area_academica', 'slb_id_ard = ard_id', 'left')
                    ->join('frh_frecuencia_horario', 'slb_id_frh = frh_id', 'left')
                    ->join('pen_pensum', 'slb_id_pen = pen_id', 'left')
                    ->join('tbs_tipo_beneficiario_solicitud', 'slb_id_tbs= tbs_id', 'left')
                    ->join('mod_modulo', 'pen_id_mod = mod_id', 'left')

            ;
            if ($where != null) {
                $this->db->where($where);
            }

        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera
     * @since  15-11-2017
     * @return Obtener información de los tipos de becas.
    * */
    function get_detalles_tipo($where=null){
    	$query = $this->db->select()
                    ->from('tpb_tipo_beca')
                    ->join('dxb_detallextipo_beca', 'tpb_id = dxb_id_tpb')
                    ->join('ard_area_academica', 'ard_id = dxb_id_ard')
                    ->join('pen_pensum', 'dxb_id_pen = pen_id')
                    ->join('mod_modulo','pen_id_mod=mod_id')
            ;
            if ($where != null) {
                $this->db->where($where);
            }

        return $query->get()->result_array();
    }

     /**
     * @author Nelson Soriano
     * @since  19-07-2018
     * @return Obtener información de los tipos de becas.
    * */
    function get_becas_finanzas($where=null){
    	$query = $this->db->select()
                    ->from('tpb_tipo_beca')
                    ->join('fxb_finanzaxtipo_beca', 'fxb_id_tpb = tpb_id')
                    ->join('cnt_cuenta_contable' , 'cnt_id = fxb_id_cnt')
                    ->join('tcn_tipo_cuenta', 'tcn_id= fxb_id_tcn')
                    ->join('cec_centro_costo','cec_id = fxb_id_cec')
            ;
            if ($where != null) {
                $this->db->where($where);
            }

        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera
     * @since  16-11-2017
     * @return Obtener información de las prácticas profesionales.
    * */
    function get_info_practica($where = null) {
            $query = $this->db->select()
                    ->from('pcf_practica_profesional')
                    ->join('alm_alumno', 'alm_id = pcf_id_alm')
                    ->join('lgp_lugar_practicas', 'lgp_id=pcf_id_lgp')
                    ->join('anp_anexo_practica', 'pcf_id = anp_id_pcf', 'left')

            ;
            if ($where != null) {
                $this->db->where($where);
            }

        return $query->get()->result_array();
    }

    
    /**
     * @author Luis Navarro
     * @since  22-11-2017
     * @return Obtener los alumnos incritos en un grupo.
    * */
    function get_alumnos_grupo($where = NULL, $groupby = NULL) {
        $query = $this->db->select()
                 ->from('alm_alumno')
                 ->join('lxa_alumnoxarea', 'lxa_id_alm=alm_id', 'inner')
                 ->join('lxp_alumnoxpensum', 'lxp_id_lxa=lxa_id', 'left')
                 ->join('gra_grupo_academico', ' lxp_id_gra=gra_id', 'inner')
        ;
        if ($where != NULL) {
            $this->db->where($where);
        }
        if ($groupby != NULL) {
            $this->db->group_by($groupby);
        }
        return $query->get()->result_array();         
    }

    /**
     * @author Luis Navarro
     * @since  22-11-2017
     * @return obtener las asistencia de Alumnos.
    * */
    function get_asistencias($where = NULL) {
         $query = $this->db->select()
                 ->from('asg_asistencia_grupo')
                 ->join('gra_grupo_academico', 'gra_id=asg_id_gra', 'inner')
                 ->join('dsg_detalle_asistencia', 'asg_id=dsg_id_asg', 'inner')
                 ->join('tpi_tipo_inasistencia', 'dsg_id_tpi=tpi_id', 'left')
    
        ;
        if ($where != NULL) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }


    /**
     * @author Luis Navarro
     * @since  22-11-2017
     * @return Validar fecha de inicio y fin en la tabla pyc_proyeccion
    * */
    function get_validar_fecha_asistencia($where = NULL, $fecha = NULL) {
        $query = $this->db->select()
                ->from("pyc_proyeccion")
        ;

        if ($where != NULL) {
            $this->db->where($where);
        }
        if($fecha != NULL) {
            $this->db->where("'".$fecha."' BETWEEN pyc_fecha_inicio and pyc_fecha_fin", NULL, false );
        }
        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since  22-11-2017
     * @return Obtener el horario por grupo
    * */
    function get_horario_grupo($where = NULL) {

        // WHERE gra_id=6
        $query = $this->db->select("dia_nombre, hrg_inicio, hrg_fin")
                ->from("frh_frecuencia_horario")
                ->join("gra_grupo_academico", "gra_id_frh=frh_id", "inner")
                ->join("dfr_detalle_frecuencia", "dfr_id_frh=frh_id", "ïnner")
                ->join("dia_dia", "dfr_id_dia=dia_id", "left")
                ->join("hrg_horario_grupo", "hrg_id=dfr_id_hrg", "inner")
        ;

        if ($where != NULL) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since  25-11-2017
     * @return Obtener todo los alumnos por proyeccion (tabla pyc_proyeccion)
    * */    
    function get_alumnos_proyeccion($where=NULL, $orderby=NULL) {

        $query = $this->db->select()
                 ->from('alm_alumno')
                 ->join('lxa_alumnoxarea', 'lxa_id_alm=alm_id', 'inner')
                 ->join('lxp_alumnoxpensum', 'lxp_id_lxa=lxa_id', 'left')
                 ->join('gra_grupo_academico', ' lxp_id_gra=gra_id', 'inner')
                 ->join('pyc_proyeccion', 'gra_id_pyc=pyc_id', 'left')
        ;
        if ($where != NULL) {
            $this->db->where($where);
        }
        if ($orderby != NULL) {
            $this->db->order_by($orderby, 'ASC');
        }
        $this->db->group_by('alm_id');

        return $query->get()->result_array();  
    }

    /**
     * @author Luis Navarro
     * @since  27-11-2017
     * @return Obtener todo los alumnos por graduaciones
    * */
    function get_alumnos_graduaciones ($where=NULL) {

         $query = $this->db->select("grl_id, dgr_id, pyc_id, pyc_nombre, GROUP_CONCAT(alm_id) as alumnosId, GROUP_CONCAT(CONCAT_WS(' ',alm_nombre, alm_apellido)) as alumnos", false)
                 ->from('dgr_detalle_graduacion')
                 ->join('grl_graduacion_alumno', 'grl_id=dgr_id_grl', 'left')
                 ->join('pyc_proyeccion', 'dgr_id_pyc=pyc_id', 'inner')
                 ->join('alm_alumno', ' dgr_id_alm=alm_id', 'inner')
        ;
        if ($where != NULL) {
            $this->db->where($where);
        }

        $this->db->group_by('dgr_id_grl');

        return $query->get()->result_array();  
    }

    /**
     * @author Luis Navarro
     * @since  28-11-2017
     * @return Obtener información de Grupo
    * */
    function get_grupo_info($where=NULL) {

        $query = $this->db->select()
                 ->from('gra_grupo_academico')
                 ->join('ard_area_academica', 'gra_id_ard=ard_id', 'left')
                 ->join('scc_seccion', 'scc_id=gra_id_scc', 'left')
                 ->join('aul_aula', 'aul_id=gra_id_aul', 'left')
                 ->join('pen_pensum', 'pen_id=gra_id_pen', 'left')
                 ->join('mod_modulo', 'mod_id=pen_id_mod', 'left')
                 ->join('sug_supervisor_grupo', 'sug_id=gra_id_sug', 'left')
        ;
        if ($where != NULL) {
            $this->db->where($where);
        }

        $this->db->group_by('gra_id');

        return $query->get()->result_array(); 
    }

    /**
     * @author Luis Navarro
     * @since  29-11-2017
     * @return Obtener los docentes por proyección
    * */
    function get_docentes_proyeccion($where=NULL, $groupby=NULL) {

        $query = $this->db->select()
                 ->from('pyc_proyeccion')
                 ->join('gra_grupo_academico', 'pyc_id=gra_id_pyc', 'left')
                 ->join('dct_docente', 'dct_id=gra_id_dct', 'left')
                 ->join('emp_empleado', 'emp_id=dct_id_emp', 'left')
        ;
        if ($where != NULL) {
            $this->db->where($where);
        }

       if ($groupby != NULL) {
            if (is_string($groupby)) {
                 $this->db->group_by($groupby);
            }
       }

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since  29-11-2017
     * @return Obtener los cierres de grupos
    * */
    function get_cierre_grupo($where=NULL, $where2=NULL) {

        $query = $this->db->select()
                 ->from('dcg_detalle_cierre_grupo')
                 ->join('gra_grupo_academico', 'dcg_id_gra=gra_id', 'inner')
                 ->join('ard_area_academica', 'gra_id_ard=ard_id', 'left')
                 ->join('pyc_proyeccion', 'gra_id_pyc=pyc_id', 'left')
                 ->join('pen_pensum', 'gra_id_pen=pen_id', 'left')
                 ->join('mod_modulo', 'mod_id=pen_id_mod', 'left')
                 ->join('dct_docente', 'gra_id_dct=dct_id', 'left')
                 ->join('emp_empleado', 'emp_id=dct_id_emp', 'left')
                 ->join('sug_supervisor_grupo', 'gra_id_sug=sug_id', 'left')
        ;

        if ($where != NULL) {
            $this->db->where($where);
        }

        if ($where2 != NULL) {
            $this->db->where($where2);
        }

        $this->db->group_by('dcg_id');

        return $query->get()->result_array();
    }

     /**
     * @author Edith Herrera
     * @since  27-11-2017
     * @return Obtener los periodos por grupo
    * */
    function get_periodosxgrupo($where = NULL, $group=null) {

        $query = $this->db->select("pen_id, mod_nombre, pev_id, pev_nombre, evm_porcentaje, evm_id, tev_nombre, lxp_id, tev_id, gra_id, gra_id_ard, gra_id_frh, gra_id_aul, frh_nombre, ard_nombre, aul_nombre, scc_nombre, gra_cupo_minimo, gra_cupo, gra_fecha_inicio, gra_fecha_fin, pyc_fecha_limite_nota AS limite")
                ->from("gra_grupo_academico")
                ->join('lxp_alumnoxpensum','gra_id=lxp_id_gra')
                ->join("pen_pensum", "gra_id_pen = pen_id", "inner")
                ->join("mod_modulo", "pen_id_mod = mod_id", "inner")
                ->join("frh_frecuencia_horario", "gra_id_frh = frh_id", "inner")
                ->join("ard_area_academica", "gra_id_ard = ard_id", "inner")
                ->join("aul_aula", "gra_id_aul = aul_id", "left")
                ->join("pyc_proyeccion", "gra_id_pyc = pyc_id", "inner")
                ->join("evm_evaluacion_modulo", "evm_id_pen = pen_id AND gra_id_pyc = evm_id_pyc", "inner")

                ->join("pev_periodo_evaluacion", "pev_id = evm_id_pev", "left")
                ->join('tev_tipo_evaluacion', 'evm_id_tev = tev_id', 'left')
                ->join("scc_seccion", "gra_id_scc = scc_id", "left")
                ->where('lxp_estado', 1)
        ;

        if ($where != NULL) {
            $this->db->where($where);
        }

        if($group!=null){
        	$this->db->group_by($group);
        }

        $this->db->group_by('pev_id');

        return $query->get()->result_array();
    }

    /** 
     * @author Luis Navarro
     * @since  02-12-2017
     * @return Obtener las areas por nivel
    * */
    function get_areaxnivel($where=NULL) {

        $query = $this->db->select()
                 ->from('ard_area_academica')
                 ->join('pen_pensum', 'pen_id_ard=ard_id', 'inner')
                 ->join('mod_modulo', 'mod_id=pen_id_mod', 'left')
        ;

        if ($where != NULL) {
            $this->db->where($where);
        }

        $this->db->group_by('mod_id');

        return $query->get()->result_array();
    }

    /** 
     * @author Luis Navarro
     * @since  05-12-2017
     * @return Validar la fecha del Grupo
    * */
    function validar_fecha_grupo($where = NULL, $fecha = NULL) {
        $query = $this->db->select()
            ->from("gra_grupo_academico")
        ;

        if ($where != NULL) {
            $this->db->where($where);
        }
        if($fecha != NULL) {
            $this->db->where("'".$fecha."' BETWEEN gra_fecha_inicio and gra_fecha_fin", NULL, false );
        }
        return $query->get()->result_array();   
    }

    /** 
     * @author Luis Navarro
     * @since  05-12-2017
     * @return Numero de Alumnos Inscritos
    * */
    function get_n_alumnos_inscritos($where = NULL) {

        $query = $this->db->select('COUNT(lxp_id_lxa)')
            ->from("lxp_alumnoxpensum")
            ->join('gra_grupo_academico', 'gra_id=lxp_id_gra', 'inner')
        ;

        if ($where != NULL) {
            $this->db->where($where);
        }
    
        return $query->get()->result_array(); 
    }

    /** 
     * @author Luis Navarro
     * @since  05-12-2017
     * @return Obtener los docentes por grado y area
    * */
    function get_docentes_areas($where=NULL){

        $query = $this->db->select()
            ->from("dct_docente")
            ->join('emp_empleado', 'emp_id=dct_id_emp', 'inner')
            ->join('gra_grupo_academico', 'dct_id=gra_id_dct', 'left')
            ->join('ard_area_academica', 'gra_id_ard=ard_id', 'left')
            ->join('pen_pensum', 'pen_id=gra_id_pen', 'inner')
            ->join('mod_modulo', 'mod_id=pen_id_mod', 'left')
            ->join('aul_aula', 'aul_id=gra_id_aul', 'left')
        ;

        if ($where != NULL) {
            $this->db->where($where);
        }

        $this->db->group_by('gra_id');
    
        return $query->get()->result_array(); 

    }

     /**
     * @author Edith Herrera
     * @since  05-12-2017
     * @return Búsqueda de empleados por nombre u otras condiciones aplicadas.
     */
    public function get_empleados_like($where = null, $like = null, $docente=null) {
        $query = $this->db->select("*,
            CONCAT_WS(' ',emp_codigo,' - ',emp_nombre, emp_apellido) as empleado", false)
                ->from('emp_empleado')
        ;

        if($docente!=null){
        	$this->db->join('dct_docente', 'dct_id_emp=emp_id');
        	$this->db->where('dct_estado', 1);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->or_like($like);
        }

        return $query->get()->result_array();
    }

     /**
     * @author Edith Herrera
     * @since  05-12-2017
     * @return Búsqueda de alumnos para traslado.
     */
    public function get_alumnos_trs($where = null) {
        $query = $this->db->select("alm_id, alm_codigo, alm_estado, lxp_condicion, lxp_estado, lxp_id,
            CONCAT_WS(' ',alm_nombre,' - ',alm_apellido) as alumno, gra_id_pyc, gra_id", false)
                ->from('alm_alumno')
                ->join('lxa_alumnoxarea', 'lxa_id_alm=alm_id')
                ->join('lxp_alumnoxpensum', 'lxp_id_lxa = lxa_id')
                ->join('gra_grupo_academico', 'lxp_id_gra = gra_id')
                ->join('pyc_proyeccion', 'gra_id_pyc = pyc_id')
                ->where('lxp_condicion', 1)
                ->where('lxp_estado', 1)
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('alm_id, gra_id');

       
        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera
     * @since  06-12-2017
     * @return Información de traslado de alumnos.
     */
    public function get_traslados_alumno($where = null) {
        $query = $this->db->select("alm_id, alm_codigo, alm_estado, lxp_condicion, lxp_estado, lxp_id,
            CONCAT_WS(' ',alm_nombre,' ',alm_apellido) AS alumno, gra_id_pyc, gra_id, gra_nombre, pyc_nombre, trl_id_lxp_destino AS destino, trl_id_lxp_origen AS origen_id, trl_observacion, trl_id,
			( SELECT gra_nombre FROM lxp_alumnoxpensum INNER JOIN gra_grupo_academico ON lxp_id_gra = gra_id WHERE lxp_id=trl_id_lxp_origen ) AS origen", false)
                ->from('alm_alumno')
                ->join('lxa_alumnoxarea', 'lxa_id_alm=alm_id')
                ->join('lxp_alumnoxpensum', 'lxp_id_lxa = lxa_id')
                ->join('gra_grupo_academico', 'lxp_id_gra = gra_id')
                ->join('pyc_proyeccion', 'gra_id_pyc = pyc_id')
 				->join('dct_docente', 'gra_id_dct = dct_id')
 				->join('trl_traslado_alumno', 'trl_id_lxp_destino = lxp_id')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('trl_id');

       
        return $query->get()->result_array();
    }


     /**
     * @author Edith Herrera
     * @since  06-12-2017
     * @return Información de origen / destino según traslado de alumnos.
     */
    public function get_info_trasladoxalumno($where = null) {
        $query = $this->db->select("*", false)
                ->from('alm_alumno')
                ->join('lxa_alumnoxarea', 'lxa_id_alm=alm_id')
                ->join('lxp_alumnoxpensum', 'lxp_id_lxa = lxa_id')
                ->join('gra_grupo_academico', 'lxp_id_gra = gra_id')
                ->join('pyc_proyeccion', 'gra_id_pyc = pyc_id')
 				->join('dct_docente', 'gra_id_dct = dct_id')
        ;

        if ($where != null) {
            $this->db->where($where);
        }       
        return $query->get()->result_array();
    }


     /**
     * @author Edith Herrera
     * @since  06-12-2017
     * @return Información notas por alumno.
     */
    public function obtener_notas_alumnos($where = null) {
        $query = $this->db->select("
        	mod_nombre,
        	aul_nombre, 
        	tev_nombre, 
        	noa_nota, 
        	pev_nombre, 
        	ard_nota_minima  AS minima, 
        	IFNULL(noa_fecha_creacion,0), 
        	evm_id_pen as pen,
        	ard_nombre,
        	(
        		SELECT sum(
        		(E.evm_porcentaje_periodo * N.noa_nota) / 100)
				FROM evm_evaluacion_modulo E
				INNER JOIN pen_pensum P on E.evm_id_pen = P.pen_id
				INNER JOIN noa_nota_alumno N on N.noa_id_evm = E.evm_id
				INNER JOIN mod_modulo M on M.mod_id = P.pen_id_mod
				WHERE M.mod_id = Z.mod_id 

        	) as suma_geenral,
        	(   	SELECT COUNT(DISTINCT E.evm_id_pev)			
					FROM evm_evaluacion_modulo E
					INNER JOIN pen_pensum P on E.evm_id_pen = P.pen_id
					INNER JOIN mod_modulo M on M.mod_id = P.pen_id_mod
					INNER JOIN pev_periodo_evaluacion L ON L.pev_id = E.evm_id_pev
					WHERE M.mod_id = Z.mod_id

        	) as numero_periodos        	
        	", false)
                ->from('alm_alumno')
                ->join('lxa_alumnoxarea', 'lxa_id_alm=alm_id')
                ->join('ard_area_academica', 'lxa_id_ard=ard_id')
                ->join('lxp_alumnoxpensum', 'lxp_id_lxa = lxa_id')
                ->join('gra_grupo_academico', 'lxp_id_gra = gra_id')
                ->join('pyc_proyeccion', 'gra_id_pyc = pyc_id')
                ->join('pen_pensum', 'gra_id_pen = pen_id')
 				->join('mod_modulo Z', 'pen_id_mod = Z.mod_id')
 				->join('aul_aula', 'gra_id_aul = aul_id')
 				->join('evm_evaluacion_modulo', 'lxp_id_gra = gra_id AND pyc_id=evm_id_pyc AND gra_id_pen = evm_id_pen')
 				->join('tev_tipo_evaluacion', 'evm_id_tev=tev_id')
 				->join('pev_periodo_evaluacion', 'evm_id_pev=pev_id')
 				->join('noa_nota_alumno H', 'evm_id = H.noa_id_evm AND H.noa_id_lxp=lxp_id', 'left')
 				->where('lxp_estado', 1)
        ;

        if ($where != null) {
            $this->db->where($where);
        }       

        $this->db->group_by('evm_id');
        return $query->get()->result_array();
    }

    /** 
     * @author Luis Navarro
     * @since  06-12-2017
     * @return Obtener todo los datos de alumno con Documento y Telefono
    * */
    public function obtener_datos_alumnos ($where=NULL) {
        $query = $this->db->select()
                ->from('alm_alumno')
                ->join('dce_documento_alm', 'dce_id_alm=alm_id', 'left')
                ->join('tal_telefonoxalumno', 'tal_id_alm=alm_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }       
        $this->db->group_by('alm_id');
        $this->db->limit(1);
        return $query->get()->row();
    }

  /** 
     * @author Luis Navarro
     * @since  06-12-2017
     * @return Obtener toda las sustituciones de maestros
    * */
    public function obtener_maestros_sustituto($where=NULL, $where2=NULL) {

        $query = $this->db->select("stm_id, stm_id_gra, sustituto.dct_id_emp, emp_titular.emp_nombre as dct_emp_nombre, emp_titular.emp_apellido as dct_emp_apellido, titular.dct_id_emp as titular_emp, emp_sustituto.emp_nombre as dcts_emp_nombre, emp_sustituto.emp_apellido as dcts_emp_apellido, gra_id, gra_nombre, DATE_FORMAT(stm_fecha_inicio, '%y-%m-%d') as fechaInicio, DATE_FORMAT(stm_fecha_fin, '%y-%m-%d') as fechaFin, dfr_id, dhs_id, stm_pago_titular, stm_pago_sustituto, stm_tipo_pago, stm_id_tbe, stm_observacion, mod_nombre, gra_id_ard, stm_fecha_creacion, stm_numero_horas, stm_estado, pla_fecha_inicio, pla_fecha_fin, tpl_nombre, tpl_id, stm_id_pla", false)
                ->from('stm_sustituto_maestro')
                ->join('dct_docente as titular', 'stm_id_dct_titular=titular.dct_id', 'left')
                ->join('emp_empleado as emp_titular', 'emp_titular.emp_id=titular.dct_id_emp', 'left')
                ->join('dct_docente as sustituto', 'stm_id_dct_sustituto=sustituto.dct_id', 'left')
                ->join('emp_empleado as emp_sustituto', 'emp_sustituto.emp_id=sustituto.dct_id_emp', 'left')
                ->join('gra_grupo_academico', 'stm_id_gra=gra_id', 'inner')
                ->join('pen_pensum', 'pen_id=gra_id_pen', 'left')
                ->join('mod_modulo', 'mod_id=pen_id_mod', 'left')
                ->join('dhs_detalle_horario_sustituir', 'dhs_id_stm=stm_id', 'left')
                ->join('dfr_detalle_frecuencia', 'dfr_id=dhs_id_dfr AND dfr_estado = 1', 'left')
                ->join('frh_frecuencia_horario', 'frh_id=dfr_id_frh', 'inner')
                ->join('pla_planilla', 'pla_id = stm_id_pla', 'left')
                ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }       

        $this->db->group_by('stm_id');
        return $query->get()->result_array();
    }


    /** 
     * @author Edith Herrera
     * @since  08-12-2017
     * @return Obtener promedios finales
    * */
    public function get_promedios_finales($where=NULL, $limit=null) {

        $query = $this->db->select("gra_nombre, pyc_id, pyc_nombre, alm_id, alm_codigo, alm_nombre, alm_apellido, SUM(lxp_promedio) as promedio, COUNT(DISTINCT gra_id) as grupos, SUM(lxp_promedio) / COUNT(DISTINCT gra_id) AS promFinal", false)
                ->from('gra_grupo_academico')
                ->join('pyc_proyeccion', 'pyc_id = gra_id_pyc')
                ->join('lxp_alumnoxpensum', 'lxp_id_gra=gra_id')
                ->join('lxa_alumnoxarea', 'lxp_id_lxa = lxa_id')
                ->join('alm_alumno', 'lxa_id_alm=alm_id')
        ;

        if ($where != null) {
            $this->db->where($where);
        } 

        if($limit>0){
        	$this->db->limit($limit);
        }      

        $this->db->group_by('pyc_id, alm_id');
        $this->db->order_by('promFinal', 'DESC');
        return $query->get()->result_array();
    }

    /** 
     * @author Luis Navarro
     * @since  08-12-2017
     * @return Obtener los docentes sustituto
    * */
    public function obtener_info_maestro_sustituto($where=NULL, $select="*", $limit=NULL) {

        $query = $this->db->select($select)
                ->from('stm_sustituto_maestro')
                ->join('dhs_detalle_horario_sustituir', 'dhs_id_stm=stm_id', 'left')
                ->join('dfr_detalle_frecuencia', 'dfr_id=dhs_id_dfr AND dfr_estado = 1', 'left')
                ->join('hrg_horario_grupo', 'dfr_id_hrg=hrg_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        } 

        if($limit>0){
            $this->db->limit($limit);
        }      

        $this->db->group_by('stm_id');
        return $query->get()->result_array();
    }

     /** 
     * @author Edith Herrera
     * @since  08-12-2017
     * @return Regresa el listado de clientes por posibles coincidencias
     * @property array $where 'Array de filtros a usar'
     * @property array $like 'Concidencias con el nombre'
     */
    public function get_clientes($where = null, $like = null) {
        $query = $this->db->select("*, CASE WHEN cli_personeria = 1 THEN
            CONCAT_WS(' ',cli_codigo,' - ',cli_nombre, cli_apellido)
            ELSE CONCAT_WS(' ',cli_codigo,' - ',cli_apellido) END as cliente", false)
                ->from('cli_cliente')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->like($like);
        }

        return $query->get()->result_array();
    }

    /** 
     * @author Luis Navarro
     * @since  12-12-2017
     * @return Obtener horarios de supervisores
    * */
    public function obtener_horarios_supervisor($where=NULL, $limit=NULL) {
        $query = $this->db->select()
                ->from('hrs_horario_supervisor')
                ->join('sug_supervisor_grupo', 'hrs_id_sug=sug_id', 'left')
                ->join('emp_empleado', 'sug_id_emp=emp_id', 'left')
                ->join('tbe_tabla_escalafon', 'tbe_id=hrs_id_tbe', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        } 

        if($limit>0){
            $this->db->limit($limit);
        }      

        // $this->db->group_by('stm_id');
        return $query->get()->result_array();
    }

    /** 
     * @author Edith Herrera
     * @since  15-12-2017
     * @return Obtener cursos por alumno (modal de inscripción).
    * */
    public function obtener_cursos_alumno($where=NULL) {
        $query = $this->db->select()
                ->from('lxp_alumnoxpensum')
                ->join('lxa_alumnoxarea', 'lxp_id_lxa = lxa_id')
                ->join('ard_area_academica', 'ard_id = lxa_id_ard')
                ->join('gra_grupo_academico', 'lxp_id_gra = gra_id')
                ->join('pen_pensum', 'gra_id_pen = pen_id')
                ->join('mod_modulo', 'pen_id_mod = mod_id')
        ;

        if ($where != null) {
            $this->db->where($where);
        }     

        return $query->get()->result_array();
    }

    /** 
     * @author Edith Herrera
     * @since  18-12-2017
     * @return Carga areas según alumno seleccionado (modal de inscripcion).
    * */
    public function cargar_areaxalumno($where=NULL) {
        $query = $this->db->select()
                ->from('lxp_alumnoxpensum')
                ->join('lxa_alumnoxarea', 'lxp_id_lxa = lxa_id')
                ->join('ard_area_academica', 'ard_id = lxa_id_ard')
                ->join('alm_alumno', 'lxa_id_alm=alm_id')
        	;

        if ($where != null) {
            $this->db->where($where);
        }     

       	$this->db->group_by('lxa_id_ard');

        return $query->get()->result_array();
    }

    /** 
     * @author Edith Herrera
     * @since  20-12-2017
     * @return Obtener el registro completo de inscripción de alumno.
    * */
    public function get_registro_inscripcion($where=null, $group=null){
    	$query = $this->db->select("*, GROUP_CONCAT(tal_numero) as telefono, (SELECT COUNT(cmc_id) FROM cmc_cargo_alumnoxcurso 
    		WHERE cmc_id_lxp = lxp_id AND cmc_estado = 1 AND cmc_estado_cargo = 1) AS contar_cmc", FALSE)
                ->from('lxp_alumnoxpensum')
                ->join('lxa_alumnoxarea', 'lxp_id_lxa = lxa_id')
                ->join('ard_area_academica', 'ard_id = lxa_id_ard')
                ->join('alm_alumno', 'lxa_id_alm=alm_id')
                ->join('gra_grupo_academico', 'lxp_id_gra=gra_id')
                ->join('pyc_proyeccion', 'gra_id_pyc=pyc_id', 'left')
                ->join('pen_pensum', 'gra_id_pen=pen_id', 'left')
                ->join('mod_modulo', 'pen_id_mod=mod_id', 'left')
                ->join('frh_frecuencia_horario', 'frh_id = gra_id_frh', 'left')
				->join('scc_seccion', 'scc_id = gra_id_scc', 'left')
                ->join('tal_telefonoxalumno', 'tal_id_alm = lxa_id_alm', 'left')
                ->join('grd_grado', 'gra_id_grd = grd_id', 'left')
        	;

        if ($where != null) {
            $this->db->where($where);
        }

        if($group!=null){
        	$this->db->group_by($group);
        }else{
        	$this->db->group_by('lxp_id');
        }
        return $query->get()->result_array();
    }

    /** 
     * @author Edith Herrera
     * @since  27-12-2017
     * @return Obtener detalles de factura.
    * */
    function get_detalles_fac($where=null){
    	$query = $this->db->select("COUNT(DISTINCT def_id) as detalle, COUNT(lxp_id_def) as det_ins", false)
                ->from('fac_factura')
                ->join('def_detalle_fact', 'fac_id = def_id_fac')
                ->join('lxp_alumnoxpensum', 'lxp_id_def = def_id', 'left')
        	;

        if ($where != null) {
            $this->db->where($where);
        }     

        return $query->get()->row_array();
    }

    /** 
     * @author Luis Navarro
     * @since  27-12-2017
     * @return Obtener registros de contenido por nivel
    **/
    public function get_contenido_nivel($where=null) {

        $query = $this->db->select()
                ->from('ctd_contenido_modulo')
                ->join('ctc_categoria_contenido', 'ctd_id_ctc=ctc_id')
                ->join('mod_modulo', 'mod_id=ctd_id_mod')
            ;

        if ($where != null) {
            $this->db->where($where);
        }     

        return $query->get()->result_array();
    }

    /** 
     * @author Edith Herrera
     * @since  28-12-2017
     * @return Obtener evaluaciones por grupo.
    * */
    function get_evaluaciones_grupo($where=null){
    	$query = $this->db->select(" evm_porcentaje, tev_nombre", false)
                ->from('gra_grupo_academico')
                ->join('evm_evaluacion_modulo', 'evm_id_pen = gra_id_pen AND gra_id_pyc=evm_id_pyc')
                ->join('tev_tipo_evaluacion', 'evm_id_tev = tev_id')
        	;

        if ($where != null) {
            $this->db->where($where);
        }     

        return $query->get()->result_array();
    }

    /** 
     * @author Luis Navarro
     * @since  02-01-2018
     * @return Obtener registros de facturacion de los alumnos.
    * */
    function get_alm_con_beneficio($where=NULL, $groupby=NULL, $fecha_inicio=NULL, $fecha_fin=NULL) {
        // WHERE apb_estado=1 
        // GROUP BY alm_id

        $query = $this->db->select("alm_id, alm_codigo, alm_nombre, alm_apellido, apb_porcentaje, tbf_nombre, (SELECT CONCAT_WS(',',fac_descuento, fac_numero, fac_fecha_fact) FROM fac_factura WHERE fac_id_cli=cli_id AND DATE(fac_fecha_fact) >= '$fecha_inicio' AND DATE(fac_fecha_fact) <= '$fecha_fin' ORDER BY fac_id DESC LIMIT 1) as factura", false)
                ->from('alm_alumno')
                ->join('cli_cliente', 'alm_id_cli=cli_id')
                ->join('slb_solicitud_beca', 'slb_id_alm=alm_id')
                ->join('apb_aprobacion_beca', 'slb_id=apb_id_slb')
                ->join('tbf_tipo_beneficio', 'apb_id_tbf=tbf_id')
                // ->join('lxa_alumnoxarea', 'alm_id=lxa_id_alm')
                // ->join('lxp_alumnoxpensum', 'lxp_id_lxa=lxa_id')
            ;

        if ($where != null) {
            $this->db->where($where);
        }
        // $this->db->order_by('fac_id', 'DESC');
        if($groupby != NULL) {
            $this->db->group_by($groupby);
        }

        return $query->get()->result_array();
    }

    /** 
     * @author Luis Navarro
     * @since  05-01-2018
     * @return Obtener registros de proyeccion por nivel
    **/
    function get_proyeccion_x_nivel($where=NULL, $groupby=NULL) {
    
        $query = $this->db->select()
                ->from('pyc_proyeccion')
                ->join('gra_grupo_academico', 'gra_id_pyc=pyc_id')
                ->join('pen_pensum', 'pen_id = gra_id_pen')
                ->join('mod_modulo', 'mod_id=pen_id_mod')
            ;

        if ($where != null) {
            $this->db->where($where);
        }
    
        if($groupby != NULL) {
            $this->db->group_by($groupby);
        } else {
            $this->db->group_by('mod_id');
        }

        return $query->get()->result_array();
    }

    /** 
     * @author Luis Navarro
     * @since  08-01-2018
     * @return Obtener registros de Grupos
    **/
    function get_grupos($where=NULL) {
        $query = $this->db->select('emp_codigo, gra_nombre, mod_nombre, scc_nombre, aul_nombre, aul_capacidad, gra_cupo_minimo, (SELECT COUNT(lxp_id_lxa) FROM lxp_alumnoxpensum WHERE lxp_id_gra=gra_id) as inscritos, emp_nombre, emp_apellido', false)
            ->from('gra_grupo_academico')
            ->join('aul_aula','gra_id_aul = aul_id','left')
            ->join('scc_seccion','scc_id = gra_id_scc','left')
            ->join('dct_docente','gra_id_dct = dct_id','left')
            ->join('emp_empleado','emp_id = dct_id_emp','left')
            ->join('ard_area_academica','gra_id_ard=ard_id','left')
            ->join('frh_frecuencia_horario', 'frh_id=gra_id_frh', 'left')
            ->join('pen_pensum','pen_pensum.pen_id = gra_grupo_academico.gra_id_pen','left')
            ->join('mod_modulo','mod_modulo.mod_id=pen_pensum.pen_id_mod','left')
            ->join('pyc_proyeccion', 'gra_id_pyc=pyc_id', 'left')
            ;

          if($where!=null){
                $this->db->where($where);
          }
          $this->db->group_by('gra_id');
        return $query->get()->result_array();    
    }

    /** 
     * @author Luis Navarro
     * @since  08-01-2018
     * @return Obtener frecuencias por proyeccion y area
    **/
    function get_frecuencia_pyc_area($where=NULL) {
        
            $query = $this->db->select()
            ->from('pyc_proyeccion')
            ->join('ard_area_academica','pyc_id_ard=ard_id','left')
            ->join('frh_frecuencia_horario','frh_id_ard=ard_id','left')
            ;

          if($where!=null){
                $this->db->where($where);
          }
          
        return $query->get()->result_array(); 
    }

     /** 
     * @author Edith Herrera
     * @since  05-01-2018
     * @return Obtener registros proficiencia por alumno (Certificado de notas).
    * */
    function get_proficienciaxalumno($where=null, $group=null, $join=null){
    	 $query = $this->db->select("pen_id, tev_nombre, evm_porcentaje, noa_nota, mod_nombre, lxp_promedio", false)
                ->from('pen_pensum')
                ->join('gra_grupo_academico', 'gra_id_pen = pen_id')
                ->join('pyc_proyeccion', 'gra_id_pyc = pyc_id')
                ->join('mod_modulo', 'pen_id_mod = mod_id')
                ->join('evm_evaluacion_modulo', 'evm_id_pyc = pyc_id AND pen_id=evm_id_pen')
                ->join('tev_tipo_evaluacion', 'tev_id= evm_id_tev')
                ->join('lxp_alumnoxpensum','lxp_id_gra=gra_id')
				->join('lxa_alumnoxarea','lxp_id_lxa=lxa_id')
				->join('alm_alumno','alm_id=lxa_id_alm')
                ->join('noa_nota_alumno', 'noa_id_evm = evm_id', $join)
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        if($group != NULL) {
            $this->db->group_by($group);
        }

        return $query->get()->result_array();
    }
    
    /** 
     * @author Luis Navarro
     * @since  08-01-2018
     * @return Obtener Grupos por Proyeccion
    **/
    function get_gruposxproyeccion($where=NULL) {

         $query = $this->db->select()
            ->from('pyc_proyeccion')
            ->join('ard_area_academica','pyc_id_ard=ard_id')
            ->join('gra_grupo_academico','gra_id_pyc=pyc_id')
            ;

          if($where!=null){
                $this->db->where($where);
          }
          
        return $query->get()->result_array(); 
    }

    /** 
     * @author Luis Navarro
     * @since  08-01-2018
     * @return Obtener Alumnos por Area y Grupo
    **/
    function alumnosxarea_grupo($where=NULL) {

        $query = $this->db->select("(SELECT CONCAT_WS(',',fac_descuento, fac_numero, fac_fecha_fact, lxp_id_fac) FROM fac_factura WHERE fac_id_cli=cli_id  ORDER BY fac_id DESC LIMIT 1) as factura, mod_nombre as Modulo, alm_codigo, alm_nombre, alm_apellido, alm_becado, gra_id, gra_nombre, gra_id_grd, grd_nombre, grd_id_cfg, pyc_ultima_fecha_pago as fecha_pago, scc_nombre, gxa_id", false)
        	->from('ard_area_academica')
        	->join('axy_areas_x_proyecion', 'axy_id_ard = ard_id')
        	->join('pyc_proyeccion', 'pyc_id = axy_id_pyc')
			->join('pen_pensum','pen_id_ard = ard_id')
			->join('mod_modulo as md','md.mod_id = pen_id_mod')
			->join('gra_grupo_academico','gra_id_pen = pen_id')
			->join('scc_seccion','gra_id_scc = scc_id')
			->join('lxp_alumnoxpensum','lxp_id_gra = gra_id')
			->join('lxa_alumnoxarea','lxp_id_lxa = lxa_id')
			->join('alm_alumno','alm_id=lxa_id_alm')
            ->join('cli_cliente', 'alm_id_cli=cli_id')
            ->join('fac_factura','lxp_id_fac=fac_id', 'left')
            ->join('grd_grado','gra_id_grd = grd_id', 'left')
            ->join('art_articulo','grd_id_art = art_id', 'left')
            ->join('gxa_gradoxalumno', 'gxa_id_grd = grd_id AND gxa_id_alm = alm_id', 'left')
            ;

          if($where!=null){
                $this->db->where($where);
          }

          $this->db->group_by('alm_id');
          $this->db->order_by('gra_nombre, alm_nombre', 'ASC');
          
        return $query->get()->result_array(); 
    }

    /** 
     * @author Edith Herrera
     * @since  10-01-2018
     * @return Obtener inscripciones de alumno (pensum).
    **/
    function pensumxalumno_inscrito($where=NULL, $examen=null) {

        $query = $this->db->select()
            ->from('lxp_alumnoxpensum')
            ->join('gra_grupo_academico', 'lxp_id_gra = gra_id')
            ->join('pen_pensum','gra_id_pen = pen_id')
            ->join('lxa_alumnoxarea','lxa_id = lxp_id_lxa')
            ->where('lxp_estado',1)
            ;

          	if($where!=null){
                $this->db->where($where);
          	}

          	if($examen==null){
          		$this->db->where_in('lxp_condicion', array(1,2)); // Inscrito o aprobado.
          	}else{
          		$this->db->where('lxp_condicion', 1);
          	}
          	
          	$this->db->group_by('pen_id');
          
        return $query->get()->result_array(); 
	}
	
    /** 
     * @author Herberth Lucho
     * @since  12-09-2019
     * @return valida si el grupo tiene mas materias en el pensum
    **/
    function check_grupo_finalizar($where=NULL) {
		/*
			SELECT
				pen_id,
				mod_nombre,
				pen_id_mod_siguiente 
			FROM
				pen_pensum
				INNER JOIN gra_grupo_academico ON gra_id_pen = pen_id
				INNER JOIN ard_area_academica ON ard_id = gra_id_ard
				INNER JOIN pyc_proyeccion ON gra_id_pyc = gra_id_pyc
				INNER JOIN mod_modulo ON mod_id = pen_id_mod 
			WHERE
				gra_id = '37' 
				AND pyc_id = '19'
		 */
        $query = $this->db->select()
            ->from('pen_pensum')
            ->join('gra_grupo_academico', 'gra_id_pen = pen_id')
            ->join('ard_area_academica','ard_id = gra_id_ard')
            ->join('pyc_proyeccion','gra_id_pyc = gra_id_pyc')
            ->join('mod_modulo','mod_id = pen_id_mod')
            ;

          	if($where!=null){
                $this->db->where($where);
          	}
          	
        return $query->get()->result_array(); 
    }

    /** 
     * @author Luis Navarro
     * @since  10-01-2018
     * @return Obtener Los Horarios de disponibilidad del Docente.
    **/
    function get_dispo_docente($where=NULL, $groupby=NULL) {
 
        $query = $this->db->select()
            ->from('dct_docente')
            ->join('fxd_frecuenciaxdocente', 'dct_id=fxd_id_dct')
            ->join('dfr_detalle_frecuencia','dfr_id_frh=fxd_id_frh')
            ->join('hrg_horario_grupo','hrg_id=dfr_id_hrg')
            ->join('dia_dia','dia_id=dfr_id_dia')
            ;

        if($where!=null){
            $this->db->where($where);
        }

        if($groupby!=NULL) {
            $this->db->group_by($groupby);
        }
          
        return $query->get()->result_array(); 
        
    }

     /** 
     * @author Edith Herrera
     * @since  11-01-2018
     * @return Obtener evaluaciones por alumno (reporte notas por grupo).
    **/
    public function get_evaluaciones_rpt_grupo($where = null, $group_evm=null) {
        $query = $this->db->select()
        	 ->from('evm_evaluacion_modulo')
        	 ->join('pyc_proyeccion', 'evm_id_pyc=pyc_id')
        	 ->join('tev_tipo_evaluacion', 'evm_id_tev=tev_id')
        	 ->join('pen_pensum', 'pen_id=evm_id_pen')
        	 ->join('mod_modulo', 'pen_id_mod= mod_id')
        	 ->join('pev_periodo_evaluacion', 'pev_id=evm_id_pev')
        	 ->join('noa_nota_alumno', 'evm_id = noa_id_evm')
        	 ->join('lxp_alumnoxpensum', 'lxp_id=noa_id_lxp')
        	;

        if ($where != null) {
            $this->db->where($where);
        }

        if($group_evm!=null){
        	$this->db->group_by('evm_id');
        }

        return $query->get()->result_array();    
    }

    /** 
     * @author Luis Navarro
     * @since  16-01-2018
     * @return Obtener Asistencia de Alumnos por Grupo
    **/
    public function obtener_asistencia_grupo($where = NULL, $groupby = NULL) {

        $query = $this->db->select('asg_id, emp_nombre, emp_apellido, asg_fecha_asistencia, (SELECT COUNT(dsg_id) FROM dsg_detalle_asistencia WHERE dsg_id_asg=asg_id AND dsg_asistencia=1) as asistencia, (SELECT COUNT(dsg_id) FROM dsg_detalle_asistencia WHERE dsg_id_asg=asg_id AND dsg_asistencia=0) as inasistencia', false)
             ->from('asg_asistencia_grupo')
             ->join('dct_docente', 'dct_id=asg_id_dct')
             ->join('emp_empleado', 'dct_id_emp=emp_id')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        if($groupby!=null){
            $this->db->group_by($groupby);
        }

        $this->db->order_by('asg_fecha_asistencia');

        return $query->get()->result_array();
    }

    /** 
     * @author Luis Navarro
     * @since  17-01-2018
     * @return Obtener Dias de Asistencia de Alumnos por Grupo para reporte
    **/
    public function obtener_dias_asistencia_grupo($where = NULL, $groupby = NULL, $fechaInicio = NULL, $fechaFin = NULL, $orderby = NULL) {

        if ($fechaInicio != NULL && $fechaFin != NULL) {
            $selected = "
                    (
                        SELECT
                            alm_id
                        FROM
                            alm_alumno
                        WHERE
                            alm_id = dsg_id_alm
                    ) AS alm_id,
                    (
                        SELECT
                            alm_codigo
                        FROM
                            alm_alumno
                        WHERE
                            alm_id = dsg_id_alm
                    ) AS alm_codigo,
                    (
                        SELECT
                            alm_nombre
                        FROM
                            alm_alumno
                        WHERE
                            alm_id = dsg_id_alm
                    ) AS alm_nombre,
                    (
                        SELECT
                            alm_apellido
                        FROM
                            alm_alumno
                        WHERE
                            alm_id = dsg_id_alm
                    ) AS alm_apellido,
                    asg_fecha_asistencia,
                    GROUP_CONCAT(
                        CONCAT_WS(
                            '&',
                            DATE_FORMAT(asg_fecha_asistencia, '%Y-%m-%d'),
                            dsg_asistencia
                        )
                        ORDER BY asg_fecha_asistencia ASC
                    ) as asistencias
            ";

        }

        $query = $this->db->select($selected, false)
             ->from('asg_asistencia_grupo')
             ->join('dsg_detalle_asistencia', 'asg_id = dsg_id_asg')
            ;

        $this->db->where("asg_fecha_asistencia BETWEEN '$fechaInicio' and '$fechaFin'", NULL, false );
        if ($where != null) {
            $this->db->where($where, NULL, false);
        }

        if($groupby != null){
            $this->db->group_by($groupby);
        }

        if ($orderby != NUll) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }


    /** 
     * @author Edith Herrera
     * @since  18-01-2018
     * @return Obtener informacion del prerrequisito según modulo facturado.
    **/
    public function get_info_prerrequisito($where = NULL) {
        $query = $this->db->select('mod_nombre, gra_id_ard, pen_id, pen_id_ard, pen_id_mod, pre_id_mod, lxp_id, lxp_condicion, lxa_id,  lxa_id_alm', false)
             ->from('lxa_alumnoxarea')
             ->join('lxp_alumnoxpensum', 'lxp_id_lxa = lxa_id')
             ->join('gra_grupo_academico', 'lxp_id_gra= gra_id')
             ->join('pen_pensum', 'gra_id_pen = pen_id')
             ->join('mod_modulo', 'pen_id_mod = mod_id')
             ->join('pre_prerrequisito', 'mod_id=pre_id_mod')
             ->where('lxp_estado',1)
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('lxa_id_alm');
        return $query->get()->row_array();
    }

    /** 
     * @since  2024-04-04
     * @return Detalles de alumnos y su modalidad de estudios (Presencial o Virtual)
    **/
    public function modalidad_estudios($where = null) {
        $query = $this->db->select('ard_nombre, gra_nombre, frh_nombre, alm_nombre, alm_apellido, lxp_modalidad')//, false
             ->from('lxp_alumnoxpensum')
             ->join('gra_grupo_academico', 'gra_id = lxp_id_gra')
             ->join('frh_frecuencia_horario', 'frh_id = gra_id_frh')
             ->join('lxa_alumnoxarea', 'lxa_id = lxp_id_lxa')
             ->join('alm_alumno', 'alm_id = lxa_id_alm')
             ->join('ard_area_academica', 'ard_id = lxa_id_ard')
             ->order_by('ard_id ASC, gra_id ASC, frh_id ASC, alm_apellido ASC')
		;

        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /** 
     * @author Luis Navarro
     * @since  22-01-2018
     * @return Obtener informacion para estadisticas de alumnos.
    **/
    public function get_estadisticas_alumnos($where=null) {

        $query = $this->db->select(
        '
        ard_id,
        ard_nombre,
        (
            SELECT
                COUNT(gra_id)
            FROM
                gra_grupo_academico
            WHERE
                gra_id_ard = ard_id
        ) AS grupos,
        SUM((

        SELECT COUNT(alm_id) FROM alm_alumno 
        LEFT JOIN lxa_alumnoxarea ON lxa_id_alm=alm_id
        LEFT JOIN lxp_alumnoxpensum ON lxp_id_lxa=lxa_id
        WHERE lxp_id_gra=gra_id AND lxa_id_ard=ard_id AND lxp_alumnoxpensum.lxp_condicion IN (1,2)

        )) AS alumnos

        '
        , false)
        ->from('ard_area_academica')
        ->join('gra_grupo_academico', 'gra_id_ard = ard_id', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('ard_id');
        return $query->get()->result_array();
    }

    /** 
     * @author Edith Herrera
     * @since  24-01-2018
     * @return Obtener información del siguiente nivel en el que se debe inscribir el grupo.
    **/
    public function get_info_siguientenivel($where = NULL) {
        $query = $this->db->select('mod_nombre, gra_id_ard, pen_id, pen_id_ard, pen_id_mod, pre_id_mod, gra_id, gra_nombre', false)
             ->from('pre_prerrequisito')
             ->join('mod_modulo', 'pre_id_mod = mod_id')
             ->join('pen_pensum', 'pre_id_pen = pen_id')
             ->join('gra_grupo_academico', 'gra_id_pen = pen_id', 'inner')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /** 
     * @author Luis Navarro
     * @since  25-01-2018
     * @return Obtener la informacion de los alumnos que aprobaron y cuadro cerrado
    **/
    public function get_alumnos_diplomas($where = NULL) {

         $query = $this->db->select()
             ->from('alm_alumno')
             ->join('lxa_alumnoxarea', 'alm_id=lxa_id_alm')
             ->join('ard_area_academica', 'ard_id=lxa_id_ard')
             ->join('lxp_alumnoxpensum', 'lxp_id_lxa=lxa_id')
             ->join('gra_grupo_academico', 'gra_id=lxp_id_gra')
             ->join('pen_pensum', 'pen_id_ard=ard_id')
             ->join('mod_modulo', 'pen_id_mod=mod_id')
             ->where('lxp_estado',1)
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('alm_id');

        return $query->get()->result_array();
    }

    /** 
     * @author Edith Herrera
     * @since  2018-01-30
     * @return Obtener la docentes según la categoría del escalafón.
    **/
    public function get_docentes_escalafon($where = NULL, $join=null) {
    	$join_ = ($join!=null)?$join:'left';
         $query = $this->db->select('emp_nombre, emp_apellido, tbe_codigo, tbe_clase, tbe_monto, ctf_id, ctf_nombre', FALSE)
             ->from('tbe_tabla_escalafon')
             ->join('ctf_categoria_escalafon', 'tbe_id_ctf = ctf_id', $join_)
             ->join('exd_escalafonxdocente', 'exd_id_tbe = tbe_id', $join_)
             ->join('dct_docente', 'exd_id_dct = dct_id', $join_)
             ->join('emp_empleado', 'dct_id_emp=emp_id', $join_)
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

     /** 
     * @author Edith Herrera
     * @since  2018-02-07
     * @return Obtener la docentes según la categoría del escalafón.
    **/
    public function get_info_alummno_cons($where = NULL, $group=null) {
    	
         $query = $this->db->select('pyc_id, pyc_nombre, pen_id, mod_nombre, alm_id, alm_nombre, alm_apellido, lxp_id, lxp_estado, lxp_condicion, gra_nombre, mod_id, ard_nombre, frh_descripcion, gra_fecha_inicio AS inicio, gra_fecha_fin AS fin, pen_id, ard_id, alm_id, gra_fecha_inicio, gra_fecha_fin, pyc_fecha_inicio, pyc_fecha_fin, def_subtotal, def_impuesto, def_descuento, def_retencion, lxp_id_def, alm_codigo_nie', FALSE)
             ->from('pyc_proyeccion')
             ->join('ard_area_academica', 'pyc_id_ard = ard_id', 'inner')
             ->join('gra_grupo_academico', 'gra_id_pyc = pyc_id', 'inner')
             ->join('lxp_alumnoxpensum', 'lxp_id_gra = gra_id', 'inner')
             ->join('lxa_alumnoxarea', 'lxp_id_lxa = lxa_id AND lxa_id_ard = ard_id', 'inner')
             ->join('alm_alumno', 'lxa_id_alm = alm_id', 'inner')
             ->join('pen_pensum', 'pen_id = gra_id_pen', 'inner')
             ->join('mod_modulo', 'pen_id_mod = mod_id', 'inner')
             ->join('frh_frecuencia_horario', 'gra_id_frh=frh_id', 'left')
             ->join('def_detalle_fact', 'lxp_id_def=def_id', 'left')
             ->where('lxp_estado', 1)
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($group != null) {
            $this->db->group_by($group);
        }

        return $query->get()->result_array();
    }

     /** 
     * @author Edith Herrera
     * @since  2018-02-07
     * @return Obtener la docentes según la categoría del escalafón.
    **/
    public function get_area_padre($where = NULL) {
    	
         $query = $this->db->select('p.ard_id, p.ard_nombre AS padre, h.ard_id, h.ard_nombre AS hijo', FALSE)
             ->from('ard_area_academica p')
             ->join('ard_area_academica h', 'h.ard_id_ard_padre= p.ard_id', 'left')
           
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }


   /** 
     * @author Edith Herrera
     * @since  2018-02-21
     * @return Obtener prerrequisitos según área y nivel.
     * Utilizado en la disponibilidad de cursos del docente.
    **/
    public function prerrequisito_n($where, $area){
		$this->db->select('pen.pen_id, pre_id_mod, mod_nombre, ard_id, ard_nombre AS area, pre.pen_id AS pensum', FALSE);
		$this->db->from('pen_pensum pen');
		$this->db->join('pre_prerrequisito','pre_id_pen=pen.pen_id','inner');
		$this->db->join('pen_pensum pre','pre_id_mod = pre.pen_id_mod AND pre.pen_id_ard = '.$area,'inner');
		$this->db->join('mod_modulo', 'mod_id = pre_id_mod');
		$this->db->join('ard_area_academica', 'ard_id = pen.pen_id_ard');
		
		if($where!=null){
			$this->db->where($where);
		}

		return $this->db->get()->result_array();
	}

	/**
	 * @author Edith Herrera 
	 * @since 2018-03-02
	 * @return Registros de grupos por proyección
	 *
	**/
	public function get_grupos_pyc($where=null){
		$this->db->select('gra_id,gra_nombre, gra_fecha_inicio, gra_fecha_fin, gra_estado, ard_nombre, aul_nombre, scc_nombre, frh_nombre, CONCAT(emp_nombre,emp_apellido) AS nombre', FALSE)
				 ->from('gra_grupo_academico')
				 ->join('pyc_proyeccion', 'gra_id_pyc = pyc_id')
				 ->join('ard_area_academica', 'gra_id_ard = ard_id','inner')
				 ->join('aul_aula','gra_id_aul = aul_id','inner')
				 ->join('dct_docente', 'dct_id = gra_id_dct')
				 ->join('emp_empleado', 'dct_id_emp = emp_id')
				 ->join('frh_frecuencia_horario', 'frh_id = gra_id_frh')
				 ->join('scc_seccion', 'scc_id = gra_id_scc', 'left')
				 ;
		
		if($where!=null){
			$this->db->where($where);
		}

		return $this->db->get()->result_array();
	}

	/**
	 * @author Edith Herrera 
	 * @since 2018-03-02
	 * @return Registros de grupos por proyección
	 *
	**/
	public function get_frecuenciasxalumno($where = null) {
        $query = $this->db->select('lxp_id, gra_id, gra_id_frh', FALSE)
        	 ->from('lxp_alumnoxpensum')
        	 ->join('gra_grupo_academico', 'gra_id = lxp_id_gra')
        	 ->join('lxa_alumnoxarea', 'lxa_id=lxp_id_lxa')
        	 ->where('lxp_estado',1)
        	;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();    
    }

    /**
	 * @author Edith Herrera 
	 * @since  2018-03-13
	 * @return Registros de docentes, aula, sección según frecuencia y proyección
	 * 
	**/
	public function get_infoxfrecuencia($where = null, $group=null) {
        $query = $this->db->select('gra_id, dct_id, emp_nombre, pyc_nombre, pyc_fecha_inicio, pyc_fecha_fin, aul_id, scc_id, sug_id, gra_id_pen', FALSE)
        	 ->from('gra_grupo_academico')
        	 ->join('dct_docente', 'gra_id_dct = dct_id')
        	 ->join('emp_empleado', 'dct_id_emp = emp_id')
        	 ->join('pyc_proyeccion', 'pyc_id = gra_id_pyc')
        	 ->join('aul_aula', 'aul_id = gra_id_aul')
        	 ->join('scc_seccion', 'scc_id = gra_id_scc', 'left')
        	 ->join('sug_supervisor_grupo', 'sug_id = gra_id_sug', 'left')
        	;

        if ($where != null) {
            $this->db->where($where);
        }

        if($group != null){
        	$this->db->group_by($group);
        }

        return $query->get()->result_array();    
    }

    /**
	 * @author Edith Herrera 
	 * @since  2018-04-10
	 * @return Materias por grado 
	**/
	public function get_materias_grado($where = null, $order=null, $group=null) {
        $query = $this->db->select("grd_id_ard, grd_id_art, grd_nombre, grd_estado, gxa_id, gxa_estado_grado, gra_id, gra_nombre, lxp_id, lxp_condicion, lxp_promedio, lxp_id_gra, lxp_id_fac, lxp_id_def, gra_id_pen, IF(mod_codigo <> '' ,CONCAT_WS(' - ',mod_codigo,mod_nombre),mod_nombre) AS nombre, mod_codigo, mod_nombre, alm_codigo_nie, CONCAT(alm_nombre,alm_apellido) AS alumno, alm_codigo, pen_id, gxa_id_alm, ard_nota_minima, ", FALSE)
        	 ->from('grd_grado')
        	 ->join('gxa_gradoxalumno', 'gxa_id_grd=grd_id') // en curso
        	 ->join('lxa_alumnoxarea', 'lxa_id_alm=gxa_id_alm')
        	 ->join('gra_grupo_academico', 'gra_id_grd=grd_id')
        	 ->join('lxp_alumnoxpensum', 'gra_id=lxp_id_gra AND lxa_id=lxp_id_lxa')
        	 ->join('alm_alumno', 'lxa_id_alm = alm_id')
        	 ->join('pen_pensum', 'gra_id_pen = pen_id')
        	 ->join('ard_area_academica', 'pen_id_ard = ard_id')
        	 ->join('mod_modulo', 'pen_id_mod= mod_id')
        	 ->join('aul_aula', 'gra_id_aul= aul_id')
        	 ->where('lxp_estado',1);

        if ($where != null) {
            $this->db->where($where);
        }

        if($group != null){
        	$this->db->group_by($group);
        }else{
        	$this->db->group_by('lxp_id');
        }
        
        if($order!=null){
        	$this->db->order_by($order, 'ASC');
        }
       
        return $query->get()->result_array();    
    }

     /**
	 * @author Edith Herrera 
	 * @since  2018-04-24
	 * @return Configuración de cargos REVISAR Y VERIFICAR
	 * 
	**/
     
    public function get_config_cargo_curso($where = null){
    	$query = "SELECT CFG.cfg_id, CFG.cfg_codigo, CFG.cfg_nombre, CFG.cfg_observacion, CFG.cfg_defecto, CFG.cfg_estado
	    	FROM cfg_configuracion_cargo CFG
	    	INNER JOIN dfc_detalle_configuracion_cargo DFC ON DFC.dfc_id_cfg = CFG.cfg_id
	    	INNER JOIN art_articulo ART ON ART.art_id = DFC.dfc_id_art
	    	INNER JOIN mod_modulo MODU ON MODU.mod_id_art = ART.art_id
	    	INNER JOIN pen_pensum PEN ON PEN.pen_id_mod = MODU.mod_id
	    	INNER JOIN ard_area_academica ARD ON ARD.ard_id = PEN.pen_id_ard
	    	INNER JOIN trd_tipo_area_academica TRD ON TRD.trd_id = ARD.ard_id_trd 
	    	WHERE TRD.trd_es_curso_libre = 1
	    	GROUP BY CFG.cfg_id"
	    ;
	    return $this->db->query($query)->result_array();
    }

	public function get_config_cargos($where = null) {
        $query = $this->db->select('cfg_codigo, cfg_defecto, cfg_nombre, cfg_observacion, dfc_dias_plazo, dfc_dia_fecha_cargo, dfc_numero_cuota, art.art_id as id_art, art.art_codigo as codigo, art.art_nombre as nombre, am.art_id as id_mora, am.art_codigo as cod_mora, am.art_nombre as art_mora, dfc_id, dfc_tipo_aplicacion_mora,
        	IF(ISNULL(dfc_tipo_aplicacion_mora), "", CASE WHEN dfc_tipo_aplicacion_mora = 1 THEN "Factor de Porcentaje (%)" ELSE "Valor (USD $)" END) AS nombre_tipo_apl_mora,
        	dfc_valor_mora',
			  FALSE)
        	 ->from('cfg_configuracion_cargo')
        	 ->join('dfc_detalle_configuracion_cargo', 'cfg_id = dfc_id_cfg') // en curso
        	 ->join('art_articulo as art', 'dfc_id_art = art.art_id')
        	 ->join('art_articulo as am', 'dfc_id_art_mora = am.art_id ', 'left')
        	 ->where('cfg_estado',1)
        	;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();    
    }


     /**
	 * @author Edith Herrera 
	 * @since  2018-05-28
	 * @return Grados según proyección - muestra únicamente los grados incluidos en un grupo
	**/
	public function get_grados_pyc($where = null) {
        $query = $this->db->select()
        	 ->from('ard_area_academica')
        	 ->join('pyc_proyeccion', 'ard_id = pyc_id_ard') 
        	 ->join('gra_grupo_academico', 'gra_id_pyc = pyc_id')
        	 ->join('grd_grado', 'pyc_id_ard = grd_id_ard AND gra_id_grd = grd_id')
        	;

        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('grd_id');
       
        return $query->get()->result_array();    
    }


    /**
	 * @author Edith Herrera 
	 * @since  2018-06-05
	 * @return Periodos por nivel-pensum
	**/
	public function get_periodos_informe($where = null, $group=null, $order=null) {
        $query = $this->db->select('evm_id, evm_id_pev, pev_nombre, tev_nombre, noa_nota, lxa_id_alm, lxa_id', FALSE)
        	 ->from('evm_evaluacion_modulo')
        	 ->join('pev_periodo_evaluacion', 'evm_id_pev = pev_id') 
        	 ->join('tev_tipo_evaluacion', 'evm_id_tev = tev_id') 
        	 ->join('noa_nota_alumno', 'evm_id = noa_id_evm', 'left') 
        	 ->join('lxp_alumnoxpensum', 'lxp_id = noa_id_lxp', 'left') 
        	 ->join('lxa_alumnoxarea', 'lxp_id_lxa = lxa_id', 'left') 
        	;

        if ($where != null) {
            $this->db->where($where);
        }

        if($group != null){
       		$this->db->group_by($group);
        }

        if($order != null){
        	$this->db->order_by($order, 'ASC');
        }

        return $query->get()->result_array();    
    }


    /**
	 * @author Edith Herrera 
	 * @since  2018-09-29
	 * @return Promedios por periodo
	**/
	public function get_promedio_periodo($where = null) {
        $query = $this->db->select('FORMAT(SUM((evm_porcentaje_periodo/100)*noa_nota),1) AS nota, evm_porcentaje_periodo AS porcen, (FORMAT(SUM((evm_porcentaje_periodo/100)*noa_nota), 1)*(evm_porcentaje_periodo/100)) AS promedio, pev_orden', FALSE)
        	 ->from('pen_pensum')
        	 ->join('evm_evaluacion_modulo', 'evm_id_pen = pen_id') 
        	 ->join('pev_periodo_evaluacion', 'evm_id_pev = pev_id') 
        	 ->join('noa_nota_alumno', 'noa_id_evm = evm_id')
        	;

        if ($where != null) {
            $this->db->where($where);
        }

       	$this->db->group_by('noa_id_lxp, evm_id_pev');
       	$this->db->order_by('pev_orden', 'ASC');

        return $query->get()->result_array();    
    }

    /**
     * @author Edith Herrera
     * @since  12-10-2018
     * @return Obtener niveles 
    * */
    function get_nivel_proyeccion($where=NULL) {

        $query = $this->db->select()
                 ->from('pyc_proyeccion')
                 ->join('ard_area_academica', 'pyc_id_ard=ard_id')
                 ->join('pen_pensum', 'ard_id = pen_id_ard')
                 ->join('gra_grupo_academico', 'gra_id_pen = pen_id AND gra_id_pyc = pyc_id')
                 ->join('mod_modulo', 'pen_id_mod = mod_id')
        ;

        if ($where != NULL) {
            $this->db->where($where);
        }
        $this->db->group_by('pen_id');
        return $query->get()->result_array();
    }


     /**
	 * @author Edith Herrera 
	 * @since  2018-04-30
	 * @return Configuración de cargos generados al alumno
	 * 
	**/
	public function get_cargos_alumno($where = null) {
        $query = $this->db->select('cfg_codigo, cfg_defecto, cfg_nombre, cfg_observacion, dfc_dias_plazo, dfc_dia_fecha_cargo, dfc_numero_cuota,art_id as id_art,art_codigo as codigo,art_nombre as nombre, dfc_id, clg_fecha, clg_monto, clg_fecha_vencimiento, clg_nombre', FALSE)
        	 ->from('cfg_configuracion_cargo')
        	 ->join('dfc_detalle_configuracion_cargo', 'cfg_id = dfc_id_cfg') // en curso
        	 ->join('art_articulo', 'dfc_id_art = art_id')
        	 ->join('clg_cargo_alumnoxgrado', 'clg_id_art = art_id')
        	 ->where('cfg_estado',1)
        	;

        if ($where != null) {
            $this->db->where($where);
        }
       	
       	$this->db->group_by('clg_id');

        return $query->get()->result_array();    
    }

    /** 
     * @author Luis Navarro
     * @since  05-12-2018
     * @return Obtener informacion de los medios por lo cual se entero del programa
    **/
    public function get_reporte_medio_se_entero($where = null, $groupby = null, $orderby = null) {

        $query = $this->db->select(
                '
                    alm_id,
                    alm_codigo,
                    alm_nombre,
                    alm_apellido,
                    alm_fecha_nacimiento,
                    (
                        TIMESTAMPDIFF(YEAR,alm_fecha_nacimiento, NOW())
                    ) AS fecha_nac,
                    gen_nombre
                '
                , false
                )
            ->from('alm_alumno')
            ->join('gen_genero', 'gen_id = alm_id_gen', 'inner')
            ->join('mxl_medioxalumno', 'alm_id = mxl_id_alm', 'left')
            ->join('tmc_tipo_medio', 'tmc_id = mxl_id_tmc', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }

    public function formato_sustitucion($where = null){
        $this->db->select("*, CONCAT(emtit.emp_nombre,' ',emtit.emp_apellido) AS titular, CONCAT(emsus.emp_nombre,' ',emsus.emp_apellido) AS sustituto", false);
        $this->db->from('stm_sustituto_maestro');
        $this->db->join('gra_grupo_academico', 'gra_id = stm_id_gra');
        $this->db->join('ard_area_academica', 'ard_id = gra_id_ard');
        $this->db->join('dhs_detalle_horario_sustituir', 'stm_id = dhs_id_stm');
        $this->db->join('dfr_detalle_frecuencia', 'dfr_id = dhs_id_dfr AND dfr_estado = 1'); 
        $this->db->join('hrg_horario_grupo', 'hrg_id = dfr_id_hrg');
        $this->db->join('dct_docente as tit', 'stm_id_dct_titular = tit.dct_id');
        $this->db->join('dct_docente as sus', 'stm_id_dct_sustituto = sus.dct_id');
        $this->db->join('emp_empleado as emtit', 'emtit.emp_id = tit.dct_id_emp');
        $this->db->join('emp_empleado as emsus', 'emsus.emp_id = sus.dct_id_emp');
        $this->db->join('pen_pensum', 'pen_id = gra_id_pen', 'left');
        $this->db->join('mod_modulo', 'mod_id = pen_id_mod', 'left'); 
        $this->db->join('pyc_proyeccion', 'gra_id_pyc = pyc_id','left');
        $this->db->join('scc_seccion', 'scc_id=gra_id_scc', 'left');
        $this->db->join('aul_aula', 'aul_id=gra_id_aul', 'left');        
        $this->db->join('frh_frecuencia_horario', 'frh_id = gra_id_frh');
        if ($where != null) {
            $this->db->where($where);
        }        
        $result = $this->db->get()->result_array();
        return $result;
    }

    //ADDED ON SEP/19 BY RAUL E. //VERIFICAR UTILIDAD, SINO ELIMINAR 
    public function get_notas_alumnos2($where = null) {
        $query = $this->db->select("*", false)
                ->from('gra_grupo_academico')
                ->join('pyc_proyeccion', 'gra_id_pyc = pyc_id')
                ->join('lxp_alumnoxpensum', 'lxp_id_gra = gra_id')
                ->join('noa_nota_alumno', 'noa_id_lxp = lxp_id')                
                ->join('lxa_alumnoxarea', 'lxp_id_lxa = lxa_id')
                ->join('alm_alumno', 'lxa_id_alm = alm_id')
                ->join('pen_pensum', 'gra_id_pen = pen_id')
 				->join('mod_modulo', 'pen_id_mod = mod_id')
 				->join('ard_area_academica', 'ard_id = pen_id_ard')
 				->where('lxp_estado', 1)
        ;
        if ($where != null) {
            $this->db->where($where);
        }       
        return $query->get()->result_array();
    }

    public function get_cursosXalumno($where=null){
    	$query = $this->db->select("mod_id, grd_nombre, mod_nombre, lxp_tipo_inscripcion, pyc_fecha_inicio AS fecha_inicio, pyc_fecha_fin AS fecha_finalizacion,
    		CASE WHEN lxp_condicion = 1 THEN 'Inscrito' WHEN lxp_condicion = 2 THEN 'Aprobado' WHEN lxp_condicion = 3 THEN 'Reprobado' WHEN  lxp_condicion = 4 THEN 'Retiro' 
    		ELSE '' END AS condicion, IFNULL((SELECT SUM((e.evm_porcentaje_periodo * n.noa_nota)/100) FROM evm_evaluacion_modulo e JOIN pen_pensum p ON e.evm_id_pen = p.pen_id 
    		JOIN noa_nota_alumno n ON n.noa_id_evm = e.evm_id JOIN mod_modulo m ON m.mod_id = p.pen_id_mod LEFT JOIN pev_periodo_evaluacion pv ON pv.pev_id = e.evm_id_pev 
    		WHERE m.mod_id = mod_id AND n.noa_id_lxp = lxp_id) / (SELECT COUNT(DISTINCT e.evm_id_pev) FROM evm_evaluacion_modulo e JOIN pen_pensum p ON e.evm_id_pen = p.pen_id 
    		JOIN mod_modulo m on m.mod_id = p.pen_id_mod JOIN pev_periodo_evaluacion v ON v.pev_id = e.evm_id_pev WHERE m.mod_id = mod_id), -1) AS nota_final", false)
                ->from('lxp_alumnoxpensum')
                ->join('lxa_alumnoxarea', 'lxa_id = lxp_id_lxa')
				->join('ard_area_academica', 'ard_id = lxa_id_ard')
				->join('trd_tipo_area_academica', 'trd_id = ard_id_trd and trd_es_curso_libre = 1')
                ->join('gra_grupo_academico', 'gra_id = lxp_id_gra')
                ->join('pyc_proyeccion', 'pyc_id = gra_id_pyc')                
                ->join('pen_pensum', 'pen_id = gra_id_pen')
 				->join('mod_modulo', 'mod_id = pen_id_mod')
                ->join('grd_grado', 'grd_id = gra_id_grd', 'LEFT')
        ;
        if ($where) {
            $this->db->where($where);
        }       
        return $query->get()->result_array();
    }

    public function get_info_extra_cons($where = NULL) {    	
    	$query = $this->db->select('*, IF(pen_id_mod_siguiente IS NULL,"",(SELECT mod_nombre FROM mod_modulo m2 WHERE m2.mod_id = pen_id_mod)) AS mod_siguiente', FALSE)
             ->from('ard_area_academica')
             ->join('pen_pensum', 'pen_id_ard = ard_id')
             ->join('mod_modulo', 'pen_id_mod = mod_id')
             ->join('gra_grupo_academico', 'gra_id_pen = pen_id')
             ->join('lxp_alumnoxpensum', 'lxp_id_gra = gra_id')
             ->join('lxa_alumnoxarea', 'lxp_id_lxa = lxa_id AND lxa_id_ard = ard_id')
             ->join('alm_alumno', 'alm_id = lxa_id_alm')
             ->join('frh_frecuencia_horario', 'gra_id_frh = frh_id')
             ->join('art_articulo', 'mod_id_art = art_id') 
             ->join('scc_seccion', 'scc_id = gra_id_scc')  
             ->join('aul_aula', 'aul_id = gra_id_aul')
             ->join('dct_docente', 'dct_id = gra_id_dct')     
             ->join('emp_empleado', 'emp_id = dct_id_emp') 
             ->join('grd_grado', 'grd_id_ard = ard_id')
             ->join('gxa_gradoxalumno', 'gxa_id_grd = grd_id')
             ->join('pyc_proyeccion', 'pyc_id_ard = ard_id')
             ->join('def_detalle_fact', 'def_id = lxp_id_def')
             ->join('evm_evaluacion_modulo', 'evm_id_pyc = pyc_id')
             ->join('pev_periodo_evaluacion', 'evm_id_pev = pev_id')
             ->join('noa_nota_alumno', 'noa_id_lxp = lxp_id AND noa_id_evm = evm_id')
             ->join('cfg_configuracion_cargo', 'grd_id_cfg = cfg_id')
             ->join('dfc_detalle_configuracion_cargo', 'dfc_id_cfg = cfg_id')
             ->join('hrg_horario_grupo', 'hrg_id = gra_id_hrg', 'left')
             ->join('asg_asistencia_grupo', 'asg_id_gra = gra_id', 'left')
             ->join('dsg_detalle_asistencia', 'dsg_id_asg = asg_id AND dsg_id_alm = alm_id', 'left')
             ->join('trd_tipo_area_academica', 'trd_id = ard_id_trd', 'left')
             ->join('dcg_detalle_cierre_grupo', 'dcg_id_gra = gra_id', 'left')             
             ->where('lxp_estado', 1)
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

	public function get_cuotas_curso_libre($where=null){
    	$query = $this->db->select("*, 
					IF(cmc_impuestos IS NULL, 0 + cmc_monto, cmc_impuestos + cmc_monto) AS total_cuota_pagar,
					CASE WHEN cmc_estado_cargo = 0 THEN 'Eliminado'
						WHEN cmc_estado_cargo = 1 THEN 'Pendiente'
						WHEN cmc_estado_cargo = 2 AND cmc_id_fac IS NULL THEN 'Pago pendiente de facturar' 
						WHEN cmc_estado_cargo = 2 AND cmc_id_fac IS NOT NULL THEN 'Pagado y facturado'
					END AS estado_cargo", FALSE)
                ->from('cmc_cargo_alumnoxcurso')
                ->join('lxp_alumnoxpensum', 'lxp_id = cmc_id_lxp')
                ->join('gra_grupo_academico', 'lxp_id_gra = gra_id')
                ->join('pen_pensum', 'gra_id_pen = pen_id')
                ->join('mod_modulo', 'pen_id_mod = mod_id')
				->join('lxa_alumnoxarea', 'lxp_id_lxa = lxa_id')
             	->join('alm_alumno', 'alm_id = lxa_id_alm')
        	;

        if ($where != null) {
            $this->db->where($where);
        }     

        $this->db->group_by('cmc_id');
        
        return $query->get()->result_array();
    }

    public function get_areasXproyeccion($where=null){
    	$query = $this->db->select("ard_area_academica.*", false)
    		->from('axy_areas_x_proyecion')
    		->join('ard_area_academica', 'ard_id = axy_id_ard')
    	;
    	if ($where) {
    		$this->db->where($where);
    	}       
    	return $query->get()->result_array();
    }


	public function get_gradosxalumno($where=null) {

		
		$query = $this->db->select("grd_id, grd_nombre, lxp_tipo_inscripcion, pyc_fecha_inicio AS fecha_inicio, pyc_fecha_fin AS fecha_finalizacion,
    		CASE WHEN lxp_condicion = 1 THEN 'Inscrito' WHEN lxp_condicion = 2 THEN 'Aprobado' WHEN lxp_condicion = 3 THEN 'Reprobado' WHEN  lxp_condicion = 4 THEN 'Retiro' 
    		ELSE '' END AS condicion", false)
                ->from('lxp_alumnoxpensum')
                ->join('lxa_alumnoxarea', 'lxa_id = lxp_id_lxa')
                ->join('gra_grupo_academico', 'gra_id = lxp_id_gra')
                ->join('pyc_proyeccion', 'pyc_id = gra_id_pyc')  
                ->join('grd_grado', 'grd_id = gra_id_grd')
        ;
        if ($where) {
            $this->db->where($where);
        }       
        return $query->get()->result_array();

	}

	public function get_cuotas_grados($where=null) {
		$query = $this->db->select("*, 
					IF(clg_impuestos IS NULL, 0 + clg_monto, clg_impuestos + clg_monto) AS total_cuota_pagar,
					CASE WHEN clg_estado_cargo = 0 THEN 'Eliminado'
						WHEN clg_estado_cargo = 1 THEN 'Pendiente'
						WHEN clg_estado_cargo = 2 AND clg_id_fac IS NULL THEN 'Pago pendiente de facturar' 
						WHEN clg_estado_cargo = 2 AND clg_id_fac IS NOT NULL THEN 'Pagado y facturado'
					END AS estado_cargo", FALSE)
                ->from('clg_cargo_alumnoxgrado')
				->join('gxa_gradoxalumno', 'gxa_id = clg_id_gxa')
				->join('grd_grado', 'grd_id = gxa_id_grd')
                ->join('gra_grupo_academico', 'gra_id_grd = grd_id')
                ->join('lxp_alumnoxpensum', 'lxp_id_gra = gra_id')
				->join('lxa_alumnoxarea', 'lxp_id_lxa = lxa_id')
             	->join('alm_alumno', 'alm_id = lxa_id_alm')
        	;

        if ($where != null) {
            $this->db->where($where);
        }     

        $this->db->group_by('clg_id');
        
        return $query->get()->result_array();
	}

	//obtener informacion alumno / articulo
	public function get_informacion_alumno_curso($where = null){
        
        $this->db->select("trd_es_curso_libre, gfa_id, gfa_cantidad, alm_aplica_gfa", false)
            ->from('lxp_alumnoxpensum')
            ->join('gra_grupo_academico','gra_id = lxp_id_gra', 'inner')
            ->join('pen_pensum','pen_id = gra_id_pen', 'inner')
            ->join('mod_modulo','mod_id = pen_id_mod', 'inner')
			->join('lxa_alumnoxarea','lxa_id = lxp_id_lxa', 'inner')
            ->join('alm_alumno','alm_id = lxa_id_alm', 'inner')
			->join('gfa_grupo_familiar', 'gfa_id = alm_id_gfa', 'left')
            ->join('aul_aula', 'gra_id_aul = aul_id', 'left')
            ->join('scc_seccion', 'gra_id_scc = scc_id', 'left')
			->join('ard_area_academica', 'ard_id = lxa_id_ard', 'inner')
			->join('trd_tipo_area_academica', 'trd_id = ard_id_trd', 'inner')
            ->join('grd_grado', 'gra_id_grd = grd_id', 'left')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

	public function get_registro_monto_menor($where = null){
        
        $this->db->select('lip_precio, alm_id_cli, mod_id_art', false)
			->from('lxp_alumnoxpensum')
			->join('gra_grupo_academico', 'gra_id = lxp_id_gra', 'inner')
			->join('pen_pensum', 'pen_id = gra_id_pen', 'inner')
			->join('mod_modulo', 'mod_id = pen_id_mod', 'inner')
			->join('lxa_alumnoxarea', 'lxa_id = lxp_id_lxa', 'inner')
			->join('alm_alumno', 'alm_id = lxa_id_alm', 'inner')
			->join('ard_area_academica', 'ard_id = lxa_id_ard', 'inner')
			->join('trd_tipo_area_academica', 'trd_id = ard_id_trd', 'inner')
			->join('lip_listado_precio', 'lip_id_art = mod_id_art', 'inner')
        ;

        if($where != null){
            $this->db->where($where);
        }

		$this->db->order_by('lip_precio', 'asc');

		$this->db->limit(1);

        return $this->db->get()->result_array();
    }


} // End 