<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Proyecto_model extends CI_Model {

    function __construct() {
        $this->load->database();
    }

    //FUNCION PARA PREGUNTAR SI UN REGISTRO EXISTE
//public function existe_cotizacion_GP($tabla,$DatosarregloAsociativo,$campoCondicion="",$valorCondicion="") {
    public function Existe_Registro($tabla, $DatosarregloWhere) {

        $this->db->select("*")
                ->from($tabla)
                ->where($DatosarregloWhere)
        ;
        $nreg = $this->db->count_all_results();
        return $nreg;
    }

    public function get_registro($tabla, $where, $id) {

        $this->db->select()
                ->from($tabla)
                ->where($where, $id);

        $query = $this->db->get();
        return $query->row();
    }

    public function get_ordenes($where = null) {
        $this->db->select()
                ->from('ord_orden')
                ->join('cli_cliente', 'ord_id_cli = cli_id', 'left')
                ->join('cot_cotizacion', 'cot_id_cli = cli_id', 'left')
                ->join('tio_tipo_orden', 'ord_id_tio = tio_id', 'left')
                ->join('pcl_proyecto_cliente', 'pcl_id = ord_id_pcl', 'left')
                ->join('dpp_detalle_programacion_produccion', 'dpp_id_ord = ord_id', 'left')
                ->group_by('ord_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        //die(print_r($this->db->last_query()));
        return $this->db->get()->result_array();
    }

//FUNCION QUE ME DEVOLVERÁ LOS IDs DE LOS VENDEDORES QUE PERTENECEN A UN SUPERVISOR (vendedor o supervisor son un usuario) 
    public function get_idsVendedoresxSupervisor($id_usuario) {

        $this->db->select('GROUP_CONCAT(vxs_id_ven) AS vendedores_ids')
                ->FROM('vxs_vendedorxsupervisor')
                ->join('sup_supervisor', 'vxs_vendedorxsupervisor.vxs_id_sup = sup_supervisor.sup_id')
                ->join('ven_vendedor', 'vxs_vendedorxsupervisor.vxs_id_ven = ven_vendedor.ven_id')
                ->where('ven_estado', 1)
                ->where('sup_id_usu', $id_usuario)
                ->where('sup_estado', 1);

        $query = $this->db->get()->row_array();
        $ids = $query['vendedores_ids'];
        if (strlen($ids) > 0) {
            $ids = $ids;
        } else {
            $ids = "0";
        }
        return $ids;
    }

    //funcion trae los usuarios que no han sido asignaados a supervisores
    public function getusername() {
        $this->db->select('GROUP_CONCAT(id) as usu');
        $this->db->FROM('users');
        $this->db->where('id NOT IN (SELECT DISTINCT ven_id_usu FROM ven_vendedor WHERE ven_id_usu IS NOT NULL UNION SELECT DISTINCT sup_id_usu FROM sup_supervisor WHERE sup_id_usu IS NOT NULL )', null, false);

        $query = $this->db->get()->row_array();
        return $query['usu'];
    }

    public function existeRegistroEtapa($tabla, $id1, $Valorid1, $id2, $Valorid2, $tipo = 0, $idActual = 0) {
        //tipo = 0 insert
        //tipo = 1 update
        //idActual cuando es actualizacion

        if ($tipo == 0 and $idEtapaActual == 0) {
            $this->db->select('*')
                    ->from($tabla)
                    ->where($id1, $Valorid1)
                    ->where($id2, $Valorid2);

            $nregistros = $this->db->count_all_results();
        } else {
            $this->db->select('*')
                    ->from($tabla)
                    ->where($id1, $Valorid1)
                    ->where($id2, $Valorid2)
                    ->where("$id1 !=", $idActual)
            ;

            $nregistros = $this->db->count_all_results();
        }
        return $nregistros; //devolver el numero de filas afectadas por la consulta
    }

    public function get_categoriasPadre_hijos() {
        $query = $this->db->query("SELECT sub_cat.*,tia_tipo_articulo.tia_nombre AS padre FROM tia_tipo_articulo 
              INNER JOIN tia_tipo_articulo AS  sub_cat ON tia_tipo_articulo.tia_id=sub_cat.tia_padre AND tia_tipo_articulo.tia_padre IS NULL
              UNION
              SELECT tia_tipo_articulo.*,tia_tipo_articulo.tia_padre AS padre FROM tia_tipo_articulo WHERE tia_tipo_articulo.tia_padre IS NULL
              ORDER BY tia_id DESC ")->result_array();
        $ids = array();
        foreach ($query as $fila) {
            $ids[] = $fila['tia_id'];
        }
        return (count($ids) > 0) ? implode(',', $ids) : '0';
    }

    function categorias_hijas_padres($id) {
        $query = $this->db->query("SELECT
	    tia_id AS id,
	    tia_nombre AS categoria,
	    (
	      SELECT
	        tia_nombre
	      FROM
	        tia_tipo_articulo B
	      WHERE
	        B.tia_id = A.tia_padre
	   
	    ) AS departamento
	  FROM tia_tipo_articulo A
	  WHERE 
	  A.tia_id=$id")->result_array();
        return $query;
    }

    /**
     * @autor:  Edith Herrera
     */
    public function listaarticulo($cod_axc) {
        $this->db->select('art_id, art_codigo, art_nombre, axo_id_art, axo_id, axo_id_ord')
                ->from('axo_articuloxorden')
                ->join('art_articulo', 'axo_id_art=art_id');

        //$this->db->where('axc_id_cot',$cod_art);
        $this->db->where('axo_id', $cod_axc);
        $this->db->limit(1);

        $lst = $this->db->get()->result_array();
        return $lst;
    }

    public function obtenercodigo() {
        $this->db->select('max(ven_id) + 1 as codigo')->from('ven_vendedor');
        $r = $this->db->get()->row_array();
        return $r;
    }

    public function get_mano_obra($id_axo, $id_mxo = NULL) {
        $this->db->select()
                ->from('mxo_mano_obraxarticulo_ord')
                ->join('emp_empleado', 'emp_id=mxo_id_emp', 'left')
                ->join('mob_mano_obra', 'mob_id=mxo_id_mob')
                ->where('mxo_estado', 1)
                ->where('mxo_id_axo', $id_axo)
        ;
        if (!empty($id_mxo)) {
            $this->db->where('mxo_id', $id_mxo);
        }
        return $this->db->get()->result_array();
    }

    public function info_planilla($id_sxm) {
        $this->db->select()
                ->from('sxm_seguimiento_mano_obraxarticulo_ord')
                ->join('mxo_mano_obraxarticulo_ord', 'mxo_id = sxm_id_mxo')
                ->join('emp_empleado', 'emp_id=mxo_id_emp')
                ->join('mob_mano_obra', 'mob_id=mxo_id_mob')
                ->join('axo_articuloxorden', 'axo_id = mxo_id_axo')
                ->join('ord_orden', 'ord_id = axo_id_ord')
                ->join('pcl_proyecto_cliente', 'pcl_id = ord_id_pcl','left')
                ->where('sxm_id', $id_sxm)
        ;
        return $this->db->get()->result_array();
    }

    public function get_seguimiento_mano_obra($where) {
        $this->db->select()
                ->from('sxm_seguimiento_mano_obraxarticulo_ord')
                ->join('mxo_mano_obraxarticulo_ord', 'mxo_id = sxm_id_mxo', 'left')
                ->join('ddi_detalle_ingreso', 'ddi_id_inn = sxm_id_inn', 'left')
                ->where($where)
        ;
        return $this->db->get()->result_array();
    }

    public function no_procesados($where) {
        $this->db->select('sxm_id')
                ->from('sxm_seguimiento_mano_obraxarticulo_ord')
                ->join('ddi_detalle_ingreso', 'ddi_id_inn = sxm_id_inn', 'left')
                ->where($where)
                ->where('sxm_id_inn IS NOT NULL AND ddi_id_inn IS NULL')
        ;
        return $this->db->get()->result_array();
    }

    public function get_correlativo() {
        $this->db->select('count(ord_id) as correlativo', false)
                ->from('ord_orden');
        return $this->db->get()->row_array();
    }

    function crear_arbol($padre, $prefijo) {
        $prefijo = "";
        $cadena = "";
        $q = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1, 'tia_padre' => $padre));
        if ($q) {

            foreach ($q as $fila) {
                $cadena .= $fila['tia_id'] . ',';
                $cadena .= $this->crear_arbol($fila['tia_id'], '');
            }
        }
        return $cadena;
    }

    /**
     * Modified by: Edith Herrera
     * @since 17/10/2017  
     * Se obtienen productos, dependiendo del tipo de artículo (artículo, servicio) o si es un activo.
     */
    function get_productos_like($where = null, $like = null, $consulta=0, $producto=null) {

        if($consulta==1){ // si es activo
            $query = $this->db->select("*")->from('act_activo_fijo');

            if ($producto != null) {
                $this->db->or_like('act_codigo', $producto);
                $this->db->or_like('act_nombre', $producto);
            }
        } else{
            $categorias_final = null;
            if (isset($where['art_id_tia'])) {
                $categorias_final = $this->crear_arbol($where['art_id_tia'], "");
                $categorias_final = $categorias_final . $where['art_id_tia'];
                unset($where['art_id_tia']);
            }

            $query = $this->db->select("*, (SELECT IFNULL(mrp_nombre, '') FROM mrp_marca_producto WHERE mrp_id = art_id_mrp) AS mrp_nombre", false)
                    ->from('art_articulo')
                    ->join('ppr_presentacion_producto', 'ppr_id = art_id_ppr', 'left')
                    ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1')
                    ->join('mep_medida_producto', 'mep_id = cva_id_mep')
                    ->join('cdp_codigo_producto', 'cdp_id_art=art_id', 'left')
            ;
            
            if ($categorias_final != null) {
                $categorias = explode(',', $categorias_final);

                $this->db->where_in('art_id_tia', $categorias);
            }
          
            if ($where != null) {
                $this->db->where($where);
            }

            if ($like != null) {
                $this->db->or_like($like);
            }
        }



        if($consulta==1){
            $this->db->group_by('act_id');
        }else{
            $this->db->group_by('art_id');
        }

        return $query->get()->result_array();
    }

    /**
     * @author Mario Marquez  
     * @method Regresa el listado de clientes por posibles coincidencias
     * @property array $where 'Array de filtros a usar'
     * @property array $like 'Concidencias con el nombre'
     */
    public function get_clientes($where = null, $like = null) {
        $query = $this->db->select("*, CASE WHEN cli_personeria = 1 THEN
            CONCAT_WS(' ',cli_codigo,' - ',cli_nombre, cli_apellido)
            ELSE CONCAT_WS(' ',cli_codigo,' - ',cli_apellido) END as cliente", false)
                ->from('cli_cliente')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->like($like);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_cotizacion($where = null) {
        $query = $this->db->select("*, (SELECT cog_numero_orden FROM cog_cotiz_ganada WHERE cog_id_cot = axc_id_cot LIMIT 1) AS cog_numero_orden", false)
                ->from('axc_articuloxcotizacion')
                ->join('art_articulo', 'art_id = axc_id_art', 'inner')
                ->join('cva_conversion_articulo', 'cva_id = axc_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')

        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_caracteristicas_cot($where = null) {
        $this->db->select()
                ->from('cxo_caracxarticuloxcotizacion')
                ->join('cxu_caracxarticulo', ' cxu_id = cxo_id_cxu', 'inner')
                ->join('cxr_caractxtipo_articulo', ' cxr_id = cxu_id_cxr')
                ->join('car_caracteristica', ' car_id = cxr_id_car')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_detalle_orden($where = null, $where_in = null, $where_in_ord = null ) {
        $query = $this->db->select("*, (SELECT GROUP_CONCAT( CONCAT( car_nombre, ': ', cdo_valor ),' ' ) FROM cdo_caracteristicaxdetalle_orden 
            INNER JOIN cxu_caracxarticulo ON cxu_id = cdo_id_cxu INNER JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr INNER JOIN car_caracteristica ON car_id = cxr_id_car
            WHERE cdo_id_axo = axo_id ) AS caracteristicas,
            (SELECT GROUP_CONCAT(lop_nombre) AS lotes FROM lop_lote_produccion WHERE lop_id_axo = axo_id ) AS lotes,
            (SELECT IFNULL(SUM(deo_cantidad), 0) FROM deo_detalle_envio_orden INNER JOIN eno_envio_orden ON eno_id = deo_id_eno WHERE deo_id_axo = axo_id AND eno_estado = 1) cantidad_enviada,
            IF( (SELECT axc_personalizado FROM axc_articuloxcotizacion WHERE axc_id = axo_id_axc) = 1,'Personalizado', 'Estandar') as personalizado
            ", false)
                ->from('axo_articuloxorden')
                ->join('art_articulo', 'art_id = axo_id_art', 'inner')
                ->join('cva_conversion_articulo', 'cva_id = axo_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($where_in != null) {
            $this->db->where_in('axo_id', $where_in);
        }

        if ($where_in_ord != null) {
            $this->db->where_in('axo_id_ord', $where_in_ord);
        }
        return $query->get()->result_array();
    }

    public function get_detalle_caracteristicas_orden($where = null) {
        $this->db->select()
                ->from('cdo_caracteristicaxdetalle_orden')
                ->join('cxu_caracxarticulo', ' cxu_id = cdo_id_cxu', 'inner')
                ->join('cxr_caractxtipo_articulo', ' cxr_id = cxu_id_cxr')
                ->join('car_caracteristica', ' car_id = cxr_id_car')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_lotes($where = null) {
        $query = $this->db->select("*, (SELECT SUM(exo_duracion) AS etapas FROM exo_etapaxarticulo_orden WHERE lop_id = exo_id_lop) AS num_etapas,
            (SELECT SUM(exo_duracion_mano_obra) AS etapas FROM exo_etapaxarticulo_orden WHERE lop_id = exo_id_lop) AS num_etapas_mod,
            (SELECT COUNT(moe_id) FROM moe_movimiento_etapa JOIN exo_etapaxarticulo_orden ON exo_id = moe_id_exo WHERE exo_id_lop = lop_id) AS num_moe_jt,
            (SELECT GROUP_CONCAT(etp_nombre ORDER BY exo_orden) AS etapas FROM etp_etapa INNER JOIN exo_etapaxarticulo_orden ON exo_id_etp = etp_id 
                WHERE exo_id_lop = lop_id ORDER BY exo_orden) AS etapas", false)
            ->from('lop_lote_produccion')
            ->join('axo_articuloxorden', 'axo_id = lop_id_axo', 'inner')
            ->join('art_articulo', 'art_id = axo_id_art', 'inner')
            ->join('cva_conversion_articulo', 'cva_id = axo_id_cva', 'left')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_envio($where = null) {
        $query = $this->db->select()
                ->from('deo_detalle_envio_orden')
                ->join('axo_articuloxorden', 'axo_id = deo_id_axo', 'inner')
                ->join('art_articulo', 'art_id = axo_id_art', 'inner')
                ->join('cva_conversion_articulo', 'cva_id = axo_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
                ->join('scl_sucursal_cliente', 'scl_id = deo_id_scl', 'left')
                ->join('con_contacto', 'con_id = deo_id_con', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_etapas($where = null) {
        $query = $this->db->select()
                ->from('etp_etapa')
                ->join('bod_bodega', 'bod_id = etp_id_bod', 'left')
                ->join('sxb_sectorxbodega', 'sxb_id = etp_id_sxb', 'left')
                ->join('seb_sector_bodega', 'seb_id = sxb_id_seb', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_etapas_lotes($where = null, $order_by = 'exo_orden asc') {
        $query = $this->db->select("*, (SELECT COUNT(*) FROM moe_movimiento_etapa where moe_id_exo = exo_id) as movimientos,
                    (SELECT art_id FROM art_articulo WHERE art_id = axo_id_art) AS art_id,
                    (SELECT CONCAT(art_codigo,'<br>',art_nombre) FROM art_articulo WHERE art_id = axo_id_art) AS art_nombre,
                    (SELECT art_nombre FROM art_articulo WHERE art_id = axo_id_art) AS art_nom_art, 
                    IFNULL((SELECT SUM((axm_cantidad * axm_precio)) FROM axm_articulo_matxarticulo_ord WHERE axm_id_axo = axo_id), 0) AS axo_mat_prim,
                    IFNULL((SELECT SUM((mxo_cantidad * mxo_precio)) FROM mxo_mano_obraxarticulo_ord WHERE mxo_id_axo = axo_id), 0) AS axo_man_obra,
                    IFNULL((SELECT SUM(exr_monto_calculo) FROM exr_estimacionxarticulo WHERE exr_id_axo = axo_id), 0) AS axo_gif
                ", false)
                ->from('etp_etapa')
                ->join('exo_etapaxarticulo_orden', 'exo_id_etp = etp_id', 'inner')
                ->join('bod_bodega', 'bod_id = etp_id_bod', 'left')
                ->join('sxb_sectorxbodega', 'sxb_id = etp_id_sxb', 'left')
                ->join('seb_sector_bodega', 'seb_id = sxb_id_seb', 'left')
                ->join('lop_lote_produccion', 'lop_id = exo_id_lop', 'inner')
                ->join('axo_articuloxorden', 'axo_id = lop_id_axo', 'inner')
                ->join('ord_orden', 'ord_id = axo_id_ord', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($order_by != '') {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    public function get_etapas_articulo($where = null) {
        $query = $this->db->select()
                ->from('etp_etapa')
                ->join('eta_etapa_articulo', 'eta_id_etp = etp_id', 'inner')
                ->join('bod_bodega', 'bod_id = etp_id_bod', 'left')
                ->join('sxb_sectorxbodega', 'sxb_id = etp_id_sxb', 'left')
                ->join('seb_sector_bodega', 'seb_id = sxb_id_seb', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_movimientos_producto($where = null) {
        $query = $this->db->select()
                ->from('moi_movimiento_inv')
                ->join('dee_detalle_mov', 'moi_id = dee_id_moi', 'inner')
                ->join('sar_saldo_articulo', 'sar_id = dee_id_sar', 'inner')
                ->join('tip_tipo_proceso','tip_id = moi_id_tip','inner')
                ->join('dpv_documento_proveedor', 'dpv_id = moi_id_dpv', 'left')
                ->join('dxd_detalle_documento_proveedor', 'dpv_id = dxd_id_dpv and dxd_id_art = dee_id_art', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Mario Marquez
     * @since 2017-07-10
     * @return Busqueda de empleados por nombre o condiciones generales
     */
    public function get_empleados_like($where = null, $like = null) {
        $query = $this->db->select("*,
            CONCAT_WS(' ',emp_codigo,' - ',emp_nombre, emp_apellido) as empleado", false)
                ->from('emp_empleado')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->or_like($like);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Mario Marquez
     * @since 2017-07-10
     * @return Obtener los datos de materia prima por presupuesto por producto de orden
     */
    public function get_materia_prima_presupuesto($where = null) {
        $query = $this->db->select('*, IFNULL((
                    SELECT
                        IFNULL(SUM(dri_cantidad),0)
                    FROM
                        rxi_requisicion_inventario
                    INNER JOIN dri_detalle_requisicion_inventario ON dri_id_rxi = rxi_id
                    WHERE
                        dri_id_art = axm_id_art_materia
                        AND axo_id_ord = rxi_id_ord
                        AND axm_id = dri_id_axm
                    GROUP BY
                        axm_id
                    ), 0) AS solicitado,
                    (
                        SELECT etp_id
                        FROM etp_etapa
                        WHERE etp_id = axm_id_etp
                    ) AS etapa_id,
                    (
                        SELECT etp_nombre
                        FROM etp_etapa
                        WHERE etp_id = axm_id_etp
                    ) AS etapa_nombre',false)
                ->from('axm_articulo_matxarticulo_ord')
                ->join('art_articulo', 'art_id = axm_id_art_materia', 'inner')
                ->join('axo_articuloxorden', 'axo_id = axm_id_axo', 'inner')
                ->join('cva_conversion_articulo', 'cva_id = axm_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
                ->join('prv_proveedor', 'prv_id = axm_id_prv', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Nelson Soriano
     * @since  2018-05-19
     * @return obtiene el estado de la orden de produccion
     */
    public function get_etapas_producto_orden_estado($where = null, $group_by = null){
        $this->db->select("
            SUM(IFNULL(exo_cantidad, 0.00)) AS sum_exo_cantidad,
            SUM(lop_cantidad) AS sum_lop_cant                
            ",false)
            ->from('axo_articuloxorden')
            ->join('lop_lote_produccion', 'axo_id = lop_id_axo')
            ->join('exo_etapaxarticulo_orden', 'lop_id = exo_id_lop')  
                                         
            ->join('ord_orden', 'ord_id = axo_id_ord')                                   
            ->join('art_articulo', 'art_id = axo_id_art')                                   
        ;

        if ( $where != null) {
            $this->db->where($where);
        }

        if ( $group_by != null) {
            $this->db->group_by($group_by);
        }
        return $this->db->get()->result_array();
    }

    public function sumar_envios($where = null){
        $this->db->select("SUM( IFNULL( moe_cantidad, 0.00 ) )as total",false)
                 ->from('moe_movimiento_etapa');
        if($where){
            $this->db->where($where);
        }

        return $this->db->get()->row();

              
    }


    /**
     * @author Mario Marquez
     * @since 2017-07-10
     * @return Obtener los datos de mano de obra por presupuesto por producto de orden
     */
    public function get_mano_obra_presupuesto($where = null) {
        $query = $this->db->select()
                ->from('mxo_mano_obraxarticulo_ord')
                ->join('mob_mano_obra', 'mob_id = mxo_id_mob', 'inner')
                ->join('emp_empleado', 'emp_id = mxo_id_emp AND emp_estado = 1', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Mario Marquez
     * @since 2017-07-10
     * @return Obtener los datos de gastos indirectos por presupuesto por producto de orden
     */
    public function get_gastos_indirectos_presupuesto($where = null) {
        $query = $this->db->select()
                ->from('exr_estimacionxarticulo')
                ->join('esm_estimacion', 'esm_id=exr_id_esm', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Mario Marquez
     * @since 2017-07-10
     * @return Obtener los datos de la materia prima predeterminada por producto
     */
    /**
     * @author Habby Lovo
     * @since 2017-11-21
    */
    public function get_materia_prima_producto($where = null) {
        /*
            SELECT
    *,
IF (
    mpa_tipo_precio = 1,
    (
        SELECT
                SUM(sar_precio * sar_cant_actual) / SUM(sar_cant_actual)    
        FROM
            moi_movimiento_inv
        INNER JOIN dee_detalle_mov ON moi_id = dee_id_moi
        INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
        INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
        WHERE
            sar_id_art = art_id
        AND
        IF (
            ISNULL(prv_id),
            true,
            moi_id_prv = prv_id
        )
    ),
    (
        SELECT
            sar_precio          
        FROM
            moi_movimiento_inv
        INNER JOIN dee_detalle_mov ON moi_id = dee_id_moi
        INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
        INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
        WHERE
            sar_id_art = art_id
        AND
        IF (
            ISNULL(prv_id),
            true,
            moi_id_prv = prv_id
        )
        AND tip_entrada = 1
        ORDER BY
            moi_id
        LIMIT 1
    )
)
FROM
    mpa_materia_prima_articulo
INNER JOIN art_articulo ON art_id = mpa_id_art_materia
LEFT JOIN cva_conversion_articulo ON cva_id = mpa_id_cva
LEFT JOIN mep_medida_producto ON mep_id = cva_id_mep
LEFT JOIN prv_proveedor ON prv_id = mpa_id_prv
INNER JOIN axo_articuloxorden ON axo_id_art = mpa_id_art
WHERE
    axo_id = 129
        */
        $query = $this->db->select('*, IF (
    mpa_tipo_precio = 1,
    (
        SELECT
                SUM(sar_precio * sar_cant_actual) / SUM(sar_cant_actual)    
        FROM
            moi_movimiento_inv
        INNER JOIN dee_detalle_mov ON moi_id = dee_id_moi
        INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
        INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
        WHERE
            sar_id_art = art_id
        AND
        IF (
            ISNULL(prv_id),
            true,
            moi_id_prv = prv_id
        )
    ),
    (
        SELECT
            sar_precio          
        FROM
            moi_movimiento_inv
        INNER JOIN dee_detalle_mov ON moi_id = dee_id_moi
        INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
        INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
        WHERE
            sar_id_art = art_id
        AND
        IF (
            ISNULL(prv_id),
            true,
            moi_id_prv = prv_id
        )
        AND tip_entrada = 1
        ORDER BY
            moi_id DESC
        LIMIT 1
    )
) as tipos_precio,
(
    SELECT etp_id
    FROM etp_etapa
    WHERE etp_id = mpa_id_etp
) AS etapa_id,
(
    SELECT etp_nombre
    FROM etp_etapa
    WHERE etp_id = mpa_id_etp
) AS etapa_nombre
', false)
                ->from('mpa_materia_prima_articulo')
                ->join('art_articulo', 'art_id = mpa_id_art_materia', 'inner')
                ->join('cva_conversion_articulo', 'cva_id = mpa_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
                ->join('prv_proveedor', 'prv_id = mpa_id_prv', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Mario Marquez
     * @since 2017-07-10
     * @return Obtener los datos de la mano de obra predeterminada por producto
     */
    public function get_mano_obra_producto($where = null) {
        $query = $this->db->select()
                ->from('moa_mano_obra_articulo')
                ->join('mob_mano_obra', 'mob_id = moa_id_mob', 'inner')
                ->join('emp_empleado', 'emp_id = moa_id_emp AND emp_estado = 1', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Mario Marquez
     * @since 2017-07-10
     * @return Obtener los datos de los gastos indirectos por producto
     */
    public function get_gastos_indirectos_producto($where = null) {
        $query = $this->db->select()
                ->from('esr_estimacion_articulo')
                ->join('esm_estimacion', 'esm_id = esr_id_esm', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Mario Marquez
     * @since 2017-07-10
     * @return Obtener los datos de las horas extras procesadas desde Producción
     */
    public function get_reporte_horas_extras($where = null) {
        $query = $this->db->select()
                ->from('hxe_hora_extraxempleado')
                ->join('emp_empleado', 'emp_id = hxe_id_emp', 'inner')
                ->join('ord_orden', 'ord_id = hxe_id_ord', 'left')
                ->join('the_tipo_hora_extra', 'the_id = hxe_id_the', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_avance_produccion_lotes($where = null) {
        $query = $this->db->select('*, IFNULL((exo_cantidad/lop_cantidad),0) porc_avance', false)
                ->from('lop_lote_produccion')
                ->join('exo_etapaxarticulo_orden', 'lop_id = exo_id_lop AND exo_fin = 1', 'left')
                ->join('etp_etapa', 'exo_id_etp = etp_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_requisiciones($where = null) {
        $query = $this->db->select()
                ->from('rxi_requisicion_inventario')
                ->join('bod_bodega', 'bod_id = rxi_id_bod', 'left')
                ->join('suc_sucursal', 'suc_id = bod_id_suc', 'left')
                ->join('users', 'id = rxi_id_usu_solicita', 'inner')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                ->join('are_area', 'are_id = emp_id_are', 'left')
                ->join('ord_orden', 'ord_id = rxi_id_ord', 'inner')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_detalle_requisicion($where = null) {
        $this->db->select()
                ->from('dri_detalle_requisicion_inventario')
                ->join('art_articulo', 'art_id = dri_id_art', 'left')
                ->join('tia_tipo_articulo', 'art_id_tia = tia_id', 'left')
                ->join('cva_conversion_articulo', 'cva_id = dri_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
                ->join('axm_articulo_matxarticulo_ord', 'axm_id = dri_id_axm', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get()->result_array();
        return $query;
    }

    /**
     * @author Elman Ortiz
     * @since 2017-07-11
     * @return Obtiene los tipos de ordenes segun las ordenes que tiene un cliente
     */
    public function get_tipo_orden_cliente($where = null) {
        $query = $this->db->distinct()
                ->select('tio_id, tio_nombre')
                ->from('cli_cliente')
                ->join('ord_orden', 'cli_id = ord_id_cli')
                ->join('tio_tipo_orden', 'ord_id_tio = tio_id');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 2017-07-11
     * @return Obtiene los productos por orden
     */
    public function get_producto_x_orden($where = null) {
        $query = $this->db->distinct()
                ->select('axo_id, axo_descripcion,art_codigo,art_nombre,art_id')
                ->from('axo_articuloxorden')
                ->join('art_articulo', 'axo_id_art = art_id', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 2017-07-12
     * @return Obtiene los lotes por producto
     */
    public function get_lote_x_producto($where = null) {
        $query = $this->db->select('lop_id, lop_nombre')
                ->from('lop_lote_produccion');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 2017-07-12
     * @return Produccion por producto
     */
    public function get_avance_proxprod($where = null) {
        $query = $this->db->select('axo_id, axo_descripcion, lop_id, lop_nombre, lop_cantidad, exo_id, exo_cantidad, etp_nombre, moe_fecha_salida, 
            IFNULL(eta_orden, 0) AS eta_orden, (SELECT ord_codigo FROM ord_orden WHERE ord_id = axo_id_ord) AS ord_codigo', FALSE)
                ->from('axo_articuloxorden')
                ->join('lop_lote_produccion', 'axo_id = lop_id_axo')
                ->join('exo_etapaxarticulo_orden', 'lop_id = exo_id_lop')
                ->join('etp_etapa', 'etp_id = exo_id_etp')
                ->join('moe_movimiento_etapa', 'moe_id_exo = exo_id', 'left')
                ->join('eta_etapa_articulo', 'eta_id_art = axo_id_art AND eta_id_etp = etp_id', 'left') 
                ->group_by('axo_id, axo_descripcion, lop_id, lop_nombre, exo_id, etp_nombre')
                ->order_by('eta_orden, lop_id, exo_id', 'ASC');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_product_x_category($value='') {
        $query = $this->db->select('art_id, art_codigo, art_nombre, IFNULL(IFNULL(mpa_id,IFNULL(moa_id_art,esr_id_art)),0) AS tiene_receta', FALSE)
            ->from('art_articulo')
            ->join('mpa_materia_prima_articulo', 'mpa_id_art = art_id', 'LEFT')
            ->join('moa_mano_obra_articulo', 'moa_id_art = art_id', 'LEFT')
            ->join('esr_estimacion_articulo', 'esr_id_art = art_id', 'LEFT') 
            ->group_by('art_id')
            ->having('tiene_receta > 0')
            ->order_by('art_codigo', 'ASC')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_estandar_producto($idproducto = null) {
        $datos = null;
        $where = null;
        $receta_defecto = $this->gsatelite->get_campo('rea_receta_articulo', 'rea_id', array('rea_estado' => 1, 'rea_id_art' => $idproducto, 'rea_defecto' => 1));
        /* Materia Prima */
        $query = $this->db->select('art_id, art_nombre, art_codigo, mep_nombre, mpa_cantidad, mpa_tipo_precio, CASE WHEN mpa_tipo_precio = 2 THEN (IFNULL((SELECT (
            (dxd_subtotal/dxd_cantidad)/cva_conversion) FROM dpv_documento_proveedor JOIN dxd_detalle_documento_proveedor ON dxd_id_dpv = dpv_id 
            JOIN cva_conversion_articulo ON cva_id = dxd_id_cva WHERE dxd_id_art = art_id ORDER BY dpv_fecha_documento DESC, dpv_id DESC LIMIT 1), 0)) WHEN mpa_tipo_precio = 3 
            THEN (IFNULL((SELECT (((SELECT IFNULL(SUM(axm_cantidad * axm_precio), 0) FROM axm_articulo_matxarticulo_ord WHERE axm_id_axo = axo_id) + (SELECT IFNULL(
            SUM(mxo_cantidad * mxo_precio), 0) FROM mxo_mano_obraxarticulo_ord WHERE mxo_id_axo = axo_id) + (SELECT IFNULL(SUM(exr_monto_calculo), 0) FROM exr_estimacionxarticulo 
            WHERE exr_id_axo = axo_id)) / axo_cantidad) AS costo FROM axo_articuloxorden WHERE axo_id_art = art_id ORDER BY axo_id DESC LIMIT 1), 0)) WHEN mpa_tipo_precio = 4 
            THEN (IFNULL(mpa_precio, 0)) ELSE (SELECT IFNULL((SUM(sar_cant_actual * sar_precio) / SUM(sar_cant_actual)), 0) FROM sar_saldo_articulo WHERE sar_id_art = art_id) END
            AS mpa_precio, (mpa_cantidad * mpa_materia_prima_articulo.mpa_precio) AS subtotal', false)
                ->from('mpa_materia_prima_articulo')
                ->join('art_articulo', 'mpa_id_art_materia = art_id')
                ->join('cva_conversion_articulo', 'mpa_id_cva = cva_id', 'left')
                ->join('mep_medida_producto', 'cva_id_mep = mep_id', 'left')
        ;
        $where['mpa_id_rea'] = $receta_defecto;
        $where['mpa_id_art'] = $idproducto;
        if ($where != null) {
            $this->db->where($where);
        }
        $datos['prima'] = $query->get()->result_array();
        /* Mano de Obra */
        $where = null;
        $query = $this->db->select('mob_codigo, mob_nombre, moa_cantidad, mob_precio')
                ->from('moa_mano_obra_articulo')
                ->join('mob_mano_obra', 'moa_id_mob = mob_id')
        ;
        $where['moa_id_rea'] = $receta_defecto;
        $where['moa_id_art'] = $idproducto;
        if ($where != null) {
            $this->db->where($where);
        }
        $datos['obra'] = $query->get()->result_array();
        /* Gastos */
        $where = null;
        $query = $this->db->select('esm_codigo, esm_nombre, esr_cantidad, esr_precio, esm_tipo_calculo, esr_monto_calculo')
                ->from('esr_estimacion_articulo')
                ->join('esm_estimacion', 'esr_id_esm = esm_id')
        ;
        $where['esr_id_rea'] = $receta_defecto;
        $where['esr_id_art'] = $idproducto;
        if ($where != null) {
            $this->db->where($where);
        }
        $datos['gasto'] = $query->get()->result_array();
        return $datos;
    }

    public function generar_codigo_validar($where = null){
        $query = $this->db->select('COUNT(ord_id) as codigos',false)
                ->from('ord_orden')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since 2017-11-14
     * @return Obtiene los sectores por bodega
     */
    public function get_sector_por_bodega($where=null) {
        $this->db->select()
            ->from('sxb_sectorxbodega')
            ->join('bod_bodega', 'bod_id=sxb_id_bod', 'inner')
            ->join('seb_sector_bodega', 'seb_id=sxb_id_seb', 'inner')
    
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('sxb_id');
        return $this->db->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 2017-11-15
     * @return Array con si tiene o no lote
     */
    public function get_tiene_lote($where = null) {

        $query = $this->db->select('*')
                ->from('axo_articuloxorden')
                ->join('lop_lote_produccion', 'axo_id = lop_id_axo');                
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since 2017-11-15
     * @return Obtiene la cantidad ingresada al moi o si se guardo la cantidad del tracking
     */
    public function get_cantidad_tracking($where=null) {
        /*
            INNER JOIN exo_etapaxarticulo_orden ON exo_id = moe_id_exo
            INNER JOIN lop_lote_produccion ON lop_id = exo_id_lop
            WHERE moe_ingreso_inventario = 1 and lop_id = 54
        */
        $this->db->select('SUM(moe_cantidad) as cantidad', false)
            ->from('moe_movimiento_etapa')
            ->join('exo_etapaxarticulo_orden', 'exo_id = moe_id_exo', 'inner')
            ->join('lop_lote_produccion', 'lop_id = exo_id_lop', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since 2017-11-15
     * @return Obtiene la cantidad ingresada al moi
     */
    public function get_tracking_movimiento_moi($where=null) {
        /*
            SELECT COUNT(moe_id_moi) as cantidad
            from 
            axo_articuloxorden 
            INNER JOIN ord_orden ON ord_id = axo_id_ord
            INNER JOIN lop_lote_produccion ON lop_id_axo = axo_id
            INNER JOIN exo_etapaxarticulo_orden ON exo_id_lop = lop_id
            INNER JOIN moe_movimiento_etapa ON moe_id_exo = exo_id
            where ord_id = 91
        */
        $this->db->select('COUNT(moe_id_moi) as cantidad', false)
            ->from('axo_articuloxorden')
            ->join('ord_orden', 'ord_id = axo_id_ord', 'inner')
            ->join('lop_lote_produccion', 'lop_id_axo = axo_id', 'inner')
            ->join('exo_etapaxarticulo_orden', 'exo_id_lop = lop_id', 'inner')
            ->join('moe_movimiento_etapa', 'moe_id_exo = exo_id', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    

    /**
     * @author Habby Lovo
     * @since  2018-02-12
     * @return Obtiene todos los componentes
    */
    public function get_produccion_proyecto($where = null){
        /*
            SELECT
                ord_fecha,
                ord_codigo,
                IF (
                    cli_personeria = 1,
                    CONCAT(
                        cli_codigo,
                        " - ",
                        cli_nombre,
                        " ",
                        cli_apellido
                    ),
                    CONCAT(
                        cli_codigo,
                        " - ",
                        cli_apellido
                    )
                ) cliente,
                CONCAT_WS(
                    ' - ',
                    pcl_codigo,
                    pcl_nombre
                ) proyecto,
                epr_nombre
            FROM
                ord_orden
            INNER JOIN pcl_proyecto_cliente ON pcl_id = ord_id_pcl
            INNER JOIN cli_cliente ON cli_id = pcl_id_cli
            INNER JOIN epr_estado_proyecto ON epr_id = pcl_id_epr
            GROUP BY
                ord_id
        */
        $query = $this->db->select("
                ord_fecha,
                ord_codigo,
                IF (
                    cli_personeria = 1,
                    CONCAT(
                        cli_codigo,
                        ' - ',
                        cli_nombre,
                        ' ',
                        cli_apellido
                    ),
                    CONCAT(
                        cli_codigo,
                        ' - ',
                        cli_apellido
                    )
                ) cliente,
                CONCAT_WS(
                    ' - ',
                    pcl_codigo,
                    pcl_nombre
                ) proyecto,
                epr_nombre", false)
            ->from('ord_orden')
            ->join('pcl_proyecto_cliente','pcl_id = ord_id_pcl','inner')
            ->join('cli_cliente','cli_id = pcl_id_cli','inner')
            ->join('epr_estado_proyecto','epr_id = pcl_id_epr','inner')
            ->group_by('ord_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function consultar_mano_obra($where = null) {
        $this->db->select()
                ->from('mxo_mano_obraxarticulo_ord')
                ->join('emp_empleado', 'emp_id = mxo_id_emp', 'left')
                ->join('mob_mano_obra', 'mob_id = mxo_id_mob')
                ->join('axo_articuloxorden','axo_id = mxo_id_axo')
                ->join('ord_orden','ord_id = axo_id_ord')
                ->join('pcl_proyecto_cliente','pcl_id = ord_id_pcl','left')
        ;

        if ( $where ) {
            $this->db->where($where);
        }
        
        return $this->db->get()->result_array();
    }

    public function get_productos_masivo( $where = null, $where_not_in = null ) {
        $this->db->select("*, (SELECT GROUP_CONCAT(DISTINCT CONCAT_WS('#', rea_id, rea_nombre) SEPARATOR '&&') FROM rea_receta_articulo WHERE rea_estado = 1  AND rea_id_art = art_id) AS recetas,
            (SELECT GROUP_CONCAT(DISTINCT CONCAT_WS('#', cva_id, mep_nombre,cva_defecto)) FROM mep_medida_producto INNER JOIN cva_conversion_articulo ON cva_id_mep = mep_id 
                WHERE cva_id_art = art_id) AS medidas",false)
                ->from('art_articulo')
                ->join('mrp_marca_producto', 'mrp_id = art_id_mrp','left')
                ->join('ppr_presentacion_producto', 'ppr_id = art_id_ppr','left')
                ->join('tia_tipo_articulo','tia_id = art_id_tia','left')
                ->group_by('art_id')
        ;

        if ( $where != null) {
            $this->db->where($where);
        }

        if ( $where_not_in != null) {
            $this->db->where_not_in("art_id", $where_not_in);
        }
        
        return $this->db->get()->result_array();
    }

    public function etapas_cursograma_analitico($where = null){
        $this->db->select("*")        
            ->from('cra_cursograma_analitico') 
            ->join('exg_etapasxcursograma_analitico', 'exg_id_cra = cra_id','left')   
            ->join('rca_responsable_cursograma_analitico','rca_id_cra = cra_id','left')
            ->join('eca_etapa_cursograma_analitico','eca_id = exg_id_eca','left')
            ->join('art_articulo','art_id = cra_id_art','left')
            ->join('emp_empleado','emp_id = rca_id_emp','left')
            ->order_by('exg_orden','asc')
            ->group_by('exg_id');
        ;

        if ( $where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }
    
    /**
    *@autor Elman Ortiz
    */
    public function verificar_tiene_etapas($where = null){
        $this->db->select('etp_id, etp_nombre')
            ->from('art_articulo')
            ->join('eta_etapa_articulo', 'art_id = eta_id_art')
            ->join('etp_etapa', 'eta_id_etp = etp_id')                        
        ;

        if ( $where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * 13/11/2018
    * @autor Elman Ortiz
    */
    public function verificar_tiene_etapas_procesos($where = null){
        $this->db->select('etp_id, etp_nombre')
            ->from('axo_articuloxorden')
            ->join('axm_articulo_matxarticulo_ord', 'axo_id = axm_id_axo')
            ->join('etp_etapa', 'axm_id_etp = etp_id')                        
        ;

        if ( $where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
        * @author Francisco Orozco
        * @since  2018-1-15
        * @return Envio orden
    */
    public function get_envio_orden($where = null){
        $this->db->select("art_id, art_foto, deo_fecha, ord_codigo, ord_fecha, axo_id,deo_hora,
            CONCAT_WS(' ',cli_nombre, cli_apellido) AS cliente,
            eno_id, deo_id, tia_nombre, deo_cantidad,
            CONCAT_WS(' ', con_nombre, con_apellidos ) AS contacto,
            cli_direccion, art_descripcion, art_foto,
            (SELECT GROUP_CONCAT(CONCAT_WS(': ',car_nombre,cdo_valor)) AS caract
                FROM cdo_caracteristicaxdetalle_orden
                INNER JOIN cxu_caracxarticulo ON cxu_id = cdo_id_cxu
                INNER JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
                INNER JOIN car_caracteristica ON car_id = cxr_id_car
                INNER JOIN axo_articuloxorden dax ON cdo_id_axo = dax.axo_id
                WHERE cdo_id_axo = axo_id AND axo.axo_id = dax.axo_id GROUP BY dax.axo_id_ord
            ) AS caracteristicas", FALSE)
        ->from('ord_orden')
        ->join('eno_envio_orden', 'eno_id_ord = ord_id')
        ->join('deo_detalle_envio_orden', 'deo_id_eno = eno_id')
        ->join('con_contacto', 'con_id = ord_id_con','left')
        ->join('axo_articuloxorden AS axo', 'axo_id = deo_id_axo AND axo.axo_id_ord = eno_id_ord')
        ->join('cli_cliente', 'cli_id = ord_id_cli')
        ->join('art_articulo', 'art_id = axo.axo_id_art')
        ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
        ->join('cxu_caracxarticulo', 'cxu_id_art = art_id', 'left')
        ->join('cxr_caractxtipo_articulo', 'cxu_id_cxr = cxr_id', 'left')
        ;

        if ( $where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('axo_id');

        return $this->db->get()->result_array();
    }
    /**
    * 20/11/2018
    * @autor Manuel Anzora
    */
    //METODO PARA EL SELECT AJAX DEL CAMPO COTIZACIONES
    //RECIBE OMO PARAMETRO EL WHERE CON EL CLIENTE Y EL LIKE HACIA EL CAMPO CODIGO DE COTIZACIONES
    public function get_cotizacion_cli($where, $like){
        $this->db->select("cot_id, cot_codigo")
                ->from('cot_cotizacion');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->like($like);
        }

        return $this->db->get()->result_array();
    }
    //METODO PARA OBTENER IBFORMACION DE COTIZACIONES, CLIENTES Y PROYECTOS,
    //PROYECTOS SE UNE USANDO LEFT JOIN 
    public function get_cli_proy($tb,$where){
        $this->db->select('cot_id, cot_id_pcl, cli_id, cli_nombre, cli_apellido, cli_codigo, pcl_id, pcl_codigo, pcl_nombre')
            ->from($tb)
            ->join('cli_cliente', 'cot_id_cli = cli_id')
            ->join('pcl_proyecto_cliente', 'pcl_id = cot_id_pcl', 'left')
            ->where($where);
        return $this->db->get()->result_array();
    }
    
    /**
    * 13/11/2018
    * @autor Elman Ortiz
    */
    public function get_etapas_producto_solicitud_materiales($where = null){
        $this->db->select('DISTINCT etp_id, etp_nombre', FALSE)
            ->from('art_articulo')
            ->join('axo_articuloxorden', 'art_id = axo_id_art')
            ->join('axm_articulo_matxarticulo_ord', 'axo_id = axm_id_axo')                        
            ->join('etp_etapa', 'axm_id_etp = etp_id')                        
        ;

        if ( $where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

     /**
     * @author Francisco Orozco
     * @since 2018-12-18
     * @return Obtener orden de produccion
     */
    public function get_orden($where = null) {
        $query = $this->db->select()
                ->from('ord_orden')
                ->join('axo_articuloxorden', 'axo_id_ord = ord_id')
                ->join('art_articulo', 'art_id = axo_id_art')
                ->join('cot_cotizacion', 'cot_id = ord_id_cot','left')
                ->join('pcl_proyecto_cliente', 'ord_id_pcl = pcl_id', 'left')
                ->join('dpp_detalle_programacion_produccion', 'dpp_id_ord = ord_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }


        return $query->get()->result_array();
    }

    /**
    * @author René Castaneda
    * @since 2018-12-19
    * @return Obtener orden de produccion para generación de codigos de barra
    */
    public function get_orden_produccion_cod($where)
    {
        $query = $this->db->select()
                ->from('ord_orden')
                ->join('cli_cliente', 'cli_id = ord_id_cli')
                ->join('axo_articuloxorden', 'axo_id_ord = ord_id')
                ->join('art_articulo', 'art_id = axo_id_art')
                ->join('cot_cotizacion', 'cot_id = ord_id_cot', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
    * 03/01/2019
    * @autor Elman Ortiz
    */
    public function get_etapas_producto_orden_board($where = null, $group_by = null, $order_by = null){
        $this->db->select("
                ord_id,
                axo_id, 
                axo_id_art, 
                axo_id_ord, 
                lop_id,
                lop_nombre,
                lop_cantidad,
                axo_cantidad,
                art_nombre,
                exo_id,
                exo_cantidad,
                (SELECT etp_id FROM etp_etapa WHERE etp_id = exo_id_etp) AS etp_id,
                (SELECT exo_id_etp FROM exo_etapaxarticulo_orden WHERE exo_id_lop = lop_id AND exo_fin = 1 LIMIT 1) AS etp_final,
                (SELECT etp_nombre FROM etp_etapa WHERE etp_id = exo_id_etp) AS etp_nombre,
                DATE_FORMAT(ord_fecha,'%m-%d-%Y') AS fecha_orden,
                DATE_FORMAT(ord_fecha_entr,'%m-%d-%Y') AS fecha_entrega,
                (
                    SELECT IF(cli_personeria = 1, CONCAT(cli_nombre,' ',cli_apellido), cli_apellido)
                    FROM cli_cliente
                    WHERE cli_id = ord_id_cli
                ) AS cliente,
                ord_codigo,
                art_codigo
            ",false)
            ->from('axo_articuloxorden')
            ->join('lop_lote_produccion', 'axo_id = lop_id_axo')
            ->join('exo_etapaxarticulo_orden', 'lop_id = exo_id_lop')                                   
            ->join('ord_orden', 'ord_id = axo_id_ord')                                   
            ->join('art_articulo', 'art_id = axo_id_art')                                   
        ;
        if ( $where != null) {
            $this->db->where($where);
        }
        if ($order_by != null) {
            $this->db->order_by($order_by);
        }
        if ( $group_by != null) {
            $this->db->group_by($group_by);
        }
        return $this->db->get()->result_array();
    }

    /**
    * 03/01/2019
    * @autor Elman Ortiz
    */
    public function get_bodega_x_etapa($where = null){
        $this->db->select('bod_id, bod_nombre')
            ->from('exo_etapaxarticulo_orden')
            ->join('etp_etapa', 'exo_id_etp = etp_id')
            ->join('bod_bodega', 'bod_id = etp_id_bod')                                    
        ;

        if ( $where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

/**
 * @author Nelson Soriano
 * @since  07-03-2019
 * @return Obtiene los materias por etapa para los productos de una orden
 */
  public function get_data_produccion($where = null, $group_by = null){
    $this->db->select(
            "CONCAT(art_codigo,' - ',art_nombre) as nombre,
             ord_fecha as fecha,
             ord_codigo as numero,
             art_foto as foto,    
             art_descripcion as descripcion,
             ord_comentario as comentario,         
             ord_fecha_entr as entrega,
             ord_fecha as ingreso,
             tia_nombre as tipo,
             axo_cantidad as total_producir,
             axo_id as id,
             (
                SELECT
                    GROUP_CONCAT(
                        CONCAT(car_nombre,'|||',cdo_valor) SEPARATOR '||||'
                )
                FROM cdo_caracteristicaxdetalle_orden
                INNER JOIN cxu_caracxarticulo ON cxu_id = cdo_id_cxu
                INNER JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
                INNER JOIN car_caracteristica ON car_id = cxr_id_car
                WHERE cdo_id_axo = axo_id
                ORDER BY car_id
             )as caracteristicas, 
             CONCAT(pcl_codigo,' - ',pcl_nombre) AS proyecto
            ",false)
      ->from('axo_articuloxorden')
      ->JOIN('axm_articulo_matxarticulo_ord','axm_id_axo = axo_id','INNER')
      ->JOIN('ord_orden','ord_id = axo_id_ord','INNER')
      ->JOIN('art_articulo','axo_id_art = art_id','INNER')
      ->JOIN('tia_tipo_articulo','tia_id = art_id_tia','INNER')
      ->JOIN('cva_conversion_articulo','cva_id = axm_id_cva')
      ->JOIN('mep_medida_producto','mep_id = cva_id_mep')
      ->JOIN('orv_orden_venta','orv_id_cli = ord_id_cli','LEFT')
      ->JOIN('pcl_proyecto_cliente','ord_id_pcl = pcl_id','LEFT')
      ;
      if ($where) {
          $this->db->where($where);
      }

      if ($group_by) {
          $this->db->group_by($group_by);
      }

      return $this->db->get()->result_array();
    } 

    public function get_insumos($where = null,$order_by = null,$group_by = null){
        $this->db->select('
                        IFNULL(etp_nombre, "USO GENERAL")  as nombre,
                        art_nombre as materia,
                        axm_cantidad cantidad,
                        mep_nombre as medida,
                        IFNULL(etp_id, 0) AS id, 
                        IFNULL(CONCAT(emp_nombre," ",emp_apellido),"") as responsable
                        ',false)
                 ->from('axo_articuloxorden')
                 ->JOIN('axm_articulo_matxarticulo_ord','axm_id_axo = axo_id','INNER')
                 ->JOIN('etp_etapa','etp_id = axm_id_etp','LEFT')
                 ->JOIN('art_articulo','art_id = axm_id_art_materia','INNER')
                 ->JOIN('cva_conversion_articulo','cva_id = axm_id_cva','LEFT')
                 ->JOIN('mep_medida_producto','mep_id = cva_id_mep','INNER')
                 ->JOIN('axc_articuloxcotizacion','axc_id_art = art_id','LEFT')
                 ->JOIN('mxa_mano_obraxarticulo','mxa_id_axc = axc_id','LEFT')
                 ->JOIN('emp_empleado','emp_id = mxa_id_emp','LEFT')
                 ;
                if ($where) {
                    $this->db->where($where);
                }

                if ($group_by) {
                   $this->db->group_by($group_by);
                }

                if ($order_by) {
                   $this->db->order_by($order_by);
                }

                return $this->db->get()->result_array();

        }


    /**
      * @author Raul Escalante
      * @method Retorna el costo promedio de venta de los productos por categoria
      * @param  Array $where: Array de filtros a usar, String $categoria: Id de categoria a filtrar
      */
    public function get_costos($where = null, $categoria = null)
    {
        $select = " IFNULL( tia_padre, tia_id ) AS tia_id,
                    fac_fecha_fact,
                    IF
                    ( tia_padre IS NULL, tia_codigo, ( SELECT tia_codigo FROM tia_tipo_articulo AS t1 WHERE t1.tia_id = t2.tia_padre ) ) AS tia_codigo,
                    IF
                    ( tia_padre IS NULL, tia_nombre, ( SELECT tia_nombre FROM tia_tipo_articulo AS t1 WHERE t1.tia_id = t2.tia_padre ) ) AS tia_nombre,
                    art_codigo,
                    art_nombre,
                    SUM( def_cantidad ) AS def_cantidad,
                    AVG( def_precio_inventario ) AS def_precio_inventario,
                    ( SELECT mep_nombre FROM mep_medida_producto WHERE mep_id = cva_id_mep ) AS mep_nombre
                    ";
        $query   =  $this->db->select($select, false)
                          ->from("def_detalle_fact")
                          ->join("fac_factura","def_id_fac = fac_id")
                          ->join("art_articulo","def_id_art = art_id")
                          ->join("tia_tipo_articulo AS t2","art_id_tia = tia_id")
                          ->join("cva_conversion_articulo","def_id_cva = cva_id");
        if(!is_null($where)) {            
            $this->db->where($where);
        }
        if(!is_null($categoria)) {   
            $this->db->having('tia_id',  $categoria);
        }
        $this->db->group_by(array("art_id", "cva_id_mep")); 
        $this->db->order_by("tia_id", 'ASC');
        return $query->get()->result_array();
    }

    /**
    * 16/05/2019
    * @autor Raul Escalante
    * Devuelve las etapas del articulo para el reporte por etapas
    */
    public function get_etapas_producto_orden_reporte($where = null, $group_by = null){
        $this->db->select("etp_id, etp_nombre",false)
        ->from('axo_articuloxorden')
        ->join('axm_articulo_matxarticulo_ord', 'axm_id_axo = axo_id')
        ->join('etp_etapa', 'etp_id = axm_id_etp')
        ;

        if ( $where != null) {
            $this->db->where($where);
        }
        if ( $group_by != null) {
            $this->db->group_by($group_by);
        }
        return $this->db->get()->result_array();
    }

     public function get_detalle_requisicion_inventx($where = null,$group_by = null) {
        $this->db->select()
                ->from('dri_detalle_requisicion_inventario')
                ->join('rxi_requisicion_inventario' ,'rxi_id = dri_id_rxi')
                ->join('moi_movimiento_inv', 'moi_id_rxi = rxi_id')
                ->join('dee_detalle_mov', 'dee_id_moi = moi_id')
                ->join('sar_saldo_articulo' ,'sar_id = dee_id_sar')
                ->join('art_articulo', 'art_id = dri_id_art', 'left')
                ->join('tia_tipo_articulo', 'art_id_tia = tia_id', 'left')
                ->join('cva_conversion_articulo', 'cva_id = dri_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
                ->join('axm_articulo_matxarticulo_ord', 'axm_id = dri_id_axm', 'left')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        if ($group_by !== null) {
            $this->db->group_by($group_by);
        }
        $query = $this->db->get()->result_array();
        return $query;
    }
    public function get_productos_detalle_ingreso($where = null){
        $this->db->select('*'
                    )
                ->from('ord_orden')
                ->join('axo_articuloxorden', 'axo_id_ord = ord_id' ,'INNER')
                ->join('lop_lote_produccion', 'lop_id_axo = axo_id','INNER')
                ->join('exo_etapaxarticulo_orden','exo_id_lop = lop_id', 'INNER')
                ->join('moe_movimiento_etapa', 'moe_id_exo = exo_id','INNER')
                ->join('moi_movimiento_inv', 'moi_id = moe_id_moi','INNER')
                ->join('dee_detalle_mov', 'dee_id_moi = moi_id', 'INNER');
            if ($where != null) {
                $this->db->where($where);
            }
        return $this->db->get()->result_array();
    }

    public function get_mat_prim_x_ord($where = null) {
        $this->db->select("*,(SELECT CONCAT(a2.art_codigo, ' - ' , a2.art_nombre) FROM art_articulo AS a2 WHERE a2.art_id = axo_id_art) as producto,
            (SELECT mpa_cantidad FROM mpa_materia_prima_articulo WHERE mpa_id_art = axo_id_art AND mpa_id_art_materia = art_id 
            AND mpa_id_rea = IFNULL(axo_id_rea, (SELECT rea_id FROM rea_receta_articulo WHERE rea_id_art = axo_id_art AND rea_defecto = 1 AND rea_estado = 1))) AS mpa_cantidad
            ", false)
                ->from('ord_orden')
                ->join('axo_articuloxorden', 'ord_id = axo_id_ord')
                ->join('axm_articulo_matxarticulo_ord', 'axo_id = axm_id_axo')
                ->join('cva_conversion_articulo', 'cva_id = axm_id_cva')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep')
                ->join('art_articulo', 'art_id = axm_id_art_materia')
                ->join('cli_cliente', 'cli_id = ord_id_cli', 'left')
                ->order_by('axo_id_art')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    public function get_ord_x_exo($where = null) {
        $this->db->select()
            ->from('ord_orden')
            ->join('axo_articuloxorden', 'axo_id_ord = ord_id')
            ->join('lop_lote_produccion', 'lop_id_axo = axo_id')
            ->join('exo_etapaxarticulo_orden', 'exo_id_lop = lop_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los datos del articulo para la planificacion
    */
    public function get_datos_producto_plan($where = null, $bodega = null, $having = null){
        $query = "*, IFNULL((SELECT SUM(sar_cant_actual) FROM sar_saldo_articulo WHERE sar_id_art = art_id";
        $query .= ($bodega != null) ?  " AND sar_id_bod IN ( $bodega )": "";
        $query .= "), 0) AS inv_actual";
        $this->db->select($query, false)
        ->from('art_articulo')
        ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
        ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1')
        ->join('mep_medida_producto', 'mep_id = cva_id_mep')
        ->join('bod_bodega', 'bod_id = art_id_bod', 'LEFT')
        ->order_by('art_nombre', 'ASC')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($having != null) {
            $this->db->having($having);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve las produccion en progreso de un articulo
    */
    public function get_producto_plan_proceso($articulo = null, $medida = null){
        $this->db->select("IFNULL(SUM(axo_cantidad),0) AS en_proceso, MAX(ord_id) AS ultima_ord", false)
        ->from('ord_orden')
        ->join('axo_articuloxorden', 'axo_id_ord = ord_id')
        ->where('axo_id_art', $articulo)
        ->where('axo_id_cva', $medida)
        ->where('ord_estado !=', 0)
        ;
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los datos de la ultima orden de produccion para un articulo
    */
    public function get_last_ord_plan($where = null){
        $this->db->select("ord_id, ord_codigo, axo_cantidad, ord_fecha", false)
        ->from('ord_orden')
        ->join('axo_articuloxorden', 'axo_id_ord = ord_id')
        ->order_by('ord_id', 'DESC')
        ->limit(1)
        ->where($where)
        ;
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve el promedio de ventas de un articulo
    */
    public function get_prom_fact_prod_plan($where = null){
        $this->db->select("IFNULL(AVG(def_cantidad),0) as promedio", false)
        ->from('def_detalle_fact')
        ->join('fac_factura', 'fac_id = def_id_fac')
        ->where('fac_estado >', 0)
        ;
        if ( $where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve el promedio de proyeccion de ventas de un articulo
    */
    public function get_prom_proy_prod_plan($where = null){
        $this->db->select("IFNULL(pyv_cantidad, 0) as cantidad", false)
        ->from('pyv_pryeccion_venta')
        ->where('pyv_estado', 1)
        ;
        if ( $where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Realiza la explosion de materias primas para un articulo
    */
    public function get_explosion_plan($articulo = null, $cantidad = null, $intermedio = null, $mat_prima = null){
        $bod_inter = ($intermedio != null) ? " AND sar_id_bod = $intermedio" : "";
        $bod_mater = ($mat_prima != null) ? " AND sar_id_bod = $mat_prima" : "";
        $query = "CONCAT( mpa_id_art_materia, '#', mpa_id_cva ) AS array_key,
                    mpa_id_art_materia,
                    mpa_id_cva,
                    (SELECT tia_nombre FROM tia_tipo_articulo WHERE tia_id = art_id_tia) AS material_tia,
                    art_codigo,
                    art_nombre,
                    art_produccion,
                    art_materia_prima,
                    art_compra,
                    (SELECT mep_nombre FROM mep_medida_producto JOIN cva_conversion_articulo ON cva_id_mep = mep_id WHERE cva_id = mpa_id_cva) AS material_presentacion,
                    mpa_cantidad as requerido_1,
                    (mpa_cantidad * $cantidad) as total_requerido,
                    CASE 
                        WHEN (art_materia_prima > 0 AND art_produccion < 1) 
                            THEN (SELECT IFNULL(SUM(sar_cant_actual), 0) FROM sar_saldo_articulo WHERE sar_id_art = mpa_id_art_materia $bod_mater)
                        WHEN (art_materia_prima > 0 AND art_produccion > 0)
                            THEN (SELECT IFNULL(SUM(sar_cant_actual), 0) FROM sar_saldo_articulo WHERE sar_id_art = mpa_id_art_materia $bod_inter)
                        WHEN (art_materia_prima < 1 AND art_produccion > 0) 
                            THEN (SELECT IFNULL(SUM(sar_cant_actual), 0) FROM sar_saldo_articulo WHERE sar_id_art = mpa_id_art_materia $bod_inter)
                        ELSE (SELECT IFNULL(SUM(sar_cant_actual), 0) FROM sar_saldo_articulo WHERE sar_id_art = mpa_id_art_materia)
                    END AS disponible";
        $this->db->select($query, false)
                ->from('mpa_materia_prima_articulo')
                ->join('art_articulo', 'art_id = mpa_id_art_materia')
                ->join('cva_conversion_articulo', 'cva_id_art = mpa_id_art AND cva_defecto = 1')
                ->where('mpa_id_art', $articulo)
                ->group_by('mpa_id_art_materia, mpa_id_cva')
                ->order_by('mpa_id_art_materia', 'ASC')
        ;
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles de las ordenes de produccion
    */
    public function get_detalles_prog($where = null){
        $this->db->select()
                ->from('axo_articuloxorden')
                ->join('ord_orden', 'axo_id_ord = ord_id')
                ->join('art_articulo', 'axo_id_art = art_id')
                ->join('cva_conversion_articulo', 'cva_id = axo_id_cva')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
                ->where('art_produccion', 1)
                ->where('ord_estado', 1)
                ->where('axo_fecha_ejecucion IS NULL')
        ;
        if ( $where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles de las productos incluidos en una orden de produccion para control de calidad
    */
    public function get_detalles_orden_control_calidad($where = null){
        $this->db->select()
                ->from('axo_articuloxorden')
                ->join('ord_orden', 'axo_id_ord = ord_id')
                ->join('art_articulo', 'axo_id_art = art_id')
                ->join('cva_conversion_articulo', 'cva_id = axo_id_cva')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
        ;
        if ( $where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles de los controles de calidad
    */
    public function get_detalle_prueba_calidad($where = null) {
        $this->db->select("*, 
                        (SELECT fca_id FROM fca_factores_calidad_articulo WHERE fca_id_art = axo_id_art and fca_id_fcc = dci_id_fcc) AS fca_id, 
                        (SELECT art_nombre FROM art_articulo WHERE art_id = axo_id_art) AS producto", false)
                ->from('dci_detalle_control_calidad')
                ->join('axo_articuloxorden', 'axo_id = dci_id_axo')
                ->join('fcc_factor_calidad', 'fcc_id = dci_id_fcc')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles de la proyeccion de ventas
    */
    public function get_detalle_proyeccion($where = null) {
        $this->db->select("*, 
                        (SELECT tia_nombre FROM tia_tipo_articulo WHERE tia_id = art_id_tia) AS categoria, 
                        (SELECT mep_nombre FROM mep_medida_producto WHERE mep_id = cva_id_mep) AS unidad", false)
                ->from('pyv_pryeccion_venta')
                ->join('art_articulo', 'pyv_id_art = art_id')
                ->join('cva_conversion_articulo', 'cva_id = pyv_id_cva')
                ->order_by('pyv_id_art, pyv_periodo')                
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles del reporte programacion de produccion
    */
    public function get_reporte_programacion($where = null){
        $this->db->select("*, (SELECT ord_codigo FROM ord_orden WHERE ord_id = dpp_id_ord) AS ord_codigo,
            (SELECT tia_nombre FROM tia_tipo_articulo WHERE tia_id = art_id_tia) AS tia_nombre,
            (SELECT mep_nombre FROM mep_medida_producto JOIN cva_conversion_articulo ON mep_id = cva_id_mep WHERE cva_id = dpp_id_cva) AS unidad
        ", false)
        ->from('ppd_programacion_produccion')
        ->join('dpp_detalle_programacion_produccion', 'ppd_id = dpp_id_ppd')
        ->join('art_articulo', 'art_id = dpp_id_art')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles del reporte programacion de produccion
    */
    public function get_reporte_planificacion($where = null){
        $this->db->select("*, (SELECT tia_nombre FROM tia_tipo_articulo WHERE tia_id = art_id_tia) AS tia_nombre,
            (SELECT mep_nombre FROM mep_medida_producto JOIN cva_conversion_articulo ON mep_id = cva_id_mep WHERE cva_id = dpf_id_cva) AS unidad,
            IF(dpf_inventario_op_anterior IS NULL,'--',(SELECT ord_codigo FROM ord_orden WHERE ord_id = dpf_inventario_op_anterior)) AS ord_codigo
        ", false)
        ->from('plf_planificacion')
        ->join('dpf_detalle_planificacion', 'plf_id = dpf_id_plf')
        ->join('art_articulo', 'art_id = dpf_id_art')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles del reporte programacion de produccion
    */
    public function get_reporte_explosion_mat($tipo, $where = null){
        if ($where != null) {
            $this->db->where($where);
        }
        if ($tipo > 0) {
            //programacion
            $this->db->select("*, (SELECT tia_nombre FROM tia_tipo_articulo WHERE tia_id = art_id_tia) AS tia_nombre,
                (SELECT mep_nombre FROM mep_medida_producto WHERE mep_id = cva_id_mep) AS mep_nombre,
                IF((edp_tipo = 3 AND edp_id_rxi IS NOT NULL),(SELECT rxi_numero FROM rxi_requisicion_inventario WHERE rxi_id = edp_id_rxi),'') AS rex_invent
                ", false)
                ->from("edp_explosion_detalle_programacion")
                ->join("art_articulo", "art_id = edp_id_art")
                ->join("cva_conversion_articulo", "cva_id = edp_id_cva")
            ;
        } else {
            //planificacion
            //-- 1=compras, 2=produccion, 3=inventario
            $this->db->select("*, (SELECT tia_nombre FROM tia_tipo_articulo WHERE tia_id = art_id_tia) AS tia_nombre,
                (SELECT mep_nombre FROM mep_medida_producto WHERE mep_id = cva_id_mep) AS mep_nombre,
                IF((dex_tipo = 1 AND dex_id_rxi IS NOT NULL),(SELECT rxi_numero FROM rxi_requisicion_inventario WHERE rxi_id = dex_id_rxi),'') AS rex_compras,
                IF((dex_tipo = 2 AND dex_id_ord IS NOT NULL),(SELECT ord_codigo FROM ord_orden WHERE ord_id = dex_id_ord),'') AS op_intermedio
                ", false)
                ->from("dex_detalle_explosion")
                ->join("art_articulo", "art_id = dex_id_art")
                ->join("cva_conversion_articulo", "cva_id = dex_id_cva")
            ;
        }
        
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles de las ordenes de produccion activas
    */
    public function get_ordenes_general($where = null) {
        $this->db->select()
                ->from('ord_orden')
                ->join('axo_articuloxorden', 'axo_id_ord = ord_id')
                ->join('art_articulo', 'art_id = axo_id_art')
                ->join('cva_conversion_articulo', 'axo_id_cva = cva_id')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep')
                ->join('cli_cliente', 'cli_id = ord_id_cli', 'left')
                ->order_by('art_codigo, ord_fecha ASC')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles de las mat. primas segun un detalle de orden
    */
    public function get_mp_axo($where = null) {
        $this->db->select("*,(SELECT mep_nombre FROM cva_conversion_articulo JOIN mep_medida_producto ON cva_id_mep = mep_id WHERE cva_id = axm_id_cva AND cva_estado= 1) AS medida,
                        IFNULL((SELECT etp_nombre FROM etp_etapa WHERE etp_id = axm_id_etp), '--') AS etapa,
                        (SELECT CONCAT(art_codigo,' - ',art_nombre) FROM art_articulo WHERE art_id = axo_id_art) AS a_producir", false)
                ->from('axo_articuloxorden')
                ->join('axm_articulo_matxarticulo_ord', 'axm_id_axo = axo_id')
                ->join('art_articulo', 'art_id = axm_id_art_materia')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles de la mano de obra segun un detalle de orden
    */
    public function get_mob_axo($where = null) {
        $this->db->select("*, IFNULL((SELECT CONCAT(emp_nombre, ' ', emp_apellido) FROM emp_empleado WHERE emp_id = mxo_id_emp), '') AS responsable", false)
                ->from('axo_articuloxorden')
                ->join('mxo_mano_obraxarticulo_ord', 'mxo_id_axo = axo_id')
                ->join('mob_mano_obra', 'mob_id = mxo_id_mob')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles de los gastos indirectos de fabricacion segun el detalle de orden
    */
    public function get_gif_axo($where = null) {
        $this->db->select()
                ->from('axo_articuloxorden')
                ->join('exr_estimacionxarticulo', 'exr_id_axo = axo_id')
                ->join('esm_estimacion', 'exr_id_esm = esm_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles de la mano de obra segun receta de un producto
    */
    public function get_mob_receta($where = null) {
        $this->db->select("*, IFNULL((SELECT SUM(eta_duracion_mod) FROM eta_etapa_articulo WHERE eta_id_art = axo_id_art), 0) AS suma_hora_etapa", false)
            ->from('axo_articuloxorden')
            ->join('moa_mano_obra_articulo', 'moa_id_art = axo_id_art')
            ->join('mob_mano_obra', 'moa_id_mob = mob_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles de los gastos de fab. segun receta de un producto
    */
    public function get_gif_receta($where = null) {
        $this->db->select("*, IFNULL((SELECT SUM(eta_duracion) FROM eta_etapa_articulo WHERE eta_id_art = axo_id_art), 0) AS suma_hora_etapa", false)
            ->from('axo_articuloxorden')
            ->join('esr_estimacion_articulo', 'esr_id_art = axo_id_art')
            ->join('esm_estimacion', 'esm_id = esr_id_esm')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles de las mat. primas segun receta de un producto
    */
    public function get_mp_receta($where = null) {
        $this->db->select("mpa_materia_prima_articulo.*, axo_id, axo_cantidad,
            IF(mpa_tipo_precio > 1, 
                IFNULL((SELECT dee_precio FROM dee_detalle_mov JOIN moi_movimiento_inv ON dee_id_moi = moi_id WHERE dee_id_art = mpa_id_art_materia AND dee_id_cva = mpa_id_cva ORDER BY moi_fecha_mov DESC LIMIT 1),0), 
                IFNULL((SELECT AVG(sar_precio) FROM sar_saldo_articulo WHERE sar_id_art = mpa_id_art_materia),0)
            ) AS costo_receta,
            CASE
                WHEN mpa_tipo_precio = 2 THEN
                    (IFNULL((SELECT dxd_precio_unitario FROM dpv_documento_proveedor JOIN dxd_detalle_documento_proveedor ON dxd_id_dpv = dpv_id
                        WHERE dxd_id_art = mpa_id_art_materia ORDER BY dpv_fecha_documento, dpv_id DESC LIMIT 1), 0))
                WHEN mpa_tipo_precio = 3 THEN
                    (IFNULL((SELECT (((SELECT IFNULL(SUM(axm_cantidad * axm_precio), 0) FROM axm_articulo_matxarticulo_ord WHERE axm_id_axo = axo_id)
                    + (SELECT IFNULL(SUM(mxo_cantidad * mxo_precio), 0) FROM mxo_mano_obraxarticulo_ord WHERE mxo_id_axo = axo_id) 
                    + (SELECT IFNULL(SUM(exr_monto_calculo), 0) FROM exr_estimacionxarticulo WHERE exr_id_axo = axo_id)) / axo_cantidad)  AS costo
                    FROM axo_articuloxorden WHERE axo_id_art = mpa_id_art_materia ORDER BY axo_id DESC LIMIT 1), 0))
                ELSE
                    (SELECT IFNULL((SUM(sar_cant_actual * sar_precio) / SUM(sar_cant_actual)), 0) FROM sar_saldo_articulo WHERE sar_id_art = mpa_id_art_materia)
            END AS tipos_precio", false)
                ->from('axo_articuloxorden')
                ->join('mpa_materia_prima_articulo', 'mpa_id_art = axo_id_art')
                ->join('ord_orden', 'ord_id = axo_id_ord')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul Escalante
    * Devuelve los detalles de la produccion ingresados en el Job trackig con su costos
    */
    public function get_produc_valorizada($where = null){
        //Obtener los moi originados desde el job tracking
        $moes = $this->db->select('moe_id_moi')->from('moe_movimiento_etapa')->where('moe_id_moi IS NOT NULL')->get()->result_array();
        $permitidas = (count($moes) > 0) ? array_column($moes, 'moe_id_moi') : array(0);
        //obtener los demas datos
        $this->db->select("*, SUM(dee_cantidad) AS cantidad, AVG(dee_precio) AS costo_unitario, 
            (SELECT mep_nombre FROM mep_medida_producto JOIN cva_conversion_articulo ON cva_id_mep = mep_id WHERE cva_id = dee_id_cva) AS medida", false)
                ->from('moi_movimiento_inv')
                ->join('dee_detalle_mov', 'dee_id_moi = moi_id')
                ->join('art_articulo', 'art_id = dee_id_art')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
                ->where_in('moi_id', $permitidas)
                ->group_by('art_id')
                ->order_by('tia_id, art_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

      /**
    * @autor Marlon Olmedo
    * devuelve los detalles de programacion por operario
    */
    public function get_detalle_programacion($where) {
        $this->db->select("*", false)
                ->from('dpg_detalle_programacion')
                ->join('dpp_detalle_programacion_produccion', 'dpg_id_dpp = dpp_id')
                ->join('cva_conversion_articulo', 'dpp_id_cva = cva_id', "left")
                ->join('mep_medida_producto', 'cva_id_mep = mep_id', "left")
                ->join('art_articulo', 'dpp_id_art = art_id', "left")
                ->join('ord_orden', 'dpp_id_ord = ord_id', "left")
                ->join('etp_etapa', 'dpg_id_etp = etp_id')
                ->join('maq_maquina', 'dpg_id_maq = maq_id', "left")
                ->join('dpo_detalle_programacion_operario', 'dpo_id_dpg = dpg_id')
            ;
            $this->db->where($where);
            $this->db->order_by("dpg_id_etp");
        return $this->db->get()->result_array();
    }

    /**
    * @autor Marlon Olmedo
    * devuelve los detalles para la generacion de detalle de hoja OP
    */
    public function get_detalle_hoja_OP($where = null, $order_by = null) {
        
            $this->db->select("*", false)
                ->from('axm_articulo_matxarticulo_ord')
                ->join('art_articulo', 'axm_id_art_materia = art_id', "left")
                ->join('etp_etapa', 'axm_id_etp = etp_id', "left")
            ;
            if ($where != null) {
                $this->db->where($where);
            }
            if ($order_by != null) {
                $this->db->order_by($order_by);
            }
            
        return $this->db->get()->result_array();
    }

    /**
    * @autor Marlon Olmedo
    * devuelve el penultimo registro
    */
    public function get_penultimo_reg($from,$where = null,$order_by) {
        
            $this->db->select("*", false)
                ->from($from);
            if ($where != null) {
                $this->db->where($where);
            }
                $this->db->order_by($order_by,"DESC");
                $this->db->limit(1,1);
            
        return $this->db->get()->result_array();
    }

    public function get_total_explosion($articulo = null, $cantidad = null, $intermedio = null, $mat_prima = null){
        $bod_inter = ($intermedio != null) ? " AND sar_id_bod = $intermedio" : "";
        $bod_mater = ($mat_prima != null) ? " AND sar_id_bod = $mat_prima" : "";
        $query = "CONCAT(mpa_id_art_materia, '#', mpa_id_cva) AS array_key, mpa_id_art_materia, mpa_id_cva,
                    art_produccion, art_materia_prima, (mpa_cantidad * $cantidad) as total_requerido,
                    IF(art_produccion > 0,
                        (SELECT IFNULL(SUM(sar_cant_actual), 0) FROM sar_saldo_articulo WHERE sar_id_art = mpa_id_art_materia $bod_inter),
                        (SELECT IFNULL(SUM(sar_cant_actual), 0) FROM sar_saldo_articulo WHERE sar_id_art = mpa_id_art_materia $bod_mater)
                    ) AS disponible";
        $this->db->select($query, false)
                ->from('mpa_materia_prima_articulo')
                ->join('art_articulo', 'art_id = mpa_id_art_materia')
                ->join('cva_conversion_articulo', 'cva_id_art = mpa_id_art AND cva_defecto = 1')
                ->where('mpa_id_art', $articulo)
                ->group_by('mpa_id_art_materia, mpa_id_cva')
                ->order_by('mpa_id_art_materia', 'ASC')
        ;
        return $this->db->get()->result_array();
    }

    /**
    * @autor Marlon Olmedo
    * devuelve trae la receta y el costeo de una orden de produccion
    */
    public function get_rec_x_cost_ord($axo_id,$art_id,$where = null,$order_by,$caso) {
        if ($caso == 1) {
            $query_1 ="SELECT 
            '' AS axm_id, 
            mpa_id, 
            art_id,mpa_precio,
            '' as axm_precio,
            art_codigo,
            art_nombre,
            mpa_cantidad,
            '' as axm_cantidad,
            art_precio_sugerido
            FROM mpa_materia_prima_articulo 
            left join art_articulo on mpa_id_art_materia = art_id 
            left join cva_conversion_articulo on mpa_id_cva = cva_id 
            left join mep_medida_producto on cva_id_mep = mep_id 
            where mpa_id_art = $art_id";

            $query_2 ="SELECT 
            axm_id, 
            '' AS mpa_id, art_id,
            '' as mpa_precio, 
            axm_precio ,
            art_codigo,
            art_nombre,
            '' as mpa_cantidad,
            axm_cantidad,
            art_precio_sugerido
            FROM axm_articulo_matxarticulo_ord 
            left join art_articulo on axm_id_art_materia = art_id 
            left join cva_conversion_articulo on axm_id_cva = cva_id 
            left join mep_medida_producto on cva_id_mep = mep_id 
            WHERE axm_id_axo = $axo_id";

        } elseif ($caso == 2) {

            $query_1 ="SELECT
            '' AS mxo_id,
            moa_id,
            mob_id,
            moa_precio,
            '' AS mxo_precio,
            mob_codigo,
            mob_nombre,
            moa_cantidad,
            '' AS mxo_cantidad,
            mob_precio
            FROM
            moa_mano_obra_articulo
            LEFT JOIN mob_mano_obra ON moa_id_mob = mob_id 
            WHERE
            moa_id_art = $art_id";

            $query_2 ="SELECT
            mxo_id,
            '' AS moa_id,
            mob_id,
            '' AS moa_precio,
            mxo_precio,
            mob_codigo,
            mob_nombre,
            '' AS moa_cantidad,
            mxo_cantidad,
            mob_precio
            FROM
            mxo_mano_obraxarticulo_ord
            LEFT JOIN mob_mano_obra ON mxo_id_mob = mob_id 
            WHERE
            mxo_id_axo = $axo_id";

        } elseif ($caso == 3) {
            $query_1 ="SELECT
            '' AS exr_id,
            esr_id,
            esm_id,
            esr_precio,
            '' AS exr_precio,
            esm_codigo,
            esm_nombre,
            esr_cantidad,
            '' AS exr_cantidad,
            esm_monto 
            FROM
            esr_estimacion_articulo
            LEFT JOIN esm_estimacion ON esr_id_esm = esm_id 
            WHERE
            esr_id_art = $art_id";

            $query_2 ="SELECT
            exr_id,
            '' AS esr_id,
            esm_id,
            '' AS esr_precio,
            exr_precio,
            esm_codigo,
            esm_nombre,
            '' AS esr_cantidad,
            exr_cantidad,
            esm_monto 
            FROM
            exr_estimacionxarticulo
            LEFT JOIN esm_estimacion ON exr_id_esm = esm_id 
            WHERE
            exr_id_axo = $axo_id";
        }

        $query = $this->db->query("SELECT * FROM (($query_1) UNION ($query_2)) as t_union ORDER BY $order_by");
            
        return $query->result_array();
    }

    /**
    * @autor Marlon Olmedo
    * devuelve el penultimo registro
    */
    public function get_art_cant_real($where = null) {
        
            $this->db->select("*, ord_codigo, 
            art_codigo, art_nombre, 
            CONCAT(ROUND(axo_cantidad),' ',mep_codigo) as presentacion, 
            axo_cantidad, 
            (
	SELECT
	sum(sar_cant_actual)
FROM
	sar_saldo_articulo
	left join dee_detalle_mov on dee_id_sar = sar_id
	left join moi_movimiento_inv on dee_id_moi = moi_id
	left join moe_movimiento_etapa on moe_id_moi = moi_id
	left join exo_etapaxarticulo_orden on moe_id_exo = exo_id
	left join lop_lote_produccion on exo_id_lop = lop_id
	where lop_id_axo = axo_id
    ) as cantiada_real, axo_total_gastos, 
    (
	SELECT
	sum(sar_precio)
FROM
	sar_saldo_articulo
	left join dee_detalle_mov on dee_id_sar = sar_id
	left join moi_movimiento_inv on dee_id_moi = moi_id
	left join moe_movimiento_etapa on moe_id_moi = moi_id
	left join exo_etapaxarticulo_orden on moe_id_exo = exo_id
	left join lop_lote_produccion on exo_id_lop = lop_id
	where lop_id_axo = axo_id
	) as gasto_total_real", false)
                ->from("axo_articuloxorden")
                ->join('ord_orden', 'axo_id_ord = ord_id', "left")
                ->join('art_articulo', 'axo_id_art = art_id', "left")
                ->join('cva_conversion_articulo', 'axo_id_cva = cva_id', "left")
                ->join('mep_medida_producto', 'cva_id_mep = mep_id', "left")
                ;
            if ($where != null) {
                $this->db->where($where);
            }
            
        return $this->db->get()->result_array();
    }

    /**
    * @autor Raul E.
    * Trae los detalles de materiales de la receta cuando no hay presupuesto
    */
    public function get_materia_prima_producto_segun_receta($where = null) {
        $query = $this->db->select("*, (SELECT etp_id FROM etp_etapa WHERE etp_id = mpa_id_etp) AS etapa_id, 
            (SELECT etp_nombre FROM etp_etapa WHERE etp_id = mpa_id_etp) AS etapa_nombre,
            CASE 
                WHEN mpa_tipo_precio = 2 THEN
                    (IFNULL((SELECT ((dxd_subtotal/dxd_cantidad)/cva_conversion) FROM dpv_documento_proveedor JOIN dxd_detalle_documento_proveedor ON dxd_id_dpv = dpv_id 
                        JOIN cva_conversion_articulo ON cva_id = dxd_id_cva WHERE dxd_id_art = art_id ORDER BY dpv_fecha_documento DESC, dpv_id DESC LIMIT 1), 0))
                WHEN mpa_tipo_precio = 3 THEN
                    (IFNULL((SELECT (((SELECT IFNULL(SUM(axm_cantidad * axm_precio), 0) FROM axm_articulo_matxarticulo_ord WHERE axm_id_axo = axo_id) + 
                        (SELECT IFNULL(SUM(mxo_cantidad * mxo_precio), 0) FROM mxo_mano_obraxarticulo_ord WHERE mxo_id_axo = axo_id)      + 
                        (SELECT IFNULL(SUM(exr_monto_calculo), 0) FROM exr_estimacionxarticulo WHERE exr_id_axo = axo_id)) / axo_cantidad)  AS costo 
                        FROM axo_articuloxorden WHERE axo_id_art = art_id ORDER BY axo_id DESC LIMIT 1), 0))
                WHEN mpa_tipo_precio = 4 THEN 
                    (IFNULL(mpa_precio,0))
                ELSE
                    (SELECT IFNULL((SUM(sar_cant_actual * sar_precio) / SUM(sar_cant_actual)), 0) FROM sar_saldo_articulo WHERE sar_id_art = art_id)
            END AS tipos_precio
            ", false)
            ->from('mpa_materia_prima_articulo')
            ->join('art_articulo', 'art_id = mpa_id_art_materia', 'inner')
            ->join('cva_conversion_articulo', 'cva_id = mpa_id_cva', 'left')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
            ->join('prv_proveedor', 'prv_id = mpa_id_prv', 'left')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
    * @autor Raul E.
    */
    public function get_act_price_mat_prima($where = null, $tipo = 0) {
        $query = $this->db->select("mpa_id_art_materia, CASE WHEN mpa_tipo_precio = 2 THEN
                    (IFNULL((SELECT ((dxd_subtotal/dxd_cantidad)/cva_conversion) FROM dpv_documento_proveedor JOIN dxd_detalle_documento_proveedor ON dxd_id_dpv = dpv_id 
                        JOIN cva_conversion_articulo ON cva_id = dxd_id_cva WHERE dxd_id_art = art_id ORDER BY dpv_fecha_documento DESC, dpv_id DESC LIMIT 1), 0))
                WHEN mpa_tipo_precio = 3 THEN
                    (IFNULL((SELECT (((SELECT IFNULL(SUM(axm_cantidad * axm_precio), 0) FROM axm_articulo_matxarticulo_ord WHERE axm_id_axo = axo_id) + 
                        (SELECT IFNULL(SUM(mxo_cantidad * mxo_precio), 0) FROM mxo_mano_obraxarticulo_ord WHERE mxo_id_axo = axo_id)      + 
                        (SELECT IFNULL(SUM(exr_monto_calculo), 0) FROM exr_estimacionxarticulo WHERE exr_id_axo = axo_id)) / axo_cantidad)  AS costo 
                        FROM axo_articuloxorden WHERE axo_id_art = art_id ORDER BY axo_id DESC LIMIT 1), 0))
                WHEN mpa_tipo_precio = 4 THEN 
                    (IFNULL(mpa_precio,0))
                ELSE
                    (SELECT IFNULL((SUM(sar_cant_actual * sar_precio) / SUM(sar_cant_actual)), 0) FROM sar_saldo_articulo WHERE sar_id_art = art_id)
                END AS tipos_precio
            ", false)
            ->from('mpa_materia_prima_articulo')
            ->join('art_articulo', 'art_id = mpa_id_art_materia')
        ;
        if ($tipo > 0) {
            $this->db->join('axr_articulo_materiaxarticulo', 'mpa_id_art_materia = axr_id_art_materia');
        } else {
            $this->db->join('axm_articulo_matxarticulo_ord', 'mpa_id_art_materia = axm_id_art_materia');
        }        
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_costo_mpa($where = null){
        $this->db->select("SUM((CASE WHEN mpa_tipo_precio = 2 THEN (IFNULL((SELECT dxd_precio_unitario FROM dpv_documento_proveedor JOIN dxd_detalle_documento_proveedor ON dxd_id_dpv = dpv_id 
            WHERE dxd_id_art = mpa_id_art_materia ORDER BY dpv_fecha_documento, dpv_id DESC LIMIT 1), 0)) WHEN mpa_tipo_precio = 3 THEN (IFNULL((SELECT (((SELECT 
            IFNULL(SUM(axm_cantidad * axm_precio), 0) FROM axm_articulo_matxarticulo_ord WHERE axm_id_axo = axo_id) + (SELECT IFNULL(SUM(mxo_cantidad * mxo_precio), 0) 
            FROM mxo_mano_obraxarticulo_ord WHERE mxo_id_axo = axo_id) + (SELECT IFNULL(SUM(exr_monto_calculo), 0) FROM exr_estimacionxarticulo WHERE exr_id_axo = axo_id)) / axo_cantidad)
            AS costo FROM axo_articuloxorden WHERE axo_id_art = mpa_id_art_materia ORDER BY axo_id DESC LIMIT 1), 0)) WHEN mpa_tipo_precio = 4 THEN (IFNULL(mpa_precio,0)) ELSE 
            (SELECT IFNULL((SUM(sar_cant_actual * sar_precio) / SUM(sar_cant_actual)),0) FROM sar_saldo_articulo WHERE sar_id_art = mpa_id_art_materia) END) * mpa_cantidad) AS costo", false)
        ->from('mpa_materia_prima_articulo')
        ;        
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->row_array();
    }

    public function get_detalle_programacionxdet($where=null,$order_by=null){
        $this->db->select("*, (
            SELECT GROUP_CONCAT( 
                CONCAT( 
                    CONCAT_WS(';uwu;', etp_id, maq_id, etp_nombre, maq_nombre, dpg_horas, dpg_fecha),
                    ';uwu;',
                    (SELECT GROUP_CONCAT(dpo_id_opr) FROM dpo_detalle_programacion_operario WHERE dpo_id_dpg = dpg_id),
                    ';uwu;',
                    (SELECT GROUP_CONCAT(CONCAT(emp_nombre,' ',emp_apellido) SEPARATOR ', ') FROM dpo_detalle_programacion_operario JOIN opr_operario ON opr_id = dpo_id_opr 
                        JOIN emp_empleado ON emp_id = opr_id_emp WHERE dpo_id_dpg = dpg_id)
                )
            SEPARATOR '&&') FROM dpg_detalle_programacion LEFT JOIN etp_etapa ON dpg_id_etp = etp_id LEFT JOIN maq_maquina ON dpg_id_maq = maq_id WHERE dpg_id_dpp = dpp_id
        ) AS det_progra ", false)
        ->from('dpp_detalle_programacion_produccion')
        ->join('ord_orden', 'dpp_id_ord = ord_id', 'left')
        ->join('axo_articuloxorden', 'dpp_id_ord = axo_id_ord', 'left')
        ->join('art_articulo', 'axo_id_art = art_id', 'left')
        ->join('tia_tipo_articulo', 'art_id_tia = tia_id', 'left')
        ->join('cva_conversion_articulo', 'axo_id_cva = cva_id', 'left')
        ->join('mep_medida_producto', 'cva_id_mep = mep_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $this->db->get()->result_array();
    }

    public function get_detalles_cierre_orden($where = null){
        $this->db->select("*,
            IFNULL((SELECT SUM(axm_despachada) FROM axm_articulo_matxarticulo_ord WHERE axm_id_axo = axo_id AND axm_id_art_materia = mpa_id_art_materia), 0) AS total_solicitado,
            IFNULL((SELECT SUM(axm_devolucion) FROM axm_articulo_matxarticulo_ord WHERE axm_id_axo = axo_id AND axm_id_art_materia = mpa_id_art_materia), 0) AS material_devuelto,
            IFNULL((SELECT SUM(exo_duracion_mano_obra) FROM exo_etapaxarticulo_orden JOIN lop_lote_produccion ON exo_id_lop = lop_id WHERE lop_id_axo = axo_id), 0) AS sum_mob,
            IFNULL((SELECT SUM(exo_duracion) FROM exo_etapaxarticulo_orden JOIN lop_lote_produccion ON exo_id_lop = lop_id WHERE lop_id_axo = axo_id), 0) AS sum_gif,
            IFNULL((SELECT SUM(dee_cantidad) FROM dee_detalle_mov JOIN moe_movimiento_etapa ON moe_id_moi = dee_id_moi JOIN exo_etapaxarticulo_orden ON moe_id_exo = exo_id 
                JOIN lop_lote_produccion ON exo_id_lop = lop_id WHERE lop_id_axo = axo_id), 0) AS ctdad_real", false)
        ->from('axo_articuloxorden')
        ->join('mpa_materia_prima_articulo', 'axo_id_art = mpa_id_art')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_rpt_ordenes_finalizadas($where = null, $group = null){
        $this->db->select("ord_codigo, axo_cantidad, art_codigo, art_nombre, ord_fecha_ejecucion, IFNULL(SUM(lop_cantidad), 0) AS lop_cantidad,
            IF(cli_personeria > 1, cli_apellido, CONCAT(cli_nombre,' ',cli_apellido)) AS cliente",false)
            ->from('lop_lote_produccion')
            ->join('axo_articuloxorden', 'lop_id_axo = axo_id')
            ->join('art_articulo', 'art_id = axo_id_art')
            ->join('ord_orden', 'axo_id_ord = ord_id')
            ->join('cli_cliente', 'ord_id_cli = cli_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($group != null) {
            $this->db->group_by($group);
        }
        return $this->db->get()->result_array();
    }

    public function get_total_axo_automatico($where = null){
        $this->db->select("axo_id, (SELECT SUM((axm_cantidad * axm_precio)) FROM axm_articulo_matxarticulo_ord WHERE axm_id_axo = axo_id) AS materia_prima,
            (SELECT SUM((mxo_cantidad * mxo_precio)) FROM mxo_mano_obraxarticulo_ord WHERE mxo_id_axo = axo_id) AS mano_obra,
            (SELECT SUM((exr_cantidad * exr_precio)) FROM exr_estimacionxarticulo JOIN esm_estimacion ON exr_id_esm = esm_id WHERE esm_tipo_calculo = 1 AND exr_id_axo = axo_id) AS gif_monto_fijo,
            (SELECT SUM(IF(axm_estimacion_porcentaje > 0, (SELECT ((SUM(esm_monto) * (axm_cantidad * axm_precio)) / 100) FROM exr_estimacionxarticulo JOIN esm_estimacion on esm_id = exr_id_esm 
                WHERE esm_tipo_calculo = 0 AND exr_id_axo = axm_id_axo), 0)) FROM axm_articulo_matxarticulo_ord WHERE axm_id_axo = axo_id) AS gif_porc_axm,
            (SELECT SUM(IF(mxo_estimacion_porcentaje > 0, (SELECT ((SUM(esm_monto) * (mxo_precio * mxo_cantidad)) / 100) FROM exr_estimacionxarticulo join esm_estimacion on esm_id = exr_id_esm 
                WHERE esm_tipo_calculo = 0 AND exr_id_axo = mxo_id_axo), 0)) FROM mxo_mano_obraxarticulo_ord where mxo_id_axo = axo_id) AS gif_porc_mob
            ",false)
            ->from('axo_articuloxorden')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();        
    }

    public function get_rpt_pruebas_calidad($where = null){
        $this->db->select()
            ->from('ccr_control_calidad_orden')
            ->join('dci_detalle_control_calidad', 'dci_id_ccr = ccr_id')
            ->join('ord_orden', 'ord_id = ccr_id_ord')
            ->join('cli_cliente', 'cli_id = ord_id_cli')
            ->join('fcc_factor_calidad', 'fcc_id = dci_id_fcc')
            ->join('axo_articuloxorden', 'axo_id = dci_id_axo')
            ->join('art_articulo', 'art_id = axo_id_art')
            ->order_by('ccr_fecha, axo_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_rpt_job_tracking($where = null, $having = null){
        $this->db->select('*, (SELECT IF(cli_personeria > 1,cli_apellido,CONCAT(cli_nombre," ",cli_apellido)) FROM cli_cliente WHERE cli_id = ord_id_cli) AS cliente,
            (SELECT CONCAT(art_codigo," - ",art_nombre) FROM art_articulo WHERE art_id = axo_id_art) AS producto, (SELECT etp_nombre FROM etp_etapa WHERE etp_id = exo_id_etp) AS etp_nombre,
            IFNULL((SELECT e.exo_id_etp FROM exo_etapaxarticulo_orden AS e WHERE e.exo_id_lop = lop_id AND e.exo_cantidad IS NOT NULL ORDER BY e.exo_orden DESC LIMIT 1), 
            (SELECT e.exo_id_etp FROM exo_etapaxarticulo_orden AS e WHERE e.exo_id_lop = lop_id ORDER BY e.exo_orden ASC LIMIT 1)) AS max_etapa,
            (SELECT maq_nombre FROM dpp_detalle_programacion_produccion JOIN dpg_detalle_programacion ON dpg_id_dpp = dpp_id LEFT JOIN maq_maquina ON maq_id = dpg_id_maq 
            WHERE dpp_id_ord = ord_id AND dpg_id_etp = max_etapa AND dpp_id_art = axo_id_art LIMIT 1) AS maquina,
            (SELECT GROUP_CONCAT(CONCAT(emp_nombre," ",emp_apellido) SEPARATOR ", ") FROM dpp_detalle_programacion_produccion JOIN dpg_detalle_programacion ON dpg_id_dpp = dpp_id
            JOIN dpo_detalle_programacion_operario ON dpo_id_dpg = dpg_id JOIN opr_operario ON opr_id = dpo_id_opr JOIN emp_empleado ON emp_id = opr_id_emp 
            WHERE dpp_id_ord = ord_id AND dpg_id_etp = max_etapa AND dpp_id_art = axo_id_art LIMIT 1) AS operario', false)
            ->from('exo_etapaxarticulo_orden')
            ->join('lop_lote_produccion', 'exo_id_lop = lop_id')
            ->join('axo_articuloxorden', 'lop_id_axo = axo_id')
            ->join('ord_orden', 'axo_id_ord = ord_id')
            ->order_by('ord_id, exo_orden ASC')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($having != null) {
            $this->db->having($having);
        }
        return $this->db->get()->result_array();
    }

}

// Fin Modelo

