<?php

/**
 * Planilla_Model
 * 2013-07-11
 * @package erpConamype
 * @author Alexis Beltran
 * @copyright 2013
 * @version RC1
 * @access public
 */

/**
 * Planilla_Model
 * 
 * @package municipalidad
 * @author satelite
 * @copyright 2013
 * @version $Id$
 * @access public
 */
class Planilla_Model extends CI_Model
{

    protected $debug = 0;
    //listado de tablas
    protected $empleados = 'emp_empleado';
    protected $descuentos = 'dss_descuento';
    protected $ingresos = 'inn_ingreso';
    protected $tipo_descuentos = 'tdc_tipo_descuento';
    protected $tipo_ingresos = 'tig_tipo_ingreso';
    protected $tipo_planillas = 'tpl_tipo_planilla';
    protected $planillas = 'pla_planilla';
    protected $detalle_descuentos = 'ddd_detalle_descuento';
    protected $detalle_ingresos = 'ddi_detalle_ingreso';
    protected $desxplanilla = 'dtp_descuentoxtipo_planilla';
    protected $ingxplanilla = 'itp_ingresoxtipo_planilla';
    protected $afps = 'afp_afp';
    protected $tipos_descuento = null;
    protected $tipos_ingreso = null;
    protected $afp = null;
    var $agrupador_isr = null;
    var $agrupador_afp = null;
    var $agrupador_isss = null;
    var $agrupador_salario = null;
    var $agrupador_isr_10p = null;
    var $tdc_isr = null;
    var $tdc_isss = null;
    var $tdc_afp = null;
    var $tdc_isr_10p = null;
    var $tig_salario = null;
    var $tig_hed = null;
    var $tig_hen = null;
    var $tig_bonificacion = null;
    var $tig_viatico = null;
    var $tig_vacacion = null;
    var $tig_comision = null;

    function __construct()
    {
        parent::__construct();
        $this->agrupador_isr = $this->gsatelite->get_parametro('AGRUPADOR_ISR');
        $this->agrupador_afp = $this->gsatelite->get_parametro('ID_AGRUPADOR_AFP');
        $this->agrupador_isss = $this->gsatelite->get_parametro('AGRUPADOR_ISS');
        $this->agrupador_salario = $this->gsatelite->get_parametro('AGRUPADOR_SALARIO');
        $this->agrupador_isr_10p = $this->gsatelite->get_parametro('AGRUPADOR_ISR10');
        $this->tdc_isr = $this->gsatelite->get_parametro('DESCUENTO_ISR');
        $this->tdc_isss = $this->gsatelite->get_parametro('DESCUENTO_ISS');
        $this->tdc_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
        $this->tdc_isr_10p = $this->gsatelite->get_parametro('DESCUENTO_ISR10');
        $this->tig_salario = $this->gsatelite->get_parametro('INGRESO_SALARIO');
        $this->tig_hed = $this->gsatelite->get_parametro('INGRESO_HED');
        $this->tig_hen = $this->gsatelite->get_parametro('INGRESO_HEN');
        $this->tig_bonificacion = $this->gsatelite->get_parametro('INGRESO_BONIFICACIONES');
        $this->tig_viatico = $this->gsatelite->get_parametro('INGRESO_VIATICOS');
        $this->tig_vacacion = $this->gsatelite->get_parametro('INGRESO_VACACIONES');
        $this->tig_comision = $this->gsatelite->get_parametro('INGRESO_COMISIONES');
        $this->tpl_comision = ($this->gsatelite->get_parametro('TPL_PLANILLAS', null, null, array('COMISIONES')) > 0) ? $this->gsatelite->get_parametro('TPL_PLANILLAS', null, null, array('COMISIONES')) : 0;
        $this->tpl_quincena = ($this->gsatelite->get_parametro('TPL_PLANILLAS', null, null, array('QUINCENAL')) > 0) ? $this->gsatelite->get_parametro('TPL_PLANILLAS', null, null, array('QUINCENAL')) : 0;
        $this->tpl_vacacion = (trim($this->gsatelite->get_parametro('TPL_PLANILLAS', null, null, array('VACACIONES'))) != "") ? $this->gsatelite->get_parametro('TPL_PLANILLAS', null, null, array('VACACIONES')) : 0;
    }

    //--------- Planilla
    function get_tipo_contrato($where = null)
    {

        $puesto = $this->db->select()
            ->from('tpl_tipo_planilla')
            ->where('tpl_id_emr', $this->tank_auth->get_empresa_id());

        if ($where != null) {
            $this->db->where($where);
        }

        return $puesto->get()->result_array();
    }

    function info_completa_empleado($empleado = null)
    {
        $query = "SELECT * FROM emp_empleado 
                    LEFT JOIN gen_genero ON gen_id = emp_id_gen
                    LEFT JOIN esc_estado_civil ON esc_id = emp_id_esc
                    LEFT JOIN pro_profesion ON pro_id = emp_id_pro
                    LEFT JOIN pai_pais ON pai_id = emp_id_pai
                    LEFT JOIN afp_afp ON afp_id = emp_id_afp
                    LEFT JOIN suc_sucursal ON suc_id = emp_id_suc
                    LEFT JOIN are_area ON are_id = emp_id_are
                    LEFT JOIN plz_plaza ON plz_id = emp_id_plz
                    WHERE emp_id =" . $empleado;
        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }

    function info_completa_solicitante($solicitante = null)
    {
        $query = "SELECT * FROM sle_solicitante_empleo 
                    LEFT JOIN gen_genero ON gen_id = sle_id_gen
                    LEFT JOIN esc_estado_civil ON esc_id = sle_id_esc
                    LEFT JOIN pro_profesion ON pro_id = sle_id_pro
                    LEFT JOIN pai_pais ON pai_id = sle_id_pai
                    LEFT JOIN afp_afp ON afp_id = sle_id_afp
                    LEFT JOIN suc_sucursal ON suc_id = sle_id_suc
                    LEFT JOIN are_area ON are_id = sle_id_are
                    LEFT JOIN plz_plaza ON plz_id = sle_id_plz
                    WHERE sle_id =" . $solicitante;
        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }

    function telefono_empleado($id_emp)
    {
        $query = "SELECT * FROM emp_empleado 
                    INNER JOIN txm_telefonoxempleado ON txm_id_emp = emp_id
                    INNER JOIN tel_telefono ON tel_id = txm_id_tel
                    WHERE emp_id =" . $id_emp;
        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }

    function familiares_empleado($id_emp, $pat_id = null)
    {
        $especifico = ($pat_id) ? "AND pat_id = $pat_id" : "";
        $query = "SELECT * FROM emp_empleado 
                    INNER JOIN  fam_familiar ON fam_id_emp = emp_id
                    INNER JOIN pat_parentesco ON pat_id = fam_id_pat
                    WHERE fam_estado = 1 $especifico AND emp_id = $id_emp ";
        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }

    function get_horariosxturnos($where = null)
    {
        $this->db->select('*')
            ->from('plz_plaza')
            ->join('tur_turno', 'plz_id_tur = tur_id', 'INNER')
            ->join('dxt_detallexturno', 'dxt_id_tur = tur_id', "INNER")
            ->join('deh_detalle_horario', 'dxt_id_deh = deh_id', 'INNER')
            ->join('dia_dia', 'dxt_id_dia = dia_id', 'INNER');
        if ($where != null) {
            $this->db->where($where);
            $this->db->order_by('dia_id', 'asc');
        }
        //$this->db->group_by('dia_id');
        return $this->db->get()->result_array();
    }

    function get_horariosxturnos_group($where = null)
    {
        $this->db->select('*')
            ->from('plz_plaza')
            ->join('tur_turno', 'plz_id_tur = tur_id', 'INNER')
            ->join('dxt_detallexturno', 'dxt_id_tur = tur_id', "INNER")
            ->join('deh_detalle_horario', 'dxt_id_deh = deh_id', 'INNER')
            ->join('dia_dia', 'dxt_id_dia = dia_id', 'INNER');
        if ($where != null) {
            $this->db->where($where);
            $this->db->group_by('deh_id', 'asc');
            $this->db->order_by('dia_id');
        }
        //$this->db->group_by('dia_id');
        return $this->db->get()->result_array();
    }

    function familiares_solicitante($id_emp)
    {
        $query = "SELECT * FROM sle_solicitante_empleo 
                    INNER JOIN  fas_familiar_solicitante ON fas_id_sle = sle_id
                    INNER JOIN pat_parentesco ON pat_id = fas_id_pat
                    WHERE fas_estado=1 and sle_id =" . $id_emp;
        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }
    /**
     * Descripción:
     * se modifico el query para segun los datos que se le envie a la funcion agregara el where
     * @author      Marlon Olmedo
     * @version     23-05-2019
     **/
    function documentos_emp($empleado, $tde_id = "")
    {
        /*        $query = "SELECT * ,
                   (
                        SELECT mun_nombre
                        FROM mun_municipio
                        WHERE mun_id = dce_id_mun
                    ) AS munexp
                   FROM dce_documento_emp
                   INNER JOIN tde_tipo_documento ON tde_id=dce_id_tde
                   WHERE dce_id_emp=" . $empleado . " AND tde_id=".$tde_id;*/
        /*$query =*/
        $this->db->select("*,CONCAT(emp_nombre,' ',emp_apellido) as nombre,(SELECT mun_nombre
                        FROM mun_municipio
                        WHERE mun_id = dce_id_mun) AS munexp", false)
            ->from('dce_documento_emp')
            ->join('tde_tipo_documento', 'tde_id=dce_id_tde', 'inner')
            ->join('emp_empleado', 'dce_id_emp=emp_id', 'inner');

        if ($empleado != '' and $tde_id != '') { // si empleado y id_tipo_documento existen entonces
            $this->db->where('dce_id_emp', $empleado)
                ->where('tde_id', $tde_id);
        } elseif ($empleado != '') { //si solo empleado existe
            $this->db->where('dce_id_emp', $empleado);
        } elseif ($tde_id != '') { //si solo id_tipo_empleado existe
            $this->db->where('tde_id', $tde_id);
        }
        $this->db->order_by('emp_nombre,emp_apellido', 'ASC');
        /*        if ($tde_id!='') {
            $this->db->where('tde_id',$tde_id);
        } elseif ($empleado!='') {
            $this->db->where('dce_id_emp',$empleado);
        } elseif($empleado!='' and $tde_id!='') {
            $this->db->where('dce_id_emp',$empleado)
                     ->where('tde_id',$tde_id);
        }*/

        /*$resultado = $this->db->query($query)->result_array();*/
        $resultado = $this->db->get()->result_array();
        return $resultado;
    }
    // modificar el join dce
    function documentos_solicitante($empleado, $tde_id = null)
    {
        $this->db->select("*,CONCAT(sle_nombre,' ',sle_apellido) as nombre,(SELECT mun_nombre
                FROM mun_municipio
                WHERE mun_id = dcs_id_mun) AS munexp", false)
            ->from('dcs_documento_solicitante')
            ->join('tde_tipo_documento', 'tde_id=dcs_id_tde', 'inner')
            ->join('sle_solicitante_empleo', 'dcs_id_sle=sle_id', 'inner');

        if ($empleado != '' and $tde_id != '') { // si empleado y id_tipo_documento existen entonces
            $this->db->where('dcs_id_sle', $empleado)
                ->where('tde_id', $tde_id);
        } elseif ($empleado != '') { //si solo empleado existe
            $this->db->where('dcs_id_sle', $empleado);
        } elseif ($tde_id != '') { //si solo id_tipo_empleado existe
            $this->db->where('tde_id', $tde_id);
        }

        /*        if ($tde_id!='') {
            $this->db->where('tde_id',$tde_id);
        } elseif ($empleado!='') {
            $this->db->where('dce_id_emp',$empleado);
        } elseif($empleado!='' and $tde_id!='') {
            $this->db->where('dce_id_emp',$empleado)
                     ->where('tde_id',$tde_id);
        }*/

        /*$resultado = $this->db->query($query)->result_array();*/
        $resultado = $this->db->get()->result_array();
        return $resultado;
    }

    /**
     * 1 - Incluye horas bonificación
     */
    function ultimo_sueldo($empleado, $incluye_horas_bonificacion = null, $id_tipo_planilla = 1)
    {
        $salario = $this->gsatelite->get_parametro('INGRESO_SALARIO');
        $horas_extra_diurnas = $this->gsatelite->get_parametro('INGRESO_HED');
        $horas_extra_nocturnas = $this->gsatelite->get_parametro('INGRESO_HEN');
        $bonificaciones = $this->gsatelite->get_parametro('INGRESO_BONIFICACIONES');

        $ingresos = array();
        $ingresos[] = $salario;
        if ($incluye_horas_bonificacion != null) {
            $ingresos[] = $horas_extra_diurnas;
            $ingresos[] = $horas_extra_nocturnas;
            $ingresos[] = $bonificaciones;
        }

        //registro empleado
        $registro_emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $empleado));

        $this->db->select('ddi_id_pla AS planilla, pla_fecha_fin fecha, MONTH(pla_fecha_fin) mes')
            ->from('ddi_detalle_ingreso')
            ->join('pla_planilla', 'pla_id=ddi_id_pla');
        if ($id_tipo_planilla > 0) {
            $this->db->where('pla_id_tpl', $id_tipo_planilla);
        }
        $this->db->where("pla_estado", 3) // estado autorizada
            ->where('ddi_id_emp', $empleado)
            ->order_by('pla_fecha_fin', 'DESC')
            ->limit(1);
        if ($registro_emp[0]['emp_salario'] > 0) {
            $this->db->where('ddi_id_tig', $salario);
        }
        $consulta = $this->db->get();
        $datos = $consulta->row();
        $planilla = $datos->{'planilla'};
        $mes_planilla = $datos->{'mes'};



        $this->db->select('SUM(ddi_valor) AS sueldo')
            ->from('ddi_detalle_ingreso')
            ->join('pla_planilla', 'pla_id = ddi_id_pla')
            ->where('ddi_id_emp', $empleado);
        if ($id_tipo_planilla > 0) {
            $this->db->where('ddi_id_pla', $planilla);
        } else {
            $this->db->where('MONTH(pla_fecha_fin)', $mes_planilla);
        }
        if ($registro_emp[0]['emp_salario'] > 0) { //si tiene salario motrará el salario consignado, de lo contrario mostrará todos los ingresos
            $this->db->where('ddi_id_tig', $salario);
        }
        $consulta = $this->db->get();
        $datos = $consulta->row();
        $resultado = $datos->{'sueldo'};

        return $resultado;
    }

    /**
     * 1 - Solo AFP y Seguro Social
     */
    function descuentos_ley($empleado, $solo_afp_seguro = null, $id_tipo_planilla = 1)
    {
        $AFP = $this->gsatelite->get_parametro('DESCUENTO_AFP');
        $seguro = $this->gsatelite->get_parametro('DESCUENTO_ISS');
        $this->db->select('ddd_id_pla AS planilla, pla_fecha_fin fecha, MONTH(pla_fecha_fin) mes, YEAR(pla_fecha_fin) anio')
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'pla_id=ddd_id_pla');
        if ($id_tipo_planilla > 0) {
            $this->db->where('pla_id_tpl', $id_tipo_planilla);
        }
        $this->db->where("pla_estado", 3) // estado autorizada
            ->where('ddd_id_emp', $empleado)
            ->order_by('pla_fecha_fin', 'DESC')
            ->limit(1);
        if ($solo_afp_seguro) {
            $descuentos = array();
            $descuentos[] = $AFP;
            $descuentos[] = $seguro;
            $this->db->where_in('ddd_id_tdc', $descuentos);
        }
        $consulta = $this->db->get();
        $datos = $consulta->row();
        if (is_object($datos) && is_object($datos)) {
            $planilla = $datos->{'planilla'};
            $mes_planilla = $datos->{'mes'};
            $anio_planilla = $datos->{'anio'};
            $this->db->select('SUM(ddd_valor) as ddd_valor, ddd_fecha_mod, tdc_nombre, tdc_id, ban_nombre, dss_id_ban')
                ->from('ddd_detalle_descuento')
                ->join('pla_planilla', 'pla_id=ddd_id_pla')
                ->join('tdc_tipo_descuento', 'tdc_id=ddd_id_tdc')
                ->join('dss_descuento', 'ddd_id_dss=dss_id', 'left')
                ->join('ban_banco', 'dss_id_ban=ban_id', 'left')
                ->where('ddd_id_emp', $empleado);
            if ($id_tipo_planilla > 0) {
                $this->db->where('pla_id_tpl', $id_tipo_planilla);
            }
            $this->db->where('MONTH(pla_fecha_fin)', $mes_planilla);
            $this->db->where('YEAR(pla_fecha_fin)', $anio_planilla);
            $this->db->group_by('tdc_id');
            $this->db->order_by('tdc_id');
            if ($solo_afp_seguro) {
                $descuentos = array();
                $descuentos[] = $AFP;
                $descuentos[] = $seguro;
                $this->db->where_in('ddd_id_tdc', $descuentos);
            }
            $consulta = $this->db->get();
            $datos = $consulta->result_array();
            $resultado = $datos;
        } else {
            $dato = array();
            // NO EXISTE NINGUNA PLANILLA ANTERIOR, TEMPORALMENTE SE CALCULARA ISSS, AFP EN BASE AL SALARIO DE LA FICHA
            $emp_row = $this->gsatelite->get_registro('emp_empleado', array('emp_id' => $empleado));
            $desc_isss = $desc_afp = 0;
            if ($emp_row->emp_aplica_isss > 0) {
                $isss = $this->gsatelite->get_registro('tdc_tipo_descuento', array('tdc_id' => $seguro));
                $desc_isss = ($emp_row->emp_salario > $isss->tdc_maximo) ? ($isss->tdc_maximo * ($isss->tdc_porcentaje / 100)) : ($emp_row->emp_salario * ($isss->tdc_porcentaje / 100));
                $dato[] = array(
                    'tdc_id' => $isss->tdc_id,
                    'ddd_valor' => $desc_isss,
                    'tdc_nombre' => $isss->tdc_nombre
                );
            }
            if ($emp_row->emp_aplica_afp > 0) {
                $afps = $this->gsatelite->get_registro('tdc_tipo_descuento', array('tdc_id' => $AFP));
                $desc_afp = ($emp_row->emp_salario * ($afps->tdc_porcentaje / 100));
                $dato[] = array(
                    'tdc_id' => $afps->tdc_id,
                    'ddd_valor' => $desc_afp,
                    'tdc_nombre' => $afps->tdc_nombre
                );
            }
            if ($desc_isss > 0 || $desc_afp > 0) {
                //VALIDAR SI APLICA ISR CONTRA TABLA MENSUAL
                $isr_mens = $this->gsatelite->get_tabla('isr_isr', array('isr_id_tis' => 1));
                $valor = 0;
                $salario = $emp_row->emp_salario - ($desc_isss + $desc_afp);
                foreach ($isr_mens as $k => $value) {
                    if ($salario >= $value['isr_desde'] && $emp_row->emp_salario <= $value['isr_hasta']) {
                        $valor = $value['isr_cuota'] + (($emp_row->emp_salario - $value['isr_exceso']) * ($value['isr_porcentaje'] / 100));
                    }
                }
                if ($valor > 0) {
                    $isrs = $this->gsatelite->get_registro('tdc_tipo_descuento', array('tdc_id' => $this->tdc_isr));
                    $dato[] = array(
                        'tdc_id' => $isrs->tdc_id,
                        'ddd_valor' => $valor,
                        'tdc_nombre' => $isrs->tdc_nombre
                    );
                }
            }
            $resultado = $dato;
        }
        return $resultado;
    }



    function get_tipo_puesto()
    {
        $tipo_puesto = $this->db->select()
            ->from('tpt_tipo_puesto')
            ->get();
        return $tipo_puesto->result_array();
    }

    function get_select_tipo_planillas_actuales($where = null)
    {
        $tpls = $this->db->select('DISTINCT pla_id_tpl', false)
            ->from('pla_planilla')
            ->where('pla_id_tpl IS NOT NULL')
            ->where('pla_estado <> ', 3)
            ->get()->result_array();
        $tpin = (count($tpls) > 0) ? implode(',', array_column($tpls, 'pla_id_tpl')) : 0;
        $where_slct = array('tpl_id_emr' => $this->tank_auth->get_empresa_id(), "tpl_id IN ($tpin)" => null);
        $where_slct = ($where) ? array_merge($where_slct, $where) : $where_slct;
        $tpla = $this->gsatelite->get_dropdown('tpl_tipo_planilla', 'tpl_nombre', '', $where_slct, null, '', 'tpl_id', true);
        return str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $tpla);
    }

    function obtener_periodo_planilla($t_planilla, $tipo = null)
    {
        $this->db->select();
        $this->db->from('pla_planilla');
        $this->db->where('pla_estado <>', 1);
        $this->db->order_by('pla_fecha_inicio', 'DESC');
        if ($tipo != 1) {
            $this->db->where('pla_estado <>', 1);
        }

        $this->db->where('pla_id_tpl', $t_planilla);
        $periodos = $this->db->get();

        return $periodos->result_array();
    }

    function obtener_periodo_planilla2($t_planilla, $tipo = null)
    {
        $this->db->select();
        $this->db->from('pla_planilla');
        $this->db->where('pla_estado <>', 3);
        $this->db->order_by('pla_fecha_inicio', 'DESC');
        if ($tipo != 1) {
            $this->db->where('pla_estado <>', 1);
        }

        $this->db->where('pla_id_tpl', $t_planilla);
        $periodos = $this->db->get();

        return $periodos->result_array();
    }

    protected function calcular_ingresos($planilla, $empleado)
    {
        $fecha_inicio_pla = str_replace(' ', '', $planilla->pla_fecha_inicio);
        $fecha_fin_pla = str_replace(' ', '', $planilla->pla_fecha_fin);
        $datos_pla_liqui = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION'), true);
        $datos_pla_indem = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_INDEMNIZACION_VOLUNTARIA'), true);
        $query_ingresos = "SELECT inn_id, tig_id, tig_nombre, inn_valor, inn_cuota_pagada, inn_cuota, inn_id_psp, inn_id_acg, inn_id_ace FROM inn_ingreso
            INNER JOIN tig_tipo_ingreso ON inn_id_tig = tig_id LEFT JOIN hxe_hora_extraxempleado ON hxe_id = inn_id_hxe WHERE inn_estado = 1 AND inn_permanente = 0 
            AND inn_cuota_pagada < inn_cuota AND IF(hxe_estado IS NULL, 1, IF(hxe_estado = 1, 1, 0)) = 1 AND inn_id_tpl = $planilla->pla_id_tpl AND inn_id_emp = $empleado->emp_id ";
        if ($planilla->tpl_id != $datos_pla_liqui['ID_TIPO_PLANILLA_LIQ'] && $planilla->tpl_id != $datos_pla_indem['ID_TIPO_PLANILLA_INDEMNIZACION']) {
            $query_ingresos .= " /*AND inn_id_tig <> $this->tig_salario */
                    AND (
                        (inn_fecha_desde <= '$fecha_inicio_pla' AND inn_cuota > 1)
                            OR
                        (inn_fecha_desde >= '$fecha_inicio_pla' AND inn_fecha_desde <= '$fecha_fin_pla' AND inn_cuota = 1)
                            OR
                        (inn_fecha_desde >= '$fecha_inicio_pla' AND inn_fecha_desde <= '$fecha_fin_pla' and inn_cuota >1)
                    )
                    AND DATE_FORMAT(inn_fecha_desde,'%d') BETWEEN DATE_FORMAT('$fecha_inicio_pla','%d') AND DATE_FORMAT('$fecha_fin_pla','%d')";
        } //AND inn_id_tig <> $this->tig_salario -- SE ELIMINO PARA QUE PERMITA USAR EL MISMO INGRESO SALARIO
        $ingresos = $this->db->query($query_ingresos)->result();
        //los ingresamos en detalle
        foreach ($ingresos as $ing) {
            $this->add_ingreso_detalle($planilla, $empleado->emp_id, $ing->tig_id, $ing->inn_valor, $ing->inn_id, $planilla->tpl_frecuencia, '', $ing->inn_id_psp, $ing->inn_id_acg, $ing->inn_id_ace);
            $this->_debug("emp: $empleado->emp_id, tig: $ing->tig_id, valor: $ing->inn_valor");
        }
        //los ingresos permanentes en el periodo actual
        $ingresos_permanente = $this->db->select('inn_id, tig_id, tig_nombre, inn_valor, inn_id_psp, inn_id_acg, inn_id_ace, inn_cuota_pagada, inn_cuota');
        $this->db->from('inn_ingreso');
        $this->db->join($this->tipo_ingresos, 'inn_id_tig = tig_id', 'left');
        $this->db->join('hxe_hora_extraxempleado', 'hxe_id=inn_id_hxe', 'left');
        $this->db->where('inn_id_tig <>', $this->tig_salario);
        $this->db->where('inn_cuota_pagada = inn_cuota');
        $this->db->where('inn_id_tpl', $planilla->pla_id_tpl);
        $this->db->where('IF(hxe_estado IS NULL, 1, IF (hxe_estado = 1, 1, 0)) = 1');
        $this->db->where('(inn_fecha_desde <= "' . $planilla->pla_fecha_inicio . '" OR (inn_fecha_desde BETWEEN "' . $planilla->pla_fecha_inicio . '" AND "' . $planilla->pla_fecha_fin . '"))', null, true);
        //$this->db->where('inn_fecha_desde <=' , $planilla->pla_fecha_inicio);
        $this->db->where('inn_permanente', 1);
        $this->db->where('inn_estado', 1);
        $this->db->where('inn_id_emp', $empleado->emp_id);
        $this->db->get()->result();
        $ultima_query = $this->db->last_query();
        // $ingresos_permanente = $this->db->get($this->ingresos)->result();
        //los ingresamos en detalle
        foreach ($this->db->query($ultima_query)->result() as $ing_per) {
            $this->add_ingreso_detalle($planilla, $empleado->emp_id, $ing_per->tig_id, $ing_per->inn_valor, $ing_per->inn_id, $planilla->tpl_frecuencia, '', $ing_per->inn_id_psp, $ing_per->inn_id_acg, $ing_per->inn_id_ace);
            $this->_debug("emp: $empleado->emp_id, tig: $ing->tig_id, valor: $ing->inn_valor");
        }
    }



    protected function calcular_descuentos($planilla, $empleado)
    {
        $di_pla = formatear_fecha('d', $planilla->pla_fecha_inicio);
        $df_pla = formatear_fecha('d', $planilla->pla_fecha_fin);
        $datos_pla_liqui = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION'), true);
        $datos_pla_indem = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_INDEMNIZACION_VOLUNTARIA'), true);
        //descuentos del periodo actual
        $this->db->select('dss_descuento.dss_id,
                      tdc_tipo_descuento.tdc_id,
                      tdc_tipo_descuento.tdc_nombre,
                      dss_descuento.dss_valor,
                      dss_descuento.dss_cuota_pagada,
                      dss_descuento.dss_cuota
                      ');
        $this->db->join($this->tipo_descuentos, 'dss_descuento.dss_id_tdc = tdc_tipo_descuento.tdc_id');
        $this->db->where('dss_cuota_pagada < dss_cuota');
        $this->db->where('dss_id_emp', $empleado->emp_id);
        $this->db->where('dss_permanente', 0);
        $this->db->where('dss_estado', 1);
        $this->db->where('dss_id_tpl', $planilla->pla_id_tpl);
        if ($planilla->tpl_id != $datos_pla_liqui['ID_TIPO_PLANILLA_LIQ'] && $planilla->tpl_id != $datos_pla_indem['ID_TIPO_PLANILLA_INDEMNIZACION']) {
            $this->db->where("((dss_fecha_desde <= '$planilla->pla_fecha_inicio' AND dss_cuota > 1 AND DATE_FORMAT(dss_fecha_desde, '%d') BETWEEN '$di_pla' AND '$df_pla')
                OR (dss_fecha_desde >= '$planilla->pla_fecha_inicio' AND dss_fecha_desde <= '$planilla->pla_fecha_fin' AND dss_cuota >= 1))", NULL, FALSE);
        }
        $descuentos = $this->db->get($this->descuentos)->result();
        //los ingresamos al detalle
        foreach ($descuentos as $des) {
            $this->add_descuento_detalle($planilla->pla_id, $empleado->emp_id, $des->tdc_id, $des->dss_valor, 0, $des->dss_id, 0, $planilla->tpl_frecuencia);
            $this->_debug("emp: $empleado->emp_id, tig: $des->tdc_id, valor: $des->dss_valor");
        }
        //descuentos permanetes del periodo actual
        $this->db->select('
                      dss_descuento.dss_id,
                      tdc_tipo_descuento.tdc_id,
                      tdc_tipo_descuento.tdc_nombre,
                      dss_descuento.dss_valor,
                      dss_descuento.dss_cuota_pagada,
                      dss_descuento.dss_cuota
                      ');
        $this->db->join($this->tipo_descuentos, 'dss_descuento.dss_id_tdc = tdc_tipo_descuento.tdc_id');
        $this->db->where('dss_cuota_pagada = dss_cuota');
        //$this->db->where('dss_fecha_desde <=',$planilla->pla_fecha_inicio);
        $this->db->where("DATE_FORMAT(dss_fecha_desde,'%d') BETWEEN DATE_FORMAT('$planilla->pla_fecha_inicio','%d') AND DATE_FORMAT('$planilla->pla_fecha_fin','%d')", null, true);
        $this->db->where('dss_id_emp', $empleado->emp_id);
        $this->db->where('dss_permanente', 1);
        $this->db->where('dss_estado', 1);
        $this->db->where('dss_id_tpl', $planilla->pla_id_tpl);
        $descuentos_permanentes = $this->db->get($this->descuentos)->result();
        // print_r($this->db->last_query());die();
        //lon ingresamos al detalle
        foreach ($descuentos_permanentes as $des_per) {
            $this->add_descuento_detalle($planilla->pla_id, $empleado->emp_id, $des_per->tdc_id, $des_per->dss_valor, 0, $des_per->dss_id, 0, $planilla->tpl_frecuencia);
            $this->_debug("emp: $empleado->emp_id, tig: $des_per->tdc_id, valor: $des_per->dss_valor");
        }
    }

    protected function calcular_isr($planilla, $empleados, $validar_rentas){
        $tipo_documento_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        //obtener tablas de isr para la planilla
        $isr = $this->get_tabla_isr($planilla->pla_id, '0');

        $renta = 0;
        foreach ($empleados as $emp) {
            $aplica_renta = $this->gsatelite->get_campo('emp_empleado', 'emp_aplica_renta', array('emp_id' => $emp->emp_id));
            $tipo_renta_aplica = $this->gsatelite->get_campo('emp_empleado', 'emp_tipo_isr_aplica', array('emp_id' => $emp->emp_id));
            $empleado_aplica = ($aplica_renta > 0 && (($validar_rentas == 1 && intval($tipo_renta_aplica) == 0) || $validar_rentas == 0));
            // if($emp->emp_id==435) {  var_dump($aplica_renta, intval($tipo_renta_aplica), $empleado_aplica); die(); } 

            if ($empleado_aplica) {
                $salario = $this->calcular_agrupado($planilla, $emp->emp_id, $this->agrupador_isr);
                $sum_isr = $isr_ya = 0;
                if ($planilla->pla_id_tpl == $this->tpl_comision) {
                    $datos_mes = $this->calculo_suma_isr($planilla, $emp->emp_id, $this->tpl_comision);
                    $sum_isr = ($datos_mes['ingreso'] - ($datos_mes['isss'] + $datos_mes['afp']));
                    $isr_ya = $datos_mes['isr'];
                }
                $tpl_vacaciones = explode(',', $this->tpl_vacacion);
                if (in_array($planilla->pla_id_tpl, $tpl_vacaciones)) {
                    $datos_mes = $this->calculo_suma_isr($planilla, $emp->emp_id, $planilla->pla_id_tpl);
                    $sum_isr = ($datos_mes['ingreso'] - ($datos_mes['isss'] + $datos_mes['afp']));
                    $isr_ya = $datos_mes['isr'];
                }
                $salario = $salario + $sum_isr;
                // if($emp->emp_id==106) { var_dump($salario); die();} 

                foreach ($isr as $tramo) {
                    if ($salario >= $tramo->isr_desde && $salario <= $tramo->isr_hasta) {
                        $renta = $tramo->isr_cuota + ($salario - $tramo->isr_exceso) * $tramo->isr_porcentaje / 100;
                        $renta = $renta - $isr_ya;
                        $this->_debug("pla: $planilla->pla_id, emp: $emp->emp_id, base: $salario, renta: $renta");
                        $this->add_descuento_detalle($planilla->pla_id, $emp->emp_id, $this->tdc_isr, $renta, $salario, null, 0, $planilla->tpl_frecuencia);
                        // if($emp->emp_id==317) { print_r($salario); echo "<br />"; echo "$tramo->isr_cuota # $salario # $tramo->isr_exceso # $tramo->isr_porcentaje # $renta";  die();  } 
                    }
                }
            }
        }
    }

    protected function get_tabla_isr($planilla_id, $recalculo = "")
    {
        $this->db->select('isr_isr.*');
        $this->db->join('tpl_tipo_planilla', 'pla_planilla.pla_id_tpl = tpl_tipo_planilla.tpl_id');
        $this->db->join('txt_tipo_planillaxtipo_isr', 'txt_tipo_planillaxtipo_isr.txt_id_tpl = tpl_tipo_planilla.tpl_id');
        $this->db->join('pis_periodo_isr', 'txt_id=pis_id_txt AND DATE_FORMAT(pla_fecha_inicio,"%m")=pis_periodo');
        $this->db->join('tis_tipo_isr', 'txt_tipo_planillaxtipo_isr.txt_id_tis = tis_tipo_isr.tis_id');
        $this->db->join('isr_isr', 'isr_isr.isr_id_tis = tis_tipo_isr.tis_id');
        if ($recalculo != "") {
            $this->db->where('tis_recalculo', $recalculo);
        }
        return $this->db->get_where($this->planillas, array('pla_id' => $planilla_id))->result();
    }

    protected function calcular_isss($planilla, $empleado)
    {
        // if ($empleado->emp_id == 752) { var_dump($this->agrupador_isss); die(); }
        $salario = $this->calcular_agrupado($planilla, $empleado->emp_id, $this->agrupador_isss);
        $total_calculado_sum = $salario;
        $tdc_registro_isss = $this->db->select()->from('tdc_tipo_descuento')->where('tdc_id', $this->tdc_isss)->get()->row_array();
        $frecuencia = $this->db->select('tpl_cantidad')->from('tpl_tipo_planilla')->join('pla_planilla', 'pla_id_tpl=tpl_id')->where('pla_id', $planilla->pla_id)->get()->result();
        $total_calculado = $salario;
        $se_aplico_recalculo_isss = 0;
        $observacion_des_isss = null;
        //preguntar si la planilla no es mensual
        if ($frecuencia[0]->tpl_cantidad > 1) {
            //Preguntar si es la ultima planilla correspondiente al mes, si $query_periodos es empty es que es la primera planilla del mes
            $query_periodos = $this->db->select("COUNT(DISTINCT ddd_id_pla) n_planillas, ROUND(SUM(IFNULL(ddd_ingreso_afecto,0)),2) afecto,
                                            ROUND(SUM(IFNULL(ddd_ingreso_afecto_total,0)),2) total_calculado", false)
                ->from('ddd_detalle_descuento')
                ->join('pla_planilla', 'pla_id=ddd_id_pla')
                ->where('ddd_id_emp', $empleado->emp_id)
                ->where('pla_id_tpl', $planilla->pla_id_tpl)
                ->where('pla_id !=', $planilla->pla_id) //no tomar en cuenta la que se esta ejecutando
                //agregar el wehere de las fechas que las planillas consultas sean previas a la actual
                ->where("DATE(pla_fecha_fin)<=", formatear_fecha('Y-m-d', $planilla->pla_fecha_fin))
                ->where('DATE_FORMAT(pla_fecha_fin,"%Y%m")', formatear_fecha('Ym', $planilla->pla_fecha_fin))
                ->where('ddd_id_tdc', $this->tdc_isss)
                ->group_by('pla_id_tpl')
                ->get()->row_array();

            //definir el máximo por cada planilla
            $maximo_por_frecuencia = round($tdc_registro_isss['tdc_maximo'], 2);
            //SE COMENTO PORQUE UNICAMENTE EN MAYA SE USABA QUE SI ES EL MAXIMO DESCONTARA LA MITAD EN CADA QUINCENA
            if ($planilla->pla_id_tpl == $this->tpl_quincena) {
                $maximo_por_frecuencia = round(($tdc_registro_isss['tdc_maximo'] / $frecuencia[0]->tpl_cantidad), 2);
            }
            //preguntar si se esta en el ultimo periodo del mes y verificar los recalculos de los descuentos anteriores
            $sobrepaso = false;
            if (count($query_periodos) > 0) {
                // CALCULAR EL SALARIO NORMAL Y LUEGO TOMAR SOLO EL FALTANTE
                $salario_ =  ($salario > $maximo_por_frecuencia) ? $maximo_por_frecuencia : $salario;
                //preguntar si no se ha llegado al limite del máximo
                   $afectado_acumulado = $salario + $query_periodos['afecto'];
                if ($afectado_acumulado > $tdc_registro_isss['tdc_maximo']) {
                    $salario_ = $tdc_registro_isss['tdc_maximo'] - $query_periodos['afecto'];
                    $sobrepaso = true;
                }
                if (!$sobrepaso) {
                    //preguntar si se ya llegado al limite del ultimo periodo para aplicar recálculo
                    if ((count($query_periodos) + 1) == $frecuencia[0]->tpl_cantidad) {
                        $total_total = $total_calculado_sum + $query_periodos['total_calculado'];
                        $total_total = ($total_total > $tdc_registro_isss['tdc_maximo']) ? $tdc_registro_isss['tdc_maximo'] : $total_total;
                        $afectuar_calculo = $total_total - $query_periodos['afecto'];
                        $salario_ = $afectuar_calculo;
                        //aplico récalculo
                        $dif_recalculo = ($salario_ != $total_calculado_sum) ? 1 : 0;
                        $dif_maximo = $tdc_registro_isss['total_calculado'] - $query_periodos['afecto'];
                        $dif_maximo = ($dif_maximo > $maximo_por_frecuencia) ? $maximo_por_frecuencia : $dif_maximo;
                        $se_aplico_recalculo_isss = ($dif_recalculo > 0) ? 1 : 0;
                        $observacion_des_isss = ($dif_recalculo > 0) ? "Recalculo: $ " . $dif_maximo : null;
                        $total_calculado = $total_calculado_sum;
                    }
                }
                $salario =  ($salario > $tdc_registro_isss['tdc_maximo']) ? $tdc_registro_isss['tdc_maximo'] : $salario;
            } else {
                //$salario =  ($salario > $tdc_registro_isss['tdc_maximo']) ? $tdc_registro_isss['tdc_maximo'] : $salario;
                $salario =  ($salario > $maximo_por_frecuencia) ? $maximo_por_frecuencia : $salario;
            }
        } else {

            $salario =  ($salario > $tdc_registro_isss['tdc_maximo']) ? $tdc_registro_isss['tdc_maximo'] : $salario;
        }
        //DESCUENTO CALCULADO PARA ESTA PLANILLA
        $des_asegurado = (($salario * $tdc_registro_isss['tdc_porcentaje']) / 100);
        $desc_patronal = (($salario * $tdc_registro_isss['tdc_porcentaje_patronal']) / 100);
        // BUSCAR SI YA SE DESCONTO EN OTRA PLANILLA AUTORIZADA Y SACAR DIFERENCIA
        $ya_descontado = $this->get_isss_mes_act($planilla->pla_fecha_fin, $empleado->emp_id);
        $descuento_max_emp = (($tdc_registro_isss['tdc_maximo'] * $tdc_registro_isss['tdc_porcentaje']) / 100);
        $descuento_max_ptr = (($tdc_registro_isss['tdc_maximo'] * $tdc_registro_isss['tdc_porcentaje_patronal']) / 100);
        $des_pendiente_emp = (($descuento_max_emp - $ya_descontado['empleado']) < 0) ? 0 : ($descuento_max_emp - $ya_descontado['empleado']);
        $des_pendiente_ptr = (($descuento_max_ptr - $ya_descontado['patrono']) < 0) ? 0 : ($descuento_max_ptr - $ya_descontado['patrono']);
        $asegurado = ($des_pendiente_emp > $des_asegurado) ? $des_asegurado : $des_pendiente_emp;
        $patrono  =  ($des_pendiente_ptr > $desc_patronal) ? $desc_patronal : $des_pendiente_ptr;
        $this->_debug("emp: $empleado->emp_id, base: $salario, asegurado: $asegurado, patrono: $patrono");
        $this->add_descuento_detalle($planilla->pla_id, $empleado->emp_id, $this->tdc_isss, $asegurado, $salario, null, $patrono, $planilla->tpl_frecuencia, $total_calculado, $se_aplico_recalculo_isss, $observacion_des_isss);
    }

    function get_isss_mes_act($pla_fecha, $emp_id)
    {
        $fecha = formatear_fecha('Ym', $pla_fecha);
        $where = array("pla_estado" => 3, "ddd_id_tdc" => $this->tdc_isss, "ddd_id_emp" => $emp_id, "DATE_FORMAT(pla_fecha_inicio, '%Y%m') = '$fecha'" => null);
        $this->db->select('SUM(ddd_valor) AS empleado, SUM(ddd_valor_patronal) AS patrono', false)
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'ddd_id_pla = pla_id', 'INNER')
            ->where($where);
        $resultado = $this->db->get()->result_array();
        return $resultado[0];
    }

    protected function calcular_isr_10p($planilla, $empleado)
    {
        $salario = $this->calcular_agrupado($planilla, $empleado->emp_id, $this->agrupador_isr_10p);
        $tdc_maximo = $this->db->select('tdc_maximo')->from('tdc_tipo_descuento')->where('tdc_id', $this->tdc_isr_10p)->get()->result_array();
        $frecuencia = $this->db->select('tpl_cantidad')->from('tpl_tipo_planilla')->join('pla_planilla', 'pla_id_tpl=tpl_id')->where('pla_id', $planilla->pla_id)->get()->result();
        /* if($salario*$frecuencia[0]->tpl_cantidad > $tdc_maximo[0]['tdc_maximo']){
          $salario=$tdc_maximo[0]['tdc_maximo']/$frecuencia[0]->tpl_cantidad;
          } */
        $isr_10p = $this->db->get_where($this->tipo_descuentos, array('tdc_id' => $this->tdc_isr_10p), 1)->row();
        $asegurado = $salario * $isr_10p->tdc_porcentaje / 100;
        //$patrono = $salario * $isr_10p->tdc_porcentaje_patronal /100;
        //$this->_debug("emp: $empleado->emp_id, base: $salario, asegurado: $asegurado, patrono: $patrono");
        $this->add_descuento_detalle($planilla->pla_id, $empleado->emp_id, $this->tdc_isr_10p, $asegurado, $salario, null, 0, $planilla->tpl_frecuencia);
    }


    function calculo_suma_isr($planilla, $emp_id, $tipo_pla)
    {
        $totales = array('ingreso' => 0, 'isss' => 0, 'afp' => 0, 'isr' => 0);
        $fecha = formatear_fecha('Ym', $planilla->pla_fecha_fin);
        $where = array("pla_estado" => 3, "pla_id_tpl <> " => $tipo_pla, "txe_id_emp" => $emp_id, "DATE_FORMAT(pla_fecha_fin, '%Y%m') = '$fecha'" => null);
        $this->db->select("pla_id, pla_id_tpl, pla_codigo, pla_estado,
            IFNULL( (SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso WHERE ddi_id_emp = txe_id_emp AND ddi_id_pla = pla_id AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag = $this->agrupador_isr) ), 0) AS ingresos,
            IFNULL( (SELECT SUM(ddd_valor) FROM ddd_detalle_descuento WHERE ddd_id_emp = txe_id_emp AND ddd_id_pla = pla_id AND ddd_id_tdc = $this->tdc_isss), 0) AS desc_isss,
            IFNULL( (SELECT SUM(ddd_valor) FROM ddd_detalle_descuento WHERE ddd_id_emp = txe_id_emp AND ddd_id_pla = pla_id AND ddd_id_tdc = $this->tdc_afp), 0) AS desc_afp,
            IFNULL( (SELECT SUM(ddd_valor) FROM ddd_detalle_descuento WHERE ddd_id_emp = txe_id_emp AND ddd_id_pla = pla_id AND ddd_id_tdc = $this->tdc_isr), 0) AS desc_isr,
            IFNULL( (SELECT SUM(ddd_valor) FROM ddd_detalle_descuento WHERE ddd_id_emp = txe_id_emp AND ddd_id_pla = pla_id AND ddd_id_tdc IN (SELECT deg_id_tdc FROM deg_detalle_agrupador WHERE deg_id_tag = $this->agrupador_isr AND deg_id_tdc NOT IN ($this->tdc_isss, $this->tdc_afp))), 0) AS desc_vac
            ", false)
            ->from('pla_planilla')
            ->join('txe_tipo_planillaxempleado', 'txe_id_tpl =  pla_id_tpl', 'INNER')
            ->where($where);
        $resultado = $this->db->get()->result_array();
        if (count($resultado) > 0) {
            $inn = $iss = $afp = $isr = $vac = 0;
            foreach ($resultado as $key => $value) {
                if ($value['pla_estado'] == 3) {
                    $inn += $value['ingresos'];
                    $iss += $value['desc_isss'];
                    $afp += $value['desc_afp'];
                    $isr += $value['desc_isr'];
                    $vac += $value['desc_vac'];
                }
            }
            $ingresos = $inn - $vac;
            $totales = array('ingreso' => $ingresos, 'isss' => $iss, 'afp' => $afp, 'isr' => $isr);
        }
        // if($emp_id==106) { var_dump($totales); die();} 
        return $totales;
    }


    //TODO: pasaar a protected
    function calcular_agrupado($planilla, $emp_id, $agrupador_id)
    {
        //DELETE:
        $this->get_tipos();
        /* Se agregan condiciones para que no se tomen en cuenta en la agrupacion ya que si son dos proyectos diferentes los campos de presupuesto, a general, a espesif.. quedarian invalidados */
        $query_string = "SELECT deg_detalle_agrupador.deg_id_tig as tig,
            deg_detalle_agrupador.deg_id_tdc as tdc,
            deg_detalle_agrupador.deg_signo,
            deg_detalle_agrupador.deg_aplicacion,
            deg_detalle_agrupador.deg_valor,
            (SELECT SUM(inn_ingreso.inn_valor) FROM inn_ingreso
                WHERE inn_ingreso.inn_id_psp IS NULL 
                AND inn_ingreso.inn_id_acg IS NULL
                AND inn_ingreso.inn_id_ace IS NULL
                AND inn_ingreso.inn_id_tig = deg_detalle_agrupador.deg_id_tig
                AND inn_ingreso.inn_id_emp = $emp_id 
                AND inn_ingreso.inn_estado = 1
                AND deg_detalle_agrupador.deg_id_tag =  $agrupador_id 
                AND inn_id_tpl = $planilla->pla_id_tpl
                AND ( 
                        ( 
                            (   
                                (inn_ingreso.inn_fecha_desde >= '$planilla->pla_fecha_inicio' OR inn_ingreso.inn_fecha_desde <= '$planilla->pla_fecha_fin') 
                                AND inn_ingreso.inn_fecha_desde <= '$planilla->pla_fecha_fin'
                            )
                            AND inn_ingreso.inn_cuota_pagada < inn_ingreso.inn_cuota
                            AND inn_ingreso.inn_permanente = 0
                            AND DATE_FORMAT(inn_ingreso.inn_fecha_desde,'%d') BETWEEN DATE_FORMAT('$planilla->pla_fecha_inicio','%d') AND DATE_FORMAT('$planilla->pla_fecha_fin','%d')
                        )
                        OR
                        (
                            DATE_FORMAT(inn_ingreso.inn_fecha_desde, '%Y-%m') <= DATE_FORMAT('$planilla->pla_fecha_inicio', '%Y-%m') AND inn_ingreso.inn_permanente = 1
                            /*AND DATE_FORMAT(inn_ingreso.inn_fecha_desde,'%d') BETWEEN DATE_FORMAT('$planilla->pla_fecha_inicio','%d') AND DATE_FORMAT('$planilla->pla_fecha_fin','%d')*/
                        )
                    )
                GROUP BY inn_ingreso.inn_id_emp
            ) AS ingresos,
            (SELECT SUM(dss_descuento.dss_valor) FROM dss_descuento
                WHERE dss_descuento.dss_id_tdc = deg_detalle_agrupador.deg_id_tdc
                AND dss_descuento.dss_id_emp = $emp_id
                AND dss_descuento.dss_estado = 1 
                AND deg_detalle_agrupador.deg_id_tag = $agrupador_id
                AND dss_id_tpl = $planilla->pla_id_tpl
                AND (
                    ( 
                        dss_descuento.dss_fecha_desde >= '$planilla->pla_fecha_inicio' 
                        AND dss_descuento.dss_fecha_desde <= '$planilla->pla_fecha_fin'
                        AND dss_descuento.dss_cuota_pagada < dss_descuento.dss_cuota
                        AND dss_descuento.dss_permanente = 0
                    )
                    OR
                    ( 
                        DATE_FORMAT(dss_descuento.dss_fecha_desde,'%Y-%m') <= DATE_FORMAT('$planilla->pla_fecha_inicio', '%Y-%m') AND dss_descuento.dss_permanente = 1
                    )
                )
                GROUP BY dss_descuento.dss_id_emp
            ) As descuentos
            FROM deg_detalle_agrupador
            WHERE deg_detalle_agrupador.deg_id_tag = $agrupador_id
            GROUP BY deg_detalle_agrupador.deg_id_tig, deg_detalle_agrupador.deg_id_tdc
        ";


        $resultado = 0.0;
        $salario_empleado = $this->db->get_where($this->empleados, array('emp_id' => $emp_id), 1)->row()->emp_salario;
        $where_historico['pps_id_emp'] = $emp_id;
        $where_historico["DATE('" . $planilla->pla_fecha_pago . "') BETWEEN DATE(pps_fecha_desde) AND IFNULL(pps_fecha_hasta,CURDATE())"] = null;
        $nivelacion_historica = $this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', $where_historico);
        /*
        -- por el momento no aplica retroactividad
        if ($nivelacion_historica) {
            $salario_empleado = $nivelacion_historica[0]['pps_salario'];
        }*/
        $salario = $salario_empleado / $planilla->tpl_cantidad;
        $id_pla = $planilla->pla_id;
        $fecha_ini = $planilla->pla_fecha_inicio;
        $fecha_fin = $planilla->pla_fecha_fin;

        $salarioxdia = $this->get_informacion_empleado($id_pla, $fecha_ini, $fecha_fin, $emp_id);
        if ($salarioxdia > 0) {
            $salario = $salarioxdia / $planilla->tpl_cantidad;
        }
        // if ($emp_id == 794 && $agrupador_id == 6) { var_dump($salario); die(); }
        // //preguntar si el empleado posee incapacidad para dicho periodo
        $where_inca = array(
            "inc_id_emp" => $emp_id,
            "inc_estado" => 1,
            "(inc_id_pla = $planilla->pla_id OR (DATE(inc_fecha_inicio) < '$planilla->pla_fecha_inicio' AND DATE(inc_fecha_fin) >= '$planilla->pla_fecha_inicio'))" => null
        );
        $this->db->order_by('inc_id', 'DESC');
        $this->db->join('inn_ingreso', 'inn_id = inc_id_inn', 'left');
        $pregunta_incapacidad = $this->gsatelite->get_tabla('inc_incapacidad', $where_inca);
        if (count($pregunta_incapacidad) > 0) {
            $dias_pla = 0;
            foreach ($pregunta_incapacidad as $ki => $vi) {
                if (date("Y-m-d", strtotime($vi['inc_fecha_inicio'])) >= date("Y-m-d", strtotime($planilla->pla_fecha_inicio))) {
                    // INCAPACIDAD COMENZO DENTRO DEL PERIODO DE LA PLANILLA 
                    $dias_desps = $this->gsatelite->get_intervalo_dias($vi['inc_fecha_fin'], $planilla->pla_fecha_fin);
                    $dias_perio = $this->gsatelite->get_intervalo_dias($vi['inc_fecha_inicio'], $planilla->pla_fecha_fin);
                    $es_febrero = (formatear_fecha('n', $planilla->pla_fecha_fin) == 2) ? true : false; ///////////////////PDTE CASO FEBRERO/////////////////////////////////////////////
                    $dias_pla_f = $this->gsatelite->get_intervalo_dias($planilla->pla_fecha_inicio, formatear_fecha('Y-m-t', $planilla->pla_fecha_fin)); /////////PDTE CASO FEBRERO//////
                    if (FALSE && $es_febrero) {
                        if ($dias_desps < 0) {
                            //termina en marzo
                            $dias_pla += (intval($dias_perio) + 1);
                        } else {
                            // $dias_pla += intval($vi['inc_dias']);
                        }
                    } else {
                        if ($dias_desps < 0) {
                            $dias_pla += (intval($dias_perio) + 1);
                        } else {
                            $dias_pla += intval($vi['inc_dias']);
                        }
                    }
                } else {
                    $dias_restantes = $this->gsatelite->get_intervalo_dias($planilla->pla_fecha_inicio, $vi['inc_fecha_fin']);
                    if ($dias_restantes >= 0) {
                        if (($dias_restantes + 1) > $planilla->tpl_frecuencia) {
                            $dias_pla += $planilla->tpl_frecuencia;
                        } else {
                            $dias_pla += $dias_restantes + 1;
                        }
                    }
                }
            }
            $dias_pla = ($dias_pla > $planilla->tpl_frecuencia) ? $planilla->tpl_frecuencia : $dias_pla;
            $desc_diario = ($salario_empleado / $planilla->tpl_cantidad) / $planilla->tpl_frecuencia;
            $descu_total = $desc_diario * $dias_pla;
            $salario = $salario - $descu_total;
        }
        // if ($emp_id == 794 && $agrupador_id == 6) { var_dump($salario); die(); }
        // if ($emp_id == 777) { var_dump($salario); die(); }
        //preguntar si el tipo de planilla tiene configurado el ingreso base de salario
        $ingresos_base_salario = $this->db->get_where($this->ingxplanilla, array('itp_id_tpl' => $planilla->pla_id_tpl, 'itp_id_tpl' => $planilla->pla_id_tpl, 'itp_id_tig' => $this->tig_salario))->result();
        $tig_ingreso_aguinaldo = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');
        $tig_ingreso_vacacion = $this->gsatelite->get_parametro('ID_TIG_VACACION');
        $tig_ingreso_prima_vacacion = $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION');
        $tdc_descuento_vacacion = $this->gsatelite->get_parametro('ID_TDC_VACACION');

        // print_r($ingresos_base_salario); die();
        $this->_debug("Salario: $salario");
        $k = 0;
        $query_result = $this->db->query($query_string)->result();
        // if ($emp_id == 752 && $agrupador_id == 1) { var_dump($this->db->last_query()); die(); }
        foreach ($query_result as $row) {
            $pre_valor = 0;
            $this->_debug("emp: $emp_id, tig: $row->tig, tdc: $row->tdc, ing: $row->ingresos, des: $row->descuentos");
            //obtenemos valor
            if ($row->tig > 0) {
                //ingresos
                switch ($row->tig) {
                        //Salario
                    case $this->tig_salario: //en caso sea salario
                        if ($ingresos_base_salario) { //SI ESTA CONFIGURADO EL SALARIO COMO INGRESO BASE PROCEDER CON EL CÁLCULO
                            //consultar si es el agrupador de sueldo 
                            if ($agrupador_id == $this->agrupador_salario) {
                                if ($salario > 0 || ($salario >= 0 && count($pregunta_incapacidad) > 0)) {
                                    $pre_valor = $salario; //Si el empleado tiene salario base definido
                                } else {
                                    $pre_valor = $row->ingresos;
                                }
                            } else { //si no es el agrupador de salario consultar mediante el registro de ingreso ya registrado
                                $this->db->where(array(
                                    'ddi_id_emp' => $emp_id,
                                    'ddi_id_tig' => $this->tig_salario,
                                    'ddi_id_pla' => $planilla->pla_id
                                ));
                                // $ddi = $this->db->get($this->detalle_ingresos, 1)->row();
                                // $pre_valor = ($ddi) ? $ddi->ddi_valor : 0;
                                $pre_valor = $this->gsatelite->get_suma($this->detalle_ingresos, 'ddi_valor');
                            }
                        }
                        break;
                    case $tig_ingreso_aguinaldo:
                        $this->db->where(array(
                            'ddi_id_emp' => $emp_id,
                            'ddi_id_tig' => $tig_ingreso_aguinaldo,
                            'ddi_id_pla' => $planilla->pla_id
                        ));
                        $ddi = $this->db->get($this->detalle_ingresos, 1)->row();
                        $pre_valor = ($ddi) ? $ddi->ddi_valor : 0;
                        break;
                    case $tig_ingreso_vacacion:
                        $this->db->where(array(
                            'ddi_id_emp' => $emp_id,
                            'ddi_id_tig' => $tig_ingreso_vacacion,
                            'ddi_id_pla' => $planilla->pla_id
                        ));
                        $ddi = $this->db->get($this->detalle_ingresos, 1)->row();
                        $pre_valor = ($ddi) ? $ddi->ddi_valor : 0;
                        break;
                    case $tig_ingreso_prima_vacacion:
                        $this->db->where(array(
                            'ddi_id_emp' => $emp_id,
                            'ddi_id_tig' => $tig_ingreso_prima_vacacion,
                            'ddi_id_pla' => $planilla->pla_id
                        ));
                        $ddi = $this->db->get($this->detalle_ingresos, 1)->row();
                        $pre_valor = ($ddi) ? $ddi->ddi_valor : 0;
                        //print_r($pre_valor); die();
                        break;
                    default:
                        $pre_valor = $row->ingresos;
                }
                // if($emp_id==23 and $agrupador_id==1 and $k==4) {  echo $pre_valor; die(' hi'); }
                //$this->_debug("tig: $row->tig, pre_valor: $pre_valor");
            } else if ($row->tdc > 0) {
                //descuentos

                switch ($row->tdc) {
                        //fondo de penciones AFP (debe de haberse calculado)
                    case $this->tdc_afp:
                        $this->db->where(array(
                            'ddd_id_emp' => $emp_id,
                            'ddd_id_tdc' => $this->tdc_afp,
                            'ddd_id_pla' => $planilla->pla_id
                        ));
                        $ddd = $this->db->get($this->detalle_descuentos, 1)->row();
                        $pre_valor = ($ddd) ? $ddd->ddd_valor : 0;
                        /* print_r($this->db->last_query());
                          if($agrupador_id == $this->agrupador_isr){
                          exit();
                          } */
                        $this->_debug("Calcular AFP: $pre_valor");
                        break;

                        //isss
                    case $this->tdc_isss:
                        $this->db->where(array(
                            'ddd_id_emp' => $emp_id,
                            'ddd_id_tdc' => $this->tdc_isss,
                            'ddd_id_pla' => $planilla->pla_id
                        ));
                        $ddd = $this->db->get($this->detalle_descuentos, 1)->row();
                        // if ($emp_id == 116 && $agrupador_id == 3) { var_dump($this->db->last_query()); die(); }
                        $pre_valor = ($ddd) ? $ddd->ddd_valor : 0;
                        $this->_debug("Calcular ISSS: $pre_valor");
                        break;

                        //vacacion
                    case $tdc_descuento_vacacion:
                        $this->db->where(array(
                            'ddd_id_emp' => $emp_id,
                            'ddd_id_tdc' => $tdc_descuento_vacacion,
                            'ddd_id_pla' => $planilla->pla_id
                        ));
                        $ddd = $this->db->get($this->detalle_descuentos, 1)->row();
                        $pre_valor = ($ddd) ? $ddd->ddd_valor : 0;
                        //print_r($ddd); die();
                        $this->_debug("Calcular vaca: $pre_valor");
                        break;

                    default:
                        $tipo = $this->tipos_descuento[$row->tdc];

                        switch ($tipo->tdc_tipo) {
                                //Porcentaje
                            case 2:
                                $pre_valor = $pre_valor;
                                break;

                                //Min_MAx
                            case 3:
                                $pre_valor = $pre_valor;
                                break;

                                //Min_MAx + procentaje
                            case 4:
                                $pre_valor = $pre_valor;
                                break;

                                //Cuota
                            case 5:
                                $pre_valor = $tipo->tdc_cuota;
                                break;

                                //En base a un agrupador
                            case 6:
                                $pre_valor = $pre_valor;
                                //$pre_valor = $this->calcular_agrupado($emp_id, $tipo->tdc_agrupador);
                                break;

                                //Monto u otro
                            case 1:
                            default:
                                $pre_valor = $row->descuentos;
                        }
                }

                //$this->_debug("tdc: $row->tdc, pre_valor: $pre_valor");

            } else {
                $pre_valor = 0;
            }


            //aplicamos regla
            switch ($row->deg_aplicacion) {
                    //Porcentaje  
                case 'P':
                    $valor = $pre_valor * ($row->deg_valor / 100);
                    break;

                    //Valor REGLAS NO DEFINIDAS
                case 'V':
                    $valor = $pre_valor;
                    break;

                default:
            }

            //operamos
            switch ($row->deg_signo) {
                case '+':
                    $resultado += $valor;
                    break;

                case '-':
                    $resultado -= $valor;
                    break;

                default:
            }
            $k++;
        }

        return $resultado;
    }

    protected function detalle_agrupador($emp_id, $agrupados)
    {
    }

    public function generar_planilla($data, $planillas = null)
    {
        $this->_debug('Planilla Ini');
        $id_ingreso_vacacion       = $this->gsatelite->get_parametro('ID_TIG_VACACION');
        $id_descuento_vacacion     = $this->gsatelite->get_parametro('ID_TDC_VACACION');
        $id_ingreso_vacacion       = (trim($id_ingreso_vacacion) > 0) ? $id_ingreso_vacacion : 0;
        $id_ingreso_prima_vacacion = $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION');
        $id_ingreso_prima_vacacion = (trim($id_ingreso_prima_vacacion) > 0) ? $id_ingreso_prima_vacacion : 0;
        $id_ingreso_aguinaldo      = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');
        $id_ingreso_aguinaldo      = (trim($id_ingreso_aguinaldo) > 0) ? $id_ingreso_aguinaldo : 0;
        $id_ingreso_indemnizacion  = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION');
        $id_ingreso_indemnizacion  = (trim($id_ingreso_indemnizacion) > 0) ? $id_ingreso_indemnizacion : 0;
        // si tipo planilla es de liquidacion o indemnizacion voluntaria
        $datos_pla_liqui = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION'), true);
        $datos_pla_indem = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_INDEMNIZACION_VOLUNTARIA'), true);
        //metodo de cálculo vacación 1 = aniversario, 2= a demanda (prorratear) 3= periodos tipo pinsal
        $metodo_vacacion = $this->gsatelite->get_parametro('METODO_CALCULO_VACACION');
        // modificar el parametro de la función para simular un retiro y siempre cálcule vacación si el metodo es diferente de 1
        //si envia cero condicionará que tenga el tiempo laborar configurado.
        $marcar_como_retiro = ($metodo_vacacion == 1) ? 0 : 1;
        //eliminar todos los detalles de ingresos o descuentos que ya se hayan generado para dicha planilla
        if ($data['id_planilla']) {
            $this->gsatelite->borrado_general('ddi_detalle_ingreso', array('ddi_id_pla' => $data['id_planilla']));
            $this->gsatelite->borrado_general('ddd_detalle_descuento', array('ddd_id_pla' => $data['id_planilla']));
        }
        $this->db->join($this->tipo_planillas, 'pla_id_tpl = tpl_id');
        $planilla = $this->db->get_where($this->planillas, array('pla_id' => $data['id_planilla']), 1)->row();
        $tipo_documento_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $this->_debug("Planilla: $planilla->pla_id");
        //Pre cargamos datos
        $this->get_tipos();
        $tpl = $this->db->get_where($this->tipo_planillas, array('tpl_id' => $data['tpl_id']), 1)->row();
        $descuentos_base = $this->db->join('tdc_tipo_descuento', 'tdc_id=dtp_id_tdc')->order_by('tdc_orden_calculo', 'asc')->get_where($this->desxplanilla, array('dtp_id_tpl' => $data['tpl_id']))->result();
        $ingresos_base = $this->db->get_where($this->ingxplanilla, array('itp_id_tpl' => $data['tpl_id']))->result();
        //echo $this->db->last_query(); die();
        //obtenemos empleados        
        if ($data['tpl_id'] == $datos_pla_liqui['ID_TIPO_PLANILLA_LIQ']) {
            $empleados = $this->db->select("emp_empleado.*, pto_id, pto_salario_promediado")
                ->from('emp_empleado')
                ->join('plz_plaza', 'plz_id=emp_id_plz', 'left')
                ->join('pto_puesto', 'pto_id=plz_id_pto', 'left')
                ->join('rte_retiro_empleado', 'rte_id_emp = emp_id')
                ->join('lqe_liquidacion_empleado', 'lqe_id_rte = rte_id')
                ->where('emp_estado', 0)
                ->where('lqe_id_pla', $data['id_planilla'])->group_by('emp_id')->get()->result();
        } elseif ($data['tpl_id'] == $datos_pla_indem['ID_TIPO_PLANILLA_INDEMNIZACION']) {
            $empleados = $this->db->select("emp_empleado.*, pto_id, pto_salario_promediado")
                ->from('emp_empleado')
                ->join('plz_plaza', 'plz_id=emp_id_plz', 'left')
                ->join('pto_puesto', 'pto_id=plz_id_pto', 'left')
                ->join('inv_indemnizacion_voluntaria', 'inv_id_emp = emp_id')
                ->join('lqe_liquidacion_empleado', 'lqe_id_inv = inv_id')
                ->where('emp_estado', 1)
                ->where('lqe_id_pla', $data['id_planilla'])
                ->group_by('emp_id')->get()->result();
        } else {
            $empleados = $this->db->select("emp_empleado.*, txe_tipo_planillaxempleado.*, pto_id, pto_salario_promediado")
                ->from('emp_empleado')
                ->join('txe_tipo_planillaxempleado', 'txe_id_emp = emp_id AND txe_estado > 0')
                ->join('plz_plaza', 'plz_id=emp_id_plz', 'left') //
                ->join('pto_puesto', 'pto_id=plz_id_pto', 'left') //
                ->where('emp_estado', 1)
                ->where('emp_salario >=', 0)
                ->where('emp_fecha_contrato <=', $planilla->pla_fecha_fin)
                ->where('txe_id_tpl', $data['tpl_id'])->group_by('emp_id')->get()->result();
        }
        $this->_debug('Ingresos INI');
        //calcular los ingresos de cada empleado
        $empleados_valid = $empleados;
        foreach ($empleados as $emp) {
            //los ingresos base de la planilla
            $aplica_vacacion = array();
            $aplica_calculo_vacacion = false;
            $aplica_calculo_aguinaldo = false;
            $aplica_calculo_indemnizacion = false;
            $aplica_vacacion[0] = 0; //aplica vacacion
            $aplica_vacacion[1] = 0; //aplica prima vacacion
            $porcentaje_vacacion[0] = 100; //% aplica vacacion
            $porcentaje_vacacion[1] = 100; //% aplica prima vacacion
            foreach ($ingresos_base as $ing) {
                if ($ing->itp_id_tig == $this->tig_salario) {
                    //preguntar si existe el ingreso de salario.
                    $porcentaje_salario = ($ing->itp_porcentaje > 0) ? $ing->itp_porcentaje : 100;
                    $valor = $this->calcular_agrupado($planilla, $emp->emp_id, $this->agrupador_salario);
                    // if ($emp->emp_id == 595) { var_dump($valor); die(); }
                    $comentario_salario = ($porcentaje_salario != 100) ? "Pagado al " . round($porcentaje_salario, 2) . "%" : null;
                    $dias = $planilla->tpl_frecuencia;

                    //VALIDACION PARA LOS DIAS DE LOS NUEVOS EMPLEADOS
                    $this->db->select('emp_id, emp_fecha_contrato, emp_fecha_retiro')->from('emp_empleado')
                        ->where('emp_fecha_contrato >=', $planilla->pla_fecha_inicio)
                        ->where('emp_fecha_contrato <=', $planilla->pla_fecha_fin)
                        ->where('emp_id', $emp->emp_id);
                    $empleado_nuevo = $this->db->get()->row_array();
                    if (count($empleado_nuevo) > 0 && $empleado_nuevo['emp_id'] > 0 && $empleado_nuevo['emp_fecha_contrato'] != "") {
                        //EMPLEADO SE CONTRATO EN MEDIO DEL PERIODO DE PLANILLA
                        $this->db->join('pla_planilla', 'tpl_id = pla_id_tpl', 'inner');
                        $tipo_pla = $this->gsatelite->get_registro('tpl_tipo_planilla', array('pla_id' => $planilla->pla_id));
                        $dia_inicio = formatear_fecha('j', $planilla->pla_fecha_inicio);
                        $dia_contrato = formatear_fecha('j', $empleado_nuevo['emp_fecha_contrato']);
                        if ($tipo_pla->tpl_cantidad > 1) {
                            if (formatear_fecha('j', $planilla->pla_fecha_fin) < formatear_fecha('t', $planilla->pla_fecha_fin)) {
                                $dia_fin = formatear_fecha('j', $planilla->pla_fecha_fin);
                            } else {
                                $dia_fin = formatear_fecha('t', $planilla->pla_fecha_fin);
                            }
                        } else {
                            $dia_fin = formatear_fecha('t', $planilla->pla_fecha_fin);
                        }
                        $dias_trabajados = ($dia_fin - $dia_contrato) + 1;
                        if (formatear_fecha('n', $planilla->pla_fecha_fin) == 2) {
                            // CASO ESPECIAL DE FEBRERO POR TENER MENOS DIAS SI ENTRO EL DIA 1 DE LA PLANILLA SON LOS 15/30 DIAS, SINO LA CANTIDAD DE DIAS REALES
                            $caso_feb = ($this->gsatelite->get_intervalo_dias($planilla->pla_fecha_inicio, $planilla->pla_fecha_fin) + 1);
                        } else {
                            $caso_feb = $tipo_pla->tpl_frecuencia;
                        }
                        $dias_trabajados = ($dias_trabajados > $tipo_pla->tpl_frecuencia) ? $tipo_pla->tpl_frecuencia : $dias_trabajados;
                        $dias_trabajados = ($caso_feb == $dias_trabajados) ? $tipo_pla->tpl_frecuencia : $dias_trabajados;
                        $dias = $dias_trabajados;
                    }
                    ////////////////////////////////////////////////////////
                    $where_inca = array(
                        "inc_id_emp" => $emp->emp_id,
                        "inc_estado" => 1,
                        "(inc_id_pla = $planilla->pla_id OR (DATE(inc_fecha_inicio) < '$planilla->pla_fecha_inicio' AND DATE(inc_fecha_fin) >= '$planilla->pla_fecha_inicio'))" => null
                    );
                    $this->db->order_by('inc_id', 'DESC');
                    $this->db->join('inn_ingreso', 'inn_id = inc_id_inn', 'left');
                    $tiene_inca = $this->gsatelite->get_tabla('inc_incapacidad', $where_inca);

                    if (count($tiene_inca) > 0) {
                        $dias_pla = 0;
                        foreach ($tiene_inca as $ki => $vi) {
                            if (date("Y-m-d", strtotime($vi['inc_fecha_inicio'])) >= date("Y-m-d", strtotime($planilla->pla_fecha_inicio))) {
                                $dias_desps = $this->gsatelite->get_intervalo_dias($vi['inc_fecha_fin'], $planilla->pla_fecha_fin);
                                $dias_perio = $this->gsatelite->get_intervalo_dias($vi['inc_fecha_inicio'], $planilla->pla_fecha_fin);
                                if ($dias_desps < 0) {
                                    $dias_pla += (intval($dias_perio) + 1);
                                } else {
                                    $dias_pla += intval($vi['inc_dias']);
                                }
                            } else {
                                $dias_restantes = $this->gsatelite->get_intervalo_dias($planilla->pla_fecha_inicio, $vi['inc_fecha_fin']);
                                if ($dias_restantes >= 0) {
                                    if (($dias_restantes + 1) > $planilla->tpl_frecuencia) {
                                        $dias_pla += $planilla->tpl_frecuencia;
                                    } else {
                                        $dias_pla += $dias_restantes + 1;
                                    }
                                }
                            }
                        }
                        $dias_pla = ($dias_pla < 0) ? 0 : $dias_pla;
                        $dias_pla = ($dias_pla > $planilla->tpl_frecuencia) ? $planilla->tpl_frecuencia : $dias_pla;
                        $dias = ($dias - $dias_pla);
                        if (!($dias > 0)) {
                            $comentario_salario .= " (INCAPACIDAD VIGENTE)";
                        }
                    }
                    $this->add_ingreso_detalle(
                        $planilla,
                        $emp->emp_id,
                        $ing->itp_id_tig,
                        ($valor * ($porcentaje_salario / 100)),
                        null,
                        $dias,
                        $comentario_salario
                    );
                    // Agregamos los ingresos que provienen de un proyecto, presupuesto...
                    $ingresos_proy = $this->gsatelite->get_tabla('inn_ingreso', array('inn_id_tig' => $this->tig_salario, 'inn_id_emp' => $emp->emp_id, 'inn_id_acg IS NOT NULL' => null, 'inn_id_psp IS NOT NULL' => null, 'inn_id_ace IS NOT NULL' => null));
                    while (list($clave, $valor) = each($ingresos_proy)) {
                        $arreglo_add = array(
                            "ddi_id_pla" => $planilla->pla_id,
                            "ddi_id_inn" => $valor['inn_id'],
                            "ddi_id_psp" => $valor['inn_id_psp'],
                            "ddi_id_acg" => $valor['inn_id_acg'],
                            "ddi_id_ace" => $valor['inn_id_ace'],
                            "ddi_id_emp" => $valor['inn_id_emp'],
                            "ddi_id_emp" => $emp->emp_id,
                            "ddi_id_tig" => $valor['inn_id_tig'],
                            "ddi_valor"  => $valor['inn_valor'],
                            "ddi_dias"   => $planilla->tpl_frecuencia,
                            "ddi_observacion" => $valor['inn_observacion'],
                            "ddi_usu_mod"     => $this->tank_auth->get_user_id(),
                            "ddi_fecha_mod"   => date('Y-m-d H:m:s')
                        );
                        $this->gsatelite->ingresar('ddi_detalle_ingreso', $arreglo_add);
                    }
                }
                // if ($emp->emp_id == 408) {var_dump($ing->itp_porcentaje); die(); }
                if ($ing->itp_id_tig == $id_ingreso_vacacion) { //preguntar si existe el ingreso de vacacion
                    $aplica_calculo_vacacion = true;
                    $aplica_vacacion[0] = 1;
                    $porcentaje_vacacion[0] = ($ing->itp_porcentaje > 0) ? $ing->itp_porcentaje : 100;
                }
                if ($ing->itp_id_tig == $id_ingreso_prima_vacacion) { //preguntar si existe el ingreso de vacacion (prima 30%)
                    $aplica_calculo_vacacion = true;
                    $aplica_vacacion[1] = 1;
                    $porcentaje_vacacion[1] = ($ing->itp_porcentaje > 0) ? $ing->itp_porcentaje : 100;
                }
                if ($ing->itp_id_tig == $id_ingreso_aguinaldo) { //preguntar si existe el ingreso de aguinaldo
                    $aplica_calculo_aguinaldo = true;
                    $porcentaje_agui = ($ing->itp_porcentaje > 0) ? $ing->itp_porcentaje : 100;
                }
                if ($ing->itp_id_tig == $id_ingreso_indemnizacion) { //preguntar si existe el ingreso de indemnización
                    $aplica_calculo_indemnizacion = true;
                    $porcentaje_indem = ($ing->itp_porcentaje > 0) ? $ing->itp_porcentaje : 100;
                }
            }
            if ($aplica_calculo_vacacion) {
                //si aplica vacación procesar al empleado para vacación.
                //marcar como que fuese retiro para que prorretee los dias trabajados                
                $this->calculo_vacacion_empleado($emp, $planilla, $aplica_vacacion, $marcar_como_retiro, $porcentaje_vacacion);
            }
            if ($aplica_calculo_aguinaldo) {
                //si aplica aguinaldo procesar al empleado para aguinaldo
                $this->calculo_aguinaldo_empleado($emp, $planilla, false, $porcentaje_agui);
            }
            if ($aplica_calculo_indemnizacion) {
                //si aplica indemnizaicon procesar al empleado para el cálculo respectivo
                $this->calculo_indemnizacion_empleado($emp, $planilla, $porcentaje_indem);
            }
            //los ingresos extra de cada empleado
            $this->calcular_ingresos($planilla, $emp);
            //los descuentos de cada empleado
            $this->calcular_descuentos($planilla, $emp);
            // echo $this->db->last_query(); die();
        }
        $this->_debug('Descuentos INI');
        //LOS DESCUENTOS SON UN ARRAY DE OBJETOS BUSCAREMOS SI VIENEN AMBAS RENTAS PARA VALIDAR EL CASO CCSA
        $tipo_descuentos = array_map(function($e) {
            return is_object($e) ? $e->dtp_id_tdc : $e['dtp_id_tdc'];
        }, $descuentos_base);
        $trae_ambas_rentas = (in_array($this->tdc_isr, $tipo_descuentos) && in_array($this->tdc_isr_10p, $tipo_descuentos)) ? 1 : 0;

        $se_aplico_afp = false;
        if ($data['tpl_id'] != $datos_pla_liqui['ID_TIPO_PLANILLA_LIQ'] && $data['tpl_id'] != $datos_pla_indem['ID_TIPO_PLANILLA_INDEMNIZACION']) {
            foreach ($descuentos_base as $row) {
                if ($row->dtp_id_tdc == $id_descuento_vacacion) {
                    //preguntar si existe descuento de vacación
                    $aplica_vacacion[0] = 1;
                    $porcentaje_vacacion[0] = ($row->dtp_porcentaje > 0) ? $row->dtp_porcentaje : 100;
                    $this->calculo_vacacion_empleado($emp, $planilla, $aplica_vacacion, $marcar_como_retiro, $porcentaje_vacacion, true);
                }
                //si calculo de ISSS
                if ($row->dtp_id_tdc == $this->tdc_isss) {
                    $this->_debug("ISSS Inicio\n");
                    $ag_isss_salario = $this->db->select()
                        ->from('deg_detalle_agrupador')
                        ->where('deg_id_tig', $this->tig_salario)
                        ->where('deg_id_tag', $this->agrupador_isss)
                        ->get()->result_array();
                    //$ag_isss_salario = (count($ag_isss_salario) > 0)? 1:0;
                    foreach ($empleados as $emp) {
                        // if ($emp->emp_id == 752) { var_dump(trim($emp->emp_seguro) != '' && $emp->emp_aplica_isss == 1); die(); }
                        if (trim($emp->emp_seguro) != '' and $emp->emp_aplica_isss == 1) { //si no esta vacio el número de seguro y aplica seguro isss hacer el respectivo descuento.
                            $this->calcular_isss($planilla, $emp);
                        }
                    }
                    $this->_debug("ISSS Fin");
                }
                //si calculo de AFP
                $id_agrupador_afp = $this->gsatelite->get_parametro('ID_AGRUPADOR_AFP');
                $id_tipo_descuento_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
                $aplica_afp = 0;
                $tipo_planilla = $planilla->pla_id_tpl;
                $agrupadores = $this->agrupadores_planilla($tipo_planilla);
                foreach ($agrupadores as $agrupador) {
                    if ($agrupador['tag_id'] == $id_agrupador_afp) {
                        $aplica_afp = 1;
                        // $salario = $this->calcular_agrupado($planilla,$emp, $this->agrupador_isss);
                        $datos = $this->ingresos_agrupador($agrupador['tag_id']);
                        $ingresos_agrupador = $descuentos_agrupador = array(0);
                        foreach ($datos as $dato) {
                            if ($dato['deg_id_tig'] > 0) {
                                $ingresos_agrupador[] = $dato['deg_id_tig'];
                            }
                            if ($dato['deg_id_tdc'] > 0) {
                                $descuentos_agrupador[] = $dato['deg_id_tdc'];
                            }
                        }
                    }
                }
                if ($aplica_afp == 1 and $se_aplico_afp == false) {
                    $empleados = $empleados_valid;
                    //insercion en detalle dss
                    foreach ($empleados as $empleado) {
                        if (trim($empleado->emp_afp) != '' and $empleado->emp_aplica_afp == 1) {
                            //si no esta vacio el número de afp y aplica afp hacer el respectivo descuento.
                            $detalle_afp = $this->valor_calculo_afp($planilla->pla_id, $empleado->emp_id, $ingresos_agrupador, $descuentos_agrupador);
                            if (count($detalle_afp) > 0) {
                                //preguntar si aplica descuento afp
                                // $this->add_descuento_detalle($planilla->pla_id, $detalle_afp[0]['emp_id'], $id_tipo_descuento_afp, $detalle_afp[0]['asegurado'], $detalle_afp[0]['emp_salario'] / $tpl->tpl_cantidad, null, $detalle_afp[0]['patrono'], $tpl->tpl_frecuencia);
                                $this->add_descuento_detalle($planilla->pla_id, $detalle_afp[0]['emp_id'], $id_tipo_descuento_afp, $detalle_afp[0]['asegurado'], $detalle_afp[0]['monto_afecto'], null, $detalle_afp[0]['patrono'], $tpl->tpl_frecuencia);
                            }
                            #$this->_debug("emp_id: $row_afp->emp_id, base: $row_afp->emp_salario, asegurado: $row_afp->asegurado, patrono: $row_afp->patrono");
                        }
                    }
                    $se_aplico_afp = true;
                }
                /* SI EN LA MISMA PLANILLA VIENE ISR Y RENTA 10 DEPENDERA DEL SELECT CUAL TOMAR*/
                if ($row->dtp_id_tdc == $this->tdc_isr_10p) {
                    $this->_debug("ISR Inicio\n");
                    foreach ($empleados as $emp) {
                        $aplica_renta = $this->gsatelite->get_campo('emp_empleado', 'emp_aplica_renta', array('emp_id' => $emp->emp_id));
                        $tipo_renta_aplica = $this->gsatelite->get_campo('emp_empleado', 'emp_tipo_isr_aplica', array('emp_id' => $emp->emp_id));
                        $empleado_aplica = ($aplica_renta > 0 && (($trae_ambas_rentas == 1 && intval($tipo_renta_aplica) == 1) || $trae_ambas_rentas == 0));

                        if ($empleado_aplica ) {
                            //preguntar si el empleado aplica, para proceder al descuento de renta
                            $this->calcular_isr_10p($planilla, $emp);
                        }
                    }
                    //$this->calcular_isr_10p($planilla, $emp);
                    $this->_debug("ISR Fin");
                }
                //si calculo de ISR
                /* PARA CASO DE RECALCULOS EN PLANILLAS QUINCENALES O SEMANALES DEBERA TENER ACTIVAS AMBAS TABLAS (ej. Quincenal -> Quincenal & Recalculo_junio) */
                /* SI EN LA MISMA PLANILLA VIENE ISR Y RENTA 10 DEPENDERA DEL SELECT CUAL TOMAR*/
                if ($row->dtp_id_tdc == $this->tdc_isr) {
                    // var_dump($planillas);die();
                    if ($planillas == 1) {
                        // var_dump($data, $planilla, $empleados);die();
                        $this->generar_recalculo($data, $planilla, $empleados, $trae_ambas_rentas);
                    } else {
                        $this->_debug("ISR Inicio\n");
                        $this->calcular_isr($planilla, $empleados, $trae_ambas_rentas);
                        $this->_debug("ISR Fin");
                    }
                }
            }
        }
        //cambiamos estado de planilla
        $this->db->update($this->planillas, array('pla_estado' => 2), array('pla_id' => $planilla->pla_id));
        return $planilla->pla_id;
    }

    function print_planilla($planilla_id, $usuario = null, $tipo = null, $sin_header = null)
    {

        $registro_planilla = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $planilla_id));
        //planilla
        $this->db->join($this->tipo_planillas, 'pla_id_tpl = tpl_id');
        $planilla = $this->db->get_where($this->planillas, array('pla_id' => $planilla_id), 1)->row();

        $this->db->select('
                  emp_empleado.emp_id,
                  emp_empleado.emp_codigo,
                  emp_empleado.emp_nombre,
                  emp_empleado.emp_apellido,
                  emp_empleado.emp_salario,
                  emp_empleado.emp_metodo_pago,
                  plz_plaza.plz_nombre,
                  (Select
                    Sum(ddi_detalle_ingreso.ddi_valor)
                    From
                    ddi_detalle_ingreso
                    Where
                    ddi_detalle_ingreso.ddi_id_emp = emp_empleado.emp_id And
                    ddi_detalle_ingreso.ddi_id_pla = ' . $planilla->pla_id . '
                    Group By
                    ddi_detalle_ingreso.ddi_id_emp, ddi_detalle_ingreso.ddi_id_pla ) As ingresos,
                (Select
                    Sum(ddd_detalle_descuento.ddd_valor)
                    From
                    ddd_detalle_descuento
                    Where
                    ddd_detalle_descuento.ddd_id_emp = emp_empleado.emp_id And
                    ddd_detalle_descuento.ddd_id_pla = ' . $planilla->pla_id . '
                    Group By
                    ddd_detalle_descuento.ddd_id_emp, ddd_detalle_descuento.ddd_id_pla ) As
                descuentos
                ');
        $this->db->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id');
        $this->db->join('txe_tipo_planillaxempleado', 'txe_id_emp=emp_id');
        $this->db->where('emp_salario > ', 0);
        $this->db->where('emp_estado', 1);
        $this->db->where('txe_id_tpl', $planilla->pla_id_tpl);
        $this->db->group_by('emp_empleado.emp_id');
        $empleados = $this->db->get($this->empleados)->result();
        //id del tipo de ingreso para indemnización
        $id_ting_indemnizacion = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION');
        $id_ting_aguinaldo = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');
        //Detalle de la planilla
        $detalle = '';
        $i = 1;
        $renta_10p = $renta = $isss = $afp = $des_otros = $des_total = $cancelar = $horas_extras_diu = $horas_extras_noc = $total_vacaciones = $total_comision = 0;
        $total_aguinaldo = 0;
        $total_indemnizacion = 0;
        $x = 1; //bandera que controla la clase de los tr
        foreach ($empleados as $empleado) {

            /* $renta=0;

              $afp=0;
              $isss=0;
              $des_otros=0;
              $des_total=0;
              //totales
              $cancelar=0; */
            $horas_extras_diu = 0;
            $horas_extras_noc = 0;
            /* $total_vacaciones=0; */

            $descuentos = array();

            $valor_descuentos = 0;
            foreach ($this->get_descuentos_pla_emp($planilla, $empleado) as $row) {
                $descuentos[$row->tdc_id] = $row;
                $valor_descuentos += $row->{'ddd_valor'};
            }

            $ingresos = array();
            $valor_ingresos = 0;

            foreach ($this->get_ingresos_pla_emp($planilla, $empleado) as $row) {
                #print_r($this->db->last_query()); exit;
                $ingresos[$row->tig_id] = $row;


                $valor_ingresos += $row->{'ddi_valor'};
            }

            //Planilla Salarios
            //ingresos




            $hed = $ingresos[$this->tig_hed]->ddi_valor;
            $hen = $ingresos[$this->tig_hen]->ddi_valor;

            //$salario = $empleado->emp_salario / $planilla->tpl_cantidad;
            //$valor_ingresos=$valor_ingresos+$salario;

            $salario = $ingresos[$this->tig_salario]->ddi_valor;
            $valor_ingresos = $valor_ingresos;

            $otros_ingresos = $valor_ingresos - ($salario) - $hed - $hen;

            $this->db->select('SUM(hxe_num_hora) cantidad')
                ->from('ddi_detalle_ingreso')
                ->join('inn_ingreso', 'inn_id=ddi_id_inn')
                ->join('hxe_hora_extraxempleado', 'hxe_id=inn_id_hxe')
                ->where('ddi_id_emp', $empleado->{'emp_id'})
                ->where('ddi_id_pla', $planilla->{'pla_id'})
                ->where('hxe_id_the', 1)/* Diurnas */
                ->where('hxe_estado', 1)
                // ->group_by('hxe_id')
            ;
            $consulta = $this->db->get();
            $dato = $consulta->row();

            $numero_horas_diurnas = $dato->{'cantidad'};

            $this->db->select('SUM(hxe_num_hora) cantidad')
                ->from('ddi_detalle_ingreso')
                ->join('inn_ingreso', 'inn_id=ddi_id_inn')
                ->join('hxe_hora_extraxempleado', 'hxe_id=inn_id_hxe')
                ->where('ddi_id_emp', $empleado->{'emp_id'})
                ->where('ddi_id_pla', $planilla->{'pla_id'})
                ->where('hxe_id_the', 2)/* Nocturnas */
                ->where('hxe_estado', 1)
                //   ->group_by('hxe_id')
            ;
            $consulta = $this->db->get();
            $dato = $consulta->row();

            $numero_horas_nocturnas = $dato->{'cantidad'};

            $bonificaciones = $ingresos[$this->tig_bonificacion]->ddi_valor;
            $viaticos = $ingresos[$this->tig_viatico]->ddi_valor;
            $vacaciones = $ingresos[$this->tig_vacacion]->ddi_valor;
            $otros_descuentos = $valor_descuentos - ($descuentos[$this->tdc_isr]->ddd_valor + $descuentos[$this->tdc_isr_10p]->ddd_valor + $descuentos[$this->tdc_afp]->ddd_valor + $descuentos[$this->tdc_isss]->ddd_valor);


            $total = $valor_ingresos - $valor_descuentos;


            //descuentos
            $renta += $descuentos[$this->tdc_isr]->ddd_valor;

            $afp += $descuentos[$this->tdc_afp]->ddd_valor;
            $isss += $descuentos[$this->tdc_isss]->ddd_valor;
            $des_otros += $otros_descuentos;
            $des_total += $valor_descuentos;
            //totales
            $cancelar += $total;
            $horas_extras_diu += $hed;
            $horas_extras_noc += $hen;
            $total_vacaciones += $vacaciones;

            //planilla indemnizacion
            $indemnizacion = $ingresos[$id_ting_indemnizacion]->ddi_valor;
            $total_indemnizacion += $indemnizacion;

            //planilla comisiones (renta es la misma)
            $comisiones = $ingresos[$this->tig_comision]->ddi_valor;
            $total_comision += $comisiones;

            $renta_10p += $descuentos[$this->tdc_isr_10p]->ddd_valor;

            //planilla aguinaldo (renta es la misma)
            $aguinaldo = $ingresos[$id_ting_aguinaldo]->ddi_valor;
            $total_aguinaldo += $aguinaldo;
            //$renta1=number_format($descuentos[$this->tdc_isr]->ddd_valor, 2);
            if ($renta > 0) {
                $renta_tlt = $renta;
            } else if ($renta <= 0) {
                $renta_tlt = $renta_10p;
            }

            if ($x) {
                $valor = "impar";
                $x = 0;
            } else {
                $valor = "par";
                $x = 1;
            }

            $des_isr = number_format($descuentos[$this->tdc_isr]->ddd_valor, 2);
            if ($des_isr > 0) {
                $renta_final = $des_isr;
            } else if ($des_isr <= 0) {
                $renta_final = number_format($descuentos[$this->tdc_isr_10p]->ddd_valor, 2);
            }

            if ($tipo == 'salario') {
                $detalle .= "
                            <tr class=\"" . $valor . "\">
                            <!-- <td width=\"2%\">$i</td> -->";
                if ($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA') != "1") {
                    $detalle .= "<td>$empleado->emp_codigo</td>";
                }
                $detalle .= "<td>$empleado->emp_nombre $empleado->emp_apellido</td>
                            <!--<td>$empleado->pto_nombre</td>-->

                            <td align=\"right\">$" . number_format($salario, 2) . "</td>
                            <!-- <td></td> -->
                            <td>$" . number_format($horas_extras_diu, 2) . "</td>
                            <td>" . $numero_horas_diurnas . "</td>
                            <td>$" . number_format($horas_extras_noc, 2) . "</td>
                            <td>" . $numero_horas_nocturnas . "</td>
                            <td>$" . number_format($vacaciones, 2) . "</td>";
                if ($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA') == "1") {
                    $detalle .= "<td align=\"right\">$" . number_format($bonificaciones, 2) . "</td>";
                    $detalle .= "<td align=\"right\">$" . number_format($viaticos, 2) . "</td>";
                    //      $detalle.="<td align=\"right\">$" . number_format($otros_ingresos, 2) . "</td>"; 
                } else {
                    $detalle .= "<td align=\"right\">$" . number_format($otros_ingresos, 2) . "</td>";
                }

                $detalle .= "<td align=\"right\">$" . number_format($valor_ingresos, 2) . "</td>
                         <td align=\"right\">$" . $renta_final . "</td>
                         <td align=\"right\">$" . number_format($descuentos[$this->tdc_afp]->ddd_valor, 2) . "</td>
                         <td align=\"right\">$" . number_format($descuentos[$this->tdc_isss]->ddd_valor, 2) . "</td>
                         <td align=\"right\">$" . number_format($otros_descuentos, 2) . "</td>
                         <td align=\"right\">$" . number_format($valor_descuentos, 2) . "</td>

                         <td align=\"right\" width=\"6.3%\" >$" . number_format($total, 2) . "</td>
                         </tr>
                         ";
            } elseif ($tipo == 'comision') {
                $detalle .= "
                        <tr class=\"" . $valor . "\">
                        <!-- <td width=\"2%\">$i</td> -->
                        <td>$empleado->emp_codigo</td>
                        <td>$empleado->emp_nombre $empleado->emp_apellido</td>
                        <!-- <td>$empleado->pto_nombre</td> -->

                        <td align=\"right\">$" . number_format($comisiones, 2) . "</td>

                        <td align=\"right\">$" . number_format($renta_final, 2) . "</td>
                        <td align=\"right\">$" . number_format($total, 2) . "</td>
                        </tr>
                        ";
            } elseif ($tipo == 'aguinaldo') {
                $detalle .= "
                        <tr class=\"" . $valor . "\">
                        <!-- <td width=\"2%\">$i</td> -->
                        <td>$empleado->emp_codigo</td>
                        <td>$empleado->emp_nombre $empleado->emp_apellido</td>
                        <!--<td>$empleado->pto_nombre</td>-->

                        <td align=\"right\">$" . number_format($aguinaldo, 2) . "</td>

                        <td align=\"right\">$" . number_format($renta_final, 2) . "</td>
                        <td align=\"right\">$" . number_format($total_aguinaldo, 2) . "</td>
                        </tr>
                        ";
            } elseif ($tipo == 'indemnizacion') {
                $detalle .= "
                       <tr class=\"" . $valor . "\">
                       <!-- <td width=\"2%\">$i</td> -->
                       <td>$empleado->emp_codigo</td>
                       <td>$empleado->emp_nombre $empleado->emp_apellido</td>
                       <!-- <td>$empleado->pto_nombre</td> -->

                       <td align=\"right\">$" . number_format($indemnizacion, 2) . "</td>

                       <!-- <td align=\"right\">$" . number_format($renta_final, 2) . "</td> -->
                       <td align=\"right\">$" . number_format($total, 2) . "</td>
                       </tr>
                       ";
            }

            $i++;
            $total_aguinaldo = 0;
        }

        //Totales
        if ($tipo == 'comision') {
            $detalle .= '
                <tr class="encabezado" >
                <td colspan="2">Total planilla</td>
                <td align="right">$' . number_format($total_comision, 2) . '</td>
                <td align="right">$' . number_format($renta_tlt, 2) . '</td>

                <td align="right" >$' . number_format($cancelar, 2) . '</td>
                </tr>';
        } elseif ($tipo == "aguinaldo") {

            $detalle .= '
                <tr class="encabezado" >
                <td colspan="2">Total planilla</td>
                <td align="right">$' . number_format($total_aguinaldo, 2) . '</td>
                <td align="right">$' . number_format($renta_tlt, 2) . '</td>

                <td align="right" >$' . number_format($cancelar, 2) . '</td>
                </tr>';
        } elseif ($tipo == "indemnizacion") {
            $detalle .= '
                <tr class="encabezado" >
                <td colspan="2">Total planilla</td>
                <td align="right">$' . number_format($total_indemnizacion, 2) . '</td>
                <!-- <td align="right">$' . number_format($renta_tlt, 2) . '</td> -->

                <td align="right" >$' . number_format($cancelar, 2) . '</td>
                </tr>';
        } elseif ($tipo == 'salario') {
            $col = ($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA') == "1") ? 6 : 6;
            $detalle .= '
                <tr class="encabezado" >
                <td colspan="' . $col . '">Total planilla</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td align="right">$' . number_format($renta_tlt, 2) . '</td>
                <td align="right">$' . number_format($afp, 2) . '</td>
                <td align="right">$' . number_format($isss, 2) . '</td>
                <td align="right">$' . number_format($des_otros, 2) . '</td>
                <td align="right">$' . number_format($des_total, 2) . '</td>

                <td align="right" width="6.3%">$' . number_format($cancelar, 2) . '</td>
                </tr>';
        }
        $data['tipo'] = $tipo;
        $data['detalle_planilla'] = $detalle;
        $data['titulo'] = "Planilla";
        $data['registro_planilla'] = $registro_planilla;
        $data['usuario'] = $usuario;
        $html = "";
        if ($sin_header == null) {
            $html .= $thml = $this->load->view('personal/planilla/header_simple', array('titulo' => 'Planilla'), true);
        }
        $html .= $this->load->view('personal/planilla/pla_print', $data, true);
        return $html;
    }

    // Melbin Cruz
    // Planilla por plazas    
    function print_planilla_emi_plazas($planilla_id, $usuario = null, $tipo = null, $sin_header = null, $genera_archivo_txt = false, $consolidado = null)
    {

        //preguntar si hay planillas migradas
        //preguntar por las planillas migradas para omitir esta operación. mediante un parametro
        $planilla_migradas = $this->gsatelite->get_parametro('PLANILLAS_MIGRADAS');
        $id_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $ids_migra = array();
        if ($planilla_migradas != "") {
            $ids_migra = explode(',', $planilla_migradas);
        }


        $registro_planilla = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $planilla_id));
        //planilla
        $this->db->join($this->tipo_planillas, 'pla_id_tpl = tpl_id');
        $planilla = $this->db->get_where($this->planillas, array('pla_id' => $planilla_id), 1)->row();

        $this->db->select('
                  emp_empleado.emp_id,
                  emp_empleado.emp_codigo,
                  emp_empleado.emp_nombre,
                  emp_empleado.emp_apellido,
                  emp_empleado.emp_salario,
                  emp_empleado.emp_fecha_contrato,
                  emp_empleado.emp_numero_cuenta,
                  plz_plaza.plz_nombre,
                  dce_valor,
                  are_nombre,
                  are_id,
                  (Select
                    Sum(ddi_detalle_ingreso.ddi_valor)
                    From
                    ddi_detalle_ingreso
                    Where
                    ddi_detalle_ingreso.ddi_id_emp = emp_empleado.emp_id And
                    ddi_detalle_ingreso.ddi_id_pla = ' . $planilla->pla_id . '
                    Group By
                    ddi_detalle_ingreso.ddi_id_emp, ddi_detalle_ingreso.ddi_id_pla ) As ingresos,
                (Select
                    Sum(ddd_detalle_descuento.ddd_valor)
                    From
                    ddd_detalle_descuento
                    Where
                    ddd_detalle_descuento.ddd_id_emp = emp_empleado.emp_id And
                    ddd_detalle_descuento.ddd_id_pla = ' . $planilla->pla_id . '
                    Group By
                    ddd_detalle_descuento.ddd_id_emp, ddd_detalle_descuento.ddd_id_pla ) As
                descuentos
                ');

        // Added by Melbin
        $this->db->join('dce_documento_emp', "dce_documento_emp.dce_id_emp = emp_empleado.emp_id and dce_id_tde=$id_nit", 'left');

        if (in_array($planilla_id, $ids_migra)) {
            $this->db->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left');
            $this->db->join('are_area', 'are_id=emp_id_are', 'left');
            $this->db->join('txe_tipo_planillaxempleado', 'txe_id_emp=emp_id', 'left');
        } else {
            $this->db->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left');
            $this->db->join('are_area', 'are_id=emp_id_are', 'left');
            $this->db->join('txe_tipo_planillaxempleado', 'txe_id_emp=emp_id');
            $this->db->where('txe_id_tpl', $planilla->pla_id_tpl);
        }

        $this->db->group_by('emp_empleado.emp_id');
        $this->db->order_by('are_id', 'asc');
        $this->db->order_by('emp_apellido', 'asc');
        $empleados = $this->db->get($this->empleados)->result();
        // die($this->db->last_query()); 
        //id del tipo de ingreso para indemnización
        $id_ting_indemnizacion = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION');
        $id_ting_aguinaldo = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');


        //Detalle de la planilla
        $detalle = '';
        $k = 0;
        $renta_10p = $renta = $isss = $afp = $des_otros = $des_total = $cancelar = $horas_extras_diu = $horas_extras_noc = $total_vacaciones = $total_comision = 0;
        $total_aguinaldo = 0;
        $total_indemnizacion = 0;
        $x = 1; //bandera que controla la clase de los tr
        //id del are que sera un bandera para hacer la totalizacion por separado por area
        //asignar la primera area correspondiente
        $id_area_inicial = (count($empleados) > 0) ? $empleados[0]->are_id : 0;
        //variables para la subtotalizacio por areas y total final

        $subtotal_area_salario = 0; //variable para ir subtotalizando el salario por area
        $subtotal_area_total_ing = 0;
        $subtotal_area_total_des = 0;
        $subtotal_area_total_cancelar = 0;

        //totalizacion de los ingresos   
        $subtotal_area_des_comision = 0;
        $total_ing_comision = 0;
        $subtotal_area_ing_anticipo = 0;
        $total_ing_anticipo = 0;
        $subtotal_area_ing_premio = 0;
        $total_ing_premio = 0;
        $subtotal_area_ing_vacacion = 0;
        $total_ing_vacacion = 0;
        $subtotal_area_ing_prima_vaca = 0;
        $total_ing_prima_vaca = 0;
        $subtotal_area_ing_depreciacion = 0;
        $total_ing_depreciacion = 0;
        $subtotal_area_ing_otros = 0;
        $total_ing_otros = 0;
        $total_ing_total = 0;



        //totalizacion de los descuentos por area y final   
        $subtotal_area_des_renta = 0;
        $subtotal_area_des_afp = 0;
        $subtotal_area_des_afp_patronal = 0;
        $subtotal_area_des_isss = 0;
        $subtotal_area_des_isss_patronal = 0;
        $subtotal_area_des_anticipo = 0;
        $total_des_anticipo = 0;
        $subtotal_area_des_prestamo_ban = 0;
        $total_des_prestamo_ban = 0;
        $subtotal_area_des_emi_fam = 0;
        $total_des_emi_fam = 0;
        $subtotal_area_des_prestamos_int = 0;
        $total_des_prestamos_int = 0;
        $subtotal_area_des_otros = 0;


        $j = 0; //variable para controlar el tr del subtotal
        //variables de totalización.
        $total_salario_final = 0;
        if ($genera_archivo_txt) {
            $consolidado_e = ($consolidado) ? $consolidado[1] : 0;
            if ($consolidado_e == 0) { //que no se trate de un consolidado en excel  
                if (file_exists("uploads/txt_planilla/datos_planilla.txt")) {
                    unlink("uploads/txt_planilla/datos_planilla.txt"); //eliminar el archivo si existiese
                }
                $file_txt = fopen("uploads/txt_planilla/datos_planilla.txt", "w") or die("Problemas en creación del archivo");
            }
        }
        foreach ($empleados as $empleado) {
            $horas_extras_diu = 0;
            $horas_extras_noc = 0;

            $descuentos = array();

            $valor_descuentos = 0;
            foreach ($this->get_descuentos_pla_emp($planilla, $empleado) as $row) {
                //  print_r($this->db->last_query()); exit;
                $descuentos[$row->tdc_id] = $row;
                $valor_descuentos += $row->{'ddd_valor'};
            }

            $ingresos = array();
            $valor_ingresos = 0;

            foreach ($this->get_ingresos_pla_emp($planilla, $empleado) as $row) {
                #print_r($this->db->last_query()); exit;
                $ingresos[$row->tig_id] = $row;


                $valor_ingresos += $row->{'ddi_valor'};
            }

            //PARAMETROS PARA EMI INGRESOS
            $id_ingreso_anticipo_emi = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_ANTICIPO');
            $id_ingreso_depreciacion = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_DEPRECIACION_AUTO');
            $id_ingreso_premio = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_PREMIO_EMI');
            $id_ingreso_prima_vacacion = $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION');

            //GUARDAR LOS VALORES EN LAS VARIABLES A IMPRIMIR
            $ingreso_anticipo_emi = $ingresos[$id_ingreso_anticipo_emi]->ddi_valor;
            $ingreso_depreciacion = $ingresos[$id_ingreso_depreciacion]->ddi_valor;
            $ingreso_premio = $ingresos[$id_ingreso_premio]->ddi_valor;
            $ingreso_prima_vacacion = $ingresos[$id_ingreso_prima_vacacion]->ddi_valor;


            //Planilla Salarios
            //ingresos
            //por el momento estas variables no se utilizan
            $hed = $ingresos[$this->tig_hed]->ddi_valor;
            $hen = $ingresos[$this->tig_hen]->ddi_valor;

            $comisiones = $ingresos[$this->tig_comision]->ddi_valor;
            $total_comision += $comisiones;

            $vacaciones = $ingresos[$this->tig_vacacion]->ddi_valor;

            //  $salario = $empleado->emp_salario / $planilla->tpl_cantidad;
            $salario = $ingresos[$this->tig_salario]->ddi_valor / $planilla->tpl_cantidad;
            //die($salario); 
            //condicionar si hay planillas migradas
            if (count($ids_migra) > 0) {
                if (!in_array($planilla_id, $ids_migra)) {
                    //     $valor_ingresos=$valor_ingresos+$salario;  
                    // $valor_ingresos=($valor_ingresos==$salario_ding)? $valor_ingresos:($valor_ingresos-$salario_ding);  
                }
            } else {
                // $valor_ingresos=$valor_ingresos+$salario;
                //$valor_ingresos=($valor_ingresos==$salario_ding)? $valor_ingresos:($valor_ingresos-$salario_ding);  
            }

            $suma_ingresosIng = $comisiones + $vacaciones + $ingreso_anticipo_emi + $ingreso_depreciacion + $ingreso_premio + $ingreso_prima_vacacion;
            $otros_ingresos = $valor_ingresos - ($salario) - $suma_ingresosIng;

            //$otros_ingresos = $valor_ingresos - ($salario)-$hed-$hen-$comisiones-$vacaciones-$ingreso_anticipo_emi-$ingreso_depreciacion-$ingreso_premio;


            $this->db->select('SUM(hxe_num_hora) cantidad')
                ->from('ddi_detalle_ingreso')
                ->join('inn_ingreso', 'inn_id=ddi_id_inn')
                ->join('hxe_hora_extraxempleado', 'hxe_id=inn_id_hxe')
                ->where('ddi_id_emp', $empleado->{'emp_id'})
                ->where('ddi_id_pla', $planilla->{'pla_id'})
                ->where('hxe_id_the', 1)/* Diurnas */
                ->where('hxe_estado', 1);
            $consulta = $this->db->get();
            $dato = $consulta->row();

            $numero_horas_diurnas = $dato->{'cantidad'};

            $this->db->select('SUM(hxe_num_hora) cantidad')
                ->from('ddi_detalle_ingreso')
                ->join('inn_ingreso', 'inn_id=ddi_id_inn')
                ->join('hxe_hora_extraxempleado', 'hxe_id=inn_id_hxe')
                ->where('ddi_id_emp', $empleado->{'emp_id'})
                ->where('ddi_id_pla', $planilla->{'pla_id'})
                ->where('hxe_id_the', 2)/* Nocturnas */
                ->where('hxe_estado', 1);
            $consulta = $this->db->get();
            $dato = $consulta->row();

            $numero_horas_nocturnas = $dato->{'cantidad'};

            //PARAMETROS PARA LOS DESCUENTOS DE EMI

            $id_descuento_anticipo_emi = $this->gsatelite->get_parametro('ID_TIPO_DESCUENTO_ANTICIPO');
            $id_descuento_prestamo_banco = $this->gsatelite->get_parametro('ID_TIPO_DESCUENTO_PRESTAMO_BANCO');
            $id_descuento_emi_familia = $this->gsatelite->get_parametro('ID_TIPO_DESCUENTO_EMI_FAMILIA');
            $id_descuento_prestamo_interno = $this->gsatelite->get_parametro('ID_TIPO_DESCUENTO_PRESTAMO_INTERNO');

            //ALMACENAR LOS VALORES EN VARIABLES
            $descuento_anticipo_emi = $descuentos[$id_descuento_anticipo_emi]->ddd_valor;
            $descuento_prestamo_banco = $descuentos[$id_descuento_prestamo_banco]->ddd_valor;
            $descuento_emi_familia = $descuentos[$id_descuento_emi_familia]->ddd_valor;
            $descuento_prestamo_interno = $descuentos[$id_descuento_prestamo_interno]->ddd_valor;

            $suma_descuentos_emi = $descuento_anticipo_emi + $descuento_prestamo_banco + $descuento_emi_familia + $descuento_prestamo_interno;



            $bonificaciones = $ingresos[$this->tig_bonificacion]->ddi_valor;
            $viaticos = $ingresos[$this->tig_viatico]->ddi_valor;

            $suma_de_descuentos = $descuentos[$this->tdc_isr]->ddd_valor + $descuentos[$this->tdc_isr_10p]->ddd_valor + $descuentos[$this->tdc_afp]->ddd_valor + $descuentos[$this->tdc_isss]->ddd_valor + $suma_descuentos_emi;
            $otros_descuentos = round($valor_descuentos, 2) - round($suma_de_descuentos, 2);

            $total = $valor_ingresos - $valor_descuentos;


            //descuentos
            $renta += $descuentos[$this->tdc_isr]->ddd_valor;

            $afp += $descuentos[$this->tdc_afp]->ddd_valor;
            $afp_patronal += $descuentos[$this->tdc_afp]->ddd_valor_patronal;
            $isss += $descuentos[$this->tdc_isss]->ddd_valor;
            $isss_patronal += $descuentos[$this->tdc_isss]->ddd_valor_patronal;
            $des_otros += $otros_descuentos;
            $des_total += $valor_descuentos;
            //totales
            $cancelar += $total;
            $horas_extras_diu += $hed;
            $horas_extras_noc += $hen;
            $total_vacaciones += $vacaciones;

            //planilla indemnizacion
            $indemnizacion = $ingresos[$id_ting_indemnizacion]->ddi_valor;
            $total_indemnizacion += $indemnizacion;

            //planilla comisiones (renta es la misma)


            $renta_10p += $descuentos[$this->tdc_isr_10p]->ddd_valor;

            //planilla aguinaldo (renta es la misma)
            $aguinaldo = $ingresos[$id_ting_aguinaldo]->ddi_valor;
            $total_aguinaldo += $aguinaldo;

            if ($x) {
                $valor = "impar";
                $x = 0;
            } else {
                $valor = "par";
                $x = 1;
            }
            $total_salario_final += $salario;

            //totalizacion de los ingresos   
            $total_ing_comision += $comisiones;
            $total_ing_anticipo += $ingreso_anticipo_emi;
            $total_ing_premio += $ingreso_premio;
            $total_ing_vacacion += $vacaciones;
            $total_ing_prima_vaca += $ingreso_prima_vacacion;
            $total_ing_depreciacion += $ingreso_depreciacion;
            $total_ing_otros += $otros_ingresos;
            $total_ing_total += $valor_ingresos;

            //totalizacion de los descuentos

            $total_des_anticipo += $descuento_anticipo_emi;
            $total_des_prestamo_ban += $descuento_prestamo_banco;
            $total_des_emi_fam += $descuento_emi_familia;
            $total_des_prestamos_int += $descuento_prestamo_interno;

            $tr_subtotalizacion = "";
            if ($empleado->are_id == $id_area_inicial) {
                //incrementar las variable

                $subtotal_area_salario += $salario;

                $subtotal_area_total_ing += $valor_ingresos;
                $subtotal_area_total_des += $valor_descuentos;
                $subtotal_area_total_cancelar += $total;

                $subtotal_area_ing_comision += $comisiones;
                $subtotal_area_ing_anticipo += $ingreso_anticipo_emi;
                $subtotal_area_ing_premio += $ingreso_premio;
                $subtotal_area_ing_vacacion += $vacaciones;
                $subtotal_area_ing_prima_vaca += $ingreso_prima_vacacion;
                $subtotal_area_ing_depreciacion += $ingreso_depreciacion;
                $subtotal_area_ing_otros += $otros_ingresos;

                //subtotalizacion por area de los descuentos
                $subtotal_area_des_renta += $descuentos[$this->tdc_isr]->ddd_valor;
                $subtotal_area_des_afp += $descuentos[$this->tdc_afp]->ddd_valor;
                $subtotal_area_des_afp_patronal += $descuentos[$this->tdc_afp]->ddd_valor_patronal;
                $subtotal_area_des_isss += $descuentos[$this->tdc_isss]->ddd_valor;
                $subtotal_area_des_isss_patronal += $descuentos[$this->tdc_isss]->ddd_valor_patronal;
                $subtotal_area_des_anticipo += $descuento_anticipo_emi;
                $subtotal_area_des_prestamo_ban += $descuento_prestamo_banco;
                $subtotal_area_des_emi_fam += $descuento_emi_familia;
                $subtotal_area_des_prestamos_int += $descuento_prestamo_interno;
                $subtotal_area_des_otros += $otros_descuentos;

                $id_area_inicial = $empleado->are_id;
                $tr_subtotalizacion = "";
            } else {
                //setear las variables
                $subtotal_area_salario = $salario;

                $subtotal_area_total_ing = $valor_ingresos;
                $subtotal_area_total_des = $valor_descuentos;
                $subtotal_area_total_cancelar = $total;

                $subtotal_area_total_ing = $valor_ingresos;
                $subtotal_area_total_des = $valor_descuentos;
                $subtotal_area_total_cancelar = $total;

                $subtotal_area_ing_comision = $comisiones;
                $subtotal_area_ing_anticipo = $ingreso_anticipo_emi;
                $subtotal_area_ing_vacacion = $vacaciones;
                $subtotal_area_ing_premio = $ingreso_premio;
                $subtotal_area_ing_prima_vaca = $ingreso_prima_vacacion;
                $subtotal_area_ing_depreciacion = $ingreso_depreciacion;
                $subtotal_area_ing_otros = $otros_ingresos;

                //subtotalizacion por area de los descuentos (setearlas para comenzar con otra area)
                $subtotal_area_des_renta = $descuentos[$this->tdc_isr]->ddd_valor;
                $subtotal_area_des_afp = $descuentos[$this->tdc_afp]->ddd_valor;
                $subtotal_area_des_afp_patronal = $descuentos[$this->tdc_afp]->ddd_valor_patronal;
                $subtotal_area_des_isss = $descuentos[$this->tdc_isss]->ddd_valor;
                $subtotal_area_des_isss_patronal = $descuentos[$this->tdc_isss]->ddd_valor_patronal;
                $subtotal_area_des_anticipo = $descuento_anticipo_emi;
                $subtotal_area_des_prestamo_ban = $descuento_prestamo_banco;
                $subtotal_area_des_emi_fam = $descuento_emi_familia;
                $subtotal_area_des_prestamos_int = $descuento_prestamo_interno;
                $subtotal_area_des_otros = $otros_descuentos;

                $id_area_inicial = $empleado->are_id;
            }

            $nombre_area = $empleado->are_nombre;
            if (count($empleados) != ($j + 1)) { //que no sea el ultimo para adelantar la posición siguiente
                if ($empleados[($j + 1)]->are_id != $empleado->are_id) {
                    //crear el tr del subtotal y al final crear una fila en blanco
                    $tr_subtotalizacion = '<tr>
                            <td colspan="3" align="right" ><b>Subtotal ' . $nombre_area . '</b></td>
                            <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_salario, 2) . '</td>
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_total_ing, 2) . '</td>  
                          
                            <td align="right" style="font-weight:bold;">$  ' . number_format($subtotal_area_total_des, 2) . '</td>
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_total_cancelar, 2) . '</td>
                            </tr><tr><td colspan="6"></td></tr>';
                }
            } else { //si es el ultimo registro imprimir la totalización del area final
                $tr_subtotalizacion = '<tr>
                          <td colspan="3" align="right" ><b>Subtotal ' . $nombre_area . '</b></td>
                          <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_salario, 2) . '</td>
                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_total_ing, 2) . '</td>

                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_total_des, 2) . '</td>
                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_total_cancelar, 2) . '</td>
                          </tr><tr><td colspan="6"></td></tr>';
            }

            $j++; //incrementar la variable de control de flujo de los registros

            if ($tipo == 'salario') {
                $cuenta_empleado = "";
                //CREAR LA CADENA DE TEXTO PARA EL ARCHIVO DE TEXTO. (.txt)
                if ($genera_archivo_txt) {
                    $agregar_fila = true;
                    $nombre_empresa = utf8_decode($this->gsatelite->get_parametro('SYS_EMPRESA'));
                    $nombre_completo = utf8_decode($empleado->emp_nombre) . ' ' . utf8_decode($empleado->emp_apellido);
                    $archivo_txt = "$empleado->emp_numero_cuenta" . " ; " .
                        "$nombre_completo" . " ;  ; " .
                        number_format($total, 2, '.', '') . "; " . "; " . "Nomina $nombre_empresa " . $registro_planilla[0]['pla_codigo'] . " ; " . " ";

                    if ($consolidado) { // preguntar si existe la variable que aplica para generar un consolidado
                        $con_num_cuenta = $consolidado[0]; // 1=solo con numero de cuenta, 0=sin numero, 3=ambos
                        $es_excel_consolidado = $consolidado[1];

                        if ($con_num_cuenta == 1) { // 1=solo con numero de cuenta
                            $agregar_fila = (trim($empleado->emp_numero_cuenta) != "") ? true : false;
                        } elseif ($con_num_cuenta == 0) { // 0=sin numero de cuenta
                            $agregar_fila = (trim($empleado->emp_numero_cuenta) == "") ? true : false;
                        } else { //si no ambos
                            $agregar_fila = true;
                        }

                        $agregar_fila = ($es_excel_consolidado == 1) ? false : $agregar_fila;
                    }

                    if ($agregar_fila and $total > 0) {
                        fputs($file_txt, $archivo_txt);
                        fputs($file_txt, chr(13) . chr(10));
                    }
                }

                //ir sub-totalizando areas por separado
                $fecha = date('d-m-Y', strtotime($empleado->emp_fecha_contrato));

                if ($valor_ingresos > 0 or $valor_descuentos > 0) {
                    $k++;
                    $detalle .= "
                            <tr class=\"" . $valor . "\">
                            <td>" . $k . "</td>
                            <td>$empleado->are_nombre</td>
                            <td>$empleado->plz_nombre</td>
                            
                            <td align=\"right\">$ " . number_format($salario, 2) . "</td>";


                    $detalle .= "<td align=\"right\">$" . number_format($valor_ingresos, 2) . "</td>

                         <td align=\"right\">$" . number_format($valor_descuentos, 2) . "</td>
                         <td align=\"right\" >$" . number_format($total, 2) . "</td>
                         </tr>
                         " . $tr_subtotalizacion;
                } else { // si el ultimo empleado no posee salario entonces solo imprimir la subtotalización del area
                    $detalle .= $tr_subtotalizacion;
                }
            } elseif ($tipo == 'comision') {
                $detalle .= "
                        <tr class=\"" . $valor . "\">
                        <!-- <td width=\"2%\">$i</td> -->
                        <td>$empleado->emp_codigo</td>
                        <td>$empleado->emp_nombre $empleado->emp_apellido</td>
                        <!-- <td>$empleado->pto_nombre</td> -->

                        <td align=\"right\">$" . number_format($comisiones, 2) . "</td>

                        <td align=\"right\">$" . number_format($descuentos[$this->tdc_isr_10p]->ddd_valor, 2) . "</td>
                        <td align=\"right\">$" . number_format($total, 2) . "</td>
                        </tr>
                        ";
            } elseif ($tipo == 'aguinaldo') {
                $detalle .= "
                        <tr class=\"" . $valor . "\">
                        <!-- <td width=\"2%\">$i</td> -->
                        <td>$empleado->emp_codigo</td>
                        <td>$empleado->emp_nombre $empleado->emp_apellido</td>
                        <!--<td>$empleado->pto_nombre</td>-->

                        <td align=\"right\">$" . number_format($aguinaldo, 2) . "</td>

                        <td align=\"right\">$" . number_format($descuentos[$this->tdc_isr_10p]->ddd_valor, 2) . "</td>
                        <td align=\"right\">$" . number_format($total_aguinaldo, 2) . "</td>
                        </tr>
                        ";
            } elseif ($tipo == 'indemnizacion') {
                $detalle .= "
                       <tr class=\"" . $valor . "\">
                       <!-- <td width=\"2%\">$i</td> -->
                       <td>$empleado->emp_codigo</td>
                       <td>$empleado->emp_nombre $empleado->emp_apellido</td>
                       <!-- <td>$empleado->pto_nombre</td> -->

                       <td align=\"right\">$" . number_format($indemnizacion, 2) . "</td>

                       <!-- <td align=\"right\">$" . number_format($descuentos[$this->tdc_isr_10p]->ddd_valor, 2) . "</td> -->
                       <td align=\"right\">$" . number_format($total, 2) . "</td>
                       </tr>
                       ";
            }

            $i++;
        }
        //Totales
        if ($tipo == 'comision') {
            $detalle .= '
                <tr class="encabezado" >
                <td colspan="3">Total planilla</td>
                <td align="right">$' . number_format($total_comision, 2) . '</td>
                <td align="right">$' . number_format($renta_10p, 2) . '</td>

                <td align="right" >$' . number_format($cancelar, 2) . '</td>
                </tr>';
        } elseif ($tipo == "aguinaldo") {
            $detalle .= '
                <tr class="encabezado" >
                <td colspan="3">Total planilla</td>
                <td align="right">$' . number_format($total_aguinaldo, 2) . '</td>
                <td align="right">$' . number_format($renta, 2) . '</td>

                <td align="right" >$' . number_format($cancelar, 2) . '</td>
                </tr>';
        } elseif ($tipo == "indemnizacion") {
            $detalle .= '
                <tr class="encabezado" >
                <td colspan="3">Total planilla</td>
                <td align="right">$' . number_format($total_indemnizacion, 2) . '</td>
                <!-- <td align="right">$' . number_format($renta_10p, 2) . '</td> -->

                <td align="right" >$' . number_format($cancelar, 2) . '</td>
                </tr>';
        } elseif ($tipo == 'salario') {
            $consolidado_e = ($consolidado) ? $consolidado[1] : 0;
            if ($genera_archivo_txt and $consolidado_e == 0) {
                fclose($file_txt);
            }
            $para_consolidado_excel = $detalle;
            $detalle .= '
                <tr class="encabezado" >
                <td colspan="3"><b>Total planilla</b></td>
                <td  align="right" style="font-weight:bold;" >$ ' . number_format($total_salario_final, 2) . '</td>
                <td align="right" style="font-weight:bold;"  >$ ' . number_format($total_ing_total, 2) . '</td>

                <td align="right" style="font-weight:bold;" >$' . number_format($des_total, 2) . '</td>
                <td align="right" style="font-weight:bold;" >$' . number_format($cancelar, 2) . '</td>
                </tr>';

            //consolidado en excel
            if ($consolidado) {
                $es_excel_consolidado = $consolidado[1];
                $data['es_consolidado_excel'] = $consolidado[1];
                if ($es_excel_consolidado) {
                    $titulo_pla = '<b> CORRESPONDIENTE AL PERIODO ' . $registro_planilla[0]['pla_fecha_inicio'] . ' AL  ' . $registro_planilla[0]['pla_fecha_fin'] . '</b>';
                    $html_excel_consolidado = '<tr><td colspan="6">' . $titulo_pla . '</td></tr>' . $para_consolidado_excel;
                    $totales_planilla = array(
                        't1' => $total_salario_final, 't9' => $total_ing_total, 't18' => $des_total, 't19' => $cancelar
                    );
                    return array($html_excel_consolidado, $totales_planilla);
                }
            }
        }
        $data['tipo'] = $tipo;
        $data['detalle_planilla'] = $detalle;
        $data['titulo'] = "Planilla";
        $data['registro_planilla'] = $registro_planilla;
        $data['usuario'] = $usuario;
        $html = "";
        if ($sin_header == null) {
            $html .= $thml = $this->load->view('personal/planilla/header_simple', array('titulo' => 'Planilla'), true);
        }
        $html .= $this->load->view('personal/planilla/pla_print_emi_plazas', $data, true);
        if ($genera_archivo_txt) {
            if (file_exists("uploads/txt_planilla/datos_planilla.txt")) {
                return true;
            }
        } else {
            return $html;
        }
    }

    /**
     * @author René Castaneda
     * @return planilla personalizada para emi
     * genera_archivo_txt (boolean) = bandera para indicar si se trata de la generación del archivo txt
     * consolidado (array) = datos para indicar si se trata de un consolidado de varias planillas. 
     *
     */
    function print_planilla_emi($planilla_id, $usuario = null, $tipo = null, $sin_header = null, $genera_archivo_txt = false, $consolidado = null, $recalculo = null){

        //preguntar si hay planillas migradas
        //preguntar por las planillas migradas para omitir esta operación. mediante un parametro
        $planilla_migradas = $this->gsatelite->get_parametro('PLANILLAS_MIGRADAS');
        $id_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $ids_migra = array();
        if ($planilla_migradas != "") {
            $ids_migra = explode(',', $planilla_migradas);
        }


        $registro_planilla = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $planilla_id));
        //planilla
        $this->db->join($this->tipo_planillas, 'pla_id_tpl = tpl_id');
        $planilla = $this->db->get_where($this->planillas, array('pla_id' => $planilla_id), 1)->row();

        $this->db->select('
                  emp_empleado.emp_id,
                  emp_empleado.emp_codigo,
                  emp_empleado.emp_nombre,
                  emp_empleado.emp_apellido,
                  emp_empleado.emp_salario,
                  emp_empleado.emp_fecha_contrato,
                  emp_empleado.emp_numero_cuenta,
                  emp_empleado.emp_metodo_pago,
                  plz_plaza.plz_nombre,
                  dce_valor,
                  are_nombre,
                  are_id,
                  (Select
                    Sum(ddi_detalle_ingreso.ddi_valor)
                    From
                    ddi_detalle_ingreso
                    Where
                    ddi_detalle_ingreso.ddi_id_emp = emp_empleado.emp_id And
                    ddi_detalle_ingreso.ddi_id_pla = ' . $planilla->pla_id . '
                    Group By
                    ddi_detalle_ingreso.ddi_id_emp, ddi_detalle_ingreso.ddi_id_pla ) As ingresos,
                (Select
                    Sum(ddd_detalle_descuento.ddd_valor)
                    From
                    ddd_detalle_descuento
                    Where
                    ddd_detalle_descuento.ddd_id_emp = emp_empleado.emp_id And
                    ddd_detalle_descuento.ddd_id_pla = ' . $planilla->pla_id . '
                    Group By
                    ddd_detalle_descuento.ddd_id_emp, ddd_detalle_descuento.ddd_id_pla ) As
                descuentos
                ');

        // Added by Melbin
        $this->db->join('dce_documento_emp', "dce_documento_emp.dce_id_emp = emp_empleado.emp_id and dce_id_tde=$id_nit", 'left');

        if (in_array($planilla_id, $ids_migra)) {
            $this->db->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left');
            $this->db->join('are_area', 'are_id=emp_id_are', 'left');
            $this->db->join('txe_tipo_planillaxempleado', 'txe_id_emp=emp_id', 'left');
        } else {
            $this->db->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left');
            $this->db->join('are_area', 'are_id=emp_id_are', 'left');
            $this->db->join('txe_tipo_planillaxempleado', 'txe_id_emp=emp_id');
            $this->db->where('txe_id_tpl', $planilla->pla_id_tpl);
        }


        $this->db->group_by('emp_empleado.emp_id');
        $this->db->order_by('are_id', 'asc');
        $this->db->order_by('emp_apellido', 'asc');
        $empleados = $this->db->get($this->empleados)->result();
        //die(print_r($this->db->last_query()));
        //id del tipo de ingreso para indemnización
        $id_ting_indemnizacion = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION');
        $id_ting_aguinaldo = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');


        //Detalle de la planilla
        $detalle = '';
        $k = 0;
        $renta_10p = $renta = $isss = $afp = $des_otros = $des_total = $cancelar = $horas_extras_diu = $horas_extras_noc = $total_vacaciones = $total_comision = 0;
        $total_aguinaldo = $ipsfa = $ipsfa_patronal = 0;
        $total_indemnizacion = 0;
        $x = 1; //bandera que controla la clase de los tr
        //id del are que sera un bandera para hacer la totalizacion por separado por area
        //asignar la primera area correspondiente
        $id_area_inicial = (count($empleados) > 0) ? $empleados[0]->are_id : 0;
        //variables para la subtotalizacio por areas y total final

        $subtotal_area_salario = 0; //variable para ir subtotalizando el salario por area
        $subtotal_area_total_ing = 0;

        $subtotal_area_total_des = 0;
        $subtotal_area_total_cancelar = 0;

        //totalizacion de los ingresos   
        $subtotal_area_des_comision = 0;
        $total_ing_comision = 0;
        $subtotal_area_ing_anticipo = 0;
        $total_ing_anticipo = 0;
        $subtotal_area_ing_premio = 0;
        $total_ing_premio = 0;
        $subtotal_area_ing_vacacion = 0;
        $total_ing_vacacion = 0;
        $subtotal_area_ing_prima_vaca = 0;
        $total_ing_prima_vaca = 0;
        $subtotal_area_ing_depreciacion = 0;
        $total_ing_depreciacion = 0;
        $subtotal_area_ing_otros = 0;
        $total_ing_otros = 0;
        $total_ing_total = 0;

        //totalizacion de los descuentos por area y final   
        $subtotal_area_des_renta = 0;
        $subtotal_area_des_afp = 0;
        $subtotal_area_des_afp_patronal = 0;
        $subtotal_area_des_ipsfa = 0;
        $subtotal_area_des_ipsfa_patronal = 0;
        $subtotal_area_des_isss = 0;
        $subtotal_area_des_isss_patronal = 0;
        $subtotal_area_des_anticipo = 0;
        $total_des_anticipo = 0;
        $subtotal_area_des_prestamo_ban = 0;
        $total_des_prestamo_ban = 0;
        $subtotal_area_des_emi_fam = 0;
        $total_des_emi_fam = 0;
        $subtotal_area_des_prestamos_int = 0;
        $total_des_prestamos_int = 0;
        $subtotal_area_des_otros = 0;


        $j = 0; //variable para controlar el tr del subtotal
        //variables de totalización.
        $total_salario_final = 0;
        if ($genera_archivo_txt) {
            $consolidado_e = ($consolidado) ? $consolidado[1] : 0;
            if ($consolidado_e == 0) { //que no se trate de un consolidado en excel  
                if (file_exists("uploads/txt_planilla/datos_planilla.txt")) {
                    unlink("uploads/txt_planilla/datos_planilla.txt"); //eliminar el archivo si existiese
                }
                $file_txt = fopen("uploads/txt_planilla/datos_planilla.txt", "w") or die("Problemas en creación del archivo");
            }
        }
        foreach ($empleados as $empleado) {
            $horas_extras_diu = 0;
            $horas_extras_noc = 0;

            $descuentos = array();

            $valor_descuentos = 0;
            foreach ($this->get_descuentos_pla_emp($planilla, $empleado) as $row) {
                //  print_r($this->db->last_query()); exit;
                $descuentos[$row->tdc_id] = $row;
                $valor_descuentos += $row->{'ddd_valor'};
            }

            $ingresos = array();
            $valor_ingresos = 0;

            foreach ($this->get_ingresos_pla_emp($planilla, $empleado) as $row) {
                #print_r($this->db->last_query()); exit;
                $ingresos[$row->tig_id] = $row;
                $valor_ingresos += $row->{'ddi_valor'};
            }

            //PARAMETROS PARA EMI INGRESOS
            $id_ingreso_anticipo_emi = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_ANTICIPO');
            $id_ingreso_depreciacion = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_DEPRECIACION_AUTO');
            $id_ingreso_premio = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_PREMIO_EMI');
            $id_ingreso_prima_vacacion = $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION');

            //GUARDAR LOS VALORES EN LAS VARIABLES A IMPRIMIR
            $ingreso_anticipo_emi = $ingresos[$id_ingreso_anticipo_emi]->ddi_valor;
            $ingreso_depreciacion = $ingresos[$id_ingreso_depreciacion]->ddi_valor;
            $ingreso_premio = $ingresos[$id_ingreso_premio]->ddi_valor;
            $ingreso_prima_vacacion = $ingresos[$id_ingreso_prima_vacacion]->ddi_valor;


            //Planilla Salarios
            //ingresos
            //por el momento estas variables no se utilizan
            $hed = $ingresos[$this->tig_hed]->ddi_valor;
            $hen = $ingresos[$this->tig_hen]->ddi_valor;

            $comisiones = $ingresos[$this->tig_comision]->ddi_valor;
            $total_comision += $comisiones;

            $vacaciones = $ingresos[$this->tig_vacacion]->ddi_valor;

            //  $salario = $empleado->emp_salario / $planilla->tpl_cantidad;
            // $salario =   $ingresos[$this->tig_salario]->ddi_valor/ $planilla->tpl_cantidad ;
            $salario = $ingresos[$this->tig_salario]->ddi_valor;

            //die($salario); 


            $suma_ingresosIng = $comisiones + $vacaciones + $ingreso_anticipo_emi + $ingreso_depreciacion + $ingreso_premio + $ingreso_prima_vacacion;
            $otros_ingresos = $valor_ingresos - ($salario) - $suma_ingresosIng;

            //$otros_ingresos = $valor_ingresos - ($salario)-$hed-$hen-$comisiones-$vacaciones-$ingreso_anticipo_emi-$ingreso_depreciacion-$ingreso_premio;
            //PARAMETROS PARA LOS DESCUENTOS DE EMI

            $id_descuento_anticipo_emi = $this->gsatelite->get_parametro('ID_TIPO_DESCUENTO_ANTICIPO');
            $id_descuento_prestamo_banco = $this->gsatelite->get_parametro('ID_TIPO_DESCUENTO_PRESTAMO_BANCO');
            $id_descuento_emi_familia = $this->gsatelite->get_parametro('ID_TIPO_DESCUENTO_EMI_FAMILIA');
            $id_descuento_prestamo_interno = $this->gsatelite->get_parametro('ID_TIPO_DESCUENTO_PRESTAMO_INTERNO');

            //ALMACENAR LOS VALORES EN VARIABLES
            $descuento_anticipo_emi = $descuentos[$id_descuento_anticipo_emi]->ddd_valor;
            $descuento_prestamo_banco = $descuentos[$id_descuento_prestamo_banco]->ddd_valor;
            $descuento_emi_familia = $descuentos[$id_descuento_emi_familia]->ddd_valor;
            $descuento_prestamo_interno = $descuentos[$id_descuento_prestamo_interno]->ddd_valor;

            $suma_descuentos_emi = $descuento_anticipo_emi + $descuento_prestamo_banco + $descuento_emi_familia + $descuento_prestamo_interno;



            $bonificaciones = $ingresos[$this->tig_bonificacion]->ddi_valor;
            $viaticos = $ingresos[$this->tig_viatico]->ddi_valor;

            $suma_de_descuentos = $descuentos[$this->tdc_isr]->ddd_valor + $descuentos[$this->tdc_isr_10p]->ddd_valor + $descuentos[$this->tdc_afp]->ddd_valor + $descuentos[$this->tdc_isss]->ddd_valor + $suma_descuentos_emi;
            $otros_descuentos = round($valor_descuentos, 2) - round($suma_de_descuentos, 2);

            $total = $valor_ingresos - $valor_descuentos;

            //IPSFA ES UNA AFP PERO DEBE SALIR APARTE
            $ipsfaid = $this->gsatelite->get_parametro('AFP_IPSFA', 0);
            $afpeid = $this->gsatelite->get_campo('emp_empleado', 'emp_id_afp', array('emp_id' => $empleado->emp_id));

            //descuentos
            $renta += $descuentos[$this->tdc_isr]->ddd_valor;

            if (intval($ipsfaid) == intval($afpeid)) {
                $ipsfa += $descuentos[$this->tdc_afp]->ddd_valor;
                $ipsfa_patronal += $descuentos[$this->tdc_afp]->ddd_valor_patronal;
            } else {
            $afp += $descuentos[$this->tdc_afp]->ddd_valor;
            $afp_patronal += $descuentos[$this->tdc_afp]->ddd_valor_patronal;
            }
            $isss += $descuentos[$this->tdc_isss]->ddd_valor;
            $isss_patronal += $descuentos[$this->tdc_isss]->ddd_valor_patronal;
            $des_otros += $otros_descuentos;
            $des_total += $valor_descuentos;
            //totales
            $cancelar += $total;
            $horas_extras_diu += $hed;
            $horas_extras_noc += $hen;
            $total_vacaciones += $vacaciones;

            //planilla indemnizacion
            $indemnizacion = $ingresos[$id_ting_indemnizacion]->ddi_valor;
            $total_indemnizacion += $indemnizacion;

            //planilla comisiones (renta es la misma)
            $renta_10p += $descuentos[$this->tdc_isr_10p]->ddd_valor;

            //planilla aguinaldo (renta es la misma)
            $aguinaldo = $ingresos[$id_ting_aguinaldo]->ddi_valor;
            $total_aguinaldo += $aguinaldo;

            $total_salario_final += $salario;

            if ($renta > 0) {
                $renta_tlt = $renta;
            } else if ($renta <= 0) {
                $renta_tlt = $renta_10p;
            }

            //totalizacion de los ingresos   
            $total_ing_comision += $comisiones;
            $total_ing_anticipo += $ingreso_anticipo_emi;
            $total_ing_premio += $ingreso_premio;
            $total_ing_vacacion += $vacaciones;
            $total_ing_prima_vaca += $ingreso_prima_vacacion;
            $total_ing_depreciacion += $ingreso_depreciacion;
            $total_ing_otros += $otros_ingresos;
            $total_ing_total += $valor_ingresos;

            //totalizacion de los descuentos

            $total_des_anticipo += $descuento_anticipo_emi;
            $total_des_prestamo_ban += $descuento_prestamo_banco;
            $total_des_emi_fam += $descuento_emi_familia;
            $total_des_prestamos_int += $descuento_prestamo_interno;


            $tr_subtotalizacion = "";
            if ($empleado->are_id == $id_area_inicial) {
                //incrementar las variable

                $subtotal_area_salario += $salario;

                $subtotal_area_total_ing += $valor_ingresos;
                $subtotal_area_total_des += $valor_descuentos;
                $subtotal_area_total_cancelar += $total;

                $subtotal_area_ing_comision += $comisiones;
                $subtotal_area_ing_anticipo += $ingreso_anticipo_emi;
                $subtotal_area_ing_premio += $ingreso_premio;
                $subtotal_area_ing_vacacion += $vacaciones;
                $subtotal_area_ing_prima_vaca += $ingreso_prima_vacacion;
                $subtotal_area_ing_depreciacion += $ingreso_depreciacion;
                $subtotal_area_ing_otros += $otros_ingresos;

                //subtotalizacion por area de los descuentos
                $subtotal_area_des_renta += $descuentos[$this->tdc_isr]->ddd_valor;
                $subtotal_area_des_renta_10p += $descuentos[$this->tdc_isr_10p]->ddd_valor;
                if (intval($ipsfaid) == intval($afpeid)) {
                    $subtotal_area_des_ipsfa += $descuentos[$this->tdc_afp]->ddd_valor;
                    $subtotal_area_des_ipsfa_patronal += $descuentos[$this->tdc_afp]->ddd_valor_patronal;
                } else {
                $subtotal_area_des_afp += $descuentos[$this->tdc_afp]->ddd_valor;
                $subtotal_area_des_afp_patronal += $descuentos[$this->tdc_afp]->ddd_valor_patronal;
                }
                $subtotal_area_des_isss += $descuentos[$this->tdc_isss]->ddd_valor;
                $subtotal_area_des_isss_patronal += $descuentos[$this->tdc_isss]->ddd_valor_patronal;
                $subtotal_area_des_anticipo += $descuento_anticipo_emi;
                $subtotal_area_des_prestamo_ban += $descuento_prestamo_banco;
                $subtotal_area_des_emi_fam += $descuento_emi_familia;
                $subtotal_area_des_prestamos_int += $descuento_prestamo_interno;
                $subtotal_area_des_otros += $otros_descuentos;

                $id_area_inicial = $empleado->are_id;
                $tr_subtotalizacion = "";
            } else {
                //setear las variables
                $subtotal_area_salario = $salario;

                $subtotal_area_total_ing = $valor_ingresos;
                $subtotal_area_total_des = $valor_descuentos;
                $subtotal_area_total_cancelar = $total;

                $subtotal_area_total_ing = $valor_ingresos;
                $subtotal_area_total_des = $valor_descuentos;
                $subtotal_area_total_cancelar = $total;

                $subtotal_area_ing_comision = $comisiones;
                $subtotal_area_ing_anticipo = $ingreso_anticipo_emi;
                $subtotal_area_ing_vacacion = $vacaciones;
                $subtotal_area_ing_premio = $ingreso_premio;
                $subtotal_area_ing_prima_vaca = $ingreso_prima_vacacion;
                $subtotal_area_ing_depreciacion = $ingreso_depreciacion;
                $subtotal_area_ing_otros = $otros_ingresos;

                //subtotalizacion por area de los descuentos (setearlas para comenzar con otra area)
                $subtotal_area_des_renta = $descuentos[$this->tdc_isr]->ddd_valor;
                $subtotal_area_des_renta_10p = $descuentos[$this->tdc_isr_10p]->ddd_valor;
                if (intval($ipsfaid) == intval($afpeid)) {
                    $subtotal_area_des_afp = 0;
                    $subtotal_area_des_afp_patronal = 0;
                    $subtotal_area_des_ipsfa = $descuentos[$this->tdc_afp]->ddd_valor;
                    $subtotal_area_des_ipsfa_patronal = $descuentos[$this->tdc_afp]->ddd_valor_patronal;
                } else {
                $subtotal_area_des_afp = $descuentos[$this->tdc_afp]->ddd_valor;
                $subtotal_area_des_afp_patronal = $descuentos[$this->tdc_afp]->ddd_valor_patronal;
                $subtotal_area_des_ipsfa = 0;
                $subtotal_area_des_ipsfa_patronal = 0;
                }
                $subtotal_area_des_isss = $descuentos[$this->tdc_isss]->ddd_valor;
                $subtotal_area_des_isss_patronal = $descuentos[$this->tdc_isss]->ddd_valor_patronal;
                $subtotal_area_des_anticipo = $descuento_anticipo_emi;
                $subtotal_area_des_prestamo_ban = $descuento_prestamo_banco;
                $subtotal_area_des_emi_fam = $descuento_emi_familia;
                $subtotal_area_des_prestamos_int = $descuento_prestamo_interno;
                $subtotal_area_des_otros = $otros_descuentos;

                $id_area_inicial = $empleado->are_id;
            }

            $subtotal_area_renta_isr = $subtotal_area_des_renta;
            if ($subtotal_area_renta_isr > 0) {
                $subtotal_renta_final = $subtotal_area_renta_isr;
            } else if ($subtotal_area_renta_isr <= 0) {
                $subtotal_renta_final = $subtotal_area_des_renta_10p;
            }

            $nombre_area = $empleado->are_nombre;
            if (count($empleados) != ($j + 1)) { //que no sea el ultimo para adelantar la posición siguiente
                if ($empleados[($j + 1)]->are_id != $empleado->are_id) {
                    //crear el tr del subtotal y al final crear una fila en blanco
                    $tr_subtotalizacion = '<tr>
                            <td colspan="8" align="right" ><b>Subtotal ' . $nombre_area . '</b></td>
                            <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_salario, 2) . '</td>
                            <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_ing_comision, 2) . '</td>
                            <td align="right"  style="font-weight:bold;">$ ' . number_format($subtotal_area_ing_anticipo, 2) . '</td>
                            <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_ing_vacacion, 2) . '</td>
                            <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_ing_prima_vaca, 2) . '</td>
                            <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_ing_depreciacion, 2) . '</td>
                            <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_ing_premio, 2) . '</td>
                            <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_ing_otros, 2) . '</td>
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_total_ing, 2) . '</td>  
                          
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_renta_final, 2) . '</td>
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_afp, 2) . '</td>
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_afp_patronal, 2) . '</td> 
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_ipsfa, 2) . '</td>
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_ipsfa_patronal, 2) . '</td> 
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_isss, 2) . '</td>
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_isss_patronal, 2) . '</td>
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_anticipo, 2) . '</td>
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_prestamo_ban, 2) . '</td>';
                    if ($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA') != 3) {
                        $tr_subtotalizacion .= '<td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_emi_fam, 2) . '</td>';
                    }
                    $tr_subtotalizacion .= '<td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_prestamos_int, 2) . '</td>
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_otros, 2) . '</td>

                            <td align="right" style="font-weight:bold;">$  ' . number_format($subtotal_area_total_des, 2) . '</td>
                            <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_total_cancelar, 2) . '</td>
                            </tr>';
                    if ($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA') != 3) {
                        $tr_subtotalizacion .= '<tr><td colspan="31"></td></tr>';
                    } else {
                        $tr_subtotalizacion .= '<tr><td colspan="28"></td></tr>';
                    }
                }
            } else { //si es el ultimo registro imprimir la totalización del area final
                $tr_subtotalizacion = '<tr>
                          <td colspan="8" align="right" ><b>Subtotal ' . $nombre_area . '</b></td>
                          <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_salario, 2) . '</td>
                          <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_ing_comision, 2) . '</td>
                          <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_ing_anticipo, 2) . '</td>
                          <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_ing_vacacion, 2) . '</td>
                          <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_ing_prima_vaca, 2) . '</td>
                          <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_ing_depreciacion, 2) . '</td>
                          <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_ing_premio, 2) . '</td>
                            
                          <td align="right" style="font-weight:bold;" >$ ' . number_format($subtotal_area_ing_otros, 2) . '</td>
                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_total_ing, 2) . '</td>

                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_renta_final, 2) . '</td>
                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_afp, 2) . '</td>
                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_afp_patronal, 2) . '</td>
                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_ipsfa, 2) . '</td>
                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_ipsfa_patronal, 2) . '</td> 
                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_isss, 2) . '</td>
                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_isss_patronal, 2) . '</td>
                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_anticipo, 2) . '</td>
                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_prestamo_ban, 2) . '</td>';
                if ($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA') != 3) {
                    $tr_subtotalizacion .= '<td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_emi_fam, 2) . '</td>';
                }
                $tr_subtotalizacion .= '<td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_prestamos_int, 2) . '</td>
                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_des_otros, 2) . '</td>


                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_total_des, 2) . '</td>
                          <td align="right" style="font-weight:bold;">$ ' . number_format($subtotal_area_total_cancelar, 2) . '</td>
                          </tr>';
                if ($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA') != 3) {
                    $tr_subtotalizacion .= '<tr><td colspan="31"></td></tr>';
                } else {
                    $tr_subtotalizacion .= '<tr><td colspan="28"></td></tr>';
                }
            }



            $j++; //incrementar la variable de control de flujo de los registros

            if ($tipo == 'salario') {
                // Forma de pago de salario
                $cuenta_empleado = "";
                if ($empleado->emp_metodo_pago != "") {
                    if ($empleado->emp_metodo_pago == 1) {
                        $cuenta_empleado = trim($empleado->emp_numero_cuenta);
                    } elseif ($empleado->emp_metodo_pago == 2) {
                        $cuenta_empleado = '<span style="color:red;">Cheque</span>';
                    } elseif ($empleado->emp_metodo_pago == 3) {
                        $cuenta_empleado = '<span style="color:red;">Efectivo</span>';
                    }
                } else {
                    $cuenta_empleado = (trim($empleado->emp_numero_cuenta) != "") ? trim($empleado->emp_numero_cuenta) : '<span style="color:red;">Cheque</span>';
                }

                //CREAR LA CADENA DE TEXTO PARA EL ARCHIVO DE TEXTO. (.txt)
                if ($genera_archivo_txt) {
                    $nombre_empresa = utf8_decode($this->gsatelite->get_parametro('SYS_EMPRESA'));
                    $agregar_fila = true;
                    $nombre_completo = utf8_decode($empleado->emp_nombre) . ' ' . utf8_decode($empleado->emp_apellido);
                    $archivo_txt = "$empleado->emp_numero_cuenta" . " ; " .
                        "$nombre_completo" . " ;  ; " .
                        number_format($total, 2, '.', '') . "; " . "; " . "Nomina $nombre_empresa " . $registro_planilla[0]['pla_codigo'] . " ; " . " ";

                    if ($consolidado) { // preguntar si existe la variable que aplica para generar un consolidado
                        $con_num_cuenta = $consolidado[0]; // 1=solo con numero de cuenta, 0=sin numero, 3=ambos
                        $es_excel_consolidado = $consolidado[1];

                        if ($con_num_cuenta == 1) { // 1=solo con numero de cuenta
                            $agregar_fila = (trim($empleado->emp_numero_cuenta) != "") ? true : false;
                        } elseif ($con_num_cuenta == 0) { // 0=sin numero de cuenta
                            $agregar_fila = (trim($empleado->emp_numero_cuenta) == "") ? true : false;
                        } else { //si no ambos
                            $agregar_fila = true;
                        }

                        $agregar_fila = ($es_excel_consolidado == 1) ? false : $agregar_fila;
                    }

                    if ($agregar_fila and $total > 0) {
                        fputs($file_txt, $archivo_txt);
                        fputs($file_txt, chr(13) . chr(10));
                    }
                }

                //ir sub-totalizando areas por separado
                $fecha = date('d-m-Y', strtotime($empleado->emp_fecha_contrato));

                $des_isr = number_format($descuentos[$this->tdc_isr]->ddd_valor, 2);
                if ($des_isr > 0) {
                    $renta_final = $des_isr;
                } else if ($des_isr <= 0) {
                    $renta_final = number_format($descuentos[$this->tdc_isr_10p]->ddd_valor, 2);
                }

                if ($valor_ingresos > 0 or $valor_descuentos > 0) {
                    $k++;
                    $valor_clase = ($x) ? 'impar' : 'par';
                    $x = ($x) ? 0 : 1;

                    $detalle .= "
                            <tr class=\"" . $valor_clase . "\">
                            <td>" . $k . "</td>
                            <td>$empleado->are_nombre</td>
                            <td>$empleado->plz_nombre</td>
                            <td>&nbsp;" . $fecha . "</td>
                            <td>$empleado->dce_valor</td>  
                            <td>&nbsp;$empleado->emp_codigo</td>
                            <td>&nbsp;$cuenta_empleado</td>
                            <td  style=\"text-align:left;\" >&nbsp;&nbsp;$empleado->emp_apellido $empleado->emp_nombre </td>
                            <td align=\"right\">$ " . number_format($salario, 2) . "</td>
                            <td align=\"right\">$ " . number_format($comisiones, 2) . "</td>
                            <td align=\"right\">$ " . number_format($ingreso_anticipo_emi, 2) . "</td>
                            <td align=\"right\">$ " . number_format($vacaciones, 2) . "</td>
                            <td align=\"right\">$ " . number_format($ingreso_prima_vacacion, 2) . "</td>
                            <td align=\"right\" >$ " . number_format($ingreso_depreciacion, 2) . "</td>
                            <td align=\"right\">$ " . number_format($ingreso_premio, 2) . "</td>";

                    $detalle .= "<td align=\"right\">$" . number_format($otros_ingresos, 2) . "</td>";
                    if (intval($ipsfaid) == intval($afpeid)) {
                        $vipsfa = number_format($descuentos[$this->tdc_afp]->ddd_valor, 2);
                        $vafpnm = number_format(0, 2);
                        $pipsfa = number_format($descuentos[$this->tdc_afp]->ddd_valor_patronal, 2);
                        $vafpnp = number_format(0, 2);
                    } else {
                        $vipsfa = number_format(0, 2);
                        $vafpnm = number_format($descuentos[$this->tdc_afp]->ddd_valor, 2);
                        $pipsfa = number_format(0, 2);
                        $vafpnp = number_format($descuentos[$this->tdc_afp]->ddd_valor_patronal, 2);
                    }
                    $detalle .= "<td align=\"right\">$" . number_format($valor_ingresos, 2) . "</td>
                            <td align=\"right\">$" . $renta_final . "</td>
                            <td align=\"right\">$" . $vafpnm . "</td>
                            <td align=\"right\">$" . $vafpnp . "</td>
                            <td align=\"right\">$" . $vipsfa . "</td>
                            <td align=\"right\">$" . $pipsfa . "</td>                         
                            <td align=\"right\">$" . number_format($descuentos[$this->tdc_isss]->ddd_valor, 2) . "</td>
                            <td align=\"right\">$" . number_format($descuentos[$this->tdc_isss]->ddd_valor_patronal, 2) . "</td>
                            <td align=\"right\">$" . number_format($descuento_anticipo_emi, 2) . "</td>
                            <td align=\"right\">$" . number_format($descuento_prestamo_banco, 2) . "</td>";
                    if ($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA') != 3) {
                        $detalle .= "<td align=\"right\">$" . number_format($descuento_emi_familia, 2) . "</td>";
                    }
                    $detalle .= "<td align=\"right\">$" . number_format($descuento_prestamo_interno, 2) . "</td>
                         
                            <td align=\"right\">$" . number_format($otros_descuentos, 2) . "</td>
                            <td align=\"right\">$" . number_format($valor_descuentos, 2) . "</td>
                            <td align=\"right\" >$" . number_format($total, 2) . "</td>
                            </tr>
                            " . $tr_subtotalizacion;
                } else { // si el ultimo empleado no posee salario entonces solo imprimir la subtotalización del area
                    $detalle .= $tr_subtotalizacion;
                }
            }
        }
        //Totales
        if ($tipo == 'salario') {
            $consolidado_e = ($consolidado) ? $consolidado[1] : 0;
            if ($genera_archivo_txt and $consolidado_e == 0) {
                fclose($file_txt);
            }
            $para_consolidado_excel = $detalle;
            $detalle .= '
                <tr class="encabezado" >
                <td colspan="8"><b>Total planilla</b></td>
                <td  align="right" style="font-weight:bold;" >$ ' . number_format($total_salario_final, 2) . '</td>
                <td align="right" style="font-weight:bold;"  >$ ' . number_format($total_ing_comision, 2) . '</td>
                <td align="right" style="font-weight:bold;"  >$ ' . number_format($total_ing_anticipo, 2) . '</td>
                <td align="right" style="font-weight:bold;"  >$ ' . number_format($total_ing_vacacion, 2) . '</td>
                <td align="right" style="font-weight:bold;"  >$ ' . number_format($total_ing_prima_vaca, 2) . '</td>
                <td align="right" style="font-weight:bold;"  >$ ' . number_format($total_ing_depreciacion, 2) . '</td>
                <td align="right" style="font-weight:bold;"  >$ ' . number_format($total_ing_premio, 2) . '</td>
                <td align="right" style="font-weight:bold;"  >$ ' . number_format($total_ing_otros, 2) . '</td>
                <td align="right" style="font-weight:bold;"  >$ ' . number_format($total_ing_total, 2) . '</td>

                <td align="right" style="font-weight:bold;" >$' . number_format($renta_tlt, 2) . '</td>
                <td align="right" style="font-weight:bold;" >$' . number_format($afp, 2) . '</td>
                <td align="right" style="font-weight:bold;" >$' . number_format($afp_patronal, 2) . '</td>
                <td align="right" style="font-weight:bold;" >$' . number_format($ipsfa, 2) . /**/ '</td>
                <td align="right" style="font-weight:bold;" >$' . number_format($ipsfa_patronal, 2) . '</td>
                <td align="right" style="font-weight:bold;" >$' . number_format($isss, 2) . '</td>
                <td align="right" style="font-weight:bold;" >$' . number_format($isss_patronal, 2) . '</td>
               
                <td align="right" style="font-weight:bold;" >$' . number_format($total_des_anticipo, 2) . '</td>
                <td align="right" style="font-weight:bold;" >$' . number_format($total_des_prestamo_ban, 2) . '</td>';
            if ($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA') != 3) {
                $detalle .= '<td align="right" style="font-weight:bold;" >$' . number_format($total_des_emi_fam, 2) . '</td>';
            }
            $detalle .= '<td align="right" style="font-weight:bold;" >$' . number_format($total_des_prestamos_int, 2) . '</td>
                <td align="right" style="font-weight:bold;" >$' . number_format($des_otros, 2) . '</td>
                <td align="right" style="font-weight:bold;" >$' . number_format($des_total, 2) . '</td>
                <td align="right" style="font-weight:bold;" >$' . number_format($cancelar, 2) . '</td>
                </tr>';

            //consolidado en excel
            if ($consolidado) {
                $es_excel_consolidado = $consolidado[1];
                $data['es_consolidado_excel'] = $consolidado[1];
                if ($es_excel_consolidado) {
                    $titulo_pla = '<b>PLANILLA CORRESPONDIENTE AL PERIODO ' . $registro_planilla[0]['pla_fecha_inicio'] . ' AL  ' . $registro_planilla[0]['pla_fecha_fin'] . '</b>';
                    $html_excel_consolidado = '<tr><td colspan="28">' . $titulo_pla . '</td></tr>' . $para_consolidado_excel;
                    $totales_planilla = array(
                        't1' => $total_salario_final, 
                        't2' => $total_ing_comision, 
                        't3' => $total_ing_anticipo, 
                        't4' => $total_ing_vacacion, 
                        't5' => $total_ing_prima_vaca, 
                        't6' => $total_ing_depreciacion, 
                        't7' => $total_ing_premio, 
                        't8' => $total_ing_otros, 
                        't9' => $total_ing_total, 
                        't10' => $renta, 
                        't11' => $afp, 
                        't12' => $isss, 
                        't13' => $total_des_anticipo, 
                        't14' => $total_des_prestamo_ban, 
                        't15' => $total_des_emi_fam, 
                        't16' => $total_des_prestamos_int, 
                        't17' => $des_otros, 
                        't18' => $des_total, 
                        't19' => $cancelar, 
                        't20' => $afp_patronal, 
                        't21' => $isss_patronal
                    );
                    return array($html_excel_consolidado, $totales_planilla);
                }
            }
        }
        $data['tipo'] = $tipo;
        $data['detalle_planilla'] = $detalle;
        $data['titulo'] = "Planilla";
        $data['registro_planilla'] = $registro_planilla;
        $data['usuario'] = $usuario;
        $html = "";
        if ($sin_header == null) {
            $html .= $thml = $this->load->view('personal/planilla/header_simple', array('titulo' => 'Planilla'), true);
        }
        $html .= $this->load->view('personal/planilla/pla_print_emi', $data, true);

        if ($genera_archivo_txt) {
            if (file_exists("uploads/txt_planilla/datos_planilla.txt")) {
                return true;
            }
        } else {
            if ($recalculo == 1) {
                $subtotal = array(
                    'planilla' => $planilla->pla_id,
                    'total_ing' => number_format($subtotal_area_total_ing, 2),
                    'total_afp' => number_format($subtotal_area_des_afp, 2),
                    'total_isss' => number_format($subtotal_area_des_isss, 2),
                    'renta' => $renta_final,
                    'salario' => $salario
                );
                return $subtotal;
            } else {
                return $html;
            }
        }
    }

    /**
     * @author Edith Herrera
     * @return planilla estructura de planilla  bnk
     * genera_archivo_txt (boolean) = bandera para indicar si se trata de la generación del archivo txt
     * consolidado (array) = datos para indicar si se trata de un consolidado de varias planillas. 
     *
     */
    function print_planilla_bnk($planilla_id, $usuario = null, $tipo = null, $sin_header = null, $genera_archivo_txt = false, $consolidado = null, $cantidad = 0)
    {
        //preguntar si hay planillas migradas
        //preguntar por las planillas migradas para omitir esta operación. mediante un parametro
        $planilla_migradas = $this->gsatelite->get_parametro('PLANILLAS_MIGRADAS');
        $id_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $ids_migra = array();
        if ($planilla_migradas != "") {
            $ids_migra = explode(',', $planilla_migradas);
        }
        // DATOS DE LA PLANILLA
        $registro_planilla = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $planilla_id));
        //planilla
        $this->db->join($this->tipo_planillas, 'pla_id_tpl = tpl_id');
        $planilla = $this->db->get_where($this->planillas, array('pla_id' => $planilla_id), 1)->row();

        $this->db->select('
                  emp_empleado.emp_id,
                  emp_empleado.emp_codigo,
                  emp_empleado.emp_nombre,
                  emp_empleado.emp_apellido,
                  emp_empleado.emp_salario,
                  emp_empleado.emp_fecha_contrato,
                  emp_empleado.emp_numero_cuenta,
                  emp_empleado.emp_seguro,
                  emp_empleado.emp_metodo_pago,
                  plz_plaza.plz_nombre,
                  dce_valor,
                  are_nombre,
                  are_id,
                  (SELECT SUM(ddi_detalle_ingreso.ddi_valor) FROM ddi_detalle_ingreso
                    WHERE
                    ddi_detalle_ingreso.ddi_id_emp = emp_empleado.emp_id AND
                    ddi_detalle_ingreso.ddi_id_pla = ' . $planilla->pla_id . '
                    GROUP BY
                    ddi_detalle_ingreso.ddi_id_emp, ddi_detalle_ingreso.ddi_id_pla ) AS ingresos,
                (SELECT SUM(ddd_detalle_descuento.ddd_valor) FROM ddd_detalle_descuento
                    WHERE
                    ddd_detalle_descuento.ddd_id_emp = emp_empleado.emp_id AND
                    ddd_detalle_descuento.ddd_id_pla = ' . $planilla->pla_id . '
                    GROUP BY
                    ddd_detalle_descuento.ddd_id_emp, ddd_detalle_descuento.ddd_id_pla ) AS
                descuentos
                ');
        // Added by Melbin
        $this->db->join('dce_documento_emp', "dce_documento_emp.dce_id_emp = emp_empleado.emp_id AND dce_id_tde = $id_nit", 'left');

        if (in_array($planilla_id, $ids_migra)) {
            $this->db->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left');
            $this->db->join('are_area', 'are_id=emp_id_are', 'left');
            $this->db->join('txe_tipo_planillaxempleado', 'txe_id_emp=emp_id', 'left');
        } else {
            $this->db->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left');
            $this->db->join('are_area', 'are_id=emp_id_are', 'left');
            $this->db->join('txe_tipo_planillaxempleado', 'txe_id_emp=emp_id');
            $this->db->where('txe_id_tpl', $planilla->pla_id_tpl);
        }

        $this->db->group_by('emp_empleado.emp_id');
        $this->db->order_by('are_id', 'ASC');
        $this->db->order_by('emp_apellido', 'ASC');
        $empleados = $this->db->get($this->empleados)->result();
        // var_dump($this->gsatelite->get_parametro('SYS_NUM_REF_BANCO'));die();
        //id del tipo de ingreso para indemnización
        $id_ting_indemnizacion = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION');
        $id_ting_aguinaldo = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');
        //Detalle de la planilla
        $detalle = '';
        $i = 1;
        $renta_10p = $renta = $isss = $afp = $des_otros = $des_total = $cancelar = $horas_extras_diu = $horas_extras_noc = $total_vacaciones = $total_comision = 0;
        $total_aguinaldo = 0;
        $total_indemnizacion = 0;

        $x = 1; //bandera que controla la clase de los tr
        //id del are que sera un bandera para hacer la totalizacion por separado por area
        //asignar la primera area correspondiente
        $id_area_inicial = (count($empleados) > 0) ? $empleados[0]->are_id : 0;
        //variables para la subtotalizacio por areas y total final

        $subtotal_area_salario = 0; //variable para ir subtotalizando el salario por area
        $subtotal_area_total_ing = 0;

        $subtotal_area_total_des = 0;
        $subtotal_area_total_cancelar = 0;

        //totalizacion de los ingresos   
        $subtotal_area_des_comision = 0;
        $total_ing_comision = 0;
        $subtotal_area_ing_anticipo = 0;
        $total_ing_anticipo = 0;
        $subtotal_area_ing_premio = 0;
        $total_ing_premio = 0;
        $subtotal_area_ing_vacacion = 0;
        $total_ing_vacacion = 0;
        $subtotal_area_ing_prima_vaca = 0;
        $total_ing_prima_vaca = 0;
        $subtotal_area_ing_depreciacion = 0;
        $total_ing_depreciacion = 0;
        $subtotal_area_ing_otros = 0;
        $total_ing_otros = 0;
        $total_ing_total = 0;

        //totalizacion de los descuentos por area y final   
        $subtotal_area_des_renta = 0;
        $subtotal_area_des_afp = 0;
        $subtotal_area_des_afp_patronal = 0;
        $subtotal_area_des_isss = 0;
        $subtotal_area_des_isss_patronal = 0;
        $subtotal_area_des_anticipo = 0;
        $total_des_anticipo = 0;
        $subtotal_area_des_prestamo_ban = 0;
        $total_des_prestamo_ban = 0;
        $subtotal_area_des_emi_fam = 0;
        $total_des_emi_fam = 0;
        $subtotal_area_des_prestamos_int = 0;
        $total_des_prestamos_int = 0;
        $subtotal_area_des_otros = 0;


        $j = 0; //variable para controlar el tr del subtotal
        //variables de totalización.
        $total_salario_final = 0;

        //die(print_r($consolidado[1]).print_r($cantidad));
        if ($genera_archivo_txt) {
            $consolidado_e = ($consolidado) ? $consolidado[1] : 0;
            if ($consolidado_e == 0) { //que no se trate de un consolidado en excel  
                if (file_exists("uploads/txt_planilla/datos_planilla.txt")) {
                    unlink("uploads/txt_planilla/datos_planilla.txt"); //eliminar el archivo si existiese
                }
                $file_txt = fopen("uploads/txt_planilla/datos_planilla.txt", "w") or die("Problemas en creación del archivo");
            }
        }
        $array_sueldo = array();
        foreach ($empleados as $empleado) {
            $horas_extras_diu = 0;
            $horas_extras_noc = 0;
            $descuentos = array();

            $valor_descuentos = 0;
            foreach ($this->get_descuentos_pla_emp($planilla, $empleado) as $row) {
                //  print_r($this->db->last_query()); exit;
                $descuentos[$row->tdc_id] = $row;
                $valor_descuentos += $row->{'ddd_valor'};
            }

            $ingresos = array();
            $valor_ingresos = 0;

            foreach ($this->get_ingresos_pla_emp($planilla, $empleado) as $row) {
                #print_r($this->db->last_query()); exit;
                $ingresos[$row->tig_id] = $row;
                $valor_ingresos += $row->{'ddi_valor'};
            }

            //por el momento estas variables no se utilizan

            $hed = $ingresos[$this->tig_hed]->ddi_valor;
            $hen = $ingresos[$this->tig_hen]->ddi_valor;
            $comisiones = $ingresos[$this->tig_comision]->ddi_valor;
            $total_comision += $comisiones;
            $vacaciones = $ingresos[$this->tig_vacacion]->ddi_valor;
            //  $salario = $empleado->emp_salario / $planilla->tpl_cantidad;
            // $salario =   $ingresos[$this->tig_salario]->ddi_valor/ $planilla->tpl_cantidad ;
            $salario = $ingresos[$this->tig_salario]->ddi_valor;
            $suma_ingresosIng = $comisiones + $vacaciones;
            $otros_ingresos = $valor_ingresos - ($salario) - $suma_ingresosIng;
            //$otros_ingresos = $valor_ingresos - ($salario)-$hed-$hen-$comisiones-$vacaciones-$ingreso_anticipo_emi-$ingreso_depreciacion-$ingreso_premio;
            //ALMACENAR LOS VALORES EN VARIABLES
            $descuento_prestamo_interno = $descuentos[$id_descuento_prestamo_interno]->ddd_valor;

            //$suma_descuentos_emi = $descuento_prestamo_banco + $descuento_emi_familia + $descuento_prestamo_interno;
            $bonificaciones = $ingresos[$this->tig_bonificacion]->ddi_valor;
            $viaticos = $ingresos[$this->tig_viatico]->ddi_valor;
            $suma_de_descuentos = $descuentos[$this->tdc_isr]->ddd_valor + $descuentos[$this->tdc_afp]->ddd_valor + $descuentos[$this->tdc_isss]->ddd_valor + $suma_descuentos_emi;
            $otros_descuentos = round($valor_descuentos, 2) - round($suma_de_descuentos, 2);
            $total = $valor_ingresos - $valor_descuentos;

            //descuentos
            $renta += $descuentos[$this->tdc_isr]->ddd_valor;

            $afp += $descuentos[$this->tdc_afp]->ddd_valor;
            $afp_patronal += $descuentos[$this->tdc_afp]->ddd_valor_patronal;
            $isss += $descuentos[$this->tdc_isss]->ddd_valor;
            $isss_patronal += $descuentos[$this->tdc_isss]->ddd_valor_patronal;
            $des_otros += $otros_descuentos;
            $des_total += $valor_descuentos;
            //totales
            $cancelar += $total;
            $total_bonificacion += $bonificaciones;
            $horas_extras_diu += $hed;
            $horas_extras_noc += $hen;
            $total_vacaciones += $vacaciones;

            //planilla indemnizacion
            $indemnizacion = $ingresos[$id_ting_indemnizacion]->ddi_valor;
            $total_indemnizacion += $indemnizacion;

            //planilla comisiones (renta es la misma)
            $renta_10p += $descuentos[$this->tdc_isr_10p]->ddd_valor;

            //planilla aguinaldo (renta es la misma)
            $aguinaldo = $ingresos[$id_ting_aguinaldo]->ddi_valor;
            $total_aguinaldo += $aguinaldo;


            if ($x) {
                $valor = "impar";
                $x = 0;
            } else {
                $valor = "par";
                $x = 1;
            }
            $total_salario_final += $salario;
            $total_cancelar += $total;
            //DATOS PARA ARCHIVO TXT
            //ONTIENE LA PREFERENCIA SYS_NUM_REF_BANCO
            $num_ref = json_decode($this->gsatelite->get_parametro('SYS_NUM_REF_BANCO'));
            //print_r($num_ref->REF1_BCO_SCOT);die();
            //$fijo1 = '10220860001';
            if (isset($num_ref->REF1_BCO_SCOT)) {
                if ($num_ref->REF1_BCO_SCOT != '') {
                    $fijo1 = $num_ref->REF1_BCO_SCOT;
                } else {
                    $fijo1 = '10220860001'; //SI EL PARAMETRO ES VACIO SE DEJA FIJO EL NUMERO
                }
            } else {
                $fijo1 = '10220860001';
            }
            //NÚMERO DE CUENTA
            $num_cub = $empleado->emp_numero_cuenta;
            $cantidad_car = strlen($num_cub);
            if ($cantidad_car > 8) {
                $cuenta = substr($num_cub, 0, 8);
            } else {
                $cuenta1 = ereg_replace("[-]", "", $num_cub);
                $long_cad = 8;
                $cuenta = str_pad($cuenta1, $long_cad, '0', STR_PAD_LEFT);
            }

            // FECHA GENERACIÓN
            $fecha = date('Y-m-d');
            $var = explode('-', $fecha);
            $periodo = $var[0] . $var[1] . $var[2];

            //NÚMERO DE AFILIACIÓN
            $cod = $empleado->emp_codigo;
            $newcode = ereg_replace("[-]", "", $cod);
            $long_codigo = 4;
            $codigo = str_pad($newcode, $long_codigo, '0', STR_PAD_LEFT);


            //SUELDO
            $total_format = number_format($total, 2);
            $su = explode('.', $total_format);

            $posicion_coincidencia = strpos($su[0], ',');
            if ($posicion_coincidencia == true) {
                $sin_coma = explode(',', $su[0]);
                //$sin_coma = strtr($su[0],',',"");
                $su[0] = $sin_coma[0] . $sin_coma[1];
            }

            $sueldo = $su[0] . $su[1];
            $salario_final = str_pad($sueldo, 9, '0', STR_PAD_LEFT);

            //CODIGO OBSERVACION
            $codigo_o = 3;

            $espacio = str_pad($codigo_o, 12, ' ', STR_PAD_LEFT);

            $j++; //incrementar la variable de control de flujo de los registros

            if ($tipo == 'salario') {
                // Forma de pago de salario
                $cuenta_empleado = "";
                if ($empleado->emp_metodo_pago != "") {
                    if ($empleado->emp_metodo_pago == 1) {
                        $cuenta_empleado = trim($empleado->emp_numero_cuenta);
                    } elseif ($empleado->emp_metodo_pago == 2) {
                        $cuenta_empleado = '<span style="color:red;">Cheque</span>';
                    } elseif ($empleado->emp_metodo_pago == 3) {
                        $cuenta_empleado = '<span style="color:red;">Efectivo</span>';
                    }
                } else {
                    $cuenta_empleado = (trim($empleado->emp_numero_cuenta) != "") ? trim($empleado->emp_numero_cuenta) : '<span style="color:red;">Cheque</span>';
                }

                //CREAR LA CADENA DE TEXTO PARA EL ARCHIVO DE TEXTO. (.txt)
                if ($genera_archivo_txt) {
                    $agregar_fila = true;
                    $cod = str_pad($codigo, 20, ' ', STR_PAD_LEFT);
                    $archivo_txt = $fijo1 . '            ' . $cuenta . $periodo . $salario_final . $cod;


                    if ($consolidado) { // preguntar si existe la variable que aplica para generar un consolidado
                        $con_num_cuenta = $consolidado[0]; // 1=solo con numero de cuenta, 0=sin numero, 3=ambos
                        $es_excel_consolidado = $consolidado[1];

                        if ($con_num_cuenta == 1) { // 1=solo con numero de cuenta
                            $agregar_fila = (trim($empleado->emp_numero_cuenta) != "") ? true : false;
                        } elseif ($con_num_cuenta == 0) { // 0=sin numero de cuenta
                            $agregar_fila = (trim($empleado->emp_numero_cuenta) == "") ? true : false;
                        } else { //si no ambos
                            $agregar_fila = true;
                        }
                        $agregar_fila = ($es_excel_consolidado == 1) ? false : $agregar_fila;
                    }

                    if ($agregar_fila == true and $total > 0) {
                        // die(print_r($archivo_txt));
                        fputs($file_txt, $archivo_txt);
                        fputs($file_txt, chr(13) . chr(10));
                        $sum_sueldo += $total; //suma de sueldos por planilla, según registros agregados al txt.
                    }
                }
            }



            $i++;
        }

        //$fijo2 = '20220860001';
        if (isset($num_ref->REF2_BCO_SCOT)) {
            if ($num_ref->REF2_BCO_SCOT != '') {
                $fijo2 = $num_ref->REF2_BCO_SCOT;
            } else {
                $fijo2 = '20220860001'; //SI EL PARAMETRO ES VACIO SE DEJA FIJO EL NUMERO
            }
        } else {
            $fijo2 = '20220860001'; // SI EL PARAMETRO NO EXISTE SE DEJA FIJO EL NUMERO
        }

        // TOTAL SUELDO 
        $su = explode('.', $total_cancelar);
        $sueldo = $su[0] . $su[1];
        $suma_salario = str_pad($sueldo, 9, '0', STR_PAD_LEFT);
        $cuenta_emp = $this->gsatelite->get_parametro('CUENTA_EMPRESA');
        $archivo_txt = $fijo2 . '          ' . $cuenta_emp . $periodo . $suma_salario . $dia . $hora;
        if ($agregar_fila && $consolidado == null) {
            fputs($file_txt, $archivo_txt);
            fputs($file_txt, chr(13) . chr(10));
        }


        if ($consolidado) {
            $es_excel_consolidado = $consolidado[1];
            $data['es_consolidado_excel'] = $consolidado[1];
            if ($es_excel_consolidado) {

                return $html_excel_consolidado;
            } else {

                if ($con_num_cuenta == 1) { // 1=solo con numero de cuenta
                    $sueldo = $total;
                } elseif ($con_num_cuenta == 0) { // 0=sin numero de cuenta
                    $sueldo = $total;
                } else { //si no ambos
                    $sueldo = $total;
                }
                $ultima_linea = array(
                    'fijo' => $fijo2, 'espacio' => $espacio, 'cuenta' => $cuenta_emp, 'periodo' => $periodo, 'salario_planilla' => $suma_salario, 'dia' => $dia, 'hora' => $hora
                );


                return array('total' => $cancelar, $ultima_linea, $sum_sueldo);
            }
        }

        $data['tipo'] = $tipo;
        $data['detalle_planilla'] = $detalle;
        $data['titulo'] = "Planilla";
        $data['registro_planilla'] = $registro_planilla;
        $data['usuario'] = $usuario;
        $html = "";
        if ($sin_header == null) {
            $html .= $thml = $this->load->view('personal/planilla/header_simple', array('titulo' => 'Planilla'), true);
        }
        // $html .= $this->load->view('personal/planilla/pla_print_emi', $data, true); 
        if ($genera_archivo_txt) {
            if (file_exists("uploads/txt_planilla/datos_planilla.txt")) {
                return true;
            }
        } else {
            return $html;
        }
    }

    /**
     * @author Edith Herrera
     * @return planilla estructura de planilla  isss
     */
    function print_planilla_isss($planilla_id, $usuario = null, $tipo = null, $sin_header = null, $genera_archivo_txt = false, $consolidado = null)
    {
        $id_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');

        $registro_planilla = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $planilla_id));
        //planilla
        $this->db->join($this->tipo_planillas, 'pla_id_tpl = tpl_id');
        $planilla = $this->db->get_where($this->planillas, array('pla_id' => $planilla_id), 1)->row();

        $this->db->select('
                  emp_empleado.emp_id,
                  emp_empleado.emp_codigo,
                  emp_empleado.emp_apellido,
                  emp_empleado.emp_nombre,
                  emp_empleado.emp_salario,
                  emp_empleado.emp_fecha_contrato,
                  emp_empleado.emp_numero_cuenta,
                  emp_empleado.emp_seguro,
                  emp_empleado.emp_metodo_pago,
                  plz_plaza.plz_nombre,
                  dce_valor,
                  are_nombre,
                  are_id,
                  (Select
                    Sum(ddi_detalle_ingreso.ddi_valor)
                    From
                    ddi_detalle_ingreso
                    Where
                    ddi_detalle_ingreso.ddi_id_emp = emp_empleado.emp_id And
                    ddi_detalle_ingreso.ddi_id_pla = ' . $planilla->pla_id . '
                    Group By
                    ddi_detalle_ingreso.ddi_id_emp, ddi_detalle_ingreso.ddi_id_pla ) As ingresos,
                (Select
                    Sum(ddd_detalle_descuento.ddd_valor)
                    From
                    ddd_detalle_descuento
                    Where
                    ddd_detalle_descuento.ddd_id_emp = emp_empleado.emp_id And
                    ddd_detalle_descuento.ddd_id_pla = ' . $planilla->pla_id . '
                    Group By
                    ddd_detalle_descuento.ddd_id_emp, ddd_detalle_descuento.ddd_id_pla ) As
                descuentos
                ');



        // Added by Melbin
        $this->db->join('dce_documento_emp', "dce_documento_emp.dce_id_emp = emp_empleado.emp_id and dce_id_tde=$id_nit", 'left');

        $this->db->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left');
        $this->db->join('are_area', 'are_id=emp_id_are', 'left');
        $this->db->join('txe_tipo_planillaxempleado', 'txe_id_emp=emp_id');
        $this->db->where('txe_id_tpl', $planilla->pla_id_tpl);
        $this->db->where('emp_aplica_isss', 1); //AGREGAR QUE SOLO BUSQUE LOS QUE APLIQUE ISSS



        $this->db->group_by('emp_empleado.emp_id');
        $this->db->order_by('are_id', 'asc');
        $this->db->order_by('emp_apellido', 'asc');
        $empleados = $this->db->get($this->empleados)->result();
        // die($this->db->last_query()); 
        //id del tipo de ingreso para indemnización
        $id_ting_indemnizacion = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION');
        $id_ting_aguinaldo = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');


        //Detalle de la planilla
        $detalle = '';
        $i = 1;
        $renta_10p = $renta = $isss = $afp = $des_otros = $des_total = $cancelar = $horas_extras_diu = $horas_extras_noc = $total_vacaciones = $total_comision = 0;
        $total_aguinaldo = 0;
        $total_indemnizacion = 0;

        $x = 1; //bandera que controla la clase de los tr
        //id del are que sera un bandera para hacer la totalizacion por separado por area
        //asignar la primera area correspondiente
        $id_area_inicial = (count($empleados) > 0) ? $empleados[0]->are_id : 0;
        //variables para la subtotalizacio por areas y total final

        $subtotal_area_salario = 0; //variable para ir subtotalizando el salario por area
        $subtotal_area_total_ing = 0;

        $subtotal_area_total_des = 0;
        $subtotal_area_total_cancelar = 0;

        //totalizacion de los ingresos   
        $subtotal_area_des_comision = 0;
        $total_ing_comision = 0;
        $subtotal_area_ing_anticipo = 0;
        $total_ing_anticipo = 0;
        $subtotal_area_ing_premio = 0;
        $total_ing_premio = 0;
        $subtotal_area_ing_vacacion = 0;
        $total_ing_vacacion = 0;
        $subtotal_area_ing_prima_vaca = 0;
        $total_ing_prima_vaca = 0;
        $subtotal_area_ing_depreciacion = 0;
        $total_ing_depreciacion = 0;
        $subtotal_area_ing_otros = 0;
        $total_ing_otros = 0;
        $total_ing_total = 0;

        //totalizacion de los descuentos por area y final   
        $subtotal_area_des_renta = 0;
        $subtotal_area_des_afp = 0;
        $subtotal_area_des_afp_patronal = 0;
        $subtotal_area_des_isss = 0;
        $subtotal_area_des_isss_patronal = 0;
        $subtotal_area_des_anticipo = 0;
        $total_des_anticipo = 0;
        $subtotal_area_des_prestamo_ban = 0;
        $total_des_prestamo_ban = 0;
        $subtotal_area_des_emi_fam = 0;
        $total_des_emi_fam = 0;
        $subtotal_area_des_prestamos_int = 0;
        $total_des_prestamos_int = 0;
        $subtotal_area_des_otros = 0;


        $j = 0; //variable para controlar el tr del subtotal
        //variables de totalización.
        $total_salario_final = 0;


        if ($genera_archivo_txt) {
            $consolidado_e = ($consolidado) ? $consolidado[1] : 0;
            if ($consolidado_e == 0) { //que no se trate de un consolidado en excel  
                if (file_exists("uploads/txt_planilla/datos_planilla.txt")) {
                    unlink("uploads/txt_planilla/datos_planilla.txt"); //eliminar el archivo si existiese
                }
                $file_txt = fopen("uploads/txt_planilla/datos_planilla.txt", "w") or die("Problemas en creación del archivo");
            }
        }

        foreach ($empleados as $empleado) {
            $horas_extras_diu = 0;
            $horas_extras_noc = 0;
            $descuentos = array();

            $valor_descuentos = 0;
            foreach ($this->get_descuentos_pla_emp($planilla, $empleado) as $row) {
                //  print_r($this->db->last_query()); exit;
                $descuentos[$row->tdc_id] = $row;
                $valor_descuentos += $row->{'ddd_valor'};
            }

            $ingresos = array();
            $valor_ingresos = 0;

            foreach ($this->get_ingresos_pla_emp($planilla, $empleado) as $row) {
                #print_r($this->db->last_query()); exit;
                $ingresos[$row->tig_id] = $row;
                $valor_ingresos += $row->{'ddi_valor'};
            }

            //por el momento estas variables no se utilizan
            $hed = $ingresos[$this->tig_hed]->ddi_valor;
            $hen = $ingresos[$this->tig_hen]->ddi_valor;
            $comisiones = $ingresos[$this->tig_comision]->ddi_valor;
            $total_comision += $comisiones;
            $vacaciones = $ingresos[$this->tig_vacacion]->ddi_valor;
            //  $salario = $empleado->emp_salario / $planilla->tpl_cantidad;
            // $salario =   $ingresos[$this->tig_salario]->ddi_valor/ $planilla->tpl_cantidad ;
            $salario = $ingresos[$this->tig_salario]->ddi_valor;
            $suma_ingresosIng = $comisiones + $vacaciones;
            $otros_ingresos = $valor_ingresos - ($salario) - $suma_ingresosIng;
            //$otros_ingresos = $valor_ingresos - ($salario)-$hed-$hen-$comisiones-$vacaciones-$ingreso_anticipo_emi-$ingreso_depreciacion-$ingreso_premio;
            //ALMACENAR LOS VALORES EN VARIABLES
            $descuento_prestamo_interno = $descuentos[$id_descuento_prestamo_interno]->ddd_valor;

            //$suma_descuentos_emi = $descuento_prestamo_banco + $descuento_emi_familia + $descuento_prestamo_interno;
            $bonificaciones = $ingresos[$this->tig_bonificacion]->ddi_valor;
            $viaticos = $ingresos[$this->tig_viatico]->ddi_valor;
            $suma_de_descuentos = $descuentos[$this->tdc_isr]->ddd_valor + $descuentos[$this->tdc_afp]->ddd_valor + $descuentos[$this->tdc_isss]->ddd_valor + $suma_descuentos_emi;
            $otros_descuentos = round($valor_descuentos, 2) - round($suma_de_descuentos, 2);
            $total = $valor_ingresos - $valor_descuentos;

            //descuentos
            $renta += $descuentos[$this->tdc_isr]->ddd_valor;

            $afp += $descuentos[$this->tdc_afp]->ddd_valor;
            $afp_patronal += $descuentos[$this->tdc_afp]->ddd_valor_patronal;
            $isss += $descuentos[$this->tdc_isss]->ddd_valor;
            $isss_patronal += $descuentos[$this->tdc_isss]->ddd_valor_patronal;
            $des_otros += $otros_descuentos;
            $des_total += $valor_descuentos;
            //totales
            $cancelar += $total;
            $total_bonificacion += $bonificaciones;
            $horas_extras_diu += $hed;
            $horas_extras_noc += $hen;
            $total_vacaciones += $vacaciones;

            //planilla indemnizacion
            $indemnizacion = $ingresos[$id_ting_indemnizacion]->ddi_valor;
            $total_indemnizacion += $indemnizacion;

            //planilla comisiones (renta es la misma)
            $renta_10p += $descuentos[$this->tdc_isr_10p]->ddd_valor;

            //planilla aguinaldo (renta es la misma)
            $aguinaldo = $ingresos[$id_ting_aguinaldo]->ddi_valor;
            $total_aguinaldo += $aguinaldo;

            if ($x) {
                $valor = "impar";
                $x = 0;
            } else {
                $valor = "par";
                $x = 1;
            }
            $total_salario_final += $salario;

            // //totalizacion de los ingresos   
            // $total_ing_comision += $comisiones; 
            // $total_ing_vacacion += $vacaciones;  
            // $total_ing_otros += $otros_ingresos;
            // $total_ing_total += $valor_ingresos;
            //DATOS PARA ARCHIVO TXT


            $numero_patronal = $this->gsatelite->get_parametro('SYS_ISSS_PATRONAL');
            $fecha = $planilla->pla_fecha_inicio;
            $var = explode('-', $fecha);
            $periodo = $var[0] . $var[1];
            $correlativo = '001';

            //NÚMERO DE AFILIACIÓN
            $numero = $empleado->emp_seguro;
            $nuevo_num = ereg_replace("[-]", "", $numero);
            $longitud = 9;
            $numero_afi = str_pad($nuevo_num, $longitud, '0', STR_PAD_LEFT);

            //NOMBRE DEL EMPLEADO
            $nomb = $empleado->emp_apellido . ' ' . $empleado->emp_nombre;
            $nombre = utf8_decode($nomb);
            $long = 40;
            $empleado = str_pad($nombre, 40);

            //SUELDO
            $su = explode('.', $salario);
            $sueldo = $su[0] . $su[1];
            $salario_final = str_pad($sueldo, $longitud, '0', STR_PAD_LEFT);

            //INGRESOS SIN SUELDO
            $pago = $vacaciones + $bonificaciones + $hed + $hen;

            $conv = number_format($pago, 2, '.', '');
            $pg = explode('.', $conv);
            $pago_a = $pg[0] . $pg[1];
            $pago_adicional = str_pad($pago_a, $longitud, '0', STR_PAD_LEFT);

            //MONTO DE VACACIÓN
            $vn = (explode('.', $vacaciones));
            $monto_v = $vn[0] . $vn[1];
            $monto_vacacion = str_pad($monto_v, $longitud, '0', STR_PAD_LEFT);

            $lg = 2;

            //DIAS TRANSCURRIDOS
            $dias_m = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES');
            $dias_mes = str_pad($dias_m, $lg, '0', STR_PAD_LEFT);
            //HORAS POR DIA
            $horas_d = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA');
            $horas_dia = str_pad($horas_d, $lg, '0', STR_PAD_LEFT);

            //DIAS VACACION
            $dias_v = 00;
            $dias_vacacion = str_pad($dias_v, $lg, '0', STR_PAD_LEFT);

            //CODIGO OBSERVACION
            $codigo_o = 00;
            $codigo_obs = str_pad($codigo_o, $lg, '0', STR_PAD_LEFT);

            $j++; //incrementar la variable de control de flujo de los registros

            if ($tipo == 'salario') {
                // Forma de pago de salario
                $cuenta_empleado = "";
                if ($empleado->emp_metodo_pago != "") {
                    if ($empleado->emp_metodo_pago == 1) {
                        $cuenta_empleado = trim($empleado->emp_numero_cuenta);
                    } elseif ($empleado->emp_metodo_pago == 2) {
                        $cuenta_empleado = '<span style="color:red;">Cheque</span>';
                    } elseif ($empleado->emp_metodo_pago == 3) {
                        $cuenta_empleado = '<span style="color:red;">Efectivo</span>';
                    }
                } else {
                    $cuenta_empleado = (trim($empleado->emp_numero_cuenta) != "") ? trim($empleado->emp_numero_cuenta) : '<span style="color:red;">Cheque</span>';
                }

                //CREAR LA CADENA DE TEXTO PARA EL ARCHIVO DE TEXTO. (.txt)
                if ($genera_archivo_txt) {
                    $agregar_fila = true;
                    $archivo_txt = $numero_patronal . $periodo . $correlativo . $numero_afi .
                        $empleado . $salario_final . $pago_adicional . $monto_vacacion .
                        $dias_mes . $horas_dia . $dias_vacacion . $codigo_obs;

                    //echo $numero_patronal . $periodo . $correlativo . $numero_afi; die();

                    if ($consolidado) { // preguntar si existe la variable que aplica para generar un consolidado
                        $con_num_cuenta = $consolidado[0]; // 1=solo con numero de cuenta, 0=sin numero, 3=ambos
                        $es_excel_consolidado = $consolidado[1];

                        if ($con_num_cuenta == 1) { // 1=solo con numero de cuenta
                            $agregar_fila = (trim($empleado->emp_numero_cuenta) != "") ? true : false;
                        } elseif ($con_num_cuenta == 0) { // 0=sin numero de cuenta
                            $agregar_fila = (trim($empleado->emp_numero_cuenta) == "") ? true : false;
                        } else { //si no ambos
                            $agregar_fila = true;
                        }
                        $agregar_fila = ($es_excel_consolidado == 1) ? false : $agregar_fila;
                    }

                    if ($agregar_fila and $total > 0) {
                        fputs($file_txt, $archivo_txt);
                        fputs($file_txt, chr(13) . chr(10));
                    }
                }
            }
            $i++;
        }

        $data['tipo'] = $tipo;
        $data['detalle_planilla'] = $detalle;
        $data['titulo'] = "Planilla";
        $data['registro_planilla'] = $registro_planilla;
        $data['usuario'] = $usuario;
        $html = "";
        if ($sin_header == null) {
            $html .= $thml = $this->load->view('personal/planilla/header_simple', array('titulo' => 'Planilla'), true);
        }
        // $html .= $this->load->view('personal/planilla/pla_print_emi', $data, true); 
        if ($genera_archivo_txt) {
            if (file_exists("uploads/txt_planilla/datos_planilla.txt")) {
                return true;
            }
        } else {
            return $html;
        }
    }

    protected function get_ingresos_pla_emp($planilla, $empleado)
    {

        $this->db->select('
                  tig_tipo_ingreso.tig_id,
                  tig_tipo_ingreso.tig_nombre,
                  Sum(ddi_detalle_ingreso.ddi_valor) As ddi_valor,
                  ddi_detalle_ingreso.ddi_dias 
                  ');
        $this->db->join($this->tipo_ingresos, 'ddi_detalle_ingreso.ddi_id_tig = tig_tipo_ingreso.tig_id');
        $this->db->join('inn_ingreso', 'inn_id=ddi_id_inn', 'left');
        $this->db->join('hxe_hora_extraxempleado', 'hxe_id=inn_id_hxe', 'left');
        $this->db->where('ddi_id_pla', $planilla->pla_id);
        $this->db->where('ddi_id_emp', $empleado->emp_id);
        $this->db->where('IF(hxe_estado IS NULL, 1, IF (hxe_estado = 1, 1, 0)) = 1');
        /* $this->db->where("(tig_id<>$INGRESO_HED AND tig_id<>$INGRESO_HEN)"); */
        $this->db->group_by('tig_id');

        return $this->db->get($this->detalle_ingresos)->result();
    }

    protected function get_descuentos_pla_emp($planilla, $empleado)
    {
        $this->db->select('
                  tdc_tipo_descuento.tdc_id,
                  tdc_tipo_descuento.tdc_nombre,
                 sum(ddd_detalle_descuento.ddd_valor) as ddd_valor,
                  ddd_detalle_descuento.ddd_valor_patronal,
                  ddd_detalle_descuento.ddd_ingreso_afecto,
                  ddd_detalle_descuento.ddd_dias_descuento  
                  ');
        $this->db->join($this->tipo_descuentos, 'ddd_detalle_descuento.ddd_id_tdc = tdc_tipo_descuento.tdc_id');
        $this->db->where('ddd_id_pla', $planilla->pla_id);
        $this->db->where('ddd_id_emp', $empleado->emp_id)->group_by('tdc_id');
        return $this->db->get($this->detalle_descuentos)->result();
    }

    function get_descuentos_emp($planilla, $empleado)
    {
        $this->db->select('
                  tdc_tipo_descuento.tdc_id,
                  tdc_tipo_descuento.tdc_nombre,
                 sum(ddd_detalle_descuento.ddd_valor) as ddd_valor,
                  ddd_detalle_descuento.ddd_valor_patronal,
                  ddd_detalle_descuento.ddd_ingreso_afecto,
                  ddd_detalle_descuento.ddd_dias_descuento  
                  ');
        $this->db->join($this->tipo_descuentos, 'ddd_detalle_descuento.ddd_id_tdc = tdc_tipo_descuento.tdc_id');
        $this->db->where('ddd_id_pla', $planilla);
        $this->db->where('ddd_id_emp', $empleado)->group_by('tdc_id');
        return $this->db->get($this->detalle_descuentos)->result_array();
    }

    function editar_ingreso_info($ingreso)
    {
        $ingresos = $this->db->where('inn_id', $ingreso)->get('inn_ingreso');
        return $ingresos->result_array();
    }

    function editar_descuento_info($descuento)
    {
        $ingresos = $this->db->where('dss_id', $descuento)->join('emp_empleado', 'emp_id=dss_id_emp')->get('dss_descuento');
        return $ingresos->result_array();
    }

    function editar_ingreso($ingreso)
    {
        $editar = array(
            'inn_id_tig' => $this->input->post('tipo_ingreso'),
            'inn_motivo' => $this->input->post('con_ingreso'),
            'inn_valor' => $this->input->post('monto_aumentar'),
            'inn_fecha_desde' => $this->input->post('fecha_desde_in'),
            //'inn_fecha_hasta' => $this->input->post('fecha_hasta_in'),
            'inn_cuota' => $this->input->post('cuotas_in'),
            'inn_usu_mod' => $this->tank_auth->get_user_id(),
            'inn_observacion' => $this->input->post('observaciones_in'),
            'inn_estado' => ($this->input->post('estado_in') > 0) ? 1 : 0,
            'inn_permanente' => ($this->input->post('permanente_in')) ? 1 : 0,
            'inn_fecha_mod' => date('Y-m-d H:i:s')
        );
        $resultado = $this->db->where('inn_id', $ingreso)->update('inn_ingreso', $editar);
        return $this->db->trans_status();
    }

    function editar_descuento($descuento)
    {
        $editar = array(
            'dss_id_tdc' => $this->input->post('tipo_descuento'),
            'dss_motivo' => $this->input->post('con_descuento'),
            'dss_valor' => $this->input->post('monto_descontar'),
            'dss_referencia' => $this->input->post('referencia_des'),
            'dss_fecha_desde' => $this->input->post('fecha_desde_des'),
            //'dss_fecha_hasta' => $this->input->post('fecha_hasta_des'),
            'dss_observacion' => $this->input->post('observaciones_des'),
            'dss_estado' => ($this->input->post('estado_des') > 0) ? 1 : 0,
            'dss_cuotas' => $this->input->post('cuotas_des'),
            'dss_usu_mod' => $this->tank_auth->get_user_id(),
            'dss_fecha_mod' => date('Y-m-d H:i:s')
        );
        $resultado = $this->db->where('dss_id', $descuento)->update('dss_descuento', $editar);

        return $this->db->trans_status();
    }

    protected function add_descuento_detalle($planilla, $empleado, $tdc_id, $valor, $afecto, $dss_id = null, $patronal = 0, $dias = 0, $total_calculado = null, $aplico_recalculo = null, $observaciones_descuento = null)
    {   //Este proceso se debe realizar solo en la autorización de la planilla
        /* if($planilla->pla_estado==3){
          $this->db->set('dss_cuota_pagada', 'dss_cuota_pagada + 1', false);
          $this->db->where('dss_id', $dss_id);
          $this->db->update($this->descuentos);
          }
          $this->add_descuento_detalle($planilla->pla_id, $detalle_afp[0]['emp_id'], $id_tipo_descuento_afp, $detalle_afp[0]['asegurado'], $detalle_afp[0]['emp_salario'] / $tpl->tpl_cantidad, null, $detalle_afp[0]['patrono'], $tpl->tpl_frecuencia);

         */

        if ($empleado != null and $valor != null and $valor > 0  and $tdc_id > 0 and $empleado > 0) {
            return $this->db->insert($this->detalle_descuentos, array(
                'ddd_id_pla' => $planilla,
                'ddd_id_emp' => $empleado,
                'ddd_id_tdc' => $tdc_id,
                'ddd_valor' => $valor,
                'ddd_valor_patronal' => $patronal,
                'ddd_ingreso_afecto' => $afecto,
                'ddd_dias_descuento' => $dias,
                'ddd_fecha_mod' => date('Y-m-d H:i:s'),
                'ddd_id_dss' => $dss_id,
                'ddd_ingreso_afecto_total' => $total_calculado,
                'ddd_aplico_recalculo' => $aplico_recalculo,
                'ddd_observaciones' => $observaciones_descuento
            ));
        } else {
            return 0;
        }
    }

    protected function add_ingreso_detalle($planilla, $empleado, $tig_id, $valor, $inn_id = null, $dias = 0, $observacion = null, $psp = null, $acg = null, $ace = null)
    {
        //Este proceso se debe realizar solo en la autorización de la planilla
        if (!is_null($valor) && $valor >= 0 && $tig_id > 0 && $empleado > 0) {

            return $this->db->insert($this->detalle_ingresos, array(
                'ddi_id_pla' => $planilla->pla_id,
                'ddi_id_inn' => $inn_id,
                'ddi_id_psp' => $psp,
                'ddi_id_acg' => $acg,
                'ddi_id_ace' => $ace,
                'ddi_id_emp' => $empleado,
                'ddi_id_tig' => $tig_id,
                'ddi_valor'  => $valor,
                'ddi_dias'   => $dias,
                'ddi_observacion' => $observacion,
                'ddi_usu_mod' => $this->tank_auth->get_user_id(),
                'ddi_fecha_mod' => date('Y-m-d H:i:s')
            ));
        }
        return 0;
    }

    function codigo_ingreso01($empleado, $id_tipo_planilla = 1)
    {
        $salario = $this->gsatelite->get_parametro('INGRESO_SALARIO');
        // $this->db->select('ddi_id_pla AS planilla, pla_fecha_fin AS fecha, MONTH(pla_fecha_fin) AS mes')
        /* caso eno trabajo de MAR - MAY traia id de mayo pero fechas de marzo  // LA FECHA Y MES NO SIEMPRE SON LAS DEL MAX(pla_id) */
        $this->db->select('MAX(ddi_id_pla) planilla, pla_fecha_fin fecha, MONTH(pla_fecha_fin) mes')
            ->from('ddi_detalle_ingreso')
            ->join('pla_planilla', 'pla_id=ddi_id_pla')
            ->where('ddi_id_emp', $empleado);
        if ($id_tipo_planilla > 0) {
            $this->db->where('pla_id_tpl', $id_tipo_planilla);
        }
        if (isset($ingresos)) {
            $this->db->where_in('ddi_id_tig', $ingresos);
        }
        // $this->db->order_by('ddi_id_pla', 'DESC');
        $this->db->order_by('pla_fecha_fin', 'DESC');
        // $this->db->limit(1);
        $consulta = $this->db->get();
        $datos = $consulta->row();
        $planilla = $datos->{'planilla'};
        $mes_planilla = $datos->{'mes'};
        $this->db->select('SUM(ddi_valor) AS sueldo')
            ->from('ddi_detalle_ingreso')
            ->join('pla_planilla', 'pla_id = ddi_id_pla')
            ->join('tig_tipo_ingreso', 'tig_id=ddi_id_tig')
            ->where('ddi_id_emp', $empleado);
        if ($id_tipo_planilla > 0) {
            $this->db->where('ddi_id_pla', $planilla);
        } else {
            $this->db->where('MONTH(pla_fecha_fin)', $mes_planilla);
        }
        $this->db->where('tig_id', $salario)
            ->where('tig_gravado', 1);
        $consulta = $this->db->get();
        $datos = $consulta->row();
        $sueldo = $datos->{'sueldo'};
        if ($sueldo > 0) {
            /* calculo del afp para restarlo a la renta */

            $id_descuento_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
            $this->db->select('SUM(ddd_valor) AS afp')
                ->from('ddd_detalle_descuento')
                ->join('pla_planilla', 'pla_id = ddd_id_pla')
                ->join('tdc_tipo_descuento', 'tdc_id = ddd_id_tdc')
                ->where('ddd_id_emp', $empleado);
            if ($id_tipo_planilla > 0) {
                $this->db->where('ddd_id_pla', $planilla);
            } else {
                $this->db->where('MONTH(pla_fecha_fin)', $mes_planilla);
            }
            $this->db->where('tdc_id', $id_descuento_afp);
            $consulta = $this->db->get();
            $datos = $consulta->row();
            $afp = ($datos->{'afp'} > 0) ? $datos->{'afp'} : 0;
            $salario_gravado = $sueldo - $afp;

            $id_descuento_renta = $this->gsatelite->get_parametro('DESCUENTO_ISR');
            $this->db->select('SUM(ddd_valor) AS renta')
                ->from('ddd_detalle_descuento')
                ->join('pla_planilla', 'pla_id = ddd_id_pla')
                ->join('tdc_tipo_descuento', 'tdc_id = ddd_id_tdc')
                ->where('ddd_id_emp', $empleado);
            if ($id_tipo_planilla > 0) {
                $this->db->where('ddd_id_pla', $planilla);
            } else {
                $this->db->where('MONTH(pla_fecha_fin)', $mes_planilla);
            }
            $this->db->where('tdc_id', $id_descuento_renta);
            $consulta = $this->db->get();
            $datos = $consulta->row();
            $renta = ($datos->{'renta'} > 0) ? $datos->{'renta'} : 0;


            /* Aplica renta */

            /*

              $this->db->select('isr_porcentaje')
              ->from('isr_isr')
              ->where('isr_desde <=', $salario_gravado)
              ->where('isr_hasta >=', $salario_gravado)
              ->where('isr_id_tis', 1);
              $consulta=$this->db->get();
              $datos=$consulta->row();
              $porcentaje=$datos->{'isr_porcentaje'};

              $renta=$salario_gravado*($porcentaje/100);

             */
        } else {
            $renta = 0;
        }

        if ($sueldo > 0) {
            $sueldo = $sueldo - $afp;
        } else {
            $sueldo = 0;
            $afp = 0;
        }
        $datos = array(
            'sueldo' => $sueldo,
            'renta' => $renta
        );
        return json_encode($datos);
    }

    function codigo_ingreso11($empleado, $id_tipo_planilla = 1)
    {
        $comisiones = $this->gsatelite->get_parametro('INGRESO_COMISIONES');
        // $this->db->select('ddi_id_pla AS planilla, pla_fecha_fin AS fecha, MONTH(pla_fecha_fin) AS mes')
        $this->db->select('MAX(ddi_id_pla) planilla, pla_fecha_fin fecha, MONTH(pla_fecha_fin) mes')
            ->from('ddi_detalle_ingreso')
            ->join('pla_planilla', 'pla_id=ddi_id_pla')
            ->where('ddi_id_emp', $empleado);
        if ($id_tipo_planilla > 0) {
            $this->db->where('pla_id_tpl', $id_tipo_planilla); /* Planilla de comisiones */
        }
        if (isset($ingresos)) {
            $this->db->where_in('ddi_id_tig', $ingresos);
        }
        // $this->db->order_by('ddi_id_pla', 'DESC');
        $this->db->order_by('pla_fecha_fin', 'DESC');
        // $this->db->limit(1);
        $consulta = $this->db->get();
        $datos = $consulta->row();
        $planilla = $datos->{'planilla'};
        $mes_planilla = $datos->{'mes'};

        $this->db->select('SUM(ddi_valor) AS comision')
            ->from('ddi_detalle_ingreso')
            ->join('pla_planilla', 'pla_id=ddi_id_pla')
            ->join('tig_tipo_ingreso', 'tig_id=ddi_id_tig')
            ->where('ddi_id_emp', $empleado);
        if ($id_tipo_planilla > 0) {
            $this->db->where('ddi_id_pla', $planilla);
        } else {
            $this->db->where('MONTH(pla_fecha_fin)', $mes_planilla);
        }
        $this->db->where('tig_id', $comisiones)
            ->where('tig_gravado', 1);
        $consulta = $this->db->get();
        $datos = $consulta->row();
        $comision = $datos->{'comision'};

        if ($comision > 0) {

            /* Aplica renta */
            $this->db->select('isr_porcentaje')
                ->from('isr_isr')
                ->where('isr_desde <=', $comision)
                ->where('isr_hasta >=', $comision)
                ->where('isr_id_tis', 1);
            $consulta = $this->db->get();
            $datos = $consulta->row();
            $procentaje = $datos->{'isr_porcentaje'};

            $renta = $comision * ($porcentaje / 100);
        } else {
            $renta = 0;
        }

        $datos = array(
            'comision' => $comision,
            'renta' => $renta
        );
        return json_encode($datos);
    }

    public function get_empl_x_plan($where = null)
    {
        $this->db->select("emp_id, emp_codigo, emp_nombre, emp_apellido")
            ->from('pla_planilla')
            ->join('ddi_detalle_ingreso', 'ddi_id_pla = pla_id')
            ->join('emp_empleado', 'emp_id = ddi_id_emp')
            ->group_by('emp_id');
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    function generar_boletas($planilla_id, $id_emp = NULL)
    {
        $this->_debug('Generar Planilla: ini');
        //descuento banco y afp
        $des_banco = $this->gsatelite->get_parametro('ID_TIPO_DESCUENTO_PRESTAMO_BANCO');
        $des_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
        $pla_liquidacion = $this->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION', null, null, array('ID_TIPO_PLANILLA_LIQ'));
        //planilla
                    $this->db->join($this->tipo_planillas, 'pla_id_tpl = tpl_id');
        $planilla = $this->db->get_where($this->planillas, array('pla_id' => $planilla_id), 1)->row();
        $this->_debug($this->db->last_query());
        $this->_debug($planilla, 'die');
        if (!count($planilla)) {
            $this->_debug('Error: Planilla no existe');
            return false;
        }

        //obtner empleados afectados
        $this->db->join($this->detalle_ingresos, 'ddi_id_emp = emp_id');
        if (!empty($id_emp)) {
            $empleados = $this->db->get_where($this->empleados, array('ddi_id_pla' => $planilla->pla_id, 'emp_id' => $id_emp))->result();
        } else {
            $this->db->order_by('emp_id_are', 'asc');
            $this->db->order_by('emp_apellido', 'asc');
            $empleados = $this->db->get_where($this->empleados, array('ddi_id_pla' => $planilla->pla_id))->result();
        }
        $this->_debug($this->db->last_query());
        $this->_debug($empleados, 'die');
        if (!count($empleados)) {
            $this->_debug('Sin Empleados');
            return false;
        }

        $plazas = array();
        foreach ($this->db->get('plz_plaza')->result() as $row) {
            $plazas[$row->plz_id] = $row;
        }

        $sucursales = array();
        foreach ($this->db->get('suc_sucursal')->result() as $row) {
            $sucursales[$row->suc_id] = $row;
        }

        $afps = array();
        foreach ($this->db->get('afp_afp')->result() as $row) {
            $afps[$row->afp_id] = $row;
        }

        $proyectos = array();
        foreach ($this->db->get('pcl_proyecto_cliente')->result() as $row) {
            $proyectos[$row->pcl_id] = $row;
        }

        $iddui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI', 0);
        $idnit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT', 0);
        foreach ($empleados as $nit) {
            $this->db->select("dce_valor");
            $this->db->where(array('dce_id_tde' => $idnit, 'dce_id_emp' => $nit->emp_id));
            $nitsempleados[] = $this->db->get("dce_documento_emp")->result_array();

            $this->db->select("dce_valor");
            $this->db->where(array('dce_id_tde' => $iddui, 'dce_id_emp' => $nit->emp_id));
            $duisempleados[] = $this->db->get("dce_documento_emp")->result_array();
        }

        //print_r($nitsempleados);die();

        $retorno = array();
        $sal = $this->tig_salario;
        $pla_normal = ($planilla->tpl_id != $pla_liquidacion) ? true : false;
        // tipos de ingresos de las incapacidades
        $tnc_tabla = $this->gsatelite->get_tabla("tnc_tipo_incapacidad", array("tnc_estado" => 1, "tnc_aplica_planilla" => 1, "tnc_id_tig IS NOT NULL" => null));
        $tig_inc = (count($tnc_tabla) > 0) ? implode(',', array_column($tnc_tabla, 'tnc_id_tig')) : 0;
        foreach ($empleados as $key => $empleado) {
            //ingresos            
            $this->db->select("tig_tipo_ingreso.tig_id, tig_codigo, tig_nombre,
                /*
                CASE
                    WHEN tig_tipo_ingreso.tig_id = $sal AND '$pla_normal' THEN
                        CONCAT(tig_nombre,' (',ddi_detalle_ingreso.ddi_dias,' DIAS)')
                    WHEN tig_tipo_ingreso.tig_id IN ($tig_inc) THEN
                        IF(
                            (SELECT SUM(inc_dias) FROM inc_incapacidad WHERE inc_id_emp = ddi_id_emp AND inc_id_pla = ddi_id_pla) IS NULL, 
                            tig_nombre,
                            CONCAT(tig_nombre,' (',(SELECT ROUND(SUM(inc_dias)) FROM inc_incapacidad WHERE inc_id_emp = ddi_id_emp AND inc_id_pla = ddi_id_pla),' DIAS)')
                        )
                    ELSE
                        tig_nombre
                END AS tig_nombre,
                */
                CASE
                    WHEN tig_tipo_ingreso.tig_id = $sal AND '$pla_normal' THEN
                        IF((SELECT SUM(inc_dias) FROM inc_incapacidad JOIN inn_ingreso ON inn_id = inc_id_inn WHERE inc_id_pla = ddi_id_pla AND inn_id_tig = tig_id AND inc_id_emp = ddi_id_emp) IS NULL,
                            CONCAT(' (', ddi_detalle_ingreso.ddi_dias, ' DIAS)'),
                            IF(ROUND((SELECT SUM(inc_dias) FROM inc_incapacidad JOIN inn_ingreso ON inn_id = inc_id_inn WHERE inc_id_pla = ddi_id_pla AND inn_id_tig = tig_id AND inc_id_emp = ddi_id_emp) + ddi_dias) > (SELECT tpl_frecuencia FROM pla_planilla JOIN tpl_tipo_planilla ON tpl_id = pla_id_tpl WHERE pla_id = ddi_id_pla),
                                CONCAT(' (', (SELECT tpl_frecuencia FROM pla_planilla JOIN tpl_tipo_planilla ON tpl_id = pla_id_tpl WHERE pla_id = ddi_id_pla), ' DIAS)'),
                                CONCAT(' (', ROUND((SELECT SUM(inc_dias) FROM inc_incapacidad JOIN inn_ingreso ON inn_id = inc_id_inn WHERE inc_id_pla = ddi_id_pla AND inn_id_tig = tig_id AND inc_id_emp = ddi_id_emp) + ddi_dias), ' DIAS)')
                            )
                        )
                    WHEN tig_tipo_ingreso.tig_id != $sal AND tig_tipo_ingreso.tig_id IN ($tig_inc) AND '$pla_normal' THEN
                        IF((SELECT SUM(inc_dias) FROM inc_incapacidad WHERE inc_id_emp = ddi_id_emp AND inc_estado = 1 AND inc_id_pla = ddi_id_pla) IS NULL,
                            '',
                            CONCAT(' (', (SELECT ROUND(SUM(inc_dias)) FROM inc_incapacidad WHERE inc_id_emp = ddi_id_emp AND inc_estado=1 AND inc_id_pla = ddi_id_pla AND inc_id_inn IS NOT NULL), ' DIAS)')
                        )
                    ELSE ''
                END AS dias_incapacidad,
                /*IF(tig_tipo_ingreso.tig_id = $sal AND '$pla_normal', CONCAT(tig_nombre,'(',ddi_detalle_ingreso.ddi_dias,' DIAS)'), tig_nombre) AS tig_nombre_2, */
                inn_referencia, ddi_id, inn_id,
                ROUND((SELECT SUM(inc_dias) FROM inc_incapacidad JOIN inn_ingreso ON inn_id = inc_id_inn WHERE inc_estado = 1 AND inc_id_pla = ddi_id_pla  AND inn_id_tig = tig_id AND inc_id_emp = ddi_id_emp)) AS tiene_incapacidad,
                (IF(ddi_observacion IS NOT NULL AND TRIM(ddi_observacion) != '', CONCAT('<br />&nbsp;&nbsp;&nbsp;', '*', GROUP_CONCAT(DISTINCT TRIM(ddi_observacion))), '')) AS texto_info,
                SUM(ddi_detalle_ingreso.ddi_valor) AS ddi_valor, ddi_detalle_ingreso.ddi_dias,
                IF(inn_referencia IS NOT NULL AND TRIM(inn_referencia) != '', CONCAT('&nbsp;&nbsp;', GROUP_CONCAT( DISTINCT CONCAT('*',
                    RPAD(CONCAT(UPPER(LEFT(inn_referencia,1)),SUBSTR(inn_referencia,2)), 25, '.'), ' ($', ddi_valor,') '
                            ) SEPARATOR '<br />&nbsp;&nbsp;&nbsp;&nbsp;' )
                    ), ' '
                ) AS referencia", false);
            $this->db->join($this->tipo_ingresos, 'ddi_id_tig = tig_id');
            $this->db->join('inn_ingreso AS inn', 'inn_id = ddi_id_inn', 'left');
            $this->db->where(array(
                'ddi_id_pla' => $planilla->pla_id,
                'ddi_id_emp' => $empleado->emp_id
            ));
            $this->db->group_by('tig_id');
            $this->db->order_by('tig_orden', 'ASC');
            $ingresos = $this->db->get($this->detalle_ingresos)->result();
            //descuentos
            $this->db->select('dss_referencia, dss_fecha_desde, tdc_tipo_descuento.tdc_id, tdc_tipo_descuento.tdc_codigo, tdc_tipo_descuento.tdc_nombre, SUM(ddd_detalle_descuento.ddd_valor) AS ddd_valor,
                ddd_detalle_descuento.ddd_valor_patronal, ddd_detalle_descuento.ddd_ingreso_afecto, ddd_detalle_descuento.ddd_dias_descuento,
                CASE
                    WHEN tdc_tipo_descuento.tdc_id = ' . $des_afp . ' THEN
                        (SELECT CONCAT("<br />&nbsp;&nbsp;*(", afp_nombre, ")") AS nombre_afp FROM emp_empleado JOIN afp_afp ON afp_id = emp_id_afp WHERE emp_id = ' . $empleado->emp_id . ')
                    WHEN tdc_tipo_descuento.tdc_prestamo_bancario = 1 THEN
                        (SELECT CONCAT("<br />", GROUP_CONCAT(DISTINCT CONCAT("&nbsp;&nbsp;*(", IFNULL(TRIM(ban_nombre), "Banco no definido"),
                        IF(ISNULL(dss_valor), "", CONCAT(" -> $", dss_valor)), ")" ) SEPARATOR "<br />" ) ) AS info_adicional FROM dss_descuento LEFT JOIN ban_banco ON ban_id = dss_id_ban
                        JOIN tdc_tipo_descuento AS t ON t.tdc_id = dss_id_tdc INNER JOIN ddd_detalle_descuento ON ddd_id_dss = dss_id WHERE dss_id_emp = ' . $empleado->emp_id . ' 
                        AND dss_estado = 1 AND ddd_id_pla = ' . $planilla->pla_id . ' AND t.tdc_prestamo_bancario = 1  )
                    ELSE ""
                    END AS texto_info,
                    IF(dss_referencia IS NOT NULL AND TRIM(dss_referencia) <> "" AND tdc_tipo_descuento.tdc_prestamo_bancario = 0, CONCAT("<br />&nbsp;&nbsp;", 
                        GROUP_CONCAT(DISTINCT CONCAT("*", CONCAT(UPPER(LEFT(dss_referencia, 1)), SUBSTR(dss_referencia, 2))) SEPARATOR "<br />&nbsp;&nbsp;")), " ") AS referencia
            ', false); //"*", RPAD(CONCAT(UPPER(LEFT(dss_referencia,1)),SUBSTR(dss_referencia,2)), 25, "."), " ($", ddd_valor,") "    //////  GROUP BY dss_id_tdc
            $this->db->join($this->tipo_descuentos, 'ddd_id_tdc = tdc_id'); //dss_referencia, IF(ISNULL(dss_referencia), "-", ""), ", ",
            $this->db->join('dss_descuento', 'dss_id = ddd_id_dss', 'left');
            $this->db->where(array(
                'ddd_id_pla' => $planilla->pla_id,
                'ddd_id_emp' => $empleado->emp_id
            ));
            $this->db->group_by('tdc_id');
            $this->db->order_by('tdc_orden', 'asc');
            $descuentos = $this->db->get($this->detalle_descuentos)->result();

            //calculos
            $ing = 0;
            foreach ($ingresos as $row) {
                $ing += $row->ddi_valor;
            }
            $des = 0;
            foreach ($descuentos as $row) {
                $des += $row->ddd_valor;
            }

            if ($empleado->emp_id_are > 0) {
                $this->db->select('are_nombre', false)->from('are_area')->where("are_id = ".$empleado->emp_id_are);
                $resultado_areas = $this->db->get()->row();
            }

            if ($empleado->emp_id_plz > 0) {
                $this->db->select('plz_codigo, plz_nombre, plz_id_pto, plz_forma_pagos, unp_codigo, lnt_codigo, plz_id_ppl, plz_id_spp', false)
                    ->from('plz_plaza')
                    ->join('unp_unidad_presupuestaria', 'unp_id = plz_id_unp', 'left')
                    ->join('lnt_linea_trabajo', 'lnt_id = plz_id_lnt', 'left')
                    ->where("plz_id = ".$empleado->emp_id_plz)
                ;
                $resultado_plaza = $this->db->get()->row();
            }


            // print_r($nitsempleados);die();
            //formulario
            $formulario = array(
                'id_emp' => $empleado->emp_id,
                'empleado' => $empleado->emp_codigo . ' ' . $empleado->emp_nombre . ' ' . $empleado->emp_apellido,
                'nombre_empleado' => $empleado->emp_apellido.', '.$empleado->emp_nombre,
                'nit' => $nitsempleados[$key][0]['dce_valor'],
                'dui' => $duisempleados[$key][0]['dce_valor'],
                'puesto'   => /* $empleado->emp_id_pto . ': ' . */ ($empleado->emp_id_plz != '') ? $plazas[$empleado->emp_id_plz]->plz_nombre : '',
                'afp'      => /* $empleado->emp_id_afp . ': ' . */ $afps[$empleado->emp_id_afp]->afp_nombre,
                'sucursal' => /* $empleado->emp_id_suc . ': ' . */ $sucursales[$empleado->emp_id_suc]->suc_nombre,
                'periodo'  => $planilla->pla_codigo,
                'planilla' => $planilla->tpl_nombre,
                'frecuencia_planilla' => $planilla->tpl_frecuencia,
                'ingresos'      => $ing,
                'descuentos'    => $des,
                'ingreso'       => $empleado->emp_fecha_contrato,
                'fecha_inicio'  => $planilla->pla_fecha_inicio,
                'fecha_pago'    => $planilla->pla_fecha_pago,
                'fecha_fin'     => $planilla->pla_fecha_fin,
                'proyecto'      => ($planilla->pla_id_plc != '') ? $proyectos[$planilla->pla_id_plc]->pcl_codigo . ' ' . $proyectos[$planilla->pla_id_plc]->pcl_nombre : '',
                'forma_pago'    => $empleado->emp_metodo_pago,
                'numero_cuenta' => $empleado->emp_numero_cuenta,
                'salario' => $empleado->emp_salario,
                'area' => ($resultado_areas) ? $resultado_areas->are_nombre: '',
                'plaza' => $resultado_plaza ? $resultado_plaza : ''
            );

            //armamos
            $retorno[$empleado->emp_id] = array(
                'ing' => $ingresos,
                'des' => $descuentos,
                'frm' => (object) $formulario
            );
        }

        return $retorno;
    }

    public function tabla_generada_planilla($planilla, $ingreso_salario)
    {
        $query = "SELECT ddd_id_tdc, ddd_id_pla AS pla_id, emp_id AS id,Concat(emp_nombre,' ',emp_apellido) AS nombre, emp_salario AS salario, 
                    ifnull((SELECT SUM(ddi_valor) AS valor from ddi_detalle_ingreso where ddi_id_emp = emp_empleado.emp_id AND ddi_id_pla = " . $planilla . " AND ddi_id_tig NOT IN(" . $ingreso_salario . ") ),0) AS ingresos, 
                    ifnull((SELECT SUM(ddd_valor) AS valor from ddd_detalle_descuento where ddd_id_emp = emp_empleado.emp_id AND ddd_id_pla = " . $planilla . "),0) AS descuentos,
                    ifnull((SELECT SUM(ddi_valor) AS valor from ddi_detalle_ingreso where ddi_id_emp = emp_empleado.emp_id AND ddi_id_pla = " . $planilla . "),0) -
                    ifnull((SELECT SUM(ddd_valor) AS valor from ddd_detalle_descuento where ddd_id_emp = emp_empleado.emp_id AND ddd_id_pla = " . $planilla . "),0)  AS total ";
        if ($ingreso_salario != null) {
            $query .= ",  ifnull((SELECT SUM(ddi_valor) AS valor from ddi_detalle_ingreso where ddi_id_emp = emp_empleado.emp_id AND ddi_id_pla =" . $planilla . " AND ddi_id_tig IN(" . $ingreso_salario . ")) ,0) AS ing_salario";
        }

        $query .= " FROM   emp_empleado 
                    LEFT JOIN ddd_detalle_descuento ddd_id_pla
                    ON ddd_id_emp = emp_id  AND ddd_id_pla = " . $planilla . "
                    INNER JOIN ddi_detalle_ingreso 
                    ON ddi_id_emp = emp_id 
                    WHERE ddi_id_pla = " . $planilla . " 
                    GROUP  BY ddi_id_emp, ddd_id_pla";

        // IF(ddd_id_pla IS NULL, 1, IF (ddd_id_pla = 1, 1, 0)) = 1 
        //ddd_id_pla = ".$planilla." AND  
        $resultado = $this->db->query($query);
        return $resultado->result_array();
    }

    function get_informacion_empleado($pla_id, $fecha_ini, $fecha_fin, $id_emp)
    {
        $this->db->select('emp_nombre, emp_apellido, 
                               emp_fecha_contrato,emp_fecha_retiro, emp_salario, emp_id')
            ->from('emp_empleado')
            ->where('emp_fecha_contrato >=', $fecha_ini)
            ->where('emp_fecha_contrato <=', $fecha_fin)
            ->where('emp_id', $id_emp);
        $result = $this->db->get()->row_array();
        //die(print_r($result['emp_salario']));

        $this->db->select('emp_nombre, emp_apellido, 
                                emp_fecha_contrato,emp_fecha_retiro, emp_salario, emp_id')
            ->from('emp_empleado')
            ->where('emp_fecha_retiro >=', $fecha_ini)
            ->where('emp_fecha_retiro <=', $fecha_fin)
            ->where('emp_id', $id_emp);
        $result2 = $this->db->get()->row_array();
        //print_r($result2); die();
        $sueldo_dias = 0;
        if (isset($result['emp_id']) && $result['emp_id'] > 0 && count($result2) <= 0) {
            //EMPLEADO SE CONTRATO EN MEDIO DEL PERIODO DE PLANILLA Y NO SE HA RETIRADO
            $this->db->join('pla_planilla', 'tpl_id = pla_id_tpl', 'inner');
            $tipo_pla = $this->gsatelite->get_registro('tpl_tipo_planilla', array('pla_id' => $pla_id));
            $sueldo = $result['emp_salario'];
            $fecha_contrato = $result['emp_fecha_contrato'];
            $dia_inicio = date('d', strtotime($fecha_ini));
            $dia_contrato = date('d', strtotime($fecha_contrato));
            // $dia_fin = $this->gsatelite->get_parametro("DIAS_TRABAJADOS_MES");
            if ($tipo_pla->tpl_cantidad > 1) {
                if (formatear_fecha('d', $fecha_fin) < formatear_fecha('t', $fecha_fin)) {
                    $dia_fin = formatear_fecha('d', $fecha_fin);
                } else {
                    $dia_fin = formatear_fecha('t', $fecha_fin);
                }
            } else {
                $dia_fin = formatear_fecha('t', $fecha_fin);
            }
            $dias_trabajados = ($dia_fin - $dia_contrato) + 1;
            $caso_feb = (formatear_fecha('n', $fecha_fin) == 2) ? ($this->gsatelite->get_intervalo_dias($fecha_ini, $fecha_fin) + 1) : $tipo_pla->tpl_frecuencia;
            $dias_trabajados = ($dias_trabajados > $tipo_pla->tpl_frecuencia) ? $tipo_pla->tpl_frecuencia : $dias_trabajados;
            $dias_trabajados = ($caso_feb == $dias_trabajados) ? $tipo_pla->tpl_frecuencia : $dias_trabajados;
            $sueldoxdia = $sueldo / $this->gsatelite->get_parametro("DIAS_TRABAJADOS_MES", 30);
            $sueldo_d = ($dias_trabajados * $sueldoxdia) * floatval($tipo_pla->tpl_cantidad);
            $sueldo_dias = number_format($sueldo_d, '2', '.', '');
            // if ($id_emp == 720) { var_dump($sueldo_d); die(); }
        } elseif (isset($result['emp_id']) && $result2['emp_id'] > 0 and count($result) <= 0) {

            $sueldo = $result2['emp_salario'];
            $fecha_retiro = $result2['emp_fecha_retiro'];

            $dia_inicio = date('d', strtotime($fecha_ini));
            $dia_retiro = date('d', strtotime($fecha_retiro));
            $dia_fin = $this->gsatelite->get_parametro("DIAS_TRABAJADOS_MES"); //date('d', strtotime($fecha_fin));

            $dias_trabajados = $dia_retiro - $dia_inicio + 1;
            $sueldoxdia = $sueldo / $dia_fin;

            $sueldo_d = $dias_trabajados * $sueldoxdia;
            $sueldo_dias = number_format($sueldo_d, '2', '.', '');
            //die(print_r($dias_trabajados.'/'.$sueldoxdia.'/'.$sueldo_dias));
        } elseif (isset($result['emp_id']) && $result['emp_id'] > 0 and $result2['emp_id'] > 0) {

            $sueldo = $result2['emp_salario'];
            $fecha_contrato = $result2['emp_fecha_contrato'];
            $fecha_retiro = $result2['emp_fecha_retiro'];

            $dia_inicio = date('d', strtotime($fecha_contrato));
            $dia_retiro = date('d', strtotime($fecha_retiro));
            $dia_fin = $this->gsatelite->get_parametro("DIAS_TRABAJADOS_MES"); //date('d', strtotime($fecha_fin));

            $dias_trabajados = $dia_retiro - $dia_inicio + 1;
            $sueldoxdia = $sueldo / $dia_fin;

            $sueldo_d = $dias_trabajados * $sueldoxdia;
            $sueldo_dias = number_format($sueldo_d, '2', '.', '');
            //die(print_r($dias_trabajados.'/'.$sueldoxdia.'/'.$sueldo_dias));
        }
        return $sueldo_dias;
    }

    protected function get_tipos()
    {
        //tipos de descuentos
        foreach ($this->db->get($this->tipo_descuentos)->result() as $row) {
            $this->tipos_descuento[$row->tdc_id] = $row;
        }

        //tipos de ingresos
        foreach ($this->db->get($this->tipo_ingresos)->result() as $row) {
            $this->tipos_ingreso[$row->tig_id] = $row;
        }

        //afps
        foreach ($this->db->get($this->afps)->result() as $row) {
            $this->afp[$row->afp_id] = $row;
        }
    }

    //--------- Ingesos

    function get_ingresos($emp_id)
    {
        $this->db->select('
                      inn_ingreso.inn_id,
                      tig_tipo_ingreso.tig_nombre,
                      inn_ingreso.inn_valor,
                      inn_ingreso.inn_fecha_desde,
                      -- inn_ingreso.inn_fecha_hasta,
                      inn_ingreso.inn_cuota,
                      inn_ingreso.inn_cuota_pagada
                      ');
        $this->db->join($this->tipo_ingresos, 'inn_id_tig = tig_id');
        $this->db->where('inn_id_emp', $emp_id);
        $result = $this->db->get($this->ingresos);
        if ($result->num_rows() > 0) {
            return $result->result();
        }
        return null;
    }

    function add_ingreso_empleado($data)
    {
        return $this->db->insert($this->ingresos, $data);
    }

    function delete_ingreso_empleado($data)
    {
        return $this->db->delete($this->ingresos, $data, 1);
    }

    //--------- Descuentos

    function get_descuentos($emp_id)
    {
        $this->db->select('
                      dss_descuento.dss_id,
                      tdc_tipo_descuento.tdc_nombre,
                      dss_descuento.dss_valor,
                      dss_descuento.dss_fecha_desde,
                      -- dss_descuento.dss_fecha_hasta,
                      dss_descuento.dss_cuotas,
                      dss_descuento.dss_cuota_pagada
                      ');
        $this->db->join($this->tipo_descuentos, 'dss_id_tdc = tdc_id');
        $this->db->where('dss_id_emp', $emp_id);
        $result = $this->db->get($this->descuentos);
        if ($result->num_rows() > 0) {
            return $result->result();
        }
        return null;
    }

    function get_otros_descuentos_empleado($where = null)
    {
        $consulta = $this->db->select()
            ->from('tdc_tipo_descuento')
            ->join('dss_descuento', 'tdc_id = dss_id_tdc')
            ->group_by('tdc_id');
        if ($where != null) {
            $this->db->where($where, null, false);
        }
        return $this->db->get()->result_array();
    }

    function get_detalle_otros_desc_emp($where = null)
    {
        $consulta = $this->db->select()
            ->from('ddd_detalle_descuento')
            ->join('tdc_tipo_descuento', 'tdc_id = ddd_id_tdc')
            ->join('dss_descuento', 'dss_id = ddd_id_dss')
            ->join('pla_planilla', 'pla_id = ddd_id_pla')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl')
            ->join('emp_empleado', 'emp_id = ddd_id_emp')
            ->where('dss_estado', 1)
            ->where('pla_estado > ', 1)
            ->order_by('pla_fecha_pago');
        if ($where != null) {
            $this->db->where($where, null, false);
        }
        return $this->db->get()->result_array();
    }

    function add_descuento_empleado($data)
    {
        return $this->db->insert($this->descuentos, $data);
    }

    function delete_descuento_empleado($data)
    {
        return $this->db->delete($this->descuentos, $data, 1);
    }

    //---------

    function get_empleado($emp_id)
    {
        $this->db->select('
                      emp_empleado.emp_codigo,
                      emp_empleado.emp_nombres,
                      emp_empleado.emp_apellidos,
                      tpl_tipo_planilla.tpl_id,
                      tpl_tipo_planilla.tpl_nombre
                      ');
        $this->db->join('txe_tipo_planillaxempleado', 'txe_tipo_planillaxempleado.txe_id_emp = emp_empleado.emp_id');
        $this->db->join($this->tipo_planillas, 'txe_tipo_planillaxempleado.txe_id_tpl = tpl_tipo_planilla.tpl_id');
        $res = $this->db->get_where($this->empleados, array('emp_id' => $emp_id), 1);
        //echo $this->db->last_query(); die();
        if ($res->num_rows() == 1) {
            return $res->row();
        }
        return null;
    }

    //---------

    function get_dropdown($tabla, $campo_display, $campo_value, $where = '')
    {
        $this->db->select($campo_value . ', ' . $campo_display);
        if ($where)
            $this->db->where($where);
        $result = $this->db->get($tabla);
        $return = array();
        foreach ($result->result() as $row) {
            $return[$row->$campo_value] = $row->$campo_display;
        }
        return $return;
    }

    protected function _now()
    {
        return date('Y-m-d H:i:s');
    }

    protected function _debug($msg, $type = 'msj', $time = true)
    {
        if ($this->debug) {
            if ($time)
                echo date('H:i:s') . '> ';
            //print_r($msg) . "\n";
            switch ($type) {
                case 'die':
                    die();
                    break;
                case '':
                    break;

                case 'msj':
                default:
            }
        }
    }

    public function calcular_indemnizacion($array_data)
    {
        $tipo_planilla = $array_data['tpl_id'];
        $periodo_pla = $array_data['id_planilla'];
        $registro_planilla = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $periodo_pla);

        //preguntar si es una tipo de planilla de indemnización. (con un like)
        $query = $this->db->select()->from('tpl_tipo_planilla')
            ->where('tpl_id', $tipo_planilla)->get()->row_array();
        if ($query) {
            //die(print_r($query));
            //si es de tipo indemnizacion preguntar si existe un tipo de ingreso llamado indemnización.
            $id_tg_parametro = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION');
            $query_tipo_ing = $this->db->select()->from('tig_tipo_ingreso')
                ->where('tig_id', $id_tg_parametro)->get()->row_array();
            if ($query_tipo_ing) {
                // die(print_r($query_tipo_ing));
                //si es de tipo indemnizacion y existe un tipo de ingreso indemnizacion procesar a los empleados
                $query_emp = $this->db->select()->from('txe_tipo_planillaxempleado')
                    ->join('emp_empleado', 'emp_id=txe_id_emp')
                    ->where('txe_id_tpl', $tipo_planilla)
                    ->group_by('txe_id_emp', 'asc')->get()->result_array();

                $salario_minimo = $this->gsatelite->get_parametro('MONTO_SALARIO_MINIMO');
                $suma_salarios = $salario_minimo * 4;

                foreach ($query_emp as $fila) {
                    //calcular el valor de la indemnización
                    $fecha_retiro = $registro_planilla->pla_fecha_fin;
                    $year_retiro = date("Y", strtotime($registro_planilla->pla_fecha_fin));
                    //para ylufa (al año)
                    if ($this->gsatelite->get_intervalo_dias($fila['emp_fecha_contrato'], $fecha_retiro) >= 365) {
                        $fecha_ingreso = "01-01-$year_retiro";
                    } else {
                        $fecha_ingreso = $fila['emp_fecha_contrato'];
                    }

                    $ndias_trabaja = $this->gsatelite->get_intervalo_dias($fecha_ingreso, $fecha_retiro);
                    $salario_empleado = $fila['emp_salario'];
                    if ($salario_empleado > $suma_salarios) {
                        $total_indem = $ndias_trabaja * ($suma_salarios / 365);
                    } else {
                        $total_indem = $ndias_trabaja * ($salario_empleado / 365);
                    }

                    //se le restará un dia para asegurarse que entre en la planilla que se esta generando
                    $fecha_desde = strtotime('-1 day', strtotime($fecha_retiro));
                    $fecha_desde = date('Y-m-d', $fecha_desde);

                    //preguntar si ya existen ingresos similares al que se va ha ingresar
                    //se deberá eliminarlos dado que esta función se llama cada vez que se genera un planilla
                    $this->gsatelite->borrado_general('inn_ingreso', array('inn_id_emp' => $fila['emp_id'], 'inn_id_tig' => $query_tipo_ing['tig_id'], 'inn_fecha_desde' => $fecha_desde));


                    $ingreso = array(
                        'inn_id_emp' => $fila['emp_id'],
                        'inn_id_tpl' => $tipo_planilla,
                        'inn_id_tig' => $query_tipo_ing['tig_id'],
                        'inn_motivo' => 'ingreso por indemnización',
                        'inn_observacion' => 'ingreso por indemnización',
                        'inn_permanente' => 0,
                        'inn_valor' => $total_indem,
                        'inn_fecha_desde' => $fecha_desde,
                        'inn_cuota' => 1,
                        'inn_cuota_pagada' => 0,
                        'inn_estado' => 1,
                        'inn_fecha_mod' => date("Y-m-d H:i:s"),
                        'inn_usu_mod' => $this->tank_auth->get_user_id()
                    );

                    $this->db->insert('inn_ingreso', $ingreso);
                }
                return 'exito'; //los ingresos fueron procesados para cada empleado
            } else {
                return 'no hay tipo de ingreso indemnizacion, favor ingresar un registro con ese nombre';
            }
        } else {
            return 'no es de tipo indemnizacion';
        }
        //seleccionar los empleados que pertenencen al tipo de planilla (siempre y cuando se ha de indemnizacion)
    }

    public function calcular_aguinaldo($array_data)
    {
        $tipo_planilla = $array_data['tpl_id'];
        $periodo_pla = $array_data['id_planilla'];
        $registro_planilla = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $periodo_pla);

        //preguntar si es una tipo de planilla de aguinaldo
        $query = $this->db->select()->from('tpl_tipo_planilla')
            ->where('tpl_id', $tipo_planilla)->get()->row_array();
        if ($query) {
            //si es de tipo aguinaldo preguntar si existe un tipo de ingreso llamado aguinaldo.
            $id_tg_parametro = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');
            $query_tipo_ing = $this->db->select()->from('tig_tipo_ingreso')
                ->where('tig_id', $id_tg_parametro)->get()->row_array();
            if ($query_tipo_ing) {
                // die(print_r($query_tipo_ing));
                //si es de tipo indemnizacion y existe un tipo de ingreso indemnizacion procesar a los empleados
                $query_emp = $this->db->select()->from('txe_tipo_planillaxempleado')
                    ->join('emp_empleado', 'emp_id=txe_id_emp')
                    ->where('txe_id_tpl', $tipo_planilla)
                    ->group_by('txe_id_emp', 'asc')->get()->result_array();

                //$salario_minimo = $this->gsatelite->get_parametro('MONTO_SALARIO_MINIMO');
                //$suma_salarios =  $salario_minimo * 4;

                foreach ($query_emp as $fila) {
                    //calcular el valor del aguinaldo
                    $fecha_retiro = $registro_planilla->pla_fecha_fin;
                    $year_retiro = date("Y", strtotime($registro_planilla->pla_fecha_fin));

                    $fecha_ingreso = $fila['emp_fecha_contrato'];

                    $ndias_trabaja = $this->gsatelite->get_intervalo_dias($fecha_ingreso, $fecha_retiro);
                    $year_trabaja = $ndias_trabaja / 365;
                    //preguntar en que rango esta para calcular el numero de dias de goze

                    $salario_empleado = $fila['emp_salario'];

                    $monto_1 = $salario_empleado / 30;
                    $fecha_ini_year = date("Y-01-01");
                    $dato1 = $this->gsatelite->get_intervalo_dias($fecha_ini_year, $registro_planilla->pla_fecha_fin) + 1;
                    $pregunta_goze = $this->gsatelite->get_tabla('agd_aguinaldo', array('agd_estado' => 1));
                    $n_dias = 0;
                    foreach ($pregunta_goze as $fpregunta) {
                        if ($year_trabaja >= $fpregunta['agd_desde'] and $year_trabaja >= $fpregunta['agd_hasta']) {
                            $n_dias = $fpregunta['agd_dias_derecho'];
                        }
                    }
                    $dias_goze = $n_dias;
                    $dato2 = $dias_goze / 365;

                    $monto_2 = $dato1 * $dato2;
                    $total_aguinaldo = $monto_1 * $monto_2;


                    //se le restará un dia para asegurarse que entre en la planilla que se esta generando
                    $fecha_desde = strtotime('-1 day', strtotime($fecha_retiro));
                    $fecha_desde = date('Y-m-d', $fecha_desde);

                    //preguntar si ya existen ingresos similares al que se va ha ingresar
                    //se deberá eliminarlos dado que esta función se llama cada vez que se genera un planilla
                    $this->gsatelite->borrado_general('inn_ingreso', array('inn_id_emp' => $fila['emp_id'], 'inn_id_tig' => $query_tipo_ing['tig_id'], 'inn_fecha_desde' => $fecha_desde));


                    $ingreso = array(
                        'inn_id_emp' => $fila['emp_id'],
                        'inn_id_tpl' => $tipo_planilla,
                        'inn_id_tig' => $query_tipo_ing['tig_id'],
                        'inn_motivo' => 'ingreso por indemnización',
                        'inn_observacion' => 'ingreso por indemnización',
                        'inn_permanente' => 0,
                        'inn_valor' => $total_aguinaldo,
                        'inn_fecha_desde' => $fecha_desde,
                        'inn_cuota' => 1,
                        'inn_cuota_pagada' => 0,
                        'inn_estado' => 1,
                        'inn_fecha_mod' => date("Y-m-d H:i:s"),
                        'inn_usu_mod' => $this->tank_auth->get_user_id()
                    );

                    $this->db->insert('inn_ingreso', $ingreso);
                }
                return 'exito'; //los ingresos fueron procesados para cada empleado
            } else {
                return 'no hay tipo de ingreso aguinaldo, favor ingresar un registro con ese nombre';
            }
        } else {
            return 'no es de tipo aguinaldo';
        }
        //seleccionar los empleados que pertenencen al tipo de planilla (siempre y cuando se ha de indemnizacion)
    }

    /**
     * @author René Castaneda
     *
     */
    function get_empleados_reporte($where = null, $ids_parentesco_hijo = 0)
    {
        $this->db->select("  * ,            
                IF(emp_estado =1,'Activo','Inactivo') AS estado_empleado,
                IF(emp_es_reingreso =1,'sí','no') AS reingreso_empleado,
                '' emp_organigrama,
                IFNULL(
                    GROUP_CONCAT( DISTINCT TRIM(CONCAT(dce_documento_emp.dce_valor,' (',tde_tipo_documento.tde_nombre,')')) SEPARATOR ',')
                    ,'' ) AS documentos_empleado,
                IFNULL(
                    GROUP_CONCAT(DISTINCT TRIM(CONCAT(tde_tipo_documento.tde_id,'##',dce_documento_emp.dce_valor,'##',tde_tipo_documento.tde_nombre)) SEPARATOR '&&'),
                    '' ) AS param_docs_empleado, 
               IFNULL(
                GROUP_CONCAT( DISTINCT TRIM(CONCAT(tel_numero,' (',tit_nombre,')')) SEPARATOR ',')
                ,'' ) AS telefonos_empleado,

               IFNULL(
                GROUP_CONCAT( DISTINCT TRIM(cxp_correo) SEPARATOR ',')
                ,'' ) AS correo_empleado,
               
               IFNULL(
                GROUP_CONCAT( DISTINCT TRIM(tpl_nombre) SEPARATOR ',')
                ,'' ) AS tipo_planilla_empleado,

               IFNULL(
                GROUP_CONCAT( DISTINCT TRIM(seg_nombre) SEPARATOR ',')
                ,'' ) AS seguro_empleado,
               IFNULL(
                GROUP_CONCAT( DISTINCT TRIM(CONCAT(anx_nombre,' (',anx_url,')')) SEPARATOR ',')
                ,'' ) AS anexos_empleado,
               IFNULL(
                GROUP_CONCAT( DISTINCT TRIM(anx_nombre) SEPARATOR ',')
                ,'' ) AS anexos_nombre_empleado,
               IFNULL(
                GROUP_CONCAT( DISTINCT TRIM(anx_url) SEPARATOR ',')
                ,'' ) AS anexos_url_empleado,
                TRUNCATE (
                  (
                    (
                      to_days(now()) - to_days(emp_fecha_nac)
                    ) / 365
                  ),
                  0
                ) AS Anos_edad,
                (
                SELECT COUNT(DISTINCT fam_id) FROM fam_familiar 
                WHERE fam_id_emp = emp_id AND fam_id_pat in ($ids_parentesco_hijo)
                ) numero_hijos,
                a1.are_nombre area_hija,
                a2.are_nombre area_padre,
                a3.are_nombre area_padre_padre,
                a1.are_id_nia nia_area_hija,
                a2.are_id_nia nia_area_padre,
                a3.are_id_nia nia_area_padre_padre,
                IF(emp_estado = 0, 
                   (SELECT subplz.plz_nombre FROM pps_promocion_plaza_salarioxemp
                    JOIN plz_plaza subplz on subplz.plz_id = pps_id_plz
                    WHERE pps_id_emp = emp_id AND pps_estado = 1 ORDER BY pps_id DESC LIMIT 1
                )
                , CONCAT(plz_codigo,' - ',plz_nombre) ) nombre_plaza,
                IF(emp_estado = 0
                ,
                   (SELECT subplzpadre.plz_nombre FROM pps_promocion_plaza_salarioxemp
                    JOIN plz_plaza subplz on subplz.plz_id = pps_id_plz
                    JOIN plz_plaza subplzpadre on subplzpadre.plz_id = subplz.plz_id_padre
                    WHERE pps_id_emp = emp_id AND pps_estado = 1 ORDER BY pps_id DESC LIMIT 1
                ) 
                ,
                (SELECT p2.plz_nombre FROM plz_plaza p2 WHERE p2.plz_id = p1.plz_id_padre LIMIT 1) 
                ) plaza_padre
                ", false)
            ->from('emp_empleado')

            ->join('are_area a1', 'emp_id_are = a1.are_id', 'left')
            ->join('are_area a2', 'a2.are_id = a1.are_padre', 'left')
            ->join('are_area a3', 'a3.are_id = a2.are_padre', 'left')
            ->join('nia_nivel_area', 'nia_id = a1.are_id_nia', 'left')
            ->join('zon_zona', 'zon_id = emp_id_zon', 'left')
            ->join('tcv_tipo_construccion_vivienda', 'tcv_id = emp_id_tcv', 'left')
            ->join('tiv_tipo_vivienda', 'tiv_id = emp_id_tiv', 'left')
            ->join('fnr_fuente_reclutamiento', 'fnr_id = emp_id_fnr', 'left')
            ->join('tps_tipo_salario', 'tps_id = emp_id_tps', 'left')

            ->join('gen_genero', 'emp_id_gen = gen_id', 'left')
            ->join('pai_pais', 'emp_id_pai = pai_id', 'left')
            ->join('mun_municipio', 'emp_id_mun = mun_id', 'left')
            ->join('dep_departamento', 'mun_id_dep = dep_id', 'left')
            ->join('esc_estado_civil', 'emp_id_esc = esc_id', 'left')
            ->join('plz_plaza p1', 'emp_id_plz = p1.plz_id', 'left')
            ->join('deh_detalle_horario', 'deh_id = p1.plz_id_deh', 'left')
            ->join('pto_puesto', 'pto_id = p1.plz_id_pto', 'left')
            ->join('ubp_ubicacion_plaza', 'ubp_id = p1.plz_id_ubp', 'left')
            ->join('org_organigrama', 'org_id = p1.plz_id_org', 'left')
            ->join('ban_banco', 'emp_id_ban = ban_id', 'left')
            ->join('tic_tipo_contrato', 'emp_id_tic = tic_id', 'left')
            ->join('suc_sucursal', 'emp_id_suc = suc_id', 'left')
            ->join('pro_profesion', 'emp_id_pro = pro_id', 'left')
            ->join('afp_afp', 'emp_id_afp = afp_id', 'left')
            ->join('txe_tipo_planillaxempleado', 'txe_id_emp = emp_id', 'left')
            ->join('tpl_tipo_planilla', 'txe_id_tpl = tpl_id', 'left')
            ->join('txm_telefonoxempleado', 'txm_id_emp = emp_id', 'left')
            ->join('tel_telefono', 'txm_id_tel = tel_telefono.tel_id', 'left')
            ->join('cxp_correoxempleado', 'cxp_id_emp = emp_id', 'left')
            ->join('dce_documento_emp', 'dce_id_emp = emp_id', 'left')
            ->join('tde_tipo_documento', 'dce_id_tde = tde_id', 'left')
            ->join('sxe_seguroxempleado', 'sxe_id_emp = emp_id and sxe_estado=1', 'left')
            ->join('seg_seguro', 'sxe_id_seg = seg_id', 'left')
            ->join('axe_anexoxempleado', 'axe_id_emp = emp_id', 'left')
            ->join('anx_anexo', 'axe_id_anx = anx_id', 'left')
            ->join('tit_tipo_telefono', 'tel_id_tit = tit_id', 'left')
            ->join('emr_empresa', 'emr_id = emp_id_emr', 'left')
            ->group_by('emp_id');

        if (!isset($where["emp_estado"])) {
            $where["emp_estado"] = 1;
        }
        if (!isset($where['emp_id_emr'])) { //agregar el id del filtro de empresa
            $this->db->where('emp_id_emr', $this->tank_auth->get_empresa_id());
        } else {
            if ($where['emp_id_emr'] == "-1") {
                //filtrando todos los empleados de las n empresas
                unset($where['emp_id_emr']);
                //mostrando los empleados activos e inactivos
                unset($where['emp_estado']);
            }
        }
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }
    // repetido
    function get_solicitante_reporte($where = null, $ids_parentesco_hijo = 0)
    {
        $this->db->select("  * ,            
                IF(sle_estado = 1,'Activo','Inactivo') AS estado_empleado,
                IF(sle_es_reingreso =1,'sí','no') AS reingreso_empleado,
                '' emp_organigrama,
                IFNULL(
                    GROUP_CONCAT( DISTINCT TRIM(CONCAT(dcs_documento_solicitante.dcs_valor,' (',tde_tipo_documento.tde_nombre,')')) SEPARATOR ',')
                    ,'' ) AS documentos_empleado,

               IFNULL(
                GROUP_CONCAT( DISTINCT TRIM(CONCAT(tsl_numero,' (',tit_nombre,')')) SEPARATOR ',')
                ,'' ) AS telefonos_empleado,

               IFNULL(
                GROUP_CONCAT( DISTINCT TRIM(cse_correo) SEPARATOR ',')
                ,'' ) AS correo_empleado,
               IFNULL(
                GROUP_CONCAT( DISTINCT TRIM(CONCAT(ans_nombre,' (',ans_url,')')) SEPARATOR ',')
                ,'' ) AS anexos_empleado,
               IFNULL(
                GROUP_CONCAT( DISTINCT TRIM(ans_nombre) SEPARATOR ',')
                ,'' ) AS anexos_nombre_empleado,
               IFNULL(
                GROUP_CONCAT( DISTINCT TRIM(ans_url) SEPARATOR ',')
                ,'' ) AS anexos_url_empleado,
                TRUNCATE (
                  (
                    (
                      to_days(now()) - to_days(sle_fecha_nac)
                    ) / 365
                  ),
                  0
                ) AS Anos_edad,
                (
                SELECT COUNT(DISTINCT fas_id) FROM fas_familiar_solicitante
                WHERE fas_id_sle = sle_id AND fas_id_pat in ($ids_parentesco_hijo)
                ) numero_hijos,
                a1.are_nombre area_hija,
                a2.are_nombre area_padre,
                a3.are_nombre area_padre_padre,
                a1.are_id_nia nia_area_hija,
                a2.are_id_nia nia_area_padre,
                a3.are_id_nia nia_area_padre_padre
               
                ", false)
            ->from('sle_solicitante_empleo')

            ->join('are_area a1', 'sle_id_are = a1.are_id', 'left')
            ->join('are_area a2', 'a2.are_id = a1.are_padre', 'left')
            ->join('are_area a3', 'a3.are_id = a2.are_padre', 'left')
            ->join('nia_nivel_area', 'nia_id = a1.are_id_nia', 'left')
            ->join('zon_zona', 'zon_id = sle_id_zon', 'left')
            ->join('tcv_tipo_construccion_vivienda', 'tcv_id = sle_id_tcv', 'left')
            ->join('tiv_tipo_vivienda', 'tiv_id = sle_id_tiv', 'left')
            ->join('fnr_fuente_reclutamiento', 'fnr_id = sle_id_fnr', 'left')

            ->join('gen_genero', 'sle_id_gen = gen_id', 'left')
            ->join('pai_pais', 'sle_id_pai = pai_id', 'left')
            ->join('mun_municipio', 'sle_id_mun = mun_id', 'left')
            ->join('dep_departamento', 'mun_id_dep = dep_id', 'left')
            ->join('esc_estado_civil', 'sle_id_esc = esc_id', 'left')
            ->join('plz_plaza p1', 'sle_id_plz = p1.plz_id', 'left')
            ->join('deh_detalle_horario', 'deh_id = p1.plz_id_deh', 'left')
            ->join('pto_puesto', 'pto_id = p1.plz_id_pto', 'left')
            ->join('ubp_ubicacion_plaza', 'ubp_id = p1.plz_id_ubp', 'left')
            ->join('org_organigrama', 'org_id = p1.plz_id_org', 'left')
            ->join('ban_banco', 'sle_id_ban = ban_id', 'left')
            ->join('suc_sucursal', 'sle_id_suc = suc_id', 'left')
            ->join('pro_profesion', 'sle_id_pro = pro_id', 'left')
            ->join('afp_afp', 'sle_id_afp = afp_id', 'left')
            ->join('tsl_telefono_solicitante', 'tsl_id_sle = sle_id', 'left')
            ->join('cse_correo_solicitante_empleo', 'cse_id_sle = sle_id', 'left')
            ->join('dcs_documento_solicitante', 'dcs_id_sle = sle_id', 'left')
            ->join('tde_tipo_documento', 'dcs_id_tde = tde_id', 'left')
            ->join('ans_anexo_solicitante', 'ans_id_sle = sle_id', 'left')
            ->join('tit_tipo_telefono', 'tsl_id_tit = tit_id', 'left')
            ->join('emr_empresa', 'emr_id = sle_id_emr', 'left')
            ->group_by('sle_id');

        if (!isset($where["sle_estado"])) {
            $where["sle_estado"] = 1;
        }
        if (!isset($where['sle_id_emr'])) { //agregar el id del filtro de empresa
            $this->db->where('sle_id_emr', $this->tank_auth->get_empresa_id());
        } else {
            if ($where['sle_id_emr'] == "-1") {
                //filtrando todos los empleados de las n empresas
                unset($where['sle_id_emr']);
                //mostrando los empleados activos e inactivos
                unset($where['sle_estado']);
            }
        }
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }





    //rene castaneda
    function get_reporte_descuento_planilla($array = null)
    {
        $this->db->select("*,
            SUM(ddd_valor) AS total_empleado, SUM(ddd_valor_patronal) AS total_patrono, SUM(ddd_ingreso_afecto) AS total_afecto,
            (SELECT SUM(dss_cuota) FROM dss_descuento WHERE dss_estado = 1 AND dss_permanente = 0 AND dss_id_tpl = pla_id_tpl AND dss_id_emp = emp_id
                AND dss_id_tdc = tdc_id AND dss_valor = ddd_valor) AS total_cuotas,
            (SELECT SUM(dss_cuota_pagada) FROM dss_descuento WHERE dss_estado = 1 AND dss_permanente = 0 AND dss_id_tpl = pla_id_tpl 
                AND dss_id_emp = emp_id AND dss_id_tdc = tdc_id AND dss_valor = ddd_valor) AS total_cuotas_pagadas", false)
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'pla_id = ddd_id_pla')
            ->join('emp_empleado', 'emp_id = ddd_id_emp')
            ->join('tdc_tipo_descuento', 'tdc_id=ddd_id_tdc')
            ->join('dss_descuento', 'dss_id = ddd_id_dss', 'left')
            ->join('ban_banco', 'ban_id = dss_id_ban', 'left')
            ->join('afp_afp', 'afp_id = emp_id_afp', 'left')
            ->join('are_area', 'emp_id_are = are_id', 'left')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl', 'left')
            ->order_by('emp_id_are', 'ASC')
            ->order_by('emp_id', 'ASC')
            ->group_by('emp_id, tdc_id');
        if ($array) {
            $this->db->where($array);
        }
        $query = $this->db->get()->result_array();
        return $query;
    }

    public function get_rpte_descuento_planilla($where = null, $orderby = null)
    {
        // CODE VERSION ANTERIOR
        /*$this->db->select("MAX(pla_codigo) AS pla_codigo, emp_id_are, emp_codigo, emp_nombre, emp_apellido, tdc_nombre, are_nombre, SUM(ddd_valor) AS ddd_valor, SUM(ddd_valor_patronal) AS ddd_valor_patronal, SUM(ddd_ingreso_afecto) AS ddd_ingreso_afecto, emp_id_afp, emp_id_afp AS afp_id, (SELECT afp_nombre FROM afp_afp WHERE afp_id = emp_id_afp) AS afp_nombre, IFNULL((SELECT dss_permanente FROM dss_descuento WHERE dss_id = ddd_id_dss AND dss_valor = ddd_valor), 0) AS dss_permanente, IFNULL((SELECT dss_cuota_pagada FROM dss_descuento WHERE dss_id = ddd_id_dss AND dss_valor = ddd_valor AND dss_permanente = 1), 0) AS dss_cuota_pagada, IFNULL((SELECT dss_valor FROM dss_descuento WHERE dss_id = ddd_id_dss AND dss_valor = ddd_valor), 0) AS dss_valor, (SELECT SUM(dss_cuota) FROM dss_descuento WHERE dss_estado = 1 AND dss_permanente = 0 AND dss_id_tpl = pla_id_tpl AND dss_id_emp = emp_id AND dss_id_tdc = tdc_id AND dss_valor = ddd_valor) AS total_cuotas, (SELECT SUM(dss_cuota_pagada) FROM dss_descuento WHERE dss_estado = 1 AND dss_permanente = 0 AND dss_id_tpl = pla_id_tpl AND dss_id_emp = emp_id AND dss_id_tdc = tdc_id AND dss_valor = ddd_valor) AS total_cuotas_pagadas, IFNULL((SELECT dss_motivo FROM dss_descuento WHERE dss_id = ddd_id_dss AND dss_valor = ddd_valor), '') AS dss_motivo", false)->from('ddd_detalle_descuento')->join('pla_planilla', 'pla_id = ddd_id_pla')->join('emp_empleado', 'emp_id = ddd_id_emp')->join('are_area', 'emp_id_are = are_id', 'left')->join('tdc_tipo_descuento', 'tdc_id = ddd_id_tdc')->order_by('emp_id_are','ASC')
            ->order_by('emp_id', 'ASC')
            ->group_by('emp_id, tdc_id, dss_valor');
        if ($consolidado > 0) { $this->db->order_by('ddd_id_pla','ASC'); }
        */
        $this->db->select("tdc_id, emp_id, emp_id_are, IFNULL(emp_id_afp, 0) AS emp_id_afp, emp_codigo, emp_nombre, emp_apellido, tdc_nombre, SUM( ddd_valor ) AS suma_descuento,
            SUM( ddd_valor_patronal ) AS suma_patronal, SUM( ddd_ingreso_afecto ) AS suma_ingreso_afecto, IFNULL(( SUM( dss_cuota ) / COUNT( ddd_id_dss )), 0 ) AS promedio_cuotas,
            IFNULL( dss_valor, 0 ) AS valor_cuota, COUNT( ddd_id ) AS veces, IFNULL(( SUM( dss_cuota_pagada ) / COUNT( ddd_id_dss )), 0 ) AS cuota_pagada, 
            IFNULL( dss_fecha_desde, '' ) AS fecha_inicio, IFNULL( dss_referencia, '' ) AS referencia, GROUP_CONCAT( pla_id ) AS planillas, IFNULL( dss_id, 0 ) AS dss_adicional, 
            IFNULL( dss_motivo, '' ) AS dss_motivo, ( SELECT are_nombre FROM are_area WHERE are_id = emp_id_are ) AS area_nombre, IFNULL( dss_permanente,- 1 ) AS permanente,
            ( SELECT afp_nombre FROM afp_afp WHERE afp_id = emp_id_afp ) AS afp_nombre", false)
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'pla_id = ddd_id_pla')
            ->join('emp_empleado', 'emp_id = ddd_id_emp')
            ->join('tdc_tipo_descuento', 'tdc_id = ddd_id_tdc')
            ->join('dss_descuento', 'dss_id = ddd_id_dss', 'LEFT')
            ->group_by("emp_id, tdc_id, dss_referencia, ddd_valor");
        if ($where) {
            $this->db->where($where);
        }
        if ($orderby) {
            $this->db->order_by($orderby);
        }
        $query = $this->db->get()->result_array();
        return $query;
    }

    function get_rpte_descuentos_bancarios($array = null)
    {
        $this->db->select("tdc_id, IFNULL(ban_id, 0) AS ban_id, ddd_valor, emp_codigo, emp_nombre, emp_apellido, tdc_nombre, tpl_nombre, pla_codigo, are_nombre,
            IFNULL(ban_nombre, 'Banco No Definido') AS ban_nombre, dss_referencia", false)
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'pla_id = ddd_id_pla')
            ->join('emp_empleado', 'emp_id = ddd_id_emp')
            ->join('tdc_tipo_descuento', 'tdc_id=ddd_id_tdc')
            ->join('dss_descuento', 'dss_id = ddd_id_dss', 'left')
            ->join('ban_banco', 'ban_id = dss_id_ban', 'left')
            ->join('are_area', 'emp_id_are = are_id', 'left')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl', 'left')
            ->order_by('dss_id_ban, emp_id, ddd_id_tdc, ddd_id_pla', 'ASC');
        if ($array) {
            $this->db->where($array);
        }
        return $this->db->get()->result_array();
    }

    //rene castaneda
    function get_reporte_ingreso_planilla($array = null, $reporte_vacacion = false)
    {

        if ($reporte_vacacion) {
            $this->db->select("*, SUM(ddi_valor) as suma_v, GROUP_CONCAT(ddi_valor SEPARATOR '#')  as vaca, 
                GROUP_CONCAT(ddi_id_tig SEPARATOR '#')  as vaca_ids, YEAR(pla_fecha_fin) as year_planilla", false)
                ->from('ddi_detalle_ingreso')
                ->join('emp_empleado', 'emp_id=ddi_id_emp')
                ->join('tig_tipo_ingreso', 'tig_id=ddi_id_tig')
                ->join('pla_planilla', 'pla_id=ddi_id_pla')
                ->join('inn_ingreso', 'inn_id = ddi_id_inn', 'left')
                ->join('are_area', 'emp_id_are=are_id', 'left')
                ->group_by('ddi_id_emp,ddi_id_pla')
                ->order_by('emp_id_are')
                ->order_by('ddi_id_pla');
            if ($array) {
                $this->db->where($array);
            }
            $query = $this->db->get()->result_array();
        } else {

            $this->db->select()
                ->from('ddi_detalle_ingreso')
                ->join('emp_empleado', 'emp_id=ddi_id_emp')
                ->join('tig_tipo_ingreso', 'tig_id=ddi_id_tig')
                ->join('pla_planilla', 'pla_id=ddi_id_pla')
                ->join('inn_ingreso', 'inn_id = ddi_id_inn', 'left')
                ->join('are_area', 'emp_id_are=are_id', 'left')
                ->order_by('emp_id_are')
                ->order_by('ddi_id_pla');
            if ($array) {
                $this->db->where($array);
            }
            $query = $this->db->get()->result_array();
        }

        return $query;
    }

    //rene castaneda
    function get_cumplen_anio_laboral($fecha, $ids_emp = false)
    {
        $fecha =  date('Y-m-d', strtotime($fecha));
        $fecha_mes = formatear_fecha('Ym', $fecha);
        $this->db->select("emp_empleado.*, DATEDIFF('$fecha',emp_fecha_contrato) AS tiempo, 
            PERIOD_DIFF('$fecha_mes', DATE_FORMAT(emp_fecha_contrato,'%Y%m')) AS meses", false) //ROUND((DATEDIFF('$fecha',emp_fecha_contrato)/30),0)
            ->from('emp_empleado')
            ->where('emp_estado', 1)
            ->where("MOD(PERIOD_DIFF('$fecha_mes', DATE_FORMAT(emp_fecha_contrato,'%Y%m')), 12) = 0");
        $query = $this->db->get()->result_array();
        if (!$ids_emp) {
            return $query;
        } else {
            $idEmp = array(0);
            foreach ($query as $k) {
                $idEmp[] = $k['emp_id'];
            }
            return $idEmp;
        }
    }

    /**
     * @author Boris Estrada
     * Determinar por medio de los agrupadores asociados si a la planilla se le aplica AFP
     */
    /*    public function aplica_afp($planilla){
      $this->db->select()
      ->from('pla_planilla')
      ->join('tpl_tipo_planilla', 'tpl_id=pla_id_tpl')
      ->join('dtp_descuentoxtipo_planilla', 'dtp_id_tpl=tpl_id')
      ->join('tdc_tipo_descuento', 'tdc_id=dtp_id_tdc')
      ->where('pla_id', $planilla)
      ->where('tdc_id', 6);
      #Valor de AFP
      $consulta=$this->db->get();
      $datos=$consulta->result_array();
      return (count($datos)>0)? 1: 0;
      } */

    /**
     * 
     */
    public function agrupadores_planilla($tipo_planilla)
    {
        $this->db->select('tag_id')
            ->from('dtp_descuentoxtipo_planilla')
            ->join('tdc_tipo_descuento', 'tdc_id = dtp_id_tdc')
            ->join('tag_tipo_agrupador', 'tag_id = tdc_agrupador')
            ->where('dtp_id_tpl', $tipo_planilla)
            ->group_by('tag_id');
        $consulta = $this->db->get();
        $datos = $consulta->result_array();
        return $datos;
    }

    /**
     * 
     */
    public function ingresos_agrupador($agrupador)
    {
        $this->db->select('deg_id_tig, deg_id_tdc')
            ->from('deg_detalle_agrupador')
            ->where('deg_id_tag', $agrupador);
        $consulta = $this->db->get();
        $datos = $consulta->result_array();
        return $datos;
    }

    /**
     * 
     */
    public function valor_calculo_afp($planilla, $empleado, $ingresos, $descuentos_agrupador = null)
    {
        $desc = (count($descuentos_agrupador) > 0) ? implode(',', $descuentos_agrupador) : 0;
        // if ($empleado == 679) { var_dump($desc); die();  } //para debuger
        $this->db->select("emp_id, afp_id, emp_salario, afp_maximo, 
            (SUM(ddi_valor) - IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento WHERE ddd_id_emp = emp_id AND ddd_id_pla = $planilla
            AND ddd_id_tdc IN ($desc)), 0)) AS monto_afecto, ((SUM(ddi_valor) - IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento 
            WHERE ddd_id_emp = emp_id AND ddd_id_pla = $planilla AND ddd_id_tdc IN ($desc)), 0)) * (afp_porcentaje / 100)) AS asegurado,
            ((SUM(ddi_valor) - IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento WHERE ddd_id_emp = emp_id AND ddd_id_pla = $planilla
            AND ddd_id_tdc IN ($desc)), 0)) * (afp_porcentaje_patrono / 100) ) AS patrono", false)
            ->from('emp_empleado')
            ->join('afp_afp', 'emp_id_afp = afp_id')
            ->join('ddi_detalle_ingreso', 'ddi_id_emp = emp_id')
            // ->join('ddd_detalle_descuento', "ddd_id_emp=emp_id AND ddd_id_pla=$planilla AND ddd_id_tdc IN ($desc) ", 'left')
            ->where('emp_estado', 1)
            ->where('afp_activo', 1)
            ->where('emp_id', $empleado)
            ->where('ddi_id_pla', $planilla)
            ->where_in('ddi_id_tig', $ingresos);
        $consulta = $this->db->get();
        $datos = $consulta->result_array();
        /* if($empleado==432) {
          print_r($this->db->last_query()); die();
          } */
        return $datos;
    }

    /**
     * @author Edith Herrera
     * @return Obtiene el reporte AFP
     */
    public function get_reporte_afp($where = null, $groupby = null, $orderby = null)
    {

        $id_descuento_afp = ($this->gsatelite->get_parametro('DESCUENTO_AFP') > 0) ? $this->gsatelite->get_parametro('DESCUENTO_AFP') : null;
        $nit = ($this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT') > 0) ? $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT') : null;
        $dui = ($this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI') > 0) ? $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI') : null;
        $hxd = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA', 8);

        $this->db->select("*,
                        (SELECT dce_valor FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = " . $dui . " LIMIT 1) AS dui,
                        (SELECT dce_valor FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = " . $nit . " LIMIT 1) AS nit,
                        (SELECT tel_numero FROM tel_telefono INNER JOIN txm_telefonoxempleado ON txm_id_tel = tel_id WHERE txm_id_emp = emp_id LIMIT 1) AS telefono,
                        (SELECT cxp_correo FROM cxp_correoxempleado WHERE cxp_id_emp = emp_id LIMIT 1) AS correo,
                        (SUM(ddd_valor)) AS total_valor,
                        (SUM(ddd_valor_patronal)) AS total_patronal,
                        (SUM(ddd_valor) + SUM(ddd_valor_patronal)) AS neto,
                        (SUM(ddd_ingreso_afecto)) AS total_ingreso_afecto,
                        (SELECT (sum(tpl_frecuencia) - IFNULL(FLOOR((SUM(hxe_num_hora) / $hxd)), 0))) AS dias_trabajados
                    ", false)
            ->from('pla_planilla')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl')
            ->join('ddd_detalle_descuento', 'pla_id = ddd_id_pla')
            ->join('emp_empleado', 'emp_id = ddd_id_emp')
            ->join('plz_plaza', 'plz_id = emp_id_plz', 'left')
            ->join('afp_afp', 'afp_id = emp_id_afp')
            ->join('gen_genero', 'gen_id = emp_id_gen')
            ->join('pai_pais', 'pai_id = emp_id_pai', 'left')
            ->join('mun_municipio', 'mun_id = emp_id_mun', 'left')
            ->join('dep_departamento', 'dep_id = mun_id_dep', 'left')
            ->join('esc_estado_civil', 'esc_id = emp_id_esc', 'left')
            ->join('hxe_hora_extraxempleado', 'pla_id = hxe_id_pla AND emp_id = hxe_id_emp AND hxe_id_thf is not NULL', 'left')
            // ->where('pla_id_tpl', $tpl)
            // ->where('ddd_id_pla', $planilla)
            // ->group_by('ddd_id_emp,ddd_id_pla')
            // ->order_by('emp_id_are')
            // ->order_by('ddd_id_pla')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        $query = $this->db->get()->result_array();
        // die(print_r($this->db->last_query()));
        return $query;
    }

    public function get_reporte_afp2($where = null, $fecha_inicio = null, $fecha_final = null, $revision = null)
    {
        $ini = formatear_fecha('Y-m-d', $fecha_inicio);
        $fin = formatear_fecha('Y-m-d', $fecha_final);
        $afp = $this->gsatelite->get_parametro('DESCUENTO_AFP', 0);
        $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT', 0);
        $dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI', 0);
        $hxd = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA', 8);
        /* PENDIENTES CREAR / VERIFICAR PARAMETRO DE DIAS POR TIPO INCAPACIDAD PUES EMPRESA NO PAGA ENFERMEDAD COMUN A PARTIR DEL DIA 4 (inc_dias > 3), PERO ENFERMEDAD PROFESIONAL ES A PARTIR DEL DIA 2 (inc_dias > 1) Y LAS MATERNIDADES SON 112 DIAS DEBIENDO ESTAR LA FECHA DEL PARTO DENTRO DE ESOS 112 */
        //DE MOMENTO, LAS INCAPACIDADES DE 4+ DIAS, LOS 3 PRIMEROS DIAS LOS PAGA LA EMPRESA POR LO QUE SE DEJAN ESOS 3 PRIMEROS EJ. INCAP DE 5 DIAS, SE DESCUENTAN 2 A LOS DIAS COTIZADOS
        $this->db->select("*, (SELECT are_nombre FROM are_area WHERE are_id = emp_id_are) AS area_nombre,
            (SELECT dce_valor FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = $dui LIMIT 1) AS dui,
            (SELECT dce_valor FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = $nit LIMIT 1) AS nit,
            (SELECT tel_numero FROM tel_telefono INNER JOIN txm_telefonoxempleado ON txm_id_tel = tel_id WHERE txm_id_emp = emp_id LIMIT 1) AS telefono,
            (SELECT cxp_correo FROM cxp_correoxempleado WHERE cxp_id_emp = emp_id LIMIT 1) AS correo,
            SUM(ddd_valor) AS total_valor,
            SUM(ddd_valor_patronal) AS total_patronal,
            (SUM(ddd_valor) + SUM(ddd_valor_patronal)) AS neto,
            SUM(ddd_ingreso_afecto) AS total_ingreso_afecto,
            IFNULL(
                (SELECT SUM(
                    CASE 
                        WHEN DATE(inc_fecha_inicio) >= '$ini' AND DATE(inc_fecha_fin) <= '$fin' THEN
                            (inc_dias - 3)
                        WHEN DATE(inc_fecha_inicio) < '$ini' AND DATE(inc_fecha_fin) BETWEEN '$ini' AND '$fin' THEN
                            (TIMESTAMPDIFF(DAY, '$ini', inc_fecha_fin) + 1)
                        WHEN DATE(inc_fecha_fin) > '$fin' AND DATE(inc_fecha_inicio) BETWEEN '$ini' AND '$fin' THEN
                            (TIMESTAMPDIFF(DAY, inc_fecha_inicio, '$fin' ) - 2)
                        WHEN DATE(inc_fecha_inicio) < '$ini' AND DATE(inc_fecha_fin) > '$fin' THEN
                        (TIMESTAMPDIFF(DAY, '$ini', '$fin') + 1)
                        ELSE 0
                        END
                    ) FROM inc_incapacidad WHERE inc_estado = 1 AND inc_dias > 3 AND inc_id_emp = emp_id
                ), 0
            ) AS incapacidades,
            IFNULL(
                (SELECT SUM(FLOOR(IF(DATE(hxe_fecha_fin) > '$fin', (TIMESTAMPDIFF(DAY, DATE(hxe_fecha), '$fin') + 1), (hxe_num_hora / $hxd)))) FROM hxe_hora_extraxempleado 
                    JOIN thf_tipo_hora_faltante ON thf_id = hxe_id_thf WHERE hxe_estado = 1 AND hxe_id_emp = emp_id AND DATE(hxe_fecha) BETWEEN '$ini' AND '$fin'
                    AND thf_id_tdc IS NOT NULL),
            0) AS permiso_sin_goce,
            CASE
                WHEN DATE(emp_fecha_contrato) BETWEEN '$ini' AND '$fin' AND (DATE(emp_fecha_retiro) > '$fin' OR emp_fecha_retiro IS NULL) THEN
                    (TIMESTAMPDIFF(DAY, emp_fecha_contrato, '$fin') + 1)
                WHEN DATE(emp_fecha_retiro) BETWEEN '$ini' AND '$fin' THEN
                    IF(DATE(emp_fecha_contrato) <= '$ini',
                        IF((TIMESTAMPDIFF(DAY, '$ini', emp_fecha_retiro) + 1) > MAX(tpl_frecuencia * tpl_cantidad),
                            MAX(tpl_frecuencia * tpl_cantidad),
                            (TIMESTAMPDIFF(DAY, '$ini', emp_fecha_retiro) + 1)
                        ),
                        (TIMESTAMPDIFF(DAY, emp_fecha_contrato, emp_fecha_retiro) + 1)
                    )
                ELSE MAX(tpl_frecuencia * tpl_cantidad)
            END AS dias_trabajados
            ", false) //(TIMESTAMPDIFF(DAY, inc_fecha_inicio, '$fin' ) - 2)  <==> +1-3
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'pla_id = ddd_id_pla')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl')
            ->join('emp_empleado', 'emp_id = ddd_id_emp')
            ->join('afp_afp', 'afp_id = emp_id_afp')
            ->join('gen_genero', 'gen_id = emp_id_gen')
            ->join('plz_plaza', 'plz_id = emp_id_plz', 'LEFT')
            ->join('pai_pais', 'pai_id = emp_id_pai', 'LEFT')
            ->join('mun_municipio', 'mun_id = emp_id_mun', 'LEFT')
            ->join('dep_departamento', 'dep_id = mun_id_dep', 'LEFT')
            ->join('esc_estado_civil', 'esc_id = emp_id_esc', 'LEFT')
            ->group_by('emp_id')
            // ->order_by('emp_id_are, emp_id')
        ;
        if ($revision) {
            $this->db->order_by('emp_id_afp ASC, emp_id_are ASC, emp_id ASC');
        } else {
            $this->db->order_by('emp_id_are ASC, emp_id ASC');
        }

        if ($where) {
            $this->db->where($where);
        }
        $query = $this->db->get()->result_array();
        return $query;
    }

    public function get_reporte_isss_rev($where = null, $fecha_inicio = null, $fecha_final = null, $revision = null)
    {
        $ini = formatear_fecha('Y-m-d', $fecha_inicio);
        $fin = formatear_fecha('Y-m-d', $fecha_final);
        $hxd = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA', 8);
        $dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI', 0);
        $isss = $this->gsatelite->get_parametro('DESCUENTO_ISS', 0);
        $agrp = $this->gsatelite->get_parametro('AGRUPADOR_ISS', 0);
        $salr = $this->gsatelite->get_parametro('INGRESO_SALARIO', 0);
        $dscv = $this->gsatelite->get_parametro('ID_TDC_VACACION', 0);
        $dvac = $this->gsatelite->get_parametro('INGRESO_VACACIONES', 0);
        $pvac = $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION', 0);
        $this->db->select("*, (SELECT dce_valor FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = $dui LIMIT 1) AS dui,
            SUM(ddd_valor) AS total_valor, SUM(ddd_valor_patronal) AS total_patronal, SUM(ddd_ingreso_afecto) AS total_ingreso_afecto,            
            (SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON ddi_id_pla = pla_id WHERE ddi_id_emp = emp_id AND pla_fecha_inicio >= '$ini'
                AND pla_fecha_fin <= '$fin' AND ddi_id_tig = $salr) AS solo_salario,
            (SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_fecha_inicio >= '$ini'
                AND pla_fecha_fin <= '$fin' AND ddi_id_tig = $salr) 
                -
                IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento JOIN pla_planilla ON pla_id = ddd_id_pla WHERE ddd_id_emp = emp_id AND pla_fecha_inicio >= '$ini'
                AND pla_fecha_fin <= '$fin'  AND ddd_id_tdc = $dscv), 0
            ) AS salario,
            IFNULL(
                (SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON ddi_id_pla = pla_id WHERE ddi_id_emp = emp_id AND pla_fecha_inicio >= '$ini'
                AND pla_fecha_fin <= '$fin' AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag = $agrp AND ddi_id_tig IS NOT NULL)
                AND ddi_id_tig = $dvac ),
            0) AS vacaciones,
            IFNULL(
                (SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON ddi_id_pla = pla_id WHERE ddi_id_emp = emp_id AND pla_fecha_inicio >= '$ini'
                AND pla_fecha_fin <= '$fin' AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag = $agrp AND ddi_id_tig IS NOT NULL)
                AND ddi_id_tig = $pvac ),
            0) AS prima_vacaciones,
            IFNULL(
                (SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON ddi_id_pla = pla_id WHERE ddi_id_emp = emp_id AND pla_fecha_inicio >= '$ini'
                AND pla_fecha_fin <= '$fin' AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag = $agrp AND ddi_id_tig IS NOT NULL)
                AND ddi_id_tig NOT IN($salr, $dvac, $pvac)),
            0) AS adicional,
            IFNULL(
                (SELECT SUM(
                    CASE 
                        WHEN DATE(inc_fecha_inicio) >= '$ini' AND DATE(inc_fecha_fin) <= '$fin' THEN
                            (inc_dias - 3)
                        WHEN DATE(inc_fecha_inicio) < '$ini' AND DATE(inc_fecha_fin) BETWEEN '$ini' AND '$fin' THEN
                            (TIMESTAMPDIFF(DAY, '$ini', inc_fecha_fin) + 1)
                        WHEN DATE(inc_fecha_fin) > '$fin' AND DATE(inc_fecha_inicio) BETWEEN '$ini' AND '$fin' THEN
                            (TIMESTAMPDIFF(DAY, inc_fecha_inicio, '$fin' ) - 2)
                        WHEN DATE(inc_fecha_inicio) < '$ini' AND DATE(inc_fecha_fin) > '$fin' THEN
                        (TIMESTAMPDIFF(DAY, '$ini', '$fin') + 1)
                        ELSE 0
                        END
                    ) FROM inc_incapacidad WHERE inc_estado = 1 AND inc_dias > 3 AND inc_id_emp = emp_id
                ), 0
            ) AS incapacidades,
            IFNULL(
                (SELECT tpl_frecuencia FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla JOIN tpl_tipo_planilla ON tpl_id = pla_id_tpl 
                WHERE ddi_id_emp = emp_id AND pla_fecha_inicio >= '$ini' AND pla_fecha_fin <= '$fin' AND pla_id_tpl IN ($this->tpl_vacacion) AND ddi_id_tig IN (SELECT deg_id_tig 
                FROM deg_detalle_agrupador WHERE deg_id_tag = $agrp AND ddi_id_tig IS NOT NULL) AND ddi_id_tig IN ($dvac, $pvac) GROUP BY tpl_id LIMIT 1
                ), 0
            ) AS vaca_dias,
            IFNULL(
                (SELECT SUM(FLOOR(IF(DATE(hxe_fecha_fin) > '$fin', (TIMESTAMPDIFF(DAY, DATE(hxe_fecha), '$fin') + 1), (hxe_num_hora / $hxd)))) FROM hxe_hora_extraxempleado 
                    JOIN thf_tipo_hora_faltante ON thf_id = hxe_id_thf WHERE hxe_estado = 1 AND hxe_id_emp = emp_id AND DATE(hxe_fecha) BETWEEN '$ini' AND '$fin'
                    AND thf_id_tdc IS NOT NULL),
            0) AS permiso_sin_goce,
            CASE WHEN DATE(emp_fecha_contrato) BETWEEN '$ini' AND '$fin' AND (DATE(emp_fecha_retiro) > '$fin' OR emp_fecha_retiro IS NULL)
                    THEN (TIMESTAMPDIFF(DAY, emp_fecha_contrato, '$fin') + 1)
                WHEN DATE(emp_fecha_retiro) BETWEEN '$ini' AND '$fin' 
                    THEN IF(DATE(emp_fecha_contrato) <= '$ini',
                        IF((TIMESTAMPDIFF(DAY, '$ini', emp_fecha_retiro) + 1) > MAX(tpl_frecuencia * tpl_cantidad),
                            MAX(tpl_frecuencia * tpl_cantidad),
                            (TIMESTAMPDIFF(DAY, '$ini', emp_fecha_retiro) + 1)
                        ),
                        (TIMESTAMPDIFF(DAY, emp_fecha_contrato, emp_fecha_retiro) + 1)
                    )
                ELSE MAX(tpl_frecuencia * tpl_cantidad)
            END AS dias_trabajados
            ", false)
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'pla_id = ddd_id_pla')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl')
            ->join('emp_empleado', 'emp_id = ddd_id_emp')
            ->group_by('emp_id');
        if ($revision) {
            $this->db->order_by('emp_apellido ASC, emp_id ASC');
        } else {
            $this->db->order_by('emp_codigo ASC, emp_id ASC');
        }
        if ($where) {
            $this->db->where($where);
        }
        $query = $this->db->get()->result_array();
        return $query;
    }

    public function get_detalles_plan_unica($where = null, $fecha_inicio = null, $fecha_final = null)
    {
        $f_1 = ($fecha_inicio) ? formatear_fecha('Y-m-d', $fecha_inicio) : date('Y-m-d');
        $f_2 = ($fecha_final) ? formatear_fecha('Y-m-d', $fecha_final) : date('Y-m-d');
        $nit = ($this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT') > 0) ? $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT') : 0;
        $dui = ($this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI') > 0) ? $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI') : 0;
        $porvac = ($this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION') > 0) ? $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION') : 0;
        $dscvac = ($this->gsatelite->get_parametro('ID_TDC_VACACION') > 0) ? $this->gsatelite->get_parametro('ID_TDC_VACACION') : 0;
        $parvac = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_VACACION'), true);
        $tagvac = ($parvac['ID_AGRUPADOR_VACACION'] > 0) ? $parvac['ID_AGRUPADOR_VACACION'] : 0;
        $this->db->select("DATE_FORMAT(pla_fecha_pago,'%Y%m') AS periodo, '001' AS centro_trabajo /*SUCURSAL?*/,  emp_seguro, afp_codigo, emp_nombre, emp_apellido, emp_salario,
            IFNULL((SELECT CONCAT(dce_id_tde,'##',tde_nombre,'##',dce_valor) FROM dce_documento_emp JOIN tde_tipo_documento ON tde_id = dce_id_tde WHERE dce_id_emp = emp_id AND tde_id = $dui),
                (SELECT CONCAT(dce_id_tde,'##',tde_nombre,'##',dce_valor) FROM dce_documento_emp JOIN tde_tipo_documento ON tde_id = dce_id_tde WHERE dce_id_emp = emp_id AND tde_id = $nit)) AS doc_emp, emp_fecha_contrato, emp_fecha_retiro, emp_es_jubilado, MAX(tpl_frecuencia) AS max_frecuencia,
            IF(SUBSTRING_INDEX(LOWER(emp_apellido),' de ',-1) = emp_apellido,'',SUBSTRING_INDEX(LOWER(emp_apellido),' de ',-1)) AS ape_casada,
            IFNULL(((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_fecha_inicio >= '$f_1' AND pla_fecha_fin <= '$f_2' 
                AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag IN ($this->agrupador_afp,$this->agrupador_isss,$this->agrupador_salario) AND ddi_id_tig IS NOT NULL) 
                AND ddi_id_tig = $this->tig_salario) - IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento JOIN pla_planilla ON pla_id = ddd_id_pla WHERE ddd_id_emp = emp_id AND pla_fecha_inicio >= '$f_1' AND pla_fecha_fin <= '$f_2' AND ddd_id_tdc = $dscvac), 0)), 0) AS sal_dev_no_vac,
            IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON ddi_id_pla = pla_id WHERE ddi_id_emp = emp_id AND pla_fecha_inicio >= '$f_1' AND pla_fecha_fin <= '$f_2' 
                AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag = $tagvac AND ddi_id_tig IS NOT NULL) AND ddi_id_tig = $this->tig_vacacion), 0) AS vacaciones,
            IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON ddi_id_pla = pla_id WHERE ddi_id_emp = emp_id AND pla_fecha_inicio >= '$f_1' AND pla_fecha_fin <= '$f_2'
                AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag = $tagvac AND ddi_id_tig IS NOT NULL) AND ddi_id_tig = $porvac), 0) AS prima_vacaciones,
            IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON ddi_id_pla = pla_id WHERE ddi_id_emp = emp_id AND pla_fecha_inicio >= '$f_1' AND pla_fecha_fin <= '$f_2' 
                AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag IN ($this->agrupador_salario,$this->agrupador_afp,$this->agrupador_isss) AND ddi_id_tig IS NOT NULL) 
                AND ddi_id_tig NOT IN($this->tig_salario, $this->tig_vacacion, $porvac)), 0) AS adicional,
            CASE WHEN DATE(emp_fecha_contrato) BETWEEN '$f_1' AND '$f_2' AND (DATE(emp_fecha_retiro) > '$f_2' OR emp_fecha_retiro IS NULL) THEN (TIMESTAMPDIFF(DAY, emp_fecha_contrato, '$f_2') + 1) 
                WHEN DATE(emp_fecha_retiro) BETWEEN '$f_1' AND '$f_2' THEN IF(DATE(emp_fecha_contrato) <= '$f_1', IF((TIMESTAMPDIFF(DAY, '$f_1', emp_fecha_retiro) + 1) > 
                MAX(tpl_frecuencia * tpl_cantidad), MAX(tpl_frecuencia * tpl_cantidad), (TIMESTAMPDIFF(DAY, '$f_1', emp_fecha_retiro) + 1)), (TIMESTAMPDIFF(DAY, emp_fecha_contrato, 
                emp_fecha_retiro) + 1)) ELSE MAX(tpl_frecuencia * tpl_cantidad) END AS dias_trabajados,
            IFNULL((SELECT SUM(CASE WHEN DATE(inc_fecha_inicio) >= '$f_1' AND DATE(inc_fecha_fin) <= '$f_2' THEN (inc_dias - 3) WHEN DATE(inc_fecha_inicio) < '$f_1' AND DATE(inc_fecha_fin) 
                BETWEEN '$f_1' AND '$f_2' THEN (TIMESTAMPDIFF(DAY, '$f_1', inc_fecha_fin) + 1) WHEN DATE(inc_fecha_fin) > '$f_2' AND DATE(inc_fecha_inicio) BETWEEN '$f_1' AND '$f_2' THEN 
                (TIMESTAMPDIFF(DAY, inc_fecha_inicio, '$f_2') - 2) WHEN DATE(inc_fecha_inicio) < '$f_1' AND DATE(inc_fecha_fin) > '$f_2' THEN (TIMESTAMPDIFF(DAY, '$f_1', '$f_2') + 1) 
                ELSE 0 END) FROM inc_incapacidad WHERE inc_estado = 1 AND inc_dias > 3 AND inc_id_emp = emp_id), 0) AS incapacidades,
            IFNULL((SELECT tpl_frecuencia FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla JOIN tpl_tipo_planilla ON tpl_id = pla_id_tpl WHERE ddi_id_emp = emp_id AND pla_fecha_inicio >= '$f_1' AND pla_fecha_fin <= '$f_2' AND pla_id_tpl IN ($this->tpl_vacacion) AND ddi_id_tig IN ($this->tig_vacacion, $porvac) GROUP BY tpl_id LIMIT 1), 
                0) AS vaca_dias,
            IFNULL((SELECT SUM(FLOOR(IF(DATE(hxe_fecha_fin) > '$f_2', (TIMESTAMPDIFF(DAY, DATE(hxe_fecha), '$f_2') + 1), (hxe_num_hora / 8)))) FROM hxe_hora_extraxempleado 
                JOIN thf_tipo_hora_faltante ON thf_id = hxe_id_thf WHERE hxe_estado = 1 AND hxe_id_emp = emp_id AND DATE(hxe_fecha) BETWEEN '$f_1' AND '$f_2' AND thf_id_tdc IS NOT NULL), 
                0) AS permiso_sin_goce
            ", false)
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'pla_id = ddd_id_pla')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl')
            ->join('emp_empleado', 'emp_id = ddd_id_emp')
            ->join('afp_afp', 'afp_id = emp_id_afp')
            ->group_by('emp_id')
            ->having('sal_dev_no_vac > 0 OR vacaciones > 0 OR prima_vacaciones > 0 OR adicional > 0')
            ->order_by('emp_apellido');
        if ($where) {
            $this->db->where($where);
        }
        $query = $this->db->get()->result_array();
        // var_dump($this->db->last_query());die();
        return $query;
    }

    /**
     * @author René Castaneda
     * @return el promedio del total devengado por un empleado basado en una cantida
     * determinada planilla planillas autorizadas
     */
    function get_promedio_ingreso_empleado($id_empleado = 0, $n_num_periodos = null, $return_planillas = null, $id_tipo_pla = 0, $sin_comision = null, $solo_comision = null)
    {
        //$id_empleado = empleado al que se le hara el calculo
        //$n_num_periodos = numero de planillas ya procesadas (autorizadas) para preguntar por los ingresos y hacer un promedio
        //si el dato viene nulo se tomara como valor el parametro preestablecido "NUM_PLANILLAS_CALCULO_VACACION"
        //al final el promedio se obtendra de la suma de los ingresos por planilla 
        //divida entre el numero de planillas encontradas (el limit no me asegura que se encuntre dicha cantidad exacta 
        //asi que lo mas seguro es hacer por el numero de registro devuelto por la consulta)
        if ($n_num_periodos) {
            $n_num_periodos = $n_num_periodos;
        } else {
            //preguntar por el parametro
            $parametro_calculo_vacacion = $this->gsatelite->get_parametro('NUM_PLANILLAS_CALCULO_VACACION');
            $n_num_periodos = $parametro_calculo_vacacion;
        }
        //NOTA NO SE UTILIZÓ  LA FUNCION AVG O SUM PORQUE EL CALCULO NO SE BASABA EN EL LIMIT Y EL CALCULO ERA EL ERRONEO
        //OBTENER EL NUMERO DE PLANILLAS ENCONTRADAS SEGUN EL LIMIT
        $query_pla = $this->db->select("ddi_id_pla, pla_fecha_fin")
            ->from("ddi_detalle_ingreso")
            ->join("pla_planilla", "pla_id = ddi_id_pla")
            ->where("ddi_id_emp", $id_empleado)
            ->where("pla_estado", 3) // estado autorizada
            ->group_by("pla_id")
            ->order_by("pla_fecha_fin", "DESC")
            ->limit(1);
        if ($id_tipo_pla > 0) {
            $this->db->where('pla_id_tpl', $id_tipo_pla);
        }

        $query_pla =  $query_pla->get()->row_array();
        // print_r($this->db->last_query()); die();
        //print_r($query_pla);die();
        if (!$query_pla) {
            return 0;
        }

        // obtener la fecha de n meses hacia atras a partir de la fecha de ultima planilla generada.
        $fecha_fin = $query_pla['pla_fecha_fin'];
        $fecha = date_create($fecha_fin);
        date_add($fecha, date_interval_create_from_date_string("-$n_num_periodos month"));
        $fecha_inicio = date_format($fecha, 'Y-m-01');


        /*
        $id_planillas = array(0);
        foreach ($query_pla as $fila_pla) {
            $id_planillas[] = $fila_pla['ddi_id_pla'];
        }
        $n_planillas_encontradas = count($query_pla);
        */
        //  print_r($n_planillas_encontradas); die();

        $query = $this->db->select("IFNULL(SUM(ddi_valor),0) AS VALOR_INGRESO, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses", false)
            ->from("ddi_detalle_ingreso")
            ->join("pla_planilla", "pla_id = ddi_id_pla")
            ->where("ddi_id_emp", $id_empleado)
            ->where("pla_estado", 3) // estado autorizada
            ->where("pla_fecha_inicio >=", $fecha_inicio)
            ->where("pla_fecha_fin <=", $fecha_fin)
            // ->where_in('ddi_id_pla', $id_planillas)
            ->order_by("pla_id", "DESC");
        if ($id_tipo_pla > 0) {
            $this->db->where('pla_id_tpl', $id_tipo_pla);
        }

        if ($solo_comision != null) {
            $this->db->where('ddi_id_tig', $sin_comision);
        } else {
            if ($sin_comision != null) {
                $this->db->where('ddi_id_tig <>', $sin_comision);
            }
        }

        $query =  $query->get()->row_array();

        $suma_ingresos = $query['VALOR_INGRESO'];

        if ($solo_comision > 0) {
            $n_planillas_encontradas = $solo_comision;
        } else {
            $n_planillas_encontradas = $query['meses'];
        }
        /*
        foreach ($query as $fila_v) {
            $suma_ingresos += $fila_v['ddi_valor'];
        } */

        $promedio = ($suma_ingresos > 0) ? ($suma_ingresos / $n_planillas_encontradas) : 0;
        // die(print_r($suma_ingresos));
        //  echo $promedio; die();
        if ($return_planillas != null) {
            return array($promedio, $n_planillas_encontradas);
        } else {
            return $promedio;
        }
    }

    /**
     * @author Mario Marquez
     * @return planilla estructura de planilla  isss
     * genera_archivo_txt (boolean) = bandera para indicar si se trata de la generación del archivo txt
     * consolidado (array) = datos para indicar si se trata de un consolidado de varias planillas. 
     *
     */
    function print_detalle_planilla_bnk($planilla_id, $usuario = null, $tipo = null, $sin_header = null, $genera_archivo_txt = false, $consolidado = null, $filtro_forma_pago = 0)
    {
        //preguntar si hay planillas migradas
        //preguntar por las planillas migradas para omitir esta operación. mediante un parametro
        $planilla_migradas = $this->gsatelite->get_parametro('PLANILLAS_MIGRADAS');

        //$id_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');

        $id_dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');

        $ids_migra = array();

        if ($planilla_migradas != "") {
            $ids_migra = explode(',', $planilla_migradas);
        }


        $registro_planilla = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $planilla_id));
        //planilla
        $this->db->join($this->tipo_planillas, 'pla_id_tpl = tpl_id');
        $planilla = $this->db->get_where($this->planillas, array('pla_id' => $planilla_id), 1)->row();

        $this->db->select('
      emp_empleado.emp_id,
      emp_empleado.emp_codigo,
      emp_empleado.emp_nombre,
      emp_empleado.emp_apellido,
      emp_empleado.emp_salario,
      emp_empleado.emp_fecha_contrato,
      emp_empleado.emp_numero_cuenta,
      emp_empleado.emp_seguro,
      emp_empleado.emp_metodo_pago,
      plz_plaza.plz_nombre,
      dce_valor,
      are_nombre,
      are_id,
      (Select
      Sum(ddi_detalle_ingreso.ddi_valor)
      From
      ddi_detalle_ingreso
      Where
      ddi_detalle_ingreso.ddi_id_emp = emp_empleado.emp_id And
      ddi_detalle_ingreso.ddi_id_pla = ' . $planilla->pla_id . '
      Group By
      ddi_detalle_ingreso.ddi_id_emp, ddi_detalle_ingreso.ddi_id_pla ) As ingresos,
      (Select
      Sum(ddd_detalle_descuento.ddd_valor)
      From
      ddd_detalle_descuento
      Where
      ddd_detalle_descuento.ddd_id_emp = emp_empleado.emp_id And
      ddd_detalle_descuento.ddd_id_pla = ' . $planilla->pla_id . '
      Group By
      ddd_detalle_descuento.ddd_id_emp, ddd_detalle_descuento.ddd_id_pla ) As
      descuentos
      ');



        // Added by Melbin
        $this->db->join('dce_documento_emp', "dce_documento_emp.dce_id_emp = emp_empleado.emp_id and dce_id_tde=$id_dui", 'left');

        if (in_array($planilla_id, $ids_migra)) {
            $this->db->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left');
            $this->db->join('are_area', 'are_id=emp_id_are', 'left');
            $this->db->join('txe_tipo_planillaxempleado', 'txe_id_emp=emp_id', 'left');
        } else {
            $this->db->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left');
            $this->db->join('are_area', 'are_id=emp_id_are', 'left');
            $this->db->join('txe_tipo_planillaxempleado', 'txe_id_emp=emp_id');
            $this->db->where('txe_id_tpl', $planilla->pla_id_tpl);
            $this->db->where("emp_id in (SELECT ddi_where.ddi_id_emp FROM ddi_detalle_ingreso ddi_where WHERE ddi_where.ddi_id_pla = $planilla_id)", null, false);
        }


        if ($filtro_forma_pago > 0) {
            $this->db->where('emp_metodo_pago', $filtro_forma_pago);
        }
        $this->db->group_by('emp_empleado.emp_id');
        $this->db->order_by('are_id', 'asc');
        $this->db->order_by('emp_apellido', 'asc');
        $empleados = $this->db->get($this->empleados)->result();
        // die($this->db->last_query()); 
        //return $empleados;
        //id del tipo de ingreso para indemnización
        $id_ting_indemnizacion = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION');
        $id_ting_aguinaldo = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');


        //Detalle de la planilla
        $detalle = '';
        $i = 1;
        $renta_10p = $renta = $isss = $afp = $des_otros = $des_total = $cancelar = $horas_extras_diu = $horas_extras_noc = $total_vacaciones = $total_comision = 0;
        $total_aguinaldo = 0;
        $total_indemnizacion = 0;

        $x = 1; //bandera que controla la clase de los tr
        //id del are que sera un bandera para hacer la totalizacion por separado por area
        //asignar la primera area correspondiente
        $id_area_inicial = (count($empleados) > 0) ? $empleados[0]->are_id : 0;
        //variables para la subtotalizacio por areas y total final

        $subtotal_area_salario = 0; //variable para ir subtotalizando el salario por area
        $subtotal_area_total_ing = 0;

        $subtotal_area_total_des = 0;
        $subtotal_area_total_cancelar = 0;

        //totalizacion de los ingresos   
        $subtotal_area_des_comision = 0;
        $total_ing_comision = 0;
        $subtotal_area_ing_anticipo = 0;
        $total_ing_anticipo = 0;
        $subtotal_area_ing_premio = 0;
        $total_ing_premio = 0;
        $subtotal_area_ing_vacacion = 0;
        $total_ing_vacacion = 0;
        $subtotal_area_ing_prima_vaca = 0;
        $total_ing_prima_vaca = 0;
        $subtotal_area_ing_depreciacion = 0;
        $total_ing_depreciacion = 0;
        $subtotal_area_ing_otros = 0;
        $total_ing_otros = 0;
        $total_ing_total = 0;

        //totalizacion de los descuentos por area y final   
        $subtotal_area_des_renta = 0;
        $subtotal_area_des_afp = 0;
        $subtotal_area_des_afp_patronal = 0;
        $subtotal_area_des_isss = 0;
        $subtotal_area_des_isss_patronal = 0;
        $subtotal_area_des_anticipo = 0;
        $total_des_anticipo = 0;
        $subtotal_area_des_prestamo_ban = 0;
        $total_des_prestamo_ban = 0;
        $subtotal_area_des_emi_fam = 0;
        $total_des_emi_fam = 0;
        $subtotal_area_des_prestamos_int = 0;
        $total_des_prestamos_int = 0;
        $subtotal_area_des_otros = 0;


        $j = 0;
        //variable para controlar el tr del subtotal
        //variables de totalización.
        $total_salario_final = 0;


        if ($genera_archivo_txt) {
            $consolidado_e = ($consolidado) ? $consolidado[1] : 0;
            if ($consolidado_e == 0) { //que no se trate de un consolidado en excel  
                if (file_exists("uploads/txt_planilla/datos_planilla.txt")) {
                    unlink("uploads/txt_planilla/datos_planilla.txt"); //eliminar el archivo si existiese
                }
                $file_txt = fopen("uploads/txt_planilla/datos_planilla.txt", "w") or die("Problemas en creación del archivo");
            }
        }

        $array_sueldo = array();
        $datos_detalle = array();
        foreach ($empleados as $empleado) {

            $nombre_completo = $empleado->emp_nombre . ' ' . $empleado->emp_apellido;

            $horas_extras_diu = 0;
            $horas_extras_noc = 0;
            $descuentos = array();

            $valor_descuentos = 0;
            foreach ($this->get_descuentos_pla_emp($planilla, $empleado) as $row) {
                //  print_r($this->db->last_query()); exit;
                $descuentos[$row->tdc_id] = $row;
                $valor_descuentos += $row->{'ddd_valor'};
            }

            $ingresos = array();
            $valor_ingresos = 0;

            foreach ($this->get_ingresos_pla_emp($planilla, $empleado) as $row) {
                #print_r($this->db->last_query()); exit;
                $ingresos[$row->tig_id] = $row;
                $valor_ingresos += $row->{'ddi_valor'};
            }

            //por el momento estas variables no se utilizan
            $hed = $ingresos[$this->tig_hed]->ddi_valor;
            $hen = $ingresos[$this->tig_hen]->ddi_valor;
            $comisiones = $ingresos[$this->tig_comision]->ddi_valor;
            $total_comision += $comisiones;
            $vacaciones = $ingresos[$this->tig_vacacion]->ddi_valor;
            //  $salario = $empleado->emp_salario / $planilla->tpl_cantidad;
            // $salario =   $ingresos[$this->tig_salario]->ddi_valor/ $planilla->tpl_cantidad ;
            $salario = $ingresos[$this->tig_salario]->ddi_valor;
            $suma_ingresosIng = $comisiones + $vacaciones;
            $otros_ingresos = $valor_ingresos - ($salario) - $suma_ingresosIng;
            //$otros_ingresos = $valor_ingresos - ($salario)-$hed-$hen-$comisiones-$vacaciones-$ingreso_anticipo_emi-$ingreso_depreciacion-$ingreso_premio;
            //ALMACENAR LOS VALORES EN VARIABLES
            $descuento_prestamo_interno = $descuentos[$id_descuento_prestamo_interno]->ddd_valor;

            //$suma_descuentos_emi = $descuento_prestamo_banco + $descuento_emi_familia + $descuento_prestamo_interno;
            $bonificaciones = $ingresos[$this->tig_bonificacion]->ddi_valor;
            $viaticos = $ingresos[$this->tig_viatico]->ddi_valor;
            $suma_de_descuentos = $descuentos[$this->tdc_isr]->ddd_valor + $descuentos[$this->tdc_afp]->ddd_valor + $descuentos[$this->tdc_isss]->ddd_valor + $suma_descuentos_emi;
            $otros_descuentos = round($valor_descuentos, 2) - round($suma_de_descuentos, 2);
            $total = $valor_ingresos - $valor_descuentos;

            //descuentos
            $renta += $descuentos[$this->tdc_isr]->ddd_valor;

            $afp += $descuentos[$this->tdc_afp]->ddd_valor;
            $afp_patronal += $descuentos[$this->tdc_afp]->ddd_valor_patronal;
            $isss += $descuentos[$this->tdc_isss]->ddd_valor;
            $isss_patronal += $descuentos[$this->tdc_isss]->ddd_valor_patronal;
            $des_otros += $otros_descuentos;
            $des_total += $valor_descuentos;
            //totales
            $cancelar += $total;

            $total_bonificacion += $bonificaciones;

            $horas_extras_diu += $hed;

            $horas_extras_noc += $hen;

            $total_vacaciones += $vacaciones;

            //planilla indemnizacion
            $indemnizacion = $ingresos[$id_ting_indemnizacion]->ddi_valor;
            $total_indemnizacion += $indemnizacion;

            //planilla comisiones (renta es la misma)
            $renta_10p += $descuentos[$this->tdc_isr_10p]->ddd_valor;

            //planilla aguinaldo (renta es la misma)
            $aguinaldo = $ingresos[$id_ting_aguinaldo]->ddi_valor;
            $total_aguinaldo += $aguinaldo;

            if ($x) {
                $valor = "impar";
                $x = 0;
            } else {
                $valor = "par";
                $x = 1;
            }
            $total_salario_final += $salario;
            $total_cancelar += $total;
            //DATOS PARA ARCHIVO TXT


            $fijo1 = '10220860001';
            //NÚMERO DE CUENTA
            $num_cub = $empleado->emp_numero_cuenta;
            $cantidad_car = strlen($num_cub);

            if ($cantidad_car > 8) {
                $cuenta = substr($num_cub, 0, 8);
            } else {
                $cuenta1 = ereg_replace("[-]", "", $num_cub);
                $long_cad = 8;
                $cuenta = str_pad($cuenta1, $long_cad, '0', STR_PAD_LEFT);
            }

            // FECHA GENERACIÓN
            $fecha = date('Y-m-d');
            $var = explode('-', $fecha);
            $periodo = $var[0] . $var[1] . $var[2];

            //NÚMERO DE AFILIACIÓN
            $cod = $empleado->emp_codigo;
            $newcode = ereg_replace("[-]", "", $cod);
            $long_codigo = 4;
            $codigo = str_pad($newcode, $long_codigo, '0', STR_PAD_LEFT);

            //SUELDO
            $total_format = number_format($total, 2);
            $su = explode('.', $total_format);

            $posicion_coincidencia = strpos($su[0], ',');
            if ($posicion_coincidencia == true) {
                $sin_coma = explode(',', $su[0]);
                //$sin_coma = strtr($su[0],',',"");
                $su[0] = $sin_coma[0] . $sin_coma[1];
            }

            $sueldo = $su[0] . $su[1];
            $salario_final_str = str_pad($sueldo, 9, '0', STR_PAD_LEFT);
            $salario_final = $total;

            //CODIGO OBSERVACION
            $codigo_o = 3;

            $espacio = str_pad($codigo_o, 12, ' ', STR_PAD_LEFT);

            $j++; //incrementar la variable de control de flujo de los registros

            if ($tipo == 'salario') {
                // Forma de pago de salario
                $cuenta_empleado = "";
                if ($empleado->emp_metodo_pago != "") {
                    if ($empleado->emp_metodo_pago == 1) {
                        $cuenta_empleado = trim($empleado->emp_numero_cuenta);
                        $forma_pago = 'Transferencia Bancaria';
                    } elseif ($empleado->emp_metodo_pago == 2) {
                        $cuenta_empleado = '<span style="color:red;">Cheque</span>';
                        $forma_pago = 'Cheque';
                    } elseif ($empleado->emp_metodo_pago == 3) {
                        $cuenta_empleado = '<span style="color:red;">Efectivo</span>';
                        $forma_pago = 'Efectivo';
                    }
                } else {
                    $forma_pago = 'No definida';
                    $cuenta_empleado = (trim($empleado->emp_numero_cuenta) != "") ? trim($empleado->emp_numero_cuenta) : '<span style="color:red;"> -- </span>';
                }


                $array = array(
                    'fijo' => $fijo1,
                    'cuenta' => $cuenta,
                    'nombre' => $nombre_completo,
                    'periodo' => $periodo,
                    'salario_final' => $salario_final,
                    'salario_final_str' => $salario_final_str,
                    'salario_final_for' => number_format($salario_final_str / 100, 2),
                    'codigo' => $codigo,
                    'forma_pago' => $forma_pago,
                    'documento' => $empleado->dce_valor,
                );

                // $datos_detalle[]['fijo1'] = $fijo1;
                // $datos_detalle[]['cuenta'] = $cuenta;
                // $datos_detalle[]['periodo'] = $periodo;
                // $datos_detalle[]['salario_final'] = $salario_final;
                // $datos_detalle[]['codigo'] = $codigo;
                $datos_detalle[] = $array;
                //CREAR LA CADENA DE TEXTO PARA EL ARCHIVO DE TEXTO. (.txt)
                if ($genera_archivo_txt) {
                    $agregar_fila = true;



                    //$archivo_txt =$fijo1.'            '.$cuenta.$periodo.$salario_final.'                 '.$codigo;
                    // if($consolidado) { // preguntar si existe la variable que aplica para generar un consolidado
                    //       $con_num_cuenta = $consolidado[0]; // 1=solo con numero de cuenta, 0=sin numero, 3=ambos
                    //       $es_excel_consolidado=$consolidado[1];
                    //       if($con_num_cuenta==1) { // 1=solo con numero de cuenta
                    //           $agregar_fila =   (trim($empleado->emp_numero_cuenta)!="")? true:false;  
                    //       } elseif ($con_num_cuenta==0) { // 0=sin numero de cuenta
                    //           $agregar_fila =   (trim($empleado->emp_numero_cuenta)=="")? true:false;  
                    //       } else { //si no ambos
                    //         $agregar_fila = true;
                    //     }
                    //     $agregar_fila = ($es_excel_consolidado==1)? false: $agregar_fila;
                    // }
                    // if($agregar_fila==true and $total>0) {
                    //        // die(print_r($archivo_txt));
                    //   fputs($file_txt,$archivo_txt);
                    //   fputs($file_txt,chr(13).chr(10));
                    //   $sum_sueldo += $total; //suma de sueldos por planilla, según registros agregados al txt.
                    // }
                }
            }
            $i++;
        }

        $fijo2 = '20220860001';
        // TOTAL SUELDO 

        $su = explode('.', $total_cancelar);
        $sueldo = $su[0] . $su[1];
        $suma_salario = str_pad($sueldo, 9, '0', STR_PAD_LEFT);
        $cuenta_emp = $this->gsatelite->get_parametro('CUENTA_EMPRESA');

        $archivo_txt = $fijo2 . '          ' . $cuenta_emp . $periodo . $suma_salario . $dia . $hora;

        // $array = array(
        //   'fijo' => $fijo2,
        //   'cuenta' => $cuenta_emp,
        //   'nombre' => '',
        //   'periodo'=>$periodo,
        //   'salario_final' => $suma_salario.$dia.$hora,
        //   'salario_final_str' => '',
        //   'salario_final_for' => '',
        //   'codigo' => $codigo,
        //   'documento' => '',
        // );
        $datos_detalle['total_cancelar'] = $total_cancelar;
        $datos_detalle['cuenta_alc'] = $cuenta_emp;

        return $datos_detalle;
        // if($agregar_fila && $consolidado == null ){
        //     fputs($file_txt,$archivo_txt);
        //     fputs($file_txt,chr(13).chr(10));
        // }


        if ($consolidado) {
            $es_excel_consolidado = $consolidado[1];
            $data['es_consolidado_excel'] = $consolidado[1];

            if ($es_excel_consolidado) {

                return $html_excel_consolidado;
            } else {

                if ($con_num_cuenta == 1) { // 1=solo con numero de cuenta
                    $sueldo = $total;
                } elseif ($con_num_cuenta == 0) { // 0=sin numero de cuenta
                    $sueldo = $total;
                } else { //si no ambos
                    $sueldo = $total;
                }
                $ultima_linea = array(
                    'fijo' => $fijo2, 'espacio' => $espacio, 'cuenta' => $cuenta_emp, 'periodo' => $periodo, 'salario_planilla' => $suma_salario, 'dia' => $dia, 'hora' => $hora
                );
                return array('total' => $cancelar, $ultima_linea, $sum_sueldo);
            }
        }

        $data['tipo'] = $tipo;
        $data['detalle_planilla'] = $detalle;
        $data['titulo'] = "Planilla";
        $data['registro_planilla'] = $registro_planilla;
        $data['usuario'] = $usuario;
        $html = "";

        if ($sin_header == null) {
            $html .= $thml = $this->load->view('personal/planilla/header_simple', array('titulo' => 'Planilla'), true);
        }

        // $html .= $this->load->view('personal/planilla/pla_print_emi', $data, true);

        if ($genera_archivo_txt) {
            if (file_exists("uploads/txt_planilla/datos_planilla.txt")) {
                return true;
            }
        } else {
            return $html;
        }
    }

    function get_ingresos_anual($emp_id, $tpl_id, $anio = null)
    {
        $this->db->select('ddi_id, tig_nombre, tig_id, ddi_valor, inn_fecha_desde, 
                        inn_cuota, inn_cuota_pagada, SUM(ddi_valor) as valor');

        $this->db->from('tpl_tipo_planilla')
            ->join('pla_planilla', 'pla_id_tpl = tpl_id')
            ->join('ddi_detalle_ingreso', 'ddi_id_pla = pla_id')
            ->join('emp_empleado', 'emp_id = ddi_id_emp')
            ->join('tig_tipo_ingreso', 'ddi_id_tig=tig_id')
            ->join('inn_ingreso', 'ddi_id_inn=inn_id AND inn_estado >= 0', 'left');

        if ($tpl_id > 0) {
            $this->db->where('pla_id_tpl', $tpl_id);
        }

        $this->db->where('ddi_id_emp', $emp_id)
            ->where("pla_fecha_inicio BETWEEN DATE_SUB( date( NOW( ) ), INTERVAL 6 month)
    AND date( NOW( ) )");
        $this->db->group_by('tig_id');
        $result = $this->db->get();

        return $result->result_array();
    }

    function get_ingresos_anual_full($emp_id = 0, $anio = null)
    {
        $year = ($anio) ? $anio : date('Y');
        $dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI', 0);
        $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT', 0);
        $prima_vaca     = ($this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION', 0)) ? $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION', 0) : 0;
        $tig_hora_xtras = ($this->gsatelite->get_parametro('ID_INGRESO_HORAS_EXTRAS', 0)) ? $this->gsatelite->get_parametro('ID_INGRESO_HORAS_EXTRAS', 0) : 0;
        $tig_honorarios = ($this->gsatelite->get_parametro('TIPO_INGRESO_HONORARIOS', 0)) ? $this->gsatelite->get_parametro('TIPO_INGRESO_HONORARIOS', 0) : 0;
        $tig_aguinaldo  = ($this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO', 0)) ? $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO', 0) : 0;
        $tig_indemnizar = ($this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION', 0)) ? $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION', 0) : 0;
        $tdc_afp_emp = ($this->tdc_afp > 0) ? $this->tdc_afp : 0;
        $tdc_isr_tabla = ($this->tdc_isr > 0) ? $this->tdc_isr : 0;
        $tdc_isss_emp = ($this->tdc_isss > 0) ? $this->tdc_isss : 0;
        $tig_salario = ($this->tig_salario > 0) ? $this->tig_salario : 0;
        $tdc_renta_10 = ($this->tdc_isr_10p > 0) ? $this->tdc_isr_10p : 0;
        $tig_vacacion = ($this->tig_vacacion > 0) ? $this->tig_vacacion : 0;
        $tig_comisions = ($this->tig_comision > 0) ? $this->tig_comision : 0;
        $tig_bonificac = ($this->tig_bonificacion > 0) ? $this->tig_bonificacion : 0;
        $tig_hora_xtras = (trim($tig_hora_xtras) != "") ? $tig_hora_xtras : 0;
        $this->db->select("emp_id, emp_apellido, emp_nombre, emp_doc_bancario, 
            IF(emp_doc_bancario IS NOT NULL, (SELECT MAX(dce_valor) FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = emp_doc_bancario),
                IFNULL((SELECT MAX(dce_valor) FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = $nit), (SELECT MAX(dce_valor) 
                FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = $dui))) AS documento,
            IF(emp_doc_bancario IS NOT NULL, (SELECT tde_nombre FROM tde_tipo_documento WHERE tde_id = emp_doc_bancario), IFNULL((SELECT tde_nombre 
                FROM tde_tipo_documento WHERE tde_id = $nit), (SELECT tde_nombre FROM tde_tipo_documento WHERE tde_id = $dui))) AS tipo_documento,
            IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio, '%Y') = '$year' AND ddi_id_tig = $prima_vaca), 0) AS prima_vacacion, 
            IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio, '%Y') = '$year' AND ddi_id_tig = $tig_vacacion), 0) AS ingreso_vacacion,
            IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio, '%Y') = '$year' AND ddi_id_tig = $tig_comisions), 0) AS comisiones,
            IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio, '%Y') = '$year' AND ddi_id_tig = $tig_bonificac), 0) AS bonificacion, 
            IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio, '%Y') = '$year' AND ddi_id_tig = $tig_indemnizar), 0) AS indemnizacion,
            IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio, '%Y') = '$year' AND ddi_id_tig = $tig_aguinaldo), 0) AS aguinaldo, 
            IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio, '%Y') = '$year' AND ddi_id_tig IN ( $tig_hora_xtras ) ), 0) AS horas_extras,
            IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio, '%Y') = '$year' AND ddi_id_tig = $tig_salario), 0) AS salarios, 
            IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio, '%Y') = '$year' AND ddi_id_tig = $tig_honorarios), 0) AS honorarios,
            IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento JOIN pla_planilla ON pla_id = ddd_id_pla WHERE ddd_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio, '%Y') = '$year' AND ddd_id_tdc = $tdc_afp_emp), 0) AS total_afp,
            IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento JOIN pla_planilla ON pla_id = ddd_id_pla WHERE ddd_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio, '%Y') = '$year' AND ddd_id_tdc = $tdc_isss_emp), 0) AS total_isss,
            IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento JOIN pla_planilla ON pla_id = ddd_id_pla WHERE ddd_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio, '%Y') = '$year' AND ddd_id_tdc = $tdc_isr_tabla), 0) AS total_isrtabla,
            IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento JOIN pla_planilla ON pla_id = ddd_id_pla WHERE ddd_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio, '%Y') = '$year' AND ddd_id_tdc = $tdc_renta_10), 0) AS total_isrrenta
            ", false);
        $this->db->from('emp_empleado');
        $this->db->where('emp_id', $emp_id);
        return $this->db->get()->row_array();
    }

    function get_descuentos_anual($emp_id, $tpl_id, $anio = null)
    {
        $this->db->select('ddd_id, tdc_nombre, tdc_id, ddd_valor, dss_fecha_desde, 
                                       dss_cuota, dss_cuota_pagada, SUM(ddd_valor) as valor, SUM(ddd_ingreso_afecto) as afecto');

        $this->db->from('tpl_tipo_planilla')
            ->join('pla_planilla', 'pla_id_tpl = tpl_id')
            ->join('ddd_detalle_descuento', 'ddd_id_pla = pla_id')
            ->join('emp_empleado', 'emp_id = ddd_id_emp')
            ->join('tdc_tipo_descuento', 'ddd_id_tdc=tdc_id')
            ->join('dss_descuento', 'ddd_id_dss=dss_id AND dss_estado >= 0', 'left');

        $this->db->where('ddd_id_emp', $emp_id);
        if ($tpl_id > 0) {
            $this->db->where('pla_id_tpl', $tpl_id);
        }
        $this->db->where("pla_fecha_inicio BETWEEN DATE_SUB( date( NOW( ) ), INTERVAL 10 month)
                    AND date( NOW( ) )");
        $this->db->group_by('tdc_id');
        $result = $this->db->get();

        return $result->result_array();
    }

    function get_isr($tpl_id, $mes = null)
    {
        $this->db->select()
            ->from('tpl_tipo_planilla')
            ->join('txt_tipo_planillaxtipo_isr', 'txt_id_tpl=tpl_id')
            ->join('tis_tipo_isr', 'tis_id=txt_id_tis')
            ->order_by('tis_recalculo', 'ASC');

        if ($mes != null) {
            $this->db->join('pis_periodo_isr', 'pis_id_txt=txt_id', 'left');
            $this->db->where('pis_periodo', $mes);
        }
        $this->db->where('tpl_id', $tpl_id);

        $result = $this->db->get();
        return $result->result_array();
    }

    function generar_recalculo($data, $planilla_info, $empleados, $validar_rentas){
        $planilla = $data['id_planilla'];
        $tipo_planilla = $data['tpl_id'];
        $info_pla = $this->gsatelite->get_registro('pla_planilla', array('pla_id' => $planilla));
        $fecha = $info_pla->pla_fecha_inicio;
        $anio = date('Y', strtotime($fecha));
        $fecha_mes = date('Y-m', strtotime($fecha));

                           $this->db->order_by('pla_fecha_inicio', 'ASC');
        $meses_incluidos = $this->gsatelite->get_tabla('pla_planilla', array('date_format(pla_fecha_inicio, "%Y-%m") <=' => $fecha_mes, 'date_format(pla_fecha_inicio, "%Y") =' => $anio));
        if (count($meses_incluidos) > 0) {
            foreach ($empleados as $emp) {

                $aplica_renta = $this->gsatelite->get_campo('emp_empleado', 'emp_aplica_renta', array('emp_id' => $emp->emp_id));
                $tipo_renta_aplica = $this->gsatelite->get_campo('emp_empleado', 'emp_tipo_isr_aplica', array('emp_id' => $emp->emp_id));
                $empleado_aplica = ($aplica_renta > 0 && (($validar_rentas == 1 && intval($tipo_renta_aplica) == 0) || $validar_rentas == 0));
                if ($empleado_aplica) {
                    //preguntar si el empleado aplica para proceder al descuento de renta}
                    $this->_debug("ISR Inicio\n");
                    $this->calcular_isr_recalculo($planilla_info, $emp->emp_id, $meses_incluidos);
                    $this->_debug("ISR Fin");
                }
            }
        } else {
            $alerta = array('tipo_alerta' => "error", 'titulo_alerta' => "Error", 'texto_alerta' => "No hay planillas requeridas para el recálculo");
            $this->session->set_flashdata($alerta);
            redirect('personal/planilla/generar_planilla_index');
        }
    }

    //René Castaneda 16-12-2016
    protected function calcular_isr_recalculo($planilla, $emp_id, $meses_incluidos)
    {
        //obtener tablas de isr para la planilla
        $isr = $this->get_tabla_isr($planilla->pla_id, 1);
        $descuento_isr = $this->gsatelite->get_parametro('DESCUENTO_ISR');
        $gravado_renta = 0;
        $descontado_renta = 0;
        $tpl_aguinaldo = $this->gsatelite->get_parametro('ID_TIPO_PLANILLA_APLICA_AGUINALDO', 0);
        $config_aguina = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_AGUINALDO', null, null, true), true);
        $tis_isr_aguin = (isset($config_aguina['TIPO_TABLA_ISR'])) ? $config_aguina['TIPO_TABLA_ISR'] : 0;
        foreach ($meses_incluidos as $meses) {
            if ($meses['pla_fecha_inicio'] == $planilla->pla_fecha_inicio) { //aplicar calculo normal.
                $gravado_renta += $this->calcular_agrupado_recalculo($meses, $emp_id);
            } else {
                $gravado_renta += $this->calcular_agrupado_recalculo($meses, $emp_id);
                $query_renta = $this->gsatelite->get_tabla('ddd_detalle_descuento', array('ddd_id_emp' => $emp_id, 'ddd_id_tdc' => $descuento_isr, 'ddd_id_pla' => $meses['pla_id']));
                if (count($query_renta) > 0) {
                    $row_pla = $this->gsatelite->get_registro('pla_planilla', array('pla_id' => $query_renta[0]['ddd_id_pla']));
                    $isr_agui = $this->gsatelite->count('isr_isr', array('isr_id_tis' => $tis_isr_aguin, 'isr_desde <= ' => $query_renta[0]['ddd_ingreso_afecto'], 'isr_hasta >= ' => $query_renta[0]['ddd_ingreso_afecto']));
                    $descontado_renta += ($row_pla->pla_id_tpl == $tpl_aguinaldo  &&  $isr_agui > 0) ? 0 : $query_renta[0]['ddd_valor'];
                } else {
                    $descontado_renta += 0;
                }
            }
        }
        foreach ($isr as $tramo) {
            if ($gravado_renta >= $tramo->isr_desde && $gravado_renta <= $tramo->isr_hasta) {
                $renta_total = $tramo->isr_cuota + (($gravado_renta - $tramo->isr_exceso) * ($tramo->isr_porcentaje / 100));
                $renta = (float) $renta_total - (float) $descontado_renta; //descontar el acumulado de rentas retenidas.
                $renta = ($renta > 0) ? $renta : 0;
                // $salarios[$tramo->isr_desde]=$gravado_renta;
                $this->_debug("pla: $planilla->pla_id, emp: $emp_id, base: $gravado_renta, renta: $renta");
                $this->add_descuento_detalle($planilla->pla_id, $emp_id, $this->tdc_isr, $renta, $gravado_renta, null, 0, $planilla->tpl_frecuencia);
            }
        }
    }

    //René Castaneda 16-12-2016
    public function calcular_agrupado_recalculo($planilla, $emp_id)
    {
        $year = formatear_fecha('Y', $planilla['pla_fecha_pago']);
        $tig_agui = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');
        $tpl_aguinaldo = $this->gsatelite->get_parametro('ID_TIPO_PLANILLA_APLICA_AGUINALDO', 0);
        $config_aguina = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_AGUINALDO', null, null, true), true);
        $tis_isr_aguin = (isset($config_aguina['TIPO_TABLA_ISR'])) ? $config_aguina['TIPO_TABLA_ISR'] : 0;
        // SI NO EXISTE EL AGRUPADOR DE RECALCULO USAR EL AGRUPADOR NORMAL
        $tag_recalculo =  $this->gsatelite->get_parametro('AGRUPADOR_RECALCULO_ISR', 0);
        $agrupador_id = ($tag_recalculo > 0) ? $tag_recalculo : $this->agrupador_isr;
        $query = $this->db->query('
                    SELECT deg_id_tag, tag_nombre, SUM(descuentos_no_gravar) no_gravar, SUM(ingresos_gravar) gravar FROM (
                    SELECT
                    deg_id_tag,
                    tag_nombre,
                    (SELECT SUM(ddd_valor) 
                        FROM ddd_detalle_descuento 
                        WHERE ddd_id_emp = ' . $emp_id . ' 
                        AND ddd_id_tdc = deg_id_tdc 
                        AND ddd_id_pla = ' . $planilla['pla_id'] . ' ) descuentos_no_gravar
                    ,
                    (SELECT SUM(CASE WHEN ddi_id_tig = ' . $tig_agui . ' THEN 
                        IF((
                                (SELECT COUNT(isr_id) FROM isr_isr WHERE isr_id_tis = ' . $tis_isr_aguin . ' AND isr_desde <= ddi_valor AND isr_hasta >= ddi_valor) > 0 AND 
                                (SELECT COUNT(pla_id) FROM pla_planilla WHERE pla_id_tpl = ' . $tpl_aguinaldo . ' AND DATE_FORMAT(pla_fecha_fin, "%Y") = ' . $year . ') > 0
                            ), 0, ddi_valor)
                        ELSE ddi_valor
                        END) 
                        FROM ddi_detalle_ingreso 
                        WHERE ddi_id_emp = ' . $emp_id . ' 
                        AND ddi_id_tig = deg_id_tig 
                        AND ddi_id_pla = ' . $planilla['pla_id'] . '  ) ingresos_gravar
                    FROM deg_detalle_agrupador 
                    JOIN tag_tipo_agrupador ON tag_id=deg_id_tag
                    WHERE deg_id_tag=' . $agrupador_id . '
                    ) D ');
        $datos_query = $query->row_array();
        $gravar = ($datos_query['gravar'] > 0) ? $datos_query['gravar'] : 0;
        $no_gravar = ($datos_query['no_gravar'] > 0) ? $datos_query['no_gravar'] : 0;
        return ($gravar - $no_gravar);
    }

    public function get_salario_empleado($where = null, $planilla = null, $ingreso_salario = null)
    {

        $query = "ddd_id_tdc,ddd_id_pla AS pla_id,emp_id AS id,
             Concat(emp_nombre,' ',emp_apellido) AS nombre,
             emp_salario AS salario,
             ifnull(
             (SELECT SUM(ddi_valor) AS valor
             FROM ddi_detalle_ingreso
             WHERE ddi_id_emp = emp_empleado.emp_id 
             AND ddi_id_pla = " . $planilla . " AND ddi_id_tig NOT IN (" . $ingreso_salario . ")),0
             ) AS ingresos,
             ifnull(
             (SELECT SUM(ddd_valor) AS valor
             FROM ddd_detalle_descuento 
             WHERE ddd_id_emp = emp_empleado.emp_id AND ddd_id_pla = " . $planilla . "
             ),0
             ) AS descuentos,
             ifnull(
             (
             SELECT SUM(ddi_valor) AS valor
             FROM ddi_detalle_ingreso
             WHERE ddi_id_emp = emp_empleado.emp_id 
             AND ddi_id_pla = " . $planilla . "
             ),0
             ) - ifnull(
             (
             SELECT SUM(ddd_valor) AS valor
             FROM ddd_detalle_descuento
             WHERE ddd_id_emp = emp_empleado.emp_id AND ddd_id_pla = " . $planilla . "
             ),0
             ) AS total";

        $result = $this->db->select($query, false)
            ->from('emp_empleado')
            ->join('ddd_detalle_descuento', 'ddd_id_emp = emp_id AND ddd_id_pla=' . $planilla, 'left')
            ->join('ddi_detalle_ingreso', 'ddi_id_emp = emp_id', 'inner');
        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('ddi_id_emp,ddd_id_pla');

        return $result->get()->result_array();
    }

    public function get_cheques_pendientes($where = null)
    {

        $query = $this->db->select()
            ->from('chp_cheque_pendiente')
            ->join('emp_empleado', 'emp_id = chp_id_emp', 'inner')
            ->join('pla_planilla', 'pla_id = chp_id_pla', 'inner');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }


    function get_ingresosxplanilla($emp_id, $tpl_id)
    {
        $this->db->select('ddi_id, tig_nombre, tig_id, SUM(ddi_valor) as ddi_valor, inn_fecha_desde, 
                        inn_cuota, inn_cuota_pagada');

        $this->db->from('tpl_tipo_planilla')
            ->join('pla_planilla', 'pla_id_tpl = tpl_id')
            ->join('ddi_detalle_ingreso', 'ddi_id_pla = pla_id')
            ->join('emp_empleado', 'emp_id = ddi_id_emp')
            ->join('tig_tipo_ingreso', 'ddi_id_tig=tig_id')
            ->join('inn_ingreso', 'ddi_id_inn=inn_id AND inn_estado >= 0', 'left');
        if ($tpl_id > 0) {
            $this->db->where('pla_id_tpl', $tpl_id);
        }
        $this->db->where('ddi_id_emp', $emp_id);

        $this->db->group_by('tig_id');
        $this->db->order_by('tig_orden', 'ASC');
        $result = $this->db->get();
        //die($this->db->last_query());
        return $result->result_array();
    }

    /**
     * @author René Castaneda
     * @since 2017-07-22
     * @return Información basica del periodo de planilla (para generar la partida contable)
     */
    public function get_informacion_planilla($where = null)
    {
        $this->db->select()
            ->from('tpl_tipo_planilla')
            ->join('pla_planilla', 'pla_id_tpl = tpl_id')
            ->where($where);
        return $this->db->get()->row_array();
    }

    /**
     * @author René Castaneda
     * @since 2017-07-22
     * @return Información de los ingresos de una planilla
     */
    public function get_informacion_planilla_ingresos($where = null)
    {

        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('INGRESO_PLANILLA_EMPLEADO'));
        $tipo_cuenta = ($tipo_cuenta > 0) ? $tipo_cuenta : 0;

        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('INGRESO_PLANILLA_EMPLEADO'));
        $tipo_cuenta = ($tipo_cuenta > 0) ? $tipo_cuenta : 0;
        $this->db->select("
                        ddi_id,
                        ddi_id_pla,
                        ddi_id_emp,                                                        
                        ROUND(SUM(IFNULL(ddi_valor,0) *(IFNULL(dcl_porcentaje,100)/100)),4) AS valor,
                        IFNULL((
                            SELECT dti_id_cnt
                            FROM tig_tipo_ingreso
                            JOIN dti_detalle_tipo_ingreso ON tig_id = dti_id_tig
                            WHERE dti_id_tcn = $tipo_cuenta
                            AND dti_id_cec = dcl_id_cec
                            AND tig_id = ddi_id_tig
                            AND dti_id_tig = tig_id
                            LIMIT 1
                        ),$cuenta_defecto) AS id_cuenta_contable,
                        (
                            SELECT cnt_cuenta
                            FROM cnt_cuenta_contable
                            WHERE cnt_id = (
                            IFNULL(                                    
                                    (SELECT dti_id_cnt
                                     FROM
                                     tig_tipo_ingreso
                                     JOIN dti_detalle_tipo_ingreso ON tig_id = dti_id_tig
                                     WHERE dti_id_tcn = $tipo_cuenta
                                     AND dti_id_cec = dcl_id_cec
                                     AND tig_id = ddi_id_tig
                                     AND dti_id_tig = tig_id
                                     LIMIT 1
                                    ),$cuenta_defecto)                                                                            
                                  )
                        ) AS cnt_cuenta,
                        (
                            SELECT cnt_nombre
                            FROM cnt_cuenta_contable
                            WHERE cnt_id = (
                            IFNULL(                                    
                                    (SELECT dti_id_cnt
                                     FROM
                                     tig_tipo_ingreso
                                     JOIN dti_detalle_tipo_ingreso ON tig_id = dti_id_tig
                                     WHERE dti_id_tcn = $tipo_cuenta
                                     AND dti_id_cec = dcl_id_cec
                                     AND tig_id = ddi_id_tig
                                     AND dti_id_tig = tig_id
                                     LIMIT 1
                                    ),$cuenta_defecto)                                                                            
                                  )
                        ) AS cnt_nombre
                    ", false)
            ->from('ddi_detalle_ingreso')
            ->join('emp_empleado', 'ddi_id_emp = emp_id')
            ->join('plz_plaza', 'emp_id_plz = plz_id', 'left')
            ->join('dcl_detalle_centro_costoxplaza', "plz_id = dcl_id_plz", 'left')
            ->group_by('id_cuenta_contable');

        if ($where) {
            $this->db->where($where);
        }
        $resultado = $this->db->get()->result_array();
        //print_r($this->db->last_query()); die();
        return $resultado;
    }

    /**
     * @author René Castaneda
     * @since 2017-07-22
     * @return Información de los descuentos de una planilla excluyendo el afp
     */
    public function get_informacion_planilla_descuentos($where = null)
    {

        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $tipo_des_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('DESCUENTO_APORTE_EMPLEADO'));
        $tipo_cuenta = ($tipo_cuenta > 0) ? $tipo_cuenta : 0;

        $this->db->select("
                ddd_id,
                ddd_id_pla,
                ddd_id_emp,                
                ROUND(SUM(IFNULL(ddd_valor,0) *(IFNULL(dcl_porcentaje,100)/100)),4) AS valor,
                IFNULL((
                    SELECT dtd_id_cnt
                    FROM tdc_tipo_descuento
                    JOIN dtd_detalle_tipo_descuento ON tdc_id = dtd_id_tdc  
                    WHERE dtd_id_tcn = $tipo_cuenta
                    AND dtd_id_cec = dcl_id_cec
                    AND tdc_id = ddd_id_tdc
                    AND dtd_id_tdc = tdc_id
                    LIMIT 1
                ),$cuenta_defecto) AS id_cuenta_contable,
                (
                    SELECT cnt_cuenta
                    FROM cnt_cuenta_contable
                    WHERE cnt_id = (
                        IFNULL((
                            SELECT dtd_id_cnt
                            FROM tdc_tipo_descuento
                            JOIN dtd_detalle_tipo_descuento ON tdc_id = dtd_id_tdc 
                            WHERE dtd_id_tcn = $tipo_cuenta
                            AND dtd_id_cec = dcl_id_cec
                            AND tdc_id = ddd_id_tdc
                            AND dtd_id_tdc = tdc_id
                            LIMIT 1), $cuenta_defecto)
                    )    
                ) AS cnt_cuenta,
                (
                    SELECT cnt_nombre
                    FROM cnt_cuenta_contable
                    WHERE cnt_id = (
                        IFNULL((
                            SELECT dtd_id_cnt
                            FROM tdc_tipo_descuento
                            JOIN dtd_detalle_tipo_descuento ON tdc_id = dtd_id_tdc 
                            WHERE dtd_id_tcn = $tipo_cuenta
                            AND dtd_id_cec = dcl_id_cec
                            AND tdc_id = ddd_id_tdc
                            AND dtd_id_tdc = tdc_id
                            LIMIT 1), $cuenta_defecto)
                    )    
                ) AS cnt_nombre                
                ", false)
            ->from('ddd_detalle_descuento')
            ->join('emp_empleado', 'ddd_id_emp = emp_id')
            ->join('plz_plaza', 'emp_id_plz = plz_id', 'left')
            ->join('dcl_detalle_centro_costoxplaza', 'plz_id = dcl_id_plz', 'left')
            ->where('ddd_id_tdc !=', $tipo_des_afp)
            ->group_by('id_cuenta_contable');

        if ($where) {
            $this->db->where($where);
        }

        $resultados =  $this->db->get()->result_array();
        //print_r($this->db->last_query()); die();
        return $resultados;
    }

    /**
     * @author René Castaneda
     * @since 2017-07-22
     * @return Información de los descuentos de una planilla excluyendo el afp
     */
    public function get_informacion_planilla_descuentos_patrono($where = null, $provision = false)
    {

        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $tipo_des_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
        $provision = ($provision) ? 'PROVISION_DESCUENTO_APORTE_PATRONAL' : 'DESCUENTO_APORTE_PATRONAL';
        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array("$provision"));

        $tipo_cuenta = ($tipo_cuenta > 0) ? $tipo_cuenta : 0;
        $this->db->select("
                ddd_id,
                ddd_id_pla,
                ddd_id_emp,                
                ROUND(SUM(IFNULL(ddd_valor_patronal,0) *(IFNULL(dcl_porcentaje,100)/100)),4) AS valor,
                IFNULL((
                    SELECT dtd_id_cnt
                    FROM tdc_tipo_descuento
                    JOIN dtd_detalle_tipo_descuento ON tdc_id = dtd_id_tdc  
                    WHERE dtd_id_tcn = $tipo_cuenta
                    AND dtd_id_cec = dcl_id_cec
                    AND tdc_id = ddd_id_tdc
                    AND dtd_id_tdc = tdc_id
                    LIMIT 1
                ),$cuenta_defecto) AS id_cuenta_contable,
                (
                    SELECT cnt_cuenta
                    FROM cnt_cuenta_contable
                    WHERE cnt_id = (
                        IFNULL((
                            SELECT dtd_id_cnt
                            FROM tdc_tipo_descuento
                            JOIN dtd_detalle_tipo_descuento ON tdc_id = dtd_id_tdc 
                            WHERE dtd_id_tcn = $tipo_cuenta
                            AND dtd_id_cec = dcl_id_cec
                            AND tdc_id = ddd_id_tdc
                            AND dtd_id_tdc = tdc_id
                            LIMIT 1), $cuenta_defecto)
                    )    
                ) AS cnt_cuenta,
                (
                    SELECT cnt_nombre
                    FROM cnt_cuenta_contable
                    WHERE cnt_id = (
                        IFNULL((
                            SELECT dtd_id_cnt
                            FROM tdc_tipo_descuento
                            JOIN dtd_detalle_tipo_descuento ON tdc_id = dtd_id_tdc 
                            WHERE dtd_id_tcn = $tipo_cuenta
                            AND dtd_id_cec = dcl_id_cec
                            AND tdc_id = ddd_id_tdc
                            AND dtd_id_tdc = tdc_id
                            LIMIT 1), $cuenta_defecto)
                    )    
                ) AS cnt_nombre                
                ", false)
            ->from('ddd_detalle_descuento')
            ->join('emp_empleado', 'ddd_id_emp = emp_id')
            ->join('plz_plaza', 'emp_id_plz = plz_id', 'left')
            ->join('dcl_detalle_centro_costoxplaza', 'plz_id = dcl_id_plz', 'left')
            ->where('ddd_valor_patronal >', 0)
            ->where('ddd_id_tdc !=', $tipo_des_afp)
            ->group_by('id_cuenta_contable');

        if ($where) {
            $this->db->where($where);
        }

        $resultados = $this->db->get()->result_array();
        //print_r($this->db->last_query()); die();
        return $resultados;
    }


    /**
     * @author René Castaneda
     * @since 2017-07-24
     * @return Información de los descuentos de una planilla solo de afp
     */
    public function get_informacion_planilla_descuentos_afp($where = null)
    {
        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $tipo_des_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('DESCUENTO_APORTE_EMPLEADO'));
        $tipo_cuenta = ($tipo_cuenta > 0) ? $tipo_cuenta : 0;

        $this->db->select("
                ddd_id,
                ddd_id_pla,
                ddd_id_emp,                
                ROUND(SUM(IFNULL(ddd_valor,0) *(IFNULL(dcl_porcentaje,100)/100)),4) AS valor,
                IFNULL((
                    SELECT dff_id_cnt
                    FROM dff_detalle_finanza_afp
                    WHERE dff_id_tcn = $tipo_cuenta
                    AND dff_id_cec = dcl_id_cec
                    AND dff_id_afp = emp_id_afp
                    LIMIT 1
                ),$cuenta_defecto) AS id_cuenta_contable,
                (
                    SELECT cnt_cuenta
                    FROM cnt_cuenta_contable
                    WHERE cnt_id = (
                        IFNULL((
                            SELECT dff_id_cnt
                            FROM dff_detalle_finanza_afp
                            WHERE dff_id_tcn = $tipo_cuenta
                            AND dff_id_cec = dcl_id_cec
                            AND dff_id_afp = emp_id_afp
                            LIMIT 1), $cuenta_defecto)                        
                    )
                ) AS cnt_cuenta,
                (
                    SELECT cnt_nombre
                    FROM cnt_cuenta_contable
                    WHERE cnt_id = (
                        IFNULL((
                            SELECT dff_id_cnt
                            FROM dff_detalle_finanza_afp
                            WHERE dff_id_tcn = $tipo_cuenta
                            AND dff_id_cec = dcl_id_cec
                            AND dff_id_afp = emp_id_afp
                            LIMIT 1), $cuenta_defecto)                        
                    )
                ) AS cnt_nombre
                ", false)
            ->from('ddd_detalle_descuento')
            ->join('emp_empleado', 'ddd_id_emp = emp_id')
            ->join('plz_plaza', 'emp_id_plz = plz_id', 'left')
            ->join('dcl_detalle_centro_costoxplaza', 'plz_id = dcl_id_plz', 'left')
            ->where('ddd_id_tdc =', $tipo_des_afp)
            ->group_by('id_cuenta_contable');

        if ($where) {
            $this->db->where($where);
        }
        //$this->db->limit(1);
        return $this->db->get()->result_array();
        //print_r($this->db->last_query()); die();

    }

    /**
     * @author René Castaneda
     * @since 2017-07-24
     * @return Información de los descuentos de una planilla solo de afp
     */
    public function get_informacion_planilla_descuentos_afp_patrono($where = null, $provision = false)
    {
        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $tipo_des_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');

        $provision = ($provision) ? 'PROVISION_DESCUENTO_APORTE_PATRONAL' : 'DESCUENTO_APORTE_PATRONAL';
        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array("$provision"));
        $tipo_cuenta = ($tipo_cuenta > 0) ? $tipo_cuenta : 0;

        $this->db->select("
                ddd_id,
                ddd_id_pla,
                ddd_id_emp,                
                ROUND(SUM(IFNULL(ddd_valor_patronal,0) *(IFNULL(dcl_porcentaje,100)/100)),4) AS valor,
                IFNULL((
                    SELECT dff_id_cnt
                    FROM dff_detalle_finanza_afp
                    WHERE dff_id_tcn = $tipo_cuenta
                    AND dff_id_cec = dcl_id_cec
                    AND dff_id_afp = emp_id_afp
                    LIMIT 1
                ),$cuenta_defecto) AS id_cuenta_contable,
                (
                    SELECT cnt_cuenta
                    FROM cnt_cuenta_contable
                    WHERE cnt_id = (
                        IFNULL((
                            SELECT dff_id_cnt
                            FROM dff_detalle_finanza_afp
                            WHERE dff_id_tcn = $tipo_cuenta
                            AND dff_id_cec = dcl_id_cec
                            AND dff_id_afp = emp_id_afp
                            LIMIT 1), $cuenta_defecto)                        
                    )
                ) AS cnt_cuenta,
                (
                    SELECT cnt_nombre
                    FROM cnt_cuenta_contable
                    WHERE cnt_id = (
                        IFNULL((
                            SELECT dff_id_cnt
                            FROM dff_detalle_finanza_afp
                            WHERE dff_id_tcn = $tipo_cuenta
                            AND dff_id_cec = dcl_id_cec
                            AND dff_id_afp = emp_id_afp
                            LIMIT 1), $cuenta_defecto)                        
                    )
                ) AS cnt_nombre
                ", false)
            ->from('ddd_detalle_descuento')
            ->join('emp_empleado', 'ddd_id_emp = emp_id')
            ->join('plz_plaza', 'emp_id_plz = plz_id', 'left')
            ->join('dcl_detalle_centro_costoxplaza', 'plz_id = dcl_id_plz', 'left')
            ->where('ddd_id_tdc =', $tipo_des_afp)
            ->where('ddd_valor_patronal >', 0)
            ->group_by('id_cuenta_contable');

        if ($where) {
            $this->db->where($where);
        }
        //$this->db->limit(1);
        $datos_query = $this->db->get()->result_array();
        //print_r($this->db->last_query()); die();
        return $datos_query;
    }

    /**
     * @author René Castaneda
     * @since 2017-07-22
     * @return Información de los salarios de la planilla (pago al empleado)
     */
    public function get_informacion_planilla_pagos($array_planillas = null, $where = null)
    {
        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('GASTO'));
        $tipo_cuenta = (isset($tipo_cuenta) && $tipo_cuenta > 0) ? $tipo_cuenta : 0;
        $ids_planillas = implode(',', $array_planillas);
        $this->db->select("emp_nombre, emp_apellido, IFNULL( txe_id_cnt, IFNULL( emp_id_cnt, '$cuenta_defecto')) id_cuenta_contable, 
                        (
                         SELECT cnt_cuenta
                         FROM cnt_cuenta_contable
                         WHERE cnt_id = (IFNULL(txe_id_cnt, IFNULL( emp_id_cnt, '104' )))
                        ) AS cnt_cuenta,
                        (
                         SELECT cnt_nombre
                         FROM cnt_cuenta_contable
                         WHERE cnt_id = (IFNULL(txe_id_cnt, IFNULL( emp_id_cnt, '104' )))
                        ) AS cnt_nombre,
                        ROUND( (( SELECT Sum( ddi_valor ) FROM ddi_detalle_ingreso WHERE ddi_id_emp = emp_id AND ddi_id_pla IN ( $ids_planillas ) GROUP BY ddi_id_emp, ddi_id_pla )), 2 ) AS ingresos,
                        ROUND(
                            IFNULL( SUM(( SELECT Sum( ddd_valor ) FROM ddd_detalle_descuento WHERE ddd_id_emp = emp_id AND ddd_id_pla IN ( $ids_planillas ) GROUP BY ddd_id_emp, ddd_id_pla )), 0 ),
                            2 
                        ) AS descuentos,
            ROUND( (( SELECT Sum( ddi_valor ) FROM ddi_detalle_ingreso WHERE ddi_id_emp = emp_id AND ddi_id_pla IN ( $ids_planillas ) GROUP BY ddi_id_emp, ddi_id_pla )), 2 ) - ROUND(
            IFNULL( (( SELECT Sum( ddd_valor ) FROM ddd_detalle_descuento WHERE ddd_id_emp = emp_id AND ddd_id_pla IN ( $ids_planillas ) GROUP BY ddd_id_emp, ddd_id_pla )), 0 ), 2) AS valor", false)
            ->from('emp_empleado')
            ->join('txe_tipo_planillaxempleado', 'txe_id_emp=emp_id', 'left')
            ->group_by('id_cuenta_contable, emp_id');
        if ($where) {
            $this->db->where($where);
        }

        $this->db->where("emp_id IN (select ddi_id_emp FROM ddi_detalle_ingreso WHERE ddi_id_pla IN ($ids_planillas))", NULL, FALSE);


        $resultado = $this->db->get()->result_array();
        $query = $this->db->last_query();
        $query_final = "SELECT 
                        pla.emp_nombre,
                        pla.emp_apellido,
                        pla.id_cuenta_contable,
                        pla.cnt_cuenta,
                        pla.cnt_nombre,
                        pla.ingresos,
                        pla.descuentos,
                        SUM(pla.valor) as valor 
                        FROM (" . $query . ") AS pla GROUP BY pla.id_cuenta_contable";
        //print_r($query_final); die();
        //$this->db->get()->result_array();
        $resultado_final = $this->db->query($query_final)->result_array();
        return $resultado_final;
    }



    /**
     * @author René Castaneda
     * @since 2017-08-22
     * @return Información de la planilla para generar el archivo prn
     */
    public function get_informacion_planilla_prn($array_planillas = null, $where = null, $datos_complementario = null)
    {
        $letra = $datos_complementario['letra']; //'T' letraT,'6877' 
        $identificador = $datos_complementario['identificador']; //'T' letraT,'6877' 
        $codigo_pla = $datos_complementario['codigo_pla']; //00029
        $id_tipo_doc_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');

        $this->db->select("'$letra$identificador' AS identificador, '$codigo_pla' AS codigo, 
            IF(emp_doc_bancario > 0,
                (SELECT REPLACE(dce_valor, '-', '') FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = emp_doc_bancario LIMIT 1),
                (SELECT REPLACE(dce_valor, '-', '') FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = $id_tipo_doc_nit LIMIT 1)
            ) AS nit,
            /* REPLACE(dce_valor,'-','') nit, */
            CASE tpl_frecuencia 
            WHEN 15 THEN CONCAT('PLAN $identificador ',IF((DATE_FORMAT(pla_fecha_fin,'%d') = 15),'1RA QUINC.','2DA QUINC.'))    /*Quincenal*/
            ELSE 'PLAN $identificador MENSUAL.'  /* Mensual*/
            END AS periodo, 
            DATE_FORMAT(pla_fecha_fin,'%m') AS mes_planilla, 
            DATE_FORMAT(pla_fecha_pago,'%Y%m%d') AS fecha_pago,
            CONCAT(trim(emp_nombre),' ',trim(emp_apellido)) AS nombre_empleado,
            emp_numero_cuenta,
            REPLACE(ROUND(SUM((IFNULL((SELECT SUM(d2.ddi_valor) FROM ddi_detalle_ingreso d2 WHERE d2.ddi_id_pla = pla_id  AND d2.ddi_id_emp = emp_id), 0)
            - IFNULL((SELECT SUM(IFNULL(d3.ddd_valor, 0)) FROM ddd_detalle_descuento d3 WHERE d3.ddd_id_pla = pla_id AND d3.ddd_id_emp = emp_id), 0))), 2), '.', '') AS total_pagar,
            ROUND(SUM((IFNULL((SELECT SUM(IFNULL(d2.ddi_valor, 0)) FROM    ddi_detalle_ingreso d2 WHERE d2.ddi_id_pla = pla_id AND d2.ddi_id_emp = emp_id),0)
            - IFNULL((SELECT SUM(d3.ddd_valor) FROM ddd_detalle_descuento d3 WHERE d3.ddd_id_pla = pla_id AND d3.ddd_id_emp = emp_id),0))), 2) AS normal
        ", false)
            ->from('emp_empleado')
            ->join('txe_tipo_planillaxempleado', 'txe_id_emp=emp_id')
            ->join('tpl_tipo_planilla', 'tpl_id=txe_id_tpl')
            ->join('pla_planilla', 'pla_id_tpl=tpl_id')
            // ->join('dce_documento_emp', "dce_id_emp=emp_id and dce_id_tde=$id_tipo_doc_nit")
            ->group_by('emp_id')
            ->order_by('pla_id_tpl, pla_id, emp_id');

        /*
    ->from('emp_empleado')
    ->join('ddi_detalle_ingreso', 'ddi_id_emp=emp_id')
    ->join('pla_planilla', 'pla_id=ddi_id_pla')
    ->join('tpl_tipo_planilla', 'tpl_id=pla_id_tpl')
    ->join('dce_documento_emp', "dce_id_emp=emp_id and dce_id_tde=$id_tipo_doc_nit")
    ->group_by('emp_id')
    ->order_by('pla_id_tpl, pla_id, emp_id');
                                */

        if ($where) {
            $this->db->where($where);
        }
        if ($array_planillas) {
            $this->db->where_in('pla_id', $array_planillas);
        }
        $this->db->having("normal > 0", false);
        return $this->db->get()->result_array();
    }


    /**
     * @author René Castaneda
     * @since 16-12-2017
     * @Description: 
     * Función para el cálculo de vacación a un empleado
     * @param array object $empleado (información del empleado)
     * @param array object $planilla (información de la planilla)
     */
    public function calculo_vacacion_empleado($emp = null, $planilla = null, $aplica_vacacion = null, $es_retiro = false, $porcentaje_vacacion = null, $es_descuento_vacacion = false)
    {
        if (is_null($emp->emp_fecha_contrato)) return null;
        if (!is_array($porcentaje_vacacion)) {
            $porcentaje_vacacion_[0] = 100; //% vacación
            $porcentaje_vacacion_[1] = 100; //% prima vacación
        } else {
            $porcentaje_vacacion_ = $porcentaje_vacacion;
        }
        //consultar las configuraciones
        $configuracion_vacacion = $this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_VACACION');
        //numero de dias trabajados para tener derecho a vacación.
        $numero_dias_aplica_vacacion = $this->gsatelite->get_parametro('NUM_DIAS_APLICA_VACACION');
        $numero_dias_aplica_vacacion = ($numero_dias_aplica_vacacion > 0) ? $numero_dias_aplica_vacacion : 1;
        $configuracion_vacacion = json_decode($configuracion_vacacion);
        if (!is_object($configuracion_vacacion)) return null;
        $configuracion_vacacion = (array) $configuracion_vacacion;
        $dias_anio_vacacion = (trim($configuracion_vacacion['DIAS_ANIO_VACACION']) > 0) ? $configuracion_vacacion['DIAS_ANIO_VACACION'] : 0;
        $n = $this->gsatelite->get_intervalo_dias($emp->emp_fecha_contrato, $planilla->pla_fecha_fin);
        //if ($n <= 0) { return null;} //si dio negativa detener el proceso.        
        $n_dias = $n + 1;
        $dias_considerados = ($n_dias >= $dias_anio_vacacion) ? $dias_anio_vacacion : $n_dias;
        $anio_dif = (formatear_fecha('Y', $planilla->pla_fecha_inicio) - formatear_fecha('Y', $emp->emp_fecha_contrato));
        $fecha = date_create($emp->emp_fecha_contrato);
        date_add($fecha, date_interval_create_from_date_string("+$anio_dif year")); //cuadrar al año actual
        $fecha_con = date_format($fecha, 'Y-m-d');
        $date_1 = new DateTime($fecha_con);
        $date_2 = new DateTime($planilla->pla_fecha_inicio);
        $date_3 = new DateTime($planilla->pla_fecha_fin);
        $metodo_vacacion = $this->gsatelite->get_parametro('METODO_CALCULO_VACACION');
        // $aniversario = ($date_1 >= $date_2 && $date_1 <= $date_3 ) ? true : false; //preguntar si tiene aniversario
        if ($date_1 >= $date_2 && $date_1 <= $date_3) {
            //FECHA CONTRATO = ENERO & FECHA VACACION = ENERO
            $aniversario = true;
            $fecha_actualiza = $planilla->pla_fecha_pago;
        } else {
            // SI HAY ULYIMA VACACION VER SI ESTA FECHA ES DESPUES DE LA ULTIMA EXISTENTE
            if ($emp->emp_fecha_ult_vacacion != "") {
                $ultima_fecha = new DateTime($emp->emp_fecha_ult_vacacion);
            } else {
                // SI NO HAY ULYIMA VACACION VER SI ESTA FECHA ES DESPUES DE 1 AÑO DE LA CONTRATACION
                $f = date_create($emp->emp_fecha_contrato);
                date_add($f, date_interval_create_from_date_string("+1 year"));
                $nf = date_format($f, 'Y-m-d');
                $ultima_fecha = new DateTime($nf);
            }
            //FECHA CONTRATO = ENERO & FECHA VACACION = MAYO 
            if ($date_1 < $date_2 && $date_1 > $ultima_fecha &&  formatear_fecha('Y', $planilla->pla_fecha_inicio) == formatear_fecha('Y', $fecha_con)) {
                $aniversario = true;
                $fecha_actualiza = $fecha_con;
            } else {
                $wgva = array("gva_estado" => 1, "gva_id_emp" => $emp->emp_id, "(gva_id_pla_pago = $planilla->pla_id OR gva_id_pla_pago_factor = $planilla->pla_id)" => null);
                $gva_emp = $this->gsatelite->get_tabla('gva_goce_vacacion', $wgva);
                if ($metodo_vacacion == 2 && count($gva_emp) > 0) {
                    $aniversario = true;
                    $fecha_actualiza = $planilla->pla_fecha_pago;
                } else {
                    $aniversario = false;
                }
            }
        }
        // if ($emp->emp_id == 8) {var_dump($n_dias);var_dump($numero_dias_aplica_vacacion); die(); }
        //si posee los dias de antiguedad laborados que aplique la vacación o que se trate de un retiro
        if ($aniversario == true && (($n_dias >= $numero_dias_aplica_vacacion) or ($es_retiro == true and $n_dias >= 1))) {

            //actualizar en el empleado la ultima fecha de vacación.
            $this->gsatelite->actualizar_array(
                'emp_empleado',
                array(
                    'emp_fecha_ult_vacacion' => $fecha_actualiza, //$fecha_con antes.
                    'emp_usu_mod' => $this->tank_auth->get_user_id(),
                    'emp_fecha_mod' => date('Y-m-d H:i:s')
                ),
                array('emp_id' => $emp->emp_id)
            );


            $dias_mes = (trim($this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES')) != '') ? $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES') : 30;
            $porcentaje_vac = (trim($this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION')) != '') ? $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION') : 0.3;
            $id_tig_vacacion = (trim($this->gsatelite->get_parametro('ID_TIG_VACACION')) > 0) ? $this->gsatelite->get_parametro('ID_TIG_VACACION') : 0;
            $id_desc_vacacion = (trim($this->gsatelite->get_parametro('ID_TDC_VACACION')) > 0) ? $this->gsatelite->get_parametro('ID_TDC_VACACION') : 0;
            $id_tig_vacacion_prima = (trim($this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION')) > 0) ? $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION') : 0;

            $salario_emp_vac = $emp->emp_salario;

            $base_dias_laboral = true;
            $salario_dia_vac_prom = 0;
            //preguntar si es promediado
            if ($emp->pto_salario_promediado) {
                $numero_meses = (trim($configuracion_vacacion['NUMERO_MESES_PARA_VACACION']) > 0) ? $configuracion_vacacion['NUMERO_MESES_PARA_VACACION'] : 6;
                $id_tag_vacacion = (trim($configuracion_vacacion['ID_AGRUPADOR_VACACION']) > 0) ? $configuracion_vacacion['ID_AGRUPADOR_VACACION'] : 0;

                //preguntar por los meses anteriores excluyendo el actual
                //llevar al día 15 para no tener problemas con los meses a 30 días
                $planilla_ini = formatear_fecha('Y-m-15', $planilla->pla_fecha_inicio);
                $fecha = date_create($planilla_ini);
                date_add($fecha, date_interval_create_from_date_string("-1 month"));
                $ffin_ = date_format($fecha, 'Y-m-15');  //llevar al día 15 para no tener problemas con los meses a 30 días

                $fecha = date_create($ffin_);
                date_add($fecha, date_interval_create_from_date_string("-$numero_meses month"));
                $fini = date_format($fecha, 'Y-m-01');
                $ffin = formatear_fecha('Y-m-t', $ffin_);

                //consultar por los ingresos y descuento segun el agrupador
                $q_ing = $this->db->select("IFNULL(SUM(ddi_valor),0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses,
                    GROUP_CONCAT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y%m')) AS det_meses
                    ", false)
                    ->from("ddi_detalle_ingreso")
                    ->join("pla_planilla", "pla_id = ddi_id_pla")
                    ->where("ddi_id_emp", $emp->emp_id)
                    ->where("pla_estado", 3) //solo autorizadas
                    ->where("pla_fecha_inicio >=", $fini)
                    ->where("pla_fecha_fin <=", $ffin)
                    ->where("ddi_id_pla !=",  $planilla->pla_id) //excluir la que se esta ejecutando dado que aun no se han generado sus ingresos
                    ->where("ddi_id_tig in ( SELECT deg_id_tig from deg_detalle_agrupador where deg_id_tag = $id_tag_vacacion AND deg_id_tig is not null )")
                    ->get()->row_array();
                $q_des = $this->db->select("IFNULL(SUM(ddd_valor),0) AS descuentos", false)
                    ->from("ddd_detalle_descuento")
                    ->join("pla_planilla", "pla_id = ddd_id_pla")
                    ->where("ddd_id_emp", $emp->emp_id)
                    ->where("pla_estado", 3) //solo autorizadas
                    ->where("pla_fecha_inicio >=", $fini)
                    ->where("pla_fecha_fin <=", $ffin)
                    ->where("ddd_id_pla !=",  $planilla->pla_id) //excluir la que se esta ejecutando dado que aun no se han generado sus ingresos
                    ->where("ddd_id_tdc in ( SELECT deg_id_tdc from deg_detalle_agrupador where deg_id_tag = $id_tag_vacacion AND deg_id_tdc is not null )")
                    ->get()->row_array();

                //obtener el salario promediado.
                $salario_emp_vac_all = ($q_ing['ingresos'] > 0) ? ($q_ing['ingresos'] - $q_des['descuentos']) : $emp->emp_salario;
                $salario_emp_vac = ($q_ing['ingresos'] > 0) ? (($q_ing['ingresos'] - $q_des['descuentos']) / $q_ing['meses']) : $emp->emp_salario;

                if ($base_dias_laboral && $q_ing) {
                    $dias_segun_mes = $this->gsatelite->get_tabla('djm_dias_trajado_mes', array('djm_estado' => 1));
                    $array_dias_meses = ($dias_segun_mes) ? array_column($dias_segun_mes, 'djm_dias', 'djm_periodo') : array();
                    $meses_ing = explode(',', $q_ing['det_meses']);
                    if ($dias_segun_mes) {
                        $dias_segun_periodo = 0;
                        for ($q = 0; $q < count($meses_ing); $q++) {
                            $mes_p = intval($meses_ing[$q]);
                            if ($mes_p > 0) {
                                $dias_segun_periodo += (array_key_exists($mes_p, $array_dias_meses)) ? intval($array_dias_meses[$mes_p]) : $dias_mes;
                            }
                        }
                        $dias_considerados = ($dias_segun_periodo > 0) ? $dias_segun_periodo : $dias_considerados;
                        $salario_dia_vac_prom = $salario_emp_vac_all / $dias_considerados;
                    }
                }
            }
            $prom_comi_dias = $this->promedio_comision_dias($emp, $planilla);
            if ($prom_comi_dias > 0) {
                $salario_emp_vac += $prom_comi_dias;
            }
            $salario_dia = $salario_emp_vac / $dias_mes;
            if ($metodo_vacacion == 3) {
                $salario_dia = ($salario_dia_vac_prom > 0) ? $salario_dia_vac_prom : $salario_dia;
                //cambiar al parametro de los 15 días. por el paráemetro
                $salario_dias_ley_vac = ($configuracion_vacacion['DIAS_LEY_VACACION'] > 0) ? $configuracion_vacacion['DIAS_LEY_VACACION'] : 15;

                $anio_ini = '01-01-' . formatear_fecha('Y', $planilla->pla_fecha_fin);
                $anio_fin = '31-12-' . formatear_fecha('Y', $planilla->pla_fecha_fin);
                $anio = ($this->gsatelite->get_intervalo_dias($anio_ini, $anio_fin) + 1);
                $periodo_plan = ($this->gsatelite->get_intervalo_dias($planilla->pla_fecha_inicio, $planilla->pla_fecha_fin) + 1);
                $contrat_plan = ($this->gsatelite->get_intervalo_dias($emp->emp_fecha_contrato, $planilla->pla_fecha_fin) + 1);

                //$fecha_ini_pla = ($contrat_plan >= $periodo_plan) ? $periodo_plan : $contrat_plan;

                $fecha_ini_pla = $anio; //efecto cero para pagar completo sin prorratear

                $salario_dias_ley = (($salario_dia * $salario_dias_ley_vac) / $anio) * $fecha_ini_pla;
                $porcentaje_vacacion = $salario_dias_ley * $porcentaje_vac;
            } elseif ($metodo_vacacion == 2) {
                // SOLO LOS YA EXISTENTES EN LA VGA 
                $aplica_vacacion[0] = 0;
                $aplica_vacacion[1] = 0;
            } else {
                $salario_dias_ley = $salario_dia * (($configuracion_vacacion['DIAS_LEY_VACACION'] > 0) ? $configuracion_vacacion['DIAS_LEY_VACACION'] : 15);
                $porcentaje_vacacion = $salario_dias_ley * $porcentaje_vac;
                $salario_dias_ley = ($salario_dias_ley * $dias_considerados) / $dias_anio_vacacion; //calculo de 15 dias.
                $porcentaje_vacacion = ($porcentaje_vacacion * $dias_considerados) / $dias_anio_vacacion; //calculo de 30%
                $extra = ($dias_considerados != $dias_anio_vacacion) ? "($dias_considerados laborados)" : '';
                $dias_ley = (($configuracion_vacacion['DIAS_LEY_VACACION'] > 0) ? $configuracion_vacacion['DIAS_LEY_VACACION'] : 15);
                //insertar ingreso de vacacion si es que aplica de acuerdo a la configuración
                $extra = ($dias_ley != 15) ? "$dias_ley días vacación. " . $extra : $extra;
            }
            // if ($emp->emp_id == 76) {var_dump($aplica_vacacion); die(); }
            /*
            //print_r($salario_emp_vac); die();
            $salario_dia = $salario_emp_vac / $dias_mes;
            $salario_dias_ley = $salario_dia * (($configuracion_vacacion['DIAS_LEY_VACACION'] > 0)? $configuracion_vacacion['DIAS_LEY_VACACION'] : 15);


            $porcentaje_vacacion = $salario_dias_ley * $porcentaje_vac;

            $salario_dias_ley = ($salario_dias_ley * $dias_considerados) / $dias_anio_vacacion; //calculo de 15 dias.
            $porcentaje_vacacion = ($porcentaje_vacacion * $dias_considerados) / $dias_anio_vacacion; //calculo de 30%

            $extra = ($dias_considerados != $dias_anio_vacacion)? "($dias_considerados laborados)":'';
            $dias_ley = (($configuracion_vacacion['DIAS_LEY_VACACION'] > 0)? $configuracion_vacacion['DIAS_LEY_VACACION'] : 15);
            //insertar ingreso de vacacion si es que aplica de acuerdo a la configuración

            $extra = ($dias_ley != 15)? "$dias_ley días vacación. ".$extra:$extra;
            */

            if ($aplica_vacacion[0] == 1) {
                $comentario_det_ingreso = ($porcentaje_vacacion_[0] != 100) ? " (" . round($porcentaje_vacacion_[0], 2) . "%)" : null;
                if ($es_descuento_vacacion) {
                    $this->add_descuento_detalle(
                        $planilla->pla_id,
                        $emp->emp_id,
                        $id_desc_vacacion,
                        ($salario_dias_ley * ($porcentaje_vacacion_[0] / 100)),
                        $salario_emp_vac,
                        null,
                        0,
                        $planilla->tpl_frecuencia,
                        null,
                        null,
                        $comentario_det_ingreso
                    );
                } else {
                    $this->add_ingreso_detalle(
                        $planilla,
                        $emp->emp_id,
                        $id_tig_vacacion,
                        ($salario_dias_ley * ($porcentaje_vacacion_[0] / 100)),
                        null,
                        $planilla->tpl_frecuencia,
                        $extra . $comentario_det_ingreso
                    );
                }
            }

            //insertar ingreso de vacacion del 30% si es que aplica de acuerdo a la configuración.
            if ($aplica_vacacion[1] == 1) {
                $comentario_det_ingreso = ($porcentaje_vacacion_[1] != 100) ? " (" . round($porcentaje_vacacion_[1], 2) . "%)" : null;
                $desc_pgr = 0;
                $tdc_pgr_id = $this->gsatelite->get_parametro_emp('SYS_DESCUENTO_PGR', null, null, array('TIPO_DESCUENTO_ID')); //TIPO DE DESCUENTO DE PROCURADURIA GNAL DE LA REP.
                $porc_pgr = $this->gsatelite->get_parametro_emp('SYS_DESCUENTO_PGR', null, null, array('PORCENTAJE'));
                if ($tdc_pgr_id > 0) {
                    $posee_desc = $this->gsatelite->get_tabla('dss_descuento', array('dss_estado' => 1, 'dss_permanente' => 1, 'dss_id_emp' => $emp->emp_id, 'dss_id_tdc' => $tdc_pgr_id));
                    if (count($posee_desc) > 0) {
                        //SI EL EMPLEADO POSEE DESCUENTO PGR SE LE RETIENE UN PORCENTAJE DE SU PORCENTAJE VACACION
                        $porc_pgr = (trim($porc_pgr) != "") ? trim($porc_pgr) : 0;
                        $desc_pgr = $porcentaje_vacacion * ($porc_pgr / 100);
                    }
                }
                // if ($emp->emp_id == 76) {var_dump($desc_pgr); die(); }

                $this->add_ingreso_detalle(
                    $planilla,
                    $emp->emp_id,
                    $id_tig_vacacion_prima,
                    ($porcentaje_vacacion * ($porcentaje_vacacion_[1] / 100)),
                    null,
                    $planilla->tpl_frecuencia,
                    $extra . $comentario_det_ingreso
                );
                if ($desc_pgr > 0) {
                    $coment_desc_pgr = $porc_pgr . " % aplicado sobre porcentaje vacación";
                    $this->add_descuento_detalle($planilla->pla_id, $emp->emp_id, $tdc_pgr_id, $desc_pgr, 0, null, 0, $planilla->tpl_frecuencia, null, null, $coment_desc_pgr);
                }
            }
        }
    }

    /**
     * @author René Castaneda
     * @since 21-12-2017
     * @Description: función para el cálculo del aguinaldo de un empleado
     * @param array object $empleado (información del empleado)
     * @param array object $planilla (información de la planilla)
     */
    public function promedio_comision_dias($emp, $pla = null)
    {
        $promedio = 0;
        $planillas_empleado = $this->gsatelite->get_tabla("txe_tipo_planillaxempleado", array('txe_id_emp' => $emp->emp_id));
        if (count($planillas_empleado) > 0) {
            $dias_mes = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30);
            $tpls_ids = array_column($planillas_empleado, 'txe_id_tpl');
            if (in_array($this->tpl_comision, $tpls_ids)) {
                $n_meses = (trim($configuracion_vacacion['NUMERO_MESES_PARA_VACACION']) > 1) ? ($configuracion_vacacion['NUMERO_MESES_PARA_VACACION'] - 1) : 5;
                $query_pla = $this->db->select("ddi_id_pla, pla_fecha_fin")
                    ->from("ddi_detalle_ingreso")
                    ->join("pla_planilla", "pla_id = ddi_id_pla")
                    ->where('pla_id_tpl', $this->tpl_comision)
                    ->where("ddi_id_emp", $emp->emp_id)
                    ->where("pla_estado", 3)
                    ->group_by("pla_id")
                    ->order_by("pla_fecha_fin", "DESC")
                    ->limit(1);
                if ($pla) {
                    $this->db->where('DATE(pla_fecha_fin) <= ', $pla->pla_fecha_inicio);
                }
                $query_pla =  $query_pla->get()->row_array();
                if ($query_pla) {
                    $fecha = date_create($query_pla['pla_fecha_fin']);
                    $f_1 = date_add($fecha, date_interval_create_from_date_string("-$n_meses month"));
                    $fecha_ini = date_format($fecha, 'Y-m-01');
                    $fecha_fin = formatear_fecha('Y-m-t', $query_pla['pla_fecha_fin']);
                    $q_ing = $this->db->select("IFNULL(SUM(ddi_valor), 0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses", false)
                        ->from("ddi_detalle_ingreso")
                        ->join("pla_planilla", "pla_id = ddi_id_pla")
                        ->where("pla_estado", 3)
                        ->where('pla_id_tpl', $this->tpl_comision)
                        ->where("ddi_id_emp", $emp->emp_id)
                        ->where("pla_fecha_inicio >=", $fecha_ini)
                        ->where("pla_fecha_fin <=", $fecha_fin)
                        ->where("ddi_id_tig", $this->tig_comision)
                        ->get()->row_array();
                    // if ($emp->emp_id == 43) { var_dump($this->db->last_query());die(); }
                    $mesini = formatear_fecha('Ym', $fecha_ini);
                    $mesfin = formatear_fecha('Ym', $fecha_fin);
                    $dias_mes_tbl = $this->gsatelite->get_suma('djm_dias_trajado_mes', 'djm_dias', array('djm_estado' => 1, 'djm_periodo >= ' => $mesini, 'djm_periodo <= ' => $mesfin));
                    if ($dias_mes_tbl > 0) {
                        $promedio = ($q_ing['ingresos'] > 0) ? ($q_ing['ingresos'] * ($dias_mes / $dias_mes_tbl)) : 0;
                    } else {
                        $promedio = ($q_ing['ingresos'] > 0) ? ($q_ing['ingresos'] / ($n_meses + 1)) : 0;
                    }
                }
            }
        }
        return number_format($promedio, 2, '.', '');
    }

    /**
     * @author René Castaneda
     * @since 21-12-2017
     * @Description: 
     * función para el cálculo del aguinaldo de un empleado
     * @param array object $empleado (información del empleado)
     * @param array object $planilla (información de la planilla)
     * @param int  $es_retiro (saber si es retiro o no. 1=true, 0=false)
     */
    public function calculo_aguinaldo_empleado($emp = null, $planilla = null, $es_retiro = false, $porcentaje_agui = 100)
    {
        //print_r($emp); die();
        if (trim($emp->emp_fecha_antiguedad) == '') {
            return null;
        }
        $dias_mes = (trim($this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES')) != '') ? $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES') : 30;

        $id_tig_aguinaldo = (trim($this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO')) > 0) ? $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO') : 0;


        $configuracion_aguinaldo = $this->gsatelite->get_parametro('SYS_CONFIGURACION_AGUINALDO'); //consultar las configuraciones
        $configuracion_aguinaldo = json_decode($configuracion_aguinaldo);
        if (!is_object($configuracion_aguinaldo)) return null;
        $configuracion_aguinaldo = (array) $configuracion_aguinaldo;

        $dias_anio_aguinaldo = (trim($configuracion_aguinaldo['DIAS_ANIO_AGUINALDO']) > 0) ? $configuracion_aguinaldo['DIAS_ANIO_AGUINALDO'] : 0;
        $n = $this->gsatelite->get_intervalo_dias($emp->emp_fecha_antiguedad, $planilla->pla_fecha_fin);
        $n_dias = $n + 1;



        $dias_considerados = ($n_dias >= $dias_anio_aguinaldo) ? $dias_anio_aguinaldo : $n_dias;

        $anios_trabajado = $n_dias / 365; //determinar los anios trabajados en la empresa.

        $salario_emp_agui = $emp->emp_salario;
        $base_dias_laboral = true;
        $salario_dia_agui_prom = 0;
        if ($emp->pto_salario_promediado) { //preguntar si es promediado
            $numero_meses = (trim($configuracion_aguinaldo['NUMERO_MESES_PARA_AGUINALDO']) > 0) ? $configuracion_aguinaldo['NUMERO_MESES_PARA_AGUINALDO'] : 6;
            $id_tag_aguinaldo = (trim($configuracion_aguinaldo['ID_AGRUPADOR_AGUINALDO']) > 0) ? $configuracion_aguinaldo['ID_AGRUPADOR_AGUINALDO'] : 0;

            //preguntar por los meses anteriores excluyendo el actual
            $fecha_inicio_prom = formatear_fecha('Y-m-15', $planilla->pla_fecha_inicio);
            $fecha = date_create($fecha_inicio_prom);
            date_add($fecha, date_interval_create_from_date_string("-1 month"));
            $ffin_ = date_format($fecha, 'Y-m-15'); //para no dar conflicto en conversión pasarlo al día 15

            $fecha = date_create($ffin_);
            date_add($fecha, date_interval_create_from_date_string("-$numero_meses month"));
            $fini = date_format($fecha, 'Y-m-01');
            $ffin = formatear_fecha('Y-m-t', $ffin_);


            //consultar por los ingresos y descuento segun el agrupador
            $q_ing = $this->db->select("IFNULL(SUM(ddi_valor),0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses,
                 GROUP_CONCAT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y%m')) AS det_meses
                 ", false)
                ->from("ddi_detalle_ingreso")
                ->join("pla_planilla", "pla_id = ddi_id_pla")
                ->where("ddi_id_emp", $emp->emp_id)
                ->where("pla_estado", 3) //solo autorizadas
                ->where("pla_fecha_inicio >=", $fini)
                ->where("pla_fecha_fin <=", $ffin)
                ->where("ddi_id_pla !=",  $planilla->pla_id) //excluir la que se esta ejecutando dado que aun no se han generado sus ingresos
                ->where("ddi_id_tig in ( SELECT deg_id_tig from deg_detalle_agrupador where deg_id_tag = $id_tag_aguinaldo AND deg_id_tig is not null )")
                ->get()->row_array();
            // if ($emp->emp_id == 170) {  print_r($this->db->last_query()); die();  } //para debuger
            $q_des = $this->db->select("IFNULL(SUM(ddd_valor),0) AS descuentos", false)
                ->from("ddd_detalle_descuento")
                ->join("pla_planilla", "pla_id = ddd_id_pla")
                ->where("ddd_id_emp", $emp->emp_id)
                ->where("pla_estado", 3) //solo autorizadas
                ->where("pla_fecha_inicio >=", $fini)
                ->where("pla_fecha_fin <=", $ffin)
                ->where("ddd_id_pla !=",  $planilla->pla_id) //excluir la que se esta ejecutando dado que aun no se han generado sus ingresos
                ->where("ddd_id_tdc in ( SELECT deg_id_tdc from deg_detalle_agrupador where deg_id_tag = $id_tag_aguinaldo AND deg_id_tdc is not null )")
                ->get()->row_array();

            //obtener el salario promediado.
            $salario_emp_agui_full = ($q_ing['ingresos'] > 0) ? (($q_ing['ingresos'] - $q_des['descuentos'])) : $emp->emp_salario;
            $salario_emp_agui = ($q_ing['ingresos'] > 0) ? (($q_ing['ingresos'] - $q_des['descuentos']) / $q_ing['meses']) : $emp->emp_salario;


            if ($base_dias_laboral && $q_ing) {
                $dias_segun_mes = $this->gsatelite->get_tabla('djm_dias_trajado_mes', array('djm_estado' => 1));
                $array_dias_meses = ($dias_segun_mes) ? array_column($dias_segun_mes, 'djm_dias', 'djm_periodo') : array();
                $meses_ing = explode(',', $q_ing['det_meses']);
                if ($dias_segun_mes) {
                    $dias_segun_periodo = 0;
                    for ($q = 0; $q < count($meses_ing); $q++) {
                        $mes_p = intval($meses_ing[$q]);
                        if ($mes_p > 0) {
                            $dias_segun_periodo += (array_key_exists($mes_p, $array_dias_meses)) ? intval($array_dias_meses[$mes_p]) : $dias_mes;
                        }
                    }
                    $dias_considerados = ($dias_segun_periodo > 0) ? $dias_segun_periodo : $dias_considerados;
                    $salario_dia_agui_prom = $salario_emp_agui_full / $dias_considerados;
                }
            }
        }
        $prom_comi_dias = $this->promedio_comision_dias($emp);
        if ($prom_comi_dias > 0) {
            $salario_emp_agui += $prom_comi_dias;
        }
        $salario_dia = $salario_emp_agui / $dias_mes;
        $salario_dia = ($salario_dia_agui_prom > 0) ? $salario_dia_agui_prom : $salario_dia;

        $pregunta_goze = $this->gsatelite->get_tabla('agd_aguinaldo', array('agd_estado' => 1));
        $dias_goze = 0;
        foreach ($pregunta_goze as $fpregunta) {
            if ($anios_trabajado >= $fpregunta['agd_desde'] and $anios_trabajado <= $fpregunta['agd_hasta']) {
                $dias_goze = $fpregunta['agd_dias_derecho'];
            }
        }



        $salario_dias_ley = $salario_dia * $dias_goze;
        $salario_dias_ley = ($salario_dias_ley * $dias_considerados) / $dias_anio_aguinaldo; //calculo de los dias de goze.
        $exito = false;
        if ($salario_dias_ley > 0) {
            $comentario_det_agui = ($porcentaje_agui != 100) ? "(" . round($porcentaje_agui, 2) . "%)" : null;
            $aguinaldo_neto = ($salario_dias_ley * ($porcentaje_agui / 100));
            $desc_pgr = 0;
            $tdc_pgr_id = $this->gsatelite->get_parametro_emp('SYS_DESCUENTO_PGR', null, null, array('TIPO_DESCUENTO_ID')); //TIPO DE DESCUENTO DE PROCURADURIA GNAL DE LA REP.
            $porc_pgr = $this->gsatelite->get_parametro_emp('SYS_DESCUENTO_PGR', null, null, array('PORCENTAJE'));
            if ($tdc_pgr_id > 0) {
                $posee_desc = $this->gsatelite->get_tabla('dss_descuento', array('dss_estado' => 1, 'dss_permanente' => 1, 'dss_id_emp' => $emp->emp_id, 'dss_id_tdc' => $tdc_pgr_id));
                if (count($posee_desc) > 0) {
                    //SI EL EMPLEADO POSEE DESCUENTO PGR SE LE RETIENE UN PORCENTAJE DEL TOTAL DE SU AGUINALDO
                    $porc_pgr = (trim($porc_pgr) != "") ? trim($porc_pgr) : 0;
                    $desc_pgr = $aguinaldo_neto * ($porc_pgr / 100);
                }
            }
            // if ($emp->emp_id == 3) { var_dump($desc_pgr); die(); }

            $exito =  $this->add_ingreso_detalle(
                $planilla,
                $emp->emp_id,
                $id_tig_aguinaldo,
                $aguinaldo_neto,
                null,
                $planilla->tpl_frecuencia,
                $comentario_det_agui
            );
            if ($desc_pgr > 0) {
                $coment_desc_agui = $porc_pgr . " % aplicado sobre aguinaldo";
                $coment_desc_agui .= ($comentario_det_agui) ? " " . $comentario_det_agui : null;
                $this->add_descuento_detalle($planilla->pla_id, $emp->emp_id, $tdc_pgr_id, $desc_pgr, 0, null, 0, $planilla->tpl_frecuencia, null, null, $coment_desc_agui);
            }
        }

        if ($exito) {
            //actualizar en el empleado la ultima fecha de aguinaldo
            $this->gsatelite->actualizar_array(
                'emp_empleado',
                array(
                    'emp_fecha_ult_aguinaldo' => $planilla->pla_fecha_pago,
                    'emp_usu_mod' => $this->tank_auth->get_user_id(),
                    'emp_fecha_mod' => date('Y-m-d H:i:s')
                ),
                array('emp_id' => $emp->emp_id)
            );
        }
    }


    /**
     * @author René Castaneda
     * @since 22-01-2018
     * @Description: 
     * función para el calcular los descuentos de ley en caliente segun el salario promediado
     * @param int  $empleado (información del empleado)
     * @param double  $monto (monto bajo el cual se hara el cálculo)
     * @param int  $id_tipo_planilla (id del tipo de planilla)
     */
    function descuentos_ley_vivo($empleado, $monto = 0, $id_tipo_planilla = 0)
    {

        //tipos de descuento
        $AFP = $this->gsatelite->get_parametro('DESCUENTO_AFP');
        $seguro = $this->gsatelite->get_parametro('DESCUENTO_ISS');
        $renta = $this->gsatelite->get_parametro('DESCUENTO_ISR');
        $renta10 = $this->gsatelite->get_parametro('DESCUENTO_ISR10');
        $id_tabla_renta = $this->gsatelite->get_parametro('SYS_ID_TABLA_RENTA_CALCULO');
        $id_tabla_renta = ($id_tabla_renta > 0) ? $id_tabla_renta : 1; //defecto la mensual

        $array_descuentos['AFP'] = 0;
        $array_descuentos['ISSS'] = 0;
        $array_descuentos['RENTA'] = 0;
        $array_descuentos['ES_RENTA10'] = 0;
        $array_descuentos['SUMA_TOTAL'] = 0;
        $array_descuentos['NOMBRE_AFP'] = '';


        $this->db->join('afp_afp', 'afp_id = emp_id_afp', 'left');
        $registro_emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $empleado));
        $registro_emp = $registro_emp[0];

        //preguntar si le estan descontando afp
        $query_afp =  $this->db->select('ddd_id_tdc')
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'pla_id=ddd_id_pla')
            ->where("pla_estado", 3) // estado autorizada
            ->where("ddd_id_tdc", $AFP);
        if ($id_tipo_planilla > 0) {
            $this->db->where('pla_id_tpl', $id_tipo_planilla);
        }
        $this->db->where('ddd_id_emp', $empleado)
            ->limit(1)
            ->get()->row_array();


        if ($query_afp and $registro_emp['emp_id_afp'] > 0) {
            $porcentaje = $registro_emp['afp_porcentaje'] / 100;
            $array_descuentos['AFP'] = number_format(($porcentaje * $monto), 2, '.', '');
            $array_descuentos['NOMBRE_AFP'] =  $registro_emp['afp_nombre'];
        }
        //print_r($array_descuentos); 
        //die();

        //preguntar si le estan descontando isss
        $query_isss =  $this->db->select('ddd_id_tdc')
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'pla_id=ddd_id_pla')
            ->where("pla_estado", 3) // estado autorizada
            ->where("ddd_id_tdc", $seguro);
        if ($id_tipo_planilla > 0) {
            $this->db->where('pla_id_tpl', $id_tipo_planilla);
        }
        $this->db->where('ddd_id_emp', $empleado)
            ->limit(1)
            ->get()->row_array();
        if ($query_isss) {
            $reg_isss = $this->gsatelite->get_registro('tdc_tipo_descuento', 'tdc_id', $seguro);
            $porcentaje = $reg_isss->tdc_porcentaje / 100;
            $monto_calculo = ($monto > $reg_isss->tdc_maximo) ? $reg_isss->tdc_maximo : $monto;
            $array_descuentos['ISSS'] = number_format(($porcentaje * $monto_calculo), 2, '.', '');
        }

        //preguntar si le estan descontando afp
        $query_renta =  $this->db->select('ddd_id_tdc')
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'pla_id=ddd_id_pla')
            ->where("pla_estado", 3) // estado autorizada
            ->where("ddd_id_tdc", $renta);
        if ($id_tipo_planilla > 0) {
            $this->db->where('pla_id_tpl', $id_tipo_planilla);
        }
        $this->db->where('ddd_id_emp', $empleado)
            ->limit(1)
            ->get()->row_array();
        if ($query_renta) {

            $monto_calculo = $monto - ($array_descuentos['AFP'] + $array_descuentos['ISSS']);
            $descuento_renta = 0;

            //obtener tablas de isr para la planilla
            $isr = $this->get_tabla_isr($planilla->pla_id);


            $this->db->select('isr_isr.*');
            $this->db->from('isr_isr');
            $this->db->join('tis_tipo_isr', ' tis_id = isr_id_tis');
            $this->db->where('isr_id_tis', $id_tabla_renta);
            $isr = $this->db->get()->result();

            //echo $this->db->last_query(); die();
            foreach ($isr as $tramo) {
                if ($monto_calculo >= $tramo->isr_desde && $monto_calculo <= $tramo->isr_hasta) {
                    $descuento_renta = $tramo->isr_cuota + ($monto_calculo - $tramo->isr_exceso) * $tramo->isr_porcentaje / 100;
                }
            }

            $array_descuentos['RENTA'] = number_format($descuento_renta, 2, '.', '');
        }

        //preguntar si le estan descontando afp
        $query_renta10 =  $this->db->select('ddd_id_tdc')
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'pla_id=ddd_id_pla')
            ->where("pla_estado", 3) // estado autorizada
            ->where("ddd_id_tdc", $renta10)
            ->where('ddd_id_emp', $empleado)
            ->limit(1)
            ->get()->row_array();

        if ($query_renta10 && $array_descuentos['RENTA'] == 0) {
            $reg_renta10 = $this->gsatelite->get_registro('tdc_tipo_descuento', 'tdc_id', $renta10);
            $porcentaje = $reg_renta10->tdc_porcentaje;
            $array_descuentos['RENTA'] = number_format((($porcentaje / 100) * $monto), 2, '.', '');
            $array_descuentos['ES_RENTA10'] = $porcentaje;
        }

        $array_descuentos['SUMA_TOTAL'] =  $array_descuentos['AFP'] + $array_descuentos['ISSS'] + $array_descuentos['RENTA'];
        return $array_descuentos;
    }


    /**
     * @author René Castaneda
     * @since 22-01-2018
     * @Description: 
     * función para el calcular los descuentos de ley de forma promediada
     * @param int  $empleado (información del empleado)
     * @param double  $monto (monto bajo el cual se hara el cálculo)
     * @param int  $id_tipo_planilla (id del tipo de planilla)
     */
    function descuentos_ley_promediado($empleado, $solo_afp_seguro = null, $id_tipo_planilla = 1)
    {

        $AFP = $this->gsatelite->get_parametro('DESCUENTO_AFP');
        $seguro = $this->gsatelite->get_parametro('DESCUENTO_ISS');
        $renta = $this->gsatelite->get_parametro('DESCUENTO_ISR');
        //$renta10 = $this->gsatelite->get_parametro('DESCUENTO_ISR10');

        //preguntar por el parametro
        $parametro_calculo_vacacion = $this->gsatelite->get_parametro('NUM_PLANILLAS_CALCULO_VACACION');
        $n_num_periodos = ($parametro_calculo_vacacion > 0) ? $parametro_calculo_vacacion : 6;

        //preguntar por el ultimo ingreso del empleado
        $query_pla = $this->db->select("ddi_id_pla, pla_fecha_fin")
            ->from("ddi_detalle_ingreso")
            ->join("pla_planilla", "pla_id = ddi_id_pla")
            ->where("ddi_id_emp", $empleado)
            ->where("pla_estado", 3) // estado autorizada
            ->group_by("pla_id")
            ->order_by("pla_fecha_fin", "DESC")
            ->limit(1);
        if ($id_tipo_planilla > 0) {
            $this->db->where('pla_id_tpl', $id_tipo_planilla);
        }

        $query_pla =  $query_pla->get()->row_array();
        //print_r($this->db->last_query()); die();

        if (!$query_pla) {
            return 0;
        }

        // obtener la fecha de n meses hacia atras a partir de la fecha de ultima planilla generada.
        $fecha_fin = $query_pla['pla_fecha_fin'];
        $fecha = date_create($fecha_fin);
        date_add($fecha, date_interval_create_from_date_string("-$n_num_periodos month"));
        $fecha_inicio = date_format($fecha, 'Y-m-01');




        $this->db->select("(SUM(ddd_valor) / COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m'))) AS ddd_valor, ddd_fecha_mod, tdc_nombre, tdc_id, ban_nombre, dss_id_ban", false)
            ->from('ddd_detalle_descuento')
            ->join('tdc_tipo_descuento', 'tdc_id=ddd_id_tdc')
            ->join('dss_descuento', 'ddd_id_dss=dss_id', 'left')
            ->join('ban_banco', 'dss_id_ban=ban_id', 'left')
            ->join('pla_planilla', 'pla_id=ddd_id_pla')
            ->where('ddd_id_emp', $empleado)
            ->where("pla_estado", 3) // estado autorizada
            ->where("pla_fecha_inicio >=", $fecha_inicio)
            ->where("pla_fecha_fin <=", $fecha_fin);
        if ($id_tipo_planilla > 0) {
            $this->db->where('pla_id_tpl', $id_tipo_planilla);
        }
        $this->db->order_by('tdc_orden')
            ->group_by('tdc_id');
        if ($solo_afp_seguro) {
            $descuentos = array();
            $descuentos[] = $AFP;
            $descuentos[] = $seguro;
            $this->db->where_in('ddd_id_tdc', $descuentos);
        } else {
            $descuentos = array();
            $descuentos[] = $AFP;
            $descuentos[] = $seguro;
            $descuentos[] = $renta;
            $this->db->where_in('ddd_id_tdc', $descuentos);
        }
        $consulta = $this->db->get();
        $datos = $consulta->result_array();
        $resultado = $datos;
        // die($this->db->last_query());

        return $resultado;
    }

    /**
     * @author René Castaneda
     * @since 09-02-2018
     * @Description: 
     * función para obtener los datos de una planilla en especifico.
     * @param int  $planilla_id id de la planilla a generar el reporte.
     */
    function datos_planilla_personalizada($planilla_id, $sucursal = ""){
        $id_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $dias_trabaja_mes = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES');
        $horas_trabaja_dia = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA');
        $columna_personalizada_extra = $this->gsatelite->get_parametro('COLUMN_PERSONALIZADA_PLANILLA_RPTE', 0);
        $id_ing_salario = $this->tig_salario;
        $es_alcaldia = (substr_count(mb_strtolower($this->gsatelite->get_parametro_emp('SYS_EMPRESA'), 'UTF-8'), 'municipal') > 0) ? 1 : 0;
        if (is_array($planilla_id)) {
            $this->db->group_by('tpl_id');
            $this->db->where_in('pla_id', $planilla_id);
            $this->db->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl');
            $agrupador_reporte_person = $this->gsatelite->get_campo('pla_planilla', 'tpl_id_tag', array('pla_estado >' => 0));
        } else {
            $this->db->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl');
            $agrupador_reporte_person = $this->gsatelite->get_campo('pla_planilla', 'tpl_id_tag', array('pla_id' => $planilla_id, 'pla_estado >' => 0));
        }
        if ($agrupador_reporte_person != "") {
            $id_agrupador_reporte = $agrupador_reporte_person;
        } else {
            $id_agrupador_reporte = $this->gsatelite->get_parametro('SYS_ID_AGRUPADOR_PLANILLA_REPORTE');
        }
        //SI NO EXISTE EL PARAMETRO ABORTAR OPERACION
        if ($id_agrupador_reporte != "") {
            $detalles = $this->gsatelite->get_tabla('deg_detalle_agrupador', array('deg_id_tag' => $id_agrupador_reporte));
            if (!(count($detalles) > 0)) {
                //verificar que haya ingresos/descuentos en el deg_detalle_agrupador, sino abortar la operacion
                $this->gsatelite->show_dialog('Verifique el agrupador e inténtelo de nuevo', '', 'error', 'Error de Agrupador ');
            }
        } else {
            $this->gsatelite->show_dialog('Verifique la configuración e inténtelo de nuevo', '', 'error', 'Error de Parámetro ');
        }
        $where_planilla = (is_array($planilla_id)) ? " IN (" . implode(',', $planilla_id) . ")" : " IN ($planilla_id)";
        $planilla = $this->db->select("COUNT(DISTINCT pla_id) n_pla, MIN(pla_fecha_inicio) pla_fecha_inicio, MAX(pla_fecha_fin) pla_fecha_fin, 
                            GROUP_CONCAT(DISTINCT pla_id) ids_pla, GROUP_CONCAT(DISTINCT pla_id_tpl) ids_tpl, MAX(tpl_cantidad) cantidad_planilla, 
                            MAX(tpl_frecuencia) frecuencia_mayor ")
            ->from($this->planillas)
            ->join($this->tipo_planillas, 'pla_id_tpl = tpl_id')
            ->where("pla_id " . $where_planilla, null, false)
            ->get()->row();
        // echo $this->db->last_query(); die();
        // $dias_trabaja_mes = ($planilla->cantidad_planilla > 0)? ($dias_trabaja_mes/$planilla->cantidad_planilla):$dias_trabaja_mes;
        $dias_trabaja_mes =  ($planilla->frecuencia_mayor > 0) ? $planilla->frecuencia_mayor : $dias_trabaja_mes;
        $men_quin_sem = ($planilla->frecuencia_mayor == 7) ? ' Semanal' : (($planilla->frecuencia_mayor == 15) ? ' Quincenal' : ' Mensual');
        $this->db->select("emp_id, emp_codigo, emp_apellido, emp_nombre, emp_salario, emp_fecha_contrato, emp_numero_cuenta, emp_metodo_pago, plz_nombre, dce_valor, are_id, are_nombre, suc_nombre, are_orden,
            IFNULL(
                (SELECT (CASE ddi_id_tig WHEN  $id_ing_salario THEN SUM(ddi_valor)
                /* - IFNULL(((SELECT SUM(IFNULL(ddd_valor,0)) from hxe_hora_extraxempleado JOIN dss_descuento on dss_id_hxe = hxe_id JOIN ddd_detalle_descuento on ddd_id_dss = dss_id 
                where hxe_id_emp = ddi_id_emp AND ddd_id_emp = ddi_id_emp AND ddd_id_pla IN ($planilla->ids_pla) AND hxe_id_thf is not NULL)),0) */                        
                ELSE SUM(ddi_valor) 
                END)
                FROM ddi_detalle_ingreso WHERE ddi_id_emp = emp_id AND ddi_id_pla IN ($planilla->ids_pla) GROUP BY ddi_id_emp ), 
            0) AS ingresos,
            IFNULL(
                (SELECT SUM(ddd_valor)
                /*  - IFNULL(((SELECT SUM(IFNULL(ddd_valor,0)) from hxe_hora_extraxempleado JOIN dss_descuento on dss_id_hxe = hxe_id JOIN ddd_detalle_descuento on ddd_id_dss = dss_id
                where hxe_id_emp = emp_id AND ddd_id_emp = emp_id AND ddd_id_pla IN ($planilla->ids_pla) AND hxe_id_thf is not NULL)),0) */
                FROM ddd_detalle_descuento WHERE ddd_id_emp = emp_id AND ddd_id_pla IN ($planilla->ids_pla)  GROUP BY ddd_id_emp), 
            0) AS descuentos,
            (SELECT SUM(IFNULL(hxe_num_hora,0)) FROM hxe_hora_extraxempleado JOIN dss_descuento on dss_id_hxe = hxe_id JOIN ddd_detalle_descuento ON ddd_id_dss = dss_id
            WHERE hxe_id_emp = emp_id AND ddd_id_emp = emp_id AND ddd_id_pla IN ($planilla->ids_pla) AND hxe_id_thf IS NOT NULL) horas_faltante,
            (SELECT SUM((DATEDIFF(pla_fecha_fin,pla_fecha_inicio) +1)) FROM pla_planilla WHERE pla_id IN ($planilla->ids_pla)) dias_periodo,
            IFNULL(((SELECT SUM(IFNULL(ddd_valor,0)) from hxe_hora_extraxempleado JOIN dss_descuento on dss_id_hxe = hxe_id JOIN ddd_detalle_descuento on ddd_id_dss = dss_id
                WHERE hxe_id_emp = emp_id AND ddd_id_emp = emp_id AND ddd_id_pla IN ($planilla->ids_pla) AND hxe_id_thf IS NOT NULL)),
            0) tiempo_notrabajado,
            IFNULL(are_id_cec,0) AS linea,
            IFNULL((SELECT CONCAT(cec_codigo, ' - ', cec_nombre) FROM cec_centro_costo WHERE cec_id = are_id_cec), '') AS nombre_linea
            ", false);
        $this->db->join('dce_documento_emp', "dce_id_emp = emp_id AND dce_id_tde=$id_nit", 'left');
        $this->db->join('plz_plaza', 'emp_id_plz = plz_id', 'left');
        $this->db->join('are_area', 'are_id=emp_id_are', 'left');
        $this->db->join('suc_sucursal', 'suc_id=emp_id_suc', 'left');
        $this->db->join('txe_tipo_planillaxempleado', "txe_id_emp=emp_id AND txe_id_tpl IN ($planilla->ids_tpl)", 'left');
        $this->db->where("emp_id IN (SELECT di.ddi_id_emp FROM ddi_detalle_ingreso AS di WHERE di.ddi_id_pla  IN ($planilla->ids_pla) GROUP BY di.ddi_id_emp )", null, false);
        if ($sucursal != "" && $sucursal > 0) {
            $this->db->where('emp_id_suc', $sucursal);
        }
        $this->db->group_by('emp_id');
        if ($es_alcaldia > 0) {
            $this->db->order_by('are_id_cec', 'ASC');
        }
        // SI SE QUIERE USAR SCAPE EN EL ORDERBY
        // $this->db->_protect_identifiers = FALSE;
        // $this->db->order_by("IFNULL(are_orden, 0) ASC");
        // $this->db->_protect_identifiers = TRUE;
        // SI NO POSEE ARE_ORDEN MANDA EL NIVEL DEL AREA
        $this->db->order_by('are_orden', 'ASC');
        $this->db->order_by('are_nivel', 'ASC');
        $this->db->order_by('are_id', 'ASC');
        $this->db->order_by('emp_apellido', "ASC");
        $empleados = $this->db->get($this->empleados)->result_array();
        // var_dump($this->db->last_query());die();
        //CONSULTAR LAS COLUMNAS DE INGRESOS Y DESCUENTOS QUE SE MOSTRARÁN.
        //Obtener el primer ingreso
        $q_colum_ingreso1 = $this->db->select("tig_id, tig_codigo, tig_nombre, '0' AS inicio_ing", false)
            ->from('deg_detalle_agrupador')
            ->join('tig_tipo_ingreso', 'tig_id = deg_id_tig')
            ->where('deg_id_tag', $id_agrupador_reporte)->limit(1)->get()->result_array();
        $q_colum_ingreso1 = (count($q_colum_ingreso1) > 0) ? $q_colum_ingreso1 : array();
        if (count($q_colum_ingreso1) > 0) {
            $q_colum_ingreso1[0]['tig_nombre'] .= $men_quin_sem;
        }
        $q_colum_ingreso2 = array();
        $q_colum_ingreso3 = array();
        if (count($q_colum_ingreso1) == 1) {
            $q_colum_ingreso3 = $this->db->select("tig_id, tig_codigo, tig_nombre, '0' AS inicio_ing", false)
                ->from('deg_detalle_agrupador')
                ->join('tig_tipo_ingreso', 'tig_id = deg_id_tig')
                ->where('deg_id_tag', $id_agrupador_reporte)
                ->where('tig_id !=', $q_colum_ingreso1[0]['tig_id'])
                ->get()->result_array();
        }
        $q_colum_ingreso = array_merge($q_colum_ingreso1, $q_colum_ingreso2, $q_colum_ingreso3);
        $q_colum_descuento = $this->db->select("deg_id_tdc, tdc_id, tdc_codigo, tdc_nombre, '0' AS inicio_des", false)
            ->from('deg_detalle_agrupador')
            ->join('tdc_tipo_descuento', 'tdc_id = deg_id_tdc')
            ->where('deg_id_tag', $id_agrupador_reporte)->get()->result_array();

        //NOMBRES DE LAS COLUMNAS
        $nombres_columnas['TITULO_PLANILLA'] = (($planilla->n_pla > 1) ? $planilla->n_pla . " PLANILLAS" : "PLANILLA") . " CORRESPONDIENTE AL PERIODO " . formatear_fecha('d-m-Y', $planilla->pla_fecha_inicio) . " AL " . formatear_fecha('d-m-Y', $planilla->pla_fecha_fin);

        $nombres_cols = json_decode($this->gsatelite->get_parametro('SYS_CONF_PLANILLA_CAMPOS', true, null));
        $nombres_cols = (array)$nombres_cols;
        //SE MOSTRARAN SIEMPRE LAS COLUMNAS #/CODIGO EMPLEADO/NOMBRE EMPLEADO
        $nombres_columnas['EMPLEADO'][0] = "N&deg;";
        $nombres_columnas['EMPLEADO'][1] = "C&Oacute;DIGO";
        $nombres_columnas['EMPLEADO'][2] = "EMPLEADO";
        foreach ($nombres_cols as $key_col => $fila_cols) {
            $fila_cols = (array)$fila_cols;
            if ($fila_cols['MOSTRAR']) { //preguntar si se mostrará o no en la planilla
                $nombres_columnas['EMPLEADO'][($key_col + 3)] = mb_strtoupper($fila_cols['NOMBRE'], 'UTF-8');
            }
        }
        $title_ing = array_column($q_colum_ingreso, 'tig_nombre');
        $title_des = array_column($q_colum_descuento, 'tdc_nombre');
        $nombres_columnas['INGRESOS'] = array_merge($title_ing, array('OTROS_ING' => 'Otros Ingresos', 'TOTAL_ING' => 'Total Ingresos'));
        if ($columna_personalizada_extra > 0) {
            $name = $this->gsatelite->get_campo('tag_tipo_agrupador', 'tag_nombre', array('tag_id' => $columna_personalizada_extra));
            $nombres_columnas['INGRESOS']['PERSONALIZADO'] = $name;
        }
        $nombres_columnas['DESCUENTOS'] = array_merge($title_des, array('OTROS_DES' => 'Otros Descuentos', 'TOTAL_DES' => 'Total Descuentos'));
        $array_ing_ID = array_column($q_colum_ingreso, 'tig_id');
        $array_des_ID = array_column($q_colum_descuento, 'tdc_id');
        //pendiente funcionalidad*****
        //Agregar complementos predeterminados al final de la planilla
        /*
        $nombres_columnas['COMPLEMENTO'] = array(); 
        $aplica_isss_p = false;
        $aplica_afp_p = false;
        //preguntar si aplica isss
        if (in_array($this->tdc_isss, $array_des_ID)) {
           $nombres_columnas['COMPLEMENTO']['ISSS_P'] = 'ISSS Patronal';,'APF_P'=>'AFP Patronal');
           $aplica_isss_p = true;
        }
        //preguntar si aplica afp
        if (in_array($this->tdc_afp, $array_des_ID)) {
           $nombres_columnas['COMPLEMENTO']['APF_P'] = 'AFP Patronal';
           $aplica_afp_p = true;
        }        
        */
        //inicializar para totalizar hasta el final
        //INGRESOS
        $array_ing_TOTAL = array_column($q_colum_ingreso, 'inicio_ing', 'tig_id');
        $array_ing_TOTAL['OTROS_ING'] = 0;
        $array_ing_TOTAL['TOTAL_ING'] = 0;
        if ($columna_personalizada_extra > 0) {
            $array_ing_TOTAL['PERSONALIZADO'] = 0;
        }
        //DESCUENTOS
        $array_des_TOTAL = array_column($q_colum_descuento, 'inicio_des', 'tdc_id');
        $array_des_TOTAL['OTROS_DES'] = 0;
        $array_des_TOTAL['TOTAL_DES'] = 0;
        $n_registros = count($empleados);
        //id del are que sera un bandera para hacer la totalizacion por separado por area
        //asignar la primera area correspondiente
        $are_id_cec_ini = ($n_registros > 0) ? $empleados[0]['linea'] : 0;
        $id_area_inicial = ($n_registros > 0) ? $empleados[0]['are_id'] : 0;
        $nombre_area_inicial = ($n_registros > 0) ? $empleados[0]['are_nombre'] : '';
        $are_id_cec_nom_inic = ($n_registros > 0) ? $empleados[0]['nombre_linea'] : '';
        $sub_inicializados_in = $array_ing_TOTAL;
        $sub_inicializados_des = $array_des_TOTAL;
        $sub_inicializados_cecin = $array_ing_TOTAL;
        $sub_inicializados_cecds = $array_des_TOTAL;
        $subtotal_area_in[$id_area_inicial] = $sub_inicializados_in;
        $subtotal_area_des[$id_area_inicial] = $sub_inicializados_des;
        $subtotal_linea_in[$id_area_inicial] = $sub_inicializados_cecin;
        $subtotal_linea_ds[$id_area_inicial] = $sub_inicializados_cecds;
        //pendiente funcionalidad*****
        /*
        //COMPLEMENTOS
        if ($aplica_isss_p) {
            $array_comp_TOTAL['ISSS_COMP'] = 0;
            $subtotal_area_comp[$id_area_inicial]['ISSS_COMP'] = 0;
        }
        if ($aplica_afp_p) {
            $array_comp_TOTAL['AFP_COMP'] = 0;
            $subtotal_area_comp[$id_area_inicial]['AFP_COMP'] = 0;
        }
        */
        $simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

        $correlativo = 0;
        $valores_columnas['EMPLEADO'] = array();
        $valores_columnas['INGRESOS'] = array();
        $valores_columnas['DESCUENTOS'] = array();
        $valores_columnas['COMPLEMENTO'] = array();
        $valoresColum = array();
        if ($es_alcaldia > 0) {
            // SI ES ALCALDIA LA PRIMER FILA SERA EL NOMBRE DE LA 1ER "LINEA"
            $valoresColum[] = array(
                'NOMBRE_CEC' => $are_id_cec_nom_inic,
                'CEC_TOTALES' => array()
            );
        }
        foreach ($empleados as $fila_emp) {
            $correlativo++;
            //$dias_trabaja_mes = ($fila_emp['dias_periodo']>0)? $fila_emp['dias_periodo']:$dias_trabaja_mes;
            //si el area ya no es la misma reinicializar las variables.
            if ($fila_emp['are_id'] != $id_area_inicial) {
                $subtotal_area_in[$id_area_inicial]['NOMBRE'] = $nombre_area_inicial;
                //agregar al final el total a pagar del area
                $subtotal_area_des[$id_area_inicial]['TOTAL_PAGAR'] = ($subtotal_area_in[$id_area_inicial]['TOTAL_ING'] - $subtotal_area_des[$id_area_inicial]['TOTAL_DES']);
                $datos_sub['SUB_INGRESOS'] = $subtotal_area_in[$id_area_inicial];
                $datos_sub['SUB_DESCUENTOS'] = $subtotal_area_des[$id_area_inicial];
                //pendiente funcionalidad*****
                // $datos_sub['SUB_COMPLEMENTO'] = $subtotal_area_comp[$id_area_inicial];
                $valoresColum[] = $datos_sub;
                $subtotal_area_in[$fila_emp['are_id']] = $sub_inicializados_in;
                $subtotal_area_des[$fila_emp['are_id']] = $sub_inicializados_des;
                $id_area_inicial = $fila_emp['are_id'];
                $nombre_area_inicial = $fila_emp['are_nombre'];
            }
            if ($fila_emp['linea'] != $are_id_cec_ini && $es_alcaldia > 0) {
                $subtotal_linea_ds[$are_id_cec_ini]['TOTAL_PAGAR'] = ($subtotal_linea_in[$are_id_cec_ini]['TOTAL_ING'] - $subtotal_linea_ds[$are_id_cec_ini]['TOTAL_DES']);
                $cec_sub['SUB_INGRESOS'] = $subtotal_linea_in[$are_id_cec_ini];
                $cec_sub['SUB_DESCUENTOS'] = $subtotal_linea_ds[$are_id_cec_ini];
                $valoresColum[] = array(
                    'NOMBRE_CEC' => $are_id_cec_nom_inic,
                    'CEC_TOTALES' => $cec_sub
                );
                // REINICIALIZAR
                $subtotal_linea_in[$fila_emp['linea']] = $sub_inicializados_cecin;
                $subtotal_linea_ds[$fila_emp['linea']] = $sub_inicializados_cecds;
                $valoresColum[] = array(
                    'NOMBRE_CEC' => $fila_emp['nombre_linea'],
                    'CEC_TOTALES' => array()
                );
                $are_id_cec_ini = $fila_emp['linea'];
                $are_id_cec_nom_inic = $fila_emp['nombre_linea'];
            }
            $where_in = array('ddi_id_emp' => $fila_emp['emp_id'], "ddi_id_pla IN ($planilla->ids_pla)" =>  null);
            $where_des = array('ddd_id_emp' => $fila_emp['emp_id'], "ddd_id_pla IN ($planilla->ids_pla)" => null);
            $get_ingresos = $this->db->select("ddi_id_tig, SUM(ddi_valor) ddi_valor,
                (CASE ddi_id_tig  WHEN  $id_ing_salario THEN
                    SUM(ddi_valor)  - IFNULL(( (SELECT SUM(IFNULL(ddd_valor,0)) from hxe_hora_extraxempleado JOIN dss_descuento on dss_id_hxe = hxe_id
                        JOIN ddd_detalle_descuento on ddd_id_dss = dss_id WHERE hxe_id_emp = ddi_id_emp AND ddd_id_emp = ddi_id_emp AND ddd_id_pla IN ($planilla->ids_pla) 
                        AND hxe_id_thf IS NOT NULL) ),0)
                ELSE SUM(ddi_valor) END) ddi_valor2,
                IFNULL(( (SELECT IFNULL(GROUP_CONCAT(DISTINCT ddd_id),0) from hxe_hora_extraxempleado JOIN dss_descuento on dss_id_hxe = hxe_id 
                    JOIN ddd_detalle_descuento on ddd_id_dss = dss_id WHERE hxe_id_emp = ddi_id_emp AND ddd_id_emp = ddi_id_emp AND ddd_id_pla IN ($planilla->ids_pla)  
                    AND hxe_id_thf IS NOT NULL) ),0) id_descuento_horas
                ", false)
                ->from('ddi_detalle_ingreso')->where($where_in)->group_by("ddi_id_tig")->get()->result_array();
            $array_horas_des = array_column($get_ingresos, 'id_descuento_horas');
            $descuento_horas_id = '0';
            if (count($array_horas_des) > 0) {
                $descuento_horas_id = implode(',', $array_horas_des);
            }
            $get_descuentos = $this->db->select("ddd_id_tdc, SUM(ddd_valor) AS ddd_valor, SUM(ddd_valor_patronal) AS ddd_valor_patronal")->from('ddd_detalle_descuento')
                ->where($where_des)
                ->group_by("ddd_id_tdc")->get()->result_array();
            $array_ing = array_column($q_colum_ingreso, 'inicio_ing', 'tig_id');
            $array_ing['OTROS_ING'] = $fila_emp['ingresos'];
            $array_ing['TOTAL_ING'] = $fila_emp['ingresos'];
            if ($columna_personalizada_extra > 0) {
                $where_plas = (is_array($planilla_id)) ? implode(',', $planilla_id)  : $planilla_id;
                $valor_pers = $this->get_agrupado_personalizado($fila_emp['emp_id'], $where_plas, $columna_personalizada_extra);
                $array_ing['PERSONALIZADO'] = $valor_pers;
            }
            $array_des = array_column($q_colum_descuento, 'inicio_des', 'tdc_id');
            $array_des['OTROS_DES'] = $fila_emp['descuentos'];
            $array_des['TOTAL_DES'] = $fila_emp['descuentos'];
            $array_des['TOTAL_PAGAR'] = ($fila_emp['ingresos'] - $fila_emp['descuentos']); //AGREGAR EL TOTAL A PAGAR EN LA ULTIMA POSICIÓN
            if ($es_alcaldia > 0) {
                $array_des['FIRMA_EMPLEADO'] = "";
            }
            //pendiente funcionalidad*****
            /*
            //COMPLEMENTOS
            if ($aplica_isss_p) {
                $array_comp['ISSS_COMP'] = 0;
            }
            if ($aplica_afp_p) {
                $array_comp['AFP_COMP'] = 0;
            }
            */
            $valor_ingresos = array_column($get_ingresos, 'ddi_valor', 'ddi_id_tig');
            $valor_descuentos = array_column($get_descuentos, 'ddd_valor', 'ddd_id_tdc');
            //pendiente funcionalidad*****
            /*
            //COMPLEMENTOS
            if ($aplica_isss_p || $aplica_afp_p) {
                $valor_descuentos_patronal = array_column($get_descuentos, 'ddd_valor_patronal', 'ddd_id_tdc');
            }
            */
            // Forma de pago de salario
            $cuenta_empleado = "";
            if (trim($fila_emp['emp_metodo_pago']) != "") {
                if ($fila_emp['emp_metodo_pago'] == 1) {
                    $cuenta_empleado = trim($fila_emp['emp_numero_cuenta']);
                } elseif ($fila_emp['emp_metodo_pago'] == 2) {
                    $cuenta_empleado = 'Cheque';
                } elseif ($fila_emp['emp_metodo_pago'] == 3) {
                    $cuenta_empleado = 'Efectivo';
                }
            } else {
                $cuenta_empleado = (trim($fila_emp['emp_numero_cuenta']) != "") ? trim($fila_emp['emp_numero_cuenta']) : 'Cheque';
            }
            $dias_trabajados = ($fila_emp['horas_faltante']) ? (round($dias_trabaja_mes - ($fila_emp['horas_faltante'] / $horas_trabaja_dia), 2)) : $dias_trabaja_mes;
            $valores_columnas['EMPLEADO'][0] = $correlativo . "##" . $fila_emp['emp_id'];
            $valores_columnas['EMPLEADO'][1] = $fila_emp['emp_codigo'];
            $valores_columnas['EMPLEADO'][2] = $fila_emp['emp_nombre'] . ' ' . $fila_emp['emp_apellido'];
            $array_datos_generales = array(
                $fila_emp['are_nombre'],
                $fila_emp['plz_nombre'],
                $fila_emp['suc_nombre'], ///ADDED FEB/2022
                $fila_emp['emp_fecha_contrato'],
                $fila_emp['dce_valor'],
                $cuenta_empleado,
                $dias_trabajados,
                $simbolo . number_format($fila_emp['emp_salario'], 2, '.', '')
            );
            foreach ($nombres_cols as $key_col => $fila_cols) {
                $fila_cols = (array) $fila_cols;
                if ($fila_cols['MOSTRAR']) { //preguntar si se mostrará o no en la planilla
                    $valores_columnas['EMPLEADO'][($key_col + 3)] = $array_datos_generales[$key_col];
                }
            }
            //PARA EL TIEMPO NO TRABAJADO
            // $array_ing['tiempo_no_tra'] = $fila_emp['tiempo_notrabajado'];
            // $array_ing_TOTAL['tiempo_no_tra'] +=  $fila_emp['tiempo_notrabajado'];
            // $subtotal_area_in[$fila_emp['are_id']]['tiempo_no_tra'] += $fila_emp['tiempo_notrabajado'];
            //PARA LOS INGRESOS
            foreach ($valor_ingresos as $key => $value) {
                if (in_array($key, $array_ing_ID)) {
                    $array_ing[$key] = $value;
                    //incrementar tambien el array que llevará los totales.
                    $array_ing_TOTAL[$key] +=  $value;
                    //como se inicializo con el total se le restará el que se encuente
                    $array_ing['OTROS_ING'] -= $value;

                    //INCREMENTAR LOS SUBTOTALES DE LAS AREAS
                    $subtotal_area_in[$fila_emp['are_id']][$key] += $value;
                    if ($es_alcaldia > 0) {
                        $subtotal_linea_in[$fila_emp['linea']][$key] += $value;
                    }
                }
            }
            //Al final del recorrido incrementar las variables inicializadas correspondiente a otros ingresos y al total de ingresos
            $array_ing_TOTAL['OTROS_ING'] +=  $array_ing['OTROS_ING'];
            $array_ing_TOTAL['TOTAL_ING'] +=  $array_ing['TOTAL_ING'];
            //INCREMENTAR LOS VALORES DEL AREA
            $subtotal_area_in[$fila_emp['are_id']]['OTROS_ING'] += $array_ing['OTROS_ING'];
            $subtotal_area_in[$fila_emp['are_id']]['TOTAL_ING'] += $array_ing['TOTAL_ING'];
            //INCREMENTAR LOS VALORES DE LA LINEA
            if ($es_alcaldia > 0) {
                $subtotal_linea_in[$fila_emp['linea']]['OTROS_ING'] += $array_ing['OTROS_ING'];
                $subtotal_linea_in[$fila_emp['linea']]['TOTAL_ING'] += $array_ing['TOTAL_ING'];
            }
            if ($columna_personalizada_extra > 0) {
                $array_ing_TOTAL['PERSONALIZADO'] +=  $array_ing['PERSONALIZADO'];
                $subtotal_area_in[$fila_emp['are_id']]['PERSONALIZADO'] += $array_ing['PERSONALIZADO'];
            }
            //PARA LOS DESCUENTOS
            //print_r($array_des_TOTAL); die();
            foreach ($valor_descuentos as $key => $value) {
                if (in_array($key, $array_des_ID)) {
                    $array_des[$key] = $value;
                    //incrementar tambien el array que llevará los totales.
                    $array_des_TOTAL[$key] +=  $value;
                    //como se inicializo con el total se le restará el que se encuente
                    $array_des['OTROS_DES'] -= $value;
                    //INCREMENTAR LOS SUBTOTALES DE LAS AREAS
                    $subtotal_area_des[$fila_emp['are_id']][$key] += $value;
                    if ($es_alcaldia > 0) {
                        $subtotal_linea_ds[$fila_emp['linea']][$key] += $value;
                    }
                    //pendiente funcionalidad*****
                    /*
                    //COMPLEMENTOS
                    if ($aplica_isss_p && ($key == $this->tdc_isss ) {
                        $array_comp['ISSS_COMP'] += $valor_descuentos_patronal[$key];
                    }
                    if ($aplica_afp_p && ($key == $this->tdc_afp)) {
                        $array_comp['AFP_COMP'] += $valor_descuentos_patronal[$key];
                    } */
                }
            }
            //Al final del recorrido incrementar las variables inicializadas correspondiente a otros ingresos y al total de ingresos
            $array_des_TOTAL['OTROS_DES'] +=  $array_des['OTROS_DES'];
            $array_des_TOTAL['TOTAL_DES'] +=  $array_des['TOTAL_DES'];

            //INCREMENTAR LOS VALORES DEL AREA
            $subtotal_area_des[$fila_emp['are_id']]['OTROS_DES'] += $array_des['OTROS_DES'];
            $subtotal_area_des[$fila_emp['are_id']]['TOTAL_DES'] += $array_des['TOTAL_DES'];
            //INCREMENTAR LOS VALORES DE LA LINEA
            if ($es_alcaldia > 0) {
                $subtotal_linea_ds[$fila_emp['linea']]['OTROS_DES'] += $array_des['OTROS_DES'];
                $subtotal_linea_ds[$fila_emp['linea']]['TOTAL_DES'] += $array_des['TOTAL_DES'];
            }

            $valores_columnas['INGRESOS'] =  $array_ing;
            $valores_columnas['DESCUENTOS'] =  $array_des;

            $data_colum['EMPLEADO'] = $valores_columnas['EMPLEADO'];
            $data_colum['INGRESOS'] = $valores_columnas['INGRESOS'];
            $data_colum['DESCUENTOS'] = $valores_columnas['DESCUENTOS'];
            $valoresColum[] = $data_colum;
            //$valoresColum[] = array_merge($valores_columnas['EMPLEADO'],$valores_columnas['INGRESOS'],$valores_columnas['DESCUENTOS']);

            //preguntar si es el último registro
            if ($fila_emp['are_id'] == $id_area_inicial && $n_registros == $correlativo) {
                $subtotal_area_in[$id_area_inicial]['NOMBRE'] = $nombre_area_inicial;

                //agregar al final el total a pagar del area
                $subtotal_area_des[$id_area_inicial]['TOTAL_PAGAR'] = ($subtotal_area_in[$id_area_inicial]['TOTAL_ING'] - $subtotal_area_des[$id_area_inicial]['TOTAL_DES']);

                $datos_sub['SUB_INGRESOS'] = $subtotal_area_in[$id_area_inicial];
                $datos_sub['SUB_DESCUENTOS'] = $subtotal_area_des[$id_area_inicial];
                $valoresColum[] = $datos_sub;
                // IGUAL PARA LA LINEA
                if ($es_alcaldia > 0) {
                    $subtotal_linea_ds[$are_id_cec_ini]['TOTAL_PAGAR'] = ($subtotal_linea_in[$are_id_cec_ini]['TOTAL_ING'] - $subtotal_linea_ds[$are_id_cec_ini]['TOTAL_DES']);
                    $cec_sub['SUB_INGRESOS'] = $subtotal_linea_in[$are_id_cec_ini];
                    $cec_sub['SUB_DESCUENTOS'] = $subtotal_linea_ds[$are_id_cec_ini];
                    $valoresColum[] = array(
                        'NOMBRE_CEC' => $are_id_cec_nom_inic,
                        'CEC_TOTALES' => $cec_sub
                    );
                }
            }
        }
        $data_return['NOMBRE_COLUMNA'] = $nombres_columnas;
        $data_return['VALOR_COLUMNA'] = $valoresColum;
        $data_return['TOTAL_INGRESO'] = $array_ing_TOTAL;
        $data_return['TOTAL_DESCUENTO'] = $array_des_TOTAL;
        // var_dump($data_return);die();
        return $data_return;
    }

    public function get_agrupado_personalizado($empid = 0, $plaids = 0, $tagid = 0){
        $query = "SELECT (SELECT IFNULL(SUM(ddi_valor), 0) FROM ddi_detalle_ingreso WHERE ddi_id_emp = $empid AND ddi_id_pla IN ($plaids) 
            AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag = $tagid AND deg_id_tig IS NOT NULL)) AS ingresos,
        (SELECT IFNULL(SUM(ddd_valor), 0) FROM ddd_detalle_descuento WHERE ddd_id_emp = $empid AND  ddd_id_pla IN ($plaids) 
            AND ddd_id_tdc IN (SELECT deg_id_tdc FROM deg_detalle_agrupador WHERE deg_id_tag = $tagid AND deg_id_tdc IS NOT NULL)) AS descuento;";
        $resultado = $this->db->query($query)->row_array();
        $valor_neto = $resultado['ingresos'] - $resultado['descuento'];
        return $valor_neto;
    }


    /**
     * Descripción:
     * Función para calcular renta complementaria (Reporte).
     * Se utiliza para el reporte de renta y el reporte de renta complementaria.
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-07-16
     * @param  ninguno
     * @return Consulta de renta según tabla asociada a la planilla.
     */
    public function get_isr_planilla($where = null, $group = null, $year = null)
    {

        if ($year != null) {
            $query = $this->db->select("emp_id, emp_codigo, CONCAT_WS(' ',emp_nombre,emp_apellido) AS empleado, ddd_id_pla, MONTH( pla_fecha_inicio) AS mes, ddd_id_tdc, tdc_nombre, ddd_dias_descuento, ddd_ingreso_afecto, ddd_valor, SUM(ddd_ingreso_afecto) as ingreso , SUM(ddd_valor) AS isr, SUM(((SELECT SUM(d2.ddi_valor) from ddi_detalle_ingreso d2 where d2.ddi_id_pla=pla_id and d2.ddi_id_emp=emp_id AND DATE_FORMAT(ddi_fecha_mod,'%Y') = $year)
             )) AS total", FALSE);
            $this->db->from('emp_empleado')
                ->join('txe_tipo_planillaxempleado', 'emp_id = txe_id_emp')
                ->join('tpl_tipo_planilla', 'txe_id_tpl = tpl_id')
                ->join('pla_planilla', 'pla_id_tpl = tpl_id')
                ->join('ddd_detalle_descuento', 'pla_id = ddd_id_pla AND ddd_id_emp = emp_id')
                ->join('tdc_tipo_descuento', 'ddd_id_tdc = tdc_id')
                ->where('pla_estado', 3);
        } else {
            // $query = $this->db->select("emp_id, emp_codigo, CONCAT_WS(' ',emp_nombre,emp_apellido) AS empleado, ddd_id_pla, MONTH( pla_fecha_inicio) AS mes, ddd_id_tdc, tdc_nombre, ddd_dias_descuento, ddd_ingreso_afecto, ddd_valor, SUM(ddd_ingreso_afecto) as ingreso , SUM(ddd_valor) AS isr ", FALSE);
            $query = $this->db->select("emp_id, emp_codigo, CONCAT_WS(' ',emp_nombre,emp_apellido) AS empleado, SUM(ddd_ingreso_afecto) as ingreso, SUM(ddd_valor) AS isr ", FALSE);
            $this->db->from('ddd_detalle_descuento')
                ->join('pla_planilla', 'ddd_id_pla = pla_id')
                ->join('emp_empleado', 'ddd_id_emp = emp_id')
                ->where('pla_estado', 3);
        }
        //SE COMENTO PARA CAMBIAR LA CONSULTA EN CASO QUE $year ES NULL
        // $this->db->from('emp_empleado')
        //  ->join('txe_tipo_planillaxempleado', 'emp_id = txe_id_emp') 
        //  ->join('tpl_tipo_planilla', 'txe_id_tpl = tpl_id') 
        //  ->join('pla_planilla', 'pla_id_tpl = tpl_id') 
        //  ->join('ddd_detalle_descuento', 'pla_id = ddd_id_pla AND ddd_id_emp = emp_id') 
        //  ->join('tdc_tipo_descuento', 'ddd_id_tdc = tdc_id') 
        //  ->where('pla_estado', 3)
        // ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($group != null) {
            $this->db->group_by($group);
        } else {
            if ($year != null) {
                $this->db->group_by('emp_id, MONTH( pla_fecha_inicio)');
                $this->db->order_by('emp_nombre, MONTH( pla_fecha_inicio)', 'ASC');
            } else {
                $this->db->group_by('emp_id');
                $this->db->order_by('emp_nombre', 'ASC');
            }
        }


        return $query->get()->result_array();
    }


    /**
     * @author Edith Herrera
     * @since  2018-07-17
     * @return Información de la planilla para generar el archivo txt
     */
    public function get_informacion_planilla_txt($where = null)
    {
        // PDTE CAMBIO DE UNIFICACION DE DOCS. SI SE USARA NIT O DUI.
        $id_tipo_doc_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $this->db->select("pla_id, emp_id_ban, pla_fecha_corte, tpl_frecuencia, REPLACE(dce_valor,'-','') nit, 
            DATE_FORMAT(pla_fecha_fin,'%m') mes_planilla, DATE_FORMAT(pla_fecha_pago,'%Y%m%d') fecha_pago, pla_codigo,
            CONCAT(trim(emp_apellido),' ',trim(emp_nombre)) nombre_empleado, REPLACE(emp_numero_cuenta, '-', '') AS cuenta,
            REPLACE(ROUND( SUM(((SELECT SUM(d2.ddi_valor) from ddi_detalle_ingreso d2 where d2.ddi_id_pla=pla_id and d2.ddi_id_emp=emp_id) - (SELECT SUM(d3.ddd_valor)
                from ddd_detalle_descuento d3 where d3.ddd_id_pla=pla_id and d3.ddd_id_emp=emp_id) )), 2), '.', '') total_pagar,
            ROUND(SUM(((SELECT SUM(d2.ddi_valor) from ddi_detalle_ingreso d2 where d2.ddi_id_pla=pla_id and d2.ddi_id_emp=emp_id) - (SELECT SUM(d3.ddd_valor) 
                from ddd_detalle_descuento d3 where d3.ddd_id_pla=pla_id and d3.ddd_id_emp=emp_id) )), 2) normal", false)
            ->from('emp_empleado')
            ->join('txe_tipo_planillaxempleado', 'txe_id_emp=emp_id')
            ->join('tpl_tipo_planilla', 'tpl_id=txe_id_tpl')
            ->join('pla_planilla', 'pla_id_tpl=tpl_id')
            ->join('dce_documento_emp', "dce_id_emp=emp_id and dce_id_tde=$id_tipo_doc_nit")
            ->group_by('emp_id')
            ->order_by('pla_id_tpl, pla_id, emp_id');

        if ($where) {
            $this->db->where($where);
        }

        $this->db->having("normal > 0", false);
        return $this->db->get()->result_array();
    }

    public function get_info_planilla_txt_cusca($where = null)
    {
        $this->db->select("pla_id, emp_id_ban, emp_doc_bancario, emp_metodo_pago, tpl_frecuencia, pla_codigo, REPLACE(emp_numero_cuenta, '-', '') AS cuenta, 
            (SELECT dce_valor FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = emp_doc_bancario) AS doc_emp, pla_fecha_fin AS mes_planilla,
            DATE_FORMAT(pla_fecha_pago, '%Y%m%d') fecha_pago, CONCAT(trim(emp_nombre), ' ', trim(emp_apellido)) nombre_empleado, pla_fecha_corte, tpl_frecuencia,
            ROUND(SUM(((SELECT SUM(d2.ddi_valor) FROM ddi_detalle_ingreso d2 WHERE d2.ddi_id_pla = pla_id AND d2.ddi_id_emp=emp_id) - (SELECT SUM(d3.ddd_valor) 
                FROM ddd_detalle_descuento d3 WHERE d3.ddd_id_pla=pla_id and d3.ddd_id_emp=emp_id) )), 2) AS monto", false)
            ->from('emp_empleado')
            ->join('txe_tipo_planillaxempleado', 'txe_id_emp = emp_id')
            ->join('tpl_tipo_planilla', 'tpl_id = txe_id_tpl')
            ->join('pla_planilla', 'pla_id_tpl = tpl_id')
            ->group_by('emp_id')
            ->order_by('pla_id_tpl, pla_id, emp_id');
        if ($where) {
            $this->db->where($where);
        }
        $this->db->having("monto > 0", false);
        return $this->db->get()->result_array();
    }


    /**
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-07-21
     * @return Último ingreso según el tipo solicitado.
     */
    public function get_ultimo_ingreso($where = null)
    {
        $this->db->select("pla_id, pla_fecha_inicio, pla_estado, ddi_id_emp, ddi_valor, ddi_id_tig, SUM(ddi_valor) as mensual", false)
            ->from('pla_planilla')
            ->join('ddi_detalle_ingreso', 'ddi_id_pla = pla_id')
            ->where('pla_estado', 3);
        if ($where) {
            $this->db->where($where);
        }
        $this->db->group_by('MONTH(pla_fecha_inicio)', false);
        return $this->db->get()->row();
    }

    /**
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-07-21
     * @return Descuentos por periodo de fechas.
     */
    function get_descuentos_empleado($inicio, $fin, $where = null)
    {
        $this->db->select('emp_codigo, CONCAT_WS(" ",emp_nombre,emp_apellido) AS nombre, SUM(ddd_ingreso_afecto) AS afecto, SUM(ddd_valor) AS descuento, (SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso INNER JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND DATE_FORMAT(pla_fecha_inicio,"%Y-%m-%d") >=  "' . $inicio . '" AND DATE_FORMAT(pla_fecha_fin,"%Y-%m-%d") <=  "' . $fin . '" ) AS ingreso, (SELECT tdc_nombre FROM tdc_tipo_descuento WHERE tdc_id = ddd_id_tdc) AS name_dsc', FALSE)
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'pla_id=ddd_id_pla')
            ->join('emp_empleado', 'emp_id=ddd_id_emp')
            ->join('tdc_tipo_descuento', 'tdc_id=ddd_id_tdc')
            ->order_by('emp_id');
        if ($where) {
            $this->db->where($where);
        }
        $this->db->group_by('emp_id, ddd_id_tdc');
        $query = $this->db->get()->result_array();
        return $query;
    }

    /**
     * @author Raul E. - Grupo Satélite
     * @since  2021-mar
     * @return Ingresos por empleado por planilla.
     */
    function get_ingresos_mensuales($where = null)
    {
        $this->db->select('emp_id, emp_codigo, emp_nombre, emp_apellido, tig_id, SUM(ddi_valor) AS ddi_valor, tig_nombre, pla_codigo, tpl_nombre', false)
            ->from('ddi_detalle_ingreso')
            ->join('pla_planilla', 'pla_id = ddi_id_pla')
            ->join('emp_empleado', 'emp_id = ddi_id_emp')
            ->join('tig_tipo_ingreso', 'tig_id = ddi_id_tig')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl')
            ->order_by('emp_id');
        if ($where) {
            $this->db->where($where);
        }
        $this->db->group_by('emp_id, tig_id, pla_id');
        return $this->db->get()->result_array();
    }

    /**
     * @author Raul E. - Grupo Satélite
     * @return Datos de empleados activos por planilla.
     */
    public function info_empleados_activos($where = null)
    {
        $this->db->select('emp_id, IFNULL(are_id, 0) AS are_id, emp_codigo, emp_nombre, emp_apellido, are_nombre, plz_nombre, GROUP_CONCAT(DISTINCT pla_id) AS planillas, emp_salario,
            emp_fecha_contrato, emp_fecha_antiguedad, IFNULL((SELECT tic_nombre FROM tic_tipo_contrato WHERE tic_id = emp_id_tic),"") AS tic_nombre, tpl_nombre, "" AS dias, "" AS ingresos,
            GROUP_CONCAT(DISTINCT tpl_nombre ORDER BY tpl_nombre ASC SEPARATOR ", ") AS all_tpls,
            IFNULL((SELECT pto_salario_promediado FROM pto_puesto WHERE pto_id = plz_id_pto),0) AS salario_promediado', false)
            ->from('emp_empleado')
            ->join('are_area', 'are_id = emp_id_are', 'LEFT')
            ->join('plz_plaza', 'plz_id = emp_id_plz', 'LEFT')
            ->join('txe_tipo_planillaxempleado', 'txe_id_emp = emp_id')
            ->join('pla_planilla', 'pla_id_tpl = txe_id_tpl')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl')
            ->where('pla_estado', 3)
            ->order_by('are_id, emp_nombre');
        if ($where) {
            $this->db->where($where);
        }
        $this->db->group_by('emp_id');
        return $this->db->get()->result_array();
    }

    public function get_ings_mes_emp($where = null, $where2 = null)
    {
        $this->db->select('IFNULL(SUM(ddi_valor), 0) AS ingreso', false)
            ->from('ddi_detalle_ingreso')
            ->join('pla_planilla', 'pla_id = ddi_id_pla')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl');
        if ($where) {
            $this->db->where($where);
        }
        // if ($where2){
        //     $this->db->where($where2);
        // }
        $respuesta = $this->db->get()->result_array();
        return $respuesta[0]['ingreso'];
    }

    public function get_nombre_ingresos($where = null)
    {
        $this->db->select('TIG.tig_nombre', false)
            ->from('ddi_detalle_ingreso DDI')
            ->join('tig_tipo_ingreso TIG', 'DDI.ddi_id_tig = TIG.tig_id', 'RIGHT')
            ->order_by('TIG.tig_nombre', 'asc');
        if ($where) {
            $this->db->where($where);
        }
        $this->db->group_by('TIG.tig_nombre');
        return $this->db->get()->result_array();
    }

    /**
     * @author Raul E. - Grupo Satélite
     * @since  2021-jul
     */
    function get_ingresos_mensuales_ddi($where = null)
    {
        $this->db->select('ddi_id_pla, ddi_id_emp, ddi_id_inn, ddi_valor, emp_codigo, emp_nombre, emp_apellido, (SELECT tig_nombre FROM tig_tipo_ingreso WHERE tig_id = ddi_id_tig) AS tipo_inn', false)
            ->from('ddi_detalle_ingreso')
            ->join('inn_ingreso', 'inn_id = ddi_id_inn')
            ->join('emp_empleado', 'emp_id = ddi_id_emp')
            ->order_by('ddi_id_pla, ddi_id_emp, ddi_id_inn ASC');
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author Raul E. - Grupo Satélite
     * @since  2021-mar
     * @return Descuentos no listados en reporte de planilla.
     */
    function get_otros_descuentos($where = null)
    {
        $id_agrup_rpte = $this->gsatelite->get_parametro('SYS_ID_AGRUPADOR_PLANILLA_REPORTE');
        $tabla_det_agr = $this->gsatelite->get_tabla('deg_detalle_agrupador', array('deg_id_tag' => $id_agrup_rpte, 'deg_id_tdc IS NOT NULL' => null));
        $agrupador = (count($tabla_det_agr) > 0) ? array_column($tabla_det_agr, 'deg_id_tdc') : array(0);
        $this->db->select('emp_codigo, emp_nombre, emp_apellido, tdc_codigo, tdc_nombre, IFNULL(dss_motivo,"") AS dss_motivo, SUM(ddd_valor) AS ddd_valor,
                    MIN(pla_fecha_inicio) AS desde, MAX(pla_fecha_fin) AS hasta', false)
            ->from('ddd_detalle_descuento')
            ->join('pla_planilla', 'ddd_id_pla = pla_id')
            ->join('emp_empleado', 'emp_id = ddd_id_emp')
            ->join('tdc_tipo_descuento', 'ddd_id_tdc = tdc_id')
            ->join('dss_descuento', 'dss_id = ddd_id_dss', 'left')
            ->where_not_in('tdc_id', $agrupador)
            ->order_by('emp_codigo');
        if ($where) {
            $this->db->where($where);
        }
        $this->db->group_by('emp_id, tdc_id');
        return $this->db->get()->result_array();
    }

    /**
     * @author René Castaneda
     * @since 07-08-2018
     * @Description: 
     * función para el cálculo del indemnización de un empleado
     * @param array object $empleado (información del empleado)
     * @param array object $planilla (información de la planilla)
     */
    public function calculo_indemnizacion_empleado($emp = null, $planilla = null, $porcentaje_indeminzacion = 100)
    {

        $emp->emp_fecha_ult_liquidacion = (trim($emp->emp_fecha_ult_liquidacion) != '') ? $emp->emp_fecha_ult_liquidacion : $emp->emp_fecha_contrato;

        $emp->emp_fecha_retiro = (trim($emp->emp_fecha_retiro) != '') ? $emp->emp_fecha_retiro : $emp->emp_fecha_fin_contrato;

        $emp->emp_fecha_retiro = (trim($emp->emp_fecha_retiro) != '') ? $emp->emp_fecha_retiro : $planilla->pla_fecha_fin;

        if (trim($emp->emp_fecha_ult_liquidacion) == '' || trim($emp->emp_fecha_retiro) == '') { //emp_fecha_ult_liquidacion
            return null;
        }

        $salario_minimo = $this->gsatelite->get_parametro('MONTO_SALARIO_MINIMO');

        $id_tig_indemnizacion = (trim($this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION')) > 0) ? $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION') : 0;

        $configuracion_indemnizacion = $this->gsatelite->get_parametro('SYS_CONFIGURACION_INDEMNIZACION'); //consultar las configuraciones
        $configuracion_indemnizacion = json_decode($configuracion_indemnizacion);
        //print_r($configuracion_indemnizacion); die();
        if (!is_object($configuracion_indemnizacion)) return null;
        $configuracion_indemnizacion = (array) $configuracion_indemnizacion;
        $n = $this->gsatelite->get_intervalo_dias($emp->emp_fecha_ult_liquidacion, $emp->emp_fecha_retiro);
        $n_dias = $n + 1;
        // print_r($emp->emp_fecha_ult_liquidacion); 
        // print_r($emp->emp_fecha_retiro);
        // die();
        $suma_salarios = $salario_minimo * $configuracion_indemnizacion['NUM_CANTIDAD_SALARIO_MINIMO'];

        $promediado_ = false;
        $salario_emp_indem = $emp->emp_salario;
        $salario_dia_indem_prom = 0;
        $base_dias_laboral = true;
        if ($emp->pto_salario_promediado) { //preguntar si es promediado
            $numero_meses = (trim($configuracion_indemnizacion['NUMERO_MESES_PARA_INDEMNIZACION']) > 0) ? $configuracion_indemnizacion['NUMERO_MESES_PARA_INDEMNIZACION'] : 6;
            $id_tag_indemnizacion = (trim($configuracion_indemnizacion['ID_AGRUPADOR_INDEMNIZACION']) > 0) ? $configuracion_indemnizacion['ID_AGRUPADOR_INDEMNIZACION'] : 0;

            //preguntar por los meses anteriores excluyendo el actual

            //llevar al día 15 para no tener problemas con los meses a 30 días
            $planilla_ini = formatear_fecha('Y-m-15', $planilla->pla_fecha_inicio);
            $fecha = date_create($planilla_ini);
            date_add($fecha, date_interval_create_from_date_string("-1 month"));
            $ffin_ = date_format($fecha, 'Y-m-15'); //llevar al día 15 para no tener problemas con los meses a 30 días

            $fecha = date_create($ffin_);
            date_add($fecha, date_interval_create_from_date_string("-$numero_meses month"));
            $fini = date_format($fecha, 'Y-m-01');
            $ffin = formatear_fecha('Y-m-t', $ffin_);


            //consultar por los ingresos y descuento segun el agrupador
            $q_ing = $this->db->select("IFNULL(SUM(ddi_valor),0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses,
                 GROUP_CONCAT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y%m')) AS det_meses
                 ", false)
                ->from("ddi_detalle_ingreso")
                ->join("pla_planilla", "pla_id = ddi_id_pla")
                ->where("ddi_id_emp", $emp->emp_id)
                ->where("pla_estado", 3) //solo autorizadas
                ->where("pla_fecha_inicio >=", $fini)
                ->where("pla_fecha_fin <=", $ffin)
                ->where("ddi_id_pla !=",  $planilla->pla_id) //excluir la que se esta ejecutando dado que aun no se han generado sus ingresos
                ->where("ddi_id_tig in ( SELECT deg_id_tig from deg_detalle_agrupador where deg_id_tag = $id_tag_indemnizacion AND deg_id_tig is not null )")
                ->get()->row_array();
            // if ($emp->emp_id == 170) {  print_r($this->db->last_query()); die();  } //para debuger
            $q_des = $this->db->select("IFNULL(SUM(ddd_valor),0) AS descuentos", false)
                ->from("ddd_detalle_descuento")
                ->join("pla_planilla", "pla_id = ddd_id_pla")
                ->where("ddd_id_emp", $emp->emp_id)
                ->where("pla_estado", 3) //solo autorizadas
                ->where("pla_fecha_inicio >=", $fini)
                ->where("pla_fecha_fin <=", $ffin)
                ->where("ddd_id_pla !=",  $planilla->pla_id) //excluir la que se esta ejecutando dado que aun no se han generado sus ingresos
                ->where("ddd_id_tdc in ( SELECT deg_id_tdc from deg_detalle_agrupador where deg_id_tag = $id_tag_indemnizacion AND deg_id_tdc is not null )")
                ->get()->row_array();

            //obtener el salario promediado.
            $salario_emp_indem_all = ($q_ing['ingresos'] > 0) ? ($q_ing['ingresos'] - $q_des['descuentos']) : $emp->emp_salario;
            $salario_emp_indem = ($q_ing['ingresos'] > 0) ? (($q_ing['ingresos'] - $q_des['descuentos']) / $q_ing['meses']) : $emp->emp_salario;

            if ($base_dias_laboral && $q_ing) {
                $dias_segun_mes = $this->gsatelite->get_tabla('djm_dias_trajado_mes', array('djm_estado' => 1));
                $array_dias_meses = ($dias_segun_mes) ? array_column($dias_segun_mes, 'djm_dias', 'djm_periodo') : array();
                $meses_ing = explode(',', $q_ing['det_meses']);
                if ($dias_segun_mes) {
                    $dias_segun_periodo = 0;
                    for ($q = 0; $q < count($meses_ing); $q++) {
                        $mes_p = intval($meses_ing[$q]);
                        if ($mes_p > 0) {
                            $dias_segun_periodo += (array_key_exists($mes_p, $array_dias_meses)) ? intval($array_dias_meses[$mes_p]) : $dias_mes;
                        }
                    }
                    $dias_considerados = ($dias_segun_periodo > 0) ? $dias_segun_periodo : $dias_considerados;
                    $salario_dia_indem_prom = $salario_emp_indem_all / $dias_considerados;
                }
            }
        }

        $ndias_trabaja = $this->gsatelite->get_intervalo_dias($emp->emp_fecha_ult_liquidacion, $emp->emp_fecha_retiro);
        $ndias_trabaja =  $ndias_trabaja + 1; //incluir el final


        $dias_anio_laboral = $configuracion_indemnizacion['DIAS_ANIO_LABORAL'];

        $salario_diario_empleado = ($salario_dia_indem_prom > 0) ?: ($salario_emp_indem / $dias_anio_laboral);
        // print_r($ndias_trabaja); die();
        // print_r($dias_anio_laboral); die();
        // if ($salario_emp_indem > $suma_salarios) {
        //     $total_indem = $ndias_trabaja * ($suma_salarios / $dias_anio_laboral);
        // } else {
        //     $total_indem = $ndias_trabaja * ($salario_emp_indem / $dias_anio_laboral);
        // }
        //El total de la indemnización no debe sobrepasar el tope de ley que viene en la variable $suma_salarios
        $total_indem = $ndias_trabaja * $salario_diario_empleado;
        $total_indem = ($total_indem > $suma_salarios) ? $suma_salarios : $total_indem;

        $exito = false;
        if ($total_indem > 0) {
            $comentario_det_idemn = ($porcentaje_indeminzacion != 100) ? "(" . round($porcentaje_indeminzacion, 2) . "%)" : null;

            $exito =  $this->add_ingreso_detalle(
                $planilla,
                $emp->emp_id,
                $id_tig_indemnizacion,
                ($total_indem * ($porcentaje_indeminzacion / 100)),
                null,
                $planilla->tpl_frecuencia,
                $comentario_det_idemn
            );
        }

        //    if ($exito) {
        //       //actualizar en el empleado la ultima fecha de aguinaldo
        //     $this->gsatelite->actualizar_array('emp_empleado',
        //         array('emp_fecha_ult_aguinaldo' => $planilla->pla_fecha_pago,
        //           'emp_usu_mod' => $this->tank_auth->get_user_id(),
        //           'emp_fecha_mod'=>date('Y-m-d H:i:s')), array('emp_id' =>$emp->emp_id));
        // }

    }

    /**
     * @author Elman Ortiz
     * @since 2018-08-18
     * @return Información de los salarios de la planilla (pago al empleado)
     */
    public function partida_contable_aporte_patronal($array_planillas = null, $where = null)
    {
        //Cuenta defecto
        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        //Tipos de descuento
        $tcd_insaforp = $this->gsatelite->get_parametro('SYS_CUENTA_TIPO_DESCUENTO_INSAFORP');
        $tdc_isss = $this->gsatelite->get_parametro('SYS_CUENTA_TIPO_DESCUENTO_ISSS');
        //Tipo de cuenta
        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('GASTO'));
        $id_planilla = $array_planillas['pla_id'];
        //$ids_planillas = implode(',', $array_planillas);
        $this->db->select('
                    ddd_id, 
                    ddd_id_pla, 
                    ddd_id_emp, 
                    SUM(IFNULL(ddd_valor, 0) *(dcl_porcentaje/100)) AS valor,
                    (
                        SELECT tdc_nombre
                        FROM tdc_tipo_descuento
                        JOIN dtd_detalle_tipo_descuento ON tdc_id = dtd_id_tdc 
                        WHERE dtd_id_tcn = ' . $tipo_cuenta . ' 
                        AND dtd_id_cec = dcl_id_cec
                        AND tdc_id = ddd_id_tdc
                        AND dtd_id_tdc = tdc_id
                        LIMIT 1
                    ) AS nombre_tipo_descuento, 
                    IFNULL((
                        SELECT dtd_id_cnt
                        FROM tdc_tipo_descuento
                        JOIN dtd_detalle_tipo_descuento ON tdc_id = dtd_id_tdc 
                        WHERE dtd_id_tcn = ' . $tipo_cuenta . ' 
                        AND dtd_id_cec = dcl_id_cec
                        AND tdc_id = ddd_id_tdc
                        AND dtd_id_tdc = tdc_id
                        LIMIT 1
                    ), 104) AS id_cuenta_contable
                ', false)
            ->from('ddd_detalle_descuento')
            ->join('emp_empleado', 'ddd_id_emp = emp_id')
            ->join('plz_plaza', 'emp_id_plz = plz_id')
            ->join('dcl_detalle_centro_costoxplaza', 'plz_id = dcl_id_plz')
            ->where('(ddd_id_tdc =' . $tcd_insaforp . ' OR ddd_id_tdc =' . $tdc_isss . ') AND ddd_id_pla =' . $id_planilla, null)
            ->group_by('id_cuenta_contable');
        if ($where) {
            $this->db->where($where);
        }
        //$this->db->limit(1);

        return $this->db->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 2018-08-18
     * @return Información de obligacion patronal
     */
    public function partida_contable_obligacion_patronal($array_planillas = null, $where = null)
    {
        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        //Tipos de descuento
        $tcd_insaforp = $this->gsatelite->get_parametro('SYS_CUENTA_TIPO_DESCUENTO_INSAFORP');
        $tdc_isss = $this->gsatelite->get_parametro('SYS_CUENTA_TIPO_DESCUENTO_ISSS');
        //Cuenta obligacion patronal
        $cuenta_obligacion = $this->gsatelite->get_parametro('SYS_CUENTA_OBLIGACION_PATRONAL');
        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('GASTO'));
        $id_planilla = $array_planillas['pla_id'];
        //$ids_planillas = implode(',', $array_planillas);
        $this->db->select('
                    ddd_id, 
                    ddd_id_pla, 
                    ddd_id_emp, 
                    SUM(IFNULL(ddd_valor, 0) *(dcl_porcentaje/100)) AS valor,' .
            $cuenta_obligacion . ' AS id_cuenta_contable
                ', false)
            ->from('ddd_detalle_descuento')
            ->join('emp_empleado', 'ddd_id_emp = emp_id')
            ->join('plz_plaza', 'emp_id_plz = plz_id')
            ->join('dcl_detalle_centro_costoxplaza', 'plz_id = dcl_id_plz')
            //->where('(ddd_id_tdc = $tcd_insaforp OR ddd_id_tdc = $tdc_isss) AND ddd_id_pla =  $id_planilla', null)
            ->where('(ddd_id_tdc =' . $tcd_insaforp . ' OR ddd_id_tdc =' . $tdc_isss . ') AND ddd_id_pla =' . $id_planilla, null)
            ->group_by('id_cuenta_contable');
        if ($where) {
            $this->db->where($where);
        }
        //$this->db->limit(1);

        return $this->db->get()->result_array();
    }

    public function get_ingresos_proyectos($pla_id = false)
    {
        $this->db->select('*,
                        CONCAT(psp_codigo," ",psp_nombre)as presupuesto,
                        CONCAT(acg_codigo," ",acg_nombre)as ageneral,
                        CONCAT(ace_codigo," ",ace_nombre)as rubro,
                        CONCAT(pcl_codigo," ",pcl_nombre)as proyecto,
                        pla_codigo as referencia,
                        (
                            select sum(ddi_valor)
                        ) as requerido
                   ', false)
            ->from('pla_planilla')
            ->join('ddi_detalle_ingreso', 'ddi_id_pla = pla_id', 'INNER')
            ->join('psp_presupuesto', 'psp_id = ddi_id_psp', 'INNER')
            ->join('acg_actividad_general', 'acg_id = ddi_id_acg', 'INNER')
            ->join('ace_actividad_especifica', 'ace_id = ddi_id_ace', 'INNER')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl', 'INNER')
            ->join('pcl_proyecto_cliente', 'pcl_id = psp_id_pcl', 'INNER')
            ->where(array('pla_id' => $pla_id))
            ->group_by('ddi_id_psp,ddi_id_acg,ddi_id_ace');
        return $this->db->get()->result_array();
    }

    public function get_disponible_pcp($where, $fecha)
    {
        $this->db->select('
            dps_id as detalle_p,
            pcp_monto as permitido,
            (
            IFNULL(
                    (
                        SELECT
                            SUM(dgp_monto)
                        FROM
                            dgp_detalle_gasto_prespuesto
                        WHERE
                            dgp_id_dps = dps_id
                        AND
                            dgp_id_dps = dps_id      
                        AND dgp_estado = 1
                        AND date_format(dgp_fecha,"%Y%m") = ' . $fecha . '
                    ),
                0
                )
            ) AS utilizado

        ', false)
            ->from("dps_detalle_presupuesto")
            ->join("pcp_plan_compra_presupuesto", "pcp_id_dps = dps_id", 'INNER')
            ->join("acg_actividad_general", " acg_id = dps_id_acg", 'INNER')
            ->join("ace_actividad_especifica", " ace_id = dps_id_ace", 'INNER');
        if ($where != '') {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author: Francisco Orozco
     * @since: 21-08-2019
     * @method Obtener detalles de ingresos paa un partida.
     * @param: where
     * @return: detalle de planillas 
     **/
    public function get_ingresos_partidas($where = null, $cuenta_defecto = 0, $tipo_cuenta = 0)
    {
        $query = $this->db->select("*,
                (
                    ( IFNULL(sum(ddi_valor),0) * IFNULL(dcl_porcentaje,100) )/ 100
                ) AS calculo,           
                IFNULL(
                    (
                        SELECT
                            dti_id_cnt
                        FROM
                            dti_detalle_tipo_ingreso
                        WHERE
                            dti_id_tcn = $tipo_cuenta
                        LIMIT 1
                    ),
                    $cuenta_defecto
                ) cuenta_contable", false)
            ->from('pla_planilla')
            ->join('ddi_detalle_ingreso', 'ddi_id_pla = pla_id', 'INNER')
            ->join('emp_empleado', 'emp_id = ddi_id_emp', 'INNER')
            ->join('plz_plaza', 'plz_id = emp_id_plz', 'INNER')
            ->join('dcl_detalle_centro_costoxplaza', 'dcl_id_plz = plz_id', 'LEFT')
            ->group_by('dcl_id_cec, cuenta_contable');

        if ($where != null) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    /**
     * @author: Francisco Orozco
     * @since: 21-08-2019
     * @method Obtener detalles de ingresos para un partida.
     * @param: where
     * @return: detalle de descuentos de partidas
     **/
    public function get_descuentos_partidas($where = null, $cuenta_defecto = 0, $tipo_cuenta)
    {
        $query = $this->db->select("*,
                (
                    (
                        IFNULL(sum(ddd_valor), 0) * IFNULL(dcl_porcentaje, 100)
                    ) / 100
                ) AS calculo,
                IFNULL(
                    (
                        SELECT
                            dtd_id_cnt
                        FROM
                            dtd_detalle_tipo_descuento
                        WHERE
                            dtd_id_tcn = $tipo_cuenta
                        LIMIT 1
                    ),
                    $cuenta_defecto
                ) cuenta_contable", false)
            ->from('pla_planilla')
            ->join('ddd_detalle_descuento', 'ddd_id_pla = pla_id', 'INNER')
            ->join('emp_empleado', 'emp_id = ddd_id_emp', 'LEFT')
            ->join('plz_plaza', 'plz_id = emp_id_plz', 'INNER')
            ->join('dcl_detalle_centro_costoxplaza', 'dcl_id_plz = plz_id', 'LEFT')
            ->group_by('dcl_id_cec, cuenta_contable');

        if ($where != null) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    /**
     * @author: Francisco Orozco
     * @since: 21-08-2019
     * @method Obtener detalles de ingresos para un partida.
     * @param: where
     * @return: detalle de descuentos de partidas de patronal
     **/
    public function get_descuentos_partidas_patronal($where = null, $cuenta_defecto = 0, $tipo_cuenta = 0)
    {
        $query = $this->db->select("*,
                (
                    (
                        IFNULL(sum(ddd_valor_patronal), 0) * IFNULL(dcl_porcentaje, 100)
                    ) / 100
                ) AS calculo,
                IFNULL(
                    (
                        SELECT
                            dtd_id_cnt
                        FROM
                            dtd_detalle_tipo_descuento
                        WHERE
                            dtd_id_tcn = $tipo_cuenta                      
                        LIMIT 1
                    ),
                    $cuenta_defecto
                ) cuenta_contable", false)
            ->from('pla_planilla')
            ->join('ddd_detalle_descuento', 'ddd_id_pla = pla_id', 'INNER')
            ->join('emp_empleado', 'emp_id = ddd_id_emp', 'LEFT')
            ->join('plz_plaza', 'plz_id = emp_id_plz', 'INNER')
            ->join('dcl_detalle_centro_costoxplaza', 'dcl_id_plz = plz_id', 'LEFT')
            ->group_by('dcl_id_cec, cuenta_contable');

        if ($where != null) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    /**
     * @author: Francisco Orozco
     * @since: 21-08-2019
     * @method Obtener detalles de ingresos para un partida.
     * @param: where
     * @return: detalle de afp
     **/
    public function get_descuentos_partidas_afp($where = null, $cuenta_defecto = 0,  $tipo_cuenta = 0)
    {
        $query = $this->db->select("*,
                SUM(
                    IFNULL(ddd_valor, 0) * (
                        IFNULL(dcl_porcentaje, 100) / 100
                    )
                ) AS calculo,
                SUM(
                    IFNULL(ddd_valor_patronal, 0) * (
                        IFNULL(dcl_porcentaje, 100) / 100
                    )
                ) AS patronal,
                IFNULL(
                    (
                        SELECT
                            dff_id_cnt
                        FROM
                            dff_detalle_finanza_afp
                        WHERE
                            dff_id_tcn = $tipo_cuenta
                        AND emp_id_afp = dff_id_afp
                        LIMIT 1
                    ),
                    $cuenta_defecto
                ) cuenta_contable", false)
            ->from('pla_planilla')
            ->join('ddd_detalle_descuento', 'ddd_id_pla = pla_id', 'INNER')
            ->join('emp_empleado', 'emp_id = ddd_id_emp', 'LEFT')
            ->join('plz_plaza', 'plz_id = emp_id_plz', 'INNER')
            ->join('dcl_detalle_centro_costoxplaza', 'dcl_id_plz = plz_id', 'LEFT')
            ->group_by('dcl_id_cec, cuenta_contable');

        if ($where != null) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    /**
     * @author: Francisco Orozco
     * @since: 21-08-2019
     * @method Obtener detalles de planilals
     * @param: where
     * @return: detalle de planillas
     **/
    public function get_planilla_partidas($where = null, $cec_id = 0)
    {
        $query = $this->db->select("*, (IFNULL(dcl_id_cec," . $cec_id . ")) as centro, sum(dcl_porcentaje) AS porcentajes", false)
            ->from('emp_empleado')
            ->join('txe_tipo_planillaxempleado', 'txe_id_emp = emp_id', 'INNER')
            ->join('plz_plaza', 'plz_id = emp_id_plz', 'INNER')
            ->join('dcl_detalle_centro_costoxplaza', 'dcl_id_plz = plz_id', 'LEFT')
            ->join('cnt_cuenta_contable', 'cnt_id = emp_id_cnt', 'LEFT')
            ->group_by('dcl_id_cec, emp_id_cnt');

        if ($where != null) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    /**
     * @author: Raul E.
     * @since: Ene-2020
     * @method Obtener detalles del recalculo
     * @param: fecha inicio, fecha fin && where
     * @return: detalle de recalculo
     **/
    public function get_renta_complementaria($inicio, $final, $where = null, $tpl = null)
    {
        $agrupador = $this->gsatelite->get_parametro('AGRUPADOR_ISR');
        $isr = $this->gsatelite->get_parametro('DESCUENTO_ISR');
        $tipo_pla = ($tpl != null) ? "AND pla_id_tpl = $tpl" : "";
        $ingresos = implode(',', array_filter(array_column($this->gsatelite->get_tabla('deg_detalle_agrupador', array('deg_id_tag' => $agrupador)), 'deg_id_tig')));
        $array_tdc = array_filter(array_column($this->gsatelite->get_tabla('deg_detalle_agrupador', array('deg_id_tag' => $agrupador)), 'deg_id_tdc'));
        $iss = $this->gsatelite->get_parametro('DESCUENTO_ISS');
        $afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
        $query = "emp_codigo, 
                CONCAT(emp_nombre,' ',emp_apellido) AS empleado, 
                (SELECT are_nombre FROM are_area WHERE are_id = emp_id_are) AS area, 
                (SELECT plz_nombre FROM plz_plaza WHERE plz_id = emp_id_plz) AS plaza, 
                (SELECT IFNULL(SUM(ddi_valor) , 0) FROM ddi_detalle_ingreso JOIN pla_planilla ON ddi_id_pla = pla_id 
                    WHERE pla_estado > 1 AND pla_fecha_inicio >= '$inicio' AND pla_fecha_fin <= '$final' 
                    AND ddi_id_tig IN ($ingresos) AND ddi_id_emp = emp_id $tipo_pla
                ) AS total_ingreso, ";
        if (in_array($iss, $array_tdc)) {
            $query .= "(SELECT IFNULL(SUM(ddd_valor),0) FROM ddd_detalle_descuento JOIN pla_planilla ON ddd_id_pla = pla_id WHERE pla_estado > 1 
                            AND pla_fecha_inicio >= '$inicio' AND pla_fecha_fin <= '$final' AND ddd_id_emp = emp_id AND ddd_id_tdc = $iss $tipo_pla
                        ) AS descuento_isss, ";
            $pos = array_search($iss, $array_tdc);
            unset($array_tdc[$pos]);
        } else {
            $query .= "0 AS descuento_isss, ";
        }
        if (in_array($afp, $array_tdc)) {
            $query .= "(SELECT IFNULL(SUM(ddd_valor),0) FROM ddd_detalle_descuento JOIN pla_planilla ON ddd_id_pla = pla_id WHERE pla_estado > 1 
                        AND pla_fecha_inicio >= '$inicio' AND pla_fecha_fin <= '$final' AND ddd_id_emp = emp_id AND ddd_id_tdc = $afp $tipo_pla
                        ) AS descuento_afp, ";
            $pos = array_search($afp, $array_tdc);
            unset($array_tdc[$pos]);
        } else {
            $query .= "0 AS descuento_afp, ";
        }
        if (count($array_tdc) > 0) {
            $descuentos = implode(',', $array_tdc);
            $query .= "(SELECT IFNULL(SUM(ddd_valor),0) FROM ddd_detalle_descuento JOIN pla_planilla ON ddd_id_pla = pla_id WHERE pla_estado > 1 
                        AND pla_fecha_inicio >= '$inicio' AND pla_fecha_fin <= '$final' AND ddd_id_emp = emp_id AND ddd_id_tdc IN ($descuentos) $tipo_pla
                        ) AS otros_descuentos, ";
        } else {
            $query .= "0 AS otros_descuentos, ";
        }
        $query .= "SUM(ddd_valor) AS renta, 
                    IFNULL( 
                        (SELECT IFNULL(ddd_valor, 0) FROM ddd_detalle_descuento JOIN pla_planilla ON ddd_id_pla = pla_id 
                            WHERE ddd_id_tdc = $isr AND ddd_id_emp = emp_id AND pla_fecha_fin = '$final' AND pla_estado > 1 
                            ORDER BY pla_fecha_corte DESC LIMIT 1
                        ), 
                    0) AS recalculo ";
        $consulta = $this->db->select($query, false)
            ->from('emp_empleado')
            ->join('ddd_detalle_descuento', 'ddd_id_emp = emp_id')
            ->join('pla_planilla', 'ddd_id_pla = pla_id')
            ->where('emp_estado', 1)
            ->where('ddd_id_tdc', $isr)
            ->where('pla_estado >', 1)
            ->group_by('emp_id')
            ->order_by('emp_apellido ASC');

        if ($where != null) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    /**
     * @author: Raul E.
     * @since: Ene-2020
     * @method Obtener detalles del recalculo
     * @param: fecha inicio, fecha fin && where
     * @return: detalle de recalculo
     **/
    public function get_tipos_planillas_isr()
    {
        $consulta = $this->db->select("*, count(txt_id_tis) as cantidad", false)
            ->from('tpl_tipo_planilla')
            ->join('txt_tipo_planillaxtipo_isr', 'txt_id_tpl = tpl_id')
            ->join('tis_tipo_isr', 'tis_id = txt_id_tis')
            ->where('tis_recalculo', 1)
            ->group_by('tpl_id')
            ->having('cantidad >', 1);
        return $this->db->get()->result_array();
    }

    public function get_detalle_empleado($whereinn = null, $wheredss = null){
        $respuesta = array();
        $ingresos = $this->db->select("emp_id, emp_codigo, emp_nombre, emp_apellido, tig_id, SUM(ddi_valor) AS ddi_valor, tig_nombre, pla_codigo, tpl_nombre, inn_referencia", false)
            ->from('ddi_detalle_ingreso')
            ->join('emp_empleado', 'emp_id = ddi_id_emp')
            ->join('tig_tipo_ingreso', 'tig_id = ddi_id_tig')
            ->join('pla_planilla', 'pla_id = ddi_id_pla')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl')
            ->join('inn_ingreso', 'inn_id = ddi_id_inn', 'left')
            ->group_by('emp_id, tig_id')
        ;
        if ($whereinn) {
            $this->db->where($whereinn);
        }
        $respuesta['ingreso'] = $this->db->get()->result_array();
        $descuentos = $this->db->select("emp_id, emp_codigo, emp_nombre, emp_apellido, tdc_id, SUM(ddd_valor) AS ddd_valor, tdc_nombre, pla_codigo, tpl_nombre,dss_referencia", false)
            ->from('ddd_detalle_descuento')
            ->join('emp_empleado', 'emp_id = ddd_id_emp')
            ->join('tdc_tipo_descuento', 'tdc_id = ddd_id_tdc')
            ->join('pla_planilla', 'pla_id = ddd_id_pla')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl')
            ->join('dss_descuento', 'dss_id = ddd_id_dss', 'left')
            ->group_by('emp_id, tdc_id')
        ;
        if ($wheredss) {
            $this->db->where($wheredss);
        }
        $respuesta['descuento'] = $this->db->get()->result_array();
        return $respuesta;
    }

    /**
     * @author: Raul E.
     * @since: Feb-2020
     * @method Obtener datos de los ingresos permanentes
     * @return: detalle de datos
     **/
    public function get_ingresos_permanentes($where = null, $where2 = null)
    {
        $query = "emp_id, emp_nombre, emp_apellido, emp_codigo, plz_nombre, tic_nombre, emp_salario, IFNULL((SELECT SUM(inn_valor) FROM inn_ingreso WHERE inn_estado = 1 AND inn_id_emp = emp_id";
        if ($where2 != null) {
            $query .= (array_key_exists('planilla', $where2)) ? " AND inn_id_tpl = " . $where2['planilla'] : "";
            $query .= (array_key_exists('ingresos', $where2)) ? " AND inn_id_tig IN (" . $where2['ingresos'] . ")" : "";
        }
        $query .= " AND inn_permanente = 1), 0) AS otros_ingresos";
        $consulta = $this->db->select($query, false)
            ->from('emp_empleado')
            ->join('plz_plaza', 'plz_id = emp_id_plz', 'LEFT')
            ->join('tic_tipo_contrato', 'tic_id = emp_id_tic', 'LEFT')
            ->order_by('emp_nombre', 'ASC');
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author: Marlon Olmedo.
     * @since: ABRIL-2020
     * @method obtiene el salario segun planilla generada del mes actual
     * @param: where
     * @return: detalle de ingresos de la planilla
     **/
    public function get_sallario_detallepla($where = null, $id_emp)
    {
        $consulta = $this->db->select("*", false)
            ->from('ddi_detalle_ingreso')
            ->join('pla_planilla', "ddi_id_pla = pla_id and ddi_id_emp = $id_emp", "left");

        if ($where != null) {
            $this->db->where($where, null, false);
        }

        return $this->db->get()->result_array();
    }

    /* SALARIO DEESDE LOS INGRESOS NO DEFINIDOS EN FICHA (CASO FE & ALEGRIA) */
    public function get_salary_from_incomes($emp_id)
    {
        $salario = 0;
        $pla_defecto = $this->gsatelite->get_parametro('ID_TIPO_PLANILLA_DEFECTO');
        $tipo_planillas = ($pla_defecto != "") ? explode(',', $pla_defecto) : array(0);
        // ULTIMA PLANILLA GENERADA   FALTA DEFINIR SI SOLO TIPO "SALARIO"
        $last_plan = $this->db->select('pla_id, tpl_id')
            ->from('pla_planilla')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl')
            ->join('txe_tipo_planillaxempleado', 'txe_id_tpl = tpl_id')
            ->where("txe_id_emp", $emp_id)
            ->where("pla_estado", 3)
            ->where_in("tpl_id", $tipo_planillas)
            ->order_by('pla_fecha_fin', 'DESC')
            ->limit(1)
            ->get()->result_array();
        if (count($last_plan) > 0) {
            $planilla = $this->db->get_where('pla_planilla', array('pla_id' => $last_plan[0]['pla_id']), 1)->row();
            $f_ini_pla = formatear_fecha('Y-m-d', $planilla->pla_fecha_inicio);
            $f_fin_pla = formatear_fecha('Y-m-d', $planilla->pla_fecha_fin);
            $valor = $this->calcular_agrupado($planilla, $emp_id, $this->agrupador_salario);
            $ingresos_base = $this->db->get_where('itp_ingresoxtipo_planilla', array('itp_id_tpl' => $last_plan[0]['tpl_id']))->result_array();
            // INGRESOS BASE
            foreach ($ingresos_base as $key => $value) {
                $porc = ($value['itp_porcentaje'] > 0) ? $value['itp_porcentaje'] : 100;
                $salario += ($valor * ($porc / 100));
            }

            // OTROS INGRESOS EXTRAS (NO SALARIO)
            $where_extras = array(
                "inn_id_tig <> " => $this->tig_salario,
                "inn_id_tpl" => $planilla->pla_id_tpl,
                "inn_estado" => 1,
                "inn_id_emp" => $emp_id,
                "inn_permanente" => 0,
                "IFNULL(hxe_estado, 1) = " => 1,
                "inn_cuota_pagada < inn_cuota" => null,
                "((inn_fecha_desde <= '$f_ini_pla' AND inn_cuota > 1) OR (inn_fecha_desde >= '$f_ini_pla' AND inn_fecha_desde <= '$f_fin_pla' AND inn_cuota >= 1))" => null
            );
            $others_incomes = $this->db->select('inn_valor', false)
                ->from('inn_ingreso')
                ->join('tig_tipo_ingreso', 'inn_id_tig = tig_id')
                ->join('hxe_hora_extraxempleado', 'hxe_id = inn_id_hxe', 'left')
                ->where($where_extras)
                ->get()->result_array();
            foreach ($others_incomes as $key => $value) {
                $salario += $value['inn_valor'];
            }
            $where_perm = array(
                "inn_id_tig <> " => $this->tig_salario,
                "inn_id_tpl" => $planilla->pla_id_tpl,
                "IFNULL(hxe_estado, 1) = " => 1,
                "inn_estado" => 1,
                "inn_permanente" => 1,
                "inn_id_emp" => $emp_id,
                "inn_cuota_pagada = inn_cuota" => null,
                "(inn_fecha_desde <= '$f_ini_pla' OR (inn_fecha_desde BETWEEN '$f_ini_pla' AND '$f_ini_pla') )" => null
            );
            $permanentes = $this->db->select('inn_valor')
                ->from('inn_ingreso')
                ->join('tig_tipo_ingreso', 'inn_id_tig = tig_id', 'left')
                ->join('hxe_hora_extraxempleado', 'hxe_id = inn_id_hxe', 'left')
                ->where($where_perm)
                ->get()->result_array();
            foreach ($permanentes as $key => $value) {
                $salario += $value['inn_valor'];
            }
        }
        //INGRESOS POR PROYECTOS
        $where_pry = array(
            'inn_id_tig' => $this->tig_salario,
            'inn_id_emp' => $emp_id,
            'inn_id_acg IS NOT NULL' => null,
            'inn_id_psp IS NOT NULL' => null,
            'inn_id_ace IS NOT NULL' => null
        );
        $ingresos_proy = $this->gsatelite->get_tabla('inn_ingreso', $where_pry);
        foreach ($ingresos_proy as $key => $value) {
            $salario += $value['inn_valor'];
        }
        return $salario;
    }

    /**
     * @author: Marlon Olmedo.
     * @since: ABRIL-2020
     * @method obtiene la ultima fecha de la planilla autorizada
     * @param: where
     * @return: fecha planilla
     **/
    public function get_fecha_detallepla($where = null)
    {
        $consulta = $this->db->select("MAX(pla_fecha_fin) fecha_fin", false)
            ->from('ddi_detalle_ingreso')
            ->join('pla_planilla', 'ddi_id_pla = pla_id', "left");

        if ($where != null) {
            $this->db->where($where, null, false);
        }

        return $this->db->get()->result_array();
    }

    public function actualizar_fechas_empleado($emp_id, $pla_id, $tpl_id)
    {
        $updates = array();
        $ing_vacacion      = $this->gsatelite->get_parametro('ID_TIG_VACACION', 0);
        $prm_vacacion      = $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION', 0);
        $ing_aguinaldo     = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO', 0);
        $ing_indemnizacion = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION', 0);
        $datos_pla_liqui = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION'), true);
        $datos_pla_indem = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_INDEMNIZACION_VOLUNTARIA'), true);
        $inns = $this->db->select()->join('inn_ingreso', 'inn_id = ddi_id_inn')->get_where('ddi_detalle_ingreso', array('ddi_id_emp' => $emp_id, 'ddi_id_pla' => $pla_id))->result_array();
        if (count($inns) > 0) {
            if ($tpl_id == $datos_pla_liqui['ID_TIPO_PLANILLA_LIQ']) {
                $indm = $this->db->select()->join('rte_retiro_empleado', 'rte_id = lqe_id_rte')
                    ->get_where('lqe_liquidacion_empleado', array('rte_autorizar_ret' => 1, 'rte_id_emp' => $emp_id, 'lqe_id_pla' => $pla_id))->result_array();
                $fecha = $indm[0]['rte_fecha_retiro'];
            }
            if ($tpl_id == $datos_pla_indem['ID_TIPO_PLANILLA_INDEMNIZACION']) {
                $indm = $this->db->select()->join('inv_indemnizacion_voluntaria', 'inv_id = lqe_id_inv')
                    ->get_where('lqe_liquidacion_empleado', array('inv_estado' => 1, 'inv_id_emp' => $emp_id, 'lqe_id_pla' => $pla_id))->result_array();
                $fecha = $indm[0]['inv_fecha_calculo'];
                $inv_completed = array('inv_estado' => 2, 'inv_usu_modificacion' => $this->tank_auth->get_user_id(), 'inv_fecha_modificacion' => date('Y-m-d'));
                $this->gsatelite->actualizar_array('inv_indemnizacion_voluntaria', $inv_completed, array('inv_id' => $indm[0]['inv_id']));
            }
            foreach ($inns as $k => $inn) {
                switch ($inn['ddi_id_tig']) {
                    case $ing_aguinaldo:
                        $updates['emp_fecha_ult_aguinaldo'] = formatear_fecha('Y-m-d', $fecha);
                        break;
                    case $ing_indemnizacion:
                        $updates['emp_fecha_ult_liquidacion'] = formatear_fecha('Y-m-d', $fecha);
                        break;
                    case $ing_vacacion:
                    case $prm_vacacion:
                        $updates['emp_fecha_ult_vacacion'] = formatear_fecha('Y-m-d', $fecha);
                        break;
                }
            }
            if (count($updates) > 0) {
                $updates['emp_fecha_mod'] = date('Y-m-d');
                $updates['emp_usu_mod'] = $this->tank_auth->get_user_id();
                $this->gsatelite->actualizar_array('emp_empleado', $updates, array('emp_id' => $emp_id));
            }
        }
    }

    /**
     * @since: JUN-2022
     * @method obtiene las planilla de un empleado y el detalle de renta
     * @param: empleado y año a evaluar
     **/
    public function get_detalle_planillas_renta($emp, $year)
    {
        $respueta = array();
        // DATOS DEL EMPLEADO
        $d = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI', 0);
        $n = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT', 0);
        $datos_empleado = $this->db->select("tpl_nombre, emp_codigo, emp_nombre, emp_apellido, 
            (SELECT dce_valor FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_estado > 0 AND dce_id_tde = $n LIMIT 1) AS emp_nit,
            (SELECT dce_valor FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_estado > 0 AND dce_id_tde = $d LIMIT 1) AS emp_dui,
            IFNULL((SELECT itp_id_tpl FROM itp_ingresoxtipo_planilla WHERE itp_id_tpl = txe_id_tpl AND itp_id_tig = 14 LIMIT 1), 0) AS planilla_nomima", false)
            ->from('txe_tipo_planillaxempleado')
            ->join('tpl_tipo_planilla', 'tpl_id = txe_id_tpl')
            ->join('emp_empleado', 'emp_id = txe_id_emp')
            ->where('emp_id', $emp)
            ->order_by('planilla_nomima', 'DESC')
            ->get()->result_array();
        $respueta['empleado'] = $datos_empleado;
        $otros_desc = $this->db->select('deg_id_tdc')->from('deg_detalle_agrupador')->where('deg_id_tag', $this->agrupador_isr)
            ->where('deg_id_tdc IS NOT NULL')->where_not_in('deg_id_tdc', array($this->tdc_isss, $this->tdc_afp))->get()->result_array();
        $otros_descuentos = (count($otros_desc) > 0) ? implode(',', array_column($otros_desc, 'deg_id_tdc')) : '0';
        // DATOS POR MES
        for ($i = 1; $i < 13; $i++) {
            $m = ($i < 10) ? '0' . $i : $i;
            $mes = $year . $m;
            // INGRESOS
            $query_ingr = "SELECT pla_codigo, IF(pla_id_tpl = 1, 1, 0) AS pla_sal, SUM(ddi_valor) AS monto FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla 
                        WHERE ddi_id_emp = $emp AND DATE_FORMAT(pla_fecha_fin,'%Y%m') = '$mes' AND pla_estado = 3 AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador 
                        WHERE deg_id_tig IS NOT NULL AND deg_id_tag = $this->agrupador_isr) GROUP BY pla_sal, pla_id ORDER BY pla_sal DESC, pla_codigo ASC";
            // ISSS
            $query_isss = "SELECT pla_codigo, IF(pla_id_tpl = 1, 1, 0) AS pla_sal, SUM(ddd_valor) AS monto FROM ddd_detalle_descuento JOIN pla_planilla ON pla_id = ddd_id_pla
                        WHERE ddd_id_emp = $emp AND DATE_FORMAT(pla_fecha_fin,'%Y%m') = '$mes' AND pla_estado = 3 AND ddd_id_tdc = $this->tdc_isss 
                        GROUP BY pla_sal, pla_id ORDER BY pla_sal DESC, pla_codigo ASC";
            // AFP
            $query_afps = "SELECT pla_codigo, IF(pla_id_tpl = 1, 1, 0) AS pla_sal, SUM(ddd_valor) AS monto FROM ddd_detalle_descuento JOIN pla_planilla ON pla_id = ddd_id_pla
                        WHERE ddd_id_emp = $emp AND DATE_FORMAT(pla_fecha_fin,'%Y%m') = '$mes' AND pla_estado = 3 AND ddd_id_tdc = $this->tdc_afp
                        GROUP BY pla_sal, pla_id ORDER BY pla_sal DESC, pla_codigo ASC";
            // OTROS DESCUENTOS
            $query_otro = "SELECT pla_codigo, IF(pla_id_tpl = 1, 1, 0) AS pla_sal, SUM(ddd_valor) AS monto FROM ddd_detalle_descuento JOIN pla_planilla ON pla_id = ddd_id_pla
                        WHERE ddd_id_emp = $emp AND DATE_FORMAT(pla_fecha_fin,'%Y%m') = '$mes' AND pla_estado = 3 AND ddd_id_tdc IN ($otros_descuentos)
                        GROUP BY pla_sal, pla_id ORDER BY pla_sal DESC, pla_codigo ASC";
            // RENTA YA COBRADA
            $query_islr = "SELECT pla_codigo, IF(pla_id_tpl = 1, 1, 0) AS pla_sal, SUM(ddd_valor) AS monto FROM ddd_detalle_descuento JOIN pla_planilla ON pla_id = ddd_id_pla
                        WHERE ddd_id_emp = $emp AND DATE_FORMAT(pla_fecha_fin,'%Y%m') = '$mes' AND pla_estado = 3 AND ddd_id_tdc = $this->tdc_isr
                        GROUP BY pla_sal, pla_id ORDER BY pla_sal DESC, pla_codigo ASC";
            $respueta['ingresos'][$i] = $this->db->query($query_ingr)->result_array();
            $respueta['descisss'][$i] = $this->db->query($query_isss)->result_array();
            $respueta['descafps'][$i] = $this->db->query($query_afps)->result_array();
            $respueta['otrosdes'][$i] = $this->db->query($query_otro)->result_array();
            $respueta['rentaemp'][$i] = $this->db->query($query_islr)->result_array();
        }
        return $respueta;
    }

    public function planilla_bnk_hipotec($planillas = null)
    {
        $consulta = $this->db->select("emp_codigo, emp_numero_cuenta, emp_apellido, emp_nombre, MAX(pla_fecha_pago) AS pla_fecha_pago,
            (SUM(ddi_valor) - IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento WHERE ddd_id_emp = emp_id AND ddd_id_pla = pla_id), 0))AS monto", false)
            ->from('ddi_detalle_ingreso')
            ->join('emp_empleado', 'emp_id = ddi_id_emp')
            ->join('pla_planilla', 'pla_id = ddi_id_pla')
            ->where('emp_metodo_pago', 1)
            ->group_by('emp_id')
            ->order_by('emp_codigo');
        if ($planillas) {
            $this->db->where_in('ddi_id_pla', $planillas);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author: Max Molina
     * @since: Oct-2021
     * @method Obtener datos del area mediante la sucursal
     * @return: detalle de datos
     **/
    public function get_areaXsucursal($where = null)
    {
        $query = $this->db->select('ARE.are_id')
            ->from('suc_sucursal AS SUC')
            ->join('emp_empleado AS EMP', 'SUC.suc_id = EMP.emp_id_suc', 'LEFT')
            ->join('are_area AS ARE', 'EMP.emp_id_are = ARE.are_id', 'LEFT')
            ->join('mxr_empresaxarea AS MXR', 'ARE.are_id = MXR.mxr_id_are', 'LEFT')
            ->where($where);
        return $query->get()->result_array();
    }

    public function promedio_comision_constancias($emp)
    {
        $promedio = 0;
        $configuracion_vacacion = json_decode($this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_VACACION'));
        if (is_object($configuracion_vacacion)) {
            $configuracion = (array) $configuracion_vacacion;
            $numero_meses = (trim($configuracion['NUMERO_MESES_PARA_VACACION']) > 0) ? $configuracion['NUMERO_MESES_PARA_VACACION'] : 6;
            $mes = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30);
            $fecha_desde = date_create(date('Y-m-01'));
            $fecha_hasta = date_create(date('Y-m-01'));
            $fecha_desde->modify("first day of -$numero_meses month");
            $fecha_hasta->modify("last day of last month");
            $f1 = date_format($fecha_desde, 'Y-m-d');
            $f2 = date_format($fecha_hasta, 'Y-m-d');
            $where_dias = array('djm_estado' => 1, 'djm_periodo >= ' => formatear_fecha('Ym', $f1), 'djm_periodo <= ' => formatear_fecha('Ym', $f2));
            $dias_segun_mes = $this->gsatelite->get_tabla('djm_dias_trajado_mes', $where_dias);
            $array_dias_meses = (count($dias_segun_mes) > 0) ? array_column($dias_segun_mes, 'djm_dias', 'djm_periodo') : array();
            $dias_promediar = 0;
            foreach ($array_dias_meses as $k => $v) {
                $dias_promediar += (trim($v) != "") ? intval($v) : 0;
            }
            $q_ing = $this->db->select("IFNULL(SUM(ddi_valor), 0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses", false)
                ->from("ddi_detalle_ingreso")
                ->join("pla_planilla", "pla_id = ddi_id_pla")
                ->where("pla_estado", 3)
                ->where('pla_id_tpl', $this->tpl_comision)
                ->where("ddi_id_emp", $emp)
                ->where("pla_fecha_inicio >=", $f1)
                ->where("pla_fecha_fin <=", $f2)
                ->where("ddi_id_tig", $this->tig_comision)
                ->get()->row_array();
            $promedio = ($q_ing['ingresos'] > 0) ? ($q_ing['ingresos'] * ($mes / $dias_promediar)) : 0;
        }
        return number_format($promedio, 2, '.', '');
    }

    public function get_prom_comisiones_rpt($fecha = null, $emp = null)
    {
        $configuracion_vacacion = json_decode($this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_VACACION'));
        if (is_object($configuracion_vacacion)) {
            $configuracion = (array) $configuracion_vacacion;
            $numero_meses = (trim($configuracion['NUMERO_MESES_PARA_VACACION']) > 0) ? $configuracion['NUMERO_MESES_PARA_VACACION'] : 6;
            $mes = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30);
            $fecha = ($fecha) ? formatear_fecha('Y-m-d', $fecha) : date('Y-m-01');
            $fecha_desde = date_create($fecha);
            $fecha_hasta = date_create($fecha);
            $fecha_desde->modify("first day of -$numero_meses month");
            $fecha_hasta->modify("last day of last month");
            $f1 = date_format($fecha_desde, 'Y-m-d');
            $f2 = date_format($fecha_hasta, 'Y-m-d');
            $p1 = formatear_fecha('Ym', $f1);
            $p2 = formatear_fecha('Ym', $f2);
            $where_dias = array('djm_estado' => 1, 'djm_periodo >= ' => $p1, 'djm_periodo <= ' => $p2);
            $dias_segun_mes = $this->gsatelite->get_tabla('djm_dias_trajado_mes', $where_dias);
            $veces = (count($dias_segun_mes) > 0) ? count($dias_segun_mes) : $numero_meses;
            $query = "SELECT emp_id, emp_codigo, emp_nombre, emp_apellido, $veces AS rows, ";
            foreach ($dias_segun_mes as $ky => $value) {
                $k = $ky + 1;
                $p = $value['djm_periodo'];
                $d = ($value['djm_dias'] > 0) ? $value['djm_dias'] : $mes;
                $query .= "IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE pla_estado =  3 
                    AND DATE_FORMAT(pla_fecha_inicio, '%Y%m') = '$p' AND ddi_id_emp = emp_id AND ddi_id_tig = $this->tig_comision), 0) AS m$k, 
                    $d AS dm$k, $p AS pm$k, ";
            }
            $query .= "IFNULL((SELECT SUM(djm_dias) FROM djm_dias_trajado_mes WHERE djm_estado = 1 AND djm_periodo >= $p1 AND djm_periodo <= $p2), ($mes * $numero_meses)) AS total_dias,
                IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE pla_estado =  3 AND DATE_FORMAT(pla_fecha_inicio , '%Y%m') >= '$p1'
                AND DATE_FORMAT(pla_fecha_inicio , '%Y%m') <= '$p2' AND ddi_id_emp = emp_id AND ddi_id_tig = $this->tig_comision), 0) AS total_ingreso
                FROM emp_empleado WHERE emp_estado = 1 ";
            if ($emp > 0) {
                $query .= "AND emp_id = $emp";
            }
            $resultado = $this->db->query($query)->result_array();
            return $resultado;
        } else {
            return "error";
        }
    }

    public function datos_constancia_agrupador($emp = 0)
    {
        $respuesta = $for_rentas = array();
        $agrupador_id = $this->gsatelite->get_parametro('ID_AGRUPADOR_CONSTANCIAS', 0);
        if ($agrupador_id > 0) {
            $agrupador = $this->gsatelite->get_tabla('deg_detalle_agrupador', array('deg_id_tag' => $agrupador_id));
            // INGRESOS
            $this->db->order_by('tig_orden');
            $this->db->where_in('tig_id', array_filter(array_column($agrupador, 'deg_id_tig')));
            $ingresos = $this->gsatelite->get_tabla('tig_tipo_ingreso', array('tig_estado' => 1));
            if (count($ingresos) > 0) {
                foreach ($ingresos as $k => $valing) {
                    switch ($valing['tig_id']) {
                        case $this->tig_salario:
                            $respuesta['inn'][trim($valing['tig_nombre'])] = $this->gsatelite->get_campo('emp_empleado', 'emp_salario', array('emp_id' => $emp));
                            break;
                        case $this->tig_comision:
                            $respuesta['inn'][trim($valing['tig_nombre'])] = $this->promedio_comision_constancias($emp);
                            break;
                        default:
                            $where = array(
                                'inn_id_emp' => $emp,
                                'inn_estado' => 1,
                                'inn_id_tig' => $valing['tig_id'],
                                '(inn_permanente = 1 OR (inn_permanente = 0 AND inn_cuota_pagada < inn_cuota))' => null
                            );
                            $respuesta['inn'][trim($valing['tig_nombre'])] = $this->gsatelite->get_suma('inn_ingreso', 'inn_valor', $where);
                            break;
                    }
                    $for_rentas['i'][$valing['tig_id']] = $respuesta['inn'][trim($valing['tig_nombre'])];
                }
            }
            // DESCUENTOS
            $this->db->order_by('tdc_orden');
            $this->db->where_in('tdc_id', array_filter(array_column($agrupador, 'deg_id_tdc')));
            $descuentos = $this->gsatelite->get_tabla('tdc_tipo_descuento', array('tdc_estado' => 1));
            if (count($descuentos) > 0) {
                $valor_banco = 0;
                $aplica_isr = $aplica_renta10 = false;
                $nombre_isr = $nombre_renta10 = "";
                $agr_afp = $this->db->select()->from('deg_detalle_agrupador')->where('deg_id_tag', $this->agrupador_afp)->where('deg_id_tig IS NOT NULL', null)->get()->result_array();
                $agr_isss = $this->db->select()->from('deg_detalle_agrupador')->where('deg_id_tag', $this->agrupador_isss)->where('deg_id_tig IS NOT NULL', null)->get()->result_array();
                foreach ($descuentos as $k => $valdes) {
                    switch ($valdes['tdc_id']) {
                        case $this->tdc_isss:
                            $afecto = 0;
                            $agr_isss_ids = array_column($agr_isss, 'deg_id_tig');
                            foreach ($for_rentas['i'] as $ke => $va) {
                                if (in_array($ke, $agr_isss_ids) && $va > 0) {
                                    $afecto += $va;
                                }
                            }
                            if ($afecto > $valdes['tdc_maximo']) {
                                $respuesta['des'][trim($valdes['tdc_nombre'])] = ($valdes['tdc_maximo'] * $valdes['tdc_porcentaje']) / 100;
                            } else {
                                $respuesta['des'][trim($valdes['tdc_nombre'])] = ($afecto * $valdes['tdc_porcentaje']) / 100;
                            }
                            break;
                        case $this->tdc_afp:
                            $afecto = 0;
                            $agr_afp_ids = array_column($agr_afp, 'deg_id_tig');
                            foreach ($for_rentas['i'] as $ke => $va) {
                                if (in_array($ke, $agr_afp_ids) && $va > 0) {
                                    $afecto += $va;
                                }
                            }
                            if ($afecto > $valdes['tdc_maximo'] && $valdes['tdc_maximo'] > 0) {
                                $respuesta['des'][trim($valdes['tdc_nombre'])] = ($valdes['tdc_maximo'] * $valdes['tdc_porcentaje']) / 100;
                            } else {
                                $respuesta['des'][trim($valdes['tdc_nombre'])] = ($afecto * $valdes['tdc_porcentaje']) / 100;
                            }
                            break;
                        case $this->tdc_isr:
                            $aplica_isr = true;
                            $nombre_isr = trim($valdes['tdc_nombre']);
                            $respuesta['des'][trim($valdes['tdc_nombre'])] = 0;
                            break;
                        case $this->tdc_isr_10p:
                            $aplica_renta10 = true;
                            $nombre_renta10 = trim($valdes['tdc_nombre']);
                            $respuesta['des'][trim($valdes['tdc_nombre'])] = 0;
                            break;
                        default:
                            $des_banco = $this->gsatelite->get_parametro('ID_TIPO_DESCUENTO_PRESTAMO_BANCO');
                            $where = array(
                                'dss_id_emp' => $emp,
                                'dss_estado' => 1,
                                'dss_id_tdc' => $valdes['tdc_id'],
                                '(dss_permanente = 1 OR (dss_permanente = 0 AND dss_cuota_pagada < dss_cuota))' => null
                            );
                            if ($valdes['tdc_id'] == $des_banco) {
                                $bancos = $this->db->select('SUM(dss_valor) AS dss_valor, IFNULL(ban_nombre, dss_motivo) AS ban_nombre', false)
                                    ->from('dss_descuento')
                                    ->join('ban_banco', 'ban_id = dss_id_ban', 'LEFT')
                                    ->where($where)
                                    ->group_by('dss_id_ban')
                                    ->get()->result_array();
                                foreach ($bancos as $kb => $vb) {
                                    $valor_banco += $vb['dss_valor'];
                                    $respuesta['des'][trim($vb['ban_nombre'])]  = $vb['dss_valor'];
                                }
                            } else {
                                $respuesta['des'][trim($valdes['tdc_nombre'])] = $this->gsatelite->get_suma('dss_descuento', 'dss_valor', $where);
                            }
                            break;
                    }
                    $for_rentas['d'][$valdes['tdc_id']] = ($valdes['tdc_id'] == $des_banco) ? $valor_banco : $respuesta['des'][trim($valdes['tdc_nombre'])];
                }
                // AGREGA AL FINAL ISR O RENTA POR LOS AGRUPADORES DE CADA UNO
                if ($aplica_isr) {
                    $monto_afecto = $impuesto = 0;
                    $agr_isr = $this->db->select()->from('deg_detalle_agrupador')->where('deg_id_tag', $this->agrupador_isr)->get()->result_array();
                    $isr_ingreso = array_filter(array_column($agr_isr, 'deg_id_tig'));
                    $isr_descuentos = array_filter(array_column($agr_isr, 'deg_id_tdc'));
                    $tabla_isr = $this->gsatelite->get_tabla('isr_isr', array('isr_id_tis' => 1));
                    foreach ($for_rentas['i'] as $ki => $vi) {
                        if (in_array($ki, $isr_ingreso) && $vi > 0) {
                            $monto_afecto += $vi;
                        }
                    }
                    foreach ($for_rentas['d'] as $kd => $vd) {
                        if (in_array($kd, $isr_descuentos) && $vd > 0) {
                            $monto_afecto -= $vd;
                        }
                    }
                    foreach ($tabla_isr as $keyr => $valur) {
                        if ($monto_afecto >= $valur['isr_desde'] && $monto_afecto <= $valur['isr_hasta']) {
                            $impuesto = $valur['isr_cuota'] + (($monto_afecto - $valur['isr_exceso']) * ($valur['isr_porcentaje'] / 100));
                        }
                    }
                    $respuesta['des'][$nombre_isr] = $impuesto;
                }
                if ($aplica_renta10) {
                    $monto_afecto = $impuesto = 0;
                    $agr_isr = $this->db->select()->from('deg_detalle_agrupador')->where('deg_id_tag', $this->agrupador_isr_10p)->get()->result_array();
                    $isr_ingreso = array_filter(array_column($agr_isr, 'deg_id_tig'));
                    $isr_descuentos = array_filter(array_column($agr_isr, 'deg_id_tdc'));
                    $tdc_isr = $this->gsatelite->get_registro('tdc_tipo_descuento', array('tdc_id' => $this->tdc_isr_10p));
                    foreach ($for_rentas['i'] as $ki => $vi) {
                        if (in_array($ki, $isr_ingreso) && $vi > 0) {
                            $monto_afecto += $vi;
                        }
                    }
                    foreach ($for_rentas['d'] as $kd => $vd) {
                        if (in_array($kd, $isr_descuentos) && $vd > 0) {
                            $monto_afecto -= $vd;
                        }
                    }
                    $impuesto = ($monto_afecto * $tdc_isr->tdc_porcentaje) / 100;
                    $respuesta['des'][$nombre_renta10] = $impuesto;
                }
            }
            return $respuesta;
        }
    }
} //end class
