<?php
/**
 * Created by PhpStorm.
 * User: mario.marquez
 * Date: 5/3/2020
 * Time: 15:53
 */

/**
 * @author Mario Marquez
 * @method Modelo - Modulo de Plan Operativo
 */
Class Plan_Operativo_Model extends CI_Model
{

    function __construct()
    {
        $this->load->database();
    }

    public function get_planes_operativos_unidad($where = null, $select = "*"){
        $query = $this->db->select($select)
            ->from('pxu_plan_operativoxunidad')
            ->join('poa_plan_operativo', 'poa_id = pxu_id_poa','inner')
            ->join('are_area', 'are_id = pxu_id_are','inner')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_objs_operativos($where = null){
        $query = $this->db->select()
            ->from('poa_plan_operativo')
            ->join('pxu_plan_operativoxunidad', 'pxu_id_poa = poa_id')
            ->join('are_area', 'are_id = pxu_id_are')
            ->join('obo_objetivo_operativo', 'obo_id_pxu = pxu_id', 'left')
        ;
        if($where){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_riesgos($where = null, $seguim = null){
        $query = $this->db->select()
            ->from('mai_matriz_riesgo')
            ->join('mxu_matrizxunidad', 'mxu_id_mai = mai_id')
            ->join('are_area', 'are_id = mxu_id_are')
            ->join('rsg_riesgos', 'rsg_id_mxu = mxu_id', 'left')
            ->join('clr_clasificacion_riesgo', 'clr_id = rsg_id_clr', 'left')
        ;
        if ($seguim) {
            $this->db->join('sgr_seguimiento_riesgo', 'sgr_id_rsg = rsg_id', 'left');
        }
        if($where){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_metas_operativas($where = null){

        $query = $this->db->select()
            ->from('met_meta_operativa')
            ->join('pxu_plan_operativoxunidad','met_id_pxu = pxu_id','inner')
            ->join('poa_plan_operativo', 'poa_id = pxu_id_poa','inner')
            ->join('tmd_tipo_medicion', 'tmd_id = met_id_tmd','inner')
            ->join('are_area','are_id = pxu_id_are', 'inner')
            ->join('ino_indicador_operativo','ino_id = met_id_ino', 'inner')
            ->join('obo_objetivo_operativo','obo_id = ino_id_obo', 'inner')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_actividades_realizadas($where = null){
        $query = $this->db->select()
            ->from('pxu_plan_operativoxunidad')
            ->join('poa_plan_operativo','poa_id = pxu_id_poa')
            ->join('obo_objetivo_operativo', 'obo_id_pxu = pxu_id')
            ->join('ino_indicador_operativo', 'ino_id_obo = obo_id','inner')
            ->join('met_meta_operativa', 'met_id_ino = ino_id')
            ->join('prm_programacion_meta', 'prm_id_met = met_id')
            ->join('per_periodo', 'per_id = prm_id_per')
            ->join('sgm_seguimiento_mensual', 'sgm_id_prm = prm_id')
            ->join('aco_accion_operativa', 'aco_id = met_id_aco')
            ->join('aca_accion_estrategica', 'aca_id = aco_id_aca')
            ->join('obe_objetivo_estrategico', 'obe_id = aca_id_obe')
            ->join('pie_pilar_estrategico', 'pie_id = obe_id_pie')
            ->join('pes_plan_estrategico', 'pes_id = pie_id_pes')
            ->order_by("met_id_aco, per_id ASC")
        ;
        if($where!=null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_informacion_empleado($user_id = 0){
        $q = $this->db->select()
            ->from('users')
            ->join('emp_empleado', 'id = emp_id_usu')
            ->join('are_area', 'are_id = emp_id_are')
            ->join('plz_plaza', 'plz_id = emp_id_plz')
            ->join('pto_puesto', 'pto_id = plz_id_pto')
            ->where('id', $user_id)
            ->group_by('emp_id')
        ;
        return $q->get()->result_array();
    }

    public function get_indicadores_operativos($where = null){
        $query = $this->db->select()
            ->from('ino_indicador_operativo')
            ->join('obo_objetivo_operativo','obo_id = ino_id_obo', 'inner')
            ->join('pxu_plan_operativoxunidad','pxu_id = obo_id_pxu','inner')
            ->join('poa_plan_operativo', 'poa_id = pxu_id_poa','inner')
            ->join('are_area','are_id = pxu_id_are', 'inner')            
        ;
        if($where){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_actividades_operativas_plan($where = null, $group_by = null, $select = "*"){

        $query = $this->db->select($select, FALSE)
            ->from('pes_plan_estrategico')
            ->join('pie_pilar_estrategico', 'pie_id_pes = pes_id','inner')
            ->join('obe_objetivo_estrategico', 'obe_id_pie = pie_id','inner')
            ->join('aca_accion_estrategica', 'aca_id_obe = obe_id','inner')
            ->join('aco_accion_operativa', 'aco_id_aca = aca_id','inner')
            ->join('pop_plan_operativoxplan_estrategico', 'pop_id_pes = pes_id','inner')
            ->join('pxu_plan_operativoxunidad','pxu_id_poa = pop_id_poa')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        if($group_by!=null){
            $this->db->group_by($group_by);
        }


        return $query->get()->result_array();

        return $query->get()->result_array();
    }

    public function get_programacion_meta($where = null, $order_by = null){

        $query = $this->db->select()
            ->from('prm_programacion_meta')
            ->join('per_periodo','prm_id_per = per_id','inner')
            ->join('sgm_seguimiento_mensual','prm_id = sgm_id_prm','left')
            ->join('rpd_reprogramacion_detalle','prm_id = rpd_id_prm','left')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        if($order_by!=null){
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    public function get_cumplimiento_ino($where = null, $order_by = null){
        $query = $this->db->select('SUM(sgm_ejecutado) AS sgm_ejecutado, SUM(IFNULL(rpd_programacion_nueva, prm_programa)) AS prm_programa, per_codigo', false)
            ->from('prm_programacion_meta')
            ->join('per_periodo','prm_id_per = per_id','inner')
            ->join('met_meta_operativa','met_id = prm_id_met','inner')
            ->join('sgm_seguimiento_mensual','prm_id = sgm_id_prm','left')
            ->join('rpd_reprogramacion_detalle','prm_id = rpd_id_prm','left')
            ->group_by('per_codigo')
        ;
        if($where){
            $this->db->where($where);
        }
        if($order_by){
            $this->db->order_by($order_by);
        }
        return $query->get()->result_array();
    }

    public function get_plz_responsables_ino($where = null){
        $query = $this->db->select("GROUP_CONCAT(DISTINCT(plz_nombre) SEPARATOR ', ') AS responsables", false)
            ->from('ino_indicador_operativo')
            ->join('rei_responsable_indicador','rei_id_ino = ino_id')
            ->join('plz_plaza','plz_id = rei_id_plz')
            ->join('emp_empleado','emp_id_plz = plz_id')
            ->join('are_area','are_id = emp_id_are','left')
        ;
        if($where!=null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_info_accion_operativa($where = null, $year = 0){
        $query = $this->db->select("*, IFNULL((SELECT pxn_programa FROM pxn_periodoxaccion_operativa JOIN per_periodo ON per_id = pxn_id_per
            WHERE pxn_id_aco = aco_id AND per_codigo = $year LIMIT 1), aco_unidad_program) AS aco_programacion", false)
            ->from('aco_accion_operativa')
        ;
        if($where!=null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_solicitudes_reprogramacion($where = null){
        $query = $this->db->select()
            ->from('slr_solicitud_reprogramacion')
            ->join('pxu_plan_operativoxunidad', 'pxu_id = slr_id_pxu','inner')
            ->join('poa_plan_operativo', 'poa_id = pxu_id_poa','inner')
            ->join('are_area', 'are_id = pxu_id_are','inner')
            ->join('per_periodo', 'per_id = slr_id_per','inner')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_metas_solicitudes_reprogramacion($where = null){
        $query = $this->db->select()
            ->from('mxs_metasxsolicitud_reprogramacion')
            ->join('met_meta_operativa', 'met_id = mxs_id_met','inner')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_solicitudes_modificacion($where = null){
        $query = $this->db->select()
            ->from('slr_solicitud_reprogramacion')
            ->join('pxu_plan_operativoxunidad', 'pxu_id = slr_id_pxu','inner')
            ->join('poa_plan_operativo', 'poa_id = pxu_id_poa','inner')
            ->join('are_area', 'are_id = pxu_id_are','inner')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_resumen_actividades_poa($where = null){

        $query = $this->db->select("
                are_nombre,
                SUM(CASE WHEN met_tipo_meta = 1 THEN 1 ELSE 0 END) as operativa,
                SUM(CASE WHEN met_tipo_meta = 2 THEN 1 ELSE 0 END ) as estrategica,
                SUM(met_asignacion_presupuesto) as asignacion_presupuesto,
                (SELECT COUNT(DISTINCT met_id) FROM met_meta_operativa met
                    LEFT JOIN prm_programacion_meta ON prm_id_met = met_id
                    WHERE met.met_id_pxu = pxu_id AND prm_id IS NOT NULL) as programadas
            ", FALSE)
            ->from('met_meta_operativa')
            ->join('pxu_plan_operativoxunidad','met_id_pxu = pxu_id','inner')
            ->join('poa_plan_operativo', 'poa_id = pxu_id_poa','inner')
            ->join('tmd_tipo_medicion', 'tmd_id = met_id_tmd','inner')
            ->join('are_area','are_id = pxu_id_are', 'inner')
            ->group_by('are_nombre')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_involucrados_act_pei($obe_id = null){
        $query = "SELECT DISTINCT plaza FROM (
            (
                SELECT DISTINCT pao_id_plz AS plaza, obe_id, 'p' AS tipo FROM obe_objetivo_estrategico JOIN aca_accion_estrategica ON aca_id_obe = obe_id
                JOIN aco_accion_operativa ON aco_id_aca = aca_id JOIN pao_participante_accion_ope ON pao_id_aco = aco_id
            ) UNION (
                SELECT DISTINCT reo_id_plz AS plaza, obe_id, 'e' AS tipo FROM obe_objetivo_estrategico JOIN aca_accion_estrategica ON aca_id_obe = obe_id 
                JOIN aco_accion_operativa ON aco_id_aca = aca_id JOIN reo_responsable_actividad_ope ON reo_id_aco = aco_id)
        ) AS plazas "; 
        $query .= ($obe_id) ? "WHERE obe_id = " . $obe_id : "";
        $resultado = $this->db->query($query);
        return $resultado->result_array();
    }

    public function get_involucrados_act_poa($where = null){
        $query = $this->db->select("DISTINCT rei_id_plz AS plaza", false)
            ->from('ino_indicador_operativo')
            ->join('rei_responsable_indicador', 'rei_id_ino = ino_id')
        ;
        if($where){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_objetivos_riesgos_pei_poa($year, $area = null){
        $query = "SELECT * FROM (
            (
                SELECT obo_id AS id_ob, CONCAT(obo_codigo,' - ',obo_nombre) AS name_ob, 'o' AS tipo_ob, pxu_id_are, poa_anio FROM obo_objetivo_operativo 
                JOIN pxu_plan_operativoxunidad ON pxu_id = obo_id_pxu JOIN poa_plan_operativo ON poa_id = pxu_id_poa
            ) UNION (
                SELECT obe_id AS id_ob, CONCAT(obe_numero,' - ',obe_nombre) AS name_ob, 'e' AS tipo_ob, pxu_id_are, poa_anio FROM obe_objetivo_estrategico 
                JOIN pie_pilar_estrategico ON pie_id = obe_id_pie  JOIN pes_plan_estrategico ON pes_id = pie_id_pes 
                JOIN pop_plan_operativoxplan_estrategico ON pop_id_pes = pes_id JOIN poa_plan_operativo ON poa_id = pop_id_poa 
                JOIN pxu_plan_operativoxunidad ON pxu_id_poa = poa_id
            )
        ) AS objetivos WHERE poa_anio = $year ";
        $query .= ($area) ? "AND pxu_id_are = $area" : "GROUP BY pxu_id_are, TIPO";
        $resultado = $this->db->query($query);
        return $resultado->result_array();
    }

    public function get_seguim_riesgos($where = null){
        $query = $this->db->select()
            ->from('rsg_riesgos')
            ->join('mxu_matrizxunidad', 'mxu_id = rsg_id_mxu')
            ->join('mai_matriz_riesgo', 'mai_id = mxu_id_mai')
            ->join('are_area', 'are_id = mxu_id_are')
            ->join('prb_probabilidad_riesgo', 'prb_id = rsg_id_prb_post_control', 'left')
            ->join('imr_impacto_riesgo', 'imr_id = rsg_id_imr_post_control', 'left')
            ->join('evt_evaluacion_riesgo_total', 'evt_id = rsg_id_evt', 'left')
            ->join('plz_plaza', 'plz_id = rsg_id_plz', 'left')
            ->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
            ->join('obe_objetivo_estrategico', 'obe_id = rsg_id_obe', 'left')
            ->join('obo_objetivo_operativo', 'obo_id = rsg_id_obo', 'left')
        ;
        if($where){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_avance_seguim_riesgo($where = null){
        $query = $this->db->select('*, IFNULL((SELECT MAX(ixs_porcentaje_ind) FROM ixs_indicadoresxseguimiento WHERE ixs_id_inr = inr_id), 0) AS avance', false)
            ->from('inr_indicador_riesgo')
            ->join('ixs_indicadoresxseguimiento', 'ixs_id_inr = inr_id', 'left')
            ->join('stl_estado_logro', 'stl_id = ixs_id_stl', 'left')
        ;
        if($where){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }
}