<?php
/**
 * Created by PhpStorm.
 * User: mario.marquez
 * Date: 5/3/2020
 * Time: 15:53
 */

/**
 * @author Mario Marquez
 * @method Modelo - Modulo Compras
 */
Class Plan_Estrategico_Model extends CI_Model
{

    function __construct()
    {
        $this->load->database();
    }

    public function get_periodo_planificacion($periodo, $tipo_periodo){
        $periodo_array = $this->db->select()
            ->from('per_periodo')
            ->where(
                array(
                    'per_codigo' => $periodo,
                    'per_tipo' => $tipo_periodo
                ))->get()->result_array();

        //Si no existe se ingresa
        if (count($periodo_array) == 0) {
            $nombre = $periodo;
            //Se verifica el numero de Mes si es tipo 1
            if($tipo_periodo == 1){
                $mes = substr($periodo, -2);
                switch ($mes){
                    case '01':
                        $nombre = "Enero";
                    break;
                    case '02':
                        $nombre = "Febrero";
                        break;
                    case '03':
                        $nombre = "Marzo";
                        break;
                    case '04':
                        $nombre = "Abril";
                        break;
                    case '05':
                        $nombre = "Mayo";
                        break;
                    case '06':
                        $nombre = "Junio";
                        break;
                    case '07':
                        $nombre = "Julio";
                        break;
                    case '08':
                        $nombre = "Agosto";
                        break;
                    case '09':
                        $nombre = "Septiembre";
                        break;
                    case '10':
                        $nombre = "Octubre";
                        break;
                    case '11':
                        $nombre = "Noviembre";
                        break;
                    case '12':
                        $nombre = "Diciembre";
                        break;

                }
            }

            $array_datos = array(
                'per_codigo' => $periodo,
                'per_nombre' => $nombre,
                'per_tipo' => $tipo_periodo,
                'per_estado' => 1,
                'per_usu_creacion' => $this->tank_auth->get_user_id(),
                'per_usu_modificacion' => $this->tank_auth->get_user_id(),
                'per_fecha_creacion' => date('Y-m-d H:i:s'),
                'per_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $per_id = $this->gsatelite->ingresar('per_periodo', $array_datos);
            $array_datos['per_id'] = $per_id;
            $periodo_array = $array_datos;
        }
        else{
            $periodo_array = $periodo_array[0];
        }

        return $periodo_array;
    }
    public function get_metas_estrategicas($where = null, $group_by = null, $select = "*"){

        $query = $this->db->select($select, FALSE)
            ->from('pes_plan_estrategico')
            ->join('pie_pilar_estrategico', 'pie_id_pes = pes_id','inner')
            ->join('obe_objetivo_estrategico', 'obe_id_pie = pie_id','inner')
            ->join('aca_accion_estrategica', 'aca_id_obe = obe_id','inner')
            ->join('aco_accion_operativa', 'aco_id_aca = aca_id','inner')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        if($group_by!=null){
            $this->db->group_by($group_by);
        }


        return $query->get()->result_array();
    }

    public function get_metas_est_form_pei($where = null){
        $query = $this->db->select('*, GROUP_CONCAT(reo_id_plz) AS responsable, GROUP_CONCAT(pao_id_plz) AS participante', FALSE)
            ->from('pes_plan_estrategico')
            ->join('pie_pilar_estrategico', 'pie_id_pes = pes_id','inner')
            ->join('obe_objetivo_estrategico', 'obe_id_pie = pie_id','inner')
            ->join('aca_accion_estrategica', 'aca_id_obe = obe_id','inner')
            ->join('aco_accion_operativa', 'aco_id_aca = aca_id','inner')
            ->join('reo_responsable_actividad_ope', 'reo_id_aco = aco_id','left')
            ->join('pao_participante_accion_ope', 'pao_id_aco = aco_id','left')
            ->group_by('aco_id')
        ;
        if($where){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_responsables_plan_estrategico($where = null, $group_by = null, $select = "*"){

        $query = $this->db->select($select, FALSE)
            ->from('pes_plan_estrategico')
            ->join('pie_pilar_estrategico', 'pie_id_pes = pes_id','inner')
            ->join('obe_objetivo_estrategico', 'obe_id_pie = pie_id','inner')
            ->join('aca_accion_estrategica', 'aca_id_obe = obe_id','inner')
            ->join('aco_accion_operativa', 'aco_id_aca = aca_id','inner')
            ->join('reo_responsable_actividad_ope', 'reo_id_aco = aco_id','inner')
            ->join('plz_plaza','plz_id = reo_id_plz','inner')
            ->join('emp_empleado','emp_id_plz = plz_id','inner')
            ->join('are_area','are_id = emp_id_are','inner')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        if($group_by!=null){
            $this->db->group_by($group_by);
        }


        return $query->get()->result_array();
    }

    public function get_participantes_plan_estrategico($where = null, $group_by = null, $select = "*"){

        $query = $this->db->select($select, FALSE)
            ->from('pes_plan_estrategico')
            ->join('pie_pilar_estrategico', 'pie_id_pes = pes_id','inner')
            ->join('obe_objetivo_estrategico', 'obe_id_pie = pie_id','inner')
            ->join('aca_accion_estrategica', 'aca_id_obe = obe_id','inner')
            ->join('aco_accion_operativa', 'aco_id_aca = aca_id','inner')
            ->join('pao_participante_accion_ope', 'pao_id_aco = aco_id','inner')
            ->join('plz_plaza','plz_id = pao_id_plz','inner')
            ->join('emp_empleado','emp_id_plz = plz_id','inner')
            ->join('are_area','are_id = emp_id_are','inner')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        if($group_by!=null){
            $this->db->group_by($group_by);
        }


        return $query->get()->result_array();
    }

    public function get_programacion_accion_operativa($where = null){
        $query = $this->db->select()
            ->from('pxn_periodoxaccion_operativa')
            ->join('per_periodo','per_id = pxn_id_per','inner')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_ejecucion_accion_operativa($where = null){
        $query = $this->db->select('aco_id, aco_nombre, per_codigo, pxn_id_per,
            IFNULL((SELECT IFNULL(SUM(sgm_ejecutado), 0) / pxn_programa FROM met_meta_operativa JOIN prm_programacion_meta ON prm_id_met = met_id 
            JOIN sgm_seguimiento_mensual ON sgm_id_prm = prm_id JOIN pxu_plan_operativoxunidad ON pxu_id = met_id_pxu JOIN poa_plan_operativo ON pxu_id_poa = poa_id
            JOIN pop_plan_operativoxplan_estrategico ON pop_id_poa = poa_id JOIN pes_plan_estrategico ON pes_id = pop_id_pes
            WHERE met_id_aco = aco_id AND poa_anio = per_codigo AND pop_id_pes = pie_id_pes), 0) AS ejecucion_anio', false)
            ->from('aco_accion_operativa')
            ->join('pxn_periodoxaccion_operativa','pxn_id_aco = aco_id')
            ->join('per_periodo','per_id = pxn_id_per')
            ->join('aca_accion_estrategica','aca_id = aco_id_aca')
            ->join('obe_objetivo_estrategico','obe_id = aca_id_obe')
            ->join('pie_pilar_estrategico','pie_id = obe_id_pie')
        ;
        if($where!=null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_programacion_plan_estrategico($where = null, $group_by = null, $select = "*"){

        $query = $this->db->select($select, FALSE)
            ->from('pes_plan_estrategico')
            ->join('pie_pilar_estrategico', 'pie_id_pes = pes_id','inner')
            ->join('obe_objetivo_estrategico', 'obe_id_pie = pie_id','inner')
            ->join('aca_accion_estrategica', 'aca_id_obe = obe_id','inner')
            ->join('aco_accion_operativa', 'aco_id_aca = aca_id','inner')
            ->join('pxn_periodoxaccion_operativa', 'pxn_id_aco = aco_id','inner')
            ->join('per_periodo','per_id = pxn_id_per','inner')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        if($group_by!=null){
            $this->db->group_by($group_by);
        }


        return $query->get()->result_array();
    }


    public function get_evaluacion_meta($valor){
        $query = $this->db->query(
            'SELECT
                * 
            FROM
                ( `evs_evaluacion_meta_estrategica` ) 
            WHERE
                '.$valor.' BETWEEN evs_rango_inicio AND evs_rango_fin'
        );


        return $query->result_array();
    }
}