<?php
class Personal_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    public function get_tabla($tabla,$where=0)
    {    
        $this->db->select();
        if($where!=0)
          $this->db->where($where);
        $this->db->from($tabla);
        $query=$this->db->get();    
        return $query->result_array();
    }


    public function get_ing_des($tabla,$where=0,$tipo)
    {    
        $this->db->select();
        if($where!=0)
          $this->db->where($where);
        $this->db->from($tabla);
        if($tipo==1)
          $this->db->join('tdc_tipo_descuento','tdc_id=dtp_id_tdc');
        if($tipo==2)
          $this->db->join('tig_tipo_ingreso','tig_id=itp_id_tig');
        if($tipo==3)
          $this->db->join('tis_tipo_isr','tis_id=txt_id_tis');
        $query=$this->db->get();    
        return $query->result_array();
    }
    public function get_det_ing_des($tabla,$det,$campo1,$campo2,$campo3=null)
    {    
    //'tdc_tipo_descuento',$data['desxpla'],'dtp_id_tdc','tdc_id'
        $arr=array();
        foreach($det as $c):
            $arr[]=$c[$campo1];
        endforeach;
        $this->db->select();
        $this->db->from($tabla);
        if(count($arr)>0)
            if($campo3 =="tdc_agrupador"){
                $this->db->where( array("$campo3 <>" => 'null'));
            }    
            if(count($arr)>0){
              $this->db->where_not_in($campo2,$arr);
          }
        $query=$this->db->get();

        return $query->result_array();
    }
    public function add_regitro($tabla,$datos)
    {   
        try{
          $this->db->insert($tabla,$datos);
          return $this->db->insert_id();
      }
      catch(Exception $e){
          return 0;
      }
    }
    function anexo_empleado($emp_id)
    {
        $anexos = $this->db->select()
        ->from('axe_anexoxempleado')
        ->join('anx_anexo','anx_id = axe_id_anx')
        ->where('axe_id_emp',$emp_id)
        ->where('anx_imagen',0);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

function anexo_solicitante($emp_id)
{
    $anexos = $this->db->select()
    ->from('ans_anexo_solicitante')
    ->where('ans_id_sle',$emp_id)
    ->where('ans_imagen',0);
    $resultado = $this->db->get();
    return $resultado->result_array();
}

function obtener_periodo_planilla($t_planilla)
{
 $this->db->select()
 ->from('pla_planilla')
 ->where('pla_id_tpl',$t_planilla);
 $periodos=$this->db->get();
 return $periodos->result_array();
}

function tipo_descuento($descuentos_base=false,$id_tipo_pla=null,$permitir=0)
{
    $id_descuento_isss = ($permitir > 0) ? 0 :  $this->gsatelite->get_parametro('DESCUENTO_ISS');
    $id_descuento_renta = ($permitir > 0) ? 0 : $this->gsatelite->get_parametro('DESCUENTO_ISR');
    $id_descuento_afp = ($permitir > 0) ? 0 : $this->gsatelite->get_parametro('DESCUENTO_AFP');
    $id_descuento_renta10 = ($permitir > 0) ? 0 : $this->gsatelite->get_parametro('DESCUENTO_ISR10');
    $id_descuento_vacacion = ($permitir > 0) ? 0 : $this->gsatelite->get_parametro('ID_TDC_VACACION');
    if($id_tipo_pla){
       $asociados= $this->gsatelite->get_tabla('dtp_descuentoxtipo_planilla',array('dtp_id_tpl'=>$id_tipo_pla));
        $ids_no = array(0);
        foreach ($asociados as $fila){
            $ids_no[] = $fila['dtp_id_tdc'];
        }
    }

    $tipos = $this->db->select()->from('tdc_tipo_descuento');
    if($descuentos_base){  
        $this->db->where_not_in('tdc_id', $ids_no);
        $this->db->where_in('tdc_id',array($id_descuento_isss,$id_descuento_renta,$id_descuento_afp,$id_descuento_renta10, $id_descuento_vacacion));
    } else {
        $this->db->where_not_in('tdc_id',array($id_descuento_isss,$id_descuento_renta,$id_descuento_afp,$id_descuento_renta10));
    }
    $resultado = $this->db->get();
    return $resultado->result_array();

}

function tipo_ingreso($ingreso_base=false,$id_tipo_pla=null, $sueldo_join=null)
{
    
    $id_ingreso=$this->gsatelite->get_parametro('INGRESO_SALARIO');
    $id_vacacion = $this->gsatelite->get_parametro('ID_TIG_VACACION');
    $id_prima_vacacion = $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION');
    $id_ingreso_aguinado = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');
    $id_ingreso_indemnizacion = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION');
    $id_ingreso_sueldo =explode(',', $id_ingreso);
    
    $id_ingreso_sueldo[] = intval($id_vacacion);
    $id_ingreso_sueldo[] = intval($id_prima_vacacion);
    $id_ingreso_sueldo[] = intval($id_ingreso_aguinado);
    $id_ingreso_sueldo[] = intval($id_ingreso_indemnizacion);
    //print_r($id_ingreso_sueldo); die();
    if($id_tipo_pla){
       $asociados= $this->gsatelite->get_tabla('itp_ingresoxtipo_planilla',array('itp_id_tpl'=>$id_tipo_pla));
       //die(print_r($asociados));
        $ids_no = array(0);
        foreach ($asociados as $fila) 
        {
            $ids_no[] = $fila['itp_id_tig'];
        }
    }
    $tipos = $this->db->select()
    ->from('tig_tipo_ingreso');
    if($ingreso_base)
    {
        $this->db->where_not_in('tig_id',$ids_no);
        $this->db->where_in('tig_id', $id_ingreso_sueldo);
    } 
    else if($ingreso_base==null && $sueldo_join==null)
     {
        $this->db->where_not_in('tig_id', $id_ingreso_sueldo);
    }else{
        $this->db->where('tig_estado', 1); 
    }
    $this->db->where('tig_estado', 1);
    $resultado = $this->db->get();

    return $resultado->result_array();

}

function listado_empleados($where=null){
    if($where!=null){
        $this->db->where($where);
    }
    $empleados = $this->db->select('*, 
                IFNULL((SELECT (SUM(vac_dia_ganado) - SUM(vac_dia_gozado)) FROM vac_vacacion WHERE vac_estado = 1 AND vac_id_emp = emp_id),0) AS dias_vac,
                IFNULL(rxe_id, 0) AS flag_rxe', false)  /* COMO VALIDAR SI TIENEN MAS DE 1 ???*/
    ->from('emp_empleado')
    ->join('plz_plaza','plz_id=emp_id_plz','left')
    ->join('are_area','emp_id_are=are_id','left')
    ->join('vac_vacacion','vac_id_emp = emp_id AND vac_estado = 1', 'left')
    ->join('rxe_resolucionxempleado', 'rxe_id_emp = vac_id_emp AND rxe_id_rsl = 3 AND rxe_fecha_creacion = vac_fecha_creacion', 'left')
    ->where('emp_id_emr',$this->tank_auth->get_empresa_id()) //added by René Castaneda 05032018
    ->group_by('emp_id')
    ->get();
    //print_r($this->db->last_query());
    return $empleados->result_array();
}

 function get_departamento()
{
    $area = $this->db->select()
    ->from('are_area')
    ->join('mxr_empresaxarea', 'mxr_id_are = are_id')
    ->where('mxr_id_emr', $this->tank_auth->get_empresa_id()) //Added by René Castaneda 
    ->get();
    return $area->result_array();
}

function info_empleado($id)
{
    $emp=$this->db->select()
    ->where('emp_id',$id)
    ->from('emp_empleado')
    ->get();
    return $emp->result_array();
}

function descuentos_empleado($id)
{
    $desc=$this->db->select()
    ->where('dss_id_emp',$id)
    ->from('dss_descuento')
    ->join('tdc_tipo_descuento','tdc_id=dss_id_tdc')
    ->get();
    return $desc->result_array();

}

function ingresos_empleado($id)
{
    $inn =$this->db->select()
    ->from('inn_ingreso')
    ->join('tig_tipo_ingreso','tig_id=inn_id_tig')
    ->where('inn_id_emp',$id)
    ->order_by('inn_estado')
    ->get();
    return $inn->result_array();

}

public function editar_empleado($id_emp)
{
    $query="SELECT * FROM emp_empleado 
    LEFT JOIN txe_tipo_planillaxempleado ON txe_id_emp = emp_id
    LEFT JOIN tpl_tipo_planilla ON tpl_id = txe_id_tpl
    LEFT JOIN cnt_cuenta_contable ON cnt_id = emp_id_cnt
    WHERE emp_id = ".$id_emp;
    $resultado = $this->db->query($query);
    return $resultado->result_array();
}

public function foto_empleado($id_emp)
{
    $query="SELECT * FROM emp_empleado
    INNER JOIN axe_anexoxempleado ON axe_id_emp=emp_id
    INNER JOIN anx_anexo ON anx_id = axe_id_anx
    WHERE anx_imagen = 1 AND emp_id=".$id_emp;
    $resultado = $this->db->query($query);
    return $resultado->result_array();
}

public function foto_solicitante($id_emp)
{
    $query="SELECT * FROM sle_solicitante_empleo
    INNER JOIN ans_anexo_solicitante ON ans_id_sle=sle_id
    WHERE ans_imagen = 1 AND sle_id=".$id_emp;
    $resultado = $this->db->query($query);
    return $resultado->result_array();
}



public function editar_tel_empleado($id_emp, $order=null, $limit=null)
{
    $this->db->select();
    $this->db->from('txm_telefonoxempleado');
    $this->db->join('tel_telefono', 'tel_id = txm_id_tel');
    $this->db->join('tit_tipo_telefono', 'tit_id = tel_id_tit', 'left');
    $this->db->where('txm_id_emp', $id_emp);
    $this->db->where('tel_estado', 1);
    /*$query ="SELECT * FROM txm_telefonoxempleado
    INNER JOIN tel_telefono ON tel_id = txm_id_tel
    LEFT JOIN tit_tipo_telefono ON tit_id = tel_id_tit
    WHERE txm_id_emp = ".$id_emp;
    $resultado = $this->db->query($query);
    return $resultado->result_array();
    */

    if($order!=null){
        $this->db->order_by($order);
    }

    if($limit!=null){
        $this->db->limit($limit);
    }

    $query = $this->db->get();
    return $query->result_array();
    
}

public function editar_doc_empleado($id_emp, $order=null, $limit=null)
{

    $query = $this->db->select()
             ->from('dce_documento_emp')
             ->join('tde_tipo_documento', 'tde_id = dce_id_tde')
            ;

    if($order!=null){
        $this->db->order_by($order);
    }

    if($limit!=null){
        $this->db->limit($limit);
    }

    $query = $this->db->get();
    return $query->result_array();
}

public function editar_doc_solicitante($id_emp, $order=null, $limit=null)
{

    $query = $this->db->select()
             ->from('dcs_documento_solicitante')
             ->join('tde_tipo_documento', 'tde_id = dcs_id_tde')
            ;

    if($order!=null){
        $this->db->order_by($order);
    }

    if($limit!=null){
        $this->db->limit($limit);
    }

    $query = $this->db->get();
    return $query->result_array();
}

function editar_fam_empleado($id_emp)
{
    $query = "SELECT * FROM fam_familiar JOIN pat_parentesco ON fam_id_pat = pat_id
    WHERE fam_estado=1 and fam_id_emp = ".$id_emp;
    $resultado = $this->db->query($query);
    return $resultado->result_array();
}

function get_afp()
{
    $afp = $this->db->select()
    ->from('afp_afp')
    ->get();
    return $afp->result_array();
}
function get_documentos()
{
    $tipo_documento = $this->db->select()
    ->from('tde_tipo_documento')
    ->where('tde_estado',1)
    ->get();
    return $tipo_documento->result_array();
}

function get_parentesco()
{
    $tipo_parentesco = $this->db->select()
    ->from('pat_parentesco')
    ->where('pat_estado',1)
    ->get();
    return $tipo_parentesco->result_array();
}
function get_sucursal()
{
    $sucursal = $this->db->select()
    ->from('suc_sucursal')
    ->where('suc_id_emr', $this->tank_auth->get_empresa_id())
    ->get();
    return $sucursal->result_array();
}
function get_puesto()
{
    $puesto = $this->db->select()
    ->from('pto_puesto')
    ->get();
    return $puesto->result_array();
}

function get_tipo_puesto()
{
    $tipo_puesto= $this->db->select()
    ->from('tpt_tipo_puesto')
    ->get();
    return $tipo_puesto->result_array();
}

function get_tipo_contrato()
{
    $puesto = $this->db->select()
    ->from('tpl_tipo_planilla')
    ->where('tpl_id_emr', $this->tank_auth->get_empresa_id())
    ->get();
    return $puesto->result_array();
}
function get_tipotelefono()
{
    $tipo_telefono = $this->db->select()
    ->from('tit_tipo_telefono')
    ->get();
    return $tipo_telefono->result_array();
}

function get_genero()
{
    $generos = $this->db->select()
    ->from('gen_genero')
    ->get();
    return $generos->result_array();

}
function get_profesion()
{
    $profesion = $this->db->select()
    ->from('pro_profesion')
    ->where('pro_estado',1)
    ->get();
    return $profesion->result_array();

}
function get_nacionalidad()
{
    $nacionalidad = $this->db->select()
    ->from('pai_pais')
    ->where('pai_estado',1)
    ->get();
    return $nacionalidad->result_array();

}
function get_estado_civil()
{
    $estado = $this->db->select()
    ->from('esc_estado_civil')
    ->get();
    return $estado->result_array();

}

    /**
    * @author Edith Herrera
    */
    function retiro_empleado($where=NULL)
    {
        if(isset($where)){
            $this->db->where($where);
        }
        $empleados = $this->db->select()
        ->from('emp_empleado')
        ->join('rte_retiro_empleado','rte_id_emp=emp_id')
        ->join('ctr_categoria_retiro','ctr_id=rte_id_ctr')
        ->join('are_area','emp_id_are=are_id','left')
        ->join('plz_plaza','plz_id=emp_id_plz','left')
        ->where('emp_id_emr', $this->tank_auth->get_empresa_id())
        ->where('rte_estado',1)
        ->get();

        return $empleados->result_array();
    }

    /**
     * @author Boris Estrada
     */
    function agrupadores($condiciones,$tag,$array){

        $consulta=$this->db->select()->from('deg_detalle_agrupador')->where($condiciones)->get();
        $registros=$consulta->result_array();
        //eliminar los ingresados por grocery para despues ingresarlos nuevamente con los campos configurados
        $this->gsatelite->borrado_general('deg_detalle_agrupador', $condiciones);
        $array_in=$array['ingresos'];
        $array_des=$array['descuentos'];
        foreach ($array_in as $registro) {
            if($registro!= NULL){
                $ingresos=array(
                    'deg_id_tag'=>$tag,
                    'deg_id_tig'=>$registro,
                    'deg_signo'=>'+',
                    'deg_aplicacion'=>'P',
                    'deg_valor'=>'100'
                    );
            }
            $this->db->insert('deg_detalle_agrupador',$ingresos);
        }

        foreach ($array_des as $key) {
            if($key!= NULL){
                $descuentos=array(
                    'deg_id_tag'=>$tag,
                    'deg_id_tdc'=>$key,
                    'deg_signo'=>'-',
                    'deg_aplicacion'=>'P',
                    'deg_valor'=>'100'
                    );
            }
            $this->db->insert('deg_detalle_agrupador',$descuentos);
        }


        return 1;
    }

   /**
     * REGISTRO DE ALUMNOS
     * 
     * @author Christian Menenedez
     * @since 
     */

public function editar_documentos_alm($id_alm)
{

    $this->db->select('*');
        $this->db->from('dca_documento_alumno');
        $this->db->join('tde_tipo_documento', 'dca_id_tde = tde_tipo_documento.tde_id');
       
       
        $this->db->where('dca_id_alm', $id_alm); 

       
        $query = $this->db->get();

        
        return $query->result_array();
/*
 $this->db->select('*');
        $this->db->from('dce_documento_alm');
        $this->db->join('tde_tipo_documento', 'dce_documento_alm.dce_id_tde = tde_tipo_documento.tde_id');
       
       
        $this->db->where('dce_id_alm', $id_alm); 

       
        $query = $this->db->get();

        
        return $query->result_array();
*/

}

   /**
     * REGISTRO DE ALUMNOS
     * 
     * @author Christian Menenedez
     * @since 
     */

public function editar_idioma_alum($id_alm)
{

    $this->db->select('*');
        $this->db->from('ial_idioma_alumno');
        $this->db->join('idm_idioma', 'ial_idioma_alumno.ial_id_idm = idm_idioma.idm_id');
        $this->db->join('nii_nivel_idioma', 'nii_nivel_idioma.nii_id = ial_idioma_alumno.ial_id_nii');
       
       
        $this->db->where('ial_id_alm', $id_alm); 

       
        $query = $this->db->get();

        
        return $query->result_array();


}

   /**
     * REGISTRO DE ALUMNOS
     * 
     * @author Christian Menenedez
     * @since 
     */

public function editar_alumno($id_alm)
{

    $this->db->select('*');
        $this->db->from('alm_alumno');
        $this->db->join('mun_municipio', 'mun_municipio.mun_id = alm_alumno.alm_id_mun','left');
        $this->db->join('dep_departamento', 'dep_departamento.dep_id = mun_municipio.mun_id_dep','left');
        // $this->db->join('pai_pais', 'pai_pais.pai_id = alm_alumno.alm_id_pai');
        $this->db->join('gen_genero', 'gen_genero.gen_id = alm_alumno.alm_id_gen');
        $this->db->join('pro_profesion', 'pro_profesion.pro_id = alm_alumno.alm_id_pro','left');
        $this->db->join('fin_financiamiento', 'fin_financiamiento.fin_id = alm_id_fin','left');
       
        $this->db->where('alm_id', $id_alm); 

       
        $query = $this->db->get();

       // die(print_r($this->db->last_query()));
        
        return $query->result_array();


}

   /**
     * REGISTRO DE ALUMNOS
     * 
     * @author Christian Menenedez
     * @since 
     */

public function editar_tel_alumno($id_alm)
{
   $this->db->select('txa_telefonoxalumno.* , alm_alumno.alm_nombre, alm_alumno.alm_apellido,alm_alumno.alm_id ');
        $this->db->from(' txa_telefonoxalumno');
        $this->db->join('tit_tipo_telefono', 'tit_tipo_telefono.tit_id = txa_telefonoxalumno.txa_id_tit');
        $this->db->join('alm_alumno', 'alm_alumno.alm_id = txa_telefonoxalumno.txa_id_alm');

        $this->db->where('alm_alumno.alm_id', $id_alm); 
        
        $query = $this->db->get();

        
        return $query->result_array();
}


   /**
     * REGISTRO DE ALUMNOS
     * 
     * @author Christian Menenedez
     * @since 
     */

public function alm_documentos($id_alm)
{
   $this->db->select('*');
        $this->db->from(' dce_documento_alm');
        $this->db->join('alm_alumno', 'alm_alumno.alm_id = dce_documento_alm.dce_id_alm');
        $this->db->join('tde_tipo_documento', 'tde_tipo_documento.tde_id = dce_documento_alm.dce_id_tde');

        $this->db->where('alm_alumno.alm_id', $id_alm); 
        
        $query = $this->db->get();

        
        return $query->result_array();
}

public function obtener_modulos($ard_id)
{
   $this->db->select('*');
        $this->db->from(' mod_modulo');
        $this->db->join('pen_pensum', 'mod_modulo.mod_id = pen_pensum.pen_id_mod');
        $this->db->join('ard_area_academica', 'ard_id = pen_id_ard');

        $this->db->where('ard_area_academica.ard_id', $ard_id); 
        
        $query = $this->db->get();

        
        return $query->result_array();
}

public function obtener_notas_modulos($fecha_inicio=null, $fecha_fn=null, $mod=null,  $area=null, $lxp_activo=null, $group=null)
{
   $this->db->select();
        $this->db->from('ard_area_academica');
        $this->db->join('pen_pensum', 'pen_id_ard=ard_id');
        $this->db->join('mod_modulo', 'mod_id=pen_id_mod');
        $this->db->join('gra_grupo_academico', 'gra_id_pen=pen_id');
        $this->db->join('lxp_alumnoxpensum', 'lxp_id_gra=gra_id ');
        $this->db->join('aul_aula', 'aul_id=gra_id_aul ');
        $this->db->join('lxa_alumnoxarea', 'lxp_id_lxa=lxa_id');
        $this->db->join('alm_alumno', 'alm_id=lxa_id_alm');

        if($lxp_activo!=null){
            $this->db->where('lxp_estado', 1);
        }

        if ($fecha_inicio!=null && $fecha_fn!=null) {
           $this->db->where('gra_fecha_inicio >=', $fecha_inicio); 
        $this->db->where('gra_fecha_fin <=', $fecha_fn);
        }
        

        $this->db->where('mod_id', $mod); 
        
        if($area!=null){
            $this->db->where('ard_id',$area);
        }

        if($group!=null){
            $this->db->group_by($group);
        }

        $this->db->order_by('alm_nombre');
        $query = $this->db->get();

        return $query->result_array();
}

public function obtener_alumnos($ard_id)
{
   $this->db->select('*');
        $this->db->from(' alm_alumno');
        $this->db->join('lxa_alumnoxarea', 'alm_alumno.alm_id = lxa_alumnoxarea.lxa_id_alm');
        $this->db->join('ard_area_academica', 'lxa_alumnoxarea.lxa_id_ard = ard_area_academica.ard_id');

        $this->db->where('ard_id', $ard_id); 
        
        $query = $this->db->get();

        
        return $query->result_array();
}


public function obtener_notas_alm($where_a)
{
   $this->db->select('*, CONCAT(hrg_inicio,"-",hrg_fin) as Horario', FALSE);
        $this->db->from('ard_area_academica ');
        $this->db->join('pen_pensum', 'pen_id_ard=ard_id');

        $this->db->join('mod_modulo', 'mod_id=pen_id_mod');

        $this->db->join('gra_grupo_academico', 'gra_id_pen=pen_id');

        $this->db->join('lxp_alumnoxpensum', 'lxp_id_gra=gra_id ');

        $this->db->join('lxa_alumnoxarea', 'lxp_id_lxa=lxa_id');

        $this->db->join('alm_alumno', 'alm_id=lxa_id_alm');
        $this->db->join('hrg_horario_grupo', 'gra_id_hrg=hrg_id', 'left');
        //$this->db->join('noa_nota_alumno', 'noa_id_lxp = lxp_id');
        //$this->db->join('pod_ponderacion', 'pod_id = noa_id_pod');

        $this->db->where($where_a); 
        
        $query = $this->db->get();
        
        return $query->result_array();
}


public function obtener_pensum_nivel()
{
   $this->db->select('ard_nombre as Nivel,modl.mod_nombre as Modulo, 
pen_uni_valorativa as UV,pre.mod_nombre');

        $this->db->from('ard_area_academica ');

        $this->db->join('pen_pensum', 'pen_id_ard=ard_id');

        $this->db->join('mod_modulo modl', 'modl.mod_id=pen_id_mod ');


        $this->db->join('pre_prerrequisito', 'pre_id_pen=pen_id');

        $this->db->join('mod_modulo pre', 'pre.mod_id=pre_id_mod');

        
        $query = $this->db->get();

        
        return $query->result_array();
}

 function get_pla_meses($txt_id,$tpl_id){
                    $this->db->select();
                    $this->db->from('txt_tipo_planillaxtipo_isr');
                    $this->db->join('tpl_tipo_planilla', 'tpl_id=txt_id_tpl');
                    $this->db->join('pis_periodo_isr', 'txt_id=pis_id_txt');

                    $this->db->where('txt_id', $txt_id); 
                    $this->db->where('tpl_id', $tpl_id);
                    
                    $query = $this->db->get();

                    
                    return $query->result_array();
                }

                //funcion para filtrar los telefonos
    function get_id_telefono($id){
        $this->db->select();
        $this->db->from('tel_telefono');
        $this->db->join('txm_telefonoxempleado','txm_id_tel = tel_id');
        $this->db->where('txm_id_emp', $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    function buscarturno($where=null){
        $this->db->select("deh_detalle_horario.*", false);
        $this->db->from('deh_detalle_horario');
        $this->db->join('dxt_detallexturno','dxt_id_deh = deh_id');
        $this->db->join('txe_turnoxempleado','txe_id_tur = dxt_id_tur');
        if($where){
            $this->db->where($where);
         // WHERE txe_id_emp = 1 AND txe_desde <= '2024-08-14' AND (txe_hasta IS NULL OR txe_hasta >= '2024-08-14') AND txe_estado = 1 
        }
        return $this->db->get()->result_array();
    }

    function get_telefonos_alumnos($where = null){
        $query = $this->db->select('tal_numero, tit_nombre, tal_id, tit_id')
                ->from('tal_telefonoxalumno')
                ->join('tit_tipo_telefono','tit_id = tal_id_tit')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

     function get_telefonos_solicitante($where = null){
        $query = $this->db->select()
                ->from('tsl_telefono_solicitante')
                ->join('tit_tipo_telefono','tit_id = tsl_id_tit')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_redes_alumnos($where = null){
        $query = $this->db->select()
                ->from('rxa_red_socialxalumno')
                ->join('res_red_social','res_id = rxa_id_res')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }
    function get_familiares_alumnos($where = null){
        $query = $this->db->select()
                ->from('fal_familiar_alumno')
                ->join('pat_parentesco', 'pat_id = fal_id_pat')
                ->join('tde_tipo_documento', 'tde_id = fal_id_tde', 'left')
                ->join('pro_profesion', 'pro_id = fal_id_pro', 'left')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }
    function get_datos_academicos_alumnos($where = null){
        /*select * from eda_educacion_alumno 
        INNER JOIN pai_pais on pai_id = eda_id_pai
        INNER JOIN tie_tipo_educacion on tie_id = eda_id_tie
        INNER JOIN ina_institucion_academica on ina_id = eda_id_ina
        INNER JOIN ted_titulo_educacion on ted_id = eda_id_ted*/
        $query = $this->db->select()
                ->from('eda_educacion_alumno')
                ->join('pai_pais','pai_id = eda_id_pai')
                ->join('tie_tipo_educacion','tie_id = eda_id_tie')
                ->join('ina_institucion_academica','ina_id = eda_id_ina', 'left')
                ->join('ted_titulo_educacion','ted_id = eda_id_ted', 'left')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }
    function get_idioma_alumnos($where = null){
        /*
            select * from ial_idioma_alumno 
            INNER JOIN idm_idioma on idm_id = ial_id_idm
            INNER JOIN nii_nivel_idioma on nii_id = ial_id_nii
            where ial_id_alm = 34
        */
        $query = $this->db->select()
                ->from('ial_idioma_alumno')
                ->join('idm_idioma', 'idm_id = ial_id_idm')
                ->join('nii_nivel_idioma', 'nii_id = ial_id_nii')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }
    function get_clinicos_alumnos($where = null){
        /*
            select * from ial_idioma_alumno 
            INNER JOIN idm_idioma on idm_id = ial_id_idm
            INNER JOIN nii_nivel_idioma on nii_id = ial_id_nii
            where ial_id_alm = 34
        */
        $query = $this->db->select()
                ->from('cla_clinico_alumno')
                ->join('pat_parentesco', 'pat_id = cla_id_pat', 'left')
                ->join('ttm_tipo_tratamiento', 'ttm_id = cla_id_ttm', 'left')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }
    function get_habilidades_alumnos($where){
        /*
            select * from hxa_habilidadxalumno 
            INNER JOIN grh_grupo_habilidad on grh_id = hxa_id_grh
            INNER JOIN hab_habilidad on hab_id = hxa_id_hab
            INNER JOIN tih_tipo_habilidad on tih_id = hab_id_tih
            where hxa_id_alm = 34
        */
        $query = $this->db->select()
                ->from('hxa_habilidadxalumno')
                ->join('hab_habilidad', 'hab_id = hxa_id_hab')
                ->join('tih_tipo_habilidad', 'tih_id = hab_id_tih')
                ->join('grh_grupo_habilidad', 'grh_id = hxa_id_grh', 'left')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }
    function get_pasatiempo_alumno($where){
        /*
            select * from psa_pasatiempo_alumno 
            INNER JOIN pst_pasatiempo on pst_id = psa_id_pst
            where psa_id_alm = 34
        */
        $query = $this->db->select()
            ->from('psa_pasatiempo_alumno')
            ->join('pst_pasatiempo', 'pst_id = psa_id_pst')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
    * @author René Castaneda
    * @since 2017-07-31
    * @return Obtener los usuarios de auditoria (CRUD)
     */
    //array de dos posiciones crea/modifica
    public function auditoria_ingreso_descuento($array_usu=null,$retorna_full=false)
    {
      if (!is_array($array_usu)) {
          return '';
      }
       $query = $this->db->select()
           ->from('users')
       ;
       if($array_usu != null){
           $this->db->where_in('id',$array_usu);
       }
       $resultado = $query->get()->result_array();
       if ($retorna_full) {
           return $resultado;
       }
       $usuarios = array();
       foreach ($resultado as $fila) { //creación
           if (isset($array_usu[0]) and $array_usu[0]==$fila['id'] ) {
               $usuarios[] = $fila['username'];
           }
       }

       foreach ($resultado as $fila) {  //modificación.
           if (isset($array_usu[1]) and $array_usu[1]==$fila['id'] ) {
               $usuarios[] = $fila['username'];
           }
       }

       $auditoria = (count($usuarios) > 0 )? implode('/',(array_unique($usuarios))):'';
       //print_r($auditoria); die();
       return $auditoria;
    }

    /**
    * @author jose marlon
    * @since 2019-05-31
    * @return obtiene los ingresos y descuentos de un tipo de agrupador
     */
    function tipo_agrupadores($where=null) {

        $this->db->select('*,tig_nombre,tdc_nombre')
                           ->from('deg_detalle_agrupador')
                           ->join('tig_tipo_ingreso','deg_id_tig = tig_id','left')
                           ->join('tdc_tipo_descuento','deg_id_tdc = tdc_id','left');

        if ($where != '') {
            $this->db->where($where);
        }
        $result = $this->db->get()->result_array();
        return $result;
        }
            /**
    * @author jose marlon
    * @since 2019-06-07
    * @return obtiene los ingresos 
     */
    function tig_ingresos($where=null) {

        $this->db->select('tig_id,tig_nombre')
                 ->from('tig_tipo_ingreso');

        if ($where != '') {
            $this->db->where($where,'',false);
        }
        $result = $this->db->get()->result_array();
        return $result;
        }
            /**
    * @author jose marlon
    * @since 2019-06-37
    * @return obtiene los descuentos
     */
    function tdc_descuentos($where=null) {
        $this->db->select('tdc_id,tdc_nombre')
            ->from('tdc_tipo_descuento');
        if ($where != '') {
            $this->db->where($where,'',false);
        }
        $result = $this->db->get()->result_array();
        return $result;
    }


    public function elegibles_indemnizar(){
        $fecha = date_create(date('Y-m-d'));
        $meses_param = json_decode($this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_INDEMNIZACION_VOLUNTARIA', null, null, array('MINIMO_MESES_PARA_INDEMNIZACION')));
        $meses = ($meses_param > 0) ? $meses_param : 12;
        $fecha->modify("-$meses month");
        $hasta = date_format($fecha, 'Y-m-d'); 
        $this->db->select("emp_id, emp_codigo, emp_nombre, emp_apellido, plz_nombre, are_nombre, emp_fecha_contrato, emp_fecha_ult_liquidacion")
            ->from("emp_empleado")
            ->join("plz_plaza", "plz_id = emp_id_plz", "left")
            ->join("are_area", "emp_id_are = are_id", "left")
            ->where("emp_estado", 1)
            ->where("emp_id NOT IN (SELECT rte_id_emp FROM rte_retiro_empleado)", null, false)
            ->where("DATE(IFNULL(emp_fecha_ult_liquidacion, emp_fecha_contrato)) <= '$hasta'", null, false)
        ;
        return $this->db->get()->result_array();
    }

    /**
    * @author Raul Escalante
    * @since 2019-06-10
    * @return Obtiene la planilla mas reciente de un empleado
     */
    function get_tipo_planilla($id){
        $tipo = $this->db->select()
                         ->from('txe_tipo_planillaxempleado')
                         ->where('txe_estado', 1)
                         ->where('txe_id_emp', $id)
                         ->order_by('txe_fecha_creacion', 'DESC')
                         ->limit(1)
        ;
        return $tipo->get()->result_array();
    }

    /**
    * @author Raul Escalante
    * @return Obtiene los datos para las constancias personalizadas
    */
    function get_datos_tipo_constancia($id){
        $tipo = $this->db->select("tpo_id, fre_id, tpo_nombre, fre_configuraciones_formato,
            (SELECT GROUP_CONCAT(vao_nombre ORDER BY vao_nombre) FROM vxt_variablextipo_constancia JOIN vao_variable_constancia ON vao_id = vxt_id_vao WHERE vxt_id_tpo = tpo_id) AS variables_constancia
            ", false)
                ->from('tpo_tipo_constancia')
                ->join('fre_formato_constancia_empleado', 'fre_id_tpo = tpo_id')
                ->where('tpo_id', $id)
        ;
        return $tipo->get()->result_array();
    }

     /**
    * @author Raul Escalante
    * @since 2019-06-10
    * @return Obtiene la planilla mas reciente de un empleado
     */
    function get_detalles_afp($where = null, $group_by = null){
        $query = $this->db->select()
                ->from('afp_afp')
                ->join("dff_detalle_finanza_afp","dff_id_afp = afp_id","LEFT")
                ->join("cnt_cuenta_contable","cnt_id = dff_id_cnt","LEFT")
                ->join("cec_centro_costo","cec_id = dff_id_cec","LEFT")
                ->join("tcn_tipo_cuenta","tcn_id = dff_id_tcn","LEFT")
        ;

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }
}
