<?php
/**
 * 
 */
class Oracleserver_model extends CI_Model
{

    /**
     * Gsatelite::__construct()
     * 
     * @return
     */
    private $db2;

    function __construct()
    {
        $this->db2 = $this->load->database('oracle',true);
        date_default_timezone_set('America/El_Salvador');
    }

    function get_all_vw_cli(){
        // $query = "SELECT * FROM CLIENTES";
        $query = "SELECT * FROM PR_MV_CLIENTES_ESFSV ";
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());
    }

    function get_all_vw_fac(){
        // $query = "SELECT * from RESUMEN_PAGOS";
        $query = "SELECT * from PR_MV_RESUMEN_PAGOS_ESFSV ";
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());
    }

    /**
    * @author R.Escalante
    * @since 2024-05-01
    * @return datos de la vista segun where
     */
    function get_vw_fac_fechas($where_array = null){
        $where = "";
        // $query = "SELECT * from RESUMEN_PAGOS ";
        $query = "SELECT * from PR_MV_RESUMEN_PAGOS_ESFSV ";
        if ($where_array) {
            $where = implode(" AND ", $where_array);
        }
        $query .= $where;
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());
    }

    function get_all_vw_defC($refpago = null){
        // $query = "SELECT * from DETALLE_PAGOS ";
        $query = "SELECT * from PR_MV_DETALLE_PAGOS_ESFSV ";
        if ($refpago) {
            $query .= "WHERE SECUENCIA_PAGO = '$refpago' ";
        }
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());
    }

    function get_vw_clifac($where_array = null, $fkcliente = null){
        # SELECT DISTINCT c.* FROM PR_MV_CLIENTES_ESFSV c INNER JOIN PR_MV_RESUMEN_PAGOS_ESFSV p ON p.CODIGO_CLIENTE = c.CODIGO WHERE p.FECHA_TRANSACCION >= TO_DATE('2024-09-30','YYYY/MM/DD') AND p.FECHA_TRANSACCION <= TO_DATE('2024-09-30','YYYY/MM/DD') AND c.FECHA_ACTUALIZACION = (SELECT MAX(f.FECHA_ACTUALIZACION) FROM PR_MV_CLIENTES_ESFSV f WHERE f.CODIGO = c.CODIGO)
        $where = "";
        $cli_key = ($fkcliente) ? $fkcliente : "CODIGO";
        $query = "SELECT DISTINCT c.* FROM PR_MV_RESUMEN_PAGOS_ESFSV p JOIN PR_MV_CLIENTES_ESFSV c ON c.$cli_key = p.CODIGO_CLIENTE ";
        if ($where_array) {
            $where = implode(" AND ", $where_array);
            $where = str_replace("FECHA_TRANSACCION", "p.FECHA_TRANSACCION", $where);
            $where .= " AND c.FECHA_ACTUALIZACION = (SELECT MAX(f.FECHA_ACTUALIZACION) FROM PR_MV_CLIENTES_ESFSV f WHERE f.CODIGO = c.CODIGO)";
        } else {
            $where = "WHERE c.FECHA_ACTUALIZACION = (SELECT MAX(f.FECHA_ACTUALIZACION) FROM PR_MV_CLIENTES_ESFSV f WHERE f.CODIGO = c.CODIGO)";
        }
        $query .= $where;
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());
    }

    public function get_tabla($tabla, $where=null){
        if(!$tabla && !is_string($tabla)){
            return null;
        }
        if($where){
            $this->db2->where($where);
        }
        $results=$this->db2->get($tabla)->result_array();
        return $results;
    }


    public function get_vw_fac_fechas_param($consulta = null, $where_array = null){
        $where = "";
        $query = ($consulta) ? "SELECT $consulta FROM PR_MV_RESUMEN_PAGOS_ESFSV " : "SELECT * FROM PR_MV_RESUMEN_PAGOS_ESFSV ";
        if ($where_array) {
            $where = implode(" AND ", $where_array);
        }
        $query .= $where;
        // var_dump($query);die();
        $result = $this->db2->query($query);
        return utf8_converter($result->result_array());
    }


}