<?php
class Medico_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /**
     * @author Marlon Olmedo
     * @since 2019-08-10
     * @return Obtener información de la aseguradora con su poliza (tabla: ase_aseguradora,pol_poliza)
     */
    public function aseguradoraxpoliza($where = null) {
        $q = $this->db->select("*, (SELECT COUNT(*) FROM sep_seguro_paciente WHERE sep_id_pol = pol_id) AS asegurados", false)
        ->from('ase_aseguradora')
        ->join('pol_poliza', 'pol_id_ase = ase_id','left')
        ;
        if ($where) {
            $this->db->where($where);
        }
        
        return $q->get()->result_array();
    }

      /**
     * @author Elmer Hernandez
     * @since 2019-11-11
     * @return Obtener los datos para poder generar el formulario de aseguradoras dependiendo del paciente seleccionado
     */
      public function datos_formulario($where = null, $grou_by = null) {
        $q = $this->db->select("cnm_id,cnm_numero,ase_id,ase_nombre")
        ->from('cnm_consulta_medica')
        ->join('cim_cita_medica', 'cnm_id_cim=cim_id','left')
        ->join('epp_expediente_paciente', 'cim_id_epp = epp_id','left')
        ->join('sep_seguro_paciente', 'sep_id_epp=epp_id','left')
        ->join('pol_poliza', 'sep_id_pol=pol_id','left')
        ->join('ase_aseguradora', 'pol_id_ase=ase_id','left')
        ;
        if ($where) {
            $this->db->where($where);
        }
        if ($grou_by != null) {
            $this->db->group_by($grou_by);
        }
        return $q->get()->result_array();
    }

    

     /**
     * @author Elmer Hernandez
     * @since 2019-11-11
     * @return Obtener los formularios de aseguradoras dependiendo de la aseguradora
     */
     public function formularios_aseguradora($where = null) {
        $q = $this->db->select("frm_id,frm_nombre,frm_archivo, ase_nombre")
        ->from('frm_formulario_medico')
        ->join('ase_aseguradora', 'frm_id_ase=ase_id','inner')
        ;
        if ($where) {
            $this->db->where($where);
        }
        
        return $q->get()->result_array();
    }

        /**
     * @author Marlon Olmedo
     * @since 2019-08-10
     * @return Obtener información sobre las citas (tabla: cim_cita_medica,epp_expediente_paciente,tcm_tipo_consulta_medica)
     */
        public function informacion_cita($where = null) {
            $q = $this->db->select("*,CONCAT(epp_numero_expediente,'-',epp_nombre,' ',epp_apellido,' ', IFNULL(epp_apellido_casada, '')) as nombre_paciente",false)
            ->from('cim_cita_medica')
            ->join('tcm_tipo_consulta_medica', 'cim_id_tcm = tcm_id','left')
            ->join('epp_expediente_paciente', 'cim_id_epp = epp_id','left')
            ->join('sgt_seguimiento_cita', 'sgt_id_cim = cim_id','left')
            ->join('med_medico', 'cim_id_med = med_id','left')
            ->join('luc_lugar_cita', 'cim_id_luc = luc_id','left')
            ;
            if ($where) {
                $this->db->where($where);
            }

            return $q->get()->result_array();
        }

            /**
     * @author Marlon Olmedo
     * @since 2019-08-10
     * @return Obtener información sobre las Consultas (tabla: cnm_consulta_medica,cim_cita_medica,tcm_tipo_consulta_medica,cdm_condicion_medica)
     */
            public function informacion_consulta($where = null) {
                $q = $this->db->select("*,CONCAT(epp_numero_expediente,'-',epp_nombre,' ',epp_apellido,' ',epp_apellido_casada) as nombre_paciente,
                    (SELECT COUNT(rct_id) FROM rct_receta WHERE rct_id_cnm = cnm_id) AS receta",false)
                ->from('cnm_consulta_medica')
                ->join('cim_cita_medica', 'cim_id = cnm_id_cim','left')
                ->join('tcm_tipo_consulta_medica', 'cim_id_tcm = tcm_id','left')
                ->join('cdm_condicion_medida', 'cnm_id_cdm = cdm_id','left')
                ->join('epp_expediente_paciente', 'cim_id_epp = epp_id','left')
                ->join('med_medico', 'cim_id_med = med_id','left')
                ->join('luc_lugar_cita', 'cim_id_luc = luc_id','left')
                ;
                if ($where) {
                    $this->db->where($where);
                }

                return $q->get()->result_array();
            }

        function recetas_por_consulta($where = null){
            $query = $this->db->select("*, (SELECT CONCAT(epp_numero_expediente, '-', epp_nombre, ' ', epp_apellido, ' ', epp_apellido_casada) FROM cim_cita_medica
                    JOIN epp_expediente_paciente ON epp_id = cim_id_epp WHERE cim_id = cnm_id_cim) AS nombre_paciente, IFNULL((SELECT lip_precio FROM tpn_tipo_precio_cliente 
                    JOIN tlp_tipo_lista_precio ON tlp_id = tpn_id_tlp JOIN lip_listado_precio ON lip_id_tlp = tlp_id WHERE tlp_defecto = 1 AND lip_id_art = rct_id_art 
                    AND rct_cantidad >= lip_desde AND rct_cantidad <= lip_hasta AND lip_estado = 1 AND tpn_id_cli = (SELECT epp_id_cli FROM cim_cita_medica 
                    JOIN epp_expediente_paciente ON epp_id = cim_id_epp WHERE cim_id = cnm_id_cim) LIMIT 1), 0) AS lip_precio_sugerido", false)
                ->from('rct_receta')
                ->join('art_articulo', 'art_id=rct_id_art','inner')
                ->join('ppr_presentacion_producto', 'ppr_id=art_id_ppr','inner')
                ->join('cnm_consulta_medica', 'cnm_id = rct_id_cnm','inner')
            ;
            if ($where) {
                $this->db->where($where);
            }
            return $query->get()->result_array();
        }

        function recetas_por_consulta2($where = null){
            /* VERSION SIMPLE PARA CLINICA CALVO */
            $query = $this->db->select("cnm_fecha_consulta, art_nombre, art_sinonimo, ppr_nombre, rct_cantidad, rct_dosis, CONCAT(epp_numero_expediente, '-', epp_nombre, ' ', epp_apellido, ' ', epp_apellido_casada) AS nombre_paciente", false)
                ->from('rct_receta')
                ->join('art_articulo', 'art_id = rct_id_art','inner')
                ->join('ppr_presentacion_producto', 'ppr_id = art_id_ppr','inner')
                ->join('cnm_consulta_medica', 'cnm_id = rct_id_cnm','inner')
                ->join('cim_cita_medica', 'cim_id = cnm_id_cim','inner')
                ->join('epp_expediente_paciente', 'epp_id = cim_id_epp','inner')
            ;
            if ($where) {
                $this->db->where($where);
            }
            return $query->get()->result_array();
        }

        function dato_empresa($where = null){
            $q = $this->db->select("*")
            ->from('prm_parametro_empresa')
            ;
            if ($where) {
                $this->db->where($where);
            }

            return $q->get()->result_array();
        }

                /**
     * @author Marlon Olmedo
     * @since 2019-08-10
     * @return Obtener información sobre las Consultas Anteriores(tabla: cnm_consulta_medica,cim_cita_medica,tcm_tipo_consulta_medica,cdm_condicion_medica)
     */
                public function informacion_consulta_anteriores($where = null) {
                    $q = $this->db->select("*,CONCAT(epp_numero_expediente,'-',epp_nombre,' ',epp_apellido,' ',epp_apellido_casada) as nombre_paciente",false)
                    ->from('cim_cita_medica')
                    ->join('cnm_consulta_medica', 'cnm_id_cim = cim_id','inner')
                    ->join('tcm_tipo_consulta_medica', 'cim_id_tcm = tcm_id','left')
                    ->join('cdm_condicion_medida', 'cnm_id_cdm = cdm_id','left')
                    ->join('epp_expediente_paciente', 'cim_id_epp = epp_id','left')
                    ->join('med_medico', 'cim_id_med = med_id','left')
                    ->join('luc_lugar_cita', 'cim_id_luc = luc_id','left')
                    ;
                    if ($where) {
                        $this->db->where($where);
                    }

        //print_r($this->db->last_query());die();

                    return $q->get()->result_array();
                }

     /**
     * @author Marlon Olmedo
     * @since 2019-08-10
     * @return Obtener información sobre las recetas (tabla: rct_receta,cnm_consulta_medica,art_articulo)
     */
     public function informacion_receta($where = null) {
        $q = $this->db->select("*")
        ->from('rct_receta')
        ->join('art_articulo', 'art_id = rct_id_art','left')
        ->join('tia_tipo_articulo', 'art_id_tia = tia_id','left')
        ->join('ppr_presentacion_producto', 'art_id_ppr = ppr_id', 'left')
        ;
        if ($where) {
            $this->db->where($where);
        }
        
        return $q->get()->result_array();
    }

     /**
     * @author Habby Lovo
     * @since 2019-09-03
     * @return Obtener información sobre los pacientes (tabla: epp_expediente_paciente)
     */
     public function get_tabla_expediente_paciente($where = null) {
        /*
            SELECT * FROM
                epp_expediente_paciente
            LEFT JOIN cfc_clasificacion_cliente ON cfc_id = epp_id_cfc
        */
            $q = $this->db->select()
            ->from('epp_expediente_paciente')
            ->join('cfc_clasificacion_cliente', 'cfc_id = epp_id_cfc','left')
            ->join('gen_genero', 'gen_id = epp_id_gen','left')
            ->join('pro_profesion', 'pro_id = epp_id_pro','left')
            ->join('pai_pais', 'pai_id = epp_id_pai','left')
            ->join('dep_departamento', 'dep_id = epp_id_dep','left')
            ->join('mun_municipio', 'mun_id = epp_id_mun','left')
            ->join('ciu_ciudad', 'ciu_id = epp_id_ciu','left')
            ->join('ref_referido', 'ref_id = epp_id_ref','left')
            ->join('esc_estado_civil', 'esc_id = epp_id_esc','left')
            ->join('epm_especialidad_medica', 'epm_id = epp_id_epm','left')
            ->join('pat_parentesco', 'pat_id = epp_id_pat','left')
            ->join('tsr_tipo_sange', 'tsr_id = epp_id_tsr','left')
            ;
            if ($where) {
                $this->db->where($where);
            }

            return $q->get()->result_array();
        }

    /**
     * @author Marlon Olmedo
     * @since 2019-09-18
     * @return Obtener información sobre los seguro (tabla: sep_seguro_paciente)
     */
    public function get_seguro_paciente($where = null) {
        $q = $this->db->select()
        ->from('sep_seguro_paciente')
        ->join('epp_expediente_paciente','sep_id_epp = epp_id')
        ->join('pol_poliza', 'pol_id = sep_id_pol','left')
        ->join('ase_aseguradora', 'ase_id = pol_id_ase','left')
        ;
        if ($where) {
            $this->db->where($where);
        }
        
        return $q->get()->result_array();
    }

    /**
     * @author Marlon Olmedo
     * @since 2019-09-18
     * @return Obtener información sobre los contacto (tabla: cpt_contacto_paciente)
     */
    public function get_contacto_paciente($where = null) {
        $q = $this->db->select()
        ->from('cpt_contacto_paciente')
        ->join('tit_tipo_telefono', 'tit_id = cpt_id_tit','left')
        ;
        if ($where) {
            $this->db->where($where);
        }
        
        return $q->get()->result_array();
    }

    /**
        * @author Marlon Olmedo
        * @since 2019-09-18
        * @return Obtener información sobre los docuemntos (tabla: dop_documento_paciente)
    */
    public function get_documento($where = null) {
        $q = $this->db->select()
        ->from('dop_documento_paciente')
        ->join('tde_tipo_documento', 'tde_id = dop_id_tde','left')
        ;
        if ($where) {
            $this->db->where($where);
        }
        
        return $q->get()->result_array();
    }

    public function get_clientes($where = null, $like = null){
        $query = $this->db->select("cli_id as cliente, CASE WHEN cli_personeria = 1 THEN CONCAT(IFNULL(cli_codigo,''),' - ',IFNULL(cli_nombre,''), ' ', IFNULL(cli_apellido,''))
            ELSE CONCAT(IFNULL(cli_codigo,''),' - ',IFNULL(cli_apellido,'') ) END as cliente_nombre", false)
        ->from('cli_cliente');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($like != null) {
            $this->db->like($like);
        }
        return $query->get()->result_array();
    }

    /**
        * @author Francisco Orozco
        * @since 2019-09-27
        * @return Obtener información sobre el procidimiento quirugico(tabla: pgp_programacion_procedimiento)
    */
    public function get_procedimiento_quirurgico($where = null, $grou_by = null){
        $query = $this->db->select('*, CONCAT(epp_numero_expediente,"-",epp_nombre) as nombre_paciente,
            (SELECT med_nombre FROM med_medico WHERE med_id = pgp_id_med) as nombre_medico,
            (SELECT med_nombre FROM med_medico WHERE med_id = pgp_id_med_anestesia) as nombre_anestecia,
            (SELECT med_nombre FROM med_medico WHERE med_id = pgp_id_med_ayudante) as nombre_ayudante',false)
        ->from('pgp_programacion_procedimiento')
        ->join('epp_expediente_paciente', 'epp_id = pgp_id_epp','INNER')                               
        ->join('cli_cliente', 'cli_id = epp_id_cli','INNER')
        ->join('pcm_procedimiento_medico', 'pcm_id = pgp_id_pcm','LEFT')         
        ->join('epm_especialidad_medica','pgp_id_epm = epm_id','left')
        ; 

        if ($where != null) {
            $this->db->where($where);
        }  

        if ($grou_by != null) {
            $this->db->group_by($grou_by);
        }  

        return $query->get()->result_array();
    }

    public function get_archivos_aseguradora($id)
    {
        $this->db->select('frm_id,frm_nombre,frm_descripcion,frm_archivo');
        $this->db->from('frm_formulario_medico');
        $this->db->where('frm_id_ase', $id);
        $this->db->where('frm_activo', 1);
        $query = $this->db->get();

        return $query->result();
    }

    public function delete_formato($id)
    {
        $this->db->where('frm_id', $id);
        $this->db->update('frm_formulario_medico', array('frm_activo' => 0));
        return $this->db->affected_rows();

    }

    public function get_url_archivo($id)
    {
      $this->db->select('frm_archivo');
      $this->db->from('frm_formulario_medico');
      $this->db->where('frm_id', $id);
      $query = $this->db->get();

      return $query->row();
      
  }


    public function clasificacion_paciente($where = null)
    {
        $date = date('Y-m-d H:i:s');
        $query = $this->db->select("
            epp_numero_expediente,
            epp_nombre,
            epp_apellido,
            gen_nombre,
            clp_id,
            clp_estado_consulta,
            clp_es_referido,
            clp_id_cnm,
            clp_id_tcm,
            mem_id,
            mem_motivo,
            clp_detalle_emergencia,
            tcm_nombre,
            cle_color,
            cle_nivel,
            cle_id,
            suc_id,
            IF(epp_fecha_nacimiento IS NULL, 
               '', 
               FLOOR(DATEDIFF(CURDATE(), epp_fecha_nacimiento) / 365)
            ) AS edad,  
            DATE( clp_fecha ) AS fecha_emergencia,
            DATE_FORMAT( clp_fecha, '%r' ) AS hora_emergencia,
            cle_nombre,
            cle_tiempo,
            (SELECT COUNT(*) FROM cxc_clasificacion_pacientexconsultorio WHERE cxc_id_clp = clp_id AND cxc_estado = 1) as consultorioAsignado,            
            (SELECT cxc_id_con FROM cxc_clasificacion_pacientexconsultorio WHERE cxc_id_clp = clp_id AND cxc_estado = 1 LIMIT 1) as idConsultorioAsignado,            
            CASE
                WHEN clp_estado_consulta = 1 THEN
                'En espera' 
                WHEN clp_estado_consulta = 2 THEN
                'En consulta' 
                WHEN clp_estado_consulta = 3 THEN
                'Despachado' 
            END AS estado_consulta,
            CASE 
                WHEN FLOOR(TIMESTAMPDIFF(MINUTE, clp_fecha, '$date') / 60) = 0 THEN 
                    CONCAT(TIMESTAMPDIFF(MINUTE, clp_fecha, '$date') % 60, ' minutos')
                ELSE 
                    CONCAT(
                        FLOOR(TIMESTAMPDIFF(MINUTE, clp_fecha, '$date') / 60), ' horas, ', 
                        TIMESTAMPDIFF(MINUTE, clp_fecha, '$date') % 60, ' minutos'
                    )
            END AS tiempo_espera           
            ", false)
            ->from('clp_clasificacion_paciente')
            ->join('epp_expediente_paciente', 'clp_id_epp = epp_id', 'INNER')
            ->join('suc_sucursal', 'suc_id = clp_id_suc', 'INNER')
            ->join('cle_clasificacion_emergencia', 'cle_id = clp_id_cle', 'INNER')
            ->join('tcm_tipo_consulta_medica', 'tcm_id = clp_id_tcm', 'INNER')
            ->join('mem_motivo_emergencia', 'mem_id = clp_id_mem', 'LEFT')
            ->join('gen_genero', 'gen_id = epp_id_gen', 'INNER')
            ->order_by('cle_nivel', 'asc')
            ->order_by('clp_fecha', 'asc');

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    } 

    function articulo_like($where = null, $bodega = 0)
    {
        $q = $this->db->select("*, , IFNULL((SELECT SUM(sar_cant_actual) FROM sar_saldo_articulo WHERE sar_id_art = art_id AND sar_id_bod = $bodega),'') AS saldo, 
            IFNULL((SELECT mep_nombre FROM cva_conversion_articulo JOIN mep_medida_producto ON mep_id = cva_id_mep WHERE cva_id_art = art_id AND cva_defecto = 1 AND cva_estado = 1),'') AS medida", false)
            ->from('art_articulo');
        if ($where) {
            $this->db->where($where);
        }
        return $q->get()->result_array();
    }

    public function consultar_turnos_pacientes($where = null)
    {
        $query = $this->db->select("
            CONCAT( COALESCE(epp_numero_expediente, ''), '-', COALESCE(epp_nombre, ''), ' ', COALESCE(epp_apellido, '')) 
            AS nombre_paciente,
            con_nombre,
            clp_estado_consulta        
        ", false)
            ->from('con_consultorio')
            ->join('cxc_clasificacion_pacientexconsultorio', 'cxc_id_con = con_id')
            ->join('clp_clasificacion_paciente', 'clp_id = cxc_id_clp')
            ->join('epp_expediente_paciente', 'epp_id = clp_id_epp');

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }    

}