<?php
class Marcacion_model extends CI_Model
{
	function __construct()
    {
        parent::__construct();
    }

    // Esta es la funcion Original
    
    public function get_reporte_marcacion($where = null) {
        $this->db->select('*, (SELECT hxe_hora_inicio FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha) = DATE(mar_fecha_entrada) AND hxe_estado = 2 
            AND hxe_id_thf IS NOT NULL LIMIT 1) AS inicia_permiso, (SELECT hxe_hora_fin FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha_fin) = DATE(mar_fecha_salida) 
            AND hxe_estado = 2 AND hxe_id_thf IS NOT NULL LIMIT 1) AS termina_permiso, (SELECT hxe_id FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND hxe_estado = 2 
            AND hxe_id_thf IS NOT NULL AND (DATE(mar_fecha_entrada) >= DATE(hxe_fecha) AND DATE(mar_fecha_salida) <= DATE(hxe_fecha_fin)) LIMIT 1) AS id_permiso', false)
           ->from('mar_marcacion')
           ->join('dxt_detallexturno', 'dxt_id = mar_id_dxt')
           ->join('tur_turno', 'tur_id = dxt_id_tur')
           ->join('deh_detalle_horario', 'deh_id = dxt_id_deh') // Aniadido para Horas Extras.
           ->join('emp_empleado', 'emp_id = mar_id_emp')
           ->join('are_area', 'emp_id_are = are_id', 'left')
           ->join('txe_turnoxempleado', 'txe_id_emp = emp_id AND txe_id_tur = tur_id')
           ->join('tiu_tipo_turno', 'tiu_id = txe_id_tiu', 'left')
           ->join('che_configuracion_hora_extra', 'che_id_tur = tur_id', 'left') // Aniadido para Horas Extras.
           ->group_by('mar_id')
        ;
        if($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }
    
     /*Temporalmente mientras se crea en procesos*/
     public function get_reporte_marcacion2($where) {
       $this->db->select('*, (SELECT hxe_hora_inicio FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha) = DATE(mar_fecha_entrada) AND hxe_estado = 2
          AND hxe_id_thf IS NOT NULL LIMIT 1) AS inicia_permiso,
          (SELECT hxe_hora_fin FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha_fin) = DATE(mar_fecha_salida) AND hxe_estado = 2 
          AND hxe_id_thf IS NOT NULL LIMIT 1) AS termina_permiso,
          (SELECT hxe_id FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND hxe_estado = 2 AND hxe_id_thf IS NOT NULL
          AND (DATE(mar_fecha_entrada) >= DATE(hxe_fecha) AND DATE(mar_fecha_salida) <= DATE(hxe_fecha_fin)) LIMIT 1) AS id_permiso 
        ', false)
       ->from('mar_marcacion')
       ->join('emp_empleado','emp_id=mar_id_emp')
       ->join('dxt_detallexturno','dxt_id=mar_id_dxt', 'left')
       ->join('deh_detalle_horario','deh_id=dxt_id_deh', 'left')
       ->join('tur_turno','tur_id=dxt_id_tur', 'left')
       ->join('txe_turnoxempleado','txe_id_emp = emp_id','left')
       ->join('tiu_tipo_turno', 'tiu_id = txe_id_tiu','left')
       ->join('che_configuracion_hora_extra','che_id_tur=tur_id',"left")
       ->join('are_area','emp_id_are=are_id','left')
       ->group_by('mar_id');
       if($where) {
         $this->db->where($where);
       }
       return $this->db->get()->result_array();
     }

     public function get_marcacion_area($where = null, $group_by = null) {
        $this->db->select('*, MIN(mar_hora_entrada) AS mar_hora_entrada, MAX(mar_hora_salida) AS mar_hora_salida, (SELECT MIN(hxe_hora_inicio) FROM hxe_hora_extraxempleado 
          WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha) =  DATE(mar_fecha_entrada) AND hxe_estado = 2 AND hxe_id_thf IS NOT NULL) AS inicia_permiso, (SELECT MAX(hxe_hora_fin) 
          FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha_fin) =  DATE(mar_fecha_salida) AND hxe_estado = 2 AND hxe_id_thf IS NOT NULL) AS termina_permiso,
          (SELECT hxe_id FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND hxe_estado = 2 AND hxe_id_thf IS NOT NULL AND (DATE(mar_fecha_entrada) >= DATE(hxe_fecha)
          AND DATE(mar_fecha_salida) <= DATE(hxe_fecha_fin)) LIMIT 1) AS id_permiso 
          ', false)
            ->from('mar_marcacion')
            ->join('emp_empleado','emp_id = mar_id_emp')
            ->join('are_area','are_id = emp_id_are')
            ->join('dxt_detallexturno','dxt_id = mar_id_dxt')
            ->join('deh_detalle_horario','deh_id = dxt_id_deh')
            ->join('che_configuracion_hora_extra', 'che_id_tur = dxt_id_tur', 'left')       
        ;
        if($where != null) {
            $this->db->where($where);
        }
        if ($group_by != null) {
          $this->db->group_by($group_by);
        }
        return $this->db->get()->result_array();
    }

    public function get_tiempo_gratis($where) {
      $this->db->select()
        ->from('tur_turno')
        ->join('cot_configuracion_turno','cot_id_tur=tur_id');
        if($where){
          $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_datos_permiso($where = null) {
      $this->db->select('thf_nombre, (SELECT CONCAT(emp_codigo," - ",emp_nombre," ",emp_apellido) FROM emp_empleado WHERE emp_id = hxe_id_emp) AS empleado, 
          (SELECT IF(ISNULL(emp_id), username, CONCAT(emp_nombre," ",emp_apellido)) FROM users LEFT JOIN emp_empleado ON emp_id = usu_id_emp WHERE id = hxe_id_usu_autoriza) AS user_autoriza, 
          hxe_fecha, hxe_fecha_fin, hxe_hora_inicio, hxe_hora_fin, hxe_observacion, hxe_observacion_revision, thf_id_tdc, hxe_estado', false)
        ->from('hxe_hora_extraxempleado')
        ->join('thf_tipo_hora_faltante', 'thf_id = hxe_id_thf')
        ->where('hxe_id_thf IS NOT NULL')
      ;
      if($where){
        $this->db->where($where);
      }
      return $this->db->get()->result_array();
    }

    public function get_incid_marc($where = null) {
      $this->db->select("emp_id, emp_codigo, emp_nombre, emp_apellido, SUM(mar_entrada_tarde) AS min_tarde, SUM(IF(mar_entrada_tarde > 0,1,0)) AS eventos", false)
        ->from('mar_marcacion')
        ->join('emp_empleado','emp_id = mar_id_emp')
        ->group_by('emp_id')
      ;
      if($where){
        $this->db->where($where);
      }
      return $this->db->get()->result_array();
    }

    public function get_empleados_turnados($where = null) {
      $this->db->select("emp_id, emp_codigo, emp_nombre, emp_apellido, tur_nombre, COUNT(DISTINCT txe_id_tur) AS ctdad, IFNULL(DATE_FORMAT(MIN(txe_desde),'%d-%m-%Y'), '--') AS desde,
          IF((ISNULL(DATE_FORMAT(MAX(txe_hasta), '%d-%m-%Y')) OR IFNULL(SUM(txe_indefinido), 0) > 0), 'Indefinido', DATE_FORMAT(MAX(txe_hasta), '%d-%m-%Y')) AS hasta", false)
        ->from('emp_empleado')
        ->join('txe_turnoxempleado', 'txe_id_emp = emp_id AND txe_estado > 0', 'LEFT')
        ->join('tur_turno', 'tur_id = txe_id_tur', 'LEFT')
        ->group_by('emp_id');
        if($where){
          $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_tiempo_descuento($where) {
      $this->db->select()
        ->from('tur_turno')
        ->join('cat_configuracion_accion_turno','cat_id_tur=tur_id');
        if($where){
          $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_horas_extras($where) {
      $this->db->select()
        ->from('tur_turno')
        ->join('che_configuracion_hora_extra','che_id_tur=tur_id');
        if($where){
          $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function hora_a_minutos($hora){
        $array = explode(':', $hora);

        // Asegurarse de que cada índice exista
        $h = isset($array[0]) ? intval($array[0]) : 0;
        $m = isset($array[1]) ? intval($array[1]) : 0;
        $s = isset($array[2]) ? intval($array[2]) : 0;

        // Convertir todo a minutos
        $h_min = ($h * 60) + $m + ($s / 60);

        return $h_min;
    }

    /**
     * Descripción:
     * Función para obtención de marcaciones
     * @author René Castaneda - Grupo satélite
     * @since  2021-09-06
     * @param  $desde date 
     * @param  $hasta date 
     * @return array query
     */
    public function get_marcacion_emp($desde=null, $hasta=null) {
        $q = $this->db->query("
            SELECT M.emp_id, M.emp_codigo, M.emp_nombre, M.emp_apellido, M.emp_salario, M.eventos_doble_entradas, M.eventos_doble_salidas,
            FLOOR(SUM(IF((M.permiso_completo_entrada = 0 AND M.permiso_completo_salida = 0),M.minutos_entrada_tarde,0)  )) entrada_tarde,
            FLOOR(SUM(IF((M.permiso_completo_entrada = 0 AND M.permiso_completo_salida = 0),M.minutos_salida_temprano,0) )) salida_temprano,
            FLOOR(SUM(IF((M.permiso_completo_entrada = 0 AND M.permiso_completo_salida = 0),M.ausencias,0))) injustificado,
            SUM(IF(M.minutos_entrada_tarde > 0 AND (M.permiso_completo_entrada = 0 AND M.permiso_completo_salida = 0),1,0)) n_llegada_tarde, 
            SUM(IF(M.minutos_salida_temprano > 0  AND (M.permiso_completo_entrada = 0 AND M.permiso_completo_salida = 0),1,0)) n_salida_temprano
            FROM (
                SELECT  mar_id, emp_id, emp_codigo, emp_nombre,emp_apellido,emp_salario, tur_id, tur_nombre, mar_id_dxt,
                DATE(mar_fecha_entrada) mar_fecha_entrada, mar_hora_entrada,
                DATE(mar_fecha_salida) mar_fecha_salida, mar_hora_salida,
                IFNULL(( 
                   SELECT hxe_id FROM hxe_hora_extraxempleado 
                   WHERE  hxe_id_emp = mar_id_emp AND DATE(mar_fecha_entrada) BETWEEN DATE(hxe_fecha) AND DATE(IFNULL(hxe_fecha_fin,hxe_fecha))
                   AND DATE(mar_fecha_entrada) !=  DATE(hxe_fecha)
                   AND hxe_id_thf IS NOT NULL LIMIT 1
                   ),0) permiso_completo_entrada,
                IFNULL(( 
                   SELECT hxe_id FROM hxe_hora_extraxempleado 
                   WHERE hxe_id_emp = mar_id_emp AND DATE(mar_fecha_entrada) BETWEEN DATE(hxe_fecha) AND DATE(IFNULL(hxe_fecha_fin,hxe_fecha))
                   AND DATE(mar_fecha_salida) !=  DATE(IFNULL(hxe_fecha_fin,hxe_fecha))
                   AND hxe_id_thf IS NOT NULL LIMIT 1
                   ),0) permiso_completo_salida,
                /*
                (IF(
                    (FLOOR((TIME_TO_SEC(TIMEDIFF(mar_hora_entrada,deh_hora_entrada))/60))
                        - IFNULL((SELECT (cot_minutos - (cot_minutos - IFNULL(cot_inicio_calculo, cot_minutos))) FROM cot_configuracion_turno 
                            WHERE cot_id_tur = tur_id AND cot_tipo = 1 AND cot_estado = 1 LIMIT 1),0)
                        - IFNULL((SELECT TIME_TO_SEC(TIMEDIFF(hxe_hora_fin,deh_hora_entrada))/60 FROM hxe_hora_extraxempleado
                            WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha) = DATE(mar_fecha_entrada) AND hxe_hora_inicio <= deh_hora_entrada AND hxe_estado = 2
                            AND hxe_id_thf IS NOT NULL LIMIT 1),0)) > 0,
                    (FLOOR((TIME_TO_SEC(TIMEDIFF(mar_hora_entrada,deh_hora_entrada))/60)) 
                        - IFNULL((SELECT (cot_minutos - (cot_minutos - IFNULL(cot_inicio_calculo, cot_minutos))) FROM cot_configuracion_turno 
                            WHERE cot_id_tur = tur_id AND cot_tipo = 1 AND cot_estado = 1 LIMIT 1),0)
                        - IFNULL((SELECT TIME_TO_SEC(TIMEDIFF(hxe_hora_fin,deh_hora_entrada))/60 FROM hxe_hora_extraxempleado
                            WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha) = DATE(mar_fecha_entrada) AND hxe_hora_inicio <= deh_hora_entrada
                            AND hxe_estado = 2 AND hxe_id_thf IS NOT NULL LIMIT 1),0)
                        ) ,
                    0)
                ) minutos_entrada_tarde,
                */
                IF(ISNULL(mar_hora_entrada), 
                    IF(IFNULL((SELECT hxe_id FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND hxe_estado = 2 AND hxe_id_thf IS NOT NULL AND (DATE(hxe_fecha) <= DATE(mar_fecha_entrada) AND DATE(hxe_fecha_fin) >= DATE(mar_fecha_salida))), 0) > 0, 0, IFNULL((SELECT cat_minutos FROM cat_configuracion_accion_turno WHERE cat_estado = 1 AND cat_id_tur = tur_id AND cat_tipo = 1), 0)),    
                    (IF((FLOOR((TIME_TO_SEC(TIMEDIFF(mar_hora_entrada,deh_hora_entrada))/60)) - IFNULL((SELECT cot_minutos FROM cot_configuracion_turno WHERE cot_id_tur = tur_id AND cot_tipo = 1 AND cot_estado = 1 LIMIT 1),0) - IFNULL((SELECT TIME_TO_SEC(TIMEDIFF(hxe_hora_fin,deh_hora_entrada))/60 FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha) = DATE(mar_fecha_entrada) AND hxe_hora_inicio <= deh_hora_entrada AND hxe_estado=2 AND hxe_id_thf IS NOT NULL LIMIT 1),0)) > 0, (FLOOR((TIME_TO_SEC(TIMEDIFF(mar_hora_entrada,deh_hora_entrada))/60)) - IFNULL((SELECT (cot_minutos - (cot_minutos - IFNULL(cot_inicio_calculo, cot_minutos))) FROM cot_configuracion_turno WHERE cot_id_tur = tur_id AND cot_tipo = 1 AND cot_estado = 1 LIMIT 1),0) - IFNULL((SELECT TIME_TO_SEC(TIMEDIFF(hxe_hora_fin,deh_hora_entrada))/60 FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha) = DATE(mar_fecha_entrada) AND hxe_hora_inicio <=deh_hora_entrada AND hxe_estado=2 AND hxe_id_thf IS NOT NULL LIMIT 1),0)), 0))
                ) minutos_entrada_tarde, 
                (IF(CEIL((TIME_TO_SEC(TIMEDIFF(deh_hora_entrada,mar_hora_entrada))/60)) >0,
                    CEIL((TIME_TO_SEC(TIMEDIFF(deh_hora_entrada,mar_hora_entrada))/60)),
                    0)
                ) minutos_entrada_temprano,
                /*
                (IF(
                    (CEIL((TIME_TO_SEC(TIMEDIFF(deh_hora_salida,mar_hora_salida))/60))
                        - IFNULL((SELECT (cot_minutos - (cot_minutos - IFNULL(cot_inicio_calculo, cot_minutos))) FROM cot_configuracion_turno 
                            WHERE cot_id_tur = tur_id AND cot_tipo = 2 AND cot_estado = 1 LIMIT 1),0)
                        - IFNULL((SELECT TIME_TO_SEC(TIMEDIFF(deh_hora_salida,hxe_hora_inicio))/60 FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp 
                            AND DATE(hxe_fecha_fin) = DATE(mar_fecha_salida)  AND hxe_hora_fin >= deh_hora_salida AND hxe_estado = 2 
                            AND hxe_id_thf IS NOT NULL LIMIT 1),0)) >0,
                    (CEIL((TIME_TO_SEC(TIMEDIFF(deh_hora_salida,mar_hora_salida))/60))
                        - IFNULL((SELECT (cot_minutos - (cot_minutos - IFNULL(cot_inicio_calculo, cot_minutos))) FROM cot_configuracion_turno 
                            WHERE cot_id_tur = tur_id AND cot_tipo = 2 AND cot_estado = 1 LIMIT 1),0)
                        - IFNULL((SELECT TIME_TO_SEC(TIMEDIFF(deh_hora_salida,hxe_hora_inicio))/60 FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp 
                            AND DATE(hxe_fecha_fin) = DATE(mar_fecha_salida) AND hxe_hora_fin >= deh_hora_salida AND hxe_estado = 2 
                            AND hxe_id_thf IS NOT NULL LIMIT 1),0)
                        ),
                    0)
                ) minutos_salida_temprano,
                */
                IF(ISNULL(mar_hora_salida), 
                    IF(IFNULL((SELECT hxe_id FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND hxe_estado = 2 AND hxe_id_thf IS NOT NULL AND (DATE(hxe_fecha) <= DATE(mar_fecha_entrada) AND DATE(hxe_fecha_fin) >= DATE(mar_fecha_salida))), 0) > 0, 0,   
                        IFNULL((SELECT cat_minutos FROM cat_configuracion_accion_turno WHERE cat_estado = 1 AND cat_id_tur = tur_id AND cat_tipo = 2), 0)), 
                    (IF((CEIL((TIME_TO_SEC(TIMEDIFF(deh_hora_salida,mar_hora_salida))/60)) - IFNULL((SELECT cot_minutos FROM cot_configuracion_turno WHERE cot_id_tur = tur_id AND cot_tipo = 2 AND cot_estado = 1 LIMIT 1),0) - IFNULL((SELECT TIME_TO_SEC(TIMEDIFF(deh_hora_salida,hxe_hora_inicio))/60 FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha_fin) = DATE(mar_fecha_salida)  AND hxe_hora_fin >= deh_hora_salida AND hxe_estado = 2 AND hxe_id_thf IS NOT NULL LIMIT 1),0)) >0, (CEIL((TIME_TO_SEC(TIMEDIFF(deh_hora_salida,mar_hora_salida))/60)) - IFNULL((SELECT (cot_minutos - (cot_minutos - IFNULL(cot_inicio_calculo, cot_minutos))) FROM cot_configuracion_turno WHERE cot_id_tur = tur_id AND cot_tipo = 2 AND cot_estado = 1 LIMIT 1),0) - IFNULL((SELECT TIME_TO_SEC(TIMEDIFF(deh_hora_salida,hxe_hora_inicio))/60 FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha_fin) = DATE(mar_fecha_salida) AND hxe_hora_fin >= deh_hora_salida AND hxe_estado = 2 AND hxe_id_thf IS NOT NULL LIMIT 1),0) ), 0))
                ) minutos_salida_temprano,
                (IF(FLOOR((TIME_TO_SEC(TIMEDIFF(mar_hora_salida,deh_hora_salida))/60)) >0,
                    FLOOR((TIME_TO_SEC(TIMEDIFF(mar_hora_salida,deh_hora_salida))/60)),
                    0)
                ) minutos_salida_tarde,
                (IF(ISNULL(mar_hora_entrada) AND ISNULL(mar_hora_salida), IF(IFNULL((SELECT hxe_id FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND hxe_estado = 2 AND hxe_id_thf IS NOT NULL AND (DATE(hxe_fecha) <= DATE(mar_fecha_entrada) AND DATE(hxe_fecha_fin) >= DATE(mar_fecha_salida))), 0) > 0, 0, (IFNULL((SELECT cat_minutos FROM cat_configuracion_accion_turno WHERE cat_estado = 1 AND cat_id_tur = tur_id AND cat_tipo = 1), 0) + IFNULL((SELECT cat_minutos FROM cat_configuracion_accion_turno WHERE cat_estado = 1 AND cat_id_tur = tur_id AND cat_tipo = 2),0))), 0)) AS ausencias,
                IFNULL((SELECT cot_minutos FROM cot_configuracion_turno WHERE cot_id_tur = tur_id AND cot_tipo = 1 AND cot_estado = 1 LIMIT 1),0) compensacion_entrada_tarde,
                IFNULL((SELECT cot_minutos FROM cot_configuracion_turno WHERE cot_id_tur = tur_id AND cot_tipo = 2 AND cot_estado = 1 LIMIT 1),0) compensacion_salida_temprano,
                (SELECT cot_eventos_doble FROM cot_configuracion_turno WHERE cot_id_tur = tur_id AND cot_tipo = 1 AND cot_estado = 1 LIMIT 1) AS eventos_doble_entradas,
                (SELECT cot_eventos_doble FROM cot_configuracion_turno WHERE cot_id_tur = tur_id AND cot_tipo = 2 AND cot_estado = 1 LIMIT 1) AS eventos_doble_salidas,
                (SELECT hxe_hora_inicio FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha) = DATE(mar_fecha_entrada) AND hxe_estado = 2
                    AND hxe_id_thf IS NOT NULL LIMIT 1) AS inicia_permiso,
                (SELECT hxe_hora_fin FROM hxe_hora_extraxempleado WHERE hxe_id_emp = mar_id_emp AND DATE(hxe_fecha_fin) = DATE(mar_fecha_salida) AND hxe_estado = 2 
                    AND hxe_id_thf IS NOT NULL LIMIT 1) AS termina_permiso
                FROM mar_marcacion
                JOIN emp_empleado ON emp_id = mar_id_emp
                JOIN dxt_detallexturno on dxt_id = mar_id_dxt
                JOIN tur_turno on tur_id = dxt_id_tur
                JOIN deh_detalle_horario on deh_id = dxt_id_deh and deh_estado = 1
                WHERE 
                DATE(mar_fecha_entrada) BETWEEN '$desde' AND '$hasta'
                /* and emp_id in 103 /* ////////////////////////////////////////////////////////////////////////////////////// */
                GROUP BY mar_id
            ) M
            GROUP BY M.emp_id
            ;
            ")->result_array();      
        ;
        return $q;
    }
    
    public function marcacionesxturno($codigo){
        try {
            $query = $this->db->query("SELECT * FROM emp_empleado emp
               JOIN txe_turnoxempleado txe ON txe.txe_id_emp = emp.emp_id
               WHERE emp.emp_codigo = '$codigo' AND txe.txe_estado = 1");
            $query = $query->result();
            return $query;
        } catch (Exception $e) {
        }
    }
   
   public function verificarTurnoEmpleado($emp_id){
      try {
      $query = $this->db->query("
         SELECT * FROM emp_empleado emp
         JOIN txe_turnoxempleado txe ON txe.txe_id_emp = emp.emp_id
         /*JOIN deh_detalle_horario deh ON deh.deh_id = emp.emp_id*/
         WHERE emp.emp_id = $emp_id 
         AND txe.txe_estado = 1 
      ");
      $query = $query->result();
         return $query;
      } catch (Exception $e) {
    }
   }

    public function obtener_permisos_dia($empleado_id, $fecha) {

        // Traer todos los permisos del empleado ordenados por inicio
        $this->db->select('hxe_hora_inicio, hxe_hora_fin');
        $this->db->from('hxe_hora_extraxempleado');
        $this->db->where('hxe_id_emp', $empleado_id);
        $this->db->where('hxe_id_thf IS NOT NULL', NULL);
        $this->db->where('hxe_estado', 2);
        $this->db->where("DATE('{$fecha}') >= DATE(hxe_fecha) AND DATE('{$fecha}') <= DATE(hxe_fecha_fin)", NULL);
        $this->db->order_by('hxe_hora_inicio', 'ASC');
        $query = $this->db->get();
        $permisos = $query->result_array();

        if (empty($permisos)) {
            return [];
        }

        $fusionados = [];
        foreach ($permisos as $permiso) {
            $inicioMin = $this->hora_a_minutos($permiso['hxe_hora_inicio']);
            $finMin = $this->hora_a_minutos($permiso['hxe_hora_fin']);

            if (empty($fusionados)) {
                $fusionados[] = ['hxe_hora_inicio' => $inicioMin, 'hxe_hora_fin' => $finMin];
            } else {
                $ultimo = &$fusionados[count($fusionados) - 1];
                if ($inicioMin <= $ultimo['hxe_hora_fin']) {
                    $ultimo['hxe_hora_fin'] = max($ultimo['hxe_hora_fin'], $finMin);
                } else {
                    $fusionados[] = ['hxe_hora_inicio' => $inicioMin, 'hxe_hora_fin' => $finMin];
                }
            }
        }

        return $fusionados;
    }

    public function verificar_permiso_dia_completo($empleado_id, $fecha) {

        // Traer todos los permisos del empleado ordenados por inicio
        $this->db->select('hxe_hora_inicio, hxe_hora_fin, hxe_id');
        $this->db->from('hxe_hora_extraxempleado');
        $this->db->where('hxe_id_emp', $empleado_id);
        $this->db->where('hxe_id_thf IS NOT NULL', NULL);
        $this->db->where('hxe_hora_inicio', NULL);
        $this->db->where('hxe_hora_fin', NULL);
        $this->db->where('hxe_estado', 2);
        $this->db->where("DATE('{$fecha}') >= DATE(hxe_fecha) AND DATE('{$fecha}') <= DATE(hxe_fecha_fin)", NULL);
        $this->db->order_by('hxe_hora_inicio', 'ASC');
        $query = $this->db->get();

        $permiso = $query->result_array();
        return count($permiso) > 0;
    }    
}