<?php

class Landing_page_model extends CI_Model {

    public function __construct() {
        $this->load->database();
    }



    function load_directorio(){
        $query = $this->db->select("*")
                 ->from("emp_empleado")
                 ->join("txm_telefonoxempleado","txm_id_emp = emp_id","inner")
                 ->join("tel_telefono","txm_id_tel = tel_id","inner")
                 ->join("tit_tipo_telefono","tel_id_tit = tit_id","inner")
                 ->join("are_area","emp_id_are = are_id","inner")
                 ->join("plz_plaza","emp_id_plz = plz_id","inner")
                 ->where("tel_estado", 1)
                 ->where("tit_privacidad", 1)
                 ->order_by("tel_numero", "asc")
                 ->get()
                 ->result_array();

        return $query;
    }


function load_cumple_mes() {
    $query = $this->db->query("SELECT * 
                                FROM emp_empleado 
                                WHERE DATE_FORMAT(emp_fecha_nac, '%m') = DATE_FORMAT(NOW(), '%m') 
                                ORDER BY DATE_FORMAT(emp_fecha_nac, '%d') ASC;
                                ")
             ->result_array();

    return $query;
}


public function get_solo_padres($where = null, $id_empresa)
    {
        //preguntar por los padres
        $query = $this->db->select()
            ->from('are_area')
            ->where('are_estado', 1)
            ->order_by('are_id', 'ASC');

        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        $this->db->where('mxr_id_emr', $id_empresa); //Added by René Castaneda 02-03-2018

        if ($where != null) {
            $this->db->where($where);
        } else {
            $this->db->where('are_padre', null);
        }

        $resultado = $query->get()->result_array();

        return $resultado;
    }



function load_public_arch(){
     $query = $this->db->query("SELECT 
        uba_id,
        uba_ruta,
        uba_nombre,
        uba_nombre_clean
        from arh_archivo 
        INNER JOIN uba_ubicacion_archivo on arh_id_uba = uba_id
        INNER JOIN cxh_categoriaxarchivo on cxh_id_arh = arh_id
        INNER JOIN cag_categoria_gestion on cxh_id_cag = cag_id
        WHERE cag_publico = 1 and uba_estado = 1 GROUP BY uba_id")
        ->result_array();

    return $query;
}

function get_avisos() {

        $where = 'DATE(NOW()) BETWEEN DATE(avi_fecha_desde) AND DATE(avi_fecha_hasta) AND avi_estado = 1 AND avi_publico = 1';

        $query = $this->db->select("*")
                ->from('avi_aviso');

        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('avi_id');

        $resultado = $query->get()->result_array();
        
        foreach($resultado as &$aviso){
            $aviso['anexos'] = $this->gsatelite->get_tabla('ani_anexo_aviso', array('ani_id_avi' => $aviso['avi_id']));
        }
        return $resultado;
    }


function load_arch_x_uba($id) {
    $query = $this->db->query("
            SELECT 
                uba_nombre,
                arh_nombre,
                arh_descripcion,
                CONCAT(uba_ruta,'/',arh_url_archivo) as url,
                arh_size,
                date_format(arh_fecha, '%d-%m-%Y') as arh_fecha
                from arh_archivo 
                INNER JOIN uba_ubicacion_archivo on arh_id_uba = uba_id
                INNER JOIN cxh_categoriaxarchivo on cxh_id_arh = arh_id
                INNER JOIN cag_categoria_gestion on cxh_id_cag = cag_id
                WHERE 
                        cag_publico = 1 AND 
                        arh_estado = 1 AND
                        arh_id_uba = $id
            ")
            ->result_array();

    return $query;
}
















    public function crear_arbol($padre, $prefijo, $extra_where = null)
    {
        $cadena = "";
        if ($extra_where != null && count($extra_where) > 0) {
            $this->db->where($extra_where);
        }
        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        $this->db->where('mxr_id_emr', 1); //Added by René Castaneda 02-03-2018  
        $q = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1, 'are_padre' => $padre));
        if ($q) {
            $cadena .= "\n<ul>";
            foreach ($q as $fila) {
                //preguntar por la cantidad de empleados pertenecientes a cada area
                $n_empleados = $this->db->select("COUNT(emp_id_are) AS n", false)->from('emp_empleado')->where(array('emp_estado' => 1, 'emp_id_are' => $fila['are_id'], 'emp_id_emr' => 1))->get()->row_array();
                $n = ($n_empleados['n'] != 0) ? ' (<span class="n_empleados_area">' . $n_empleados['n'] . '</span>)' : '';
                //preguntar por los puestos
                $plazas = $this->plazas_area($fila['are_id']);
                /*
                $idplz = (trim($fila['are_id']) != '')? $fila['are_id']:'0';
                $n_empleados = $this->gsatelite->get_tabla('emp_empleado', array("emp_id_are in (".$idplz.")" => null));
                if (count($n_empleados) > 0) {  
                    $n_emp = '<hr style="margin-top:1px;margin-bottom:5px; border-color:black" /><div class="cotenedor_empleado_arbol">';
                    foreach ($n_empleados as $fe) {
                        $n_emp .= '- '.$fe['emp_nombre']." ".$fe['emp_apellido'].'<br />';
                    }
                    $n_emp .= '</div>';
                } else {
                    $n_emp = "";
                }
                // agregar el $n_emp.
                */
                $cadena .= "\n<li>" . $prefijo . $fila['are_nombre'] . $n . " <br />" . $plazas;
                $cadena .= $this->crear_arbol($fila['are_id'], $prefijo . $prefijo, $extra_where);
            }
            $cadena .= '</ul></li>';
        } else {
            $cadena .= "</i>";
        }
        return $cadena;
    }

    public function crear_arbol_plz($padre, $prefijo, $aplicar_where_in = null, $esJSON = false, $tipo_vista = 0)
    {
        $cadena = "";
        $q = $this->get_hijos_plaza_modificado($padre, $aplicar_where_in);
        if ($q) {
            if (isset($q[0]['plz_id']) > 0 and $q[0]['plz_id'] > 0) {
                $cadena .= ($esJSON) ? ', "children": [' : ', "children": [';
                foreach ($q as $fila) {
                    //preguntar por el empleado de la plaza

                    $idplz = (trim($fila['ids_plazas']) != '') ? $fila['ids_plazas'] : '0';
                    $n_empleados = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1, "emp_id_plz in (" . $idplz . ")" => null));
                    $empleado = (count($n_empleados) > 0) ? $n_empleados[0] : '';
                    $n = (count($n_empleados) > 0) ? ' <span class="totalEmp">[' . $fila['total'] . "]</span>" : '';
                    if ($esJSON) {
                        $n = (count($n_empleados) > 0) ? " [<span class='conteo_nplazas'>" . $fila['total'] . "</span>]" : '';
                    }

                    //Si el tipo de vista es para plazas Empleados
                    $n_emp = 'null';
                    if ($tipo_vista == 1) {
                        $n_emp = array();
                        if (count($n_empleados) > 0) {
                            foreach ($n_empleados as $fe) {
                                //$n_emp .= '- '.trim($fe['emp_nombre'])." ".trim($fe['emp_apellido']).'\r\n';
                                $n_emp[] = array('emp_nombre' => trim($fe['emp_nombre']) . " " . trim($fe['emp_apellido']));
                            }
                        }
                    }

                    $subtitulo = "null";
                    if (count($n_empleados) > 0 && $tipo_vista == 1) {
                        $subtitulo = array();
                        foreach ($n_empleados as $fe) {
                            $n_emp = $fe['emp_nombre'] . " " . $fe['emp_apellido'] . '<br>';
                            $subtitulo[] = array('emp_nombre' => $n_emp);
                        }
                    } else {
                        $subtitulo = "null";
                    }
                    $subtitulo = json_encode($subtitulo); //aqui van los nombres de los empleados


                    if ($esJSON) {
                        $tiene_dep = true;
                        if ($fila['plz_id_padre'] > 0 && $fila['plz_es_staff'] == 1) {
                            $tiene_dep = $this->gsatelite->get_tabla('plz_plaza', array('plz_id_padre' => $fila['plz_id_padre'], '(plz_es_staff !=1 or plz_es_staff IS NULL)' => null));
                        }
                        $tipo_area = ($fila['plz_es_staff'] == 1) ? (($tiene_dep) ? 'staff' : 'subordinate') : 'subordinate';
                        $extra_tipo = ($fila['plz_es_staff'] == 1) ? ', "subtype" : "dashed", "box_color" : "#a0cea7"' : '';
                        $cadena .= '{ "id": "plz_' . $fila['plz_id'] . '", "title": "' . $fila['plz_nombre'] . ' (' . count($n_empleados) . ')", "subtitle": ' . $subtitulo . ', "type":"' . $tipo_area . '"' . $extra_tipo;
                        $cadena .= $this->crear_arbol_plz($fila['plz_id'], $prefijo . $prefijo, $aplicar_where_in, $esJSON, $tipo_vista);
                    } else {
                        $cadena .= '<li>' . $prefijo . $fila['plz_nombre'] . $n . $n_emp;
                        $cadena .= $this->crear_arbol_plz($fila['plz_id'], $prefijo . $prefijo, $aplicar_where_in, $esJSON, $tipo_vista);
                    }
                }
                $cadena .= ($esJSON) ? '] },' : '';
            }
        } else {
            $cadena .= ($esJSON) ? "}," : "</i>";
        }
        return $cadena;
    }

    public function crear_arbol3($padre, $prefijo, $where)
    {
        $cadena = "";

        if ($where) {
            $this->db->where($where);
        }
        $this->db->order_by('are_nivel ASC, are_orden ASC');
        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        $this->db->where('mxr_id_emr', 1);
        $q = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1, 'are_padre' => $padre));
        // print_r($this->db->last_query());die();
        /*$q2 = $this->gsatelite->get_tabla('plz_plaza', array('plz_estado' => 1, 'plz_id_are' => $padre));
          $q = array_merge($q, $q2);     */
        if ($q) {
            $cadena .= "<ul>";
            foreach ($q as $fila) {
                //$cadena .= $prueba; 
                //preguntar por la cantidad de empleados pertenecientes a cada area
                $n_empleados = $this->db->select("COUNT(emp_id_are) AS n", false)->from('emp_empleado')->where(array('emp_estado' => 1, 'emp_id_are' => $fila['are_id'], 'emp_id_emr' => 1))->get()->row_array();
                $n = ($n_empleados['n'] != 0) ? ' (<span class="conteo_nplazas">' . $n_empleados['n'] . '</span>)' : '';
                //preguntar por los puestos
                $plazas = $this->plazas_area3($fila['are_id'], '', $where);

                $linea = "";
                if (trim($plazas) != "") {
                    $linea = '<hr style="margin-top:5px;margin-bottom:5px; border-color:black"><div style="display:block;border-top-style:none; width:120%; text-align:left;  border-top-width:2px; margin-top:5px; font-weight: bold; margin-right: 10px;"></div>';
                }
                $cadena .= '<li style="text-align:center;"><div style="font-weight:bold;">' . $prefijo . $fila['are_nombre'] . $n . "\n" . '<br /></div>' . $linea . $plazas;

                $cadena .= $this->crear_arbol3($fila['are_id'], $prefijo . $prefijo, $where);
            }
            $cadena .= "</ul></li>\n";
        } else {
            $cadena .= "</i>\n";
        }
        return $cadena;
    }

    public function plazas_area3($id_area, $devolver_array = false)
    {

        $query = $this->get_plazas_area(array('plz_id_are' => $id_area, 'plz_estado' => 1));
        //print_r($this->db->last_query());die();
        $nombre = array();
        $nombre_hijas = "";
        $cadena = "";
        $linea = '<hr style="margin-top:5px;margin-bottom:5px; border-color:black"><div style="display:block;border-top-style:none; width:120%; text-align:left;  border-top-width:2px; margin-top:5px; font-weight: bold; margin-right: 10px;"></div>';
        foreach ($query as $f) {
            $query_posee = $this->get_plazas_area(array('plz_id_are' => $id_area, 'plz_estado' => 1, 'plz_id_padre' => $f['plz_id']));
            $nombre[] = $f['plz_nombre'] . '(<span class="conteo_nplazas">' . $f['nplazas'] . '</span>)';
            $cadena .= '<div class="contenedor_plaza" style="text-align: left !important;white-space:nowrap;">';

            if ($query_posee)
                $cadena .= '<b>' . $f['plz_nombre'] . '(<span class="conteo_nplazas2">' . $f['nplazas'] . '</span>)' . '</b>';
            else
                $cadena .= $f['plz_nombre'] . '(<span class="conteo_nplazas2">' . $f['nplazas'] . '</span>)';

            $cadena .= $this->plazas_hijas($id_area, $f['plz_id'], '&nbsp;');
            $cadena .= '</div>' . $linea;
        }

        if ($devolver_array) {
            return $nombre;
        } else {
            //if (count($nombre) > 0) {


            //$cadena = '<div class="contenedor_plaza" >'. $nombre_hijas.'</div>';
            return $cadena;
            //} else {
            //return "";
            //}
        }
    }

    public function plazas_hijas($id_area, $plaza_padre, $prefijo, $ids = null)
    {
        $query = $this->get_plazas_area(array('plz_id_are' => $id_area, 'plz_estado' => 1, 'plz_id_padre' => $plaza_padre), $ids);
        //$query = $this->gsatelite->get_tabla('plz_plaza', array('plz_id_padre'=>$plaza_padre, 'plz_id_are'=>$id_area));
        $regresar = '';
        if ($ids != null) {
            //echo $this->db->last_query();die();
        }

        if (count($query) > 0) {

            foreach ($query as $key) {
                $regresar .= '<br>-' . $prefijo . $key['plz_nombre'] . '(<span class="conteo_nplazas2">' . $key['nplazas'] . '</span>)';
                $regresar .= $this->plazas_hijas($id_area, $key['plz_id'], $prefijo . $prefijo, $key['ids']);
            }
        } else {
            $regresar = "";
        }
        return $regresar;
    }

     public function get_plazas_area($where = null, $ids = null)
    {
        /*SELECT * FROM plz_plaza WHERE plz_id_are = 12
ORDER BY plz_id_cec, plz_id_pto
        SELECT *, COUNT(plz_nombre) FROM plz_plaza WHERE plz_id_are = 12
GROUP BY plz_nombre
*/
        $query = $this->db->select('*, COUNT(plz_nombre) as nplazas, group_concat(plz_id) as ids', false)
            ->from('plz_plaza')
            ->join('are_area', 'are_id = plz_id_are')
            ->join('emp_empleado', 'emp_id_plz = plz_id') //obligarlo que tenga empleado para ser mostrado
            ->join('mxr_empresaxarea', 'mxr_id_are = are_id')
            ->where('emp_estado', 1)
            ->where('mxr_id_emr', 1)
            ->group_by('plz_nombre')

            /*->order_by('plz_id_cec')
                        ->order_by('plz_id_pto')*/;


        if ($where != null && $ids == null) {
            $this->db->where($where);
        }
        if ($ids != null) {
            $this->db->where("plz_id_padre in (" . $ids . ")");
        }
        // $this->db->where('plz_id_emr', 1);
        return $query->get()->result_array();
    }

function get_hijos_plaza_modificado($padre, $where_in, $get_ids_plaza = 0)
    {

        $reg_padre = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $padre));

        $reg_padre_ids = $this->gsatelite->get_tabla('plz_plaza', array('plz_id_padre' => $reg_padre[0]['plz_id_padre'], 'plz_nombre' => $reg_padre[0]['plz_nombre']));

        $idss = array_column($reg_padre_ids, 'plz_id');
        //print_r($idss); die();

        $query = $this->db->select('*, COUNT(plz_id) AS total, group_concat(DISTINCT plz_id) AS ids_plazas')
            ->from('plz_plaza')
            ->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
            ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
            ->where('plz_estado', 1)
            ->where('mxr_id_emr', 1)
            ->where('plz_id_padre', $padre)
            ->where('plz_dibujar_organigrama', 1)
            //->where_in("plz_id_padre",$idss) //tomar los ids que se agruparon.
        ;

        if ($where_in != null and $where_in > 0) {
            $this->db->where("pto_id IN (SELECT pto_id FROM pto_puesto WHERE pto_id_tpt <= " . $where_in . ")", null);
        }

        $this->db->group_by('plz_nombre');
        $this->db->order_by('plz_id', 'asc');
        //preguntar si hay padres agrupados con hijos.
        $this->db->having('total >', 1);


        // die();
        $resultado = $query->get()->result_array();
        if ($get_ids_plaza != 0) {
            return $resultado[0]['ids_plazas'];
        }
        if (count($resultado) > 0) { //REPETIR LA QUERY PERO EN ESTA OCACIÓN NO AGRUPADA
            $incluirlo = array(0);
            foreach ($resultado as $fpadre) {
                $nhiijos = $this->db->select("COUNT(plz_id) AS total, GROUP_CONCAT(DISTINCT plz_id_padre) idpdres")->from('plz_plaza')->where("plz_id_padre in (" . $fpadre['ids_plazas'] . ")")->get()->result_array();
                if (count($nhiijos) > 0 && $nhiijos[0]['total'] > 0) {
                    $incluirlo[] = $nhiijos[0]['idpdres'];
                }
            }


            $query = $this->db->select('*, COUNT(plz_id) AS total, group_concat(DISTINCT plz_id) AS ids_plazas')
                ->from('plz_plaza')
                ->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
                ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
                ->where('plz_estado', 1)
                ->where('mxr_id_emr', 1)
                ->where('plz_id_padre', $padre)
                ->where('plz_dibujar_organigrama', 1)
                ->where("plz_plaza.plz_id not in (" . implode(',', $incluirlo) . ")", null, false)
                //->where_in("plz_id_padre",$idss) //tomar los ids que se agruparon.
            ;

            if ($where_in != null and $where_in > 0) {
                $this->db->where("pto_id IN (SELECT pto_id FROM pto_puesto WHERE pto_id_tpt <= " . $where_in . ")", null);
            }
            $this->db->group_by('plz_nombre');
            $this->db->order_by('plz_id', 'ASC');
            $resultado1 = $query->get()->result_array();

            $query = $this->db->select('*, COUNT(plz_id) AS total, group_concat(DISTINCT plz_id) AS ids_plazas')
                ->from('plz_plaza')
                ->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
                ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
                ->where('plz_estado', 1)
                ->where('plz_dibujar_organigrama', 1)
                ->where('mxr_id_emr', 1)
                ->where('plz_id_padre', $padre)
                ->where("plz_plaza.plz_id in (" . implode(',', $incluirlo) . ")", null, false)
                //->where_in("plz_id_padre",$idss) //tomar los ids que se agruparon.
            ;

            if ($where_in != null and $where_in > 0) {
                $this->db->where("pto_id IN (SELECT pto_id FROM pto_puesto WHERE pto_id_tpt <= " . $where_in . ")", null);
            }
            $this->db->group_by('plz_id');
            $this->db->order_by('plz_id', 'asc');
            $resultado2 = $query->get()->result_array();

            $resultado = array_merge($resultado1, $resultado2);
            //$resultado = array_sort($resultado, 'plz_nombre', SORT_ASC);

        } else {
            $query = $this->db->select('*, COUNT(plz_id) AS total, group_concat(DISTINCT plz_id) AS ids_plazas')
                ->from('plz_plaza')
                ->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
                ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
                ->where('plz_estado', 1)
                ->where('plz_dibujar_organigrama', 1)
                ->where('mxr_id_emr', 1)
                ->where('plz_id_padre', $padre)
                //->where_in("plz_id_padre",$idss) //tomar los ids que se agruparon.
            ;

            if ($where_in != null and $where_in > 0) {
                $this->db->where("pto_id IN (SELECT pto_id FROM pto_puesto WHERE pto_id_tpt <= " . $where_in . ")", null);
            }

            $this->db->group_by('plz_nombre');
            $this->db->order_by('plz_id', 'asc');
            $resultado = $query->get()->result_array();
        }

        return $resultado;
    }

}