<?php

class Inventario_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function crear_arbol($padre, $prefijo) {
        $prefijo = "";
        $cadena = "";
        // var_dump($padre);die();
        $q = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1, 'tia_padre' => $padre));
        if ($q) {

            foreach ($q as $fila) {
                $cadena .= $fila['tia_id'] . ',';
                $cadena .= $this->crear_arbol($fila['tia_id'], '');
            }
        }
        return $cadena;
    }

    public function contar_registros($dias) {
        $cadena = $this->db->query(
                //"SELECT COUNT(*) as productos from sar_saldo_articulo where sar_fecha_caducidad < ('".$fecha."');"
                "SELECT COUNT(*) as productos from sar_saldo_articulo where  DATEDIFF(sar_fecha_caducidad,NOW()) BETWEEN 1 AND " . $dias . ";"
        );
        return $cadena->result_array();
    }

    public function editar_requisicion($id_req) {
        $this->db->select()
                ->from('rxi_requisicion_inventario')
                ->join('bod_bodega', 'bod_id = rxi_id_bod')
                ->where('rxi_id', $id_req)
        ;
        $query = $this->db->get()->result_array();
        return $query;
    }

    public function get_requisicion_detalle($where = null) {
        $this->db->select()
                ->from('dri_detalle_requisicion_inventario')
                ->join('art_articulo', 'art_id = dri_id_art', 'left')
                ->join('tia_tipo_articulo', 'art_id_tia = tia_id', 'left')
                ->join('cva_conversion_articulo', 'cva_id = dri_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
                ->join('act_activo_fijo', 'act_id = dri_id_act', 'left')
                ->join('tac_tipo_activofijo', 'act_id_tac = tac_id', 'left')
                ->join('axm_articulo_matxarticulo_ord', 'dri_id_axm = axm_id', 'left')
                ->join('rxi_requisicion_inventario', 'rxi_id = dri_id_rxi')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get()->result_array();
        return $query;
    }

    public function get_productos_a_vencer($tabla, $where = null) {
        if (!$tabla && !is_string($tabla)) {
            return null;
        }

        $this->db->select(
                '
                dee_fecha_caducidad sar_fecha_caducidad,
                (
                SUM(IF(tip_entrada=1,dee_cantidad,0))
                - SUM(IF(tip_salida=1,dee_cantidad,0))
                )   sar_cant_actual,
                art_nombre,
                art_codigo,
                art_fecha,
                mrp_nombre as marca,
                dee_codigo_lote as lote
                ',false)
                ->join('sar_saldo_articulo', 'sar_id = dee_id_sar')
                ->join('art_articulo', 'art_id = dee_id_art')
                ->join('moi_movimiento_inv', 'moi_id = dee_id_moi')
                ->join('tip_tipo_proceso', 'tip_id = moi_id_tip')
                ->join('mrp_marca_producto', 'mrp_id=art_id_mrp', 'left')
                ->where($where)
                ->where('sar_fecha_caducidad IS NOT NULL AND art_estado = 1')
                ->group_by('date(dee_fecha_caducidad), art_id')
        ;

        $query = $this->db->get("dee_detalle_mov")->result_array();
        return $query;
    }

    public function cantidad_minima() {
        $cadena = $this->db->query(
                "SELECT art_id, art_nombre, sar_id, sar_cant_actual, art_minimo  FROM art_articulo
			INNER JOIN sar_saldo_articulo ON sar_id_art = art_id AND sar_cant_actual > 0
			WHERE sar_saldo_articulo.sar_cant_actual <= art_articulo.art_minimo
			GROUP BY sar_id DESC
			LIMIT 1"
        );
        return $cadena->result_array();
    }

    public function artxcategorias($bodega, $padre, $tipo, $aplica_factura = false) {

        $categorias_final = $this->crear_arbol($padre, "");
        // $categorias_final=substr(($categorias_final), 0,-1);

        $categorias_final = $categorias_final . $padre;

        if ($padre == "null" || $padre == null) {
            $categorias_final = null;
        }
        if ($tipo == "entrada") {
            if ($categorias_final != null) {
                $producto = "SELECT * FROM art_articulo "
                        . "LEFT JOIN sar_saldo_articulo ON sar_id_art=art_id "
                        . "LEFT JOIN cva_conversion_articulo ON cva_id_art = art_id AND cva_defecto = 1 "
                        . "LEFT JOIN mep_medida_producto ON mep_id = cva_id_mep WHERE art_inventario = 1 AND art_id_tia IN (" . $categorias_final . ") GROUP BY art_id";
            } else {
                $producto = "SELECT * FROM art_articulo
                                LEFT JOIN sar_saldo_articulo ON sar_id_art=art_id
                                LEFT JOIN cva_conversion_articulo ON cva_id_art = art_id AND cva_defecto = 1
                                LEFT JOIN mep_medida_producto ON mep_id = cva_id_mep WHERE art_inventario = 1 GROUP BY art_id ";
            }
        } else if ($tipo == "salida") {
            $producto = "SELECT SUM(sar_cant_actual)  as sar_cant_actual,
                          (SELECT sar_precio FROM sar_saldo_articulo WHERE sar_id=(SELECT MAX(sar_id) FROM sar_saldo_articulo WHERE sar_id_art = art_id)) AS precio,
                          art_articulo.art_id,
                          art_articulo.art_nombre,
                          art_articulo.art_codigo
                          FROM    (   sar_saldo_articulo sar_saldo_articulo
                           INNER JOIN
                           bod_bodega bod_bodega
                           ON (sar_saldo_articulo.sar_id_bod = bod_bodega.bod_id))";

            $producto .= " INNER JOIN
                      art_articulo art_articulo
                      ON (sar_saldo_articulo.sar_id_art = art_articulo.art_id)
                      INNER JOIN tia_tipo_articulo
                      ON tia_tipo_articulo.tia_id = art_articulo.art_id_tia";

            if ($aplica_factura == true) {
                $producto .= "
                          INNER JOIN dee_detalle_mov ON (dee_id_sar = sar_saldo_articulo.sar_id)
                          INNER JOIN moi_movimiento_inv ON (moi_id = dee_id_moi)
                          INNER JOIN tip_tipo_proceso ON (moi_id_tip = tip_tipo_proceso.tip_id)
                        ";
            }

            if ($categorias_final != null) {
                $producto .= " WHERE bod_id = " . $bodega . " AND art_inventario=1 AND tia_id IN(" . $categorias_final . ") AND sar_cant_actual>0 ";

                if ($aplica_factura == true) {
                    $producto .= " AND tip_salida_fac=1 AND art_venta=1 ";
                }
                $producto .= " GROUP BY art_nombre,art_id,art_nombre";
            } else {
                $producto .= " WHERE bod_id = " . $bodega . " AND sar_cant_actual>0 AND art_inventario=1 ";

                if ($aplica_factura == true) {
                    $producto .= " AND tip_salida_fac=1 AND art_venta=1 ";
                }

                $producto .= " GROUP BY art_nombre,art_id,art_nombre";
            }
        }

        $producto_final = $this->db->query($producto)->result_array();
        //die(print_r($this->db->last_query()));
        return $producto_final;
    }

    public function usuarioxbodega() {
        $query = "SELECT uxb_id_usu , uxb_id_bod, bod_nombre,bod_id FROM uxb_usuarioxbodega
    INNER JOIN bod_bodega ON bod_id =uxb_id_bod
    WHERE uxb_id_usu = " . $this->tank_auth->get_user_id() . " AND bod_estado=1";
        $resultado = $this->db->query($query);
        return $resultado->result_array();
    }

    public function datos_bodega($bod_id) {
        $datos_bodega = $this->db->select()
                ->from('bod_bodega')
                ->where('bod_id', $bod_id)
                ->get()
                ->result_array();
        return $datos_bodega;
    }

    public function get_detalles_rxixbodega() {
        $query = "SELECT
                  art_foto AS foto,
                  art_codigo AS productos,
                  art_id AS art_id,
                  art_nombre AS nombre,
                  username AS usuario,
                  CONCAT_WS(' ',emp_nombre, emp_apellido)  AS empleado,
                  (
                    SELECT
                      SUM(sar_cant_actual)
                    FROM
                      sar_saldo_articulo
                    WHERE
                      sar_id_art = dri_id_art
                  ) AS cant_actual,
                  (
                    SELECT
                      SUM(dri_cantidad)
                    FROM
                      dri_detalle_requisicion_inventario
                    WHERE
                      sar_id_art = dri_id_art
                  ) AS cantidad
                FROM
                  rxi_requisicion_inventario
                INNER JOIN dri_detalle_requisicion_inventario ON dri_id_rxi = rxi_id
                INNER JOIN sar_saldo_articulo ON sar_id_art = dri_id_art
                INNER JOIN art_articulo ON art_id = dri_id_art
                INNER JOIN users ON id=rxi_id_usu_solicita
                LEFT JOIN  emp_empleado ON usu_id_emp=emp_id
                GROUP BY
                  productos";

        $detalle = $this->db->query($query)->result_array();
        return $detalle;
    }

    public function cantidad_requisicionesxbodega($id_art) {
        $query = "SELECT
                  suc_nombre AS sucursal,
                  suc_id AS suc_id,
                  IF(emp_nombre IS NOT NULL ,CONCAT_WS(' ',emp_nombre,emp_apellido),username) as solicitante,
                  SUM(dri_cantidad) AS cantxbodega
                FROM
                  dri_detalle_requisicion_inventario
                INNER JOIN rxi_requisicion_inventario ON rxi_id = dri_id_rxi
                INNER JOIN users ON id = rxi_id_usu_solicita
                INNER JOIN bod_bodega ON bod_id = rxi_id_bod
                INNER JOIN suc_sucursal ON suc_id=bod_id_suc
                LEFT JOIN emp_empleado ON usu_id_emp = emp_id
                WHERE dri_id_art =" . $id_art . "
                GROUP BY dri_id_rxi,id
            ";
        $detalle = $this->db->query($query)->result_array();
        return $detalle;
    }

    public function cargar_proveedor_activo() {
        $query = $this->db->select('prv_id,prv_nombre, prv_estado')
                ->from('prv_proveedor')
                ->where('prv_estado', 1)
                ->get();
        return $query->result_array();
    }

    function saldo_cero($where = null, $in = null, $group_by = null, $having = null) {
        $script = "art_id,art_codigo,art_nombre,art_foto,
            bod_nombre as bodegas,
        SUM(sar_cant_actual) AS cant_actual,
        /* PRIMERA FECHA SALIDA */
	(
        SELECT moi_fecha_mov _fecha FROM dee_detalle_mov C
        INNER JOIN moi_movimiento_inv E ON E.moi_id = C.dee_id_moi
        INNER JOIN tip_tipo_proceso F ON F.tip_id = E.moi_id_tip
        WHERE C.dee_id_art = art_id AND F.tip_salida = 1
        ORDER BY E.moi_fecha_mov ASC LIMIT 1
	) AS primer_salida,
	/* ULTIMA FECHA SALIDA */
	(SELECT moi_fecha_mov _fecha FROM dee_detalle_mov C
        INNER JOIN moi_movimiento_inv E ON E.moi_id = C.dee_id_moi
        INNER JOIN tip_tipo_proceso F ON F.tip_id = E.moi_id_tip
        WHERE C.dee_id_art = art_id AND F.tip_salida = 1
        ORDER BY E.moi_fecha_mov DESC LIMIT 1
	) AS ultima_salida, mrp_nombre as marca";

        $query = $this->db->select($script, false)
                ->from('sar_saldo_articulo')
                ->join('art_articulo', 'art_id = sar_id_art', 'inner')
                ->join('bod_bodega', 'bod_id = sar_id_bod', 'left')
                ->join('mrp_marca_producto', 'mrp_id=art_id_mrp', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        if ($in != null) {
            $where_in = explode(',', $in);
            $this->db->where_in('art_id', $where_in);
        }
        if ($group_by != null) {
            $this->db->group_by($group_by);
        }
        if ($having != null) {
            $this->db->having($having, false);
        }


        return $query->get()->result_array();
    }

    function get_movimientos($where = null) {
        $this->db->select()
                ->from('moi_movimiento_inv')
                ->join('bod_bodega', 'bod_id = moi_id_bod')
                ->join('tip_tipo_proceso', 'tip_id = moi_id_tip', 'inner')
                ->join('prv_proveedor', 'prv_id = moi_id_prv', 'left')
        ;
        //->where('moi_documento', $doc);
        if ($where != null) {
            $this->db->where($where);
        }

        $mois = $this->db->get()->result_array();
        return $mois;
    }

    function get_existencias($where = null, $group_by = null, $having = null, $order_by = null) {
        $script = "
            mep_nombre AS UM,
            art_foto AS art_foto,
            CONCAT(tia_codigo,'-',tia_nombre) AS linea,
            art_codigo AS codigo,
            art_nombre AS nombre,
            art_id,
            (
                SELECT dee_codigo_lote FROM dee_detalle_mov
                WHERE dee_id_sar = sar_id
                GROUP BY dee_id_art
                LIMIT 1
            ) AS lote,
            SUM(sar_cant_actual) AS cantidad,
            IFNULL((SUM(sar_cant_actual*sar_precio)/SUM(sar_cant_actual)),0) AS precio,
            SUM(sar_cant_actual * sar_precio) AS total,
            (SELECT bod_nombre FROM bod_bodega WHERE bod_id = sar_id_bod) AS bodega,
            (SELECT seb_nombre FROM sxb_sectorxbodega JOIN seb_sector_bodega ON seb_id = sxb_id_seb WHERE sxb_id = sar_id_sxb AND seb_estado = 1) AS sector,
            (SELECT mrp_nombre FROM mrp_marca_producto WHERE mrp_id = art_id_mrp) AS marca,
            (SELECT GROUP_CONCAT(cdp_codigo SEPARATOR ',  ') FROM cdp_codigo_producto WHERE cdp_id_art = art_id) as codigo_secundario,
        ";

        $query = $this->db->select($script, false)
                ->from('sar_saldo_articulo')
                //->join('bod_bodega', 'bod_id = sar_id_bod', 'inner')
                ->join('art_articulo', 'art_id = sar_id_art', 'inner')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia', 'inner')
                //->join('uxb_usuarioxbodega', 'uxb_id_bod = bod_id', 'inner')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1', 'inner')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
                //->join('mrp_marca_producto', 'mrp_id = art_id_mrp', 'left')
                // ->join('cdp_codigo_producto', 'cdp_id_art = art_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }

        if ($having != null) {
            $this->db->having($having, false);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    function get_existencias_lotes($where = null, $group_by = null, $having = null, $order_by = null) {
         $script = "
            mep_nombre AS UM,
            art_foto AS art_foto,
            CONCAT(tia_codigo,'-',tia_nombre) AS linea,
            art_codigo AS codigo,
            art_nombre AS nombre,
            dee_codigo_lote AS lote,
            dee_fecha_caducidad,
            (SELECT IF(prv_tipo_pers = 2, prv_apellido, CONCAT(prv_nombre,' ',prv_apellido)) FROM prv_proveedor WHERE prv_id = moi_id_prv) AS proveedor,
            art_id,          
            SUM(sar_cant_actual) AS cantidad,
            sar_precio AS precio,
            (
                SUM(sar_cant_actual) * sar_precio
            ) AS total,
            bod_nombre AS bodega
           
        ";

        $query = $this->db->select($script, false)
                ->from('sar_saldo_articulo')
                ->join('dee_detalle_mov','dee_id_sar = sar_id')
                ->join('moi_movimiento_inv', 'dee_id_moi = moi_id')
                ->join('tip_tipo_proceso','tip_id = moi_id_tip')
                ->join('bod_bodega', 'bod_id = sar_id_bod', 'inner')
                ->join('art_articulo', 'art_id = sar_id_art', 'inner')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia', 'inner')
                //->join('uxb_usuarioxbodega', 'uxb_id_bod = bod_id', 'inner')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1', 'inner')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
                //->join('mrp_marca_producto', 'mrp_id = art_id_mrp', 'left')
        ;
        $this->db->where('tip_entrada = 1');
        if ($where != null) {
            $this->db->where($where);
        }

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }

        if ($having != null) {
            $this->db->having($having, false);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }


    function get_existencias_ylufa() {
        /* //order by anteriores
          Departamento,
          linea,
          codigo,
          contenedor
         */
        $query = "SELECT mep_nombre AS UM,
                           art_foto AS art_foto,
                           tia_nombre AS linea,
                           art_codigo AS codigo,
                           art_nombre AS nombre,
                                                   (
                                            (
                                              SELECT
                                                SUM(dee_cantidad)
                                              FROM
                                                dee_detalle_mov
                                              INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                                              INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                                              WHERE
                                                tip_entrada = 1 AND dee_id_ixc = ixc_id  AND moi_id NOT IN (
                                                SELECT
                                                  tra_id_moi_ent
                                                FROM
                                                  tra_translado
                                              )
                                            ) - IFNULL(
                                              (
                                                SELECT
                                                  SUM(dee_cantidad)
                                                FROM
                                                  dee_detalle_mov
                                                INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                                                INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                                                WHERE
                                                  tip_salida = 1 AND dee_id_ixc = ixc_id  AND moi_id NOT IN (
                                                  SELECT
                                                    tra_id_moi_sal
                                                  FROM
                                                    tra_translado
                                                )
                                              ),
                                              0
                                            )
                                          )
                           AS cantidad,
                           sar_precio AS precio,
                           (
                            SUM(ixc_cantidad_actual) * sar_precio
                          ) AS total,
                           (
                            SELECT
                              tia_nombre
                            FROM
                              tia_tipo_articulo B
                            WHERE
                              B.tia_id = A.tia_padre
                          ) AS departamento,
                            ixc_contenedor AS contenedor,
                            ixc_id AS id
                          FROM
                            ixc_ingresoxcontenedor
                         INNER JOIN dee_detalle_mov ON dee_id_ixc = ixc_id
                         INNER JOIN sar_saldo_articulo ON sar_id= dee_id_sar
                         INNER JOIN art_articulo ON art_id = sar_id_art
                         INNER JOIN tia_tipo_articulo A ON A.tia_id = art_id_tia
                         INNER JOIN mep_medida_producto ON mep_id = art_id_mep
                          GROUP BY
                           -- tia_nombre,
                            --art_codigo,
                           art_nombre,
                            -- sar_precio
                            id,
                            cantidad
                          HAVING
                            cantidad > 0
                          ORDER BY
                            contenedor,codigo ASC";

        $detalle = $this->db->query($query)->result_array();
        //print_r($this->db->last_query());exit()
        return $detalle;
    }

    function get_movimientos_detalles($where = null) {
        $script = "art_id AS id, 
        art_id_tia as tia_id, 
        (SELECT tia_padre FROM tia_tipo_articulo WHERE tia_id = art_id_tia) as tia_padre,
    	moi_fecha_mov AS fecha_mov,
    	moi_documento AS documento,
    	moi_retaceo AS retaceo,
    	moi_descripcion AS descripcion,
    	bod_nombre AS bodega,
    	art_codigo AS codigo,
    	art_nombre AS nombre,
    	art_foto AS foto,
    	dee_cantidad AS cant_art,
    	dee_precio AS precio,
        (dee_cantidad * dee_precio) as subtotal, mrp_nombre AS marca
        ";

        $query = $this->db->select($script, false)
                ->from('dee_detalle_mov')
                ->join('moi_movimiento_inv', 'moi_id = dee_id_moi', 'inner')
                ->join('tip_tipo_proceso', 'tip_id = moi_id_tip', 'inner')
                ->join('bod_bodega', 'bod_id = moi_id_bod', 'inner')
                ->join('art_articulo', 'art_id = dee_id_art', 'inner')
                ->join('uxb_usuarioxbodega', 'uxb_id_bod = bod_id', 'inner')
                ->join('mrp_marca_producto', 'mrp_id=art_id_mrp', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_movimientos_detalles_proceso($moi, $tipo) {
        $id_usu_log = $this->tank_auth->get_user_id();
        $query = 'SELECT
            art_id AS id,
            moi_fecha_mov AS fecha_mov,
            moi_documento AS documento,
            moi_retaceo AS retaceo,
            moi_descripcion AS descripcion,';
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $query .= 'ixc_contenedor AS furgon,
            ixc_caja AS caja,';
        }
        $query .= "tip_nombre As tip_proceso,
           bod_nombre AS bodega,
            art_codigo AS codigo,
            art_nombre AS nombre,
            art_foto AS foto,
            dee_cantidad AS cant_art,
            dee_precio AS precio, mrp_nombre AS marca
            FROM
            dee_detalle_mov
            INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
            INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
            INNER JOIN bod_bodega ON bod_id = moi_id_bod";
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $query .= " INNER JOIN ixc_ingresoxcontenedor ON ixc_id = dee_id_ixc";
        }
        $query .= ' INNER JOIN art_articulo ON art_id = dee_id_art
                     INNER JOIN uxb_usuarioxbodega ON uxb_id_bod = bod_id
                     LEFT JOIN mrp_marca_producto ON art_id_mrp=mrp_id
            WHERE
            ' . $tipo . ' = 1 AND uxb_id_usu = ' . $id_usu_log . ' AND dee_id_moi = ' . $moi;
        $detalles = $this->db->query($query)->result_array();
        return $detalles;
    }

    function consultaxproveedor($proveedor = null, $where = null, $in = null) {

        $script = "
                art_nombre AS nombre,
                art_codigo AS codigo,
                art_id AS id_art,
                art_foto AS foto,
                tia_id AS id_tipo_art,
                tia_nombre AS linea,
                mep_nombre AS UM,
                sar_id AS id_sar,
                art_foto AS foto,
                sar_id_art AS id_articulo,
                moi_fecha_mov,
                group_concat(
                    DISTINCT dee_precio
                    ORDER BY
                        dee_precio ASC
                ) AS precios_costos,
                prv_nombre AS proveedor,
                bod_nombre AS bodega,
                (
                    SELECT
                        SUM(dee_cantidad)
                    FROM
                        dee_detalle_mov
                    INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                    INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                    WHERE
                        tip_entrada = 1
                    AND dee_id_art = sar_id_art
                    AND dee_id_sar = sar_id
                ) AS Entradas,
                (
                    SELECT
                        IFNULL(SUM(dee_cantidad), 0)
                    FROM
                        dee_detalle_mov
                    INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                    INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                    WHERE
                        tip_salida = 1
                    AND dee_id_sar = sar_id
                ) AS Salidas,
                (
                    (
                        SELECT
                            SUM(dee_cantidad)
                        FROM
                            dee_detalle_mov
                        INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                        INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                        WHERE
                            tip_entrada = 1
                        AND dee_id_sar = sar_id
                    ) - IFNULL(
                        (
                            SELECT
                                SUM(dee_cantidad)
                            FROM
                                dee_detalle_mov
                            INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                            INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                            WHERE
                                tip_salida = 1
                            AND dee_id_sar = sar_id
                        ),
                        0
                    )
                ) AS Saldo,
                sar_cant_actual AS cant_actual,
                sar_precio AS precio_compra,
                mrp_nombre AS marca,
                prv_codigo,
                (
                    SELECT dpv_numero_documento FROM dpv_documento_proveedor
                    WHERE dpv_id = moi_id_dpv
                ) AS dpv_numero,
                (
                    SELECT dpv_fecha_documento FROM dpv_documento_proveedor
                    WHERE dpv_id = moi_id_dpv
                ) AS dpv_fecha
        ";

        $query = $this->db->select($script, false)
                ->from('dee_detalle_mov')
                ->join('moi_movimiento_inv', ' moi_id = dee_id_moi', 'inner')
                ->join('sar_saldo_articulo', ' sar_id = dee_id_sar', 'inner')
                ->join('art_articulo', ' art_id = sar_id_art', 'inner')
                ->join('tia_tipo_articulo', ' tia_id = art_id_tia', 'inner')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1', 'inner')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
                ->join('bod_bodega', ' bod_id = sar_id_bod', 'inner')
                ->join('tip_tipo_proceso', ' tip_id = moi_id_tip', 'inner')
                ->join('prv_proveedor', 'prv_id = moi_id_prv', 'inner')                
                ->join('mrp_marca_producto', 'art_id_mrp=mrp_id', 'left')
                ->where('prv_nombre IS NOT NULL')
                ->where('moi_id_prv IS NOT NULL')
        ;

        //$this->db->where('moi_id NOT IN (SELECT tra_id_moi_ent FROM tra_translado)', null, false);
        if($proveedor != null){
            $where_p = explode(',', $proveedor);
            $this->db->where_in('prv_id', $where_p);
            //$this->db->where('prv_id', $proveedor, false);
        }
        if ($where != null) {
            $this->db->where($where);
        }
        if ($in != null) {
            $where_in = explode(',', $in);
            $this->db->where_in('art_id', $where_in);
        }
        $this->db->group_by('id_sar');
        $this->db->order_by('codigo','ASC');

        return $query->get()->result_array();
    }

    function consultaxdep($tia, $bdg, $furgon = '', $codigo = null, $fechaInicio = null, $fechaFin = null) {
        // Variable para evaluar la cantidad de productos en un rango de fechas
        $whereFecha = "";
        $whereFecSc = "";

        if (empty($furgon)) {
            $variable = "";
            $ixc = "";
        }
        // Verificar el rango de fechas para obtener las entradas y salidas de productos
        if ($fechaInicio != null && $fechaFin != null) {
            $fechainicio = formatear_fecha('Y-m-d', $fechaInicio);
            $fechafin    = formatear_fecha('Y-m-d', $fechaFin);
            $whereFecha = " DATE(moi_fecha_mov) BETWEEN '$fechainicio' AND '$fechafin' AND ";
            $whereFecSc = " AND DATE(moi_fecha_mov) BETWEEN '$fechainicio' AND '$fechafin'";
        }

        if ($codigo == 2) {
            $condicion_codigo = " Saldo = 0";
        } elseif ($codigo == 1) {
            $condicion_codigo = " Saldo <> 0";
        } elseif ($codigo == null) {
            $condicion_codigo = $whereFecha." (Saldo <> 0 OR  Saldo = 0) ";
        } elseif ($codigo == 3) {
            $condicion_codigo = " Salidas = 0";
        }

        $query = "SELECT
                  art_nombre AS nombre,
                  art_codigo AS codigo,
                  art_id AS id_art,
                  art_foto AS foto,
                  tia_id AS id_tipo_art,
                  mep_nombre AS UM,
                  mep_id AS id_um,
                  sar_id AS id_sar,
                  art_foto AS foto,
                  sar_id_art AS id_articulo,";
        $query .= " bod_nombre AS bodega,

                  (
                    SELECT
                      SUM(dee_cantidad)
                    FROM
                      dee_detalle_mov
                    INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                    INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip

                    WHERE
                      tip_entrada = 1
                    AND dee_id_art = sar_id_art";

        $query .= " AND dee_id_sar = sar_id";

        $query .= $whereFecSc;

        $query .= " ) AS Entradas,
                  (
                    SELECT
                      IFNULL(SUM(dee_cantidad), 0)
                    FROM
                      dee_detalle_mov
                    INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                    INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                    WHERE
                      tip_salida = 1
                    AND dee_id_art = sar_id_art";

        $query .= " AND dee_id_sar = sar_id";

        $query .= $whereFecSc;

        $query .= " ) AS Salidas,
                  (
                    IFNULL(
                    (
                      SELECT
                        SUM(dee_cantidad)
                      FROM
                        dee_detalle_mov
                      INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                      INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                      WHERE
                        tip_entrada = 1";

        $query .= " AND dee_id_sar = sar_id";
        $query .= $whereFecSc;
        $query .= "), 0 ";

        $query .= "
                    ) - IFNULL(
                      (
                        SELECT
                          SUM(dee_cantidad)
                        FROM
                          dee_detalle_mov
                        INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                        INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                        WHERE
                          tip_salida = 1";
        $query .= " AND dee_id_sar = sar_id";
        $query .= $whereFecSc;

        $query .= "
                      ),
                      0
                    )
                  ) AS Saldo,
                  sar_cant_actual AS cant_actual,
                  sar_precio AS precio_compra,
                  mrp_nombre AS marca,
                  dee_codigo_lote AS lote,
                  moi_fecha_mov
                FROM
                  dee_detalle_mov";
        $query .= " INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
                INNER JOIN art_articulo ON art_id = sar_id_art
                INNER JOIN tia_tipo_articulo ON tia_id = art_id_tia
                INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                INNER JOIN bod_bodega ON bod_id = sar_id_bod

                INNER JOIN cva_conversion_articulo on cva_id_art = dee_id_art and cva_defecto = 1
                INNER JOIN mep_medida_producto ON mep_id= cva_id_mep
                LEFT JOIN mrp_marca_producto ON art_id_mrp = mrp_id
                WHERE
                  sar_id_bod = " . $bdg . "
                 AND art_id_tia = " . $tia
                 . $variable;


        $ordernar_por = "codigo, moi_fecha_mov";
        $query .= " GROUP BY
                  id_sar";


        $query .= " HAVING " . $condicion_codigo . " ORDER BY
                  $ordernar_por ASC"; //codigo
        $informacion = $this->db->query($query)->result_array();
        return $informacion;
    }

    function obtener_furgones() {
        $query = "SELECT DISTINCT
    ixc_contenedor
  FROM
    ixc_ingresoxcontenedor
  ORDER BY
    ixc_contenedor ASC";
        $detalles = $this->db->query($query)->result_array();
        return $detalles;
    }

    function get_tia_padre($bdg, $departamento = null) {
        if ($departamento != null) {
            $opcional = " tia_id = " . $departamento . " AND ";
        } else {
            $opcional = "";
        }
        /* $datos=$this->db->distinct()
          ->select('tia_id,tia_nombre')
          ->where(array('tia_padre'=>null,'sar_id_bod'=>$bdg))
          ->join('art_articulo','art_id_tia=tia_id')
          ->join('sar_saldo_articulo','sar_id_art=art_id')
          ->get('tia_tipo_articulo')->result_array();
          return $datos; */

        $query = "SELECT DISTINCT  tia_id,tia_nombre  FROM tia_tipo_articulo
                          WHERE " . $opcional . " tia_id IN
                          (SELECT tia_padre FROM tia_tipo_articulo
                            INNER JOIN art_articulo ON art_id_tia=tia_id
                            INNER JOIN sar_saldo_articulo ON sar_id_art=art_id
                            inner join dee_detalle_mov on dee_id_art=art_id
                            LEFT join ixc_ingresoxcontenedor on ixc_id=dee_id_ixc
                            WHERE sar_id_bod= " . $bdg . ") ORDER BY tia_nombre asc";

        $datos = $this->db->query($query)->result_array();
        return $datos;
    }

    function get_bodega($bod = null) {
        if ($bod != null) {
            $datos = $this->db->select()->where('bod_id', $bod)->get('bod_bodega')->result_array();
        } else {
            $datos = $this->db->select()->get('bod_bodega')->result_array();
        }
        return $datos;
    }

    function get_bodega_contenedor($furgon) {
        $datos = $this->db->select('bod_id, bod_nombre,ixc_contenedor')
                        ->from('ixc_ingresoxcontenedor')
                        ->join('dee_detalle_mov', 'dee_id_ixc=ixc_id')
                        ->join('moi_movimiento_inv', 'moi_id=dee_id_moi')
                        ->join('bod_bodega', 'bod_id=moi_id_bod')
                        ->where('ixc_contenedor', $furgon)->group_by('bod_id, bod_nombre,ixc_contenedor')->get()->result_array();
        return $datos;
    }

    function hay_movi_en_bod($furgon, $bodega) {
        $query = "SELECT bod_id,
                   bod_nombre,
                   ixc_contenedor
                  FROM
                    (ixc_ingresoxcontenedor)
                  JOIN dee_detalle_mov ON dee_id_ixc = ixc_id
                  JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                  JOIN bod_bodega ON bod_id = moi_id_bod
                  WHERE
                    ixc_contenedor = " . $furgon . " AND moi_id_bod = " . $bodega . "
                  GROUP BY
                    bod_id,
                    bod_nombre,
                    ixc_contenedor";
        $detalle = $this->db->query($query)->result_array();
        return $detalle;
    }

    function get_tia_hijo_entrada($papa) {
        /* $datos=$this->db->distinct()
          ->select('tia_id,tia_nombre')
          ->where(array('tia_padre'=>$papa,'sar_id_bod'=>$bdg))
          ->join('art_articulo','art_id_tia=tia_id')
          ->join('sar_saldo_articulo','sar_id_art=art_id')
          ->get('tia_tipo_articulo')->result_array();
          return $datos; */

        $query = "SELECT DISTINCT tia_id,tia_nombre  FROM tia_tipo_articulo
                          INNER JOIN art_articulo ON art_id_tia=tia_id
                          WHERE tia_padre= " . $papa . " ORDER BY tia_nombre asc";
        $datos = $this->db->query($query)->result_array();
        return $datos;
    }

    function get_tia_hijo($bdg=null, $papa) {
        /* $datos=$this->db->distinct()
          ->select('tia_id,tia_nombre')
          ->where(array('tia_padre'=>$papa,'sar_id_bod'=>$bdg))
          ->join('art_articulo','art_id_tia=tia_id')
          ->join('sar_saldo_articulo','sar_id_art=art_id')
          ->get('tia_tipo_articulo')->result_array();
          return $datos; */

        $query = "SELECT DISTINCT tia_id,tia_nombre  FROM tia_tipo_articulo
                          INNER JOIN art_articulo ON art_id_tia=tia_id
                          INNER JOIN sar_saldo_articulo ON sar_id_art=art_id
                          WHERE tia_id in ($papa)";
        if($bdg!=null){
            $query .= " AND sar_id_bod= " . $bdg;
        }
        $query .= " ORDER BY tia_nombre asc";
        $datos = $this->db->query($query)->result_array();
        return $datos;
    }

    function get_tia_hijos($papa, $ver_papa = false) {
        /* $datos=$this->db->distinct()
          ->select('tia_id,tia_nombre')
          ->where(array('tia_padre'=>$papa,'sar_id_bod'=>$bdg))
          ->join('art_articulo','art_id_tia=tia_id')
          ->join('sar_saldo_articulo','sar_id_art=art_id')
          ->get('tia_tipo_articulo')->result_array();
          return $datos; */
        // $query = "SELECT DISTINCT tia_id,tia_nombre  FROM tia_tipo_articulo
        //                   INNER JOIN art_articulo ON art_id_tia=tia_id
        //                   INNER JOIN sar_saldo_articulo ON sar_id_art=art_id
        //                   WHERE tia_padre= $papa or tia_id= $papa";
        // if($bdg!=null){
        //     $query .= " AND sar_id_bod= " . $bdg;
        // }
        // $query .= " ORDER BY tia_nombre asc";

        $query = $this->db->select("DISTINCT tia_id,tia_nombre", false)
                          ->from('tia_tipo_articulo');
        if($ver_papa){
            $this->db->where( array('tia_id in ('.$papa.')' => null) , null, false);
        }
        if($papa != null){
            $this->db->or_where( array('tia_padre in ('.$papa.')' => null) , null, false);
        }

        
        $this->db->order_by('tia_nombre', 'ASC');
        return $query->get()->result_array();
    }

    function get_papa_tia($where = null){
        $query = $this->db->select('tia_id, tia_nombre, tia_padre')
                        ->from('tia_tipo_articulo')
                            ;
        if($where != null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_tias($where = null){
      $query = $this->db->select('tia_id,tia_nombre')
                        ->from('tia_tipo_articulo')
                        ;
      if($where != null){
        $this->db->where($where);
      }
      return $query->get()->result_array();
    }

    function get_productos_sn_exist($where = null, $in = null){
      /*
        select tia_id,tia_nombre,tia_padre, art_codigo, art_nombre, art_foto, mep_nombre, SUM(tip_salida) as salidas, SUM(tip_entrada) as entradas from sar_saldo_articulo
  inner join art_articulo on art_id = sar_id_art
  INNER JOIN cva_conversion_articulo ON cva_id_art = art_id AND cva_defecto = 1 and cva_estado = 1
  INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
  INNER JOIN dee_detalle_mov ON dee_id_sar = sar_id
  inner join tia_tipo_articulo on tia_id = art_id_tia
  INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
  INNER JOIN tip_tipo_proceso on tip_id = moi_id_tip
where sar_id_bod = 16 group by sar_id_art order by tia_id
      */
      $query = $this->db->select(
        '
            tia_id,
            tia_nombre,
            MIN(moi_fecha_mov) as fecha,
            tia_padre,
            art_codigo,
            art_nombre,
            art_foto,
            mep_nombre,
            SUM(tip_salida) as salidas,
            SUM(sar_cant_actual) as entradas,
            mrp_nombre as marca,
            dee_codigo_lote as lote
        '
        ,false)
        ->from('sar_saldo_articulo')
        ->join('art_articulo','art_id = sar_id_art','inner')
        ->join('cva_conversion_articulo','cva_id_art = art_id AND cva_defecto = 1 and cva_estado = 1','inner')
        ->join('mep_medida_producto','mep_id = cva_id_mep','inner')
        ->join('dee_detalle_mov','dee_id_sar = sar_id','inner')
        ->join('tia_tipo_articulo','tia_id = art_id_tia','inner')
        ->join('moi_movimiento_inv','moi_id = dee_id_moi','inner')
        ->join('tip_tipo_proceso','tip_id = moi_id_tip','inner')
        ->join('mrp_marca_producto', 'mrp_id=art_id_mrp', 'left')
        ->group_by('sar_id_art,dee_codigo_lote')
        ->order_by('tia_id')
        ;
        if($where != null){
            $this->db->where($where);
        }
        if ($in != null) {
            $where_in = explode(',', $in);
            $this->db->where_in('art_id', $where_in);
        }
      return $query->get()->result_array();
    }

    function consultaxfurgon($tia, $furgon, $bdg, $codigo = null) {

        if ($codigo == 2) {
            $condicion_codigo = " Saldo = 0";
        } elseif ($codigo == 1) {
            $condicion_codigo = " Saldo <> 0";
        } elseif ($codigo == null) {
            $condicion_codigo = " (Saldo <> 0 OR  Saldo = 0)";
        }
        $query = "SELECT
                          art_nombre AS nombre,
                          art_codigo AS codigo,
                          art_id AS id_art,
                          tia_id AS id_tipo_art,
                          mep_nombre AS UM,
                          sar_id AS id_sar,
                          art_foto AS foto,
                          sar_id_art AS id_articulo,
                          ixc_contenedor AS furgon,
                          ixc_caja AS caja,
                          bod_nombre AS bodega,
                          /*(
                            SELECT
                            dee_cantidad
                            FROM
                            dee_detalle_mov
                            INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                            INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                            WHERE
                            tip_entrada = 1
                            AND dee_id_art = sar_id_art
                        -- AND dee_id_sar = sar_id
                        AND dee_id_ixc = ixc_id
                        ) AS cantidad,*/
  ixc_cantidad_caja AS cantidad,
  (
    SELECT
    SUM(dee_cantidad)
    FROM
    dee_detalle_mov
    INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
    INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
    WHERE
    tip_entrada = 1
    AND dee_id_art = sar_id_art
                        -- AND dee_id_sar = sar_id
                        AND dee_id_ixc = ixc_id
                        AND moi_id not in (SELECT tra_id_moi_ent from tra_translado)
                        ) AS Entradas,
  (
    SELECT
    SUM(dee_cantidad)
    FROM
    dee_detalle_mov
    INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
    INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
    WHERE
    tip_salida = 1
                                                  -- AND dee_id_sar = sar_id
                                                  AND dee_id_ixc = ixc_id
                                                  AND moi_id not in (SELECT tra_id_moi_sal from tra_translado)

                                                  ) AS Salidas,
  (
    (
      SELECT
      SUM(dee_cantidad)
      FROM
      dee_detalle_mov
      INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
      INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
      WHERE
      tip_entrada = 1
                          -- AND dee_id_sar = sar_id
                          AND dee_id_ixc = ixc_id
                          AND moi_id not in (SELECT tra_id_moi_ent from tra_translado)
                          ) - IFNULL(
                          (
                            SELECT
                            SUM(dee_cantidad)
                            FROM
                            dee_detalle_mov
                            INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                            INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                            WHERE
                            tip_salida = 1
                            -- AND dee_id_sar = sar_id
                            AND dee_id_ixc = ixc_id
                            AND moi_id not in (SELECT tra_id_moi_sal from tra_translado)
                            ),
  0
  )
  ) AS Saldo,
  sar_cant_actual AS cant_actual,
  sar_precio AS precio_compra
  FROM
  dee_detalle_mov
  INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
  INNER JOIN ixc_ingresoxcontenedor ON ixc_id = dee_id_ixc
  INNER JOIN art_articulo ON art_id = sar_id_art
  INNER JOIN tia_tipo_articulo ON tia_id = art_id_tia
  INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
  INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
  INNER JOIN bod_bodega ON bod_id = sar_id_bod
  INNER JOIN mep_medida_producto ON mep_id = art_id_mep
  WHERE
  sar_id_bod = " . $bdg . " AND art_id_tia = " . $tia . " AND ixc_contenedor = " . $furgon . " AND moi_id not in (SELECT tra_id_moi_ent from tra_translado)
  GROUP BY ixc_id HAVING " . $condicion_codigo . " ORDER BY codigo asc , furgon asc";
        $informacion = $this->db->query($query)->result_array();
        return $informacion;
    }

    function detalle_salidasxsar_id($ixc, $todo = null, $id_ixc_furgon = null, $traslados = 1) {
        $condicion_furgon = "";
        if ($id_ixc_furgon > 0) {
            $condicion_furgon = " and dee_id_ixc=$id_ixc_furgon";
        }
        $str_traslados = ($traslados == 1)? " AND moi_id NOT IN (SELECT tra_id_moi_ent FROM tra_translado) ": "";
        $select = ($todo) ? "*" : "moi_fecha_mov,moi_documento,dee_cantidad,dee_id_sar,mep_nombre,tip_nombre";
        $query = "SELECT $select  FROM moi_movimiento_inv
    INNER JOIN dee_detalle_mov ON dee_id_moi=moi_id
    INNER JOIN sar_saldo_articulo ON sar_id =  dee_id_sar
    INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
    INNER JOIN art_articulo ON art_id = sar_id_art
    INNER JOIN cva_conversion_articulo on cva_id_art = art_id and cva_defecto = 1
    INNER JOIN mep_medida_producto as mart ON mep_id= cva_id_mep
    WHERE tip_salida = 1 AND dee_id_sar = " . $ixc . $str_traslados. $condicion_furgon
    ;
        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }

    function get_detalle_inn_out_bod($where, $id_furgon = 0, $traslados = 0) {
        $query = $this->db->select("moi_fecha_mov, moi_documento, dee_cantidad, mep_nombre, tip_nombre")
            ->from('moi_movimiento_inv')
            ->join('dee_detalle_mov', 'dee_id_moi = moi_id')
            ->join('tip_tipo_proceso', 'tip_id = moi_id_tip')
            ->join('art_articulo', 'art_id = dee_id_art')
            ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep')
            ->where($where);
        ;
        if ($id_furgon > 0) {
            $this->db->where('dee_id_ixc', $id_furgon);
        }
        if ($traslados > 0) {
            $this->db->where('moi_id NOT IN (SELECT tra_id_moi_ent FROM tra_translado)');
        }
        return $query->get()->result_array();
    }

    function detalle_entradasxsar_id($ixc, $todo = null, $id_ixc_furgon = null, $traslados = 1) {
        $condicion_furgon = "";
        if ($id_ixc_furgon > 0) {
            $condicion_furgon = " and dee_id_ixc=$id_ixc_furgon";
        }
        $str_traslados = ($traslados == 1)? " AND moi_id NOT IN (SELECT tra_id_moi_ent FROM tra_translado) ": "";
        $select = ($todo) ? "*" : "moi_fecha_mov,moi_documento,dee_cantidad,dee_id_sar,mep_nombre,tip_nombre";

        $query = "SELECT $select FROM moi_movimiento_inv
    INNER JOIN dee_detalle_mov ON dee_id_moi=moi_id
    INNER JOIN sar_saldo_articulo ON sar_id =  dee_id_sar
    INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
    INNER JOIN art_articulo ON art_id = sar_id_art
    INNER JOIN cva_conversion_articulo on cva_id_art = art_id and cva_defecto = 1
    INNER JOIN mep_medida_producto as mart ON mep_id= cva_id_mep
    WHERE tip_entrada = 1 AND dee_id_sar = " . $ixc . $str_traslados. $condicion_furgon
    ;
        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }

    function detalle_existenciaxfurgon($articulo, $furgon) {
        $query = 'SELECT
    bod_nombre AS nombre,
    SUM(sar_cant_actual) AS cantidad,
    mep_nombre AS unidad
  FROM
    dee_detalle_mov
  INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
  INNER JOIN bod_bodega ON bod_id = sar_id_bod
  INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
  INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
  INNER JOIN art_articulo ON art_id = sar_id_art
  INNER JOIN mep_medida_producto ON mep_id = art_id_mep
  INNER JOIN ixc_ingresoxcontenedor ON ixc_id = dee_id_ixc
  WHERE
    sar_id_art = ' . $articulo . '
  AND ixc_contenedor = ' . $furgon . '
  AND tip_entrada = 1
  GROUP BY
    bod_nombre,
    mep_nombre';
        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }

    function listado_precios($id_sar_art, $id_mep = null) {
        $this->db->select()
                ->from('mep_medida_producto');

        if ($id_mep == null) {  //Consulta precios ingresados en entrada de articulos
            $this->db->join('pdv_precio_venta', 'mep_id=pdv_id_mep');
            $this->db->where('pdv_id_sar', $id_sar_art);
        }

        if ($id_mep != null) { //Consulta precios ingresados desde el grid lista de precios por artículo
            $this->db->join('lip_listado_precio', 'mep_id=lip_id_mep');
            $this->db->join('art_articulo', 'lip_id_art=art_id');
            $this->db->where('art_id', $id_sar_art);
            $this->db->where('mep_id', $id_mep);
        }

        $precios = $this->db->get()->result_array();
        return $precios;
    }

    function get_departamentos() {
        $this->db->select('tia_id,tia_nombre')
                ->from('tia_tipo_articulo')
                ->where('tia_padre IS NULL');
        $departamentos = $this->db->get();
        return $departamentos->result_array();
    }

    function get_categorias_hijas($padre) {
        $this->db->select('tia_id,tia_nombre')
                ->from('tia_tipo_articulo')
                ->where('tia_padre', $padre);
        $categorias = $this->db->get();
        return $categorias->result_array();
    }

    function productos_imagenes() {
        $this->db->select('art_id, art_nombre, art_foto')
                ->from('art_articulo')
                ->where('art_foto IS NOT NULL');
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function efectuar_descarga() {
        $this->load->helper('download');
        $productos = $this->productos_imagenes();
        foreach ($productos as $producto) {

            $campo = $producto['art_foto'];
            $comprobar_campo = $this->input->post($campo);

            if (isset($comprobar_campo) && $comprobar_campo == "on") {
                $folder = base_url('/assets/uploads/images/' . $comprobar_campo);
                $data = file_get_contents($folder); // Read the file's contents

                force_download($comprobar_campo, $data);
            }
        }
    }

    function informacion_empleado($id_usuario) {
        $query = "
        users.username,
         users.email,
         users.id,
         emp_empleado.*,
         are_area.are_id,
         are_area.are_nombre,
         suc_sucursal.suc_id,
         suc_sucursal.suc_nombre
         ";                      //agrega el nombre de la sucursal
        $this->db->select($query, false);
        $this->db->from('users');
        $this->db->join('emp_empleado', 'users.id = emp_empleado.emp_id_usu', 'left');
        $this->db->join('are_area', 'are_area.are_id = emp_empleado.emp_id_are', 'left');
        $this->db->join('suc_sucursal', 'suc_id = emp_empleado.emp_id_suc', 'left');
        $this->db->where('users.id', $id_usuario);
        $rs = $this->db->get();
        return $rs->result_array();
    }

    public function kardex_ajustes($id_prod, $id_bod) {
        $query = "SELECT

            tb.art_nombre,
            (
              (SELECT SUM(t4.dee_cantidad) FROM moi_movimiento_inv AS t3
                INNER JOIN dee_detalle_mov AS t4
                ON t3.moi_id=t4.dee_id_moi
                WHERE t4.dee_id<=t2.dee_id AND (t3.moi_id_tip = 1 OR t3.moi_id_tip = 4) AND t3.moi_id_bod=" . $id_bod . " AND t4.dee_id_art=" . ((trim($id_prod) != '')?$id_prod:0) . ")
  -
  IFNULL((SELECT SUM(t5.dee_cantidad) FROM moi_movimiento_inv AS t4
    INNER JOIN dee_detalle_mov AS t5
    ON t4.moi_id=t5.dee_id_moi
    WHERE t5.dee_id<=t2.dee_id AND (t4.moi_id_tip = 2 OR t4.moi_id_tip = 5) AND t4.moi_id_bod=" . $id_bod . " AND t5.dee_id_art=" . ((trim($id_prod) != '')?$id_prod:0) . "),0)
  ) AS cantidad_existencia

  FROM
  moi_movimiento_inv AS t1

  INNER JOIN dee_detalle_mov AS t2
  ON t1.moi_id=t2.dee_id_moi

  INNER JOIN bod_bodega AS ta
  ON ta.bod_id=t1.moi_id_bod

  INNER JOIN art_articulo AS tb
  ON tb.art_id=t2.dee_id_art

  WHERE
  t1.moi_id_bod=" . $id_bod . " AND t2.dee_id_art=" . ((trim($id_prod) != '')?$id_prod:0) . "

  ORDER BY
  t2.dee_id DESC LIMIT 0,1";

        $detalle = $this->db->query($query);
        $detalle = $detalle->row_array();
        return $detalle;
    }

    function get_categorias_hijas2($hija) {
        $consulta = "select tia_id,tia_nombre,tia_padre from tia_tipo_articulo where tia_estado = 1 AND tia_padre=" . $hija;
        $rs = $this->db->query($consulta);
        return $rs->result_array();
    }

    function get_categorias($id_bod = null) {
        if ($id_bod != null) {
            $consulta = "select tia_codigo, tia_id,tia_nombre,tia_padre from sar_saldo_articulo
      inner join art_articulo on art_articulo.art_id = sar_saldo_articulo.sar_id_art
      inner join tia_tipo_articulo on tia_tipo_articulo.tia_id = art_articulo.art_id_tia
      where sar_id_bod = " . $id_bod . " AND tia_aplica_tipo_venta = 1 group by tia_nombre,tia_id order by tia_nombre";
        } else {
            $consulta = "select tia_codigo,tia_id,tia_nombre,tia_padre from tia_tipo_articulo where tia_padre IS NULL AND tia_aplica_tipo_venta = 1 AND tia_estado = 1 order by tia_nombre ASC";
        }
        $rs = $this->db->query($consulta);
        return $rs->result_array();
    }

    function get_cli_fac_sin_moi() {
        $query = "SELECT cli_id, cli_codigo, cli_personeria, cli_nombre, cli_apellido FROM fac_factura INNER JOIN cli_cliente ON cli_id = fac_id_cli 
                WHERE fac_estado > 0 AND cli_estado > 0 AND fac_id NOT IN (SELECT DISTINCT moi_id_fac FROM moi_movimiento_inv WHERE moi_estado > 0 AND moi_id_fac IS NOT NULL)
                GROUP BY cli_id"
        ;
        $result = $this->db->query($query);
        return $result->result_array();
    }

    function get_productos_categoria($categoria, $tipo = null) {
        if ($tipo == null) {
            $tipo = 1;
        } //tipo venta default
        $query = "SELECT
    art_articulo.art_id,
    art_articulo.art_nombre,
    art_articulo.art_codigo,
    art_articulo.art_id_mep,
    mep_nombre
    FROM art_articulo art_articulo

    INNER JOIN tia_tipo_articulo
    ON tia_tipo_articulo.tia_id = art_articulo.art_id_tia
    INNER JOIN mep_medida_producto ON mep_id=art_id_mep
    WHERE art_estado = 1 AND tia_id IN (" . $categoria . ")
    AND art_tipo_articulo=$tipo";

        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_requisiciones($user = null, $id_solicitud = '-') {

        $query = "select * from rxi_requisicion_inventario
    inner join bod_bodega on bod_bodega.bod_id = rxi_requisicion_inventario.rxi_id_bod
    inner join users on users.id = rxi_requisicion_inventario.rxi_id_user
    where rxi_requisicion_inventario.rxi_estado = 2 or rxi_requisicion_inventario.rxi_estado = 3
    order by  rxi_id DESC";

        if ($user != null) {
            $query .= " and users.id=" . $user;
        }

        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function productos_requisicion_rxi($id_req) {

        $campos = "dri_id_art,rxi_estado, rxi_id_bod, tia_id, art_nombre, art_codigo, SUM(dri_cantidad) AS dri_cantidad,SUM(dri_cantidad_despacho) AS dri_cantidad_despacho,rxi_id_bod";
        $this->db->select($campos);
        $this->db->from('dri_detalle_requisicion_inventario');

        $this->db->join('art_articulo', 'dri_id_art=art_id');
        $this->db->join('rxi_requisicion_inventario', 'dri_id_rxi=rxi_id');
        $this->db->join('tia_tipo_articulo', 'art_id_tia=tia_id');

        $this->db->where('rxi_id', $id_req);
        $this->db->where('(rxi_estado=3 OR rxi_estado=2)');
        $this->db->group_by('dri_id_art, rxi_id_bod, tia_id, art_nombre');

        $rs = $this->db->get();

        return $rs->result_array();
    }

    public function cargar_registros($tabla, $campo, $id) {
        $this->db->select();
        $this->db->from($tabla);
        $this->db->where($campo, $id);

        $query = $this->db->get();
        return $query->result_array();
    }

    public function solicitante_rxi($rxi_id) {
        $this->db->select("rxi_id_usu_solicita, rxi_id_usu_aprueba, rxi_numero, rxi_descripcion, emp_codigo, emp_nombre, emp_apellido, are_nombre");
        $this->db->from('rxi_requisicion_inventario');
        $this->db->join('emp_empleado', 'emp_id = rxi_id_emp');
        $this->db->join('are_area', 'are_id = emp_id_are');
        $this->db->where('rxi_id', $rxi_id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function cargar_registro($tabla, $campo, $id) {
        $this->db->select();
        $this->db->from($tabla);
        if($id != null && $campo != null){
            $this->db->where($campo, $id);
        }
        $query = $this->db->get();
        return $query->row_array();
    }

    function detalle_requisicion_inventario($id_solicitud) {
        $query = "select dri_id,dri_cantidad,art_nombre, rxi_requisicion_inventario.rxi_id,art_id,sum(sar_cant_actual) as cantidad FROM dri_detalle_requisicion_inventario
    INNER JOIN rxi_requisicion_inventario
    ON rxi_requisicion_inventario.rxi_id = dri_detalle_requisicion_inventario.dri_id_rxi
    INNER JOIN art_articulo
    ON dri_detalle_requisicion_inventario.dri_id_art = art_articulo.art_id
    INNER JOIN sar_saldo_articulo
    ON dri_detalle_requisicion_inventario.dri_id_art = sar_saldo_articulo.sar_id_art
    WHERE rxi_id = " . $id_solicitud . " AND rxi_requisicion_inventario.rxi_estado = 1
    group by dri_id,dri_cantidad,art_nombre, rxi_requisicion_inventario.rxi_id,art_id";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    public function cargar_productos_bodega($id_bodega) {

        $query = "SELECT SUM(sar_cant_actual)  as sar_cant_actual,
    art_articulo.art_id,
    art_articulo.art_nombre
    FROM    (   sar_saldo_articulo sar_saldo_articulo
     INNER JOIN
     bod_bodega bod_bodega
     ON (sar_saldo_articulo.sar_id_bod = bod_bodega.bod_id))
  INNER JOIN
  art_articulo art_articulo
  ON (sar_saldo_articulo.sar_id_art = art_articulo.art_id)
  INNER JOIN tia_tipo_articulo
  ON tia_tipo_articulo.tia_id = art_articulo.art_id_tia
  WHERE bod_id = " . $id_bodega . " AND sar_cant_actual>0 GROUP BY art_nombre,art_id,art_nombre";

        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function asignacion_empleado_inventario($id_area) {
        $query = "users.id,users.username,are_nombre";
        $this->db->select($query);
        $this->db->from('users');
        $this->db->join('are_area', 'are_area.are_id = users.use_id_are');
        $this->db->where('are_area.are_id', $id_area);
        $rs = $this->db->get();
        return $rs->result_array();
    }

    public function comprobar_existencias($valor_articulo, $bodega) {
        //print_r('art'.$valor_articulo.'bod'.$bodega);
        $query = "SUM(sar_cant_actual) as existencias";
        $this->db->select($query);
        $this->db->from('sar_saldo_articulo');
        $this->db->where('sar_id_art', $valor_articulo);
        $this->db->where('sar_id_bod', $bodega);
        $query2 = $this->db->get();
        return $query2->row_array();
    }

    public function bodega_destino($bod_id, $tipo_bodega = NULL) {
        $query = "SELECT * FROM bod_bodega where bod_id <>" . $bod_id; //." AND bod_tipo_bodega =".$tipo_bodega;
        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }

    public function cargar_articulos($iden_bod, $iden_art) {

        $query = $this->db->query('SELECT MIN(sar_id) as identificador, sar_precio, sar_cant_actual
      FROM sar_saldo_articulo WHERE sar_cant_actual > 0 AND sar_id_bod = ' . $iden_bod . '
      AND sar_id_art = ' . $iden_art . '
      GROUP BY sar_id, sar_precio, sar_cant_actual');

        return $query->row_array();
    }

    public function get_notas_remi($having = null) {
        $parametros = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $not_remi = (isset($parametros['NOTA REMISION'])) ? $parametros['NOTA REMISION'] : 0;        
        $query = $this->db->select('*, SUM(tip_entrada) as tip_entrada, SUM(tip_salida) as tip_salida', false)
            ->from('moi_movimiento_inv')
            ->join('tip_tipo_proceso', 'moi_id_tip = tip_id')
            ->join('fac_factura', 'moi_id_fac = fac_id')
            ->where('fac_id_tif', $not_remi)
            ->group_by('moi_id_fac')
        ;
        if ($having != null) {
            $this->db->having($having);
        }
        return $query->get()->result_array();
    }

    public function requisicion_med_inv() {
        $this->db->select()
                ->from('rxi_requisicion_inventario')
                ->where('rxi_tipo', 2)
                ->where('rxi_estado', 1);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function cargar_todo2($tabla) {
        $this->db->distinct()->select();
        $this->db->from($tabla);
        $query = $this->db->get();

        return $query->result_array();
    }

    public function cargar_todo($tabla, $where = null, $order = null) {
        $this->db->select();
        $this->db->from($tabla);

        if ($where != null) {
            $this->db->where($where);
        }

        if ($order != null) {
            $this->db->order_by($order);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    function historial_solicitudes($usuario = null, $where = null) {

        $this->db->select()
                ->from('rxi_requisicion_inventario')
                ->join('bod_bodega', 'bod_bodega.bod_id = rxi_requisicion_inventario.rxi_id_bod', 'inner')
                ->join('users', 'users.id = rxi_requisicion_inventario.rxi_id_user', 'inner')
                ->join('uxb_usuarioxbodega', 'uxb_id_bod = bod_id')
                ->where('rxi_requisicion_inventario.rxi_estado', 0)
        ;

        if ($usuario != null) {
            $this->db->where('uxb_id_usu', $usuario);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        $rs = $this->db->get();
        return $rs->result_array();
    }

    function solicitudes_rechazadas($usuario = null, $where = null) {
        $this->db->select()
                ->from('rxi_requisicion_inventario')
                ->join('bod_bodega', 'bod_bodega.bod_id = rxi_requisicion_inventario.rxi_id_bod', 'inner')
                ->join('users', 'users.id = rxi_requisicion_inventario.rxi_id_user', 'inner')
                ->join('uxb_usuarioxbodega', 'uxb_id_bod = bod_id')
                ->where('rxi_requisicion_inventario.rxi_estado', 4)
        ;

        if ($usuario != null) {
            $this->db->where('uxb_id_usu', $usuario);
        }
        if ($where != null) {
            $this->db->where($where);
        }

        $rs = $this->db->get();
        return $rs->result_array();
    }

    function historial_solicitudes2($usuario = null, $where = null) {
        $this->db->select()
                ->from('rxi_requisicion_inventario')
                ->join('bod_bodega', 'bod_bodega.bod_id = rxi_requisicion_inventario.rxi_id_bod', 'inner')
                ->join('users', 'users.id = rxi_requisicion_inventario.rxi_id_user', 'inner')
                ->join('uxb_usuarioxbodega', 'uxb_id_bod = bod_id')
                ->where("(`rxi_requisicion_inventario`.`rxi_estado` = 1 OR `rxi_requisicion_inventario`.`rxi_estado` = 3)")
        ;

        if ($usuario != null) {
            $this->db->where('uxb_id_usu', $usuario);
        }
        if ($where != null) {
            $this->db->where($where);
        }

        $rs = $this->db->get();
        return $rs->result_array();
    }

    function historial_solicitudes3($usuario = null) {
        $query = "select * from rxi_requisicion_inventario
    inner join bod_bodega on bod_bodega.bod_id = rxi_requisicion_inventario.rxi_id_bod
    inner join users on users.id = rxi_requisicion_inventario.rxi_id_user
    where (rxi_requisicion_inventario.rxi_estado = 1)";

        if ($usuario != null) {
            $query .= " and rxi_requisicion_inventario.rxi_id_user = " . $usuario;
        }

        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    public function cargar_req_detail($id_req) {
        $this->db->select();
        $this->db->from('rxi_requisicion_inventario');
        $this->db->where('rxi_id', $id_req);
        $this->db->join('bod_bodega', 'rxi_id_bod=bod_id');
        $this->db->join('users', 'id=rxi_id_user');
        $this->db->join('emp_empleado', 'emp_id_usu=id', 'LEFT');
        $query = $this->db->get();
        return $query->row_array();
    }

    public function cargar_req_moi($id_req) {
        $this->db->select('art_id,art_codigo,articulo,medida,observacion,solicitado,despachado,fecha,fecha_mov');
        $this->db->from('vw_rxi_detalle');
        $this->db->where('rxi_id', $id_req);
        $this->db->group_by('art_id,articulo,solicitado,despachado,fecha,fecha_mov');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function anular_requisicion($id_req_show, $observacion) {
        $data = array('rxi_estado' => 4, 'rxi_descripcion_anulacion' => $observacion);
        $this->db->where('rxi_id', $id_req_show);
        $resultado = $this->db->update('rxi_requisicion_inventario', $data);
        //return $resultado->result_array();
    }

    public function marcar_entrega($id_req_show, $observacion) {
        $data = array('rxi_estado' => 0, 'rxi_descripcion_anulacion' => $observacion);
        $this->db->where('rxi_id', $id_req_show);
        $resultado = $this->db->update('rxi_requisicion_inventario', $data);
    }

    function prductosxbodega($bodega) {
        $query = "SELECT SUM(sar_cant_actual)  as sar_cant_actual,
    art_articulo.art_id,
    art_articulo.art_nombre,
    art_articulo.art_codigo
    FROM    (   sar_saldo_articulo sar_saldo_articulo
     INNER JOIN
     bod_bodega bod_bodega
     ON (sar_saldo_articulo.sar_id_bod = bod_bodega.bod_id))
  INNER JOIN
  art_articulo art_articulo
  ON (sar_saldo_articulo.sar_id_art = art_articulo.art_id)
  INNER JOIN tia_tipo_articulo
  ON tia_tipo_articulo.tia_id = art_articulo.art_id_tia
  WHERE bod_id = " . $bodega . " AND sar_cant_actual>0 AND art_inventario=1 GROUP BY art_nombre,art_id,art_nombre";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_productos_bodega_cantidad_salida($bodega, $categoria = null) {
        $query = "SELECT SUM(sar_cant_actual)  as sar_cant_actual,
    art_articulo.art_id,
    art_articulo.art_nombre,
    art_articulo.art_codigo
    FROM    (   sar_saldo_articulo sar_saldo_articulo
     INNER JOIN
     bod_bodega bod_bodega
     ON (sar_saldo_articulo.sar_id_bod = bod_bodega.bod_id))
  INNER JOIN
  art_articulo art_articulo
  ON (sar_saldo_articulo.sar_id_art = art_articulo.art_id)
  INNER JOIN tia_tipo_articulo
  ON tia_tipo_articulo.tia_id = art_articulo.art_id_tia";
        if ($categoria != null) {
            $query .= " WHERE bod_id = " . $bodega . " AND tia_id =" . $categoria . " AND sar_cant_actual>0 GROUP BY art_nombre,art_id,art_nombre";
        } else {
            $query .= " WHERE bod_id = " . $bodega . " AND sar_cant_actual>0 GROUP BY art_nombre,art_id,art_nombre";
        }

        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_productos_bodega_cantidad_salida2($bodega, $categoria) {
        $query = "SELECT SUM(sar_cant_actual)  as sar_cant_actual,
    art_articulo.art_id,
    art_articulo.art_nombre
    FROM    (   sar_saldo_articulo sar_saldo_articulo
     INNER JOIN
     bod_bodega bod_bodega
     ON (sar_saldo_articulo.sar_id_bod = bod_bodega.bod_id))
  INNER JOIN
  art_articulo art_articulo
  ON (sar_saldo_articulo.sar_id_art = art_articulo.art_id)
  INNER JOIN tia_tipo_articulo
  ON tia_tipo_articulo.tia_id = art_articulo.art_id_tia
  WHERE bod_id = " . $bodega . " AND tia_id =" . $categoria . " GROUP BY art_nombre,art_id,art_nombre";

        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_cantidad_articulos_solicitud($id_articulo, $id_solicitud) {
        $query = "SELECT dri_detalle_requisicion_inventario.dri_cantidad
    FROM    dri_detalle_requisicion_inventario
    INNER JOIN
    rxi_requisicion_inventario
    ON (dri_detalle_requisicion_inventario.dri_id_rxi =
      rxi_requisicion_inventario.rxi_id)
  where rxi_requisicion_inventario.rxi_id =" . $id_solicitud . " and dri_detalle_requisicion_inventario.dri_id_art =" . $id_articulo . "
  and rxi_requisicion_inventario.rxi_estado = 1";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_bodegas_articulos($id_articulo) {
        $query = "SELECT bod_bodega.bod_id, bod_bodega.bod_nombre
    FROM    (   sar_saldo_articulo sar_saldo_articulo
     INNER JOIN
     bod_bodega bod_bodega
     ON (sar_saldo_articulo.sar_id_bod = bod_bodega.bod_id))
  INNER JOIN
  art_articulo art_articulo
  ON (sar_saldo_articulo.sar_id_art = art_articulo.art_id)
  WHERE art_articulo.art_id =" . $id_articulo . " AND sar_saldo_articulo.sar_cant_actual > 0";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_productos_bodega_cantidad_entrada($bodega, $categoria) {
        $query = "SELECT SUM(sar_cant_actual)  as sar_cant_actual,
    art_articulo.art_id,
    art_articulo.art_nombre
    FROM    (   sar_saldo_articulo sar_saldo_articulo
     INNER JOIN
     bod_bodega bod_bodega
     ON (sar_saldo_articulo.sar_id_bod = bod_bodega.bod_id))
  INNER JOIN
  art_articulo art_articulo
  ON (sar_saldo_articulo.sar_id_art = art_articulo.art_id)
  INNER JOIN tia_tipo_articulo
  ON tia_tipo_articulo.tia_id = art_articulo.art_id_tia
  WHERE bod_id = " . $bodega . " AND tia_id =" . $categoria . " GROUP BY art_nombre,art_id,art_nombre";

        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_articulos_medicina($bodega) {
        $consulta = "
    SELECT  SUM(sar_saldo_articulo.sar_cant_actual) as sar_cant_actual,
    art_articulo.art_id,
    art_articulo.art_nombre
    FROM    (   sar_saldo_articulo sar_saldo_articulo
     INNER JOIN
     bod_bodega bod_bodega
     ON (sar_saldo_articulo.sar_id_bod = bod_bodega.bod_id))
  INNER JOIN
  art_articulo art_articulo
  ON (sar_saldo_articulo.sar_id_art = art_articulo.art_id)
  INNER JOIN tia_tipo_articulo
  ON tia_tipo_articulo.tia_id = art_articulo.art_id_tia
  where tia_tipo_articulo.tia_id = 5 and bod_bodega.bod_id = " . $bodega . "GROUP BY art_nombre,art_id,art_nombre";

        $informacion = $this->db->query($consulta);
        return $informacion->result_array();
    }

    public function cargar_info_user($id_usuario_rxi) {
        $query = $this->db->select('are_nombre,plz_nombre,emp_nombre,emp_apellido,suc_nombre')
                ->from('emp_empleado')
                ->join('plz_plaza', 'plz_id=emp_id_plz', 'left')
                ->join('are_area', 'are_id=emp_id_are', 'left')
                ->join('suc_sucursal', 'suc_id=emp_id_suc')
                ->where('emp_id_usu', $id_usuario_rxi)
                ->get();

        return $query->row_array();
    }

    public function kardex_producto($id_prod, $id_bod=null, $fecha_ini=null, $fecha_fin=null) {
        if($fecha_ini!=null && $fecha_fin !=null ){
            $fecha_ini = date("Y-m-d", strtotime($fecha_ini));
            $fecha_fin = date("Y-m-d", strtotime($fecha_fin));
        }

        $query = "SELECT            
            tpt.tip_id,            
            sar_precio,
            t1.moi_id,
            t2.dee_id,
            bod.bod_nombre,
            bod.bod_id,
            t1.moi_id_tip,
            tpt.tip_entrada,
            tpt.tip_salida,
            tpt.tip_nombre,
            t1.moi_fecha_mov,
            t1.moi_documento,
            t2.dee_id_art,
            SUM(t2.dee_cantidad) AS dee_cantidad,
            tif2.tif_abreviacion as abre2,
            t2.dee_precio,
            t2.dee_id_sar,
            prv.prv_id,
            prv.prv_nombre,
            ord.ord_codigo,
            pai_nacionalidad,
            dpv_serie_documento,
            fac.fac_numero,
            t1.moi_usu_creacion usuario,
            tf.tif_abreviacion,
            (
                SELECT sef_abrev FROM sef_serie_factura
                JOIN cof_correlativo_factura ON sef_id = cof_id_sef
                WHERE cof_id = fac.fac_id_cof   
                GROUP BY sef_id
            ) AS serie_fac,        
            GROUP_CONCAT(
            CASE WHEN tpt.tip_entrada = 1 THEN 
            (SELECT SUM(t4.dee_cantidad) FROM moi_movimiento_inv AS t3
                INNER JOIN dee_detalle_mov AS t4
                ON t3.moi_id=t4.dee_id_moi
                INNER JOIN tip_tipo_proceso AS tp1
                ON t3.moi_id_tip=tp1.tip_id
                WHERE t3.moi_fecha_mov <= t1.moi_fecha_mov AND tp1.tip_entrada=1 "; // WHERE t4.dee_id<=t2.dee_id AND tp1.tip_entrada=1
                if($id_bod!=null){
                  $query .= " AND t3.moi_id_bod=" . $id_bod;
                }

                $query .= " AND t4.dee_id_art=" . $id_prod . ")
      -
      IFNULL((SELECT SUM(t5.dee_cantidad) FROM moi_movimiento_inv AS t4
        INNER JOIN dee_detalle_mov AS t5
        ON t4.moi_id=t5.dee_id_moi
        INNER JOIN tip_tipo_proceso AS tp2
        ON t4.moi_id_tip=tp2.tip_id
        WHERE t4.moi_fecha_mov < t1.moi_fecha_mov AND tp2.tip_salida=1";// WHERE t5.dee_id<=t2.dee_id
        if($id_bod!=null){
          $query .= " AND t4.moi_id_bod=" . $id_bod;
        }
          $query .= " AND t5.dee_id_art=" . $id_prod . ")
      ,0)
      WHEN  tpt.tip_salida = 1 THEN 
      (SELECT SUM(t4.dee_cantidad) FROM moi_movimiento_inv AS t3
                INNER JOIN dee_detalle_mov AS t4
                ON t3.moi_id=t4.dee_id_moi
                INNER JOIN tip_tipo_proceso AS tp1
                ON t3.moi_id_tip=tp1.tip_id
                WHERE t3.moi_fecha_mov <= t1.moi_fecha_mov AND tp1.tip_entrada=1 "; // WHERE t4.dee_id<=t2.dee_id AND tp1.tip_entrada=1
                if($id_bod!=null){
                  $query .= " AND t3.moi_id_bod=" . $id_bod;
                }

                $query .= " AND t4.dee_id_art=" . $id_prod . ")
      -
      IFNULL((SELECT SUM(t5.dee_cantidad) FROM moi_movimiento_inv AS t4
        INNER JOIN dee_detalle_mov AS t5
        ON t4.moi_id=t5.dee_id_moi
        INNER JOIN tip_tipo_proceso AS tp2
        ON t4.moi_id_tip=tp2.tip_id
        WHERE t4.moi_fecha_mov <= t1.moi_fecha_mov AND tp2.tip_salida=1";// WHERE t5.dee_id<=t2.dee_id
        if($id_bod!=null){
          $query .= " AND t4.moi_id_bod=" . $id_bod;
        }
          $query .= " AND t5.dee_id_art=" . $id_prod . ")
      ,0)
      END
      ) as cantidad_existencia,

      GROUP_CONCAT(
        
        CASE WHEN tpt.tip_entrada = 1 THEN 
        (SELECT SUM(t4.dee_cantidad*t4.dee_precio) FROM moi_movimiento_inv AS t3
          INNER JOIN dee_detalle_mov AS t4
          ON t3.moi_id=t4.dee_id_moi
          INNER JOIN tip_tipo_proceso AS tp1
          ON t3.moi_id_tip=tp1.tip_id
          WHERE DATE(t3.moi_fecha_mov) <= DATE(t1.moi_fecha_mov) AND tp1.tip_entrada=1"; //t4.dee_id<=t2.dee_id
          if($id_bod!=null){
           $query .= " AND t3.moi_id_bod=" . $id_bod;
          }
           $query .=" AND t4.dee_id_art=" . $id_prod . ")
      -
      IFNULL((SELECT SUM(t5.dee_cantidad*t5.dee_precio) FROM moi_movimiento_inv AS t4
        INNER JOIN dee_detalle_mov AS t5
        ON t4.moi_id=t5.dee_id_moi
        INNER JOIN tip_tipo_proceso AS tp2
        ON t4.moi_id_tip=tp2.tip_id
        WHERE DATE(t4.moi_fecha_mov) < DATE(t1.moi_fecha_mov) AND tp2.tip_salida=1"; //t5.dee_id<=t2.dee_id 
        if($id_bod!=null){
         $query .=" AND t4.moi_id_bod=" . $id_bod;
       }
         $query .= " AND t5.dee_id_art=" . $id_prod . ")
      ,0)

      WHEN tpt.tip_salida = 1 THEN 
       (SELECT SUM(t4.dee_cantidad*t4.dee_precio) FROM moi_movimiento_inv AS t3
          INNER JOIN dee_detalle_mov AS t4
          ON t3.moi_id=t4.dee_id_moi
          INNER JOIN tip_tipo_proceso AS tp1
          ON t3.moi_id_tip=tp1.tip_id
          WHERE DATE(t3.moi_fecha_mov) <= DATE(t1.moi_fecha_mov) AND tp1.tip_entrada=1"; //t4.dee_id<=t2.dee_id
          if($id_bod!=null){
           $query .= " AND t3.moi_id_bod=" . $id_bod;
          }
           $query .=" AND t4.dee_id_art=" . $id_prod . ")
      -
      IFNULL((SELECT SUM(t5.dee_cantidad*t5.dee_precio) FROM moi_movimiento_inv AS t4
        INNER JOIN dee_detalle_mov AS t5
        ON t4.moi_id=t5.dee_id_moi
        INNER JOIN tip_tipo_proceso AS tp2
        ON t4.moi_id_tip=tp2.tip_id
        WHERE DATE(t4.moi_fecha_mov) <= DATE(t1.moi_fecha_mov) AND tp2.tip_salida=1"; //t5.dee_id<=t2.dee_id 
        if($id_bod!=null){
         $query .=" AND t4.moi_id_bod=" . $id_bod;
       }
         $query .= " AND t5.dee_id_art=" . $id_prod . ")
      ,0)
      END
      ) as monto_existencia,
      moi_usu_creacion AS usuario,
      IF(tpt.tip_entrada=1,SUM(dee_cantidad),0) cantidad_entrada_new,
        IF(tpt.tip_salida=1,SUM(dee_cantidad),0) cantidad_salida_new,
        SUM(IF(tpt.tip_entrada=1,t2.dee_cantidad,0)*t2.dee_precio) prc_cantidad_entrada_new,
        SUM(IF(tpt.tip_salida=1,t2.dee_cantidad,0)*t2.dee_precio) prc_cantidad_salida_new
      FROM
      moi_movimiento_inv AS t1

      INNER JOIN dee_detalle_mov AS t2
      ON t1.moi_id=t2.dee_id_moi

      INNER JOIN tip_tipo_proceso AS tpt
      ON t1.moi_id_tip=tpt.tip_id

      INNER JOIN sar_saldo_articulo on sar_id = dee_id_sar

      LEFT JOIN rxi_requisicion_inventario AS rxi
      ON t1.moi_id_rxi=rxi.rxi_id

      LEFT JOIN ord_orden AS ord
      ON rxi.rxi_id_ord = ord.ord_id

      LEFT JOIN fac_factura AS fac
      ON t1.moi_id_fac=fac.fac_id

      LEFT JOIN tif_tipo_factura AS tf
      ON fac.fac_id_tif=tf.tif_id

      LEFT JOIN dpv_documento_proveedor ON dpv_id = t1.moi_id_dpv
      LEFT JOIN tif_tipo_factura as tif2 ON tif2.tif_id = dpv_id_tif

      LEFT JOIN prv_proveedor AS prv
      ON prv.prv_id=t1.moi_id_prv

      LEFT JOIN bod_bodega AS bod  ON bod.bod_id=t1.moi_id_bod
      LEFT JOIN pai_pais ON prv_id_pai = pai_id

      WHERE
      t2.dee_id_art=" . $id_prod;
      if($id_bod!=null){
        $query .= " AND t1.moi_id_bod=" . $id_bod;
      }
      if($fecha_ini!=null && $fecha_fin !=null ){
        $query .= " AND DATE(t1.moi_fecha_mov) BETWEEN '" . $fecha_ini . "' AND'" . $fecha_fin . "'";
      }
      $query .= "
      GROUP BY t1.moi_id
      ORDER BY
       t1.moi_fecha_mov ASC, t1.moi_id ASC, t2.dee_id DESC";
            $detalle = $this->db->query($query);
            $detalle = $detalle->result_array();
            //print_r($this->db->last_query());exit();
            return $detalle;
    }

    public function kardex_tipo($id_cat, $id_bod, $fecha_ini, $fecha_fin) {

        $fecha_ini = date("Y-m-d", strtotime($fecha_ini));
        $fecha_fin = date("Y-m-d", strtotime($fecha_fin));

    $query = "SELECT
        sar_precio,
        prv.prv_nombre,
        bod.bod_nombre,
        pai_nacionalidad,
        dpv_serie_documento,
        t1.moi_id,
        t2.dee_id,
        t1.moi_id_tip,
        tpt.tip_entrada,
        tpt.tip_salida,
        tpt.tip_nombre,
        t1.moi_fecha_mov,
        t1.moi_documento,
        tif2.tif_abreviacion as abre2,
        t2.dee_id_art,
        SUM(t2.dee_cantidad) as dee_cantidad,
        t2.dee_precio,
        t2.dee_id_sar,
        tiat.tia_id,
        tart.art_nombre,
        tart.art_id,
        tart.art_codigo,
        mart.mep_nombre,
        mrp_nombre AS marca,
        ord.ord_codigo,
        fac.fac_numero,
        tf.tif_abreviacion,
        (
            SELECT sef_abrev FROM sef_serie_factura
            JOIN cof_correlativo_factura ON sef_id = cof_id_sef
            WHERE cof_id = fac.fac_id_cof   
            GROUP BY sef_id
        ) AS serie_fac,
        (
            CASE WHEN tpt.tip_entrada = 1 THEN 
          (SELECT SUM(t4.dee_cantidad) FROM moi_movimiento_inv AS t3
            INNER JOIN dee_detalle_mov AS t4
            ON t3.moi_id=t4.dee_id_moi
            INNER JOIN tip_tipo_proceso AS tp1
            ON t3.moi_id_tip=tp1.tip_id
            WHERE t3.moi_fecha_mov <= t1.moi_fecha_mov AND tp1.tip_entrada=1"; //t4.dee_id<=t2.dee_id
    if($id_bod>0){
        $query .= " AND t3.moi_id_bod = " . $id_bod;
    }

    $query .= " AND t4.dee_id_art=tart.art_id)";

    $query .= " -
      IFNULL((SELECT SUM(t5.dee_cantidad) FROM moi_movimiento_inv AS t4
        INNER JOIN dee_detalle_mov AS t5
        ON t4.moi_id=t5.dee_id_moi
        INNER JOIN tip_tipo_proceso AS tp2
        ON t4.moi_id_tip=tp2.tip_id
        WHERE t4.moi_fecha_mov < t1.moi_fecha_mov AND tp2.tip_salida=1"; // t5.dee_id<=t2.dee_id

    if($id_bod>0){
        $query .= " AND t4.moi_id_bod = " . $id_bod;
    }

    $query .= " AND t5.dee_id_art=tart.art_id),0)
    WHEN tpt.tip_salida = 1 THEN 
     (SELECT SUM(t4.dee_cantidad) FROM moi_movimiento_inv AS t3
            INNER JOIN dee_detalle_mov AS t4
            ON t3.moi_id=t4.dee_id_moi
            INNER JOIN tip_tipo_proceso AS tp1
            ON t3.moi_id_tip=tp1.tip_id
            WHERE t3.moi_fecha_mov <= t1.moi_fecha_mov AND tp1.tip_entrada=1"; //t4.dee_id<=t2.dee_id
    if($id_bod>0){
        $query .= " AND t3.moi_id_bod = " . $id_bod;
    }

    $query .= " AND t4.dee_id_art=tart.art_id)";

    $query .= " -
      IFNULL((SELECT SUM(t5.dee_cantidad) FROM moi_movimiento_inv AS t4
        INNER JOIN dee_detalle_mov AS t5
        ON t4.moi_id=t5.dee_id_moi
        INNER JOIN tip_tipo_proceso AS tp2
        ON t4.moi_id_tip=tp2.tip_id
        WHERE t4.moi_fecha_mov <= t1.moi_fecha_mov AND tp2.tip_salida=1"; // t5.dee_id<=t2.dee_id

    if($id_bod>0){
        $query .= " AND t4.moi_id_bod = " . $id_bod;
    }

    $query .= " AND t5.dee_id_art=tart.art_id),0)
    END 
    ) AS cantidad_existencia
      ,
      (
        (SELECT SUM(t4.dee_cantidad*t4.dee_precio) FROM moi_movimiento_inv AS t3
          INNER JOIN dee_detalle_mov AS t4
          ON t3.moi_id=t4.dee_id_moi
          INNER JOIN tip_tipo_proceso AS tp1
          ON t3.moi_id_tip=tp1.tip_id
          WHERE t4.dee_id<=t2.dee_id AND tp1.tip_entrada=1 ";

        if($id_bod>0){
            $query .= " AND t3.moi_id_bod = " . $id_bod;
        }

    $query .= " AND t4.dee_id_art=tart.art_id)
        -
        IFNULL((SELECT SUM(t5.dee_cantidad*t5.dee_precio) FROM moi_movimiento_inv AS t4
            INNER JOIN dee_detalle_mov AS t5
            ON t4.moi_id=t5.dee_id_moi
            INNER JOIN tip_tipo_proceso AS tp2
            ON t4.moi_id_tip=tp2.tip_id
            WHERE t5.dee_id<=t2.dee_id AND tp2.tip_salida=1";

        if($id_bod>0){
            $query .= " AND t4.moi_id_bod = " . $id_bod;
        }

    $query .= " AND t5.dee_id_art=tart.art_id),0)
        ) AS monto_existencia

  FROM
  moi_movimiento_inv AS t1

  INNER JOIN dee_detalle_mov AS t2
  ON t1.moi_id=t2.dee_id_moi

  INNER JOIN art_articulo as tart
  ON tart.art_id=t2.dee_id_art

  INNER JOIN cva_conversion_articulo on cva_id_art = art_id and cva_defecto = 1

  INNER JOIN mep_medida_producto as mart
  ON mep_id= cva_id_mep

  INNER JOIN tia_tipo_articulo as tiat
  ON tiat.tia_id=tart.art_id_tia

  INNER JOIN tip_tipo_proceso AS tpt
  ON t1.moi_id_tip=tpt.tip_id

  INNER JOIN sar_saldo_articulo on sar_id = dee_id_sar

  LEFT JOIN dpv_documento_proveedor ON dpv_id = t1.moi_id_dpv
  LEFT JOIN tif_tipo_factura as tif2 ON tif2.tif_id = dpv_id_tif

  LEFT JOIN rxi_requisicion_inventario AS rxi
  ON t1.moi_id_rxi=rxi.rxi_id

  LEFT JOIN ord_orden AS ord
  ON rxi.rxi_id_ord=ord.ord_id

  LEFT JOIN fac_factura AS fac
  ON t1.moi_id_fac=fac.fac_id

  LEFT JOIN tif_tipo_factura AS tf
  ON fac.fac_id_tif=tf.tif_id

  LEFT JOIN prv_proveedor AS prv
  ON prv.prv_id=t1.moi_id_prv

  LEFT JOIN bod_bodega AS bod
  ON bod.bod_id=t1.moi_id_bod

  LEFT JOIN pai_pais ON prv_id_pai = pai_id
  LEFT JOIN mrp_marca_producto ON mrp_id = art_id_mrp
  WHERE tiat.tia_id=" . $id_cat ;

    if($id_bod>0){
        $query .= " AND t1.moi_id_bod = " . $id_bod;
    }

  $query .= " AND DATE(t1.moi_fecha_mov) BETWEEN '" . $fecha_ini . "' AND '" . $fecha_fin . "'
  GROUP BY t1.moi_id
  ORDER BY
  art_id, t1.moi_fecha_mov ASC
  ";
        /*  INNER JOIN mep_medida_producto as mart
          ON mart.mep_id=tart.art_id_mep */
        //echo $query.'<br/>';
        $detalle = $this->db->query($query);
        $detalle = $detalle->result_array();
        //print_r($this->db->last_query());exit();
        return $detalle;
    }

    public function proveedor_con_mov() {
/*        $query = "SELECT prv_id,prv_nombre
              FROM prv_proveedor
              WHERE prv_id IN (
                  SELECT moi_id_prv
                  FROM moi_movimiento_inv
                  GROUP BY moi_id_prv)";
        $result = $this->db->query($query)->result_array();*/

        $this->db->select("prv_proveedor.*")
                ->from('prv_proveedor')
                ->join('moi_movimiento_inv', 'moi_id_prv = prv_id')
                ->group_by('prv_id')
                ;
        $result = $this->db->get()->result_array();

        return $result;
    }

    function consulta_general($nombre_tabla) {
        $this->db->select('*');
        $this->db->from($nombre_tabla);

        $query = $this->db->get();
        return $query->result_array();
    }

    function consulta_condicion_resultado($tabla, $campo, $valor) {
        $this->db->select('*');
        $this->db->from($tabla);
        $this->db->where($campo, $valor);
        $query = $this->db->get();
        return $query->result_array();
    }

    function consulta_ejecutando_join($tabla, $cadena_campos, $cadena_relacion = null, $campo = '-', $valor = '-', $campo2 = '-', $valor2 = '-', $join_left=null) {
        $this->db->select($cadena_campos);
        $this->db->from($tabla);
        if ($cadena_relacion != null) {
            $dividir_cadena = explode("/", $cadena_relacion);
            foreach ($dividir_cadena as $key) {
                $construir_join = explode(",", $key);
                $this->db->join($construir_join[0], $construir_join[1]);
            }
        }
        if ($join_left != null) {
            $dividir_join = explode("/", $join_left);
            foreach ($dividir_join as $div) {
                $construir_join_left = explode(",", $div);
                $this->db->join($construir_join_left[0], $construir_join_left[1], 'left');
            }
        }
        if ($campo != '-' && $valor != '-') {
            $this->db->where($campo, $valor);
        }
        if ($campo2 != '-' && $valor2 != '-') {
            $this->db->where($campo2, $valor2);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function bodega_entrada($bodega_entrada) {
        $query = "SELECT * FROM bod_bodega
    INNER JOIN moi_movimiento_inv ON moi_id_bod = bod_id
    WHERE moi_id = " . $bodega_entrada;
        $resultado = $this->db->query($query);
        return $resultado->result_array();
    }

    public function bodega_salida($bodega_salida) {
        $query = "SELECT * FROM bod_bodega
    INNER JOIN moi_movimiento_inv ON moi_id_bod = bod_id
    WHERE moi_id = " . $bodega_salida;
        $resultado = $this->db->query($query);
        return $resultado->result_array();
    }

    function pdf_detalle_requisicion_inventario($id_solicitud) {
        $query = "SELECT distinct art_articulo.art_nombre,
    dri_detalle_requisicion_inventario.dri_cantidad,
    sar_saldo_articulo.sar_precio
    FROM    (   (   (   (   rxi_requisicion_inventario rxi_requisicion_inventario
     INNER JOIN
     users users
     ON (rxi_requisicion_inventario.rxi_id_user = users.id))
  INNER JOIN
  dri_detalle_requisicion_inventario dri_detalle_requisicion_inventario
  ON (dri_detalle_requisicion_inventario.dri_id_rxi =
    rxi_requisicion_inventario.rxi_id))
  INNER JOIN
  bod_bodega bod_bodega
  ON (rxi_requisicion_inventario.rxi_id_bod = bod_bodega.bod_id))
  INNER JOIN
  sar_saldo_articulo sar_saldo_articulo
  ON (sar_saldo_articulo.sar_id_bod = bod_bodega.bod_id))
  INNER JOIN
  art_articulo art_articulo
  ON (sar_saldo_articulo.sar_id_art = art_articulo.art_id)
  WHERE rxi_requisicion_inventario.rxi_id = 12";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function inventario_fisico($articulos, $bodega) {
        $query = "art_articulo.art_nombre,sum(sar_saldo_articulo.sar_cant_actual) as cantidad_sistema,sum(dif_cantidad) as cantidad_usuario";
        $this->db->select($query);
        $this->db->from('art_articulo');
        $this->db->join('sar_saldo_articulo', 'art_articulo.art_id = sar_saldo_articulo.sar_id_art');
        $this->db->join('inf_inventario_fisico', 'sar_saldo_articulo.sar_id_bod = inf_inventario_fisico.inf_id_bod');
        $this->db->join('dif_detalle_inventario_fisico', 'inf_inventario_fisico.inf_id = dif_detalle_inventario_fisico.dif_id_inf AND   dif_detalle_inventario_fisico.dif_id_art = sar_saldo_articulo.sar_id_art');
        $this->db->where('sar_id_bod', $bodega);
        $this->db->where_in('sar_id_art', $articulos);
        $this->db->group_by('art_articulo.art_nombre');
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    public function detalles_inventario($proceso, $fecha1, $fecha2) {
        $query = "moi_movimiento_inv.moi_detalle as detalle,moi_movimiento_inv.moi_fecha_mov as fecha,dee_detalle_mov.dee_cantidad as cantidad,dee_detalle_mov.dee_precio as precio,art_articulo.art_nombre as articulo,tia_tipo_articulos.tia_nombre as categoria,bod_bodega.bod_nombre as bodega,(dee_detalle_mov.dee_cantidad * dee_detalle_mov.dee_precio) as subtotal";
        $this->db->select($query);
        $this->db->from('moi_movimiento_inv');
        $this->db->join('dee_detalle_mov', 'moi_movimiento_inv.moi_id=dee_detalle_mov.dee_id_moi');
        $this->db->join('art_articulo', 'dee_detalle_mov.dee_id_art = art_articulo.art_id');
        $this->db->join('tia_tipo_articulos', 'art_articulo.art_id_tia = tia_tipo_articulos.tia_id');
        $this->db->join('bod_bodega', 'moi_movimiento_inv.moi_id_bod=bod_bodega.bod_id');
        $this->db->where('moi_movimiento_inv.moi_id_tip =', $proceso);
        $this->db->where('moi_movimiento_inv.moi_fecha_mov >=', $fecha1);
        $this->db->where('moi_movimiento_inv.moi_fecha_mov <=', $fecha2);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    public function ver_telefono($con_id) {
        $query = "tel_id, tel_telefono, tel_nombre";
        $this->db->select($query);
        $this->db->from('tel_telefono');
        $this->db->join('txc_telefonoxcontacto', 'txc_id_tel=tel_id');
        $this->db->where('txc_id_con =', $con_id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function ver_correo($con_id) {
        $query = "cor_id, cor_correo, cor_nombre";
        $this->db->select($query);
        $this->db->from('cor_correo');
        $this->db->join('cxc_correoxcontacto', 'cxc_id_cor=cor_id');
        $this->db->where('cxc_id_con =', $con_id);
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * @author René Castaneda
     * @param int id serie
     * @param array $otrosDatos sera un array para otros valores (otras salidas(aun no guardadas en la base))
     * @return un array con dos array (que indicaran el inicio y fin de los correlativos disponibles)
     */
    public function get_Correlativos_disponibles($id_serie, $otrosDatos = null) {
        //NOTA: Las condiciones consideran el cero como una posicion activa para un solo correlativo
        if ($id_serie > 0) { //verificar que sea un id valido
            //primero consultar los correlativos de tipo entrada
            $entradas = $this->db
                            ->select()
                            ->from("cor_correlativo")
                            ->where("cor_tipo", 1)
                            ->where("cor_id_ser", $id_serie)
                            ->order_by("cor_inicio", "ASC")
                            ->get()->result_array();
            //DECLARAR LOS ARRAY PARA GUARDAR EL INICIO Y FIN

            $valores_inicio = array();
            $valores_fin = array();
            $n_resultados = count($entradas);
            for ($i = 0; $i < $n_resultados; $i++) {
                $entrada_ini = $entradas[$i]['cor_inicio'];
                $entrada_fin = $entradas[$i]['cor_fin'];

                //PREGUNTAR SI EXISTEN OTROS DATOS
                if ($otrosDatos != null) {
                    $OdatosInicio = $otrosDatos[0]; //datos de inicio de correlativos que se tomanaran como salidas
                    $OdatosFin = $otrosDatos[1]; //datos de fin de correlativos que se tomanaran como salidas
                    //preguntar en que rango caben
                    //consultar los correlativos de salida que pertenecen (entran en el rango) a la entrada
                    $corr_salida = $this->get_correlativosSalida($id_serie, $entrada_ini, $entrada_fin);
                    $corrS_ini = $corr_salida[0];
                    $corrS_fin = $corr_salida[1];
                    //areglos para guardar aquellas salidas que petenescan al rango en curso
                    $array_salida_inicio = array();
                    $array_salida_fin = array();
                    for ($j = 0; $j < count($OdatosInicio); $j++) {
                        //preguntar cuales de los datos petenecen al registro de entrada en curso.
                        if ($OdatosInicio[$j] >= $entrada_ini and $OdatosFin[$j] <= $entrada_fin) {
                            $array_salida_inicio[] = $OdatosInicio[$j];
                            $array_salida_fin[] = $OdatosFin[$j];
                        }
                    }
                    //al final mezclar los arreglos  (y autodestruir las variables)
                    $corrS_ini = array_merge($corrS_ini, $array_salida_inicio);
                    sort($corrS_ini); //ordenar los datos
                    $corrS_fin = array_merge($corrS_fin, $array_salida_fin);
                    sort($corrS_fin); //ordenar los datos
                    $n_corr_salida = count($corrS_ini);
                } else {
                    //consultar los correlativos de salida que pertenecen (entran en el rango) a la entrada
                    $corr_salida = $this->get_correlativosSalida($id_serie, $entrada_ini, $entrada_fin);
                    $n_corr_salida = count($corr_salida[0]);
                    $corrS_ini = $corr_salida[0];
                    $corrS_fin = $corr_salida[1];
                }


                //preguntar si ya posee salidas
                if ($n_corr_salida > 0) {
                    $SalidasCorrelativoI = $corrS_ini;
                    $SalidasCorrelativoF = $corrS_fin;
                    //  echo print_r($SalidasCorrelativoI); print_r($SalidasCorrelativoF); die();
                    for ($k = 0; $k < $n_corr_salida; $k++) {
                        //preguntar si hay algun intervalo de 1 en cada rango (para catalogar como disponible)
                        //para el primer registro hace esto
                        if ($k == 0) {

                            if ($n_corr_salida == 1) { //en el caso de que tenga solamente una salida
                                //restar 1 al inicio porque (se debe excluir el mismo numero)
                                //recorrer las salidas
                                if ((($SalidasCorrelativoI[$k] - 1) - $entrada_ini) >= 0) {  //preguntar si hay disponibilidad al inicio
                                    $valores_inicio[] = $entrada_ini;
                                    $valores_fin[] = $SalidasCorrelativoI[$k] - 1;
                                }
                                if (($entrada_fin - ($SalidasCorrelativoF[$k] + 1)) >= 0) {  //preguntar si hay disponibilidad al final
                                    $valores_inicio[] = $SalidasCorrelativoF[$k] + 1;
                                    $valores_fin[] = $entrada_fin;
                                }
                            } else {  //en el caso de que tenga mas de una salida
                                //restar 1 al inicio porque (se debe excluir el mismo numero)
                                if ((($SalidasCorrelativoI[$k] - 1 ) - $entrada_ini) >= 0) {
                                    $valores_inicio[] = $entrada_ini;
                                    $valores_fin[] = $SalidasCorrelativoI[$k] - 1;
                                }
                            }
                        }
                        //preguntar si es el ultimo registro
                        elseif ($k == ($n_corr_salida - 1)) {  //restar uno por que k empieza desde cero.
                            //ir a la posición anterior
                            if ((($SalidasCorrelativoI[$k] - 1) - ($SalidasCorrelativoF[($k - 1)] + 1) ) >= 0) {  //preguntar si hay disponibilidad
                                $valores_inicio[] = $SalidasCorrelativoF[($k - 1)] + 1;
                                $valores_fin[] = $SalidasCorrelativoI[$k] - 1;
                            }

                            if (($entrada_fin - ($SalidasCorrelativoF[$k] + 1)) >= 0) {  //preguntar si hay disponibilidad al final
                                $valores_inicio[] = $SalidasCorrelativoF[$k] + 1;
                                $valores_fin[] = $entrada_fin;
                            }
                        } else { //si no es la posision final ni la posicion inicial entonces recorrer los registros.
                            //ir a la posición anterior
                            if (( ($SalidasCorrelativoI[$k] - 1) - ($SalidasCorrelativoF[($k - 1)] + 1) ) >= 0) {  //preguntar si hay disponibilidad
                                $valores_inicio[] = $SalidasCorrelativoF[($k - 1)] + 1;
                                $valores_fin[] = $SalidasCorrelativoI[$k] - 1;
                            }
                        }
                    } //END FOR CORRELATIVOS SALIDA
                } else { //si no poseen salidas entonces acumular el inicio y el fin de sus correlativos (como disponibles)
                    $valores_inicio[] = $entrada_ini;
                    $valores_fin[] = $entrada_fin;
                }
            }

            return array($valores_inicio, $valores_fin); //retornar en un array los dos arrays
        }
    }

    /**
     * @author René Castaneda
     */
    public function get_correlativosSalida($id_serie = null, $cor_ini = null, $cor_fin = null) {
        if ($cor_ini != null and $cor_fin != null and $id_serie != null) {
            //preguntar por las salidas pertenecientes al cor_inicio y cor_fin
            $salidasIni = array();
            $salidasFin = array();
            $consulta = $this->db
                            ->select()
                            ->from("cor_correlativo")
                            ->where("cor_id_ser=$id_serie AND cor_tipo=2  AND (cor_inicio BETWEEN $cor_ini AND $cor_fin) AND (cor_fin BETWEEN $cor_ini AND $cor_fin )", null, false)
                            ->order_by("cor_inicio", "ASC")
                            ->get()->result_array();

            foreach ($consulta as $fila) {
                $salidasIni[] = $fila["cor_inicio"];
                $salidasFin[] = $fila["cor_fin"];
            }
            return array($salidasIni, $salidasFin);
        }
    }

    public function get_categoriasPadre_hijos() {
        $query = $this->db->query("SELECT sub_cat.*,tia_tipo_articulo.tia_nombre AS padre FROM tia_tipo_articulo
              INNER JOIN tia_tipo_articulo AS  sub_cat ON tia_tipo_articulo.tia_id=sub_cat.tia_padre AND tia_tipo_articulo.tia_padre IS NULL
              UNION
              SELECT tia_tipo_articulo.*,tia_tipo_articulo.tia_padre AS padre FROM tia_tipo_articulo WHERE tia_tipo_articulo.tia_padre IS NULL
              ORDER BY tia_id DESC ")->result_array();
        $ids = array();
        foreach ($query as $fila) {
            $ids[] = $fila['tia_id'];
        }
        return (count($ids) > 0) ? implode(',', $ids) : '0';
    }

    function categorias_hijas_padres($id) {
        $query = $this->db->query("SELECT
    tia_id AS id,
    tia_nombre AS categoria,
    (
      SELECT
        tia_nombre
      FROM
        tia_tipo_articulo B
      WHERE
        B.tia_id = A.tia_padre

    ) AS departamento
  FROM tia_tipo_articulo A
  WHERE
  A.tia_id=$id")->result_array();
        return $query;
    }

    //fernando melendez

    public function obtener_caracteristicas() {
        $query = "car_id, car_nombre";
        $this->db->select($query);
        $this->db->from('car_caracteristica');
        $query = $this->db->get();
        return $query->result_array();
    }

    function get_caracteristica($categoria) {
        $query = $this->db->select('car_id,car_nombre')
                ->from('cxr_caractxtipo_articulo')
                ->join('car_caracteristica', 'cxr_id_car = car_id')
                ->where('cxr_id_tia', $categoria)
                ->where('cxr_estado', '1');
        //->get('cxr_caractxtipo_articulo')

        return $query->get()->result_array();
    }

    function get_caracteristica2($caracteristica) {
        $query = $this->db->select('cxr_id,cxr_id_car,car_nombre,tia_codigo,car_tipo')
                ->from('car_caracteristica')
                ->join('cxr_caractxtipo_articulo', 'cxr_id_car = car_id')
                ->join('tia_tipo_articulo', 'cxr_id_tia = tia_id')
                ->where('cxr_id_tia', $caracteristica)
                ->where('cxr_estado', '1');
        //->get('cxr_caractxtipo_articulo')

        return $query->get()->result_array();
    }

    function get_articulo_cma($articulo) {
        $query = $this->db->select('art_id, cma_id, cma_cantidad, art_nombre, mep_nombre, cva_id')
                ->from('art_articulo')
                ->join('cma_combo_articulo', 'cma_id_art_combo = art_id')
                ->join('cva_conversion_articulo', 'cva_id = cma_id_cva')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep')
                ->where('cma_id_art', $articulo)
                ->where('cma_estado', '1');
        //->get('cxr_caractxtipo_articulo')

        return $query->get()->result_array();
    }

    public function obt_cant_minimaYexistente($id_art, $bodega=null) {
        //$this->db->select('SUM(sar_cant_actual) AS suma, art_minimo, mep_nombre')
        $this->db->select('SUM(sar_cant_actual) AS suma, art_minimo')
                ->from('art_articulo')
                ->join('sar_saldo_articulo', 'sar_id_art = art_id', 'left')
                ->join('bod_bodega', 'bod_id = sar_id_bod', 'left')
                //->join('mep_medida_producto', 'mep_id = art_id_mep', left)
                ->where('art_id', $id_art);
                if($bodega!=null){
                  $this->db->where('bod_id', $bodega);
                }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function obt_cant_actual_existente() {
        $this->db->select('SUM(sar_cant_actual) AS suma, art_minimo, mep_nombre, art_id, bod_id, sar_precio')
                ->from('art_articulo')
                ->join('sar_saldo_articulo', 'sar_id_art = art_id', 'left')
                ->join('bod_bodega', 'bod_id = sar_id_bod', 'left')
                ->join('mep_medida_producto', 'mep_id = art_id_mep', 'left')
                ->group_by('art_id,bod_id');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function datos_generles_articulo($id_art) {
        $this->db->select('art_id,art_codigo,art_nombre,mep_nombre,cva_id')
                ->from('art_articulo')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
                ->where('art_id', $id_art);
        $query = $this->db->get();
        return $query->result_array();
    }

    function productos_requisicion_rxi_new($id_req) {

        $campos = "dri_id_art,rxi_estado, rxi_id_bod, tia_id, art_nombre, art_codigo, SUM(dri_cantidad) AS dri_cantidad,SUM(dri_cantidad_despacho) AS dri_cantidad_despacho,rxi_id_bod, mep_nombre";
        $this->db->select($campos);
        $this->db->from('dri_detalle_requisicion_inventario');

        $this->db->join('art_articulo', 'dri_id_art=art_id');
        $this->db->join('rxi_requisicion_inventario', 'dri_id_rxi=rxi_id');
        $this->db->join('tia_tipo_articulo', 'art_id_tia=tia_id');
        $this->db->join('mep_medida_producto', 'mep_id = art_id_mep');

        $this->db->where('rxi_id', $id_req);
        $this->db->where('(rxi_estado=3 OR rxi_estado=2)');
        $this->db->group_by('dri_id_art, rxi_id_bod, tia_id, art_nombre');

        $rs = $this->db->get();

        return $rs->result_array();
    }

    function num_max_requi() {

        $campos = "count(rxi_id) as maximo";
        $this->db->select($campos);
        $this->db->from('rxi_requisicion_inventario');
        $rs = $this->db->get();
        return $rs->result_array();
    }

    public function get_bodegas_usuario() {
        $id = $this->tank_auth->get_user_id();
        $this->db->select('*')
                ->from('bod_bodega')
                ->join('uxb_usuarioxbodega', 'uxb_id_bod = bod_id', 'left')
                ->where('uxb_id_usu', $id);
        $this->db->where('bod_estado', 1);
        $query = $this->db->get();
        return $query->result_array();
    }

    function productos_requisicion_rxi_new_1($id_req) {

        $campos = "dri_id_art,rxi_estado,rxi_fecha,moi_fecha_mov, rxi_id_bod, tia_id, art_nombre, art_codigo, SUM(dri_cantidad) AS dri_cantidad,SUM(dri_cantidad_despacho) AS dri_cantidad_despacho,rxi_id_bod, mep_nombre";
        $this->db->select($campos);
        $this->db->from('dri_detalle_requisicion_inventario');

        $this->db->join('art_articulo', 'dri_id_art=art_id', left);
        $this->db->join('rxi_requisicion_inventario', 'dri_id_rxi=rxi_id', left);
        $this->db->join('tia_tipo_articulo', 'art_id_tia=tia_id', left);
        $this->db->join('mep_medida_producto', 'mep_id = art_id_mep', left);
        $this->db->join('bod_bodega', 'rxi_id_bod = bod_id', left);
        $this->db->join('moi_movimiento_inv', 'moi_id = rxi_id_moi', left);

        $this->db->where('rxi_id', $id_req);
        $this->db->where('(rxi_estado=1 OR rxi_estado=2 OR rxi_estado=3 OR rxi_estado=4 OR rxi_estado=0)');
        $this->db->group_by('dri_id_art, rxi_id_bod, tia_id, art_nombre');

        $rs = $this->db->get();

        return $rs->result_array();
    }

    function get_roles_paso($where = null) {
        $query = $this->db->select()
                ->from('rxp_rolxpaso')
                ->join('rol_rol', 'rxp_id_rol = rol_id', 'inner')
                ->join('psf_paso_flujo', 'rxp_id_psf = psf_id', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_acciones_rol($where = null) {
        $query = $this->db->select()
                ->from('axr_accionxrol_paso')
                ->join('acc_accion', 'acc_id = axr_id_acc', 'inner')
                ->join('rxp_rolxpaso', 'axr_id_rxp = rxp_id', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('acc_id');

        return $query->get()->result_array();
    }

    function get_rol_usuario($where = null) {
        $query = $this->db->select()
                ->from('uxr_usuarioxrol')
                ->join('rol_rol', 'uxr_id_rol = rol_id', 'inner')
                ->join('usu_usuario', 'usu_id = uxr_id_usu', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_conversiones_producto($where = null) {

        $query = $this->db->select()
                ->from('cva_conversion_articulo')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_categorias_servicios($where = null) {

        $query = $this->db->select()
                ->from('cas_categoria_servicio')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_servicios_inventario($where = null) {

        $query = $this->db->select()
                ->from('sri_servicio_inventario')
                ->join('cas_categoria_servicio', 'cas_id=sri_id_cas', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_primer_paso_flujo($flujo_id) {
        $query = "SELECT * FROM psf_paso_flujo AS psf INNER JOIN flu_flujo AS flu
            ON flu.flu_id = psf.psf_id_flu WHERE psf.psf_id_flu = " . $flujo_id . "
            AND psf.psf_orden = (SELECT MIN(psf_orden) FROM psf_paso_flujo WHERE psf_id_flu = " . $flujo_id . ")";

        $result = $this->db->query($query);

        return $result->result_array();
    }

    function get_backlog_requisiciones($where = null, $area = 0) {

        $query = $this->db->select('*', false)
                ->from('rxi_requisicion_inventario')
                ->join('bod_bodega', 'bod_id = rxi_id_bod', 'left')
                ->join('sgr_seguimiento_requisicion', 'sgr_id_rxi = rxi_id', 'inner')
                ->join('psf_paso_flujo', 'psf_id = sgr_id_psf', 'inner')
                ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
                ->join('rxp_rolxpaso', 'rxp_id_psf = psf_id', 'inner')
                ->join('uxr_usuarioxrol', 'uxr_id_rol = rxp_id_rol', 'inner')
                ->join('users', 'id = uxr_id_usu', 'inner')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
        ;

        $this->db->where('(
		(
                    psf_area = 1
                    AND
                    (emp_id_are = ' . $area . ')
		)
		OR
		psf_area = 0
            )
        ');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_paso_anterior($registro, $tipo_flujo) {
        $paso_anterior = null;
        if ($registro != null && $tipo_flujo != null) {
            switch ($tipo_flujo) {
                case 1:
                    //SE OBTIENE EL ID_FLUJO
                    $flujo_id = $this->gsatelite->get_campo('rxi_requisicion_inventario', 'rxi_id_flu', array('rxi_id' => $registro));
                    //SE OBTIENE EL PASO ACTUAL
                    $paso_actual = $this->get_paso_actual($registro, $tipo_flujo);
                    //Si hay un paso actual se obtienen el paso anterior
                    if (count($paso_actual) > 0) {
                        $orden_actual = $paso_actual[0]['psf_orden'];
                        $where = array(
                            'rxi_id' => $registro,
                            'flu_id' => $flujo_id,
                            'psf_paso_siguiente <= ' => $orden_actual,
                            'psf_paso_siguiente > ' => 0
                        );
                        //Se obtiene el paso anterior, del orden siguiente.
                        $query = $this->db->select()
                                ->from('psf_paso_flujo')
                                ->join('flu_flujo', 'psf_id_flu = flu_id', 'inner')
                                ->join('rxi_requisicion_inventario', 'rxi_id_flu = flu_id')
                                ->where($where)
                                ->order_by('psf_orden', 'DESC')
                        ;
                        $paso_anterior = $query->get()->result_array();
                    }
                    break;
                case 2:
                    //SE OBTIENE EL ID_FLUJO
                    $flujo_id = $this->gsatelite->get_campo('orc_orden_compra', 'orc_id_flu', array('orc_id' => $registro));

                    //SE OBTIENE EL PASO ACTUAL
                    $paso_actual = $this->get_paso_actual($registro, $tipo_flujo);

                    //Si hay un paso actual se obtienen el paso anterior
                    if (count($paso_actual) > 0) {

                        $orden_actual = $paso_actual[0]['psf_orden'];

                        $where = array(
                            'orc_id' => $registro,
                            'flu_id' => $flujo_id,
                            'psf_paso_siguiente' => $orden_actual
                        );
                        //Se obtiene el paso anterior, del orden siguiente.
                        $query = $this->db->select()
                                ->from('psf_paso_flujo')
                                ->join('flu_flujo', 'psf_id_flu = flu_id', 'inner')
                                ->join('orc_orden_compra', 'orc_id_flu = flu_id')
                                ->where($where)
                        ;

                        $paso_anterior = $query->get()->result_array();
                    }
                    break;
                case 4:
                    //SE OBTIENE EL ID_FLUJO
                    $flujo_id = $this->gsatelite->get_campo('ccc_comparativo_cotizacion_compra', 'ccc_id_flu', array('ccc_id' => $registro));
                    //SE OBTIENE EL PASO ACTUAL
                    $paso_actual = $this->get_paso_actual($registro, $tipo_flujo);
                    //Si hay un paso actual se obtienen el paso anterior
                    if (count($paso_actual) > 0) {
                        $orden_actual = $paso_actual[0]['psf_orden'];
                        $where = array(
                            'ccc_id' => $registro,
                            'flu_id' => $flujo_id,
                            'psf_paso_siguiente <= ' => $orden_actual,
                            'psf_paso_siguiente > ' => 0
                        );
                        //Se obtiene el paso anterior, del orden siguiente.
                        $query = $this->db->select()
                                ->from('psf_paso_flujo')
                                ->join('flu_flujo', 'psf_id_flu = flu_id', 'inner')
                                ->join('ccc_comparativo_cotizacion_compra', 'ccc_id_flu = flu_id')
                                ->where($where)
                                ->order_by('psf_orden', 'DESC')
                        ;
                        $paso_anterior = $query->get()->result_array();
                    }                    
                    break;
            }
        }
        return $paso_anterior;
    }

    /*
     * tipo flujo: 1- Requisiciones, 2- Orden de Compra.
     */

    function get_paso_actual($registro, $tipo_flujo) {

        $paso_actual = null;
        if ($registro != null && $tipo_flujo != null) {

            switch ($tipo_flujo) {
                case 1:

                    $flujo_id = $this->gsatelite->get_campo('rxi_requisicion_inventario', 'rxi_id_flu', array('rxi_id' => $registro));

                    $where = array(
                        'psf_id_flu' => $flujo_id,
                        'sgr_id_rxi' => $registro,
                        'sgr_fecha_salida' => null
                    );

                    $query = $this->db->select()
                            ->from('sgr_seguimiento_requisicion')
                            ->join('psf_paso_flujo', 'psf_id = sgr_id_psf', 'inner')
                            ->where($where)
                    ;

                    $paso_actual = $query->get()->result_array();

                    break;
            }
        }
        return $paso_actual;
    }

    /*
     * tipo flujo: 1- Requisiciones, 2- Orden de Compra.
     */

    function get_paso_siguiente($registro, $tipo_flujo) {

        $paso_actual = null;
        if ($registro != null && $tipo_flujo != null) {

            switch ($tipo_flujo) {
                case 1:
                    //SE OBTIENE EL ID_FLUJO
                    $flujo_id = $this->gsatelite->get_campo('rxi_requisicion_inventario', 'rxi_id_flu', array('rxi_id' => $registro));

                    //SE OBTIENE EL PASO MENOR DEL FLUJO
                    $num_siguiente = $this->gsatelite->get_min('psf_paso_flujo', 'psf_orden', array('psf_id_flu' => $flujo_id));

                    $obligatorio = null;

                    //SE VERIFICA QUE EL PLAN CONTENGA UN PASO EN EL FLUJO.
                    //Como prioridad se busca un paso obligtorio
                    $where_obligatorios = array(
                        'psf_id_flu' => $flujo_id,
                        'sgr_id_rxi' => $registro,
                        'psf_obligatorio' => 1,
                        'sgr_fecha_salida' => null
                    );
                    $this->db->join('sgr_seguimiento_requisicion', 'psf_id = sgr_id_psf', 'inner');
                    $this->db->group_by('psf_orden');
                    $num_obligatorios = $this->gsatelite->count('psf_paso_flujo', $where_obligatorios);

                    //  Si no se encuentra un paso obligatorio en proceso
                    //  se busca un paso opcional
                    $where_opcionales = array(
                        'psf_id_flu' => $flujo_id,
                        'sgr_id_rxi' => $registro,
                        'psf_obligatorio' => 0,
                        'sgr_fecha_salida' => null
                    );
                    $this->db->join('sgr_seguimiento_requisicion', 'psf_id = sgr_id_psf', 'inner');
                    $this->db->group_by('psf_orden');
                    $num_opcionales = $this->gsatelite->count('psf_paso_flujo', $where_opcionales);


                    //   Se setea la variable $obligagorio con su valor respectivo dependiendo de
                    //   el tipo de paso que se encuentre
                    //   1: Obligatorio, 0: Opcional

                    if ($num_obligatorios > 0) {
                        $obligatorio = 1;
                    }
                    if ($num_opcionales > 0) {
                        $obligatorio = 0;
                    }

                    // SI SE TIENE UN PASO EN PROCESO SE OBTIENE DICHO PASO
                    if ($num_obligatorios > 0 || $num_opcionales > 0) {

                        $where_siguiente = array(
                            'psf_id_flu' => $flujo_id,
                            'sgr_id_rxi' => $registro,
                            'psf_obligatorio' => $obligatorio,
                            'sgr_fecha_salida' => null
                        );
                        $this->db->join('sgr_seguimiento_requisicion', 'psf_id = sgr_id_psf', 'inner');
                        $num_siguiente = $this->gsatelite->get_campo('psf_paso_flujo', 'psf_paso_siguiente', $where_siguiente);
                    }

                    $this->db->limit(1);
                    $paso_siguiente = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id_flu' => $flujo_id, 'psf_orden' => $num_siguiente));
                    break;
            }
        }
        return $paso_siguiente;
    }

    /*
     * tipo flujo: 1- Requisiciones, 2- Orden de Compra.
     */

    public function get_historial_paso($registro, $tipo_flujo) {

        $historial = null;
        if ($registro != null && $tipo_flujo != null) {

            switch ($tipo_flujo) {
                case 1:

                    $where = array(
                        'rxi_id' => $registro,
                    );

                    $query = $this->db->select("
                                psf_nombre as paso,
                                username as usuario_responsable,
                                CONCAT(emp_nombre,' ',emp_apellido) as responsable,
                                sgr_fecha_entrada as fecha_entrada,
                                sgr_fecha_salida as fecha_salida,
                                sgr_observacion as comentario,
                                sgr_anexo as anexo
                            "
                                    , false)
                            ->from('rxi_requisicion_inventario')
                            ->join('sgr_seguimiento_requisicion', 'sgr_id_rxi = rxi_id', 'inner')
                            ->join('psf_paso_flujo', 'psf_id = sgr_id_psf', 'inner')
                            ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
                            ->join('users', 'sgr_id_usu = id', 'inner')
                            ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                    ;

                    $this->db->where($where);
                    $this->db->order_by('sgr_fecha_entrada DESC');


                    $historial = $query->get()->result_array();

                    break;
            }
        }
        return $historial;
    }

    function get_articulosxcategoria($categoria, $servicios = null, $where = null) {
        $categorias_final = $this->crear_arbol($categoria, "");
        // $categorias_final=substr(($categorias_final), 0,-1);

        $categorias_final = $categorias_final . $categoria;

        if ($categoria == "null" || $categoria == null) {
            $categorias_final = null;
        }

        $query = $this->db->select("*,sum(sar_cant_actual) as saldo")
                ->from('art_articulo')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
                ->join('sar_saldo_articulo', 'sar_id_art=art_id ', 'left')
                ->join('cdp_codigo_producto', 'cdp_id_art = art_id', 'left')
                ->group_by('art_id');

        if ($categorias_final != null) {
            $categorias = explode(',', $categorias_final);

            $this->db->where_in('art_id_tia', $categorias);
        }

        if ($servicios == '1') {
            $this->db->where('art_tipo', 1);
        } else if($servicios == '4') {
            //$this->db->where('art_tipo', 1);
        } else {
            $this->db->where('art_tipo', 0);
        }

        if ($where != null) {
            $this->db->where($where);
        }


        return $query->get()->result_array();
    }

    function get_formulas($where = null, $ordenar = null) {
        $query = $this->db->select()
                ->from('foa_formula_articulo')
                ->join('dxf_detallexformula', 'dxf_id_foa = foa_id')
                ->join('cxu_caracxarticulo', 'cxu_id = dxf_id_cxu')
                ->join('cxr_caractxtipo_articulo', 'cxr_id = cxu_id_cxr')
                ->join('car_caracteristica', 'car_id = cxr_id_car')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($ordenar != null) {
            $this->db->group_by($ordenar);
        }
        return $query->get()->result_array();
    }

    function get_caracteristica_factura($where = null) {
        $query = $this->db->select()
                ->from('cxu_caracxarticulo')
                ->join('cxr_caractxtipo_articulo', 'cxr_id = cxu_id_cxr', 'inner')
                ->join('car_caracteristica', 'car_id = cxr_id_car', 'inner')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_caracteristica_precio($where = null) {
        $query = $this->db->select('vrl_precio_valor')
                ->from('vrl_valores_lista')
                ->join('car_caracteristica', 'vrl_id_car = car_id', 'inner')
                ->join('cxr_caractxtipo_articulo', 'cxr_id_car = car_id', 'inner')
                ->join('cxu_caracxarticulo','cxu_id_cxr = cxr_id','inner');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->row();
    }

    function get_medida($id_art, $defecto = null) {
        $consulta = 'mep_id, mep_nombre, cva_id, cva_defecto, cva_id_mep, cva_conversion, IF(cva_defecto > 0, 
            cva_id, (SELECT c.cva_id FROM cva_conversion_articulo c WHERE c.cva_id_art = ' . $id_art . ' AND c.cva_defecto = 1 
            AND c.cva_estado = 1 ORDER BY cva_id ASC LIMIT 1)) AS defecto';
        $query = $this->db->select($consulta, FALSE)
                ->from('mep_medida_producto')
                ->join('cva_conversion_articulo', 'cva_id_mep = mep_id')
                ->where('cva_id_art', $id_art)
                ->where('cva_estado', 1);
        if ($defecto == null) {
            $this->db->where('cva_defecto', 1);
        }
        return $query->get()->result_array();
    }

    function verificar_codigo($codigo, $id_edit) {
        $query = $this->db->select('art_id')
            ->from('art_articulo')
            ->join('cdp_codigo_producto', 'cdp_id_art = art_id', 'LEFT')
            ->where('art_id != ', $id_edit)
            ->where("(art_codigo = '$codigo' OR (cdp_codigo = '$codigo' AND cdp_estado = 1))")
            ->group_by('art_id')
        ;
        return $query->get()->result_array();
    }

//PENDIENTE
    function get_backlog_inventario_entrada($where = null) {
        /*
          SELECT
          moi_id,
          moi_movimiento_inv.moi_fecha_mov,
          prv_proveedor.prv_nombre,
          bod_bodega.bod_nombre,
          seb_sector_bodega.seb_nombre
          FROM
          moi_movimiento_inv
          INNER JOIN bod_bodega ON moi_movimiento_inv.moi_id_bod = bod_bodega.bod_id
          LEFT JOIN prv_proveedor ON moi_movimiento_inv.moi_id_prv = prv_proveedor.prv_id
          LEFT JOIN sxb_sectorxbodega ON sxb_sectorxbodega.sxb_id_bod = bod_bodega.bod_id AND moi_movimiento_inv.moi_id_sxb = sxb_sectorxbodega.sxb_id
          LEFT JOIN seb_sector_bodega ON sxb_sectorxbodega.sxb_id_seb = seb_sector_bodega.seb_id
          */
        $query = $this->db->select('*', false)
                ->from('moi_movimiento_inv')
                ->join('bod_bodega', 'bod_id = moi_id_bod', 'inner')
                ->join('prv_proveedor', 'prv_id = moi_id_prv', 'left')
                ->join('sxb_sectorxbodega', 'bod_id = sxb_id_bod', 'left')
                ->join('seb_sector_bodega', 'seb_id = sxb_id_seb', 'left')
                ->join('tip_tipo_proceso', 'tip_id = moi_id_tip', 'left')
                ->join('orc_orden_compra', 'moi_id_orc = orc_id', 'left')
                ->where('tip_entrada', 1)
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_backlog_inventario_salida($where = null) {
        $query = $this->db->select('*', false)
                ->from('moi_movimiento_inv')
                ->join('bod_bodega', 'bod_id = moi_id_bod', 'inner')
                ->join('prv_proveedor', 'prv_id = moi_id_prv', 'left')
                ->join('orc_orden_compra', 'moi_id_orc = orc_id', 'left')
                /* ->join('sxb_sectorxbodega','bod_id = sxb_id_bod','left')
                  ->join('seb_sector_bodega','seb_id = sxb_id_seb','left') */
                ->join('tip_tipo_proceso', 'tip_id = moi_id_tip', 'left')
                ->where('tip_salida', 1)
        //->order_by('moi_fecha_mov','desc')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_backlog_inventario_traslado($where = null) {
        $query = $this->db->select('tra_id, tra_id_moi_sal,
                tra_id_moi_ent,
                (
                  SELECT bod_nombre
                  FROM moi_movimiento_inv
                  INNER JOIN bod_bodega ON moi_id_bod = bod_id WHERE moi_id = tra_id_moi_sal
                ) as moi_salida,
                (
                  SELECT bod_nombre
                  FROM moi_movimiento_inv
                  INNER JOIN bod_bodega ON moi_id_bod = bod_id WHERE moi_id = tra_id_moi_ent
                ) as moi_entrada,
                (
                  SELECT suc_nombre
                  FROM moi_movimiento_inv
                  INNER JOIN bod_bodega ON moi_id_bod = bod_id
                  INNER JOIN suc_sucursal ON suc_id = bod_id_suc WHERE moi_id = tra_id_moi_sal
                ) as suc_salida,
                (
                  SELECT suc_nombre
                  FROM moi_movimiento_inv
                  INNER JOIN bod_bodega ON moi_id_bod = bod_id
                  INNER JOIN suc_sucursal ON suc_id = bod_id_suc WHERE moi_id = tra_id_moi_ent
                ) as suc_entrada,
                tra_descripcion,
                tra_id_tip,
                tra_fecha_translado, tra_correlativo', false)
                ->from('tra_translado')
                ->where('tra_estado', 1)
                ->order_by('tra_fecha_translado', 'desc')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
        /*
          SELECT
          tra_id_moi_sal,
          tra_id_moi_ent,
          (
          SELECT bod_nombre
          FROM moi_movimiento_inv
          INNER JOIN bod_bodega ON moi_id_bod = bod_id WHERE moi_id = tra_id_moi_sal
          ) as moi_salida,
          (
          SELECT bod_nombre
          FROM moi_movimiento_inv
          INNER JOIN bod_bodega ON moi_id_bod = bod_id WHERE moi_id = tra_id_moi_ent
          ) as moi_entrada,
          tra_fecha_translado
          FROM tra_translado

         */
    }

    //obtiene el codigo del producto, dependiendo de la categoria tomando en cuenta que el codigo se genera con el codigo de la categoria
    function get_correlativo($correlativo) {
        $query = $this->db->select('art_codigo')
                ->from('art_articulo')
                ->order_by('art_codigo', 'desc')
                ->like('art_codigo', $correlativo, 'after');
        return $query->get()->result_array();
    }

    //Muestra las caracteristicas en la grid
    function get_caracteristica_grid($tia_id) {
        $query = $this->db->select('car_nombre')
                ->from('car_caracteristica')
                ->join('cxr_caractxtipo_articulo', 'cxr_id_car = car_id')
                ->where('cxr_id_tia', $tia_id)
                ->where('cxr_estado', 1);
        return $query->get()->result_array();
    }

    //Muestra las caracteristicas en la grid
    function get_sector_grid($bod_id) {
        $query = $this->db->select()
                ->from('seb_sector_bodega')
                ->join('sxb_sectorxbodega', 'sxb_id_seb = seb_id')
                ->where('sxb_id_bod', $bod_id);
        return $query->get()->result_array();
    }

    function get_sectorxbodega($bod_id) {
        $query = $this->db->select('SUM(sar_cant_actual) as sar_cant_actual', false)
                ->from('sar_saldo_articulo')
                ->where('sar_id_bod', $bod_id);
        return $query->get()->result_array();
    }

    function get_medidas_articulo($id_art) {
        $query = $this->db->select('mep_nombre')
                ->from('mep_medida_producto')
                ->join('cva_conversion_articulo', 'cva_id_mep = mep_id')
                ->where('cva_id_art', $id_art)
                ->where('cva_estado', 1);
        return $query->get()->result_array();
    }

    function get_cantidad_bodega($art_tia, $bod_id, $sxb_id, $art_id = null) {
        $query = $this->db->select('art_id, art_codigo ,cva_id, cva_conversion, mep_nombre, bod_id, bod_nombre, art_nombre, SUM(sar_cant_actual) as cantidad, IFNULL(mma_minimo,"") minimo, IFNULL(mma_maximo,"") maximo ', false)
                ->from('sar_saldo_articulo')
                ->join('bod_bodega', 'bod_id = sar_id_bod')
                ->join('art_articulo', 'sar_id_art = art_id')
                ->join('mma_mimino_maximoxarticulo', 'mma_id_bod = bod_id AND mma_id_art = art_id', 'left')
                ->join('cva_conversion_articulo', 'cva_id_art = sar_id_art AND cva_defecto = 1')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep')
                ->where('bod_id', $bod_id)
                ->group_by('art_nombre');
        if ($sxb_id != null) {
            $this->db->where('sar_id_sxb', $sxb_id);
        }
        if ($art_tia != null) {
            $this->db->where('art_id_tia', $art_tia);
        }
        if ($art_id != null) {
            $this->db->where('art_id', $art_id);
        }
        return $query->get()->result_array();
        /*
          SELECT
          bod_id,
          bod_nombre,
          art_nombre,
          cva_conversion,
          SUM(sar_cant_actual) as cantidad
          FROM
          sar_saldo_articulo
          INNER JOIN bod_bodega ON bod_id = sar_id_bod
          INNER JOIN art_articulo ON sar_id_art = art_id
          INNER JOIN cva_conversion_articulo on cva_id_art = sar_id_art and cva_defecto = 1
          INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
          WHERE bod_id = 32
          GROUP BY art_nombre



          SELECT
          bod_id,
          bod_nombre,
          art_nombre,
          SUM(sar_cant_actual) as cantidad
          FROM
          sar_saldo_articulo
          INNER JOIN bod_bodega ON bod_id = sar_id_bod
          INNER JOIN art_articulo ON sar_id_art = art_id
          WHERE bod_id = 32
          GROUP BY art_nombre */
    }

    function mostrar_requisicion_salida($rxi_id, $dri_id_art = null) {
        $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');//pdte definir caso si es peps
        $query = $this->db->select("*, IF($costo_promedio > 0, (SELECT MAX(sar_precio) FROM sar_saldo_articulo WHERE sar_id_art = dri_id_art AND sar_id_bod = rxi_id_bod),0) AS costo", false)
                ->from('rxi_requisicion_inventario')
                ->join('dri_detalle_requisicion_inventario', 'dri_id_rxi = rxi_id')
                ->join('art_articulo', 'dri_id_art = art_id')
                ->join('cva_conversion_articulo', 'dri_id_cva = cva_id')
                ->join('mep_medida_producto', 'cva_id_mep = mep_id')
                ->join('bod_bodega', 'bod_id = rxi_id_bod')
                ->join('suc_sucursal', 'suc_id = bod_id_suc')
                ->where('rxi_id', $rxi_id)
                ->where('dri_estado', 1);
        if ($dri_id_art != null) {
            $this->db->where('dri_id_art', $dri_id_art);
        }
        return $query->get()->result_array();
        /* SELECT
          dri_detalle_requisicion_inventario.dri_id_art,
          art_articulo.art_nombre,
          art_articulo.art_codigo,
          mep_medida_producto.mep_nombre,
          rxi_requisicion_inventario.rxi_numero,
          dri_detalle_requisicion_inventario.dri_cantidad,
          cva_conversion_articulo.cva_id_mep
          FROM
          rxi_requisicion_inventario
          LEFT JOIN dri_detalle_requisicion_inventario ON dri_detalle_requisicion_inventario.dri_id_rxi = rxi_requisicion_inventario.rxi_id
          LEFT JOIN art_articulo ON dri_detalle_requisicion_inventario.dri_id_art = art_articulo.art_id
          LEFT JOIN cva_conversion_articulo ON dri_detalle_requisicion_inventario.dri_id_cva = cva_conversion_articulo.cva_id
          LEFT JOIN mep_medida_producto ON cva_conversion_articulo.cva_id_mep = mep_medida_producto.mep_id
          LEFT JOIN bod_bodega ON bod_id = rxi_id_bod
          LEFT JOIN suc_sucursal ON suc_id = bod_id_suc
          WHERE rxi_id = 3 */
    }

    function mostrar_detalle_factura($where = null) {
        $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');//pdte definir caso si es peps
        /* SELECT * FROM def_detalle_fact INNER JOIN art_articulo ON art_id = def_id_art INNER JOIN cva_conversion_articulo ON cva_id_art = art_id and cva_defecto = 1
            INNER JOIN mep_medida_producto ON mep_id = cva_id_mep WHERE art_inventario = 1 AND def_id_fac = 'XXX' */
        $query = $this->db->select("*, IF($costo_promedio > 0, (SELECT MAX(sar_precio) FROM sar_saldo_articulo WHERE sar_id_art = def_id_art AND sar_id_bod = def_id_bod),0) AS costo", false)
                ->from('def_detalle_fact')
                ->join('art_articulo', 'art_id = def_id_art', 'INNER')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1', 'INNER')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'INNER')
                ->where('art_inventario', 1)
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_detalles_nota_remision($where = null) {
        $query = $this->db->select("*, (SELECT c.cva_conversion FROM cva_conversion_articulo c WHERE c.cva_estado = 1 and c.cva_id_art = art_id and c.cva_defecto = 1) AS dfct", false)
                ->from('moi_movimiento_inv')
                ->join('dee_detalle_mov', 'dee_id_moi = moi_id')
                ->join('art_articulo', 'dee_id_art = art_id')
                ->join('cva_conversion_articulo', 'cva_id = dee_id_cva')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function mostrar_orden_compra_entrada($where = null) {
        $query = $this->db->select('*,
          art_id as id_art,
          (
            SELECT cva_1.cva_conversion FROM cva_conversion_articulo as cva_1
            WHERE cva_1.cva_estado = 1 and cva_1.cva_id_art = id_art and cva_defecto = 1
          ) as cva_defecto_actual', false)
                ->from('dor_detalle_orden_compra')
                ->join('art_articulo', 'dor_id_art = art_id')
                ->join('cva_conversion_articulo', 'dor_id_cva = cva_id')
                ->join('mep_medida_producto', 'cva_id_mep = mep_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
        /* SELECT * FROM dor_detalle_orden_compra
          INNER JOIN art_articulo ON art_id = dor_id_art
          LEFT JOIN cva_conversion_articulo ON dor_id_cva = cva_id
          LEFT JOIN mep_medida_producto ON cva_id_mep = mep_id; */
    }

    function mostrar_orden_compra_dpv($where = null) {
        $query = $this->db->select(
          '
            *, art_id AS id_art,
            (
                SELECT
                    cva_1.cva_conversion
                FROM
                    cva_conversion_articulo AS cva_1
                WHERE
                    cva_1.cva_estado = 1
                AND cva_1.cva_id_art = id_art
                AND cva_defecto = 1
            ) AS cva_defecto_actual,
            (
                SELECT dpv_numero_documento FROM dpv_documento_proveedor
                WHERE dxd_id_dpv = dpv_id
            ) AS dpv_numero
          ', false)
                ->from('dxd_detalle_documento_proveedor')
                ->join('art_articulo', 'dxd_id_art = art_id')
                ->join('cva_conversion_articulo', 'dxd_id_cva = cva_id')
                ->join('mep_medida_producto', 'cva_id_mep = mep_id')
                ->join('sxb_sectorxbodega','sxb_id = dxd_id_sxb','left')
                ->join('seb_sector_bodega','seb_id = sxb_id_seb','left')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_sar_cantidades($art_id, $bod_id = null, $where = null, $order_by  = null) {
        $query = $this->db->select('*')
        ->from('sar_saldo_articulo')
        ->join('dee_detalle_mov', 'dee_id_sar = sar_id', 'left')
        ->where('sar_id_art', $art_id)
        ->where('sar_cant_actual >', 0)
        ->group_by('sar_id');   
        ;

        if ($bod_id != null) {
            $this->db->where('sar_id_bod', $bod_id);
        }
        if ($where != null) {
            $this->db->where($where);
        }
        if ($order_by != null) {
            $this->db->order_by($order_by);
        } else {
            $this->db->order_by('sar_fecha_creacion', 'asc');
        }
        
        return $query->get()->result_array();
    }

    function get_salidas_dee($moi_id, $where = null) {
        $query = $this->db->select('art_codigo, tip_nombre, bod_nombre, moi_fecha_mov, moi_documento, moi_descripcion, mep_nombre, art_nombre, dee_id_art, dee_id_cva, cva_id, sar_id_sxb, IFNULL((SELECT CONCAT_WS(" ",emp_nombre, emp_apellido) FROM rxi_requisicion_inventario JOIN emp_empleado ON emp_id = rxi_id_emp WHERE rxi_id = moi_id_rxi), "") AS emp_solicita, IFNULL((SELECT are_nombre FROM rxi_requisicion_inventario JOIN emp_empleado ON emp_id = rxi_id_emp JOIN are_area ON are_id = emp_id_are WHERE rxi_id = moi_id_rxi), "") AS are_solicita, SUM(dee_cantidad) as cantidad, dee_precio, SUM(dee_subtotal) as dee_subtotal, IFNULL((SELECT rxi_numero FROM rxi_requisicion_inventario WHERE rxi_id = moi_id_rxi), "") AS rxi_numero,
            (SELECT cva_conversion FROM cva_conversion_articulo WHERE cva_id = dee_id_cva) AS multiplo, 
            (SELECT mep_nombre FROM cva_conversion_articulo JOIN mep_medida_producto ON mep_id = cva_id_mep WHERE cva_id = dee_id_cva) AS unidad_dee, dee_fecha_caducidad, 
            IFNULL((SELECT seb_nombre FROM sxb_sectorxbodega JOIN seb_sector_bodega ON seb_id = sxb_id_seb WHERE sxb_id = sar_id_sxb), "") AS sector', false)
                ->from('dee_detalle_mov')
                ->join('moi_movimiento_inv', 'moi_id = dee_id_moi')
                ->join('bod_bodega', 'bod_id = moi_id_bod')
                ->join('tip_tipo_proceso', 'tip_id = moi_id_tip')
                ->join('sar_saldo_articulo', 'sar_id = dee_id_sar')
                ->join('art_articulo','art_id = dee_id_art')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id')
                ->join('mep_medida_producto', 'cva_id_mep = mep_id')
                ->where('dee_id_moi', $moi_id)
                ->where('cva_defecto', 1)
                ->where('cva_estado', 1)
                ->group_by('dee_id_art');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_salidas_dee_fact($moi_id, $where = null) {
        $query = $this->db->select('art_codigo, tip_nombre, bod_nombre, moi_fecha_mov, moi_documento, moi_descripcion, mep_nombre, art_nombre, dee_id_art, dee_id_cva, cva_id, dee_id_sxb, SUM(dee_cantidad) as cantidad, dee_precio, SUM(dee_subtotal) as dee_subtotal, 
            (SELECT cva_conversion FROM cva_conversion_articulo WHERE cva_id = dee_id_cva) AS multiplo,
            IFNULL((SELECT CONCAT_WS(" ",emp_nombre, emp_apellido) FROM rxi_requisicion_inventario JOIN emp_empleado ON emp_id = rxi_id_emp WHERE rxi_id = moi_id_rxi), "") AS emp_solicita, 
            IFNULL((SELECT are_nombre FROM rxi_requisicion_inventario JOIN emp_empleado ON emp_id = rxi_id_emp JOIN are_area ON are_id = emp_id_are WHERE rxi_id = moi_id_rxi), "") AS are_solicita, 
            IFNULL((SELECT rxi_numero FROM rxi_requisicion_inventario WHERE rxi_id = moi_id_rxi), "") AS rxi_numero,
            (SELECT mep_nombre FROM cva_conversion_articulo JOIN mep_medida_producto ON mep_id = cva_id_mep WHERE cva_id = dee_id_cva) AS unidad_dee, cli_personeria, cli_apellido,
            cli_nombre, cli_direccion, tif_abreviacion, fac_numero', false)
                ->from('dee_detalle_mov')
                ->join('moi_movimiento_inv', 'moi_id = dee_id_moi')
                ->join('bod_bodega', 'bod_id = moi_id_bod')
                ->join('tip_tipo_proceso', 'tip_id = moi_id_tip')
                ->join('sar_saldo_articulo', 'sar_id = dee_id_sar')
                ->join('art_articulo','art_id = dee_id_art')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id')
                ->join('mep_medida_producto', 'cva_id_mep = mep_id')
                ->join('fac_factura', 'fac_id = moi_id_fac', 'left')
                ->join('cli_cliente', 'cli_id = fac_id_cli', 'left')
                ->join('tif_tipo_factura', 'tif_id = fac_id_tif', 'left')
                ->where('dee_id_moi', $moi_id)
                ->where('cva_defecto', 1)
                ->where('cva_estado', 1)
                ->group_by('dee_id_art');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_productos($where = null) {
        $query = $this->db->select('*')
                ->from('art_articulo')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id')
                ->join('mep_medida_producto', 'cva_id_mep = mep_id')
                ->join('mrp_marca_producto', 'mrp_id = art_id_mrp', 'left')
                ->where('cva_defecto', 1)
                ->where('cva_estado', 1);
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_traslados($where = null) {
        $query = $this->db->select('moi_id as id_moi, moi_fecha_mov, bod_nombre as bodega_salida, moi_id_bod, suc_nombre,
                (
                  SELECT CONCAT_WS(",", bod_id, bod_nombre, suc_nombre)
                  FROM
                    sar_saldo_articulo
                  INNER JOIN dee_detalle_mov ON sar_id = dee_id_sar
                  INNER JOIN moi_movimiento_inv ON dee_id_moi = moi_id
                  LEFT JOIN bod_bodega ON bod_id = sar_id_bod
                  INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip AND tip_traslado = 1
                  INNER JOIN suc_sucursal ON bod_id_suc = suc_id
                  where bod_id <> moi_id_bod AND dee_id_moi = id_moi GROUP BY bod_id
                ) as bodega_entrada', false)
                ->from('moi_movimiento_inv')
                ->join('bod_bodega', 'bod_id = moi_id_bod', 'inner')
                ->join('tip_tipo_proceso', 'tip_id = moi_id_tip', 'left')
                ->join('suc_sucursal', 'bod_id_suc = suc_id', 'inner')
                ->where('tip_traslado', 1)
                ->order_by('moi_id', 'desc')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_productosxbodega($where = null, $group = null) {
        if (isset($where['bod_id'])) {
        $query = $this->db->select('*')
                ->from('bod_bodega')
                ->join('sar_saldo_articulo', 'sar_id_bod = bod_id')
                ->join('art_articulo', 'art_id = sar_id_art')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id')
                ->join('mep_medida_producto', 'cva_id_mep = mep_id')
                ->join('tia_tipo_articulo', 'art_id_tia = tia_id')
                ->where('cva_defecto', 1)
                ->where('cva_estado', 1)
                ->order_by('art_id', 'desc')
        ;
        }
        else {
         
         $query = $this->db->select('*')
                 ->from('tia_tipo_articulo')
                 ->join('art_articulo', 'tia_id = art_id_tia')                            
                 ->order_by('art_id', 'desc')
         ;
            
        }

        if ($group != null) {
            $this->db->group_by($group);
        }
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
        /* SELECT
          bod_nombre,
          art_nombre,
          mep_nombre,
          tia_nombre,
          tia_padre
          FROM
          bod_bodega
          INNER JOIN sar_saldo_articulo ON sar_id_bod = bod_id
          INNER JOIN art_articulo ON art_id = sar_id_art
          INNER JOIN cva_conversion_articulo ON cva_id_art = art_id
          INNER JOIN mep_medida_producto  ON cva_id_mep = mep_id
          LEFt JOIN tia_tipo_articulo on art_id_tia = tia_id
          WHERE cva_defecto = 1 and cva_estado = 1 AND bod_id = 34
          GROUP BY art_id
          ORDER BY art_id desc */
    }

    function get_categoria_factura($group = null) {
        //$bod_id = $this->gsatelite->get_parametro('SYS_BODEGA_FACTURA');
        $bod_id = null;
        //$combinar =$this->gsatelite->get_parametro('SYS_PERMITE_FACTURAR_PRODUCTO_SERVICIO');
        $where_cadena = "(cva_defecto = 1 and cva_estado = 1)";

        if ($bod_id != null) {
            $where_cadena .= ' AND ((bod_id = ' . $bod_id . ' AND art_inventario = 1) OR art_tipo = 1 OR art_venta = 1)';
        } else {
            $where_cadena .= ' AND (art_tipo = 1 OR art_venta = 1)';
        }
        $query = "SELECT
                  (SELECT SUM(sar_cant_actual) FROM sar_saldo_articulo WHERE sar_id_art = art_id) as cantidad,
                  tia_id,
                  art_codigo,
                  tia_nombre,
                  art_venta,
                  art_inventario,
                  art_id,
                  art_nombre,
                  art_tipo,
                  tia_padre,
                  bod_id,
                  cva_defecto,
                  cva_id_mep,
                  mep_nombre,
                  gra_id
                FROM
                  art_articulo
                LEFT JOIN cva_conversion_articulo ON cva_id_art = art_id
                LEFT JOIN mep_medida_producto ON mep_id = cva_id_mep
                LEFT JOIN tia_tipo_articulo ON tia_id = art_id_tia
                LEFT JOIN sar_saldo_articulo ON sar_id_art = art_id
                LEFT JOIN bod_bodega ON bod_id = sar_id_bod
                LEFT JOIN gra_grupo_academico ON gra_id_art = art_id
                WHERE $where_cadena
                GROUP BY $group
                ORDER BY art_id";

        $detalle = $this->db->query($query)->result_array();
        return $detalle;
        /* $query = $this->db->select('
          (SELECT SUM(sar_cant_actual) FROM sar_saldo_articulo WHERE sar_id_art = art_id) as cantidad,
          tia_id,
          tia_nombre,
          art_venta,
          art_inventario,
          art_id,
          art_nombre,
          art_tipo,
          tia_padre,
          bod_id,
          cva_defecto,
          cva_id_mep,
          mep_nombre
          ', false)
          ->from('art_articulo')
          ->join('cva_conversion_articulo', 'cva_id_art = art_id','left')
          ->join('mep_medida_producto', 'cva_id_mep = mep_id','left')
          ->join('tia_tipo_articulo', 'art_id_tia = tia_id','left')
          ->join('sar_saldo_articulo', 'art_id = sar_id_art','left')
          ->join('bod_bodega', 'bod_id = sar_id_bod','left')
          ->order_by('art_id','desc')
          ; */

        //return $query->get()->result_array();
    }

    function get_categoria_factura2($group = null) {
        //$bod_id = $this->gsatelite->get_parametro('SYS_BODEGA_FACTURA');
        $bod_id = null;
        //$combinar =$this->gsatelite->get_parametro('SYS_PERMITE_FACTURAR_PRODUCTO_SERVICIO');
        //$where_cadena = "(cva_defecto = 1 and cva_estado = 1)";
        $query = $this->db->select('art_id, art_nombre, art_tipo, bod_id, mod_id, art_codigo, tia_codigo, tia_nombre, tia_id, art_venta, art_inventario, tia_padre', false)
                      ->from('art_articulo')
                      ->join('tia_tipo_articulo','tia_id = art_id_tia', 'left')
                      ->join('sar_saldo_articulo','sar_id_art = art_id', 'left')
                      ->join('bod_bodega','bod_id = sar_id_bod', 'left')
                      ->join('mod_modulo','mod_id_art = art_id', 'left')
                      ->group_by($group)
                      ->order_by('art_id')
        ;

        if ($bod_id != null) {
            $this->db->where('bod_id', $bod_id)
                      ->where('art_inventario', 1)
                      ->or_where('art_tipo', 1)
                      ->or_where('art_venta', 1);
            //$where_cadena .= '((bod_id = ' . $bod_id . ' AND art_inventario = 1) OR art_tipo = 1 OR art_venta = 1)';
        } else {
            $this->db->where('art_tipo', 1)
                      ->or_where('art_venta', 1);
            //$where_cadena .= '(art_tipo = 1 OR art_venta = 1)';
        }
        $detalle = $query->get()->result_array();
        //$detalle = $this->db->query($query)->result_array();
        return $detalle;
    }

    function get_detalle_producto($where = null) {
        $query = $this->db->select()
                ->from('art_articulo')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_saldo_anterior($where = null) {
        /* SELECT
          IF(tip_entrada = 1, dee_cantidad,null) as cantidad_entrada, IF(tip_entrada = 1, dee_subtotal,null) as total_entrada,
          IF(tip_salida = 1, dee_cantidad,null) as cantidad_salida, IF(tip_salida = 1, dee_subtotal,null) as total_salida
          from dee_detalle_mov
          INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
          INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
          where  moi_id_bod = 34 and dee_id_art = 267
          ORDER BY moi_fecha_mov ASC; */
        $query = $this->db->select('dee_id, dee_precio,
            IF(tip_entrada = 1, dee_cantidad,null) as cantidad_entrada, IF(tip_entrada = 1, dee_subtotal,null) as total_entrada,
            IF(tip_salida = 1, dee_cantidad,null) as cantidad_salida, IF(tip_salida = 1, dee_subtotal,null) as total_salida
        ', false)
                ->from('dee_detalle_mov')
                ->join('moi_movimiento_inv', 'moi_id = dee_id_moi')
                ->join('tip_tipo_proceso', 'tip_id = moi_id_tip')
                ->order_by('moi_fecha_mov', 'ASC')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_tia_padres($where = null) {
        $query = $this->db->select('*')
                ->from('tia_tipo_articulo');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
        /* SELECT
          tia_nombre,
          tia_padre
          FROM tia_tipo_articulo
          WHERE tia_id = 117 */
    }

    function get_costo_promedio($where = null) {
        $query = $this->db->select('sar_id,
            (select CONCAT_WS(" ",
            sum(IF(tip_entrada = 1, dee_cantidad,0)), sum(IF(tip_entrada = 1, dee_subtotal,0)),
            sum(IF(tip_salida = 1, dee_cantidad,0)), sum(IF(tip_salida = 1, dee_subtotal,0)))
            from dee_detalle_mov
            INNER JOIN moi_movimiento_inv on moi_id = dee_id_moi
            INNER JOIN tip_tipo_proceso on moi_id_tip = tip_id
            where dee_id_sar = sar_id) as valores', false)
                ->from('sar_saldo_articulo')
                ->join('dee_detalle_mov', 'dee_id_sar = sar_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        //$this->db->
        $this->db->order_by('sar_fecha_creacion', 'asc');
        return $query->get()->result_array();
        /*
          SELECT
          sar_id,
          (select CONCAT_WS(" ",
          sum(IF(tip_entrada = 1, dee_cantidad,0)), sum(IF(tip_entrada = 1, dee_subtotal,0)),
          sum(IF(tip_salida = 1, dee_cantidad,0)), sum(IF(tip_salida = 1, dee_subtotal,0)))
          from dee_detalle_mov
          INNER JOIN moi_movimiento_inv on moi_id = dee_id_moi
          INNER JOIN tip_tipo_proceso on moi_id_tip = tip_id
          where dee_id_sar = sar_id)
          from sar_saldo_articulo
          WHERE sar_id_art = 267 and sar_id_bod = 34
          ORDER BY sar_fecha_creacion asc



          $query = $this->db->select('sum(dee_cantidad) as cantidad, sum(dee_subtotal) as precio')
          ->from('dee_detalle_mov')
          ->join('moi_movimiento_inv','moi_id = dee_id_moi')
          ->join('tip_tipo_proceso','moi_id_tip = tip_id')
          ;
          if($where != null){
          $this->db->where($where);
          }
          return $query->get()->result_array();


          select sum(dee_cantidad), sum(dee_subtotal)
          from dee_detalle_mov
          INNER JOIN moi_movimiento_inv on moi_id = dee_id_moi
          INNER JOIN tip_tipo_proceso on moi_id_tip = tip_id
          where dee_id_sar = 420 and tip_salida = 1


          $query = $this->db->select('SUM(sar_precio*sar_cant_actual) as total, SUM(sar_cant_actual) as cantidad')
          ->from('art_articulo')
          ->join('sar_saldo_articulo','sar_id_art = art_id')
          ->join('bod_bodega','bod_id = sar_id_bod')
          ->group_by('art_id')
          ;
          if($where != null){
          $this->db->where($where);
          }
          FROM
          art_articulo
          INNER JOIN sar_saldo_articulo ON sar_id_art = art_id
          INNER JOIN bod_bodega ON bod_id = sar_id_bod
          WHERE art_id = 293 and bod_id = 34
          GROUP BY art_id */
    }

    function get_requisicionxmovimiento($where = null) {
        $query = $this->db->select()
                ->from('rxi_requisicion_inventario')
                ->join('dri_detalle_requisicion_inventario', 'dri_id_rxi = rxi_id')
                ->join('dxm_detallexmovimiento', 'dxm_id_dri = dri_id')
                ->join('moi_movimiento_inv', 'moi_id = dxm_id_moi')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
        /* SELECT * from rxi_requisicion_inventario
          INNER JOIN dri_detalle_requisicion_inventario on dri_id_rxi = rxi_id
          INNER JOIN dxm_detallexmovimiento ON dxm_id_dri = dri_id
          INNER JOIN moi_movimiento_inv ON moi_id = dxm_id_moi */
    }

    function get_impuestos_producto($where = null) {

        $query = $this->db->select()
                ->from('ixa_impuestoxarticulo')
                ->join('imp_impuesto', 'imp_id = ixa_id_imp', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_sector_producto($where = null) {
        $query = $this->db->select()
                ->from('moi_movimiento_inv')
                ->join('dee_detalle_mov', 'moi_id = dee_id_moi')
                ->join('sar_saldo_articulo', 'dee_id_sar = sar_id')
                ->group_by('sar_id_sxb')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
        /*
          SELECT * from moi_movimiento_inv
          INNER JOIN dee_detalle_mov on moi_id = dee_id_moi
          INNER JOIN sar_saldo_articulo on dee_id_sar = sar_id
          where moi_id_bod = 36 and sar_id_art = 265
          GROUP BY sar_id_sxb
         */
    }

    function get_orden_compra($where = null) {
        $query = $this->db->select("*, (SELECT SUM(dpv_estado) FROM dpv_documento_proveedor WHERE dpv_id_orc = orc_id AND dpv_afecta_inventario = 0) as activo_dpv,
            (SELECT dpv_id FROM dpv_documento_proveedor WHERE dpv_id_orc = orc_id AND dpv_afecta_inventario = 0 LIMIT 1) as dpv_exist,
            (SELECT IF(prv_tipo_pers > 1, prv_apellido, CONCAT(prv_nombre,' ',prv_apellido)) FROM prv_proveedor WHERE prv_id = orc_id_prv) AS proveedor", false)
                ->from("orc_orden_compra")
                ->join("rxi_requisicion_inventario", "rxi_id = orc_id_rxi", "left")
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
        /*
          SELECT *,
          (
          SELECT
          CONCAT_WS(',',SUM(dpv_estado),COUNT(dpv_id) )
          from dpv_documento_proveedor
          where dpv_id_orc = orc_id and dpv_afecta_inventario = 0
          ) as activo_orc,
          (
          SELECT
          dpv_id
          from dpv_documento_proveedor
          where dpv_id_orc = orc_id and dpv_afecta_inventario = 0 limit 1
          ) as dpv_exist
          from orc_orden_compra
          LEFT JOIN rxi_requisicion_inventario ON rxi_id = orc_id_rxi
          WHERE orc_id = 22
          GROUP BY orc_id





          SELECT *,
          (
          SELECT
          CONCAT_WS(',',SUM(dpv_estado),COUNT(dpv_id) )
          from dpv_documento_proveedor
          where dpv_id_orc = orc_id
          ) as activo_orc
          from orc_orden_compra
          LEFT JOIN dpv_documento_proveedor ON dpv_id_orc = orc_id
          LEFT JOIN rxi_requisicion_inventario ON rxi_id = orc_id_rxi
          where orc_id = 35
          GROUP BY orc_id

          SELECT * from orc_orden_compra
          LEFT JOIN dpv_documento_proveedor ON dpv_id_orc = orc_id
          LEFT JOIN rxi_requisicion_inventario ON rxi_id = orc_id_rxi */
    }

    function get_dpv_bodega($where = null) {
        /* SELECT * from dpv_documento_proveedor
          INNER JOIN dxd_detalle_documento_proveedor on dxd_id_dpv = dpv_id
          INNER JOIN bod_bodega ON bod_id = dxd_id_bod
          where dpv_id_orc = 41
          GROUP BY dxd_id_bod */
        $query = $this->db->select("*, if(prv_tipo_pers=1, CONCAT_WS(' ',prv_nombre,prv_apellido), prv_apellido) as proveedor", FALSE)
                ->from('dpv_documento_proveedor')
                ->join('dxd_detalle_documento_proveedor', 'dxd_id_dpv = dpv_id')
                ->join('bod_bodega', 'bod_id = dxd_id_bod')
                ->join('prv_proveedor', 'dpv_id_prv = prv_id')
                ->group_by('dpv_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_sucursalxusuario($where = null) {
        $query = $this->db->select()
                ->from('suc_sucursal')
                ->join('bod_bodega', 'bod_id_suc = suc_id', 'inner')
                ->join('uxb_usuarioxbodega', 'uxb_id_bod = bod_id', 'inner')
                ->where('uxb_id_usu', $this->tank_auth->get_user_id())
                ->group_by('suc_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_impuestos_categoria($where = null) {
        $query = $this->db->select()
                ->from('ixr_impuestox_tipo_articulo')
                ->join('imp_impuesto', 'imp_id = ixr_id_imp', 'inner')
                ->group_by('imp_id')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_impuestos_edit_dpv($where = null) {
        $query = $this->db->select()
                ->from('imp_impuesto')
                ->join('ixr_impuestox_tipo_articulo', 'ixr_id_imp = imp_id AND ixr_estado = 1', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_impuestos_edit_dpv2($where = null) {
        $query = $this->db->select()
                ->from('imp_impuesto')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }



    public function get_caracteristicas_producto($where = null) {
        $query = $this->db->select()
                ->from('cxu_caracxarticulo')
                ->join('cxr_caractxtipo_articulo', 'cxr_id = cxu_id_cxr', 'inner')
                ->join('car_caracteristica', 'cxr_id_car = car_id', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_caracteristicas_formula($where = null) {
        $query = $this->db->select()
                ->from('dxf_detallexformula')
                ->join('cxu_caracxarticulo', 'cxu_id = dxf_id_cxu', 'inner')
                ->join('cxr_caractxtipo_articulo', 'cxr_id = cxu_id_cxr', 'inner')
                ->join('car_caracteristica', 'cxr_id_car = car_id', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /*
     * Mod: Mario Marquez
     * $where: Condicional de busqueda
     */

    function listado_empleados($where = null) {
        $query = "username, email,id,emp_nombre,emp_apellido,are_id,are_nombre,suc_nombre,emp_id";
        $this->db->select($query);
        $this->db->from('emp_empleado');
        $this->db->join('users', 'users.id = emp_empleado.emp_id_usu', 'left');
        $this->db->join('are_area', 'are_area.are_id = emp_empleado.emp_id_are', 'left');
        $this->db->join('suc_sucursal', 'suc_id = emp_empleado.emp_id_suc', 'left');

        if ($where == null) {
            $this->db->where($where);
        }
        $rs = $this->db->get();
        return $rs->result_array();
    }

    public function consultar_movimientos_articulo($where = null, $group_by = null, $order_by = null) {
        $script = "art_nombre AS nombre,art_codigo AS codigo, art_id, dee_id AS id_dee, art_foto AS foto, bod_id, dee_id_sar AS id_sar,
            dee_id_art AS id_articulo, moi_fecha_mov, bod_nombre AS bodega,
            ((SELECT SUM(dee_cantidad) FROM dee_detalle_mov JOIN moi_movimiento_inv ON moi_id = dee_id_moi JOIN tip_tipo_proceso ON tip_id = moi_id_tip 
                WHERE tip_entrada = 1 AND dee_id_art = art_id AND DATE(moi_fecha_mov) < '2020-09-01' AND moi_id_bod = bod_id) -
                IFNULL((SELECT SUM(dee_cantidad) FROM dee_detalle_mov JOIN moi_movimiento_inv ON moi_id = dee_id_moi JOIN tip_tipo_proceso ON tip_id = moi_id_tip 
                WHERE tip_salida = 1 AND dee_id_art = art_id AND DATE(moi_fecha_mov) < '2020-09-01' AND moi_id_bod = bod_id),0)
            ) AS saldo_ini,
            SUM(IF(tip_entrada = 1,dee_cantidad,0)) AS Entradas,
            SUM(IF(tip_salida = 1, dee_cantidad, 0)) AS Salidas,
            ((SELECT SUM(dee_cantidad) FROM dee_detalle_mov
                INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                WHERE tip_entrada = 1 AND dee_id_art = art_id AND moi_id_bod = bod_id
                )
                -
                IFNULL((SELECT SUM(dee_cantidad) FROM dee_detalle_mov
                    INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                    INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                    WHERE tip_salida = 1 AND dee_id_art = art_id AND moi_id_bod = bod_id
                    ),0
                )
            ) AS Saldo,
            mrp_nombre AS marca";
        $query = $this->db->select($script, false)
                ->from('dee_detalle_mov')
                ->join('moi_movimiento_inv', 'moi_id = dee_id_moi')
                ->join('tip_tipo_proceso ', 'tip_id = moi_id_tip')
                ->join('bod_bodega', 'bod_id = moi_id_bod')
                ->join('art_articulo', 'art_id = dee_id_art')
                ->join('mrp_marca_producto', 'mrp_id = art_id_mrp', 'left')
        ;
        if ($where != null) {
            $this->db->where($where, null, false);
        }

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    public function get_max_codigo($tabla, $campo) {
        $this->db->select('MAX( CAST(' . $campo . ' as unsigned integer)) as codigo', FALSE)
                ->from($tabla)
        ;
        $result = $this->db->get();
        return $result->row();
    }

    public function get_articulosxcaracteristicas($where = null, $group_by = null) {

        $script = "*";
        if ($group_by != null) {
            $script = "art_articulo.*,
            GROUP_CONCAT(car_nombre) as caracteristicas,
            GROUP_CONCAT(car_descripcion) as carac_descripcion,
            GROUP_CONCAT(cxu_valor) as carac_valores, mrp_nombre AS marca";
        }


        $query = $this->db->select($script, false)
                ->from('art_articulo')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia', 'inner')
                ->join('cxu_caracxarticulo', 'art_id = cxu_id_art', 'left')
                ->join('cxr_caractxtipo_articulo', 'cxr_id = cxu_id_cxr', 'left')
                ->join('car_caracteristica', 'car_id = cxr_id_car', 'left')
                ->join('mrp_marca_producto', 'mrp_id=art_id_mrp', 'left')
                //->join('vrl_valores_lista', 'car_id = vrl_id_car','left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }

        return $query->get()->result_array();
    }

    public function get_proveedores($where = null) {
        $query = $this->db->select()
                ->from('prv_proveedor')
                ->join('acp_act_economica_prov', 'acp_id = prv_id_acp', 'left')
                ->join('mun_municipio', 'mun_id = prv_id_mun', 'left')
                ->join('dep_departamento', 'dep_id = mun_id_dep', 'left')
                ->join('pai_pais', 'pai_id  = prv_id_pai', 'left')
                ->join('tap_tamano_prov', ' tap_id = prv_id_tap', 'left')
                ->join('gir_giro', 'gir_id = prv_id_gir', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_productos_like($where = null, $like = null) {
        $categorias_final = null;
        if (isset($where['art_id_tia'])) {
            $categorias_final = $this->crear_arbol($where['art_id_tia'], "");
            $categorias_final = $categorias_final . $where['art_id_tia'];
            unset($where['art_id_tia']);
        }
        $query = $this->db->select("*, SUM(sar_cant_actual) AS saldo, (SELECT IFNULL(mrp_nombre, '') FROM mrp_marca_producto WHERE mrp_id = art_id_mrp) AS mrp_nombre", false)
                ->from('art_articulo AS art')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
                ->join('sar_saldo_articulo', 'sar_id_art=art_id ', 'left')
                ->join('bod_bodega', 'bod_id = sar_id_bod', 'left')
                ->where('art_estado', 1)
        ;
        if ($categorias_final != null) {
            $categorias = explode(',', $categorias_final);
            $this->db->where_in('art_id_tia', $categorias);
        }
        if ($where != null) {
            $this->db->where($where);
        }
        if ($like != null) {
          $this->db->where('( art_nombre LIKE "%'.$like.'%" OR art_codigo LIKE "%'.$like.'%" OR art_sinonimo LIKE "%'.$like.'%" OR art_id IN (SELECT art_id  FROM art_articulo AS art2 INNER JOIN cdp_codigo_producto ON cdp_id_art= art2.art_id WHERE art2.art_id=art.art_id AND cdp_codigo  LIKE "%'.$like.'%"))', null, FALSE);
        }
        $this->db->group_by('art_id');
        return $query->get()->result_array();
    }

    function consultaxcategoria_productos($tia, $bdg, $furgon = '', $codigo = null) {
        if (empty($furgon)) {
            $variable = "";
            $ixc = "";
        }
        //print_r($codigo);exit();
        if ($codigo == 2) {
            $condicion_codigo = " Saldo = 0";
        } elseif ($codigo == 1) {
            $condicion_codigo = " Saldo <> 0";
        } elseif ($codigo == null) {
            $condicion_codigo = " (Saldo <> 0 OR  Saldo = 0)";
        } elseif ($codigo == 3) {
            $condicion_codigo = " Salidas = 0";
        }
        //print_r($condicion_codigo);exit();
        $query = "SELECT
                  art_nombre AS nombre,
                  art_codigo AS codigo,
                  art_id AS id_art,
                  art_foto AS foto,
                  tia_id AS id_tipo_art,
                  mep_nombre AS UM,
                  mep_id AS id_um,
                  sar_id AS id_sar,
                  art_foto AS foto,
                  sar_id_art AS id_articulo,";
        $query .= " bod_nombre AS bodega,

                  (
                    SELECT
                      SUM(dee_cantidad)
                    FROM
                      dee_detalle_mov
                    INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                    INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                    INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
                    WHERE
                      tip_entrada = 1
                    AND sar_id_art = art_id
                    AND sar_id_bod = bod_id
                    ";

        $query .= " AND moi_id NOT IN (
                      SELECT
                        tra_id_moi_ent
                      FROM
                        tra_translado
                    )
                  ) AS Entradas,
                  (
                    SELECT
                      IFNULL(SUM(dee_cantidad), 0)
                    FROM
                      dee_detalle_mov
                    INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                    INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                    INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
                    WHERE
                      tip_salida = 1
                      AND sar_id_art = art_id
                      AND sar_id_bod = bod_id
                    ";

        $query .= " AND moi_id NOT IN (
                      SELECT
                        tra_id_moi_sal
                      FROM
                        tra_translado
                    )
                  ) AS Salidas,
                  (
                    (
                      SELECT
                        SUM(dee_cantidad)
                      FROM
                        dee_detalle_mov
                      INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                      INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                      INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
                      WHERE
                        tip_entrada = 1
                        AND sar_id_art = art_id
			AND sar_id_bod = bod_id
                     ";
        $query .= " AND moi_id NOT IN (
                        SELECT
                          tra_id_moi_ent
                        FROM
                          tra_translado
                      )
                    ) - IFNULL(
                      (
                        SELECT
                          SUM(dee_cantidad)
                        FROM
                          dee_detalle_mov
                        INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                        INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                        INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
                        WHERE
                          tip_salida = 1
                          AND sar_id_art = art_id
                          AND sar_id_bod = bod_id
                       ";

        $query .= " AND moi_id NOT IN (
                          SELECT
                            tra_id_moi_sal
                          FROM
                            tra_translado
                        )
                      ),
                      0
                    )
                  ) AS Saldo,
                  sar_cant_actual AS cant_actual,
                  sar_precio AS precio_compra, mrp_nombre as marca
                FROM
                  dee_detalle_mov";
        $query .= " INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
                INNER JOIN art_articulo ON art_id = sar_id_art
                INNER JOIN tia_tipo_articulo ON tia_id = art_id_tia
                INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                INNER JOIN bod_bodega ON bod_id = sar_id_bod

                INNER JOIN cva_conversion_articulo on cva_id_art = dee_id_art and cva_defecto = 1
                INNER JOIN mep_medida_producto ON mep_id= cva_id_mep
                LEFT JOIN mrp_marca_producto ON mrp_id = art_id_mrp
                WHERE
                  sar_id_bod = " . $bdg . "
                 AND art_id_tia = " . $tia . "
                 AND moi_id NOT IN (
                  SELECT
                    tra_id_moi_ent
                  FROM
                    tra_translado
                )" . $variable;


        $ordernar_por = "codigo";
        $query .= " GROUP BY art_id";
        $query .= " HAVING " . $condicion_codigo . " ORDER BY
                  $ordernar_por ASC"; //codigo
        $informacion = $this->db->query($query)->result_array();
        return $informacion;
    }

    function get_productos_combo($where = null) {
        $query = $this->db->select('*, (
                SELECT
                    cva_conversion
                FROM
                    cva_conversion_articulo cva1
                WHERE
                    cva1.cva_id_art = cma_id_art
                AND cva1.cva_defecto = 1
            ) conversion_defecto, 
            (SELECT mep_nombre FROM cva_conversion_articulo JOIN mep_medida_producto ON cva_id_mep = mep_id WHERE cva_id = cma_id_cva) AS mep_nombre')
                ->from('cma_combo_articulo')
                ->join('art_articulo', 'cma_id_art_combo = art_id', 'inner')
                ->join('cva_conversion_articulo', 'cva_id = cma_id_cva', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author: Elman Ortiz
     * @descripcion: Se obtienen los subtotales por cada categoria(tipo articulo) producto en base al dee_id_moi
     * @return: Arreglo con art_nombre, tia_nombre, dee_id_art, dee_id_moi, tia_id, SUM(dee_subtotal)
     */
    function get_subtotales_categoriaprod($id_movimiento) {
        $query = $this->db->select('art_nombre, tia_nombre, tia_id, dee_id_art, dee_id_moi, SUM(dee_subtotal) AS newsubtotal')
                ->from('moi_movimiento_inv')
                ->join('dee_detalle_mov', 'moi_id = dee_id_moi')
                ->join('art_articulo', 'art_id = dee_id_art')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
                ->where('dee_id_moi', $id_movimiento)
                ->group_by('tia_id');

        return $query->get()->result_array();
    }

    //Fin get_subtotales_categoriaprod

    /**
     * @author: Elman Ortiz
     * @descripcion: Se obtienen las cuentas por cada tipo de cuentas devuelto por el metodo get_subtotales_categoriaprod()
     * @return: Array con los datos de la cuenta
     */
    function get_cuenta_categoria($where) {
        $query = $this->db->select('*')
                ->from('dta_detalle_tipoarticulo')
                ->join('tcn_tipo_cuenta', 'tcn_id = dta_id_tcn', 'inner')
                ->join('cnt_cuenta_contable', 'cnt_id = dta_id_cnt', 'inner')
                ->join('cec_centro_costo', 'cec_id = dta_id_cec', 'left')
                ->join('bod_bodega', 'bod_id = dta_id_bod', 'left')
                ->join('pai_pais', 'pai_id = dta_id_pai', 'left')
                ->where($where);

        return $query->get()->result_array();
    }

//Fin get_cuenta_categoria

    /**
     * @author: Elman Ortiz
     * @descripcion:
     * @return:
     */
    function get_cuenta_contable($where) {
        //$query = $this->db->select('dfp_id_cnt')->from('tip_tipo_proceso')->join('dfp_detalle_finanza_proveedor', 'prv_id = dfp_id_prv')->join('tcn_tipo_cuenta', 'tcn_id = dfp_id_tcn')->where($where);
        $query = $this->db->select('dfp_id_cnt')
                  ->from('prv_proveedor')
                  ->join('dfp_detalle_finanza_proveedor', 'prv_id = dfp_id_prv')
                  ->join('tcn_tipo_cuenta', 'tcn_id = dfp_id_tcn')
                  ->where($where)
                  ->limit(1);
        return $query->get()->result_array();
    }

    /**
     * @author: Elman Ortiz
     * @descripcion:
     * @return:
     */
    function get_cuenta_contable_entrada_inventario($where) {
        $query = $this->db->select('ctp_id_cnt')
                   ->from('tip_tipo_proceso')
                   ->join('ctp_cuenta_tipo_proceso', 'ctp_id_tip = tip_id')
                   ->join('cnt_cuenta_contable', 'ctp_id_cnt = cnt_id')
                   ->where($where)
                   ->limit(1);

        return $query->get()->result_array();
    }

    /**
     * @author: Elman Ortiz
     * @descripcion:
     * @return:
     */
    function get_cuenta_contable_salida_inventario($where) {
        $query = $this->db->select('*')
                ->from('cli_cliente')
                ->join('cxn_cuentaxcliente', 'cli_id = cxn_id_cli')
                ->join('tcn_tipo_cuenta', 'tcn_id = cxn_id_tcn')
                ->where($where);

        return $query->get()->result_array();
        //return print_r($this->db->last_query()); die();
    }

    /**
     * @author: Elman Ortiz
     * @descripcion: Obtener el numero de la factura a partir de moi_id
     * @return: fac_numero
     */
    function get_fac_num($moi_id) {
        $query = $this->db->select('fac_numero')
                ->from('fac_factura')
                ->join('moi_movimiento_inv', 'fac_id = moi_id_fac')
                ->where('moi_id', $moi_id);

        return $query->get()->result_array();
    }

    /**
     * @author: Elman Ortiz
     * @descripcion: Se obtienen los subtotales por cada cuenta contable a la que pertenece el producto en base al dee_id_moi
     * @return: Arreglo con dee_id_moi, tia_nombre, cnt_nombre, cnt_cuenta, SUM(dee_subtotal) AS newsubtotal
     */
    function get_subtotales_cuentaprod($id_movimiento, $idtipo_cnt) {
        // (SELECT SUM(dxd_subtotal) FROM dxd_detalle_documento_proveedor WHERE dxd_id_dpv = dpv_id AND dxd_id_art = dee_id_art)
      $query = $this->db->select('dee_id_moi, art_id ,tia_nombre, 
              SUM(dee_subtotal) AS newsubtotal,
              (
                select dta_id_cnt
                from dta_detalle_tipoarticulo
                join ctp_cuenta_tipo_proceso
                where dta_id_tia = tia_id
                AND dta_id_tcn = '.$idtipo_cnt.'
                AND dta_id_bod = moi_id_bod
                AND dta_id_tcn = ctp_id_tcn
                AND dta_id_bod = ctp_id_bod
                AND dta_id_cec = ctp_id_cec
                AND dta_id_tia = art_id_tia
                AND ctp_id_tip = moi_id_tip
                limit 1
              ) AS cnt_id')

              //$this->db->select('cnt_id_tcn, dee_id_moi, art_id ,tia_nombre, cnt_id, cnt_nombre, cnt_cuenta, SUM(dee_subtotal)/COUNT(dee_subtotal) AS newsubtotal')
              ->from('dee_detalle_mov')
              ->join('moi_movimiento_inv', 'moi_id = dee_id_moi')
              ->join('art_articulo', 'art_id = dee_id_art and art_inventario = 1')
              ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
              ->join('dpv_documento_proveedor', 'dpv_id = moi_id_dpv', 'left')
              //->join('dta_detalle_tipoarticulo', 'dta_id_tia = tia_id', 'left')
              //->join('cnt_cuenta_contable', 'cnt_id = dta_id_cnt', 'left')
              ->where("dee_id_moi=".$id_movimiento, NULL, FALSE)
              //->where("(dee_id_moi=".$id_movimiento." AND (ISNULL(dta_estado) OR dta_estado = 1))", NULL, FALSE)
              //->where('dee_id_moi', $id_movimiento)
              //->group_by('tia_id, cnt_id');
              ->group_by('cnt_id');

      return $query->get()->result_array();
      //return print_r($this->db->last_query());
    }
    //Fin get_subtotales_categoriaprod

    function get_caracteristicas($car_id){
      $this->db->select('*');
      $this->db->from('car_caracteristica');
      $this->db->join('vrl_valores_lista','car_id =vrl_id_car','left');
      $this->db->where(array('car_id'=>$car_id));
      $carac = $this->db->get()->result_array();
      return $carac;
    }

    function get_datos_caracteristicas($where = NULL){
        $this->db->select('cxr_id, cxr_id_car, cxu_id, cxu_id_art, cxu_valor, car_tipo, vrl_id, vrl_valor');
        $this->db->from('cxr_caractxtipo_articulo');
        $this->db->join('car_caracteristica','car_id = cxr_id_car');
        $this->db->join('cxu_caracxarticulo','cxu_id_cxr = cxr_id');
        $this->db->join('vrl_valores_lista','vrl_id_car = cxr_id_car','LEFT');
        $this->db->where('cxu_estado', 1);

        if ($where != NULL) {
            $this->db->where($where);
        }
        $carac = $this->db->get()->result_array();
        return $carac;
    }

    function delete_caracteristica($where){
      $this->db->select('*');
      $this->db->from('car_caracteristica');
      $this->db->join('cxr_caractxtipo_articulo', 'car_id = cxr_id_car');
      $this->db->where($where);
      $result = $this->db->get()->result_array();

      if(count($result) == 0){
        $this->db->delete('car_caracteristica', $where);
        $this->db->affected_rows();
        return 1;
      }else{
        return 0;
      }
    }

    /**
    * @author Habby Lovo
    * @since 2017-09-26
    * @return Categorias de los productos
    * @param $where array asociativo para condicionar
    */
    public function get_productos_slcAjax($producto, $where = null) {
        $this->db->select();
        $this->db->from('art_articulo');
        $this->db->like('art_nombre', $producto);
        $this->db->or_like('art_codigo', $producto);
        $this->db->limit(100);

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->where('art_estado', 1);
        $query = $this->db->get();

        return $query->result_array();
    }

    public function get_caracteristicas_det_factura($where = null){
        /*
            SELECT * FROM cxd_caracteristicaxdetalle_factura
            INNER JOIN cxu_caracxarticulo ON cxu_id = cxd_id_cxu
            inner JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
            INNER JOIN car_caracteristica ON car_id = cxr_id_car
            where cxd_id_def = 259
        */
        $query = $this->db->select()
                        ->from('cxd_caracteristicaxdetalle_factura')
                        ->join('cxu_caracxarticulo','cxu_id = cxd_id_cxu','inner')
                        ->join('cxr_caractxtipo_articulo','cxr_id = cxu_id_cxr','inner')
                        ->join('car_caracteristica','car_id = cxr_id_car','inner')
        ;
        if($where != null){
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    /*
      verifica si el producto nuevo tiene igual unidad de medida
    */
    public function verificar_um($where = null, $cva = null){
      /*
        SELECT art_nombre, cva_id, cva_defecto, mep_nombre FROM
art_articulo
INNER JOIN cva_conversion_articulo ON cva_id_art = art_id
INNER join mep_medida_producto ON mep_id = cva_id_mep
WHERE  art_id = 264
      */
        $query = $this->db->select()
                    ->from('art_articulo')
                    ->join('cva_conversion_articulo', 'cva_id_art = art_id', 'inner')
                    ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
        ;
        if($cva != null){
            $this->db->where('mep_id = (
                    SELECT
                        mep.mep_id
                    FROM
                        mep_medida_producto AS mep
                    INNER JOIN cva_conversion_articulo AS cva ON cva.cva_id_mep = mep.mep_id
                    WHERE
                        cva.cva_id = '.$cva.'
                )');
        }

        if($where != null){
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
    * @author Habby Lovo
    * @since 2017-10-04
    * @return Detalle de la grid para el reporte de requisiciones
    */
    public function get_reporte_requisiciones($where = null, $modulo = 1) {
        /*
            SELECT
                rxi_id,
                rxi_numero,
                bod_nombre,
                CONCAT(
                    emp_nombre,
                    ' ',
                    emp_apellido
                ),
                are_nombre,
                CASE rxi_estado
                    WHEN 0 THEN
                        'Despachada'
                    WHEN 1 THEN
                        'Creada'
                    WHEN 2 THEN
                        'Pendiente de Autorizacion'
                    WHEN 3 THEN
                        'Autorizada'
                    WHEN 4 THEN
                        'Rechazada'
                    WHEN 5 THEN
                        'Anulada'
                    WHEN 6 THEN
                        'Parcial'
                END AS estado
            FROM
                rxi_requisicion_inventario
            INNER JOIN bod_bodega ON bod_id = rxi_id_bod
            INNER JOIN emp_empleado ON emp_id = rxi_id_emp
            INNER JOIN are_area ON are_id = emp_id_are
        */
        $this->db->select("rxi_id,orc_id,
                rxi_numero,
                bod_nombre,
                ord_codigo,
                CONCAT(
                    emp_nombre,
                    ' ',
                    emp_apellido
                ) as nombre,
                are_nombre,
                CASE rxi_estado
                    WHEN 0 THEN
                        'Despachada'
                    WHEN 1 THEN
                        'Creada'
                    WHEN 2 THEN
                        'Pendiente de Autorizacion'
                    WHEN 3 THEN
                        'Autorizada'
                    WHEN 4 THEN
                        'Rechazada'
                    WHEN 5 THEN
                        'Anulada'
                    WHEN 6 THEN
                        'Parcial'
                END AS estado", false);
        $this->db->from('rxi_requisicion_inventario');
        $this->db->join('bod_bodega','bod_id = rxi_id_bod','left');
        $this->db->join('ord_orden','ord_id = rxi_id_ord','left');
        $this->db->join('orc_orden_compra','orc_id_rxi = rxi_id','left');
        if($modulo == 1){
            $this->db->join('emp_empleado','emp_id = rxi_id_emp','left');
        } else if($modulo == 2){
            $this->db->join('emp_empleado','emp_id_usu = rxi_id_usu_solicita','inner');
        }
        $this->db->join('are_area','are_id = emp_id_are','left');

        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
    * @author Habby Lovo
    * @since 2017-10-04
    * @return detalles de la requisicion
    */
    public function get_reporte_requisiciones_detalle($where = null, $modulo = 1) {
        /*
            SELECT
                rxi_id,
                rxi_numero,
                CONCAT(
                    emp_nombre,
                    ' ',
                    emp_apellido
                ) AS nombre,
                are_nombre,
                bod_nombre,
                rxi_descripcion,
                art_codigo,
                art_nombre,
                mep_nombre,
                rxi_fecha,
                (
                    SELECT
                        CONCAT_WS(" ", sum(IF(tip_entrada = 1, dee_cantidad, 0)),   sum(IF(tip_salida = 1, dee_cantidad, 0)))
                    FROM
                        moi_movimiento_inv
                    INNER JOIN dee_detalle_mov ON dee_id_moi = moi_id
                    INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                    WHERE
                        dee_id_art = art_id
                    AND moi_fecha_mov <= rxi_fecha
                ) as cantidad_actual,
                dri_cantidad
            FROM
                rxi_requisicion_inventario
            INNER JOIN bod_bodega ON bod_id = rxi_id_bod
            INNER JOIN emp_empleado ON emp_id = rxi_id_emp
            INNER JOIN are_area ON are_id = emp_id_are
            INNER JOIN dri_detalle_requisicion_inventario ON dri_id_rxi = rxi_id
            INNER JOIN art_articulo ON art_id = dri_id_art
            INNER JOIN cva_conversion_articulo ON cva_id = dri_id_cva
            INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
        */
        $this->db->select('rxi_id,orc_id,
                rxi_numero,
                CONCAT(
                    emp_nombre,
                    " ",
                    emp_apellido
                ) AS nombre,
                are_nombre,
                bod_nombre,
                rxi_descripcion,
                art_codigo,
                art_nombre,
                mep_nombre,
                rxi_fecha,
                ord_codigo,
                (
                    SELECT
                        CONCAT_WS(" ", sum(IF(tip_entrada = 1, dee_cantidad, 0)),   sum(IF(tip_salida = 1, dee_cantidad, 0)))
                    FROM
                        moi_movimiento_inv
                    INNER JOIN dee_detalle_mov ON dee_id_moi = moi_id
                    INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                    WHERE
                        dee_id_art = art_id
                    AND moi_fecha_mov <= rxi_fecha
                ) as cantidad_actual,
                dri_cantidad,dri_cantidad_despacho, mrp_nombre AS marca', false);
        $this->db->from('rxi_requisicion_inventario');
        $this->db->join('bod_bodega','bod_id = rxi_id_bod','left');
        $this->db->join('ord_orden','ord_id = rxi_id_ord','left');
        $this->db->join('orc_orden_compra','orc_id_rxi = rxi_id','left');
        if($modulo == 1){
            $this->db->join('emp_empleado','emp_id = rxi_id_emp','LEFT');
        } else if($modulo == 2){
            $this->db->join('emp_empleado','emp_id_usu = rxi_id_usu_solicita','inner');
        }
        $this->db->join('are_area','are_id = emp_id_are','LEFT');
        $this->db->join('dri_detalle_requisicion_inventario','dri_id_rxi = rxi_id','inner');
        $this->db->join('art_articulo','art_id = dri_id_art','inner');
        $this->db->join('cva_conversion_articulo','cva_id = dri_id_cva','inner');
        $this->db->join('mep_medida_producto','mep_id = cva_id_mep','inner');
        $this->db->join('mrp_marca_producto','mrp_id = art_id_mrp','left');
        //$this->db->join('flu_flujo','flu_id = rxi_id_flu','inner');
        $this->db->group_by("art_id");

        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
    * @author Habby Lovo
    * @since 2017-10-11
    * @return reporte historico de existencias
    */
    public function get_reporte_historico($where = null) {
        /*
            SELECT
              moi_id,
              moi_id_bod,
              bod_nombre,
              tia_nombre,
              art_codigo,
              art_nombre,
              mep_nombre,
              moi_fecha_mov,
              dee_codigo_lote,
              SUM(

                IF (
                  tip_entrada = 1,
                  dee_cantidad,
                  0
                )
              ) as entradas,
              SUM(

                IF (
                  tip_salida = 1,
                  dee_cantidad,
                  0
                )
              ) as salidas,
              IF (
                  tip_entrada = 1,
                  1,
                  0
                ) as tipo
            FROM
              moi_movimiento_inv
            INNER JOIN bod_bodega ON bod_id = moi_id_bod
            INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
            INNER JOIN dee_detalle_mov ON dee_id_moi = moi_id
            INNER JOIN art_articulo ON art_id = dee_id_art
            INNER JOIN cva_conversion_articulo ON cva_id = dee_id_cva
            INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
            INNER JOIN tia_tipo_articulo ON tia_id = art_id_tia
            GROUP BY
              DATE_FORMAT(moi_fecha_mov, "%Y-%m-%d"),
              art_id,
              moi_id_bod,
            tipo
            ORDER BY
              art_id, moi_fecha_mov ASC
        */
        $this->db->select('moi_id,
                    moi_id_bod,
                    bod_nombre,
                    tia_nombre,
                    art_id,
                    art_codigo,
                    art_nombre,
                    mep_nombre,
                    dee_codigo_lote,
                    max(moi_fecha_mov) as fecha_movimiento,
                    SUM(

                        IF (
                            tip_entrada = 1,
                            dee_cantidad,
                            0
                        )
                    ) as entradas,
                    SUM(

                        IF (
                            tip_salida = 1,
                            dee_cantidad,
                            0
                        )
                    ) as salidas,
                    IF (
                            tip_entrada = 1,
                            1,
                            0
                        ) as tipo
                    ', false);
        $this->db->from('moi_movimiento_inv');
        $this->db->join('bod_bodega','bod_id = moi_id_bod','inner');
        $this->db->join('tip_tipo_proceso','tip_id = moi_id_tip','inner');
        $this->db->join('dee_detalle_mov','dee_id_moi = moi_id','inner');
        $this->db->join('art_articulo','art_id = dee_id_art','inner');
        $this->db->join('cva_conversion_articulo','cva_id = dee_id_cva','inner');
        $this->db->join('mep_medida_producto','mep_id = cva_id_mep','inner');
        $this->db->join('tia_tipo_articulo','tia_id = art_id_tia','inner');
        $this->db->group_by("DATE(moi_fecha_mov)");
        $this->db->group_by('art_id');
        $this->db->group_by('moi_id_bod');
        $this->db->group_by('tipo');
        $this->db->order_by('art_id','ASC');
        $this->db->order_by('moi_fecha_mov','ASC');
        $this->db->order_by('moi_id_bod','ASC');
        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
    * @author Elman Ortiz
    * @since 2017-10-11
    * @return Get tipo de lista de precio dependiendo de
    */
    public function get_tipo_lista_precio($where = null) {
      $this->db->select('*', false);
      $this->db->from('lip_listado_precio');
      $this->db->join('tlp_tipo_lista_precio','tlp_id = lip_id_tlp');
      $this->db->join('tpn_tipo_precio_cliente','tpn_id_tlp = tlp_id');
      $this->db->group_by('tlp_id');
      if ($where != null) {
          $this->db->where($where);
      }
      $query = $this->db->get();
      return $query->result_array();
    }

    /**
    * @author Habby Lovo
    * @since 2017-12-21
    * @return nos devuelve las categorias del producto
    */
    function get_categoria_factura3($group = null, $bod_id = null) {
      $query = $this->db->select('art_id, art_nombre, art_tipo, bod_id, mod_id, art_codigo, tia_codigo, tia_nombre, tia_id, art_venta, art_inventario, tia_padre, tia_estado, art_sinonimo, cdp_codigo', false)
                    ->from('art_articulo')
                    ->join('tia_tipo_articulo','tia_id = art_id_tia', 'left')
                    ->join('sar_saldo_articulo','sar_id_art = art_id', 'left')
                    ->join('bod_bodega','bod_id = sar_id_bod', 'left')
                    ->join('mod_modulo','mod_id_art = art_id', 'left')
                    ->join('cdp_codigo_producto','cdp_id_art = art_id', 'left')
                    //->group_by($group)
                    ->order_by('art_id')
      ;
      if($group != null){
        $this->db->group_by($group);
      }

      if ($bod_id != null) {
          $this->db->where('bod_id', $bod_id)
                    ->where('art_inventario', 1)
                    ->or_where('art_tipo', 1)
                    ->or_where('art_venta', 1);
          //$where_cadena .= '((bod_id = ' . $bod_id . ' AND art_inventario = 1) OR art_tipo = 1 OR art_venta = 1)';
      } else {
          $this->db->where('art_tipo', 1)
                    ->or_where('art_venta', 1);
          //$where_cadena .= '(art_tipo = 1 OR art_venta = 1)';
      }
      $detalle = $query->get()->result_array();
      //$detalle = $this->db->query($query)->result_array();
      return $detalle;
    }

    /**
    * @author Francisco Orozco
    * @since 2018-01-19
    * @return Devuelve los productos de un documento de un proveedor
    */
    function get_productos_documento_proveedor($where = null){
        $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');//pdte definir caso si es peps
        $this->db->select("*, 
            (SELECT SUM(sar_cant_actual) FROM sar_saldo_articulo WHERE sar_id_bod = dxd_id_bod AND sar_id_art = dxd_id_art) AS existencia,
            (SELECT dpv_numero_documento FROM dpv_documento_proveedor WHERE dxd_id_dpv = dpv_id) AS dpv_numero, 
            (SELECT cva_id FROM cva_conversion_articulo c2 WHERE c2.cva_estado = 1 AND c2.cva_id_art = dxd_id_art AND c2.cva_defecto =  1) AS defecto,
            IF($costo_promedio > 0, (SELECT MAX(sar_precio) FROM sar_saldo_articulo WHERE sar_id_art = dxd_id_art AND sar_id_bod = dxd_id_bod),0) AS costo
            ", false)
        ->from('dxd_detalle_documento_proveedor')
        ->join('art_articulo','art_id = dxd_id_art')
        ->join('cva_conversion_articulo','cva_id = dxd_id_cva')
        ->join('mep_medida_producto','mep_id = cva_id_mep')
        ->join('sxb_sectorxbodega','sxb_id_bod = dxd_id_bod','left')
        ->join('seb_sector_bodega','seb_id = sxb_id_seb','left')
        ->group_by('art_id')
        ;
        if($where != null){
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
    * @author Francisco Orozco
    * @since 2018-01-10
    * @return Devuelve los documentos del proveedor que no tienen salida
    */
    function get_documento_proveedor($where = null){
        $this->db->select('*')
                    ->from('dpv_documento_proveedor')
                    ->join('dxd_detalle_documento_proveedor','dxd_id_dpv = dpv_id')
                    ->join('moi_movimiento_inv','moi_id_dpv = dpv_id')
                    ->join('tip_tipo_proceso','tip_id = moi_id_tip')
                    ->join('prv_proveedor','prv_id = dpv_id_prv')
                    ->group_by('dpv_id')
        ;

        if($where != null){
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * @author: Luis Navarro
     * @descripcion: Se obtienen las cuentas por tipo de proceso
     * @return: Array con los datos de la cuenta
     */
    function get_cuenta_tipo_proceso($where = null) {
        $query = $this->db->select()
                ->from('ctp_cuenta_tipo_proceso')
                ->join('tcn_tipo_cuenta', 'tcn_id = ctp_id_tcn', 'inner')
                //->join('cnt_cuenta_contable', 'cnt_id = ctp_id_cnt', 'inner')
                ->join('cec_centro_costo', 'cec_id = ctp_id_cec', 'left')
                ->join('bod_bodega', 'bod_id = ctp_id_bod', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author: Habby Lovo
     * @descripcion: muestra las existencias del producto
     */
    function get_ajuste_existencia($where = null){
        /*
          SELECT
            art_nombre,
            SUM(sar_cant_actual) cantidad_existencia
          FROM
            sar_saldo_articulo
          INNER JOIN art_articulo ON art_id = sar_id_art
          WHERE
            sar_id_bod = 62
          AND sar_id_art = 472

            SELECT
                art_nombre,
                SUM(sar_cant_actual) cantidad_existencia
            FROM
                art_articulo
            LEFT JOIN `sar_saldo_articulo` AS art1 ON `art_id` = `sar_id_art` 
            WHERE
                `art_id` = '3'
            AND `sar_id_bod` = '4'
        */
        $query = $this->db->select('art_nombre,
                IFNULL(SUM(sar_cant_actual),0) cantidad_existencia',false)
                ->from('art_articulo')
                ->join('sar_saldo_articulo', 'art_id = sar_id_art', 'LEFT')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author: Habby Lovo
     * @descripcion: muestra los tipos de salida
     */
    function cargar_tipo_proceso($where = null) {
        /*
          SELECT * FROM tip_tipo_proceso
          WHERE tip_ajuste = 1 and (tip_entrada = 1 or tip_salida = 1)
        */
        $query = $this->db->select('*, IF(tip_entrada = 1, 1, 0) tipo', false)
                ->from('tip_tipo_proceso')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    function detalle_producto_ajuste($where = null, $bodega = null){
        /*
          SELECT *, (SELECT sar_precio FROM sar_saldo_articulo WHERE sar_id_art = art_id and sar_cant_actual != 0 ORDER BY sar_id ASC LIMIT 1) saldo FROM art_articulo
          INNER JOIN cva_conversion_articulo ON cva_id_art = art_id
          INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
          WHERE cva_defecto = 1
        */
        $script = "*, IFNULL( (SELECT sar_precio FROM sar_saldo_articulo WHERE sar_id_art = art_id AND sar_cant_actual != 0 ";
        $script .= ($bodega != null) ? "AND sar_id_bod = " . $bodega . " " : "";
        $script .= "ORDER BY sar_id DESC LIMIT 1), (SELECT dee_precio FROM moi_movimiento_inv JOIN dee_detalle_mov ON dee_id_moi = moi_id WHERE dee_id_art = art_id ";
        $script .= ($bodega != null) ? "AND moi_id_bod = " . $bodega . " " : "";
        $script .= "ORDER BY moi_fecha_mov DESC LIMIT 1)) AS saldo";
        $query = $this->db->select($script, false)
                ->from('art_articulo')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id', 'inner')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * @author: Habby Lovo
     * @descripcion: muestra las caracteristicas de la cotizacion
     */
    function cargar_caracterisitca_cotizacion($where = null) {
        /*
          SELECT cxo_id_cxu, cxo_valor FROM axc_articuloxcotizacion
          inner JOIN cxo_caracxarticuloxcotizacion ON cxo_id_axc = axc_id
          WHERE cxo_id_axc = 16
        */
        $query = $this->db->select('cxo_id_cxu, cxo_valor,cxo_precio_valor', false)
                ->from('axc_articuloxcotizacion')
                ->join('cxo_caracxarticuloxcotizacion','cxo_id_axc = axc_id ','inner');
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }


    /**
     * Descripción:
     * Función obtener cantidad de producto según el lote en el que se ha registrado.
     * @author Edith Herrera - Grupo satélite
     * @since  2018-05-14
     * @param  Ninguno
     * @return Cantidad de productos en existencia por lote
     */
     function get_cantidadxlote($where = null) {
        $query = $this->db->select('sar_id, art_id, art_codigo, SUM(sar_cant_actual) as cant, dee_codigo_lote', false)
                ->from('art_articulo')
                ->join('sar_saldo_articulo','sar_id_art=art_id')
                ->join('dee_detalle_mov', 'dee_id_sar=sar_id')
                ->join('moi_movimiento_inv', 'moi_id = dee_id_moi')
                ->join('tip_tipo_proceso', 'moi_id_tip = tip_id')
                ->where('tip_entrada', 1)
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('dee_codigo_lote');
        $query = $this->db->get();
        return $query->result_array();
    }

    function movimientos_solicitud_materiales($where = null){
        $query = $this->db->select('axm_id, axm_cantidad, axm_pendiente, axm_despachada, 
                    (SELECT sum(dri_cantidad_despacho) FROM dri_detalle_requisicion_inventario WHERE dri_id_axm = axm_id) as despachados', false)
                ->from('axm_articulo_matxarticulo_ord')
                ->join('dri_detalle_requisicion_inventario','dri_id_axm = axm_id')
                ->join('axo_articuloxorden', 'axo_id = axm_id_axo')
                ->join('rxi_requisicion_inventario', 'rxi_id_ord = axo_id_ord')
                ->join('moi_movimiento_inv', 'moi_id_rxi = rxi_id')                
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('axm_id');
        $query = $this->db->get();
        return $query->result_array();

    }

    /**
     * Descripción:
     * Función obtener los empaques de cada detalle de producto en una entrada de producto
     * @author Luis Navarro - Grupo satélite
     * @since  2018-06-18
     * @param  Ninguno
     */
    function get_etiquetas_empaques($where = null, $groupby = null, $orderby = null) {
        $query = $this->db->select(
            "
                dmp_id,
                art_id,
                art_nombre,
                dee_codigo_lote,
                dmp_codigo_empaque,
                dmp_cantidad,
                dmp_peso_neto,
                dmp_peso_bruto,
                (
                        SELECT
                                GROUP_CONCAT(
                                        CONCAT(car_id, '&', (IF(cdi_valor = vrl_id, vrl_valor, cdi_valor))) SEPARATOR ','
                                )
                        FROM
                                cdi_caract_detalle_inventario
                        JOIN cxu_caracxarticulo ON cxu_id = cdi_id_cxu
                        JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
                        JOIN car_caracteristica ON car_id = cxr_id_car
                        LEFT JOIN vrl_valores_lista ON vrl_id_car = car_id AND IF(cdi_valor = vrl_id, vrl_id = cdi_valor, 1 = 0)
                        WHERE dmp_id_dee = cdi_id_dee
                        GROUP BY
                                cdi_id_dee

                ) AS caracteristicas,
                (
                        SELECT tia_nombre FROM tia_tipo_articulo
                        WHERE tia_id = art_id_tia
                ) AS categoria,
                moi_fecha_mov
            ", false)
            ->from('dmp_detalle_empaque')
            ->join('dee_detalle_mov','dmp_id_dee = dee_id')
            ->join('moi_movimiento_inv','dee_id_moi = moi_id')
            ->join('art_articulo', 'art_id = dee_id_art')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * Descripción:
     * Función para obtener las existencias de empaques
     * @author Luis Navarro - Grupo satélite
     * @since  2018-06-20
     * @param  Ninguno
     */
    function get_existencias_empaques($where = null) {
        $prod  = (isset($where['art_id']) && $where['art_id'] != '')?' AND art_id = '.$where['art_id']:'';
        $lote  = (isset($where['dee_codigo_lote']) && $where['dee_codigo_lote'] != '')?' AND dee_codigo_lote = "'.$where['dee_codigo_lote'].'"':'';
        $bod  = (isset($where['moi_id_bod']) && $where['moi_id_bod'] != '')?' AND moi_id_bod = '.$where['moi_id_bod']:'';

        $where = ($prod != "" || $lote != "" || $bod != "")?' '.$prod.' '.$lote.' '.$bod.' ':'';
        $query =
        "
        SELECT * FROM
        (
            (
                SELECT
                        art_id,
                        dee_id,
                        dee_id_art,
                        dee_id_moi,
                        art_codigo,
                        art_nombre,
                        dee_codigo_lote,
                        dee_fecha_creacion
                FROM dee_detalle_mov
                JOIN art_articulo ON art_id = dee_id_art
                ORDER BY dee_id
            ) AS t1
            INNER JOIN
            (
                SELECT
                    dmp_id,
                    dmp_id_dee,
                    dmp_codigo_empaque,
                    dmp_cantidad,
                    dmp_peso_neto,
                    dmp_peso_bruto,
                    dmp_procesado_salida
                FROM
                    dmp_detalle_empaque
                ORDER BY dmp_id_dee
            ) AS t2
            ON t1.dee_id = t2.dmp_id_dee
            INNER JOIN
            (
                SELECT * FROM moi_movimiento_inv
            ) AS moi
            ON t1.dee_id_moi = moi.moi_id
            LEFT JOIN
            (
                SELECT
                        IF(cdi_valor = vrl_id, vrl_id, cdi_id) AS grado_id,
                        cdi_id_dee AS grado_dee,
                        car_nombre AS grado_nombre,
                        IF(cdi_valor = vrl_id, vrl_valor, cdi_valor) AS grado_valor
                FROM
                        cdi_caract_detalle_inventario
                JOIN cxu_caracxarticulo ON cxu_id = cdi_id_cxu
                JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
                JOIN car_caracteristica ON car_id = cxr_id_car
                LEFT JOIN vrl_valores_lista ON vrl_id_car = car_id AND IF(cdi_valor = vrl_id, true, false)
                WHERE car_id = 8
                ORDER BY cdi_id_dee
            ) AS t3
            ON t1.dee_id = t3.grado_dee
            LEFT JOIN
            (
                SELECT
                        car_id AS torsion_id,
                        cdi_id_dee AS torsion_dee,
                        car_nombre AS torsion_nombre,
                        IF(cdi_valor = vrl_id, vrl_valor, cdi_valor) AS torsion_valor
                FROM
                        cdi_caract_detalle_inventario
                JOIN cxu_caracxarticulo ON cxu_id = cdi_id_cxu
                JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
                JOIN car_caracteristica ON car_id = cxr_id_car
                LEFT JOIN vrl_valores_lista ON vrl_id_car = car_id AND IF(cdi_valor = vrl_id, true, false)
                WHERE car_id = 9
                ORDER BY cdi_id_dee

            ) AS t4
            ON t1.dee_id = t4.torsion_dee
            LEFT JOIN
            (
                SELECT
                        car_id AS entre_id,
                        cdi_id_dee AS entre_dee,
                        car_nombre AS entre_nombre,
                        IF(cdi_valor = vrl_id, vrl_valor, cdi_valor) AS entre_valor
                FROM
                        cdi_caract_detalle_inventario
                JOIN cxu_caracxarticulo ON cxu_id = cdi_id_cxu
                JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
                JOIN car_caracteristica ON car_id = cxr_id_car
                LEFT JOIN vrl_valores_lista ON vrl_id_car = car_id AND IF(cdi_valor = vrl_id, true, false)
                WHERE car_id = 15
                ORDER BY cdi_id_dee
            ) AS t5
            ON t1.dee_id = t5.entre_dee
            LEFT JOIN
            (
                SELECT
                        car_id AS origen_id,
                        cdi_id_dee AS origen_dee,
                        car_nombre AS origen_nombre,
                        IF(cdi_valor = vrl_id, vrl_valor, cdi_valor) AS origen_valor
                FROM
                        cdi_caract_detalle_inventario
                JOIN cxu_caracxarticulo ON cxu_id = cdi_id_cxu
                JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
                JOIN car_caracteristica ON car_id = cxr_id_car
                LEFT JOIN vrl_valores_lista ON vrl_id_car = car_id AND IF(cdi_valor = vrl_id, true, false)
                WHERE car_id = 17
                ORDER BY cdi_id_dee
            ) AS t6
            ON t1.dee_id = t6.origen_dee
        )
        WHERE dmp_procesado_salida = 0 $where
        ORDER BY grado_valor, art_nombre
        ";
        $query = $this->db->query($query);
        return $query->result_array();
    }

    /**
     * Descripción:
     * Función para obtener Minimo-Maximo de producto
     * @author Luis Navarro - Grupo satélite
     * @since  2018-07-19
     * @param  Ninguno
     */
    public function get_min_max_producto($where =  null, $groupby = null, $orderby = null) {
        /***********************************/
        $query = $this->db->select(
            "
            mma_id,
            bod_nombre,
            art_codigo,
            art_nombre,
            (
                SELECT
                    SUM(sar_cant_actual)
                FROM
                    dee_detalle_mov
                JOIN moi_movimiento_inv ON dee_id_moi = moi_id
                JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                LEFT JOIN `sar_saldo_articulo` ON `dee_id_sar` = `sar_id`
                WHERE
                    art_id = sar_id_art
                AND tip_entrada = 1
                AND sar_id_bod = bod_id
            ) AS cantidad,
            mma_minimo,
            mma_maximo
            ", false
            )
            ->from('mma_mimino_maximoxarticulo')
            ->join('art_articulo','art_id = mma_id_art', 'left')
            ->join('bod_bodega','bod_id = mma_id_bod', 'left')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        $query = $this->db->get();
        return $query->result_array();
        /***********************************/
    }

    /**
     * Descripción:
     * Función para roles de empleados para autorizar requisiciones
     * @author Luis Navarro - Grupo satélite
     * @since  2018-07-28
     * @param  Ninguno
     */
    public function get_permisos_autorizar_requisicion($where = null, $groupby = null, $orderby = null) {
        /***********************************/
        $query = $this->db->select()
            ->from('flu_flujo')
            ->join('psf_paso_flujo','flu_id = psf_id_flu')
            ->join('rxp_rolxpaso','rxp_id_psf = psf_id')
            ->join('rol_rol','rol_id = rxp_id_rol')
            ->join('axr_accionxrol_paso', 'rxp_id = axr_id_rxp')
            ->join('uxr_usuarioxrol','uxr_id_rol = rxp_id_rol')
            ->join('users','id = uxr_id_usu')
            ->join('emp_empleado','emp_id = usu_id_emp', 'left')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        $query = $this->db->get();
        return $query->result_array();
        /***********************************/
    }

    function get_pais_usuario($where){        
        $query = $this->db->select()
                ->from('users')
                ->join('emr_empresa','usu_id_emp = emr_id')                
        ;
        if ($where != null) {
            $this->db->where($where);
        }        
        $query = $this->db->get();        
        return $query->result_array();        
    }

    /**
     * @author: Elman Ortiz
     * @descripcion: Se obtienen los impuestos por cada cuenta contable a la que pertenece el producto en base al dee_id_moi
     * @return: Arreglo con cxe_id_cnt as cnt_id, imp_nombre ,idd_monto as monto_imp_det as totalxporcentaje
     */
    function get_impuesto_cuentaprod($id_movimiento, $idtipo_cnt = null) {
        $tipo_cuenta_impuesto = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('IMPUESTOS'));

        $query = $this->db->select('cxe_id, cxe_id_cnt as cnt_id, imp_nombre ,SUM(idd_monto) as monto_imp_det')
            ->from('moi_movimiento_inv')
            ->join('dpv_documento_proveedor', 'moi_id_dpv = dpv_id')
            ->join('dxd_detalle_documento_proveedor', 'dpv_id = dxd_id_dpv')
            ->join('idd_impuestoxdetalle_documento', 'dxd_id = idd_id_dxd')
            ->join('imp_impuesto', 'idd_id_imp = imp_id')
            ->join('cxe_cuentaximpuesto', 'imp_id = cxe_id_imp')
            ->where("moi_id=".$id_movimiento." AND cxe_id_tcn=".$tipo_cuenta_impuesto, NULL, FALSE)
            ->group_by('cnt_id');

        return $query->get()->result_array();
        //print_r($this->db->last_query()); die();
    }

    /**
     * Descripción:
     * Función obtener los sectores a los cuales solo tiene permitido de acuedo a la bodega disponibles para el usuario
     * @author Elman Ortiz - Grupo satélite
     * @since  2018-12-06
     * @param  Ninguno
     */
    public function get_sectoresxbodegas_posee_usuario() {
        $id = $this->tank_auth->get_user_id();
        $this->db->select('DISTINCT(seb_id), seb_nombre')
                ->from('bod_bodega')
                ->join('uxb_usuarioxbodega', 'uxb_id_bod = bod_id')
                ->join('sxb_sectorxbodega', 'bod_id = sxb_id_bod')
                ->join('seb_sector_bodega', 'seb_id = sxb_id_seb')
                ->where('uxb_id_usu', $id);
        $this->db->where('bod_estado', 1);
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * Descripción:
     * Función obtener los sectores a los cuales solo tiene permitido de acuedo a la bodega disponibles para el usuario
     * @author Elman Ortiz - Grupo satélite
     * @since  2018-12-06
     * @param  Ninguno
     */
    public function reporte_inventario_fisico($where = null, $having = null) {        
        /*$this->db->select('bod_id, bod_nombre, sar_id_sxb, sar_id_art,
                    (SELECT art_codigo FROM art_articulo WHERE art_id = sar_id_art) AS art_codigo,
                    (SELECT art_nombre FROM art_articulo WHERE art_id = sar_id_art) AS art_nombre,
                    (SELECT seb_nombre FROM seb_sector_bodega WHERE seb_id = sxb_id_seb) AS seb_nombre,
                    (SELECT tia_id FROM tia_tipo_articulo JOIN art_articulo ON tia_id = art_id_tia WHERE art_id = sar_id_art) AS tia_id,
                    (SELECT mep_nombre FROM dee_detalle_mov JOIN cva_conversion_articulo ON dee_id_cva = cva_id JOIN mep_medida_producto ON cva_id_mep = mep_id WHERE dee_id_sar = sar_id LIMIT 1) AS mep_nombre,
                    (SELECT mep_id FROM dee_detalle_mov JOIN cva_conversion_articulo ON dee_id_cva = cva_id JOIN mep_medida_producto ON cva_id_mep = mep_id WHERE dee_id_sar = sar_id LIMIT 1) AS mep_id,
                    (SELECT tia_nombre FROM tia_tipo_articulo JOIN art_articulo ON tia_id = art_id_tia WHERE art_id = sar_id_art
                    ) AS tia_nombre')
                ->from('bod_bodega')
                ->join('sar_saldo_articulo', 'bod_id = sar_id_bod')
                ->join('sxb_sectorxbodega', 'sar_id_sxb = sxb_id', 'left');                
                if($where != null){
                    $this->db->where($where);    
                }
                $this->db->group_by('mep_id, sar_id_art');
                if($having != null){
                    $this->db->having($having);
                }
                $this->db->order_by('bod_id');*/
                $this->db->select("(SELECT moi_fecha_mov 
                                        FROM sar_saldo_articulo 
                                        JOIN dee_detalle_mov ON dee_id_sar = sar_id 
                                        JOIN moi_movimiento_inv ON moi_id = dee_id_moi 
                                        WHERE dee_id_art = art_id ORDER BY sar_id DESC LIMIT 1) AS moi_fecha_mov,
                                    (SELECT dee_id 
                                        FROM sar_saldo_articulo 
                                        JOIN dee_detalle_mov ON dee_id_sar = sar_id 
                                        WHERE dee_id_art = art_id ORDER BY sar_id DESC LIMIT 1) AS dee_id,  
                                    art_id,
                                    (SELECT bod_nombre 
                                        FROM bod_bodega 
                                        WHERE bod_id = art_id_bod) AS bod_nombre,
                                    (SELECT CONCAT(tia_codigo,' - ',tia_nombre)
                                        FROM tia_tipo_articulo 
                                        WHERE tia_id = art_id_tia) AS tia_nombre,
                                    art_codigo,                            
                                    art_nombre,
                                    (SELECT mep_nombre 
                                        FROM mep_medida_producto 
                                        WHERE mep_id = cva_id_mep) AS mep_nombre,
                                    IFNULL (
                                        (SELECT SUM(sar_cant_actual) 
                                            FROM sar_saldo_articulo
                                            WHERE sar_id_art = art_id AND sar_id_bod = art_id_bod) 
                                    ,0) AS cantidad
                                ", false)
                         ->from('art_articulo')
                         ->join('cva_conversion_articulo', 'art_id = cva_id_art');
                        //->join('sxb_sectorxbodega', 'sar_id_sxb = sxb_id', 'left');                
                        
                        if($where != null){
                            $this->db->where($where);    
                        }

                        //$this->db->group_by('mep_id, sar_id_art');

                        if($having != null){
                            $this->db->having($having);
                        }
                        
                        $this->db->order_by('art_codigo');
        $query = $this->db->get();
        return $query->result_array();
        //print_r($this->db->last_query());
        //die();
    }
    /**
     * Descripción:
     * Función obtener productos, mediante una consulta via ajax
     * @author Manuel Anzora - Grupo satélite
     * @since  2018-12-06
     * @param  $where: condicion para filtrar por la bodega, estado e inventario
     */
    public function get_producto_req_like($where, $producto){
        $this->db->select("*, SUM(sar_cant_actual) as saldo, (SELECT IFNULL(mrp_nombre, '') FROM mrp_marca_producto WHERE mrp_id = art_id_mrp) AS mrp_nombre",false)
                ->from('art_articulo')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep')
                ->join('sar_saldo_articulo', 'sar_id_art=art_id ', 'left')
                ->join('cdp_codigo_producto', 'cdp_id_art=art_id ', 'left')
                ->group_by('art_id');
        $this->db->where('art_tipo', 0);//filtra solo productos
        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->where('(art_nombre LIKE "%'.$producto.'%" OR art_codigo LIKE "%'.$producto.'%" OR art_sinonimo LIKE "%'.$producto.'%" OR cdp_codigo LIKE "%'.$producto.'%")');
        return $this->db->get()->result_array();
        /*if($sector!=null){
            $this->db->where('');
        }*/        
    }

    /**
     * Descripción:
     * Función obtener productos, mediante una consulta via ajax
     * @author Habby Lovo - Grupo satélite
     * @since  2019-03-20
     * @param  $where: condicion para filtrar por la bodega, estado e inventario
     */
    function get_pais_usuario2($where){        
        $query = $this->db->select()
                ->from('users')
                ->join('emp_empleado','emp_id_usu = id')
                ->join('pai_pais', 'pai_id = emp_id_pai')
        ;
        if ($where != null) {
            $this->db->where($where);
        }        
        $query = $this->db->get();        
        return $query->result_array();        
    }

    function usuario_autoriza_rxi($where){        
        $estados = array(0, 3);
        $query = $this->db->select('username, rxi_id, rxi_numero, sgr_id_usu, sgr_fecha_entrada')
                ->from('rxi_requisicion_inventario')
                ->join('sgr_seguimiento_requisicion','sgr_id_rxi = rxi_id')
                ->join('psf_paso_flujo', 'sgr_id_psf = psf_id')
                ->join('users', 'sgr_id_usu = id')
        ;
        $this->db->where('sgr_id_psf', 8);
        //$this->db->where('rxi_estado', 3);
        $this->db->where_in('rxi_estado', $estados);
        if ($where != null) {
            $this->db->where('rxi_id',$where);
        }        
        $query = $this->db->get();        
        return $query->result_array();        
    }

    //Se cambia el id de la categoria por un array 20-10-20 by Raul E
    function get_productosxcategoria($id_cat = null) {
        $this->db->select('art_id, art_codigo, art_nombre');
        $this->db->from('art_articulo');
        $this->db->join('tia_tipo_articulo', 'tia_id = art_id_tia');
        if ($id_cat != null && count($id_cat) > 0) {
            $this->db->where_in('tia_id', $id_cat);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * Descripción:
     * Obtiene datos filtrados de traslados para una consulta ajax
     * @author Raul Escalante
     * @since  2019-05-08
     * @param  $where: condicion para filtrar
     */
    function filtrar_traslados($where = null) {
        $this->db->select("
                tra_id,
                tra_id_moi_sal,
                tra_id_moi_ent,
                tra_fecha_translado,
                tra_descripcion,
                salida.moi_id_bod AS s_bodega,
                entrada.moi_id_bod AS e_bodega,
                IFNULL(tia_padre,tia_id) as categoria
                ",false)
                ->from('tra_translado')
                ->join('moi_movimiento_inv AS salida', 'salida.moi_id = tra_id_moi_sal')
                ->join('moi_movimiento_inv AS entrada', 'entrada.moi_id = tra_id_moi_ent')
                ->join('tip_tipo_proceso', 'tip_id = tra_id_tip')
                ->join('dee_detalle_mov', 'dee_id_moi = salida.moi_id')
                ->join('art_articulo', 'dee_id_art = art_id')
                ->join('tia_tipo_articulo', 'art_id_tia = tia_id')
                ->where('tip_traslado', 1)
        ;        
        if ($where != null) {
            if ($where['fecha_ini']) {
                $this->db->where('tra_fecha_translado >=', $where['fecha_ini']);
            }
            if ($where['fecha_fin']) {
                $this->db->where('tra_fecha_translado <=', $where['fecha_fin']);
            }
            if ($where['categoria']) {
                $this->db->where('IFNULL(tia_padre,tia_id)', $where['categoria']);
                //$this->db->or_where('tia_padre', $where['categoria']);
            }
            if ($where['productos']) {
                $where_in = explode(',', $where['productos']);
                $this->db->where_in('art_id', $where_in);
            }
            if ($where['bodega']) {
                $this->db->having('e_bodega', $where['bodega']); 
                $this->db->or_having('s_bodega', $where['bodega']);
            }
        }
        $this->db->group_by("tra_id"); 
        $datos = $this->db->get()->result_array();
        return $datos;
    }

    /**
     * Descripción:
     * Obtiene los datos de lo ya inventariado para calcular el costo promedio
     * @author Raul Escalante     
     * @param  $where: condicion para filtrar
     */
    public function calcular_precio_promedio($where = null) {
        $this->db->select("art_id, sar_id, sar_id_art, bod_id, sar_cant_actual, sar_precio, 
                (sar_cant_actual * sar_precio) as valor, art_nombre
                ",false)
        // $this->db->select("art_id, sar_id, sar_id_art, dee_id, bod_id, sar_cant_actual, sar_precio, dee_cantidad, 
        //         dee_precio,(sar_cant_actual * sar_precio) as valor, art_nombre
        //         ",false)
                ->from('sar_saldo_articulo')                
                // ->join('dee_detalle_mov', 'dee_id_sar = sar_id')
                ->join('art_articulo', 'sar_id_art = art_id')
                ->join('bod_bodega', 'sar_id_bod = bod_id')
                // ->join('moi_movimiento_inv', 'dee_id_moi = moi_id')
                // ->join('tip_tipo_proceso', 'moi_id_tip = tip_id')
                // ->where('tip_entrada', 1)
        ;        
        if ($where != null) {
            $this->db->where($where);
        }
        $datos = $this->db->get()->result_array();        
        return $datos;        
    }

    function get_sum_sar_cantidades($art_id, $bod_id) {
        $query = $this->db->select('SUM(sar_cant_actual) AS cantidad')
                ->from('sar_saldo_articulo')
                ->where('sar_id_art', $art_id)
                ->where('sar_id_bod', $bod_id)
        ;        
        return $query->get()->result_array();
    }

    /**
    * Descripción:
    * Obtiene los datos de loa picking list existentes
    * @author Raul Escalante     
    * @param  $where: condicion para filtrar
    */
    function get_backlog_picking_list($where = null) {
        $query = $this->db->select('*, SUM(sxk_cantidad_reserva) AS reservados',false)
                ->from('pkl_picking_list ')
                ->join('dxk_detalle_ordenxpicking_list', 'pkl_id = dxk_id_pkl')
                ->join('sxk_saldo_artxdetalle_picking_list', 'sxk_id_dxk = dxk_id', 'left')
                ->join('dov_detalle_orden_venta', 'dov_id = dxk_id_dov')
                ->join('ldp_lotexdetalle_picking', 'dxk_id = ldp_id_dxk', 'left')
                ->join('lop_lote_produccion', 'lop_id = ldp_id_lop')
                ->join('orv_orden_venta', 'orv_id = dov_id_orv')
                ->join('cli_cliente', 'cli_id = orv_id_cli')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('pkl_id');
        return $query->get()->result_array();
    }

    /**
     * Descripción:
     * Obtiene el id del vendedor que mas se repite en las ordenes de venta con picking list de un cliente especifico
     * @param  $cliente: id del cliente
     * @author Raul Escalante     
     */
    function get_vendedor_orden_cliente($cliente){
        $this->db->select("orv_id_ven, COUNT(orv_id_ven) AS maximo",false)
                 ->from('orv_orden_venta')
                 ->where('orv_id_cli', $cliente)
                 ->where('orv_aplica_picking_list', 1)
                 ->group_by('orv_id_ven')
                 ->order_by('maximo DESC')
                 ->limit(1)
        ;
        return $this->db->get()->result_array();
    }

    /**
     * Descripción:
     * Obtiene el dropdown de las ordenes que aun no tienen un picking list activo (o fue anulado)
     * @param  $cliente: id del cliente
     * @author Raul Escalante     
     */
    function get_ordenes_cliente($cliente){
        $query = "SELECT orv_id, orv_numero_orden FROM orv_orden_venta WHERE orv_aplica_picking_list = 1 
                AND orv_id_cli = " . $cliente . " AND orv_id NOT IN ( SELECT DISTINCT( orv_id ) FROM pkl_picking_list
                JOIN dxk_detalle_ordenxpicking_list ON dxk_id_pkl = pkl_id JOIN dov_detalle_orden_venta ON dov_id = dxk_id_dov
                JOIN orv_orden_venta ON dov_id_orv = orv_id WHERE pkl_estado_picking_list > 0 )";
        $resultado = $this->db->query($query);
        return $resultado->result_array();
    }

    /**
    * Descripción:
    * Obtiene el deltalle de la orden de venta especifica para el proceso del picking list
    * @param  $where: parametros para la busqueda
    * @author Raul Escalante     
    */
    function get_detalle_orden($where = NULL){
        $this->db->select("dov_id_art, dov_id_cva, dov_id_bod, dov_cantidad",false)
                 ->from('orv_orden_venta')
                 ->join('dov_detalle_orden_venta', 'dov_id_orv = orv_id')
                 ->where('orv_aplica_picking_list', 1)
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    function get_moe_id_moi($where = NULL){
        $this->db->select("moe_id_moi, lop_id",false)
                 ->from('moe_movimiento_etapa')
                 ->join('exo_etapaxarticulo_orden', 'moe_id_exo = exo_id')
                 ->join('lop_lote_produccion', 'exo_id_lop = lop_id')
                 ->join('axo_articuloxorden', 'lop_id_axo = axo_id')
                 ->where('moe_ingreso_inventario', 1)
                 ->where('moe_id_moi is not null')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    function get_datos_art($articulo, $orden){
        $this->db->select("art_nombre, mep_nombre, dov_cantidad, orv_numero_orden, cva_id, dov_id")
                 ->from('dov_detalle_orden_venta')
                 ->join('art_articulo', 'art_id = dov_id_art')
                 ->join('orv_orden_venta', 'orv_id = dov_id_orv')
                 ->join('cva_conversion_articulo', 'cva_id = dov_id_cva')
                 ->join('mep_medida_producto', 'mep_id = cva_id_mep')
                 ->where('dov_id_orv', $orden)
                 ->where('dov_id_art', $articulo)
        ;
        return $this->db->get()->result_array();
    }

    function get_art_bod_pick($articulo,$medida,$bodega,$in){
        $where_in = explode(',', $in);
        $this->db->select("moi_id, moi_id_bod, dee_id_art, dee_id_cva, dee_cantidad, sar_id, sar_cant_actual,
                            IFNULL((SELECT sum(ldp_cantidad_reserva) from ldp_lotexdetalle_picking WHERE ldp_estado = 1 AND ldp_id_lop = lop_id),0) as reservado,
                            lop_id, lop_nombre",false)
                 ->from('moi_movimiento_inv')
                 ->join('dee_detalle_mov', 'dee_id_moi = moi_id')
                 ->join('sar_saldo_articulo', 'dee_id_sar = sar_id')
                 ->join('moe_movimiento_etapa', 'moe_id_moi = moi_id')
                 ->join('exo_etapaxarticulo_orden', 'moe_id_exo = exo_id')
                 ->join('lop_lote_produccion', 'exo_id_lop = lop_id')
                 ->where('sar_id_art', $articulo)
                 ->where('dee_id_cva', $medida)
                 ->where('moi_id_bod', $bodega)
                 ->where_in('moi_id', $where_in)
                 ->order_by('sar_cant_actual desc')
        ;
        return $this->db->get()->result_array();
    }

    function get_detalle_picking($where){
        $this->db->select('*,
            (SELECT mep_nombre from mep_medida_producto join cva_conversion_articulo on cva_id_mep = mep_id WHERE cva_id = dov_id_cva) as medida,
            (SELECT GROUP_CONCAT(DISTINCT(lop_nombre)) from lop_lote_produccion join ldp_lotexdetalle_picking on lop_id = ldp_id_lop) as lotes
            ',false)
                 ->from('pkl_picking_list')
                 ->join('dxk_detalle_ordenxpicking_list', 'dxk_id_pkl = pkl_id')
                 ->join('dov_detalle_orden_venta', 'dov_id = dxk_id_dov')
                 ->join('orv_orden_venta', 'orv_id = dov_id_orv')
                 ->join('art_articulo', 'art_id = dov_id_art')
                 ->join('ldp_lotexdetalle_picking', 'dxk_id = ldp_id_dxk', 'left')
                 ->join('sxk_saldo_artxdetalle_picking_list', 'dxk_id = sxk_id_dxk', 'left')
                 ->where('pkl_id',$where)
        ;
        return $this->db->get()->result_array();
    }

    function rpte_kardex_resumen($bodega = "",$fecha_ini,$fecha_fin){
        $query = "SELECT CONCAT(t.tia_id,'_',art_id) AS llave, t.tia_id, t.tia_codigo, t.tia_padre, art_id, t.tia_nombre,  art_codigo, art_nombre,
            IFNULL((SELECT SUM(IF(tip_entrada = 1, dee_cantidad, 0)) - SUM(IF(tip_salida = 1, dee_cantidad, 0)) FROM moi_movimiento_inv 
                JOIN dee_detalle_mov ON moi_id = dee_id_moi JOIN tip_tipo_proceso ON moi_id_tip = tip_id WHERE dee_id_art = art_id ";
        $query .= ($bodega != "") ? "AND moi_id_bod = $bodega " : "";
        $query .= "AND moi_fecha_mov < '$fecha_ini'), 0) AS inv_ini_uni,
            IFNULL((SELECT SUM(IF(tip_entrada = 1, dee_cantidad * dee_precio, 0)) - SUM(IF(tip_salida = 1, dee_cantidad * dee_precio, 0)) FROM moi_movimiento_inv
                JOIN dee_detalle_mov ON moi_id = dee_id_moi JOIN tip_tipo_proceso ON moi_id_tip = tip_id WHERE dee_id_art = art_id ";
        $query .= ($bodega != "") ? "AND moi_id_bod = $bodega " : "";
        $query .= "AND moi_fecha_mov < '$fecha_ini'), 0) AS inv_ini_tot,
            IFNULL((SELECT SUM(IF(tip_entrada = 1, dee_cantidad, 0)) FROM moi_movimiento_inv JOIN dee_detalle_mov ON moi_id = dee_id_moi
                JOIN tip_tipo_proceso ON moi_id_tip = tip_id WHERE dee_id_art = art_id ";
        $query .= ($bodega != "") ? "AND moi_id_bod = $bodega " : "";
        $query .= "AND DATE(moi_fecha_mov) BETWEEN '$fecha_ini' AND '$fecha_fin'), 0) AS entradas,
            IFNULL((SELECT SUM(IF(tip_entrada = 1, (dee_cantidad * dee_precio), 0)) FROM moi_movimiento_inv JOIN dee_detalle_mov ON moi_id = dee_id_moi
                JOIN tip_tipo_proceso ON moi_id_tip = tip_id WHERE dee_id_art = art_id ";
        $query .= ($bodega != "") ? "AND  moi_id_bod = $bodega " : "";
        $query .= "AND DATE(moi_fecha_mov) BETWEEN '$fecha_ini' AND '$fecha_fin'), 0) AS costo_entradas,
            IFNULL((SELECT SUM(IF(tip_salida = 1, dee_cantidad, 0)) FROM moi_movimiento_inv JOIN dee_detalle_mov ON moi_id = dee_id_moi
                JOIN tip_tipo_proceso ON moi_id_tip = tip_id WHERE dee_id_art = art_id ";
        $query .= ($bodega != "") ? "AND  moi_id_bod = $bodega " : "";
        $query .= "AND DATE(moi_fecha_mov) BETWEEN '$fecha_ini' AND '$fecha_fin'), 0) AS salidas,
            IFNULL((SELECT SUM(IF(tip_salida = 1, (dee_cantidad * dee_precio ), 0)) FROM moi_movimiento_inv JOIN dee_detalle_mov ON moi_id = dee_id_moi
                JOIN tip_tipo_proceso ON moi_id_tip = tip_id WHERE dee_id_art = art_id ";
        $query .= ($bodega != "") ? "AND moi_id_bod = $bodega " : "";
        $query .= "AND DATE(moi_fecha_mov) BETWEEN '$fecha_ini' AND '$fecha_fin'), 0) AS costo_salidas,
            IFNULL((SELECT SUM(IF(tip_entrada = 1, dee_cantidad, 0)) - SUM(IF(tip_salida = 1, dee_cantidad, 0)) FROM moi_movimiento_inv
                JOIN dee_detalle_mov ON moi_id = dee_id_moi JOIN tip_tipo_proceso ON moi_id_tip = tip_id WHERE dee_id_art = art_id ";
        $query .= ($bodega != "") ? "AND moi_id_bod = $bodega " : "";
        $query .= "AND DATE(moi_fecha_mov) <= '$fecha_fin'), 0) AS inv_fin_uni,
            IFNULL((SELECT SUM(IF(tip_entrada = 1, dee_cantidad * dee_precio, 0)) - SUM(IF(tip_salida = 1, dee_cantidad * dee_precio, 0)) FROM moi_movimiento_inv
                JOIN dee_detalle_mov ON moi_id = dee_id_moi JOIN tip_tipo_proceso ON moi_id_tip = tip_id WHERE dee_id_art = art_id ";
        $query .= ($bodega != "") ? "AND moi_id_bod = $bodega " : "";
        $query .= "AND DATE(moi_fecha_mov) <= '$fecha_fin'), 0) AS inv_fin_tot,
            IF (t.tia_padre IS NOT NULL, (SELECT t2.tia_nombre FROM tia_tipo_articulo AS t2 WHERE t2.tia_id = t.tia_padre), '') AS padre_nombre, 
            IF (t.tia_padre IS NOT NULL, (SELECT t2.tia_codigo FROM tia_tipo_articulo AS t2 WHERE t2.tia_id = t.tia_padre), '') AS padre_codigo, ";
        $query .= ($bodega != "") ? "(SELECT bod_nombre FROM bod_bodega WHERE bod_id = $bodega)" : "'TODAS'";
        $query .= " AS bod_nombre,
            mep_nombre    
            FROM art_articulo
            JOIN tia_tipo_articulo AS t ON t.tia_id = art_id_tia 
            JOIN cva_conversion_articulo ON cva_id_art = art_id AND cva_defecto = 1 
            JOIN mep_medida_producto ON mep_id = cva_id_mep 
            WHERE art_inventario = 1 AND art_estado = 1
            GROUP BY art_id    
            ORDER BY tia_padre, tia_id, art_id ASC
            ";                
        $datos = $this->db->query($query);        
        $detalle = $datos->result_array();
        return $detalle;
    }

    function rpte_kardex_detalle($bodega = "",$fecha_ini,$fecha_fin, $where_in = array()){
        $articulos = (count($where_in) > 0) ? implode(',', $where_in) : "";
        $art_in = ($articulos != "") ? 'AND art_id IN (' . $articulos . ') ' : '';
        $query = "SELECT CONCAT(tia_id,'_',art_id) as llave, tia_id, tia_padre, tia_codigo, tia_nombre, mep_nombre,        
            IF (tia_padre IS NOT NULL, (SELECT t2.tia_nombre FROM tia_tipo_articulo AS t2 WHERE t2.tia_id = t.tia_padre), '') AS padre_nombre,
            IF (tia_padre IS NOT NULL, (SELECT t2.tia_codigo FROM tia_tipo_articulo AS t2 WHERE t2.tia_id = t.tia_padre), '') AS padre_codigo, 
            art_codigo, art_nombre, moi_fecha_mov, tip_nombre, tip_entrada, tip_salida, dee_cantidad, dee_precio, (dee_cantidad * dee_precio) AS valor, 
            IFNULL((SELECT SUM(IF(tip_entrada = 1, dee_cantidad, 0)) - SUM(IF(tip_salida = 1, dee_cantidad, 0)) FROM moi_movimiento_inv
                JOIN dee_detalle_mov ON moi_id = dee_id_moi JOIN tip_tipo_proceso ON moi_id_tip = tip_id WHERE dee_id_art = art_id 
                AND moi_fecha_mov < '$fecha_ini'";
        $query .= ($bodega != "") ? " AND moi_id_bod = $bodega" : "";
        $query .= "), 0) AS inv_ini_uni,
            IFNULL((SELECT SUM(IF(tip_entrada = 1, dee_cantidad * dee_precio, 0)) - SUM(IF(tip_salida = 1, dee_cantidad * dee_precio, 0)) 
                FROM moi_movimiento_inv JOIN dee_detalle_mov ON moi_id = dee_id_moi JOIN tip_tipo_proceso ON moi_id_tip = tip_id 
                WHERE dee_id_art = art_id AND moi_fecha_mov < '$fecha_ini'";
        $query .= ($bodega != "") ? " AND moi_id_bod = $bodega" : "";
        $query .= "), 0) AS inv_ini_tot,
            IFNULL((SELECT SUM(IF(tip_entrada = 1, dee_cantidad, 0)) - SUM(IF(tip_salida = 1, dee_cantidad, 0)) FROM moi_movimiento_inv
                JOIN dee_detalle_mov ON moi_id = dee_id_moi JOIN tip_tipo_proceso ON moi_id_tip = tip_id 
                WHERE dee_id_art = art_id";
        $query .= ($bodega != "") ? " AND moi_id_bod = $bodega" : "";
        $query .= "), 0) AS inv_fin_uni,
            IFNULL((SELECT SUM(IF(tip_entrada = 1, dee_cantidad * dee_precio, 0)) - SUM(IF(tip_salida = 1, dee_cantidad * dee_precio, 0)) 
                FROM moi_movimiento_inv JOIN dee_detalle_mov ON moi_id = dee_id_moi JOIN tip_tipo_proceso ON moi_id_tip = tip_id 
                WHERE dee_id_art = art_id";
        $query .= ($bodega != "") ? " AND moi_id_bod = $bodega" : "";
        $query .= "), 0) AS inv_fin_tot,
            (SELECT bod_nombre FROM bod_bodega WHERE bod_id = moi_id_bod) AS bod_nombre, 
            (SELECT sef_abrev FROM sef_serie_factura JOIN cof_correlativo_factura ON sef_id = cof_id_sef WHERE cof_id = fac_id_cof GROUP BY sef_id LIMIT 1) AS serie_fac, 
            tfdpv.tif_abreviacion AS tif_abr_dpv, tffac.tif_abreviacion AS tif_abr_fac, fac_numero, clip.pai_nacionalidad AS pais_cli, moi_documento,
            IF(cli_personeria = 2,cli_apellido,CONCAT(cli_nombre,' ',cli_apellido)) AS cli_nombre, prvp.pai_nacionalidad AS pais_prv, dpv_serie_documento,          
            prv_nombre, rxi_numero, ord_codigo, CONCAT(tfdpv.tif_abreviacion,' - ',moi_documento) AS doc_entrada, 
            IF(rxi_numero != '', CONCAT('REQ',rxi_numero), CONCAT((SELECT sef_nombre from sef_serie_factura JOIN cof_correlativo_factura ON sef_id = cof_id_sef 
                WHERE cof_id = fac_id_cof GROUP BY sef_id LIMIT 1),fac_numero)) AS doc_salida, 
            moi_id, dee_id, dee_id_art, cva_id, moi_id_tip, mep_id
            FROM art_articulo
            JOIN tia_tipo_articulo AS t ON t.tia_id = art_id_tia 
            JOIN cva_conversion_articulo ON cva_id_art = art_id AND cva_defecto = 1 
            JOIN mep_medida_producto ON mep_id = cva_id_mep 
            JOIN dee_detalle_mov ON dee_id_art = art_id
            JOIN moi_movimiento_inv ON moi_id = dee_id_moi
            JOIN tip_tipo_proceso ON moi_id_tip = tip_id 
            LEFT JOIN dpv_documento_proveedor ON dpv_id = moi_id_dpv 
            LEFT JOIN prv_proveedor ON prv_id = moi_id_prv 
            LEFT JOIN rxi_requisicion_inventario ON moi_id_rxi = rxi_id 
            LEFT JOIN ord_orden ON rxi_id_ord = ord_id 
            LEFT JOIN fac_factura ON moi_id_fac = fac_id 
            LEFT JOIN cli_cliente ON fac_id_cli = cli_id 
            LEFT JOIN tif_tipo_factura AS tfdpv ON tfdpv.tif_id = dpv_id_tif 
            LEFT JOIN tif_tipo_factura AS tffac ON tffac.tif_id = fac_id_tif 
            LEFT JOIN pai_pais AS prvp ON prv_id_pai = prvp.pai_id 
            LEFT JOIN pai_pais AS clip ON cli_id_pai = clip.pai_id
            WHERE art_estado = 1 AND art_inventario = 1 "; 
        $query .= ($bodega != "") ? "AND moi_id_bod = $bodega " : "";
        $query .= "AND DATE(moi_fecha_mov) BETWEEN '$fecha_ini' AND '$fecha_fin' $art_in
            ORDER BY tia_padre, tia_id, art_id, moi_fecha_mov ASC";               
        $datos = $this->db->query($query);
        $detalle = $datos->result_array();
        return $detalle;
    }

    public function get_detalles_ruta($where = null){
        $this->db->select()
                 ->from('rte_ruta_entrega')
                 ->join('dre_detalle_ruta_entrega', 'rte_id = dre_id_rte')
                 ->join('mot_motorista', 'mot_id = rte_id_mot')
                 ->join('fac_factura', 'fac_id = dre_id_fac')
                 ->join('cli_cliente', 'cli_id = fac_id_cli')
                 ->join('emp_empleado', 'emp_id = mot_empleado') 
                 ->join('rtc_ruta_cobro', 'rtc_id = rte_id_rtc')
                 ->where('rte_estado', 1)
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    
    /**
     * @author: Mario Marquez
     * @descripcion: Obtener el numero de la factura a partir de moi_id
     * @return: fac_numero
     */
    function get_factura_sin_movimiento($where = null, $select = "*", $group_by = null) {
        $query = $this->db->select($select)
                ->from('fac_factura')
                ->join('moi_movimiento_inv', 'fac_id = moi_id_fac', 'left')
        ;

        if($group_by!=null){
            $this->db->group_by($group_by);
        }

        if($where!=null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author: Habby Lovo
     * @descripcion: Obtiene los sectores de los detalles del traslado temporal
     * @return: trp_id
     */
    function get_sectores_traslado_temporal($where = null) {
        /*
            SELECT 
                DISTINCT sxb_id, seb_nombre
            FROM
                dtr_detalle_traslado_pendiente
            INNER JOIN sxb_sectorxbodega ON sxb_id = dtr_id_sxb
            INNER JOIN seb_sector_bodega ON seb_id = sxb_id_seb
        */
        $query = $this->db->select('DISTINCT sxb_id, seb_nombre', false)
                ->from('dtr_detalle_traslado_pendiente')
                ->join('sxb_sectorxbodega', 'sxb_id = dtr_id_sxb', 'INNER')
                ->join('seb_sector_bodega', 'seb_id = sxb_id_seb', 'INNER')
        ;

        if($where != null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author: Habby Lovo
     * @descripcion: Obtiene los sectores de los detalles del traslado temporal
     * @return: trp_id
     */
    function get_traslado_temporal($where = null) {
        /*
            SELECT 
                *, 
                bod1.bod_nombre AS bodega_origen,
                bod2.bod_nombre AS bodega_destino,
                emp1.emp_nombre AS nombre_solicita,
                emp1.emp_apellido AS apellido_solicita,
                emp2.emp_nombre AS nombre_autoriza,
                emp2.emp_apellido AS apellido_autoriza,
                emp3.emp_nombre AS nombre_anula,
                emp3.emp_apellido AS apellido_anula
            FROM
                trp_traslado_pendiente
            INNER JOIN dtr_detalle_traslado_pendiente ON dtr_id_trp = trp_id
            INNER JOIN bod_bodega AS bod1 ON bod1.bod_id = trp_id_bod_destino
            INNER JOIN bod_bodega AS bod2 ON bod2.bod_id = trp_id_bod_origen
            INNER JOIN emp_empleado AS emp1 ON emp1.emp_id_usu = trp_id_usu
            LEFT JOIN emp_empleado AS emp2 ON emp2.emp_id_usu = trp_id_usu_autoriza
            LEFT JOIN emp_empleado AS emp3 ON emp3.emp_id_usu = trp_id_usu_anula
            LEFT JOIN sxb_sectorxbodega ON sxb_id = dtr_id_sxb
            LEFT JOIN seb_sector_bodega ON seb_id = sxb_id_seb
            LEFT JOIN art_articulo ON art_id = dtr_id_art
        */
        $query = $this->db->select('*, 
                    bod1.bod_nombre AS bodega_origen, 
                    bod2.bod_nombre AS bodega_destino,
                    emp1.emp_nombre AS nombre_solicita,
                    emp1.emp_apellido AS apellido_solicita,
                    emp2.emp_nombre AS nombre_autoriza,
                    emp2.emp_apellido AS apellido_autoriza,
                    emp3.emp_nombre AS nombre_anula,
                    emp3.emp_apellido AS apellido_anula', false)
                ->from('trp_traslado_pendiente')
                ->join('dtr_detalle_traslado_pendiente', 'dtr_id_trp = trp_id', 'INNER')
                ->join('bod_bodega AS bod1', 'bod1.bod_id = trp_id_bod_origen', 'INNER')
                ->join('bod_bodega AS bod2', 'bod2.bod_id = trp_id_bod_destino', 'INNER')
                ->join('emp_empleado AS emp1', 'emp1.emp_id_usu = trp_id_usu', 'INNER')
                ->join('emp_empleado AS emp2', 'emp2.emp_id_usu = trp_id_usu_autoriza', 'LEFT')
                ->join('emp_empleado AS emp3', 'emp3.emp_id_usu = trp_id_usu_anula', 'LEFT')
                ->join('sxb_sectorxbodega', 'sxb_id = dtr_id_sxb', 'LEFT')
                ->join('seb_sector_bodega', 'seb_id = sxb_id_seb', 'LEFT')
                ->join('art_articulo', 'art_id = dtr_id_art', 'LEFT')
                ->join('rxi_requisicion_inventario', 'rxi_id = trp_id_rxi', 'LEFT')
        ;

        if($where != null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_costo_traslado($where = null){
        /*
            SELECT 
                * 
            FROM
                sxd_saldo_artxdetalle_pendiente
            INNER JOIN dtr_detalle_traslado_pendiente ON dtr_id = sxd_id_dtr
            INNER JOIN trp_traslado_pendiente ON trp_id = dtr_id_trp
            LEFT JOIN tra_translado ON tra_id_trp = trp_id
            LEFT JOIN moi_movimiento_inv ON moi_id = tra_id_moi_ent
            LEFT JOIN dee_detalle_mov ON dee_id_moi = moi_id
            WHERE 
                sxd_id_dtr = 2
            GROUP BY 
                IF(ISNULL(tra_id), sxd_id_sar, dee_id)
        */
        $query = $this->db->select()
                ->from('sxd_saldo_artxdetalle_pendiente')
                ->join('dtr_detalle_traslado_pendiente', 'dtr_id = sxd_id_dtr', 'INNER')
                ->join('trp_traslado_pendiente', 'trp_id = dtr_id_trp', 'INNER')
                ->join('tra_translado', 'tra_id_trp = trp_id', 'LEFT')
                ->join('moi_movimiento_inv', 'moi_id = tra_id_moi_ent', 'LEFT')
                ->join('dee_detalle_mov', 'dee_id_moi = moi_id', 'LEFT')
        ;

        if($where != null){
            $this->db->where($where);
        }
        $this->db->group_by('IF(ISNULL(tra_id), sxd_id_sar, dee_id )');

        return $query->get()->result_array();
    }

    function get_existencias_bodegas($where = null){
        $this->db->select('tia_id, tia_codigo, tia_nombre, concat(tia_id, bod_id) AS indentificador, SUM(IF(tip_salida = 1,(dee_cantidad*dee_precio),0)) AS salidas, bod_nombre, bod_id', false)
                  ->from('tia_tipo_articulo')  
                  ->join('art_articulo', 'tia_id = art_id_tia', 'LEFT')
                  ->join('dee_detalle_mov', 'art_id = dee_id_art', 'LEFT')
                  ->join('moi_movimiento_inv', 'moi_id = dee_id_moi', 'LEFT')
                  ->join('tip_tipo_proceso', 'tip_id = moi_id_tip', 'LEFT')
                  ->join('bod_bodega', 'bod_id = moi_id_bod', 'LEFT')
                  ->group_by('tia_id, bod_id')
                  ->order_by('tia_id ASC')
                  ->having('salidas > 0')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    function requix_areas_report($where = null){
        $this->db->select('art_id, tia_id, bod_id, IFNULL(are_id,0) AS are_id, emp_id, rxi_numero, are_nombre, art_nombre,tia_codigo, tia_nombre, bod_nombre, rxi_estado, 
            SUM(dri_cantidad) AS total, rxi_fecha, moi_fecha_mov, SUM(dee_cantidad) AS despachado, dee_precio, dee_subtotal', false)
            ->from('dri_detalle_requisicion_inventario')
            ->join('art_articulo', 'art_id = dri_id_art')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
            ->join('rxi_requisicion_inventario', 'rxi_id = dri_id_rxi')
            ->join('bod_bodega', 'bod_id = rxi_id_bod')
            ->join('emp_empleado', 'emp_id = rxi_id_emp')
            ->join('moi_movimiento_inv', 'moi_id_rxi = rxi_id')
            ->join('dee_detalle_mov', 'dee_id_moi = moi_id AND dee_id_art = dri_id_art')
            ->join('are_area', 'are_id = emp_id_are', 'LEFT')
            ->group_by('rxi_estado, are_id, art_id, dee_precio')
            ->order_by('are_id, rxi_estado')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    function consumo_areas_report($where = null){
        $this->db->select('art_id, tia_id, bod_id, IFNULL(are_id,0) AS are_id, emp_id, are_nombre, rxi_numero, art_nombre, tia_codigo, tia_nombre, bod_nombre, rxi_estado,
            (SELECT mep_nombre FROM cva_conversion_articulo JOIN mep_medida_producto ON mep_id = cva_id_mep WHERE cva_id = dee_id_cva) AS unidad, rxi_fecha, moi_fecha_mov, 
            dri_cantidad, dee_cantidad, dee_precio, dee_subtotal', false)
            ->from('dri_detalle_requisicion_inventario')
            ->join('art_articulo', 'art_id = dri_id_art')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
            ->join('rxi_requisicion_inventario', 'rxi_id = dri_id_rxi')
            ->join('moi_movimiento_inv', 'moi_id_rxi = rxi_id')
            ->join('bod_bodega', 'bod_id = moi_id_bod')
            ->join('emp_empleado', 'emp_id = rxi_id_emp')
            ->join('tip_tipo_proceso', 'tip_id = moi_id_tip')
            ->join('dee_detalle_mov', 'dee_id_moi = moi_id AND dee_id_art = dri_id_art')
            ->join('are_area', 'are_id = emp_id_are', 'LEFT')
            ->order_by('are_id, rxi_fecha')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    function get_movimientos_reporte($fecha_inicio, $fecha_final, $bodega = null){
        $where_bod = ($bodega) ? 'AND moi_id_bod = ' . $bodega : '';
        /*
        SELECT tia_id, tia_nombre, tia_codigo,
        (SELECT SUM(IF(tip_entrada = 1, (dee_cantidad * dee_precio), 0)) FROM dee_detalle_mov JOIN moi_movimiento_inv ON moi_id = dee_id_moi
        JOIN art_articulo ON art_id = dee_id_art JOIN tip_tipo_proceso ON tip_id = moi_id_tip  WHERE DATE(moi_fecha_mov) >= '2021-08-01' 
        AND DATE(moi_fecha_mov) <= '2021-08-30' AND art_id_tia = tia_id   AND moi_id_bod = 10 ) AS entradas,
        (SELECT SUM(IF(tip_salida = 1, (dee_cantidad * dee_precio), 0)) FROM dee_detalle_mov JOIN moi_movimiento_inv ON moi_id = dee_id_moi
        JOIN art_articulo ON art_id = dee_id_art  JOIN tip_tipo_proceso ON tip_id = moi_id_tip WHERE DATE(moi_fecha_mov) >= '2021-08-01' 
        AND DATE(moi_fecha_mov) <= '2021-08-30' AND art_id_tia = tia_id AND moi_id_bod = 10 ) AS salidas,
        (SELECT SUM((IF(tip_entrada = 1, (dee_cantidad * dee_precio), 0) -  IF(tip_salida = 1, (dee_cantidad*dee_precio), 0)))
        FROM dee_detalle_mov JOIN moi_movimiento_inv ON moi_id = dee_id_moi JOIN art_articulo ON art_id = dee_id_art 
        JOIN tip_tipo_proceso ON tip_id = moi_id_tip WHERE DATE(moi_fecha_mov) < '2021-08-01' AND art_id_tia = tia_id AND moi_id_bod = 10
        ) AS saldo_anterior FROM tia_tipo_articulo 
        */
        $query = $this->db->select("tia_id, tia_nombre, tia_codigo, IFNULL((SELECT SUM(IF(tip_entrada = 1, (dee_cantidad * dee_precio), 0)) FROM dee_detalle_mov 
            JOIN moi_movimiento_inv ON moi_id = dee_id_moi JOIN art_articulo ON art_id = dee_id_art JOIN tip_tipo_proceso ON tip_id = moi_id_tip 
            WHERE DATE(moi_fecha_mov) >= '$fecha_inicio' AND DATE(moi_fecha_mov) <= '$fecha_final' AND art_id_tia = tia_id $where_bod ), 0) AS entradas,
            IFNULL((SELECT SUM(IF(tip_salida = 1, (dee_cantidad * dee_precio), 0)) FROM dee_detalle_mov JOIN moi_movimiento_inv ON moi_id = dee_id_moi
            JOIN art_articulo ON art_id = dee_id_art JOIN tip_tipo_proceso ON tip_id = moi_id_tip WHERE DATE(moi_fecha_mov) >= '$fecha_inicio' 
            AND DATE(moi_fecha_mov) <= '$fecha_final' AND art_id_tia = tia_id $where_bod ), 0) AS salidas,
            IFNULL((SELECT SUM((IF(tip_entrada = 1, (dee_cantidad * dee_precio), 0) -  IF(tip_salida = 1, (dee_cantidad*dee_precio), 0))) FROM dee_detalle_mov 
            JOIN moi_movimiento_inv ON moi_id = dee_id_moi JOIN art_articulo ON art_id = dee_id_art JOIN tip_tipo_proceso ON tip_id = moi_id_tip 
            WHERE DATE(moi_fecha_mov) < '$fecha_inicio' AND art_id_tia = tia_id $where_bod ), 0) AS saldo_anterior", false)
            ->from('tia_tipo_articulo')
        ;
        return $query->get()->result_array();
    }

    function get_saldo_existencia_reporte($where = null){
        $fecha_where = '';
        if ($where != null) {
            $fecha_where = $where;
        }
        /*
            SELECT
                tia_id,
                tia_nombre,
                tia_codigo,
                bod_id,
                bod_nombre,
                SUM(
                    IF(tip_entrada = 1,(dee_cantidad*dee_precio),0)
                ) AS entradas
            FROM
                tia_tipo_articulo
            LEFT JOIN art_articulo ON art_id_tia = tia_id
            LEFT JOIN dee_detalle_mov ON dee_id_art = art_id
            LEFT JOIN moi_movimiento_inv ON moi_id = dee_id_moi AND DATE(moi_fecha_mov) >= '2019-09-01' AND DATE(moi_fecha_mov) <= '2019-09-30' 
            LEFT JOIN bod_bodega ON bod_id = moi_id_bod
            LEFT JOIN tip_tipo_proceso ON tip_id = moi_id_tip
            GROUP BY
                tia_id, bod_id
        */
        $query = $this->db->select('
                tia_id,
                tia_nombre,
                tia_codigo,
                bod_id,
                bod_nombre,
                concat(tia_id, bod_id) AS indentificador,
                SUM(
                    IF(tip_entrada = 1,(dee_cantidad*dee_precio),0)
                ) AS entradas
            ', false)
                ->from('tia_tipo_articulo')
                ->join('art_articulo', 'art_id_tia = tia_id', 'LEFT')
                ->join('dee_detalle_mov', 'dee_id_art = art_id', 'LEFT')
                ->join('moi_movimiento_inv', 'moi_id = dee_id_moi '.$fecha_where, 'LEFT')
                ->join('bod_bodega', 'bod_id = moi_id_bod', 'LEFT')
                ->join('tip_tipo_proceso', 'tip_id = moi_id_tip', 'LEFT')
        ;

        $this->db->group_by('tia_id');
        $this->db->group_by('bod_id');

        return $query->get()->result_array();
    }

    function get_informe_existencia_reporte($where = null){
        // $fecha_where = '';
        // if ($where != null) {
        //     $fecha_where = $where;
        // }
        /*
            SELECT
                tia_codigo,
                art_nombre,
                mep_nombre,
                cex_correlativo,
                cex_cantidad_ant,
                cex_precio_ant,
                (
                    cex_cantidad_ant * cex_precio_ant
                )
            FROM
                cex_contro_existencia
            LEFT JOIN cva_conversion_articulo ON cva_id = cex_id_cva
            LEFT JOIN mep_medida_producto ON mep_id = cva_id_mep
            LEFT JOIN art_articulo ON art_id = cex_id_art
            LEFT JOIN tia_tipo_articulo ON tia_id = art_id_tia
        */
        $query = $this->db->select('
                tia_id,
                tia_codigo,
                tia_nombre,
                art_codigo,
                art_nombre,
                mep_nombre,
                cex_correlativo,
                cex_cantidad_ant,
                cex_precio_ant,
                (
                    cex_cantidad_ant * cex_precio_ant
                ) AS total
            ', false)
                ->from('cex_contro_existencia')
                ->join('cva_conversion_articulo', 'cva_id = cex_id_cva', 'LEFT')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'LEFT')
                ->join('art_articulo', 'art_id = cex_id_art', 'LEFT')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia', 'LEFT')
        ;
        if($where != null){
            $this->db->where($where);
        }
        // $this->db->group_by('tia_id');
        // $this->db->group_by('bod_id');

        return $query->get()->result_array();
    }

    public function get_control_existencia($where = null, $grou_by = null){
        $query = $this->db->select()
                ->from('dcx_detalle_control_existencia')
                ->join('cex_contro_existencia', 'cex_id = dcx_id_cex','JOIN')
                ->join('art_articulo', 'art_id = cex_id_art', 'JOIN')
                ->join("bod_bodega","bod_id = cex_id_bod", 'JOIN')
                ->join("tip_tipo_proceso","tip_id = dcx_id_tip", 'JOIN')                
                ->join("cva_conversion_articulo","cva_id = cex_id_cva", 'JOIN')   
                ->join("mep_medida_producto","mep_id = cva_id_mep", 'JOIN')                   
        ; 

        if ($where != null) {
            $this->db->where($where);
        }  

        if ($grou_by != null) {
            $this->db->group_by($grou_by);
        }  

        return $query->get()->result_array();
    }

    function tabla_rpt_krdx_det($bodega,$fecha_ini,$fecha_fin){
        //devuelve el costo total de entradas/salidas por cada tipo de movimiento
        $query = $this->db->select('tip_id, tip_nombre, tip_entrada, tip_salida, SUM(dee_cantidad * dee_precio) AS total',false)
                ->from('moi_movimiento_inv')
                ->join('dee_detalle_mov', 'moi_id = dee_id_moi')
                ->join('tip_tipo_proceso', 'tip_id = moi_id_tip')
                ->where('moi_id_bod', $bodega)
                ->where('DATE(moi_fecha_mov) >=', $fecha_ini)
                ->where('DATE(moi_fecha_mov) <=', $fecha_fin)
                ->group_by('tip_id')
        ;
        return $query->get()->result_array();
    }

    public function get_reporte_983($where = null){
        $query = $this->db->select('art_codigo, art_nombre, art_referencia_del_bien, art_referencia_en_libro, ROUND(AVG(dee_precio), 10) AS costo, SUM(dee_cantidad) AS cantidad, 
            (SELECT mep_nombre FROM cva_conversion_articulo JOIN mep_medida_producto ON mep_id = cva_id_mep WHERE cva_defecto = 1 AND cva_id_art = dee_id_art 
            AND cva_estado = 1 LIMIT 1) AS medida',false)
            ->from('dee_detalle_mov')
            ->join('art_articulo', 'art_id = dee_id_art')
            ->join('moi_movimiento_inv', 'moi_id = dee_id_moi')
            ->where('moi_estado', 1)
            ->where('dee_estado', 1)
            ->group_by('dee_id_art')
            ->having('costo > 0')
        ;

        if ($where != null) {
            $this->db->where($where);
        } 
        return $query->get()->result_array();
    }

    public function get_ajustes_inv($where = null){
        $query = $this->db->select("*, (SELECT bod_nombre FROM bod_bodega WHERE bod_id = moi_id_bod) AS bodega,
            (SELECT IF(ISNULL(emp_id), username, CONCAT(emp_nombre,' ',emp_apellido)) FROM users LEFT JOIN emp_empleado ON emp_id = usu_id_emp WHERE id = aju_usu_genera) AS usuario_crea, 
            (SELECT tip_nombre FROM tip_tipo_proceso WHERE tip_id = moi_id_tip) AS tipo_proc, IF(dea_tipo_operacion > 0, 'Sobrante Físico', 'Faltante Físico') AS motivo_diferencia,
            IF(dea_tipo_operacion > 0, (dea_cantidad_fisica - dea_existencia) , (dea_existencia - dea_cantidad_fisica)) AS diferencia",false)
            ->from('aju_ajuste_inventario')
            ->join('dea_detalle_ajuste_inv', 'dea_id_aju = aju_id')
            ->join('moi_movimiento_inv', 'moi_id_aju = aju_id')
            ->join('art_articulo', 'art_id = dea_id_art')
        ;
        if ($where != null) {
            $this->db->where($where);
        } 
        return $query->get()->result_array();
    }

    function get_existencias_unidades($where = null, $group_by = null, $having = null, $order_by = null) {
        $query = $this->db->select("mep_nombre AS UM, art_foto AS art_foto, CONCAT(tia_codigo,'-',tia_nombre) AS linea, art_codigo AS codigo, art_nombre AS nombre, art_id,
            (SELECT dee_codigo_lote FROM dee_detalle_mov WHERE dee_id_sar = sar_id GROUP BY dee_id_art LIMIT 1) AS lote,
            SUM(sar_cant_actual) AS cantidad, sar_precio AS precio, (SUM(sar_cant_actual) * sar_precio) AS total, mrp_nombre AS marca,
            (SELECT bod_nombre FROM bod_bodega WHERE bod_id = sar_id_bod) AS bodega, 
            (SELECT seb_nombre FROM sxb_sectorxbodega JOIN seb_sector_bodega ON seb_id = sxb_id_seb WHERE sxb_id = sar_id_sxb) AS sector, 
            (SELECT GROUP_CONCAT(cdp_codigo SEPARATOR ', ') FROM cdp_codigo_producto WHERE cdp_id_art = art_id) as codigo_secundario", false)
                ->from('sar_saldo_articulo')
                ->join('bod_bodega', 'bod_id = sar_id_bod', 'inner')
                ->join('art_articulo', 'art_id = sar_id_art', 'inner')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia', 'inner')
                ->join('uxb_usuarioxbodega', 'uxb_id_bod = bod_id', 'inner')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1', 'inner')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
                ->join('mrp_marca_producto', 'mrp_id = art_id_mrp', 'left')
                // ->join('cdp_codigo_producto', 'cdp_id_art = art_id', 'left')
        ;


        if ($where != null) {
            $this->db->where($where);
        }
        if ($group_by != null) {
            $this->db->group_by($group_by);
        }
        if ($having != null) {
            $this->db->having($having, false);
        }
        if ($order_by != null) {
            $this->db->order_by($order_by);
        }
        return $query->get()->result_array();
    }

    public function get_costo_salida($where = null, $promedio = 1){
        if ($promedio > 0) {
            $query = $this->db->select_max('sar_precio')
                    ->from('sar_saldo_articulo');
            if ($where != null) {
                $this->db->where($where);
            }
        }
        return $query->get()->result_array();
    }

    function get_codigo_secundario($where = null, $group_by = null, $having = null, $order_by = null) {
        $script = "
            tia_nombre AS linea,
            art_codigo AS codigo,
            art_nombre AS nombre,
            art_id,
            (SELECT GROUP_CONCAT(cdp_codigo SEPARATOR ',  ') FROM cdp_codigo_producto WHERE cdp_id_art = art_id) as codigo_sec,
            (SELECT bod_nombre FROM bod_bodega WHERE bod_id = art_id_bod) AS bodega,
        ";

        $query = $this->db->select($script, false)
                ->from('art_articulo')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia', 'inner')
                ->join('cdp_codigo_producto', 'cdp_id_art = art_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }

        if ($having != null) {
            $this->db->having($having, false);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }
}//end class
?>