<?php

/**
 * 
 */
class Gsatelite2 extends CI_Model
{

    /**
     * Gsatelite::__construct()
     * 
     * @return
     */

    private $db2;
            
    function __construct()
    {
       // $this->load->database();

        /*
            - conexion2 es para irse a traer los datos a un sql-server
            - default seria para hacer las mismas consultas pero en una base de MySql
        */

        $this->db2 = $this->load->database('', true);
        date_default_timezone_set('America/El_Salvador');
    }


    public function get_tabla($tabla, $where=null)
    {
     if(!$tabla && !is_string($tabla)){
        return null;
    }

    if($where){
        $this->db2->where($where);
    }

    $results=$this->db2->get($tabla)->result_array();
    return $results;
    }

    /**
     * Gsatelite::ingresar()
     * 
     * @param mixed $tabla
     * @param mixed $cadena
     * @return
     */
    public function ingresar($tabla, $cadena)
    {
        $this->db2->insert($tabla, $cadena);
        return $this->db2->insert_id();
    } //fin de esta funcion

    /**
     * Gsatelite::actualizar()
     * 
     * @param mixed $tabla
     * @param mixed $cadena
     * @param mixed $campo
     * @param mixed $condicion
     * @return
     */
    public function actualizar($tabla, $cadena, $campo, $condicion)
    {
        $this->db2->where($campo, $condicion);
        $this->db2->update($tabla, $cadena);
 
        return $this->db2->affected_rows();
    } //fin de esta funcion
     public function actualizar_array($tabla, $cadena, $condiciones)
    {
        $this->db2->where($condiciones);
        $this->db2->update($tabla, $cadena);
       // return $this->db2->affected_rows();
        return 1;
    }


    /**
     * Gsatelite::borrado_general()
     * 
     * @param mixed $tabla
     * @param mixed $cadena
     * @return
     */
    public function borrado_general($tabla, $cadena)
    {
        $this->db2->delete($tabla, $cadena);
        return $this->db2->affected_rows();
    } //fin de esta funcion
    
    /**
     * Gsatelite::get_dropdown()
     * Genera un array para utilizar con form_dropdown.
     * 
     * @author Alexis Beltran
     * @param string $tabla
     * @param string $display
     * @param string $name
     * @param string $where
     * @param string $selected Si = 0 agrega una opcion 'Seleccione'
     * @param string $extras
     * @return html
     */
    function get_dropdown($tabla, $display = '', $name = '', $where = '', $selected = null
                            , $extras = '', $primary = '', $soloOpciones = false)
    {
        if(!$tabla && !is_string($tabla)){
            return 'Error: Sin Tabla.';
        }
        
        //obtenemos la llave primaria
        if( $primary == '' ){
            foreach($this->db2->field_data($tabla) as $field){
                if($field->primary_key){
                    $primary = $field->name;
                }
            }
            
            if($primary == ''){
                return "Error: $tabla no tiene LLave Primaria.";
            }
        }
        
        $select = "$tabla.$primary";
        
        //pre consulta
        if(strstr($display,'{'))
    	{
    		$display = str_replace(" ", "&nbsp;", $display);
    		$select .= ", CONCAT('".str_replace(array('{','}'),array("',COALESCE(",", ''),'"),str_replace("'","\\'",$display))."') as valor ";
    	}
        else if($display == '')
        {
            $select .= ", $tabla.$primary as valor";
        }
    	else
    	{
	    	$select .= ", $tabla.$display as valor";
    	}
        
        //Consulta
        $this->db2->select($select, false);
        if($where) $this->db2->where($where);
        $this->db2->order_by('valor');
        $result = $this->db2->get($tabla);
        //echo $this->db2->last_query(); die();
        
        //Clasificador
        $return = array();
        
        if( $result->num_rows() > 0 ){
            $return[0] = 'Seleccione';
            foreach ($result->result() as $row){
                $return[$row->$primary] = $row->valor;       
            }
        }else{
            $return[0] = 'Sin Registros';
        }
            
        
        if($name == ''){
            $name = $primary;
        }
        
        $selected = set_value($name, $selected);
        
        if( $soloOpciones ){
            return $this->get_dropdown_options($return, $selected);   
        }
        $extras = ($extras=='')? 'class="nostyle" style="display:inline-block; width:480px;"':$extras;
        
        return form_dropdown($name, $return, $selected, $extras);
    }
    
    /**
     * Gsatelite::get_dropdown_options()
     * 
     * @param array $options
     * @param array $selected
     * @return string
     */
    function get_dropdown_options( $options = array() , $selected = null)
    {
        if ( ! is_array($selected))
		{
			$selected = array($selected);
		}
        
        $form = "";
        
        foreach ($options as $key => $val)
		{
			$key = (string) $key;

			if (is_array($val) && ! empty($val))
			{
				$form .= '<optgroup label="'.$key.'">'."\n";

				foreach ($val as $optgroup_key => $optgroup_val)
				{
					$sel = (in_array($optgroup_key, $selected)) ? ' selected="selected"' : '';

					$form .= '<option value="'.$optgroup_key.'"'.$sel.'>'.(string) $optgroup_val."</option>\n";
				}

				$form .= '</optgroup>'."\n";
			}
			else
			{
				$sel = (in_array($key, $selected)) ? ' selected="selected"' : '';

				$form .= '<option value="'.$key.'"'.$sel.'>'.(string) $val."</option>\n";
			}
		}
        
        return $form;
        
    }
    
    /**
     * Gsatelite::get_catalogo()
     * 
     * @param int $tipo
     * @param string $name
     * @param integer $selected
     * @param string $extras
     * @param bool $padre
     * @return html
     */
    function get_catalogo($tipo, $name = '', $selected = 0, $extras = '', $padre = false)
    {
        if(!$tipo && !is_numeric($tipo)){
            return null;
        }
        
        $where = array(
            'cat_tipo'  => $tipo,
            'cat_padre' => $padre
        );
        
        return $this->get_dropdown('cat_catalogo', 'cat_nombre', $name, $where, $selected, $extras);
    }
    
    /**
     * Gsatelite::get_catalogo_grocery()
     * 
     * @param string $campo
     * @param int $tipo
     * @param object $grocery
     * @return
     */
    function get_catalogo_grocery($campo, $tipo, &$grocery)
    {
        if( !$tipo && !is_numeric($tipo) && !$grocery ){
            return null;
        }
        
        $grocery->set_relation($campo, 'cat_catalogo', 'cat_nombre', array('cat_tipo' => $tipo, 'cat_padre' => 0), 'cat_nombre');
    }
    
    /**
     * Gsatelite::get_registro()
     * 
     * @param string $tabla
     * @param mixed $where
     * @return result o object
     */
    function get_registro($tabla, $where = null, $escape = true,$where2=false){
        
        if(!$tabla && !is_string($tabla)){
            return null;
        }
        
        if($where){
            $this->db2->where($where, $escape);
        }
        if($where2) {
            $this->db2->where($where2);
        }
        $result = $this->db2->get($tabla);
        
        if($result->num_rows() > 1){
            return $result->result();
        }else if($result->num_rows() == 1){
            return $result->row();
        }else{
            return array();
        }
        
    }   
    
    /**
     * Gsatelite::get_campo()
     * 
     * @param string $tabla
     * @param string $campo
     * @param mixed $where
     * @return
     */
    function get_campo($tabla, $campo, $where){
        //die($where);
        //obtenemos el registro
        $registro = $this->get_registro($tabla, $where);
        //echo $this->db2->last_query();
        //print_r($registro); die();
        
        if($registro){
            foreach($registro as $field => $value){
                if($field == $campo){
                    return $value;
                }
            }
        }
        return null;
    }
    
/**
     * Gsatelite::get_parametro()
     * 
     * @param string $codigo
     * @author Alexis Beltran
     * @return mixed
     */
    function get_parametro($codigo, $defecto = null, $full = false)
    {
        $tabla = 'par_parametro';
        $retorno = null;
        if($full){
            $retorno = $this->get_registro($tabla,
                array('par_codigo' => strtoupper(trim($codigo)))
                );
            
            if( count($retorno) == 0 && $defecto != null ){
                $retorno = $defecto;
            }elseif(count($retorno)==0){
                $retorno = array();
            }
            
        }else{
            $retorno = $this->get_campo($tabla, 
                'par_valor', 
                array('par_codigo' => strtoupper(trim($codigo)))
                );
            
            if( strlen($retorno) == 0 && $defecto != null ){
                $retorno = $defecto;
            }elseif(strlen($retorno) == 0){
                $retorno = '';
            }
        }
        
        return $retorno;
    }
    
    /**
     * Gsatelite::get_areas_by_user()
     * 
     * @param int $user
     * @param bool $full
     * @param int $area
     * @return
     */
    function get_areas_by_user($user, $full = false, $area = 0)
    {
        $area_user = $this->get_campo('users', 'use_id_are', array('id' => $user));
        
        if($area){
            return ($area_user == $area);
        }else{
            if($full){
                return $this->get_registro('are_area', array('are_id' => $area_user));
            }else{
                return $area_user;
            }
        }
    }
    
    /**
     * show_dialog()
     * 
     * @author Alexis Beltran
     * @param string $mensaje
     * @param string $tipo
     * @param string $cabecera
     * @return void
     */
    function show_dialog($mensaje, $url = '', $tipo = 'success', $cabecera = ''){
            
        switch ($tipo){ 
        	case 'success':
                $alerta = array(
                    'tipo_alerta'   =>  'success',
                    'titulo_alerta' =>  ($cabecera)? $cabecera : "Éxito.",
                    'texto_alerta'  =>  $mensaje);
        	break;
        
        	case 'error':
                $alerta = array(
                    'tipo_alerta'   =>  'error',
                    'titulo_alerta' =>  ($cabecera)? $cabecera : "Error.",
                    'texto_alerta'  =>  $mensaje);
        	break;
        
        	case 'warning':
                $alerta = array(
                    'tipo_alerta'   =>  'warning',
                    'titulo_alerta' =>  ($cabecera)? $cabecera : "Advertencia.",
                    'texto_alerta'  =>  $mensaje);
            break;
        
        	default :
                $alerta = array(
                    'tipo_alerta'   =>  'note',
                    'titulo_alerta' =>  ($cabecera)? $cabecera : "",
                    'texto_alerta'  =>  $mensaje);
        }
        
        $this->session->set_flashdata($alerta);
        redirect($url);
    }
    
    function send_email($para, $asunto, $html)
    {
        $this->load->library('email');

        $this->email->from($this->gsatelite->get_parametro('SYS_EMAIL_FROM'), 'ERP CONAMYPE');
        $this->email->to($para); 
        
        $this->email->subject($asunto);
        $this->email->message($html);	
        
        $this->email->send();
        
        //echo $this->email->print_debugger();
    }

  function get_data_acc_especifica($id_acc){
    $data_acc= $this->db2->query("select * from acc_accion as acc 
    inner join dac_detalle_accion dac on dac.dac_id_acc = acc.acc_id
     where dac.dac_id=".$id_acc)->row_array();
     return $data_acc; 

  }

  function update_registro($array, $tabla, $key){
      $this->db2->where('acc_id', $key);
        return $this->db2->update($tabla, $array);


  }

  function get_notificaciones()
  {
     $resultado=$this->get_notificacionesxrol($this->tank_auth->get_user_id());
     $notificaciones = array();
     foreach ($resultado as $key) {
        $conteo = $this->contar_notificaciones($key['tab_nombre'],$key['tar_id'],$key['not_id_pas']);
        $total=0;
        if (count($conteo)>0) {
                    $total=$conteo['total'];
                     $notificaciones[]=array('mensaje'=>$key['not_mensaje'],'total'=> $total);   
                }        
             
     }     
     if(count($notificaciones)>0)
     return $notificaciones;    
 else
    return 0;
  }

  function contar_notificaciones($tabla,$tarea,$paso)
  {    
    $id = $this->get_prefijo($tabla);
    $cadena='select count(pro_get_orden_actual('.$tarea.','.$id.')) as total, 
    pro_get_orden_actual('.$tarea.','.$id.') as paso 
    from che_cheque 
    where pro_get_orden_actual('.$tarea.','.$id.')='.$paso.' 
    group by pro_get_orden_actual('.$tarea.','.$id.')';
    $query=$this->db2->query($cadena);
        return $query->row_array();
  }

  function get_prefijo($cadena)
  {
    $prefijo=explode('_', $cadena);
    return $prefijo[0].'_id';    
  }



  function get_notificacionesxrol($id)
  {
    $this->db2->select()
        ->where('uxr_id_usu',$id)
        ->from('uxr_usuarioxrol')
        ->join('nxr_notificacionxrol','nxr_id_rol=uxr_id_rol')
        ->join('not_notificacion','not_id=nxr_id_not')
        ->join('tab_tabla','tab_id=not_id_tab')
        ->join('tar_tarea','tar_id_tab=tab_id');
        $query=$this->db2->get();                
        return $query->result_array();  
  }

  function get_alertas()
  {
    $resultado=$this->get_alertasxrol($this->tank_auth->get_user_id());
    $notificaciones = array();
    foreach ($resultado as $key) {
        $registros =  $this->get_registro_alerta($key);        
        foreach ($registros as $key2) {
            $notificaciones[]=array('mensaje'=>$key['ale_mensaje'],'id'=> $key2['id'],'campo' => $key2['campo'], 'fecha' => $key2['fecha']);  
        }
        
    }
    if(count($notificaciones)>0)
     return $notificaciones;    
 else
    return 0;
  }
   
  function get_registro_alerta($arr)
  {
    $id = $this->get_prefijo($arr['tab_nombre']);
    $fecha=$arr['ale_campo_fecha'];    
    $this->db2->select($id.' as id, '.$arr['ale_campo_select'].' as campo, '.$arr['ale_campo_fecha'].' as fecha')
        ->where('DATE_ADD('.$arr['ale_campo_fecha'].', INTERVAL '.$arr['ale_dias_despues'].' DAY) >=',date('Y-m-d'))
        ->where('DATE_ADD('.$arr['ale_campo_fecha'].', INTERVAL -'.$arr['ale_dias_antes'].' DAY) <=',date('Y-m-d'))
        ->from($arr['tab_nombre']);
        $query=$this->db2->get();                
        return $query->result_array();  
  }

  function get_alertasxrol($id)
  {
    $this->db2->select()
        ->where('uxr_id_usu',$id)
        ->from('uxr_usuarioxrol')
        ->join('axr_alertaxrol','axr_id_rol=uxr_id_rol')
        ->join('ale_alerta','ale_id=axr_id_ale')
        ->join('tab_tabla','tab_id=ale_id_tab')
        ->join('tar_tarea','tar_id_tab=tab_id','left');
        $query=$this->db2->get();                
        return $query->result_array();  
  }

  function get_noticias()
  {
    $this->db2->select()
        ->where('anu_estado',1)
        ->from('anu_anuncio');        
        $query=$this->db2->get();                
        return $query->result_array();  
  }
  
  /**
  *@author René Castaneda
  *@param date $fecha1 (inicio -fecha menor-), date $fecha2 (fin -fecha mayor-)
  */
  function get_intervalo_dias($fecha1=null,$fecha2=null) {
    if($fecha1==null) { return 0; }
    if($fecha2==null) { $fecha2=date('Y-m-d H:s:i'); }

    $fecha1 = date('Y-m-d',strtotime($fecha1));
    $fecha2 = date('Y-m-d',strtotime($fecha2));
    $datetime1 = new DateTime($fecha1);//fecha de presentación
    $datetime2 = new DateTime($fecha2);//fecha actual
    $interval = $datetime1->diff($datetime2);
    $resta =  $interval->format('%R%a');
    return str_replace('+', '', $resta);
  }

  function verificar_registro_real($tabla=null,$id=null) {
    if($tabla==null or $id==null or !is_numeric($id)){
         $this->show_dialog('Petición no valida','inicio/index', 'error', 'Petición no valida');
    }
    else {
        $prefijo = current(explode('_', $tabla));
        if(count($this->get_tabla($tabla,array($prefijo.'_id'=>$id)))<=0){
        $this->show_dialog('Error en registro','inicio/index', 'error', 'Petición no valida');
        }
    }
  }


  /**
  *@author : René Castaneda 
  *string $de : (quien envia el correo)
  *string $nombre_envia : (nombre de quien envia el correo)
  *array/string $para : (a quienes sera dirigido el correo electronico)
  *string $mensaje : (texto del mensaje a enviar)
  *string $asunto : asunto del correo
  *array/string $copias : (a quienes se les enviará copia del mensaje)
  *
  **/
  function envio_correo($de="",$nombre_envia="",$para="",$asunto="ENVIO CORREO",$mensaje="",$copias=null,$ruta_adjunto=null) {

        $this->load->library('email');
        $config['protocol'] = "smtp";
        $config['smtp_host'] = "ssl://mail.gruposatelite.net";
        $config['smtp_port'] = "465";
        $config['smtp_user'] = $this->gsatelite->get_parametro('CORREO_ADMIN'); 
        $config['smtp_pass'] = "Nuevo1010";
        $config['charset'] = "utf-8";
        $config['mailtype'] = "html";
        $config['newline'] = "\r\n";

        $this->email->initialize($config);

        $this->email->from($de,$nombre_envia);
        $this->email->to($para);
        if($copias) {
            $this->email->cc($copias); 
        }
        $this->email->reply_to($de,$nombre_envia);
        $this->email->subject($asunto);
        $this->email->message($mensaje);

        if($ruta_adjunto){
        $this->email->attach($ruta_adjunto);
        }

        if($this->email->send()) {
            return 1;
        } 
        else {
            return 0;
        }
  }
/**
*@author René Castaneda
*/
  function cargar_vista_masterpage($ubicacion_vista=null,$datos_vista=null,$grocery_output=null) {
    $datos_vista = ($datos_vista)? $datos_vista:array();
    if($ubicacion_vista!=null) {
        $data = $datos_vista;
    if($grocery_output) {
       $data =  array_merge($datos_vista,(array)$grocery_output);  
    }
    $html = $this->load->view($ubicacion_vista,$data, true);
    $data['contenido_html'] = $html;
    $this->load->view('carga_vista_masterpage',$data);
    }
  }


    /**
  *@author René Castaneda
  */
  function convertir_hora($hora=null,$tipo=1,$sumar_resta_tiempo='00:00:00',$tipo_extra=1) {
    /*
    $tipo=1 (segundos) $tipo=2 (minutos) $tipo=3 (horas)
    $tipo_extra = 1=sumatoria,2=resta
    convertir una hora debe tener el formato siguiente 00:00:00 (hh:mm:ss), hora minutos y segundos
    */

///sumar tiempo 
    $suma_t = explode(':', $sumar_resta_tiempo);
    $sh=intval("$suma_t[0]");
    $sm=intval("$suma_t[1]");
    $ss=intval("$suma_t[2]");
   // $segundos_adicionales =   mktime($hh,$hm,$hs,0,0,0);
    $segundos_adicionales =   ($sh * 3600 ) + ($sm * 60 ) + $ss;

    $tiempo=0;
    if($hora){
        $h = explode(':',$hora);
        $hh=intval("$h[0]");
        $hm=intval("$h[1]");
        $hs=intval("$h[2]");
        $segundos = ($hh * 3600 ) + ($hm * 60 ) + $hs;
        if($tipo_extra==1) {
        $segundos = $segundos + $segundos_adicionales;
        }
        else {
          $segundos = $segundos - $segundos_adicionales;  
        }
      //$segundos =   mktime($hh,$hm,$hs,0,0,0);
      if($tipo==1) {
        $tiempo=$segundos;
      }
      else if($tipo==2) { //minutos
        $tiempo = $segundos/60;
      }
      else  if($tipo==3) { //horas
       $tiempo = $segundos/60/60;
      }
      else {
         $tiempo=$segundos;
      }
    }

    return $tiempo;

  }

  /**
  *@author René Castaneda
  *@return hora militar (00:00:00 - 23:59:59)
  **/

  function convertir_hora_militar($hora=null) {
    /*
    La función recibirá como parametro una hora normal que se identificará si
    es pm o am para convertirla en hora militar
    */
    $hora_return = "";
    if($hora){
        $separar = explode(' ',trim($hora));
        if(count($separar)==2) { //separar en am o pm de la hora
            $h = explode(':', $separar[0]);
            $pm_am = str_replace('.','',$separar[1]);
            $array_pm = array('01','02','03','04','05','06','07','08','09','10','11','12');
            $array_militar = array('13','14','15','16','17','18','19','20','21','22','23','00');
            if(strtolower($pm_am)=='pm'){
                $hora = str_replace($array_pm, $array_militar, $h[0]);
                $hora_return = "$hora:$h[1]:$h[2]";
            } else {
                 $hora_return = "$h[0]:$h[1]:$h[2]";
            }

        }

    }
    return $hora_return;
  }

  public function restar_horas_mysql($hora1, $hora2)
  {
    $h_en_array = explode(':',$hora1);
    $h_sal_array = explode(':',$hora2);
    $h_enh = $h_en_array[0] + ($h_en_array[1]/60)+(($h_en_array[2]/60)/60); //convertir todo a horas 
    $h_salh = $h_sal_array[0] + ($h_sal_array[1]/60)+(($h_sal_array[2]/60)/60); //convertir todo a horas
    $horas =  $h_salh - $h_enh;
    return $horas;
  }

    public function get_permisos_opcion($nombre_funcion=null) {
      $id_usuario = $this->tank_auth->get_user_id();
          $array_permisos = array(
          'permite_ver'=>0
          ,'permite_agregar'=>0
          ,'permite_editar'=>0
          ,'permite_eliminar'=>0
          );
  if($nombre_funcion) {

      $query=$this->db2->query("
           SELECT oxr_opcionxrol.* from usu_usuario
          JOIN uxr_usuarioxrol on uxr_id_usu=usu_id
          JOIN rol_rol on rol_id = uxr_id_rol
          JOIN oxr_opcionxrol on oxr_id_rol=rol_id
          JOIN opc_opcion on opc_id = oxr_id_opc
          where opc_funcion='$nombre_funcion' and uxr_id_usu=$id_usuario
          limit 1
          ")->row_array();
  if(count($query)>0) {
          $array_permisos = array(
          'permite_ver'=>$query['oxr_ver']
          ,'permite_agregar'=>$query['oxr_insertar']
          ,'permite_editar'=>$query['oxr_editar']
          ,'permite_eliminar'=>$query['oxr_eliminar']
          );
  }

  }

  return $array_permisos;

    }


  }

?>