<?php

/**
 * 
 */
class Gsatelite extends CI_Model {

    /**
     * Gsatelite::__construct()
     * 
     * @return
     */
    function __construct() {
        $this->load->database();
        date_default_timezone_set('America/El_Salvador');
    }

    public function count($tabla, $where = null) {
        $this->db->from($tabla);
        if ($where != null) {
            $this->db->where($where);
        }
        $cantidad = $this->db->get()->num_rows();
        return $cantidad;
    }

    public function get_suma($table = null, $campo = null, $where = null) {
        if ($table == null) {
            return null;
        }

        if ($campo == null) {
            return null;
        }

        $query = $this->db->select_sum($campo, 'suma')
                ->from($table)
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $result = $query->get()->result_array();

        return ($result[0]['suma'] != null) ? $result[0]['suma'] : 0;
    }

    public function get_max($table = null, $campo = null, $where = null) {
        if ($table == null) {
            return null;
        }

        if ($campo == null) {
            return null;
        }

        $query = $this->db->select_max($campo)
                ->from($table)
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $result = $query->get()->result_array();

        return ($result) ? $result[0][$campo] : 0;
    }

    public function get_max_numerico($tabla, $campo, $where = null) {
        $this->db->select_max($campo);
        if ($where) {
            $this->db->where($where);
        }

        $this->db->where("{$campo} REGEXP '^[0-9]+$'"); 
        $result = $this->db->get($tabla);
        $max_valor = 0;
    
        if ($result->num_rows() == 1) {
            $row = $result->row();
            $max_valor = $row->$campo;
        }
    
        return $max_valor;
    }

    public function get_min($table = null, $campo = null, $where = null) {
        if ($table == null) {
            return null;
        }

        if ($campo == null) {
            return null;
        }

        $query = $this->db->select_min($campo)
                ->from($table)
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $result = $query->get()->result_array();

        return $result[0][$campo];
    }

    public function get_tabla($tabla, $where = null) {
        if (!$tabla && !is_string($tabla)) {
            return null;
        }

        if ($where) {
            $this->db->where($where);
        }

        $results = $this->db->get($tabla)->result_array();
        return $results;
    }

    /**
     * Gsatelite::ingresar()
     * 
     * @param mixed $tabla
     * @param mixed $cadena
     * @return
     */
    public function ingresar($tabla, $cadena, $tipo = false) {
        if ($tipo) { //insetar varios registros
            $this->db->insert_batch($tabla, $cadena);
            return $this->db->affected_rows();     //retornar la cantidad de registros insertados
        } else {
            if (trim($tabla) != '' && is_array($cadena)) {
                $this->db->insert($tabla, $cadena);
                return $this->db->insert_id(); //retornar el id ingresado
            } else {
                return null; //no hubo exito
            }
        }
    }

    //fin de esta funcion

    /**
     * Gsatelite::actualizar()
     * 
     * @param mixed $tabla
     * @param mixed $cadena
     * @param mixed $campo
     * @param mixed $condicion
     * @return
     */
    public function actualizar($tabla, $cadena, $campo, $condicion) {
        $this->db->where($campo, $condicion);
        $this->db->update($tabla, $cadena);

        return $this->db->affected_rows();
    }

    //fin de esta funcion

    public function actualizar_array($tabla, $cadena, $condiciones) {
        $this->db->where($condiciones);
        $this->db->update($tabla, $cadena);
        // return $this->db->affected_rows();
        return 1;
    }

    /**
     * Gsatelite::borrado_general()
     * 
     * @param mixed $tabla
     * @param mixed $cadena
     * @return
     */
    public function borrado_general($tabla, $cadena) {
        $this->db->delete($tabla, $cadena);
        return $this->db->affected_rows();
    }

    //fin de esta funcion

    /**
     * Gsatelite::get_dropdown()
     * Genera un array para utilizar con form_dropdown.
     * 
     * @author Alexis Beltran
     * @param string $tabla
     * @param string $display
     * @param string $name
     * @param string $where
     * @param string $selected Si = 0 agrega una opcion 'Seleccione'
     * @param string $extras
     * @return html
     */
    function get_dropdown($tabla, $display = '', $name = '', $where = '', $selected = null, $extras = '', $primary = '', $soloOpciones = false) {
        if (!$tabla && !is_string($tabla)) {
            return 'Error: Sin Tabla.';
        }

        //obtenemos la llave primaria
        if ($primary == '') {
            foreach ($this->db->field_data($tabla) as $field) {
                if ($field->primary_key) {
                    $primary = $field->name;
                }
            }

            if ($primary == '') {
                return "Error: $tabla no tiene LLave Primaria.";
            }
        }

        $select = "$tabla.$primary";

        //pre consulta
        if (strstr($display, '{')) {
            $display = str_replace(" ", "&nbsp;", $display);
            $select .= ", CONCAT('" . str_replace(array('{', '}'), array("',COALESCE(", ", ''),'"), str_replace("'", "\\'", $display)) . "') as valor ";
        } elseif (strstr($display, '[')) {
            $select .= ", " . str_replace(array('[', ']'), array('', ''), $display) . " as valor";
        } else if ($display == '') {
            $select .= ", $tabla.$primary as valor";
        } else {
            $select .= ", $tabla.$display as valor";
        }

        //Consulta
        $this->db->select($select, false);
        if ($where)
            $this->db->where($where);
        $this->db->order_by('valor');
        $result = $this->db->get($tabla);
        //echo $this->db->last_query(); die();
        //Clasificador
        $return = array();

        if (is_object($result) && $result->num_rows() > 0) {
            $return[0] = 'Seleccione';
            foreach ($result->result() as $row) {
                $return[$row->$primary] = $row->valor;
            }
        } else {
            $return[0] = 'Sin Registros';
        }


        if ($name == '') {
            $name = $primary;
        }

        $selected = set_value($name, $selected);

        if ($soloOpciones) {
            return $this->get_dropdown_options($return, $selected);
        }
        $extras = ($extras == '') ? 'class="nostyle" style="display:inline-block; width:480px;"' : $extras;

        return form_dropdown($name, $return, $selected, $extras);
    }

    /**
     * Gsatelite::get_dropdown_options()
     * 
     * @param array $options
     * @param array $selected
     * @return string
     */
    function get_dropdown_options($options = array(), $selected = null) {
        if (!is_array($selected)) {
            $selected = array($selected);
        }

        $form = "";

        foreach ($options as $key => $val) {
            $key = (string) $key;

            if (is_array($val) && !empty($val)) {
                $form .= '<optgroup label="' . $key . '">' . "\n";

                foreach ($val as $optgroup_key => $optgroup_val) {
                    $sel = (in_array($optgroup_key, $selected)) ? ' selected="selected"' : '';

                    $form .= '<option value="' . $optgroup_key . '"' . $sel . '>' . (string) $optgroup_val . "</option>\n";
                }

                $form .= '</optgroup>' . "\n";
            } else {
                $sel = (in_array($key, $selected)) ? ' selected="selected"' : '';

                $form .= '<option value="' . $key . '"' . $sel . '>' . (string) $val . "</option>\n";
            }
        }

        return $form;
    }

    /**
     * Gsatelite::get_catalogo()
     * 
     * @param int $tipo
     * @param string $name
     * @param integer $selected
     * @param string $extras
     * @param bool $padre
     * @return html
     */
    function get_catalogo($tipo, $name = '', $selected = 0, $extras = '', $padre = false) {
        if (!$tipo && !is_numeric($tipo)) {
            return null;
        }

        $where = array(
            'cat_tipo' => $tipo,
            'cat_padre' => $padre
        );

        return $this->get_dropdown('cat_catalogo', 'cat_nombre', $name, $where, $selected, $extras);
    }

    /**
     * Gsatelite::get_catalogo_grocery()
     * 
     * @param string $campo
     * @param int $tipo
     * @param object $grocery
     * @return
     */
    function get_catalogo_grocery($campo, $tipo, &$grocery) {
        if (!$tipo && !is_numeric($tipo) && !$grocery) {
            return null;
        }

        $grocery->set_relation($campo, 'cat_catalogo', 'cat_nombre', array('cat_tipo' => $tipo, 'cat_padre' => 0), 'cat_nombre');
    }

    /**
     * Gsatelite::get_registro()
     * 
     * @param string $tabla
     * @param mixed $where
     * @return result o object
     */
    function get_registro($tabla, $where = null, $escape = true, $where2 = false) {

        if (!$tabla && !is_string($tabla)) {
            return null;
        }

        if ($where) {
            $this->db->where($where, $escape);
        }
        if ($where2) {
            $this->db->where($where2);
        }
        $result = $this->db->get($tabla);

        if ($result->num_rows() > 1) {
            return $result->result();
        } else if ($result->num_rows() == 1) {
            return $result->row();
        } else {
            return array();
        }
    }

    /**
     * Gsatelite::get_campo()
     * 
     * @param string $tabla
     * @param string $campo
     * @param mixed $where
     * @return
     */
    function get_campo($tabla, $campo, $where) {
        //die($where);
        //obtenemos el registro
        $registro = $this->get_registro($tabla, $where);
        //echo $this->db->last_query();
        //print_r($registro); die();

        if ($registro) {
            foreach ($registro as $field => $value) {
                if ($field == $campo) {
                    return $value;
                }
            }
        }
        return null;
    }

    /**
     * Gsatelite::get_parametro()
     * 
     * @param string $codigo
     * @param array $json
     * @author Alexis Beltran
     * @return mixed
     */
    function get_parametro($codigo, $defecto = null, $full = false, $json = null) {

        $tabla = 'par_parametro';
        $retorno = null;
        if ($full) {
            $retorno = $this->get_registro( $tabla, array('par_codigo' => strtoupper(trim($codigo))));

            if (count((array)$retorno) == 0 && $defecto != null) {
                $retorno = $defecto;
            } elseif (count((array)$retorno) == 0) {
                $retorno = array();
            }
        } else {
            $retorno = $this->get_campo($tabla, 'par_valor', array('par_codigo' => strtoupper(trim($codigo))));
            if (is_array($json)) {

                $array_datos = array();
                $decode = json_decode($retorno, true);
                if (count($json) == 1) {
                    foreach ($json as $key => $value) {
                        $retorno = isset($decode[$value]) ? $decode[$value] : null;
                    }
                } else if (count($json) > 0) {
                    foreach ($json as $key => $value) {
                        $array_datos[] = isset($decode[$value]) ? $decode[$value] : null;
                    }

                    $retorno = $array_datos;
                } else {
                    $array_datos = $decode;
                }
            } else {
                if (strlen($retorno) == 0 && $defecto != null) {
                    $retorno = $defecto;
                } elseif (strlen($retorno) == 0) {
                    $retorno = '';
                }
            }
        }
        return $retorno;
    }

    /**
     * Gsatelite::get_areas_by_user()
     * 
     * @param int $user
     * @param bool $full
     * @param int $area
     * @return
     */
    function get_areas_by_user($user, $full = false, $area = 0) {
        $area_user = $this->get_campo('users', 'use_id_are', array('id' => $user));

        if ($area) {
            return ($area_user == $area);
        } else {
            if ($full) {
                return $this->get_registro('are_area', array('are_id' => $area_user));
            } else {
                return $area_user;
            }
        }
    }

    /**
     * show_dialog()
     * 
     * @author Alexis Beltran
     * @param string $mensaje
     * @param string $tipo
     * @param string $cabecera
     * @return void
     */
    function show_dialog($mensaje, $url = '', $tipo = 'success', $cabecera = '') {

        switch ($tipo) {
            case 'success':
                $alerta = array(
                    'tipo_alerta' => 'success',
                    'titulo_alerta' => ($cabecera) ? $cabecera : "Éxito.",
                    'texto_alerta' => $mensaje
                );
                break;

            case 'error':
                $alerta = array(
                    'tipo_alerta' => 'error',
                    'titulo_alerta' => ($cabecera) ? $cabecera : "Error.",
                    'texto_alerta' => $mensaje
                );
                break;

            case 'warning':
                $alerta = array(
                    'tipo_alerta' => 'warning',
                    'titulo_alerta' => ($cabecera) ? $cabecera : "Advertencia.",
                    'texto_alerta' => $mensaje
                );
                break;
            case 'info':
                $alerta = array(
                    'tipo_alerta' => 'info',
                    'titulo_alerta' => ($cabecera) ? $cabecera : "Informaci&oacute;n.",
                    'texto_alerta' => $mensaje
                );
                break;

            default:
                $alerta = array(
                    'tipo_alerta' => 'note',
                    'titulo_alerta' => ($cabecera) ? $cabecera : "Notificaci&oacute;n",
                    'texto_alerta' => $mensaje
                );
        }

        $this->session->set_flashdata($alerta);
        redirect($url);
    }

    function send_email($para, $asunto, $html) {
        $this->load->library('email');

        $this->email->from($this->gsatelite->get_parametro('SYS_EMAIL_FROM'), 'ERP CONAMYPE');
        $this->email->to($para);

        $this->email->subject($asunto);
        $this->email->message($html);

        $this->email->send();

        //echo $this->email->print_debugger();
    }

    function get_data_acc_especifica($id_acc) {
        $data_acc = $this->db->query("select * from acc_accion as acc 
    inner join dac_detalle_accion dac on dac.dac_id_acc = acc.acc_id
     where dac.dac_id=" . $id_acc)->row_array();
        return $data_acc;
    }

    function update_registro($array, $tabla, $key) {
        $this->db->where('acc_id', $key);
        return $this->db->update($tabla, $array);
    }

    function get_notificaciones() {
        $resultado = $this->get_notificacionesxrol($this->tank_auth->get_user_id());
        $notificaciones = array();
        foreach ($resultado as $key) {
            $conteo = $this->contar_notificaciones($key['tab_nombre'], $key['tar_id'], $key['not_id_pas']);
            $total = 0;
            if (count($conteo) > 0) {
                $total = $conteo['total'];
                $notificaciones[] = array('mensaje' => $key['not_mensaje'], 'total' => $total);
            }
        }
        if (count($notificaciones) > 0)
            return $notificaciones;
        else
            return 0;
    }

    function contar_notificaciones($tabla, $tarea, $paso) {
        $id = $this->get_prefijo($tabla);
        $cadena = 'select count(pro_get_orden_actual(' . $tarea . ',' . $id . ')) as total, 
    pro_get_orden_actual(' . $tarea . ',' . $id . ') as paso 
    from che_cheque 
    where pro_get_orden_actual(' . $tarea . ',' . $id . ')=' . $paso . ' 
    group by pro_get_orden_actual(' . $tarea . ',' . $id . ')';
        $query = $this->db->query($cadena);
        return $query->row_array();
    }

    function get_prefijo($cadena) {
        $prefijo = explode('_', $cadena);
        return $prefijo[0] . '_id';
    }

    function get_notificacionesxrol($id) {
        $this->db->select()
            ->where('uxr_id_usu', $id)
            ->from('uxr_usuarioxrol')
            ->join('nxr_notificacionxrol', 'nxr_id_rol=uxr_id_rol')
            ->join('not_notificacion', 'not_id=nxr_id_not')
            ->join('tab_tabla', 'tab_id=not_id_tab')
            ->join('tar_tarea', 'tar_id_tab=tab_id');
        $query = $this->db->get();
        return $query->result_array();
    }

    function get_alertas() {
        $resultado = $this->get_alertasxrol($this->tank_auth->get_user_id());
        $notificaciones = array();
        foreach ($resultado as $key) {
            $registros = $this->get_registro_alerta($key);
            foreach ($registros as $key2) {
                $notificaciones[] = array('mensaje' => $key['ale_mensaje'], 'id' => $key2['id'], 'campo' => $key2['campo'], 'fecha' => $key2['fecha']);
            }
        }
        if (count($notificaciones) > 0)
            return $notificaciones;
        else
            return 0;
    }

    function get_registro_alerta($arr) {
        $id = $this->get_prefijo($arr['tab_nombre']);
        $fecha = $arr['ale_campo_fecha'];
        $this->db->select($id . ' as id, ' . $arr['ale_campo_select'] . ' as campo, ' . $arr['ale_campo_fecha'] . ' as fecha')
            ->where('DATE_ADD(' . $arr['ale_campo_fecha'] . ', INTERVAL ' . $arr['ale_dias_despues'] . ' DAY) >=', date('Y-m-d'))
            ->where('DATE_ADD(' . $arr['ale_campo_fecha'] . ', INTERVAL -' . $arr['ale_dias_antes'] . ' DAY) <=', date('Y-m-d'))
            ->from($arr['tab_nombre']);
        $query = $this->db->get();
        return $query->result_array();
    }

    function get_alertasxrol($id) {
        $this->db->select()
            ->where('uxr_id_usu', $id)
            ->from('uxr_usuarioxrol')
            ->join('axr_alertaxrol', 'axr_id_rol=uxr_id_rol')
            ->join('ale_alerta', 'ale_id=axr_id_ale')
            ->join('tab_tabla', 'tab_id=ale_id_tab')
            ->join('tar_tarea', 'tar_id_tab=tab_id', 'left');
        $query = $this->db->get();
        return $query->result_array();
    }

    function get_noticias() {
        $this->db->select()
            ->where('anu_estado', 1)
            ->from('anu_anuncio');
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * @author René Castaneda
     * @param date $fecha1 (inicio -fecha menor-), date $fecha2 (fin -fecha mayor-)
     */
    function get_intervalo_dias($fecha1 = null, $fecha2 = null) {
        if ($fecha1 == null) {
            return 0;
        }
        if ($fecha2 == null) {
            $fecha2 = date('Y-m-d H:s:i');
        }

        $fecha1 =  formatear_fecha('Y-m-d', $fecha1); //date('Y-m-d', strtotime($fecha1));
        $fecha2 =  formatear_fecha('Y-m-d', $fecha2); //date('Y-m-d', strtotime($fecha2));
        $datetime1 = new DateTime($fecha1); //fecha de presentación
        $datetime2 = new DateTime($fecha2); //fecha actual
        $interval = $datetime1->diff($datetime2);
        $resta = $interval->format('%R%a');
        return str_replace('+', '', $resta);
    }

    /**
     *@modify by: Mario Marquez
     *string $tabla: Nombre de la tabla a utilizar
     *int $id = identificador o id del registro a buscar
     *bool $return_resultado: Retorna el resultado como un Boolean, en caso de estar el parametro True.
     * @function: Verifica la existencia de un registro en la tabla especificada
     */
    function verificar_registro_real($tabla = null, $id = null, $return_resultado = false) {
        if ($tabla == null or $id == null or !is_numeric($id)) {
            $this->show_dialog('Petición no valida', 'inicio/index', 'error', 'Petición no valida');
        } else {
            $prefijo = current(explode('_', $tabla));
            $resultado = count($this->get_tabla($tabla, array($prefijo . '_id' => $id)));
            if ($resultado <= 0) {
                if ($return_resultado == true) {
                    return false;
                }
                $this->show_dialog('Error en registro', 'inicio/index', 'error', 'Petición no valida');
            }
            return true;
        }
    }

    /**
     * @author : René Castaneda 
     * string $de : (quien envia el correo)
     * string $nombre_envia : (nombre de quien envia el correo)
     * array/string $para : (a quienes sera dirigido el correo electronico)
     * string $mensaje : (texto del mensaje a enviar)
     * string $asunto : asunto del correo
     * array/string $copias : (a quienes se les enviará copia del mensaje)
     *
     * */
   function envio_correo($de = "", $nombre_envia = "", $para = "", $asunto = "ENVIO CORREO", $mensaje = "", $copias = null, $ruta_adjunto = null, $copia_oculta = false) {
    // Obtener configuración desde base
    $json_config = $this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_CORREO');
    $params = json_decode($json_config);

    $cuenta = isset($params->SMTPUser) ? $params->SMTPUser : 'facturacion@instruquimica.com';
    $debug  = isset($params->debug) ? (bool)$params->debug : false;

    $nombre_envia = ($nombre_envia != "") ? $nombre_envia : 'noreply';
    $from_email   = ($de != "") ? $de : $cuenta;

    if (empty($para)) {
        $msg = 'envio_correo(): destinatario vacío';
        log_message('error', $msg);
        if ($debug) echo $msg;
        return 0;
    }

    // Múltiples destinatarios como string separados por coma
    if (is_string($para) && strpos($para, ',') !== false) {
        $para = array_map('trim', explode(',', $para));
    }

    // CC o BCC según el parámetro $copia_oculta
    $cc  = !$copia_oculta ? $copias : null;
    $bcc =  $copia_oculta ? $copias : null;

    if (is_string($cc) && strpos($cc, ',') !== false) {
        $cc = array_map('trim', explode(',', $cc));
    }

    if (is_string($bcc) && strpos($bcc, ',') !== false) {
        $bcc = array_map('trim', explode(',', $bcc));
    }

    if (is_string($ruta_adjunto) && strpos($ruta_adjunto, ',') !== false) {
        $ruta_adjunto = array_map('trim', explode(',', $ruta_adjunto));
    }

    $this->load->library('EmailPHPMailer');
    $ok = $this->emailphpmailer->enviar($from_email, $nombre_envia, $para, $asunto, $mensaje, $cc, $bcc, $ruta_adjunto);

    if (!$ok) {
        $msg = 'envio_correo(): fallo el envío de correo.';
        log_message('error', $msg);
        if ($debug) echo $msg;
        return 0;
    }

    return 1;
}

    /**
     * @author René Castaneda
     */
    function cargar_vista_masterpage($ubicacion_vista = null, $datos_vista = null, $grocery_output = null) {
        $datos_vista = ($datos_vista) ? $datos_vista : array();
        if ($ubicacion_vista != null) {
            $data = $datos_vista;
            if ($grocery_output) {
                $data = array_merge($datos_vista, (array) $grocery_output);
            }
            $html = $this->load->view($ubicacion_vista, $data, true);
            $data['contenido_html'] = $html;
            $this->load->view('carga_vista_masterpage', $data);
        }
    }

    /**
     * @author René Castaneda
     */
    function convertir_hora($hora = null, $tipo = 1, $sumar_resta_tiempo = '00:00:00', $tipo_extra = 1) {
        /*
          $tipo=1 (segundos) $tipo=2 (minutos) $tipo=3 (horas)
          $tipo_extra = 1=sumatoria,2=resta
          convertir una hora debe tener el formato siguiente 00:00:00 (hh:mm:ss), hora minutos y segundos
         */

        ///sumar tiempo 
        $suma_t = explode(':', $sumar_resta_tiempo);
        $sh = intval("$suma_t[0]");
        $sm = intval("$suma_t[1]");
        $ss = intval("$suma_t[2]");
        // $segundos_adicionales =   mktime($hh,$hm,$hs,0,0,0);
        $segundos_adicionales = ($sh * 3600) + ($sm * 60) + $ss;

        $tiempo = 0;
        if ($hora) {
            $h = explode(':', $hora);
            $hh = intval("$h[0]");
            $hm = intval("$h[1]");
            $hs = intval("$h[2]");
            $segundos = ($hh * 3600) + ($hm * 60) + $hs;
            if ($tipo_extra == 1) {
                $segundos = $segundos + $segundos_adicionales;
            } else {
                $segundos = $segundos - $segundos_adicionales;
            }
            //$segundos =   mktime($hh,$hm,$hs,0,0,0);
            if ($tipo == 1) {
                $tiempo = $segundos;
            } else if ($tipo == 2) { //minutos
                $tiempo = $segundos / 60;
            } else if ($tipo == 3) { //horas
                $tiempo = $segundos / 60 / 60;
            } else {
                $tiempo = $segundos;
            }
        }

        return $tiempo;
    }

    function es_administrador($id_usuario) {
        $this->db->select("count(uxr_id) AS usuario")
            ->from('users')
            ->join('uxr_usuarioxrol', 'uxr_id_usu = id')
            ->where('id', $id_usuario)
            ->where('uxr_id_rol', 1)
        ;

        return $this->db->get()->row_array();
    }

    /**
     * @author René Castaneda
     * @return hora militar (00:00:00 - 23:59:59)
     * */
    function convertir_hora_militar($hora = null) {
        /*
          La función recibirá como parametro una hora normal que se identificará si
          es pm o am para convertirla en hora militar
         */
        $hora_return = "";
        if ($hora) {
            $separar = explode(' ', trim($hora));
            if (count($separar) == 2) { //separar en am o pm de la hora
                $h = explode(':', $separar[0]);
                $pm_am = str_replace('.', '', $separar[1]);
                $array_pm = array('01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12');
                $array_militar = array('13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '00');
                if (strtolower(trim($pm_am)) == 'pm') {
                    $hora = str_replace($array_pm, $array_militar, $h[0]);
                    $hora_return = "$hora:$h[1]:$h[2]";
                } else {
                    $hora_return = "$h[0]:$h[1]:$h[2]";
                }
            }
        }
        return $hora_return;
    }

    public function restar_horas_mysql($hora1, $hora2) {
        $h_en_array = explode(':', $hora1);
        $h_sal_array = explode(':', $hora2);
        $h_enh = $h_en_array[0] + ($h_en_array[1] / 60) + (($h_en_array[2] / 60) / 60); //convertir todo a horas 
        $h_salh = $h_sal_array[0] + ($h_sal_array[1] / 60) + (($h_sal_array[2] / 60) / 60); //convertir todo a horas
        $horas = $h_salh - $h_enh;
        return $horas;
    }

    /*
     * @author Mario Marquez.
     * @property varchar $nombre_funcion 'Formato de la opcion --modulo/controlador/funcion--'
     * @property varchar $tipo 'Nombre del permiso a solicitar'
     */

    public function get_permisos_opcion($nombre_funcion = null, $tipo = NULL, $where = null, $resp = false) {

        $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $nombre_funcion = (substr_count($nombre_funcion, '/') > 0) ? $nombre_funcion : $data['modulo'] . '/' . $data['control'] . '/' . ((trim($nombre_funcion) != '') ? $nombre_funcion : $data['funcion']);

        $id_usuario = $this->tank_auth->get_user_id();
        $id_empresa = $this->tank_auth->get_empresa_id();
        $array_permisos = array(
            'permite_ver' => 0, 
            'permite_agregar' => 0, 
            'permite_editar' => 0, 
            'permite_eliminar' => 0, 
            'sin_permisos' => 1, 
            'modulo' => $data['modulo'], 
            'control' => $data['control'], 
            'funcion' => $data['funcion']
        );
        if ($nombre_funcion) {
            /*
             * @author Mario Marquez.
             * Se modifico la consulta para ERP, se comentara esta query para otros proyectos. 
             */
            /* $query = $this->db->query("
              SELECT oxr_opcionxrol.* from usu_usuario
              JOIN uxr_usuarioxrol on uxr_id_usu=usu_id
              JOIN rol_rol on rol_id = uxr_id_rol
              JOIN oxr_opcionxrol on oxr_id_rol=rol_id
              JOIN opc_opcion on opc_id = oxr_id_opc
              where opc_funcion='$nombre_funcion' and uxr_id_usu=$id_usuario
              limit 1
              ")->row_array(); */

            $execute = $this->db->select("oxr.*, CONCAT(opc_lv0.opc_funcion,'/',opc_lv1.opc_funcion,'/',opc_lv2.opc_funcion) as funcion", FALSE)
                ->from('opc_opcion AS opc_lv2')
                ->join('opc_opcion AS opc_lv1', 'opc_lv1.opc_id = opc_lv2.opc_padre')
                ->join('opc_opcion AS opc_lv0', 'opc_lv0.opc_id = opc_lv1.opc_padre')
                ->join('oxr_opcionxrol AS oxr', 'oxr.oxr_id_opc = opc_lv2.opc_id')
                ->join('rol_rol AS rol', 'rol.rol_id = oxr.oxr_id_rol')
                ->join('uxr_usuarioxrol AS uxr', 'uxr.uxr_id_rol = rol.rol_id')
                ->join('users AS usu', 'usu.id = uxr.uxr_id_usu')
                ->where('uxr.uxr_id_usu', $id_usuario)
                ->where('oxr.oxr_id_emr', $id_empresa);
            if ($where != '') {
                $this->db->where($where);
            }

            $this->db->having('funcion', $nombre_funcion);
            $this->db->limit(1);
            $query = $execute->get()->row_array();

            if (count($query) > 0) {
                $array_permisos['permite_ver'] = $query['oxr_ver'];
                $array_permisos['permite_agregar'] = $query['oxr_insertar'];
                $array_permisos['permite_editar'] = $query['oxr_editar'];
                $array_permisos['permite_eliminar'] = $query['oxr_eliminar'];
                $array_permisos['sin_permisos'] = 0;
            }
        }

        if ($array_permisos['sin_permisos'] and $this->input->is_ajax_request() && $tipo == null) {
            if ($resp == true) {
                return 0;
                die();
            } else {
                die("<h2>Sin permisos para dicha opción:<h2> <h3>" . $nombre_funcion . "</h3>");
            }
        } elseif ($array_permisos['sin_permisos']  && $tipo == null) {
            if ($resp == true) {
                return 0;
                die();
            } else {
                redirect('inicio');
            }
        }

        // Si es una pantalla a pie, verificar los permisos
        switch ($tipo) {
            case 'editar':
                if (!$array_permisos['permite_editar'] && !$resp)
                    redirect('inicio');
                else
                    return $array_permisos['permite_editar'];
                break;
            case 'ver':
                if (!$array_permisos['permite_ver'] && !$resp)
                    redirect('inicio');
                else
                    return $array_permisos['permite_ver'];
                break;
            case 'agregar':
                if (!$array_permisos['permite_agregar'] && !$resp)
                    redirect('inicio');
                else
                    return $array_permisos['permite_agregar'];
                break;

            default:
                break;
        }



        return $array_permisos;
    }

    // End get_permisos_opcion

    function get_dropdown_empleado($tabla, $display = '', $name = '', $where = '', $selected = null, $extras = '', $primary = '', $soloOpciones = false, $retorna_array = false) {
        if (!$tabla && !is_string($tabla)) {
            return 'Error: Sin Tabla.';
        }

        //obtenemos la llave primaria
        if ($primary == '') {
            foreach ($this->db->field_data($tabla) as $field) {
                if ($field->primary_key) {
                    $primary = $field->name;
                }
            }

            if ($primary == '') {
                return "Error: $tabla no tiene LLave Primaria.";
            }
        }

        $select = "$tabla.$primary";

        //pre consulta
        if (strstr($display, '{')) {
            $display = str_replace(" ", "&nbsp;", $display);
            $select .= ", CONCAT('" . str_replace(array('{', '}'), array("',COALESCE(", ", ''),'"), str_replace("'", "\\'", $display)) . "') as valor ";
        } else if ($display == '') {
            $select .= ", $tabla.$primary as valor";
        } else {
            $select .= ", $tabla.$display as valor";
        }

        //Consulta
        $this->db->select($select, false);
        if ($where)
            $this->db->where($where);
        $this->db->order_by('valor');
        $result = $this->db->get($tabla);
        //echo $this->db->last_query(); die();
        //Clasificador
        $return = array();

        //HACER LA CONEXION SQL-SERVER
        //$this->load->model('gsatelite2');
        if ($result->num_rows() > 0) {
            $return[0] = 'Seleccione';
            foreach ($result->result() as $row) {
                $q_emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => trim($row->valor)));
                if ($q_emp) {
                    $nombre_empleado = $q_emp[0]['emp_nombre'] . " " . $q_emp[0]['emp_apellido'];
                    // $return[$row->$primary] = $row->valor ." ".$nombre_empleado;    
                    $return[$row->$primary] = $nombre_empleado;
                }
            }
        } else {
            $return[0] = 'Sin Registros';
        }

        if ($retorna_array) {
            return $return;
        }

        if ($name == '') {
            $name = $primary;
        }

        $selected = set_value($name, $selected);

        if ($soloOpciones) {
            return $this->get_dropdown_options($return, $selected);
        }
        $extras = ($extras == '') ? 'class="nostyle" style="display:inline-block; width:480px;"' : $extras;

        return form_dropdown($name, $return, $selected, $extras);
    }

    //funcion para limpiar el texto de los archivos subidos al servidor.
    function limpiar_string($string = "", $sustituto_espacio = "") {

        $string = trim($string);

        $string = str_replace(array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'), array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'), $string);

        $string = str_replace(array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'), array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'), $string);

        $string = str_replace(array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'), array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'), $string);

        $string = str_replace(array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'), array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'), $string);

        $string = str_replace(array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'), array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'), $string);

        $string = str_replace(array('ñ', 'Ñ', 'ç', 'Ç'), array('n', 'N', 'c', 'C',), $string);

        //Esta parte se encarga de eliminar cualquier caracter extraño
        $string = str_replace(
            array(
                "\\", "¨", "º", "-", "~", "*",
                "#", "@", "|", "!", "\"",
                "·", "$", "%", "&", "/",
                "(", ")", "?", "'", "¡",
                "¿", "[", "^", "`", "]",
                "+", "}", "{", "¨", "´",
                ">", "< ", ";", ",", ":",
                ".", " "
            ), "$sustituto_espacio", $string
        );


        return $string;
    }

    //René Castaneda
    public function validar_ingreso_modulo($modulo = '') {
        $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        if (trim($modulo) != '') {
            $this->db->select()
                ->from('oxr_opcionxrol')
                ->join('opc_opcion', 'opc_id = oxr_id_opc')
                ->join('uxr_usuarioxrol', 'uxr_id_rol = oxr_id_rol')
                ->where('opc_padre', 0)
                ->where('uxr_id_usu', $this->tank_auth->get_user_id())
                ->where('opc_funcion', $modulo);
            $result = $this->db->get()->result_array();
            if (count($result) <= 0) {
                $this->show_dialog('Petición no valida', 'inicio/index', 'error', 'Acceso no permitido');
            }
        }
    }

    /*
     * Gsatelite::get_cuenta_contable()
     * @author: Mario Marquez
     * @method: Obtener un tipo de cuenta contable
     */

    public function get_cuenta_contable($tabla = null, $tipo_cuenta = null, $where = null) {
        $cuenta_defecto = $this->get_parametro('SYS_CUENTA_DEFECTO');
        $cuenta = null;
        if ($tabla == null || $tipo_cuenta == null) {
            $registro = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $cuenta_defecto));
            $cuenta = $registro[0];
        } else {

            $tipo_cnt = $this->get_parametro('SYS_TIPO_CUENTAS', null, null, array($tipo_cuenta));

            $tabla_explode = explode('_', $tabla);

            $campo = $tabla_explode[0] . '_id_cnt';

            $where[$tabla_explode[0] . '_id_tcn'] = $tipo_cnt;
            $this->db->group_by($campo);
            $id_registro = $this->get_campo($tabla, $campo, $where);

            if ($id_registro != null) {

                $registro = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $id_registro));
                $cuenta = $registro[0];
            } else {
                $registro = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $cuenta_defecto));
                $cuenta = $registro[0];
            }
        }
        return $cuenta;
    }

    /**
     * @author René Castaneda
     * @since 16-02-2018
     * @return $data array, retorna los componentes de la url actual
     */
    public function get_valores_url() {
        $data['modulo'] =  strtolower($this->uri->segment(1));
        $data['control'] = $this->router->class;
        $data['funcion'] = strtolower($this->router->fetch_method());
        return $data;
    }

    /**
     * @author René Castaneda
     * @since 01-03-2018
     * @return $data array, retorna los componentes de la url actual
     */
    public function actualizar_empresa_id($tabla_update = "") {
        $n = 0;
        if (trim($tabla_update) != "" and substr_count($tabla_update, "_") > 0 and  $this->tank_auth->get_empresa_id() > 0) {
            $idUsu = $this->tank_auth->get_user_id();
            $idEmp = $this->tank_auth->get_empresa_id();
            if ($tabla_update == "are_area") {
                //INSERTAR TODOS AQUELLOS REGISTROS QUE NO POSEEN EMPRESA DADO QUE ES OBLIGATORIO QUE POSEEAN.                
                $this->db->query("INSERT INTO mxr_empresaxarea (mxr_id_are, mxr_id_emr, mxr_estado, mxr_usu_creacion, mxr_fecha_creacion, mxr_usu_modificacion, mxr_fecha_modificacion) 
                    SELECT are_id, $idEmp empresa, 1 estado, $idUsu usu_crea, CURRENT_TIMESTAMP() f_crea, $idUsu usu_mod, CURRENT_TIMESTAMP() f_mod  
                    FROM are_area WHERE are_id NOT IN (SELECT mxr_id_are FROM mxr_empresaxarea);");
            } else if ($tabla_update == "pto_puesto") {
                //INSERTAR TODOS AQUELLOS REGISTROS QUE NO POSEEN EMPRESA DADO QUE ES OBLIGATORIO QUE POSEEAN.                
                $this->db->query("INSERT INTO mxp_empresaxpuesto (mxp_id_pto, mxp_id_emr, mxp_estado, mxp_usu_creacion, mxp_fecha_creacion, mxp_usu_modificacion, mxp_fecha_modificacion) 
                    SELECT pto_id, $idEmp empresa, 1 estado, $idUsu usu_crea, CURRENT_TIMESTAMP() f_crea, $idUsu usu_mod, CURRENT_TIMESTAMP() f_mod  
                    FROM pto_puesto WHERE pto_id NOT IN (SELECT mxp_id_pto FROM mxp_empresaxpuesto);");
            } else {
                $prefijo = explode("_", $tabla_update);
                $campo_empresa = $prefijo[0] . "_id_emr";
                $this->db->where("$campo_empresa IS NULL", null, false);
                $this->db->update($tabla_update, array("$campo_empresa" => $this->tank_auth->get_empresa_id()));
                return $this->db->affected_rows();
            }
        }
        return $n;
    }

    /**
     * Gsatelite::get_parametro_emp() //parametro de empresa 
     * 
     * @param string $codigo
     * @param array $json
     * @author René Castaneda
     * @return mixed 
     */
    function get_parametro_emp($codigo, $defecto = null, $full = false, $json = null) {

        $tabla = 'prm_parametro_empresa';
        $where_parametro = array("prm_codigo" =>  strtoupper(trim($codigo)), "prm_id_emr" => 1);
        $query = $this->get_tabla('prm_parametro_empresa', $where_parametro);

        if (!$query)  //si no existe tomarlo de la tabla general
            return $this->get_parametro($codigo, $defecto, $full, $json);

        $retorno = null;
        if ($full) {
            $retorno = $this->get_registro($tabla, $where_parametro);

            if (count($retorno) == 0 && $defecto != null) {
                $retorno = $defecto;
            } elseif (count($retorno) == 0) {
                $retorno = array();
            }
        } else {
            $retorno = $this->get_campo($tabla, 'prm_valor', $where_parametro);
            if (is_array($json)) {

                $array_datos = array();
                $decode = json_decode($retorno, true);
                if (count($json) == 1) {
                    foreach ($json as $key => $value) {
                        $retorno = $decode[$value];
                    }
                } else if (count($json) > 0) {
                    foreach ($json as $key => $value) {
                        $array_datos[] = $decode[$value];
                    }

                    $retorno = $array_datos;
                } else {
                    $array_datos = $decode;
                }
            } else {
                if (strlen($retorno) == 0 && $defecto != null) {
                    $retorno = $defecto;
                } elseif (strlen($retorno) == 0) {
                    $retorno = '';
                }
            }
        }

        return $retorno;
    }

    /**
     * Gsatelite::get_dropdown()
     * Genera un array para utilizar con form_dropdown.
     * 
     * @author René Castaneda
     * @param string $display
     * @param string $name
     * @param string $where
     * @param string $selected Si = 0 agrega una opcion 'Seleccione'
     * @param string $extras
     * @return html
     */
    function get_dropdown_empresa($display = 'emr_nombre', $where = null, $selected = null, $name = '', $soloOpciones = true, $extras = '') {
        $tabla = "emr_empresa";
        $primary = 'emr_id';
        $empresa_id = $this->tank_auth->get_empresa_id();
        $usuario_id = $this->tank_auth->get_user_id();
        $where = ($where) ? $where : array("emr_id IN (SELECT uxe_id_emr FROM uxe_usuarioxempresa WHERE uxe_id_usu = $usuario_id)" => null);
        $selected = ($selected == null) ? array($empresa_id) : null;
        if (!$tabla && !is_string($tabla)) {
            return 'Error: Sin Tabla.';
        }

        //obtenemos la llave primaria

        $select = "$tabla.$primary";

        //pre consulta
        if (strstr($display, '{')) {
            $display = str_replace(" ", "&nbsp;", $display);
            $select .= ", CONCAT('" . str_replace(array('{', '}'), array("',COALESCE(", ", ''),'"), str_replace("'", "\\'", $display)) . "') as valor ";
        } elseif (strstr($display, '[')) {
            $select .= ", " . str_replace(array('[', ']'), array('', ''), $display) . " as valor";
        } else if ($display == '') {
            $select .= ", $tabla.$primary as valor";
        } else {
            $select .= ", $tabla.$display as valor";
        }

        //Consulta
        $this->db->select($select, false);
        if ($where)
            $this->db->where($where);
        $this->db->order_by('valor');
        $result = $this->db->get($tabla);
        //echo $this->db->last_query(); die();
        //Clasificador
        $return = array();

        if ($result->num_rows() > 0) {
            $return[0] = 'Seleccione';
            foreach ($result->result() as $row) {
                $return[$row->$primary] = $row->valor;
            }
        } else {
            $return[0] = 'Sin Registros';
        }


        if ($name == '') {
            $name = $primary;
        }

        $selected = set_value($name, $selected);

        if ($soloOpciones) {
            $select_empresa = $this->get_dropdown_options($return, $selected);
            return str_replace('<option value="0">Seleccione</option>', '', $select_empresa);
        }
        $extras = ($extras == '') ? 'class="nostyle" style="display:inline-block; width:480px;"' : $extras;

        $select_empresa =  form_dropdown($name, $return, $selected, $extras);

        return str_replace('<option value="0">Seleccione</option>', '', $select_empresa);
    }

    public function user_active_directory($user, $pass){
        $dominio = $this->get_parametro_emp('SYS_CONFIG_ACTIVE_DIRECTORY', null, false, array('DOMINIO'));
        $ip_dominio = $this->get_parametro_emp('SYS_CONFIG_ACTIVE_DIRECTORY', null, false, array('IP_DOMINIO'));
        $puerto = $this->get_parametro_emp('SYS_CONFIG_ACTIVE_DIRECTORY', null, false, array('PUERTO'));        

        $partes_dom = explode('.',$dominio);
        $dominio_usuario = strtoupper($partes_dom[0]);

        // ejemplo de autenticación
        $ldaprdn  = "{$dominio_usuario}". '\\' . $user;
        $ldappass = $pass;

        $ldapConnection = ldap_connect($ip_dominio, $puerto);

        if (@ldap_bind($ldapConnection, $ldaprdn, $ldappass)) {
            $exito = 1;
        } else {
            $exito = 0;
        }

        return $exito;
    }

public function envio_correo_v2($de = "", $nombre_envia = "", $para = [], $asunto = "ENVIO CORREO", $mensaje = "", $copias = null, $ruta_adjunto = null, $copia_oculta = false) {
    // Carga la biblioteca de PHPMailer
    $this->load->library('phpmailer_lib');
    $mail = $this->phpmailer_lib->load();

    try {
        // Configuración del servidor SMTP
        $servidor = $this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_CORREO', null, false, array('SERVIDOR'));
        $puerto = $this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_CORREO', null, false, array('PUERTO'));
        $cuenta = $this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_CORREO', null, false, array('CUENTA'));
        $clave = $this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_CORREO', null, false, array('CLAVE'));
        $tls = $this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_CORREO', null, false, array('TLS'));

        $mail->isSMTP();
        $mail->Host = (trim($servidor) != "") ? $servidor : "mail.gruposatelite.net";
        $mail->SMTPAuth = true;
        $mail->Username = (trim($cuenta) != "") ? $cuenta : "facturacion.sat@gruposatelite.net";
        $mail->Password = (trim($clave) != "") ? $clave : "Nuevo1010$";
        $mail->SMTPSecure = ($tls == 1) ? 'tls' : 'ssl'; // Determina el tipo de encriptación
        $mail->Port = ($tls == 1) ? 587 : 465; // Determina el puerto según el tipo de encriptación
        // $mail->SMTPDebug = 2;
        $mail->CharSet = 'UTF-8';


        // Configuración del remitente y destinatario
        $mail->setFrom((trim($cuenta) != "") ? $cuenta : 'facturacion.sat@gruposatelite.net', ($nombre_envia != "") ? $nombre_envia : 'noreply');

        // Agregar destinatarios
        if (count($para) > 0) {            
            foreach ($para as $correo) {
                $mail->addAddress($correo);  // Agregar cada destinatario
            }        
        }

        if ($copias) {
            if ($copia_oculta) {
                $mail->addBCC($copias);
            } else {
                $mail->addCC($copias);
            }
        }

        if ($de && $nombre_envia != 'noreply') {
            $mail->addReplyTo($de, $nombre_envia);
        }

        // Contenido del correo
        $mail->isHTML(true);
        $mail->Subject = $asunto;
        $mail->Body    = $mensaje;

        // Adjuntar archivo si se proporciona
        if ($ruta_adjunto) {
            $mail->addAttachment($ruta_adjunto);
        }

        // Enviar correo
        $mail->send();
        return 1; // Correo enviado con éxito
    } catch (Exception $e) {
        // Manejo de errores
        if (ENVIRONMENT == "development") {
            echo "Error al enviar el correo: {$mail->ErrorInfo}";
        }
        return 0; // Correo no enviado
    }
} 

    /**
     * @author: René Castaneda
     * @since: 16-01-2019
     * @return: ids_cuentas hijas
     */
    public function get_ids_cuentas_hijas($id_padre=null, $where=null)
    {
        $cadena_ids = "";
             if ($where) 
             {
                $this->db->where($where);
             }
        $q = $this->gsatelite->get_tabla('cla_clasificacion_encuesta', array('cla_estado' => 1, 'cla_id_padre' => $id_padre));
        if ($q) 
        {
            foreach ($q as $fila) 
            {
                $cadena_ids .= $fila['cla_id']. ',';
                $cadena_ids .= $this->get_ids_cuentas_hijas($fila['cla_id'],$where);
            }
        }
        return $cadena_ids;
    } 
}

// End gsatelite
