<?php

/**
 * @author Mario Marquez  
 * @method Modelo - Modulo Avisos
 */
Class Gestion_documental_Model extends CI_Model {

    function __construct() {
        parent::__construct();
    }


public function get_filtered_data_archive($sSearch, $iDisplayStart, $iDisplayLength, $order_column, $order_dir, $where, $where_metadata) {
    $this->db->select("
        arh_id as archivo_id,
        arh_archivo.*,
        uba_ubicacion_archivo.*, 
        IFNULL(GROUP_CONCAT(DISTINCT cxh_id_cag),0) as ids_categoria,
        (
            SELECT GROUP_CONCAT(DISTINCT CONCAT('<b class=txt_bd>', mga_nombre_campo, '</b>', ': ', 
                        '<span class=txt_bd>', mga_valor, '</span>') 
                        ORDER BY mga_nombre_campo ASC SEPARATOR '</br>')
            FROM mga_metadata_gestor_archivos
            WHERE mga_id_arh = arh_archivo.arh_id
        ) AS mga_campo,
        (
            SELECT GROUP_CONCAT(DISTINCT cag_categoria_gestion.cag_nombre ORDER BY cag_categoria_gestion.cag_nombre ASC SEPARATOR ', ')
            FROM cxh_categoriaxarchivo
            LEFT JOIN cag_categoria_gestion ON cag_id = cxh_id_cag
            WHERE cxh_id_arh = arh_archivo.arh_id
        ) AS categorias
    ", false)
    ->from('arh_archivo')
    ->join('tpa_tipo_archivo', 'tpa_id = arh_id_tpa', 'left')
    ->join('uba_ubicacion_archivo', 'uba_id = arh_id_uba', 'left')
    ->join('users', 'id = arh_id_usu')
    ->join('emp_empleado', 'usu_id_emp = emp_id', 'left')
    ->join('cxh_categoriaxarchivo', 'cxh_id_arh = arh_id', 'left')
    ->join('cag_categoria_gestion', 'cag_id = cxh_id_cag', 'left')
    ->join('exh_etiquetaxarchivo', 'exh_id_arh = arh_id', 'left')
    ->join('eqa_etiqueta_archivo', 'eqa_id = exh_id_eqa', 'left')
    ->join('mga_metadata_gestor_archivos', 'mga_id_arh = arh_id', 'left')
    ->group_by("arh_archivo.arh_id");

    if ($where != null) {
        $this->db->where($where);
    }

    if (!empty($where_metadata)) {
        $sql_conditions = [];
        foreach ($where_metadata as $campo => $valor) {
            if (is_array($valor)) {
                if (isset($valor['desde']) && isset($valor['hasta'])) {
                    $sql_conditions[] = "(mga_metadata_gestor_archivos.mga_campo = " . $this->db->escape($campo) . 
                                        " AND CAST(mga_metadata_gestor_archivos.mga_valor AS DATE) BETWEEN " . 
                                        $this->db->escape($valor['desde']) . " AND " . $this->db->escape($valor['hasta']) . ")";
                } elseif (isset($valor['desde'])) {
                    $sql_conditions[] = "(mga_metadata_gestor_archivos.mga_campo = " . $this->db->escape($campo) . 
                                        " AND CAST(mga_metadata_gestor_archivos.mga_valor AS DATE) >= " . 
                                        $this->db->escape($valor['desde']) . ")";
                } elseif (isset($valor['hasta'])) {
                    $sql_conditions[] = "(mga_metadata_gestor_archivos.mga_campo = " . $this->db->escape($campo) . 
                                        " AND CAST(mga_metadata_gestor_archivos.mga_valor AS DATE) <= " . 
                                        $this->db->escape($valor['hasta']) . ")";
                }
            } else {
                $sql_conditions[] = "(mga_metadata_gestor_archivos.mga_campo = " . $this->db->escape($campo) . 
                                    " AND mga_metadata_gestor_archivos.mga_valor = " . $this->db->escape($valor) . ")";
            }
        }

        if (!empty($sql_conditions)) {
            $this->db->where("(" . implode(" OR ", $sql_conditions) . ")", null, false);
            $this->db->having("COUNT(DISTINCT mga_metadata_gestor_archivos.mga_campo) = " . count($where_metadata));
        }
    }

    if (!empty($sSearch)) {
        $this->db->where("(arh_nombre LIKE '%" . $this->db->escape_like_str($sSearch) . "%' 
                          OR arh_keywords LIKE '%" . $this->db->escape_like_str($sSearch) . "%')", null, false);
    }

    $this->db->order_by($order_column, $order_dir);

    if (!is_null($iDisplayStart) && !is_null($iDisplayLength)) {
        $this->db->limit($iDisplayLength, $iDisplayStart);
    }

    return $this->db->get()->result_array();
}




public function get_total_records_archive($where = null, $where_metadata = null) {
    $this->db->select("COUNT(DISTINCT arh_archivo.arh_id) as total", false)
             ->from('arh_archivo')
             ->join('tpa_tipo_archivo', 'tpa_id = arh_id_tpa', 'left')
             ->join('uba_ubicacion_archivo', 'uba_id = arh_id_uba', 'left')
             ->join('users', 'id = arh_id_usu', 'left')
             ->join('emp_empleado', 'usu_id_emp = emp_id', 'left')
             ->join('cxh_categoriaxarchivo', 'cxh_id_arh = arh_id', 'left')
             ->join('cag_categoria_gestion', 'cag_id = cxh_id_cag', 'left')
             ->join('exh_etiquetaxarchivo', 'exh_id_arh = arh_id', 'left')
             ->join('eqa_etiqueta_archivo', 'eqa_id = exh_id_eqa', 'left')
             ->join('mga_metadata_gestor_archivos', 'mga_id_arh = arh_id', 'left');

       if ($where != null) {
            $this->db->where($where);
        }

    if (!empty($where_metadata)) {
        foreach ($where_metadata as $campo => $valor) {
            if (is_array($valor)) {
                if (isset($valor['desde']) && isset($valor['hasta'])) {
                    $this->db->where("mga_metadata_gestor_archivos.mga_campo", $campo);
                    $this->db->where("CAST(mga_metadata_gestor_archivos.mga_valor AS DATE) BETWEEN '{$valor['desde']}' AND '{$valor['hasta']}'", null, false);
                } elseif (isset($valor['desde'])) {
                    $this->db->where("mga_metadata_gestor_archivos.mga_campo", $campo);
                    $this->db->where("CAST(mga_metadata_gestor_archivos.mga_valor AS DATE) >=", $valor['desde']);
                } elseif (isset($valor['hasta'])) {
                    $this->db->where("mga_metadata_gestor_archivos.mga_campo", $campo);
                    $this->db->where("CAST(mga_metadata_gestor_archivos.mga_valor AS DATE) <=", $valor['hasta']);
                }
            } else {
                $this->db->where("mga_metadata_gestor_archivos.mga_campo", $campo);
                $this->db->where("mga_metadata_gestor_archivos.mga_valor", $valor);
            }
        }
    }

    $query = $this->db->get();
    return $query->row()->total;
}


public function get_filtered_count_archive($sSearch, $where, $where_metadata) {
    $this->db->select("
        arh_archivo.*, 
        IFNULL(GROUP_CONCAT(DISTINCT cxh_id_cag),0) as ids_categoria,
        GROUP_CONCAT(DISTINCT CONCAT('<b class=txt_bd>', mga_metadata_gestor_archivos.mga_nombre_campo, '</b>', ': ', 
                     '<span class=txt_bd>', mga_metadata_gestor_archivos.mga_valor, '</span>') 
                     ORDER BY mga_metadata_gestor_archivos.mga_nombre_campo ASC SEPARATOR '</br>') AS mga_campo
    ", false)
    ->from('arh_archivo')
    ->join('tpa_tipo_archivo', 'tpa_id = arh_id_tpa', 'left')
    ->join('uba_ubicacion_archivo', 'uba_id = arh_id_uba', 'left')
    ->join('users', 'id = arh_id_usu')
    ->join('emp_empleado', 'usu_id_emp = emp_id', 'left')
    ->join('cxh_categoriaxarchivo', 'cxh_id_arh = arh_id', 'left')
    ->join('cag_categoria_gestion', 'cag_id = cxh_id_cag', 'left')
    ->join('exh_etiquetaxarchivo', 'exh_id_arh = arh_id', 'left')
    ->join('eqa_etiqueta_archivo', 'eqa_id = exh_id_eqa', 'left')
    ->join('mga_metadata_gestor_archivos', 'mga_id_arh = arh_id', 'left')
    ->group_by("arh_archivo.arh_id");

    if ($where != null) {
        $this->db->where($where);
    }

    if (!empty($where_metadata)) {
        $sql_conditions = [];
        foreach ($where_metadata as $campo => $valor) {
            if (is_array($valor)) {
                if (isset($valor['desde']) && isset($valor['hasta'])) {
                    $sql_conditions[] = "(mga_metadata_gestor_archivos.mga_campo = " . $this->db->escape($campo) . 
                                        " AND CAST(mga_metadata_gestor_archivos.mga_valor AS DATE) BETWEEN " . 
                                        $this->db->escape($valor['desde']) . " AND " . $this->db->escape($valor['hasta']) . ")";
                } elseif (isset($valor['desde'])) {
                    $sql_conditions[] = "(mga_metadata_gestor_archivos.mga_campo = " . $this->db->escape($campo) . 
                                        " AND CAST(mga_metadata_gestor_archivos.mga_valor AS DATE) >= " . 
                                        $this->db->escape($valor['desde']) . ")";
                } elseif (isset($valor['hasta'])) {
                    $sql_conditions[] = "(mga_metadata_gestor_archivos.mga_campo = " . $this->db->escape($campo) . 
                                        " AND CAST(mga_metadata_gestor_archivos.mga_valor AS DATE) <= " . 
                                        $this->db->escape($valor['hasta']) . ")";
                }
            } else {
                $sql_conditions[] = "(mga_metadata_gestor_archivos.mga_campo = " . $this->db->escape($campo) . 
                                    " AND mga_metadata_gestor_archivos.mga_valor = " . $this->db->escape($valor) . ")";
            }
        }

        if (!empty($sql_conditions)) {
            $this->db->where("(" . implode(" OR ", $sql_conditions) . ")", null, false);
            $this->db->having("COUNT(DISTINCT mga_metadata_gestor_archivos.mga_campo) = " . count($where_metadata));
        }
    }

    if (!empty($sSearch)) {
        $this->db->where("(arh_nombre LIKE '%" . $this->db->escape_like_str($sSearch) . "%' 
                          OR arh_keywords LIKE '%" . $this->db->escape_like_str($sSearch) . "%')", null, false);
    }

    return $this->db->get()->num_rows();
}


public function get_archivos($where = null, $where_metadata = null) {
    $this->db->select("arh_archivo.*, IFNULL(GROUP_CONCAT(DISTINCT cxh_id_cag),0) as ids_categoria", false)
             ->from('arh_archivo')
             ->join('tpa_tipo_archivo', 'tpa_id = arh_id_tpa', 'left')
             ->join('uba_ubicacion_archivo', 'uba_id = arh_id_uba')
             ->join('users', 'id = arh_id_usu')
             ->join('emp_empleado', 'usu_id_emp = emp_id', 'left')
             ->join('cxh_categoriaxarchivo', 'cxh_id_arh = arh_id', 'left')
             ->join('cag_categoria_gestion', 'cag_id = cxh_id_cag', 'left')
             ->join('exh_etiquetaxarchivo', 'exh_id_arh = arh_id', 'left')
             ->join('eqa_etiqueta_archivo', 'eqa_id = exh_id_eqa', 'left')
             ->join('mga_metadata_gestor_archivos', 'mga_id_arh = arh_id', 'left') 
             ->group_by("arh_id");

    if (!empty($where)) {
        $this->db->where($where);
    }

    if (!empty($where_metadata)) {
        $sql_conditions = [];
        foreach ($where_metadata as $campo => $valor) {
            if (is_array($valor) && isset($valor['desde']) && isset($valor['hasta'])) {
                $sql_conditions[] = "(mga_metadata_gestor_archivos.mga_campo = " . $this->db->escape($campo) . 
                                    " AND (STR_TO_DATE(mga_metadata_gestor_archivos.mga_valor, '%d/%m/%Y %h:%i:%s %p') BETWEEN " . 
                                    $this->db->escape($valor['desde']) . " AND " . $this->db->escape($valor['hasta']) . 
                                    " OR STR_TO_DATE(mga_metadata_gestor_archivos.mga_valor, '%Y-%m-%d') BETWEEN " . 
                                    $this->db->escape($valor['desde']) . " AND " . $this->db->escape($valor['hasta']) . "))";
            } elseif (is_array($valor) && isset($valor['desde'])) {
                $sql_conditions[] = "(mga_metadata_gestor_archivos.mga_campo = " . $this->db->escape($campo) . 
                                    " AND (STR_TO_DATE(mga_metadata_gestor_archivos.mga_valor, '%d/%m/%Y %h:%i:%s %p') >= " . 
                                    $this->db->escape($valor['desde']) . 
                                    " OR STR_TO_DATE(mga_metadata_gestor_archivos.mga_valor, '%Y-%m-%d') >= " . 
                                    $this->db->escape($valor['desde']) . "))";
            } elseif (is_array($valor) && isset($valor['hasta'])) {
                $sql_conditions[] = "(mga_metadata_gestor_archivos.mga_campo = " . $this->db->escape($campo) . 
                                    " AND (STR_TO_DATE(mga_metadata_gestor_archivos.mga_valor, '%d/%m/%Y %h:%i:%s %p') <= " . 
                                    $this->db->escape($valor['hasta']) . 
                                    " OR STR_TO_DATE(mga_metadata_gestor_archivos.mga_valor, '%Y-%m-%d') <= " . 
                                    $this->db->escape($valor['hasta']) . "))";
            } else {
                $sql_conditions[] = "(mga_metadata_gestor_archivos.mga_campo = " . $this->db->escape($campo) . 
                                    " AND mga_metadata_gestor_archivos.mga_valor = " . $this->db->escape($valor) . ")";
            }
        }

        if (!empty($sql_conditions)) {
            $this->db->where("(" . implode(" OR ", $sql_conditions) . ")", null, false);
            
            $this->db->having("COUNT(DISTINCT mga_metadata_gestor_archivos.mga_campo) = " . count($where_metadata));
        }
    }

    return $this->db->get()->result_array();
}


    /**
     * @author Mario Marquez
     * @since 2018-07-16
     * @return Obtener información del usuario
     */
    public function get_info_usuario($where = null) {
        $q = $this->db->select()
                ->from('users')
                ->join('emp_empleado', 'usu_id_emp=emp_id')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $q->get()->result_array();
    }

    public function get_bitacora_archivo($where = null) {
        $query = $this->db->select()
                ->from('bta_bitacora_archivo')
                ->join('users', 'id = bta_id_usu')
                ->join('emp_empleado', 'usu_id_emp = emp_id', 'left');
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_permisos_categoria($where = null) {
        $query = $this->db->select()
                ->from('pmg_permiso_categoria')
                ->join('users', 'id = pmg_id_usu', 'left')
                ->join('rol_rol', 'rol_id = pmg_id_rol', 'left')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

     /**
     * @author René Castaneda
     * @since 2018-08-21
     * @return Obtener los permisos sobre la gestión de archivos.
     */

     public function get_permisos_gestion($where=null,$permiso_especifico=null)
     {

        $array_permisos = array(
            'usuario' =>  $this->tank_auth->get_user_id()
            , 'categoria_gestion' => ""
            , 'rol_usuario' => ""
            , 'insertar' => 0
            , 'escritura' => 0
            , 'actualizar' => 0
            , 'descargar' => 0
            , 'deshabilitar' => 0
            , 'comentario' => 0
            , 'enviar_vinculo' => 0
            , 'enviar_carpeta' => 0
        );

         $query = $this->db->select("
            uxr_id_usu usuario,
            GROUP_CONCAT(cag_nombre) categoria_gestion,
            GROUP_CONCAT(rol_nombre) rol_usuario,
            IF((SUM(pmg_insertar) > 0),1,0) insertar,
            IF((SUM(pmg_escritura) > 0),1,0) escritura,
            IF((SUM(pmg_actualizar) > 0),1,0) actualizar,
            IF((SUM(pmg_descarga) > 0),1,0) descargar,
            IF((SUM(pmg_deshabilitar) > 0),1,0) deshabilitar,
            IF((SUM(pmg_comentario) > 0),1,0) comentario,
            IF((SUM(pmg_enviar_vinculo) > 0),1,0) enviar_vinculo,
            IF((SUM(pmg_enviar_carpeta) > 0),1,0) enviar_carpeta
            ",false)
                 ->from('pmg_permiso_categoria')
                 ->join('cag_categoria_gestion', 'cag_id = pmg_id_cag')
                 ->join('uxr_usuarioxrol', 'uxr_id_usu = pmg_id_usu OR uxr_id_rol = pmg_id_rol')
                 ->join('rol_rol', 'rol_id = uxr_id_rol')
         ;
         if ($where) {
             $this->db->where($where);
         }
         $resulados = $query->get()->result_array();
         if ($permiso_especifico) {
             # code...
         }
         if (count($resulados) > 0 ) {
            $array_permisos = $resulados[0];
         }
         
         if ($permiso_especifico) {
             $array_permisos = (isset($array_permisos[$permiso_especifico]))? $array_permisos[$permiso_especifico]:0;
         }

         return $array_permisos;
     }



     public function obtener_filtro_metadata_gestor_archivos() {
        $this->db->select("*");
        $this->db->from("mga_metadata_gestor_archivos");
        $this->db->where("mga_estado", 1);
        $this->db->group_by("mga_campo"); 
        $query = $this->db->get();
        return $query->result_array();
    }


    public function get_full_hierarchy() {
        $this->db->select('uba_id, uba_nombre, uba_id_padre');
        $query = $this->db->get('uba_ubicacion_archivo');

        $result = array();
        foreach ($query->result_array() as $row) {
            $full_path = $this->get_hierarchy_path($row['uba_id']);
            $result[] = array(
                'uba_id' => $row['uba_id'],
                'full_path' => $full_path
            );
        }

        return $result;
    }


    private function get_hierarchy_path($id) {
        $path = array();

        while ($id !== NULL) {

            $this->db->select('uba_nombre, uba_id_padre');
            $this->db->where('uba_id', $id);
            $query = $this->db->get('uba_ubicacion_archivo');

            if ($query->num_rows() > 0) {
                $row = $query->row_array();
                $path[] = $row['uba_nombre'];
                $id = $row['uba_id_padre'];
            } else {
                break; 
            }
        }

        return implode(" \\ ", array_reverse($path));
    }


}
