<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Facturacion_model extends CI_Model {

    function __construct() {
        $this->load->database();
    }

    public function get_registro($tabla, $where, $id) {

        $this->db->select()
                ->from($tabla)
                ->where($where, $id);

        $query = $this->db->get();
        return $query->row();
    }

    //obtener la fila del ultimo seguimiento de una cotización
    //para obtener la fila
    /*
      public function get_ultimo_seguimiento($id_cotizacion)
      {

      $query ="";


      $consulta = $this->db->query($query);
      $fila = $consulta->row();

      return @$fila;


      }
     */


    /**
     *@author Nelson Soriano
     *@since  18-01-2019
     *@param  where con parametros de busqueda
     *@return data_array
    **/

    public function obtener_facturas_anuladas($where = null){
      $this->db->select('*')
                 ->from('fac_factura')
                 ->join('tif_tipo_factura', 'tif_id = fac_id_tif','left')
                 ->join('cof_correlativo_factura','cof_id = fac_id_cof','inner')
                 ->join('sef_serie_factura', 'sef_id = cof_id_sef','inner')
                 ->join('suc_sucursal', 'fac_id_suc = suc_id', 'left')
                 ->join('cli_cliente' ,'fac_id_cli = cli_id', 'inner');

        if ($where) {
            $this->db->where($where);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    public function existeRegistroEtapa($tabla, $id1, $Valorid1, $id2, $Valorid2, $tipo = 0, $idActual = 0) {
        //tipo = 0 insert
        //tipo = 1 update
        //idActual cuando es actualizacion

        if ($tipo == 0 and $idEtapaActual == 0) {
            $this->db->select('*')
                    ->from($tabla)
                    ->where($id1, $Valorid1)
                    ->where($id2, $Valorid2);

            $nregistros = $this->db->count_all_results();
        } else {
            $this->db->select('*')
                    ->from($tabla)
                    ->where($id1, $Valorid1)
                    ->where($id2, $Valorid2)
                    ->where("$id1 !=", $idActual)
            ;

            $nregistros = $this->db->count_all_results();
        }
        return $nregistros; //devolver el numero de filas afectadas por la consulta
    }

    //funcion aplicada para validar que el nombre no se repita
    public function existeNombre($tabla, $campoNombre, $valorNombre, $tipo = 0, $nombreActual = 0) {
        //tipo = 0 insert
        //tipo = 1 update

        if ($tipo == 0 and $idEtapaActual == 0) {
            $this->db->select('*')
                    ->from($tabla)
                    ->where($campoNombre, $valorNombre);

            $nregistros = $this->db->count_all_results();
        } else {
            $this->db->select('*')
                    ->from($tabla)
                    ->where($campoNombre, $valorNombre)
                    ->where("$campoNombre !=", $nombreActual)
            ;

            $nregistros = $this->db->count_all_results();
        }
        return $nregistros; //devolver el numero de filas afectadas por la consulta
    }

    function get_tipo_proceso($tabla, $where = null) {

        $this->db->select('tip_entrada')
                ->where($where)
                ->from($tabla)
                ->join('moi_movimiento_inv', 'dee_id_moi=moi_id')
                ->join('tip_tipo_proceso', 'moi_id_tip=tip_id')
                ->limit(1);

        $query = $this->db->get()->result_array();
        return count($query);
    }

    function get_articulos($tabla, $where) {
        $this->db->select_sum('sar_cant_actual')
                ->where($where)
                ->from('sar_saldo_articulo');

        $query = $this->db->get()->row();
        return $query->sar_cant_actual;
    }

    public function get_tabla($nombretabla, $Campowhere = "", $Valorcampo = "", $campo_orden = "", $tipoorden = "") {
        //Obtiene todos los campos de una tabla (se puede utilizar WHERE opcionalmente)

        $this->db->select();

        if ($Campowhere != "" and $Valorcampo != "") {
            $this->db->where($Campowhere, $Valorcampo);
        }
        if ($campo_orden != "" and $tipoorden != "") {
            $this->db->order_by($campo_orden, $tipoorden);
        }

        $this->db->from($nombretabla);
        $query = $this->db->get();

        return $query;
    }

    //a diferencia a la anterior este recibe un array asociativo cuando las condicionantes pueden ser varias
    public function get_tabla2($nombretabla, $arrayWhere, $campo_orden = "", $tipoorden = "") {
        //Obtiene todos los campos de una tabla (se puede utilizar WHERE en array asociativo)

        $this->db->select();

        if (count($arrayWhere) > 0) {
            $this->db->where($arrayWhere);
        }
        if ($campo_orden != "" and $tipoorden != "") {
            $this->db->order_by($campo_orden, $tipoorden);
        }

        $this->db->from($nombretabla);
        $query = $this->db->get();

        return $query;
    }

    public function get_cotizaciones_ganadas($cliente) {
        $this->db->select('*, (SELECT SUM(IFNULL(axc_cantidad_pendiente, axc_cantidad)) FROM axc_articuloxcotizacion WHERE axc_id_cot = cot_id) AS pdte_fac', false)
                ->from('cog_cotiz_ganada')
                ->join('cot_cotizacion', 'cot_id = cog_id_cot', 'inner')
                ->join('ord_orden', 'ord_id_cot = cot_id', 'left')
                ->where('cot_id_cli', $cliente)
                ->where('cot_estado', 1)
        ;
        return $this->db->get()->result_array();
    }

    public function get_cotizaciones($where = null) {
        $this->db->select('*, (SELECT SUM(IFNULL(axc_cantidad_pendiente, axc_cantidad)) FROM axc_articuloxcotizacion WHERE axc_id_cot = cot_id) AS pdte_fac', false)
                ->from('cog_cotiz_ganada')
                ->join('cot_cotizacion', 'cot_id = cog_id_cot', 'inner')
                ->join('ord_orden', 'ord_id_cot = cot_id', 'left')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function articulos_cotizacion($id_cot) {
        $this->db->select()
                ->from('axc_articuloxcotizacion')
                ->join('art_articulo', 'art_id = axc_id_art', 'inner')
                ->where('axc_id_cot', $id_cot)
        ;

        return $this->db->get()->result_array();
    }

    public function get_correlativo($inicio, $fin, $id_serie, $masivo = null, $id_cor = null) {
        $this->db->select('cof_inicio, cof_actual')
                ->from('cof_correlativo_factura')
                ->where('cof_id_sef', $id_serie)
                ->where('cof_inicio >=' . $inicio)
                ->where('cof_inicio <=' . $fin);
        if ($masivo != null) {
            $this->db->where('cof_masivo', $masivo);
        }
        if ($id_cor != null) {
            $this->db->where('cof_id', $id_cor);
        }
        $this->db->order_by('cof_inicio', 'DESC')
                ->limit(1)
        ;

        $result = $this->db->get()->result_array();
        //die(print_r($result));
        return $result;
    }

//para la enumeracion de los registros
    public function posicion_registro($nombre_tabla, $campoIdfila, $idValorfila, $condicional = "", $valorCondicional = 0) {

        $nposicion = "-";

        if ($condicional != "" and $valorCondicional != 0) {

            $this->db->select("*")
                    ->from($nombre_tabla)
                    ->where($condicional, $valorCondicional)
                    ->where("$campoIdfila <= ", $idValorfila)
            ;

            $nposicion = $this->db->count_all_results();
        } else {

            $this->db->select("*")
                    ->from($nombre_tabla)
                    ->where("$campoIdfila <= ", $idValorfila)
            ;
            $nposicion = $this->db->count_all_results();
        }


        return $nposicion;
    }

    /*
      FUNCION PARA ACTUALIZAR UN DATOS DE UN REGISTRO EN UNA TABLA
     */

    public function actualizarCampo($tabla, $campoIdTabla, $valorIdTabla, $campoActualizar, $valorActualizar) {


        $data = array(
            $campoActualizar => $valorActualizar
        );

        $this->db->where($campoIdTabla, $valorIdTabla);
        if ($this->db->update($tabla, $data)) {
            return true;
        } else {
            return false;
        }
    }

//FUNCION PARA PREGUNTAR SI UN REGISTRO EXISTE
//public function existe_cotizacion_GP($tabla,$DatosarregloAsociativo,$campoCondicion="",$valorCondicion="") {
    public function Existe_Registro($tabla, $DatosarregloWhere) {

        $this->db->select("*")
                ->from($tabla)
                ->where($DatosarregloWhere)
        ;
        $nreg = $this->db->count_all_results();
        return $nreg;
    }

//FUNCION QUE ME DEVOLVERÁ LOS IDs DE LOS VENDEDORES QUE PERTENECEN A UN SUPERVISOR (vendedor o supervisor son un usuario)
    public function get_idsVendedoresxSupervisor($id_usuario) {

        $this->db->select('GROUP_CONCAT(vxs_id_ven) AS vendedores_ids')
                ->FROM('vxs_vendedorxsupervisor')
                ->join('sup_supervisor', 'vxs_vendedorxsupervisor.vxs_id_sup = sup_supervisor.sup_id')
                ->where('sup_id_usu', $id_usuario)
                ->where('sup_estado', 1);

        $query = $this->db->get()->row_array();
        $ids = $query['vendedores_ids'];
        if (strlen($ids) > 0) {
            $ids = $ids;
        } else {
            $ids = "0";
        }
        return $ids;
    }

    /**
     * @author René Castaneda.
     * @param string $criterio criterio de búsqueda para el like
     * @description Esta función es llamada en un evento ajax que utiliza un select2 en el keyup
     *              para buscar a los productos(que estan en la base de datos)
     *              que coincidan con el nombre o codigo.
     */
    public function get_productosLike($criterio = "") {
        $criterio = trim($criterio);
        $this->db->select("art_id,
      art_nombre,
      art_codigo,
      art_estado")
                ->from('art_articulo')
                ->where("art_estado", 1)
                ->where("art_venta", 1)
                ->like("TRIM(art_nombre)", trim($criterio))
                ->or_like("TRIM(art_codigo)", trim($criterio))
                ->limit(20);
        return $this->db->get()->result_array();
    }

    /**
     * @author René Castaneda.
     * @param int $id_fac id de la factura
     * @return la informacion del registro de la factura
     */
    public function get_facturas($where = null) {

        $this->db->select("*")
                ->from('fac_factura')
                ->join('cli_cliente', 'cli_cliente.cli_id = fac_factura.fac_id_cli', 'left')
                ->join('tpg_tipo_pago', 'tpg_tipo_pago.tpg_id = fac_id_tpg', 'left')
                ->join('tif_tipo_factura', 'tif_id = fac_id_tif', 'left')
                ->join('ven_vendedor', 'ven_vendedor.ven_id = fac_factura.fac_id_ven', 'left')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_orden_entrega($where = null) {
        $this->db->select("*, IFNULL((SELECT GROUP_CONCAT(DISTINCT seb_nombre SEPARATOR ', ') FROM dee_detalle_mov JOIN moi_movimiento_inv ON moi_id = dee_id_moi 
            JOIN sar_saldo_articulo ON sar_id = dee_id_sar JOIN sxb_sectorxbodega ON sxb_id = sar_id_sxb JOIN seb_sector_bodega ON seb_id = sxb_id_seb WHERE moi_id_fac = fac_id 
            AND dee_id_art = def_id_art AND dee_id_cva = def_id_cva), '') AS seb_nombre", false)
                ->from('def_detalle_fact')
                ->join('art_articulo', 'art_id = def_id_art')
                ->join('fac_factura', 'fac_id = def_id_fac')
                ->join('cli_cliente', 'cli_id = fac_id_cli')
                ->join('tif_tipo_factura', 'tif_id = fac_id_tif')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author René Castaneda.
     * @param int $id_fac id de la factura
     * @return la informacion del registro de la factura
     */
    public function get_factura_info($id_fac) {

        $this->db->select("*")
                ->from('fac_factura')
                ->join('cli_cliente', 'cli_id = fac_id_cli')
                ->join('ven_vendedor', 'ven_id = fac_id_ven', 'left')
                ->join('tif_tipo_factura','tif_id = fac_id_tif')
                ->join('tpg_tipo_pago','tpg_id = fac_id_tpg', 'left')//
                ->join('gir_giro', 'gir_id = cli_id_gir', 'left')
                ->join('mun_municipio', 'mun_id = cli_id_mun', 'left')
                ->where("fac_id", $id_fac);
        return $this->db->get()->result_array();
    }

    public function destalles_impuestos($id_factura) {
        $this->db->select('ixf_id_def, ixf_monto, imp_id, imp_nombre, imp_porcentaje')
                ->from('ixf_impuestoxfactura')
                ->join('imp_impuesto', 'imp_id = ixf_id_imp', 'left')
                ->join('def_detalle_fact', 'def_id = ixf_id_def', 'left')
                ->where('def_id_fac', $id_factura);
        return $this->db->get()->result_array();
    }

    public function anular_factura($id_fac, $fecha, $razon, $seguimiento = null, $fac_total_pendiente = null) {
        $pendiente_anulacion = 0;
        if($seguimiento == 1){
            $pendiente_anulacion = $fac_total_pendiente;
        }

        $where_fac =  array(
                        'fac_estado'            => 0,
                        'fac_fecha_anulacion'   => date('Y-m-d H:i:s'),
                        'fac_usu_mod'           => $this->tank_auth->get_user_id(),
                        'fac_fecha_mod'         => date('Y-m-d H:i:s'),
                        'fac_motivo_anulacion'  => $razon,
                        'fac_monto_pendiente'   => 0,
                        'fac_monto_abono'       => 0,
                        'fac_total'             => 0,
                        'fac_descuento'         => 0,
                        'fac_impuesto'          => 0,
                        'fac_descuento'         => 0,
                        'fac_subtotal'          => 0,
                        'fac_total_retencion'   => 0,
                        'fac_retencion_abono'   => 0,
                        'fac_aplica_seguimiento_anulacion'   => $seguimiento,
                        'fac_monto_pendiente_anulacion'   => $pendiente_anulacion,
                        'fac_monto_abonado_anulacion'   => 0
        );
        $reg_fac = $this->gsatelite->get_tabla('fac_factura', array('fac_id'=>$id_fac));
        $reg_fac = $reg_fac[0];
        //por ser un campo nuevo validaremos si esta creado en la base de datos.
        if (count($reg_fac) > 0 && array_key_exists('fac_id_usu_anulacion',$reg_fac)) { 
            $where_fac['fac_id_usu_anulacion'] = $this->tank_auth->get_user_id();
        }

        $this->db->where('fac_id', $id_fac)->update('fac_factura',  $where_fac );

        $data = array(
                    'paf_estado'            => 0,
                    'paf_fecha_anulacion'   => $fecha,
                    'paf_motivo_anulacion'  => $razon
        );

        $this->db->where('paf_id_fac', $id_fac);
        $resultado = $this->db->update('paf_pago_factura', $data);
    }

    public function get_factura_anulacion($where = null){
        /*
            SELECT dee_cantidad, dee_precio, dee_id_art, dee_id_cva, dee_id_moi, dee_id_sxb FROM fac_factura
            INNER JOIN moi_movimiento_inv ON moi_id_fac = fac_id
            INNER JOIN dee_detalle_mov ON dee_id_moi = moi_id
            WHERE moi_id_fac = 11174
        */
        $query = $this->db->select('dee_cantidad, dee_precio, sar_precio, dee_id_art, dee_id_cva, sar_id_bod, sar_id_sxb, fac_id_tif, fac_id_cot, axc_cantidad_pendiente, axc_cantidad_facturada, axc_id')
                ->from('fac_factura')
                ->join('moi_movimiento_inv','moi_id_fac = fac_id','inner')
                ->join('dee_detalle_mov','dee_id_moi = moi_id','inner')
                ->join('sar_saldo_articulo','sar_id = dee_id_sar','inner')
                ->join('cot_cotizacion','cot_id = fac_id_cot','left')
                ->join('axc_articuloxcotizacion','axc_id_cot = cot_id AND dee_id_art = axc_id_art','left')
                //->where(array('dee_id_art = axc_id_art' => null))
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author René Castaneda.
     * @param int $id_fac id de la factura
     * @return la informacion del detalle de la factura
     */
    public function get_detalle_factura($id_fac) {
        // Obtener el detalle de las facturas por productos
        //$this->db->select("art_codigo, def_descripcion, def_cantidad, def_precio, def_impuesto, def_subtotal, tpg_nombre")
        $this->db->select("art_codigo, def_descripcion, def_cantidad, def_precio, def_impuesto, def_subtotal, def_id_lip, lip_id_tlp", false)
                ->from('def_detalle_fact')
                ->join('art_articulo', 'art_articulo.art_id = def_detalle_fact.def_id_art')
                ->join('lip_listado_precio', 'lip_id = def_detalle_fact.def_id_lip','left')
                //->join('tpg_tipo_pago','tpg_id=def_id_tpg')
                //->from('fac_factura')
                //->join('tpg_tipo_pago','fac_factura.fac_id_tpg = tpg_tipo_pago.tpg_id')
                //->join('def_detalle_fact','def_detalle_fact.def_id_fac = fac_id')
                //->join('art_articulo','art_articulo.art_id = def_id')
                ->where("def_detalle_fact.def_id_fac", $id_fac)
                ->where("def_detalle_fact.def_estado", 1);
        //return $this->db->get()->result_array();
        $query = $this->db->get()->result_array();
        //print_r($query);die();
        $query_productos = $this->db->last_query();


        // Obtener el detalle de las facturas por servicios
        //$this->db->select('src_codigo, tcs_nombre, NULL AS def_cantidad, caf_valor, caf_impuesto, caf_subtotal, NULL as tpg_nombre', false)
        /*
          $this->db->select('src_codigo, tcs_nombre, NULL AS def_cantidad, caf_valor, caf_impuesto, caf_subtotal', false)
          ->from('fxs_facturaxservicio')
          ->join('sxc_servicioxcliente',' sxc_id = fxs_id_sxc')
          ->join('src_servicio', 'src_id = sxc_id_src')
          ->join('caf_cargo_facturacion', 'caf_id_sxc = sxc_id')
          ->join('tcs_tipo_cargo_servicio', 'tcs_id = caf_id_tcs')
          ->where('src_estado',1)
          ->where('fxs_estado',1)
          ->where('sxc_estado',1)
          ->where('caf_estado',1)
          ->where('tcs_estado',1)
          ->where('fxs_id_fac', $id_fac)
          ;
          $query = $this->db->get()->result_array();
          $query_servicios = $this->db->last_query();
         */
        return $this->db->query($query_productos /* ." union ".$query_servicios */)->result_array();
    }

    public function cargar_todo($tabla, $where = null, $order = null) {
        $this->db->select();
        $this->db->from($tabla);

        if ($where != null) {
            $this->db->where($where);
        }

        if ($order != null) {
            $this->db->order_by($order);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    public function datos_principales($cliente, $no_fact) {
        $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $nt_remi = (isset($tipo_factura['NOTA REMISION'])) ? $tipo_factura['NOTA REMISION'] : 0;
        $this->db->select("f.fac_id, cli_id, cli_apellido, cli_nombre, cli_personeria, cli_codigo, tif_nombre, tpg_nombre, f.fac_numero, f.fac_fecha_fact, sef_id, 
            sef_nombre,sef_abrev, cof_inicio, cof_fin, f.fac_fecha_cont, ven_nombre, ven_apellidos, ven_codigo, f.fac_observacion, f.fac_subtotal, f.fac_descuento, 
            f.fac_observaciones_factura_electronica, f.fac_sello_recepcion, tif_id, f.fac_codigo_generacion, f.fac_numero_control,
            f.fac_impuesto, f.fac_total, orv_id, orv_numero_orden, f.fac_id_cot, tif_aplica_anulacion, IF(tif_id = $nt_remi, IFNULL( (SELECT 
            CONCAT(tif_nombre, ' ', sef_abrev, '- #', r.fac_numero) FROM fxr_factura_remisionxfactura JOIN fac_factura AS r ON r.fac_id = fxr_id_fac 
            JOIN cof_correlativo_factura ON cof_id = r.fac_id_cof JOIN sef_serie_factura ON sef_id = cof_id_sef JOIN tif_tipo_factura ON tif_id = sef_id_tif 
            WHERE fxr_id_fac_remision = f.fac_id), 'No facturada'), '') AS fac_padre_rem, IF(tif_id = $nt_remi, IFNULL((SELECT r.fac_fecha_fact 
            FROM fxr_factura_remisionxfactura JOIN fac_factura AS r ON r.fac_id = fxr_id_fac WHERE fxr_id_fac_remision = f.fac_id),''),'') AS fac_padre_fecha", false)
                ->from("fac_factura AS f")
                ->join("cof_correlativo_factura", "f.fac_id_cof = cof_id")
                //->join("sxc_servicioxcliente", "sxc_id = fxs_id_sxc", 'left')
                //->join('txs_telefonoxservicio', 'txs_id_sxc = sxc_id AND txs_principal=1', 'left')
                ->join("cli_cliente", "f.fac_id_cli = cli_id")
                ->join("tpg_tipo_pago", "f.fac_id_tpg = tpg_id", 'left')
                ->join("sef_serie_factura", "cof_id_sef = sef_id")
                ->join("tif_tipo_factura", "sef_id_tif= tif_id")
                ->join("ven_vendedor", "cli_id_ven = ven_id", 'left')
                ->join("orv_orden_venta", "orv_id_fac = f.fac_id", 'left')
                ->where("cli_id", $cliente)
                ->where("f.fac_id", $no_fact);
                //->where('txs_principal',1)
                // ->where("fac_estado = 1", null);
        $result = $this->db->get()->result_array();
        return $result;
    }

    public function factura_detalle($cliente, $no_fact) {
        $this->db->select("art_codigo, def_descripcion, def_cantidad, def_precio, def_impuesto, def_subtotal")
                ->from('fac_factura')
                ->join('def_detalle_fact', 'def_id_fac=fac_id')
                ->join('art_articulo', 'art_id = def_id_art')
                ->where("fac_id_cli", $cliente)
                ->where("fac_id", $no_fact);
                // ->where("fac_estado = 1", null);
        $result = $this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $result;
    }

    public function get_info_tpg_cli($cliente){
        $this->db->select("IFNULL(cli_id_tpg, 0) AS tipo, IFNULL(tpg_aplica_credito, -1) AS aplica", false)
            ->from("cli_cliente")
            ->join("tpg_tipo_pago", "tpg_id = cli_id_tpg", "LEFT")
            ->where("cli_id", $cliente);
        return $this->db->get()->row();
    }

    public function get_rango_corr($sef_id, $numero) {
        $query = $this->db->query("SELECT  cof_inicio, cof_fin from sef_serie_factura
              INNER JOIN cof_correlativo_factura ON sef_id = cof_id_sef
              WHERE cof_id_fac is null and sef_id=" . $sef_id . " and  cof_inicio <= 33 AND cof_fin >= 33");
        return $query->result();
    }

    public function get_doc_fact($factura = 0){
        $this->db->select("sef_nombre, CONCAT(sef_abrev, '-', fac_numero) AS factura", false)
            ->from('fac_factura')
            ->join('cof_correlativo_factura', 'cof_id = fac_id_cof')
            ->join('sef_serie_factura', 'sef_id = cof_id_sef')
            ->where('fac_id', $factura)
        ;
        $resp = $this->db->get()->row_array();
        return $resp['factura'];
    }

    /**
     * @autor:  Edith Herrera
     */
    public function impuesto_cliente($cliente = null) {
        $this->db->select()
                ->from('imp_impuesto')
                ->join('ixc_impuestoxcliente', 'imp_id = ixc_id_imp AND ixc_id_cli = ' . $cliente . '', 'left');

        $res = $this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $res;
    }

    /**
     * @autor:  Edith Herrera
     */
    public function impuesto_cotizacion($cotizacion = null, $axc = null) {

        $this->db->select('ixt_id_imp')
                ->from('axc_articuloxcotizacion')
                ->join('ixt_impuestoxcotizacion', 'axc_id=ixt_id_axc ')
                ->join('imp_impuesto', 'imp_id = ixt_id_imp')
                ->where('axc_id_cot', $cotizacion);
        if ($axc > 0) {
            $this->db->where('axc_id', $axc);
        }
        $result = $this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $result;
    }

    function facturas_cliente($id_cliente) {
        $this->db->select()
                ->from('fac_factura')
                ->where('fac_estado', 1)
                ->where('fac_id_cli', $id_cliente)
        ;

        $result = $this->db->get()->result_array();
        return $result;
    }

    public function get_cargos_fijos($where = null, $fecha_ini = null, $fecha_fin = null, $plan = null, $pxl = null, $doc = null) {

        $this->db->select('sxc_id, cli_id, src_id, src_nombre, pxl_id, pxl_fecha_inicio,
                      pxl_fecha_fin, pln_id, pln_tipo, pln_nombre, pln_costo, pln_desde, pln_hasta');
        $this->db->from('sxc_servicioxcliente')
                ->join('cli_cliente', 'cli_id= sxc_id_cli')
                ->join('src_servicio', 'sxc_id_src=src_id')
                ->join('txs_telefonoxservicio', 'txs_id_sxc=sxc_id')
                ->join('pxl_plan_promoxcliente', 'sxc_id=pxl_id_sxc')
                ->join('pln_plan_promocion', 'pxl_id_pln=pln_id')
                ->join('dcc_documento_cliente', 'dcc_id_cli=cli_id', 'left')
        ;

        if ($plan != null) {
            $this->db->join('caf_cargo_facturacion', 'caf_id_sxc=sxc_id');
            $this->db->where('caf_id_tcs', $plan);
        }

        if ($where != null) {
            $this->db->where($where);
        }
        // subquery

        $this->db->where("pxl_id in (SELECT  pxl_id FROM pxl_plan_promoxcliente
                                 WHERE (pxl_fecha_inicio BETWEEN '" . $fecha_ini . "' AND '" . $fecha_fin . "')
                                 OR (pxl_fecha_fin BETWEEN '" . $fecha_ini . "' AND '" . $fecha_fin . "')
                                 OR (date_format(pxl_fecha_inicio,'%Y-%m-%d') <=  '" . $fecha_ini . "'
                                 AND date_format(pxl_fecha_fin,'%Y-%m-%d') >=  '" . $fecha_fin . "'))", null, false);
        if ($pxl != null) {
            $this->db->group_by('pxl_id, cli_id');
            $this->db->order_by('sxc_id', 'asc');
        } else {
            $this->db->group_by('pxl_id, pln_id, cli_id');
        }

        $result = $this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $result;
    }

    public function get_cargos_consumo($date1 = null, $date2 = null, $cliente = null, $doc = null) {
        $query = "
        SELECT cdd_id, cdd_numero_origen, cdd_fecha_inicio, cdd_fecha_fin, cdr_id, cdd_costo_total,
               sxc_id, SUM(cdd_costo_total) as total,sxc_id_cli
        FROM cdr_resumen
        INNER JOIN cdd_cdr_detalle on cdr_id=cdd_id_cdr
        INNER JOIN txs_telefonoxservicio ON REPLACE(txs_numero,'-','')= cdd_numero_origen
        INNER JOIN sxc_servicioxcliente ON sxc_id= txs_id_sxc
        LEFT JOIN dcc_documento_cliente ON sxc_id_cli=dcc_id_cli
        WHERE cdd_costo_total > 0 AND cdd_fecha_inicio >= '" . $date1 . "'
        AND cdd_fecha_inicio <= '" . $date2 . "'";
        if ($cliente != null) {
            $query .= " AND sxc_id_cli = " . $cliente;
        }
        if ($doc != null) {
            $query .= " AND dcc_valor = " . $doc;
        }
        $query .= " GROUP BY sxc_id";

        $resultado = $this->db->query($query)->result_array();
        //die(print_r($this->db->last_query()));
        return $resultado;
    }

    public function get_consumos_caf($where = null) {
        $this->db->select('caf_id, caf_fecha, cli_nombre, caf_valor, sxc_id, caf_id_tcs')
                //$this->db->select('caf_id, caf_fecha, cli_nombre, sxc_numero, caf_valor, sxc_id, caf_id_tcs')
                ->from('caf_cargo_facturacion')
                ->join('sxc_servicioxcliente', 'sxc_id=caf_id_sxc')
                ->join('cli_cliente', 'cli_id= sxc_id_cli')
                ->join('dcc_documento_cliente', 'dcc_id_cli=cli_id', 'left');
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        $result = $this->db->get()->result_array();
        return $result;
    }

    public function get_detalle_totalxcliente($fecha_ini = null, $fecha_fin = null, $fijo = null, $consumo = null, $facturas = null, $bd = null, $pendientes = null, $cliente = null, $doc = null) {
        $query = "
        SELECT caf_id_sxc, caf_id, caf_id_tcs, caf_valor, caf_fecha, sxc_id,  src_nombre, cli_id, cli_nombre,
               cli_apellido, cli_id_tif, tif_nombre, tpg_id, tpg_nombre, cli_id_ven, caf_nombre,
               SUM(DISTINCT(IF(caf_id_tcs = '" . $fijo . "', caf_valor, 0))) AS fijo,
               SUM(IF(caf_id_tcs = '" . $consumo . "', caf_valor, 0)) As consumo,
               SUM(IF(caf_id_tcs != '" . $fijo . "' and caf_id_tcs != '" . $consumo . "', caf_valor, 0)) AS adicional,
               (SELECT IFNULL(SUM(imp_porcentaje),0) FROM imp_impuesto INNER JOIN ixc_impuestoxcliente
               ON ixc_id_imp = imp_id WHERE ixc_id_cli = cli_id) as impuestos,
               (SELECT CONCAT(MIN(date_format(pxl_fecha_inicio,'%Y-%m-%d')),' - ',MAX(date_format(pxl_fecha_fin,'%Y-%m-%d')))
                  FROM pxl_plan_promoxcliente WHERE pxl_id_sxc = sxc_id ) as pxl, GROUP_CONCAT(DISTINCT(sxc_id)) as servicio
            ";
        if ($bd == 1) {
            $query .= ", fxs.fxs_id, fxs.fxs_fecha_fin, cof_id, fac_id, fac_total, fac_id_cli, fac_numero,fac_estado, fac_subtotal, cxs_id, cxs_id_fxs";
        }
        $query .= " FROM caf_cargo_facturacion
        INNER JOIN sxc_servicioxcliente ON sxc_id=caf_id_sxc
        INNER JOIN cli_cliente ON cli_id= sxc_id_cli
        INNER JOIN src_servicio ON src_id=sxc_id_src
        INNER JOIN tif_tipo_factura ON cli_id_tif=tif_id
        INNER JOIN tpg_tipo_pago ON cli_id_tpg=tpg_id
        LEFT JOIN dcc_documento_cliente ON cli_id=dcc_id_cli";
        if ($bd == 1) {
            /* $query.="
              LEFT JOIN fxs_facturaxservicio ON sxc_id = fxs_id_sxc
              LEFT JOIN fac_factura ON fac_id=fxs_id_fac
              LEFT JOIN cof_correlativo_factura ON cof_id=fac_id_cof
              LEFT JOIN cxs_cargoxfacturacion_serv ON cxs_id_fxs=fxs_id"; */
            $query .= "
        LEFT JOIN
          (SELECT * FROM cxs_cargoxfacturacion_serv cs LEFT JOIN fxs_facturaxservicio fs ON fs.fxs_id= cs.cxs_id_fxs
           WHERE fs.fxs_estado=1 )
          cxs ON cxs.cxs_id_caf = caf_id
        LEFT JOIN
            (SELECT * FROM fxs_facturaxservicio facs WHERE facs.fxs_estado=1  ) fxs ON fxs.fxs_id = cxs_id_fxs
        LEFT JOIN fac_factura ON fac_id = fxs.fxs_id_fac
        LEFT JOIN cof_correlativo_factura ON cof_id = fac_id_cof";
        }

        if ($pendientes == null) {
            $query .= " WHERE date_format(caf_fecha,'%Y-%m-%d') >= '" . $fecha_ini . "'
            AND date_format(caf_fecha,'%Y-%m-%d') <= '" . $fecha_fin . "'";
        }

        if ($facturas != null) {
            $query .= " AND fac_id in (" . $facturas . ")";
        }
        if ($bd == 1) {
            //$query.="AND fac_estado IS NULL OR fac_estado = 1";
        }

        if ($pendientes == 1) {
            $query .= " WHERE date_format(fac_fecha_cont,'%Y-%m-%d') >= '" . $fecha_ini . "'
                      AND date_format(fac_fecha_cont,'%Y-%m-%d') <= '" . $fecha_fin . "'";
            $query .= " AND fac_estado = 1";
        }

        if ($cliente != null) {
            $query .= " AND cli_id = " . $cliente;
        }
        if ($doc != null) {
            $query .= " AND dcc_valor = '" . $doc . "'";
        }
        $query .= " GROUP BY sxc_id";

        if ($bd == 1) {
            $query .= " ORDER BY MAX(fac_id)";
        }

        $resultado = $this->db->query($query)->result_array();
        //  die(print_r($this->db->last_query()));
        return $resultado;
    }

    public function get_caf_filas($id_sxc = NULL, $id_tcs = NULL) {
        $this->db->select('GROUP_CONCAT(DISTINCT caf_id ORDER BY caf_id) AS caf_id', false)
                ->from('caf_cargo_facturacion')
                ->where('caf_id_tcs', $id_tcs)
                ->where('caf_id_sxc', $id_sxc)
        ;
        return $this->db->get()->row();
    }

    public function get_detalle_total_bd($where = null) {
        $this->db->select('caf_id_sxc, caf_id, caf_id_tcs, caf_valor, caf_fecha,sxc_id, fxs_id, src_nombre,
                        cli_id, cli_nombre, cli_id_tif, tif_nombre, tpg_id, tpg_nombre, cof_id, cof_masivo,
                        fac_id, fac_total, fac_numero,fac_impuesto, fac_id_cof, cxs_id_fxs, cxs_id, fac_fecha_fact,
                        fac_fecha_cont,tif_nombre, tif_id, tpg_id, tpg_nombre,fac_estado')
                ->from('caf_cargo_facturacion')
                ->join('sxc_servicioxcliente', 'sxc_id=caf_id_sxc')
                ->join('cli_cliente', 'cli_id= sxc_id_cli')
                ->join('src_servicio', 'src_id=sxc_id_src')
                ->join('fxs_facturaxservicio', 'sxc_id=fxs_id_sxc')
                ->join('fac_factura', 'fac_id=fxs_id_fac')
                ->join('cof_correlativo_factura', 'cof_id=fac_id_cof')
                ->join('tif_tipo_factura', 'cli_id_tif=tif_id')
                ->join('tpg_tipo_pago', 'cli_id_tpg=tpg_id')
                ->join('cxs_cargoxfacturacion_serv', 'cxs_id_fxs=fxs_id', 'inner')
                ->join('dcc_documento_cliente', 'cli_id=dcc_id_cli', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        //$this->db->where("fac_id NOT IN (SELECT fxp_id_fac FROM fxp_facturaxplan_pago)");
        //$this->db->where('fac_estado',1);
        $this->db->group_by('sxc_id');
        $this->db->group_by('fac_id');
        $this->db->order_by('fac_id', 'desc');
        $result = $this->db->get()->result_array();
        return $result;
    }

    function numeros_cliente() {
        $this->db->select('cli_id, sxc_id, txs_id, cli_nombre, txs_numero')
                ->from('cli_cliente')
                ->join('sxc_servicioxcliente', 'cli_id=sxc_id_cli')
                ->join('txs_telefonoxservicio', 'txs_id_sxc=sxc_id')
                ->where('cli_estado', 1)
                ->where('txs_principal', 1)
        ;

        $result = $this->db->get()->result_array();
        return $result;
    }

    function get_cargos_cliente($where = null, $adicional = null) {
        $this->db->select('fac_id, fac_numero, fac_fecha_fact, fac_fecha_cont
                  , SUM(caf_subtotal) as subtotal
                  , caf_impuesto
                  , COUNT(caf_id) as cantidad
                  , caf_id, caf_fecha, caf_valor, caf_id_sxc
      ')
                ->from('caf_cargo_facturacion')
                ->join('cxs_cargoxfacturacion_serv', 'caf_id=cxs_id_caf')
                ->join('fxs_facturaxservicio', 'cxs_id_fxs=fxs_id')
                ->join('fac_factura', 'fac_id=fxs_id_fac');

        //->join('caf_cargo_facturacion','caf_id_sxc = sxc_id')
        //->join('tcs_tipo_cargo_servicio', 'tcs_id = caf_id_tcs');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($adicional != null) {
            $this->db->where('caf_id_tcs <>', 2);
        }

        $this->db->group_by('caf_id');

        $result = $this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $result;
    }

    function cuotas_cliente($cli = null, $id_plg = null) {
        $this->db->select('cli_id, cli_nombre, cli_id_tif, tif_nombre, fac_id, fac_total, plg_numero, plg_id, plg_monto_deuda,
                        plg_fecha_primera_cuota, cpl_id, cpl_monto, cpl_numero, cpl_interes, cpl_total, cpl_estado, cpl_fecha_vencimiento, fac_id_tpg, tpg_nombre,
                         sxc_id, pxl_id, pxl_id_pln, pln_nombre')
                ->from('cli_cliente')
                ->join('fac_factura', 'fac_id_cli=cli_id')
                ->join('fxp_facturaxplan_pago', 'fxp_id_fac=fac_id')
                ->join('plg_plan_pago', 'plg_id=fxp_id_plg')
                ->join('cpl_cuota_plan_pago', 'cpl_id_plg=plg_id')
                ->join('tif_tipo_factura', 'cli_id_tif=tif_id')
                //->join('tpg_tipo_pago','fac_id_tpg=tpg_id')
                ->join('sxc_servicioxcliente', 'sxc_id_cli=cli_id')
                ->join('pxl_plan_promoxcliente', 'sxc_id= pxl_id_sxc')
                ->join('pln_plan_promocion', 'pln_id=pxl_id_pln')
                ->where('cpl_estado', 1)
                ->where('cli_id', $cli)
        ;
        if ($id_plg != null) {
            $this->db->where('plg_id', $id_plg);
            $this->db->order_by('cpl_id', 'asc');
            $this->db->limit(1);
        }
        if ($id_plg == null) {
            $this->db->group_by('cli_id, plg_id');
        }
        $result = $this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $result;
    }

    function get_impuestos_cliente($where = null) {
        $query = $this->db->select()
                ->from('imp_impuesto')
                ->join('ixc_impuestoxcliente', 'ixc_id_imp = imp_id', 'inner')
                ->join('cli_cliente', 'cli_id = ixc_id_cli', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function detalle_impuestos_factura($factura = null, $fecha_ini = null, $fec_fin = null, $where = null) {

        // $query = "SELECT imp.imp_nombre as impuesto,SUM(ixg.ixg_monto) as monto FROM
        //           ixg_impuestoxcargo AS ixg INNER JOIN imp_impuesto AS imp
        //           ON imp.imp_id = ixg.ixg_id_imp INNER JOIN caf_cargo_facturacion AS caf
        //           ON caf.caf_id = ixg.ixg_id_caf  INNER JOIN cxs_cargoxfacturacion_serv AS cxs
        //           ON cxs.cxs_id_caf = caf.caf_id INNER JOIN fxs_facturaxservicio AS fxs
        //           ON fxs.fxs_id = cxs.cxs_id_fxs INNER JOIN fac_factura AS fac
        //           ON fac.fac_id = fxs.fxs_id_fac WHERE fac_id = ".$factura." GROUP BY ixg.ixg_id_imp ";

        $query = "SELECT imp.imp_nombre as impuesto,SUM(ixg.ixg_monto) as monto FROM
            ixg_impuestoxcargo AS ixg INNER JOIN imp_impuesto AS imp ON imp.imp_id = ixg.ixg_id_imp
            INNER JOIN caf_cargo_facturacion AS caf ON caf.caf_id = ixg.ixg_id_caf
            INNER JOIN tcs_tipo_cargo_servicio AS tcs ON tcs.tcs_id = caf.caf_id_tcs
            INNER JOIN sxc_servicioxcliente AS sxc ON sxc.sxc_id = caf.caf_id_sxc
            INNER JOIN fxs_facturaxservicio AS fxs ON fxs.fxs_id_sxc = sxc.sxc_id
            INNER JOIN fac_factura AS fac ON fac.fac_id = fxs.fxs_id_fac
            WHERE fac_id = " . $factura;

        if ($fecha_ini != null && $fec_fin != null) {
            $query .= " AND date_format(caf_fecha,'%Y-%m-%d') >= '" . $fecha_ini . "'
                    AND date_format(caf_fecha,'%Y-%m-%d') <= '" . $fec_fin . "'";
        }

        $query .= " GROUP BY ixg.ixg_id_imp";

        if ($where != null) {
            $this->db->where($where);
        }

        $result = $this->db->query($query);
        //die(print_r($this->db->last_query()));

        return $result->result_array();
    }

    function verificar_correlativo($tif) {
        $query = $this->db->select('sef_id, sef_id_tif, sef_nombre, tif_nombre, cof_id, cof_inicio, cof_fin, cof_masivo')
                ->from('cof_correlativo_factura')
                ->join('sef_serie_factura', 'cof_id_sef = sef_id', 'inner')
                ->join('tif_tipo_factura', 'sef_id_tif = tif_id', 'inner')
        ;

        if ($tif != null) {
            $this->db->where('sef_id_tif', $tif);
        }
        $this->db->where('cof_masivo', 1);

        return $query->get()->result_array();
    }

    public function get_fijos_caf($where = null, $plan = null, $pxl = null) {
        if ($pxl != null) {
            $this->db->select('sxc_id, cli_id, caf_nombre, caf_valor, pxl_id, pxl_fecha_inicio, pxl_fecha_fin, caf_id, caf_fecha');
        } else {
            $this->db->select('sxc_id, cli_id, caf_nombre, caf_valor,caf_id, caf_fecha');
        }
        $this->db->from('sxc_servicioxcliente')
                ->join('cli_cliente', 'cli_id= sxc_id_cli')
                ->join('caf_cargo_facturacion', 'caf_id_sxc=sxc_id')
        ;
        if ($pxl != null) {
            $this->db->join('pln_plan_promocion', 'pln_nombre=caf_nombre');
            $this->db->join('pxl_plan_promoxcliente', 'pxl_id_pln=pln_id AND sxc_id=pxl_id_sxc');
        }
        $this->db->join('dcc_documento_cliente', 'cli_id=dcc_id_cli', 'left');
        $this->db->where('caf_id_tcs', $plan);


        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('caf_nombre, sxc_id, cli_id');
        $this->db->order_by('sxc_id', 'asc');

        $result = $this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $result;
    }

    public function get_detalle_pago_caja($sxc_id = null, $fac_fecha_cont = null, $tcs = null) {
        $query = "
    SELECT caf_id_sxc, caf_id, caf_id_tcs, caf_valor, caf_fecha, sxc_id,  src_nombre, cli_id, cli_nombre,
               cli_apellido, cli_id_tif, tif_nombre, tpg_id, tpg_nombre, cli_id_ven, caf_nombre, caf_impuesto,
               SUM(caf_subtotal) as subtotal, COUNT(caf_id) as cantidad,
                (SELECT IFNULL(SUM(imp_porcentaje),0) FROM imp_impuesto INNER JOIN ixc_impuestoxcliente
               ON ixc_id_imp = imp_id WHERE ixc_id_cli = cli_id) as impuestos,
               (SELECT CONCAT(MIN(date_format(pxl_fecha_inicio,'%Y-%m-%d')),' - ',MAX(date_format(pxl_fecha_fin,'%Y-%m-%d')))
                  FROM pxl_plan_promoxcliente WHERE pxl_id_sxc = sxc_id ) as pxl
            , fxs.fxs_id, fxs.fxs_fecha_fin, cof_id, fac_id, fac_total, fac_numero,fac_estado, fac_subtotal, cxs_id, cxs_id_fxs FROM caf_cargo_facturacion
        INNER JOIN sxc_servicioxcliente ON sxc_id=caf_id_sxc
        INNER JOIN cli_cliente ON cli_id= sxc_id_cli
        INNER JOIN src_servicio ON src_id=sxc_id_src
        INNER JOIN tif_tipo_factura ON cli_id_tif=tif_id
        INNER JOIN tpg_tipo_pago ON cli_id_tpg=tpg_id
        LEFT JOIN
          (SELECT * FROM cxs_cargoxfacturacion_serv cs LEFT JOIN fxs_facturaxservicio fs ON fs.fxs_id= cs.cxs_id_fxs
           WHERE fs.fxs_estado=1 )
          cxs ON cxs.cxs_id_caf = caf_id
        LEFT JOIN
            (SELECT * FROM fxs_facturaxservicio facs WHERE facs.fxs_estado=1  ) fxs ON fxs.fxs_id = cxs_id_fxs
        LEFT JOIN fac_factura ON fac_id = fxs.fxs_id_fac
        LEFT JOIN cof_correlativo_factura ON cof_id = fac_id_cof
        WHERE sxc_id =" . $sxc_id . "";

        if ($tcs != null) {
            $query .= " AND caf_id_tcs = " . $tcs;
        } else {
            $query .= " AND caf_id_tcs NOT IN (1,2)";
        }

        if ($fac_fecha_cont != null) {
            $query .= " AND date_format(caf_fecha,'%Y-%m-%d') = '" . $fac_fecha_cont . "'";
        }

        $query .= " GROUP BY caf_id";


        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }

    function reporte_historial_facturacion($cliente = 0, $fecha_inicio = '', $fecha_fin = '') {

        $query = $this->db->query('call sp_historial_facturacion(' . $cliente . ',"' . $fecha_inicio . '","' . $fecha_fin . '")');

        clean_mysqli_connection($this->db->conn_id);

        return $query->result_array();
    }

    function reporte_pagos($cliente = 0, $fecha_inicio = '', $fecha_fin = '') {

        $query = $this->db->query('call sp_reporte_pag(' . $cliente . ',"' . $fecha_inicio . '","' . $fecha_fin . '")');

        clean_mysqli_connection($this->db->conn_id);

        return $query->result_array();
    }

    function reporte_facturas($cliente = 0, $fecha_inicio = '', $fecha_fin = '', $estado = 5) {
        if ($estado == 3) {
            $estado = 0;
        }

        $query = $this->db->query('call sp_reporte_fac(' . $cliente . ',"' . $fecha_inicio . '","' . $fecha_fin . '","' . $estado . '")');

        clean_mysqli_connection($this->db->conn_id);

        return $query->result_array();
    }

    function get_reporte_contabilidad($cliente = 0, $fecha_inicio = '', $fecha_fin = '') {

        $query = $this->db->query('call sp_reporte_contabilidad(' . $cliente . ',"' . $fecha_inicio . '","' . $fecha_fin . '")');

        clean_mysqli_connection($this->db->conn_id);

        return $query->result_array();
    }

    function get_facturas_vencidas($cliente = 0, $servicio = 0, $fecha_inicio = '', $fecha_fin = '') {
        $query = $this->db->query('call sp_reporte_fac_venc(' . $cliente . ',' . $servicio . ',"' . $fecha_inicio . '","' . $fecha_fin . '")');

        clean_mysqli_connection($this->db->conn_id);

        return $query->result_array();
    }

    function reporte_libros_iva($tipo = 0, $fecha_inicio = '', $fecha_fin = '') {

        $query = $this->db->query('call sp_reporte_libro_iva(' . $tipo . ',"' . $fecha_inicio . '","' . $fecha_fin . '")');

        clean_mysqli_connection($this->db->conn_id);

        return $query->result_array();
    }

    function reporte_fac($cliente = 0, $fecha_inicio = '', $fecha_fin = '', $estado = 5, $nit) {

        $query = "SELECT cli_codigo AS codigo_cliente, CONCAT_WS(' ',cli_nombre, cli_apellido) nombre,
             IF(dcc_id_tde =2 ,dcc_valor,'') as nit_dcc,
             IF(dce_id_tde =2 ,dce_valor,'') as nit_dce,
            fac_numero AS factura, fac_subtotal AS total_neto, fac_total AS totalMasIva, fac_tipo, tif_nombre AS tipo_factura,
            GROUP_CONCAT(def_descripcion SEPARATOR ',') as Producto,
            CASE
                WHEN   fac_estado = 0 THEN 'Anulada'
                WHEN fac_estado = 1 THEN 'Pendiente'
                WHEN   fac_estado = 2 THEN 'Pagada'
            END estado
            FROM cli_cliente
            INNER JOIN fac_factura ON cli_id = fac_id_cli
            INNER JOIN cof_correlativo_factura ON fac_id_cof=cof_id
            INNER JOIN sef_serie_factura ON sef_id=cof_id_sef
            INNER JOIN tif_tipo_factura ON sef_id_tif=tif_id
            INNER JOIN def_detalle_fact ON def_id_fac=fac_id
            LEFT JOIN alm_alumno ON alm_id_cli = cli_id
            LEFT  JOIN dcc_documento_cliente  ON dcc_id_cli = cli_id AND dcc_id_tde=" . $nit . " AND dcc_valor IS NOT NULL
            LEFT JOIN dce_documento_alm ON dce_id_alm = alm_id AND dce_id_tde=" . $nit . " AND dce_valor IS NOT NULL
            WHERE cli_id = " . $cliente . " AND DATE_FORMAT(fac_fecha_crea, '%Y-%m-%d') >= '" . $fecha_inicio . "' AND DATE_FORMAT(fac_fecha_crea, '%Y-%m-%d') <= '" . $fecha_fin . "'"
        ;

        if ($estado != 5) {
            $query .= " AND  fac_estado =" . $estado;
        }

        $query .= " GROUP BY fac_numero";


        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }

    function correlativo_caja($id) {
        $this->db->select('*, (SELECT COUNT(fac_id) FROM fac_factura WHERE fac_numero >= cxj_inicio AND fac_numero <= cxj_fin AND fac_id_cof = cof_id 
            AND fac_id_tif = sef_id_tif) AS ya_usadas', false)
                ->from('cxj_correlativoxcaja')
                ->join('caj_caja', 'caj_id = cxj_id_caj', 'left')
                ->join('cof_correlativo_factura', 'cxj_id_cof = cof_id', 'right')
                ->join('sef_serie_factura', 'sef_id = cof_id_sef', 'right')
                ->where('caj_id', $id);
        return $this->db->get()->result_array();
    }

    function obtener_series() {  
        $this->db->select('')
                ->from('cof_correlativo_factura')
                // ->join('cxj_correlativoxcaja','cxj_id_cof = cof_id', left)
                ->join('sef_serie_factura', 'cof_id_sef = sef_id', 'left')
                ->where('cof_estado', 1)
                ->group_by('cof_id');
        return $this->db->get()->result_array();
    }

    function obtener_series2($id2) {
        $this->db->select('')
                ->from('cof_correlativo_factura')
                ->join('cxj_correlativoxcaja', 'cxj_id_cof = cof_id', 'left')
                ->join('caj_caja', 'caj_id = cxj_id_caj', 'left')
                ->join('sef_serie_factura', 'cof_id_sef = sef_id', 'left')
                ->where('caj_id', $id2);
        return $this->db->get()->result_array();
    }

    function correlativos_caja($id) {
        $this->db->select('')
                ->from('cxj_correlativoxcaja')
                ->join('cof_correlativo_factura', 'cof_id = cxj_id_cof', 'left')
                ->join('sef_serie_factura', 'sef_id = cof_id_sef', 'left')
                ->where('cxj_id', $id);
        return $this->db->get()->result_array();
    }

    function cajeros($rol, $where=null) {
        /*
            SELECT *, COUNT(id) FROM users
            LEFT JOIN emp_empleado ON emp_id_usu = id
            LEFT JOIN uxr_usuarioxrol ON uxr_id_usu = id
            LEFT JOIN rol_rol ON rol_id = uxr_id_rol
            WHERE rol_id = 4
            GROUP BY id
            HAVING COUNT(id) = 1 and id NOT IN(SELECT uxc_id_usu FROM uxc_usuarioxcaja WHERE uxc_estado = 1 AND uxc_tipo != 2)
            ORDER BY emp_nombre, emp_apellido;
        */
        $this->db->select('*,count(id)')
                ->from('users')
                ->join('emp_empleado', 'emp_id_usu = id', 'left')
                ->join('uxr_usuarioxrol', 'uxr_id_usu = id', 'left')
                ->join('rol_rol', 'rol_id = uxr_id_rol', 'left')
                //  ->join('uxc_usuarioxcaja', 'uxc_id_usu = emp_id_usu', left)
                ->where('activated', 1)
                ->where('rol_id', $rol);
            if($where!=null){
                $this->db->where($where);
            }

        $this->db->group_by('id')
                ->having('count(id)', 1)
                ->having('id NOT IN(SELECT uxc_id_usu FROM uxc_usuarioxcaja WHERE uxc_estado = 1 AND uxc_tipo = 1)')
                ->order_by('emp_nombre, emp_apellido', false);
        return $this->db->get()->result_array();
    }

    public function nuevas_series($tipo, $caja) {
        $id = $this->tank_auth->get_user_id();
        $this->db->select('')
                ->from('tif_tipo_factura')
                ->join('sef_serie_factura', 'sef_id_tif = tif_id', 'left')
                ->join('cof_correlativo_factura', 'cof_id_sef = sef_id', 'left')
                ->join('cxj_correlativoxcaja', 'cxj_id_cof = cof_id', 'left')
                ->join('caj_caja', 'caj_id = cxj_id_caj', 'left')
                ->where('caj_id', $caja)
                ->where('cxj_estado', 1);
        $this->db->where('tif_id', $tipo)
                ->group_by('caj_id');
        return $this->db->get()->result_array();
    }

    public function nuevas_series_cargar() {
        $id = $this->tank_auth->get_user_id();
        $this->db->select('')
                ->from('uxc_usuarioxcaja')
                ->join('caj_caja', 'uxc_id_caj = caj_id', 'left')
                ->join('cxj_correlativoxcaja', 'cxj_id_caj = caj_id', 'left')
                ->join('cof_correlativo_factura', 'cof_id = cxj_id_cof', 'left')
                ->join('sef_serie_factura', 'sef_id = cof_id_sef', 'left')
                ->join('emp_empleado', 'emp_id_usu = uxc_id_usu', 'left')
                ->join('uxr_usuarioxrol', 'uxr_id_usu = uxc_id_usu', 'left')
                ->join('rol_rol', 'rol_id = uxr_id_rol', 'left')
                ->where('uxc_id_usu', $id)
                // $this->db->where('sef_id_tif', $tipo)
                ->group_by('cxj_id');
        return $this->db->get()->result_array();
    }

    public function correlativos_x_cajas($id_serie, $caja) {
        $id = $this->tank_auth->get_user_id();
        $this->db->select('')
                ->from('uxc_usuarioxcaja')
                ->join('caj_caja', 'uxc_id_caj = caj_id', 'left')
                ->join('cxj_correlativoxcaja', 'cxj_id_caj = caj_id', 'left')
                ->join('cof_correlativo_factura', 'cof_id = cxj_id_cof', 'left')
                ->join('sef_serie_factura', 'sef_id = cof_id_sef', 'left')
                ->join('emp_empleado', 'emp_id_usu = uxc_id_usu', 'left')
                ->join('uxr_usuarioxrol', 'uxr_id_usu = uxc_id_usu', 'left')
                ->join('rol_rol', 'rol_id = uxr_id_rol', 'left')
                ->where('uxc_id_usu', $id);
        $this->db->where('cof_id', $id_serie);
        $this->db->where('cxj_estado', 1);
        $this->db->where('caj_id', $caja)
                ->group_by('cxj_id');
        return $this->db->get()->result_array();
    }

    public function correlativos_x_cajas_sujexc($id_serie, $caja) {
        $this->db->select('')
                ->from('uxc_usuarioxcaja')
                ->join('caj_caja', 'uxc_id_caj = caj_id', 'left')
                ->join('cxj_correlativoxcaja', 'cxj_id_caj = caj_id', 'left')
                ->join('cof_correlativo_factura', 'cof_id = cxj_id_cof', 'left')
                ->join('sef_serie_factura', 'sef_id = cof_id_sef', 'left')
                ->join('emp_empleado', 'emp_id_usu = uxc_id_usu', 'left')
                ->join('uxr_usuarioxrol', 'uxr_id_usu = uxc_id_usu', 'left')
                ->join('rol_rol', 'rol_id = uxr_id_rol', 'left');
        $this->db->where('cof_id', $id_serie);
        $this->db->where('cxj_estado', 1);
        $this->db->where('caj_id', $caja)
                ->group_by('cxj_id');
        return $this->db->get()->result_array();
    }

    public function anticipos_obtener($cliente = null, $producto = null){
        $this->db->select("fac_id, CONCAT(tif_abreviacion, '-',fac_numero) as factura,fac_monto_anticipo,fac_monto_usado_anticipo,fac_monto_saldo_anticipo",false)
                 ->from('fac_factura')
                 ->join('def_detalle_fact', 'fac_id = def_id_fac', 'INNER')
                 ->join('tif_tipo_factura', 'fac_id_tif = tif_id', 'LEFT')
                 ->where(array('fac_id_cli' => $cliente, 'def_id_art' => $producto,'fac_monto_saldo_anticipo >'=>0))
                 ->order_by('fac_id desc')
                 ;
        $query = $this->db->get();
        if ($query->num_rows()>0) {
            return $query->result_array();
        }else{return false;}
    }

    public function get_nombre_cajero_factura($fac_id = 0){
        $dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
        $this->db->select("IF(emp_id IS NULL, username, CONCAT_WS(' ',emp_nombre,emp_apellido)) AS cajero, IFNULL((SELECT dce_valor FROM dce_documento_emp 
            WHERE dce_estado = 1 AND dce_id_tde = $dui AND dce_id_emp = emp_id LIMIT 1), '') AS dui_cajero ", false)
            ->from('fac_factura')
            ->join('uxc_usuarioxcaja', 'uxc_id = fac_id_uxc', 'INNER')
            ->join('users', 'id = uxc_id_usu', 'INNER')
            ->join('emp_empleado', 'emp_id = usu_id_emp', 'LEFT')
            ->where('fac_id', $fac_id)
        ;
        return $this->db->get()->result_array();
    }

    public function datos_usuario_caja($rol, $id_usuario = null) {
        $id = ($id_usuario!=null) ? $id_usuario : $this->tank_auth->get_user_id();
        $this->db->select('')
                ->from('uxc_usuarioxcaja')
                ->join('caj_caja', 'uxc_id_caj = caj_id', 'left')
                ->join('cxj_correlativoxcaja', 'cxj_id_caj = caj_id', 'left')
                ->join('cof_correlativo_factura', 'cof_id = cxj_id_cof', 'left')
                ->join('sef_serie_factura', 'sef_id = cof_id_sef', 'left')
                ->join('users', 'id = uxc_id_usu', 'left')
                ->join('emp_empleado', 'emp_id_usu = id', 'left')
                ->join('suc_sucursal', 'emp_id_suc = suc_id', 'left')
                ->join('uxr_usuarioxrol', 'uxr_id_usu = id', 'left')
                ->join('rol_rol', 'rol_id = uxr_id_rol', 'left')
                ->where('id', $id);
        $this->db->where('rol_id', $rol);
        $this->db->where('uxc_estado', 1)
                ->where('uxc_tipo', 1)
                ->group_by('uxc_id')
                ->order_by('uxc_id');
        return $this->db->get()->result_array();
    }

    public function cajas_asignadas_grid() {
        $id = $this->tank_auth->get_user_id();
        $this->db->select('*, (SELECT username FROM users WHERE id = uxc_id_usu) AS username,
            (SELECT uxc.uxc_id FROM uxc_usuarioxcaja AS uxc WHERE uxc.uxc_id_caj = uxc2.uxc_id_caj ORDER BY uxc.uxc_id DESC LIMIT 1, 1) as uxc_anterior', false)
                ->from('uxc_usuarioxcaja AS uxc2')
                ->join('caj_caja', 'uxc2.uxc_id_caj = caj_id', 'left')
                ->join('emp_empleado', 'emp_id_usu = uxc2.uxc_id_usu', 'left')
                ->where('caj_estado', 1);
        $this->db->where('uxc2.uxc_estado', 1);
        return $this->db->get()->result_array();
    }

    public function datos_uxc_edit($uxc_id) {
        $id = $this->tank_auth->get_user_id();
        $this->db->select('')
                ->from('uxc_usuarioxcaja')
                ->join('caj_caja', 'uxc_id_caj = caj_id', 'left')
                ->join('cxj_correlativoxcaja', 'cxj_id_caj = caj_id', 'left')
                ->join('cof_correlativo_factura', 'cof_id = cxj_id_cof', 'left')
                ->join('sef_serie_factura', 'sef_id = cof_id_sef', 'left')
                ->join('emp_empleado', 'emp_id_usu = uxc_id_usu', 'left')
                ->join('uxr_usuarioxrol', 'uxr_id_usu = uxc_id_usu', 'left')
                ->join('rol_rol', 'rol_id = uxr_id_rol', 'left')
                ->where('uxc_id', $uxc_id)
                ->group_by('uxc_id');
        return $this->db->get()->result_array();
    }

    public function validar_uxc($uxc_id) {
        $id = $this->tank_auth->get_user_id();
        $this->db->select('')
                ->from('cxj_correlativoxcaja')
                ->join('cof_correlativo_factura', 'cof_id = cxj_id_cof', 'left');
        return $this->db->get()->result_array();
    }

    public function historial_cajas($caja = null, $fecha_inicio = null, $fecha_fn = null, $estado = null, $where = null, $having = null) {
        $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $nt_cred = (isset($tipo_factura['NOTA CREDITO'])) ? $tipo_factura['NOTA CREDITO'] : 0;
        $nt_remi = (isset($tipo_factura['NOTA REMISION'])) ? $tipo_factura['NOTA REMISION'] : 0;
        $excluidas = implode(',', array($nt_cred, $nt_remi));
        $this->db->select("
                    IF (
                        f1.fac_fecha_anulacion IS NULL,
                            IF (f1.fac_estado > 1, 'Pagada', 'Pendiente'),
                            IF (DATE(f1.fac_fecha_anulacion ) <= '".$fecha_fn."', 'Anulada', 'Anulada' /* IF (f1.fac_estado > 1, 'Pagada','Pendiente') */
                            )
                    ) AS estado_actual,
                    f1.fac_id_fac_credito,
                    ( 
                        SELECT 
                            CONCAT(tnc.tif_abreviacion,' #',fnc.fac_numero )  
                        FROM fac_factura AS fnc 
                        JOIN tif_tipo_factura AS tnc ON tnc.tif_id = fnc.fac_id_tif  
                        WHERE fnc.fac_id = f1.fac_id_fac_credito 
                    ) AS fac_padre,
                    (
                        SELECT
	                        SUM(ana_monto)
                        FROM
	                        ana_anticipo_abono
                        join abc_abono_cliente on abc_id = ana_id_abc
                        join abf_abono_factura on abf_id_abc = abc_id
                        where abf_id_fac = f1.fac_id
                    ) AS anticipo,
                    (
                        SELECT
                           CONCAT_WS('##', IFNULL(GROUP_CONCAT(DISTINCT abc_id_pct),''), IFNULL(GROUP_CONCAT(DISTINCT anl_id_pct),''))
                        FROM
                             abf_abono_factura
                             join abc_abono_cliente on abc_id = abf_id_abc
                             left join ana_anticipo_abono on ana_id_abc = abc_id
                             left join anl_anticipo_cliente on anl_id = ana_id_anl
                             where abf_id_fac = f1.fac_id limit 1
                    ) AS id_partida_abc_anticipo,
                    IF (cli_personeria = 1,
                    CONCAT(cli_codigo, ' - ', CONCAT_WS(' ',cli_nombre, cli_apellido)),
                    CONCAT(cli_codigo, ' - ',cli_apellido)
                    ) AS cliente,

                    caj_id, caj_nombre, 
                    f1.fac_numero,
                    f1.fac_tipo,
                    t1.tif_nombre,
                    DATE_FORMAT(f1.fac_fecha_fact, ('%d-%m-%Y')) AS fecha, f1.fac_estado,
                    emp_nombre, emp_apellido,f1.fac_subtotal,f1.fac_descuento,f1.fac_impuesto,
                    t1.tif_abreviacion, tpg_nombre, arf_nombre, f1.fac_total, 
                    f1.fac_id, f1.fac_id_pct, f1.fac_id_pct_anulacion,uxc_id_fac",false)
                ->from('fac_factura f1')
                //->join('cof_correlativo_factura', 'cof_id = fac_id_cof', 'left')
                //->join('sef_serie_factura', 'sef_id = cof_id_sef', 'left')
                ->join('tif_tipo_factura t1', 't1.tif_id = f1.fac_id_tif', 'left')
                ->join('paf_pago_factura', 'paf_id_fac = f1.fac_id', 'left')
                //->join('cxj_correlativoxcaja', 'cof_id = cxj_id_cof', 'left')
                ->join('uxc_usuarioxcaja', 'f1.fac_id_uxc = uxc_id', 'left')
                ->join('caj_caja', 'caj_id  = uxc_id_caj', 'left')
                ->join('emp_empleado', 'f1.fac_usu_mod = emp_id_usu', 'left')
                //->join('are_area','are_id = fac_id_are','left')
                ->join('arf_area_factura','arf_id = f1.fac_id_arf','left')
                ->join('cli_cliente','cli_id = f1.fac_id_cli','left')
                ->join('tpg_tipo_pago','tpg_id = f1.fac_id_tpg',"left")
                ;
        if ($estado == 1){
            $this->db->join("abf_abono_factura", "abf_id_fac = f1.fac_id AND abf_pendiente_factura > 0", "left");
            $this->db->join("abc_abono_cliente", "abc_id = abf_id_abc AND abc_estado = 1 AND DATE(abc_fecha) <= '$fecha_fn'", "left");
        } else {
            $this->db->join("abf_abono_factura", "abf_id_fac = f1.fac_id AND abf_pendiente_factura = 0", "left");
            $this->db->join("abc_abono_cliente", "abc_id = abf_id_abc AND abc_estado = 1 AND DATE(abc_fecha) <= '$fecha_fn'", "left");
        }
        if ($where != null) {
            $this->db->where($where);
        }
        if ($caja != null) {
            $this->db->where('uxc_id_caj', $caja);
        }
        $this->db->where("fac_id_tif NOT IN ($excluidas)");
        if ($estado === 0) {
            $this->db->where(" DATE(f1.fac_fecha_anulacion) BETWEEN '".$fecha_inicio."' AND '".$fecha_fn."'",null,false);
        } elseif ($estado == 1) {
            $this->db->where(" f1.fac_id NOT IN (SELECT abf_id_fac FROM abf_abono_factura JOIN abc_abono_cliente ON abc_id = abf_id_abc WHERE DATE(abc_fecha) BETWEEN '$fecha_inicio' AND '$fecha_fn' AND abf_pendiente_factura = 0 and abc_estado <> 0)",null,false);
            $this->db->where(" ( DATE(f1.fac_fecha_anulacion) >= '".$fecha_fn."' or f1.fac_fecha_anulacion IS NULL)",null,false);
        } elseif ($estado == 2) {
            $this->db->where(" f1.fac_id IN (SELECT abf_id_fac FROM abf_abono_factura JOIN abc_abono_cliente ON abc_id = abf_id_abc WHERE DATE(abc_fecha) BETWEEN '$fecha_inicio' AND '$fecha_fn' AND abf_pendiente_factura = 0 AND abc_estado <> 0 AND f1.fac_fecha_anulacion IS NULL)",null,false);
            $this->db->where(" ( DATE(f1.fac_fecha_anulacion) <= '".$fecha_fn."' or f1.fac_fecha_anulacion IS NULL)",null,false);
        }
        if ($fecha_inicio == null) {

        } else {
            $this->db->where("DATE(f1.fac_fecha_fact) >=", "'".$fecha_inicio."'",false);
        }
        if ($fecha_fn == null) {

        } else {
            $this->db->where("DATE(f1.fac_fecha_fact) <=", "'".$fecha_fn."'",false);
        }
        if ($having != null) {
            $this->db->having($having);
        }
        $this->db->group_by('f1.fac_id')
                ->order_by('caj_id, f1.fac_numero');

        return $this->db->get()->result_array();
    }

    public function historial_caja_cajero($fecha_inicio = null, $fecha_fn = null, $where_in=null, $where=null) {
        $this->db->select("
                fac_id,
                fac_id_tpg,
                fac_id_tif,
                fac_id_uxc,
                fac_id_cof,
                caj_nombre,
                suc_nombre,
                fac_numero,
                sef_nombre,
                fac_tipo,
                tif_nombre,
                DATE_FORMAT(fac_fecha_fact,('%d-%m-%Y')) AS fecha,
                (SELECT cli_codigo FROM cli_cliente WHERE cli_id = fac_id_cli) AS cli_codigo,
                (SELECT IF(cli_personeria = 2,cli_apellido,CONCAT_WS(' ',cli_nombre,cli_apellido)) FROM cli_cliente WHERE cli_id = fac_id_cli) AS cli_nombre,
                fac_estado,
                emp_nombre,
                emp_apellido,
                fac_subtotal,
                fac_descuento,
                fac_total_retencion,
                fac_impuesto,
                fac_total,
                IF(emp_id IS NULL, username, CONCAT_WS(' ', emp_nombre, emp_apellido)) AS usuario
            ", false)
            ->from('fac_factura')
            ->join('cof_correlativo_factura', 'cof_id = fac_id_cof')
            ->join('sef_serie_factura', 'sef_id = cof_id_sef')
            ->join('tif_tipo_factura', 'sef_id_tif = tif_id')
            ->join('cxj_correlativoxcaja', 'cof_id = cxj_id_cof')
            ->join('caj_caja', 'caj_id  = cxj_id_caj')
            ->join('uxc_usuarioxcaja', 'fac_id_uxc = uxc_id AND uxc_id_caj = caj_id')
            ->join('emp_empleado', 'emp_id_usu = uxc_id_usu', 'left')
            ->join('users', 'id = uxc_id_usu')
            ->join('suc_sucursal', 'suc_id = fac_id_suc', 'left')
        ;
        $this->db->where('fac_fecha_fact' . ' >=', $fecha_inicio . ' 00:00:00');
        $this->db->where('fac_fecha_fact' . ' <=', $fecha_fn . ' 23:59:59');
        if($where!=null){
            $this->db->where($where);
        }
        if($where_in!=null){
            $this->db->where_in('uxc_id_caj', $where_in);
        }
        $this->db->group_by('fac_id')
        ->order_by('sef_nombre, fac_numero');
        return $this->db->get()->result_array();
    }

    public function datos_caja_asignadas($id_caja, $fecha = null) {
        $this->db->select('*, (SELECT username FROM users WHERE id = uxc_id_usu) AS username', false)
                ->from('uxc_usuarioxcaja')
                ->join('caj_caja', 'uxc_id_caj = caj_id', 'left')
                ->join('emp_empleado', 'emp_id_usu = uxc_id_usu', 'left')
                ->join('suc_sucursal', 'emp_id_suc = suc_id', 'left')
                ->where('caj_id', $id_caja);
        if ($fecha) {
            // $this->db->where('uxc_fecha_proceso',$fecha);
        }
        $this->db->where('uxc_estado', 1);
        return $this->db->get()->result_array();
    }

    public function datos_caja_asignadas_ayer($id_caja) {
        $this->db->select('*')
                ->from('uxc_usuarioxcaja')
                ->join('caj_caja', 'uxc_id_caj = caj_id', 'left' )
                ->join('emp_empleado', 'emp_id_usu = uxc_id_usu', 'left')
                ->where('caj_id', $id_caja);
        $this->db->where('uxc_estado', 1);
        return $this->db->get()->result_array();
    }

    public function validar_correlativos_cajas_($caja) {
        $this->db->select('cxj_inicio, cxj_fin, cof_inicio, cof_fin, sef_nombre, tif_nombre, tif_id, tif_id, cxj_id_cof')
                ->from('cxj_correlativoxcaja')
                ->join('cof_correlativo_factura', 'cof_id = cxj_id_cof', 'left')
                ->join('sef_serie_factura', 'sef_id = cof_id_sef', 'left')
                ->join('tif_tipo_factura', 'tif_id = sef_id_tif', 'left')
                ->where('cxj_estado', 1)
                ->where('cxj_id_caj', $caja)
                ;
        $this->db->where('cof_estado', 1);
        return $this->db->get()->result_array();
    }

    public function validar_tipo_serie_($serie) {
        $this->db->select('tif_id')
                ->from('cof_correlativo_factura')
                ->join('sef_serie_factura', 'sef_id = cof_id_sef', 'left')
                ->join('tif_tipo_factura', 'tif_id = sef_id_tif', 'left')
                ->where('cof_id', $serie);
        return $this->db->get()->result_array();
    }

    public function get_new_correlativo($inicio, $fin, $id_serie, $masivo = null, $id_cor = null, $id_cxj, $caj_id, $uxj_id) {
        $id = $this->tank_auth->get_user_id();
        $query = "SELECT cxj_inicio, cxj_fin, sef_nombre, cxj_id, caj_nombre, caj_id, cof_id, fac_numero, MAX((fac_numero))   as cor_actual
        FROM
          uxc_usuarioxcaja
         JOIN `caj_caja` ON `uxc_id_caj` = `caj_id`
         JOIN `cxj_correlativoxcaja` ON `cxj_id_caj` = `caj_id`
         JOIN `cof_correlativo_factura` ON `cof_id` = `cxj_id_cof`
         JOIN `sef_serie_factura` ON `sef_id` = `cof_id_sef`
         JOIN emp_empleado ON emp_id_usu = uxc_id_usu
         JOIN fac_factura ON fac_id_cof = cof_id
        WHERE
          `uxc_id_usu` = '" . $id . "'
          AND cof_id = '" . $id_serie . "' AND
          fac_numero >= (
                          select cxj_inicio
                          from cxj_correlativoxcaja
                          LEFT JOIN cof_correlativo_factura ON cof_id = cxj_id_cof
                          where cxj_id = '" . $id_cxj . "'  AND cxj_id_caj = '" . $caj_id . "')
          AND fac_numero <= (SELECT cxj_fin
                          from cxj_correlativoxcaja
                          LEFT JOIN cof_correlativo_factura ON cof_id = cxj_id_cof
                          where cxj_id = '" . $id_cxj . "'  AND cxj_id_caj = '" . $caj_id . "')
        GROUP BY fac_id
        ORDER BY cor_actual desc";
        $result = $this->db->query($query);
        //die(print_r($this->db->last_query()));

        return $result->result_array();
    }

    public function info_articulo($id) {
        $this->db->select('gra_nombre, gra_id_art, gra_horario')
                ->from('gra_grupo_academico')
                ->where('gra_id_art', 202);
        return $this->db->get()->result_array();
    }

    public function unidades_grupo($id_grupo) {
        $this->db->select('*')
                ->from('gra_grupo_academico')
                ->join('uxg_uni_grupo', 'uxg_id_gra = gra_id')
                ->join('unm_unidad_modulo', 'unm_id = uxg_id_unm')
                ->where('gra_id', $id_grupo);
        $this->db->where('uxg_estado', 1);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function docente_grupo($id_grupo) {
        $this->db->select('emp_nombre, emp_apellido')
                ->from('gra_grupo_academico')
                ->join('dct_docente', 'dct_id = gra_id_dct')
                ->join('emp_empleado', 'emp_id = dct_id_emp')
                ->where('gra_id', $id_grupo);
        //$this->db->where('uxg_estado',1);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function modulo_grupo($id_grupo) {
        $this->db->select('mod_nombre')
                ->from('gra_grupo_academico')
                ->join('pen_pensum', 'pen_id = gra_id_pen')
                ->join('mod_modulo', 'mod_id = pen_id_mod')
                ->where('gra_id', $id_grupo);
        //$this->db->where('uxg_estado',1);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function horario_grupo($id_grupo) {
        $this->db->select("CONCAT(DATE_FORMAT(hrg_inicio, '%h:%i %p'), ' - ', DATE_FORMAT(hrg_fin, '%h:%i %p')) as horario", false)
                ->from('gra_grupo_academico')
                ->join('hrg_horario_grupo', 'hrg_id = gra_id_hrg')
                ->where('gra_id', $id_grupo);
        //$this->db->where('uxg_estado',1);
        $query = $this->db->get();
        return $query->result_array();
    }

    function get_numeros_facturas($where = null) {
        $query = $this->db->select()
                ->from('fac_factura')
                ->order_by('fac_numero', 'DESC')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->limit('1');
        return $query->get()->result_array();
    }

    function get_numeros_facturas2($where = null, $select = "*") {
        $query = $this->db->select($select)
                ->from('fac_factura')
                ->order_by('fac_numero', 'DESC')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_cotizacion_factura($where = null) {
        $query = $this->db->select()
                ->from('cog_cotiz_ganada')
                ->join('cot_cotizacion', 'cog_id_cot = cot_id');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_producto_detalle($where = null) {
        $query = $this->db->select()
                ->from('axc_articuloxcotizacion')
                ->join('art_articulo', 'art_id = axc_id_art')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_producto_orden_detalle($where = null) {
        $query = $this->db->select()
                ->from('axo_articuloxorden')
                ->join('art_articulo', 'art_id = axo_id_art')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_producto_factura_detalle($where = null) {
        $query = $this->db->select()
                ->from('def_detalle_fact')
                ->join('art_articulo', 'art_id = def_id_art')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep')
                ->join('tpv_tipo_venta', 'tpv_id = def_id_tpv','left')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_impuestos_productos($where = null) {
        $query = $this->db->select()
                ->from('ixt_impuestoxcotizacion')
                ->join('imp_impuesto', 'imp_id = ixt_id_imp');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_impuestos_factura_productos($where = null) {
        $query = $this->db->select()
                ->from('ixf_impuestoxfactura')
                ->join('imp_impuesto', 'imp_id = ixf_id_imp');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_retencion_factura_productos($where = null) {
        $query = $this->db->select()
                ->from('rxf_retencionxdetalle_factura')
                ->join('ret_retencion', 'ret_id = rxf_id_ret');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_datos_garantia($where = null, $group = null) {
        $query = $this->db->select("", true)
                ->from('fac_factura')
                ->join('cli_cliente', 'cli_id = fac_id_cli');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($group != null) {
            $this->db->group_by($group);
        }
        return $query->get()->result_array();
    }

    function get_datos_pagos($where = null,$groupby = null) {
        /* SELECT * FROM fac_factura
          INNER JOIN cli_cliente on fac_id_cli = cli_id
          LEFT JOIN ven_vendedor on fac_id_ven = ven_id
          LEFT JOIN suc_sucursal ON fac_id_suc = suc_id
          INNER JOIN tif_tipo_factura on fac_id_tif = tif_id */
        $query = $this->db->select("*, IF (
                        cli_personeria = 1,
                        CONCAT_WS(' ', cli_nombre, cli_apellido),
                        cli_apellido
                    ) AS nombre",false)
                ->from('fac_factura')
                ->join('cli_cliente', 'fac_id_cli = cli_id', 'inner')
                ->join('scl_sucursal_cliente','scl_id = fac_id_scl','left')
                ->join('suc_sucursal', 'suc_id = fac_id_suc', 'left')
                ->join('ven_vendedor', 'fac_id_ven = ven_id', 'left')
                ->join('tif_tipo_factura', 'fac_id_tif = tif_id', 'inner')
                ->order_by('fac_fecha_cont', 'ASC')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
          $this->db->group_by($groupby);
        }

        return $query->get()->result_array();
    }

    /**/
    public function datos_numero_control($fac_id){
        $ffct = $this->gsatelite->get_campo('fac_factura', 'fac_fecha_fact', array('fac_id' => $fac_id));
        $year = ($ffct) ? formatear_fecha("Y", $ffct) : date("Y");///AND f.fac_numero_control != '' 
        $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $ccfe = $tipo_factura["CREDITO FISCAL"];
        $fsee = $tipo_factura["SUJETO EXCLUIDO"];
        $nce  = $tipo_factura["NOTA CREDITO"];
        $nde  = $tipo_factura["NOTA DEBITO"];
        $nre  = $tipo_factura["NOTA REMISION"];
        $fexe = $tipo_factura["EXPORTACION"];
        $query = $this->db->select("IFNULL(tif_codigo_fact_elect, (CASE x.fac_id_tif WHEN 'DONACION' THEN '15' WHEN $fsee THEN '14' WHEN $fexe THEN '11'  
            WHEN 'COMP.LIQUIDACION' THEN '08' WHEN $nce THEN '05' WHEN $nre THEN '04' WHEN 'C.RETENCION' THEN '07' WHEN $nde THEN '06' WHEN 'D.C.LIQUIDA' THEN '09' 
            WHEN $ccfe THEN '03' ELSE '01' END) ) AS tipo_documento,
            suc_codigo, suc_codigo_fact_elect, caj_id, caj_codigo_fact_elect,
            IFNULL((SELECT MAX(SUBSTRING_INDEX(f.fac_numero_control,'-',-1)) FROM fac_factura AS f JOIN uxc_usuarioxcaja AS u ON u.uxc_id = f.fac_id_uxc 
            WHERE YEAR(f.fac_fecha_fact) = $year AND f.fac_id_tif = x.fac_id_tif AND u.uxc_id_caj = caj_id), 0) AS ultimo_correlativo", false)
            ->from('fac_factura AS x ')
            ->join('tif_tipo_factura', 'tif_id = x.fac_id_tif')
            ->join('suc_sucursal', 'suc_id = x.fac_id_suc')
            ->join('uxc_usuarioxcaja', 'uxc_id = x.fac_id_uxc')
            ->join('caj_caja', 'caj_id = uxc_id_caj')
            ->where('x.fac_id', $fac_id)
        ;
        return $query->get()->row_array();
        /* (IFNULL((SELECT MAX(CAST(SUBSTRING_INDEX(f.fac_numero_control,'-',-1) AS UNSIGNED)) FROM fac_factura AS f WHERE YEAR(f.fac_fecha_fact) = $year 
            AND f.fac_id_tif = x.fac_id_tif), 0) + 1) AS control_correlativo, ((SELECT COUNT(dpv_id) FROM dpv_documento_proveedor WHERE YEAR(dpv_fecha_documento) = $year AND dpv_numero_control IS NOT NULL) + (SELECT COUNT(f.fac_id) FROM fac_factura AS f WHERE YEAR(f.fac_fecha_fact) = $year AND f.fac_numero_control IS NOT NULL) + 1) AS corr_anual */
    }
    public function datos_numero_control_compras($dpv_id){
        $year = date("Y");///AND f.fac_numero_control != '' 
        $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $caja_param = $this->gsatelite->get_parametro_emp('SYS_CAJA_FACTURACION_ELECTRONICA_MIGRADAS', 0);
        $ccfe = $tipo_factura["CREDITO FISCAL"];
        $fsee = $tipo_factura["SUJETO EXCLUIDO"];
        $query = $this->db->select("IFNULL(tif_codigo_fact_elect, (CASE dpv_id_tif WHEN 'DONACION' THEN '15' WHEN $fsee THEN '14' WHEN 'EXPORTA' THEN '11' WHEN 'COMP.LIQUIDACION' THEN '08' WHEN 'N.DE.CREDITO' THEN '05' WHEN 'REMISION' THEN '04' WHEN 'C.RETENCION' THEN '07' /*N.DE.CREDITO*/ WHEN 'N.DEBITO' THEN '06' WHEN 'D.C.LIQUIDA' THEN '09' /*N.DE.CREDITO*/ WHEN $ccfe THEN '03' ELSE '01' /*FACT*/ END) ) AS tipo_documento,
            IF($caja_param > 0, (SELECT suc_codigo_fact_elect FROM caj_caja JOIN suc_sucursal ON suc_id = caj_id_suc WHERE caj_id = $caja_param), (SELECT suc_codigo_fact_elect FROM suc_sucursal ORDER BY suc_id ASC LIMIT 1)) AS suc_codigo_fact_elect,
            IF($caja_param > 0, (SELECT suc_codigo FROM caj_caja JOIN suc_sucursal ON suc_id = caj_id_suc WHERE caj_id = $caja_param), (SELECT suc_codigo FROM suc_sucursal ORDER BY suc_id ASC LIMIT 1)) AS suc_codigo,
            IF($caja_param > 0, $caja_param, (SELECT caj_id FROM cxj_correlativoxcaja JOIN caj_caja ON caj_id = cxj_id_caj JOIN cof_correlativo_factura ON cof_id = cxj_id_cof JOIN sef_serie_factura ON sef_id = cof_id_sef WHERE cxj_estado = 1 AND cof_estado = 1 AND caj_estado = 1 AND sef_estado = 1 AND cxj_fin < 0 AND sef_id_tif = $fsee ORDER BY caj_id LIMIT 1)) AS caj_id,
            IF($caja_param > 0, (SELECT caj_codigo_fact_elect FROM caj_caja WHERE caj_id = $caja_param), (SELECT caj_codigo_fact_elect FROM cxj_correlativoxcaja JOIN caj_caja ON caj_id = cxj_id_caj JOIN cof_correlativo_factura ON cof_id = cxj_id_cof JOIN sef_serie_factura ON sef_id = cof_id_sef WHERE cxj_estado = 1 AND cof_estado = 1 AND caj_estado = 1 AND sef_estado = 1 AND cxj_fin < 0 AND sef_id_tif = $fsee ORDER BY caj_id LIMIT 1)) AS caj_codigo_fact_elect,
            (IFNULL((SELECT MAX(CAST(SUBSTRING_INDEX(f.dpv_numero_control,'-',-1) AS UNSIGNED)) FROM dpv_documento_proveedor AS f WHERE YEAR(f.dpv_fecha_documento) = $year 
            AND f.dpv_id_tif = tif_id), 0) + 1) as corr_anual,
            ((SELECT COUNT(dpv_id) FROM dpv_documento_proveedor WHERE YEAR(dpv_fecha_documento) = $year AND dpv_numero_control IS NOT NULL) + 
                (SELECT COUNT(fac_id) FROM fac_factura WHERE YEAR(fac_fecha_fact) = $year AND fac_numero_control IS NOT NULL) + 1) AS corr_anualViejo"
            , false)
            ->from('dpv_documento_proveedor')
            ->join('tif_tipo_factura', 'tif_id = dpv_id_tif')
            ->where('dpv_id', $dpv_id)
        ;
        return $query->get()->row_array();
    }
    public function get_fact_dte($fac_id){
        $rnt = $this->gsatelite->get_parametro('SYS_RENTA');
        $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
        $query = $this->db->select("*, (SELECT txc_numero FROM txc_telefonoxcliente WHERE txc_id_cli = cli_id ORDER BY txc_id DESC LIMIT 1)  AS telefono,
            (SELECT GROUP_CONCAT(DISTINCT con_email SEPARATOR ', ') FROM con_contacto WHERE TRIM(con_email) != '' AND con_id_cli = cli_id) AS mail_adic,
            (SELECT tde_codigo_fact_elect FROM dcc_documento_cliente JOIN tde_tipo_documento ON tde_id = dcc_id_tde WHERE dcc_estado = 1 AND dcc_id_tde = $nit 
                AND dcc_id_cli = cli_id LIMIT 1) AS code_tipo_doc_nit,
            (SELECT tde_codigo_fact_elect FROM dcc_documento_cliente JOIN tde_tipo_documento ON tde_id = dcc_id_tde WHERE dcc_estado = 1 AND dcc_id_tde = $dui 
                AND dcc_id_cli = cli_id LIMIT 1) AS code_tipo_doc_dui, (SELECT suc_codigo_fact_elect FROM suc_sucursal WHERE suc_id = fac_id_suc) AS suc_codeMH,
            (SELECT tpg_nombre FROM tpg_tipo_pago WHERE tpg_id = fac_id_tpg) AS tipo_pago, (SELECT suc_nombre FROM suc_sucursal WHERE suc_id = fac_id_suc) AS suc_nombre,
            IFNULL((SELECT SUM(rxf_monto) FROM rxf_retencionxdetalle_factura JOIN def_detalle_fact ON def_id = rxf_id_def JOIN ret_retencion ON ret_id = rxf_id_ret 
                WHERE ret_estado = 1 AND rxf_estado = 1 AND ret_porcentaje = $rnt AND def_id_fac = fac_id), 0) AS ret10renta,
            (SELECT ven_codigo FROM ven_vendedor WHERE ven_id = fac_id_ven) AS ven_codigo,
            (SELECT caj_codigo_fact_elect FROM uxc_usuarioxcaja JOIN caj_caja ON caj_id = uxc_id_caj WHERE uxc_id = fac_id_uxc) AS caj_codeMH,
            (SELECT caj_id FROM uxc_usuarioxcaja JOIN caj_caja ON caj_id = uxc_id_caj WHERE uxc_id = fac_id_uxc) AS caja_id,
            (SELECT dcc_valor FROM dcc_documento_cliente WHERE dcc_estado = 1 AND dcc_id_tde = $nit AND dcc_id_cli = cli_id LIMIT 1) AS cli_nit, 
            (SELECT dcc_valor FROM dcc_documento_cliente WHERE dcc_estado = 1 AND dcc_id_tde = $dui AND dcc_id_cli = cli_id LIMIT 1) AS cli_dui", false)
            ->from('fac_factura')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->join('mun_municipio', 'mun_id = cli_id_mun', 'left')
            ->join('dep_departamento', 'dep_id = mun_id_dep', 'left')
            ->join('dis_distrito', 'dis_id = cli_id_dis', 'left')
            ->join('gir_giro', 'gir_id = cli_id_gir', 'left')
            ->join('pai_pais', 'pai_id = cli_id_pai', 'left')
            ->where('fac_id', $fac_id)
        ;
        return $query->get()->result_array();
    }
    public function get_doc_dte_compra($dpv_id){
        $iva = $this->gsatelite->get_parametro('SYS_IVA');
        $rnt = $this->gsatelite->get_parametro('SYS_RENTA');
        $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
        $nrc = $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NRC_PROVEEDOR');
        $query = $this->db->select("*, (SELECT dcp_valor FROM dcp_documento_proveedor WHERE dcp_id_tde = $nit AND dcp_id_prv = prv_id AND dcp_estado = 1 LIMIT 1) AS prv_nit,
            (SELECT dcp_valor FROM dcp_documento_proveedor WHERE dcp_id_tde = $dui AND dcp_id_prv = prv_id  AND dcp_estado = 1 LIMIT 1) AS prv_dui, 
            (SELECT dcp_valor FROM dcp_documento_proveedor WHERE dcp_id_tde = $nrc AND dcp_id_prv = prv_id  AND dcp_estado = 1 LIMIT 1) AS prv_registro, 
            (SELECT tde_codigo_fact_elect FROM tde_tipo_documento WHERE tde_id = $nit) AS cod_tde_nit, 
            (SELECT tde_codigo_fact_elect FROM tde_tipo_documento WHERE tde_id = $dui) AS cod_tde_dui,
            (SELECT tpg_codigo_fact_elect FROM tpg_tipo_pago WHERE tpg_id = dpv_id_tpg) AS condicion_operacion,
            (SELECT tep_numero FROM tep_telefono_proveedor WHERE tep_estado = 1 AND tep_id_prv = prv_id ORDER BY tep_id DESC LIMIT 1) AS telefono, 
            (SELECT cpd_correo FROM cpd_correo_proveedor WHERE cpd_id_prv = prv_id AND cpd_estado = 1 ORDER BY cpd_id DESC LIMIT 1) AS correo,
            (IFNULL((SELECT SUM(rxd_monto) FROM rxd_retencionxdetalle_documento JOIN dxd_detalle_documento_proveedor ON dxd_id = rxd_id_dxd  JOIN ret_retencion ON ret_id = rxd_id_ret 
                WHERE ret_estado = 1 AND rxd_estado = 1 AND dxd_id_dpv = dpv_id AND ret_porcentaje = $iva AND ret_codigo_fact_elect = 'C4' ORDER BY ret_id LIMIT 1), 0)) AS iva_retenido,
            (IFNULL((SELECT SUM(rxd_monto) FROM rxd_retencionxdetalle_documento JOIN dxd_detalle_documento_proveedor ON dxd_id = rxd_id_dxd  JOIN ret_retencion ON ret_id = rxd_id_ret 
                WHERE ret_estado = 1 AND rxd_estado = 1 AND dxd_id_dpv = dpv_id AND ret_porcentaje = $rnt  ORDER BY ret_id LIMIT 1), 0)) AS retenido_renta10
            ", false)
            ->from('dpv_documento_proveedor')
            ->join('prv_proveedor', 'prv_id = dpv_id_prv')
            ->join('mun_municipio', 'mun_id = prv_id_mun', 'left')
            ->join('dep_departamento', 'dep_id = mun_id_dep', 'left')
            ->join('gir_giro', 'gir_id = prv_id_gir', 'left')
            ->where('dpv_id', $dpv_id)
        ;
        return $query->get()->result_array();
    }
    public function get_empresa_dte($emr_id){
        $query = $this->db->select()
        ->from('emr_empresa')
        ->join('gir_giro', 'gir_id = emr_id_gir', 'left')
        ->join('mun_municipio', 'mun_id = emr_id_mun', 'left')
        ->join('dep_departamento', 'dep_id = mun_id_dep', 'left')
        ->where('emr_id', $emr_id)
        ;
        return $query->get()->result_array();
    }
    public function get_cuerpo_dte($fac_id){
        $ivaId = $this->gsatelite->get_parametro('SYS_ID_IVA');
        $query = $this->db->select("def_cantidad, art_codigo, def_descripcion, mep_codigo, def_precio, def_descuento, def_impuesto, def_retencion, def_id_tpv,
            IF(((SELECT COUNT(DISTINCT imp_id) FROM ixf_impuestoxfactura JOIN imp_impuesto ON imp_id = ixf_id_imp WHERE ixf_id_def = def_id) = 1  AND 
                (SELECT DISTINCT imp_id FROM ixf_impuestoxfactura JOIN imp_impuesto ON imp_id = ixf_id_imp WHERE ixf_id_def = def_id) = $ivaId), 1, 0) AS solo_iva,
            ((def_subtotal + def_descuento + def_impuesto) / def_cantidad) AS precio_iva,
            CASE WHEN art_tipo > 0 THEN '99' ELSE IFNULL(mep_cogigo_fact_elect, '99') END AS code_uni_medi,
            CASE art_tipo WHEN 0 THEN '1' WHEN 1 THEN '2' ELSE '3' END AS code_art_tipo", false)
            ->from('def_detalle_fact')
            ->join('art_articulo', 'art_id = def_id_art')
            ->join('cva_conversion_articulo', 'cva_id = def_id_cva')
            ->join('mep_medida_producto', 'mep_id= cva_id_mep')
            ->where('def_id_fac', $fac_id)
        ;
        return $query->get()->result_array();
    }
    public function get_cuerpo_dte_compra($dpv_id){
        $query = $this->db->select("dxd_cantidad, art_codigo, IF(dxd_descripcion != '', dxd_descripcion, art_nombre) AS dxd_descripcion, mep_codigo, dxd_precio_unitario,
            dxd_impuesto, dxd_descuento, dxd_retencion, CASE art_tipo WHEN 0 THEN '1' WHEN 1 THEN '2' ELSE '3' END AS code_art_tipo, dxd_total, dxd_subtotal,
            CASE WHEN art_tipo > 0 THEN '99' ELSE IFNULL(mep_cogigo_fact_elect, '99') END AS code_uni_medi"
            , false)
            ->from('dxd_detalle_documento_proveedor')
            ->join('art_articulo', 'art_id = dxd_id_art')
            ->join('cva_conversion_articulo', 'cva_id = dxd_id_cva')
            ->join('mep_medida_producto', 'mep_id= cva_id_mep')
            ->where('dxd_id_dpv', $dpv_id)
        ;
        return $query->get()->result_array();
    }
    public function get_dtes_pdtes($where = null, $limit = 0){
        $query = $this->db->select("fac_id, tif_nombre, fac_numero, fac_numero_control, fac_total, fac_fecha_fact, fac_total_retencion, fac_observaciones_factura_electronica,
            CASE  WHEN fac_estado = 0 THEN 'Anulada' ELSE 'Activa' END AS estado, fac_numero_electronico_interno, fac_codigo_generacion, fac_sello_recepcion,
            IF(cli_personeria > 1, cli_apellido, CONCAT_WS(' ',cli_nombre,cli_apellido)) AS cliente_name, cli_codigo, fac_referencia_externa", false)
            ->from('fac_factura')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->join('tif_tipo_factura', 'tif_id = fac_id_tif')
        ;
        if ($where) {
            $this->db->where($where);
        }
        if ($limit == 0) {
            $this->db->limit(5000);///100 limite
        }
        return $query->get()->result_array();
        // $query = "SELECT fac_observaciones_factura_electronica as observacion , count(*) as total from fac_factura where fac_fecha_fact>='20240501' and fac_fecha_fact<='20240530' GROUP BY fac_observaciones_factura_electronica;"; $result = $this->db->query($query); return $result->result_array();
    }
    public function get_sjexc_pdtes($where = null){
        $query = $this->db->select("dpv_id, tif_nombre, dpv_numero_documento, dpv_fecha_documento, dpv_total, dpv_codigo_generacion, dpv_observaciones_factura_electronica,
            CASE  WHEN dpv_estado = 0 THEN 'Anulada' ELSE 'Activa' END AS estado, dpv_numero_electronico_interno, dpv_numero_control,
            IF(prv_tipo_pers > 1, prv_apellido, CONCAT_WS(' ',prv_nombre,prv_apellido)) AS cliente_name", false)
            ->from('dpv_documento_proveedor')
            ->join('prv_proveedor', 'prv_id = dpv_id_prv')
            ->join('tif_tipo_factura', 'tif_id = dpv_id_tif')
        ;
        if ($where) {
            $this->db->where($where);
        }
        $this->db->limit(100);///100 limite
        return $query->get()->result_array();
    }
    public function get_comp_ret_pdtes($where = null){
        $query = $this->db->select("cre_id, dpv_id, tif_nombre, dpv_numero_documento, dpv_fecha_documento, dpv_total, dpv_observaciones_factura_electronica,
            CASE  WHEN cre_estado = 0 THEN 'Anulado' ELSE 'Activo' END AS estado, cre_numero_electronico_interno,
            IF(prv_tipo_pers > 1, prv_apellido, CONCAT_WS(' ',prv_nombre,prv_apellido)) AS cliente_name", false)
            ->from('cre_comprobante_retencion')
            ->join('dpv_documento_proveedor', 'dpv_id = cre_id_dpv')
            ->join('prv_proveedor', 'prv_id = dpv_id_prv')
            ->join('tif_tipo_factura', 'tif_id = dpv_id_tif')
        ;
        if ($where) {
            $this->db->where($where);
        }
        $this->db->limit(100);///100 limite
        return $query->get()->result_array();
    }
    public function get_json_conct($wherein){
        $query = $this->db->select("fac_sello_recepcion, fac_json_factura_electronica")
            ->from('fac_factura')
            ->where_in('fac_id', $wherein)
        ;
        $json_array = array();
        $tabla = $query->get()->result_array();
        foreach ($tabla as $key => $value) {
            if ((!($value['fac_sello_recepcion'] != "")) && trim($value['fac_json_factura_electronica']) != "") {
                $json_array[] = json_decode($value["fac_json_factura_electronica"], true);
            }
        }
        return $json_array;
    }
    public function get_ref_imt_actuales($ini = null, $fin = null){
        $query = $this->db->select("DISTINCT fac_referencia_externa", false)
            ->from("fac_factura")
            ->where("fac_referencia_externa IS NOT NULL")
        ;
        if ($ini && $fin) {
            $i = formatear_fecha('Y-m-d', $ini);
            $f = formatear_fecha('Y-m-d', $fin);
            $this->db->where("DATE(fac_fecha_cont) BETWEEN '$i' AND '$f'");
        }
        return $query->get()->result_array();
    }
    public function get_datos_envio_masv($wherein){
        $query = $this->db->select('fac_id, fac_codigo_generacion, cli_codigo, tif_codigo_fact_elect')
            ->from('fac_factura')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->join('tif_tipo_factura', 'tif_id = fac_id_tif')
            ->where_in('fac_id', $wherein)
            ->where('fac_sello_recepcion IS NULL')
        ;
        return $query->get()->result_array();
    }

    public function get_act_eco($codigo = null){
        $query = $this->db->select()
            ->from('gir_giro')
            ->where('gir_codigo',$codigo)
            ->limit(1)
            ->order_by('gir_id', 'ASC')
        ;
        $giros = $query->get()->result_array();
        return (count($giros) > 0) ? $giros[0]['gir_id'] : null;
    }
    public function get_pais($codigo = null){
        $query = $this->db->select()
            ->from('pai_pais')
            ->where('pai_codigo', $codigo)
            ->limit(1)
            ->order_by('pai_id', 'ASC')
        ;
        $pais = $query->get()->result_array();
        return (count($pais) > 0) ? $pais[0]['pai_id'] : null;
    }
    public function get_municipio($departamento = null, $municipio = null){
        $query = $this->db->select("mun_id, dep_id, mun_nombre, dep_nombre")
            ->from('mun_municipio')
            ->join('dep_departamento', 'dep_id = mun_id_dep')
            ->where('dep_codigo_fact_elect', $departamento)
            ->where('mun_codigo_fact_elect', $municipio)
            ->limit(1)
            ->order_by('mun_id', 'ASC')
        ;
        $municipio = $query->get()->result_array();
        return (count($municipio) > 0) ? $municipio[0]['mun_id'] : null;
    }
    public function get_municipio_importar($departamento = null, $municipio = null){
        $query = $this->db->select("mun_id, dep_id, mun_nombre, dep_nombre")
            ->from('mun_municipio')
            ->join('dep_departamento', 'dep_id = mun_id_dep')
            ->where('dep_codigo', $departamento)
            ->where('mun_codigo', $municipio)
            ->where('dep_estado', 1)
            ->where('mun_estado', 1)
            ->limit(1)
            ->order_by('mun_id', 'ASC')
        ;
        $municipio = $query->get()->result_array();
        return (count($municipio) > 0) ? $municipio[0]['mun_id'] : null;
    }
    public function get_distrito_importar($municipio = null, $codigo = null){
        if ($municipio) {
            $query = $this->db->select("dis_id, dis_nombre")
                ->from('dis_distrito')
                ->where('dis_id_mun', $municipio)
                ->where('dis_codigo', $codigo)
                ->where('dis_estado', 1)            
                ->limit(1)
                ->order_by('dis_id', 'ASC')
            ;
            $distrito = $query->get()->result_array();
            return (count($distrito) > 0) ? $distrito[0]['dis_id'] : null;
        } else {
            return null;
        }        
    }
    public function get_tipo_doc($codigo = null){
        $query = $this->db->select()
            ->from("tde_tipo_documento")
            ->where('tde_codigo_fact_elect', $codigo)
            ->limit(1)
            ->order_by('tde_id', 'ASC')
        ;
        $tipo = $query->get()->result_array();
        return (count($tipo) > 0) ? $tipo[0]['tde_id'] : null;
    }
    public function get_tipo_doc_importar($codigo = null){
        $query = $this->db->select()
            ->from("tde_tipo_documento")
            ->where('tde_estado', 1)
            ->where('tde_codigo', $codigo)
            ->order_by('tde_id', 'ASC')
            ->limit(1)
        ;
        $tipo = $query->get()->result_array();
        return (count($tipo) > 0) ? $tipo[0]['tde_id'] : 6;//ID DE "OTROS" //NEED A PARAMETRO?
    }
    public function get_cof_elect($tifid = null, $where = null){
        if ($tifid) {
            $query = $this->db->select("cof_id, cxj_id_caj, sef_id, sef_id_tif")
                ->from("cxj_correlativoxcaja")
                ->join("cof_correlativo_factura", "cof_id = cxj_id_cof")
                ->join("sef_serie_factura", "sef_id = cof_id_sef")
                ->join("caj_caja", "caj_id = cxj_id_caj")
                ->where("cxj_estado", 1)
                ->where("cof_estado", 1)
                ->where("sef_estado", 1)
                ->where("cxj_fin < ", 0)
                ->where("cof_fin < ", 0)
                ->where("sef_id_tif", $tifid)
                ->order_by("cxj_id_caj", "ASC")
                ->order_by("cof_id", "DESC")
            ;
            if ($where) {
                $this->db->where($where);
            }
            $correlativos = $query->get()->result_array();
            return (count($correlativos) > 0) ? $correlativos[0] : null;
        } else {
            return null;
        }        
    }
    public function get_uxc_elect($cajid = null){
        if ($cajid) {
            $query = $this->db->select()
                ->from('uxc_usuarioxcaja')
                ->where("uxc_estado", 1)
                ->where("uxc_tipo", 1)
                ->where("uxc_id_caj", $cajid)
                ->order_by('uxc_id', 'DESC')
            ;
            $cortes = $query->get()->result_array();
            return (count($cortes) > 0) ? $cortes[0]['uxc_id'] : null;
        } else {
            return null;
        }        
    }
    public function get_suc_code_json($facturas = null){
        $facturas = ($facturas) ? $facturas : 0;
        $query = $this->db->select("DISTINCT suc_codigo_fact_elect", false)
            ->from("fac_factura")
            ->join("suc_sucursal", "suc_id = fac_id_suc")
            ->where("fac_id IN ($facturas)")
            ->limit(1)
        ;
        $sucursal = $query->get()->result_array();
        return (count($sucursal) > 0) ? $sucursal[0]['suc_codigo_fact_elect'] : null;
    }
    public function get_suc_code_json_compras($caja = null){
        $query = $this->db->select("DISTINCT suc_codigo_fact_elect", false)
            ->from("caj_caja")
            ->join("suc_sucursal", "suc_id = caj_id_suc")
            ->where("caj_id", $caja)
        ;
        $sucursal = $query->get()->result_array();
        return (count($sucursal) > 0) ? $sucursal[0]['suc_codigo_fact_elect'] : null;
    }
    public function correos_factelect($where = null){
        $this->db->select("fac_id, fac_codigo_generacion")
            ->from('fac_factura')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->where("fac_estado > ", 0)
            ->where("fac_transmitida_correo", 0)
            ->where("fac_sello_recepcion != ''")
            ->where("cli_email != ''")
            ->where("fac_tipo_facturacion", 1)
            ->where("cli_email LIKE '%@%'")
            ->where("fac_json_factura_electronica NOT LIKE '%N@GMAIL.COM%' ")
            ->order_by("fac_id DESC")
            ->limit(1000)
        ;
        return $this->db->get()->result_array();
    }
    /**/

    function get_productos_factura($where = null) {
        /* SELECT
         * ,
          (
          SELECT GROUP_CONCAT(ret_porcentaje) FROM ret_retencion
          INNER JOIN rxf_retencionxdetalle_factura ON rxf_id_ret = ret_id
          WHERE rxf_id_def = def_id AND ISNULL(rxf_aplicado)
          ) as porcentaje
          FROM def_detalle_fact
          INNER JOIN art_articulo on art_id = def_id_art
          INNER JOIN cva_conversion_articulo on cva_id = def_id_cva
          INNER JOIN mep_medida_producto on mep_id = cva_id_mep
          where def_id_fac = 11058 */
        $query = $this->db->select('*,
      (
          SELECT GROUP_CONCAT(ret_porcentaje) FROM ret_retencion
            INNER JOIN rxf_retencionxdetalle_factura ON rxf_id_ret = ret_id
            WHERE rxf_id_def = def_id AND ISNULL(rxf_aplicado)
      ) as porcentaje', false)
                ->from('def_detalle_fact')
                ->join('art_articulo', 'art_id = def_id_art')
                ->join('cva_conversion_articulo', 'cva_id = def_id_cva')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep ')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_anticipos($where = null) {
        $query = $this->db->select()
                ->from('anl_anticipo_cliente')
                ->join('cli_cliente', 'cli_id = anl_id_cli', 'inner')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_factura_ven($where = null) {
        /*
          SELECT
         * ,

          (SELECT GROUP_CONCAT(art_nombre) FROM def_detalle_fact
          INNER JOIN art_articulo ON art_id = def_id_art
          WHERE def_id_fac = fac_id
          GROUP BY def_id_fac) as productos
          FROM
          fac_factura
          LEFT JOIN pxf_personalxfactura ON pxf_id_fac = fac_id
          INNER JOIN emp_empleado ON emp_id = pxf_id_emp
          INNER JOIN plz_plaza ON plz_id = emp_id_plz
          inner JOIN pto_puesto ON pto_id = plz_id_pto
          WHERE fac_id = 11059

         */
        $query = $this->db->select('*, (SELECT GROUP_CONCAT(art_nombre) FROM def_detalle_fact
      INNER JOIN art_articulo ON art_id = def_id_art
      WHERE def_id_fac = fac_id
      GROUP BY def_id_fac) as productos', false)
                ->from('fac_factura')
                ->join('pxf_personalxfactura', 'pxf_id_fac = fac_id', 'left')
                ->join('emp_empleado', 'emp_id = pxf_id_emp', 'inner')
                ->join('plz_plaza', 'plz_id = emp_id_plz', 'inner')
                ->join('pto_puesto', 'pto_id = plz_id_pto', 'inner')
                ->order_by('pto_nombre', 'asc')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_comprobantes_factura($where = null, $group = null) {
        /*
          SELECT *,
          (SELECT
          CONCAT_WS("+",
          GROUP_CONCAT(rxf_id_ret),
          GROUP_CONCAT(ret_nombre)
          )
          FROM rxf_retencionxdetalle_factura
          INNER JOIN ret_retencion ON ret_id = rxf_id_ret
          WHERE rxf_id_def = def_id AND rxf_jd_cmr = cmr_id
          GROUP BY rxf_id_def) as retenciones
          FROM
          cmr_comprobante_retencion
          INNER JOIN rxf_retencionxdetalle_factura ON rxf_id_cmr = cmr_id
          INNER JOIN def_detalle_fact ON def_id = rxf_id_def
          WHERE def_id_fac = 11059
          GROUP BY cmr_id, def_id
         */
        $query = $this->db->select('*,
      (SELECT
          CONCAT_WS("+",
            GROUP_CONCAT(rxf_id_ret),
            GROUP_CONCAT(ret_nombre),
            SUM(ret_porcentaje),
            GROUP_CONCAT(ret_porcentaje)
          )
      FROM rxf_retencionxdetalle_factura
      INNER JOIN ret_retencion ON ret_id = rxf_id_ret
      WHERE rxf_id_def = def_id AND rxf_id_cmr = cmr_id
      GROUP BY rxf_id_def) as retenciones', false)
                ->from('cmr_comprobante_retencion')
                ->join('rxf_retencionxdetalle_factura', 'rxf_id_cmr = cmr_id', 'inner')
                ->join('def_detalle_fact', 'def_id = rxf_id_def', 'inner')
                ->join('art_articulo', 'art_id = def_id_art', 'inner')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($group != null) {
            $this->db->group_by($group);
        }
        return $query->get()->result_array();
    }

    function get_factura_acumulado($where = null, $group_by = null, $order_by = null, $fecha_inicio = null) {
        /*
          SELECT
          are_nombre,
          fac_id as facturacion_id,
          art_nombre,
          art_id_tia,
          (
          SELECT GROUP_CONCAT(tpg_nombre)
          FROM tpg_tipo_pago
          INNER JOIN fac_factura ON fac_id_tpg = tpg_id
          WHERE fac_id = facturacion_id
          ) as detalles_pago,
          (def_subtotal+def_impuesto-def_descuento) as monto_total_producto
          FROM
          fac_factura
          INNER JOIN def_detalle_fact ON def_id_fac = fac_id
          INNER JOIN art_articulo ON art_id = def_id_art
          LEFT JOIN are_area ON are_id = fac_id_are
          INNER JOIN tia_tipo_articulo ON tia_id = art_id_tia
         */
        /* $where_filtro = '';
          if($fecha_inicio != null){
          $where_filtro = 'and fac_fecha_fact = '$fecha_inicio;
          } */

        /*
          SELECT
          are_nombre,
          fac_fecha_fact,
          fac_id as facturacion_id,
          art_nombre,
          art_id_tia,
          tia_nombre,
          (
          SELECT GROUP_CONCAT(tpg_nombre)
          FROM tpg_tipo_pago
          INNER JOIN fac_factura ON fac_id_tpg = tpg_id
          WHERE fac_id = facturacion_id
          ) as detalles_pago,
          (def_subtotal+def_impuesto-def_descuento) as monto_total_producto
          FROM
          fac_factura
          INNER JOIN def_detalle_fact ON def_id_fac = fac_id
          INNER JOIN art_articulo ON art_id = def_id_art
          LEFT JOIN are_area ON are_id = fac_id_are
          INNER JOIN tia_tipo_articulo ON tia_id = art_id_tia


         */

        $query = $this->db->select('*, fac_id as facturacion_id, 
            (SELECT GROUP_CONCAT(tpg_nombre) FROM tpg_tipo_pago INNER JOIN fac_factura ON fac_id_tpg = tpg_id WHERE fac_id = facturacion_id) AS detalles_pago,
            (SELECT tpg_nombre FROM tpg_tipo_pago WHERE fac_id_tpg = tpg_id) AS tipo_pago, SUM((def_subtotal - def_descuento)) AS subtotal, SUM(def_impuesto) AS impuestos,
            (def_subtotal+def_impuesto-def_descuento) as monto_total_producto', false)
            ->from('fac_factura')
            ->join('def_detalle_fact', 'def_id_fac = fac_id', 'inner')
            ->join('art_articulo', 'art_id = def_id_art', 'inner')
            //->join('are_area', 'are_id = fac_id_are', 'left')
            ->join('arf_area_factura', 'arf_id = fac_id_arf', 'left')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia', 'left')
        //->order_by('are_nombre, art_id_tia','asc')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($group_by != null) {
            $this->db->group_by($group_by);
        }
        if ($order_by != null) {
            $this->db->order_by($order_by, 'ASC');
        }
        return $query->get()->result_array();
    }

    function get_cobrador($where = null) {
        $query = $this->db->select()
                ->from('cob_cobrador')
                ->join('emp_empleado', 'emp_id = cob_id_emp', 'left')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_detalle_abono($where = null,$group_by = null) {
        /* SELECT
          cli_nombre,
          abc_monto,
          DATE_FORMAT(abc_fecha, '%d-%m-%Y') as fecha_abono,
          CONCAT_WS("",ven_codigo, ven_nombre) as vendedor,
          abc_comprobante,
          tif_abreviacion,
          CONCAT_WS("-",cxj_inicio, cxj_fin) as correlativo,
          abf_monto,
          fac_monto_pendiente
          FROM
          abc_abono_cliente
          INNER JOIN cli_cliente ON cli_id = abc_id_cli
          INNER JOIN abf_abono_factura ON abf_id_abc = abc_id
          INNER JOIN fac_factura ON fac_id = abf_id_fac
          INNER JOIN ven_vendedor ON ven_id = fac_id_ven
          INNER JOIN cxj_correlativoxcaja ON cxj_id_cof = fac_id_cof
          INNER JOIN tif_tipo_factura ON tif_id = fac_id_tif */
        $query = $this->db->select("abc_id, cli_nombre,cli_apellido,cli_personeria, abf_pendiente_factura, cli_id, abc_monto, fac_total_retencion,
            CONCAT_WS(' ',cli_nombre,cli_apellido) as nombre_completo,
            (SELECT GROUP_CONCAT(fac_numero) FROM abf_abono_factura JOIN fac_factura ON fac_id = abf_id_fac WHERE abf_id_abc = abc_id) AS facturas,
            DATE_FORMAT(abc_fecha, '%Y-%m-%d') as fecha_abono, CONCAT_WS(' ',ven_nombre, ven_apellidos) as vendedor,
            abc_comprobante, tif_abreviacion, sef_nombre, fac_numero, abf_monto, SUM(abf_monto) AS total_abono,
            fac_id_tpg,
            tpg_nombre,
            fac_monto_pendiente, cob_codigo AS codigo_cobrador", false)
                ->from('abc_abono_cliente')
                ->join('cli_cliente', 'cli_id = abc_id_cli', 'inner')
                ->join('abf_abono_factura', 'abf_id_abc = abc_id', 'inner')
                ->join('fac_factura', 'fac_id = abf_id_fac', 'inner')
                ->join('ven_vendedor', 'ven_id = fac_id_ven', 'left')
                ->join('cof_correlativo_factura', 'cof_id = fac_id_cof', 'inner')
                ->join('sef_serie_factura', 'sef_id = cof_id_sef', 'inner')
                // ->join('cxj_correlativoxcaja', 'cxj_id_cof = cof_id', 'inner')
                ->join('tif_tipo_factura', 'tif_id = fac_id_tif', 'inner')
                ->join('tpg_tipo_pago', 'tpg_id = fac_id_tpg', 'left')
                ->join('cob_cobrador', 'cob_id = abc_id_cob', 'left')
                // ->join('emp_empleado', 'emp_id = cob_id_emp', 'left')
                ->order_by('cli_nombre, cli_id, fac_id ASC, abf_pendiente_factura DESC')
                ->where('abc_estado > 0')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        if ($group_by !== null) {
            $this->db->group_by($group_by);
        }
        return $query->get()->result_array();
    }

    function get_detalle_por_abono($where = null) {
        /*
          select * from dab_detalle_abono
          INNER JOIN tpg_tipo_pago ON tpg_id = dab_id_tpg
         */
        $query = $this->db->select()
                ->from('dab_detalle_abono')
                ->join('tpg_tipo_pago', 'tpg_id = dab_id_tpg')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_facturas_proximas_vencer($where = null) {
        /*
          SELECT
         * ,
          CONCAT_WS(' ',cli_nombre,cli_apellido) as nombre_completo,
          DATE_FORMAT(fac_fecha_fact, '%Y-%m-%d') as fecha_factura,
          DATE_FORMAT(fac_fecha_vencimiento, '%Y-%m-%d') as fecha_vencimiento,
          CONCAT_WS("-",cxj_inicio, cxj_fin) as correlativo
          FROM
          fac_factura
          INNER JOIN cli_cliente ON cli_id = fac_id_cli
          INNER JOIN ven_vendedor ON ven_id = fac_id_ven
          INNER JOIN cxj_correlativoxcaja ON cxj_id_cof = fac_id_cof
          INNER JOIN tif_tipo_factura on fac_id_tif = tif_id
         */
        $query = $this->db->select("*,
  CONCAT_WS(' ',cli_nombre,cli_apellido) as nombre_completo,
  DATE_FORMAT(fac_fecha_fact, '%Y-%m-%d') as fecha_factura,
  DATE_FORMAT(fac_fecha_vencimiento, '%Y-%m-%d') as fecha_vencimiento,
  CONCAT_WS('-',cxj_inicio, cxj_fin) as correlativo", false)
                ->from('fac_factura')
                ->join('cli_cliente', 'cli_id = fac_id_cli', 'inner')
                ->join('ven_vendedor', 'ven_id = fac_id_ven', 'left')
                ->join('cxj_correlativoxcaja', 'cxj_id_cof = fac_id_cof', 'inner')
                ->join('cof_correlativo_factura', 'cof_id = cxj_id_cof', 'inner')
                ->join('sef_serie_factura', 'sef_id = cof_id_sef', 'inner')
                ->join('tif_tipo_factura', 'tif_id = fac_id_tif', 'inner')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        
        return $query->get()->result_array();
    }

    function get_productos_facturacion($where = null) {
        $query = $this->db->select("art_id, def_subtotal, def_impuesto, def_precio, def_cantidad, def_descuento, def_retencion, art_codigo, art_nombre,
            cli_codigo, cli_nombre, cli_apellido, cli_personeria, ven_nombre, ven_apellidos, ven_codigo, fac_numero, fac_fecha_fact, mep_nombre, bod_nombre")
                ->from('def_detalle_fact')
                ->join('fac_factura', 'fac_id = def_id_fac', 'inner')
                ->join('cli_cliente', 'cli_id = fac_id_cli', 'inner')
                ->join('art_articulo', 'art_id = def_id_art', 'inner')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id and cva_defecto = 1', 'inner')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
                ->join('ven_vendedor', 'ven_id = fac_id_ven', 'left')
                ->join('bod_bodega', 'bod_id = def_id_bod', 'left')
                ->order_by('art_id ASC')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_componentes_facturacion($where = null) {
        $query = $this->db->select("fac_id, cdf_descripcion, cdf_cantidad, cdf_precio, cdf_subtotal, cdf_total, cdf_altera_precio, def_descripcion, def_subtotal, 
            def_impuesto, (SELECT tif_abreviacion FROM tif_tipo_factura WHERE tif_id = fac_id_tif) AS tif_abreviacion, def_retencion, def_descuento, fac_fecha_fact, 
            fac_numero, fac_generacion_masiva, fac_numero_control, cli_personeria, fac_nombre_factura, cli_nombre, cli_apellido, art_codigo, art_nombre, mep_nombre",
            false)
            ->from('cdf_componente_detalle_factura')
            ->join('def_detalle_fact', 'def_id = cdf_id_def')
            ->join('fac_factura', 'fac_id = def_id_fac')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->join('art_articulo', 'art_id = cdf_id_art')
            ->join('cva_conversion_articulo', 'cva_id = cdf_id_cva')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep')
            ->order_by('fac_id, art_id ASC')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_facturas_detallado($where = null) {
        $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $query = $this->db->select("fac_id, tif_id, cli_id, tpg_id, uxc_id, caj_id, ven_id, fac_fecha_fact, tif_abreviacion, fac_numero, cli_codigo, cli_nombre, cli_apellido, (SELECT frp_nombre FROM frp_forma_pago WHERE frp_id = fac_id_frp) AS frp_nombre, tif_nombre,
            ven_codigo, ven_nombre, ven_apellidos, tpg_nombre, fac_subtotal, fac_descuento, fac_total_retencion, fac_impuesto, fac_total, caj_nombre,
            (SELECT dcc_valor FROM dcc_documento_cliente WHERE dcc_id_cli = fac_id_cli AND dcc_id_tde = $nit LIMIT 1) AS cli_nit", false)
                ->from('fac_factura')
                ->join('tif_tipo_factura', 'tif_id = fac_id_tif')
                ->join('cli_cliente', 'cli_id = fac_id_cli')
                ->join('tpg_tipo_pago', 'tpg_id = fac_id_tpg')
                ->join('uxc_usuarioxcaja', 'uxc_id = fac_id_uxc')
                ->join('caj_caja', 'caj_id = uxc_id_caj')
                ->join('ven_vendedor', 'ven_id = fac_id_ven', 'left')
                ->order_by('tif_id,fac_fecha_fact', 'ASC')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_anticipos_pendientes($where = null) {
        /*
          SELECT * FROM anl_anticipo_cliente
          LEFT JOIN cli_cliente ON cli_id = anl_id_cli
          LEFT JOIN tif_tipo_factura ON tif_id = anl_id_tif
         */
        $query = $this->db->select("*")
                ->from('anl_anticipo_cliente')
                ->join('cli_cliente', 'cli_id = anl_id_cli', 'left')
                ->join('tif_tipo_factura', 'tif_id = anl_id_tif', 'left')
                ->join('tpc_tipo_cliente', 'tpc_id = cli_id_tpc', 'left')
                ->order_by('tpc_id', 'asc')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_anticipos_detallado($where = null) {
        /*
          SELECT * FROM ana_anticipo_abono
          INNER JOIN abc_abono_cliente ON abc_id = ana_id_abc
          INNER JOIN abf_abono_factura ON abf_id_abc = abc_id
          INNER JOIN fac_factura ON fac_id = abf_id_fac
          INNER JOIN tif_tipo_factura as tipo_factura ON tipo_factura.tif_id = fac_id_tif
          INNER JOIN anl_anticipo_cliente ON anl_id = ana_id_anl
          LEFT JOIN cli_cliente ON cli_id = anl_id_cli
          LEFT JOIN tif_tipo_factura AS tipo_anticipo ON tipo_anticipo.tif_id = anl_id_tif
         */
        $query = $this->db->select("*, tipo_factura.tif_nombre as tif_nombre_factura, tipo_anticipo.tif_nombre as tif_nombre_anticipo")
                ->from('ana_anticipo_abono')
                ->join('abc_abono_cliente', 'abc_id = ana_id_abc', 'inner')
                ->join('abf_abono_factura', 'abf_id_abc = abc_id', 'inner')
                ->join('fac_factura', 'fac_id = abf_id_fac', 'inner')
                ->join('tif_tipo_factura AS tipo_factura', 'tipo_factura.tif_id = fac_id_tif', 'inner')
                ->join('anl_anticipo_cliente', 'anl_id = ana_id_anl', 'inner')
                ->join('cli_cliente', 'cli_id = anl_id_cli', 'left')
                ->join('tpc_tipo_cliente', 'tpc_id = cli_id_tpc', 'left')
                ->join('tif_tipo_factura AS tipo_anticipo', 'tipo_anticipo.tif_id = anl_id_tif', 'left')
                ->order_by('cli_nombre, anl_id, ana_fecha_creacion', 'asc')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /*     * **************************** DETALLE FACTURA INSCRIPCIÓN *********************************************************** */

    public function get_detalle_fac($caja = null, $fecha_inicio = null, $fecha_fn = null, $estado = null, $fac_id = null) {
        $this->db->select('caj_id, caj_nombre, fac_numero,  sef_nombre, fac_tipo, tif_nombre, DATE_FORMAT(fac_fecha_fact, ("%d-%m-%Y" )) AS fecha, fac_estado,  emp_nombre, emp_apellido, fac_total, fac_id, def_descripcion, def_cantidad, def_precio, def_impuesto, def_subtotal, tpg_nombre')
                ->from('fac_factura')
                ->join('def_detalle_fact', 'def_id_fac=fac_id')
                ->join('tpg_tipo_pago', 'def_id_tpg=tpg_id', 'left')
                ->join('cof_correlativo_factura', 'cof_id = fac_id_cof', left)
                ->join('sef_serie_factura', 'sef_id = cof_id_sef', left)
                ->join('tif_tipo_factura', 'sef_id_tif = tif_id', left)
                ->join('paf_pago_factura', 'paf_id_fac = fac_id', left)
                ->join('cxj_correlativoxcaja', 'cof_id = cxj_id_cof', left)
                ->join('caj_caja', 'caj_id  = cxj_id_caj', left)
                ->join('emp_empleado', 'fac_usu_mod = emp_id_usu', left);

        if ($caja != null) {
            $this->db->where('caj_id', $caja);
        }
        if ($fac_id != null) {
            $this->db->where('fac_id', $fac_id);
        }

        if ($estado == 10) {
            $this->db->where('fac_estado', 0);
        } elseif ($estado != null && $estado != 10) {
            $this->db->where('fac_estado', $estado);
        } else {
            $this->db->where('(fac_estado = 1 or fac_estado = 0)');
        }

        if ($fecha_inicio == null) {

        } else {
            $this->db->where('fac_fecha_fact' . ' >=', $fecha_inicio . ' 00:00:00');
        }
        if ($fecha_fn == null) {

        } else {
            $this->db->where('fac_fecha_fact' . ' <=', $fecha_fn . ' 23:59:59');
        }

        $this->db->order_by('caj_id, sef_nombre, fac_numero');

        return $this->db->get()->result_array();
    }

    public function get_factura_caja($where = null, $tipo = null){
        if($tipo != null){
            $query = $this->db->select('tif_nombre,
                MIN(cxj_inicio) as inicio,
                MAX(cxj_fin) as fin,
                GROUP_CONCAT(
                    DISTINCT 
                        IFNULL(
                            CONCAT(
                                emp_codigo,
                                " - ",
                                emp_nombre,
                                " ",
                                emp_apellido
                            ),
                            (SELECT username FROM users WHERE id = uxc_id_usu)
                    ) SEPARATOR ", "
                ) as empleados',false)
                ->from('fac_factura')
                ->join('tif_tipo_factura','tif_id = fac_id_tif','inner')
                ->join('uxc_usuarioxcaja','uxc_id = fac_id_uxc','inner')
                ->join('sef_serie_factura','sef_id_tif = tif_id','inner')
                ->join('cof_correlativo_factura','cof_id_sef = sef_id','inner')
                ->join('cxj_correlativoxcaja','cxj_id_cof = cof_id AND cxj_id_caj = uxc_id_caj','inner')
                ->join('emp_empleado','emp_id_usu = uxc_id_usu','left')
                ->where('(fac_estado = 1 OR fac_estado = 2)')
                ->group_by('tif_id')
            ;
        } else{
            $query = $this->db->select('fac_numero, tif_abreviacion, cli_codigo,
                IF(cli_personeria > 1, cli_apellido, CONCAT(cli_nombre, " ", cli_apellido)) AS nombre_cliente, 
                tif_nombre, tpg_id, tpg_nombre, IF(fac_estado = 1,"Pendiente", "Pagado") AS fac_estado_txt, fac_estado,
                fac_subtotal, fac_descuento, fac_impuesto, fac_total_retencion,
                (SELECT frp_nombre FROM frp_forma_pago WHERE frp_id = fac_id_frp) AS frp_nombre,
                (SELECT IF(SUM(def_subtotal) IS NULL, 0, SUM(def_subtotal)) FROM def_detalle_fact WHERE def_id_fac = fac_id and def_impuesto = 0) as exento,
                (
                    SELECT
                        GROUP_CONCAT(
                                CONCAT(
                                    0,
                                    "-",
                                    abf_monto,
                                    "-",
                                    if(tpg2.tpg_id is null, 0, tpg2.tpg_id),
                                    "-",
                                    if(tpg2.tpg_nombre is null, 0, tpg2.tpg_nombre),
                                    "-",
                                    if(abf_monto_entregado is null, "", abf_monto_entregado)
                                )
                            )
                        FROM abf_abono_factura
                        JOIN abc_abono_cliente ON abc_id = abf_id_abc
                        LEFT JOIN dab_detalle_abono ON dab_id_abc = abc_id
                        LEFT JOIN tpg_tipo_pago AS tpg2 ON tpg2.tpg_id = dab_id_tpg
                    WHERE abf_id_fac = fac_id AND abc_estado = 1
                ) as abonos',false)
                ->from('fac_factura')
                ->join('tpg_tipo_pago','tpg_id = fac_id_tpg','inner')
                ->join('uxc_usuarioxcaja','uxc_id = fac_id_uxc','inner')
                ->join('emp_empleado','emp_id_usu = uxc_id_usu','left')
                ->join('tif_tipo_factura','tif_id = fac_id_tif','inner')
                ->join('cli_cliente', 'fac_id_cli = cli_id', 'inner')
                ->where('(fac_estado = 1 OR fac_estado = 2)')
            ;
        }

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_detalle_clientexfactura($where = null, $array = NULL){
        /*
        SELECT
            fac_id,
        IF (
            cli_personeria = 1,
            CONCAT(
                cli_nombre,
                ' ',
                cli_apellido
            ),
            cli_apellido
        ) AS cliente,
         cli_direccion,
         mun_nombre,
         dep_nombre,
         fac_fecha_fact,
         cli_registro,
         (
            SELECT
                dcc_valor
            FROM
                dcc_documento_cliente
            WHERE
                dcc_id_cli = cli_id and dcc_id_tde = 1 or dcc_id_tde = 2
            LIMIT 1
        ) AS documento,
         gir_nombre,
         (
            SELECT
                txc_numero
            FROM
                txc_telefonoxcliente
            WHERE
                txc_id_cli = cli_id
            ORDER BY
                txc_fecha_mod ASC
            LIMIT 1
        ) AS numero,
         fac_id_tpg
        FROM
            fac_factura
        INNER JOIN cli_cliente ON cli_id = fac_id_cli
        LEFT JOIN mun_municipio ON mun_id = cli_id_mun
        LEFT JOIN dep_departamento ON dep_id = mun_id_dep
        LEFT JOIN gir_giro ON gir_id = cli_id_gir
        */

        // Datos provenientes de la frf
        $documento  = $array['documento'];
        $iva        = (isset($array['iva']))?$array['iva']:'';
        $nrc        = (isset( $array['nrc']))? $array['nrc']:'';
        $iva_percibido  = (isset( $array['iva_percibido']))? $array['iva_percibido']:'';
        $factura    = $array['factura'];
        $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
        $where_documento = '';
        if($documento == 1){
            $where_documento = 'AND dcc_id_tde = '.$nit;
        } else if($documento == 2){
            $where_documento = 'AND (dcc_id_tde = '.$dui.' OR dcc_id_tde = '.$nit.')';
        }
        $query = $this->db->select("caj_nombre, ven_nombre, ven_codigo, ord_codigo, def_retencion, scl_nombre, suc_nombre, fac_fecha_vencimiento, fac_fecha_crea,
                    fac_orden_compra, fac_observacion, fac_id, fac_numero, fac_estado, fac_fecha_cont, fac_subtotal, fac_impuesto, fac_generacion_masiva, fac_nombre_factura,
                    ven_id, arf_nombre, fac_id_fac_credito, fac_id_fac_debito, bod_nombre, IF (cli_personeria = 1, CONCAT(cli_nombre, ' ', cli_apellido), cli_apellido) AS cliente,
                    cli_direccion, cli_codigo, mun_id, mun_nombre, dep_id, dep_nombre, pai_id, pai_nombre, fac_impuesto, fac_total_retencion, fac_fecha_entrega, fac_fecha_fact, art_id_tia,
                    IFNULL(t.tia_padre, 0) AS tia_padre, t.tia_nombre, IFNULL((SELECT p.tia_nombre FROM tia_tipo_articulo AS p WHERE p.tia_id = t.tia_padre), t.tia_nombre) AS tia_padre_nom,  dis_id, dis_nombre,
                    fac_documento_cliente, fac_dui_cliente_factura, fac_nit_cliente_factura, cli_registro, fac_id_tif, fac_id_suc, fac_usu_crea, tpg_nombre,
                    (SELECT sef_nombre from cxj_correlativoxcaja JOIN cof_correlativo_factura ON cof_id = cxj_id_cof JOIN sef_serie_factura ON sef_id = cof_id_sef 
                        WHERE cof_id = fac_id_cof LIMIT 1) AS serie_fac,
                    (SELECT GROUP_CONCAT(DISTINCT txc_numero SEPARATOR '##') FROM txc_telefonoxcliente WHERE txc_estado = 1 AND txc_id_cli = cli_id) AS tel_cliente,
                    (SELECT dcc_valor FROM dcc_documento_cliente WHERE dcc_id_cli = cli_id ".$where_documento." AND dcc_estado = 1 LIMIT 1) AS documento,
                    (SELECT dcc_valor FROM dcc_documento_cliente WHERE dcc_id_cli = cli_id and dcc_id_tde = ".$dui." AND dcc_estado = 1 LIMIT 1 ) AS DUI,
                    (SELECT dcc_valor FROM dcc_documento_cliente WHERE dcc_id_cli = cli_id and dcc_id_tde = ".$nit." AND dcc_estado = 1 LIMIT 1 ) AS NIT,
                    (
                        SELECT GROUP_CONCAT(CONCAT_WS('#',ixf_id_imp,ixf_monto))
                        FROM ixf_impuestoxfactura
                        INNER JOIN imp_impuesto ON ixf_id_imp = imp_id
                        WHERE
                            ixf_id_def = def_id
                        AND ixf_estado = 1
                    ) AS IMPUESTOS,
                    (
                        SELECT GROUP_CONCAT(CONCAT_WS('#',rxf_id_ret,rxf_monto))
                        FROM rxf_retencionxdetalle_factura                       
                        WHERE
                            rxf_id_def = def_id
                        AND rxf_estado = 1
                    ) AS RETENCIONES,
                    (
                        SELECT GROUP_CONCAT(ixf_monto) FROM ixf_impuestoxfactura
                        INNER JOIN imp_impuesto ON ixf_id_imp=imp_id
                        WHERE ixf_id_def = def_id AND imp_id = ".$iva."
                    )  AS IVA,
                    (
                        SELECT GROUP_CONCAT(rxf_monto) FROM rxf_retencionxdetalle_factura
                        INNER JOIN ret_retencion ON rxf_id_ret = ret_id
                        WHERE rxf_id_def = def_id " . ((trim($iva_percibido) != '') ? 'AND ret_id = ' . $iva_percibido : '') . "
                    )  AS IVA_PERCIBIDO,
                    (
                        SELECT dcc_valor FROM dcc_documento_cliente
                        INNER JOIN tde_tipo_documento ON tde_id=dcc_id_tde
                        WHERE dcc_id_cli=cli_id AND dcc_id_tde = ".$nrc."
                        AND dcc_estado = 1
                        LIMIT 1
                    ) AS NRC, 
                    gir_nombre, cli_email, fac_id_tpg, fac_id_uxc,
                    (SELECT txc_numero FROM txc_telefonoxcliente WHERE txc_id_cli = cli_id ORDER BY txc_fecha_mod ASC LIMIT 1) AS numero,
                    (
                        SELECT
                            tpg_nombre
                        FROM
                            tpg_tipo_pago
                        WHERE
                            tpg_id = fac_id_tpg
                     ) AS tipo_pago,
                     (SELECT frp_nombre FROM frp_forma_pago WHERE frp_id = fac_id_frp
                     ) AS forma_pago,
                     def_cantidad,
                     CONCAT(art_codigo, '- ', def_descripcion) as producto,
                     art_codigo,
                     art_nombre,
                     mep_nombre,
                     mep_codigo,
                     cva_conversion,
                     cva_medida_equivalente,
                     (
                        SELECT
                            GROUP_CONCAT(
                                CONCAT(car_nombre, ':', cxd_valor)
                            )
                        FROM
                            cxd_caracteristicaxdetalle_factura
                        INNER JOIN cxu_caracxarticulo ON cxu_id = cxd_id_cxu
                        INNER JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
                        INNER JOIN car_caracteristica ON car_id = cxr_id_car
                        WHERE
                            cxd_id_def = def_id
                    ) AS caracteristica,
                    def_id,
                    def_precio,
                    def_porcentaje_descuento,
                    def_porcentaje_impuesto,
                    fac_descuento,
                    def_impuesto,
                    def_subtotal,
                    def_descuento,
                    fac_subtotal,
                    fac_total,
                    def_descripcion,
                    def_valor_formula,
                    def_id_bod,
                    def_id_art, cda_codigo, cda_descripcion,
                    (
                    SELECT
                        GROUP_CONCAT(
                            CONCAT(
                                cxd_valor,
                                '&op',
                                dxf_operador
                            )
                        )
                    FROM
                        foa_formula_articulo
                    INNER JOIN dxf_detallexformula ON dxf_id_foa = foa_id
                    INNER JOIN cxu_caracxarticulo ON cxu_id = dxf_id_cxu
                    INNER JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
                    INNER JOIN car_caracteristica ON car_id = cxr_id_car
                    LEFT JOIN cxd_caracteristicaxdetalle_factura ON cxd_id_cxu = cxu_id
                    WHERE
                        foa_id = def_id_fao and
                        cxd_id_def = def_id
                    ) AS formulas,
                    (
                    SELECT emp_codigo
                    FROM emp_empleado
                    INNER JOIN pxf_personalxfactura ON pxf_id_emp = emp_id
                    where pxf_id_fac = fac_id
                    ORDER BY pxf_id
                    LIMIT 1
                    ) AS PERSONAL,
                    (
                        SELECT
	                        SUM(ana_monto)
                        FROM
	                        ana_anticipo_abono
                        join abc_abono_cliente on abc_id = ana_id_abc
                        join abf_abono_factura on abf_id_abc = abc_id
                        where abf_id_fac = fac_id
                    ) AS anticipo,
                    CONCAT(
                        ven_nombre,
                        ' ',
                        ven_apellidos
                    ) AS vendedor,
                    (
                        SELECT
                            f.fac_numero
                        FROM
                            fac_factura AS f
                        WHERE
                            f.fac_id = ".$factura."
                    ) as devolucion, 
                    (
                        SELECT
                            f.fac_fecha_fact
                        FROM
                            fac_factura AS f
                        WHERE
                            f.fac_id = ".$factura."
                    ) as devolucion_fecha,
                    tif_nombre", false)
                ->from('fac_factura')
                ->join('def_detalle_fact','def_id_fac = fac_id','left')
                ->join('art_articulo','art_id = def_id_art','left')
                ->join('cva_conversion_articulo','cva_id = def_id_cva','left')
                ->join('mep_medida_producto','mep_id = cva_id_mep','left')
                ->join('cli_cliente','cli_id = fac_id_cli','inner')
                ->join('mun_municipio','mun_id = cli_id_mun','left')
                ->join('dep_departamento','dep_id = mun_id_dep','left')
                ->join('dis_distrito','dis_id = cli_id_dis','left')
                ->join('gir_giro','gir_id = cli_id_gir','left')
                ->join('tia_tipo_articulo AS t','t.tia_id = art_id_tia','left')
                ->join('tpg_tipo_pago','tpg_id = fac_id_tpg','left')
                ->join('ven_vendedor','ven_id = fac_id_ven','left')
                ->join('arf_area_factura','arf_id = fac_id_arf','left')
                ->join('suc_sucursal','suc_id = fac_id_suc','left')
                ->join('scl_sucursal_cliente','scl_id = fac_id_scl','left')
                ->join('ord_orden','ord_id = fac_id_ord','left')
                ->join('uxc_usuarioxcaja','uxc_id = fac_id_uxc', 'left')
                ->join('pai_pais','cli_id_pai = pai_id', 'left')
                ->join('caj_caja','caj_id = uxc_id_caj', 'left')
                ->join('bod_bodega','bod_id = def_id_bod', 'left')
                ->join('cda_codigo_arancelario','cda_id = art_id_cda', 'left')
                ->join('tif_tipo_factura','tif_id = fac_id_tif', 'left');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Francisco Orozco
     * @return devuelve una o varias facturas para impresion masiva.
     * @since 29/11/17
    */
    function get_facturas_masiva_info($correlativo_inicial = 0, $correlativo_final =0, $factura_inicial = 0,$factura_final=0,$where_in_array =null){
        $this->db->select()
            ->from('fac_factura')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->join('ven_vendedor', 'ven_id = fac_id_ven', 'left')
            ->join('gir_giro', 'gir_id = cli_id_gir', 'left')
            ->join('tif_tipo_factura','tif_id = fac_id_tif')
            ->join('tpg_tipo_pago','tpg_id = fac_id_tpg', 'left')
            ->join('mun_municipio', 'mun_id = cli_id_mun', 'left')
        ;

        $this->db->where("fac_numero BETWEEN ".$correlativo_inicial." and ".$correlativo_final, NULL, false );
        $this->db->where("fac_id BETWEEN ".$factura_inicial." and ".$factura_final, NULL, false );
        if ( $where_in_array != null){
            $this->db->where_in('fac_id',$where_in_array);
        }
        $this->db->order_by('fac_id','asc');
        return $this->db->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @return devuelve los clientes
     * @since 06/12/17
    */
    function clientes_lista_precio($where = null){
        $this->db->select('*, GROUP_CONCAT(tpn_id_tlp) as lista')
            ->from('cli_cliente')
            ->join('tpn_tipo_precio_cliente', 'tpn_id_cli = cli_id', 'left')
            ->group_by('cli_id')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @return devuelve los clientes
     * @since 14/12/17
    */
    function bodegas_cliente($where = null, $art_id = 0){
        $this->db->select("*, (
        SELECT
            CONCAT_WS('*',SUM(sar_cant_actual), GROUP_CONCAT(DISTINCT mep_id, '+', cva_conversion, '-', if(cva_defecto = 1, 1, 0)))
        FROM
            sar_saldo_articulo
        INNER JOIN art_articulo ON art_id = sar_id_art
        INNER JOIN cva_conversion_articulo ON cva_id_art = art_id
        INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
        WHERE
            sar_id_bod = bod_id
        AND art_id = ".$art_id." AND cva_estado = 1
    ) as productos", false)
            ->from('uxb_usuarioxbodega')
            ->join('bod_bodega', 'bod_id = uxb_id_bod', 'inner')
            ->join('suc_sucursal', 'suc_id = bod_id_suc', 'inner')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @return devuelve los clientes
     * @since 02/01/18
    */
    function get_detalle_orden_venta($where = null){
        $this->db->select("
            dov_id,
            art_codigo,
            dov_id_art,
            dov_descripcion,
            dov_cantidad,
            dov_precio,
            (dov_cantidad * dov_precio) AS suma,
            dov_descuento,
            dov_subtotal,
            dov_impuesto,
            dov_retencion,
            (dov_subtotal + dov_impuesto - dov_retencion) AS total,
            art_tipo,
            dov_id_tpv,
            tpv_abreviacion,
            dov_id_lip,
            lip_id_tlp,
            dov_id_cva,
            cva_id_mep,
            dov_precio_sugerido_lista,
            (
                IF (
                    dov_impuesto = 0,
                    CONCAT_WS('&#',0,0,''),
                    (
                        SELECT
                            CONCAT_WS(
                                '&#',
                                GROUP_CONCAT(ixv_porcentaje),
                                SUM(ixv_porcentaje),
                                GROUP_CONCAT(ixv_id_imp)
                            )
                        FROM
                            ixv_impuestoxorden_venta
                        WHERE
                            ixv_id_dov = dov_id
                    )
                )
            ) AS impuesto,
            (
                IF (
                    dov_retencion = 0,
                    CONCAT_WS('&#',0,0,''),
                    (
                        SELECT
                            CONCAT_WS(
                                '&#',
                                GROUP_CONCAT(rxv_porcentaje),
                                SUM(rxv_porcentaje),
                                GROUP_CONCAT(rxv_id_ret)
                            )
                        FROM
                            rxv_retencionxorden_venta
                        WHERE
                            rxv_id_dov = dov_id
                    )
                )
            ) AS retencion,
            (
                SELECT
                    GROUP_CONCAT(
                        CONCAT(
                            cva.cva_id,
                            '-',
                            cva.cva_conversion,
                            '-',
                            cva.cva_defecto
                        )
                    )
                FROM
                    cva_conversion_articulo AS cva
                WHERE
                    cva.cva_id_art = art_id
                AND cva.cva_estado = 1
            ) AS conversiones,
            dov_porcentaje_descuento,
            dov_porcentaje_impuesto,
            dov_porcentaje_retencion,
            dov_combo,
            dov_id_bod",false)
            ->from('dov_detalle_orden_venta')
            ->join('art_articulo', 'art_id = dov_id_art', 'inner')
            ->join('cva_conversion_articulo', 'cva_id = dov_id_cva', 'inner')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
            ->join('tpv_tipo_venta', 'tpv_id = dov_id_tpv', 'left')
            ->join('lip_listado_precio', 'lip_id = dov_id_lip', 'left')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    function get_productos_like($where = null, $like = null, $select_query = "*") {

        $categorias_final = null;
        if (isset($where['art_id_tia'])) {
            $categorias_final = $this->crear_arbol($where['art_id_tia'], "");
            $categorias_final = $categorias_final . $where['art_id_tia'];
            unset($where['art_id_tia']);
        }

        $query = $this->db->select($select_query,false)
                ->from('art_articulo')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia AND tia_estado = 1')   //Se agrego porque estaba filtrando productos de categorias en estado INACTIVO
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1');

                if ($select_query = "*") // si se quiere mostrar todo hacer el join con la tabla unidad de medida
                    $this->db->join('mep_medida_producto', 'mep_id = cva_id_mep');

                $this->db->join('cdp_codigo_producto', 'cdp_id_art=art_id and cdp_estado = 1', 'left');
                $this->db->join('mrp_marca_producto', 'mrp_id = art_id_mrp AND mrp_estado = 1', 'left');

        if ($categorias_final != null) {
            $categorias = explode(',', $categorias_final);
            $this->db->where_in('art_id_tia', $categorias);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->where($like);
            $this->db->limit(100); // si se trata búsqueda por like establecer un limit
        }
        $this->db->group_by('art_id');
        return $query->get()->result_array();
    }

    function crear_arbol($padre, $prefijo) {
        $prefijo = "";
        $cadena = "";
        $q = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1, 'tia_padre' => $padre));
        if ($q) {

            foreach ($q as $fila) {
                $cadena .= $fila['tia_id'] . ',';
                $cadena .= $this->crear_arbol($fila['tia_id'], '');
            }
        }
        return $cadena;
    }

    public function get_lista_precio($where = null){
        /*
            SELECT
                *
            FROM
                tlp_tipo_lista_precio
            INNER JOIN tpn_tipo_precio_cliente ON tpn_id_tlp = tlp_id
            INNER JOIN lip_listado_precio ON lip_id_tlp = tlp_id
            WHERE
                tpn_id_cli = 328 and lip_id_art = 264
            GROUP BY tlp_id
        */
        $this->db->select()
            ->from('tlp_tipo_lista_precio')
            ->join('tpn_tipo_precio_cliente','tpn_id_tlp = tlp_id')
            ->join('lip_listado_precio','lip_id_tlp = tlp_id')
            ->group_by('tlp_id')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_descripcion_curso($where = null){
        /*
            SELECT if(frh_descripcion = '' or ISNULL(frh_descripcion), frh_nombre, frh_descripcion) as descripcion, frh_id from lxp_alumnoxpensum
            INNER JOIN gra_grupo_academico on gra_id = lxp_id_gra
            INNER join pen_pensum on pen_id = gra_id_pen
            INNER JOIN lxa_alumnoxarea on lxa_id = lxp_id_lxa
            INNER JOIN mod_modulo ON mod_id = pen_id_mod
            INNER JOIN frh_frecuencia_horario ON frh_id = gra_id_frh
            WHERE lxp_estado = 1 and lxa_id_alm = 107 and mod_id_art = 544
        */
        $this->db->select("if(frh_descripcion = '' or ISNULL(frh_descripcion), CONCAT_WS(' - ', mod_nombre, frh_nombre, aul_nombre, scc_nombre ), CONCAT_WS(' - ', mod_nombre, frh_descripcion,aul_nombre, scc_nombre )) as descripcion,

            if(gra_id_grd > 0, CONCAT_WS(' - ', grd_nombre, aul_nombre, scc_nombre ), '') as descripcion_grd", false)
            ->from('lxp_alumnoxpensum')
            ->join('gra_grupo_academico','gra_id = lxp_id_gra', 'inner')
            ->join('pen_pensum','pen_id = gra_id_pen', 'inner')
            ->join('lxa_alumnoxarea','lxa_id = lxp_id_lxa', 'inner')
            ->join('mod_modulo','mod_id = pen_id_mod', 'inner')
            ->join('frh_frecuencia_horario','frh_id = gra_id_frh', 'inner')
            ->join('alm_alumno','alm_id = lxa_id_alm', 'inner')
            ->join('aul_aula', 'gra_id_aul = aul_id', 'inner')
            ->join('scc_seccion', 'gra_id_scc = scc_id', 'inner')
            ->join('grd_grado', 'gra_id_grd = grd_id', 'left')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_facturas_realizadas_grupo_familiar_hoy($where = null){
        /*
            SELECT COUNT(*) as total_facturas_realizadas_hoy FROM fac_factura
            INNER JOIN cli_cliente ON cli_cliente.cli_id = fac_factura.fac_id_cli
            INNER JOIN alm_alumno ON alm_alumno.alm_id_cli = cli_cliente.cli_id
            WHERE DATE(fac_factura.fac_fecha_fact) = "2025-08-19" and alm_alumno.alm_id_gfa = 1;
        */
        $this->db->select("COUNT(*) as cantidad_facturas_realizadas_gfa_hoy, GROUP_CONCAT(fac_id_cli) as clientes_facturas", false)
            ->from('fac_factura')
            ->join('cli_cliente','cli_id = fac_id_cli', 'inner')
            ->join('alm_alumno','alm_id_cli = cli_id', 'inner')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    function get_orden_venta_detalle($where = null) {
        /*
            SELECT * FROM dov_detalle_orden_venta
            INNER JOIN art_articulo ON art_id = dov_id_art
            INNER JOIN cva_conversion_articulo ON cva_id = dov_id_cva
            INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
        */
        $query = $this->db->select()
                ->from('dov_detalle_orden_venta')
                ->join('art_articulo', 'art_id = dov_id_art')
                ->join('cva_conversion_articulo', 'cva_id = dov_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_impuestos_orden_venta_productos($where = null) {
        $query = $this->db->select()
                ->from('ixv_impuestoxorden_venta')
                ->join('imp_impuesto', 'imp_id = ixv_id_imp');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_retencion_orden_venta_productos($where = null) {
        $query = $this->db->select()
                ->from('rxv_retencionxorden_venta')
                ->join('ret_retencion', 'ret_id = rxv_id_ret');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @return detalles de la orden de compra para la facturacion
     * @since 17/01/18
    */
    function get_detalle_orden_factura($where = null){
        /*
            SELECT
            dov_id,
            art_codigo,
            dov_descripcion,
            dov_cantidad,
            dov_precio,
            (dov_cantidad * dov_precio) AS suma,
            dov_descuento,
            dov_subtotal,
            dov_impuesto,
            dov_retencion,
            (dov_subtotal + dov_impuesto) AS total,
            art_tipo,
            dov_id_tpv,
            tpv_abreviacion,
            dov_id_lip,
            lip_id_tlp,
            dov_id_cva,
            (
                SELECT
                    CONCAT_WS(
                        '&#',
                        GROUP_CONCAT(ixv_porcentaje),
                        SUM(ixv_porcentaje),
                        GROUP_CONCAT(ixv_id_imp)
                    )
                FROM
                    ixv_impuestoxorden_venta
                WHERE
                    ixv_id_dov = dov_id
            ) AS impuesto,
            (
                SELECT
                    CONCAT_WS(
                        '&#',
                        GROUP_CONCAT(rxv_porcentaje),
                        SUM(rxv_porcentaje),
                        GROUP_CONCAT(rxv_id_ret)
                    )
                FROM
                    rxv_retencionxorden_venta
                WHERE
                    rxv_id_dov = dov_id
            ) AS retencion,
            dov_porcentaje_descuento,
            dov_porcentaje_impuesto,
            dov_porcentaje_retencion
        FROM
            dov_detalle_orden_venta
        INNER JOIN art_articulo ON art_id = dov_id_art
        INNER JOIN cva_conversion_articulo ON cva_id = dov_id_cva
        INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
        LEFT JOIN tpv_tipo_venta ON tpv_id = dov_id_tpv
        LEFT JOIN lip_listado_precio ON lip_id = dov_id_lip
        WHERE
            dov_id_orv = 7
        */
        $this->db->select("
            dov_id,
            art_codigo,
            dov_id_art articulo,
            dov_descripcion descripcion,
            dov_cantidad cantidad,
            dov_precio precio,
            (dov_cantidad * dov_precio) AS suma,
            dov_descuento descuento,
            dov_subtotal subtotal,
            dov_impuesto impuesto,
            dov_retencion retencion,
            (dov_subtotal + dov_impuesto) AS total,
            art_tipo,
            dov_id_tpv tipo_venta,
            tpv_abreviacion abreviacion,
            dov_id_lip,
            lip_id_tlp id_tlp,
            dov_id_cva id_cva,
            cva_id_mep id_mep,
            dov_precio_sugerido_lista precio_sugerido_lista,
            (
                IF (
                    dov_impuesto = 0,
                    CONCAT_WS('&&&',0,0,''),
                    (
                        SELECT
                            CONCAT_WS(
                                '&&&',
                                GROUP_CONCAT(ixv_porcentaje),
                                SUM(ixv_porcentaje),
                                GROUP_CONCAT(ixv_id_imp)
                            )
                        FROM
                            ixv_impuestoxorden_venta
                        WHERE
                            ixv_id_dov = dov_id
                    )
                )
            ) AS impuestos,
            (
                IF (
                    dov_retencion = 0,
                    CONCAT_WS('&&&',0,0,''),
                    (
                        SELECT
                            CONCAT_WS(
                                '&&&',
                                GROUP_CONCAT(rxv_porcentaje),
                                SUM(rxv_porcentaje),
                                GROUP_CONCAT(rxv_id_ret)
                            )
                        FROM
                            rxv_retencionxorden_venta
                        WHERE
                            rxv_id_dov = dov_id
                    )
                )
            ) AS retenciones,
            (
                SELECT
                    GROUP_CONCAT(
                        CONCAT(
                            cva.cva_id,
                            '-',
                            cva.cva_conversion,
                            '-',
                            cva.cva_defecto
                        )
                    )
                FROM
                    cva_conversion_articulo AS cva
                WHERE
                    cva.cva_id_art = art_id
                AND cva.cva_estado = 1
            ) AS conversiones,
            dov_porcentaje_descuento descuento_por,
            dov_porcentaje_impuesto impuesto_por,
            dov_precio_inventario AS costo_por_detalle_producto,
            dov_porcentaje_retencion retencion_por,
            dov_combo reg_combo, cva_conversion,
            dov_id_bod bodega_factura",false)
            ->from('dov_detalle_orden_venta')
            ->join('art_articulo', 'art_id = dov_id_art', 'inner')
            ->join('cva_conversion_articulo', 'cva_id = dov_id_cva', 'inner')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
            ->join('tpv_tipo_venta', 'tpv_id = dov_id_tpv', 'left')
            ->join('lip_listado_precio', 'lip_id = dov_id_lip', 'left')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @return detalles de la cotizacion para la facturacion
     * @since 17/01/18
    */
    function get_detalle_cotizacion_factura($where = null){
        /*
            SELECT
            axc_id,
            art_codigo,
            axc_id_art articulo,
            axc_descripcion descripcion,
            axc_cantidad cantidad,
            axc_precio precio,
            (axc_cantidad * axc_precio) AS suma,
            axc_descuento descuento,
            axc_subtotal subtotal,
            axc_impuesto impuesto,
            0 retencion,
            (axc_subtotal + axc_impuesto) AS total,
            art_tipo,
            #dov_id_tpv tipo_venta,
            #tpv_abreviacion abreviacion,
            axc_id_lip,
            lip_id_tlp id_tlp,
            axc_id_cva id_cva,
            cva_id_mep id_mep,
            axc_precio_sugerido_lista precio_sugerido_lista,
            (
                SELECT
                    CONCAT_WS(
                        '&#',
                        GROUP_CONCAT(imp_porcentaje),
                        SUM(imp_porcentaje),
                        GROUP_CONCAT(ixt_id_imp)
                    )
                FROM
                    ixt_impuestoxcotizacion
                INNER JOIN imp_impuesto ON imp_id = ixt_id_imp
                WHERE
                    ixt_id_axc = axc_id
            ) AS impuestos,
            (CONCAT_WS('&#',0,0,'')) as retenciones,
            (
                SELECT
                    GROUP_CONCAT(
                        CONCAT(
                            cva.cva_id,
                            '-',
                            cva.cva_conversion,
                            '-',
                            cva.cva_defecto
                        )
                    )
                FROM
                    cva_conversion_articulo AS cva
                WHERE
                    cva.cva_id_art = art_id
                AND cva.cva_estado = 1
            ) AS conversiones,
            ((axc_descuento*100)/axc_subtotal) as descuento_por,
            (
                SELECT
                        SUM(imp_porcentaje)
                FROM
                    ixt_impuestoxcotizacion
                INNER JOIN imp_impuesto ON imp_id = ixt_id_imp
                WHERE
                    ixt_id_axc = axc_id
            ) AS impuesto_por,
            0 retencion_por,
            art_combo reg_combo
            FROM axc_articuloxcotizacion
            INNER JOIN art_articulo ON art_id = axc_id_art
            INNER JOIN cva_conversion_articulo ON cva_id = axc_id_cva
            INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
            LEFT JOIN lip_listado_precio ON lip_id = axc_id_lip
            LEFT JOIN cot_cotizacion ON cot_id = axc_id_cot
            WHERE axc_id_cot = 251
        */
        //axc_descuento descuento,
        //((axc_descuento*100)/axc_subtotal) as descuento_por,
        $this->db->select("
            axc_id,
            cot_id,
            cot_id_pcl,
            cot_id_tpg,
            cot_fecha_entrega,
            art_codigo,
            axc_id_art articulo,
            IF(TRIM(axc_descripcion) != '',axc_descripcion, (SELECT art_nombre FROM art_articulo WHERE art_id = axc_id_art)) AS descripcion,
            axc_cantidad cantidad_base,
            IFNULL(axc_cantidad_facturada,0) cantidad_facturada_base,
            IFNULL(axc_cantidad_pendiente,axc_cantidad) cantidad_pendiente_base,
            axc_cantidad - IFNULL(axc_cantidad_facturada,0) cantidad,
            axc_precio precio,
            ((axc_cantidad - IFNULL(axc_cantidad_facturada,0)) * axc_precio) AS suma,
            (((axc_cantidad - IFNULL(axc_cantidad_facturada,0)) * axc_precio)*(axc_descuento/100)) descuento,
            axc_subtotal subtotal,
            axc_impuesto impuesto,
            0 retencion,
            ( (axc_subtotal + axc_impuesto) - (((axc_cantidad - IFNULL(axc_cantidad_facturada,0)) * axc_precio)*(axc_descuento/100)) )AS total,
            art_tipo,
            (SELECT cli_id_tpv FROM cli_cliente WHERE cli_id = cot_id_cli) AS tipo_venta,
            (SELECT tpv_abreviacion FROM cli_cliente JOIN tpv_tipo_venta ON tpv_id = cli_id_tpv WHERE cli_id = cot_id_cli ) AS abreviacion,
            axc_id_lip,
            lip_id_tlp id_tlp,
            axc_id_cva id_cva,
            cva_id_mep id_mep,
            axc_id_foa,
            axc_valor_formula,
            axc_precio_sugerido_lista precio_sugerido_lista,
            (
                IF (
                    axc_impuesto = 0,
                    CONCAT_WS('&&&',0,0,''),
                    (
                        SELECT
                            CONCAT_WS(
                                '&&&',
                                GROUP_CONCAT(imp_porcentaje),
                                SUM(imp_porcentaje),
                                GROUP_CONCAT(ixt_id_imp)
                            )
                        FROM
                            ixt_impuestoxcotizacion
                        INNER JOIN imp_impuesto ON imp_id = ixt_id_imp
                        WHERE
                            ixt_id_axc = axc_id
                    )
                )
            ) AS impuestos,
            (CONCAT_WS('&&&',0,0,'')) as retenciones,
            (
                SELECT
                    GROUP_CONCAT(
                        CONCAT(
                            cva.cva_id,
                            '-',
                            cva.cva_conversion,
                            '-',
                            cva.cva_defecto
                        )
                    )
                FROM
                    cva_conversion_articulo AS cva
                WHERE
                    cva.cva_id_art = art_id
                AND cva.cva_estado = 1
            ) AS conversiones,
            (axc_descuento) as descuento_por,
            (
                SELECT
                    SUM(imp_porcentaje)
                FROM
                    ixt_impuestoxcotizacion
                INNER JOIN imp_impuesto ON imp_id = ixt_id_imp
                WHERE
                    ixt_id_axc = axc_id
            ) AS impuesto_por,
            0 retencion_por,
            #dov_combo reg_combo
            art_combo reg_combo,
            cva_conversion,
            axc_precio_inventario AS costo_por_detalle_producto,
            cot_id_ven,
            axc_id_bod bodega_factura,
            (
                SELECT cog_numero_orden
                FROM cog_cotiz_ganada
                WHERE cog_id_cot = cot_id
            ) AS cog_numero_orden
            ",false)
            ->from('axc_articuloxcotizacion')
            ->join('art_articulo', 'art_id = axc_id_art', 'inner')
            ->join('cva_conversion_articulo', 'cva_id = axc_id_cva', 'inner')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
            //->join('tpv_tipo_venta', 'tpv_id = dov_id_tpv', 'left')
            ->join('lip_listado_precio', 'lip_id = axc_id_lip', 'left')
            ->join('cot_cotizacion', 'cot_id = axc_id_cot', 'left')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_detalle_cuotas_curso_factura($where = null){
        $this->db->select("*,
            a.art_id AS articulo, c.cva_id AS id_cva, 1 AS cantidad, a.art_combo AS reg_combo, ma.mep_id AS id_mep, a.art_codigo, '' AS id_tlp, a.art_nombre AS descripcion,
            CONCAT(c.cva_id, '-', c.cva_conversion, '-', c.cva_defecto) AS conversiones, c.cva_conversion AS cva_conversion, cmc_id, 0 AS descuento_por, cmc_monto AS precio, 
            cmc_monto AS precio_sugerido_lista, 0 as descuento, cmc_monto AS subtotal, 0 as retencion_por, 0 as retencion, '' tipo_venta, '' abreviacion, a.art_tipo AS art_tipo,
            IFNULL((SELECT SUM(imp_porcentaje) FROM ixr_impuestox_tipo_articulo JOIN imp_impuesto ON imp_id = ixr_id_imp WHERE ixr_estado = 1 AND ixr_id_tia = a.art_id_tia), 0) AS impuesto_por,
            IFNULL((cmc_monto * (SELECT (SUM(imp_porcentaje) / 100) FROM ixr_impuestox_tipo_articulo JOIN imp_impuesto ON imp_id = ixr_id_imp WHERE ixr_estado = 1 AND ixr_id_tia = a.art_id_tia)), 0) 
            AS impuesto, (IF((IFNULL((cmc_monto * (SELECT (SUM(imp_porcentaje) / 100)FROM ixr_impuestox_tipo_articulo JOIN imp_impuesto ON imp_id = ixr_id_imp 
            WHERE ixr_estado = 1 AND ixr_id_tia = a.art_id_tia)), 0) = 0), CONCAT_WS('&&&',0,0,''), (SELECT CONCAT_WS('&&&', GROUP_CONCAT(imp_porcentaje), SUM(imp_porcentaje), 
            GROUP_CONCAT(ixr_id_imp)) FROM ixr_impuestox_tipo_articulo JOIN imp_impuesto ON imp_id = ixr_id_imp WHERE ixr_estado = 1 AND ixr_id_tia = a.art_id_tia))) AS impuestos, 0 AS retencion2,
            0 AS retencion_por2, (CONCAT_WS('&&&',0,0,'')) as retenciones, ( cmc_monto + ( IFNULL((cmc_monto * (SELECT (SUM(imp_porcentaje) / 100)FROM ixr_impuestox_tipo_articulo 
            JOIN imp_impuesto ON imp_id = ixr_id_imp WHERE ixr_estado = 1 AND ixr_id_tia = a.art_id_tia)), 0) ) )AS total, DATEDIFF(CURDATE(), cmc_fecha_vencimiento) AS pago_vencido, cmc_estado_cargo,
            m.art_id AS articulo2, cm.cva_id AS id_cva2, m.art_combo AS reg_combo2, mm.mep_id AS id_mep2, m.art_codigo AS art_codigo2, m.art_nombre AS descripcion2, 
            CONCAT(cm.cva_id, '-', cm.cva_conversion, '-', cm.cva_defecto) AS conversiones2, cm.cva_conversion AS cva_conversion2, cmc_cuota, 
            IF(dfc_tipo_aplicacion_mora > 0,((dfc_valor_mora/100)*cmc_monto),dfc_valor_mora) AS precio2,
            IFNULL((SELECT SUM(imp_porcentaje) FROM ixr_impuestox_tipo_articulo JOIN imp_impuesto ON imp_id = ixr_id_imp WHERE ixr_estado = 1 AND ixr_id_tia = m.art_id_tia), 0) AS impuesto_por2,
            IFNULL( ((IF(dfc_tipo_aplicacion_mora > 0,((dfc_valor_mora/100)*cmc_monto),dfc_valor_mora)) * (SELECT (SUM(imp_porcentaje) / 100)FROM ixr_impuestox_tipo_articulo JOIN imp_impuesto ON imp_id = ixr_id_imp WHERE ixr_estado = 1 and ixr_id_tia = m.art_id_tia)), 0) AS impuesto2,
            IF((IFNULL( ((IF(dfc_tipo_aplicacion_mora > 0,((dfc_valor_mora/100)*cmc_monto),dfc_valor_mora)) * (SELECT (SUM(imp_porcentaje) / 100)FROM ixr_impuestox_tipo_articulo JOIN imp_impuesto ON imp_id = ixr_id_imp WHERE ixr_estado = 1 and ixr_id_tia = m.art_id_tia)), 0)) = 0, CONCAT_WS('&&&',0,0,''),  (SELECT CONCAT_WS('&&&', GROUP_CONCAT(imp_porcentaje), SUM(imp_porcentaje), GROUP_CONCAT(ixr_id_imp)) FROM ixr_impuestox_tipo_articulo JOIN imp_impuesto ON imp_id = ixr_id_imp WHERE ixr_id_tia = m.art_id_tia)) AS impuestos2,
            m.art_tipo AS art_tip2,
            ( (IF(dfc_tipo_aplicacion_mora > 0,((dfc_valor_mora/100)*cmc_monto),dfc_valor_mora)) + (IFNULL((( IF(dfc_tipo_aplicacion_mora > 0,((dfc_valor_mora/100)*cmc_monto),dfc_valor_mora)) * (SELECT (SUM(imp_porcentaje) / 100)FROM ixr_impuestox_tipo_articulo JOIN imp_impuesto ON imp_id = ixr_id_imp WHERE ixr_estado = 1 AND ixr_id_tia = m.art_id_tia)), 0))  )AS total2
            ", false)
            ->from('dfc_detalle_configuracion_cargo')
            ->join('cfg_configuracion_cargo', 'cfg_id = dfc_id_cfg')
            ->join('cmc_cargo_alumnoxcurso', 'cmc_id_cfg = cfg_id')
            ->join('art_articulo AS a', 'a.art_id = dfc_id_art')
            ->join('cva_conversion_articulo AS c', 'c.cva_id_art = a.art_id AND c.cva_estado = 1 AND c.cva_defecto = 1')
            ->join('mep_medida_producto AS ma', 'ma.mep_id = c.cva_id_mep')
            ->join('art_articulo as m', 'm.art_id = dfc_id_art_mora', 'left')
            ->join('cva_conversion_articulo AS cm', 'cm.cva_id_art = m.art_id AND cm.cva_defecto = 1', 'left')
            ->join('mep_medida_producto AS mm', 'mm.mep_id = cm.cva_id_mep', 'left')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @return detalles de la factura
     * @since 04/04/18
    */
    public function get_detalle_factura_duplicar($where = null){
        /*
            SELECT def_id,
            art_codigo,
            def_id_art articulo,
            def_descripcion descripcion,
            def_cantidad cantidad,
            def_precio precio,
            (def_cantidad * def_precio) AS suma,
            def_descuento descuento,
            def_subtotal subtotal,
            def_impuesto impuesto,
            def_retencion retencion,
            (def_subtotal + def_impuesto) AS total,
            art_tipo,
            def_id_tpv tipo_venta,
            tpv_abreviacion abreviacion,
            def_id_lip,
            lip_id_tlp id_tlp,
            def_id_cva id_cva,
            cva_id_mep id_mep,
            def_precio_sugerido_lista precio_sugerido_lista,
            (
                IF (
                    def_impuesto = 0,
                    CONCAT_WS('&#',0,0,''),
                    (
                        SELECT
                            CONCAT_WS(
                                '&#',
                                GROUP_CONCAT(ixf_porcentaje),
                                SUM(ixf_porcentaje),
                                GROUP_CONCAT(ixf_id_imp)
                            )
                        FROM
                            ixf_impuestoxfactura
                        WHERE
                            ixf_id_def = def_id
                    )
                )
            ) AS impuestos,
            (
                IF (
                    def_retencion = 0,
                    CONCAT_WS('&#',0,0,''),
                    (
                        SELECT
                            CONCAT_WS(
                                '&#',
                                GROUP_CONCAT(rxf_porcentaje),
                                SUM(rxf_porcentaje),
                                GROUP_CONCAT(rxf_id_ret)
                            )
                        FROM
                            rxf_retencionxdetalle_factura
                        WHERE
                            rxf_id_def = def_id
                    )
                )
            ) AS retenciones,
            (
                SELECT
                    GROUP_CONCAT(
                        CONCAT(
                            cva.cva_id,
                            '-',
                            cva.cva_conversion,
                            '-',
                            cva.cva_defecto
                        )
                    )
                FROM
                    cva_conversion_articulo AS cva
                WHERE
                    cva.cva_id_art = art_id
                AND cva.cva_estado = 1
            ) AS conversiones,
            def_porcentaje_descuento descuento_por,
            def_porcentaje_impuesto impuesto_por,
            def_porcentaje_retencion retencion_por,
            def_combo reg_combo, cva_conversion

            FROM
            def_detalle_fact
        INNER JOIN art_articulo ON art_id = def_id_art
        INNER JOIN cva_conversion_articulo ON cva_id = def_id_cva
        INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
        LEFT JOIN tpv_tipo_venta ON tpv_id = def_id_tpv
        LEFT JOIN lip_listado_precio ON lip_id = def_id_lip
        WHERE
            def_id_fac = 12401
        */

        $this->db->select("
            def_id,
            art_codigo,
            def_id_art articulo,
            def_descripcion descripcion,
            def_cantidad cantidad,
            def_precio precio,
            (def_cantidad * def_precio) AS suma,
            def_descuento descuento,
            def_subtotal subtotal,
            def_impuesto impuesto,
            def_retencion retencion,
            def_precio_inventario,
            (def_subtotal + def_impuesto) AS total,
            art_tipo,
            def_id_tpv tipo_venta,
            tpv_abreviacion abreviacion,
            def_id_lip,
            lip_id_tlp id_tlp,
            def_id_cva id_cva,
            cva_id_mep id_mep,
            def_usu_autoriza_descuento,
            def_precio_sugerido_lista precio_sugerido_lista,
            (
                IF (
                    def_impuesto = 0,
                    CONCAT_WS('&&&',0,0,''),
                    (
                        SELECT
                            CONCAT_WS(
                                '&&&',
                                GROUP_CONCAT(ixf_porcentaje),
                                SUM(ixf_porcentaje),
                                GROUP_CONCAT(ixf_id_imp)
                            )
                        FROM
                            ixf_impuestoxfactura
                        WHERE
                            ixf_id_def = def_id
                    )
                )
            ) AS impuestos,
            (
                IF (
                    def_retencion = 0,
                    CONCAT_WS('&&&',0,0,''),
                    (SELECT CONCAT_WS('&&&',
                                GROUP_CONCAT(ret_porcentaje),
                                SUM(ret_porcentaje),
                                GROUP_CONCAT(rxf_id_ret)
                            )
                        FROM rxf_retencionxdetalle_factura 
                        JOIN ret_retencion ON ret_id = rxf_id_ret
                        WHERE rxf_id_def = def_id
                    )
                )
            ) AS retenciones,
            (IF (def_retencion = 0, CONCAT_WS('&&&', 0, 0, ''), (SELECT CONCAT_WS('&&&', GROUP_CONCAT(ret_valor), SUM(ret_valor), GROUP_CONCAT(rxf_id_ret)) FROM rxf_retencionxdetalle_factura 
                JOIN ret_retencion ON ret_id = rxf_id_ret WHERE rxf_id_def = def_id))
            ) AS retenciones_monto, 
            (
                SELECT
                    GROUP_CONCAT(
                        CONCAT(
                            cva.cva_id,
                            '-',
                            cva.cva_conversion,
                            '-',
                            cva.cva_defecto
                        )
                    )
                FROM
                    cva_conversion_articulo AS cva
                WHERE
                    cva.cva_id_art = art_id
                AND cva.cva_estado = 1
            ) AS conversiones,
            def_porcentaje_descuento descuento_por,
            def_porcentaje_impuesto impuesto_por,
            def_porcentaje_retencion retencion_por,
            def_combo reg_combo, cva_conversion,
            def_precio_inventario",false)
            ->from('def_detalle_fact')
            ->join('art_articulo', 'art_id = def_id_art', 'inner')
            ->join('cva_conversion_articulo', 'cva_id = def_id_cva', 'inner')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
            ->join('tpv_tipo_venta', 'tpv_id = def_id_tpv', 'left')
            ->join('lip_listado_precio', 'lip_id = def_id_lip', 'left')
        ;

        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_preinscripcion_almMod($where=null)
    {
        $query = $this->db->select()
             ->from('lxa_alumnoxarea')
             ->join('alm_alumno', 'lxa_id_alm=alm_id')
             ->join('lxp_alumnoxpensum', 'lxp_id_lxa = lxa_id')
             ->join('gra_grupo_academico', 'lxp_id_gra= gra_id')
             ->join('pen_pensum', 'gra_id_pen = pen_id')
             ->join('mod_modulo', 'pen_id_mod = mod_id')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('lxp_id');
        $this->db->order_by('lxp_id', 'DESC');
        return $query->get()->row_array();
    }

    public function existen_notas_credito($id = 0){
        $query = "SELECT * FROM def_detalle_fact WHERE def_id_fac IN ((SELECT fac_id FROM fac_factura WHERE fac_id_origen_devolucion = $id AND fac_id_fac_credito = $id AND fac_estado > 0))";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    /**
    * @author Habby Lovo
    * @since 2018-01-22
    * @return
    */
    public function get_articulos_mep($where = null){
        /*
            SELECT
                art_id,
                art_nombre,
                art_tipo,
                art_componente,
                (
                    SELECT
                        GROUP_CONCAT(CONCAT('<',mep_id,'$',cva_conversion,'=',cva_id,'!',mep_nombre,'>'))
                    FROM
                        cva_conversion_articulo
                    INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
                    WHERE
                        cva_id_art = art_id
                ) as producto
            FROM
                art_articulo
        */
        $this->db->select("
            art_id,
            art_codigo,
            art_nombre,
            art_tipo,
            art_componente,
            art_descripcion,
            art_sinonimo,
            (
                SELECT
                    GROUP_CONCAT(CONCAT('*',mep_id,'$',cva_conversion,'/',cva_id, '(', if(cva_defecto = 1,'+','!'), mep_nombre, '?'))
                FROM
                    cva_conversion_articulo
                INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
                WHERE
                    cva_id_art = art_id and cva_estado = 1
            ) as medidas,
            (
                SELECT
                    GROUP_CONCAT(cva_conversion)
                FROM
                    cva_conversion_articulo
                INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
                WHERE
                    cva_id_art = art_id and cva_defecto = 1 and cva_estado = 1
            ) AS medida_defecto",false)
            ->from('art_articulo')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author Francisco Orozco
     * @since 26/01/2018
     * @method Reportes por estado de anticipos
    */

    public function reporte_anticiposxestado($where = null,$estado = null){
        $query = $this->db->select("*,
                    (IF (cli_personeria = 1,CONCAT_WS(' ',cli_nombre,cli_apellido),CONCAT_WS(' ', cli_apellido))) AS cliente,
                    CONCAT_WS('/',
                        IF(( CURDATE() > DATE(anl_fecha_vencimiento) and anl_saldo != 0 AND anl_fecha_vencimiento IS NOT NULL),'VENCIDO','-') ,
                        IF((anl_monto = anl_saldo),'SIN APLICAR',
                        IF((anl_saldo =0),'APLICADO','APLICADO PARCIAL')
                    )
                    ) estado",false)
        ->from("anl_anticipo_cliente")
        ->join("cli_cliente", "cli_id = anl_id_cli")
        ;

        if($where != null){
           $this->db->where($where);
        }

        if ($estado != null) {
			switch ($estado) {
                case 1: //sin aplicar
                    $this->db->where('anl_saldo = anl_monto',null);
					//$where[' anl_saldo = anl_monto ']    = Null;
					break;
                case 2: //aplicado
                    $this->db->where('(anl_saldo != anl_monto and anl_saldo = 0 )',null);
					break;
                case 3: //aplicado parcialmente
                    $this->db->where('(anl_saldo != anl_monto and anl_saldo != 0 )',null);
					break;
                case 4: //vencido
                    $this->db->where('(CURDATE() > anl_fecha_vencimiento and anl_saldo != 0 )',null);
					break;
			}
		}

        return $this->db->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 08/12/2017
     * @method Se obtiene la Cuenta contable del producto (Cuando el producto factura afecta/no afecta el inventario)
    */
    public function get_cnt_x_prod_x_fac($where){
        
        $id_pais_defecto = $this->tank_auth->get_all_empresa()->emr_id_pai;
        if($id_pais_defecto == null){
            $id_pais_defecto = 7;
        }
        $query = "
                SELECT
                SUM(IFNULL(dcf_monto,def_subtotal)) AS subtotal_prod,
                tia_id,
                (
                    SELECT cnt_id
                    FROM dcf_detalle_centrocostoxfactura AS dcf2
                    JOIN cnt_cuenta_contable ON dcf2.dcf_id_cnt = cnt_id
                    JOIN dta_detalle_tipoarticulo ON dta_id_cec = dcf2.dcf_id_cec AND dta_id_pai = IFNULL(dcf_id_pai,$id_pais_defecto)
                    WHERE dcf2.dcf_id_def = def_id AND dcf_id_tcn =".$where['idtipo_cnt']." AND dcf2.dcf_id = dcf1.dcf_id AND dta_id_tia = tia_id LIMIT 1
                ) AS cnt_id,
                (
                    SELECT cnt_nombre
                    FROM dcf_detalle_centrocostoxfactura AS dcf2
                    JOIN cnt_cuenta_contable ON dcf2.dcf_id_cnt = cnt_id
                    JOIN dta_detalle_tipoarticulo ON dta_id_cec = dcf2.dcf_id_cec AND dta_id_pai = IFNULL(dcf_id_pai,$id_pais_defecto)
                    WHERE dcf2.dcf_id_def = def_id AND dcf_id_tcn =".$where['idtipo_cnt']." AND dcf2.dcf_id = dcf1.dcf_id AND dta_id_tia = tia_id LIMIT 1
                ) AS cnt_nombre
                FROM fac_factura
                JOIN def_detalle_fact ON fac_id = def_id_fac
                LEFT JOIN dcf_detalle_centrocostoxfactura AS dcf1 ON dcf1.dcf_id_def = def_id
                JOIN art_articulo ON def_id_art = art_id
                JOIN tia_tipo_articulo ON art_id_tia = tia_id
                WHERE fac_id = ".$where['fac_id']."
                GROUP BY cnt_id"
        ;

        return $this->db->query($query)->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 08/02/2018
     * @method Se obtiene la Cuenta contable del impuesto (Cuando la factura no afecta el inventario)
    */
    public function get_cnt_x_impu_x_fac($where){
        $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('IMPUESTOS'));
        $query = "
                 SELECT
                  fac_id,
                  cxe_id_tcn,
                  imp_porcentaje,
                  SUM(((imp_porcentaje / 100) * def_subtotal)) AS subtotximpcuenta,
                  def_subtotal,
                  IF (ISNULL(cxe_id_cnt),0,cxe_id_cnt) AS cxe_id_cnt,
                  (
                    SELECT
                        cnt_cuenta
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = cxe_id_cnt
                    LIMIT 1
                   ) cuenta,
                  (
                    SELECT
                        cnt_nombre
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = cxe_id_cnt
                    LIMIT 1
                 ) cuenta_nombre
                 FROM
                    fac_factura
                 JOIN def_detalle_fact ON fac_id = def_id_fac
                 JOIN ixf_impuestoxfactura ON def_id = ixf_id_def
                 JOIN imp_impuesto ON ixf_id_imp = imp_id
                 LEFT JOIN cxe_cuentaximpuesto ON imp_id = cxe_id_imp
                 LEFT JOIN cnt_cuenta_contable ON cnt_id = cxe_id_cnt
                 WHERE
                    fac_id = ".$where['fac_id']."
                 GROUP BY
                    cxe_id_cnt,
                    fac_id
                 HAVING cxe_id_tcn = ".$tcn_id." OR ISNULL(cxe_id_tcn)
                 ORDER BY
                    def_id
                ";

        return $this->db->query($query)->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-02-01
     * @return Obtiene todos los componentes
     */
    public function get_componente_orden_venta($where = null){
        /*SELECT
            cdv_descripcion descripcion,
            mep_nombre medida,
            cdv_cantidad cantidad,
            cva_conversion * (
                cdv_cantidad / (
                    SELECT
                        cva.cva_conversion
                    FROM
                        cva_conversion_articulo AS cva
                    WHERE
                        cva.cva_id_art = art_id
                    AND cva.cva_defecto = 1
                )
            ) cantidad_convertida,
            cdv_precio precio,
            cdv_subtotal subtotal,
            cdv_altera_precio altera_precio,
            IF (
                cdv_altera_precio = 1,
                'Si',
                'No'
            ) altera_preciotxt,
             cdv_muestra_descripcion muestra_descripcion,
            IF (
                cdv_altera_precio = 1,
                'checked',
                ''
            ) muestra_descripcionck,
             art_id,
             art_tipo,
             cva_id,
             mep_id,
             cva_conversion,
             (
                SELECT
                    cva.cva_conversion
                FROM
                    cva_conversion_articulo AS cva
                WHERE
                    cva.cva_id_art = art_id
                AND cva.cva_defecto = 1
            ) cva_defecto
        FROM
            cdv_componente_detallexorden_venta
        INNER JOIN cva_conversion_articulo ON cva_id = cdv_id_cva
        INNER JOIN art_articulo ON art_id = cva_id_art
        INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
        WHERE
            cdv_id_dov = 18*/
        $query = $this->db->select("
                cdv_id codigo,
                cdv_descripcion descripcion,
                mep_nombre medida,
                cdv_cantidad cantidad,
                cva_conversion * (
                    cdv_cantidad / (
                        SELECT
                            cva.cva_conversion
                        FROM
                            cva_conversion_articulo AS cva
                        WHERE
                            cva.cva_id_art = art_id
                        AND cva.cva_defecto = 1
                    )
                ) cantidad_convertida,
                cdv_precio precio,
                cdv_subtotal subtotal,
                cdv_altera_precio altera_precio,
                IF (
                    cdv_altera_precio = 1,
                    'Si',
                    'No'
                ) altera_preciotxt,
                cdv_muestra_descripcion muestra_descripcion,
                IF (
                    cdv_muestra_descripcion = 1,
                    'checked',
                    ''
                ) muestra_descripcionck,
                IF (
                    cdv_altera_precio = 1,
                    'checked',
                    ''
                ) altera_preciock,
                 art_id,
                 art_tipo,
                 cva_id,
                 mep_id,
                 cva_conversion,
                 (
                    SELECT
                        cva.cva_conversion
                    FROM
                        cva_conversion_articulo AS cva
                    WHERE
                        cva.cva_id_art = art_id
                    AND cva.cva_defecto = 1
                ) cva_defecto_a", false)
            ->from('cdv_componente_detallexorden_venta')
            ->join('cva_conversion_articulo','cva_id = cdv_id_cva','inner')
            ->join('art_articulo','art_id = cva_id_art','inner')
            ->join('mep_medida_producto','mep_id = cva_id_mep','inner')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-02-01
     * @return Obtiene todos los componentes
     */
    public function get_componente_factura($where = null){
        /*SELECT
            cdv_descripcion descripcion,
            mep_nombre medida,
            cdv_cantidad cantidad,
            cva_conversion * (
                cdv_cantidad / (
                    SELECT
                        cva.cva_conversion
                    FROM
                        cva_conversion_articulo AS cva
                    WHERE
                        cva.cva_id_art = art_id
                    AND cva.cva_defecto = 1
                )
            ) cantidad_convertida,
            cdv_precio precio,
            cdv_subtotal subtotal,
            cdv_altera_precio altera_precio,
            IF (
                cdv_altera_precio = 1,
                'Si',
                'No'
            ) altera_preciotxt,
             cdv_muestra_descripcion muestra_descripcion,
            IF (
                cdv_altera_precio = 1,
                'checked',
                ''
            ) muestra_descripcionck,
             art_id,
             art_tipo,
             cva_id,
             mep_id,
             cva_conversion,
             (
                SELECT
                    cva.cva_conversion
                FROM
                    cva_conversion_articulo AS cva
                WHERE
                    cva.cva_id_art = art_id
                AND cva.cva_defecto = 1
            ) cva_defecto
        FROM
            cdv_componente_detallexorden_venta
        INNER JOIN cva_conversion_articulo ON cva_id = cdv_id_cva
        INNER JOIN art_articulo ON art_id = cva_id_art
        INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
        WHERE
            cdv_id_dov = 18*/
        $query = $this->db->select("
                cdf_id codigo,
                cdf_descripcion descripcion,
                mep_nombre medida,
                cdf_cantidad cantidad,
                cva_conversion * (
                    cdf_cantidad / (
                        SELECT
                            cva.cva_conversion
                        FROM
                            cva_conversion_articulo AS cva
                        WHERE
                            cva.cva_id_art = art_id
                        AND cva.cva_defecto = 1
                    )
                ) cantidad_convertida,
                cdf_precio precio,
                cdf_subtotal subtotal,
                cdf_altera_precio altera_precio,
                IF (
                    cdf_altera_precio = 1,
                    'Si',
                    'No'
                ) altera_preciotxt,
                cdf_muestra_descripcion muestra_descripcion,
                IF (
                    cdf_muestra_descripcion = 1,
                    'checked',
                    ''
                ) muestra_descripcionck,
                IF (
                    cdf_altera_precio = 1,
                    'checked',
                    ''
                ) altera_preciock,
                 art_id,
                 art_tipo,
                 cva_id,
                 mep_id,
                 cva_conversion,
                 (
                    SELECT
                        cva.cva_conversion
                    FROM
                        cva_conversion_articulo AS cva
                    WHERE
                        cva.cva_id_art = art_id
                    AND cva.cva_defecto = 1
                ) cva_defecto_a", false)
            ->from('cdf_componente_detalle_factura')
            ->join('cva_conversion_articulo','cva_id = cdf_id_cva','inner')
            ->join('art_articulo','art_id = cva_id_art','inner')
            ->join('mep_medida_producto','mep_id = cva_id_mep','inner')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 08/02/2018
     * @method Se obtiene la Cuenta contable para el cliente
    */
    function get_cuenta_contable_tipopago($where) {
        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('CUENTA_POR_COBRAR_CREDITO'));

        /*$query = "
                SELECT
                IFNULL((
                    SELECT cnt2.cnt_id
                    FROM fac_factura AS fac2
                    LEFT JOIN cli_cliente AS cli2 ON fac2.fac_id_cli = cli2.cli_id
                    LEFT JOIN cxn_cuentaxcliente AS cxn2 ON cli2.cli_id = cxn2.cxn_id_cli
                    LEFT JOIN tpg_tipo_pago AS tpg2 ON cxn2.cxn_id_tpg = tpg2.tpg_id
                    LEFT JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = cxn2.cxn_id_cnt
                    WHERE cxn2.cxn_id_tpg = fac1.fac_id_tpg
                    AND tpg2.tpg_id = fac1.fac_id_tpg
                    AND fac2.fac_id = fac1.fac_id
                    LIMIT 1
                ),0) AS cnt_id,
                (
                    SELECT cnt2.cnt_nombre
                    FROM fac_factura AS fac2
                    JOIN cli_cliente AS cli2 ON fac2.fac_id_cli = cli2.cli_id
                    JOIN cxn_cuentaxcliente AS cxn2 ON cli2.cli_id = cxn2.cxn_id_cli
                    JOIN tpg_tipo_pago AS tpg2 ON cxn2.cxn_id_tpg = tpg2.tpg_id
                    JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = cxn2.cxn_id_cnt
                    WHERE cxn2.cxn_id_tpg = fac1.fac_id_tpg
                    AND tpg2.tpg_id = fac1.fac_id_tpg
                    AND fac2.fac_id = fac1.fac_id
                    LIMIT 1
                ) AS cnt_nombre
                FROM fac_factura AS fac1
                LEFT JOIN cli_cliente ON fac1.fac_id_cli = cli_id
                LEFT JOIN cxn_cuentaxcliente ON fac_id_cli = cxn_id_cli
                LEFT JOIN tpg_tipo_pago ON cxn_id_tpg = tpg_id
                LEFT JOIN cnt_cuenta_contable ON cnt_id = cxn_id_cnt
                WHERE fac1.fac_id = ".$where['fac_id']."
                GROUP BY fac1.fac_id
            ";*/

        $query = "
            SELECT
            (
                SELECT cec_nombre
                FROM cec_centro_costo
                WHERE cec_id = dcf_id_cec
            ) AS cec_nombre,
            dcf_id,
            dcf_porcentaje,
            fac_id,
            fac_id_cli,
            SUM((IFNULL(dcf_monto,def_subtotal) + IFNULL(def_impuesto,0.00)+ IFNULL(def_retencion,0.00))) total,
            SUM((IFNULL(def_subtotal,0.00) + IFNULL(def_impuesto,0.00) + IFNULL(def_retencion,0.00))*(dcf_porcentaje/100)) AS total_bk,
            IFNULL((
                SELECT cnt_id
                FROM cnt_cuenta_contable
                JOIN cxn_cuentaxcliente ON cxn_id_cnt = cnt_id
                WHERE cxn_id_tcn = $tipo_cuenta
                AND cxn_id_cec = dcf_id_cec
                AND cxn_id_cli = fac_id_cli
                LIMIT 1
            ), $cuenta_defecto) AS cnt_id,
             IFNULL((
                SELECT cnt_nombre
                FROM cnt_cuenta_contable
                JOIN cxn_cuentaxcliente ON cxn_id_cnt = cnt_id
                WHERE cxn_id_tcn = $tipo_cuenta
                AND cxn_id_cec = dcf_id_cec
                AND cxn_id_cli = fac_id_cli
                LIMIT 1
            ), (SELECT cnt_nombre FROM cnt_cuenta_contable WHERE cnt_id = $cuenta_defecto)) AS cnt_nombre
            FROM fac_factura
            JOIN def_detalle_fact ON fac_id = def_id_fac
            JOIN dcf_detalle_centrocostoxfactura ON def_id = dcf_id_def
            WHERE fac_id = ".$where['fac_id']."
            GROUP BY cnt_id
        ";

        return $this->db->query($query)->result_array();
        //return $this->db->last_query();
    }

    /**
     * @author Elman Ortiz
     * @since 09/02/2018
     * @method Determina si hay productos que afectan o no inventario en una factura
    */
    function existe_prod_afec_inv($where) {
        $query = $this->db->select('IF(COUNT(*)>0,TRUE,FALSE) AS afecta_inv', false)
                ->from('fac_factura')
                ->join('def_detalle_fact', 'fac_id = def_id_fac')
                ->join('art_articulo', 'def_id_art = art_id')
                ->where($where);

        return $query->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 09/12/2017
     * @method Se obtiene la Cuenta contable del producto (Cuando el producto afecta el inventario)
    */
    public function get_cnt_x_prod_x_fac_afec_inv($where){
        $query = "
                SELECT
                    SUM(def_precio_inventario * def_cantidad) AS subtotal_prod,
                    (
                        SELECT
                            cnt_id
                        FROM
                            dta_detalle_tipoarticulo
                        JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                        WHERE
                            dta_id_tia = tia_id
                        AND dta_id_tcn = ".$where['tcn_id']."
                        AND dta_id_cec = ".$where['cec_id']."
                        LIMIT 1
                    ) AS cnt_id,
                    (
                        SELECT
                            cnt_nombre
                        FROM
                            dta_detalle_tipoarticulo
                        JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                        WHERE
                            dta_id_tia = tia_id
                        AND dta_id_tcn = ".$where['tcn_id']."
                        AND dta_id_cec = ".$where['cec_id']."
                        LIMIT 1
                    ) AS cnt_nombre,
                    (
                        SELECT
                            dta_id_cec
                        FROM
                            dta_detalle_tipoarticulo
                        JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                        WHERE
                            dta_id_tia = tia_id
                        AND dta_id_tcn = ".$where['tcn_id']."
                        AND dta_id_cec = ".$where['cec_id']."
                        LIMIT 1
                    ) AS cec_id
                FROM
                    fac_factura
                JOIN def_detalle_fact ON fac_id = def_id_fac
                JOIN art_articulo ON def_id_art = art_id
                JOIN tia_tipo_articulo ON art_id_tia = tia_id
                WHERE
                    fac_id = ".$where['fac_id']." AND art_inventario = 1"
        ;

        return $this->db->query($query)->result_array();

    }

    /**
     * @author Habby Lovo
     * @since  2018-02-12
     * @return Obtiene todos los componentes
    */
    public function get_factura_proyecto($where = null){
        /*SELECT
            tif_abreviacion,
            fac_numero,
            fac_fecha_fact,
            CASE fac_estado
                WHEN 0 THEN
                    "Anulada"
                WHEN 1 THEN
                    "Pendiente"
                WHEN 2 THEN
                    "Pagado"
            END AS estado,
            IF (
                cli_personeria = 1,
                CONCAT(
                    cli_codigo,
                    " - ",
                    cli_nombre,
                    " ",
                    cli_apellido
                ),
                CONCAT(
                    cli_codigo,
                    " - ",
                    cli_apellido
                )
            ) cliente,
             CONCAT_WS(
                ' - ',
                pcl_codigo,
                pcl_nombre
            ) proyecto,
             epr_nombre,
             SUM(fac_subtotal) subtotal,
             SUM(fac_descuento) descuento,
             SUM(fac_impuesto) impuesto,
             (
                SUM(fac_subtotal) + SUM(fac_impuesto) - SUM(fac_descuento)
            ) total
            FROM
                fac_factura
            INNER JOIN tif_tipo_factura ON tif_id = fac_id_tif
            INNER JOIN pcl_proyecto_cliente ON pcl_id = fac_id_pcl
            INNER JOIN cli_cliente ON cli_id = pcl_id_cli
            INNER JOIN epr_estado_proyecto ON epr_id = pcl_id_epr
            GROUP BY fac_id*/
        $query = $this->db->select("
                CONCAT(tif_abreviacion,'-',fac_numero) numero_factura,
                tif_abreviacion,
                fac_numero,
                fac_fecha_fact,
                CASE fac_estado
                    WHEN 0 THEN
                        'Anulada'
                    WHEN 1 THEN
                        'Pendiente'
                    WHEN 2 THEN
                        'Pagado'
                END AS estado,
                IF (
                    cli_personeria = 1,
                    CONCAT(
                        cli_codigo,
                        ' - ',
                        cli_nombre,
                        ' ',
                        cli_apellido
                    ),
                    CONCAT(
                        cli_codigo,
                        ' - ',
                        cli_apellido
                    )
                ) cliente,
                 CONCAT_WS(
                    ' - ',
                    pcl_codigo,
                    pcl_nombre
                ) proyecto,
                 epr_nombre,
                 SUM(fac_subtotal) subtotal,
                 SUM(fac_descuento) descuento,
                 SUM(fac_impuesto) impuesto,
                 (
                    SUM(fac_subtotal) + SUM(fac_impuesto) - SUM(fac_descuento)
                ) total", false)
            ->from('fac_factura')
            ->join('tif_tipo_factura','tif_id = fac_id_tif','inner')
            ->join('pcl_proyecto_cliente','pcl_id = fac_id_pcl','inner')
            ->join('cli_cliente','cli_id = pcl_id_cli','inner')
            ->join('epr_estado_proyecto','epr_id = pcl_id_epr','inner')
            ->group_by('fac_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-02-12
     * @return Obtiene todas las facturas
    */
    public function get_detalle_factura_proyecto($where = null){
        /*SELECT
            fac_numero,
            art_codigo,
            art_nombre,
            SUM(def_cantidad) cantidad,
            SUM(def_precio) precio,
            SUM(def_subtotal) subtotal,
            SUM(def_descuento) descuento,
            SUM(def_impuesto) impuesto,
            SUM(def_subtotal + def_impuesto - def_descuento) total
        FROM
            def_detalle_fact
        INNER JOIN fac_factura ON fac_id = def_id_fac
        INNER JOIN pcl_proyecto_cliente ON pcl_id = fac_id_pcl
        INNER JOIN art_articulo ON art_id = def_id_art
        INNER JOIN epr_estado_proyecto ON epr_id = pcl_id_epr
        GROUP BY fac_id*/
        $query = $this->db->select("
                fac_numero,
                art_codigo,
                art_nombre,
                SUM(def_cantidad) cantidad,
                SUM(def_precio) precio,
                SUM(def_subtotal) subtotal,
                SUM(def_descuento) descuento,
                SUM(def_impuesto) impuesto,
                SUM(def_subtotal + def_impuesto - def_descuento) total", false)
            ->from('def_detalle_fact')
            ->join('fac_factura','fac_id = def_id_fac','inner')
            ->join('pcl_proyecto_cliente','pcl_id = fac_id_pcl','inner')
            ->join('art_articulo','art_id = def_id_art','inner')
            ->join('epr_estado_proyecto','epr_id = pcl_id_epr','inner')
            ->group_by('fac_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_estado_proyecto_cliente($where = null) {
        $query = $this->db->distinct()
                ->select('epr_id,epr_nombre')
                ->from('pcl_proyecto_cliente')
                ->join('epr_estado_proyecto', 'pcl_id_epr = epr_id');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_centro_costo($where = null, $id_pais_defecto=null){
        /*
            SELECT * FROM dta_detalle_tipoarticulo
            INNER JOIN tcn_tipo_cuenta ON tcn_id = dta_id_tcn
            INNER JOIN cec_centro_costo ON cec_id = dta_id_cec
            INNER JOIN cnt_cuenta_contable ON cnt_id = dta_id_cnt
            WHERE dta_id_tia = 117
        */
        //$id_pais_defecto = $this->gsatelite->get_parametro('SYS_ID_PAIS');
        $id_pais_defecto = $this->tank_auth->get_all_empresa()->emr_id_pai;
        if(!($id_pais_defecto > 0)){
            $id_pais_defecto = 7;
        }
        //print_r($this->tank_auth->get_all_empresa()); die();
        $query = $this->db->select('*, IFNULL(pai_nombre,(SELECT pai_nombre FROM pai_pais where pai_id ='.$id_pais_defecto.')) AS nombre_pais, IFNULL(pai_id,(SELECT pai_id FROM pai_pais where pai_id = '.$id_pais_defecto.')) AS id_pais')
                ->from('dta_detalle_tipoarticulo')
                ->join('tcn_tipo_cuenta', 'tcn_id = dta_id_tcn')
                ->join('cec_centro_costo', 'cec_id = dta_id_cec')
                ->join('cnt_cuenta_contable', 'cnt_id = dta_id_cnt')
                ->join('pai_pais', 'pai_id = dta_id_pai','LEFT');
        if ($where != null) {
            $this->db->where($where);
        }

        // $this->db->limit(1);
        return $query->get()->result_array();
        //return print_r($this->db->last_query()); die();
    }

    /**
    * @author Edith Herrera - Grupo Satélite
    * @since  2018-03-21
    * @return Materias y grupos del pensum asociadas al grado
    **/
     public function get_grupos_grado($where = null){
        $query = $this->db->select()
                ->from('pen_pensum')
                ->join('mod_modulo', 'pen_id_mod= mod_id')
                ->join('gra_grupo_academico', 'gra_id_pen=pen_id AND gra_id_ard=pen_id_ard', 'left')
            ;
        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('pen_id');

        return $query->get()->result_array();
    }


    /**
    * @author Edith Herrera - Grupo Satélite
    * @since  2018-04-06
    * @return Facturas pagadas por hora.
    **/

    public function ventasxhora($where = null, $groupby = null) {

            $this->db->select('
                GROUP_CONCAT(DISTINCT caj_nombre) AS cajas,
                 GROUP_CONCAT(DISTINCT tif_nombre) AS tipo,
                GROUP_CONCAT(DISTINCT fac_id) AS totales,
                SUM(fac_total) AS monto,
                COUNT(DISTINCT fac_id) as cantidad, DATE_FORMAT(fac_fecha_crea, ("%H" )) AS hora,
                fac_estado, fac_subtotal, fac_fecha_crea, suc_nombre, caj_nombre',false)
                ->from('fac_factura AS fac')
                ->join('cof_correlativo_factura', 'cof_id = fac_id_cof', 'left')
                ->join('sef_serie_factura', 'sef_id = cof_id_sef', 'left')
                ->join('tif_tipo_factura', 'sef_id_tif = tif_id', 'left')
                ->join('uxc_usuarioxcaja', 'fac_id_uxc  = uxc_id', 'left')
                ->join('caj_caja', 'caj_id  = uxc_id_caj', 'left')
                ->join('suc_sucursal', 'suc_id  = fac_id_suc', 'left')
                ->where('fac_estado', 2)
                ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        $this->db->order_by('DATE_FORMAT(fac_fecha_crea, ("%H"))');

        return $this->db->get()->result_array();
    }

    public function get_centro_costo_detalle_fac($where = null){
        /* SELECT * FROM dcf_detalle_centrocostoxfactura
            INNER JOIN cec_centro_costo ON cec_id = dcf_id_cec
            INNER JOIN tcn_tipo_cuenta ON tcn_id = dcf_id_tcn
            INNER JOIN cnt_cuenta_contable ON cnt_id = dcf_id_cnt
            WHERE dcf_id_def = 6901
        */
        $query = $this->db->select('*, , dcf_porcentaje porcentaje, dcf_monto monto', false)
                ->from('dcf_detalle_centrocostoxfactura')
                ->join('tcn_tipo_cuenta', 'tcn_id = dcf_id_tcn')
                ->join('cec_centro_costo', 'cec_id = dcf_id_cec')
                ->join('cnt_cuenta_contable', 'cnt_id = dcf_id_cnt');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function consolid_facXdia($where = null, $groupby = null) {
        $this->db->select('fac_fecha_fact, fac_fecha_cont, COUNT(fac_id) AS ctdad, SUM(fac_total) AS fac_total',false)->from('fac_factura');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        return $this->db->get()->result_array();
    }

    public function get_impuesto2($where = null){
        /*
            SELECT
                CONCAT_WS(
                    '&#',
                    GROUP_CONCAT(imp_porcentaje),
                    SUM(imp_porcentaje),
                    GROUP_CONCAT(imp_id)
                ) as impuesto
            FROM
                imp_impuesto
            where imp_id in (1,2)
        */
        $query = $this->db->select("
                CONCAT_WS(
                    '&#',
                    GROUP_CONCAT(imp_porcentaje),
                    SUM(imp_porcentaje),
                    GROUP_CONCAT(imp_id)
                ) as impuesto", false)
                ->from('imp_impuesto');
        if ($where != null) {
            $this->db->where_in('imp_id',$where);
        }
        return $query->get()->result_array();
    }

    public function get_retencione2($where = null){
        $query = $this->db->select("
                CONCAT_WS(
                    '&#',
                    GROUP_CONCAT(ret_porcentaje),
                    SUM(ret_porcentaje),
                    GROUP_CONCAT(ret_id)
                ) as retencion", false)
                ->from('ret_retencion');
        if ($where != null) {
            $this->db->where_in('ret_id',$where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 23/03/2018
     * @method Se obtiene la Cuenta contable del producto (Cuando el producto factura afecta/no afecta el inventario)
    */
    public function get_cnt_x_prod_x_fac_anular($where, $return = null){

        if($return){//Retornar array para el modulo de contabilidad
            $query = "
                    SELECT
                    fac_id,
                    SUM(def_subtotal) AS subtotal_prod,
                    tia_id,
                    (
                        SELECT cnt_id
                        FROM dta_detalle_tipoarticulo
                        JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                        WHERE dta_id_tia = tia_id AND dta_id_tcn = ".$where['idtipo_cnt']."
                        LIMIT 1
                    ) AS cnt_id,
                    (
                        SELECT cnt_cuenta
                        FROM dta_detalle_tipoarticulo
                        JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                        WHERE dta_id_tia = tia_id AND dta_id_tcn = ".$where['idtipo_cnt']."
                        LIMIT 1
                    ) AS cuenta,
                    (
                        SELECT cnt_nombre
                        FROM dta_detalle_tipoarticulo
                        JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                        WHERE dta_id_tia = tia_id AND dta_id_tcn = ".$where['idtipo_cnt']."
                        LIMIT 1
                    ) AS cuenta_nombre
                    FROM fac_factura
                    JOIN def_detalle_fact ON fac_id = def_id_fac
                    JOIN art_articulo ON def_id_art = art_id
                    JOIN tia_tipo_articulo ON art_id_tia = tia_id
                    WHERE DATE(fac_fecha_cont) >= '".$where['fac_fecha_cont']."'
                    AND DATE(fac_fecha_cont) <= '".$where['fac_fecha_cont']."'
                    AND ".$where['fac_id_pct']."
                    AND fac_estado = 0
                    GROUP BY fac_id,cnt_id
                    LIMIT 25"
            ;
        }else{
            $query = "
                    SELECT
                    fac_id,
                    SUM(def_subtotal) AS subtotal_prod,
                    tia_id,
                    (
                        SELECT cnt_id
                        FROM dta_detalle_tipoarticulo
                        JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                        WHERE dta_id_tia = tia_id AND dta_id_tcn = ".$where['idtipo_cnt']."
                        LIMIT 1
                    ) AS cnt_id,
                    (
                        SELECT cnt_cuenta
                        FROM dta_detalle_tipoarticulo
                        JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                        WHERE dta_id_tia = tia_id AND dta_id_tcn = ".$where['idtipo_cnt']."
                        LIMIT 1
                    ) AS cuenta,
                    (
                        SELECT cnt_nombre
                        FROM dta_detalle_tipoarticulo
                        JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                        WHERE dta_id_tia = tia_id AND dta_id_tcn = ".$where['idtipo_cnt']."
                        LIMIT 1
                    ) AS cuenta_nombre
                    FROM fac_factura
                    JOIN def_detalle_fact ON fac_id = def_id_fac
                    JOIN art_articulo ON def_id_art = art_id
                    JOIN tia_tipo_articulo ON art_id_tia = tia_id
                    WHERE fac_id = ".$where['fac_id']."
                    GROUP BY cnt_id
                    LIMIT 25"
            ;
        }
        //print_r($query); die();
        return $this->db->query($query)->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 23/03/2018
     * @method Se obtiene la Cuenta contable del impuesto (Cuando la factura no afecta el inventario)
    */
    public function get_cnt_x_impu_x_fac_anular($where, $return = null){
        $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('IMPUESTOS'));

        if($return){//Retornar array para el modulo de contabilidad
            $query = "
                     SELECT
                      fac_id,
                      cxe_id_tcn,
                      imp_porcentaje,
                      ixf_monto,
                      SUM(((imp_porcentaje / 100) * def_subtotal)) AS subtotximpcuenta,
                      def_subtotal,
                      IF (ISNULL(cxe_id_cnt),0,cxe_id_cnt) AS cxe_id_cnt,
                      (
                        SELECT
                            cnt_cuenta
                        FROM
                            cnt_cuenta_contable
                        WHERE
                            cnt_id = cxe_id_cnt
                       ) cuenta,
                      (
                        SELECT
                            cnt_nombre
                        FROM
                            cnt_cuenta_contable
                        WHERE
                            cnt_id = cxe_id_cnt
                     ) cuenta_nombre
                     FROM
                        fac_factura
                     JOIN def_detalle_fact ON fac_id = def_id_fac
                     JOIN ixf_impuestoxfactura ON def_id = ixf_id_def
                     JOIN imp_impuesto ON ixf_id_imp = imp_id
                     LEFT JOIN cxe_cuentaximpuesto ON imp_id = cxe_id_imp
                     LEFT JOIN cnt_cuenta_contable ON cnt_id = cxe_id_cnt
                     WHERE DATE(fac_fecha_cont) >= '".$where['fac_fecha_cont']."'
                     AND DATE(fac_fecha_cont) <= '".$where['fac_fecha_cont']."'
                     AND ".$where['fac_id_pct']."
                     AND fac_estado = 0
                     GROUP BY
                        cxe_id_cnt,
                        fac_id
                     HAVING cxe_id_tcn = ".$tcn_id." OR ISNULL(cxe_id_tcn)
                     ORDER BY
                        def_id
                     LIMIT 25
                    ";
        }else{
            $query = "
                     SELECT
                      fac_id,
                      cxe_id_tcn,
                      imp_porcentaje,
                      ixf_monto,
                      SUM(((imp_porcentaje / 100) * def_subtotal)) AS subtotximpcuenta,
                      def_subtotal,
                      IF (ISNULL(cxe_id_cnt),0,cxe_id_cnt) AS cxe_id_cnt,
                      (
                        SELECT
                            cnt_cuenta
                        FROM
                            cnt_cuenta_contable
                        WHERE
                            cnt_id = cxe_id_cnt
                       ) cuenta,
                      (
                        SELECT
                            cnt_nombre
                        FROM
                            cnt_cuenta_contable
                        WHERE
                            cnt_id = cxe_id_cnt
                     ) cuenta_nombre
                     FROM
                        fac_factura
                     JOIN def_detalle_fact ON fac_id = def_id_fac
                     JOIN ixf_impuestoxfactura ON def_id = ixf_id_def
                     JOIN imp_impuesto ON ixf_id_imp = imp_id
                     LEFT JOIN cxe_cuentaximpuesto ON imp_id = cxe_id_imp
                     LEFT JOIN cnt_cuenta_contable ON cnt_id = cxe_id_cnt
                     WHERE
                        fac_id = ".$where['fac_id']."
                     GROUP BY
                        cxe_id_cnt,
                        fac_id
                     HAVING cxe_id_tcn = ".$tcn_id." OR ISNULL(cxe_id_tcn)
                     ORDER BY
                        def_id
                     LIMIT 25
                    ";
        }

        return $this->db->query($query)->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 23/03/2018
     * @method Se obtiene la Cuenta contable para el cliente
     * $return Si es true es del modulo de contabilidad
    */
    function get_cuenta_contable_tipopago_anular_factura($where, $return = false) {

        if($return){//Es del modulo contabilidad
            $query = "
                    SELECT
                    fac1.fac_id,
                    IFNULL((
                        SELECT cnt2.cnt_id
                        FROM fac_factura AS fac2
                        LEFT JOIN cli_cliente AS cli2 ON fac2.fac_id_cli = cli2.cli_id
                        LEFT JOIN cxn_cuentaxcliente AS cxn2 ON cli2.cli_id = cxn2.cxn_id_cli
                        LEFT JOIN tpg_tipo_pago AS tpg2 ON cxn2.cxn_id_tpg = tpg2.tpg_id
                        LEFT JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = cxn2.cxn_id_cnt
                        WHERE cxn2.cxn_id_tpg = fac1.fac_id_tpg
                        AND tpg2.tpg_id = fac1.fac_id_tpg
                        AND fac2.fac_id = fac1.fac_id
                        LIMIT 1
                    ),0) AS cnt_id,
                    (
                        SELECT cnt2.cnt_nombre
                        FROM fac_factura AS fac2
                        JOIN cli_cliente AS cli2 ON fac2.fac_id_cli = cli2.cli_id
                        JOIN cxn_cuentaxcliente AS cxn2 ON cli2.cli_id = cxn2.cxn_id_cli
                        JOIN tpg_tipo_pago AS tpg2 ON cxn2.cxn_id_tpg = tpg2.tpg_id
                        JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = cxn2.cxn_id_cnt
                        WHERE cxn2.cxn_id_tpg = fac1.fac_id_tpg
                        AND tpg2.tpg_id = fac1.fac_id_tpg
                        AND fac2.fac_id = fac1.fac_id
                        LIMIT 1
                    ) AS cnt_nombre
                    FROM fac_factura AS fac1
                    LEFT JOIN cli_cliente ON fac1.fac_id_cli = cli_id
                    LEFT JOIN cxn_cuentaxcliente ON fac_id_cli = cxn_id_cli
                    LEFT JOIN tpg_tipo_pago ON cxn_id_tpg = tpg_id
                    LEFT JOIN cnt_cuenta_contable ON cnt_id = cxn_id_cnt
                    WHERE DATE(fac_fecha_cont) >= '".$where['fac_fecha_cont']."'
                    AND DATE(fac_fecha_cont) <= '".$where['fac_fecha_cont']."'
                    AND fac_estado = 0
                    GROUP BY fac1.fac_id
                ";
        }else{
            $query = "
                    SELECT
                    fac1.fac_id,
                    IFNULL((
                        SELECT cnt2.cnt_id
                        FROM fac_factura AS fac2
                        LEFT JOIN cli_cliente AS cli2 ON fac2.fac_id_cli = cli2.cli_id
                        LEFT JOIN cxn_cuentaxcliente AS cxn2 ON cli2.cli_id = cxn2.cxn_id_cli
                        LEFT JOIN tpg_tipo_pago AS tpg2 ON cxn2.cxn_id_tpg = tpg2.tpg_id
                        LEFT JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = cxn2.cxn_id_cnt
                        WHERE cxn2.cxn_id_tpg = fac1.fac_id_tpg
                        AND tpg2.tpg_id = fac1.fac_id_tpg
                        AND fac2.fac_id = fac1.fac_id
                        LIMIT 1
                    ),0) AS cnt_id,
                    (
                        SELECT cnt2.cnt_nombre
                        FROM fac_factura AS fac2
                        JOIN cli_cliente AS cli2 ON fac2.fac_id_cli = cli2.cli_id
                        JOIN cxn_cuentaxcliente AS cxn2 ON cli2.cli_id = cxn2.cxn_id_cli
                        JOIN tpg_tipo_pago AS tpg2 ON cxn2.cxn_id_tpg = tpg2.tpg_id
                        JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = cxn2.cxn_id_cnt
                        WHERE cxn2.cxn_id_tpg = fac1.fac_id_tpg
                        AND tpg2.tpg_id = fac1.fac_id_tpg
                        AND fac2.fac_id = fac1.fac_id
                        LIMIT 1
                    ) AS cnt_nombre
                    FROM fac_factura AS fac1
                    LEFT JOIN cli_cliente ON fac1.fac_id_cli = cli_id
                    LEFT JOIN cxn_cuentaxcliente ON fac_id_cli = cxn_id_cli
                    LEFT JOIN tpg_tipo_pago ON cxn_id_tpg = tpg_id
                    LEFT JOIN cnt_cuenta_contable ON cnt_id = cxn_id_cnt
                    WHERE fac1.fac_id = ".$where['fac_id']."
                    GROUP BY fac1.fac_id
                ";
        }

        return $this->db->query($query)->result_array();
    }

    /**
     * @author Luis Navarro
     * @since 17/04/2018
     * @method Se obtiene los correlativos de caja por usuario
    */
    public function get_datos_corr_usuarioxcaja($where = null, $groupby = null) {
        $query = $this->db->select(
            '
            uxc_id,
            uxc_id_usu,
            cof_id,
            fac_id_tif,
            GROUP_CONCAT(DISTINCT fac_numero ORDER BY fac_numero ASC) AS facturas,
            MIN(fac_numero) AS corrPrimero,
            MAX(fac_numero) AS corrUltimo,
            COUNT(DISTINCT fac_id) AS cantidadFac
            ', false
        )
            ->from('uxc_usuarioxcaja')
            ->join('fac_factura', 'fac_id_uxc = uxc_id')
            ->join('cof_correlativo_factura', 'fac_id_cof = cof_id')
            ->join('cxj_correlativoxcaja', 'cxj_id_cof = cof_id')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since 17/04/2018
     * @method Se obtiene los tipos de pagos de caja por usuario
    */
    public function get_datos_pago_usuarioxcaja($where = null, $groupby = null, $tipo = 1) {
        $query = $this->db->select(
            '
            GROUP_CONCAT(fac_id) AS facturas,
            uxc_id,
            fac_id_tif,
            fac_id_tpg,
            fac_id_frp,
            sum(if(fac_estado = 0,0,if((
                    SELECT ROUND(SUM((def_subtotal + def_impuesto)), 6) FROM def_detalle_fact
                    WHERE def_id_fac = fac_id
            ) > 0, (
                    SELECT SUM(ROUND((def_subtotal + def_impuesto),4)) FROM def_detalle_fact
                    WHERE def_id_fac = fac_id
            ), (if(fac_id_tif = 18 ,(
                    SELECT ROUND(SUM(def_subtotal + def_impuesto),2) FROM def_detalle_fact
                    WHERE def_id_fac = fac_id
            ) ,0)) ))) AS gravadatotal,
            COUNT(fac_numero) AS cantidadFac
            ', false
        )
            ->from('uxc_usuarioxcaja')
            ->join('fac_factura', 'fac_id_uxc = uxc_id', 'left')
            ;

        if ($where != null) {
            if($tipo == 1){
                $this->db->where($where);
            } else{
                $this->db->where_in('uxc_id', $where);
            }
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since 17/04/2018
     * @method Se obtiene las categorias por factura por cajero
    */
    public function get_catxproductos_usuarioxcaja($where = null, $groupby = null) {
        $query = $this->db->select(
            '
            tia_id,
            uxc_id,
            SUM(ROUND((def_subtotal + def_impuesto), 4)) AS total,
            COUNT(art_id) AS prodTotal,
            COUNT(DISTINCT art_id) AS prodDistintos,
            COUNT(DISTINCT fac_id) AS facturas,
            GROUP_CONCAT(DISTINCT fac_id ORDER BY fac_id ASC) AS numFacturas
            ', false
        )
            ->from('uxc_usuarioxcaja')
            ->join('fac_factura', 'fac_id_uxc = uxc_id AND fac_estado != 0')
            // ->join('fac_factura', 'fac_id_uxc = uxc_id AND fac_estado != 0')
            ->join('def_detalle_fact', 'def_id_fac = fac_id')
            ->join('art_articulo', 'art_id = def_id_art')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since 18/04/2018
     * @method Se obtiene los datos de la caja por usuario
    */
    public function get_datos_usuarioxcaja($where = null, $groupby = null, $orderby = null) {
        $query = $this->db->select("*, (SELECT CONCAT(emp.emp_nombre, ' ', emp.emp_apellido) from uxc_usuarioxcaja as uxc INNER JOIN emp_empleado as emp ON emp.emp_id_usu = uxc.uxc_id_usu WHERE uxc.uxc_id_caj = uxc_id_caj order by uxc.uxc_id DESC limit 1) as empleado", false)
        ->from('uxc_usuarioxcaja')
        ->join('caj_caja', 'uxc_id_caj = caj_id')
        ->join('cxj_correlativoxcaja', 'cxj_id_caj = caj_id AND cxj_estado = 1')
        ->join('cof_correlativo_factura', 'cof_id = cxj_id_cof')
        ->join('sef_serie_factura', 'sef_id = cof_id_sef AND sef_estado = 1')
        ->join('users', 'id = uxc_id_usu')
        ->join('uxr_usuarioxrol', 'uxr_id_usu = id')
        ->join('rol_rol', 'rol_id = uxr_id_rol')
        ->join('emp_empleado', 'emp_id_usu = id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        $this->db->limit(1);

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since 18/04/2018
     * @method Se obtiene los correlativos de corte por caja
    */
    public function get_correlativos_cortexcaja($where = null, $groupby = null, $orderby = null, $tipo = 1) {
        $inicios_fin = "crc_correlativo_inicio, crc_correlativo_fin";
        if($groupby) {
           $inicios_fin = " MIN(crc_correlativo_inicio) crc_correlativo_inicio, MAX(crc_correlativo_fin) crc_correlativo_fin"; 
        }
        $query = $this->db->select(
        "
        crc_id_uxc,
        crc_id_tif,
        tif_nombre,
        tif_abreviacion,
        $inicios_fin
        "
        )
        ->from('crc_correlativo_cortexcaja')
        ->join('uxc_usuarioxcaja', 'crc_id_uxc = uxc_id')
        ->join('cof_correlativo_factura', 'crc_id_cof = cof_id')
        ->join('tif_tipo_factura', 'crc_id_tif = tif_id')
        ;

        if ($where != null) {
            if($tipo == 1){
                $this->db->where($where);
            } else{
                $this->db->where_in('uxc_id', $where);
            }
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since 18/04/2018
     * @method Se obtiene los tipo de pagos por corte de caja
    */
    public function get_tipo_pago_corte($where = null, $groupby = null, $orderby = null, $tipo = 1) {
        $contado = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA',null,null,array('CONTADO'));
        $credito = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA',null,null,array('CREDITO'));
        $query = $this->db->select(
            "
        tif_nombre,
        tif_abreviacion,
        SUM(DISTINCT(
            SELECT SUM(dgc2.dgc_total) FROM dgc_detalle_pago_corte AS dgc2
            WHERE dgc2.dgc_id_tpg = 1 AND dgc2.dgc_id_tif = dcg1.dgc_id_tif AND dgc2.dgc_id_uxc = dcg1.dgc_id_uxc
        )) AS contado, 
        SUM(DISTINCT(
            SELECT SUM(dgc3.dgc_total) FROM dgc_detalle_pago_corte AS dgc3
            WHERE dgc3.dgc_id_tpg = 2 AND dgc3.dgc_id_tif = dcg1.dgc_id_tif AND dgc3.dgc_id_uxc = dcg1.dgc_id_uxc
        )) AS credito, 
        SUM(DISTINCT(
            SELECT SUM(dgc4.dgc_total) FROM dgc_detalle_pago_corte AS dgc4
            WHERE dgc4.dgc_id_uxc = dcg1.dgc_id_uxc AND dgc4.dgc_id_tif = dcg1.dgc_id_tif AND (dgc4.dgc_id_tpg != 1 AND dgc4.dgc_id_tpg != 2)
        )) AS otros, 
        SUM(DISTINCT(
            SELECT COUNT(fac_id) FROM fac_factura
            WHERE fac_id_uxc = dcg1.dgc_id_uxc AND fac_id_tif = dcg1.dgc_id_tif
        )) AS facturas, 
        SUM(DISTINCT(
            SELECT COUNT(fac_id) FROM fac_factura
            WHERE fac_id_uxc = dcg1.dgc_id_uxc AND fac_id_tif = dcg1.dgc_id_tif AND fac_id_origen_devolucion IS NOT NULL
        )) AS devolucion, 
        SUM(DISTINCT(
            SELECT SUM(fac_total) FROM fac_factura
            WHERE fac_id_uxc = dcg1.dgc_id_uxc AND fac_id_tif = dcg1.dgc_id_tif AND fac_id_origen_devolucion IS NOT NULL
        )) AS devmonto,
        dcg1.*
            ", false)
        ->from('dgc_detalle_pago_corte AS dcg1')
        ->join('uxc_usuarioxcaja', 'dcg1.dgc_id_uxc = uxc_id')
        ->join('tif_tipo_factura', 'dgc_id_tif = tif_id')
        // ->join('tpg_tipo_pago', 'dgc_id_tpg = tpg_id')
        ;

        if ($where != null) {
            if($tipo == 1){
                $this->db->where($where);
            } else{
                $this->db->where_in('uxc_id', $where);
            }
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since 18/04/2018
     * @method Se obtiene las facturas por categoria en corte por caja
    */
    public function get_fact_categoria_corte($where = null, $groupby = null, $orderby = null, $tipo = 1) {
        $query = $this->db->select(
            "
            tia_codigo,
            tia_nombre,
            SUM(dft_total) AS total,
            dft_detalle_fact_tipoart.*
            "
            , false)
        ->from('dft_detalle_fact_tipoart')
        ->join('uxc_usuarioxcaja', 'dft_id_uxc = uxc_id')
        ->join('tia_tipo_articulo', 'dft_id_tia = tia_id')
        ;

        if ($where != null) {
            if($tipo == 1){
                $this->db->where($where);
            } else{
                $this->db->where_in('uxc_id', $where);
            }
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera
     * @since  2018-04-10
     * @return Información de las inscripciones según la factura.
     *
    **/
    public function get_registro_alumno($where = null) {
        $query = $this->db->select('lxp_id, lxp_condicion, lxp_estado, lxp_promedio, lxa_id, lxa_id_alm, fac_id, fac_estado, gra_cerrado, gra_nombre, gra_id_grd', FALSE)
             ->from('lxp_alumnoxpensum')
             ->join('lxa_alumnoxarea', 'lxp_id_lxa = lxa_id')
             ->join('fac_factura', 'lxp_id_fac = fac_id')
             ->join('gra_grupo_academico', 'lxp_id_gra = gra_id')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('lxp_id');

        return $query->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 11/04/2018
     * @method Se obtiene la Cuenta contable del producto (Cuando el producto factura afecta/no afecta el inventario)
    */
    public function get_cnt_x_haber_x_fac_anular($where){

            $query = "
                    SELECT
                        fac1.fac_id,
                        (
                            SELECT ROUND(SUM(def_subtotal+IFNULL(def_impuesto,0.00)+IFNULL(def_retencion,0.00)),2)
                            FROM fac_factura AS fac3
                            JOIN def_detalle_fact ON fac3.fac_id = def_id_fac
                            WHERE fac3.fac_id = fac1.fac_id
                        ) as total,
                        tia1.tia_id,
                        (
                            SELECT cnt2.cnt_id
                            FROM fac_factura AS fac2
                            JOIN cli_cliente AS cli2 ON fac2.fac_id_cli = cli2.cli_id
                            JOIN cxn_cuentaxcliente AS cxn2 ON cli2.cli_id = cxn2.cxn_id_cli
                            JOIN tpg_tipo_pago AS tpg2 ON cxn2.cxn_id_tpg = tpg2.tpg_id
                            JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = cxn2.cxn_id_cnt
                            WHERE cxn2.cxn_id_tpg = fac1.fac_id_tpg
                            AND tpg2.tpg_id = fac1.fac_id_tpg
                            AND fac2.fac_id = fac1.fac_id
                            LIMIT 1
                        ) AS cnt_id,
                        (
                            SELECT cnt2.cnt_nombre
                            FROM fac_factura AS fac2
                            JOIN cli_cliente AS cli2 ON fac2.fac_id_cli = cli2.cli_id
                            JOIN cxn_cuentaxcliente AS cxn2 ON cli2.cli_id = cxn2.cxn_id_cli
                            JOIN tpg_tipo_pago AS tpg2 ON cxn2.cxn_id_tpg = tpg2.tpg_id
                            JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = cxn2.cxn_id_cnt
                            WHERE cxn2.cxn_id_tpg = fac1.fac_id_tpg
                            AND tpg2.tpg_id = fac1.fac_id_tpg
                            AND fac2.fac_id = fac1.fac_id
                            LIMIT 1
                        ) AS cnt_nombre,
                        (
                            SELECT cnt2.cnt_cuenta
                            FROM fac_factura AS fac2
                            JOIN cli_cliente AS cli2 ON fac2.fac_id_cli = cli2.cli_id
                            JOIN cxn_cuentaxcliente AS cxn2 ON cli2.cli_id = cxn2.cxn_id_cli
                            JOIN tpg_tipo_pago AS tpg2 ON cxn2.cxn_id_tpg = tpg2.tpg_id
                            JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = cxn2.cxn_id_cnt
                            WHERE cxn2.cxn_id_tpg = fac1.fac_id_tpg
                            AND tpg2.tpg_id = fac1.fac_id_tpg
                            AND fac2.fac_id = fac1.fac_id
                            LIMIT 1
                        ) AS cnt_cuenta
                    FROM fac_factura AS fac1
                    JOIN def_detalle_fact AS def1 ON fac1.fac_id = def1.def_id_fac
                    JOIN art_articulo AS art1 ON def1.def_id_art = art1.art_id
                    JOIN tia_tipo_articulo AS tia1 ON art1.art_id_tia = tia1.tia_id
                    WHERE DATE(fac1.fac_fecha_cont) >= '".$where['fac_fecha_cont']."'
                    AND DATE(fac1.fac_fecha_cont) <= '".$where['fac_fecha_cont']."'
                    AND fac1.fac_estado = 0
                    GROUP BY fac1.fac_id,cnt_id"
            ;

        return $this->db->query($query)->result_array();
    }

    /**
     * @author Habby Lovo
     * @since 09/04/2018
     * @method Se obtiene los ID de los usuarios por caja
    */
    function obtener_usuarioscaja_dia($where = null){

        $query = $this->db->select("(
                    SELECT
                        GROUP_CONCAT(uxc.uxc_id)
                    FROM
                        uxc_usuarioxcaja as uxc
                    WHERE
                        date_format(uxc.uxc_fecha_proceso, '%Y-%m-%d') = date_format(uxc2.uxc_fecha_proceso, '%Y-%m-%d') and uxc.uxc_id_caj = uxc2.uxc_id_caj
                ) as id_uxc", FALSE)
             ->from('uxc_usuarioxcaja as uxc2')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since 25/05/2018
     * @method Se obtiene los ID de los usuarios por caja para el corte Mensual
    */
    function obtener_corte_caja_uxc($where = null) {
        $query = $this->db->select("GROUP_CONCAT(uxc.uxc_id) AS uxc_id", FALSE)
             ->from('uxc_usuarioxcaja as uxc')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since 29/05/2018
     * @method Se obtiene las ventas realizadas en las cajas por fecha y hora
    */
    function get_venta_x_hora($where = null, $groupby = null, $orderby = null) {
        $query = $this->db->select("suc_id, suc_nombre, emp_nombre, emp_apellido, caj_nombre, COUNT(fac_id) AS transacciones, SUM(fac_total) AS monto_fac,
            SUM((SELECT SUM((def_subtotal + def_impuesto)) FROM def_detalle_fact WHERE def_id_fac = fac_id)) AS monto", FALSE)
                ->from('fac_factura')
                ->join('suc_sucursal', 'suc_id = fac_id_suc')
                ->join('uxc_usuarioxcaja', 'uxc_id = fac_id_uxc', 'left')
                ->join('caj_caja', 'caj_id = uxc_id_caj', 'left')
                ->join('users', 'id = uxc_id_usu', 'left')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
            ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since 29/05/2018
     * @method Se obtiene los precios de ventas
    */
    function get_preciosxventas($where = null, $groupby = null, $orderby = null) {

        $query = $this->db->select(
            "
                art_id,
                art_codigo,
                art_nombre,
                tlp_nombre,
                lip_desde,
                lip_hasta,
                lip_precio

            ", FALSE)
             ->from('fac_factura')
             ->join('def_detalle_fact', 'fac_id = def_id_fac', 'inner')
             ->join('art_articulo', 'def_id_art = art_id')
             ->join('lip_listado_precio', 'def_id_lip = lip_id', 'inner')
             ->join('tlp_tipo_lista_precio', 'lip_id_tlp = tlp_id', 'inner')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_movimiento_devolucion($id_fac = 0)
    {
        $this->db->select("moi_id_bod, dee_id_art")
                ->from('moi_movimiento_inv')
                ->join('fac_factura', 'fac_id = moi_id_fac')
                ->join('dee_detalle_mov' , 'dee_id_moi = moi_id')
                ->where('moi_id_fac', $id_fac)
                ->group_by('dee_id_art')
                ;
        return $this->db->get()->result_array();
    }



    /**
     * @author Edith Herrera - Grupo satélite.
     * @since  2018-06-04
     * @return Inscripciones de grado
     *
    **/
    public function get_inscripcion_grado($where = null) {
        $query = $this->db->select('gxa_id_alm, gxa_id_grd, gxa_estado_grado, gra_nombre,grd_nombre, lxp_condicion, lxp_estado, lxp_tipo_inscripcion', FALSE)
             ->from('gra_grupo_academico')
             ->join('grd_grado', 'gra_id_grd=grd_id')
             ->join('lxp_alumnoxpensum', 'lxp_id_gra = gra_id')
             ->join('lxa_alumnoxarea', 'lxa_id= lxp_id_lxa')
             ->join('gxa_gradoxalumno', 'gxa_id_alm = lxa_id_alm AND gxa_id_grd=grd_id')
             ->where('lxp_estado',1)
             ->where_in('lxp_condicion', '1,2') //Inscrito y aprobado
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_valor_ultima_entrada($where=null){
        $query = $this->db->select('sar_id, sar_id_art, sar_precio, sar_estado, cva_id_mep,dee_fecha_creacion,dxd_precio_unitario', FALSE)
             ->from('sar_saldo_articulo')
             ->join('dee_detalle_mov', 'dee_id_sar = sar_id')
             ->join('cva_conversion_articulo', 'cva_id = dee_id_cva')
             ->join('moi_movimiento_inv', 'moi_id = dee_id_moi')
             ->join('dpv_documento_proveedor', 'dpv_id = moi_id_dpv', 'left')
             ->join('dxd_detalle_documento_proveedor', 'dpv_id = dxd_id_dpv', 'left')
             //->where('dxd_precio_unitario IS NOT NULL')
             ->limit(1)
             ->order_by('sar_id DESC, dpv_fecha_documento ASC')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->row_array();
    }


    public function proyeccion_cajas($caja = null, $fecha_inicio = null, $fecha_fn = null, $sucursal = null, $group=null) {
        $this->db->select('DATE_FORMAT(fac_fecha_fact, "%d-%m-%Y") AS fecha, caj_nombre, caj_id, ABS(SUM(IF(fac_id_origen_devolucion IS NULL,0, fac_total))) AS devoluciones,
                    SUM(IF( (fac_monto_abono <= 0 AND fac_id_origen_devolucion IS NOT NULL) OR fac_monto_abono<=0, fac_total, fac_monto_abono)) AS total_caja',false)
                ->from('fac_factura')
                ->join('tif_tipo_factura', 'fac_id_tif = tif_id', 'left')
                ->join('paf_pago_factura', 'paf_id_fac = fac_id', 'left')
                ->join('uxc_usuarioxcaja', 'fac_id_uxc  = uxc_id', 'left')
                ->join('caj_caja', 'caj_id  = uxc_id_caj', 'left')
        ;

        if ($caja != null) {
            $this->db->where('uxc_id_caj', $caja);
        }
        if (is_numeric($sucursal)) {
            $this->db->where("fac_id_suc", $sucursal);
        }
        if ($fecha_inicio != null) {
            $this->db->where("DATE(fac_fecha_fact) >=", "'".$fecha_inicio."'",false);
        }
        if ($fecha_fn != null) {
            $this->db->where("DATE(fac_fecha_fact) <=", "'".$fecha_fn."'",false);
        }


        if($group != null){
            $this->db->group_by($group);
        }else{
            $this->db->group_by('DAY(fac_fecha_fact), caj_id');
        }

        $this->db->order_by('DAY(fac_fecha_fact)');

        return $this->db->get()->result_array();
    }

    /**
     * Descripción: Actualizacion
     * Reporte de proyección de ventas
     * @author Manuel Anzora - Grupo Satélite
     * @since  2018-11-28
     * @param  Ninguno
     * @return Registros por cajas.
     */
    public function get_estimado_fac($where, $periodo){
        /*
        SELECT
            caj_estimado_facturacion,
            ( SELECT mtc_meta_venta FROM mtc_meta_caja WHERE mtc_id_caj = caj_id AND DATE_FORMAT( mtc_periodo, '%Y-%m' ) = '2018-10' ) mtc_meta_venta 
            FROM
            caj_caja 
            WHERE caj_id = 67
        */
        $registro = $this->db->select("caj_estimado_facturacion,
            ( SELECT mtc_meta_venta FROM mtc_meta_caja WHERE mtc_id_caj = caj_id AND DATE_FORMAT( mtc_periodo, '%Y-%m' ) = '$periodo' ) mtc_meta_venta", false)
            ->from('caj_caja')
            ->where($where);
        $registro = $this->db->get()->result_array();
        if ($registro) {
            foreach ($registro as $field => $value) {
                if ($field == $campo) {
                    return $value;
                }
            }
        }else{
            return null;
        }
        //return $registro;
        /**/
    }

    public function get_supervisores_descuento($where=null){
        if ($where){
            $this->db->where($where);
        }
                    $this->db->join('sup_supervisor', 'sup_id_usu = id');
                    $this->db->join('vxs_vendedorxsupervisor', 'vxs_id_sup = sup_id');
                    $this->db->join('ven_vendedor', 'ven_id = vxs_id_ven');
        $opciones = $this->gsatelite->get_dropdown('users', '{sup_nombre} {sup_apellido}', '', array('activated' => '1'), null, '', 'id', true);
        $opciones = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $opciones);
        return $opciones;
    }


    /**
     * @author Edith Herrera - Grupo satélite.
     * @since  2018-07-02
     * @return Registros d ordenes de venta por estado.
     * @param  Array de condiciones de consulta ($where).
    **/
    public function get_ordenes_venta($where = null) {
        $query = $this->db->select('orv_fecha_orden, orv_numero_orden, fac_nombre_factura, CONCAT_WS(" ",cli_nombre,cli_apellido) as cliente, orv_total, orv_motivo_anulacion', FALSE)
            ->from('orv_orden_venta')
            ->join('cli_cliente', 'orv_id_cli = cli_id')
            ->join('fac_factura', 'fac_id = orv_id_fac', 'left')
            ->join('ven_vendedor', 'orv_id_ven = ven_id', 'left')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 08/02/2018
     * @method Se obtiene la Cuenta contable de la rentecion(Cuando la factura no afecta el inventario)
    */
    public function get_cnt_x_reten_x_fac($where){
        $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('IMPUESTOS'));
        $query = "
                 SELECT
                  fac_id,
                  dcr_id_tcn,
                  ret_porcentaje,
                  rxf_id_ret,
                  SUM(((ret_porcentaje / 100) * def_subtotal)) AS subtotxretcuenta,
                  def_subtotal,
                  IF (ISNULL(dcr_id_cnt),0,dcr_id_cnt) AS dcr_id_cnt,
                  (
                    SELECT
                        cnt_cuenta
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = dcr_id_cnt
                    LIMIT 1
                   ) cuenta,
                  (
                    SELECT
                        cnt_nombre
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = dcr_id_cnt
                    LIMIT 1
                 ) cuenta_nombre
                 FROM
                    fac_factura
                 JOIN def_detalle_fact ON fac_id = def_id_fac
                 JOIN rxf_retencionxdetalle_factura ON def_id = rxf_id_def
                 JOIN ret_retencion ON rxf_id_ret = ret_id
                 LEFT JOIN dcr_detalle_cuenta_retencion ON ret_id = dcr_id_ret
                 LEFT JOIN cnt_cuenta_contable ON cnt_id = dcr_id_cnt
                 WHERE
                    fac_id = ".$where['fac_id']."
                 GROUP BY
                    dcr_id_cnt,
                    fac_id
                 ORDER BY
                    def_id
                ";

        return $this->db->query($query)->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 23/03/2018
     * @method Se obtiene la Cuenta contable del impuesto (Cuando la factura no afecta el inventario)
    */
    public function get_cnt_x_ret_x_fac_anular($where, $return = null){
        $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('IMPUESTOS'));

        if($return){//Retornar array para el modulo de contabilidad
            $query = "
                     SELECT
                      fac_id,
                      dcr_id_tcn,
                      ret_porcentaje,
                      SUM(((ret_porcentaje / 100) * def_subtotal)) AS subtotxretcuenta,
                      def_subtotal,
                      IF (ISNULL(dcr_id_cnt),0,dcr_id_cnt) AS dcr_id_cnt,
                      (
                        SELECT
                            cnt_cuenta
                        FROM
                            cnt_cuenta_contable
                        WHERE
                            cnt_id = dcr_id_cnt
                       ) cuenta,
                      (
                        SELECT
                            cnt_nombre
                        FROM
                            cnt_cuenta_contable
                        WHERE
                            cnt_id = dcr_id_cnt
                     ) cuenta_nombre
                     FROM
                        fac_factura
                     JOIN def_detalle_fact ON fac_id = def_id_fac
                     JOIN rxf_retencionxdetalle_factura ON def_id = rxf_id_def
                     JOIN ret_retencion ON rxf_id_ret = ret_id
                     LEFT JOIN dcr_detalle_cuenta_retencion ON rxf_id_ret = dcr_id_ret


                     WHERE DATE(fac_fecha_cont) >= '".$where['fac_fecha_cont']."'
                     AND DATE(fac_fecha_cont) <= '".$where['fac_fecha_cont']."'
                     AND ".$where['fac_id_pct']."
                     AND fac_estado = 0
                     GROUP BY
                        dcr_id_cnt,
                        fac_id

                     ORDER BY
                        def_id
                     LIMIT 25
                    ";
        }else{
            $query = "SELECT
                    fac_id, 
                    dcr_id_tcn, 
                    ret_porcentaje, 
                    rxf_id_ret, 
                    IFNULL(SUM(((ret_porcentaje / 100) * def_subtotal)), 0) AS subtotxretcuenta,
                    def_subtotal, 
                    IF (ISNULL(dcr_id_cnt),0,dcr_id_cnt) AS dcr_id_cnt, 
                    (SELECT cnt_cuenta FROM cnt_cuenta_contable WHERE cnt_id = dcr_id_cnt LIMIT 1) cuenta,
                    (SELECT cnt_nombre FROM cnt_cuenta_contable WHERE cnt_id = dcr_id_cnt LIMIT 1) cuenta_nombre
                    FROM fac_factura
                    JOIN def_detalle_fact ON fac_id = def_id_fac
                    LEFT JOIN rxf_retencionxdetalle_factura ON def_id = rxf_id_def
                    LEFT JOIN ret_retencion ON rxf_id_ret = ret_id
                    LEFT JOIN dcr_detalle_cuenta_retencion ON ret_id = dcr_id_ret
                    LEFT JOIN cnt_cuenta_contable ON cnt_id = dcr_id_cnt
                    WHERE fac_id = " . $where['fac_id'] . "
                    GROUP BY dcr_id_cnt, fac_id
                    ORDER BY def_id
                    LIMIT 25
                    ";
        }

        return $this->db->query($query)->result_array();
    }

    function obtener_usuarios_rol($where = null){
        // SELECT * FROM
        // users
        // LEFT JOIN emp_empleado ON emp_id_usu = id
        // INNER JOIN uxr_usuarioxrol ON uxr_id_usu = id
        // INNER JOIN rol_rol ON rol_id = uxr_id_rol
        // INNER JOIN ven_vendedor ON ven_id_usu = id
        // WHERE rol_id = 5 and id = 1
        // GROUP BY id
        $query = $this->db->select()
             ->from('users')
             ->join('emp_empleado', 'emp_id_usu = id', 'left')
             ->join('uxr_usuarioxrol', 'uxr_id_usu = id', 'inner')
             ->join('rol_rol', 'rol_id = uxr_id_rol', 'inner')
             ->join('ven_vendedor', 'ven_id_usu = id', 'inner')
             ->order_by('id', 'desc')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_usuario_cajas($where = null){
        /*
            SELECT GROUP_CONCAT(dxc_id_uxc) FROM dxc_detallexcorte_mensual
            WHERE dxc_id_ccm = 14
        */
        $query = $this->db->select("GROUP_CONCAT(dxc_id_uxc) as usuarios_caja", false)
             ->from('dxc_detallexcorte_mensual')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_ventas_tipo($where_in = null, $groupby = null, $where = null){
        /*
            SELECT
                tpg_nombre,
                SUM(if(abc_fecha_anulacion is NOT NULL, 0, abf_monto)) as total,
                SUM(if(abc_fecha_anulacion is NOT NULL, abf_monto, 0)) as anuladas
            uxc_id
            FROM
                tpg_tipo_pago
            INNER JOIN dgc_detalle_pago_corte ON dgc_id_tpg = tpg_id
            INNER JOIN fac_factura ON fac_id_uxc = dgc_id_uxc
            INNER JOIN abf_abono_factura ON abf_id_fac = fac_id
            INNER JOIN abc_abono_cliente ON abc_id = abf_id_abc
            WHERE dgc_id_uxc IN (521,522,523,524,525,526,527,528,529)
            GROUP BY
                dgc_id_tpg
        */
        // $query = $this->db->select("tpg_nombre nombre,
        //         SUM(if(abc_fecha_anulacion is NOT NULL, 0, abf_monto)) as total,
        //         SUM(if(abc_fecha_anulacion is NOT NULL, abf_monto, 0)) as anuladas,
        //         SUM(if(abc_anticipo is NOT NULL, abc_anticipo, 0)) as anticipo", false)
        //      ->from('tpg_tipo_pago')
        //      ->join('dgc_detalle_pago_corte', 'dgc_id_tpg = tpg_id', 'inner')
        //      ->join('fac_factura', 'fac_id_uxc = dgc_id_uxc', 'inner')
        //      ->join('abf_abono_factura', 'abf_id_fac = fac_id', 'inner')
        //      ->join('abc_abono_cliente', 'abc_id = abf_id_abc', 'inner')
        //     ;

                /*

        SELECT
        DISTINCT fac_id, tpg_nombre nombre,
                (if(abc_fecha_anulacion is NOT NULL, 0, abc_monto)) as total,
                (if(abc_fecha_anulacion is NOT NULL, abc_monto, 0)) as anuladas,
                (if(abc_anticipo is NOT NULL, abc_anticipo, 0)) as anticipo
        FROM dgc_detalle_pago_corte
        INNER JOIN tpg_tipo_pago ON tpg_id = dgc_id_tpg
        INNER JOIN fac_factura ON fac_id_uxc = dgc_id_uxc AND fac_id_tpg = dgc_id_tpg and fac_id_tif = dgc_id_tif
        INNER JOIN abf_abono_factura ON abf_id_fac = fac_id
        INNER JOIN abc_abono_cliente ON abc_id = abf_id_abc
        WHERE
        dgc_id_uxc = 14 ;
        (
        --      IF(
        --          fac_id_tpg = 2,
                    fac_total
        --          IF (
        --              abc_fecha_anulacion IS NOT NULL,
        --              0,
        --              abc_monto
        --          )
        --      )        
            ) AS total,
                */

        $query = $this->db->select("DISTINCT fac_id, tpg_nombre nombre, (fac_total) AS total,
            (SELECT SUM(ROUND((def_subtotal + def_impuesto), 4)) FROM def_detalle_fact WHERE def_id_fac = fac_id) AS def_total,
            (if(abc_fecha_anulacion is NOT NULL, abc_monto, 0)) as anuladas,
            (if(abc_anticipo is NOT NULL, abc_anticipo, 0)) as anticipo", false)
         ->from('dgc_detalle_pago_corte')
         ->join('tpg_tipo_pago', 'tpg_id = dgc_id_tpg', 'inner')
         ->join('fac_factura', 'fac_id_uxc = dgc_id_uxc AND fac_id_tif = dgc_id_tif AND fac_id_tpg = dgc_id_tpg', 'inner')
         ->join('abf_abono_factura', 'abf_id_fac = fac_id', 'LEFT')
         ->join('abc_abono_cliente', 'abc_id = abf_id_abc', 'LEFT')
        ;

        if ($where_in != null) {
            $this->db->where_in('dgc_id_uxc', $where_in);
        }

        if ($where != null) {
            $this->db->where($where);
        }
        // if ($groupby != null) {
            // $this->db->group_by($groupby);
        // }

        return $query->get()->result_array();
    }

    public function get_ventas_forma_pago($where_in = null, $groupby = null, $where = null){        
        $query = $this->db->select("DISTINCT fac_id, frp_nombre nombre, (fac_total) AS total,
            (SELECT SUM(ROUND((def_subtotal + def_impuesto), 4)) FROM def_detalle_fact WHERE def_id_fac = fac_id) AS def_total,
            (if(abc_fecha_anulacion is NOT NULL, abc_monto, 0)) as anuladas,
            (if(abc_anticipo is NOT NULL, abc_anticipo, 0)) as anticipo", false)
         ->from('dgc_detalle_pago_corte')
         ->join('frp_forma_pago', 'frp_id = dgc_id_frp', 'inner')
         ->join('fac_factura', 'fac_id_uxc = dgc_id_uxc AND fac_id_tif = dgc_id_tif AND fac_id_frp = dgc_id_frp', 'inner')
         ->join('abf_abono_factura', 'abf_id_fac = fac_id', 'LEFT')
         ->join('abc_abono_cliente', 'abc_id = abf_id_abc', 'LEFT')
        ;
        if ($where_in != null) {
            $this->db->where_in('dgc_id_uxc', $where_in);
        }
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

     function get_listado_precio($where = null){
        $query = $this->db->select("art_codigo, art_precio_sugerido, tlp_nombre, art_nombre, mep_nombre, lip_desde, lip_hasta, lip_descuento_min, 
            lip_descuento_max, lip_precio, lip_id, (SELECT GROUP_CONCAT(IF(imp_valor > 0,2,1)) FROM ixr_impuestox_tipo_articulo JOIN imp_impuesto ON imp_id = ixr_id_imp WHERE ixr_id_tia = tia_id) AS tipo_imp, (SELECT GROUP_CONCAT(IF(imp_valor > 0,imp_valor,imp_porcentaje)) FROM ixr_impuestox_tipo_articulo JOIN imp_impuesto ON imp_id = ixr_id_imp WHERE ixr_id_tia = tia_id) AS valor_imp",false)
            ->from('art_articulo')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
            ->join('lip_listado_precio', 'lip_id_art = art_id')
            ->join('mep_medida_producto', 'lip_id_mep = mep_id')
            ->join('tlp_tipo_lista_precio', 'tlp_id = lip_id_tlp')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('lip_id');
        $this->db->order_by('art_id, art_nombre, lip_desde', 'ASC');

        return $query->get()->result_array();
    }

    function comprobar_cantidad_desde_hasta_por_lista($where) {
        $query = $this->db->select('*')
                ->from('lip_listado_precio')
                ->where($where)
                ->get()->result_array();
        return $query;
    }

    public function get_productos_masvendidos($fechaIni = null, $fecha_fin = null, $num = 10, $categoria = null, $marca = null){
        $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $nt_cred = (isset($tipo_factura['NOTA CREDITO'])) ? $tipo_factura['NOTA CREDITO'] : 0;
        $nt_remi = (isset($tipo_factura['NOTA REMISION'])) ? $tipo_factura['NOTA REMISION'] : 0;
        $excluidas = implode(',', array($nt_cred, $nt_remi));
        $category = (is_null($categoria)) ? "" : " AND tia_id = $categoria";
        $marcapro = (is_null($marca)) ? "" : " AND mrp_id = $marca";
        $query = "SELECT 
                    t.fac_id, 
                    SUM(t.def_cantidad*(t.cva_conversion/t.defecto)) cant,
                    t.art_nombre,
                    t.tia_nombre,
                    t.art_codigo, 
                    t.suc_nombre,
                    t.bod_nombre,
                    t.mrp_nombre,
                    AVG(t.def_precio) AS facturado
                    FROM(
                        SELECT 
                            fac_id, 
                            def_cantidad, 
                            art_nombre, 
                            tia_nombre, 
                            def_id_cva, 
                            cva_conversion,def_precio,
                            (SELECT x.cva_conversion from cva_conversion_articulo x where x.cva_id_art = art_id and x.cva_defecto = 1 and x.cva_estado = 1 LIMIT 1) as defecto,
                            bod_nombre, 
                            suc_nombre,
                            art_id, 
                            suc_id,
                            mrp_id, mrp_nombre,
                            art_codigo
                            FROM
                            fac_factura 
                            JOIN def_detalle_fact on def_id_fac = fac_id
                            JOIN art_articulo on art_id = def_id_art
                            JOIN cva_conversion_articulo on cva_id = def_id_cva
                            JOIN tia_tipo_articulo on art_id_tia = tia_id
                            LEFT JOIN bod_bodega on bod_id = def_id_bod
                            LEFT JOIN suc_sucursal on suc_id = fac_id_suc
                            LEFT JOIN mrp_marca_producto ON mrp_id = art_id_mrp
                            WHERE DATE(fac_fecha_fact) >= '$fechaIni' AND DATE(fac_fecha_fact) <= '$fecha_fin'
                            AND fac_estado > 0 AND fac_id_tif NOT IN ($excluidas)
                            $category
                            $marcapro
                    ) t
                    GROUP BY t.art_id, t.suc_id, t.mrp_id
                    ORDER BY cant desc
                    LIMIT $num";
        return  $this->db->query($query)->result_array();
    }

    /**
     * @author Francisco Orozco
     * @since  2018-08-21
     * @return Registros de ordenes de venta.
     * @param  Array de condiciones de consulta ($where).
     * @param  Array de datos de fk especificos segun cliente en su BD($array).
    **/
    public function get_orden_venta($where = NULL, $array = NULL){
        $iva        = (isset($array['iva']))?$array['iva']:'';
        $propina    = (isset($array['propina']))?$array['propina']:'';
        $fijo       = (isset($array['fijo']))?$array['fijo']:'';
        $celular    = (isset($array['celular']))?$array['celular']:'';
        $documento  = (isset($array['documento']))?$array['documento']:'';

        $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
        $where_documento = '';
        if($documento == 1){
            $where_documento = 'and dcc_id_tde = '.$nit;
        } else if($documento == 2){
            $where_documento = 'and dcc_id_tde = '.$dui.' or dcc_id_tde = '.$nit;
        }


        $this->db->select("	
            (CONCAT(ven_nombre,' ',ven_apellidos))as vendedor,
            ven_codigo,
            dov_id,
            art_codigo,
            orv_numero_orden,
            orv_fecha_orden,
            orv_total,
            orv_subtotal,
            arf_nombre,
            art_nombre,
            orv_impuesto,
            orv_observacion,
            dov_id_art,
            dov_descripcion,
            dov_cantidad,
            dov_precio,
            (dov_cantidad * dov_precio) AS suma,
            dov_descuento,
            dov_subtotal,
            dov_impuesto,
            dov_retencion,
            (dov_subtotal + dov_impuesto) AS total,
            art_tipo,
            dov_id_tpv,
            tpv_abreviacion,
            dov_id_lip,
            lip_id_tlp,
            dov_id_cva,
            cva_id_mep,
            dov_precio_sugerido_lista,
            IF (cli_personeria = 1,
                CONCAT(cli_nombre, ' ', cli_apellido),
                cli_apellido
            ) AS cliente,
            cli_direccion,
            cli_codigo,
            IFNULL((SELECT tpg_nombre FROM tpg_tipo_pago WHERE tpg_id = orv_condicion_pago), '') AS tpg_nombre,
            (SELECT SUM(ixv_monto) FROM ixv_impuestoxorden_venta WHERE ixv_id_dov = dov_id AND ixv_id_imp = ".$iva." AND ixv_estado = 1) AS IVA,
            (SELECT SUM(ixv_monto) FROM ixv_impuestoxorden_venta WHERE ixv_id_dov = dov_id AND ixv_id_imp = ".$propina." AND ixv_estado = 1) AS PROPINA,
            (SELECT txc_numero FROM txc_telefonoxcliente WHERE txc_id_cli = cli_id AND txc_id_tit = ".$fijo." AND txc_estado = 1) AS fijo,
            (SELECT txc_numero FROM txc_telefonoxcliente WHERE txc_id_cli = cli_id AND txc_id_tit = ".$celular." AND txc_estado = 1) AS celular,
            (IF (dov_retencion = 0,
                CONCAT_WS('&#', 0, 0, ''),
                (SELECT CONCAT_WS('&#', GROUP_CONCAT(rxv_porcentaje), SUM(rxv_porcentaje), GROUP_CONCAT(rxv_id_ret)) FROM rxv_retencionxorden_venta WHERE rxv_id_dov = dov_id)
                )
            ) AS retencion,
            (SELECT dcc_valor FROM dcc_documento_cliente WHERE dcc_id_cli = cli_id and dcc_id_tde = ".$dui." AND dcc_estado = 1 LIMIT 1) AS DUI,
            (SELECT dcc_valor FROM dcc_documento_cliente WHERE dcc_id_cli = cli_id and dcc_id_tde = ".$nit." AND dcc_estado = 1 LIMIT 1) AS NIT,
            (
                SELECT
                    GROUP_CONCAT(
                        CONCAT(
                            cva.cva_id,
                            '-',
                            cva.cva_conversion,
                            '-',
                            cva.cva_defecto
                        )
                    )
                FROM
                    cva_conversion_articulo AS cva
                WHERE
                    cva.cva_id_art = art_id
                AND cva.cva_estado = 1
            ) AS conversiones,
            dov_porcentaje_descuento,
            dov_porcentaje_impuesto,
            dov_porcentaje_retencion,
            dov_combo,
            dov_id_bod",false)
            ->from('orv_orden_venta')
            ->join('cli_cliente', 'cli_id = orv_id_cli', 'inner')
            ->join('dov_detalle_orden_venta', 'dov_id_orv = orv_id', 'inner')
            ->join('art_articulo', 'art_id = dov_id_art', 'inner')
            ->join('cva_conversion_articulo', 'cva_id = dov_id_cva', 'inner')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
            ->join('tpv_tipo_venta', 'tpv_id = dov_id_tpv', 'left')
            ->join('lip_listado_precio', 'lip_id = dov_id_lip', 'left')
            ->join('arf_area_factura', 'arf_id = orv_id_arf', 'left')
            ->JOIN('ven_vendedor' ,'ven_id = orv_id_ven' ,'left')
        ;

        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_max_codigo($tabla, $campo) {
        $this->db->select('MAX( CAST(' . $campo . ' as unsigned integer)) as codigo', FALSE)
                ->from($tabla)
        ;
        $result = $this->db->get();
        return $result->row();
    }

    /**
     * @author Luis Navarro
     * @since  2018-09-18
     * @return Registros de los vendedores
     * @modify Raul Escalante - 28/10/2019 //Se modifico la query para mostrar al vendedor aunque no tenga meta de ventas
     * @param  Array de condiciones de consulta ($where).
     * @param  Campo del cual se agrupara
    **/
    public function get_reporte_vendedores($where = null, $groupby = null, $orderby = null, $data = null) {

        $sucursal = (isset($data['suc_id']) && $data['suc_id'] > 0) ? ' AND fac_id_suc = '.$data['suc_id'] : '';
        $query = $this->db->select(
            '
                ven_id,
                ven_codigo,
                ven_nombre,
                ven_apellidos,
                DATE_FORMAT(mtv_periodo, "%m") AS periodo,
                mtv_meta_venta,
                IFNULL( ((SUM(fac_total) * 100) / mtv_meta_venta), "") AS avance,
                IFNULL( (100 - ((SUM(fac_total) * 100) / mtv_meta_venta)), "") AS faltante,
                SUM(fac_total) AS venta_neta,
                mtv_meta_cotizacion
            ',false
        )
             ->from('fac_factura')
             ->join('ven_vendedor', 'fac_id_ven = ven_id')
             ->join('mtv_meta_vendedor', 'mtv_id_ven = ven_id','LEFT')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since  2018-09-21
     * @return Registro de los comprobantes
     * @param  Array de condiciones de consulta ($where).
     * @param  Campo del cual se agrupara
    **/
    public function get_comprobante_descuentos ($where = null, $groupby = null, $orderby = null, $info = null) {

        $query = $this->db->select()
                ->from('cmd_comprobante_descuento')
                ->join('cli_cliente', 'cmd_id_cli = cli_id', 'inner')
                ->join('ven_vendedor', 'ven_id = cmd_id_ven', 'left');

        // $this->db->where('cmd_id_ven IN '.$query_vendedor);

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since  2018-09-21
     * @return Registro de los vendedores asociados a un supervisor
     * @param  Array de condiciones de consulta ($where).
     * @param  Campo del cual se agrupara
    **/
    public function get_vendedoresxsupervisor_comprobante($where = null, $groupby = null, $orderby = null) {
       $query = $this->db->select(
            '
            (
            IFNULL(
                (
                    SELECT
                            GROUP_CONCAT(vxs_id_ven SEPARATOR ",")
                    FROM
                            vxs_vendedorxsupervisor
                    JOIN sup_supervisor ON sup_id = vxs_id_sup
                    WHERE
                            sup_id_usu = id
                    AND sup_estado = 1
                ),
                IFNULL(
                        (
                            SELECT
                                    ven_id
                            FROM
                                    ven_vendedor
                            WHERE
                                    ven_id_usu = id
                            AND ven_estado = 1
                        ),
                        0
                )
            )
            ) AS vendedores
            ', false)
                ->from('users');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Israel alfaro - Grupo Satelite
     * @since  2018-10-24
     * @param  Array de condiciones de consulta ($where).
     * @param  int que sera un limite para la consulta ($limit)
     * @return Los mejores clientes
    **/
    function get_mejores_clientes($where = null, $limite = 10) {
        $this->db->select('cli_cliente.*, fac_factura.*, cog_cotiz_ganada.*, SUM(fac_total) AS suma_venta', false)
            ->from('fac_factura')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->join('cog_cotiz_ganada', 'cog_id_cot = fac_id_cot', 'left')
            ->join('czf_cotizacionxfacturacion', 'czf_id_cot = fac_id_cot', 'left')
            ->group_by('fac_id_cli')
            ->order_by('suma_venta', 'desc')
            ->limit($limite)
            ->where('fac_total >', 0)
            ->where('fac_estado >', 0);
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /************************************************************************/
    /**
     * @author Elman Ortiz  
     * @since 2018-12-24
     * @param array where
     * @return array ventas por sucursal
    */
    public function get_reporte_sucursal_venta($where = null, $groupby = null) {                
        $IMP_IVA = $this->gsatelite->get_parametro('SYS_ID_IVA');
        $NOTA_CREDITO = $this->gsatelite->get_parametro('SYS_ID_TIPO_FACTURA_NOTA_CREDITO');
        
        $query = "SELECT fac_id_suc, 
                (SELECT suc_nombre FROM suc_sucursal WHERE suc_id = fac_id_suc) AS sucursal,  
                (IFNULL(SUM((SELECT SUM(ABS(def_subtotal)) FROM def_detalle_fact WHERE def_id_fac = fac_id AND fac_id_tif = $NOTA_CREDITO)),0)
                    +
                    IFNULL(SUM((SELECT SUM(IF(def_descuento > 0, def_descuento, 0 )) FROM def_detalle_fact WHERE def_id_fac = fac_id)),0)
                    +
                    IFNULL(SUM((SELECT SUM(def_subtotal) FROM def_detalle_fact WHERE def_id_fac = fac_id AND fac_id_tif != $NOTA_CREDITO)),0)
                ) as venta,
                IFNULL(SUM((SELECT SUM(ABS(def_subtotal)) FROM def_detalle_fact WHERE def_id_fac = fac_id AND fac_id_tif = $NOTA_CREDITO)),0.00) AS nota_credito, 
                IFNULL(SUM((SELECT SUM(IF(def_descuento > 0, def_descuento, 0)) FROM def_detalle_fact WHERE def_id_fac = fac_id)),0.00) AS descuento,
                IFNULL(SUM((SELECT SUM(def_subtotal) FROM def_detalle_fact WHERE def_id_fac = fac_id AND fac_id_tif != $NOTA_CREDITO)),0.00) AS venta_neta,
                IFNULL(SUM((SELECT SUM(def_retencion) FROM def_detalle_fact WHERE def_id_fac = fac_id AND fac_id_tif != $NOTA_CREDITO)), 0.00) AS retencion,
                IFNULL(SUM((SELECT SUM(ixf_monto) FROM def_detalle_fact JOIN ixf_impuestoxfactura ON def_id = ixf_id_def WHERE def_id_fac = fac_id 
                    AND ixf_id_imp = $IMP_IVA AND fac_id_tif != $NOTA_CREDITO)),0.00) as iva,
                (IFNULL(SUM((SELECT SUM(def_subtotal) FROM def_detalle_fact WHERE def_id_fac = fac_id AND fac_id_tif != $NOTA_CREDITO)),0.00)
                    +
                    IFNULL(SUM((SELECT SUM(def_impuesto) FROM def_detalle_fact WHERE def_id_fac = fac_id AND fac_id_tif != $NOTA_CREDITO)),0.00)
                    -
                    IFNULL(SUM((SELECT SUM(def_retencion) FROM def_detalle_fact WHERE def_id_fac = fac_id AND fac_id_tif != $NOTA_CREDITO)), 0.00)
                ) AS venta_con_impuesto,
                IFNULL(SUM((SELECT SUM(ixf_monto) FROM def_detalle_fact JOIN ixf_impuestoxfactura ON def_id = ixf_id_def WHERE def_id_fac = fac_id 
                    AND ixf_id_imp != $IMP_IVA AND fac_id_tif != $NOTA_CREDITO)),0.00) AS impuesto
            FROM fac_factura                           
        ";
        if($where != null){
            $where_sql  = "WHERE fac_estado != 0 ";
            $where_sql .= "AND fac_id_suc IS NOT NULL ";
            $where_sql .= "AND DATE(fac_fecha_fact) >= '".$where['fecha_inicio']."'";
            $where_sql .= "AND DATE(fac_fecha_fact) <= '".$where['fecha_fin']."'";
            if(isset($where['id_sucursal'])){            
                $where_sql .= "AND fac_id_suc = ".$where['id_sucursal'];
            }        
            $query .= $where_sql;        
        }
        if($groupby != null){        
            $groupby_sql = " GROUP BY " . $groupby;
            $query .= $groupby_sql;  
        }      
        $result = $this->db->query($query);
        return $result->result_array();        
    }//Fin get_reporte_sucursal_venta

    /**
     * @author Israel Alfaro
     * @since 2018-10-30
     * @param array where
     * @return array con todos los datos de la factura respectivos a la propinas
    */
    public function obtener_propinas_por_fechas($where = null) {
        $query = $this->db->select("
                fac_id,
                date(fac_fecha_fact) AS FECHA_FAC,
                fac_numero AS NUM_FAC,
                SUM(ixf_monto) PROPINA,
                emp_codigo, 
                CONCAT(emp_nombre, ' ', emp_apellido) AS nombre_com,
                (
                    SELECT
                        COUNT(DISTINCT a1.pxf_id)
                    FROM
                        pxf_personalxfactura a1
                    WHERE
                        a1.pxf_id_fac = fac_id
                ) n_meseros,
                (
                    SUM(ixf_monto) / (
                        SELECT
                            COUNT(DISTINCT a1.pxf_id)
                        FROM
                            pxf_personalxfactura a1
                        WHERE
                            a1.pxf_id_fac = fac_id
                    )
                ) acada_uno,
                COUNT(fac_numero) AS cantidad_facturas",false)
                ->from('fac_factura')
                ->join("def_detalle_fact","def_id_fac = fac_id")
                ->join("ixf_impuestoxfactura","ixf_id_def = def_id")
                ->join("pxf_personalxfactura","pxf_id_fac = fac_id","left")
                ->join("emp_empleado","emp_id = pxf_id_emp","left")
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by("fac_id,emp_id");
        $this->db->order_by("fac_fecha_fact","asc");
        return $query->get()->result_array();
    } 

    /**
     * @author Elman Ortiz  
     * @since 2018-12-24
     * @param array where
     * @return array ventas por sucursal detallado
    */
    public function get_reporte_sucursal_venta_detallado($where = null, $groupby = null) {            
        $ID_IMPUESTO_IVA = $this->gsatelite->get_parametro('SYS_ID_IVA');
        $ID_TIPO_NOTA_CREDITO = $this->gsatelite->get_parametro('SYS_ID_TIPO_FACTURA_NOTA_CREDITO');
        $ID_PERCEPCION = $this->gsatelite->get_parametro('SYS_ID_IMPUESTO_PERCEPCION');
        
        $query = "
            SELECT 
                CONCAT_WS(' - ',sef1.sef_abrev, fac1.fac_numero) as codigo,
                DATE_FORMAT(fac1.fac_fecha_fact, '%d-%m-%Y') as fecha,
                (
                    SELECT tpg_nombre
                    FROM tpg_tipo_pago
                    WHERE tpg_id = fac1.fac_id_tpg
                ) as tipo_pago,
                DATE_FORMAT(fac1.fac_fecha_vencimiento, '%d-%m-%Y') as fecha_vencimiento,
                (
                    SELECT 
                        IF(cli_personeria = 1, CONCAT_ws(' - ',cli_nombre, cli_apellido), cli_apellido)
                    FROM cli_cliente
                    WHERE cli_id = fac1.fac_id_cli
                ) as cliente,
                IFNULL((
                    SELECT CONCAT(ven_codigo, ' - ', ven_nombre) as vendedor
                    FROM ven_vendedor
                    WHERE ven_id = fac1.fac_id_ven
                ), ' --- ') as vendedor,
                (
                    IFNULL((SELECT SUM(def_subtotal) FROM def_detalle_fact WHERE def_id_fac = fac1.fac_id), 0.00) 
                    +
                    IFNULL((SELECT SUM(IF(def_descuento > 0, def_descuento, 0)) FROM def_detalle_fact WHERE def_id_fac = fac1.fac_id), 0.00)
                )as sub_total,
                IFNULL((
                    SELECT SUM(IF(def_descuento > 0, def_descuento, 0))
                    FROM def_detalle_fact
                    WHERE def_id_fac = fac1.fac_id
                ),0.00) as descuento,
                IFNULL((
                    SELECT SUM(ixf_monto)
                    FROM def_detalle_fact
                    JOIN ixf_impuestoxfactura ON def_id = ixf_id_def
                    WHERE def_id_fac = fac1.fac_id AND ixf_id_imp = $ID_IMPUESTO_IVA
                ),0.00) as iva,
                IFNULL((
                    SELECT SUM(ixf_monto)
                    FROM def_detalle_fact
                    JOIN ixf_impuestoxfactura ON def_id = ixf_id_def
                    WHERE def_id_fac = fac_id AND ixf_id_imp = $ID_PERCEPCION
                ),0.00) as percepcion,
                IFNULL((
                    SELECT SUM(def_retencion)
                    FROM def_detalle_fact
                    WHERE def_id_fac = fac1.fac_id
                ),0.00) as retencion,
                (
                    IFNULL((SELECT SUM(def_subtotal) FROM def_detalle_fact WHERE def_id_fac = fac1.fac_id),0.00)
                    -
                    IFNULL((SELECT SUM(IF(def_descuento > 0, def_descuento, 0)) FROM def_detalle_fact WHERE def_id_fac = fac1.fac_id),0.00)
                    +
                    IFNULL((SELECT SUM(ixf_monto) FROM def_detalle_fact JOIN ixf_impuestoxfactura ON def_id = ixf_id_def WHERE def_id_fac = fac1.fac_id AND ixf_id_imp = $ID_IMPUESTO_IVA ),0.00)
                    +
                    IFNULL((SELECT SUM(ixf_monto) FROM def_detalle_fact JOIN ixf_impuestoxfactura ON def_id = ixf_id_def WHERE def_id_fac = fac1.fac_id AND ixf_id_imp = $ID_PERCEPCION ),0.00)
                    -
                    IFNULL((SELECT SUM(def_retencion) FROM def_detalle_fact WHERE def_id_fac = fac1.fac_id),0.00)
                ) as total,
                (
                    SELECT CONCAT_WS(' - ', sef2.sef_abrev, f2.fac_numero)
                    FROM fac_factura AS f2
                    JOIN cof_correlativo_factura AS cof2 ON f2.fac_id_cof = cof2.cof_id
                    JOIN sef_serie_factura AS sef2 ON sef2.sef_id = cof2.cof_id_sef
                    WHERE f2.fac_id = fac1.fac_id_origen_devolucion
                ) AS aplicaen
            FROM fac_factura AS fac1
            JOIN cof_correlativo_factura AS cof1 ON fac1.fac_id_cof = cof1.cof_id
            JOIN sef_serie_factura AS sef1 ON sef1.sef_id = cof1.cof_id_sef
        ";

      if($where != null){
        $where_sql = "WHERE fac_estado != 0 ";
        $where_sql .= "AND DATE(fac_fecha_fact) >= '".$where['fecha_inicio']."'";
        $where_sql .= "AND DATE(fac_fecha_fact) <= '".$where['fecha_fin']."'";
        if(isset($where['id_sucursal'])){            
            $where_sql .= " AND fac_id_suc = ".$where['id_sucursal'];
        }
        if(isset($where['id_tipo_factura'])) {          
            $where_sql .= " AND fac_id_tif = ".$where['id_tipo_factura'];
        }
        if(isset($where['fac_aplica_domicilio'])) {
            $where_sql .= " AND fac_aplica_domicilio = ".$where['fac_aplica_domicilio'];
        }
        $query .= $where_sql;        
      }

      /*if($groupby != null){        
        $groupby_sql = " GROUP BY " . $groupby;
        $query .= $groupby_sql;  
      }*/
      
      $result = $this->db->query($query);
      return $result->result_array();        
    }//Fin get_reporte_sucursal_venta_detallado

     /**
        * @author Francsico Orozco
        * @since 2018-11-07
        * @return clientes
        * @param $where array asociativo para condicionar.
        * @param $like string para condicionar.
    */
    public function get_clientes_like($where=null,$like=null,$evaluar_plan=false){
        $query = $this->db->select("*,IF(cli_personeria > 1, cli_apellido, CONCAT_WS(' ',cli_nombre, cli_apellido)) as nombre",false)
                ->from('cli_cliente');

        if ($evaluar_plan == true AND $evaluar_plan !=0) {
            $this->db->join("sxc_servicioxcliente","sxc_id_cli = cli_id")
            ->join("pxl_plan_promoxcliente","pxl_id_sxc = sxc_id");
        }
          
        if ($like != null) {
              $this->db->or_like("CONCAT_WS(' ',cli_nombre, cli_apellido)", $like);
        }

        if ($like != null) {
            $this->db->or_like("cli_codigo", $like);
        }

        if ($where != null) {
              $this->db->where($where);
        }
        
        $this->db->group_by('cli_id');
        $this->db->limit(100);
        return $query->get()->result_array();
    }

    public function comparativo_clientes($where = null, $where_in = null){
        $query = $this->db->select("CONCAT_WS('_',cli_id,DATE_FORMAT(fac_fecha_fact,'%m')) clave,
                    IF (cli_personeria = 1,
                    CONCAT(
                        cli_nombre,
                        ' ',
                        cli_apellido
                    ),
                        cli_apellido
                    ) AS cliente,
                    MONTH (fac_fecha_fact) AS mes,
                    DATE_FORMAT(fac_fecha_fact, '%M') AS fecha,
                    IFNULL(SUM(fac_total), 0) AS suma",false)
                ->from('fac_factura')
                ->join("cli_cliente","cli_id = fac_id_cli");
        ;
        if ($where != null) {
              $this->db->where($where);
        }        
        if ($where_in != null) {
            $this->db->where_in('fac_id_cli', $where_in);
        }

        $this->db->group_by('fac_id_cli, YEAR(fac_fecha_fact), MONTH(fac_fecha_fact)',false);
        $this->db->order_by('fac_id_cli, MONTH(fac_fecha_fact)','ASC',false);
        return $query->get()->result_array();
    }

    public function comprobantes_descuento($where = null, $groupby = null) {
        $query = $this->db->select(
            "
                IF (cli_personeria = 1,
                    CONCAT(
                            cli_nombre,
                            ' ',
                            cli_apellido
                    ),
                            cli_apellido
                ) AS cliente,
                username,
                suc_nombre,
                caj_nombre,
                cmd_comprobante_descuento.*
            ", false)
                ->from('cmd_comprobante_descuento')
                ->join("anl_anticipo_cliente", "cmd_id_anl = anl_id", "LEFT")
                ->join("ana_anticipo_abono", "ana_id_anl = anl_id")
                ->join("abc_abono_cliente", "abc_id = ana_id_abc")
                ->join("abf_abono_factura", "abf_id_abc = abc_id")
                ->join("fac_factura", "fac_id = abf_id_fac")
                ->join("cli_cliente", "cli_id = cmd_id_cli")
                ->join("ven_vendedor", "ven_id = cmd_id_ven")
                ->join("suc_sucursal", "fac_id_suc = suc_id", "LEFT")
                ->join("uxc_usuarioxcaja", "uxc_id = fac_id_uxc")
                ->join("caj_caja", "caj_id = uxc_id_caj")
                ->join("users", "uxc_id_usu = id");
        ;

        if ($where != null) {
              $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        
        return $query->get()->result_array();        
    }

    public function get_clientes_anulacion($where = null, $like = null){
        $query = $this->db->select("cli_id, cli_codigo, IF(cli_personeria > 1, cli_apellido, CONCAT_WS(' ',cli_nombre, cli_apellido)) as cli_nombre", false)
            ->from('cli_cliente')
            ->join('fac_factura', 'fac_id_cli = cli_id')
            ->join('sxc_servicioxcliente', 'sxc_id_cli = cli_id', 'left')
            ->group_by('cli_id')
        ;
        if ($like != null) {
              $this->db->like($like);
        }
        if ($where != null) {
              $this->db->where($where);
        }
        $this->db->limit(100);
        return $query->get()->result_array();
    }

    public function obtener_cajeros($where = null, $groupby = null, $orderby = null) {

        // Parametro para obtener el ID de tipo de cajero
        $rol_cajero =  $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
        $rol_cajero = ($rol_cajero>0)?$rol_cajero:null;

        $this->db->select('*,count(id)')
            ->from('users')
            ->join('emp_empleado', 'emp_id_usu = id', 'left')
            ->join('uxr_usuarioxrol', 'uxr_id_usu = id', 'left')
            ->join('rol_rol', 'rol_id = uxr_id_rol', 'left')
            ->where('rol_id', $rol_cajero);

        if($where!=null){
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $this->db->get()->result_array();
    }

    /**********************************************************************/
    /**
     * @author Elman Ortiz  
     * @since 2018-12-24
     * @param array where
     * @return array VENTA DIARIA POR ARTICULOS DETALLADO POR FACTURA
    */
    public function get_reporte_diario_articulo_detallado($where = null, $groupby = null) {                
        $ID_IMPUESTO_IVA = $this->gsatelite->get_parametro('SYS_ID_IVA');
        $ID_TIPO_NOTA_CREDITO = $this->gsatelite->get_parametro('SYS_ID_TIPO_FACTURA_NOTA_CREDITO');
        $ID_PERCEPCION = $this->gsatelite->get_parametro('SYS_ID_IMPUESTO_PERCEPCION');

        $query = "
            SELECT 
                fac_id,
                CONCAT_WS(' - ', sef_abrev, fac_numero) AS codigo,
                DATE_FORMAT(fac_fecha_fact, '%d-%m-%Y') AS fecha,
                (
                    SELECT
                        tpg_nombre
                    FROM
                        tpg_tipo_pago
                    WHERE
                        tpg_id = fac_id_tpg
                ) AS tipo_pago,
                (
                    SELECT art_codigo
                    FROM art_articulo
                    WHERE art_id = def_id_art
                ) AS cod_articulo,
                (
                    SELECT art_nombre
                    FROM art_articulo
                    WHERE art_id = def_id_art
                ) AS nom_articulo,
                def_cantidad AS cant_articulo,
                def_subtotal AS subtotal,
              def_descuento AS descuento,
                IFNULL(
                    (
                        SELECT
                            SUM(ixf_monto)
                        FROM
                            ixf_impuestoxfactura
                        WHERE
                          ixf_id_def = def_id                            
                        AND ixf_id_imp = ".$ID_IMPUESTO_IVA."
                    ),
                    0.00
                ) AS iva,
                (
                    IFNULL(def_subtotal,0.00)
                    +
                    IFNULL((SELECT SUM(ixf_monto) FROM ixf_impuestoxfactura WHERE ixf_id_def = def_id AND ixf_id_imp = 1),0.00)
                ) AS total
            FROM
                fac_factura
            JOIN def_detalle_fact ON fac_id = def_id_fac
            JOIN cof_correlativo_factura ON fac_id_cof = cof_id
            JOIN sef_serie_factura ON sef_id = cof_id_sef
        ";

      if($where != null){
        $where_sql = "WHERE fac_estado != 0 ";
        $where_sql .= "AND DATE(fac_fecha_fact) >= '".$where['fecha_inicio']."'";
        $where_sql .= "AND DATE(fac_fecha_fact) <= '".$where['fecha_fin']."'";
        if(isset($where['id_sucursal'])){            
            $where_sql .= " AND fac_id_suc = ".$where['id_sucursal'];
        }
        if(isset($where['id_tipo_factura'])){            
            $where_sql .= " AND fac_id_tif = ".$where['id_tipo_factura'];
        }       
        $query .= $where_sql;        
      }

      /*if($groupby != null){        
        $groupby_sql = " GROUP BY " . $groupby;
        $query .= $groupby_sql;  
      }*/
      
      $query .= " ORDER BY fac_id";
      $result = $this->db->query($query);
      return $result->result_array();        
    }//Fin get_reporte_sucursal_venta_detallado

    /**
         * @author Francisco Orozco
         * @since 2018-12-07
         * @param array where
         * @param array where_in
         * @return array reporte de ventas por categoria
    */
    function get_ventas_categorias($where = null ,$where_in = null){
        $query = $this->db->select('
                tia_id,
                tia_nombre AS Categoria,
                art_codigo AS Codigo_producto,
                def_descripcion AS Nombre_producto,
                mep_nombre AS Unidad_medida,
                SUM(def_cantidad) AS Cantidad,
                ROUND(def_precio,2)  AS Precio_venta
            ',false)
            ->from('def_detalle_fact')
            ->join('art_articulo', 'art_id = def_id_art')
            ->join('fac_factura', 'fac_id = def_id_fac')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
            ->join('cva_conversion_articulo', 'cva_id = def_id_cva')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep')
            ->order_by('tia_nombre,tia_id','asc')
            ->group_by('art_codigo')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($where_in != null) {
            $this->db->where_in('tia_id',$where_in);
        }       

        return $query->get()->result_array();
    }


    public function obtener_propinas_consolidadas($fecha_ini = "", $fecha_fin= ""){
        $query = " SELECT
                        *, SUM(cantidad_facturas) nfacturas, SUM(acada_uno) acada_uno2
                    FROM
                        (
                            SELECT
                                fac_id,
                                date(fac_fecha_fact) AS FECHA_FAC,
                                fac_numero AS NUM_FAC,
                                SUM(ixf_monto) PROPINA,
                                emp_id,
                                emp_codigo,
                                CONCAT_WS(' ',
                                    emp_nombre,
                                    emp_apellido
                                ) AS nombre_com,
                                (
                                    SELECT
                                        COUNT(DISTINCT a1.pxf_id)
                                    FROM
                                        pxf_personalxfactura a1
                                    WHERE
                                        a1.pxf_id_fac = fac_id
                                ) n_meseros,
                                (
                                    SUM(ixf_monto) / (
                                        SELECT
                                            COUNT(DISTINCT a1.pxf_id)
                                        FROM
                                            pxf_personalxfactura a1
                                        WHERE
                                            a1.pxf_id_fac = fac_id
                                    )
                                ) acada_uno,
                                COUNT(DISTINCT fac_id) AS cantidad_facturas
                            FROM
                                (`fac_factura`)
                            JOIN `def_detalle_fact` ON `def_id_fac` = `fac_id`
                            JOIN `ixf_impuestoxfactura` ON `ixf_id_def` = `def_id`
                            LEFT JOIN `pxf_personalxfactura` ON `pxf_id_fac` = `fac_id`
                            LEFT JOIN `emp_empleado` ON `emp_id` = `pxf_id_emp`
                            WHERE
                                DATE(fac_fecha_fact) >= '$fecha_ini'
                            AND DATE(fac_fecha_fact) <= '$fecha_fin'
                            AND `fac_estado` > 0
                            AND `ixf_id_imp` = 2
                            GROUP BY
                                fac_id, emp_id
                        ) t
                    GROUP BY
                        emp_id
                    ORDER BY
                        `FECHA_FAC` ASC";
        $result = $this->db->query($query);
        return $result->result_array();                                
    }
    /*****
     * @Autor: Manuel Anzora
     * @Create: 26/12/2018
     * @Param: where para filtrar el query
     * @Return: retorna facturas del cliente seleccionado, filtra solo las facturas que pueden anularse.
    */
    public function get_facturaxcliente($where){
        $query = $this->db->select('fac_id, fac_numero, fac_nombre_factura, tif_nombre, fac_fecha_fact');
        $query->from('fac_factura')
            ->join('tif_tipo_factura', 'tif_id = fac_id_tif')
            ->where($where);
        return $query->get()->result_array();    
    }
    /*****
     * @Autor: Manuel Anzora
     * @Create: 28/12/2018
     * @Param: id de la caja y fecha en formato Y-m-d
     * @Return: retorna FECHA de la tabla UXC_USUARIOXCAJA.
    */
    public function get_dato_caja($id_caja, $fecha) {
        $this->db->select('uxc_fecha_proceso')
                ->from('uxc_usuarioxcaja')
                ->join('caj_caja', 'uxc_id_caj = caj_id', 'left')
                ->join('emp_empleado', 'emp_id_usu = uxc_id_usu', 'left')
                ->join('suc_sucursal', 'emp_id_suc = suc_id', 'left')
                ->where('caj_id', $id_caja)
                ->where('uxc_tipo', 3)
                ->where('uxc_fecha_proceso', $fecha);
        // $this->db->where('uxc_fecha_proceso',$fecha);
        $this->db->where('uxc_estado', 1);
        return $this->db->get()->result_array();
    }

    public function get_caja_mensual($where = null){
        // SELECT
        //     *
        // FROM
        //     ccm_corte_caja_mensual
        // WHERE
        //     date(ccm_fecha_desde) >= "2019-01-01"
        // AND DATE(ccm_fecha_hasta) <= LAST_DAY("2019-01-01") and ccm_id_caj = 30
        $query = $this->db->select()
            ->from('ccm_corte_caja_mensual');

        if ($where != null) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    /**
     * Descripción:
     * Función para obtener los roles del usuario
     * @author René Castaneda - Grupo Satélite
     * @since 2017-11-14
     * @param int id del usuario
     * @return Array de los roles del usuario
     */
    public function get_roles_usuario($usu=0)
    {
        $usu  = ($usu > 0 )? $usu:$this->tank_auth->get_user_id();
        $this->db->select('uxr_id_rol')
                ->from('uxr_usuarioxrol')
                ->where('uxr_id_usu', $usu)
                ;
        $q = $this->db->get()->result_array();
        $roles = array();
        if ($q) {
            foreach ($q as $valor) {
                $roles[] = $valor['uxr_id_rol'];
            }
        }
        return $roles;
    }

    public function get_centro_costo_detalle_dov($where = null){
        /* SELECT * FROM dcf_detalle_centrocostoxfactura
            INNER JOIN cec_centro_costo ON cec_id = dcf_id_cec
            INNER JOIN tcn_tipo_cuenta ON tcn_id = dcf_id_tcn
            INNER JOIN cnt_cuenta_contable ON cnt_id = dcf_id_cnt
            WHERE dcf_id_def = 6901
        */
        $query = $this->db->select('*, , dcv_porcentaje porcentaje, dcv_monto monto, pai_id id_pais, pai_nombre nombre_pais', false)
                ->from('dcv_detalle_centrocostoxorden_venta')
                ->join('tcn_tipo_cuenta', 'tcn_id = dcv_id_tcn')
                ->join('cec_centro_costo', 'cec_id = dcv_id_cec')
                ->join('cnt_cuenta_contable', 'cnt_id = dcv_id_cnt')
                ->join('pai_pais', 'pai_id = dcv_id_pai', 'left')
            ;
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_abf_abc($where_in_facnum = null, $where_in_uxc = null){
        
        $query = $this->db->select('abc_id, abf_id, fac_id, fac_id_pct AS pct_id', false)
                ->from('fac_factura')
                ->join('abf_abono_factura', 'fac_id = abf_id_fac')
                ->join('abc_abono_cliente', 'abc_id = abf_id_abc')                
            ;
        if ($where_in_facnum != null) {
            $this->db->where_in('fac_numero', $where_in_facnum);
        }

        if ($where_in_uxc != null) {            
            $this->db->where_in('fac_id_uxc', $where_in_uxc);
        }

        return $query->get()->result_array();
         //print_r($this->db->last_query()); die();
        //print_r($a); die();
    }

    /**
     * Descripción:
     * Función obtener el centro de costo por defecto, mediante una consulta via ajax
     * @author Habby Lovo - Grupo satélite
     * @since  2019-03-25
     * @param  $where: condicion para filtrar por pais, cuenta defecto y empresa
     */
    function get_centro_costo_defecto($where){
        /*
            SELECT
                *,
                pai_nombre AS nombre_pais,
                pai_id AS id_pais
            FROM
                cec_centro_costo
            LEFT JOIN cnt_cuenta_contable ON cnt_id = 581
            INNER JOIN tcn_tipo_cuenta ON tcn_id = cnt_id_tcn
            LEFT JOIN pai_pais ON pai_id = 7
            WHERE
                cec_defecto = 1
            AND cec_id_emr = 5
        */
        $query = $this->db->select("*,
                pai_nombre AS nombre_pais,
                pai_id AS id_pais,
                CONCAT_WS(', ', cnt_id, cnt_nombre) cuenta_contable,
                cnt_id dpr_id_cnt,
                null dpr_id,
                100 dpr_porcentaje
                ", false)
                ->from('cec_centro_costo')
                ->join("cnt_cuenta_contable", "cnt_id = cnt_id")
                ->join("tcn_tipo_cuenta","tcn_id = cnt_id_tcn", "INNER")
                ->join("pai_pais","pai_id = pai_id")
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->where('cec_defecto',1);
        $query = $this->db->get();        
        return $query->result_array();        
    }


    // Funcion para obtener las facturas y detalles que no tengan movimientos generados para rosario
    public function get_descarga_masiva_inventario($limit = '', $fecha_desde = '', $fecha_hasta = ''){
        $limite = "";
        $limite .= ($fecha_desde != '') ? " AND DATE(fac_fecha_fact) >= '" . $fecha_desde . "'": "";
        $limite .= ($fecha_hasta != '') ? " AND DATE(fac_fecha_fact) <= '" . $fecha_hasta . "'": "";
        $limite .= ($limit != '') ? " LIMIT " . $limit : "";
        return $this->db->query("
            SELECT
               def_id, def_id_art, def_cantidad, def_id_cva, def_id_bod, fac_id, fac_numero, fac_id_suc, fac_fecha_fact, fac_estado, fac_fecha_anulacion
            FROM
                fac_factura
                INNER JOIN def_detalle_fact ON fac_id = def_id_fac 
            WHERE
                fac_estado >= 0
                AND fac_id NOT IN ( SELECT moi_id_fac FROM moi_movimiento_inv WHERE moi_estado = 1  and moi_id_fac <> '')                
                $limite")->result_array();          

    }

    public function update_def_facturas_bod(){
        return $this->db->query("
                UPDATE def_detalle_fact
                JOIN fac_factura on fac_id = def_id_fac
                SET def_id_bod = fac_id_suc
                WHERE def_id_bod is NULL
            ");
    }

    public function informe_ventas_icv($where = null){
        $id_iva = 0;
        if (isset($where['id_iva'])) {
            $id_iva = $where['id_iva'];
            unset($where['id_iva']);
        }
        /*
            SELECT
                fac_id,
                DATE_FORMAT(fac_fecha_fact, '%d') dia,
                DATE_FORMAT(fac_fecha_fact, '%m') mes,
                DATE_FORMAT(fac_fecha_fact, '%Y') anio,
                (
                    SELECT 
                        CONCAT_WS(':#', tde_id, tde_nombre, dcc_valor, tde_codigo_hacienda)
                    FROM dcc_documento_cliente
                    INNER JOIN tde_tipo_documento ON tde_id = dcc_id_tde
                    WHERE dcc_id_cli = cli_id
                    ORDER BY tde_codigo_hacienda DESC
                    limit 1
                ) documento,
                fac_id_tif,
                fac_numero,
                fac_subtotal,
                IFNULL(ROUND(SUM((
                    SELECT 
                        SUM(ixf_monto) 
                    from ixf_impuestoxfactura
                    JOIN def_detalle_fact on def_id = ixf_id_def
                    WHERE def_id_fac = fac_id AND ixf_id_imp = 1
                )), 2), 0) monto_iva,
                fac_total
            FROM
                fac_factura
            INNER JOIN cli_cliente ON cli_id = fac_id_cli
            WHERE fac_estado != 0 and fac_total <= 200
            GROUP BY fac_id
        */
        $query = $this->db->select("
                    fac_id,
                    DATE_FORMAT(fac_fecha_fact, '%d') dia,
                    DATE_FORMAT(fac_fecha_fact, '%m') mes,
                    DATE_FORMAT(fac_fecha_fact, '%Y') anio,
                    (
                        SELECT 
                            CONCAT_WS(':#', tde_nombre, dcc_valor, tde_codigo_hacienda)
                        FROM dcc_documento_cliente
                        INNER JOIN tde_tipo_documento ON tde_id = dcc_id_tde
                        WHERE dcc_id_cli = cli_id
                        ORDER BY tde_codigo_hacienda DESC
                        LIMIT 1
                    ) documento,
                    fac_id_tif tipo,
                    tif_nombre tipo_nombre,
                    IF(cli_personeria > 1, cli_apellido, CONCAT(cli_nombre, ' ', cli_apellido)) AS cliente,
                    fac_numero numero,
                    ABS(SUM(fac_subtotal)) subtotal,
                    IFNULL(
                        ABS(
                            ROUND(
                                SUM(
                                    (SELECT SUM(ROUND(ixf_monto,4))
                                    from ixf_impuestoxfactura 
                                    JOIN def_detalle_fact on def_id = ixf_id_def 
                                    WHERE def_id_fac = fac_id AND ixf_id_imp IN ($id_iva) 
                                    )
                                )
                            , 2)
                        )
                    , 0) monto_iva,
                    ABS(SUM(fac_total)) total,
                    DATE(fac_fecha_fact) fecha_factura,
                    cli_registro,tif_codigo_hacienda,
                    COUNT(DISTINCT fac_id) n_facturas
                ", false)
                ->from('fac_factura')
                ->join("cli_cliente", "cli_id = fac_id_cli")
                ->join("tif_tipo_factura", "tif_id = fac_id_tif", "LEFT")
        ;
        if (isset($where['group_by'])) {
            $this->db->group_by($where['group_by'],'ASC');
            $this->db->order_by($where['group_by'],'ASC');
            unset($where['group_by']);
        }
        else {
            $this->db->group_by('fac_id','DESC');
        }
        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();        
        return $query->result_array();
    }

    public function get_facturacion_corte_caja($where = null) {
        $this->db->select("caj_id, caj_nombre, SUM(fac_total) AS fac_total_fac, SUM((SELECT SUM((def_subtotal + def_impuesto)) FROM def_detalle_fact WHERE def_id_fac = fac_id)) AS fac_total,
            SUM((SELECT SUM(abf_monto) FROM abf_abono_factura WHERE abf_id_fac = fac_id)) AS abf_monto", false);
        $this->db->from('fac_factura');
        // $this->db->join("abf_abono_factura", "abf_id_fac = fac_id", "left");
        $this->db->join("uxc_usuarioxcaja", "fac_id_uxc = uxc_id");
        $this->db->join("caj_caja", "uxc_id_caj = caj_id");
        $this->db->group_by('caj_id');
        if ($where != null) {
            $this->db->where($where);
        }
        $resultado = $this->db->get();        
        return $resultado->result_array();
    }

    public function update_one_def_facturas_bod($id = null){
        $and = ($id != null) ? "  AND def_id = " . $id : "";
        return $this->db->query("
                UPDATE def_detalle_fact
                JOIN fac_factura on fac_id = def_id_fac
                JOIN bod_bodega on fac_id_suc = bod_id_suc
                SET def_id_bod = (SELECT bod_id from bod_bodega WHERE bod_id_suc = fac_id_suc limit 1)
                WHERE def_id_bod is NULL
                $and
            ");
    }

    public function get_ctdad_facturas_bod(){
        $query = "SELECT COUNT(DISTINCT(fac_id)) AS cantidad
            FROM fac_factura INNER JOIN def_detalle_fact ON fac_id = def_id_fac WHERE fac_estado > 0
            AND fac_id NOT IN ( SELECT moi_id_fac FROM moi_movimiento_inv WHERE moi_estado = 1  and moi_id_fac <> '')";
        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }

    /**
     * @author Raul Escalante - Grupo satélite.
     * @since  2019-07-10
     * @return Datos del saldo pendiente
     * @param  Id del cliente
    **/
    public function get_datos_saldo($cliente = null) {
        $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $nrem = (isset($tipo_factura['NOTA REMISION'])) ? $tipo_factura['NOTA REMISION'] : 0;
        /* SUM(fac_monto_pendiente - fac_total_retencion) AS fac_monto_pendiente  -- CUANDO SE INGRESA LA NOTA DE RETENCION EL VALOR QUEDA NEGATIVO */
        $query = $this->db->select('cli_id, SUM(fac_total - fac_total_retencion) AS fac_total, SUM(fac_monto_abono) AS fac_monto_abono, cli_monto_credito,
            SUM(((fac_total - fac_total_retencion) - IFNULL((SELECT SUM(abf_monto) FROM abc_abono_cliente JOIN abf_abono_factura ON abf_id_abc = abc_id 
            WHERE abc_estado = 1 AND abc_id_cli = fac_id_cli AND abf_id_fac = fac_id), 0))) AS fac_monto_pendiente', FALSE)
            ->from('fac_factura')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->where('fac_estado', 1)
            ->where('fac_id_tif != ', $nrem)
        ;
        if ($cliente != null) {
            $this->db->where('cli_id', $cliente);
        }else{
            $this->db->group_by('cli_id');
        }

        return $query->get()->result_array();
    }

            /**
     * @author Marlon Olmedo
     * @since 2019-07-16
     * @return query para filtrar cotizaciones facturadas.
     */
    public function get_cotizaciones_facturadas($where = null) {
        $query = $this->db->select("*, sum(fac_total) as suma_factura")
                ->from('cot_cotizacion')
                ->join('fac_factura', 'fac_id_cot = cot_id')
                ->join('ven_vendedor', 'ven_id = cot_id_ven')
                ->join('cli_cliente', 'cli_id = cot_id_cli')
                ->group_by('cot_id')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

     /**
     * @author René Castaneda
     * @since 2019-07-29
     * @return query para datos de la serie
     */
    public function get_datos_serie_factura($where_inject = null) {
        $query = $this->db->select()
                ->from('cof_correlativo_factura')
                ->join('sef_serie_factura', 'sef_id = cof_id_sef')
                ->join('cxj_correlativoxcaja', 'cxj_id_cof = cof_id')
                ->group_by('sef_id')
        ;

        if ($where_inject != null) {
            $this->db->where($where_inject,null,false);
        }

        return $query->get()->result_array();
    }

    /**
    * @author Habby Lovo
    * @since 2019-08-15
    * @return query para datos de la factura 
    */
    public function get_reporte_utilidad($where = null){
        /*
            SELECT
                fac_id,
                art_id,
                fac_id_suc,
                ( fac_fecha_fact ) AS fecha,
                art_codigo AS codigo,
                art_nombre AS nombre_articulo,
                mep_nombre AS nombre_medida,
                SUM( def_cantidad ) AS cantidad,
                SUM(
                    (SELECT
                        SUM( IF ( ( sar_precio IS NOT NULL AND sar_precio > 0 ), sar_precio, dee_precio ) * dee_cantidad ) 
                        FROM dee_detalle_mov JOIN sar_saldo_articulo ON dee_id_sar = sar_id 
                        WHERE dee_id_moi = moi_id AND dee_id_art = art_id) 
                ) AS precio_compra_total,
                ( def_precio_inventario ) AS precio_inventario,
                ( def_precio_sugerido_lista ) AS precio_sugerido,
                ( def_precio ) AS precio_venta,
                SUM( ( def_subtotal ) ) AS precio_venta_total 
            FROM ( `fac_factura` )
            INNER JOIN `def_detalle_fact` ON `def_id_fac` = `fac_id`
            INNER JOIN `moi_movimiento_inv` ON `moi_id_fac` = `fac_id`
            INNER JOIN `art_articulo` AS art1 ON `art_id` = `def_id_art`
            INNER JOIN dee_detalle_mov ON dee_id_moi = moi_id and dee_id_art = art_id
            INNER JOIN `cva_conversion_articulo` ON `cva_id` = `def_id_cva`
            INNER JOIN `mep_medida_producto` ON `mep_id` = `cva_id_mep` 
            WHERE ( DATE( fac_fecha_fact ) >= "2019-10-01" AND DATE( fac_fecha_fact ) <= "2019-11-20" ) AND `fac_id_suc` = '1' AND `fac_estado` != 0 
            GROUP BY `art_id`, `mep_id` 
            ORDER BY `nombre_articulo` ASC
        */
        $query = $this->db->select("
                    fac_id,
                    art_id,
                    fac_id_suc,
                    DATE(fac_fecha_fact) AS fecha,
                    art_codigo AS codigo,
                    art_nombre AS nombre_articulo,
                    mep_nombre AS nombre_medida,
                    SUM(def_cantidad) AS cantidad,
                    SUM((SELECT SUM( IF ((sar_precio IS NOT NULL AND sar_precio > 0), sar_precio, dee_precio) * dee_cantidad) 
                            FROM dee_detalle_mov JOIN sar_saldo_articulo ON dee_id_sar = sar_id WHERE dee_id_moi = moi_id AND dee_id_art = art_id
                        ) 
                    ) AS precio_compra_total,
                    (def_precio_inventario) AS precio_inventario,
                    (def_precio_sugerido_lista) AS precio_sugerido,
                    (def_precio) AS precio_venta,
                    SUM(def_subtotal) AS precio_venta_total
                ", false)
                ->from('fac_factura')
                ->join("def_detalle_fact", "def_id_fac = fac_id", "INNER")
                ->join("moi_movimiento_inv", "moi_id_fac = fac_id", "INNER")
                ->join("art_articulo AS art1", "art_id = def_id_art", "INNER")
                ->join("dee_detalle_mov", "dee_id_moi = moi_id and dee_id_art = art_id", "LEFT")
                ->join("cva_conversion_articulo", "cva_id = def_id_cva", "INNER")
                ->join("mep_medida_producto", "mep_id = cva_id_mep", "INNER")
                // ->join("cva_conversion_articulo", "cva_id_art = art1.art_id", "INNER")
                // ->join("art_articulo AS art2", "art2.art_id = dee_id_art", "INNER")
                // ->join("dee_detalle_mov", "dee_id_moi = moi_id AND dee_id_art = def_id_art", "INNER")
                // ->join("sar_saldo_articulo", "sar_id = dee_id_sar", "INNER")
        ;
        $this->db->group_by('art_id, mep_id');
        $this->db->order_by('nombre_articulo','ASC');
        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();        
        return $query->result_array();
    }

    public function get_factura_cinta_auditoria($where=null)
    {
        $this->db->select("fac_id,fac_id_tif")
                ->from('fac_factura')
                ->join('tif_tipo_factura', 'tif_id = fac_id_tif')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_categorias($where = null){
        $this->db->select()
            ->from('tia_tipo_articulo')
            ->order_by('tia_nombre', 'ASC')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_unidad_medida($where = null){
        $this->db->select()
            ->from('mep_medida_producto')
            ->order_by('mep_nombre', 'ASC')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_articulos_promos($where = null){
        $this->db->select()
            ->from('art_articulo')
            ->order_by('art_nombre', 'ASC')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_promocion_articulo($where = null){
        $this->db->select()
            ->from('mep_medida_producto')
            ->order_by('mep_nombre', 'ASC')
        ;
        if($where != null){
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_productos_promociones($where = null, $where_in = null){
        /*
            SELECT
                art.* 
            FROM
                art_articulo AS art
                INNER JOIN tia_tipo_articulo AS tia ON tia.tia_id = art.art_id_tia
                INNER JOIN cva_conversion_articulo AS cva ON cva.cva_id_art = art.art_id
                INNER JOIN mep_medida_producto AS mep ON mep.mep_id = cva.cva_id_mep 
            WHERE
                mep.mep_id = '1' 
                AND tia.tia_id IN ( '118' )
        */
        $this->db->select('*, art_id as codigo, art_nombre as nombre')
            ->from('art_articulo')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia', 'inner')
            ->join('cva_conversion_articulo', 'cva_id_art = art_id', 'inner')            
            ->order_by('art_nombre', 'ASC')
        ;

        if($where != null){
            $this->db->where($where);
        }
        if($where_in != null){
            $this->db->or_where_in('tia_id', $where_in);            
        }
        
        return $this->db->get()->result_array();
    }

    public function get_productos_promociones_categoria_unidadmedida($where = null, $where_in = null){
        /*
            SELECT
                art.* 
            FROM
                art_articulo AS art
                INNER JOIN tia_tipo_articulo AS tia ON tia.tia_id = art.art_id_tia
                INNER JOIN pma_promocion_articulo AS pma ON pma.pma_id_art = art.art_id
                INNER JOIN pmp_promocion_producto AS pmp ON pmp.pmp_id = pma.pma_id_pmp 
            WHERE
                pmp.pmp_id = '10'
        */
        $this->db->select()
            ->from('art_articulo')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia', 'inner')
            ->join('pma_promocion_articulo', 'pma_id_art = art_id', 'inner')
            ->join('pmp_promocion_producto', 'pmp_id = pma_id_pmp', 'inner')
        ;

        if($where != null){
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    public function get_categoria_promocion($where = null){
        /*
            SELECT
                tia.* 
            FROM
                tia_tipo_articulo AS tia
                INNER JOIN pmt_promocion_tipo_articulo AS pmt ON pmt.pmt_id_tia = tia.tia_id
                INNER JOIN pmp_promocion_producto AS pmp ON pmp.pmp_id = pmt.pmt_id_pmp 
            WHERE
                pmt.pmt_id_pmp = '11'
        */
        $this->db->select()
            ->from('tia_tipo_articulo')
            ->join('pmt_promocion_tipo_articulo', 'pmt_id_tia = tia_id', 'inner')
            ->join('pmp_promocion_producto', 'pmp_id = pmt_id_pmp', 'inner')
            ->order_by('tia_nombre', 'ASC')
            ->group_by('tia_nombre')
        ;

        if($where != null){
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    public function validacion_art_tipo_lista_precio($where = null){
        $this->db->select()->from('lip_listado_precio');
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function delete_promociones($id)
    {
        // Elimina los productos x promocion agragados
        $this->db->where('pma_id_pmp', $id);
        $this->db->delete('pma_promocion_articulo');

        // Elimina la promocion
        $this->db->where('pmp_id', $id);
        return $this->db->delete('pmp_promocion_producto');
	}

        /**
     *@author Raul Escalante
     *@since  05-09-2019
     *@param  where con parametros de busqueda
     *@return data_array
    **/

    public function get_reporte_descuentos($where = null){
        $this->db->select('*, (SELECT tlp_nombre FROM tlp_tipo_lista_precio JOIN lip_listado_precio ON tlp_id = lip_id_tlp WHERE lip_id = def_id_lip) AS lista', FALSE)
                 ->from('fac_factura')
                 ->join('def_detalle_fact', 'fac_id = def_id_fac')
                 ->join('art_articulo', 'art_id = def_id_art')
                 ->join('cli_cliente' ,'cli_id = fac_id_cli')
        ;
        if ($where) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-09-2
     * @return se traen los detalles de la nota de remision
     */
    public function get_detalle_nota_remision($where=null)
    {
        $this->db->select("*, (
                SELECT
                    GROUP_CONCAT(
                        CONCAT(
                            cva.cva_id,
                            '-',
                            cva.cva_conversion,
                            '-',
                            cva.cva_defecto
                        )
                    )
                FROM
                    cva_conversion_articulo AS cva
                WHERE
                    cva_id_art = art_id
                AND cva_estado = 1
            ) AS conversiones", false)
                ->from('def_detalle_fact')
                ->join('art_articulo', 'def_id_art = art_id', 'left')
                // ->join('ixf_impuestoxfactura', 'ixf_id_def = def_id', 'left')
                // ->join('rxf_retencionxdetalle_factura', 'rxf_id_def = def_id', 'left')
                ->join('cva_conversion_articulo', 'def_id_cva = cva_id', 'left')
                ->join('mep_medida_producto', 'cva_id_mep = mep_id', 'left')
                // ->join('lip_listado_precio', 'lip_id_art = art_id and lip_id_mep = mep_id', 'left')
        ;
        if ($where != null) {
            $this->db->where($where, false);
        }
        return $this->db->get()->result_array();
    }

    public function get_detalle_remision_facturada($where = null){
        $this->db->select("*, (SELECT GROUP_CONCAT(CONCAT(cva.cva_id,'-',cva.cva_conversion,'-',cva.cva_defecto)) FROM cva_conversion_articulo AS cva
            WHERE cva.cva_id_art = art_id AND cva.cva_estado = 1) AS conversiones, (SELECT GROUP_CONCAT(fxr_id_fac_remision) FROM fxr_factura_remisionxfactura
            WHERE fxr_id_fac = def_id_fac) AS fac_remitidas, IFNULL( (SELECT GROUP_CONCAT(CAST(x.cants AS CHAR(500)) SEPARATOR '##' ) FROM (SELECT sar_id_art, 
                CONCAT( sar_id_bod, '_', SUM( sar_cant_actual )) AS cants FROM sar_saldo_articulo GROUP BY sar_id_bod, sar_id_art) as x WHERE x.sar_id_art = art_id),
            '0_0' ) AS cantidades, (SELECT SUM(sar_cant_actual) FROM sar_saldo_articulo WHERE sar_id_art = art_id ) AS cant_brt
            ", false)
            ->from('def_detalle_fact')
            ->join('art_articulo', 'def_id_art = art_id')
            ->join('cva_conversion_articulo', 'def_id_cva = cva_id', 'left')
            ->join('mep_medida_producto', 'cva_id_mep = mep_id', 'left')
                // ->join('ixf_impuestoxfactura', 'ixf_id_def = def_id', 'left')
                // ->join('rxf_retencionxdetalle_factura', 'rxf_id_def = def_id', 'left')
                // ->join('lip_listado_precio', 'lip_id_art = art_id and lip_id_mep = mep_id', 'left')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-09-2
     * @return trae los montos de pendiente y abonado de la nota de remision
     */
    public function get_monto_nota_remision($where=null){
        $this->db->select("fac_id, fac_monto_pendiente - fac_total as monto_pendiente, fac_monto_abono + fac_total as monto_abonado, fac_total")->from('fac_factura');
        if ($where != null) {
            $this->db->where($where, false);
        }
        return $this->db->get()->result_array();
    }

    function plantilla_exportar_lista_precio($where = null){
        $query = $this->db->select("art_id, art_codigo , art_nombre, lip_desde, lip_hasta, lip_precio, lip_id_mep, lip_id_tlp, tlp_nombre, lip_descuento_min, lip_descuento_max,
            IFNULL((SELECT mep_nombre FROM mep_medida_producto WHERE mep_id = lip_id_mep),'') AS mep_nombre, lip_descuento_min_autorizado, lip_descuento_max_autorizado", FALSE)
            ->from("lip_listado_precio")
            ->join("art_articulo", "art_id = lip_id_art", "INNER")
            ->join("tlp_tipo_lista_precio", "tlp_id = lip_id_tlp", "INNER")
            ->order_by("art_id, lip_desde ASC")
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_clientes_beneficios($where = null){
        /*
            SELECT 
                cli_nombre, cli_apellido, alm_nombre, alm_apellido,cli_id, alm_id_cli_factura, tbf_nombre 
            FROM 
                cli_cliente
            INNER JOIN alm_alumno ON alm_id_cli = cli_id
            INNER JOIN slb_solicitud_beca ON slb_id_alm = alm_id
            INNER JOIN apb_aprobacion_beca ON apb_id_slb = slb_id
            INNER JOIN tbf_tipo_beneficio ON tbf_id = apb_id_tbf
        */
        $query = $this->db->select()
                ->from('cli_cliente')
                ->join("alm_alumno", "alm_id_cli = cli_id", "INNER")
                ->join("slb_solicitud_beca", "slb_id_alm = alm_id", "INNER")
                ->join("apb_aprobacion_beca", "apb_id_slb = slb_id", "INNER")
                ->join("tbf_tipo_beneficio", "tbf_id = apb_id_tbf", "INNER")
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();        
        return $query->result_array();
    }

    /**
     * @author Habby Lovo
     * @since 2019-09-03
     * @return Obtener información sobre los pacientes (tabla: epp_expediente_paciente)
    */
    public function get_facturas_seguimiento($where = null) {
        /*
            SELECT
                *
            FROM
                fac_factura
            INNER JOIN tif_tipo_factura ON tif_id = fac_id_tif
            LEFT JOIN cli_cliente ON cli_id = fac_id_cli
            WHERE
                fac_aplica_seguimiento_anulacion = 1
        */
        $q = $this->db->select()
                ->from('fac_factura')
                ->join('tif_tipo_factura', 'tif_id = fac_id_tif','inner')
                ->join('cli_cliente', 'cli_id = fac_id_cli','left')
        ;
        if ($where) {
            $this->db->where($where);
        }
        
        return $q->get()->result_array();
    }

    public function get_serie_padre($fac_id){
        $query = $this->db->select("CONCAT(sef_abrev,' - ',fac_numero) AS serie_numero", false)
                          ->from('fac_factura')
                          ->join('cof_correlativo_factura', 'cof_id = fac_id_cof')
                          ->join('sef_serie_factura','sef_id = cof_id_sef')
                          ->where('fac_id',$fac_id)
                            ;
        $datos = $this->db->get()->result_array();
        return $datos;
    }

    public function get_fxrs_adic($padre, $hija){
        $this->db->select('fxr_id, fxr_id_fac_remision, fxr_total_unidades_padre, fxr_total_unidades_entregadas')
            ->from('fxr_factura_remisionxfactura')
            ->where('fxr_id_fac', $padre)
            ->where('fxr_id_fac_remision <> ', $hija)
            ->order_by('fxr_fecha_creacion', 'ASC')
        ;
        $extras = $this->db->get()->result_array();
        if (count($extras) > 0) {
            foreach ($extras as $k => $val) {
                $productos = array();
                $this->db->select('def_id, def_id_art, def_id_cva, def_cantidad, def_cantidad_faltante')->from('def_detalle_fact')->where('def_id_fac', $val['fxr_id_fac_remision']);
                $consulta = $this->db->get()->result_array();
                if (count($consulta) > 0) {
                    foreach ($consulta as $m => $var) {
                        $llave = $var['def_id_art'] . "_" . $var['def_id_cva'];
                        $productos[$llave] = $var;
                    }
                }
                $extras[$k]['productos'] = $productos;
            }
        }
        return $extras;
    }


    public function get_ventas_por_vend_tpg($where = null){
        $query = $this->db->select("ven_id, cli_id,
                GROUP_CONCAT(
                    DISTINCT CONCAT(
                        t.fac_id_tpg,
                        '||',
                        (SELECT tpg_nombre FROM tpg_tipo_pago WHERE tpg_id = t.fac_id_tpg),
                        '||',
                        (SELECT SUM(f.fac_subtotal) FROM fac_factura AS f WHERE f.fac_id_cli = t.fac_id_cli AND f.fac_id_ven = t.fac_id_ven 
                            AND f.fac_id_tpg = t.fac_id_tpg AND DATE(f.fac_fecha_fact) = DATE(t.fac_fecha_fact))
                    )
                    ORDER BY t.fac_id_tpg ASC
                    SEPARATOR '##'
                ) AS ventas,
                cli_codigo, IF(cli_personeria = 1, CONCAT(cli_nombre,' ', cli_apellido), cli_apellido) AS nombre_cliente,
            IFNULL((SELECT CONCAT(COUNT(DISTINCT cmc_id), '/', dfc_numero_cuota) FROM cmc_cargo_alumnoxcurso JOIN dfc_detalle_configuracion_cargo ON dfc_id_cfg = cmc_id_cfg WHERE cmc_estado > 0 AND cmc_id_fac = t.fac_id),'--') AS cuotas_pagadas, t.fac_monto_pendiente,
                ven_codigo, CONCAT(ven_nombre,' ',ven_apellidos) AS nombre_vendedor", false)
            ->from('fac_factura AS t')
            ->join('cli_cliente', 'cli_id = t.fac_id_cli')
            ->join('ven_vendedor','ven_id = t.fac_id_ven')
            ->order_by('ven_codigo, cli_codigo ASC')
            ->group_by('ven_id, cli_id')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
    * @author Habby Lovo
    * @since 2019-11-08
    * @return query para datos de la factura 
    */
    public function get_ventas_consolidado($where = null){
        $ID_IMPUESTO_IVA = $this->gsatelite->get_parametro('SYS_ID_IVA');
        $ID_TIPO_NOTA_CREDITO = $this->gsatelite->get_parametro('SYS_ID_TIPO_FACTURA_NOTA_CREDITO');
        /*
            SELECT
                caj_nombre,
                tif_nombre,
                SUM(fac_total) total,
                (
                    SELECT
                        GROUP_CONCAT(
                            CONCAT(tif1.tif_abreviacion,'-', cxj_inicio, '-',cxj_fin)
                        )
                    FROM
                        cxj_correlativoxcaja
                    INNER JOIN cof_correlativo_factura ON cof_id = cxj_id_cof
                    INNER JOIN sef_serie_factura ON sef_id = cof_id_sef
                    INNER JOIN tif_tipo_factura AS tif1 ON tif1.tif_id = sef_id_tif
                    WHERE cxj_id_cof = fac_id_cof
                ) correlativos
            FROM
                fac_factura
            INNER JOIN tif_tipo_factura ON tif_id = fac_id_tif
            INNER JOIN uxc_usuarioxcaja ON uxc_id = fac_id_uxc
            INNER JOIN caj_caja ON caj_id = uxc_id_caj
            WHERE
                DATE(fac_fecha_fact) = "2019-11-01"
            GROUP BY
                uxc_id_caj,
                tif_id
        */
        $query = $this->db->select("
                    caj_nombre,
                    tif_nombre,
                    SUM(( SELECT SUM((def_subtotal + def_impuesto)) FROM def_detalle_fact WHERE def_id_fac = fac_id)) total,
                    (
                        SELECT
                            GROUP_CONCAT(
                                CONCAT(tif1.tif_abreviacion,'-', fac_numero, '-',(fac_numero + (count(fac_id) - 1) ) )
                            )
                        FROM
                            cxj_correlativoxcaja
                        INNER JOIN cof_correlativo_factura ON cof_id = cxj_id_cof
                        INNER JOIN sef_serie_factura ON sef_id = cof_id_sef
                        INNER JOIN tif_tipo_factura AS tif1 ON tif1.tif_id = sef_id_tif
                        WHERE cxj_id_cof = fac_id_cof AND cxj_id_caj = caj_id AND cxj_estado = 1
                    ) correlativos,
                    SUM( ( SELECT SUM((def_subtotal)) FROM def_detalle_fact WHERE def_id_fac = fac_id) ) subtotal,
                    ABS((SUM( (SELECT sum(def_impuesto) FROM def_detalle_fact WHERE def_id_fac = fac_id ) ) -  IFNULL(SUM((
                        SELECT SUM(ixf_monto)
                        FROM def_detalle_fact
                        JOIN ixf_impuestoxfactura ON def_id = ixf_id_def
                        WHERE def_id_fac = fac_id AND ixf_id_imp = ".$ID_IMPUESTO_IVA." AND fac_id_tif != ".$ID_TIPO_NOTA_CREDITO."
                    )),0.00))) as impuesto,
                    IFNULL(SUM((
                        SELECT SUM(ixf_monto)
                        FROM def_detalle_fact
                        JOIN ixf_impuestoxfactura ON def_id = ixf_id_def
                        WHERE def_id_fac = fac_id AND ixf_id_imp = ".$ID_IMPUESTO_IVA." AND fac_id_tif != ".$ID_TIPO_NOTA_CREDITO."
                    )),0.00) as iva
                ", false)
                ->from('fac_factura')
                ->join("tif_tipo_factura", "tif_id = fac_id_tif", "INNER")
                ->join("uxc_usuarioxcaja", "uxc_id = fac_id_uxc", "INNER")
                ->join("caj_caja", "caj_id = uxc_id_caj", "INNER")
        ;
        $this->db->group_by('uxc_id_caj, tif_id');
        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();        
        return $query->result_array();
    }

    /**
     * @author Elman Ortiz  
     * @since 2018-12-04
     * @param array where
     * @return array participacion de ventas por cliente
    */
    public function get_reporte_participacion_ventas_cliente($where = null, $groupby = null) {                                
        $query = "  SELECT fac_id, fac_id_cli,fac_id_ven, ven_id,
                    (SELECT IF(cli_personeria = 1, CONCAT(cli_nombre,' ', cli_apellido), cli_apellido) FROM cli_cliente WHERE cli_id = fac_id_cli) AS nombre_cliente,
                    SUM(fac_subtotal) AS subtotal,
                    CONCAT(ven_nombre,' ',ven_apellidos) as nombre_vendedor
                    FROM fac_factura
                    join ven_vendedor on fac_id_ven = ven_id ";
        if($where != null){
            $where_sql = "WHERE fac_estado != 0 ";
            $where_sql .= "AND DATE_FORMAT(fac_fecha_fact,'%Y-%m-%d') >= '".$where['fecha_inicio']."'";
            $where_sql .= "AND DATE_FORMAT(fac_fecha_fact,'%Y-%m-%d') <= '".$where['fecha_fin']."'";
            if($where['id_cliente'] != 'null'){            
                $where_sql .= " AND fac_id_cli IN(".$where['id_cliente'].")";
            }
            if($where['ven_id'] != 'null'){            
                $where_sql .= " AND ven_id = ".$where['ven_id'];
            }
            /*if(isset($where['id_tipo_factura'])){            
                $where_sql .= " AND fac_id_tif = ".$where['id_tipo_factura'];
            }*/       
            $query .= $where_sql;        
        }

        if($groupby != null){        
            $groupby_sql = " GROUP BY " . $groupby;
            $query .= $groupby_sql;  
        }
        $query .= " ORDER BY CONCAT(ven_nombre,' ',ven_apellidos), fac_subtotal DESC";  
        //print_r($query);die();
        $result = $this->db->query($query);
        return $result->result_array();        
    }//Fin get_reporte_participacion_cliente

   /**********************************************************/
    /**
     * @author Elman Ortiz  
     * @since 2018-12-05
     * @param array where
     * @return array participacion de ventas por cliente
    */
    public function get_nombre_cliente_personeria() {                                            
        $query = "
            SELECT cli_id,
            IF(cli_personeria = 1, CONCAT(cli_codigo, ' - ',cli_nombre, ' ',cli_apellido), CONCAT(cli_codigo, ' - ',cli_apellido)) AS cli_nombre
            FROM cli_cliente          
        ";
      
        $result = $this->db->query($query);
        return $result->result_array();        
    }

    /**
     * @author Andrea Rivera  
     * @since 2020-01-07
     * @param array where
     * @return array con registros para el reporte de precios por ventas
    */

    public function get_lista_precio_venta($where = null)
    {
        $query = $this->db->select("
            fac_id,
            art_id,
            fac_id_suc,
            DATE(fac_fecha_fact) AS fecha,
            art_codigo AS codigo,
            art_nombre AS nombre_articulo,
            mep_nombre AS nombre_medida,
            tlp_nombre AS tipo_lista,
            SUM(def_cantidad) AS cantidad,
            SUM((SELECT SUM( IF ((sar_precio IS NOT NULL AND sar_precio > 0), sar_precio, dee_precio) * dee_cantidad) 
                    FROM dee_detalle_mov JOIN sar_saldo_articulo ON dee_id_sar = sar_id WHERE dee_id_moi = moi_id AND dee_id_art = art_id
                ) 
            ) AS precio_compra_total,
            (def_precio_inventario) AS precio_inventario,
            (def_precio_sugerido_lista) AS precio_sugerido,
            (def_precio) AS precio_venta,
            SUM(def_subtotal) AS precio_venta_total
        ", false)
        ->from('fac_factura')
        /*->join('tia_tipo_articulo', 'tia_id = art_id_tia')
        ->join('lip_listado_precio', 'lip_id_art = art_id')*/
        ->join("def_detalle_fact", "def_id_fac = fac_id", "INNER")
        ->join("moi_movimiento_inv", "moi_id_fac = fac_id", "INNER")
        ->join("art_articulo AS art1", "art_id = def_id_art", "INNER")
        ->join("dee_detalle_mov", "dee_id_moi = moi_id and dee_id_art = art_id", "LEFT")
        ->join("lip_listado_precio", "lip_id_art = art_id AND lip_id = def_id_lip", "INNER")
        ->join("tlp_tipo_lista_precio", "tlp_id = lip_id_tlp", "INNER")
        ->join("cva_conversion_articulo", "cva_id = def_id_cva", "INNER")
        ->join("mep_medida_producto", "mep_id = cva_id_mep", "INNER");

        $this->db->group_by('art_id, mep_id');
        $this->db->order_by('nombre_articulo','ASC');
        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();        
        return $query->result_array();
    }

    /**
     * @author Raul E.
     * @since Feb-2020
     * @param array where
     * @return array con registros de fcaturas
    */
    function get_facturas_like($where = null, $like = null, $select_query = "*") {
        $query = $this->db->select($select_query,false)
                ->from('fac_factura')
                ->join('tif_tipo_factura', 'tif_id = fac_id_tif');
        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->where($like);
        }
        $this->db->limit(100);
        $this->db->order_by('fac_fecha_fact DESC');
        return $query->get()->result_array();
    }

    /**
     * @since JUN-2022
     * @param array where
     * @return array con registros de detalles
    */
    function get_detalles_nota_rem($where = null, $group_by = null) {
        $query = $this->db->select("(SELECT o.fac_fecha_fact FROM fac_factura AS o WHERE o.fac_id = fxr_id_fac) AS fecha_padre, fac_id_cli, fac_fecha_fact,
            fxr_id_fac, def_id_fac, fxr_id, def_id_art, fac_numero, art_codigo, art_nombre,  def_cantidad, SUM(def_cantidad) AS def_cantidad_sumada,
            (SELECT d.def_cantidad FROM def_detalle_fact AS d JOIN fac_factura AS f ON f.fac_id = d.def_id_fac WHERE f.fac_id = fxr_id_fac 
                AND d.def_id_art = art_id AND d.def_id_cva = def_id_cva) AS solicitado, def_cantidad_faltante, MIN(def_cantidad_faltante) AS faltante_calculado,
            (SELECT mep_nombre FROM cva_conversion_articulo JOIN mep_medida_producto ON mep_id = cva_id_mep WHERE cva_id = def_id_cva) AS uni_medida, 
            (SELECT sef_abrev FROM cof_correlativo_factura JOIN sef_serie_factura ON sef_id = cof_id_sef WHERE cof_id = fac_id_cof) AS fac_serie, 
            (SELECT cli_codigo FROM cli_cliente WHERE cli_id = fac_id_cli) AS cli_codigo, 
            (SELECT CONCAT(sef_abrev, ' - ', f.fac_numero, ' (', DATE_FORMAT(f.fac_fecha_fact,'%d-%m-%Y'), ')') FROM fac_factura AS f
                JOIN cof_correlativo_factura ON cof_id = f.fac_id_cof JOIN sef_serie_factura ON sef_id = cof_id_sef WHERE f.fac_id = fxr_id_fac) AS factura_padre, 
            (SELECT IF(cli_personeria > 1, cli_apellido, CONCAT_WS(' ', cli_nombre, cli_apellido)) FROM cli_cliente WHERE cli_id = fac_id_cli) AS cli_nombre, 
            IFNULL((SELECT bod_nombre FROM moi_movimiento_inv JOIN bod_bodega ON bod_id = moi_id_bod WHERE moi_id_fac = fac_id), '') AS bodega", false)
                ->from('def_detalle_fact')
                ->join('art_articulo', 'art_id = def_id_art')
                ->join('fac_factura', 'def_id_fac = fac_id')
                ->join('fxr_factura_remisionxfactura', 'fxr_id_fac_remision = fac_id');
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }
        $this->db->order_by('fecha_padre ASC, fac_id_cli ASC, fac_fecha_fact ASC');
        return $query->get()->result_array();
    }

    /**
     * @since JUN-2022
     * @param array where
     * @return array con registros de detalles
    */
    function get_notaS_sin_facturar($where = null) {
        $query = $this->db->select("fac_id_cli, def_id_fac, fac_fecha_fact, fac_numero, art_codigo, art_nombre, def_cantidad,
            (SELECT cli_codigo FROM cli_cliente WHERE cli_id = fac_id_cli) AS cli_codigo, 
            (SELECT mep_nombre FROM cva_conversion_articulo JOIN mep_medida_producto ON mep_id = cva_id_mep WHERE cva_id = def_id_cva) AS uni_medida,
            (SELECT sef_abrev FROM cof_correlativo_factura JOIN sef_serie_factura ON sef_id = cof_id_sef WHERE cof_id = fac_id_cof) AS fac_serie,
            IFNULL((SELECT bod_nombre FROM moi_movimiento_inv JOIN bod_bodega ON bod_id = moi_id_bod WHERE moi_id_fac = fac_id), '') AS bodega,
            (SELECT IF(cli_personeria > 1, cli_apellido, CONCAT_WS(' ', cli_nombre, cli_apellido)) FROM cli_cliente WHERE cli_id = fac_id_cli) AS cli_nombre", false)
                ->from('def_detalle_fact')
                ->join('art_articulo', 'art_id = def_id_art')
                ->join('fac_factura', 'def_id_fac = fac_id')
                ->join('fxr_factura_remisionxfactura', 'fxr_id_fac_remision = fac_id', 'left');
        if ($where) {
            $this->db->where($where);
        }
        $this->db->order_by('fac_id_cli, fac_fecha_fact');
        return $query->get()->result_array();
    }

    /**
     * @since JUL-2022
     * @param array where
     * @return array con registros de detalles
    */
    function get_fact_con_retenc($where = null) {
        $query = $this->db->select("fac_id, fac_id_cli, fac_fecha_fact, fac_total_retencion, fac_subtotal, fac_descuento, fac_impuesto, fac_total,
            fac_monto_pendiente, fac_monto_abono, fac_estado, fac_numero,
            (SELECT IF(cli_personeria > 1,cli_apellido,CONCAT_WS(' ',cli_nombre, cli_apellido)) FROM cli_cliente WHERE cli_id = fac_id_cli) AS cliente,
            (SELECT sef_abrev FROM cof_correlativo_factura JOIN sef_serie_factura ON sef_id = cof_id_sef WHERE sef_id_tif = fac_id_tif AND cof_id = fac_id_cof) AS serie,
            (SELECT CONCAT(ven_nombre,' ',ven_apellidos) FROM ven_vendedor WHERE ven_id = fac_id_ven) AS vendedor ", false)
            ->from('fac_factura')
        ;
        if ($where) {
            $this->db->where($where);
        }
        $this->db->order_by('fac_fecha_fact, fac_id_cli');
        return $query->get()->result_array();
    }

    function facturas_padres_remision($where = null){
        $query = $this->db->select("fac_id, CONCAT(sef_abrev, ' - ', fac_numero, ' (', DATE_FORMAT(fac_fecha_fact,'%d-%m-%Y'), ')') AS factura", false)
            ->from('fac_factura')
            ->join('fxr_factura_remisionxfactura', 'fxr_id_fac = fac_id')
            ->join('cof_correlativo_factura', 'cof_id = fac_id_cof')
            ->join('sef_serie_factura', 'sef_id = cof_id_sef AND sef_id_tif = fac_id_tif')
        ;
        if ($where) {
            $this->db->where($where);
        }
        $this->db->group_by('fac_id');
        return $query->get()->result_array();
    }

    /**
     *@author Max Molina
     *@since  27-10-2021
     *@param  like con parametros de busqueda
    **/

    function clientes_facturas_enttregas_inventario($like = null){
        $query = $this->db->select('*')
                ->from('cli_cliente');
        if ($like != null) {
            $this->db->like('cli_apellido', $like);
            $this->db->or_like('cli_nombre', $like);
        }
        return $query->get()->result_array();
    }

    /**
     *@author Max Molina
     *@since  27-10-2021
     *@param  where con parametros de busqueda
    **/

    function facturas_enttregas_inventario($where = null, $like = null, $select_query = "*"){
        $query = $this->db->select($select_query,false)
                ->from('fac_factura')
                ->join('tif_tipo_factura', 'tif_id = fac_id_tif');
        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->where($like);
        }
        $this->db->limit(100);
        $this->db->order_by('fac_fecha_fact DESC');
        return $query->get()->result_array();
    }

    /**
     *@author Max Molina
     *@since  28-10-2021
     *@param  like con parametros de busqueda
    **/

    function lista_facturasXclientes($where_cliente = null, $where_factura = null, $where_date = null){
        $select = '*,
        (SELECT	CONCAT( art_codigo," - ",art_nombre) FROM	art_articulo WHERE	art_id = DEF.def_id_art LIMIT 1) as nom,
        (SELECT	mep_nombre FROM	mep_medida_producto	JOIN	cva_conversion_articulo	ON mep_id = cva_id_mep WHERE	cva_id = DEF.def_id_cva AND	cva_id_art = DEF.def_id_art LIMIT 1) as nombre,
        (SELECT DATE(moi_fecha_mov) FROM moi_movimiento_inv WHERE moi_id_fac = FAC.fac_id LIMIT 1 ) AS fecha_fac,
        (SELECT moi_documento FROM moi_movimiento_inv WHERE moi_id_fac = FAC.fac_id LIMIT 1 ) AS documento,
        (SELECT	cva_conversion FROM	cva_conversion_articulo	WHERE	cva_id = def_id_cva AND	cva_id_art = DEF.def_id_art LIMIT 1) as cvafax,
        (SELECT cva_conversion FROM cva_conversion_articulo JOIN dee_detalle_mov ON cva_id = dee_id_cva JOIN moi_movimiento_inv ON dee_id_moi = moi_id WHERE moi_id_fac = FAC.fac_id AND dee_id_art = DEF.def_id_art LIMIT 1) AS cvadesp,
        (SELECT SUM(dee_cantidad) FROM dee_detalle_mov JOIN moi_movimiento_inv ON dee_id_moi = moi_id WHERE moi_id_fac = FAC.fac_id AND dee_id_art = DEF.def_id_art ) AS ctdaddes';
        $query = $this->db->select($select, false)
                ->from('def_detalle_fact AS DEF')
                ->join('fac_factura AS FAC','FAC.fac_id = DEF.def_id_fac')
                ->join('tif_tipo_factura TIF','TIF.tif_id = FAC.fac_id_tif')
                ->join('cli_cliente CLI','CLI.cli_id = FAC.fac_id_cli');

        if ($where_cliente != null) {
            $this->db->where('CLI.cli_id', $where_cliente);
        }
        if ($where_factura != null) {
            $this->db->where('FAC.fac_id', $where_factura);
        }
        $this->db->where($where_date);
        return $query->get()->result_array();
    }

    public function notasrem_nofact($params){
        // var_dump($params);die();
        $query = "SELECT tf.tif_abreviacion as tif_abbr, fc.fac_id, fc.fac_fecha_fact, cl.cli_personeria, cl.cli_id, cl.cli_nombre, 
            cl.cli_apellido, df.def_id_art, df.def_descripcion, df.def_cantidad, fc.fac_observacion
            FROM fac_factura fc 
            INNER JOIN tif_tipo_factura tf ON fc.fac_id_tif = tf.tif_id 
            INNER JOIN def_detalle_fact df ON fc.fac_id = df.def_id_fac 
            INNER JOIN cli_cliente cl ON fc.fac_id_cli = cl.cli_id
            WHERE tf.tif_id = $params->tipoFactura 
            AND fac_fecha_fact BETWEEN $params->fecha_desde AND $params->fecha_hasta
            AND fc.fac_id NOT IN (SELECT fxr_id_fac_remision FROM fxr_factura_remisionxfactura WHERE fxr_estado > 0) ";
        if ($params->sucursal > 0) {
            $query .= "AND fc.fac_id_suc = $params->sucursal ";
        }
        $query .= "ORDER BY cl.cli_id";
        $result = $this->db->query($query);
        return $result->result();
    }

    public function detalle_nota_envio($orv = null){
        $this->db->select("art_codigo, dov_descripcion, mrp_nombre, dov_cantidad, bod_nombre",false)
            ->from('dov_detalle_orden_venta')
            ->join('bod_bodega', 'bod_id = dov_id_bod', 'LEFT')
            ->join('art_articulo', 'art_id = dov_id_art', 'INNER')
            ->join('mrp_marca_producto', 'mrp_id = art_id_mrp', 'LEFT')
            ->where(array('dov_id_orv' => $orv))
            ;
        return $this->db->get()->result_array();
    }

    public function get_reporte_ventas_cuotas ($where = null) {
        $query = $this->db->select("*, 
                IFNULL((SELECT IF(x.cli_personeria > 1, x.cli_apellido, CONCAT_WS(' ', x.cli_nombre, x.cli_apellido)) FROM cli_cliente AS x WHERE x.cli_id = c.cli_id_cli_asociado), 
                IF(c.cli_personeria > 1, c.cli_apellido, CONCAT_WS(' ', c.cli_nombre, c.cli_apellido))) AS cli_asociado,
                (SELECT sef_abrev FROM cof_correlativo_factura JOIN sef_serie_factura ON sef_id = cof_id_sef WHERE sef_id_tif = fac_id_tif AND cof_id = fac_id_cof) AS serie_fac,
                (SELECT tpg_nombre FROM tpg_tipo_pago WHERE tpg_id = fac_id_tpg) AS tipo_pago,
                CASE WHEN cmc_estado_cargo = 0 THEN 'Eliminado'
					WHEN cmc_estado_cargo = 1 THEN 'Pendiente'
					WHEN cmc_estado_cargo = 2 AND cmc_id_fac IS NULL THEN 'Pago pendiente de facturar' 
					WHEN cmc_estado_cargo = 2 AND cmc_id_fac IS NOT NULL THEN 'Pagado y facturado'
				END AS estado_cargo"
            , false)
            ->from('cmc_cargo_alumnoxcurso')
            ->join('lxp_alumnoxpensum', 'lxp_id = cmc_id_lxp')
            ->join('lxa_alumnoxarea', 'lxa_id = lxp_id_lxa')
            ->join('alm_alumno', 'alm_id = lxa_id_alm')
            ->join('cli_cliente AS c', 'c.cli_id = alm_id_cli')
            ->join('gra_grupo_academico', 'gra_id = lxp_id_gra')
            ->join('pen_pensum', 'pen_id = gra_id_pen')
            ->join('ard_area_academica', 'ard_id = gra_id_ard')
            ->join('mod_modulo', 'mod_id = pen_id_mod')
            ->join('art_articulo', 'art_id = mod_id_art')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
            ->join('fac_factura', 'fac_id = cmc_id_fac', 'left')
            ->join('ven_vendedor', 'ven_id = fac_id_ven', 'left')
            ->join('frp_forma_pago', 'frp_id = fac_id_frp', 'left')
            ->order_by("lxp_id ASC, cmc_periodo ASC")
        ;
        if ($where) {
            $this->db->where($where);
        }

        $this->db->group_by('cmc_id');

        return $query->get()->result_array();
    }

    public function get_total_facturas_generadas_no_transmitidas ($where = null) {

        $query = $this->db->select("count(*) as total", false)
            ->from('fac_factura')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->join('tif_tipo_factura', 'tif_id = fac_id_tif')
            ->where(array("fac_numero_control IS NULL" => null))
        ;
        if ($where) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_total_facturas_validadas ($where = null) {

        $query = $this->db->select("count(*) as total", false)
            ->from('fac_factura')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->join('tif_tipo_factura', 'tif_id = fac_id_tif')
            ->where(array("fac_sello_recepcion IS NOT NULL" => null))
        ;
        if ($where) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_total_facturas_transmitidas_no_procesadas ($where = null) {

        $query = $this->db->select("count(*) as total", false)
            ->from('fac_factura')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->join('tif_tipo_factura', 'tif_id = fac_id_tif')
            ->where(array("fac_sello_recepcion IS NULL" => null, "fac_observaciones_factura_electronica IS NOT NULL" => null))
        ;
        if ($where) {
            $this->db->where($where);
        }

        return $query->get()->result_array();

    }

    public function get_total_facturas_enviadas_por_correo ($where = null) {

        $query = $this->db->select("count(*) as total", false)
            ->from('fac_factura')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->join('tif_tipo_factura', 'tif_id = fac_id_tif')
            ->where(array("fac_sello_recepcion IS NOT NULL" => null, "fac_transmitida_correo" => 1))
        ;
        if ($where) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_total_facturas_no_enviadas_por_correo ($where = null) {

        $query = $this->db->select("count(*) as total", false)
            ->from('fac_factura')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->join('tif_tipo_factura', 'tif_id = fac_id_tif')
            ->where(array("fac_sello_recepcion IS NOT NULL" => null, "fac_transmitida_correo" => 0))
        ;
        if ($where) {
            $this->db->where($where);
        }

        return $query->get()->result_array();

    }

    public function get_doc_dte_cre($cre_id){
        $rnt = $this->gsatelite->get_parametro('SYS_RENTA');
        $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
        $nrc = $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NRC_PROVEEDOR');
        $query = $this->db->select("*, (SELECT dcp_valor FROM dcp_documento_proveedor WHERE dcp_id_tde = $nit AND dcp_id_prv = prv_id AND dcp_estado = 1 LIMIT 1) AS prv_nit,
            (SELECT dcp_valor FROM dcp_documento_proveedor WHERE dcp_id_tde = $dui AND dcp_id_prv = prv_id  AND dcp_estado = 1 LIMIT 1) AS prv_dui, 
            (SELECT dcp_valor FROM dcp_documento_proveedor WHERE dcp_id_tde = $nrc AND dcp_id_prv = prv_id  AND dcp_estado = 1 LIMIT 1) AS prv_registro, 
            (SELECT tde_codigo_fact_elect FROM tde_tipo_documento WHERE tde_id = $nit) AS cod_tde_nit, 
            (SELECT tde_codigo_fact_elect FROM tde_tipo_documento WHERE tde_id = $dui) AS cod_tde_dui,
            (SELECT tep_numero FROM tep_telefono_proveedor WHERE tep_estado = 1 AND tep_id_prv = prv_id ORDER BY tep_id DESC LIMIT 1) AS telefono, 
            (SELECT cpd_correo FROM cpd_correo_proveedor WHERE cpd_id_prv = prv_id AND cpd_estado = 1 ORDER BY cpd_id ASC LIMIT 1) AS correo,
            (SELECT GROUP_CONCAT(DISTINCT cpd_correo ORDER BY cpd_id ASC SEPARATOR '##') FROM cpd_correo_proveedor WHERE TRIM(cpd_correo) != '' AND cpd_id_prv = prv_id AND cpd_estado = 1) AS mail_adic,
            ( IFNULL(( SELECT SUM( rxd_monto ) FROM dcr_detalle_comprobante_retencion JOIN rxd_retencionxdetalle_documento ON rxd_id = dcr_id_rxd JOIN dxd_detalle_documento_proveedor ON dxd_id = dcr_id_dxd JOIN ret_retencion ON ret_id = rxd_id_ret WHERE ret_estado = 1 AND rxd_estado = 1 AND dcr_id_cre = cre_id AND ret_codigo_fact_elect IS NOT NULL ORDER BY ret_id LIMIT 1 ), 0 )) AS retencion
            ", false)
            ->from('cre_comprobante_retencion')
            ->join('prv_proveedor', 'prv_id = cre_id_prv')
            ->join('mun_municipio', 'mun_id = prv_id_mun', 'left')
            ->join('dep_departamento', 'dep_id = mun_id_dep', 'left')
            ->join('gir_giro', 'gir_id = prv_id_gir', 'left')
            ->where('cre_id', $cre_id)
        ;
        return $query->get()->result_array();
    }    

    public function get_cuerpo_dte_compra_dcr($cre_id){
        $query = $this->db->select("dcr_id_cre, dxd_cantidad, art_codigo, IF(dxd_descripcion != '', dxd_descripcion, art_nombre) AS dxd_descripcion, mep_codigo, dxd_precio_unitario,
            dxd_impuesto, dxd_descuento, dxd_retencion, CASE art_tipo WHEN 0 THEN '1' WHEN 1 THEN '2' ELSE '3' END AS code_art_tipo, dxd_total, dxd_subtotal, rxd_monto,
            CASE WHEN art_tipo > 0 THEN '99' ELSE IFNULL(mep_cogigo_fact_elect, '99') END AS code_uni_medi, ret_codigo_fact_elect, dpv_fecha_documento AS fecha_padre, 
            (SELECT tif_codigo_fact_elect FROM tif_tipo_factura WHERE tif_id = dpv_id_tif) AS tipo_padre, dpv_numero_documento AS numero_padre,
            GROUP_CONCAT(CONCAT_WS('##',ROUND(dxd_cantidad,2), mep_nombre, IF(dxd_descripcion <> '',dxd_descripcion,art_nombre), ROUND(dxd_subtotal,2), ROUND(dxd_retencion, 2)) SEPARATOR '&&') AS descrips, 
            SUM(dxd_subtotal) AS sum_sujeto, SUM(rxd_monto) AS sum_retencion"
            , false)
            ->from('dcr_detalle_comprobante_retencion')
            ->join('dxd_detalle_documento_proveedor', 'dxd_id = dcr_id_dxd')
            ->join('rxd_retencionxdetalle_documento', 'rxd_id_dxd = dxd_id')
            ->join('ret_retencion', 'ret_id = rxd_id_ret')
            ->join('art_articulo', 'art_id = dxd_id_art')
            ->join('cva_conversion_articulo', 'cva_id = dxd_id_cva')
            ->join('mep_medida_producto', 'mep_id= cva_id_mep')
            ->join('dpv_documento_proveedor', 'dpv_id = dxd_id_dpv')
            ->where('dcr_id_cre', $cre_id)
            ->group_by('dxd_id_dpv, ret_codigo_fact_elect');///dpv_id
        ;
        return $query->get()->result_array();
    }

    
} // End class