<?php
class Expediente_personal_model extends CI_Model
{
	function __construct()
    {
        parent::__construct();
    }


    public function porcentajes_seguro_empleado($id_emp) {
        //preguntar por los padres
            $query = $this->db->select()
            ->from('prs_porcentaje_seguro')
            ->join('sxe_seguroxempleado','prs_porcentaje_seguro.prs_id_sxe = sxe_seguroxempleado.sxe_id')
            ->where('sxe_id_emp',$id_emp)
            ;
            $resultado = $query->get()->result_array();
            $ids=array();
            foreach ($resultado as $fila) {
             $ids[]=$fila['prs_id'];
         }
         //return $resultado;
         if(count($ids)>0) {
          return implode(',', $ids);
      }
      else {
          return '0';
      }

    }

  /**
   * @author Boris Estrada
   */
    function cumpleaneros($desde, $hasta, $area=null, $sucursal = null, $empresa = null){
      $filtro = '';
      if($area != null){   
        $filtro = ' AND emp_id_are = '.$area;
      }

      if($sucursal > 0 ){   
        $filtro = ' AND emp_id_suc = '.$sucursal;
      }
      //$where_empresa = "";
      $where_empresa = ($empresa > 0 )? "emp_id_emr = $empresa AND ": "emp_id_emr = ". $this->tank_auth->get_empresa_id() . " AND ";
      if ($empresa == -1 ) {
        $where_empresa = "";
      }
      $fechas = 'SELECT * FROM emp_empleado
        INNER JOIN are_area ON are_id = emp_id_are LEFT JOIN emr_empresa ON emr_id = emp_id_emr
        WHERE '. $where_empresa .' (DATE_FORMAT(emp_fecha_nac, "%m-%d") BETWEEN "'.formatear_fecha('m-d', $desde).'" AND "'.formatear_fecha('m-d', $hasta).'") AND emp_estado = 1 '.$filtro.'
        ORDER BY DATE_FORMAT(emp_fecha_nac, "%m"), DATE_FORMAT(emp_fecha_nac, "%d") asc';
    
      $resultado=$this->db->query($fechas)->result_array();
      return $resultado;

      /*$this->db->select()
      ->from('emp_empleado')
      ->join('are_area', 'are_id=emp_id_are', 'left')
      ->where('')
      ->where('emp_estado', 1);
      if($area!=null){   
          $this->db->where('emp_id_are', $area);
      }
      $consulta=$this->db->get();
      $empleados=$consulta->result_array();
      return $empleados;*/
    }

  /**
  * @author René Castaneda
  */

  function get_permitidos_plaza($id_excluir=null) {
    $query = $this->db->select('emp_id_plz')->from('emp_empleado')->where('emp_estado',1)->get()->result_array();
    $ids = array(0);
    foreach ($query as $fila) {
      if($fila['emp_id_plz'] != $id_excluir && $fila['emp_id_plz'] != null ) {
        $ids[] = $fila['emp_id_plz'];
      }
    }
    return $ids;
  }

  function get_permitidos_plaza_solicita($id_excluir=null) {
    $query = $this->db->select('sle_id_plz')->from('sle_solicitante_empleo')->where('sle_estado',1)->get()->result_array();
    $ids=array(0);
    foreach ($query as $fila) {
      if($fila['sle_id_plz']!=$id_excluir and $fila['sle_id_plz'] !=null ) {
        $ids[] = $fila['sle_id_plz'];
      }
    }
    return $ids;
  }

  public function fecha_vencimiento($desde,$hasta,$documento)
  {
    $fechas="SELECT * FROM dce_documento_emp 
    INNER JOIN emp_empleado ON emp_id = dce_id_emp
    LEFT JOIN tde_tipo_documento ON dce_id_tde= tde_id
    WHERE dce_id_tde = ".$documento." AND emp_estado = 1 AND (dce_fecha_vence BETWEEN '".$desde."' AND '".$hasta."')" ;
    $resultado=$this->db->query($fechas)->result_array();
    return $resultado;
  }

  function fecha_vencimiento_nuevo($where = null){
    $query = $this->db->select()
              ->from('dce_documento_emp')
              ->join('emp_empleado','emp_id = dce_id_emp','inner')
              ->join('tde_tipo_documento','dce_id_tde= tde_id','left')
              ->where('emp_id_emr', $this->tank_auth->get_empresa_id())
              ->where('emp_estado', 1)
    ;
    if($where != null){
      $this->db->where($where);
    }
    return $query->get()->result_array();
  }

  public function plazas_agrupadas() {
   $query = $this->db->select('GROUP_CONCAT(plz_id) ids, plz_nombre')
            ->from('plz_plaza')
            ->where('plz_estado',1)
            ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
            ->where('mxr_id_emr',$this->tank_auth->get_empresa_id())
            ->group_by('plz_nombre');
  return $query->get()->result_array();         
  }

  /**
  * @Descripcion.
  * Obtiene los valores de la tabla en distinto orden
  * @author Habby Lovo
  * @since 2017-20-02
  * @param String $tabla, Array $orden (campo, orden), Array $where
  */
  // Obtiene el select de distinto orden

    public function get_select($tabla, $orden=null, $where=null){
      if($where){
          $this->db->where($where);
      }
      if($orden){
          $this->db->order_by($orden[0],$orden[1]);
      }
      //$this->db->order_by('hrg_inicio', 'asc');

      $results=$this->db->get($tabla)->result_array();
      return $results;
    }

    function get_dropdown($tabla, $display = '', $name = '', $where = '', $selected = null
                            , $extras = '', $primary = '', $soloOpciones = false)
    {
        if(!$tabla && !is_string($tabla)){
            return 'Error: Sin Tabla.';
        }
        
        //obtenemos la llave primaria
        if( $primary == '' ){
            foreach($this->db->field_data($tabla) as $field){
                if($field->primary_key){
                    $primary = $field->name;
                }
            }
            
            if($primary == ''){
                return "Error: $tabla no tiene LLave Primaria.";
            }
        }
        
        $select = "$tabla.$primary";
        
        //pre consulta
        if(strstr($display,'{'))
      {
        $display = str_replace(" ", "&nbsp;", $display);
        $select .= ", CONCAT('".str_replace(array('{','}'),array("',COALESCE(",", ''),'"),str_replace("'","\\'",$display))."') as valor ";
      }
        else if($display == '')
        {
            $select .= ", $tabla.$primary as valor";
        }
      else
      {
        $select .= ", $tabla.$display as valor";
      }
        
        //Consulta
        $this->db->select($select, false);
        if($where) $this->db->where($where);
        $this->db->order_by('valor');
        $result = $this->db->get($tabla);
        //echo $this->db->last_query(); die();
        
        //Clasificador
        $return = array();
        
        if( $result->num_rows() > 0 ){
            $return[0] = 'Seleccione';
            foreach ($result->result() as $row){
                $return[$row->$primary] = $row->valor;       
            }
        }else{
            $return[0] = 'Sin Registros';
        }
            
        
        if($name == ''){
            $name = $primary;
        }
        
        $selected = set_value($name, $selected);
        
        if( $soloOpciones ){
            return $this->get_dropdown_options2($return, $selected);   
        }
        $extras = ($extras=='')? 'class="nostyle" style="display:inline-block; width:480px;"':$extras;
        
        return form_dropdown($name, $return, $selected, $extras);
    }
    
    function get_dropdown_options2( $options = array() , $selected = null)
    {
        if ( ! is_array($selected))
    {
      $selected = array($selected);
    }
        
        $form = "";
        
        foreach ($options as $key => $val)
    {
      $key = (string) $key;

      if (is_array($val) && ! empty($val))
      {
        $form .= '<optgroup label="'.$key.'">'."\n";

        foreach ($val as $optgroup_key => $optgroup_val)
        {
          $sel = (in_array($optgroup_key, $selected)) ? ' selected="selected"' : '';

          $form .= '<option value="'.$optgroup_key.'"'.$sel.'>'.(string) $optgroup_val."</option>\n";
        }

        $form .= '</optgroup>'."\n";
      }
      else
      {
        $sel = (in_array($key, $selected)) ? ' selected="selected"' : '';
        if(!($val == "Sin Registros")){
            $form .= '<option value="'.$key.'"'.$sel.'>'.(string) $val."</option>\n";
        }
      }
    }
        return $form;
    }


    /**
     * @author René Castaneda
     * @since 2017-05-23
     * @param array where
     * @return array asociativo de las habilidades
     */
    public function get_habilidades_emp($where=null)
    {
       $this->db->select()
              ->from('hxm_habilidadxempleado')
              ->join('hab_habilidad','hab_id=hxm_id_hab')
              ->join('nih_nivel_habilidad','nih_id=hxm_id_nih', 'left')
              ;
        if ($where) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

     public function get_habilidades_solicitante($where=null)
    {
       $this->db->select()
              ->from('hxs_habilidadxsolicitante')
              ->join('hab_habilidad','hab_id=hxs_id_hab')
              ->join('nih_nivel_habilidad','nih_id=hxs_id_nih', 'left')
              ;
        if ($where) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 2017-12-14
     * @param array where
     * @return array asociativo de los insumos
     */
    public function get_insumos($where=null)
    {
       $this->db->select()
              ->from('ixe_insumoxempleado')
              ->join('inm_insumo','ixe_id_inm = inm_id')
              ->join('tim_tipo_insumo','tim_id = inm_id_tim')
              ->order_by('ixe_id', 'DESC')
              ;
        if ($where) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

     public function get_insumos_soli($where=null)
    {
       $this->db->select()
              ->from('ise_isumo_solicitante_empleo')
              ->join('inm_insumo','ise_id_inm = inm_id')
              ->join('tim_tipo_insumo','tim_id = inm_id_tim')
              ->order_by('ise_id', 'DESC')
              ;
        if ($where) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 2017-12-14
     * @param array where
     * @return array asociativo de las capacitaciones
     */
    public function get_capacitaciones($where=null)
    {
       $this->db->select()
              ->from('cpe_capacitacion_empleado')
              ->join('emp_empleado', 'cpe_id_emp = emp_id', 'left')
              ->join('are_area', 'emp_id_are = are_id', 'left')
              ->join('icp_institucion_capacitacion', 'cpe_id_icp = icp_id', 'left')
              ->join('ese_estado_estudio', 'cpe_id_ese = ese_id', 'left')
              ->order_by('cpe_id', 'DESC')
            ;
        if ($where) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    public function get_capacitaciones_soli($where=null)
    {
       $this->db->select()
              ->from('ccs_capacitacion_solicitante')
              ->join('icp_institucion_capacitacion','ccs_id_icp = icp_id', 'left')
              ->join('ese_estado_estudio','ccs_id_ese = ese_id', 'left')
              ->order_by('ccs_id', 'DESC')
            ;
        if ($where) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since 2017-12-16
     * @param array where
     * @return array asociativo de los empleados
     */
    public function get_empleados_area_profesion($where=NULL) {

         $this->db->select('emp_empleado.*, emr_empresa.*, are_area.are_nombre, pro_nombre, gen_nombre,
                         padre.are_nombre as padre, plz_codigo, plz_nombre, pto_nombre, tic_nombre,suc_nombre, 
                         TIMESTAMPDIFF(YEAR,emp_fecha_nac,CURDATE()) AS edad')
              ->from('emp_empleado')
              ->join('emr_empresa','emr_id = emp_id_emr', 'left')
              ->join('plz_plaza','plz_id = emp_id_plz', 'left')
              ->join('are_area','are_id=emp_id_are', 'left')
              ->join('pro_profesion','pro_id=emp_id_pro', 'left')
              ->join('gen_genero', 'gen_id=emp_id_gen', 'left')
              ->join('pto_puesto',' pto_id = plz_id_pto', 'left')
              ->join('tic_tipo_contrato',' tic_id = emp_id_tic','left')
              ->join('suc_sucursal','suc_id = emp_id_suc', 'left')
              ->join('are_area AS padre','padre.are_id = are_area.are_padre','left')
             // ->where('emp_id_emr', $this->tank_auth->get_empresa_id())

        ;
        if (isset($where['emp_id_emr']) and $where['emp_id_emr'] != '' ) {
          if ($where['emp_id_emr'] == -1 ) unset($where['emp_id_emr']);
        } else {
          $where['emp_id_emr']  =  $this->tank_auth->get_empresa_id();
        }

        if ($where) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    /**
     * @author Luis Navarro 
     * @since 2017-12-19
     * @param array where
     * @return array asociativo por fuente de reclutamiento
     */
    function get_listado_empleados($where=null) {

        $this->db->select('emp_empleado.*, emr_empresa.*, are_area.are_nombre, padre.are_nombre as padre, plz_nombre, pto_nombre, tps_nombre, gen_nombre,
            suc_nombre, fnr_nombre, tic_nombre, TIMESTAMPDIFF(YEAR, emp_empleado.emp_fecha_nac, CURDATE()) AS edad, CONCAT(empleado_modifica.emp_nombre, " ", empleado_modifica.emp_apellido) AS nombre_empleado_modifica', false)
          ->from('emp_empleado')
          ->join('emr_empresa', 'emr_id = emp_empleado.emp_id_emr', 'left')
          ->join('plz_plaza', 'plz_id = emp_empleado.emp_id_plz','left')
          ->join('pto_puesto',' pto_id = plz_id_pto', 'left')
          ->join('are_area', 'are_id = emp_empleado.emp_id_are', 'left')
          ->join('are_area AS padre', 'padre.are_id = are_area.are_padre','left')
          ->join('gen_genero', 'gen_id = emp_empleado.emp_id_gen', 'left')
          ->join('suc_sucursal', 'suc_id = emp_empleado.emp_id_suc', 'left')
          ->join('fnr_fuente_reclutamiento', 'emp_empleado.emp_id_fnr=fnr_id', 'left')
          ->join('tps_tipo_salario', 'tps_id = emp_empleado.emp_id_tps','left')
          ->join('tic_tipo_contrato', 'tic_id = emp_empleado.emp_id_tic','left')
          ->join('cts_categoria_salarial', 'cts_id = pto_id_cts','left')
          ->join('emp_empleado AS empleado_modifica', 'empleado_modifica.emp_id_usu = emp_empleado.emp_usu_mod', 'left')
          //->where('emp_id_emr', $this->tank_auth->get_empresa_id())    
        ;
        
        if (isset($where['emp_empleado.emp_id_emr']) and is_numeric($where['emp_empleado.emp_id_emr']) ) {
          if ($where['emp_empleado.emp_id_emr'] == -1 ) unset($where['emp_empleado.emp_id_emr']);
        } else {
          $where['emp_empleado.emp_id_emr']  =  $this->tank_auth->get_empresa_id();
        }

        if($where!=null){
            $this->db->where($where);
        }
        //print_r($this->db->last_query());
        return $this->db->get()->result_array();
    }


    /**
     * @author René Castaneda
     * @since 2017-12-19
     * @param array where
     * @return array asociativo de las plazas de un empleado
     */
    public function get_plaza_salario_emp($where=null){         
               $this->db->join('plz_plaza', 'plz_id = pps_id_plz');
        return $this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp',$where);
    }

    /**
     * @author Elman Ortiz
     * @since 2017-12-18
     * @param array where
     * @return array asociativo de los empleados
     */
    public function get_empleadoxcodigo($emp_codigo, $where = null)
    {
      /*if($emp_codigo){
          $this->db->or_like('emp_codigo',$emp_codigo);
          $this->db->or_like('emp_nombre',$emp_codigo);
          $this->db->or_like('emp_apellido',$emp_codigo);          
      }*/

      $this->db->select()
            ->from('emp_empleado')            
            //->like('emp_codigo', $emp_codigo)
            ->where('emp_id_emr', $this->tank_auth->get_empresa_id())
            ->order_by('emp_id', 'DESC')
            ;
      if ($where) {
          $this->db->where($where);
      }

      return $this->db->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 2017-12-18
     * @param array where
     * @return array asociativo de los empleados
     */
    public function get_empleadoxid($where = null)
    {
      $this->db->select("emp_id, emp_nombre, emp_apellido, emp_telefono, DATE_FORMAT(emp_fecha_nac, '%d-%m-%Y') as emp_fecha_nac", false)
            ->from('emp_empleado')                        
            ->order_by('emp_id', 'DESC')
            ;
      if ($where) {
          $this->db->where($where);
      }

      return $this->db->get()->result_array();
    }
    
     /**
     * @author Luis Navarro
     * @since 2017-12-20
     * @param array where
     * @return array asociativo para tipo de experiencia por empleado
     */  
    public function get_tipo_experiencia_emp($where = null, $group_by = null) {

        $this->db->select('emp_empleado.*, are_area.are_nombre, padre.are_nombre as padre, dac_dato_academico.*, tie_nombre, exl_nombre, suc_nombre, pro_nombre, fam_familiar.*, pat_nombre, TIMESTAMPDIFF(YEAR, fam_fecha_nacimiento, CURDATE()) AS edad, emp_fecha_contrato, GROUP_CONCAT(DISTINCT hab_nombre) as habilidad, GROUP_CONCAT(DISTINCT peq_nombre) as programas')
        ->from('emp_empleado')
        ->join('dac_dato_academico','emp_id=dac_id_emp','left')
        ->join('tie_tipo_educacion','dac_id_tie=tie_id', 'left')
        ->join('exl_experiencia_laboral','exl_id=dac_id_exl', 'left')
        ->join('are_area','are_id=emp_id_are', 'left')
        ->join('are_area AS padre','padre.are_id = are_area.are_padre','left')
        ->join('suc_sucursal','suc_id = emp_id_suc','left')
        ->join('pro_profesion','dac_id_pro=pro_id','left')
        ->join('fam_familiar','emp_id=fam_id_emp','left')
        ->join('pat_parentesco','fam_id_pat=pat_id','left')
        ->join('hxm_habilidadxempleado','hxm_id_emp = emp_id','left')
        ->join('hab_habilidad','hxm_id_hab = hab_id','left')
        ->join('pxe_programaxempleado','pxe_id_emp = emp_id','left')
        ->join('peq_programa_equipo','pxe_id_peq = peq_id','left')
        ->where('emp_id_emr', $this->tank_auth->get_empresa_id())
        ;
        if($where!=null){
            $this->db->where($where);
        }
        if ($group_by != null) {
          $this->db->group_by($group_by);
        }
        
        return $this->db->get()->result_array();
    }

    /**
     * @author René Castaneda
     * @since 2017-12-20
     * @param array where
     * @return array asociativo de los insumos
     */
    public function get_insumo($where=null){         
        $this->db->join('tim_tipo_insumo', 'tim_id = inm_id_tim');
        return $this->gsatelite->get_tabla('inm_insumo',$where);
    }
    
    /**
     * @author Francisco Orozco
     * @since 2017-12-18
     * @param array where
     * @return array retiro de los empleados
    */
    public function get_retiro_empleados($where=NULL) {
        $this->db->select('emp_empleado.*, rte_retiro_empleado.*, are_area.are_nombre, gen_nombre,
                            padre.are_nombre as padre, tic_nombre, (SELECT emr_nombre FROM emr_empresa WHERE emr_id = emp_id_emr) AS emr_nombre,
                            TIMESTAMPDIFF(YEAR,`emp_fecha_nac`,CURDATE()) AS edad')
                ->from('rte_retiro_empleado')
                ->join('emp_empleado','emp_id = rte_id_emp')
                ->join('plz_plaza','plz_id = emp_id_plz','left')
                ->join('are_area','are_id=emp_id_are','left')
                ->join('gen_genero', 'gen_id=emp_id_gen')
                ->join('tic_tipo_contrato',' tic_id = emp_id_tic','left')
                ->join('are_area AS padre','padre.are_id = are_area.are_padre','left')
                //->where('emp_id_emr', $this->tank_auth->get_empresa_id())
        ;

        if (isset($where['emp_id_emr']) and is_numeric($where['emp_id_emr']) ) {
          if ($where['emp_id_emr'] == -1 ) unset($where['emp_id_emr']);
        } else {
          $where['emp_id_emr']  =  $this->tank_auth->get_empresa_id();
        }


        if ($where) {
            $this->db->where($where);
        }
        $this->db->order_by('emp_id,rte_fecha_retiro','asc');

        return $this->db->get()->result_array();
    }
    
    /**
     * @author Luis navarro
     * @since 2017-12-21
     * @param array where
     * @return array de empleados por zona de residencia
    */
    public function get_emp_zona_residencia($where=NULL) {

        $this->db->select()
            ->from('emp_empleado')
            ->join('emr_empresa', 'emp_id_emr=emr_id', 'left')
            ->join('mun_municipio', 'emp_id_mun=mun_id', 'left')
            ->join('dep_departamento', 'mun_id_dep=dep_id', 'left')
            ->join('zon_zona', 'emp_id_zon=zon_id', 'left')
            //->where('emp_id_emr', $this->tank_auth->get_empresa_id())                  
            // ->order_by('emp_id', 'DESC')
            ;

        if (isset($where['emp_id_emr']) and is_numeric($where['emp_id_emr']) ) {
          if ($where['emp_id_emr'] == -1 ) unset($where['emp_id_emr']);
        } else {
          $where['emp_id_emr']  =  $this->tank_auth->get_empresa_id();
        }

        if ($where != NULL) {
            $this->db->where($where);
        }

      return $this->db->get()->result_array();

    }

    /**
     * @author Elman Ortiz  
     * @since 2017-12-21
     * @param array where
     * @return array empleados por tipo de vivienda
    */
    public function get_empleados_tipo_construccion($where = null) {
        $this->db->select()
                ->from('emp_empleado')
                ->join('mun_municipio','emp_id_mun = mun_id', 'left')
                ->join('dep_departamento','dep_id = mun_id_dep', 'left')
                ->join('tcv_tipo_construccion_vivienda','emp_id_tcv = tcv_id', 'left')
                ->where('emp_id_emr', $this->tank_auth->get_empresa_id())                
        ;

        if ($where) {
            $this->db->where($where);
        }
        $this->db->order_by('emp_codigo ASC');

        return $this->db->get()->result_array();
    }

    /**
     * @author Luis Navarro 
     * @since 2017-12-26
     * @param array where
     * @return array asociativo de ingresos
    */
    public function get_ingresos_emp($where = null, $selected = '*') {

        $this->db->select($selected, false)
  
                ->from('ddi_detalle_ingreso')
                ->join('pla_planilla','pla_id = ddi_id_pla')
                ->join('emp_empleado','emp_id = ddi_id_emp')
                ->join('emr_empresa','emr_id = emp_id_emr')
                ->join('are_area','are_id = emp_id_are')
                ->join('tic_tipo_contrato','tic_id=emp_id_tic')
                ->join('plz_plaza','plz_id=emp_id_plz')
                //->where('emp_id_emr', $this->tank_auth->get_empresa_id())
        ;

        if (isset($where['emp_id_emr']) and $where['emp_id_emr'] != '' ) {
          if ($where['emp_id_emr'] == -1 ) unset($where['emp_id_emr']);
        } else {
          $where['emp_id_emr']  =  $this->tank_auth->get_empresa_id();
        }

        if ($where != null) {
            $this->db->where($where, NULL, false);
        }
        // $this->db->order_by('emp_id','desc');
        $this->db->group_by("ddi_id_emp");

        return $this->db->get()->result_array();
    }

    /**
     * @author Luis Navarro 
     * @since 2017-12-26
     * @param array where
     * @return array asociativo de descuentos
    */
    public function get_descuentos_emp($where = null, $selected = '*') {

        $this->db->select($selected, false)
                ->from('ddd_detalle_descuento')
                ->join('emp_empleado', 'emp_id = ddd_id_emp')
                ->join('pla_planilla','pla_id = ddd_id_pla')
               // ->where('emp_id_emr',$this->tank_auth->get_empresa_id())
        ;

        if (isset($where['emp_id_emr']) and $where['emp_id_emr'] != '' ) {
          if ($where['emp_id_emr'] == -1 ) unset($where['emp_id_emr']);
        } else {
          $where['emp_id_emr']  =  $this->tank_auth->get_empresa_id();
        }
        

        if ($where != null) {
            $this->db->where($where, NULL, false);
        }
        // $this->db->order_by('emp_id','desc');
        $this->db->group_by("ddd_id_emp");

        return $this->db->get()->result_array();
    }

    /**
     * @author Elman Ortiz  
     * @since 2017-12-21
     * @param array where
     * @return array promociones y niveles para presentar en la vista
    */
    public function reporte_promociones_niveles($where = null) {        
        $this->db->select(" emp_id,
                            pps1.pps_id, 
                            emp_codigo,
                            CASE
                            WHEN pps1.pps_tipo = 0 THEN
                              'Ingreso'
                            WHEN pps1.pps_tipo = 1 THEN
                              'Promoción Interna'
                            WHEN pps1.pps_tipo = 2 THEN
                              'Nivelación Salarial'
                            ELSE
                              'Traslado de Área o Departamento'
                            END AS tipo_promocion,  
                            emp_nombre,
                            emp_apellido,
                            emr_nombre,
                            pps1.pps_fecha_efectiva,
                            pps1.pps_fecha_desde,
                            pps1.pps_fecha_hasta,
                            plz_id,
                            plz_nombre,
                            pps1.pps_salario,
                            pps1.pps_estado,
                            are_nombre,
                            (SELECT a2.are_nombre FROM pps_promocion_plaza_salarioxemp p2 LEFT JOIN are_area a2 on a2.are_id = p2.pps_id_are
                                WHERE p2.pps_id_emp = pps1.pps_id_emp AND p2.pps_id < pps1.pps_id ORDER BY p2.pps_id DESC LIMIT 1 
                            ) AS area_anterior,
                            (
                            SELECT CONCAT_WS('##',pps2.pps_salario, plz2.plz_nombre) from pps_promocion_plaza_salarioxemp pps2 
                            LEFT JOIN plz_plaza plz2 on plz2.plz_id = pps2.pps_id_plz
                            WHERE pps2.pps_id_emp = pps1.pps_id_emp
                            and pps2.pps_id < pps1.pps_id ORDER BY pps2.pps_id DESC LIMIT 1
                             ) datos_anteriores
                            ", false)
                  ->from('pps_promocion_plaza_salarioxemp pps1')
                  ->join('emp_empleado','emp_id = pps_id_emp')
                  ->join('emr_empresa','emr_id = emp_id_emr')
                  ->join('plz_plaza','plz_id = pps_id_plz')
                  ->join('are_area','are_id = pps_id_are')
                  ->order_by('emp_id', 'ASC')
                  ->order_by('pps_id', 'DESC')
        ;
        if (isset($where['emp_id_emr']) and is_numeric($where['emp_id_emr'])) {
            if ($where['emp_id_emr'] == -1 ) unset($where['emp_id_emr']);
        } else {
            $where['emp_id_emr']  =  $this->tank_auth->get_empresa_id();
        }
        if ($where) {
            $this->db->where($where);
        }        

        return $this->db->get()->result_array();
    }

    /**
     * @author Luis Navarro 
     * @since 2018-04-12
     * @param array where
     * @return array asociativo de empleados con sus ingresos y descuentos
    */
    public function get_empleado_tipo_contrato($where = null, $groupby = null, $orderby = null) {
        $agrupador = $this->gsatelite->get_parametro('SYS_ID_AGRUPADOR_PROMEDIO_SALARIO');
        $agrupador = (isset($agrupador) && is_numeric($agrupador))?$agrupador:null;
         $this->db->select("
                emp_id,
                emp_codigo,
                CONCAT(emp_nombre, ' ', emp_apellido) AS empleado,
                emp_fecha_nac,
                emp_fecha_contrato,
                emp_fecha_fin_contrato,
                emr_nombre,
                are_nombre,
                tic_nombre,
                plz_nombre,
                plz_salario_base,
                IF(emp_salario>0,emp_salario, 0) as salario_base,
                (
                    SELECT IFNULL(SUM(ddi_valor),0) FROM ddi_detalle_ingreso
                    JOIN pla_planilla ON pla_id = ddi_id_pla
                    WHERE ddi_id_emp = emp_id AND ddi_id_tig in ( SELECT deg_id_tig from deg_detalle_agrupador where deg_id_tag = $agrupador AND deg_id_tig is not null )
                ) AS ingresos,
                (
                    SELECT IFNULL(SUM(ddd_valor),0) FROM ddd_detalle_descuento
                    JOIN pla_planilla ON pla_id = ddd_id_pla
                    WHERE ddd_id_emp = emp_id AND pla_estado = 3 AND ddd_id_tdc in ( SELECT deg_id_tdc from deg_detalle_agrupador where deg_id_tag = $agrupador AND deg_id_tdc is not null )
                )   AS descuentos,
                (
                    SELECT COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio, '%Y-%m' )) FROM ddi_detalle_ingreso
                    JOIN pla_planilla ON pla_id = ddi_id_pla
                    WHERE ddi_id_emp = emp_id  AND pla_estado = 3 AND ddi_id_tig in ( SELECT deg_id_tig from deg_detalle_agrupador where deg_id_tag = $agrupador AND deg_id_tig is not null )
                ) AS meses
                ", false)
                ->from('emp_empleado')
                ->join('emr_empresa', 'emp_id_emr = emr_id')
                ->join('are_area','emp_id_are = are_id')
                ->join('tic_tipo_contrato','emp_id_tic = tic_id')
                ->join('plz_plaza','emp_id_plz = plz_id')
        ;
        if (isset($where['emp_id_emr']) and $where['emp_id_emr'] != '' ) {
            if ($where['emp_id_emr'] == -1 ) unset($where['emp_id_emr']);
        } else {
            $where['emp_id_emr']  =  $this->tank_auth->get_empresa_id();
        }        
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $this->db->get()->result_array();
    }

    /**
    * @author René Castaneda
    * @since 2018-05-18
    * @return duplicar la información de una tabla en especifico para un empleado
     */
    public function duplicar_info_emp($tabla_origen,$id_emp_origen, $id_emp_destino)
    {
      $fecha_actual = date('Y-m-d H:i:s');
      $id_usuario = $this->tank_auth->get_user_id();

       if (in_array('sxe_seguroxempleado',$tabla_origen)) 
       {
          $this->db->query("INSERT INTO sxe_seguroxempleado (sxe_id_seg, sxe_id_emp, sxe_estado, sxe_fecha_mod, sxe_usu_mod)
          SELECT sxe_id_seg, $id_emp_destino emp, 1 estado, '$fecha_actual' fmod, '$id_usuario' usumod
          FROM sxe_seguroxempleado  WHERE sxe_id_emp=$id_emp_origen AND sxe_estado = 1");
       }
       if (in_array('cxp_correoxempleado',$tabla_origen)) 
       {
          $this->db->query("INSERT INTO cxp_correoxempleado (cxp_id_emp, cxp_correo, cxp_estado, cxp_usu_mod, cxp_fecha_mod)
            SELECT $id_emp_destino emp, cxp_correo, 1 estado, $id_usuario usu , '$fecha_actual' fmod 
            FROM cxp_correoxempleado 
            WHERE cxp_id_emp = $id_emp_origen AND cxp_estado = 1");
       }
       if (in_array('exe_enfermedadxempleado',$tabla_origen)) 
       {
          $this->db->query("INSERT INTO exe_enfermedadxempleado (exe_id_enf, exe_id_emp, exe_estado, 
            exe_usu_creacion,exe_fecha_creacion,exe_usu_modificacion,exe_fecha_modificacion)
            SELECT exe_id_enf, $id_emp_destino emp, 1 estado, $id_usuario usucrea, '$fecha_actual' fcrea, $id_usuario usumod, '$fecha_actual' fmod 
            from exe_enfermedadxempleado
            where exe_id_emp = $id_emp_origen AND exe_estado = 1");
       }
       if (in_array('cae_componente_alergico_empleado',$tabla_origen))
       {
          $this->db->query("INSERT INTO cae_componente_alergico_empleado (cae_id_coa, cae_id_emp, cae_estado, 
                        cae_usu_creacion,cae_fecha_creacion,cae_usu_modificacion,cae_fecha_modificacion)
                        SELECT cae_id_coa,  $id_emp_destino emp, 1 estado, $id_usuario usucrea, '$fecha_actual' fcrea, $id_usuario usumod, '$fecha_actual' fmod 
                        from cae_componente_alergico_empleado
                        WHERE cae_id_emp = $id_emp_origen AND cae_estado = 1");
       }
       if (in_array('dce_documento_emp',$tabla_origen)) 
       {
          $this->db->query("INSERT INTO dce_documento_emp (dce_id_tde, dce_id_emp, dce_valor, dce_fecha_registro,
                            dce_fecha_vence, dce_fecha_expedicion,
                            dce_lugar_expedicion, dce_url, dce_nombre_anexo, dce_nombre_segun_doc, dce_observacion,
                            dce_estado, dce_usu_creacion, dce_fecha_creacion, dce_usu_modificacion, dce_fecha_modificacion)
                            SELECT dce_id_tde, '$id_emp_destino' emp, dce_valor, dce_fecha_registro,
                            dce_fecha_vence, dce_fecha_expedicion,
                            dce_lugar_expedicion, dce_url, dce_nombre_anexo, dce_nombre_segun_doc, dce_observacion,
                            1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                             FROM dce_documento_emp WHERE dce_id_emp = $id_emp_origen AND dce_estado = 1");
       }
       if (in_array('pxe_programaxempleado',$tabla_origen)) 
       {
          $this->db->query("INSERT INTO pxe_programaxempleado(pxe_id_peq, pxe_id_emp, pxe_id_nie,
                        pxe_estado, pxe_usu_creacion, pxe_fecha_creacion, pxe_usu_modificacion, pxe_fecha_modificacion)
                        SELECT pxe_id_peq, '$id_emp_destino' emp, pxe_id_nie,
                        1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                         FROM pxe_programaxempleado
                         WHERE pxe_id_emp = $id_emp_origen AND pxe_estado = 1");
       }

       if (in_array('cep_certificacion_programa',$tabla_origen)) 
       {
          $this->db->query("INSERT INTO cep_certificacion_programa (cep_id_emp, cep_id_cer, cep_id_peq, cep_id_icp,cep_id_mde, cep_puntaje, cep_fecha_certificacion,
                      cep_estado, cep_usu_creacion, cep_fecha_creacion, cep_usu_modificacion, cep_fecha_modificacion)
                      SELECT '$id_emp_destino' emp, cep_id_cer, cep_id_peq, cep_id_icp,cep_id_mde, cep_puntaje, cep_fecha_certificacion,
                      1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                        FROM cep_certificacion_programa
                       WHERE cep_id_emp = $id_emp_origen AND cep_estado = 1");
        }

        if (in_array('fam_familiar',$tabla_origen)) 
        {
           $this->db->query("INSERT INTO fam_familiar(fam_nombre, fam_apellido, fam_id_pat, fam_telefono, fam_id_emp,
                            fam_id_emp_familiar, fam_dependiente, fam_empresa, fam_fecha_nacimiento, fam_reside_empleado,
                            fam_beneficiario, fam_porcentaje_beneficio,
                            fam_estado, fam_usu_crea, fam_fecha_crea, fam_usu_mod, fam_fecha_mod
                            )
                            SELECT fam_nombre, fam_apellido, fam_id_pat, fam_telefono, '$id_emp_destino' emp,
                            fam_id_emp_familiar, fam_dependiente, fam_empresa, fam_fecha_nacimiento, fam_reside_empleado,
                            fam_beneficiario, fam_porcentaje_beneficio,
                            1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                             FROM fam_familiar
                             WHERE fam_id_emp = $id_emp_origen AND fam_estado = 1");
          }
          if (in_array('iem_idioma_empleado',$tabla_origen)) 
          {
             $this->db->query("INSERT INTO iem_idioma_empleado (iem_id_nii, iem_id_idm, iem_id_emp, iem_leer, iem_escribir, iem_hablar,iem_traductor,
                          iem_estado, iem_usu_creacion, iem_fecha_creacion, iem_usu_modificacion, iem_fecha_modificacion)
                          SELECT iem_id_nii, iem_id_idm, '$id_emp_destino' emp, iem_leer, iem_escribir, iem_hablar,iem_traductor,
                          1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                          FROM iem_idioma_empleado
                           WHERE iem_id_emp = $id_emp_origen AND iem_estado = 1");
           }

           if (in_array('cri_certificacion_idioma',$tabla_origen)) 
           {
              $this->db->query("INSERT INTO cri_certificacion_idioma(cri_id_emp, cri_id_cer, cri_id_idm, cri_puntaje, cri_fecha_certificacion,
                      cri_estado, cri_usu_creacion, cri_fecha_creacion, cri_usu_modificacion, cri_fecha_modificacion)
                      SELECT '$id_emp_destino' emp, cri_id_cer, cri_id_idm, cri_puntaje, cri_fecha_certificacion,
                      1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                      FROM cri_certificacion_idioma
                       WHERE cri_id_emp = $id_emp_origen AND cri_estado = 1");
            }

            if (in_array('rfp_referencia_personal',$tabla_origen)) 
           {
              $this->db->query("INSERT INTO rfp_referencia_personal(
                      rfp_id_trr, rfp_id_emp, rfp_nombre, rfp_lugar_trabajo, rfp_ocupacion, rfp_telefono, rfp_descripcion_referencia,
                      rfp_estado, rfp_usu_creacion, rfp_fecha_creacion, rfp_usu_modificacion, rfp_fecha_modificacion
                      )
                      SELECT rfp_id_trr, '$id_emp_destino' emp, rfp_nombre, rfp_lugar_trabajo, rfp_ocupacion, rfp_telefono, rfp_descripcion_referencia,
                      1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                      FROM rfp_referencia_personal
                       WHERE rfp_id_emp = $id_emp_origen AND rfp_estado = 1");
            }

            if (in_array('rfl_referencia_laboral',$tabla_origen)) 
           {
              $this->db->query("INSERT INTO rfl_referencia_laboral (
                        rfl_id_emp, rfl_lugar_trabajo, rfl_direccion, rfl_telefono, rfl_puesto, rfl_jefe, rfl_salario_devengado,
                        rfl_motivo_retiro, rfl_nombre_ref, rfl_fecha_desde, rfl_fecha_hasta, rfl_referencia,
                        rfl_estado, rfl_usu_creacion, rfl_fecha_creacion, rfl_usu_modificacion, rfl_fecha_modificacion
                        )
                        SELECT '$id_emp_destino' emp, rfl_lugar_trabajo, rfl_direccion, rfl_telefono, rfl_puesto, rfl_jefe, rfl_salario_devengado,
                        rfl_motivo_retiro, rfl_nombre_ref, rfl_fecha_desde, rfl_fecha_hasta, rfl_referencia,
                        1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                        FROM rfl_referencia_laboral
                         WHERE rfl_id_emp = $id_emp_origen AND rfl_estado = 1");
            }
             if (in_array('dac_dato_academico',$tabla_origen)) 
            {
               $this->db->query("INSERT INTO dac_dato_academico (
                        dac_id_pai, dac_id_tie, dac_id_pro, dac_id_ese, dac_id_emp, dac_id_exl, 
                        dac_id_ina, dac_fecha_finalizacion, dac_observacion, dac_anios_cursado,
                        dac_estado, dac_usu_creacion, dac_fecha_creacion, dac_usu_modificacion, dac_fecha_modificacion
                        )
                        SELECT dac_id_pai, dac_id_tie, dac_id_pro, dac_id_ese, '$id_emp_destino' emp, dac_id_exl, 
                        dac_id_ina, dac_fecha_finalizacion, dac_observacion, dac_anios_cursado,
                        1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                        FROM dac_dato_academico
                         WHERE dac_id_emp = $id_emp_origen AND dac_estado = 1");
             }

              if (in_array('hxm_habilidadxempleado',$tabla_origen)) 
             {
                $this->db->query("INSERT INTO hxm_habilidadxempleado( hxm_id_hab, hxm_id_emp, hxm_id_nih,
                          hxm_estado, hxm_usu_creacion, hxm_fecha_creacion, hxm_usu_modificacion, hxm_fecha_modificacion)
                          SELECT hxm_id_hab, '$id_emp_destino' emp, hxm_id_nih,
                          1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                          FROM hxm_habilidadxempleado
                           WHERE hxm_id_emp = $id_emp_origen AND hxm_estado = 1");
              }
               if (in_array('age_agrupacion_empleado',$tabla_origen)) 
              {
                 $this->db->query("INSERT INTO age_agrupacion_empleado (age_id_emp, age_nombre, age_anio_afiliacion, age_estado_agrupacion,
                              age_estado, age_usu_creacion, age_fecha_creacion, age_usu_modificacion, age_fecha_modificacion)
                              SELECT '$id_emp_destino' emp, age_nombre, age_anio_afiliacion, age_estado_agrupacion,
                              1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                              FROM age_agrupacion_empleado
                               WHERE age_id_emp = $id_emp_origen AND age_estado = 1");
               }
                if (in_array('sre_servicio_empleado',$tabla_origen)) 
               {
                  $this->db->query("INSERT INTO sre_servicio_empleado(sre_id_srb, sre_id_emp,
                                sre_estado, sre_usu_creacion, sre_fecha_creacion, sre_usu_modificacion, sre_fecha_modificacion)
                                SELECT sre_id_srb, '$id_emp_destino' emp,
                                1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                                FROM sre_servicio_empleado
                                 WHERE sre_id_emp = $id_emp_origen AND sre_estado = 1");
                }

                 if (in_array('ixe_insumoxempleado',$tabla_origen)) 
                {
                   $this->db->query("INSERT INTO ixe_insumoxempleado (ixe_id_inm, ixe_id_emp, ixe_cantidad, ixe_costo, ixe_fecha_entrega,
                                  ixe_estado, ixe_usu_creacion, ixe_fecha_creacion, ixe_usu_modificacion, ixe_fecha_modificacion)
                                  SELECT ixe_id_inm, '$id_emp_destino' emp, ixe_cantidad, ixe_costo, ixe_fecha_entrega,
                                 1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                                FROM ixe_insumoxempleado
                                 WHERE ixe_id_emp = $id_emp_origen AND ixe_estado = 1");
                 }

                  if (in_array('cpe_capacitacion_empleado',$tabla_origen)) 
                {
                   $this->db->query("INSERT INTO cpe_capacitacion_empleado (
                              cpe_id_emp, cpe_id_ese, cpe_id_icp, cpe_nombre,cpe_duracion, cpe_costo_empresa, cpe_costo_insaforp,
                              cpe_costo_proveedor, cpe_fecha_inicio, cpe_fecha_fin,
                              cpe_estado, cpe_usu_creacion, cpe_fecha_creacion, cpe_usu_modificacion, cpe_fecha_modificacion)
                              SELECT  '$id_emp_destino' emp, cpe_id_ese, cpe_id_icp, cpe_nombre,cpe_duracion, cpe_costo_empresa, cpe_costo_insaforp,
                              cpe_costo_proveedor, cpe_fecha_inicio, cpe_fecha_fin,
                               1 estado, '$id_usuario' usucrea, '$fecha_actual' fcrea, '$id_usuario' usumod, '$fecha_actual' fmod
                              FROM cpe_capacitacion_empleado
                               WHERE cpe_id_emp = $id_emp_origen AND cpe_estado = 1");
                 }

                   if (in_array('axe_anexoxempleado',$tabla_origen)) 
                {
                   $this->db->query("INSERT INTO axe_anexoxempleado( axe_id_anx, axe_id_emp, axe_estado, axe_usu_mod, axe_fecha_mod)
                                SELECT axe_id_anx, '$id_emp_destino' emp, 1 estado, '$id_usuario' usumod, '$fecha_actual' fmod
                                from axe_anexoxempleado
                                 WHERE axe_id_emp = $id_emp_origen AND axe_estado = 1");
                 }



    }

    /**
     * @author Rafael A. Cuchilla  
     * @since 2018-07-06
     * @param array where
     * @return array Beneficios por puesto
    */
    public function get_beneficios_puesto($where = null) {
        $this->db->select("emp_codigo, CONCAT_WS( ' ', emp_nombre, emp_apellido ) AS nombre, plz_nombre, emr_nombre, pto_nombre, GROUP_CONCAT(bfp_nombre) AS benf", false)
            ->from('pto_puesto')
            ->join('bxp_beneficioxpuesto','bxp_id_pto = pto_id')
            ->join('bfp_beneficio_puesto','bfp_id = bxp_id_bfp')
            ->join('plz_plaza','plz_id_pto = pto_id')
            ->join('emp_empleado','emp_id_plz = plz_id')
            ->join('emr_empresa','emr_id = emp_id_emr')
            ->group_by('emp_id')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }  
    /**
     * Descripción:
     * @author Manuel Anzora - Grupo Satélite
     * @since  2018-12-07
     * @param  $where: condition para filtrar el empleado
     * @return retorna informacion de empleado para generar finiquito
     **/
    public function get_empleado_retirado($where,$group_by){
        $dui_id = $this->gsatelite->get_parametro("ID_TIPO_DOCUMENTO_DUI");
      $this->db->select('emp_id, CONCAT(emp_nombre, " ", emp_apellido) as fullname, pro_nombre, emp_direccion, dce_valor, mun_nombre, dep_nombre, pai_nombre, 
                        emp_fecha_nac, pto_nombre, plz_nombre, emp_fecha_contrato', false)
        ->from('emp_empleado')
        ->join('pro_profesion', 'pro_id = emp_id_pro', 'left')
        ->join('plz_plaza', 'plz_id = emp_id_plz', 'left')
        ->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
        ->join('dce_documento_emp', 'dce_id_emp = emp_id AND dce_id_tde = '.$dui_id, 'left')
        ->join('suc_sucursal', 'suc_id = emp_id_suc', 'left')
        ->join('mun_municipio', 'mun_id = emp_id_mun', 'left')
        ->join('dep_departamento', 'mun_id_dep = dep_id', 'left')
        ->join('pai_pais', 'dep_id_pai = pai_id', 'left')
        ->where($where);
        if($group_by!=null){
          $this->db->group_by($group_by);
        }
        
        return $this->db->get()->result_array();
    }
    /**
     * Descripción:
     * @author Manuel Anzora - Grupo Satélite
     * @since  2018-12-17
     * @param  $where: condition para filtrar el empleado
     * @return retorna informacion de empleado 
     **/
    public function get_empleado_like($where,$like){
        $this->db->select('emp_id, emp_codigo, CONCAT(emp_nombre, " ", emp_apellido) AS fullname, IF(emp_estado > 0,"","(Inactivo)") AS estado', false)
            ->from('emp_empleado')
            ->where('(emp_nombre like "%'.$like.'%" OR emp_apellido like "%'.$like.'%")')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();

    }
    /**
     * Descripción:
     * @author Manuel Anzora - Grupo Satélite
     * @since  2018-12-17
     * @param  $where: condition para filtrar empleado por sucursal
     * @return retorna informacion de empleado para generar finiquito
     **/
    public function get_empleado_activo($where,$group_by){
      $dui_id = $this->gsatelite->get_parametro("ID_TIPO_DOCUMENTO_DUI");
      $this->db->select('emp_id, CONCAT(emp_nombre, " ", emp_apellido) as fullname, pro_nombre, emp_direccion, dce_valor, mun_nombre, dep_nombre, pai_nombre', false)
        ->from('emp_empleado')
        ->join('pro_profesion', 'pro_id = emp_id_pro', 'left')
        ->join('dce_documento_emp', 'dce_id_emp = emp_id AND dce_id_tde = ' . $dui_id, 'left')
        ->join('suc_sucursal', 'suc_id = emp_id_suc', 'left')
        ->join('mun_municipio', 'mun_id = emp_id_mun', 'left')
        ->join('dep_departamento', 'mun_id_dep = dep_id', 'left')
        ->join('pai_pais', 'dep_id_pai = pai_id', 'left')
        ->where($where);
        if($group_by!=null){
          $this->db->group_by($group_by);
        }
        
        return $this->db->get()->result_array();
    }


    /**
    * @author Raul Escalante
    * @return Obtiene los datos para las constancias personalizadas
    */
    function get_datos_tipo_constancia($id){
        $tipo = $this->db->select("tpo_id, fre_id, tpo_nombre, fre_configuraciones_formato,
            (SELECT GROUP_CONCAT(vao_nombre ORDER BY vao_nombre) FROM vxt_variablextipo_constancia JOIN vao_variable_constancia ON vao_id = vxt_id_vao WHERE vxt_id_tpo = tpo_id) AS variables_constancia
            ", false)
                ->from('tpo_tipo_constancia')
                ->join('fre_formato_constancia_empleado', 'fre_id_tpo = tpo_id')
                ->where('tpo_id', $id)
        ;
        return $tipo->get()->result_array();
    }
    

    /**
     * 
     * @author Nelson Soriano
     * @since  14-05-2019
     * @param  id del area a consultar
     * @return retorna el total de coincidencia de genero por area
    **/
    public function detalles_reporte_genero($where = null, $groupby = null){
      $this->db->select('IFNULL(are_id, 0) AS are_id, gen_id, gen_nombre AS nombre, COUNT(emp_id_gen) AS total, IFNULL(are_nombre,"Sin área asignada") as area, 
              CONCAT(IFNULL(are_id,0), "_", gen_id) AS llave',false)
            ->from('emp_empleado')
            ->join('gen_genero','gen_id = emp_id_gen','LEFT')
            ->join('are_area' ,' are_id = emp_id_are','LEFT')
            ->where('!ISNULL(emp_id_gen)')// AND !ISNULL(emp_id_are)
            ->where('emp_estado > 0')
            ->order_by('are_id, gen_id');
            if ($where !== null) {
              $this->db->where($where);
            }

            if ($groupby !== null) {
              $this->db->group_by($groupby);
            }

          return $this->db->get()->result_array();
    }

    /**
     * @author Herberth Lucho
     * @since  10-09-2019
     * @param  id del empleado por planilla asignada
     * @return retorna el empleado por planilla asignada
    **/
    public function get_reporte_detalle_contratacion($where = null){
        $this->db->select('emp_codigo, emp_nombre, emp_apellido, are_nombre, plz_codigo, plz_nombre, emp_estado, emp_fecha_contrato, emp_fecha_antiguedad, emp_fecha_retiro,
            tic_nombre, emp_salario, emp_fecha_fin_contrato, (SELECT GROUP_CONCAT(DISTINCT tpl_nombre SEPARATOR ", ") FROM txe_tipo_planillaxempleado 
            JOIN tpl_tipo_planilla ON txe_id_tpl = tpl_id WHERE txe_id_emp = emp_id) AS tpl_nombre', false)
        ->from('emp_empleado')
        ->join('tic_tipo_contrato' ,'tic_id = emp_id_tic', 'LEFT')
        ->join('plz_plaza' ,'plz_id = emp_id_plz', 'LEFT')
        ->join('are_area' ,'are_id = emp_id_are', 'LEFT')
      ;
      if ($where != null) {
        $this->db->where($where);
      }
      return $this->db->get()->result_array();
    }

    function get_enfermedades_empleados($where = null) {
        $this->db->select("emp_codigo, UPPER(CONCAT_WS(' ', emp_nombre, emp_apellido)) AS empleado, are_nombre, pro_nombre, emp_telefono, emp_email, mun_nombre, dep_nombre, plz_nombre,
            GROUP_CONCAT(enf_nombre ORDER BY enf_nombre ASC SEPARATOR ', ') AS enfermedades", false)
        ->from('exe_enfermedadxempleado')
        ->join('emp_empleado', 'emp_id = exe_id_emp')
        ->join('enf_enfermedad', 'enf_id = exe_id_enf')
        ->join('are_area', 'are_id = emp_id_are', 'LEFT')
        ->join('plz_plaza', 'plz_id = emp_id_plz', 'LEFT')
        ->join('pro_profesion', 'pro_id = emp_id_pro', 'LEFT')
        ->join('mun_municipio', 'mun_id = emp_id_mun', 'LEFT')
        ->join('dep_departamento', 'dep_id = mun_id_dep', 'LEFT')
        ->group_by('emp_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    function get_medicamentos_empleados($where = null) {

      $this->db->select("emp_codigo, UPPER(CONCAT_WS(' ', emp_nombre, emp_apellido)) as empleado, are_nombre, 
            pro_nombre, emp_telefono, emp_email, mun_nombre, dep_nombre, plz_nombre,
            GROUP_CONCAT(mxe_nombre_medicamento SEPARATOR ',') as medicamentos", false)
        ->from('emp_empleado')
        ->join('are_area', 'are_id = emp_id_are', 'LEFT')
        ->join('plz_plaza', 'plz_id = emp_id_plz', 'LEFT')
        ->join('pro_profesion', 'pro_id = emp_id_pro', 'LEFT')
        ->join('mun_municipio', 'mun_id = emp_id_mun', 'LEFT')
        ->join('dep_departamento', 'dep_id = mun_id_dep', 'LEFT')
        ->join('mxe_medicamento_x_empleado', 'mxe_id_emp = emp_id and mxe_estado = 1')
      ;

      if ($where != null) {
        $this->db->where($where);
      }

      $this->db->group_by('emp_id');

      return $this->db->get()->result_array();

    }

    function get_profesiones_like($where = null, $like = null) {
      $query = $this->db->select()->from('pro_profesion');

      if ($where != null) {
        $this->db->where($where);
      }

      if ($like != null) {
        $this->db->or_like($like);
      }
      $this->db->group_by('pro_id');

      return $query->get()->result_array();
    }

    function get_areas_like($where = null, $like = null) {
      $query = $this->db->select()->from('are_area');

      if ($where != null) {
        $this->db->where($where);
      }

      if ($like != null) {
        $this->db->or_like($like);
      }
      $this->db->group_by('are_id');

      return $query->get()->result_array();
    }

    function get_empleados_like($where = null, $like = null) {
      $query = $this->db->select()->from('emp_empleado');

      if ($where != null) {
        $this->db->where($where);
      }

      if ($like != null) {
        $this->db->or_like($like);
      }
      $this->db->group_by('emp_id');

      return $query->get()->result_array();
    }

    public function get_rpt_enfermedades_personal_estadistico($where = null) {
        $this->db->select('IFNULL(are_nombre, "No Disponible") are_nombre, enf_nombre, COUNT(emp_id) AS cantidad_personas', false)
        ->from('exe_enfermedadxempleado')
        ->join('emp_empleado', 'emp_id = exe_id_emp')
        ->join('enf_enfermedad', 'enf_id = exe_id_enf')
            ->join('are_area', 'are_id = emp_id_are', 'LEFT')
        ->join('mun_municipio', 'mun_id = emp_id_mun', 'LEFT')
      ;
        if ($where) {
        $this->db->where($where);
      }
        $this->db->group_by('enf_id, are_id');
      return $this->db->get()->result_array();
    }

    public function get_rpt_profesiones_num_licencia($where = null) {
        $this->db->select("pro_nombre, UPPER(CONCAT_WS(' ', emp_nombre, emp_apellido)) AS nombre_empleado, emp_licencia_profesional, emp_codigo,
            IF(emp_fecha_contrato IS NOT NULL, DATE_FORMAT(emp_fecha_contrato, '%d-%m-%Y'), DATE_FORMAT(DATE(emp_fecha_antiguedad), '%d-%m-%Y')) AS fecha_contrato", false)
        ->from('emp_empleado')
        ->join('pro_profesion' ,'pro_id = emp_id_pro')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

}
