<?php
/**
 * @author René Castaneda
 * @method Modelo - Modulo Eventos
 */
class Eventos_model extends CI_Model
{
	function __construct()
	{
		parent::__construct();
	}


	/**
	 * @author René Castaneda
	 * @since 2018-07-15
	 * @return Obtener los datos de los eventos
	 */
	public function informacion_eventos($where=null)
	{
		$q = $this->db->select()
					->from('evn_evento')
					->join('users', 'id=evn_id_usu')
					->join('emp_empleado', 'usu_id_emp=emp_id', 'left')
					;
		if ($where) {
			$this->db->where($where);
		}
		return $q->get()->result_array();
	}

	/**
	 * @author René Castaneda
	 * @since 2018-07-15
	 * @return Obtener información del usuario
	 */
	public function get_info_usuario($where=null)
	{
		$q = $this->db->select()
					->from('users')
					->join('emp_empleado', 'usu_id_emp=emp_id', 'left')
					;
		if ($where) {
			$this->db->where($where);
		}
		return $q->get()->result_array();
	}


	/**
	 * @author René Castaneda
	 * @since 2018-07-15
	 * @return Obtener información del usuario
	 */
	public function get_info_usuario_rol($where=null)
	{
		$q = $this->db->select()
					->from('users')
					->join('emp_empleado', 'usu_id_emp=emp_id')
					->join("uxr_usuarioxrol", "uxr_id_usu = id")
					->join("rol_rol", "rol_id = uxr_id_rol")
					->group_by("id")
					->order_by("rol_nombre")
					;
		if ($where) {
			$this->db->where($where);
		}
		return $q->get()->result_array();
	}

	/**
	 * @author René Castaneda
	 * @since 2018-07-22
	 * @return Obtener información del usuario del evento
	 */
	public function get_usuarios_evento($where=null)
	{
		$q = $this->db->select()
					->from('users')
					->join('emp_empleado', 'usu_id_emp=emp_id')
					->join("uxr_usuarioxrol", "uxr_id_usu = id")
					->join("rol_rol", "rol_id = uxr_id_rol")
					->join("usv_usuario_evento","usv_id_usu=id")
					->join("evn_evento","evn_id=usv_id_evn")
					->group_by("evn_id, id")
					->order_by("rol_nombre")
					;
		if ($where) {
			$this->db->where($where);
		}
		return $q->get()->result_array();
	}

	public function get_usuarios_eventos2($where=null){
		$q = $this->db->select("*, IF(ISNULL(emp_id),username,CONCAT(emp_nombre,' ',emp_apellido)) AS creador", false)
					->from('evn_evento')
					->join('users', 'id = evn_id_usu')
					->join("emp_empleado","emp_id = usu_id_emp")
					->join("usv_usuario_evento", "usv_id_evn = evn_id", "LEFT")
					->join("uxr_usuarioxrol", "uxr_id_usu = usv_id_usu", "LEFT")
					->join("rol_rol", "rol_id = uxr_id_rol", "LEFT")
					->group_by("evn_id")
					->order_by("evn_id_usu")
					;
		if ($where) {
			$this->db->where($where);
		}
		return $q->get()->result_array();
	}




}