<?php
class Evaluacion_desempeno_model extends CI_Model
{
	function __construct()
	{
		parent::__construct();
	}

	public function select_puesto($evaluacion=0) {
		$q = $this->db->select("pto_puesto.*")
		->from("pto_puesto")
		->where("pto_id not in (SELECT ext_id_pto from ext_evaluacionxpuesto WHERE ext_id_eva=$evaluacion)")->get()->result_array();
		$opciones='<option value=""></option>';
		foreach ($q as $f) {
			$opciones .='<option value="'.$f['pto_id'].'">'.$f['pto_nombre'].'</option>';
		}

		return $opciones; 
	}

	public function opcion_respuesta($where=null)
	{
		if ($where) {
			$this->db->where($where);
		}
				$this->db->join('pon_ponderacion', 'pon_id = pxc_id_pon');
		$q =	$this->gsatelite->get_tabla('pxc_ponderacionxcompetencia');
		return $q;
	}

	public function informacion_empleado($where=null)
	{
		$q = $this->db->select()
					->from('emp_empleado')
			 		->join('plz_plaza', 'plz_id = emp_id_plz')
			 		->join('pto_puesto', 'pto_id = plz_id_pto')
					->group_by('emp_id')
					;
		if ($where) {
			$this->db->where($where);
		}
		return $q->get()->result_array();
	}

	public function get_evaluacion_puesto($where=null)
	{
		$q = $this->db->select()
					->from('ext_evaluacionxpuesto')
			 		->join('eva_evaluacion', 'eva_id = ext_id_eva')
			 		->join('pto_puesto', 'pto_id = ext_id_pto')
					->group_by('eva_id')
					;
		if ($where) {
			$this->db->where($where);
		}
		return $q->get()->result_array();
	}

	/**
	 * @author René Castaneda
	 * @since 2017-05-23
	 * @return Obtener los datos de la evaluación por empleado (datos basicos)
	 */
	public function verificar_empleado_evaluacion($where = null){
		$q = $this->db->select('*, (SELECT plz_nombre FROM emp_empleado JOIN plz_plaza ON plz_id = emp_id_plz WHERE emp_id = eve_id_emp) AS plz_nombre ', false)
			->from('eve_evaluacion_empleado')
			->join('ext_evaluacionxpuesto', 'ext_id = eve_id_ext')
			->join('eva_evaluacion', 'eva_id = ext_id_eva')
			->join('pde_periodo_evaluacion', 'pde_id = eve_id_pde')
		;
		if ($where) {
			$this->db->where($where);
		}
		return $q->get()->result_array();
	}

	/**
	 * @author René Castaneda
	 * @since 2017-05-23
	 * @return Obtener los datos de la evaluación 
	 */
	public function get_datos_evaluacion($where=null)
	{
		$q = $this->db->select("*, GROUP_CONCAT(CONCAT(pxc_id,'#',pxc_id_pon) ORDER BY pxc_id ASC SEPARATOR ',' ) pxc_poneracion",false)
					->from('eva_evaluacion')
			 		->join('coe_competencia_evaluacion', ' coe_id_eva = eva_id')
			 		->join('cte_categoria_evaluacion', 'cte_id = coe_id_cte')
			 		->join('pxc_ponderacionxcompetencia', 'pxc_id_coe = coe_id and pxc_estado = 1', 'left')
					->group_by('coe_id')
					->order_by('coe_id_cte, coe_orden')
					;
		if ($where) {
			$this->db->where($where);
		}
		return $q->get()->result_array();
	}

	/**
	 * @author René Castaneda
	 * @since 2017-05-25
	 * @return Obtener los datos de la evaluación realizada por el empleado
	 */
	public function get_datos_evaluacion_empleado($where=null)
	{
		$q = $this->db->select("*, GROUP_CONCAT(CONCAT(pxc_id,'#',pxc_id_pon) ORDER BY pxc_id ASC SEPARATOR ',' ) pxc_poneracion",false)
					->from('dte_detalle_evaluacion')
			 		->join('coe_competencia_evaluacion', 'coe_id = dte_id_coe')
			 		->join('cte_categoria_evaluacion', 'cte_id = coe_id_cte')
			 		->join('pxc_ponderacionxcompetencia', 'pxc_id_coe = coe_id and (pxc_estado = 1 or pxc_id = dte_id_pxc)', 'left')
					->group_by('coe_id')
					->order_by('coe_id_cte, coe_orden')
					;
		if ($where) {
			$this->db->where($where);
		}
		return $q->get()->result_array();
	}

	/**
	 * @author Raul E.
	 * @since 2021-JUL
	 * @return Obtener los datos de la evaluación realizada por el empleado sin tomar en cuenta valores no evaluados de la misma competencia
	 */
	public function get_datos_ponderados_evaluacion_emp($where=null){
		$q = $this->db->select('*, IFNULL((SELECT pxc_id_pon FROM pxc_ponderacionxcompetencia WHERE pxc_id = dte_id_pxc), 0) AS pond_sltd, 
			(SELECT GROUP_CONCAT(DISTINCT CONCAT(pon_id, "//", pon_nombre, "//", pon_peso) ORDER BY pon_peso ASC SEPARATOR "##") FROM coe_competencia_evaluacion AS c
			JOIN pxc_ponderacionxcompetencia ON pxc_id_coe = c.coe_id  JOIN pon_ponderacion ON pon_id = pxc_id_pon WHERE pon_estado = 1 AND c.coe_id_cte = cte_id 
			AND pxc_id_coe = dte_id_coe) AS ponderaciones',false)
				->from('dte_detalle_evaluacion')
				->join('coe_competencia_evaluacion', 'coe_id = dte_id_coe')
				->join('cte_categoria_evaluacion', 'cte_id = coe_id_cte')
				->group_by('coe_id_cte')
				->order_by('coe_id_cte')
		;
		if ($where) {
			$this->db->where($where);
		}
		return $q->get()->result_array();
	}

	/**
	 * @author René Castaneda
	 * @since 2017-05-29
	 * @return Obtener los datos de la evaluación realizada por el empleado (para el reporte)
	 */
	public function informacion_evaluacion_empleado($where=null){
		$q = $this->db->select("emp_empleado.*, eve_evaluacion_empleado.*, ext_evaluacionxpuesto.*, eva_evaluacion.*, plz_plaza.plz_id, plz_plaza.plz_nombre, are_area.are_id, 
			are_area.are_nombre, pto_id, pto_nombre, (SELECT pde_codigo FROM pde_periodo_evaluacion WHERE pde_id = eve_id_pde) AS pde_codigo, (SELECT pde_fecha_inicio FROM pde_periodo_evaluacion 
			WHERE pde_id = eve_id_pde) AS pde_fecha_inicio, (SELECT pde_fecha_fin FROM pde_periodo_evaluacion WHERE pde_id = eve_id_pde) AS pde_fecha_fin, 
			CONCAT_WS(' ', emp2.emp_nombre,emp2.emp_apellido) nombre_evaluador, are2.are_nombre area_evaluador, plz2.plz_nombre plaza_evaluador", false)
					->from('emp_empleado')
			 		->join('plz_plaza', 'plz_id = emp_id_plz', 'left')
			 		->join('are_area', 'are_id = emp_id_are', 'left')
			 		->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
			 		->join('eve_evaluacion_empleado', 'eve_id_emp = emp_id') 	
			 		->join('ext_evaluacionxpuesto', 'ext_id = eve_id_ext')
			 		->join('eva_evaluacion', 'eva_id = ext_id_eva') 
			 		->join('users', 'id = eve_id_usu')
			 		->join('emp_empleado emp2', 'emp2.emp_id = usu_id_emp', 'left')
			 		->join('plz_plaza plz2', 'plz2.plz_id = emp2.emp_id_plz', 'left')
			 		->join('are_area are2', 'are2.are_id = emp2.emp_id_are', 'left')  
					->group_by('emp_id')
					;
		if ($where) {
			$this->db->where($where);
		}
		return $q->get()->result_array();
	}

	/**
	 * @author René Castaneda
	 * @since 2017-05-29
	 * @return Obtener las ponderaciones de la evaluación realizada por el empleado
	 */
	public function get_ponderaciones_evaluacion($where=null)
	{
		$q = $this->db->select('coe_id, coe_nombre, COUNT(DISTINCT pxc_id_pon) n, GROUP_CONCAT( DISTINCT CONCAT(pon_id,"//",pon_nombre,"//",pon_peso) ORDER BY pon_peso ASC SEPARATOR "##" ) ponderaciones',false)
					->from('pxc_ponderacionxcompetencia')
			 		->join('coe_competencia_evaluacion', 'coe_id = pxc_id_coe')
			 		->join('pon_ponderacion', 'pon_id = pxc_id_pon')
					->group_by('coe_id_cte')->limit('1')
					;
		if ($where) {
			$this->db->where($where);
		}
		return $q->get()->row_array();
	}



}

