<?php

class Estructura_organizativa_model extends CI_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_solo_padres($where = null)
    {
        //preguntar por los padres
        $query = $this->db->select()
            ->from('are_area')
            ->where('are_estado', 1)
            ->order_by('are_id', 'ASC');

        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 02-03-2018

        if ($where != null) {
            $this->db->where($where);
        } else {
            $this->db->where('are_padre', null);
        }

        $resultado = $query->get()->result_array();

        return $resultado;
    }

    public function get_solo_padres_plaza()
    {
        //preguntar por los padres
        $query = $this->db->select()
            ->from('plz_plaza')
            ->where('plz_estado', 1)
            ->where('plz_id_padre', null)
            ->order_by('plz_id', 'asc');
        $resultado = $query->get()->result_array();

        return $resultado;
    }

    function get_solo_padres_plaza_modificado($where = null)
    {
        $query = $this->db->select('*, COUNT(plz_id) AS total, GROUP_CONCAT( DISTINCT plz_id) ids_p, (SELECT COUNT(sub.plz_id) FROM plz_plaza sub WHERE sub.plz_id_padre = plz_plaza.plz_id) n_hijos')
            ->from('plz_plaza')
            ->join('pto_puesto', "pto_id = plz_id_pto", "left")
            ->join('tpt_tipo_puesto', 'tpt_id = pto_id_tpt', 'left')
            ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
            ->where('plz_estado', 1)
            ->where('plz_dibujar_organigrama', 1)
            ->where('mxr_id_emr', $this->tank_auth->get_empresa_id());

        if ($where != null) {
            $this->db->where($where);
        } else {
            $this->db->where('plz_id_padre', null);
        }

        $this->db->group_by('plz_nombre')
            ->order_by('plz_id', 'asc');

        //preguntar si hay padres agrupados con hijos.
        $this->db->having('total >', 1);
        //$this->db->having('n_hijos >',0);

        $resultado = $query->get()->result_array();
        //print_r($resultado); die();
        if (count($resultado) > 0) {
            $incluirlo = array(0);
            foreach ($resultado as $fpadre) {
                $nhiijos = $this->db->select("COUNT(plz_id) AS total, GROUP_CONCAT(DISTINCT plz_id_padre) idpdres", false)->from('plz_plaza')->where("plz_id_padre in (" . $fpadre['ids_p'] . ")")->get()->result_array();
                if (count($nhiijos) > 0 &&  $nhiijos[0]['total'] > 0) {
                    $incluirlo[] = $nhiijos[0]['idpdres'];
                }
            }

            //print_r($incluirlo); die();


            $ids = array_column($resultado, 'ids_p');
            $ids = implode(',', $ids); //die('llego'); 
            $query = $this->db->select('*, COUNT(plz_id) AS total, (SELECT COUNT(sub.plz_id) FROM plz_plaza sub WHERE sub.plz_id_padre = plz_plaza.plz_id) n_hijos')
                ->from('plz_plaza')
                ->join('pto_puesto', "pto_id = plz_id_pto", "left")
                ->join('tpt_tipo_puesto', 'tpt_id = pto_id_tpt', 'left')
                ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
                ->where('plz_estado', 1)
                ->where('mxr_id_emr', $this->tank_auth->get_empresa_id())
                //->where("plz_id not in ($ids)")
                ->where("plz_plaza.plz_id not in (" . implode(',', $incluirlo) . ")", null, false);

            if ($where != null) {
                $this->db->where($where);
            } else {
                $this->db->where('plz_id_padre', null);
            }

            $this->db->group_by('plz_nombre')
                ->order_by('plz_id', 'asc');
            $resultado1 = $query->get()->result_array();
            //print_r($resultado1); die();

            $query = $this->db->select('*, COUNT(plz_id) AS total, (SELECT COUNT(sub.plz_id) FROM plz_plaza sub WHERE sub.plz_id_padre = plz_plaza.plz_id) n_hijos')
                ->from('plz_plaza')
                ->join('pto_puesto', "pto_id = plz_id_pto", "left")
                ->join('tpt_tipo_puesto', 'tpt_id = pto_id_tpt', 'left')
                ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
                ->where('plz_estado', 1)
                ->where('mxr_id_emr', $this->tank_auth->get_empresa_id())
                //->where_in('plz_plaza.plz_id', explode(',',$ids))
                ->where("plz_plaza.plz_id in (" . implode(',', $incluirlo) . ")", null, false);

            if ($where != null) {
                $this->db->where($where);
            } else {
                $this->db->where('plz_id_padre', null);
            }

            $this->db->group_by('plz_id')
                ->order_by('plz_id', 'asc');
            $resultado2 = $query->get()->result_array();
            // print_r($resultado2); die();
            $resultado = array_merge($resultado1, $resultado2);
            //$resultado = array_sort($resultado, 'plz_nombre', SORT_ASC);
            //print_r($resultado); die();

        } else {
            $query = $this->db->select('*, COUNT(plz_id) AS total, (SELECT COUNT(sub.plz_id) FROM plz_plaza sub WHERE sub.plz_id_padre = plz_plaza.plz_id) n_hijos')
                ->from('plz_plaza')
                ->join('pto_puesto', "pto_id = plz_id_pto", "left")
                ->join('tpt_tipo_puesto', 'tpt_id = pto_id_tpt', 'left')
                ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
                ->where('plz_estado', 1)
                ->where('mxr_id_emr', $this->tank_auth->get_empresa_id());

            if ($where != null) {
                $this->db->where($where);
            } else {
                $this->db->where('plz_id_padre', null);
            }

            $this->db->group_by('plz_nombre')
                ->order_by('plz_id', 'asc');

            $resultado = $query->get()->result_array();
        }

        return $resultado;
    }

    public function get_solo_padres_TIA()
    {
        //preguntar por los padres
        $query = $this->db->select()
            ->from('tia_tipo_articulo')
            ->where('tia_tipo_articulo.tia_estado', 1)
            ->where('tia_tipo_articulo.tia_padre', null)
            ->order_by('tia_id', 'asc');
        $resultado = $query->get()->result_array();

        return $resultado;
    }

    public function plazas_area($id_area, $devolver_array = false)
    {

        $query = $this->db->select()
            ->from('plz_plaza')
            ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
            ->where('mxr_id_emr', $this->tank_auth->get_empresa_id())
            ->where('plz_id_are', $id_area)
            ->where('plz_estado', 1)->get()->result_array();
        $nombre = array();
        foreach ($query as $f) {
            $nombre[] = $f['plz_nombre'];
        }
        if ($devolver_array) {
            return $nombre;
        } else {
            if (count($nombre) > 0) {
                $cadena = '<div class="contenedor_plazas" >' . implode('<br />', $nombre) . '</div>';
                return $cadena;
            } else {
                return "";
            }
        }
    }

    public function crear_arbol($padre, $prefijo, $extra_where = null)
    {
        $cadena = "";
        if ($extra_where != null && count($extra_where) > 0) {
            $this->db->where($extra_where);
        }
        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 02-03-2018  
        $q = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1, 'are_padre' => $padre));
        if ($q) {
            $cadena .= "\n<ul>";
            foreach ($q as $fila) {
                //preguntar por la cantidad de empleados pertenecientes a cada area
                $n_empleados = $this->db->select("COUNT(emp_id_are) AS n", false)->from('emp_empleado')->where(array('emp_estado' => 1, 'emp_id_are' => $fila['are_id'], 'emp_id_emr' => $this->tank_auth->get_empresa_id()))->get()->row_array();
                $n = ($n_empleados['n'] != 0) ? ' (<span class="n_empleados_area">' . $n_empleados['n'] . '</span>)' : '';
                //preguntar por los puestos
                $plazas = $this->plazas_area($fila['are_id']);
                /*
                $idplz = (trim($fila['are_id']) != '')? $fila['are_id']:'0';
                $n_empleados = $this->gsatelite->get_tabla('emp_empleado', array("emp_id_are in (".$idplz.")" => null));
                if (count($n_empleados) > 0) {  
                    $n_emp = '<hr style="margin-top:1px;margin-bottom:5px; border-color:black" /><div class="cotenedor_empleado_arbol">';
                    foreach ($n_empleados as $fe) {
                        $n_emp .= '- '.$fe['emp_nombre']." ".$fe['emp_apellido'].'<br />';
                    }
                    $n_emp .= '</div>';
                } else {
                    $n_emp = "";
                }
                // agregar el $n_emp.
                */
                $cadena .= "\n<li>" . $prefijo . $fila['are_nombre'] . $n . " <br />" . $plazas;
                $cadena .= $this->crear_arbol($fila['are_id'], $prefijo . $prefijo, $extra_where);
            }
            $cadena .= '</ul></li>';
        } else {
            $cadena .= "</i>";
        }
        return $cadena;
    }

    public function crear_arbol_plz($padre, $prefijo, $aplicar_where_in = null, $esJSON = false, $tipo_vista = 0)
    {
        $cadena = "";
        $q = $this->get_hijos_plaza_modificado($padre, $aplicar_where_in);
        if ($q) {
            if (isset($q[0]['plz_id']) > 0 and $q[0]['plz_id'] > 0) {
                $cadena .= ($esJSON) ? ', "children": [' : ', "children": [';
                foreach ($q as $fila) {
                    //preguntar por el empleado de la plaza

                    $idplz = (trim($fila['ids_plazas']) != '') ? $fila['ids_plazas'] : '0';
                    $n_empleados = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1, "emp_id_plz in (" . $idplz . ")" => null));
                    $empleado = (count($n_empleados) > 0) ? $n_empleados[0] : '';
                    $n = (count($n_empleados) > 0) ? ' <span class="totalEmp">[' . $fila['total'] . "]</span>" : '';
                    if ($esJSON) {
                        $n = (count($n_empleados) > 0) ? " [<span class='conteo_nplazas'>" . $fila['total'] . "</span>]" : '';
                    }

                    //Si el tipo de vista es para plazas Empleados
                    $n_emp = 'null';
                    if ($tipo_vista == 1) {
                        $n_emp = array();
                        if (count($n_empleados) > 0) {
                            foreach ($n_empleados as $fe) {
                                //$n_emp .= '- '.trim($fe['emp_nombre'])." ".trim($fe['emp_apellido']).'\r\n';
                                $n_emp[] = array('emp_nombre' => trim($fe['emp_nombre']) . " " . trim($fe['emp_apellido']));
                            }
                        }
                    }

                    $subtitulo = "null";
                    if (count($n_empleados) > 0 && $tipo_vista == 1) {
                        $subtitulo = array();
                        foreach ($n_empleados as $fe) {
                            $n_emp = $fe['emp_nombre'] . " " . $fe['emp_apellido'] . '<br>';
                            $subtitulo[] = array('emp_nombre' => $n_emp);
                        }
                    } else {
                        $subtitulo = "null";
                    }
                    $subtitulo = json_encode($subtitulo); //aqui van los nombres de los empleados


                    if ($esJSON) {
                        $tiene_dep = true;
                        if ($fila['plz_id_padre'] > 0 && $fila['plz_es_staff'] == 1) {
                            $tiene_dep = $this->gsatelite->get_tabla('plz_plaza', array('plz_id_padre' => $fila['plz_id_padre'], '(plz_es_staff !=1 or plz_es_staff IS NULL)' => null));
                        }
                        $tipo_area = ($fila['plz_es_staff'] == 1) ? (($tiene_dep) ? 'staff' : 'subordinate') : 'subordinate';
                        $extra_tipo = ($fila['plz_es_staff'] == 1) ? ', "subtype" : "dashed", "box_color" : "#a0cea7"' : '';
                        $cadena .= '{ "id": "plz_' . $fila['plz_id'] . '", "title": "' . $fila['plz_nombre'] . ' (' . count($n_empleados) . ')", "subtitle": ' . $subtitulo . ', "type":"' . $tipo_area . '"' . $extra_tipo;
                        $cadena .= $this->crear_arbol_plz($fila['plz_id'], $prefijo . $prefijo, $aplicar_where_in, $esJSON, $tipo_vista);
                    } else {
                        $cadena .= '<li>' . $prefijo . $fila['plz_nombre'] . $n . $n_emp;
                        $cadena .= $this->crear_arbol_plz($fila['plz_id'], $prefijo . $prefijo, $aplicar_where_in, $esJSON, $tipo_vista);
                    }
                }
                $cadena .= ($esJSON) ? '] },' : '';
            }
        } else {
            $cadena .= ($esJSON) ? "}," : "</i>";
        }
        return $cadena;
    }

    public function crear_arbol3($padre, $prefijo, $where)
    {
        $cadena = "";

        if ($where) {
            $this->db->where($where);
        }
        $this->db->order_by('are_nivel ASC, are_orden ASC');
        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id());
        $q = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1, 'are_padre' => $padre));
        // print_r($this->db->last_query());die();
        /*$q2 = $this->gsatelite->get_tabla('plz_plaza', array('plz_estado' => 1, 'plz_id_are' => $padre));
          $q = array_merge($q, $q2);     */
        if ($q) {
            $cadena .= "<ul>";
            foreach ($q as $fila) {
                //$cadena .= $prueba; 
                //preguntar por la cantidad de empleados pertenecientes a cada area
                $n_empleados = $this->db->select("COUNT(emp_id_are) AS n", false)->from('emp_empleado')->where(array('emp_estado' => 1, 'emp_id_are' => $fila['are_id'], 'emp_id_emr' => $this->tank_auth->get_empresa_id()))->get()->row_array();
                $n = ($n_empleados['n'] != 0) ? ' (<span class="conteo_nplazas">' . $n_empleados['n'] . '</span>)' : '';
                //preguntar por los puestos
                $plazas = $this->plazas_area3($fila['are_id'], '', $where);

                $linea = "";
                if (trim($plazas) != "") {
                    $linea = '<hr style="margin-top:5px;margin-bottom:5px; border-color:black"><div style="display:block;border-top-style:none; width:120%; text-align:left;  border-top-width:2px; margin-top:5px; font-weight: bold; margin-right: 10px;"></div>';
                }
                $cadena .= '<li style="text-align:center;"><div style="font-weight:bold;">' . $prefijo . $fila['are_nombre'] . $n . "\n" . '<br /></div>' . $linea . $plazas;

                $cadena .= $this->crear_arbol3($fila['are_id'], $prefijo . $prefijo, $where);
            }
            $cadena .= "</ul></li>\n";
        } else {
            $cadena .= "</i>\n";
        }
        return $cadena;
    }

    public function plazas_area3($id_area, $devolver_array = false)
    {

        $query = $this->get_plazas_area(array('plz_id_are' => $id_area, 'plz_estado' => 1));
        //print_r($this->db->last_query());die();
        $nombre = array();
        $nombre_hijas = "";
        $cadena = "";
        $linea = '<hr style="margin-top:5px;margin-bottom:5px; border-color:black"><div style="display:block;border-top-style:none; width:120%; text-align:left;  border-top-width:2px; margin-top:5px; font-weight: bold; margin-right: 10px;"></div>';
        foreach ($query as $f) {
            $query_posee = $this->get_plazas_area(array('plz_id_are' => $id_area, 'plz_estado' => 1, 'plz_id_padre' => $f['plz_id']));
            $nombre[] = $f['plz_nombre'] . '(<span class="conteo_nplazas">' . $f['nplazas'] . '</span>)';
            $cadena .= '<div class="contenedor_plaza" style="text-align: left !important;white-space:nowrap;">';

            if ($query_posee)
                $cadena .= '<b>' . $f['plz_nombre'] . '(<span class="conteo_nplazas2">' . $f['nplazas'] . '</span>)' . '</b>';
            else
                $cadena .= $f['plz_nombre'] . '(<span class="conteo_nplazas2">' . $f['nplazas'] . '</span>)';

            $cadena .= $this->plazas_hijas($id_area, $f['plz_id'], '&nbsp;');
            $cadena .= '</div>' . $linea;
        }

        if ($devolver_array) {
            return $nombre;
        } else {
            //if (count($nombre) > 0) {


            //$cadena = '<div class="contenedor_plaza" >'. $nombre_hijas.'</div>';
            return $cadena;
            //} else {
            //return "";
            //}
        }
    }

    public function plazas_hijas($id_area, $plaza_padre, $prefijo, $ids = null)
    {
        $query = $this->get_plazas_area(array('plz_id_are' => $id_area, 'plz_estado' => 1, 'plz_id_padre' => $plaza_padre), $ids);
        //$query = $this->gsatelite->get_tabla('plz_plaza', array('plz_id_padre'=>$plaza_padre, 'plz_id_are'=>$id_area));
        $regresar = '';
        if ($ids != null) {
            //echo $this->db->last_query();die();
        }

        if (count($query) > 0) {

            foreach ($query as $key) {
                $regresar .= '<br>-' . $prefijo . $key['plz_nombre'] . '(<span class="conteo_nplazas2">' . $key['nplazas'] . '</span>)';
                $regresar .= $this->plazas_hijas($id_area, $key['plz_id'], $prefijo . $prefijo, $key['ids']);
            }
        } else {
            $regresar = "";
        }
        return $regresar;
    }

    function get_hijos_plaza_modificado($padre, $where_in, $get_ids_plaza = 0)
    {

        $reg_padre = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $padre));

        $reg_padre_ids = $this->gsatelite->get_tabla('plz_plaza', array('plz_id_padre' => $reg_padre[0]['plz_id_padre'], 'plz_nombre' => $reg_padre[0]['plz_nombre']));

        $idss = array_column($reg_padre_ids, 'plz_id');
        //print_r($idss); die();

        $query = $this->db->select('*, COUNT(plz_id) AS total, group_concat(DISTINCT plz_id) AS ids_plazas')
            ->from('plz_plaza')
            ->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
            ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
            ->where('plz_estado', 1)
            ->where('mxr_id_emr', $this->tank_auth->get_empresa_id())
            ->where('plz_id_padre', $padre)
            ->where('plz_dibujar_organigrama', 1)
            //->where_in("plz_id_padre",$idss) //tomar los ids que se agruparon.
        ;

        if ($where_in != null and $where_in > 0) {
            $this->db->where("pto_id IN (SELECT pto_id FROM pto_puesto WHERE pto_id_tpt <= " . $where_in . ")", null);
        }

        $this->db->group_by('plz_nombre');
        $this->db->order_by('plz_id', 'asc');
        //preguntar si hay padres agrupados con hijos.
        $this->db->having('total >', 1);


        // die();
        $resultado = $query->get()->result_array();
        if ($get_ids_plaza != 0) {
            return $resultado[0]['ids_plazas'];
        }
        if (count($resultado) > 0) { //REPETIR LA QUERY PERO EN ESTA OCACIÓN NO AGRUPADA
            $incluirlo = array(0);
            foreach ($resultado as $fpadre) {
                $nhiijos = $this->db->select("COUNT(plz_id) AS total, GROUP_CONCAT(DISTINCT plz_id_padre) idpdres")->from('plz_plaza')->where("plz_id_padre in (" . $fpadre['ids_plazas'] . ")")->get()->result_array();
                if (count($nhiijos) > 0 && $nhiijos[0]['total'] > 0) {
                    $incluirlo[] = $nhiijos[0]['idpdres'];
                }
            }


            $query = $this->db->select('*, COUNT(plz_id) AS total, group_concat(DISTINCT plz_id) AS ids_plazas')
                ->from('plz_plaza')
                ->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
                ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
                ->where('plz_estado', 1)
                ->where('mxr_id_emr', $this->tank_auth->get_empresa_id())
                ->where('plz_id_padre', $padre)
                ->where('plz_dibujar_organigrama', 1)
                ->where("plz_plaza.plz_id not in (" . implode(',', $incluirlo) . ")", null, false)
                //->where_in("plz_id_padre",$idss) //tomar los ids que se agruparon.
            ;

            if ($where_in != null and $where_in > 0) {
                $this->db->where("pto_id IN (SELECT pto_id FROM pto_puesto WHERE pto_id_tpt <= " . $where_in . ")", null);
            }
            $this->db->group_by('plz_nombre');
            $this->db->order_by('plz_id', 'ASC');
            $resultado1 = $query->get()->result_array();

            $query = $this->db->select('*, COUNT(plz_id) AS total, group_concat(DISTINCT plz_id) AS ids_plazas')
                ->from('plz_plaza')
                ->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
                ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
                ->where('plz_estado', 1)
                ->where('plz_dibujar_organigrama', 1)
                ->where('mxr_id_emr', $this->tank_auth->get_empresa_id())
                ->where('plz_id_padre', $padre)
                ->where("plz_plaza.plz_id in (" . implode(',', $incluirlo) . ")", null, false)
                //->where_in("plz_id_padre",$idss) //tomar los ids que se agruparon.
            ;

            if ($where_in != null and $where_in > 0) {
                $this->db->where("pto_id IN (SELECT pto_id FROM pto_puesto WHERE pto_id_tpt <= " . $where_in . ")", null);
            }
            $this->db->group_by('plz_id');
            $this->db->order_by('plz_id', 'asc');
            $resultado2 = $query->get()->result_array();

            $resultado = array_merge($resultado1, $resultado2);
            //$resultado = array_sort($resultado, 'plz_nombre', SORT_ASC);

        } else {
            $query = $this->db->select('*, COUNT(plz_id) AS total, group_concat(DISTINCT plz_id) AS ids_plazas')
                ->from('plz_plaza')
                ->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
                ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
                ->where('plz_estado', 1)
                ->where('plz_dibujar_organigrama', 1)
                ->where('mxr_id_emr', $this->tank_auth->get_empresa_id())
                ->where('plz_id_padre', $padre)
                //->where_in("plz_id_padre",$idss) //tomar los ids que se agruparon.
            ;

            if ($where_in != null and $where_in > 0) {
                $this->db->where("pto_id IN (SELECT pto_id FROM pto_puesto WHERE pto_id_tpt <= " . $where_in . ")", null);
            }

            $this->db->group_by('plz_nombre');
            $this->db->order_by('plz_id', 'asc');
            $resultado = $query->get()->result_array();
        }

        return $resultado;
    }

    public function crear_arbol2($padre, $prefijo)
    { //areas hijas
        $cadena = "";
        $q = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1, 'are_padre' => $padre, 'are_id_emr' => $this->tank_auth->get_empresa_id()));
        if ($q) {
            //$cadena .="<ul>";
            $cadena .= "";
            // $cadena .= "<ul>";
            foreach ($q as $fila) {
                //Preguntar por la cantidad de empleados pertenecientes a cada area
                $n_empleados = $this->db->select("COUNT(emp_id_are) AS n", false)->from('emp_empleado')->where(array('emp_estado' => 1, 'emp_id_are' => $fila['are_id'], 'emp_id_emr' => $this->tank_auth->get_empresa_id()))->get()->row_array();
                $n = ($n_empleados['n'] != 0) ? ' (<span class="conteo_nplazas">' . $n_empleados['n'] . '</span>)' : '';

                $cadena .= '<li style="text-align:center;"><div style="font-weight:bold;">' . $prefijo . $fila['are_nombre'] . $n . '</div>';
                /*$cadena .= '<ul>
                                <li style="text-align:center;">
                                    <div style="font-weight:bold;">hola1234</div>
                                    <hr style="margin-top:5px;margin-bottom:5px; border-color:black"><div style="border-top-style:none; width:110%; text-align:left;  border-top-width:2px; margin-top:5px; font-weight: bold;">
                                    <span class="contenedor_plaza" > - joer </span><br>
                                </li>
                                <li style="text-align:center;">
                                    <div style="font-weight:bold;">hola1234</div>
                                    <hr style="margin-top:5px;margin-bottom:5px; border-color:black"><div style="border-top-style:none; width:110%; text-align:left;  border-top-width:2px; margin-top:5px; font-weight: bold;">
                                    <span class="contenedor_plaza" > - joasdaer </span><br>
                                </li>
                            </ul>';*/

                //Preguntar por los puestos

                $datos_plaza = $this->get_plazas_area(array('plz_id_are' => $fila['are_id']));
                //$datos_plaza = $this->gsatelite->get_tabla('plz_plaza', array('plz_id_are' => $fila['are_id']));
                if (count($datos_plaza) > 0) {
                    $cadena .= '<hr style="margin-top:5px;margin-bottom:5px; border-color:black"><div style="display:block;border-top-style:none; width:120%; text-align:left;  border-top-width:2px; margin-top:5px; font-weight: bold; margin-right: 10px;">';
                    foreach ($datos_plaza as $fila_plz) {
                        $cadena .= '<span class="contenedor_plaza"> - ' . $fila_plz['plz_nombre'] . '(<span class="conteo_nplazas">' . $fila_plz['nplazas'] . '</span>)</span><br>';
                        //$cadena .= $this->crear_arbol_plz2($fila_plz['plz_id'], '');
                        //$contador ++;
                    }
                    //$cadena .= "</div>\n";****

                }


                //$cadena .= "<ul>";****
                $cadena .= $this->crear_arbol2($fila['are_id'], $prefijo . $prefijo);

                $cadena .= "</li>\n";
            }
        } else {
            $cadena .= "\n";
        }
        //$cadena .= "</ul>\n";**
        return $cadena;
    }

    public function get_area_are($where = null)
    {
        /*
        $q = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1, 'are_padre' => $padre));
        
        */
        $query = $this->db->select()
            ->from('are_area');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_plazas_area($where = null, $ids = null)
    {
        /*SELECT * FROM plz_plaza WHERE plz_id_are = 12
ORDER BY plz_id_cec, plz_id_pto
        SELECT *, COUNT(plz_nombre) FROM plz_plaza WHERE plz_id_are = 12
GROUP BY plz_nombre
*/
        $query = $this->db->select('*, COUNT(plz_nombre) as nplazas, group_concat(plz_id) as ids', false)
            ->from('plz_plaza')
            ->join('are_area', 'are_id = plz_id_are')
            ->join('emp_empleado', 'emp_id_plz = plz_id') //obligarlo que tenga empleado para ser mostrado
            ->join('mxr_empresaxarea', 'mxr_id_are = are_id')
            ->where('emp_estado', 1)
            ->where('mxr_id_emr', $this->tank_auth->get_empresa_id())
            ->group_by('plz_nombre')

            /*->order_by('plz_id_cec')
                        ->order_by('plz_id_pto')*/;


        if ($where != null && $ids == null) {
            $this->db->where($where);
        }
        if ($ids != null) {
            $this->db->where("plz_id_padre in (" . $ids . ")");
        }
        // $this->db->where('plz_id_emr', $this->tank_auth->get_empresa_id());
        return $query->get()->result_array();
    }

    public function crear_arbol_plz2($padre, $prefijo, $area)
    {
        $cadena = "";
        $this->db->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are');
        $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 02-03-2018  
        $q = $this->gsatelite->get_tabla('plz_plaza', array('plz_estado' => 1, 'plz_id_padre' => $padre, 'plz_id_are' => $area));
        //print_r($q);
        //die();
        if (count($q) > 0) {
            $cadena .= "<div style='font-weight: normal;' >";
            foreach ($q as $fila) {
                //preguntar por el empleado de la plaza
                $re = $this->gsatelite->get_registro('plz_plaza', null, null, array('plz_id' => $padre));
                $n_empleados = $this->gsatelite->get_tabla('emp_empleado', array('emp_id_plz' => $re->plz_id, 'emp_estado' => 1));
                $empleado = (count($n_empleados) > 0) ? $n_empleados[0] : '';
                // $n = (count($n_empleados)>0)? '<div class="cotenedor_empleado_arbol">('.$empleado['emp_nombre'].' '.$empleado['emp_apellido'].')</div>':'';
                $n = "";
                $cadena .= '- ' . $prefijo . $fila['plz_nombre'] . $n;
                // $cadena .= $this->crear_arbol_plz2($fila['plz_id'], $prefijo . $prefijo);
                //$cadena .= $cadena;
                //$cadena .= "<br></div>\n";
                $cadena .= $this->crear_arbol_plz2($fila['plz_id'], '', $fila['plz_id_are']);
                //die();
            }
            $cadena .= "<br></div>\n";
            //print_r($cadena);
        }
        //else {  $cadena .="</li>\n";  }            
        return $cadena;
    }

    public function crear_arbol_TIA($padre, $prefijo)
    {
        $cadena = "";
        $q = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1, 'tia_padre' => $padre));
        if ($q) {
            $cadena .= "<ul>";
            foreach ($q as $fila) {
                $cadena .= '<li>' . $prefijo . $fila['tia_nombre'] . '<br>';
                $cadena .= $this->crear_arbol($fila['tia_id'], $prefijo . $prefijo);
            }
            $cadena .= '</ul></li>';
        } else {
            $cadena = "</i>";
        }
        return $cadena;
    }

    public function get_logros_plaza($where = null)
    {
        $query = $this->db->select()
            ->from('arp_area_resultadoxplaza')
            ->join('are_area', 'are_id = arp_id_are', 'inner')
            ->join('acl_area_clave_resultado', 'acl_id = arp_id_acl', 'inner')
            ->join('pot_porcentaje_tiempo', 'pot_id = arp_id_pot', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_competencias_plaza($where = null)
    {
        $query = $this->db->select()
            ->from('cpz_competencia_plaza')
            ->join('com_competencia', 'com_id = cpz_id_com', 'inner')
            ->join('cls_clasificacion', 'cls_id = cpz_id_cls', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_riesgos_plaza($where = null)
    {
        $query = $this->db->select()
            ->from('rxl_riesgoxplaza')
            ->join('nir_nivel_riesgo', 'nir_id = rxl_id_nir', 'inner')
            ->join('tri_tipo_riesgo', 'tri_id = rxl_id_tri', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_empleado($where = null)
    {
        $query = $this->db->select()
            ->from('emp_empleado')
            ->join('plz_plaza', 'plz_id = emp_id_plz')
            ->join('are_area', 'are_id = emp_id_are')
            ->join('pto_puesto', ' pto_id = plz_id_pto')
            ->join('tic_tipo_contrato', ' tic_id = emp_id_tic', 'left')
            ->join('suc_sucursal', 'suc_id = emp_id_suc', 'left')
            ->join('cts_categoria_salarial', 'cts_id = pto_id_cts', 'left')
            ->where('emp_estado', 1)
            ->where("are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = " . $this->tank_auth->get_empresa_id() . ")", null, false);

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author René Castaneda
     * @since 2018-01-02
     * @param array $where lista de condicionales para generar la query.
     * @return / Description: Generar query para retornar los datos de puesto
     */
    public function informacion_puesto($where = null)
    {
        $query = $this->db->select()
            ->from('pto_puesto')
            ->join('tpt_tipo_puesto', 'tpt_id = pto_id_tpt', 'left')
            ->join('cts_categoria_salarial', 'cts_id = pto_id_cts', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_solo_padres_plazaxtipo($where = null)
    {
        $id_empresa = $this->tank_auth->get_empresa_id();
        $query = $this->db->select('*, COUNT(plz_id) AS total')
            ->from('plz_plaza')
            ->join('pto_puesto', 'pto_id = plz_id_pto')
            ->join('tpt_tipo_puesto', "tpt_id = pto_id_tpt")
            ->where('plz_estado', 1)
            ->where("plz_id_are IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)", null, false);

        if ($where != null) {
            $this->db->where($where);
        } else {
            $this->db->where('plz_id_padre', null);
        }

        $this->db->group_by('plz_nombre')
            ->order_by('plz_id', 'asc');
        $resultado = $query->get()->result_array();

        return $resultado;
    }

    public function crear_arbol_json($padre, $prefijo, $extra_where = null, $esJSON = true)
    {
        $cadena = "";
        if ($extra_where != null  && count($extra_where) > 0) {
            $this->db->where($extra_where);
        }
        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 02-03-2018  
        $q = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1, 'are_padre' => $padre));
        if ($q) {
            $cadena .= ($esJSON) ? ', "children": [' : '';
            foreach ($q as $fila) {
                //preguntar por la cantidad de empleados pertenecientes a cada area
                $n_empleados = $this->db->select("COUNT(emp_id_are) AS n", false)->from('emp_empleado')->where(array('emp_estado' => 1, 'emp_id_are' => $fila['are_id'], 'emp_id_emr' => $this->tank_auth->get_empresa_id()))->get()->row_array();
                $n = ($n_empleados['n'] != 0) ? ' (<span class="n_empleados_area">' . $n_empleados['n'] . '</span>)' : '';
                //preguntar por los puestos
                $plazas = $this->plazas_area($fila['are_id']);

                $tiene_dep = true;
                if ($fila['are_padre'] > 0 && $fila['are_id_nia'] == 7) {
                    $tiene_dep = $this->gsatelite->get_tabla('are_area', array('are_padre' => $fila['are_padre'], 'are_id_nia !=' => 7));
                }
                if ($esJSON) {
                    $tipo_area = ($fila['are_id_nia'] == 7) ? (($tiene_dep) ? 'staff' : 'subordinate') : 'subordinate';
                    $extra_tipo = ($fila['are_id_nia'] == 7) ? ', "subtype" : "dashed", "box_color" : "#a0cea7"' : '';
                    $cadena .= '{ "id": "area_' . $fila['are_id'] . '", "title": "' . $prefijo . $fila['are_nombre'] . '", "subtitle": "", "type":"' . $tipo_area . '"' . $extra_tipo;
                    $cadena .= $this->crear_arbol_json($fila['are_id'], $prefijo . $prefijo, $extra_where, $esJSON);
                } else {
                    $tipo_area = ($fila['are_id_nia'] == 7) ? (($tiene_dep) ? 'itemType: primitives.orgdiagram.ItemType.Assistant, adviserPlacementType: primitives.common.AdviserPlacementType.Right,' : '') : '';
                    $extra_tipo = ($fila['are_id_nia'] == 7) ? 'itemTitleColor: "Green",' : '';

                    $cadena .= 'new primitives.orgdiagram.ItemConfig({ id: ' . $fila['are_id'] . ', parent: ' . $padre . ',' . $tipo_area . $extra_tipo;
                    $cadena .= 'title: "' . $fila['are_nombre'] . '", description: "",image: "' . base_url('media/user.png') . '"';
                    $cadena .= '/*,templateName: "DepartmentTitleTemplate"*/ }), ';
                    $cadena .= $this->crear_arbol_json($fila['are_id'], $prefijo . $prefijo, $extra_where, $esJSON);
                }
            }
            $cadena .= ($esJSON) ? '] },' : '';
        } else {
            $cadena .= ($esJSON) ? " }," : '';
        }
        return $cadena;
    }

    /**
     * @author René Castaneda
     * @since 2018-07-07
     * @return / Description: Generar query para niveles de area y retornar las opciones.
     */
    public function get_select_areas_niveles($preseleccion = null)
    {
        $query_nivel = $this->db->select("nia_nivel_area.*")
            ->from("nia_nivel_area")
            ->join("are_area", 'are_id_nia = nia_id')
            ->group_by('nia_id')
            ->order_by('nia_orden')
            ->get()
            ->result_array();

        $id_empresa = $this->tank_auth->get_empresa_id();
        $array_select = array();
        foreach ($query_nivel as $registro) {
            $datos_nivel['nivel'] = $registro;
            $datos_nivel['opciones'] = $this->gsatelite->get_dropdown('are_area', 'are_nombre', 'areas', array('are_estado' => 1, 'are_id_nia' => $registro['nia_id'], "are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)" => null), $preseleccion, null, null, true);
            $array_select[] = $datos_nivel;
        }
        return $array_select;
    }

    /**
     * @param $padre
     * @param $prefijo
     * @param null $aplicar_where_in
     * @param false $esJSON
     * @param int $plazas "Flag para incluir en el Subtitulo las Plazas con empleados"
     * @return string
     * En esta funcion estamos generando el nivel 2 y 3 del arbol para area plaza
     *
     */
    public function crear_arbol_area($padre, $prefijo, $aplicar_where_in = null, $esJSON = false, $plazas = 0, $cantidad = null)
    {
        $cadena = "";
        $max = 0;
        $q = $this->get_hijos_area_modificado($padre, null);
        if ($q) {
            if (isset($q[0]['are_id']) > 0 and $q[0]['are_id'] > 0) {
                $cadena .= ($esJSON) ? ', "children": [' : "<ul>";
                foreach ($q as $fila) {
                    //preguntar por el empleado de la plaza
                    $idare = (trim($fila['ids_areas']) != '') ? $fila['ids_areas'] : '0';

                    $this->db->join('plz_plaza', 'plz_id = emp_id_plz', 'inner');
                    $n_empleados = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1, "emp_id_are in (" . $idare . ")" => null));

                    $empleado = (count($n_empleados) > 0) ? $n_empleados[0] : '';
                    $max = (count($n_empleados) > $max) ? count($n_empleados) : $max;
                    $n = (count($n_empleados) > 0) ? ' <span class="totalEmp">[' . count($n_empleados) . "]</span>" : '';

                    $subtitulo = array();
                    if ($esJSON) {
                        $n = (count($n_empleados) > 0) ? " [<span class='conteo_nplazas'>" . count($n_empleados) . "</span>]" : '';
                        // if ($plazas == 1) { 
                        //esta condicional fue cambiada debido a que en el nivel 3 de un organigrama de area plaza este no estaba mostrando los nombres de los empleados y sus plazas
                        if ($plazas > 0) { 

                        foreach ($n_empleados as $emp) {
                            $subtitulo[] = array('emp_nombre' => $emp['emp_nombre'] . " " . $emp['emp_apellido'] . ' - ' . $emp['plz_nombre']);
                        }
                    }

                        // }
                        //este cambio fue efectuado el dia 15 de marzo del 2023
                    }
                    $n_emp = '';
                    // var_dump($esJSON);die();
                    if ($esJSON) {
                        $tiene_dep = true;
                        $tiene_hno = false;
                        //if ($fila['are_id_padre'] > 0 && $fila['plz_es_staff'] == 1) {
                        if ($fila['are_padre'] > 0) { //if ($fila['are_padre'] > 0 && $fila['are_id'] == 3) {
                            $mas_hijos = $this->gsatelite->get_tabla('are_area', array('are_padre' => $fila['are_padre'], 'are_id != ' => $fila['are_id']));
                            if (count($mas_hijos) > 0) {
                                $tiene_hno = true;
                            }
                            // $tiene_dep = $this->gsatelite->get_tabla('are_area',array('are_padre'=>$fila['are_padre']/*,'(plz_es_staff !=1 or plz_es_staff IS NULL)'=>null*/));
                        }
                        // $tipo_area = ($fila['are_es_staff'] == 1)? (($tiene_dep)? 'stafftop':'subordinate'):'subordinate';
                        $tipo_area = ($fila['are_es_staff'] == 1) ? (($tiene_hno) ? 'staff' : 'stafftop') : 'subordinate'; //stafftop
                        //$tipo_area = ($fila['are_id'] == 3)? (($tiene_dep)? 'staff':'subordinate'):'subordinate';
                        $extra_tipo = ($fila['are_es_staff'] == 1) ? ', "subtype" : "dashed", "box_color" : "#a0cea7"' : '';
                        //$extra_tipo = ($fila['are_id'] == 3)? ', "subtype" : "dashed", "box_color" : "#a0cea7"':'';
                        $cadena .= '{ "id": "are_' . $fila['are_id'] . '", "title": "' . $prefijo . $fila['are_nombre'] . $n . '", "subtitle": ' . json_encode($subtitulo) . ', "type":"' . $tipo_area . '"' . $extra_tipo;
                        $cadena .= $this->crear_arbol_area($fila['are_id'], $prefijo . $prefijo, $aplicar_where_in, $esJSON);
                        $son = $this->estructura_organizativa_model->crear_arbol_area($fila['are_id'],  $prefijo . $prefijo, $aplicar_where_in, $esJSON,  $plazas, 1);
                        $max = ((int) $son > $max) ? (int) $son : $max;
                    } else {
                        $cadena .= '<li>' . $prefijo . $fila['are_nombre'] . $n .  $n_emp;
                        $cadena .= $this->crear_arbol_area($fila['are_id'], $prefijo . $prefijo, $aplicar_where_in, $esJSON);
                    }
                }
                $cadena .= ($esJSON) ? '] },' : '</ul></li>';
            }
        } else {
            $cadena .= ($esJSON) ? "}," : "</i>";
        }
        if ($cantidad != null) {
            return $max;
        } else {
            return $cadena;
        }
    }

    function get_hijos_area_modificado($padre, $where_in)
    {

        $reg_padre = $this->gsatelite->get_tabla('are_area', array('are_id' => $padre));

        $reg_padre_ids = $this->gsatelite->get_tabla('are_area', array('are_padre' => $reg_padre[0]['are_padre'], 'are_nombre' => $reg_padre[0]['are_nombre']));

        $idss = array_column($reg_padre_ids, 'are_id');
        //print_r($idss); die();

        $query = $this->db->select('*, COUNT(are_id) AS total, group_concat(DISTINCT are_id) AS ids_areas')
            ->from('are_area')
            ->join('mxr_empresaxarea', 'mxr_id_are = are_id')
            ->where('are_estado', 1)
            ->where('mxr_id_emr', $this->tank_auth->get_empresa_id())
            ->where('are_padre', $padre);

        $this->db->group_by('are_nombre');
        $this->db->order_by('are_id', 'asc');
        //preguntar si hay padres agrupados con hijos.
        $this->db->having('total >', 1);

        $resultado = $query->get()->result_array();

        if (count($resultado) > 0) { //REPETIR LA QUERY PERO EN ESTA OCACIÓN NO AGRUPADA

            $incluirlo = array(0);
            foreach ($resultado as $fpadre) {
                $nhiijos = $this->db->select("COUNT(are_id) AS total, GROUP_CONCAT(DISTINCT are_padre) idpdres")->from('are_area')->where("are_padre in (" . $fpadre['ids_areas'] . ")")->get()->result_array();
                if (count($nhiijos) > 0 && $nhiijos[0]['total'] > 0) {
                    $incluirlo[] = $nhiijos[0]['idpdres'];
                }
            }


            $query = $this->db->select('*, COUNT(are_id) AS total, group_concat(DISTINCT are_id) AS ids_areas')
                ->from('are_area')
                ->join('mxr_empresaxarea', 'mxr_id_are = are_id')
                ->where('are_estado', 1)
                ->where('mxr_id_emr', $this->tank_auth->get_empresa_id())
                ->where('are_padre', $padre)
                ->where("are_area.are_id not in (" . implode(',', $incluirlo) . ")", null, false);

            $this->db->group_by('are_nombre');
            $this->db->order_by('are_id', 'ASC');
            $resultado1 = $query->get()->result_array();

            $query = $this->db->select('*, COUNT(are_id) AS total, group_concat(DISTINCT are_id) AS ids_areas')
                ->from('are_area')
                ->join('mxr_empresaxarea', 'mxr_id_are = are_id')
                ->where('are_estado', 1)
                ->where('mxr_id_emr', $this->tank_auth->get_empresa_id())
                ->where('are_padre', $padre)
                ->where("are_area.are_id in (" . implode(',', $incluirlo) . ")", null, false);

            $this->db->group_by('are_id');
            $this->db->order_by('are_id', 'asc');
            $resultado2 = $query->get()->result_array();

            $resultado = array_merge($resultado1, $resultado2);
        } else {
            $query = $this->db->select('*, COUNT(are_id) AS total, group_concat(DISTINCT are_id) AS ids_areas')
                ->from('are_area')
                ->join('mxr_empresaxarea', 'mxr_id_are = are_id')
                ->where('are_estado', 1)
                ->where('mxr_id_emr', $this->tank_auth->get_empresa_id())
                ->where('are_padre', $padre);

            $this->db->group_by('are_nombre');
            $this->db->order_by('are_id', 'asc');

            $resultado = $query->get()->result_array();
        }

        return $resultado;
    }
}
