<?php

/**
 * 
 */
class Entradas_model extends CI_Model
{

    /**
     * Entradas_model::__construct()
     * 
     * @return
     */
    function __construct()
    {
        $this->load->database();
        date_default_timezone_set('America/El_Salvador');
    }

    function get_documentosxproveedor($prov_id)
    {
        $this->db->select('tpd_nombre, dxp_numero, dxp_id_prv')
                ->from('dxp_documentoxprov')
                ->join('tpd_tipo_documento', 'tpd_id=dxp_id_tpd', 'left')
                ->where( 'dxp_id_prv', $prov_id)
                ;

        $query = $this->db->get();
        return $query->result_array();
    }

    function get_proveedor_contrato($con_id)
    {
        $this->db->select('prv_nombre')
                ->from('con_contrato_gasol')
                ->join('prv_proveedor', 'prv_id = con_id_prv', 'left')
                ->where('con_id', $con_id)
            ;
        $query = $this->db->get()->row_array();
        //die(print_r($this->db->last_query() ));
        return $query;
    }

    function get_detalle_vehiculo($id_vehiculo)
    {
        $this->db->select()
                ->from('veh_vehiculo')
                ->join('mrv_marca', 'mrv_id = veh_id_mrv', 'left')
                ->join('mdv_modelo_veh', 'mdv_id = veh_id_mdv', 'left')
                ->join('tvh_tipo_vehiculo', 'tvh_id = veh_id_tvh', 'left')
                ->join('tpm_tipo_motor', 'tpm_id = veh_id_tpm', 'left')
                ->join('clv_color_vehiculo', 'clv_id = veh_id_clv', 'left')
                ->join('trm_transmision', 'trm_id = veh_id_trm', 'left')
                ->join('trc_traccion', 'trc_id = veh_id_trc', 'left')
                ->join('tpl_tipo_llanta', 'tpl_id = veh_id_tpl', 'left')
                ->join('tpc_tipo_combustible', 'tpc_id = veh_id_tpc', 'left')
                ->join('cfv_clasif_vehiculo', 'cfv_id = veh_id_cfv', 'left')
                ->join('stv_status_vehiculo', 'stv_id = veh_id_stv', 'left')
                ->join('tpf_tipo_fondo', 'veh_id_tpf=tpf_id', 'left')
                ->where('veh_id', $id_vehiculo)
                ;
        $query = $this->db->get()->row();
        return $query;        
    }

    function get_detalle_ticket($where=null, $id_ubicacion=null, $id_ticket=null)
    {
        $this->db->select()
                ->from('tkt_ticket')
                ->join('dtt_detalle_ticket_trans', 'tkt_id = dtt_id_tkt', 'left')
                ->join('tvh_tipo_vehiculo', 'tvh_id = dtt_id_tvh', 'left')
                ->join('flu_flujo', 'flu_id = tkt_id_flu', 'left')
                ->join('esk_estado_ticket', 'esk_id = tkt_id_esk', 'left')
                ->join('prd_prioridad', 'prd_id = tkt_id_prd', 'left')
                ->join('sue_sub_especialidad', 'sue_id = tkt_id_sue', 'left')
                ->join('users', 'users.id = tkt_usuario_solicita','left')
                ->join('emp_empleado', 'emp_id = users.usu_id_emp','left')
                ;
        
            if(!empty($where)){
            $this->db->where($where);
            }        
            if(!empty($id_ubicacion)){
                $this->db->where('dtt_id IN (SELECT DISTINCT uxt_id_dtt FROM uxt_ubicaxticket WHERE uxt_id_ubt="'.$id_ubicacion.'")');
            } else {
                if(!empty($id_ticket)){
                    $this->db->where('tkt_id',$id_ticket);
                }
            }

            $query = $this->db->get()->result_array();
            return $query;        
    }

    function get_detalle_ticket_mantto($id_ticket=null)
    {
        $this->db->select()
                ->from('tkt_ticket')
                ->join('dtm_detalle_ticket_mantto', 'tkt_id = dtm_id_tkt', 'left')
                ->join('veh_vehiculo', 'veh_id = dtm_id_veh', 'left')
                ->join('flu_flujo', 'flu_id = tkt_id_flu', 'left')
                ->join('esk_estado_ticket', 'esk_id = tkt_id_esk', 'left')
                ->join('prd_prioridad', 'prd_id = tkt_id_prd', 'left')
                ->join('sue_sub_especialidad', 'sue_id = tkt_id_sue', 'left')
                ->join('tsm_tipo_sol_mantto', 'tsm_id = dtm_id_tsm', 'left')
                ->join('tpf_tipo_fondo','veh_id_tpf = tpf_id','left')
                ->where('tkt_id', $id_ticket)
                ;
        
            $query = $this->db->get()->result_array();
            return $query;        
    }

    function get_valesxasignacion($id_srv)
    {
        $this->db->select('vxg_inicio, vxg_fin', false)
                ->from('vxg_valexgestion_trans')
                ->where('vxg_id_srv', $id_srv)
                ;
        
        $query = $this->db->get()->result_array();
        $query_vxg = $this->db->last_query();

        // Segunda consulta (Vales por gestion de combustible)

       $this->db->select('vxc_inicio, vxc_fin', false)
        ->from('vxc_valesxgestion_comb')
        ->where('vxc_id_srv', $id_srv)
        ;
        
        $query = $this->db->get()->result_array();
        $query_vxc = $this->db->last_query();    

        $query_final = $this->db->query("SELECT * FROM (".$query_vxg." union ".$query_vxc .") AS vales ORDER BY vxg_inicio ASC")->result_array(); 
        return $query_final;           

    }

        function get_detalle_ticket_combustible($id_ticket=null)
    {
        $this->db->select()
                ->from('tkt_ticket')
                ->join('dtc_detalle_ticket_combustible', 'tkt_id = dtc_id_tkt', 'left')
                ->join('tpc_tipo_combustible',' tpc_id = dtc_id_tpc', 'left')
                ->join('veh_vehiculo', 'veh_id = dtc_id_veh', 'left')
                ->join('flu_flujo', 'flu_id = tkt_id_flu', 'left')
                ->join('esk_estado_ticket', 'esk_id = tkt_id_esk', 'left')
                ->join('prd_prioridad', 'prd_id = tkt_id_prd', 'left')
                ->join('sue_sub_especialidad', 'sue_id = tkt_id_sue', 'left')
                ->join('tpf_tipo_fondo','veh_id_tpf=tpf_id','left')
                ->join('users','tkt_usuario_solicita=id', 'left')
                ->join('emp_empleado', 'usu_id_emp=emp_id', 'left')
                ->join('are_area', 'are_id=emp_id_are', 'left')
                ->where('tkt_id', $id_ticket)
                ;
        
            $query = $this->db->get()->result_array();
            return $query;        
    }

    public function get_all_tickets($fecha_inicio=null, $fecha_fin=null, $solicitante=0, $destino=null, $estatus=null, $tipo_consulta)
    {

        
        $this->db->select("dtt_fecha_salida, are_nombre, tkt_descripcion, NULL AS emp_dependencia, CONCAT_WS(' ',emp_nombre, emp_apellido) as nombre, null as gtc_id, null as gmt_id, gtr_id, dtt_encargado, dtt_descripcion, esk_nombre, tkt_id, (SELECT vxg_id FROM vxg_valexgestion_trans WHERE vxg_id_gtr = gtr_id LIMIT 1 ) AS vxg_id, 'Transporte' accion, 'editar_ticket' url", false)
                ->from('dtt_detalle_ticket_trans')
                ->join('tkt_ticket', 'tkt_id = dtt_id_tkt', 'left')
                ->join('gtr_gestion_transporte', 'gtr_id_tkt = tkt_id', 'left')
                ->join('esk_estado_ticket', 'esk_id = tkt_id_esk', 'left')
                ->join('users', 'id = tkt_usuario_solicita', 'left')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                ->join('are_area', 'are_id = emp_id_are', 'left')
                ->where('tkt_estado',1)
                ;
        if(!empty($fecha_inicio)){
            $this->db->where('dtt_fecha_salida >= ', $fecha_inicio);
        }
        if(!empty($fecha_fin)){
            $this->db->where('dtt_fecha_salida <= ', $fecha_fin);
        }
        if(!empty($solicitante)){
            $this->db->where('tkt_usuario_solicita = ', $solicitante);   
        }        
        if(!empty($destino)){
            $this->db->where('dtt_id IN (SELECT DISTINCT uxt_id_dtt FROM uxt_ubicaxticket WHERE uxt_id_ubt="'.$destino.'")');
        }
        if(!empty($estatus)){
            $this->db->where('esk_id', $estatus);
        }

        $query = $this->db->get()->result_array();
        $query_dtt = $this->db->last_query();
     
        // Second query

        $this->db->select('dtm_fecha_sugerida, are_nombre, tkt_descripcion, NULL AS emp_dependencia, CONCAT_WS(" ",emp_nombre, emp_apellido) as nombre, null as gtc_id, gmt_id, null as gtr_id, null as encargado, dtm_detalle_suministro, esk_nombre, tkt_id, null as vxg_id, "Mantenimiento" accion, "editar_ticket_mantto" url', false)
                ->from('dtm_detalle_ticket_mantto')
                ->join('tkt_ticket', 'tkt_id = dtm_id_tkt', 'left')
                ->join('esk_estado_ticket', 'esk_id = tkt_id_esk', 'left')
                ->join('gmt_gestion_mantto', 'gmt_id_dtm = dtm_id', 'left')
                ->join('users', 'id = tkt_usuario_solicita', 'left')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                ->join('are_area', 'are_id = emp_id_are', 'left')
                ->where('tkt_estado',1)
                ;
        
        if(!empty($fecha_inicio)){
            $this->db->where('dtm_fecha_sugerida >= ', $fecha_inicio);
        }
        if(!empty($fecha_fin)){
            $this->db->where('dtm_fecha_sugerida <= ', $fecha_fin);
        }
        if(!empty($solicitante)){
            $this->db->where('tkt_usuario_solicita = ', $solicitante);   
        }
        if(!empty($destino)){
            //$this->db->where('dtt_id IN (SELECT DISTINCT uxt_id_dtt FROM uxt_ubicaxticket WHERE uxt_id_ubt="'.$destino.'")');
        }
        if(!empty($estatus)){
            $this->db->where('esk_id', $estatus);
        }

        $query      = $this->db->get()->result_array();
        $query_dtm  = $this->db->last_query();

        // Third query

        $this->db->select('dtc_fecha_solicitud, are_nombre, tkt_descripcion, NULL AS emp_dependencia, CONCAT_WS(" ",emp_nombre, emp_apellido) as nombre, gtc_id,  null as gtr_id, null as gmt_id, null as encargado, null as descripcion, esk_nombre, tkt_id, null as vxg_id, "Combustible" accion, "editar_ticket_combustible" url', false)
                ->from('dtc_detalle_ticket_combustible')
                ->join('tkt_ticket', 'tkt_id = dtc_id_tkt', 'left')
                ->join('esk_estado_ticket', 'esk_id = tkt_id_esk', 'left')
                ->join('gtc_gestion_combustible', 'gtc_id_dtc = dtc_id', 'left')
                ->join('users', 'id = tkt_usuario_solicita', 'left')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                ->join('are_area', 'are_id = emp_id_are', 'left')
                ->where('tkt_estado',1)
                ;
        
        if(!empty($fecha_inicio)){
            $this->db->where('dtc_fecha_solicitud >= ', $fecha_inicio);
        }
        if(!empty($fecha_fin)){
            $this->db->where('dtc_fecha_solicitud <= ', $fecha_fin);
        }
        if(!empty($solicitante)){
            $this->db->where('tkt_usuario_solicita = ', $solicitante);   
        }
        if(!empty($destino)){
            //$this->db->where('dtt_id IN (SELECT DISTINCT uxt_id_dtt FROM uxt_ubicaxticket WHERE uxt_id_ubt="'.$destino.'")');
        }
        if(!empty($estatus)){
            $this->db->where('esk_id', $estatus);
        }
        $this->db->order_by('tkt_id', 'desc');
        $query      = $this->db->get()->result_array();
        $query_dtc  = $this->db->last_query();


        if ($tipo_consulta == 0) {
           $query_final = $this->db->query($query_dtt." union ".$query_dtm ." union ".$query_dtc)->result_array();
        }elseif($tipo_consulta == 1){
            $query_final = $this->db->query($query_dtc)->result_array();
        }elseif($tipo_consulta == 2){
            $query_final = $this->db->query($query_dtm)->result_array();
        }elseif($tipo_consulta == 3){
            $query_final = $this->db->query($query_dtt)->result_array();
        }

       

        return $query_final;        
    
    }

    public function get_detalle_ticket_edicion($id_ticket=0)
    {
        $this->db->select() 
                ->from('gtr_gestion_transporte')
                ->join('veh_vehiculo', 'veh_id = gtr_id_veh', 'left')
                ->join('tvh_tipo_vehiculo', 'tvh_id = veh_id_tvh', 'left')
                ->join('tpf_tipo_fondo','veh_id_tpf=tpf_id','left')
                ->where('gtr_id_tkt', $id_ticket)
                ->where('gtr_estado !=',0)
            ;
            
            $query = $this->db->get()->result_array();
            return $query;        
    }

    public function get_detalle_ticket_mantto_edicion($id_detalle=0)
    {
        
        $this->db->select() 
                ->from('gmt_gestion_mantto')
                ->join('con_contrato_gasol', 'con_id = gmt_id_con', 'left')
                //->join('tmn_tipo_mantto', 'gmt_id_tmn = tmn_id', 'left')
                ->where('gmt_id_dtm', $id_detalle)
            ;
            
            $query = $this->db->get()->row_array();
            return $query;        

    }

    public function tabla_vales_gestion($id_gtr)
    {
        $this->db->select('con_id, srv_id, vxg_id, vxg_fin, vxg_inicio, srv_valor, con_nombre, srv_nombre') 
                    ->from('vxg_valexgestion_trans')
                    ->join('srv_serie_vale', 'srv_id = vxg_id_srv', 'left')
                    ->join('con_contrato_gasol', 'con_id = srv_id_con', 'left')
                    ->where('vxg_id_gtr', $id_gtr)
                   ;

             $query = $this->db->get()->result_array();
             return $query;       
    }

    public function tabla_vales_gestion_combustible($id_gtc=0)
    {
        
        $this->db->select('con_id, srv_id, vxc_id, vxc_fin, vxc_inicio, srv_valor, con_nombre, srv_nombre, vxc_monto') 
                    ->from('vxc_valesxgestion_comb')
                    ->join('srv_serie_vale', 'srv_id = vxc_id_srv', 'left')
                    ->join('con_contrato_gasol', 'con_id = srv_id_con', 'left')
                    ->where('vxc_id_gtc', $id_gtc)
                   ;

            $query = $this->db->get()->result_array();
             return $query;       
    }


    function get_detalle_solicitud($fecha_ini=null, $fecha_fin=null, $id_soli=null){
        $id_usu_log = $this->tank_auth->get_user_id();
                    $this->db->select(' *, GROUP_CONCAT(ubt_nombre SEPARATOR ", ") As destino', FALSE)
                           ->from('dtt_detalle_ticket_trans')
                           ->join('tkt_ticket','tkt_id=dtt_id_tkt')
                           ->join('uxt_ubicaxticket','uxt_id_dtt=dtt_id')
                           ->join('ubt_ubicacion_tarea','uxt_id_ubt=ubt_id')
                           ->join('esk_estado_ticket','tkt_id_esk=esk_id','left');
                $this->db->where('dtt_usu_creacion', $id_usu_log);    
                if($fecha_ini != '' && $fecha_fin != ''){
                    $this->db->where('dtt_fecha_salida >= ',$fecha_ini);
                    $this->db->where('dtt_fecha_salida <= ',$fecha_fin);
                }
                if($id_soli > 0){
                    $this->db->where('tkt_id',$id_soli);
                }
                $this->db->where('tkt_estado',1);
                $this->db->group_by('tkt_id');
                $this->db->order_by('tkt_id', 'desc');
                $query = $this->db->get()->result_array();
                //die(print_r($this->db->last_query()));
                return $query;  
    }


    function get_ubicacion($id_soli)
    {
        $this->db->select()
                ->from('tkt_ticket')
                ->join('dtt_detalle_ticket_trans','tkt_id = dtt_id_tkt')
                ->join('uxt_ubicaxticket','dtt_id=uxt_id_dtt')
                ->join('ubt_ubicacion_tarea','uxt_id_ubt=ubt_id')
                ->where('tkt_id',$id_soli);

            $query=$this->db->get()->result_array();
            return $query;
    }
    function get_anexos($id_soli)
    {

        $this->db->select()
                 ->from('tkt_ticket')
                 ->join('axt_anexoxticket','tkt_id = axt_id_tkt')
                 ->join('anx_anexo','anx_id=axt_id_anx')
                 ->where('tkt_id',$id_soli);
        $query=$this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $query;   
    }

    function get_solicitud_mantto($fecha_ini=null,$fecha_fin=null,$id_soli=null, $es_admin=null){
        $id_usu_log = $this->tank_auth->get_user_id();
        $this->db->select()
                 ->from('tkt_ticket')
                 ->join('dtm_detalle_ticket_mantto','tkt_id=dtm_id_tkt')
                 ->join('tsm_tipo_sol_mantto','dtm_id_tsm = tsm_id')
                 ->join('veh_vehiculo','dtm_id_veh= veh_id', 'left')
                 ->join('esk_estado_ticket','esk_id=tkt_id_esk', 'left')
                 ->join('tpf_tipo_fondo', 'veh_id_tpf=tpf_id', 'left')
                 ->where('tkt_estado',1);
        $this->db->where('dtm_usu_creacion', $id_usu_log);
                 if($fecha_ini != '' && $fecha_fin != ''){
                    $this->db->where('dtm_fecha_sugerida >= ',$fecha_ini);
                    $this->db->where('dtm_fecha_sugerida <= ',$fecha_fin);
                }
                if($id_soli > 0){
                    $this->db->where('tkt_id',$id_soli);
                }
                if($es_admin!=1) $this->db->where('tkt_usuario_solicita', $this->tank_auth->get_user_id());

                 $this->db->group_by('tkt_id');
                 $this->db->order_by('tkt_id','desc');
                $query = $this->db->get()->result_array();
                //die(print_r($this->db->last_query()));
                return $query;  

    }

    function get_tipo_url($id_tkt)
    {
        $this->db->select()
                 ->from('axt_anexoxticket')
                 ->join('anx_anexo','axt_id_anx=anx_id')
                 ->where('axt_id_tkt', $id_tkt)
                 ->where('anx_url NOT LIKE', '%uploads/%');
      
        $query = $this->db->get()->result_array();
    //die(print_r($this->db->last_query()));
        return $query;  
    }


    function detalle_combustible($fecha_ini=null,$fecha_fin=null,$id_soli=null, $tipo=null)
    {
        $id_usu_log = $this->tank_auth->get_user_id();
        $this->db->select()
                 ->from('tkt_ticket')
                 ->join('dtc_detalle_ticket_combustible','dtc_id_tkt = tkt_id')
                 ->join('mot_motorista','dtc_id_mot= mot_id','left')
                 ->join('veh_vehiculo','dtc_id_veh = veh_id','left')
                 ->join('tpc_tipo_combustible','tpc_id= veh_id_tpc','left')
                 ->join('esk_estado_ticket','tkt_id_esk = esk_id','left')
                 ->join('tpf_tipo_fondo','veh_id_tpf=tpf_id', 'left')
                 ->where('tkt_estado',1);
        $this->db->where('dtc_usu_creacion', $id_usu_log);
            if($fecha_ini != '' && $fecha_fin != ''){
                if($tipo==2){
                 $this->db->where('dtc_periodo_desde >= ',$fecha_ini);
                 $this->db->where('dtc_periodo_desde <= ',$fecha_fin);      
                } else {
                 $this->db->where('dtc_fecha_solicitud >= ',$fecha_ini);
                 $this->db->where('dtc_fecha_solicitud <= ',$fecha_fin);   
                }
            }
            if($id_soli > 0){
                 $this->db->where('tkt_id',$id_soli);
            }
                 $this->db->group_by('tkt_id');
                 $this->db->order_by('tkt_id','desc');
                 $query = $this->db->get()->result_array();
                //die(print_r($this->db->last_query()));
                return $query;   
    }

    function obtener_combustible($id_veh)
    {
        $this->db->select('tpc_id, tpc_nombre, veh_id_tpf, tpf_nombre')
                 ->from('veh_vehiculo')
                 ->join('tpc_tipo_combustible','veh_id_tpc=tpc_id')
                 ->join('tpf_tipo_fondo','veh_id_tpf=tpf_id', 'left')
                 ->where('veh_id',$id_veh);
        $query= $this->db->get()->row();
        //die(print_r($this->db->last_query()));
        return $query;
    }

    function get_detalles_combustible($id_soli=null)
    {
        $this->db->select()
                 ->from('tkt_ticket')
                 ->join('dtc_detalle_ticket_combustible','dtc_id_tkt=tkt_id')
                 ->join('ddt_detalle_destino','ddt_id_dtc=dtc_id')
                 ->where('tkt_id',$id_soli)
                 ->where('ddt_estado',1);
         $query= $this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $query;
    }

    function get_facturas($id_soli=null)
    {
        $this->db->select()
                 ->from('tkt_ticket')
                 ->join('dtc_detalle_ticket_combustible','dtc_id_tkt=tkt_id')
                 ->join('dtf_detalle_factura','dtf_id_dtc=dtc_id')
                 ->where('tkt_id',$id_soli)
                 ->where('dtf_estado',1);
         $query= $this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $query;
    }

    function obligcacionxcontrato($id_contrato)
    {
        $this->db->select()
                 ->from('obc_obligacion_contrato')
                 ->join('seg_seguimiento_cont','seg_id_obc=obc_id')
                 ->where('obc_id_con',$id_contrato)
                 ;
         $query= $this->db->get()->result_array();
        return $query;   
    }


   /**
   * @author Christian Menendez
   * @return 
   */

  function get_solicitud_transporte($id_solicitud)
  {

    $query="
   SELECT
    date_format(
        dtt.dtt_fecha_salida,
        '%d/%m/%Y'
    ) fecha,
    dtt_hora_salida,
    dtt_id_tkt,
    dtt_fecha_creacion,
    dtt.dtt_cantidad_per,
    dtt.dtt_actividad AS destino_actividad,
    dtt.dtt_actividad AS destino,
    dtt.dtt_descripcion,
    esk.esk_nombre AS estado,
    mrc.mrc_nombre,
    
    (SELECT
      GROUP_CONCAT(ubt_nombre SEPARATOR ', ')
        FROM
            uxt_ubicaxticket
          INNER JOIN ubt_ubicacion_tarea ON ubt_id = uxt_id_ubt AND ubt_estado = 1
        WHERE
            uxt_id_dtt = dtt.dtt_id
  GROUP BY 'all') AS ubicaciones
FROM
 dtt_detalle_ticket_trans AS dtt

LEFT JOIN tkt_ticket as tkt
ON tkt_id = dtt.dtt_id_tkt

LEFT JOIN esk_estado_ticket as esk
on esk_id = tkt.tkt_id_esk

LEFT JOIN mrc_medio_recepcion AS mrc
ON mrc_id = tkt.tkt_id_mrc

WHERE
    dtt.dtt_id = ".$id_solicitud."";

    $resultado=$this->db->query($query)->result_array();
    return $resultado;
  }


    /**
    * @author Christian Menendez
    * @return 
    */

    function get_control_combustible($fecha_inicio=null, $fecha_fin=null)
    {

        $query="

        SELECT
        DATE_FORMAT(vxc.vxc_fecha_creacion, '%d-%m-%Y') fecha,
        tkt.tkt_id num_solicitud,
        DATE_FORMAT(dtc.dtc_periodo_desde,'%d-%m-%Y') fecha_inicio,
        HOUR (dtc.dtc_periodo_desde) AS hora,
        CONCAT_WS(' ',emp.emp_nombre,emp.emp_apellido) AS solicitante,
        veh.veh_placa,
        srv.srv_inicio serie_inicio,
        srv.srv_fin serie_fin,
        (vxc.vxc_fin - vxc.vxc_inicio + 1) AS cantidad,
        (SELECT SUM((o.vxc_fin - o.vxc_inicio) + 1) FROM vxc_valesxgestion_comb o WHERE o.vxc_estado = 1 AND o.vxc_fecha_creacion < vxc.vxc_fecha_creacion AND o.vxc_id_srv = srv.srv_id) AS utilizados,
        srv.srv_cantidad AS gran_total,
        (vxc_monto * (vxc.vxc_fin - vxc.vxc_inicio + 1)) AS total,
        dtc.dtc_destino,
        (vxc.vxc_fin - vxc.vxc_inicio + 1) AS salida,
        ddt.ddt_actividad,
        con.con_codigo,
        CONCAT(prv_nombre,' ' ,prv_apellido) AS nombre_proveedor
        FROM
    (
        (
            (
                (
                    (
                        (
                            (srv_serie_vale srv) LEFT JOIN vxc_valesxgestion_comb vxc ON srv.srv_id = vxc.vxc_id_srv
                                        LEFT JOIN con_contrato_gasol AS con ON con.con_id = srv.srv_id_con
                                    LEFT JOIN prv_proveedor AS prv ON prv_id = con_id_prv
                        )
                        LEFT JOIN gtc_gestion_combustible gtc ON gtc.gtc_id = vxc.vxc_id_gtc
                    )
                    LEFT JOIN dtc_detalle_ticket_combustible dtc ON dtc.dtc_id = gtc.gtc_id_dtc
                )
                LEFT JOIN veh_vehiculo veh ON veh.veh_id = dtc.dtc_id_veh
            )
            LEFT JOIN tkt_ticket tkt ON tkt.tkt_id = dtc.dtc_id_tkt
        )
        LEFT JOIN emp_empleado emp ON emp.emp_id = tkt.tkt_usuario_solicita
    )
LEFT JOIN ddt_detalle_destino ddt ON ddt.ddt_id_dtc = dtc.dtc_id

";

    if($fecha_inicio!=null && $fecha_fin!=null){
        $query.= " WHERE date_format(vxc_fecha_creacion,'%Y-%m-%d') >= '".$fecha_inicio."' AND date_format(vxc_fecha_creacion,'%Y-%m-%d') <= '".$fecha_fin."'";
    }
    $query.= " ORDER BY vxc.vxc_fecha_creacion ASC";

    $resultado=$this->db->query($query)->result_array();
    return $resultado;
  }


   /**
   * @author Christian Menendez
   * @return 
   */

  function get_seguimientos_contratos($id_solicitud)
  {

 $query="select DISTINCT
    con_id,
    con.con_institucion,
    con.con_vigencia_desde,
  con.con_vigencia_hasta,
    con.con_codigo AS con_codigo,

    CONCAT_WS(' ',' CONTRATO Nº ',con.con_numero, con.con_nombre) AS cod_contrato,

    UPPER(CONCAT_WS(' ',emp.emp_nombre,emp.emp_apellido,', ',are.are_nombre)) AS jefe_transporte,con_resolucion 

    AS numero_resolucion,
    prv.prv_nombre nombre_contratista,

CONCAT_WS(' - ', IFNULL( DATE_FORMAT(con_gar_cum_desde, '%d/%m/%Y'), ' ' ), IFNULL( DATE_FORMAT(con_gar_cum_hasta, '%d/%m/%Y'), ' ' )) AS periodo_garantia, 
CONCAT_WS(' - ', IFNULL( DATE_FORMAT(con_antic_desde, '%d/%m/%Y'), ' ' ), IFNULL( DATE_FORMAT(con_antic_hasta, '%d/%m/%Y'), ' ' )) AS periodo_anticipo, 
CONCAT_WS(' - ', IFNULL( DATE_FORMAT(con_buena_desde, '%d/%m/%Y'), ' ' ), IFNULL( DATE_FORMAT(con_buena_hasta, '%d/%m/%Y'), ' ' )) AS con_buena_desde,
    obc.obc_nombre obligaciones,
    seg_desde,
    seg_hasta
FROM
    (
     (
       (
            (con_contrato_gasol con)
            LEFT JOIN obc_obligacion_contrato obc ON obc.obc_id_con = con.con_id
         )
        INNER JOIN seg_seguimiento_cont seg ON seg.seg_id_obc = obc.obc_id
   ) 
   LEFT JOIN emp_empleado emp ON emp.emp_id = con.con_id_administrador
    )
LEFT JOIN prv_proveedor prv ON prv.prv_id = con.con_id_prv
LEFT JOIN are_area are ON are.are_id = emp_id_are
WHERE
    con_id = ".$id_solicitud.";
";

    $resultado=$this->db->query($query)->result_array();
    return $resultado;
  }


   /**
   * @author Christian Menendez
   * @return 
   */
  function get_solicitud_combustible_departamental($id_solicitud)
  {

 $query="select 
     ddt.ddt_id,
   ddt.ddt_destino AS destino,
   ddt.ddt_actividad AS lugar_visita,
   ddt.ddt_fecha_destino AS fecha_destino,
   ddt.ddt_kilometraje AS kilometraje,
   (SELECT SUM(ddt_kilometraje) FROM ddt_detalle_destino WHERE ddt_id_dtc = ddt.ddt_id_dtc AND ddt_estado = 1)  AS km_total

   FROM ddt_detalle_destino AS ddt
   WHERE ddt.ddt_id_dtc = ".$id_solicitud."
";

    $resultado=$this->db->query($query)->result_array();
    return $resultado;
  }

    /**
    * @author Christian Menendez
    * @return 
    */
    function get_solicitud_combustible($id_solicitud)
    {

    $query="
    SELECT
    dtc.dtc_fecha_creacion AS fecha,
    dtc.dtc_id_tkt,
    esk_nombre AS estado_tkt,
    dtc.dtc_fecha_solicitud AS fecha_salida,
    dtc.dtc_fecha_modificacion AS fecha_actualizacion,
    dtc.dtc_destino AS destino_actividad,
    tpc.tpc_nombre,
    CONCAT_WS(' ',emp.emp_nombre,emp.emp_apellido) AS motorista,
    veh.veh_placa
    FROM
    dtc_detalle_ticket_combustible AS dtc
    JOIN tkt_ticket ON tkt_id = dtc_id_tkt 
    LEFT JOIN esk_estado_ticket ON esk_id = tkt_id_esk 
    LEFT JOIN tpc_tipo_combustible tpc ON tpc.tpc_id = dtc_id_tpc
    LEFT JOIN mot_motorista mot ON mot.mot_id = dtc.dtc_id_mot
    LEFT JOIN emp_empleado emp ON emp.emp_id = mot.mot_empleado
    LEFT JOIN veh_vehiculo veh ON veh_id = dtc.dtc_id_veh
    WHERE    dtc.dtc_id = ".$id_solicitud."
    ";

    $resultado=$this->db->query($query)->result_array();
    return $resultado;
}


   /**
   * @author Christian Menendez
   * @return 
   */

  function get_ejecucion_contratos($fecha_inicio=null, $fecha_fin=null)
  {

 $query="select con.con_numero,
              date_format(con.con_fecha_creacion,  '%Y/%m/%d') as fecha_contrato,  
              date_format(con.con_vigencia_desde,  '%Y/%m/%d') inicio_ejecucion,
              date_format(con.con_vigencia_hasta,  '%Y/%m/%d') fin_contrato
,
              con.con_nombre descripcion,
con.con_institucion
         FROM con_contrato_gasol con 
";

    if($fecha_inicio!=null && $fecha_fin!=null){
        $query.= " WHERE con_fecha_creacion >= '".$fecha_inicio."' AND con_fecha_creacion <= '".$fecha_fin."'";
    }

    $resultado=$this->db->query($query)->result_array();
    return $resultado;
  }
/**
   * @author Christian Menendez
   * @return 
   */

  function get_distribucion_combustible($fecha_inicio=null, $fecha_fin=null)
  {

 $query="select Date_format(vxc.vxc_fecha_creacion, '%Y/%m/%d') fecha, vxc.vxc_id num_vale, concat_ws(',',vxc_inicio,vxc_fin) num_vale2,
           tkt.tkt_id num_recibo,
           con.con_numero num_solicitud,
           tkt.tkt_descripcion,
           Date_format(dtc.dtc_periodo_desde, '%Y/%m/%d')fecha_inicio,
           HOUR(dtc.dtc_periodo_desde)as hora,
           concat(emp.emp_nombre, ' ', emp.emp_apellido) usu_nombreusuario,
           veh.veh_placa,
           srv.srv_inicio serie_inicio,
           srv.srv_fin serie_fin,
           (vxc.vxc_fin - vxc.vxc_inicio +1 ) as cantidad,
           (vxc.vxc_monto * (vxc.vxc_fin - vxc.vxc_inicio +1)) as total,
           dtc.dtc_destino,
           (vxc.vxc_fin - vxc.vxc_inicio) as salida, emp_nombre, emp_apellido, tpf_nombre
     FROM(
          (
           (
            (
             (
              (
               (
                srv_serie_vale srv
               )INNER JOIN vxc_valesxgestion_comb vxc
               ON srv.srv_id = vxc.vxc_id_srv
              )LEFT JOIN gtc_gestion_combustible gtc
              ON gtc.gtc_id = vxc.vxc_id_gtc
             )LEFT JOIN dtc_detalle_ticket_combustible dtc
             ON dtc.dtc_id = gtc.gtc_id_dtc
            )LEFT JOIN veh_vehiculo veh
            ON veh.veh_id = dtc.dtc_id_veh
           )LEFT JOIN tkt_ticket tkt
           ON tkt.tkt_id = dtc.dtc_id_tkt
          )LEFT JOIN users usu
          ON usu.username = tkt.tkt_usuario_solicita
         )LEFT JOIN con_contrato_gasol con
         ON con.con_id = srv.srv_id_con
        LEFT JOIN users us ON us.id=tkt_usuario_solicita
        LEFT JOIN emp_empleado emp ON emp.emp_id = us.usu_id_emp  
        LEFT JOIN tpf_tipo_fondo ON tpf_id=veh_id_tpf   
";
    if($fecha_inicio!=null && $fecha_fin!=null){
        $query.= " WHERE date_format(vxc_fecha_creacion,'%Y-%m-%d') >= '".$fecha_inicio."' AND date_format(vxc_fecha_creacion,'%Y-%m-%d') <= '".$fecha_fin."'";
    }

    $resultado=$this->db->query($query)->result_array();
    
    return $resultado;
  }


/**
   * @author Christian Menendez
   * @return 
   **/

  function get_mision_oficial($id)
  {

 $query=" 
SELECT
    get_parametro('SYS_JEFE_TRANSPORTE') AS jefe_transporte,
    get_parametro('SYS_PUESTO_JEFE_TRANSPORTE') AS puesto_transporte,
    tkt.tkt_id,
    veh.veh_placa,
    veh.veh_ano,
    veh.veh_capacidad,
    mrv.mrv_nombre marca_vehiculo,
    mdv.mdv_nombre modelo_vehiculo,
    clv.clv_nombre color,
    mot.mot_empleado,
    mot.mot_licencia,
    dtt_fecha_salida,
    date_format(dtt_fecha_salida, '%d') dia,
  UPPER(DATE_FORMAT(dtt_fecha_salida,'%M')) AS mes,
  UPPER(DATE_FORMAT(CURDATE(),'%d de %M de %Y')) AS fecha_actual,
    dtt.dtt_actividad,
    tvh.tvh_nombre,
    concat_ws(
        ' ',
        emp.emp_nombre,
        emp.emp_apellido
    ) solicitante,
     CONCAT_WS(' ',encargado.emp_nombre,encargado.emp_apellido) AS encargado,
  CONCAT_WS(' ',autoriza.emp_nombre,autoriza.emp_apellido) AS autoriza,
    are.are_nombre AS cargo_autoriza

  
FROM
    gtr_gestion_transporte gtr
LEFT JOIN veh_vehiculo veh ON veh.veh_id = gtr.gtr_id_veh
LEFT JOIN mrv_marca mrv ON mrv.mrv_id = veh.veh_id_mrv
LEFT JOIN mdv_modelo_veh mdv ON mdv_id = veh.veh_id_mdv
LEFT JOIN clv_color_vehiculo clv ON clv.clv_id = veh.veh_id_clv
LEFT JOIN tkt_ticket tkt ON tkt.tkt_id = gtr.gtr_id_tkt
LEFT JOIN dtt_detalle_ticket_trans dtt ON dtt.dtt_id_tkt = tkt.tkt_id
LEFT JOIN mot_motorista mot ON mot.mot_id = gtr.gtr_id_mot
LEFT JOIN emp_empleado emp ON emp.emp_id = mot.mot_empleado
LEFT JOIN emp_empleado autoriza ON autoriza.emp_id = gtr.gtr_id_autoriza
LEFT JOIN emp_empleado encargado ON encargado.emp_id = dtt.dtt_encargado
LEFT JOIN tvh_tipo_vehiculo tvh ON tvh.tvh_id = veh.veh_id_tvh
LEFT JOIN are_area are ON are.are_id = autoriza.emp_id_are
WHERE
    gtr.gtr_id = ".$id."
GROUP BY
    veh.veh_id;    
";

    $resultado=$this->db->query($query)->result_array();
    return $resultado;
  }


/**
   * @author Christian Menendez
   * @return 
   */

  function get_autorizacion_vehiculo($id)
  {

 $query="select
    tvh.tvh_nombre tipo_veh,
    dtt.dtt_actividad,
  dtt.dtt_fecha_salida AS fecha_solicitud,
  dtt.dtt_hora_salida  AS hora_solicitud,
  dtt.dtt_cantidad_per AS cantidad_personas, 
    veh.veh_placa,
  tkt.tkt_id AS id_ticket,
  CASE  gtr.gtr_modo_combustible WHEN '2' THEN 'Vales' WHEN '1' THEN 'Reserva' ELSE NULL END AS modo_combustible,
    (
        SELECT
            GROUP_CONCAT( CONCAT_WS(' ',vxg_inicio,' al ',vxg_fin) SEPARATOR ', ')
        FROM
            vxg_valexgestion_trans
        WHERE
            vxg_id_gtr = gtr.gtr_id
    AND 
      vxg_estado = 1  
        GROUP BY 'all'
    ) AS series_vales,
  (SELECT srv_valor FROM vxg_valexgestion_trans LEFT JOIN srv_serie_vale ON srv_id = vxg_id_srv WHERE  vxg_id_gtr = gtr.gtr_id AND vxg_estado = 1 LIMIT 1) AS valor,
  (SELECT SUM(vxg_fin - vxg_inicio +1) as suma_vales FROM vxg_valexgestion_trans WHERE  vxg_id_gtr = gtr.gtr_id AND vxg_estado = 1) AS vales,
  CONCAT_WS(' ',emp.emp_nombre, emp.emp_apellido,',', are.are_nombre) AS solicitante,
  CONCAT_WS(' ',nombre_motorista.emp_nombre, nombre_motorista.emp_apellido) AS motorista,
  CONCAT_WS(' ',usu_crea.emp_nombre, usu_crea.emp_apellido) AS usuario_creacion,
  CONCAT_WS(' ',usu_modifica.emp_nombre, usu_modifica.emp_apellido) AS usuario_modifica,
  gtr.gtr_fecha_creacion AS fecha_modificacion,
  dtt.dtt_fecha_creacion
    
FROM
    gtr_gestion_transporte gtr
LEFT JOIN tkt_ticket tkt ON tkt.tkt_id = gtr.gtr_id_tkt
LEFT JOIN veh_vehiculo veh ON veh.veh_id = gtr.gtr_id_veh
LEFT JOIN tvh_tipo_vehiculo tvh ON tvh.tvh_id = veh.veh_id_tvh
LEFT JOIN tpc_tipo_combustible tpc ON tpc.tpc_id = veh.veh_id_tpc
LEFT JOIN dtt_detalle_ticket_trans dtt ON dtt.dtt_id_tkt = gtr.gtr_id_tkt
LEFT JOIN users user ON user.id = tkt.tkt_usuario_solicita
LEFT JOIN emp_empleado emp ON emp.emp_id = user.usu_id_emp
LEFT JOIN mot_motorista mot ON mot.mot_id = gtr.gtr_id_mot
LEFT JOIN emp_empleado nombre_motorista ON nombre_motorista.emp_id =  mot.mot_empleado 
LEFT JOIN emp_empleado usu_modifica ON usu_modifica.emp_id =  gtr.gtr_usu_creacion
LEFT JOIN emp_empleado usu_crea ON usu_crea.emp_id =  dtt.dtt_usu_creacion
LEFT JOIN are_area are ON are.are_id = emp.emp_id_are

WHERE
    gtr.gtr_id = ".$id."
    
    ";

    $resultado=$this->db->query($query)->result_array();
    return $resultado;
  }



/**
   * @author Christian Menendez
   * @return 
   */

  function get_orden_trabajo($id)
  {

 $query="select gmt.gmt_id_con orden_n,
               con.con_institucion contratistas,
               get_parametro('SYS_JEFE_TRANSPORTE') AS jefe_transporte,
               get_parametro('SYS_PUESTO_JEFE_TRANSPORTE') AS puesto_transporte,
               veh.veh_placa,
               veh.veh_ano,
               veh.veh_capacidad,
               mrv.mrv_nombre marca,
               mdv.mdv_nombre modelo,
               clv.clv_nombre color,
               gmt.gmt_kilometraje kilometraje,
               tmn.tmn_nombre tipo_mantenimiento,
               tsm.tsm_nombre detalle_mant,
               date_format(dtm.dtm_fecha_sugerida, '%d/%m/%Y') fecha_sugerida,
             CONCAT_WS(' ',emp.emp_nombre,emp.emp_apellido) AS admin_contrato
       FROM gmt_gestion_mantto gmt
 LEFT JOIN dtm_detalle_ticket_mantto dtm
         ON gmt.gmt_id_dtm = dtm.dtm_id
 LEFT JOIN con_contrato_gasol con
         ON con.con_id = gmt.gmt_id_con
 LEFT JOIN tsm_tipo_sol_mantto tsm
         ON tsm.tsm_id = dtm.dtm_id_tsm
  LEFT JOIN tmn_tipo_mantto tmn
         ON tmn.tmn_id = gmt.gmt_id_tmn
 LEFT JOIN veh_vehiculo veh
         ON dtm.dtm_id_veh = veh.veh_id
 LEFT JOIN mrv_marca mrv
         ON mrv.mrv_id = veh.veh_id_mrv
 LEFT JOIN mdv_modelo_veh mdv ON mdv_id = veh.veh_id_mdv
 LEFT JOIN clv_color_vehiculo clv
         ON clv.clv_id = veh.veh_id_clv
    LEFT JOIN emp_empleado emp ON emp.emp_id = con.con_id_administrador
      WHERE gmt.gmt_id = ".$id ."
   GROUP BY veh.veh_id 
          ;";

    $resultado=$this->db->query($query)->result_array();
    return $resultado;
  }


/**
   * @author Christian Menendez
   * @return 
   */

  function get_recepcion_vehiculo1($rec_id=null)
  {

 $query1="
 SELECT IF(dxr_estado = 1, 'Sí', 'No') as estado,
             hev_nombre, 
             veh.veh_placa
        FROM(
             (
              (
               dxr_detallexrecepcion dxr
              )LEFT JOIN hev_herramienta_vehiculo hev
              ON dxr.dxr_id_hev = hev.hev_id
             )LEFT JOIN rec_recepcion_vehiculo rec
             ON rec.rec_id = dxr.dxr_id_rec
            )LEFT JOIN veh_vehiculo veh
            ON veh.veh_id = rec.rec_id_veh
       WHERE dxr_id_rec = ".$rec_id."";


      $resultado=$this->db->query($query1)->result_array();
      //die(print_r($this->bd->last_query()));
    return $resultado;
  }

/**
   * @author Christian Menendez
   * @return 
   */

  function get_recepcion_vehiculo2($rec_id=null, $rec_id_veh = null)
  {
        //CON O SIN HERRAMIENTA
        $query1="
            SELECT IF(dxr_estado = 1, 'Sí', 'No') as estado,
                 hev_nombre,
                 veh.veh_placa
            FROM(
                 (
                  (
                   dxr_detallexrecepcion dxr
                  )LEFT JOIN hev_herramienta_vehiculo hev
                  ON dxr.dxr_id_hev = hev.hev_id
                 )LEFT JOIN rec_recepcion_vehiculo rec
                 ON rec.rec_id = dxr.dxr_id_rec
                )LEFT JOIN veh_vehiculo veh
                ON veh.veh_id = rec.rec_id_veh
           WHERE dxr_id_rec = ".$rec_id."";

        // RECEPCIÓN
        $query2="
            SELECT rec.rec_tipo, rec.rec_tanque, rec.rec_fecha, rec.rec_observacion ,rec.rec_kilometraje , tir.tir_nombre FROM rec_recepcion_vehiculo rec
            LEFT JOIN tir_tipo_recepcion_veh tir ON tir.tir_id = rec.rec_id_tir
            WHERE rec_id = ".$rec_id." AND rec_tipo= 1";
        //ENTREGA
        $query3="
            SELECT rec.rec_tipo, 
                       rec.rec_tanque,
                       rec.rec_fecha,
                       rec.rec_observacion,
                       rec.rec_kilometraje,
                       tir.tir_nombre 
            FROM rec_recepcion_vehiculo rec
            LEFT JOIN tir_tipo_recepcion_veh tir 
                  ON tir.tir_id = rec.rec_id_tir
            WHERE rec_id_veh = ".$rec_id_veh."
                AND rec_id > ".$rec_id."
                AND rec_tipo = 2";

        $query=$this->db->query($query2)->result_array();
        //$query+=$this->db->query($query1)->result_array();
            // die(print_r($this->bd->last_query()));
    /*$resultado=$this->db->query($query)->result_array();
    return $resultado;*/
    return $query;
  }
  
 function get_recibo_cupones_combustible($gtc_id = null )
  {

 $query1="
 SELECT
    tpc_nombre AS combustible,
    gtc_fecha_creacion AS fecha,
    (dtc_vales * dtc_vale_valor) AS valor,
  CONCAT_WS(' ',emp.emp_nombre,emp.emp_apellido) AS usuario_recibe,
    dtc_vales AS cantidad_vales,
    dtc_destino AS cupones_para,
    veh_placa AS placa,
    dtc_id_mot AS persona_recibe,
    dtc_id_tkt
FROM
    gtc_gestion_combustible
LEFT JOIN dtc_detalle_ticket_combustible ON dtc_id = gtc_id_dtc
LEFT JOIN veh_vehiculo ON veh_id = dtc_id_veh
LEFT JOIN tpc_tipo_combustible ON tpc_id = dtc_id_tpc
LEFT JOIN emp_empleado emp ON emp_id = gtc_usuario_recibe

WHERE
    gtc_id = ".$gtc_id."";

    $resultado=$this->db->query($query1)->result_array();
    return $resultado;
  }

 function get_recibo_cupones_combustible2($vxc_id_gtc=null)
  {

       $query2="
SELECT vxc_inicio AS inicio, vxc_fin AS fin, (vxc_fin - vxc_inicio)+1 AS cantidad, ((vxc_fin - vxc_inicio)+1)*vxc_monto AS valor_total FROM vxc_valesxgestion_comb
INNER JOIN srv_serie_vale ON vxc_id_srv = srv_id
WHERE vxc_id_gtc = ".$vxc_id_gtc."";
        
    $resultado=$this->db->query($query2)->result_array();
    return $resultado;
  }

   function get_recepcion_vehiculo3($rec_id=null, $rec_id_veh = null)
  {
    //ENTREGA
        $query3="
            SELECT rec.rec_tipo, 
                       rec.rec_tanque,
                       rec.rec_fecha,
                       rec.rec_observacion,
                       rec.rec_kilometraje,
                       tir.tir_nombre 
            FROM rec_recepcion_vehiculo rec
            LEFT JOIN tir_tipo_recepcion_veh tir 
                  ON tir.tir_id = rec.rec_id_tir
            WHERE rec_id_veh = ".$rec_id_veh."
                AND rec_id > ".$rec_id."
                AND rec_tipo = 2";

      $resultado=$this->db->query($query3)->result_array();
      //die(print_r($this->bd->last_query()));
    return $resultado;
  }

  function get_obligaciones($id_contrato)
    {
        $this->db->select()
                 ->from('obc_obligacion_contrato')
                 ->join('seg_seguimiento_cont','seg_id_obc=obc_id','left')
                 ->where('obc_id_con',$id_contrato)
                 ->where('obc_estado',1)
                 ;
         $query= $this->db->get()->result_array();
        return $query;   
    }

    function get_info_mantto($id_tkt=null){
          $this->db->select('tsm_id, dtm_detalle_suministro, tsm_nombre, dtm_cantidad, veh_placa, mdv_nombre, tpf_nombre, tpl_nombre, dtm_fecha_sugerida, dtm_hora_sugerida')
                 ->from('tkt_ticket')
                 ->join('dtm_detalle_ticket_mantto','tkt_id=dtm_id_tkt')
                 ->join('tsm_tipo_sol_mantto','dtm_id_tsm=tsm_id')
                 ->join('veh_vehiculo','dtm_id_veh=veh_id','left')
                 ->join('mdv_modelo_veh', 'veh_id_mdv=mdv_id', 'left')
                 ->join('tpf_tipo_fondo', 'veh_id_tpf=tpf_id', 'left')
                 ->join('tpl_tipo_llanta','veh_id_tpl=tpl_id', 'left');

                 if($id_tkt!=null){
                    $this->db->where('tkt_id',$id_tkt);
                 }
                 
         $query= $this->db->get()->result_array();
        return $query; 
    }

    function get_combustible_gasto ($fecha_inicio, $fecha_fn,$estado){

        $this->db->select('emp_nombre, emp_apellido, veh_placa,dtc_vales, dtc_vale_valor ,esk_nombre, (dtc_vales * dtc_vale_valor) as total')
                 ->from('dtc_detalle_ticket_combustible')
                 ->join('tkt_ticket','tkt_id = dtc_id_tkt')
                 ->join('esk_estado_ticket','esk_id = tkt_id_esk')
                 ->join('veh_vehiculo','dtc_id_veh = veh_id', 'left')
                 ->join('users', 'id = dtc_usu_creacion', 'left')
                 ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                 ->where('dtc_fecha_solicitud >=',$fecha_inicio);
        $this->db->where('dtc_fecha_solicitud <=',$fecha_fn);
        $this->db->where('tkt_estado',1);

        if ($estado == 10) {
           //$this->db->where('tkt_id_esk <> ',17);
        }else{
           $this->db->where('tkt_id_esk',$estado);
        }
       
        $this->db->order_by('dtc_fecha_creacion');
        $query = $this->db->get()->result_array();
      //  die(print_r($this->db->last_query()));
        return $query;
    }

    public function get_user_name()
  {
    $id = $this->tank_auth->get_user_id();
    $this->db->select('username')
         ->from('users')
         ->where('id',$id);
    $query = $this->db->get();
    return $query->result_array();
  }

}    // End entradas_model
