<?php

/**
 * 
 */
class Encuesta_model extends CI_Model {

    function __construct() {
        $this->load->database();
        date_default_timezone_set('America/El_Salvador');
    }

    //para la enumeracion de los registros
    public function  posicion_registro($nombre_tabla,$idValorfila,$where=null) {

    $nposicion="-";
    $prefijo = current(explode("_", $nombre_tabla));
   $q= $this->db->select("count(*) n_registro")
          ->from($nombre_tabla)
          ->where("$prefijo"."_id <= ",$idValorfila);
    if ($where) {  $this->db->where($where); }      

    $resultado = $q->get()->row_array();
          
    $nposicion = ($resultado and count($resultado)>0)? $resultado['n_registro']:0; 
    return $nposicion;

    }

    public function select_agencia($encuesta=0) {
      $q = $this->db->select("suc_sucursal.*")
                ->from("suc_sucursal")
                ->where("suc_id not in (SELECT exs_id_suc from exs_encuestaxsucursal WHERE exs_id_enc=$encuesta)")->get()->result_array();
                //die($this->db->last_query());
      $opciones='<option value=""></option>';
      foreach ($q as $f) {
        $opciones .='<option value="'.$f['suc_id'].'">'.$f['suc_nombre'].'</option>';
      }
      //die(print_r($opciones));
         return $opciones; 
   }

   public function opcion_respuesta($where=null) {
    $q = $this->db->select("*")
    ->from("opr_opcion_respuesta")
    ->join('ico_icono','ico_id=opr_id_ico','left')
    ->join('pre_pregunta','pre_id=opr_id_pre_salto','left');

      if ($where) {
        $this->db->where($where);
      }
    return $q->get()->result_array(); 
  }


  public function select_consultar_encuestas($where=null)
  {

    //Verificamos el rol del usuario seleccionado
     $q = $this->db->select("*")
    ->from("usu_usuario")
    ->join('uxr_usuarioxrol','uxr_id_usu=usu_id','left')
    ->join('rol_rol','rol_id=uxr_id_rol','left');
    
    if ($where) {
      $this->db->where($where);
    }

  /*  $q = $this->db->select("*")
      ->from("opr_opcion_respuesta")
      ->join('ico_icono', 'ico_id=opr_id_ico', 'left')
      ->join('pre_pregunta', 'pre_id=opr_id_pre_salto', 'left');

    if ($where) {
      $this->db->where($where);
    }*/

    return $q->get()->result_array();
  }




  public function respuesta_configuraciones($where=null) {
    $q = $this->db->select("opr_id,opr_nombre, otd_opcion_tabla_dinamica.*")
    ->from("opr_opcion_respuesta")

    ->join('otd_opcion_tabla_dinamica','opr_id=otd_id_opr');

      if ($where) {
        $this->db->where($where);
      }
    return $q->get()->result_array();
  }


  /**
     * Encuesta_model::consultar_tipo_campo_dinamico()
     * Genera un array y devuelve el tipo de campo dinamico de la respuesta consultada.
     * 
     * @author Manuel Hernandez
     * @param string $where
     * @fecha   26/03/2020
     * @return Array
     */
  public function consultar_tipo_campo_dinamico($where=null) {
    $q = $this->db->select("opr_tipo_campo_dinamico")
    ->from("opr_opcion_respuesta");

      if ($where) {
        $this->db->where($where);
      }
     return $q->get()->result_array(); 
  }

/**
     * Encuesta_model::registroPreguntas()
     * Genera un array y devuelve todas las preguntas, respuestas y configuraciones de una encuesta especifica.
     * 
     * @author Manuel Hernandez
     * @param string $where
     * @fecha   26/03/2020
     * @return Array
     */

  public function registroPreguntas($numEncuesta=null, $where){
    $q = $this->db->select("opr_id,opr_nombre, otd_opcion_tabla_dinamica.*")
    ->from("opr_opcion_respuesta")
    ->join('otd_opcion_tabla_dinamica','opr_id=otd_id_opr');

      if ($where) {
        $this->db->where($where);
      }
    return $q->get()->result_array(); 

  }




   public function json_usuarios()
   {
     $q = $this->db->select("usu_id, usu_id_emp, usu_nombre_usuario, usu_clave, usu_email
      ,emp_cod_empleado, emp_nombre, emp_apellido
      , GROUP_CONCAT(DISTINCT uxs_id_suc SEPARATOR ',') id_sucursales
      , GROUP_CONCAT(DISTINCT suc_nombre SEPARATOR ',') nombre_sucursales",false)
      ->from("usu_usuario")
      ->join("emp_empleado","emp_id=usu_id_emp")
      ->join("uxs_usuarioxsucursal","uxs_id_usu=usu_id")
      ->join("suc_sucursal","suc_id=uxs_id_suc")
      ->where("usu_estado",1)
      ->group_by("usu_id")->get()->result_array();
     return $q;
   }

   public function json_encuesta_sucursal()
   {
    $q = $this->db->select("suc_id,suc_codigo,suc_nombre, mun_id, mun_nombre, GROUP_CONCAT(DISTINCT exs_id_enc SEPARATOR ',') id_encuestas",false)
     ->from("suc_sucursal")
     ->join("mun_municipio","mun_id=suc_id_mun")
     ->join("exs_encuestaxsucursal","exs_id_suc=suc_id")
     ->where("exs_estado",1)
     ->group_by("suc_id")->get()->result_array();
    return $q;
   }

  public function encuestas_json($array_id)
  {
                  $this->db->where_in('enc_id',$array_id);
                  $this->db->select('enc_id,enc_nombre')->where('enc_estado',1);
    $encuestas = $this->gsatelite->get_tabla('enc_encuesta');
    return $encuestas;
  }

  public function sucursales_json($array_id)
  {
                  $this->db->where_in('suc_id',$array_id);
                  $this->db->select('suc_id,suc_codigo,suc_nombre');
    $sucursales = $this->gsatelite->get_tabla('suc_sucursal');
    return $sucursales;
  }

  public function get_preguntas($where)
  {
                 $this->db->order_by('pre_orden','ASC');   
    $preguntas = $this->gsatelite->get_tabla("pre_pregunta",$where);
    return $preguntas; 
  }

  public function get_sucursalesxusuario($where = null, $tipo=null){
    if($tipo==null){
      $q = $this->db->select("suc_sucursal.*")
                ->from("usc_usuario_sucursal")
                ->join('suc_sucursal','usc_id_suc = suc_id')
      ;
      if($where != null){
          $this->db->where($where);
      }
      
      return $q->get()->result_array();
    }else{
      $q = $this->db->select('GROUP_CONCAT(DISTINCT usc_id_suc) as id_agencias')
      ->from('usc_usuario_sucursal')
      ->join('suc_sucursal','usc_id_suc = suc_id');
      
      if($where != null){
        $this->db->where($where);
      }

      $this->db->group_by('usc_id_usu');


      return $q->get()->result_array();
      
    }
  }
  
  public function get_encuestasxsucursal($where){
      $q = $this->db->select("*")
                ->from("enc_encuesta")
                ->join('exs_encuestaxsucursal','enc_id = exs_id_enc')
                ->join('suc_sucursal','suc_id = exs_id_suc')
      ;
      if($where != null){
          $this->db->where($where);
      }
      
      return $q->get()->result_array();
  }

  public function login_app($usuario, $pass)
  {
    $q = $this->db->select("*")
              ->from("usu_usuario")
              ->join('uxs_usuarioxsucursal','uxs_id_usu=usu_id')
              ->join('exs_encuestaxsucursal','exs_id=uxs_id_exs_defecto')
              ->where('usu_nombre_usuario',$usuario)
              ->where('usu_clave',md5($pass))
    ;

    return $q->get()->result_array();
  }
  
  public function respuestas($resp, $user, $ecl)
  {
    $data = array(
   'rec_id_ecl' => '$ecl' ,
   'rec_id_pre' => '(select opr_id_pre from opr_opcion_respuesta where opr_id=$resp limit 1)' ,
   'rec_id_opr' => '$resp',
   'rec_fecha_registro' => CURRENT_TIMESTAMP () ,
   'rec_estado' => 1,
   'rec_usu_creacion' => '$user' ,
   'rec_fecha_creacion' => CURRENT_TIMESTAMP (),
   'rec_usu_modificacion' => '$user' ,
   'rec_fecha_modificacion' => CURRENT_TIMESTAMP ()
);
    
    
    $this->gsatelite->ingresar("rec_respuesta_encuesta", $data);
  }

    //Rene Castaneda
    public function get_respuestaxpregunta_cerrada($seleccionar="*",$order_by='pre_id',$where=null,$group_by=null){
      $q = $this->db->select($seleccionar,false) //GROUP_CONCAT(DISTINCT ico_url SEPARATOR "#" ) iconos, opr_nombre respuesta
                ->from("pre_pregunta")
                ->join('opr_opcion_respuesta','opr_id_pre = pre_id')
                ->join('ico_icono','ico_id = opr_id_ico','left')
      ;
      if($where ){
          $this->db->where($where);
      }
      if($group_by){
          $this->db->group_by($group_by);
      }
      if($order_by){
          $this->db->order_by($order_by);
      }
      
      return $q->get()->result_array();
  }

    //Rene Castaneda
    public function respuesta_preguntas($seleccionar="*",$order_by='pre_id',$where=null,$group_by=null,$array_where_in=null){
      $q = $this->db->select($seleccionar,false) //GROUP_CONCAT(DISTINCT ico_url SEPARATOR "#" ) iconos, opr_nombre respuesta
                ->from("rec_respuesta_encuesta")
                ->join('opr_opcion_respuesta','opr_id = rec_id_opr')
                ->join('pre_pregunta','pre_id = rec_id_pre')
                ->join('ecl_encuesta_cliente','ecl_id = rec_id_ecl')
                ->join('exs_encuestaxsucursal','exs_id = ecl_id_exs')
                ->join('enc_encuesta','enc_id = exs_id_enc')
                ->join('suc_sucursal','suc_id = exs_id_suc')
                ->join('ico_icono','ico_id = opr_id_ico','left')
      ;
      if($where){
          $this->db->where($where);
      }
      if($array_where_in){
        //print_r($array_where_in); die();
        foreach ($array_where_in as $key => $value) {
          $this->db->where_in($key,$value);
        }
      }
      if($group_by){
          $this->db->group_by($group_by);
      }
      if($order_by){
          $this->db->order_by($order_by);
      }
      
      return $q->get()->result_array();
  }

     //Manuel Hernandez
     public function preguntas_contestadas($seleccionar="*",$order_by='pre_id',$where=null,$group_by=null,$array_where_in=null){
      
      $q = $this->db->select($seleccionar,false) //GROUP_CONCAT(DISTINCT ico_url SEPARATOR "#" ) iconos, opr_nombre respuesta
                ->from('rec_respuesta_encuesta')
               // ->join('opr_opcion_respuesta','opr_id = rec_id_opr')
                ->join('pre_pregunta','pre_id = rec_id_pre')
                ->join('ecl_encuesta_cliente','ecl_id = rec_id_ecl')
                ->join('exs_encuestaxsucursal','exs_id = ecl_id_exs')
                ->join('enc_encuesta','enc_id = exs_id_enc')
                ->join('suc_sucursal','suc_id = exs_id_suc')
               // ->join('ico_icono','ico_id = opr_id_ico','left')
      ;
      if($where){
          $this->db->where($where);
      }
      if($array_where_in){
        //print_r($array_where_in); die();
        foreach ($array_where_in as $key => $value) {
          $this->db->where_in($key,$value);
        }
      }
      if($group_by){
          $this->db->group_by($group_by);
      }
      if($order_by){
          $this->db->order_by($order_by);
      }
      
      return $q->get()->result_array();
  }

    //Rene Castaneda
    public function encuesta_cliente($seleccionar="*",$order_by='pre_id',$where=null,$group_by=null){
      $q = $this->db->select($seleccionar,false) //GROUP_CONCAT(DISTINCT ico_url SEPARATOR "#" ) iconos, opr_nombre respuesta
                ->from("cli_cliente")
                ->join('ecl_encuesta_cliente','ecl_id_cli = cli_id')
                ->join('exs_encuestaxsucursal','exs_id = ecl_id_exs')
      ;
      if($where ){
          $this->db->where($where);
      }
      if($group_by){
          $this->db->group_by($group_by);
      }
      if($order_by){
          $this->db->order_by($order_by);
      }
      
      return $q->get()->result_array();
  }

    //Rene Castaneda
    public function respuesta_encuesta($where=null,$seleccionar="*",$order_by='pre_orden',$group_by=null){
      $q = $this->db->select($seleccionar) //GROUP_CONCAT(DISTINCT ico_url SEPARATOR "#" ) iconos, opr_nombre respuesta
                ->from("rec_respuesta_encuesta")
                ->join('pre_pregunta','rec_id_pre = pre_id')
                ->join('ecl_encuesta_cliente','ecl_id = rec_id_ecl')
                ->join('opr_opcion_respuesta','opr_id = rec_id_opr', 'left')
                ->join('exs_encuestaxsucursal','exs_id = ecl_id_exs')
                ->join('enc_encuesta','enc_id = exs_id_enc')
                ->join('suc_sucursal','suc_id = exs_id_suc')
                ->join('cli_cliente','cli_id = ecl_id_cli')
      ;
      if($where ){
          $this->db->where($where);
      }
      if($group_by){
          $this->db->group_by($group_by);
      }
      if($order_by){
          $this->db->order_by($order_by);
      }
      
      return $q->get()->result_array();
  }

  public function select_respuesta($where=null)
  {
          $this->db->group_by('opr_nombre');
   return $this->gsatelite->get_dropdown('opr_opcion_respuesta', '{opr_nombre}','', $where, null, '', 'opr_id', true);
  }


  public function select_preguntas($where=null)
  {
          $this->db->group_by('pre_nombre');
   return $this->gsatelite->get_dropdown('pre_pregunta', '{pre_nombre}','', $where, null, '', 'pre_id', true);
  }


    //Manuel Hernandez
    public function consultar_encuesta($seleccionar="*",$order_by='pre_id',$where=null,$group_by=null, $where_in=null){
      $q = $this->db->select($seleccionar,false) //GROUP_CONCAT(DISTINCT ico_url SEPARATOR "#" ) iconos, opr_nombre respuesta
                ->from("ecl_encuesta_cliente")
                ->join('exs_encuestaxsucursal','ecl_id_exs=exs_id')
               // ->join('cli_cliente','ecl_id_cli=cli_id')
                ->join('enc_encuesta','exs_id_enc=enc_id')
                ->join('users','id=ecl_id_usu','left')
      ;
      if($where ){
          $this->db->where($where);
      }

      if($where_in!=null){
        $this->db->where_in('exs_id_suc',$where_in);
      }
      if($group_by){
          $this->db->group_by($group_by);
      }
      if($order_by){
          $this->db->order_by($order_by);
      }
      
      return $q->get()->result_array();
  }

  /*
  //Manuel Hernandez
    public function consultar_encuesta($seleccionar="*",$order_by='pre_id',$where=null,$group_by=null){
      $q = $this->db->select($seleccionar,false) //GROUP_CONCAT(DISTINCT ico_url SEPARATOR "#" ) iconos, opr_nombre respuesta
                ->from("ecl_encuesta_cliente")
                ->join('exs_encuestaxsucursal','ecl_id_exs=exs_id')
               // ->join('cli_cliente','ecl_id_cli=cli_id')
                ->join('enc_encuesta','exs_id_enc=enc_id')
                ->join('usu_usuario','usu_id=ecl_id_usu')
      ;
      if($where ){
          $this->db->where($where);
      }
      if($group_by){
          $this->db->group_by($group_by);
      }
      if($order_by){
          $this->db->order_by($order_by);
      }
      
      return $q->get()->result_array();
  }
  */


   //Manuel Hernandez
   public function idEncuesta($seleccionar="*",$order_by='pre_id',$where=null,$group_by=null){
    $q = $this->db->select($seleccionar,false) //GROUP_CONCAT(DISTINCT ico_url SEPARATOR "#" ) iconos, opr_nombre respuesta
              ->from("ecl_encuesta_cliente")
              ->join('exs_encuestaxsucursal','exs_id=ecl_id_exs')
    ;
    if($where ){
        $this->db->where($where);
    }
    if($group_by){
        $this->db->group_by($group_by);
    }
    if($order_by){
        $this->db->order_by($order_by);
    }
    
    return $q->get()->result_array();
}

//Manuel Hernandez
public function respuesta_desplegable_multiple($idEncuesta, $idPregunta){
  $q=$this->db->select('rec_id_opr, oxp_id_opr,oxp_valor_referencia, oxp_id_otd',false)
    ->from("rec_respuesta_encuesta")
    ->join('oxp_opcion_respuestaxpregunta', 'oxp_id_rec=rec_id', 'left')
    ->where('rec_id_ecl',$idEncuesta)
    ->where('rec_id_pre',$idPregunta);

  return $q->get()->result_array();
}


//Manuel Hernandez
public function respuesta_multiple($idEncuesta, $idPregunta){
  $q=$this->db->select('rec_id_opr, oxp_id_opr, oxp_valor_referencia',false)
    ->from("rec_respuesta_encuesta")
    ->join('oxp_opcion_respuestaxpregunta', 'oxp_id_rec=rec_id')
    ->where('rec_id_ecl',$idEncuesta)
    ->where('rec_id_pre',$idPregunta);

  return $q->get()->result_array();
}

public function get_exportar_datos($where = null){
  $q=$this->db->select('*',false)
    ->from("enc_encuesta")
    ->join('pre_pregunta', 'pre_id_enc = enc_id')
    ->join('exs_encuestaxsucursal', 'exs_id_enc = enc_id')
    ->join('suc_sucursal', 'suc_id = exs_id_suc')
    ->join('ecl_encuesta_cliente', 'ecl_id_exs = exs_id')
      ->order_by('ecl_id, pre_orden ASC');
    ;

    if($where!=null){
      $this->db->where($where);
    }

  return $q->get()->result_array();
}

    public function get_exportar_datos_spss($where = null, $group_by=null, $order_by=null){
        $q=$this->db->select('*',false)
            ->from("enc_encuesta")
            ->join('pre_pregunta', 'pre_id_enc = enc_id')
            ->join('exs_encuestaxsucursal', 'exs_id_enc = enc_id')
            ->join('suc_sucursal', 'suc_id = exs_id_suc')
            ->join('ecl_encuesta_cliente', 'ecl_id_exs = exs_id')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        if($group_by!=null){
            $this->db->group_by($group_by);
        }

        if($order_by!=null){
            $this->db->order_by($order_by);
        }

        return $q->get()->result_array();
    }

    public function numero_pregunta($where=null){
      $q= $this->db->select_max('pre_orden')
          ->from("pre_pregunta");

          if($where!=null){
            $this->db->where($where);
          }


      return $q->get()->result_array();

    }

    public function get_respuestas_estaticas($where = null, $group_by=null, $order_by=null){
        $q=$this->db->select('rec_respuesta_encuesta.*',false)
            ->from("enc_encuesta")
            ->join('pre_pregunta', 'pre_id_enc = enc_id')
            ->join('exs_encuestaxsucursal', 'exs_id_enc = enc_id')
            ->join('ecl_encuesta_cliente', 'ecl_id_exs = exs_id')
            ->join('rec_respuesta_encuesta','rec_id_ecl = ecl_id', 'inner')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        if($group_by!=null){
            $this->db->group_by($group_by);
        }

        if($order_by!=null){
            $this->db->order_by($order_by);
        }

        return $q->get()->result_array();
    }

    public function get_respuestas_multiples($where = null, $group_by=null, $order_by=null){
        $q=$this->db->select('oxp_opcion_respuestaxpregunta.*',false)
            ->from("enc_encuesta")
            ->join('pre_pregunta', 'pre_id_enc = enc_id')
            ->join('exs_encuestaxsucursal', 'exs_id_enc = enc_id')
            ->join('ecl_encuesta_cliente', 'ecl_id_exs = exs_id')
            ->join('rec_respuesta_encuesta','rec_id_ecl = ecl_id', 'inner')
            ->join('oxp_opcion_respuestaxpregunta','oxp_id_rec = rec_id', 'inner')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        if($group_by!=null){
            $this->db->group_by($group_by);
        }

        if($order_by!=null){
            $this->db->order_by($order_by);
        }

        return $q->get()->result_array();
    }


    //Manuel Hernandez
    public function consultar_dashboard($where=null){
      
      $q = $this->db->select('
          IFNULL((IF(T6.cla_tipo=1,
          (SELECT
          count(T5.ecl_id) AS Cantidad
        FROM
          cla_clasificacion_encuesta T1
          INNER JOIN cla_clasificacion_encuesta T2 ON T2.cla_id_padre = T1.cla_id
          INNER JOIN cxe_clasificacionxencuesta T10 ON T10.cxe_id_cla = T2.cla_id
          INNER JOIN enc_encuesta T3 ON T10.cxe_id_enc = T3.enc_id
          INNER JOIN exs_encuestaxsucursal T4 ON T4.exs_id_enc = T3.enc_id
          INNER JOIN ecl_encuesta_cliente T5 ON T5.ecl_id_exs = T4.exs_id 
        WHERE
          T2.cla_id = ' . $where . ' )
            ,
          IF(T6.cla_tipo=2,(
            SELECT
              count(T5.ecl_id) AS Cantidad
            FROM
              cla_clasificacion_encuesta T1
              INNER JOIN cla_clasificacion_encuesta T2 ON T2.cla_id_padre = T1.cla_id
              INNER JOIN cxe_clasificacionxencuesta T10 ON T10.cxe_id_cla = T2.cla_id
              INNER JOIN enc_encuesta T3 ON T3.enc_id = T10.cxe_id_enc
              INNER JOIN exs_encuestaxsucursal T4 ON T4.exs_id_enc = T3.enc_id
              INNER JOIN ecl_encuesta_cliente T5 ON T5.ecl_id_exs = T4.exs_id 
            WHERE
              T2.cla_id = ' . $where . ' 
              AND ((T5.ecl_nota_encuesta >= T6.cla_nota_minima) or ((
                    SELECT
                      SUM( ( IFNULL( pre_calificacion_maxima, 0 ) * ( IFNULL( opr_puntuacion, 0 ) / 100 ) ) ) 
                    FROM
                      opr_opcion_respuesta
                      JOIN pre_pregunta ON pre_id = opr_id_pre
                      JOIN rec_respuesta_encuesta ON rec_id_opr = opr_id 
                    WHERE
                      rec_id_ecl = ecl_id 
                      ) >= T6.cla_nota_minima))
          ),
          IF(
          T6.cla_tipo = 3,
          (
            SELECT
            COUNT(DISTINCT ecl_id) as cantidad
          FROM
            ecl_encuesta_cliente
            LEFT JOIN rec_respuesta_encuesta ON rec_id_ecl = ecl_id
            LEFT JOIN exs_encuestaxsucursal ON ecl_id_exs = exs_id
            LEFT JOIN enc_encuesta ON exs_id_enc = enc_id
            LEFT JOIN cxe_clasificacionxencuesta ON cxe_id_enc = enc_id 
            LEFT JOIN cla_clasificacion_encuesta ON cxe_id_cla = cla_id
            LEFT JOIN pcc_pregunta_condicion_clasificacion ON pcc_id_cla = cla_id
            LEFT JOIN oxp_opcion_respuestaxpregunta ON oxp_id_rec = rec_id
          WHERE
          T6.cla_id = cla_id AND
            (rec_id_opr = pcc_id_opr OR oxp_id_opr = pcc_id_opr)
          ),
          0
          )
          )  )),0) as encuestas, T7.niv_orden, T8.per_nombre
    
          ', false)
        ->from("cla_clasificacion_encuesta T6 ")
        ->join('niv_nivel_clasificacion T7', 'T7.niv_id=T6.cla_id_niv', 'left')
        ->join('per_periodo T8', 'T8.per_id=T6.cla_id_per', 'left');

      $this->db->where('T6.cla_id =', $where);
      //$this->db->order_by('T6.cla_id', 'ASC');
      //$this->db->limit(5);

      $registros = $q->get()->result_array();
    
     return $registros;  
  }

  public function consultar_nivel_dashboard($where = null)
  {
    $q = $this->db->select("*", false)
      ->from("cla_clasificacion_encuesta")
      ->join('niv_nivel_clasificacion', 'niv_id=cla_id_niv', 'inner');

    if ($where != null) {
      $this->db->where($where);
    }
    return $q->get()->result_array();
  }

    //Marlon Olmedo
    //trae las preguntas con todas las opciones
    public function get_preguntasxall($where=null,$order_by="pre_tipo",$group_by="rec_id"){
      $select = "pre_tipo,
              pre_nombre,
              rec_respuesta,
              ( SELECT GROUP_CONCAT(opr_nombre) FROM oxp_opcion_respuestaxpregunta LEFT JOIN opr_opcion_respuesta ON oxp_id_opr = opr_id WHERE oxp_id_rec = rec_id ) AS nombre_opcion,
              ( SELECT opr_nombre FROM opr_opcion_respuesta WHERE opr_id = rec_id_opr ) AS nombre_opcion_segundo,
              rec_id,
              ( SELECT GROUP_CONCAT(oxp_id_rec) FROM oxp_opcion_respuestaxpregunta WHERE oxp_id_rec = rec_id ) AS oxp_id_rec,
              ( SELECT GROUP_CONCAT(oxp_id_opr) FROM oxp_opcion_respuestaxpregunta WHERE oxp_id_rec = rec_id ) AS oxp_id_opr,
              ( SELECT opr_tipo_campo_dinamico FROM opr_opcion_respuesta WHERE opr_id = rec_id_opr ) AS opr_tipo_campo_dinamico,
              ( SELECT GROUP_CONCAT(otd_nombre) FROM oxp_opcion_respuestaxpregunta LEFT JOIN otd_opcion_tabla_dinamica ON oxp_id_otd = otd_id WHERE oxp_id_rec = rec_id ) AS otd_nombre,
              ( SELECT GROUP_CONCAT(otd_id) FROM oxp_opcion_respuestaxpregunta LEFT JOIN otd_opcion_tabla_dinamica ON oxp_id_otd = otd_id WHERE oxp_id_rec = rec_id ) AS otd_id,
              ( SELECT anr_nombre_archivo FROM anr_anexo_respuesta WHERE anr_id_rec = rec_id ) AS nombre_archivo,
              ( SELECT anr_ruta_archivo FROM anr_anexo_respuesta WHERE anr_id_rec = rec_id ) AS ruta_archivo,
              ( SELECT ico_url FROM opr_opcion_respuesta LEFT JOIN ico_icono ON opr_id_ico = ico_id WHERE rec_id_opr = opr_id ) AS icono,
              rec_id_opr,
              ( SELECT opr_url FROM opr_opcion_respuesta WHERE opr_id = rec_id_opr ) AS opr_url";
  
      $q = $this->db->select($select,false)
                ->from("rec_respuesta_encuesta")
                ->join('pre_pregunta','rec_id_pre = pre_id',"left")
                ->join('exs_encuestaxsucursal','rec_id_pre = pre_id',"left")
                ->join('ecl_encuesta_cliente','ecl_id_exs = exs_id',"left")
      ;
      if($where ){
          $this->db->where($where);
      }
      if($group_by!=null){
            $this->db->group_by($group_by);
      }
      if($order_by){
          $this->db->order_by($order_by);
      }
      
      return $q->get()->result_array();
  }


    /**
    * @author René Castaneda - Grupo Satelite
    * @since 22-12-2020
    * @return array query
    */
    public function get_preguntas_enc($where)
    {
      $q = $this->db->select("*, GROUP_CONCAT(DISTINCT CONCAT_WS('##',opr_id,opr_nombre,opr_tipo_campo_dinamico) SEPARATOR '##@') opcion_respuesta ",false)
                ->from("pre_pregunta")
                ->join('opr_opcion_respuesta','opr_id_pre = pre_id', 'left')
                ->order_by('pre_orden', 'ASC')
                ->group_by('pre_id')
               ;
      if($where ){
          $this->db->where($where);
      }        
      return $q->get()->result_array();
    }

      /**
      * @author René Castaneda - Grupo Satelite
      * @since 22-12-2020
      * @return array query
      */
      public function get_informacion_numero_encuesta($where=null) {
        $q = $this->db->select() 
                  ->from("ecl_encuesta_cliente")
                  ->join('exs_encuestaxsucursal','exs_id = ecl_id_exs')
                  ->join('enc_encuesta','enc_id = exs_id_enc')
                  ->join('suc_sucursal','suc_id = exs_id_suc','')
                  ->join('cli_cliente','cli_id = ecl_id_cli','left')
                  // ->join('usu_usuario','usu_id = ecl_id_usu','left')
                  ->join('users','id = ecl_id_usu','left')
        ;
                $this->db->order_by('ecl_fecha', 'ASC');
                $this->db->order_by('ecl_id', 'ASC');
                $this->db->group_by('ecl_id');
        if($where ){
            $this->db->where($where);
        }        
        return $q->get()->result_array();
    }
    /**
    * @author René Castaneda - Grupo Satelite
    * @since 22-12-2020
    * @return array query
    */
    public function get_informacion_encuesta($where=null) {
      $q = $this->db->select("*, 
        CONCAT(rec_id_ecl,'_',rec_id_pre) key_res,
        IF((pre_tipo = 4 AND rec_respuesta IS NOT NULL), IF(rec_respuesta = 1, 'Verdadero','Falso') ,
         IF(rec_id_opr > 0, CONCAT_WS(' ', opr_nombre, rec_respuesta), rec_respuesta)
        )
         respuesta_pregunta,
         (
         SELECT GROUP_CONCAT(DISTINCT CONCAT(oxp_id_opr,'##',IFNULL(oxp_valor_referencia,'1')) SEPARATOR '##@') 
         FROM oxp_opcion_respuestaxpregunta 
         WHERE oxp_id_rec = rec_id
         ) respuesta_pregunta_opr,
         (
         SELECT GROUP_CONCAT(DISTINCT IFNULL(oxp_valor_referencia,'') SEPARATOR ',') 
         FROM oxp_opcion_respuestaxpregunta 
         WHERE oxp_id_rec = rec_id
         ) respuesta_pregunta_extra,
         (
         SELECT GROUP_CONCAT(DISTINCT oxp_id_opr SEPARATOR '##@') 
         FROM oxp_opcion_respuestaxpregunta 
         WHERE oxp_id_rec = rec_id
         ) respuesta_pregunta_opr_id,
        (
        SELECT GROUP_CONCAT(DISTINCT CONCAT(anr_ruta_archivo,'/',anr_nombre_archivo) SEPARATOR '##') FROM anr_anexo_respuesta
        WHERE anr_id_rec = rec_id
        ) anexos_respuesta
         ",false) 
                ->from("rec_respuesta_encuesta")
                ->join('pre_pregunta','rec_id_pre = pre_id')
                ->join('ecl_encuesta_cliente','ecl_id = rec_id_ecl')
                ->join('opr_opcion_respuesta','opr_id = rec_id_opr', 'left')
                ->join('exs_encuestaxsucursal','exs_id = ecl_id_exs')
                ->join('enc_encuesta','enc_id = exs_id_enc')
                ->join('suc_sucursal','suc_id = exs_id_suc','')
                ->join('cli_cliente','cli_id = ecl_id_cli','left')
                ->join('users','id = ecl_id_usu','left')
      ;
              $this->db->order_by('ecl_fecha', 'ASC');
              $this->db->order_by('ecl_id', 'ASC');
              $this->db->order_by('pre_orden', 'ASC');
              $this->db->group_by('ecl_id');
              $this->db->group_by('pre_id');
      if($where ){
          $this->db->where($where);
      }        
      return $q->get()->result_array();
  }

  /**
  * @author René Castaneda - Grupo Satelite
  * @since 23-12-2020
  * @return array query
  */
  public function get_respuestas_dinamic($where,$group_by='rec_id')
  {
    $q = $this->db->select("*,
    GROUP_CONCAT( (
      SELECT GROUP_CONCAT(DISTINCT CONCAT(oxp_id_otd,'##',IFNULL(oxp_valor_referencia,'1')) SEPARATOR '##@') 
      FROM oxp_opcion_respuestaxpregunta 
      WHERE oxp_id_rec = rec_id
      )  SEPARATOR '##@' ) respuesta_pregunta_otd,
     GROUP_CONCAT(  (
       SELECT GROUP_CONCAT(DISTINCT IFNULL(oxp_valor_referencia, '') SEPARATOR ',') 
       FROM oxp_opcion_respuestaxpregunta 
       WHERE oxp_id_rec = rec_id
       )  SEPARATOR ',' )  respuesta_pregunta_extrabk,
       '' respuesta_pregunta_extra,
     GROUP_CONCAT(  (
      SELECT GROUP_CONCAT(DISTINCT oxp_id_otd SEPARATOR '##@') 
      FROM oxp_opcion_respuestaxpregunta 
      WHERE oxp_id_rec = rec_id
      )  SEPARATOR '##@' ) respuesta_pregunta_otd_id,
      GROUP_CONCAT( CONCAT_WS('', 
      (IF((opr_tipo_campo_dinamico = 4 AND IFNULL(rec_respuesta,'') != ''), 
      IF(rec_respuesta = 1, 'Verdadero','Falso') ,
      IF(rec_id_opr > 0, TRIM(CONCAT_WS(' ', otd_nombre, rec_respuesta)), rec_respuesta)
      )),
      IF(TRIM((
       SELECT IFNULL(GROUP_CONCAT(DISTINCT IFNULL(oxp_valor_referencia, '') SEPARATOR ','),'') 
       FROM oxp_opcion_respuestaxpregunta 
       WHERE oxp_id_rec = rec_id
       )) = '','',CONCAT(' / ',(
       SELECT GROUP_CONCAT(DISTINCT IFNULL(oxp_valor_referencia, '') SEPARATOR ',') 
       FROM oxp_opcion_respuestaxpregunta 
       WHERE oxp_id_rec = rec_id
       )) )

       )  SEPARATOR ',' )  respuesta_pre
      ",false)
              ->from("rec_respuesta_encuesta")
              ->join('oxp_opcion_respuestaxpregunta','oxp_id_rec = rec_id', 'left')
              ->join('opr_opcion_respuesta','opr_id = rec_id_opr', 'left')
              ->join('otd_opcion_tabla_dinamica','otd_id = oxp_id_otd', 'left')
              ->group_by($group_by)
             ;
    if($where ){
        $this->db->where($where);
    }        
    return $q->get()->result_array();
  }

  /**
  * @author René Castaneda - Grupo Satelite
  * @since 27-12-2020
  * @return update nota.
  */
  public function update_nota_encuesta($id_ecl=0)
  {
    $nota = null;
    if ($id_ecl > 0) {
      $q_nota = $this->db->select("ecl_encuesta_cliente.*,enc_encuesta.*, (SELECT SUM((IFNULL(pre_calificacion_maxima,0) * (IFNULL(opr_puntuacion,0)/100))) FROM opr_opcion_respuesta 
            JOIN pre_pregunta ON pre_id = opr_id_pre
            JOIN rec_respuesta_encuesta ON rec_id_opr = opr_id
            WHERE rec_id_ecl = ecl_id
             ) nota",false) 
                ->from("ecl_encuesta_cliente")
                ->join('exs_encuestaxsucursal','ecl_id_exs=exs_id')
                ->join('enc_encuesta','exs_id_enc=enc_id')
                ->where('ecl_id',$id_ecl)
                ->get()->row_array()
      ;
      if ($q_nota && $q_nota['enc_tipo'] == 1) {
        $nota = (is_numeric($q_nota['nota']))? $q_nota['nota']:0;
        $update_array = array(
          'ecl_nota_encuesta'=>$nota,
          'ecl_usu_modificacion' => $this->tank_auth->get_user_id(),
          'ecl_fecha_modificacion' => date('Y-m-d H:i:s')
        );
        $this->db->where('ecl_id',$id_ecl);
        $this->db->update('ecl_encuesta_cliente', $update_array);
      }
    }
    return $nota;
  }


  //Manuel Hernandez
  public function consultar_tabla_rastreo($slcNivel=null, $cla_tipo = null,$cla_nota = null, $where=null){

          if($cla_tipo==1){ //Metodo de conteo
            $q=$this->db->select("count(T5.ecl_id) AS encuestas,  CONCAT_WS('-',DATE_FORMAT(T5.ecl_fecha,'%m'), YEAR(T5.ecl_fecha)) as periodo, MONTH(T5.ecl_fecha) as mes",false)
            ->from("cla_clasificacion_encuesta T1")
            ->join('cxe_clasificacionxencuesta T2', 'T1.cla_id = T2.cxe_id_cla', 'inner')
            ->join('enc_encuesta T3', 'T2.cxe_id_enc=T3.enc_id', 'inner')
            ->join('exs_encuestaxsucursal T4', 'T4.exs_id_enc=T3.enc_id', 'inner')
            ->join('ecl_encuesta_cliente T5','T5.ecl_id_exs=T4.exs_id', 'inner')
            ->where('T1.cla_id',$slcNivel)
            ->order_by('YEAR(T5.ecl_fecha)', 'ASC')
            ->order_by('MONTH(T5.ecl_fecha)', 'ASC')
            ->group_by('periodo');

            if($where!=null){
              $this->db->where($where);
            }
  
            $query = $q->get()->result_array();

          }elseif($cla_tipo==2){ //Metodo de calificación
            $q=$this->db->select("count(T5.ecl_id) AS encuestas, CONCAT_WS('-',DATE_FORMAT(T5.ecl_fecha,'%m'), YEAR(T5.ecl_fecha)) as periodo, MONTH(T5.ecl_fecha) as mes",false)
            ->from("cla_clasificacion_encuesta T1")
            ->join('cxe_clasificacionxencuesta T2', 'T1.cla_id = T2.cxe_id_cla', 'inner')
            ->join('enc_encuesta T3', 'T2.cxe_id_enc=T3.enc_id', 'inner')
            ->join('exs_encuestaxsucursal T4', 'T4.exs_id_enc=T3.enc_id', 'inner')
            ->join('ecl_encuesta_cliente T5','T5.ecl_id_exs=T4.exs_id', 'inner')
            ->where('T1.cla_id',$slcNivel)
            ->where('T5.ecl_nota_encuesta >=',$cla_nota)
            ->order_by('YEAR(T5.ecl_fecha)', 'ASC')
            ->order_by('MONTH(T5.ecl_fecha)', 'ASC')
            ->group_by('periodo');

            if($where!=null){
              $this->db->where($where);
            }
  
            $query = $q->get()->result_array();
          } elseif($cla_tipo==3){
            $where_two["T1.cla_id"] = $slcNivel;
            $where_two["(T7.rec_id_opr = T6.pcc_id_opr OR T8.oxp_id_opr = T6.pcc_id_opr)"] = NULL;
            $q=$this->db->select("COUNT( DISTINCT ecl_id ) AS encuestas, CONCAT_WS('-',DATE_FORMAT(T5.ecl_fecha,'%m'), YEAR(T5.ecl_fecha)) as periodo, MONTH(T5.ecl_fecha) as mes",false)
            ->from("cla_clasificacion_encuesta T1")
            ->join('cxe_clasificacionxencuesta T2', 'T1.cla_id = T2.cxe_id_cla', 'left')
            ->join('enc_encuesta T3', 'T2.cxe_id_enc=T3.enc_id', 'left')
            ->join('exs_encuestaxsucursal T4', 'T4.exs_id_enc=T3.enc_id', 'left')
            ->join('ecl_encuesta_cliente T5','T5.ecl_id_exs=T4.exs_id', 'left')
            ->join('pcc_pregunta_condicion_clasificacion T6','T6.pcc_id_cla=T1.cla_id', 'left')
            ->join('rec_respuesta_encuesta T7','T7.rec_id_ecl=T5.ecl_id', 'left')
            ->join('oxp_opcion_respuestaxpregunta T8','T8.oxp_id_rec=T7.rec_id', 'left')
            ->where($where_two)
            ->order_by('YEAR(T5.ecl_fecha)', 'ASC')
            ->order_by('MONTH(T5.ecl_fecha)', 'ASC')
            ->group_by('periodo');

            if($where!=null){
              $this->db->where($where);
            }
  
            $query = $q->get()->result_array();
            //print_r($this->db->last_query());die();
          }

        $registros=$query;

   return $registros; 
    
}

  /**
  * @author René Castaneda - Grupo Satelite
  * @since 27-12-2020
  * @return update nota.
  */
  public function get_categoriaxpregunta($where)
  {
    $query= $this->db->select("*",false)
            ->from("pcc_pregunta_condicion_clasificacion")
            ->join('opr_opcion_respuesta', 'pcc_id_opr = opr_id', 'left')
            ->join('pre_pregunta', 'opr_id_pre = pre_id', 'left')
            ->join('enc_encuesta','pre_id_enc = enc_id', 'left')
            ->order_by('enc_id', 'DESC');

            if($where!=null){
              $this->db->where($where);
            }
  
      return $query->get()->result_array();
  }
    
} // End Encuesta_model class

// End Model 
