<?php

class Desarrollo_model extends CI_Model {

    function __construct() {
        $this->load->database();
        //$this->load->library('database');
    }

    function get_usuarios_completos($where = null) {
        $query = $this->db->select()
                ->from('users')
                ->join('emp_empleado', 'emp_empleado.emp_id = users.usu_id_emp', 'left')
                ->join('are_area', 'emp_empleado.emp_id_are = are_area.are_id', 'left')
                ->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left')
                ->join('suc_sucursal', 'emp_empleado.emp_id_suc = suc_sucursal.suc_id', 'left')                
        ;

        if ($where != null) {
            $this->db->where($where);
        }


        return $query->get()->result_array();
    }

    public function correlativo($ultimo = null) {
        $this->db->select("MAX(enr_correlativo) as ultimo");
        $this->db->from('enr_entregable');
        $this->db->where('enr_id_pry', $ultimo);
        $rs = $this->db->get();
        return $rs->result_array();
    }

    /**
     * @author Mario Marquez  
     * #order_by = text ejem: '-campo- -orden-'
     * #group_by = text OR array
     */
    public function get_etapas_entregables($where = null, $order_by = null, $group_by = null) {

        $query = $this->db->select()
                ->from('etr_etapa_entregable')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    public function get_entregables($where = null, $order_by = null, $group_by = null) {
        $query = $this->db->select()
                ->from('enr_entregable')
                ->join('pry_proyecto', 'pry_proyecto.pry_id = enr_entregable.enr_id_pry', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    public function get_data_incidencias($where = null, $order_by = null, $group_by = null, $where_cliente = null) {


        /* $this->db->select('sgi.sgi_id',false)
          ->from('sgi_seguimiento_inc as sgi')
          ->where('sgi.sgi_id_inc = inc.inc_id')
          ;

          $sgi_id = $this->db->get_compiled_select();

          $this->db->select('sgi.sgi_id_etr',false)
          ->from('sgi_seguimiento_inc AS sgi')
          ->where('sgi.sgi_id_inc = inc.inc_id')
          ->order_by('sgi.sgi_fecha DESC')
          ->limit(1)
          ;

          $sgi_lst_estado = $this->db->get_compiled_select(); */


        $query = $this->db->select("inc.*,enr.*,cmp.*,tii.*,pry.*,
               (SELECT sgi.sgi_id FROM sgi_seguimiento_inc AS sgi WHERE sgi.sgi_id_inc = inc.inc_id ORDER BY sgi.sgi_fecha DESC LIMIT 1) AS sgi_id,
               (SELECT sgi.sgi_id_etr FROM sgi_seguimiento_inc AS sgi WHERE sgi.sgi_id_inc = inc.inc_id ORDER BY sgi.sgi_id DESC LIMIT 1) as sgi_lst_estado,
               (SELECT sgi.sgi_id_etr FROM sgi_seguimiento_inc AS sgi WHERE sgi.sgi_id_inc = inc.inc_id ORDER BY sgi.sgi_id DESC LIMIT 1) as sgi_lst_estado_name,
               (SELECT count(*) AS sgi_marcada FROM sgi_seguimiento_inc AS sgi INNER JOIN etr_etapa_entregable AS etr ON etr.etr_id = sgi.sgi_id_etr WHERE etr.etr_orden = 1 
               AND sgi.sgi_id_inc = inc.inc_id) AS sgi_marcada, info.id AS info_id, info.username AS info_user, emp_info.emp_nombre AS info_nombre, emp_info.emp_apellido AS info_apellido, 
               emp_info.emp_color_icono AS info_avatar, asig.id AS asig_id, asig.username AS asig_user, IFNULL(emp_asig.emp_nombre, asig.username) AS asig_nombre, 
               emp_asig.emp_apellido AS asig_apellido, emp_asig.emp_color_icono AS asig_avatar, IFNULL( (SELECT anx_url FROM axe_anexoxempleado JOIN anx_anexo ON anx_id = axe_id_anx 
                WHERE axe_id_emp = emp_asig.emp_id AND anx_imagen = 1 ORDER BY anx_id DESC LIMIT 1), '') AS asig_foto,
               (SELECT GROUP_CONCAT(DISTINCT IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido), CONCAT_WS(' ', cli_codigo, cli_apellido)) SEPARATOR ', *' )
                FROM inl_incidencia_cliente JOIN cli_cliente on cli_id = inl_id_cli WHERE inl_id_inc = inc.inc_id ) AS cli_nombre, '' AS cli_apellido
               ", false)
                ->from('inc_incidencia as inc')
                ->join('tii_tipo_incidencia AS tii', 'tii.tii_id = inc.inc_id_tii', 'inner')
                ->join('cmp_componente AS cmp', 'cmp.cmp_id = inc.inc_id_cmp', 'inner')
                ->join('users AS info', 'info.id = inc.inc_id_usr_informante', 'inner')
                ->join('emp_empleado AS emp_info', 'emp_info.emp_id = info.usu_id_emp', 'left')
                ->join('users AS asig', 'asig.id = inc.inc_id_usr_asignado', 'inner')
                ->join('emp_empleado AS emp_asig', 'emp_asig.emp_id = asig.usu_id_emp', 'left')
                ->join('enr_entregable AS enr', 'enr.enr_id = inc.inc_id_enr', 'inner')
                ->join('pry_proyecto AS pry', 'pry.pry_id = inc.inc_id_pry', 'inner')
        ;


        if ($where != '') {
            $this->db->where($where);
        }

        if ($where_cliente != '') {
            $this->db->where($where_cliente,null,false);
        }

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    public function get_data_reportes($where = null) {
        $query = $this->db->select("inc_id_etr, inc_id_usr_asignado, pry_nombre, enr_codigo, enr_fecha_inicio, enr_fecha_fin, inc_importancia, inc_nombre, 
            inc_codigo,inc_estimacion, MAX(sgi_fecha) AS sgi_fecha, (SELECT etr_nombre FROM etr_etapa_entregable WHERE etr_id = inc_id_etr ) AS etrnombre,
            IF(ISNULL(enr_fecha_fin), NOW(),enr_fecha_fin) AS fecha_actual, IF(ISNULL(emp_id), username, CONCAT_WS(' ', emp_nombre, emp_apellido)) AS username,
            IF(ISNULL(enr_fecha_fin), DATEDIFF(NOW(), DATE(MAX(sgi_fecha))), DATEDIFF(DATE(enr_fecha_fin), DATE(MAX(sgi_fecha)))) AS diferencia", false)
            ->from('inc_incidencia')
            ->join('pry_proyecto', 'pry_id = inc_id_pry', 'inner')
            ->join('enr_entregable', 'enr_id = inc_id_enr', 'left')
            ->join('users', 'id = inc_id_usr_asignado', 'inner')
            ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
            ->join('sgi_seguimiento_inc', 'sgi_id_inc = inc_id', 'inner')
            ->group_by('inc_codigo')
            ->order_by('inc_codigo')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
        // 2023 - CAMBIO DE LOGICA YA QUE REPORTE SOLO MOSTRABA DATOS CUANDO EL CONSULTADO ES PM EN ALGUN PROYECTO, DEBIENDO MOSTRAR PARA TODOS
        // if ($where != null) {
        //     $i = 0;
        //     $where_text = '';
        //     foreach ($where as $key => $value) {
        //         if ($i > 0) {
        //             $where_text .= " And ";
        //         } else {
        //             $where_text .= "WHERE ";
        //         }
        //         if ($value == null) {
        //             $where_text .= $key;
        //         } else {
        //             $where_text .= $key." = ".$value;
        //         }
        //         $i ++;
        //     }
        // }        
        // $query1 = ('select pry_nombre,  enr_codigo, enr_fecha_inicio, inc_importancia, enr_fecha_fin, id, inc_codigo, inc_nombre, sgi_fecha,
        //     IF(emp_id != " ",CONCAT_WS(" ",emp_nombre,emp_apellido), username) as username, inc_estimacion/*,etr_nombre*/,
        //     (SELECT f.etr_nombre FROM sgi_seguimiento_inc as s INNER JOIN etr_etapa_entregable f ON f.etr_id = s.sgi_id_etr 
        //     WHERE  sgi_id_inc = a.inc_id ORDER BY sgi_fecha DESC LIMIT 1) as etrnombre, IF(enr_fecha_fin = " ", NOW(), enr_fecha_fin) as fecha_actual, 
        //     IF(enr_fecha_fin = " ", DATEDIFF(NOW(),sgi_fecha), DATEDIFF(enr_fecha_fin,sgi_fecha)) as diferencia
        //     from inc_incidencia a
        //     INNER JOIN pry_proyecto b ON inc_id_pry = pry_id
        //     LEFT JOIN enr_entregable c ON inc_id_enr = enr_id
        //     INNER JOIN users d ON inc_id_usr_asignado = d.id
        //     INNER JOIN sgi_seguimiento_inc e ON sgi_id_inc = inc_id
        //     LEFT JOIN emp_empleado f ON d.usu_id_emp = f.emp_id
        //     '.$where_text.'
        //     GROUP BY inc_codigo'
        // );
        // $detalle = $this->db->query($query1)->result_array();
        // return $detalle;
    }

    public function get_usuarios($where = null) {

        $query = $this->db->select()
                ->from('inc_incidencia AS inc')
                ->join('users as usr', 'inc.inc_id_usr_asignado = usr.id', 'inner')
                ->join('pry_proyecto AS b', 'inc_id_pry = pry_id ', 'inner')
                ->join('enr_entregable AS c', 'inc_id_enr = enr_id', 'inner')
                ->where('c.enr_codigo', $where)
        ;

        return $query->get()->result_array();
    }

    public function get_usuarios2($where = null, $tipo = null) {

        $query = $this->db->select()
                ->from('inc_incidencia AS inc')
                ->join('users as usr', 'inc.inc_id_usr_asignado = usr.id', 'inner')
                ->join('pry_proyecto AS b', 'inc_id_pry = pry_id ', 'inner')
                ->join('enr_entregable AS c', 'inc_id_enr = enr_id', 'inner')
        ;

        if ($tipo == 2) {
            $this->db->where('pry_id', $where);
        }

        return $query->get()->result_array();
    }

    public function get_sprint($where = null, $tipo2 = null) {

        $query = $this->db->select('enr_codigo')
                ->distinct('enr_codigo')
                ->from('inc_incidencia AS inc')
                ->join('users as usr', 'inc.inc_id_usr_asignado = usr.id', 'inner')
                ->join('pry_proyecto AS b', 'inc_id_pry = pry_id ', 'inner')
                ->join('enr_entregable AS c', 'inc_id_enr = enr_id', 'inner')
        ;

        if ($tipo2 == 2) {
            $this->db->where('pry_id', $where);
        }

        return $query->get()->result_array();
    }

    public function get_data_generales_sprint($where = null) {

        $query = $this->db->select(
            'pry_id,
            pry_nombre,
            enr_codigo,
            enr_fecha_inicio,
            enr_fecha_fin,
            enr_num_hora_efectiva,
            enr_consultor,
	        ( enr_num_hora_efectiva * enr_consultor) AS multiplicacion,
	        IFNULL( ( SELECT sum( inc_estimacion ) FROM inc_incidencia WHERE inc_id_etr != ( SELECT etr_id FROM etr_etapa_entregable WHERE etr_finalizacion = 1 LIMIT 1 ) AND inc_id_enr = enr_id ), 0 ) AS estima_ingr,
            IFNULL( ( SELECT sum( inc_estimacion ) FROM inc_incidencia WHERE inc_id_etr = ( SELECT etr_id FROM etr_etapa_entregable WHERE etr_finalizacion = 1 LIMIT 1 ) AND inc_id_enr = enr_id ), 0 ) AS estima_efectiva,', false)
                ->from('enr_entregable')
                ->join('pry_proyecto', 'enr_id_pry = pry_id ', 'left')
                //->join('enr_entregable AS c', 'enr_id = inc_id_enr', 'LEFT')
        ;
        $this->db->order_by('enr_fecha_inicio');

        if ($where != null) {
            $this->db->where($where);
        }
        

        return $query->get()->result_array();
    }

    public function get_data_etapas($where = null) {
        if ($where != null) {            
            $where_text = '';
            foreach ($where as $key => $value) {
                $where_text .= " And ";                
                if ($value == null) {
                    $where_text .= $key;
                } else {
                    $where_text .= $key." = ".$value;
                }                
            }
        }
        $query = $this->db->select("etr_id, etr_nombre, IFNULL((SELECT SUM(inc_estimacion) FROM inc_incidencia WHERE inc_id_etr = etr_id $where_text), 0) as cantidad", false)
                ->from('etr_etapa_entregable')
        ;
        return $query->get()->result_array();
    }

    public function get_data_seguimiento($where) {

        $query = $this->db->select()
                ->from('sgi_seguimiento_inc')
                ->join('inc_incidencia', 'inc_incidencia.inc_id = sgi_seguimiento_inc.sgi_id_inc', 'inner')
                ->join('etr_etapa_entregable', 'etr_etapa_entregable.etr_id = sgi_seguimiento_inc.sgi_id_etr', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_anexos($id_inc) {
        $this->db->select()
                ->from('inc_incidencia')
                ->join('axi_anexoxincidencia', 'inc_id = axi_id_inc')
                ->where('inc_id', $id_inc);
        $query = $this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $query;
    }

    function get_comentarios($where = null, $order_by = null) {

        $query = $this->db->select()
                ->from('cmi_comentario_inc')
                ->join('users', 'users.id = cmi_comentario_inc.cmi_usu_creacion', 'inner')
                ->join('emp_empleado', 'emp_empleado.emp_id = users.usu_id_emp', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    public function get_asig_incidencias($where) {

        $query = $this->db->select()
                ->from('enr_entregable')
                ->join('pry_proyecto', 'pry_id = enr_id_pry', 'inner')
        //->join('','enr_id = inc_id_enr','inner')
        //->group_by(array("enr_codigo"))
        ;
        $this->db->group_by(array("enr_codigo"));

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_entregables_por_usuario($where = null) {

        $query = $this->db->select()
                ->from('enr_entregable')
                ->join('pry_proyecto', 'pry_id = enr_id_pry', 'inner')
                ->join('uxp_usuarioxproyecto', 'uxp_id_pry = pry_id', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_listado_incidencias($where = null, $order_by = null) {
        $query = $this->db->select('inc.*,enr.*,cmp.*,tii.*,pry.*,info.*,emp_info.*', false)
                ->from('inc_incidencia as inc')
                ->join('tii_tipo_incidencia AS tii', 'tii.tii_id = inc.inc_id_tii', 'inner')
                ->join('cmp_componente AS cmp', 'cmp.cmp_id = inc.inc_id_cmp', 'inner')
                ->join('users AS info', 'info.id = inc.inc_id_usr_informante', 'inner')
                ->join('emp_empleado AS emp_info', 'emp_info.emp_id = info.usu_id_emp', 'left')
                ->join('users AS asig', 'asig.id = inc.inc_id_usr_asignado', 'inner')
                ->join('emp_empleado AS emp_asig', 'emp_asig.emp_id = asig.usu_id_emp', 'left')
                ->join('enr_entregable AS enr', 'enr.enr_id = inc.inc_id_enr', 'inner')
                ->join('pry_proyecto AS pry', 'pry.pry_id = inc.inc_id_pry', 'inner')
        ;


        if ($where != '') {
            $this->db->where($where);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }


    /**
     * Descripción:
     * Función para obtener los datos de los planes de trabajo
     * @author René Castaneda - Grupo Satélite
     * @since 2017-11-11
     * @param array $where Agreglo de condicionales para determinar bajo que criterior filtrar
     * @return Array asociativo de los datos que retorna la query ejecutada
     */
    public function get_plan_trabajo($where)
    {
        $this->db->select("
             ( SELECT
                GROUP_CONCAT( DISTINCT IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido)) SEPARATOR ', *' )
                FROM inl_incidencia_cliente 
                JOIN cli_cliente on cli_id = inl_id_cli
                WHERE inl_id_inc = inc_id
               )  AS CLIENTE, pm.username AS PROJECT_MANAGER,pry_nombre AS PROYECTO,cmp_nombre AS MODULO,
             inc_pantalla AS PANTALLA,inc_codigo AS INCIDENCIA,tii_nombre AS TIPO,inc_importancia AS IMPORTANCIA,
             inc_estimacion AS ESTIMACION,inc_nombre AS ASIGNACION,inc_descripcion AS DESCRIPCION, inc_fuente AS FUENTE,
             enr_codigo AS SPRINT,enr_fecha_inicio AS FECHA_INICIO,enr_fecha_fin AS FECHA_FIN,respon.username AS CONSULTOR,
             (SELECT etr_nombre FROM sgi_seguimiento_inc 
                JOIN etr_etapa_entregable on etr_id = sgi_id_etr  
                WHERE sgi_id_inc = inc_id 
                ORDER BY sgi_fecha DESC LIMIT 1) AS 'ETAPA', 
             ((inc_estimacion/IFNULL(enr_num_hora_efectiva,1) )*
              
            ((SELECT etr_finalizacion FROM sgi_seguimiento_inc 
                JOIN etr_etapa_entregable on etr_id = sgi_id_etr  
                WHERE sgi_id_inc = inc_id 
                ORDER BY sgi_fecha DESC LIMIT 1)
             )) AS CUMPLIMIENTO", false)
                ->from('inc_incidencia')
                ->join('cmp_componente','cmp_id=inc_id_cmp', 'left')
                ->join('pry_proyecto','pry_id=inc_id_pry')
                ->join('tii_tipo_incidencia','tii_id=inc_id_tii', 'left')
                ->join('enr_entregable','enr_id=inc_id_enr', 'left')
                ->join('users respon','inc_id_usr_asignado=respon.id', 'left')
                ->join('users pm','pry_id_usu_pm = pm.id ', 'left')

                ;
                

        if ($where) {
            foreach ($where as $key => $value) {
                if (( is_array($value) and count($value) > 0 ) or ( !is_array($value) and trim($value) != '' )) {
                    (is_array($value))? $this->db->where_in($key,$value): (($value == -1)? $this->db->where($key,null,false):$this->db->where($key,$value)); //si es arreglo usar el where in
                }
            }
            
        }
        $query = $this->db->get()->result_array();        
        return $query;
    }

    /**
     * Descripción:
     * Función para obtener los datos de las reuniones de scrum
     * @author René Castaneda - Grupo Satélite
     * @since 2017-11-14
     * @param array $where Agreglo de condicionales para determinar bajo que criterior filtrar
     * @return Array asociativo de los datos que retorna la query ejecutada
     */
    public function get_reunion_scrum($where)
    {
        $this->db->select("scr_scrum.*, users.*,
                GROUP_CONCAT(CONCAT(IF((ixs_porcentaje_avance >0 AND ixs_porcentaje_avance IS NOT NULL), CONCAT(inc_codigo, ' (', ixs_porcentaje_avance, '%)'), '')) SEPARATOR '#') incidencias,
                GROUP_CONCAT(CONCAT(IF((ixs_estimacion_faltante > 0 AND ixs_estimacion_faltante IS NOT NULL), CONCAT(inc_codigo,' (', ixs_estimacion_faltante, ')'), '')) SEPARATOR '#') AS estimacion,
                IFNULL((SELECT SUM((i.inc_estimacion * (x.ixs_porcentaje_avance/100))) FROM ixs_incidencia_scrum AS x JOIN inc_incidencia AS i ON i.inc_id = x.ixs_id_inc 
                    WHERE x.ixs_id_scr = scr_id),0) AS efectivas,
                IFNULL((SELECT SUM(x.ixs_estimacion_faltante) FROM ixs_incidencia_scrum AS x WHERE x.ixs_id_scr = scr_id),0) AS faltantes",
                false)
                ->from('scr_scrum')
                ->join('users','id = scr_id_usu_consultor')
                ->join('ixs_incidencia_scrum','ixs_id_scr = scr_id', 'left')
                ->join('inc_incidencia','inc_id = ixs_id_inc', 'left')
                ->group_by('scr_id')
                ->order_by('scr_fecha','ASC')
                ;

        if ($where) {
            foreach ($where as $key => $value) {
                if (( is_array($value) and count($value) > 0 ) or ( !is_array($value) and trim($value) != '' )) {
                    (is_array($value))? $this->db->where_in($key,$value): $this->db->where($key,$value); //si es arreglo usar el where in
                }
            }
            
        }
        $query = $this->db->get()->result_array();        
        return $query;
    }

    /**
     * Descripción:
     * Función para obtener los roles del usuario
     * @author René Castaneda - Grupo Satélite
     * @since 2017-11-14
     * @param int id del usuario
     * @return Array de los roles del usuario
     */
    public function get_roles_usuario($usu=0)
    {
        $usu  = ($usu > 0 )? $usu:$this->tank_auth->get_user_id();
        $this->db->select('uxr_id_rol')
                ->from('uxr_usuarioxrol')
                ->where('uxr_id_usu', $usu)
                ;
        $q = $this->db->get()->result_array();
        $roles = array();
        if ($q) {
            foreach ($q as $valor) {
                $roles[] = $valor['uxr_id_rol'];
            }
        }
        return $roles;
    }

    /**
     * Descripción:
     * Función para obtener las opciones de las incidencias para dibujar un select
     * @author René Castaneda - Grupo Satélite
     * @since 2017-12-27
     * @param array where
     * @return html select-options
     */
    public function get_option_incidencias($where=null){
        $select = '<option value=""></option>';
        $this->db->select("inc_id, inc_codigo AS cod, inc_estimacion AS estm, inc_nombre AS name, (SELECT etr_nombre FROM etr_etapa_entregable WHERE etr_id = inc_id_etr) AS etapa,
            IFNULL((SELECT MAX(ixs_porcentaje_avance) FROM ixs_incidencia_scrum WHERE ixs_estado = 1 AND ixs_id_inc = inc_id), 0) AS avance", false)
            ->from('inc_incidencia')
            ->join('sgi_seguimiento_inc', 'sgi_id_inc=inc_id')
            ->join('etr_etapa_entregable', 'etr_id=sgi_id_etr')
            ->join('enr_entregable', 'enr_id=inc_id_enr')
            ->where('enr_activo',1)
            ->group_by('inc_id')
        ;
        if ($where) {
            $this->db->where($where);
        }
        $query = $this->db->get()->result_array();
        foreach ($query as $key => $val) {
            $select .= '<option value="'.$val['inc_id'].'" data-estima="'.$val['estm'].'" data-avance="'.$val['avance'].'" data-etapa="'.$val['etapa'].'" data-name="'.$val['name'].'">'.$val['cod'].' :: '.$val['name'].'</option>';
        }
        return $select;
    }

    /**
     * Descripción:
     * Función para obtener el avanza de una incidencia
     * @author René Castaneda - Grupo Satélite
     * @since 2017-12-27
     * @param array where
     * @return html select-options
     */
    public function get_avance_incidencia($where=null){
        $this->db->select("*, IFNULL((SELECT MAX(i.ixs_porcentaje_avance) FROM ixs_incidencia_scrum AS i WHERE ixs_estado = 1 AND i.ixs_id_inc = inc_id), 0) AS avance", false)
            ->from('ixs_incidencia_scrum')
            ->join('inc_incidencia', 'inc_id = ixs_id_inc')
            ->join('etr_etapa_entregable', 'etr_id = inc_id_etr', 'left')
        ;
        if ($where) {
            $this->db->where($where);
        }
        $reg = $this->db->get()->result_array();
        return $reg;
    }


    /**
     * Descripción:
     * Función para obtener los proyectos validando usuario
     * @author René Castaneda - Grupo Satélite
     * @since 2017-12-27
     * @param array where
     * @param boolean opciones.
     * @return html select-options
     */
    public function get_proyectos($where=null, $options = false)
    {          
                if ($where and !$options) {
                    $this->db->where($where);
                }
                $this->db->join('uxp_usuarioxproyecto', 'uxp_id_pry = pry_id');
                $this->db->group_by('pry_id');
        return ($options)? $this->gsatelite->get_dropdown('pry_proyecto', '{pry_inicial} - {pry_nombre}','', $where, null, '', 'pry_id', true):$this->gsatelite->get_tabla('pry_proyecto', array('pry_estado' => 1));
    }

    /**
     * Descripción:
     * Función para obtener los proyectos validando usuario
     * @author René Castaneda - Grupo Satélite
     * @since 2017-12-27
     * @param array where
     * @param array where_having.
     * @return html select-options
     */
    public function get_incidencias_mover($where = null, $where_having = null)
    {
        $this->db->select("*
                    ,(SELECT sgi_id_etr from sgi_seguimiento_inc 
                    where sgi_id_inc = inc_id ORDER BY sgi_fecha DESC limit 1 ) id_etapa_actual,
                    (SELECT etr_nombre from sgi_seguimiento_inc 
                        JOIN etr_etapa_entregable on etr_id = sgi_id_etr 
                    where sgi_id_inc = inc_id ORDER BY sgi_fecha DESC limit 1 
                    ) nombre_etapa_actual,
                    IFNULL((SELECT sgi_id_etr from sgi_seguimiento_inc 
                        JOIN etr_etapa_entregable on etr_id = sgi_id_etr 
                    where sgi_id_inc = inc_id and etr_estimacion_cero = 1 ORDER BY sgi_fecha DESC limit 1 ), 0) etapa_estimacion_cero
                    ",
                     false)
                ->from('inc_incidencia')
                ->join('users','id = inc_id_usr_asignado')
                ->join('cmp_componente','cmp_id = inc_id_cmp', 'left')
                ->join('enr_entregable','enr_id = inc_id_enr', 'left')
                ->group_by('inc_id')
                ->order_by('inc_id_pry','ASC')
                ;

        if ($where) {
                $this->db->where($where);        
        }
        if ($where_having) {
                $this->db->having($where_having);        
        }
        $query = $this->db->get()->result_array();
    
        return $query;
    }

    /**
     * Descripción:
     * Función para obtener reporte de cumplimiento por consultor
     * @author Francisco Orozco.
     * @since 2018-01-10
     */
    public function get_cumplimiento_consultor($where_proyecto = 0, $where_sprint = "", $where_fecha ="", $where_consultor="",$where_etapas="",$having_etapas=""){
        $where_proyecto_string = '';
        if($where_proyecto != '' || $where_proyecto != 0){
            $where_proyecto_string = "AND pry_id = $where_proyecto";
        }
        $query = "SELECT REPOSITORIO.CONSULTOR, FECHA_INICIO, COUNT(REPOSITORIO.INCIDENCIA) AS INCIDENCIAS,
                    SUM(REPOSITORIO.ESTIMACION) AS HORAS,SUM(REPOSITORIO.CUMPLIMIENTO) AS CUMPLIMIENTO,
                    (SUM(REPOSITORIO.CUMPLIMIENTO) * get_parametro('SYS_HORAS_EFECTIVAS_PLAN_TRABAJO')) AS HORAS_EFECTIVAS,
                    AVG(REPOSITORIO.HORAS_ESTIM) as HORAS_ESTIM,
                    (((SUM( REPOSITORIO.CUMPLIMIENTO ) * get_parametro ( 'SYS_HORAS_EFECTIVAS_PLAN_TRABAJO' )) / AVG(REPOSITORIO.HORAS_ESTIM))) as CUMPLIMIENTO_2,
                    (( SUM( REPOSITORIO.CUMPLIMIENTO ) * get_parametro ( 'SYS_HORAS_EFECTIVAS_PLAN_TRABAJO' ) ) / SUM( REPOSITORIO.ESTIMACION )) as HORAS_ASIG
                FROM
                    (
                    SELECT cli_nombre AS CLIENTE, 'PM' AS PROJECT_MANAGER, pry_nombre AS PROYECTO,
                        cmp_nombre AS MODULO, 'PANTALLA' AS PANTALLA, inc_codigo AS INCIDENCIA,
                        tii_nombre AS TIPO, inc_importancia AS IMPORTANCIA, inc_estimacion AS ESTIMACION,
                        inc_nombre AS ASIGNACION, enr_codigo AS SPRINT, enr_fecha_inicio AS FECHA_INICIO,
                        enr_fecha_fin AS FECHA_FIN, CONCAT(emp_nombre, ' ', emp_apellido) AS CONSULTOR,
                        (
                        SELECT DISTINCT
                            (
                                SELECT
                                    etr_nombre
                                FROM
                                    sgi_seguimiento_inc D
                                INNER JOIN etr_etapa_entregable E ON E.etr_id = D.sgi_id_etr
                                WHERE
                                    D.sgi_id_inc = B.inc_id
                                ORDER BY
                                    sgi_fecha DESC
                                LIMIT 1
                            ) etapa
                        FROM
                            inc_incidencia B
                        INNER JOIN sgi_seguimiento_inc C ON C.sgi_id_inc = B.inc_id
                        WHERE
                            B.inc_id = A.inc_id
                        ORDER BY
                            1
                        ) AS 'ETAPA',
                        (
                        SELECT DISTINCT
                            (
                                SELECT
                                    etr_id
                                FROM
                                    sgi_seguimiento_inc D
                                INNER JOIN etr_etapa_entregable E ON E.etr_id = D.sgi_id_etr
                                WHERE
                                    D.sgi_id_inc = B.inc_id
                                ORDER BY
                                    sgi_fecha DESC
                                LIMIT 1
                            ) etapa
                        FROM
                            inc_incidencia B
                        INNER JOIN sgi_seguimiento_inc C ON C.sgi_id_inc = B.inc_id
                        WHERE
                            B.inc_id = A.inc_id
                        ORDER BY
                            1
                        ) AS 'ID_ETAPA',
                        (
                            (inc_estimacion / get_parametro('SYS_HORAS_EFECTIVAS_PLAN_TRABAJO')) * (
                                SELECT DISTINCT
                                    (
                                        SELECT
                                            etr_finalizacion
                                        FROM
                                            sgi_seguimiento_inc D
                                        INNER JOIN etr_etapa_entregable E ON E.etr_id = D.sgi_id_etr
                                        WHERE
                                            D.sgi_id_inc = B.inc_id
                                            $where_etapas
                                        ORDER BY
                                            sgi_fecha DESC
                                        LIMIT 1
                                    ) etapa
                                FROM
                                    inc_incidencia B
                                INNER JOIN sgi_seguimiento_inc C ON C.sgi_id_inc = B.inc_id
                                WHERE
                                    B.inc_id = A.inc_id
                                    $where_etapas
                                ORDER BY
                                    1
                            )
                        ) AS CUMPLIMIENTO, 
                        enr_num_hora_efectiva as HORAS_ESTIM
                    FROM
                        inc_incidencia A
                    LEFT JOIN cli_cliente ON cli_id = inc_id_cli
                    INNER JOIN cmp_componente ON cmp_id = inc_id_cmp
                    INNER JOIN pry_proyecto ON pry_id = inc_id_pry
                    INNER JOIN tii_tipo_incidencia ON tii_id = inc_id_tii
                    INNER JOIN enr_entregable ON enr_id = inc_id_enr
                    INNER JOIN emp_empleado ON inc_id_usr_asignado = emp_id_usu
                    WHERE
                        inc_id_usr_asignado in (
	                        SELECT uxp_id_usu from uxp_usuarioxproyecto WHERE uxp_id_pry = pry_id
                        ) 
                    AND inc_estado = 1
                    $where_proyecto_string $where_sprint $where_fecha $where_consultor 
                    $having_etapas
                ) REPOSITORIO
                GROUP BY
                    REPOSITORIO.CONSULTOR,
                    FECHA_INICIO
                ORDER BY
                    CUMPLIMIENTO DESC";
        $resultado = $this->db->query( $query );
        return $resultado->result_array();
    }


    /**
     * Descripción:
     * Función para obtener Reporte de estado de incidencias por cliente
     * @author Francisco Orozco.
     * @since 2018-01-11
     */
    public function get_incidencias_cliente($where_cliente = "", $where_sprint = "", $where_etapas = "", $estado = 1,$having_etapas ="", $where_fecha = "" ){
        $query = "SELECT IF(REPOSITORIO.CLIENTE = '' ,'SIN CLIENTE',REPOSITORIO.CLIENTE) AS CLIENTE, COUNT(REPOSITORIO.INCIDENCIA) AS INCIDENCIAS,
            SUM(REPOSITORIO.ESTIMACION) AS HORAS, SUM(REPOSITORIO.CUMPLIMIENTO) AS CUMPLIMIENTO,
            (SUM(REPOSITORIO.CUMPLIMIENTO) * get_parametro('SYS_HORAS_EFECTIVAS_PLAN_TRABAJO') ) AS HORAS_EFECTIVAS,
            REPOSITORIO.FECHA_INICIO
            FROM
                (
                    SELECT
                        IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido)) AS CLIENTE,
                        'PM' AS PROJECT_MANAGER,
                        pry_nombre AS PROYECTO,
                        cmp_nombre AS MODULO,
                        'PANTALLA' AS PANTALLA,
                        inc_codigo AS INCIDENCIA,
                        tii_nombre AS TIPO,
                        inc_importancia AS IMPORTANCIA,
                        inc_estimacion AS ESTIMACION,
                        inc_nombre AS ASIGNACION,
                        enr_codigo AS SPRINT,
                        enr_id as SPRINT_ID,
                        enr_fecha_inicio AS FECHA_INICIO,
                        enr_fecha_fin AS FECHA_FIN,
                        username AS CONSULTOR,
                        (
                            SELECT DISTINCT
                                (
                                    SELECT
                                        etr_nombre
                                    FROM
                                        sgi_seguimiento_inc D
                                    INNER JOIN etr_etapa_entregable E ON E.etr_id = D.sgi_id_etr
                                    WHERE
                                        D.sgi_id_inc = B.inc_id
                                    ORDER BY
                                        sgi_fecha DESC
                                    LIMIT 1
                                ) etapa
                            FROM
                                inc_incidencia B
                            INNER JOIN sgi_seguimiento_inc C ON C.sgi_id_inc = B.inc_id
                            WHERE
                                B.inc_id = A.inc_id
                            ORDER BY
                                1
                        ) AS 'ETAPA',
                        (
                        SELECT DISTINCT
                            (
                                SELECT
                                    etr_id
                                FROM
                                    sgi_seguimiento_inc D
                                INNER JOIN etr_etapa_entregable E ON E.etr_id = D.sgi_id_etr
                                WHERE
                                    D.sgi_id_inc = B.inc_id
                                ORDER BY
                                    sgi_fecha DESC
                                LIMIT 1
                            ) etapa
                        FROM
                            inc_incidencia B
                        INNER JOIN sgi_seguimiento_inc C ON C.sgi_id_inc = B.inc_id
                        WHERE
                            B.inc_id = A.inc_id
                        ORDER BY
                            1
                        ) AS 'ID_ETAPA',
                        (
                            (inc_estimacion / get_parametro('SYS_HORAS_EFECTIVAS_PLAN_TRABAJO')) * (
                                SELECT DISTINCT
                                    (
                                        SELECT
                                            etr_finalizacion
                                        FROM
                                            sgi_seguimiento_inc D
                                        INNER JOIN etr_etapa_entregable E ON E.etr_id = D.sgi_id_etr
                                        WHERE
                                            D.sgi_id_inc = B.inc_id
                                            $where_etapas
                                        ORDER BY
                                            sgi_fecha DESC
                                        LIMIT 1
                                    ) etapa
                                FROM
                                    inc_incidencia B
                                INNER JOIN sgi_seguimiento_inc C ON C.sgi_id_inc = B.inc_id
                                WHERE
                                    B.inc_id = A.inc_id
                                    $where_etapas
                                ORDER BY
                                    1
                            )
                        ) AS CUMPLIMIENTO
                    FROM
                        inc_incidencia A
                    LEFT JOIN inl_incidencia_cliente ON inl_id_inc = A.inc_id
	                LEFT JOIN cli_cliente ON cli_id = inl_id_cli
                    INNER JOIN cmp_componente ON cmp_id = A.inc_id_cmp
                    INNER JOIN pry_proyecto ON pry_id = A.inc_id_pry
                    INNER JOIN tii_tipo_incidencia ON tii_id = A.inc_id_tii
                    INNER JOIN enr_entregable ON enr_id = A.inc_id_enr
                    INNER JOIN users ON A.inc_id_usr_asignado = id
                    WHERE
                        enr_codigo IN (
                            SELECT
                                enr_codigo
                            FROM
                                enr_entregable
                            WHERE
                                enr_activo = $estado
                        )
                    $where_fecha
                    $where_cliente 
                    $where_sprint
                    $having_etapas
                ) REPOSITORIO
            GROUP BY
                REPOSITORIO.CLIENTE, REPOSITORIO.SPRINT_ID
            ORDER BY
                CUMPLIMIENTO DESC
        
        ";
        $resultado = $this->db->query( $query );
        return $resultado->result_array();
    }

    /**
     * Descripción:
     * Función para obtener las incidencias
     * @author Francisco Orozco.
     * @since 2018-01-25
     */
    public function get_incidencias($where = null){
        $query = $this->db->select()
                ->from('inc_incidencia')
                ->join('pry_proyecto','pry_id = inc_id_pry')
                ->join('enr_entregable','enr_id_pry = pry_id','left')
                ->join('sgi_seguimiento_inc','sgi_id_inc = inc_id','left')
                ->join('etr_etapa_entregable','etr_id = sgi_id_etr','left')
                ->join('uxp_usuarioxproyecto','uxp_id_pry = pry_id','left')
                ->group_by("inc_id")
        ;  
        if ($where) {
            $this->db->where($where);        
        }
        return $query->get()->result_array();
    }

    /**
     * Descripción:
     * Función para generar un select de cliente que poseen incidencias (para no cargar todos los clientes)
     * @author René Castaneda - Grupo Satélite
     * @since 2018-02-07
     * @param ninguno
     * @return html select
     */
    public function get_select_cliente_incidencia()
    {
                           $this->db->join('inl_incidencia_cliente', 'inl_id_cli=cli_id');
                           $this->db->group_by('cli_id');
       $select_cli = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => 1), null, null, null, true);
       return $select_cli;
    }

    /**
     * Descripción:
     * Función para obtener los datos de las asignaciones del un consultor.
     * @author René Castaneda - Grupo Satélite
     * @since 2018-02-15
     * @param array $where Agreglo de condicionales para determinar bajo que criterior filtrar
     * @return Array asociativo de los datos que retorna la query ejecutada
     */
    public function get_asignaciones_consultor($where)
    {
        $this->db->select("pry_nombre, pm.username AS project_manager
                    , enr_codigo, enr_fecha_inicio, enr_fecha_fin, respon.username AS responsable
                    , inc_codigo, inc_nombre, inc_estimacion, 
                    (SELECT CONCAT_WS('#@',etr_nombre,DATE(sgi_fecha),CURDATE(),(DATEDIFF(CURDATE(),DATE(sgi_fecha)))) FROM sgi_seguimiento_inc 
                     JOIN etr_etapa_entregable on etr_id = sgi_id_etr 
                     WHERE sgi_id_inc = inc_id 
                     ORDER BY sgi_fecha DESC LIMIT 1) AS 'etapa_fecha'
                    ", false)
                ->from('inc_incidencia')
                ->join('cmp_componente','cmp_id=inc_id_cmp', 'left')
                ->join('pry_proyecto','pry_id=inc_id_pry')
                ->join('tii_tipo_incidencia','tii_id=inc_id_tii', 'left')
                ->join('enr_entregable','enr_id=inc_id_enr', 'left')
                ->join('users respon','inc_id_usr_asignado=respon.id', 'left')
                ->join('users pm','pry_id_usu_pm = pm.id ', 'left')

                ;
                

        if ($where) {
            //$this->db->where($where);
            foreach ($where as $key => $value) {
                if (( is_array($value) and count($value) > 0 ) or ( !is_array($value) and trim($value) != '' )) {
                    (is_array($value))? $this->db->where_in($key,$value): (($value == -1)? $this->db->where($key,null,false):$this->db->where($key,$value)); //si es arreglo usar el where in
                }
            } 
            
        }

        $query = $this->db->get()->result_array();        
        return $query;
    }

    /**
     * Descripción:
     * Función para actualizar en la incidencia la etapa actual
     * @author René Castaneda - Grupo Satélite
     * @since 2018-02-16
     * @param int $id_seguimiento id del seguimiento de etapa
     * @return bool exito
     */
    public function actualizar_etapa_inc($id_seguimiento = 0)
    {
        $exito = 0;
        $q = $this->gsatelite->get_tabla('sgi_seguimiento_inc',array('sgi_id'=>$id_seguimiento)); 
        if ($q) {
            # code...
            $update_array = array(
               'inc_id_etr' => $q[0]['sgi_id_etr'],
               'inc_usu_modificacion' => $q[0]['sgi_usu_modificacion'],
               'inc_fecha_modificacion' => $q[0]['sgi_fecha_modificacion']
           );
           $exito = $this->gsatelite->actualizar_array('inc_incidencia', $update_array, array('inc_id'=>$q[0]['sgi_id_inc']));
        }
        return $exito;
    }

    /**
     * Descripción:
     * Función para obtener los datos para del diagrama
     * @author René Castaneda - Grupo Satélite
     * @since 2018-02-22
     * @param array $where Agreglo de condicionales para determinar bajo que criterior filtrar
     * @return Array asociativo de los datos que retorna la query ejecutada
     */
    public function get_velocidad_equipo($where)
    {
        $this->db->select("pry_nombre, enr_codigo, enr_fecha_inicio, enr_fecha_fin, inc_codigo, inc_nombre, inc_estimacion,
            (SELECT MAX(sgi_fecha) FROM sgi_seguimiento_inc  WHERE sgi_id_inc = inc_id LIMIT 1) fecha_seguimiento,
            (0) estimacion_finalizada
        ", false)
                ->from('inc_incidencia')
                ->join('cmp_componente','cmp_id=inc_id_cmp', 'left')
                ->join('pry_proyecto','pry_id=inc_id_pry')
                ->join('users', 'id=inc_id_usr_asignado', 'left')
                ->join('emp_empleado','emp_id = usu_id_emp', 'left')
                ->join('tii_tipo_incidencia','tii_id=inc_id_tii', 'left')
                ->join('enr_entregable','enr_id=inc_id_enr', 'left')
                ->group_by('pry_id')
                ->group_by('enr_id')

                ;
                

        if ($where) {
            $this->db->where($where);            
        }

        $query = $this->db->get()->result_array();        
        return $query;
    }

    /**
     * Descripción:
     * Función para obtener los clientes por proyecto
     * @author Rafael A. Cuchilla - Grupo Satélite
     * @since 2018-07-04
     * @param array where
     * @return html select-options
     */
    public function get_clientes_proyecto($where=null)
    {   
        $this->db->join("inl_incidencia_cliente", "inl_id_cli = cli_id");
        $this->db->join("inc_incidencia","inc_id = inl_id_inc");
        $this->db->join("pry_proyecto","inc_id_pry = pry_id");
        $this->db->group_by('cli_id');
        $reg = $this->gsatelite->get_tabla('cli_cliente',$where);        
        return $reg;
    }

    public function get_consultores($where = null){
        // SELECT emp_nombre, emp_apellido FROM uxp_usuarioxproyecto
        // INNER JOIN emp_empleado ON emp_id_usu = uxp_id_usu
        // GROUP BY emp_id
        $this->db->select()
                ->from('uxp_usuarioxproyecto')
                ->join('emp_empleado','emp_id_usu = uxp_id_usu', 'inner')
                ->group_by('emp_id');
        if($where != null){
            $this->db->where($where);
        }
        $query = $this->db->get()->result_array();        
        return $query;
    }

    public function get_consultores_completo($where = null){
        $this->db->select()
                ->from('uxp_usuarioxproyecto')
                ->join('users', 'id = uxp_id_usu')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                ->group_by('id');
        if($where != null){
            $this->db->where($where);
        }
        $query = $this->db->get()->result_array();        
        return $query;
    }

    public function get_pruebas_sugeridas($where = null){
        $this->db->select('*')
                 ->from('pbg_prueba_sugerida',false)
                 ->join('esb_estado_prueba' ,'esb_id = pbg_id_esb','LEFT');
            if ($where !== null) {
                $this->db->where($where);
            }
        return $this->db->get()->result_array();
    }


    /**
     * Descripción: Función para obtener Cantidad de incidencias de cliente por estado
     * @author Raul E.
     */
    public function get_ultimos_sprints_activos($where = null){
        $this->db->select("pry_id, pry_nombre, pry_inicial, (SELECT enr_id FROM enr_entregable WHERE enr_id_pry = pry_id AND enr_estado = 1 AND enr_activo = 1 
            AND enr_fecha_fin IS NULL ORDER BY enr_fecha_inicio DESC LIMIT 1) AS id_cierra_sprint, (SELECT CONCAT(enr_codigo,' - ',enr_nombre) FROM enr_entregable 
            WHERE enr_id_pry = pry_id AND enr_estado = 1 AND enr_activo = 1 AND enr_fecha_fin IS NULL ORDER BY enr_fecha_inicio DESC LIMIT 1) AS cierra_sprint", false)
            ->from('pry_proyecto')
            ->where('pry_estado', 1)
        ;                
        if ($where) {
            $this->db->where($where);            
        }
        return $this->db->get()->result_array();        
    }

    function get_usuarios_empleados($where = null) {
        $query = $this->db->select()
                ->from('users')
                ->join('emp_empleado', 'emp_empleado.emp_id = users.usu_id_emp')
                ->join('are_area', 'emp_empleado.emp_id_are = are_area.are_id', 'left')
                ->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left')
                ->join('suc_sucursal', 'emp_empleado.emp_id_suc = suc_sucursal.suc_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('users.id');

        return $query->get()->result_array();
    }

    function get_usuarios_configuracion($where = null) {
        $query = $this->db->select()
            ->from('users')
            ->join('uxo_usuarioxconfiguracion','uxo_usuarioxconfiguracion.uxo_id_usu = users.id','inner')
            ->join('emp_empleado', 'emp_empleado.emp_id = users.usu_id_emp', 'left')
            ->join('are_area', 'emp_empleado.emp_id_are = are_area.are_id', 'left')
            ->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left')
            ->join('suc_sucursal', 'emp_empleado.emp_id_suc = suc_sucursal.suc_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function actualizar_etapa_ticket($id_seguimiento = 0)
    {
        $exito = 0;
        $q = $this->gsatelite->get_tabla('sgk_seguimiento_ticket',array('sgk_id'=>$id_seguimiento)); 
        if ($q) {
            # code...
            $update_array = array(
               'tkh_id_esk' => $q[0]['sgk_id_esk'],
               'tkh_usu_modificacion' => $q[0]['sgk_usu_modificacion'],
               'tkh_fecha_modificacion' => $q[0]['sgk_fecha_modificacion']
           );
           $exito = $this->gsatelite->actualizar_array('tkh_ticket_helpdesk', $update_array, array('tkh_id'=>$q[0]['sgk_id_tkh']));
        }
        return $exito;
    }  
    
    function get_usuarios_completos_v2($where = null) {
        $query = $this->db->select()
                ->from('inc_incidencia')
                ->join('users', 'users.id = inc_incidencia.inc_id_usr_asignado')
                ->join('emp_empleado', 'emp_empleado.emp_id = users.usu_id_emp', 'left')
                ->join('are_area', 'emp_empleado.emp_id_are = are_area.are_id', 'left')
                ->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left')
                ->join('suc_sucursal', 'emp_empleado.emp_id_suc = suc_sucursal.suc_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_anexos_ticket($id_tkh) {
        $this->db->select()
            ->from('tkh_ticket_helpdesk')
            ->join('axh_anexo_ticket_heldesk', 'tkh_id = axh_id_tkh')
            ->where('tkh_id', $id_tkh);
        $query = $this->db->get()->result_array();
        return $query;
    } 
    
    function get_tickets($where = null) {
        $query = $this->db->select("*, 
                COALESCE((
                    SELECT CONCAT(emp.emp_nombre, ' ', emp_apellido)
                    FROM users u
                    JOIN emp_empleado emp ON emp.emp_id = u.usu_id_emp
                    WHERE u.id = tkh_ticket_helpdesk.tkh_id_usr_asignado
                    LIMIT 1
                ), '-') AS usuario_asignado
            ", false)
            ->from('tkh_ticket_helpdesk')
            ->join('pry_proyecto', 'pry_id = tkh_id_pry', 'left')
            ->join('cft_configuracion_ticket', 'cft_id_pry = pry_id', 'left')
            ->join('ret_responsable_confg_ticket_helpdesk', "ret_id_cft = cft_id", 'left')
            ->join('cmp_componente', 'cmp_id = tkh_id_cmp', 'left')
            ->join('tpp_tipo_prioridad', 'tpp_id = cmp_id_tpp', 'left')
            ->join('tii_tipo_incidencia', 'tii_id = tkh_id_tii', 'left')
            ->join('sgk_seguimiento_ticket', 'sgk_id_tkh = tkh_id and sgk_estado = 1', 'left')
            ->join('esk_estado_ticket', 'esk_id = sgk_id_esk', 'left')
            ->join('inc_incidencia', 'inc_id_tkh = tkh_id', 'left')
            ->join('users', 'tkh_id_usr_informante = id', 'left')
            ->join('emp_empleado', 'usu_id_emp = emp_id', 'left')
            ->join('are_area', 'emp_id_are = are_id', 'left')
            ->group_by('tkh_id')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get()->result_array();
        return $query;

    }

    public function get_comentarios_ticket($where = null, $order_by = null)
    {
        $query = $this->db->select()
            ->from('cmk_comentario_ticket')
            ->join('users', 'id = cmk_id_usu', 'inner')
            ->join('emp_empleado', 'usu_id_emp = emp_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        $query = $this->db->get()->result_array();
        return $query;
    }    

    function get_responsables_configuracion($where = null) {
        $query = $this->db->select()
            ->from('users')
            ->join('ret_responsable_confg_ticket_helpdesk','ret_responsable_confg_ticket_helpdesk.ret_id_usu = users.id','inner')
            ->join('emp_empleado', 'emp_empleado.emp_id = users.usu_id_emp', 'left')
            ->join('are_area', 'emp_empleado.emp_id_are = are_area.are_id', 'left')
            ->join('plz_plaza', 'emp_empleado.emp_id_plz = plz_plaza.plz_id', 'left')
            ->join('suc_sucursal', 'emp_empleado.emp_id_suc = suc_sucursal.suc_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function reporte_estado_ticket($where, $fecha_inicio, $fecha_fin)
    {

        $adicional_where_join = "";

        if($fecha_inicio != ''){
            $adicional_where_join .= "and DATE(sgk_fecha) >= '".$fecha_inicio."'";
        }
        if($fecha_fin != '') {
            $adicional_where_join .= "and DATE(sgk_fecha) <= '".$fecha_fin."'";
        }

        $query = $this->db->select("esk_id, esk_nombre, count(sgk_id) as cantidad_estado_ticket", false)
            ->from('esk_estado_ticket')
            ->join('sgk_seguimiento_ticket', 'sgk_id_esk = esk_id and sgk_estado = 1 '.$adicional_where_join, 'left')
            ->join('tkh_ticket_helpdesk', 'tkh_id_cmp = sgk_id_tkh', 'left')
            ->group_by('esk_id')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get()->result_array();
        return $query;

    }

    public function reporte_componente_ticket($where, $fecha_inicio, $fecha_fin)
    {

        $adicional_where_join = "";

        if($fecha_inicio != ''){
            $adicional_where_join .= "and DATE(tkh_fecha_ingreso) >= '".$fecha_inicio."'";
        }
        if($fecha_fin != '') {
            $adicional_where_join .= "and DATE(tkh_fecha_ingreso) <= '".$fecha_fin."'";
        }

        $query = $this->db->select("cmp_id, cmp_nombre, count(tkh_id_cmp) as cantidad_componente", false)
            ->from('cmp_componente')
            ->join('tkh_ticket_helpdesk', 'tkh_id_cmp = cmp_id '.$adicional_where_join, 'left')
            ->group_by('cmp_id')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get()->result_array();
        return $query;

    }

    public function reporte_tipo_prioridad($where, $fecha_inicio, $fecha_fin)
    {

        $adicional_where_join = "";

        if($fecha_inicio != ''){
            $adicional_where_join .= "and DATE(tkh_fecha_ingreso) >= '".$fecha_inicio."'";
        }
        if($fecha_fin != '') {
            $adicional_where_join .= "and DATE(tkh_fecha_ingreso) <= '".$fecha_fin."'";
        }

        $query = $this->db->select("tpp_id, tpp_nombre, count(tkh_id_tpp) as cantidad_tipo_prioridad", false)
            ->from('tpp_tipo_prioridad')
            ->join('tkh_ticket_helpdesk', 'tkh_id_tpp = tpp_id '.$adicional_where_join, 'left')
            ->group_by('tpp_id')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get()->result_array();
        return $query;

    }      


}

?>