<?php

/**
 * @author Francisco Orozco
 * @method Modelo - Modulo Cuentas por pagar
 */
class Cuentas_pagar_model extends CI_Model {

    function __construct() {

        $this->load->database();
    }

    /*
     * @author: Mario Marquez
     */

    public function get_proveedores($where = null,$like = null,$select = "*") {
        $query = $this->db->select($select, false)
                ->from('prv_proveedor')
                ->join('acp_act_economica_prov', 'acp_id = prv_id_acp', 'left')
                ->join('mun_municipio', 'mun_id = prv_id_mun', 'left')
                ->join('dep_departamento', 'dep_id = mun_id_dep', 'left')
                ->join('pai_pais', 'pai_id  = prv_id_pai', 'left')
                ->join('tap_tamano_prov', ' tap_id = prv_id_tap', 'left')
                ->join('gir_giro', 'gir_id = prv_id_gir', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->or_like($like);
        }

        return $query->get()->result_array();
    }

    /*
     * @author: Mario Marquez
     */

    public function get_agenda_pagos($where = null, $order_by = null) {
 //      (SELECT COUNT(*) FROM agp_agenda_pago
 // INNER JOIN chp_cheque_pendiente ON chp_id_agp = agp_id
 // WHERE agp_id_dpv = dpv_id AND chp_generado = 0  and chp_estado = 1) as agendas_pendientes

        $query = $this->db->select('*, (SELECT count(*) '
                        . 'FROM chp_cheque_pendiente '
                        . 'WHERE chp_id_dpv = dpv_id AND chp_generado = 0 and chp_estado = 1) as cheques_pendientes,'
                        . '(SELECT COUNT(*) FROM agp_agenda_pago

                    WHERE agp_id_dpv = dpv_id AND agp_estado = 1) as agendas_pendientes,
                    (SELECT count(che_id) FROM che_cheque
                    INNER JOIN chp_cheque_pendiente ON chp_id_che = che_id
                    INNER JOIN tra_transaccion ON tra_id = che_id_tra
                    WHERE chp_id_dpv = dpv_id AND tra_aplicar = 0 and chp_estado = 1) as cheque_sin_aplicar
                    ')
                ->from('dpv_documento_proveedor')
                ->join('prv_proveedor', 'dpv_id_prv = prv_id', 'inner')
                ->join('tif_tipo_factura', 'tif_id = dpv_id_tif', 'inner')
                ->join('agp_agenda_pago', 'agp_id_dpv = dpv_id  AND agp_estado = 1', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    /*
     * @author: Mario Marquez
     */

    public function get_aprobacion_pagos($where = null) {

        $query = $this->db->select('*, (SELECT COUNT(*) FROM chp_cheque_pendiente WHERE chp_id_dpv = dpv_id AND chp_generado = 0 AND chp_estado > 0) as cheques_pendientes', false)
                ->from('dpv_documento_proveedor')
                ->join('prv_proveedor', 'dpv_id_prv = prv_id', 'inner')
                ->join('tif_tipo_factura', 'tif_id = dpv_id_tif', 'left')
                ->join('agp_agenda_pago', 'agp_id_dpv = dpv_id AND agp_estado_agenda = 0', 'inner')
                ->join('frp_forma_pago','frp_id = agp_id_frp','left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /*
     * @author: Mario Marquez
     */

    public function get_antiguedad_saldos($where = null,$fecha) {

        $query = $this->db->select(
                        'prv_nombre,prv_apellido,prv_codigo,prv_tipo_pers,'
                        . '(SELECT SUM(dpv.dpv_monto_pendiente /* - dpv.dpv_retencion */)
                    FROM dpv_documento_proveedor as dpv
                    WHERE dpv.dpv_id_prv = prv_id AND
                    DATEDIFF("'.$fecha.'",dpv.dpv_fecha_vencimiento) <= 0
                    AND dpv.dpv_pagado = 0
                    AND dpv.dpv_estado = 1
                   -- AND dpv.dpv_id_tpg = 2
                    ) as monto_sin_vencer,
                    (SELECT SUM(dpv.dpv_monto_pendiente /* - dpv.dpv_retencion */)
                    FROM dpv_documento_proveedor as dpv
                    WHERE dpv.dpv_id_prv = prv_id AND
                    DATEDIFF("'.$fecha.'",dpv.dpv_fecha_vencimiento) BETWEEN 1 AND 30
                    AND dpv.dpv_pagado = 0
                    AND dpv.dpv_estado = 1
                   -- AND dpv.dpv_id_tpg = 2
                    ) as monto_rango_uno,
                    (
                    SELECT SUM(dpv.dpv_monto_pendiente /* - dpv.dpv_retencion */)
                    FROM dpv_documento_proveedor as dpv
                    WHERE dpv.dpv_id_prv = prv_id AND
                    DATEDIFF("'.$fecha.'",dpv.dpv_fecha_vencimiento) BETWEEN 31 AND 60
                    AND dpv.dpv_pagado = 0
                    AND dpv.dpv_estado = 1
                   -- AND dpv.dpv_id_tpg = 2
                    ) as monto_rango_dos,
                    (
                    SELECT SUM(dpv.dpv_monto_pendiente /* - dpv.dpv_retencion */)
                    FROM dpv_documento_proveedor as dpv
                    WHERE dpv.dpv_id_prv = prv_id AND
                    DATEDIFF("'.$fecha.'",dpv.dpv_fecha_vencimiento) BETWEEN 61 AND 90
                    AND dpv.dpv_pagado = 0
                    AND dpv.dpv_estado = 1
                  --  AND dpv.dpv_id_tpg = 2
                    ) as monto_rango_tres,
                    (
                    SELECT SUM(dpv.dpv_monto_pendiente /* - dpv.dpv_retencion */)
                    FROM dpv_documento_proveedor as dpv
                    WHERE dpv.dpv_id_prv = prv_id AND
                    DATEDIFF("'.$fecha.'",dpv.dpv_fecha_vencimiento) BETWEEN 91 AND 120
                    AND dpv.dpv_pagado = 0
                    AND dpv.dpv_estado = 1
                   -- AND dpv.dpv_id_tpg = 2
                    ) as monto_rango_cuatro,
                    (
                    SELECT SUM(dpv.dpv_monto_pendiente /* - dpv.dpv_retencion */)
                    FROM dpv_documento_proveedor as dpv
                    WHERE dpv.dpv_id_prv = prv_id
                    AND
                    DATEDIFF("'.$fecha.'",dpv.dpv_fecha_vencimiento) > 120
                    AND dpv.dpv_pagado = 0
                    AND dpv.dpv_estado = 1
                  -- AND dpv.dpv_id_tpg = 2
                    ) as monto_rango_cinco,
                    (
                    SELECT SUM(dpv.dpv_monto_pendiente /* - dpv.dpv_retencion */)
                    FROM dpv_documento_proveedor as dpv
                    WHERE dpv.dpv_id_prv = prv_id
                    AND dpv.dpv_pagado = 0
                    AND dpv.dpv_estado = 1
                   -- AND dpv.dpv_id_tpg = 2
                    ) as monto_total,
                    (
                        SELECT
                            COUNT(dpv.dpv_id)
                        FROM
                            dpv_documento_proveedor AS dpv
                        WHERE
                            dpv.dpv_id_prv = prv_id
                        AND DATE(dpv.dpv_fecha_vencimiento) < CURDATE()
                        AND dpv.dpv_pagado = 0
                        AND dpv.dpv_estado = 1
                      --  AND dpv.dpv_id_tpg = 2
                    ) AS vencidos,
                    prv_dias_plazo'
                        , false)
                ->from('prv_proveedor')
                ->join('clp_clasificacion_proveedor','clp_id = prv_id_clp','left')
        //->join('dpv_documento_proveedor','dpv_id_prv = prv_id','inner')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /*
     * @author: Mario Marquez
     * $resumido: 1 = Genera el reporte agrupado solo por proveedor, null = Genera el reporte detallado
     */

    public function get_cuentas_pagar_doc_proveedor($where = null, $resumido = null) {

        if ($resumido == null) {
            $query = $this->db->select('dpv_id,prv_id,
            dpv_numero_documento,prv_codigo,prv_nombre,prv_apellido,prv_tipo_pers,tif_nombre as tipo_doc,
            dpv_fecha_documento,dpv_fecha_vencimiento,prv_dias_plazo,
            DATEDIFF(NOW(),dpv_fecha_vencimiento) as dias_vencido,
            dpv_total,dpv_monto_abono,dpv_monto_pendiente', false)
                    ->from('dpv_documento_proveedor')
                    ->join('prv_proveedor', 'dpv_id_prv = prv_id', 'inner')
                    ->join('tif_tipo_factura', 'tif_id = dpv_id_tif', 'inner')
            ;
        } else {
            $query = $this->db->select('prv_id,prv_codigo,
                prv_nombre,prv_apellido,prv_tipo_pers,
                prv_dias_plazo,
                SUM(dpv_total) as monto_docs,
                SUM(dpv_monto_abono) as monto_abonado,
                SUM(dpv_monto_pendiente) as saldo', false)
                    ->from('prv_proveedor')
                    ->join('dpv_documento_proveedor', 'dpv_id_prv = prv_id AND dpv_pagado = 0 and dpv_estado = 1', 'inner')
                    ->join('tif_tipo_factura', 'tif_id = dpv_id_tif', 'left')
            ;

            $this->db->group_by('prv_id');
        }

        $this->db->order_by('prv_nombre,dpv_fecha_documento ASC');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_saldo_proveedor($where = null) {

        $query = $this->db->select("IFNULL(SUM(dpv_monto_pendiente), 0) as saldo", false)
                ->from('dpv_documento_proveedor')
                ->join('dch_detalle_cheque', 'dch_id_dpv = dpv_id', 'left')
                ->join('dna_detalle_nota_abono', 'dna_id_dpv = dpv_id', 'left')
                ->where('dna_id_dpv IS NULL')
                ->where('dch_id_dpv IS NULL')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        $saldo = $query->get()->row();


        return ($saldo->saldo == null) ? 0 : $saldo->saldo;
    }

    public function get_estado_cuentas_proveedor($where = null) {

        if ($where != null) {
            $where_docs = $where['documentos'];
            $where_che = $where['cheques'];
            $where_che_estado = $where['estado'];
        }

        //Se obtienen los documentos
        $query = $this->db->select(
                        "dpv_id AS registro,
		dpv_numero_documento AS num_doc,
		dpv_fecha_documento AS fecha_doc,
		dpv_total AS monto,
                tif_nombre AS tipo_doc,
		1 AS tipo,
        pct_codigo as code", FALSE)
                ->from('dpv_documento_proveedor')
                ->join('tif_tipo_factura', 'dpv_id_tif = tif_id', 'inner')
                ->join('pct_partida_contable','pct_id = dpv_id_pct','LEFT')
        ;
        if ($where_docs != null) {
            $this->db->where($where_docs);
        }


        $result = $query->get()->row();
        $query_docs = $this->db->last_query();

        //Se obtienen los documentos con cheques
        $query = $this->db->select(
                        "dpv_id AS registro,
			che_numero AS num_doc,
			che_fecha AS fecha_doc,
			dch_subtotal AS monto,
                        'Cheque' as tipo_doc,
			2 AS tipo, '' as code"
                        , FALSE)
                ->from('dpv_documento_proveedor')
                ->join('dch_detalle_cheque', 'dch_id_dpv = dpv_id', 'inner')
                ->join('che_cheque', 'che_id = dch_id_che', 'inner')
        ;

        if ($where_che != null) {
            $this->db->where($where_che);
            $this->db->where($where_che_estado);//Estado del cheque
        }
        

        $result = $query->get()->row();
        $query_cheques = $this->db->last_query();

        //se obtienen notas de abono
        $query = $this->db->select(
                        "dpv_id AS registro,
                        nta_codigo AS num_doc,
                        nta_fecha AS fecha_doc,
                        nta_monto AS monto,
                        'Transferencia Bancaria' AS tipo_doc,
                        3 AS tipo,
                        '' AS code "
                        , FALSE)
                ->from('dpv_documento_proveedor')
                ->join('dna_detalle_nota_abono', 'dna_id_dpv = dpv_id', 'inner')
                ->join('nta_nota_abono', 'nta_id = dna_id_nta', 'inner')
        ;

        if ($where_docs != null) {
            $this->db->where($where_docs); //fecha del documento y estado
            $this->db->where(array("nta_estado" => 1, "dpv_estado" => 1));//Estado de la nota de abono
        }
        
        $result = $query->get()->row();
        $query_notas = $this->db->last_query();

        //se obtiene las otras formas de pagos
        $query = $this->db->select(
                        "dpv_id AS registro,
                        ofp_codigo AS num_doc,
                        ofp_fecha AS fecha_doc,
                        ofp_monto AS monto,
                        'Otra Formas' AS tipo_doc,
                        4 AS tipo,
                        '' AS code"
                        , FALSE)
                ->from('dpv_documento_proveedor')
                ->join('ofp_otra_forma_pago', 'ofp_id_dpv = dpv_id', 'inner')
        ;

        if ($where_docs != null) {
            $this->db->where($where_docs); //fecha del documento y estado
            $this->db->where(array("ofp_estado" => 1, "dpv_estado" => 1));//Estado de la nota de abono
        }
        
        $result = $query->get()->row();
        $query_otras_formas = $this->db->last_query();


        $query_final = "(" . $query_docs . ") union (" . $query_cheques . ") union (" . $query_notas . ") union (" . $query_otras_formas . ") ORDER BY registro, tipo asc";
        $resultado = $this->db->query($query_final);
        //print_r($this->db->last_query());die();
        return $resultado->result_array();
    }

    public function get_reporte_pagos($where = null, $having = NULL) {
        //Se obtienen los documentos con cheques
        $query = $this->db->select("dpv_documento_proveedor.*, tif_tipo_factura.*, IFNULL(che_fecha,nta_fecha) AS che_fecha, IFNULL(dch_valor,dna_valor) AS dch_subtotal,
                                    IFNULL(b1.ban_nombre,b2.ban_nombre) AS ban_nombre, IFNULL(t1.tra_aplicar,t2.tra_aplicar) AS se_aplico, IFNULL(che_numero,nta_codigo) AS che_numero,
                                    IF(nta_id IS NULL,'Cheque','Transferencia') AS tipo_pago",false)
                ->from('dpv_documento_proveedor')
                ->join('prv_proveedor', 'prv_id = dpv_id_prv')
                ->join('tif_tipo_factura', 'tif_id = dpv_id_tif')
                ->join('dch_detalle_cheque', 'dch_id_dpv = dpv_id', 'LEFT')
                ->join('che_cheque', 'che_id = dch_id_che', 'LEFT')
                ->join('dna_detalle_nota_abono', 'dna_id_dpv = dpv_id', 'LEFT')
                ->join('nta_nota_abono', 'nta_id = dna_id_nta', 'LEFT')
                ->join('tra_transaccion t1', 't1.tra_id = che_id_tra', 'LEFT')
                ->join('tra_transaccion t2', 't2.tra_id = nta_id_tra', 'LEFT')                
                ->join('cub_cuenta_bancaria c1', 't1.tra_id_cub = c1.cub_id', 'LEFT')
                ->join('cub_cuenta_bancaria c2', 't2.tra_id_cub = c2.cub_id', 'LEFT')
                ->join('ban_banco b1', 'c1.cub_id_ban = b1.ban_id', 'LEFT')
                ->join('ban_banco b2', 'c2.cub_id_ban = b2.ban_id', 'LEFT')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($having != null) {
            $this->db->having($having);
        }

        $this->db->order_by('dpv_fecha_documento, che_fecha asc');

        return $query->get()->result_array();
    }

    public function get_proveedores_like($valorBusqueda = null) {

    }

    public function get_codigo_otrospagos()
    {
      $query =  $this->db->select("MAX(ofp_codigo) as code")
                ->from('ofp_otra_forma_pago');

      $res = $query->get()->row_array();
      $codigo = 0;
      if ($res['code']< 0) {
        $codigo = 1;
      } else {
        $codigo = $res['code'] + 1;
      }
      return $codigo;
    }

    public function get_otros_pagos($where = null)
    {
      $query = $this->db->select()
              ->from('ofp_otra_forma_pago');
      if ($where != null) {
       $this->db->where($where);
      }
        return $query->get()->result_array();
    }

    public function get_otros_pagos_forma_consolidada($where = null)
    {
        $query = $this->db->select()
              ->from('otp_otra_forma_pgpendiente')
              ->join('dpv_documento_proveedor','dpv_id=otp_id_dpv')
              ->where('otp_estado > 0')
              ;
      if ($where != null) {
       $this->db->where($where);
      }
        return $query->get()->result_array();
    }

    public function get_otrospagos_pendientes($where = null)
    {
      $query = $this->db->select()
              ->from('otp_otra_forma_pgpendiente')
              ->join('dpv_documento_proveedor', 'dpv_id = otp_id_dpv', 'left')
              ->join('agp_agenda_pago', 'agp_id = otp_id_agp', 'left')

      ;
      if ($where != null) {
          $this->db->where($where);
      }

      return $query->get()->result_array();
    }

    public function get_info_documento($where = null)
    {
      $query = $this->db->select()
                ->from('dpv_documento_proveedor')
                ->join('prv_proveedor','prv_id = dpv_id_prv','left')
                ;

                if ($where != null) {
                    $this->db->where($where);
                }

                return $query->get()->result_array();
    }

    public function get_detalle_antiguedad_saldos($where = null){
        $this->db->select('
            (CASE
                WHEN prv_tipo_pers = 1 THEN CONCAT(prv_nombre," ",prv_apellido)
                WHEN prv_tipo_pers = 2 THEN prv_apellido 
             END 
            )as provider,
            prv_codigo as codigo,
            dpv_numero_documento as factura,
            dpv_fecha_documento as fecha,
            dpv_fecha_vencimiento as vencimiento,
            dpv_monto_pendiente as saldo,
            DATEDIFF(NOW(),dpv_fecha_vencimiento) as dias_vencido
         ',false)
        ->from('dpv_documento_proveedor')
        ->join('prv_proveedor' ,'prv_id = dpv_id_prv','inner');

        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }               

    public function otras_formas_rpt_pagos($where = null, $having = null) {
        $query = $this->db->select("dpv_documento_proveedor.*, tif_tipo_factura.*, ofp_fecha AS che_fecha, ofp_monto AS dch_subtotal,
            'Otras formas de pago' AS ban_nombre, 1 AS se_aplico, ofp_codigo AS che_numero, frp_nombre AS tipo_pago",false)
            ->from('dpv_documento_proveedor')
            ->join('prv_proveedor', 'prv_id = dpv_id_prv')
            ->join('tif_tipo_factura', 'tif_id = dpv_id_tif')
            ->join('ofp_otra_forma_pago', 'ofp_id_dpv = dpv_id')
            ->join('frp_forma_pago', 'frp_id = ofp_id_frp')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        if ($having != null) {
            $this->db->having($having);
        }
        $this->db->order_by('dpv_fecha_documento, che_fecha asc');
        return $query->get()->result_array();
    }

}
