<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Cotizaciones_model extends CI_Model
{

    function __construct()
    {
        $this->load->database();
    }


    public function get_registro($tabla, $where, $id)
    {

        $this->db->select()
            ->from($tabla)
            ->where($where, $id);

        $query = $this->db->get();
        return $query->row();
    }

    //obtener la fila del ultimo seguimiento de una cotización
    //para obtener la fila
    /*
      public function get_ultimo_seguimiento($id_cotizacion)
      {

      $query ="";


      $consulta = $this->db->query($query);
      $fila = $consulta->row();

      return @$fila;


      }
     */

    public function existeRegistroEtapa($tabla, $id1, $Valorid1, $id2, $Valorid2, $tipo = 0, $idActual = 0)
    {
        //tipo = 0 insert
        //tipo = 1 update
        //idActual cuando es actualizacion

        if ($tipo == 0 and $idEtapaActual == 0) {
            $this->db->select('*')
                ->from($tabla)
                ->where($id1, $Valorid1)
                ->where($id2, $Valorid2);

            $nregistros = $this->db->count_all_results();
        } else {
            $this->db->select('*')
                ->from($tabla)
                ->where($id1, $Valorid1)
                ->where($id2, $Valorid2)
                ->where("$id1 !=", $idActual);

            $nregistros = $this->db->count_all_results();
        }
        return $nregistros; //devolver el numero de filas afectadas por la consulta
    }

    //funcion aplicada para validar que el nombre no se repita
    public function existeNombre($tabla, $campoNombre, $valorNombre, $tipo = 0, $nombreActual = 0)
    {
        //tipo = 0 insert
        //tipo = 1 update

        if ($tipo == 0 and $idEtapaActual == 0) {
            $this->db->select('*')
                ->from($tabla)
                ->where($campoNombre, $valorNombre);

            $nregistros = $this->db->count_all_results();
        } else {
            $this->db->select('*')
                ->from($tabla)
                ->where($campoNombre, $valorNombre)
                ->where("$campoNombre !=", $nombreActual);

            $nregistros = $this->db->count_all_results();
        }
        return $nregistros; //devolver el numero de filas afectadas por la consulta
    }

    function obtener_cotizaciones()
    {
        $query = "SELECT * FROM cot_cotizacion
              INNER JOIN est_estado_cotizacion ON est_id=cot_id_est
              INNER JOIN seg_seguimiento ON seg_id_cot=cot_id
              INNER JOIN ven_vendedor ON ven_id=cot_id_ven
              GROUP BY (cot_id)";
        $cotizaciones = $this->db->query($query)->result_array();
        return $cotizaciones;
    }

    public function get_tabla($nombretabla, $Campowhere = "", $Valorcampo = "", $campo_orden = "", $tipoorden = "")
    {
        //Obtiene todos los campos de una tabla (se puede utilizar WHERE opcionalmente)

        $this->db->select();

        if ($Campowhere != "" and $Valorcampo != "") {
            $this->db->where($Campowhere, $Valorcampo);
        }
        if ($campo_orden != "" and $tipoorden != "") {
            $this->db->order_by($campo_orden, $tipoorden);
        }

        $this->db->from($nombretabla);
        $query = $this->db->get();

        return $query;
    }

    //a diferencia a la anterior este recibe un array asociativo cuando las condicionantes pueden ser varias
    public function get_tabla2($nombretabla, $arrayWhere, $campo_orden = "", $tipoorden = "")
    {
        //Obtiene todos los campos de una tabla (se puede utilizar WHERE en array asociativo)

        $this->db->select();

        if (count($arrayWhere) > 0) {
            $this->db->where($arrayWhere);
        }
        if ($campo_orden != "" and $tipoorden != "") {
            $this->db->order_by($campo_orden, $tipoorden);
        }

        $this->db->from($nombretabla);
        $query = $this->db->get();

        return $query;
    }

    /*
     * Recibe array asociativo cuando las condiciones pueden ser varias.
     * Permite obtener la informacion de de una tabla a partir de un campo de busqueda
     * y un arreglo que contine datos del campo de busqueda.
     */

    public function get_tabla3($nombretabla, $arrayWhere = null, $campo_orden = "", $tipoorden = "", $campo_where_in = null, $array_where_in = null)
    {
        $this->db->select();

        if (count($arrayWhere) > 0) {
            $this->db->where($arrayWhere);
        }
        if ($campo_orden != "" and $tipoorden != "") {
            $this->db->order_by($campo_orden, $tipoorden);
        }
        if ($campo_where_in != null and $array_where_in != null) {
            $this->db->where_in($campo_where_in, $array_where_in);
        }

        $this->db->from($nombretabla);
        $query = $this->db->get();

        return $query;
    }

    //para la enumeracion de los registros
    public function posicion_registro($nombre_tabla, $campoIdfila, $idValorfila, $condicional = "", $valorCondicional = 0)
    {

        $nposicion = "-";

        if ($condicional != "" and $valorCondicional != 0) {

            $this->db->select("*")
                ->from($nombre_tabla)
                ->where($condicional, $valorCondicional)
                ->where("$campoIdfila <= ", $idValorfila);

            $nposicion = $this->db->count_all_results();
        } else {

            $this->db->select("*")
                ->from($nombre_tabla)
                ->where("$campoIdfila <= ", $idValorfila);
            $nposicion = $this->db->count_all_results();
        }


        return $nposicion;
    }

    /*
      FUNCION PARA ACTUALIZAR UN DATOS DE UN REGISTRO EN UNA TABLA
     */

    public function actualizarCampo($tabla, $campoIdTabla, $valorIdTabla, $campoActualizar, $valorActualizar)
    {


        $data = array(
            $campoActualizar => $valorActualizar
        );

        $this->db->where($campoIdTabla, $valorIdTabla);
        if ($this->db->update($tabla, $data)) {
            return true;
        } else {
            return false;
        }
    }

    //FUNCION QUE ME DEVOLVERÁ LOS ID DE LOS CONTACTOS DEPENDIENTO DEL CLIENTE

    public function get_idsContactosxCliente($id_cliente)
    {

        $this->db->select('GROUP_CONCAT(con_id) AS conxcli')
            ->FROM('con_contacto')
            ->where('con_estado', 1)
            ->where('con_id_cli', $id_cliente);

        $query = $this->db->get()->row_array();
        $ids = $query['conxcli'];
        if (strlen($ids) > 0) {
            $ids = $ids;
        } else {
            $ids = "0";
        }
        return $ids;
    }

    //FUNCION QUE ME DEVOLVERÁ LOS ID DE LOS CONTACTOS DE LA TABLA CXT_CONTACTOXCOTIZACION
    public function get_idsContactosxCotizacion($id_cotizacion)
    {

        $this->db->select('GROUP_CONCAT(cxt_id_con) AS conxcot')
            ->FROM('cxt_contactoxcotizacion')
            ->join('con_contacto', 'cxt_contactoxcotizacion.cxt_id_con = con_contacto.con_id')
            ->where('con_estado', 1)
            ->where('cxt_id_cot', $id_cotizacion);

        $query = $this->db->get()->row_array();
        $ids = $query['conxcot'];
        if (strlen($ids) > 0) {
            $ids = $ids;
        } else {
            $ids = "0";
        }
        return $ids;
    }

    //FUNCION QUE ME DEVOLVERÁ LOS ID DE LOS CONTACTOS DE LA TABLA CXT_CONTACTOXCOTIZACION
    public function get_idsc($id_cotizacion)
    {

        $this->db->select('GROUP_CONCAT(cxt_id_con) AS conxcot')
            ->FROM('cxt_contactoxcotizacion')
            ->join('con_contacto', 'cxt_contactoxcotizacion.cxt_id_con = con_contacto.con_id')
            ->where('con_estado', 1)
            ->where('cxt_id_cot', $id_cotizacion);

        $query = $this->db->get()->row_array();

        $ids = $query['conxcot'];
        if (strlen($ids) > 0) {
            $ids = $ids;
        } else {
            $ids = "0";
        }
        return $ids;
    }

    //FUNCION QUE ME DEVOLVERÁ LOS ID DE LOS ANEXOS QUE PERTENECEN A UNA COTIZACION
    public function get_idsAnexoxCotizaciones($id_cotizacion)
    {

        $this->db->select('GROUP_CONCAT(axc_id_anx) AS anexos_ids')
            ->FROM('axc_anexoxcotizacion')
            ->join('anx_anexo', 'axc_anexoxcotizacion.axc_id_anx = anx_anexo.anx_id')
            ->join('cot_cotizacion', 'axc_anexoxcotizacion.axc_id_cot = cot_cotizacion.cot_id')
            ->where('anx_estado', 1)
            ->where('axc_id_cot', $id_cotizacion);

        $query = $this->db->get()->row_array();
        $ids = $query['anexos_ids'];
        if (strlen($ids) > 0) {
            $ids = $ids;
        } else {
            $ids = "0";
        }
        return $ids;
    }

    //FUNCION PARA ACTUALIZAR REGISTROS MEDIANTE UN ID

    public function update_registros($tabla, $DatosarregloAsociativo, $campoCondicion = "", $valorCondicion = "")
    {

        if ($campoCondicion != "" and $valorCondicion != "") {
            $this->db->where($campoCondicion, $valorCondicion);
            return $this->db->update($tabla, $DatosarregloAsociativo);
        } else {
            return $this->db->update($tabla, $DatosarregloAsociativo);
        }
    }

    //FUNCION PARA INSERTAR REGISTROS

    public function insertar_registros($tabla, $DatosarregloAsociativo)
    {

        return $this->db->insert($tabla, $DatosarregloAsociativo);
    }

    //FUNCION PARA PREGUNTAR SI UN REGISTRO EXISTE
    //public function existe_cotizacion_GP($tabla,$DatosarregloAsociativo,$campoCondicion="",$valorCondicion="") {
    public function Existe_Registro($tabla, $DatosarregloWhere)
    {

        $this->db->select("*")
            ->from($tabla)
            ->where($DatosarregloWhere);
        $nreg = $this->db->count_all_results();
        return $nreg;
    }

    //FUNCION QUE ME DEVOLVERÁ LOS IDs DE LOS VENDEDORES QUE PERTENECEN A UN SUPERVISOR (vendedor o supervisor son un usuario)
    public function get_idsVendedoresxSupervisor($id_usuario)
    {

        $this->db->select('GROUP_CONCAT(vxs_id_ven) AS vendedores_ids')
            ->FROM('vxs_vendedorxsupervisor')
            ->join('sup_supervisor', 'vxs_vendedorxsupervisor.vxs_id_sup = sup_supervisor.sup_id')
            ->where('sup_id_usu', $id_usuario)
            ->where('sup_estado', 1);

        $query = $this->db->get()->row_array();
        $ids = $query['vendedores_ids'];
        if (strlen($ids) > 0) {
            $ids = $ids;
        } else {
            $ids = "0";
        }

        return $ids;
    }

    //FUNCION QUE ME DEVOLVERÁ LOS IDs DE LAS COTIZACIONES QUE DEBEN SER VISIBLES PARA EL SUPERVISOR (ESTO DEPENDERA DE SUS VENDEDORES ASIGNADOS)
    public function get_idsCotizacionesxSupervisor($id_usuario)
    {
        // $this->db->query("SET GLOBAL group_concat_max_len=4194304;");
        $this->db->select('cot_id AS cot_ids')
            ->FROM('vxs_vendedorxsupervisor')
            ->join('sup_supervisor', 'vxs_vendedorxsupervisor.vxs_id_sup = sup_supervisor.sup_id')
            ->join('ven_vendedor', 'vxs_vendedorxsupervisor.vxs_id_ven = ven_vendedor.ven_id')
            ->join('cot_cotizacion', 'cot_cotizacion.cot_id_ven = ven_vendedor.ven_id')
            ->where('sup_id_usu', $id_usuario)
            ->where('sup_estado', 1);

        $query = $this->db->get()->result_array();
        $ids = $query;
        if (count($ids) > 0) {
            $ids = implode(',', array_column($ids, 'cot_ids'));
        } else {
            $ids = "0";
        }
        return $ids;
    }

    //FUNCION QUE ME DEVOLVERÁ LOS IDs DE LAS COTIZACIONES QUE DEBEN SER VISIBLES PARA EL VENDEDOR
    public function get_idsCotizacionesxVendedor($id_usuario)
    {
        // $this->db->query("SET GLOBAL group_concat_max_len=4194304;");
        $this->db->select('cot_id AS cot_ids')
            ->FROM('cot_cotizacion')
            ->join('ven_vendedor', 'cot_cotizacion.cot_id_ven = ven_vendedor.ven_id')
            ->where('ven_id_usu', $id_usuario)
            ->where('ven_estado', 1);

        $query = $this->db->get()->result_array();

        $ids = $query;
        if (count($ids) > 0) {
            $ids = implode(',', array_column($ids, 'cot_ids'));
        } else {
            $ids = "0";
        }

        return $ids;
    }

    /**
     * Consultas:general_de_cotizaciones
     * @author René Castaneda
     * @return Generación de la consulta para el reporte general de las cotizaciones
     * Modificada por Carlos Flores
     * Modificacion: Se modifico para que la funcion recibiera mas parametros para que hiciera mas filtros
     */
    public function get_ReporteGeneralCotizaciones($fechaIniPres, $fechaFinPres, $fechaIniCierre = "", $fechaFinCierre = "", $id_vendedor = 0, $id_cliente = 0, $id_tia = 0, $id_estado = 0)
    {
        //$fechaIniPres = date("Y-m-d 00:00:00", strtotime($fechaIniPres));
        //$fechaFinPres = date("Y-m-d 23:59:59", strtotime($fechaFinPres));
        //$fechaIniCierre = date("Y-m-d 23:59:59", strtotime($fechaIniCierre));
        //$fechaFinCierre = date("Y-m-d 23:59:59", strtotime($fechaFinCierre));

        $select = "cot_cotizacion.*
        , cac_cartera_cliente.cac_nombre
        , cli_cliente.cli_nombre
        , cli_cliente.cli_apellido
        , ven_vendedor.ven_nombre
        , ven_vendedor.ven_apellidos
        ,IFNULL(
        GROUP_CONCAT( DISTINCT  TRIM(CONCAT(ifnull(axc_descripcion,'*'),' (',axc_cantidad,')')) SEPARATOR ','),
        '' ) AS productos
        ,CONCAT(art_codigo,' - ',art_nombre) AS producto_nombre
        , cac_cartera_cliente.cac_nombre
        , etp_etapa.etp_nombre
        , est_estado_cotizacion.est_nombre
        , est_estado_cotizacion.est_seguimiento
        , est_estado_cotizacion.est_cerrada";
        $this->db->select($select, false)
            ->from("cot_cotizacion")
            ->join('cli_cliente', 'cot_cotizacion.cot_id_cli = cli_cliente.cli_id', 'left')
            ->join('ven_vendedor', 'cot_cotizacion.cot_id_ven = ven_vendedor.ven_id', 'left')
            ->join('cac_cartera_cliente', 'cli_cliente.cli_id_cac = cac_cartera_cliente.cac_id', 'left')
            ->join('axc_articuloxcotizacion', 'cot_id = axc_id_cot', 'left')
            ->join('art_articulo', 'art_id = axc_id_art', 'left')
            ->join('est_estado_cotizacion', 'cot_cotizacion.cot_id_est = est_estado_cotizacion.est_id', 'left')
            ->join('etp_etapa', 'cot_cotizacion.cot_id_etp = etp_etapa.etp_id', 'left')
            ->join('cog_cotiz_ganada', 'cot_cotizacion.cot_id = cog_cotiz_ganada.cog_id_cot', 'left')
            ->group_by('cot_id');


        // if ($fechaIniPres != "" && $fechaFinPres != "") {
        //     $fechaIniPres = date("Y-m-d 00:00:00", strtotime($fechaIniPres));
        //     $fechaFinPres = date("Y-m-d 23:59:59", strtotime($fechaFinPres));
        //     $this->db->where("cot_cotizacion.`cot_fecha_pres` BETWEEN '$fechaIniPres' AND '$fechaFinPres'", null, false);
        // }


        //$this->db->where("cot_cotizacion.`cot_fecha_cierre` BETWEEN '$fechaIniCierre' AND '$fechaFinCierre'", null, false);
        $this->db->order_by("cot_cotizacion.cot_fecha_pres", "ASC");

        /*
        if ($fechaIniCierre != "" && $fechaFinCierre != "") {
            $fechaIniCierre = date("Y-m-d 23:59:59", strtotime($fechaIniCierre));
            $fechaFinCierre = date("Y-m-d 23:59:59", strtotime($fechaFinCierre));
            $this->db->where("cog_cotiz_ganada.`cog_fecha_cierre` BETWEEN '$fechaIniCierre' AND '$fechaFinCierre'", null, false);
        }*/

        if (trim($fechaIniPres) != '') {
            $fechaIniPres = formatear_fecha('Y-m-d', $fechaIniPres);

            $this->db->where("DATE(cot_cotizacion.cot_fecha_pres) >=", $fechaIniPres);
        }

        if (trim($fechaFinPres) != '') {
            $fechaFinPres = formatear_fecha('Y-m-d', $fechaFinPres);
            $this->db->where("DATE(cot_cotizacion.cot_fecha_pres) <=", $fechaFinPres);
        }

        if (trim($fechaIniCierre) != '') {
            $fechaIniCierre = formatear_fecha('Y-m-d', $fechaIniCierre);
            $this->db->where("DATE(cog_cotiz_ganada.cog_fecha_cierre) >=", $fechaIniCierre);
        }
        if (trim($fechaFinCierre) != '') {
            $fechaFinCierre = formatear_fecha('Y-m-d', $fechaFinCierre);
            $this->db->where("DATE(cog_cotiz_ganada.cog_fecha_cierre) <=", $fechaFinCierre);
        }

        if ($id_vendedor != 0) {
            $this->db->where("cot_cotizacion.cot_id_ven", $id_vendedor);
        }
        if ($id_cliente != 0) {
            $this->db->where("cot_cotizacion.cot_id_cli", $id_cliente);
        }
        if ($id_estado != 0) {
            $this->db->where("cot_cotizacion.cot_id_est", $id_estado);
        }
        if ($id_tia != 0) {
            $this->db->where("art_articulo.art_id_tia", $id_tia);
        }
        $this->db->where("cot_estado", 1);
        $query = $this->db->get();

        return $query;
    }

    /**
     * Consultas:general_de_cotizaciones
     * @author René Castaneda
     * @return Consultar los contactos de una cotizacion
     */
    function contactosxCotizacion($id_cotizacion)
    {
        $this->db->select()
            ->from("cxt_contactoxcotizacion")
            ->join('con_contacto', 'cxt_contactoxcotizacion.cxt_id_con = con_contacto.con_id')
            ->where("cxt_contactoxcotizacion.cxt_id_cot", $id_cotizacion);
        $query = $this->db->get();

        return $query;
    }

    /**
     * Consultas:general_de_cotizaciones
     * @author René Castaneda
     * @return Consultar los seguimientos de una cotizacion
     */
    function seguimientoxCotizacion($id_cotizacion)
    {
        $this->db->select()
            ->from("cxt_contactoxcotizacion")
            ->join('con_contacto', 'cxt_contactoxcotizacion.cxt_id_con = con_contacto.con_id')
            ->where("cxt_contactoxcotizacion.cxt_id_cot", $id_cotizacion);
        $query = $this->db->get();

        return $query;
    }

    /**
     * Consultas:general_de_cotizaciones
     * @author René Castaneda
     * @return Preguntar si la cotizacion esta ganada o perdida
     */
    function cotizacionGanadaPerdida($id_cotizacion)
    {
        //PREGUNTAR SI HA ESA COTIZACION YA SE LE REGISTRO COMO GANADA O PERDIDA Y ASI SOLO MOSTRAR SUS DATOS
        //PARA LA ACTUALIZACION

        $es_ganada = $this->Existe_Registro("cog_cotiz_ganada", array('cog_id_cot' => $id_cotizacion));
        $es_perdida = $this->Existe_Registro("per_perdido", array('per_id_cot' => $id_cotizacion));

        if ($es_ganada == 1) {
            $estado_cotizacion = 1;
            $datos_ganada = $this->get_tabla("cog_cotiz_ganada", "cog_id_cot", $id_cotizacion, "cog_id", "ASC");
            $arregloDatos = array($estado_cotizacion, $datos_ganada);
        } else if ($es_perdida == 1) {
            $estado_cotizacion = 2;
            $datos_perdida = $this->get_tabla("per_perdido", "per_id_cot", $id_cotizacion, "per_id", "ASC");
            $arregloDatos = array($estado_cotizacion, $datos_perdida);
        } else {
            $estado_cotizacion = 3;
            $arregloDatos = array($estado_cotizacion);
        }

        return $arregloDatos;
    }

    /**
     * @author René Castaneda
     * @return Datos de los vendedores de un supervisor
     */
    function datosVendedoresxSupervisor($id_usuario)
    {

        $this->db->select("ven_vendedor.*, 
                (
                    SELECT activated
                    FROM users
                    WHERE id = ven_id_usu
                ) as estado_usuario", true)
            ->from("vxs_vendedorxsupervisor")
            ->join('ven_vendedor', 'vxs_vendedorxsupervisor.vxs_id_ven = ven_vendedor.ven_id')
            ->join('sup_supervisor', 'vxs_vendedorxsupervisor.vxs_id_sup = sup_supervisor.sup_id')
            ->where("sup_supervisor.sup_id_usu", $id_usuario)
            ->where("sup_supervisor.sup_estado", 1)
            ->where("ven_vendedor.ven_estado", 1)
            ->having("estado_usuario", 1);
        $query = $this->db->get();

        return $query;
    }

    public function getListaPreciosCliente($where = null)
    {
        $this->db->select("cli_codigo, cli_personeria, cli_nombre, cli_apellido, GROUP_CONCAT(tlp_nombre ORDER BY tlp_defecto DESC SEPARATOR ', ') AS tlp_nombre", false)
            ->from('tpn_tipo_precio_cliente')
            ->join('cli_cliente', 'cli_id = tpn_id_cli', 'INNER')
            ->join('tlp_tipo_lista_precio', 'tlp_id = tpn_id_tlp', 'INNER')
            ->group_by('cli_id')
            ->order_by('cli_codigo');
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author René Castaneda
     * @return preguntar por el suma total de las cotizaciones ganadas por un vendedor
     */
    public function totalCotizacionesGanadaxVen($id_vendedor, $fecha1, $fecha2)
    {

        //$fecha1 = date("Y-m-d 00:00:00", strtotime($fecha1));
        //$fecha2 = date("Y-m-d 23:59:59", strtotime($fecha2));
        $fecha1 = formatear_fecha('Y-m-d', $fecha1);
        $fecha2 = formatear_fecha('Y-m-d', $fecha2);

        $this->db->select("SUM(cot_cotizacion.cot_total) AS suma")
            ->from("cog_cotiz_ganada")
            ->join('cot_cotizacion', 'cog_cotiz_ganada.cog_id_cot = cot_cotizacion.cot_id')
            ->where("cot_cotizacion.cot_id_ven", $id_vendedor);
        //$this->db->where('cot_fecha >=', $fecha1 . ' 00:00:00');
        $this->db->where('cot_estado', 1);
        $this->db->where("DATE(cog_fecha_cierre) BETWEEN '$fecha1' AND '$fecha2'", null, false);
        $query = $this->db->get();
        $suma = 0;
        foreach ($query->result() as $s) {
            $suma = $s->suma;
        }
        return $suma;
    }

    /**
     * @author René Castaneda
     * @return preguntar por el suma total de las cotizaciones por un vendedor
     */
    public function totalCotizacionesxVen($id_vendedor, $fecha1 = null, $fecha2 = null)
    {
        $this->db->select("SUM(cot_cotizacion.cot_total) AS suma")
            ->from("cot_cotizacion")
            ->where("cot_cotizacion.cot_id_ven", $id_vendedor)
            ->where("cot_estado", 1);
        if ($fecha1 && $fecha2) {
            //SAT_7478 DEBE SER CONTRA FECHA DE PRESENTACION
            $fecha_ini = formatear_fecha('Y-m-d', $fecha1); // . ' 00:00:00';
            $fecha_fin = formatear_fecha('Y-m-d', $fecha2); // . ' 23:59:59';
            // $this->db->where('cot_fecha >=', $fecha_ini);
            // $this->db->where('cot_fecha <=', $fecha_fin);
            $this->db->where('DATE(cot_fecha_pres) >=', $fecha_ini);
            $this->db->where('DATE(cot_fecha_pres) <=', $fecha_fin);
        }
        $query = $this->db->get();
        $suma = 0;
        foreach ($query->result() as $s) {
            $suma = $s->suma;
        }
        return $suma;
    }

    /**
     * @param integer $id_cliente
     * @return ids de los seguimientos pertencientes a un cliente
     */
    public function get_idsSeguimientoxCliente($id_cliente)
    {

        $this->db->select('GROUP_CONCAT( DISTINCT sec_seguimiento_cliente.sec_id) AS idsSec')
            ->FROM('sec_seguimiento_cliente')
            ->join('con_contacto', 'sec_seguimiento_cliente.sec_id_con = con_contacto.con_id')
            ->join('cli_cliente', 'con_contacto.con_id_cli = cli_cliente.cli_id')
            ->where('cli_cliente.cli_id', $id_cliente);

        $query = $this->db->get()->row_array();
        $ids = $query['idsSec'];
        if (strlen($ids) > 0) {
            $ids = $ids;
        } else {
            $ids = "0";
        }
        return $ids;
    }

    public function get_forma_pago_cot($where = null)
    {
        $this->db->select(
            "*, (SELECT GROUP_CONCAT(ent_id) FROM fxe_forma_pagoxentregable_cotizacion JOIN ent_entregable_cotizacion ON ent_id = fxe_id_ent WHERE fxe_id_fpc = fpc_id) AS fxe_ids,
            (SELECT GROUP_CONCAT(ent_nombre SEPARATOR ', ') FROM fxe_forma_pagoxentregable_cotizacion JOIN ent_entregable_cotizacion ON ent_id = fxe_id_ent WHERE fxe_id_fpc = fpc_id) AS fxe_names",
            false
        )
            ->from('fpc_forma_pago_cotizacion')
            ->where('fpc_estado', 1);
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    //rene castaneda
    function get_cotizacion($array = null, $no_editar_estado = 1)
    {
        $this->db->select("*,
                    IFNULL( GROUP_CONCAT( DISTINCT TRIM(CONCAT(con_contacto.con_nombre,' ',con_contacto.con_apellidos)) SEPARATOR ','),'' ) AS contactos_cotizacion,
                    if(cli_personeria = 1, CONCAT(cli_nombre,' ', cli_apellido), cli_apellido) as nombre,
                    (select txc_numero from txc_telefonoxcliente where txc_id_cli = cli_id LIMIT 1) AS telefono,
                    (select cog_numero_orden from cog_cotiz_ganada where cog_id_cot = cot_id LIMIT 1) AS cog_numero_orden 
                    
                ", false)
            ->from('cot_cotizacion')
            ->join('cli_cliente', 'cli_id=cot_id_cli', 'left')
            ->join('ven_vendedor', 'ven_id=cot_id_ven', 'left')
            ->join('users', 'id = ven_id_usu', 'left')
            ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
            ->join('plz_plaza', 'plz_id = emp_id_plz', 'left')
            ->join('tic_tipo_comision', 'tic_id=cot_id_tic', 'left')
            ->join('est_estado_cotizacion', 'est_id=cot_id_est', 'left')
            ->join('etp_etapa', 'etp_id=cot_id_etp', 'left')
            ->join('cxt_contactoxcotizacion', 'cxt_id_cot=cot_id', 'left')
            ->join('con_contacto', 'con_id=cxt_id_con', 'left')
            ->join('scl_sucursal_cliente', 'cot_id_scl = scl_id', 'left')
            ->join('tpg_tipo_pago', 'cot_id_tpg = tpg_id', 'left')
            ->join('frp_forma_pago', 'frp_id = cot_id_frp', 'left')
            ->join('arf_area_factura', 'arf_id = cot_id_arf', 'left')
            ->group_by('cot_id');

        if ($no_editar_estado == 1) {
            $this->db->where('cot_estado', 1);
        }
        if ($array) {
            $this->db->where($array);
        }
        return $this->db->get()->result_array();
    }

    //rene castaneda
    function get_detalle_productos($array = null)
    {

        $this->db->simple_query("SET SESSION group_concat_max_len = 9000000");
        $this->db->select(
            "
            axc_articuloxcotizacion.*, art_codigo,
            art_nombre,
            art_descripcion,
            art_foto,
            art_tipo,
            bod_nombre,
            mrp_nombre,
            art_descripcion,
            tia_nombre,
            axc_subtotal,
            (
                SELECT
                    sar_precio
                FROM
                    sar_saldo_articulo
                WHERE
                    sar_id_art = axc_id_art
                AND sar_id_bod = axc_id_bod
                AND sar_id = (
                    SELECT
                        MAX(sar_id)
                    FROM
                        sar_saldo_articulo
                    WHERE
                        sar_id_art = axc_id_art
                    AND sar_id_bod = axc_id_bod
                )
            ) AS ultimo_precio_producto,
            (
                SELECT
                    GROUP_CONCAT(
                        CONCAT(car_nombre, ': ', cxo_valor)
                    )
                FROM
                    cxo_caracxarticuloxcotizacion
                INNER JOIN cxu_caracxarticulo ON cxu_id = cxo_id_cxu
                INNER JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
                INNER JOIN car_caracteristica ON car_id = cxr_id_car
                WHERE
                    cxo_id_axc = axc_id
            ) AS caracteristica,

            (
                SELECT
                    GROUP_CONCAT(
                        CONCAT(car_nombre, ': ', cxo_valor)
                        SEPARATOR ' | '
                    )
                FROM
                    cxo_caracxarticuloxcotizacion
                INNER JOIN cxu_caracxarticulo ON cxu_id = cxo_id_cxu
                INNER JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
                INNER JOIN car_caracteristica ON car_id = cxr_id_car
                WHERE
                    cxo_id_axc = axc_id
            ) AS caracteristica_separator,

            (
                SELECT
                    GROUP_CONCAT(
                        CONCAT(car_nombre, ': ', cxu_valor)
                        SEPARATOR ' | '
                    )
                FROM
                    cxo_caracxarticuloxcotizacion
                INNER JOIN cxu_caracxarticulo ON cxu_id = cxo_id_cxu
                INNER JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
                INNER JOIN car_caracteristica ON car_id = cxr_id_car
                WHERE
                    cxo_id_axc = axc_id
            ) AS caracteristica_separator_instru,

            (
                SELECT
                    GROUP_CONCAT(
                        CONCAT(car_nombre, '|||', IF(TRIM(cxu_valor) != '', cxu_valor, cxo_valor), '|||', car_id) SEPARATOR '||||'
                    )
                FROM
                    cxo_caracxarticuloxcotizacion
                INNER JOIN cxu_caracxarticulo ON cxu_id = cxo_id_cxu
                INNER JOIN cxr_caractxtipo_articulo ON cxr_id = cxu_id_cxr
                INNER JOIN car_caracteristica ON car_id = cxr_id_car
                WHERE
                    cxo_id_axc = axc_id 
                ORDER BY car_id
            ) AS caracteristica_imp,

            (
                SELECT mep_nombre FROM cva_conversion_articulo
                JOIN mep_medida_producto ON cva_id_mep = mep_id
                WHERE cva_id = axc_id_cva
                GROUP BY cva_id
            ) AS mep_nombre,
            (
                select sum(ixt_monto) as total_impuestos
                from ixt_impuestoxcotizacion
                where ixt_id_axc = axc_id
            ) as impuestos,
            (
                select imp_id  as total_impuestos
                from ixt_impuestoxcotizacion
                JOIN imp_impuesto ON imp_id = ixt_id_imp
                where ixt_id_axc = axc_id
                and imp_nombre  like  '%IVA%'
                and axc_id_art = art_id 
                limit 1

            )as tiene_iva,
            mep_medida_producto.*
            ",
            false
        )
            ->from('axc_articuloxcotizacion')
            ->join('art_articulo', 'art_id=axc_id_art')
            ->join('mrp_marca_producto', 'mrp_id = art_id_mrp', 'left')
            ->join('cva_conversion_articulo', 'axc_id_cva = cva_id', 'left')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia', 'left')
            ->join('bod_bodega', 'bod_id=axc_id_bod', 'left')
            ->order_by('axc_id, tia_id', 'ASC')
            ->group_by('axc_id');

        if ($array) {
            $this->db->where($array);
        }
        return $this->db->get()->result_array();
    }

    //rene castaneda
    function get_productos_mas_ven($where = null, $limite = 10)
    {
        $this->db->select("axc_articuloxcotizacion.*, art_articulo.*, tia_tipo_articulo.*, cog_cotiz_ganada.*, ven_vendedor.*, 
                            COUNT(axc_id_art) as frecuencia, sum(axc_cantidad) as cantidad, mrp_id, mrp_nombre", false)
            ->from('axc_articuloxcotizacion')
            ->join('cot_cotizacion', 'cot_id = axc_id_cot')
            ->join('cog_cotiz_ganada', 'cot_id = cog_id_cot')
            ->join('art_articulo', 'art_id = axc_id_art')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id')
            ->join('ven_vendedor', 'cot_id_ven = ven_id')
            ->join('mrp_marca_producto', 'mrp_id = art_id_mrp', 'left')
            ->group_by('axc_id_art')
            ->order_by('cantidad', 'desc')
            ->limit($limite);
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    //rene castaneda
    function get_mejores_clientes($where = null, $limite = 10)
    {
        $this->db->select("IF(cli_personeria = 1,CONCAT(cli_nombre,' ',cli_apellido),cli_apellido) as cli_nombre, 
                            CONCAT( ven_nombre, ' ', ven_apellidos ) AS ven_nombre, 
                            SUM( axc_total ) AS suma_venta", false)
            ->from('cot_cotizacion')
            ->join('cli_cliente', 'cli_id = cot_id_cli')
            ->join('cog_cotiz_ganada', 'cot_id = cog_id_cot')
            ->join('axc_articuloxcotizacion', 'cot_id = axc_id_cot')
            ->join('ven_vendedor', 'cot_id_ven = ven_id')
            ->group_by('cot_id_cli')
            ->order_by('suma_venta', 'desc')
            ->limit($limite)
            ->where('cot_estado', 1)
            ->where('axc_estado', 1);
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    function get_cotizaciones_ganada_cliente($where = null)
    {
        $this->db->select('axc_articuloxcotizacion.*, art_articulo.*,cog_cotiz_ganada.*,cot_cotizacion.*', false)
            ->from('axc_articuloxcotizacion')
            ->join('cot_cotizacion', 'cot_id = axc_id_cot')
            ->join('cog_cotiz_ganada', 'cot_id = cog_id_cot')
            ->join('art_articulo', 'art_id = axc_id_art')
            ->group_by('cot_id')
            ->order_by('cog_id', 'asc')
            ->where('cot_estado', 1);
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_carateristicas_matenimiento_articulo($where_array)
    {
        $this->db->select('')
            ->from('cxr_caractxtipo_articulo')
            ->join('car_caracteristica', 'car_id=cxr_id_car')->where($where_array); //modulo tres es de cotizacion
        $consulta = $this->db->get();
        $datos = $consulta->result_array();
        return $datos;
    }

    //fernando melendez
    public function obtenercodigo()
    {
        $this->db->select('max(ven_id) + 1 as codigo')->from('ven_vendedor');
        $r = $this->db->get()->row_array();
        return $r;
    }

    /**
     * @autor:  Edith Herrera
     */
    public function codigoarticulo($id_axc)
    {
        $this->db->select('art_codigo')
            ->from('axc_articuloxcotizacion')
            ->join('art_articulo', 'axc_id_art=art_id');
        if ($id_axc > 0) {
            $this->db->where('axc_articuloxcotizacion.axc_id', $id_axc);
        }
        $cod = $this->db->get()->row_array();
        return $cod;
    }

    /**
     * @autor:  Edith Herrera
     */
    public function imgarticulo($id_axc)
    {
        $this->db->select('art_foto')
            ->from('axc_articuloxcotizacion')
            ->join('art_articulo', 'axc_id_art=art_id');
        if ($id_axc > 0) {
            $this->db->where('axc_id', $id_axc);
        }
        $img = $this->db->get()->row_array();
        return $img;
    }

    /**
     * @autor:  Edith Herrera
     */
    public function listaarticulo($cod_axc, $where = null)
    {
        $this->db->select('art_id, art_codigo, art_nombre, axc_id_art, axc_id, axc_id_cot, 
            (SELECT mep_nombre FROM mep_medida_producto JOIN cva_conversion_articulo ON cva_id_mep = mep_id WHERE cva_id = axc_id_cva) AS mep_nombre', FALSE)
            ->from('axc_articuloxcotizacion')
            ->join('art_articulo', 'axc_id_art=art_id');
        $this->db->where('axc_id', $cod_axc);
        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->limit(1);

        $lst = $this->db->get()->result_array();
        return $lst;
    }

    /**
     * @autor:  Edith Herrera
     */
    public function contacto($cod_cli)
    {
        $this->db->select('con_id,con_nombre,con_apellidos')
            ->from('cli_cliente')
            ->join('con_contacto', 'cli_id=con_id_cli');
        $this->db->where('con_id_cli', $cod_cli);

        $resp = $this->db->get()->result_array();
        return $resp;
    }

    /**
     * @autor:  Edith Herrera
     */
    public function medio_contacto($where_cliente = null)
    {
        $this->db->select('tmc_id,tmc_nombre')
            ->from('tmc_tipo_medio')
            ->join('cxm_clientexmediocontacto', 'cxm_id_tmc=tmc_id')->group_by('tmc_id');
        $this->db->where($where_cliente);

        $res = $this->db->get()->result_array();
        return $res;
    }

    /**
     * @autor:  Edith Herrera
     */
    public function impuesto_cliente($cliente = null)
    {
        $this->db->select()
            ->from('imp_impuesto')
            ->join('ixc_impuestoxcliente', 'imp_id = ixc_id_imp AND ixc_id_cli = ' . $cliente . '', 'left');
        //->group_by('imp_id');

        $res = $this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $res;
    }

    /**
     * @autor:  Elmer Hernández
     */

    public function categoria_producto($categoria = null, $producto = null)
    {
        $this->db->select()
            ->from('art_articulo');
        if ($categoria > 0 && $producto > 0) {
            $this->db->where('art_id', $producto);
            $this->db->where('art_id_tia', $categoria);
        }

        $result = $this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $result;
    }

    /**
     * @autor:  Elmer Hernández
     */

    public function validacion_art_tipo_lista_precio($lip_id_art = null, $lip_id_tlp)
    {
        $this->db->select()
            ->from('lip_listado_precio');
        if ($lip_id_art > 0 && $lip_id_tlp > 0) {
            $this->db->where('lip_id_art', $lip_id_art);
            $this->db->where('lip_id_tlp', $lip_id_tlp);
        }

        $result = $this->db->get()->result_array();
        //die(print_r($this->db->last_query()));
        return $result;
    }

    function comprobar_cantidad_desde_hasta_por_lista($where)
    {
        $query = $this->db->select('*')
            ->from('lip_listado_precio')
            ->where($where)
            ->get()->result_array();
        return $query;
    }

    /**
     * @autor:  Edith Herrera
     */
    public function impuesto_cotizacion($cotizacion = null, $axc = null)
    {

        $this->db->select('MAX(ixt_id_axc) as mayor')
            ->from('ixt_impuestoxcotizacion');
        $id = $this->db->get()->row_array();

        $this->db->select()
            ->from('axc_articuloxcotizacion')
            ->join('ixt_impuestoxcotizacion', 'axc_id=ixt_id_axc ')
            ->join('imp_impuesto', 'imp_id = ixt_id_imp')
            ->where('axc_id_cot', $cotizacion);

        if ($axc > 0) {
            $this->db->where('ixt_id_axc', $axc);
        } else {
            $this->db->where('ixt_id_axc', $id['mayor']);
        }

        $result = $this->db->get()->result_array();
        // die(print_r($this->db->last_query()));
        return $result;
    }

    function anexo_cliente($cliente_id)
    {
        $anexos = $this->db->select()
            ->from('axn_anexoxcliente')
            ->join('anx_anexo', 'anx_id = axn_id_anx')
            ->where('axn_id_cli', $cliente_id)
            ->where('anx_imagen', 0);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function get_telxcliente($cliente)
    {
        $this->db->select("CONCAT_WS(' ',txs_numero,txc_numero) as numero, txs_numero, txc_numero", false)
            ->from('cli_cliente')
            ->join('sxc_servicioxcliente', 'sxc_id_cli=cli_id', 'left')
            ->join('txs_telefonoxservicio', 'txs_id_sxc=sxc_id AND txs_principal=1', 'left')
            ->join('txc_telefonoxcliente', 'txc_id_cli=cli_id', 'left')
            ->where('cli_id', $cliente);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    public function get_clientes($where = null, $like = null)
    {
        $query = $this->db->select("*, cli_id as cliente,
            CASE WHEN cli_personeria = 1 THEN CONCAT(IFNULL(cli_codigo,''),' - ',IFNULL(cli_nombre,''), ' ', IFNULL(cli_apellido,''))
                    ELSE CONCAT(IFNULL(cli_codigo,''),' - ',IFNULL(cli_apellido,'') ) END as cliente_nombre", false)
            ->from('cli_cliente');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->like($like);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_cotizacion($where = null)
    {
        $query = $this->db->select(
            "*, (SELECT GROUP_CONCAT(ixt_id_imp) as impuestos
                    FROM ixt_impuestoxcotizacion
                    WHERE ixt_id_axc = axc_id) as impuestos,
                    (
                    SELECT
                    GROUP_CONCAT(cxo_id_cxu) as caracteristicas
                    FROM cxo_caracxarticuloxcotizacion
                    WHERE cxo_id_axc  = axc_id
                    ORDER BY cxo_id
                    ) as caracteristicas,
                    (
                    SELECT SUM(den_cantidad) FROM den_detalle_envio
                    WHERE den_id_axc  = axc_id
                    ) cantidad_enviada
                    "
        )
            ->from('axc_articuloxcotizacion')
            ->join('art_articulo', 'art_id = axc_id_art', 'inner')
            ->join('cva_conversion_articulo', 'cva_id = axc_id_cva', 'left')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_prorrateo_cotizacion($where = null)
    {
        $query = $this->db->select()
            ->from('pxt_prorrateoxarticulo_cotizacion')
            ->join('dpr_detalle_prorrateo', 'pxt_id_dpr = dpr_id', 'inner')
            ->join('cec_centro_costo', ' cec_id = dpr_id_cec', 'inner')
            ->join('art_articulo', ' art_id = dpr_id_art');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_detalleprorrateo($where = null)
    {
        $this->db->select()
            ->from('dpr_detalle_prorrateo')
            ->join('cec_centro_costo', ' cec_id = dpr_id_cec')
            ->join('art_articulo', ' art_id = dpr_id_art');
        //->where('dpr_id_ptg', $prorrateo_id);

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_detalle_caracteristicas_cot($where = null)
    {
        $this->db->select()
            ->from('cxo_caracxarticuloxcotizacion')
            ->join('cxu_caracxarticulo', ' cxu_id = cxo_id_cxu', 'inner')
            ->join('cxr_caractxtipo_articulo', ' cxr_id = cxu_id_cxr')
            ->join('car_caracteristica', ' car_id = cxr_id_car');

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->order_by('cxo_id', 'ASC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function crear_arbol($padre, $prefijo)
    {
        $prefijo = "";
        $cadena = "";
        $q = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1, 'tia_padre' => $padre));
        if ($q) {

            foreach ($q as $fila) {
                $cadena .= $fila['tia_id'] . ',';
                $cadena .= $this->crear_arbol($fila['tia_id'], '');
            }
        }
        return $cadena;
    }

    function get_articulosxcategoria($categoria, $servicios = null, $where = null)
    {
        $categorias_final = $this->crear_arbol($categoria, "");

        $categorias_final = $categorias_final . $categoria;

        if ($categoria == "null" || $categoria == null) {
            $categorias_final = null;
        }

        $query = $this->db->select("*")
            ->from('art_articulo')
            ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1', 'left')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
            ->join('sar_saldo_articulo', 'sar_id_art=art_id ', 'left')
            ->group_by('art_id');

        if ($categorias_final != null) {
            $categorias = explode(',', $categorias_final);

            $this->db->where_in('art_id_tia', $categorias);
        }

        if ($servicios != '') {
            $this->db->where('art_tipo', 1);
        } else {
            $this->db->where('art_tipo', 0);
        }

        if ($where != null) {
            $this->db->where($where);
        }


        return $query->get()->result_array();
    }

    public function get_cuentas_cliente($where = null)
    {
        $query = $this->db->select()
            ->from('cxn_cuentaxcliente')
            ->join('cnt_cuenta_contable', 'cxn_id_cnt = cnt_id', 'inner')
            ->join('tcn_tipo_cuenta', 'cxn_id_tcn = tcn_id', 'inner')
            ->join('cec_centro_costo', ' cec_id = cxn_id_cec', 'inner')
            ->join('frp_forma_pago', 'frp_id = cxn_id_frp', 'left')
            ->join('tpg_tipo_pago', 'cxn_id_tpg = tpg_id', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author René Castaneda
     * @since 2017-07-28
     * @return query para filtrar llamadas.
     */
    public function get_tabla_llamadas($where = null)
    {
        $query = $this->db->select("*, DATE_FORMAT(tbl_fecha, '%d-%m-%Y %H:%i:%s') fecha_llamada, IF(tbl_id_cli IS NULL,IF((tbl_personeria=1 OR tbl_personeria IS NULL),CONCAT_WS(' ',tbl_cliente_nombre, tbl_cliente_apellido),tbl_cliente_apellido),IF(cli_personeria=1,CONCAT_WS(' ',cli_nombre, cli_apellido),cli_apellido)) cliente, CONCAT_WS(' ',ven_nombre, ven_apellidos) vendedor, (SELECT CONCAT_WS('&',DATE_FORMAT(sel_fecha,'%d-%m-%Y %H:%i:%s'),sel_comentario, esn_nombre) FROM sel_seguimiento_llamada JOIN esn_estado_atencion ON sel_id_esn=esn_id WHERE sel_id_tbl=tbl_id ORDER BY sel_id DESC LIMIT 1) AS ultimo_seguimiento", false)
            ->from('tbl_tabla_llamadas')
            ->join('sec_sector_cliente', 'sec_id = tbl_id_sec', 'left')
            ->join('ven_vendedor', 'ven_id = tbl_id_ven', 'left')
            ->join('cli_cliente', 'cli_id = tbl_id_cli', 'left')
            ->join('gen_genero', 'gen_id = tbl_id_gen', 'left')
            ->join('art_articulo', 'art_id = tbl_id_art', 'left')
            ->join('mat_motivo_atencion', 'mat_id = tbl_id_mat', 'left')
            //->join('txt_tabla_llamadaxtipo_medio', 'tbl_id = txt_id_tbl', 'left')
            ->join('esn_estado_atencion', 'esn_id = tbl_id_esn', 'left')
            ->where('tbl_estado !=', '-1')
            ->order_by('tbl_fecha', 'ASC');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_cuentas_impuesto($where = null)
    {
        $query = $this->db->select()
            ->from('imp_impuesto')
            ->join('cxe_cuentaximpuesto', 'imp_id=cxe_id_imp', 'inner')
            ->join('cnt_cuenta_contable', 'cxe_id_cnt = cnt_id', 'inner')
            ->join('tcn_tipo_cuenta', 'cxe_id_tcn = tcn_id', 'left')
            ->join('cec_centro_costo', 'cec_id = cxe_id_cec', 'left')
            ->join('tif_tipo_factura', 'tif_id = cxe_id_tif', 'left');

        if ($where != null) {
            $this->db->where($where);
        }



        return $query->get()->result_array();
    }

    public function get_base_datos($where = null, $where_in = null, $where_in2 = null, $type = null)
    {
        // print_r($type); die();   
        /*$query = $this->db->select()
                ->from('drn_directorio_contacto')
                ->join('cli_cliente', 'drn_id_cli = cli_id', 'left')
                ->join('ogc_origen_contacto', 'drn_id_ogc = ogc_id', 'left')
                ->join('zod_zona_departamento', 'drn_id_zod = zod_id', 'left')
                ->join('pai_pais', 'drn_id_pai = pai_id', 'left')
                ->join('dep_departamento', 'drn_id_dep = dep_id', 'left')
                ->join('mun_municipio', 'drn_id_mun = mun_id', 'left')
                ->join('sec_sector_cliente', 'drn_id_sec = sec_id', 'left')
                ->join('cac_cartera_cliente', 'drn_id_cac = cac_id', 'left')
        ;*/
        if ($type == 1) {
            //echo "clientes"; die();
            //CLIENTES
            $query = $this->db->select('cli_id, cli_nombre, cli_apellido, cli_representante, sec_nombre, GROUP_CONCAT(DISTINCT tmc_nombre) as origen')
                ->from('cli_cliente')
                ->join('tpc_tipo_cliente', 'cli_id_tpc = tpc_id', 'left')
                ->join('sec_sector_cliente', 'sec_id = cli_id_sec', 'left')
                ->join('cxm_clientexmediocontacto', 'cxm_id_cli = cli_id', 'left')
                ->join('tmc_tipo_medio', 'tmc_id = cxm_id_tmc', 'left');
            if ($where != null) {
                $this->db->where($where);
            }
            //print_r($where_in); die();
            if (count($where_in) > 0) {
                $this->db->where_in('cli_id_tpc', $where_in);
            }
            $this->db->where('cli_estado', 1);
            $this->db->group_by('cli_id');
        } else {
            /*print_r($where);
            echo '<br>';
            print_r($where_in);
            echo '<br>';
            print_r($where_in2);*/
            //echo 'contactos'; die();
            //CONTACTOS
            $query = $this->db->select()
                ->from('drn_directorio_contacto')
                ->join('cli_cliente', 'drn_id_cli = cli_id', 'left')
                ->join('ogc_origen_contacto', 'drn_id_ogc = ogc_id', 'left')
                ->join('zod_zona_departamento', 'drn_id_zod = zod_id', 'left')
                ->join('pai_pais', 'drn_id_pai = pai_id', 'left')
                ->join('dep_departamento', 'drn_id_dep = dep_id', 'left')
                ->join('mun_municipio', 'drn_id_mun = mun_id', 'left')
                ->join('sec_sector_cliente', 'drn_id_sec = sec_id', 'left')
                ->join('cac_cartera_cliente', 'drn_id_cac = cac_id', 'left');
            if ($where != null) {
                $this->db->where($where);
            }
            $this->db->where('drn_id_cli', null);
            if (count($where_in) > 0) {
                $this->db->where_in('ogc_id', $where_in);
            }
            if (count($where_in2) > 0) {
                $this->db->join('exc_etiquetaxcontacto', 'exc_id_drn = drn_id', 'left');
                $this->db->where_in('exc_id_etq', $where_in2);
                $this->db->group_by('drn_id');
            }
        }


        return $query->get()->result_array();
    }

    public function report_proyeccion_ventas($where = null, $order_by = "cot_codigo ASC")
    {
        $query = $this->db->select()
            ->from('cot_cotizacion')
            ->join('ven_vendedor', 'cot_id_ven = ven_id', 'inner')
            ->join('users', 'id = ven_id_usu', 'inner')
            ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
            ->join('cli_cliente', 'cli_id = cot_id_cli', 'inner')
            ->join('est_estado_cotizacion', 'est_id = cot_id_est', 'left')
            ->join('etc_etapa_cotizacion', 'etc_id = cot_id_etc', 'left')
            ->join('axc_articuloxcotizacion', 'axc_id_cot = cot_id', 'inner')
            ->join('art_articulo', 'axc_id_art = art_id', 'inner')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id', 'inner')
            ->join('cva_conversion_articulo', 'axc_id_cva = cva_id', 'left')
            ->join('mep_medida_producto', 'cva_id_mep = mep_id', 'left')
            ->where('cot_estado', 1);

        if ($where != null) {
            $this->db->where($where);
        }

        if ($order_by != '') {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera
     * @since 16/08/2017
     * @return Obtener los datos de materia correspondiente al presupuesto del producto.
     */
    public function get_materia_prima_presupuesto($where = null)
    {
        $query = $this->db->select('*, IF (
    mpa_tipo_precio = 1,
    (
        SELECT
                SUM(sar_precio * sar_cant_actual) / SUM(sar_cant_actual)
        FROM
            moi_movimiento_inv
        INNER JOIN dee_detalle_mov ON moi_id = dee_id_moi
        INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
        INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
        WHERE
            sar_id_art = art_id
        AND
        IF (
            ISNULL(moi_id_prv),
            true,
            moi_id_prv = prv_id
        )
    ),
    (
        SELECT
            sar_precio
        FROM
            moi_movimiento_inv
        INNER JOIN dee_detalle_mov ON moi_id = dee_id_moi
        INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
        INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
        WHERE
            sar_id_art = art_id
        AND
        IF (
            ISNULL(moi_id_prv),
            true,
            moi_id_prv = prv_id
        )
        AND tip_entrada = 1
        ORDER BY
            moi_id DESC
        LIMIT 1
    )
) as tipos_precio,
(
    SELECT etp_id
    FROM etp_etapa
    WHERE etp_id = mpa_id_etp
) AS etapa_id,
(
    SELECT etp_nombre
    FROM etp_etapa
    WHERE etp_id = mpa_id_etp
) AS etapa_nombre', false)
            ->from('mpa_materia_prima_articulo')
            ->join('art_articulo', 'art_id = mpa_id_art_materia', 'inner')
            ->join('cva_conversion_articulo', 'cva_id = mpa_id_cva', 'left')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
            ->join('prv_proveedor', 'prv_id = mpa_id_prv', 'left');

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera
     * @since 16/08/2017
     * @return Obtener los datos de mano de obra correspondiente al presupuesto del producto.
     */
    public function get_mano_obra_presupuesto($where = null)
    {
        $query = $this->db->select()
            ->from('moa_mano_obra_articulo')
            ->join('mob_mano_obra', 'mob_id = moa_id_mob', 'inner')
            ->join('emp_empleado', 'emp_id = moa_id_emp AND emp_estado = 1', 'left');

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /*
	 * @author Raul E
     * @since 06/2021
     * @return Obtener los seguimientos de un prospecto de base de datos y trasladarlos cuando se ha convertido en un nuevo cliente.
	*/
    public function get_seguimientos_base_datos($where = null)
    {
        $query = $this->db->select("sgd_seguimiento_directorio.*, (SELECT con_id FROM con_contacto WHERE con_id_cli = cli_id LIMIT 1) AS contacto", false)
            ->from('cli_cliente')
            ->join('drn_directorio_contacto', 'drn_id_cli = cli_id')
            ->join('sgd_seguimiento_directorio', 'sgd_id_drn = drn_id');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera
     * @since 16/08/2017
     * @return Obtener los datos de gastos indirectos correspondiente al presupuesto del producto.
     */
    public function get_gastos_indirectos_presupuesto($where = null)
    {
        $query = $this->db->select()
            ->from('esr_estimacion_articulo')
            ->join('esm_estimacion', 'esm_id=esr_id_esm', 'inner')
            ->join('art_articulo', 'esr_id_art=art_id', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_axc($tabla, $campo, $where, $order_by)
    {
        $this->db->select('axc_id')
            ->from($tabla)
            ->where($where)
            ->order_by($order_by, 'desc');
        $result = $this->db->get();
        $registro = $result->result();
        if ($registro) {
            foreach ($registro as $field => $value) {
                if ($field == $campo) {
                    return $value;
                }
            }
        }
        return null;
    }


    /********************************* PRESUPUESTOS DE LA COTIZACIÓN (DETALLES) *********************************/
    /**
     * @author Edith Herrera
     * @since  18/08/2017
     * @return Obtener materia prima de la cotización por producto.
     */
    public function get_materia_prima_presupuesto_cot($where = null)
    {
        $query = $this->db->select()
            ->from('axr_articulo_materiaxarticulo')
            ->join('axc_articuloxcotizacion', 'axr_id_axc = axc_id', 'inner')
            ->join('art_articulo', 'art_id = axr_id_art_materia', 'inner')
            ->join('cva_conversion_articulo', 'cva_id = axr_id_cva', 'left')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
            ->join('prv_proveedor', 'prv_id = axr_id_prv', 'left')
            ->join('mpa_materia_prima_articulo', 'axr_id_art_materia = mpa_id_art_materia AND mpa_id_art = axc_id_art', 'left');

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera
     * @since  18/08/2017
     * @return Obtener mano de obra de la cotización por producto.
     */
    public function get_mano_obra_presupuesto_cot($where = null)
    {
        $query = $this->db->select()
            ->from('mxa_mano_obraxarticulo')
            ->join('axc_articuloxcotizacion', 'mxa_id_axc = axc_id', 'inner')
            ->join('mob_mano_obra', 'mob_id = mxa_id_mob', 'inner')
            ->join('emp_empleado', 'emp_id = mxa_id_emp AND emp_estado = 1', 'left');

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera
     * @since  18/08/2017
     * @return Obtener gastos indirectos de la cotización por producto.
     */
    public function get_gastos_indirectos_presupuesto_cot($where = null)
    {
        $query = $this->db->select()
            ->from('exa_estimacionxarticulo')
            ->join('axc_articuloxcotizacion', 'exa_id_axc = axc_id', 'inner')
            ->join('esm_estimacion', 'esm_id=exa_id_esm', 'inner')
            ->join('art_articulo', 'axc_id_art=art_id', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  12/10/2017
     * @return Verifica si hay registros en los presupuestos del producto
     */
    public function get_verificar_presupuesto($where = null, $like = null)
    {
        /*
            SELECT (COUNT(mpa_id) + COUNT(esr_id) + COUNT(moa_id)) suma FROM
        art_articulo
        LEFT JOIN mpa_materia_prima_articulo ON mpa_id_art = art_id
        LEFT JOIN esr_estimacion_articulo ON esr_id_art = art_id
        LEFT JOIN moa_mano_obra_articulo ON moa_id_art = art_id
        WHERE art_id = 264*/
        $query = $this->db->select('*,(COUNT(mpa_id) + COUNT(esr_id) + COUNT(moa_id)) suma', false)
            ->from('art_articulo')
            ->join('mpa_materia_prima_articulo', 'mpa_id_art = art_id', 'left')
            ->join('esr_estimacion_articulo', 'esr_id_art = art_id', 'left')
            ->join('moa_mano_obra_articulo', 'moa_id_art = art_id', 'left')
            ->group_by('art_id');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->or_like('art_nombre', $like);
            $this->db->or_like('art_codigo', $like);
        }

        return $query->get()->result_array();
    }
    function get_productos_like($where = null, $like = null)
    {

        $categorias_final = null;
        if (isset($where['art_id_tia'])) {
            $categorias_final = $this->crear_arbol($where['art_id_tia'], "");
            $categorias_final = $categorias_final . $where['art_id_tia'];
            unset($where['art_id_tia']);
        }

        $query = $this->db->select("*,(COUNT(mpa_id) + COUNT(esr_id) + COUNT(moa_id)) suma")
            ->from('art_articulo')
            ->join('mpa_materia_prima_articulo', 'mpa_id_art = art_id', 'left')
            ->join('esr_estimacion_articulo', 'esr_id_art = art_id', 'left')
            ->join('moa_mano_obra_articulo', 'moa_id_art = art_id', 'left')
            ->join('cra_cursograma_analitico', 'cra_id_art = art_id', 'left')
            ->group_by('art_id');

        if ($categorias_final != null) {
            $categorias = explode(',', $categorias_final);

            $this->db->where_in('art_id_tia', $categorias);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->or_like('art_nombre', $like);
            $this->db->or_like('art_codigo', $like);
        }
        return $query->get()->result_array();
    }

    /**
     *@author: Francisco Orozco
     *Fecha: 24/11/2017
     *Descripción: obtener clientes.
     */
    public function get_clientes_like($where = null, $like = null, $like2 = null)
    {
        $query = $this->db->select()
            ->from('cli_cliente')
            ->join('dcc_documento_cliente', 'dcc_id_cli = cli_id', 'left')
            ->join('tde_tipo_documento', 'tde_id = dcc_id_tde', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->like("concat_ws(' ', cli_nombre, cli_apellido)", $like);
        }

        if ($like2 != null) {
            $this->db->like($like2);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-01-31
     * @return Reporte listado de proyectos
     */
    public function get_ReporteListadoProyecto($where = null)
    {
        $query = $this->db->select('pcl_fecha_creacion,cli_codigo,cli_nombre,cli_apellido,pcl_codigo,pcl_nombre,epr_nombre, cli_personeria,
            (
                SELECT
                    SUM(cot_total)
                FROM
                    cot_cotizacion
                WHERE
                    cot_id_pcl = pcl_id and cot_estado = 1
            ) total_cot,
             (
                SELECT
                    SUM(orc_total)
                FROM
                    orc_orden_compra
                WHERE
                    orc_id_pcl = pcl_id
            ) orden,
             (
                SELECT
                    SUM(dpv_total)
                FROM
                    dpv_documento_proveedor
                WHERE
                    dpv_id_pcl = pcl_id
            ) documento_prv,
             (
                SELECT
                    SUM(fac_total)
                FROM
                    fac_factura
                WHERE
                    fac_id_pcl = pcl_id
            ) facturado,
             (
                SELECT
                    SUM(dch_valor)
                FROM
                    dch_detalle_cheque
                INNER JOIN dpv_documento_proveedor ON dpv_id = dch_id_dpv
                WHERE
                    dpv_id_pcl = pcl_id
            ) cheque', false)
            ->from('pcl_proyecto_cliente')
            ->join('cli_cliente', 'pcl_id_cli = cli_id')
            ->join('epr_estado_proyecto', 'pcl_id_epr = epr_id');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-01-31
     * @return Obtiene el estado del proyecto de un cliente
     */
    public function get_estado_proyecto_cliente($where = null)
    {
        $query = $this->db->distinct()
            ->select('epr_id,epr_nombre')
            ->from('pcl_proyecto_cliente')
            ->join('epr_estado_proyecto', 'pcl_id_epr = epr_id');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-01-31
     * @return Obtiene todos los estados de proyectos para un cliente
     */
    public function get_estados_proyectos($where = null)
    {
        $query = $this->db->distinct()
            ->select('epr_id,epr_nombre')
            ->from('pcl_proyecto_cliente')
            ->join('epr_estado_proyecto', 'pcl_id_epr = epr_id')
            ->join('cli_cliente', 'pcl_id_cli = cli_id');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-02-01
     * @return Obtiene todos los componentes
     */
    public function get_componente_cotizacion($where = null)
    {
        /*SELECT
             cdc_descripcion descripcion,
             mep_nombre medida,
             cdc_cantidad cantidad,
             cva_conversion * (
              cdc_cantidad / (
               SELECT
                cva.cva_conversion
               FROM
                cva_conversion_articulo AS cva
               WHERE
                cva.cva_id_art = art_id
               AND cva.cva_defecto = 1
              )
             ) cantidad_convertida,
             cdc_precio precio,
             cdc_subtotal subtotal,
             cdc_altera_precio altera_precio,

            IF (
             cdc_altera_precio = 1,
             'Si',
             'No'
            ) altera_preciotxt,
             cdc_muestra_descripcion muestra_descripcion,
            IF ( cdc_altera_precio = 1, 'checked', '') muestra_descripcionck,
             art_id,
             art_tipo,
             cva_id,
             mep_id,
             cva_conversion,
             (
             SELECT
              cva.cva_conversion
             FROM
              cva_conversion_articulo AS cva
             WHERE
              cva.cva_id_art = art_id
             AND cva.cva_defecto = 1
            ) cva_defecto
            FROM
             cdc_componente_detalle_cotizacion
            INNER JOIN cva_conversion_articulo ON cva_id = cdc_id_cva
            INNER JOIN art_articulo ON art_id = cva_id_art
            INNER JOIN mep_medida_producto ON mep_id = cva_id_mep
            WHERE cdc_id_axc = 164747*/
        $query = $this->db->select("
                cdc_id codigo,
                cdc_descripcion descripcion,
                mep_nombre medida,
                cdc_cantidad cantidad,
                cva_conversion * (
                    cdc_cantidad / (
                    SELECT
                        cva.cva_conversion
                    FROM
                        cva_conversion_articulo AS cva
                    WHERE
                        cva.cva_id_art = art_id
                    AND cva.cva_defecto = 1
                    )
                ) cantidad_convertida,
                cdc_precio precio,
                cdc_subtotal subtotal,
                cdc_altera_precio altera_precio,
                IF (
                    cdc_altera_precio = 1,
                    'Si',
                    'No'
                ) altera_preciotxt,
                cdc_muestra_descripcion muestra_descripcion,
                IF (
                    cdc_muestra_descripcion = 1,
                    'checked',
                    ''
                ) muestra_descripcionck,
                IF (
                    cdc_altera_precio = 1,
                    'checked',
                    ''
                ) altera_preciock,
                art_id,
                art_tipo,
                cva_id,
                mep_id,
                cva_conversion,
                (
                    SELECT
                        cva.cva_conversion
                    FROM
                        cva_conversion_articulo AS cva
                    WHERE
                        cva.cva_id_art = art_id
                    AND cva.cva_defecto = 1
                ) cva_defecto_a", false)
            ->from('cdc_componente_detalle_cotizacion')
            ->join('cva_conversion_articulo', 'cva_id = cdc_id_cva', 'inner')
            ->join('art_articulo', 'art_id = cva_id_art', 'inner')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-02-03
     * @return Reporte consolidado de cotizaciones por proyecto
     */
    public function get_CotizacionProyectoConsolidado($where = null)
    {
        $query = $this->db
            ->select('
                        cot_id,
                        cot_codigo,
                        cot_fecha,
                        est_nombre,
                        cli_nombre,
                        cli_codigo,
                        cli_apellido,
                        cli_personeria,
                        pcl_id,
                        pcl_codigo,
                        pcl_nombre,
                        epr_id,
                        epr_nombre,
                        SUM(axc_subtotal) subtotal,
                        SUM(

                            IF (
                                axc_descuento > 0,
                                (
                                    axc_subtotal * (axc_descuento / 100)
                                ),
                                0
                            )
                        ) descuento,
                        SUM(axc_impuesto) impuesto,
                        SUM(axc_total) total', false)
            ->from('cot_cotizacion')
            ->join('axc_articuloxcotizacion', 'axc_id_cot = cot_id')
            ->join('pcl_proyecto_cliente', 'cot_id_pcl = pcl_id', 'left')
            ->join('est_estado_cotizacion', 'cot_id_est = est_id')
            ->join('cli_cliente', 'cot_id_cli = cli_id')
            ->join('epr_estado_proyecto', 'pcl_id_epr = epr_id')
            ->group_by('cot_id');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-02-03
     * @return Obtiene el valor de los filtros para el reporte consolidado de cotizaciones por proyecto
     */
    public function get_FiltrosEstadoProyecto($where = null)
    {
        $query = $this->db->distinct()
            ->select('pcl_id, pcl_codigo, pcl_nombre, epr_id, epr_nombre, cot_codigo, cot_id')
            ->from('cot_cotizacion')
            ->join('pcl_proyecto_cliente', 'cot_id_pcl = pcl_id', 'left')
            ->join('epr_estado_proyecto', 'pcl_id_epr = epr_id')
            ->group_by('pcl_id');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-02-03
     * @return Reporte detallado de cotizaciones por proyecto
     */
    public function get_CotizacionProyectoDetallado($where = null)
    {
        $query = $this->db
            ->select('
                        cot_id,
                        cot_codigo,
                        cli_id,
                        cli_codigo,
                        cli_nombre,
                        cli_apellido,
                        cli_personeria,
                        pcl_nombre,
                        epr_nombre,
                        art_nombre,
                        axc_cantidad,
                        axc_precio,
                        axc_subtotal,

                        IF (
                            axc_descuento > 0,
                            (
                                axc_subtotal * (axc_descuento / 100)
                            ),
                            0
                        ) descuento,
                         axc_impuesto,
                         axc_total,
                         art_codigo,
                         cot_codigo,
                         cot_fecha', false)
            ->from('cot_cotizacion')
            ->join('pcl_proyecto_cliente', 'cot_id_pcl = pcl_id', 'left')
            ->join('cli_cliente', 'cot_id_cli = cli_id')
            ->join('axc_articuloxcotizacion', 'axc_id_cot = cot_id')
            ->join('art_articulo', 'axc_id_art = art_id')
            ->join('epr_estado_proyecto', 'pcl_id_epr = epr_id')
            ->group_by('cot_id,art_id');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_productos_likee($where = null, $like = null)
    {

        //$query = $this->db->select("*")
        $query = $this->db->select("*,sum(sar_cant_actual) as saldo")
            ->from('art_articulo')
            ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep')
            ->join('cdp_codigo_producto', 'cdp_id_art=art_id', 'left')
            ->join('sar_saldo_articulo', 'sar_id_art=art_id ', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->where($like);
        }
        $this->db->group_by('art_id');
        $this->db->limit('500');
        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera
     * @since  2018-03-12
     * @return Se obtiene el registro completo del seguimiento
     */
    public function getSeguimiento($where = null)
    {
        $query = $this->db->select("tsg_nombre, sel_fecha, IF(tbl_cliente_nombre=tbl_cliente_apellido,tbl_cliente_nombre,CONCAT_WS(' ',tbl_cliente_nombre,tbl_cliente_apellido)) as cliente, sel_id_ven, sel_id_tbl, sel_id_tsg, tbl_fecha", FALSE)
            ->from('tbl_tabla_llamadas')
            ->join('sel_seguimiento_llamada', 'sel_id_tbl=tbl_id', 'left')
            ->join('tsg_tipo_seguimiento', 'sel_id_tsg = tsg_id', 'left')
            ->join('ven_vendedor', 'sel_id_ven = ven_id', 'left')
            ->join('esn_estado_atencion', 'sel_id_esn = esn_id', 'left')
            //->group_by('pcl_id');
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->row();
    }
    /**
     *Descripcion:
     *Genera un reporte en excel con los registros de la tabla base de datos
     * @author Nelson Soriano
     * @since  17-12-2018
     * @return Devuelve los registros para exportar a excel
     */

    public function obtener_base_datos($where = null, $groupby = null, $orderby = null)
    {
        $this->db->select(
            "
                drn_id,
                drn_nombre,
                drn_contacto,
                drn_cargo,
                drn_telefono,
                IF(
                    drn_email IS NULL,
                    '',
                    drn_email
                )AS email,
                drn_sitio_web,
                drn_direccion,
                drn_observacion,
                IF (
                    cli_nombre IS NULL,
                    CONCAT(
                            cli_nombre,
                            ' ',
                            cli_apellido
                        ),
                    IF(
                        cli_personeria = 1,
                        CONCAT(
                            cli_nombre,
                            ' ',
                            cli_apellido
                        ),
                        cli_apellido
                    )
                )AS nombre_cliente,               
                cac_nombre,
                dep_nombre,
                mun_nombre,
                ogc_nombre,
                pai_nombre,
                sec_nombre,
                zod_nombre,
                (
                    SELECT GROUP_CONCAT(etq_nombre)
                    FROM etq_etiqueta
                    INNER JOIN exc_etiquetaxcontacto on exc_id_etq = etq_id
                    WHERE etq_estado = 1 AND exc_id_drn = drn_id 
                )AS etiquetas,
                (
                    SELECT GROUP_CONCAT(tmc_nombre)
                    FROM tmc_tipo_medio
                    INNER JOIN txd_tipo_contactoxdirectorio_cont on txd_id_tmc = tmc_id
                    where tmc_estado = 1 AND txd_id_drn = drn_id
                )AS medios
                ",
            false
        )
            ->from('drn_directorio_contacto')
            ->where(array('drn_estado' => 1))
            ->join('cli_cliente',                      'drn_id_cli = cli_id     AND cli_estado = 1',  'left')
            ->join('cac_cartera_cliente',              'drn_id_cac = cac_id     AND cac_estado = 1',  'left')
            ->join('dep_departamento',                 'drn_id_dep = dep_id     AND dep_estado = 1',  'left')
            ->join('mun_municipio',                    'drn_id_mun = mun_id     AND mun_estado = 1',  'left')
            ->join('ogc_origen_contacto',              'drn_id_ogc = ogc_id     AND ogc_estado = 1',  'left')
            ->join('pai_pais',                         'drn_id_pai = pai_id     AND pai_estado = 1',  'left')
            ->join('sec_sector_cliente',               'drn_id_sec = sec_id     AND sec_estado = 1',  'left')
            ->join('zod_zona_departamento',            'drn_id_zod = zod_id     AND zod_estado = 1',  'left')
            ->join('exc_etiquetaxcontacto',            'drn_id     = exc_id_drn AND exc_estado = 1',  'left')
            ->join('txd_tipo_contactoxdirectorio_cont', 'drn_id     = txd_id_drn AND txd_estado = 1',  'left')
            ->group_by('drn_id');
        /*
                if ($where != null) {
                    $this->db->where($where);
                }
                if ($groupby != null) {
                    $this->db->group_by($groupby);
                }
                if ($orderby != null) {
                    $this->db->order_by($orderby);
                }
                */
        return $query = $this->db->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since  2018-07-23
     * @return Se obtiene los registros completos para el reporte de tabla de llamadas
     */
    public function obtener_tabla_llamadas($where = null, $groupby = null, $orderby = null)
    {
        $query = $this->db->select(
            "
             tbl_fecha,
             CONCAT(
                ven_nombre,
                ' ',
                ven_apellidos
            ) AS nombre_vendedor,

            IF (
                tbl_cliente_nombre IS NULL,
                CONCAT(
                    cli_nombre,
                    ' ',
                    cli_apellido
                 ),

            IF (
                tbl_personeria = 1,
                CONCAT(
                    tbl_cliente_nombre,
                    ' ',
                    tbl_cliente_apellido
                ),
                tbl_cliente_nombre
            )
            )AS cliente,
             tbl_correo,
             tbl_id,
             cli_email,
             art_nombre,
             tbl_nuevo,
             tbl_contacto,
             tbl_recado,
             tbl_telefono,
             tbl_fecha_prox_contacto,
             mat_nombre,
             (
                SELECT
                    GROUP_CONCAT(tmc_nombre)
                FROM
                    txt_tabla_llamadaxtipo_medio
                JOIN tmc_tipo_medio ON txt_id_tmc = tmc_id
                WHERE
                    txt_id_tbl = tbl_id
            ) AS medio_contacto
            ",
            false
        )
            ->from('tbl_tabla_llamadas')
            ->join('art_articulo',       'art_id = tbl_id_art', 'left')
            ->join('ven_vendedor',       'ven_id = tbl_id_ven', 'left')
            ->join('cli_cliente',        'cli_id = tbl_id_cli', 'left')
            ->join('mat_motivo_atencion', 'mat_id = tbl_id_mat', 'left');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Nelson Soriano
     * @since 27/011/2018
     * @param id_tipo_segfuimiento
     * @return Nombre del tipo 
     */

    public function get_nombre($id)
    {
        $this->db->select('mat_nombre');
        $this->db->from('mat_motivo_atencion');
        $this->db->where('mat_id', $id);
        return  $this->db->get()->result_array();
    }

    /**
     * @author Rafael Cuchilla
     * @since 26/07/2018
     * @return Obtener los datos de reporte de cotizaciones personalizadas.
     */
    public function get_cotizaciones_personalizadas($where = null)
    {
        $query = $this->db->select("
                cot_id,
                cot_concepto,
                cot_codigo as cod,
                cot_total as total,
                CONCAT_WS(
                    ' ',
                    cli_nombre,
                    cli_apellido
                ) AS nombre,
                (
                SELECT GROUP_CONCAT(art_nombre SEPARATOR ' - ')
                FROM axc_articuloxcotizacion
                INNER JOIN art_articulo ON art_id = axc_id_art
                WHERE axc_id_cot = cot_id
                and
                    ((axc_personalizado <> '') or (axc_personalizado >0))
                )as productos,
                DATE(cot_fecha_creacion) fecha,
                est_nombre,
                COUNT(*) cant_productos,
                (
                    SELECT
                    IF (
                        ISNULL(SUM(ax.axc_personalizado)),
                        0,
                        SUM(ax.axc_personalizado)
                    )
                    FROM
                        axc_articuloxcotizacion ax
                    WHERE
                        ax.axc_id_cot = cot_id
                    GROUP BY
                        ax.axc_id_cot
                ) personalizados", false)
            ->from('cot_cotizacion')
            ->join('cli_cliente', 'cli_id = cot_id_cli', 'inner')
            ->join('est_estado_cotizacion', 'est_id = cot_id_est', 'inner')
            ->join('axc_articuloxcotizacion', 'axc_id_cot = cot_id', 'inner')
            ->join('art_articulo', 'art_id = axc_id_art', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('cot_id');

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro
     * @since  2018-08-13
     * @return Se obtiene los registros de vendedor por empleado
     */
    public function get_vendedorxempleado($where = null, $groupby = null, $orderby = null)
    {
        $query = $this->db->select()
            ->from('ven_vendedor')
            ->join('users', 'id = ven_id_usu', 'INNER')
            ->join('emp_empleado', 'emp_id = usu_id_emp', 'left');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-08-21
     * @return Se obtienen los datos de envíos parciales de cotizaciones
     */
    public function get_envío_cot($where = null)
    {
        $query = $this->db->select("art_id, art_foto, den_fecha, cot_codigo, cot_fecha, axc_id, CONCAT_WS(' ',cli_nombre, cli_apellido) AS cliente, enc_id, den_id, tia_nombre, den_cantidad, axc_personalizado, CONCAT_WS(' ', con_nombre, con_apellidos ) AS contacto, cli_direccion, art_descripcion, art_foto,
            (SELECT GROUP_CONCAT(CONCAT_WS(': ',car_nombre,cxo_valor)) AS caract
                FROM cxo_caracxarticuloxcotizacion
                INNER JOIN cxu_caracxarticulo ON cxo_id_cxu=cxu_id
                INNER JOIN cxr_caractxtipo_articulo ON cxr_id=cxu_id_cxr
                INNER JOIN car_caracteristica ON car_id=cxr_id_car
                INNER JOIN axc_articuloxcotizacion dax ON cxo_id_axc = dax.axc_id
                WHERE cxo_id_axc = axc_id AND axc.axc_id = dax.axc_id GROUP BY dax.axc_id_cot
            ) AS caracteristicas", FALSE)
            ->from('cot_cotizacion')
            ->join('enc_envio_cotizacion', 'enc_id_cot = cot_id', 'INNER')
            ->join('den_detalle_envio', 'enc_id = den_id_enc', 'INNER')
            ->join('con_contacto', 'den_id_con = con_id', 'INNER')
            ->join('axc_articuloxcotizacion AS axc', 'axc_id = den_id_axc AND axc.axc_id_cot = enc_id_cot', 'INNER')
            ->join('cli_cliente', 'cot_id_cli = cli_id', 'INNER')
            ->join('art_articulo', 'axc.axc_id_art = art_id', 'INNER')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id', 'INNER')

            ->join('cxu_caracxarticulo', 'cxu_id_art = art_id', 'left')
            ->join('cxr_caractxtipo_articulo', 'cxu_id_cxr = cxr_id', 'left');
        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('axc_id');

        return $query->get()->result_array();
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-09-10
     * @return Se obtienen los contactos por campana
     */
    public function get_contactos_x_campana($where = null, $groupby = null, $orderby = null)
    {
        $query = $this->db->select("*, (SELECT GROUP_CONCAT(DISTINCT c1.cnc_id_cli) FROM cnc_contactos_campania c1 WHERE c1.cnc_id_cam = c.cnc_id_cam) AS ids_cliente", false)
            ->from('cnc_contactos_campania c')
            ->join('drn_directorio_contacto', 'drn_id = c.cnc_id_drn', 'left')
            ->join('ogc_origen_contacto', 'drn_id_ogc = ogc_id', 'left')
            ->join('cac_cartera_cliente', 'drn_id_cac = cac_id', 'left')
            ->join('cli_cliente', 'c.cnc_id_cli = cli_id', 'left')
            ->join('sec_sector_cliente', 'sec_id = cli_id_sec', 'left')
            ->join('cxm_clientexmediocontacto', 'cxm_id_cli = cli_id', 'left')
            ->join('tmc_tipo_medio', 'tmc_id = cxm_id_tmc', 'left');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        return $query->get()->result_array();
    }

    public function get_medio()
    {
        $query = $this->db->select('cli_id, GROUP_CONCAT(DISTINCT tmc_nombre) tmc_nombre')
            ->from('cli_cliente')
            ->join('cxm_clientexmediocontacto', 'cxm_id_cli = cli_id')
            ->join('tmc_tipo_medio', 'tmc_id = cxm_id_tmc')
            ->group_by('cli_id');
        return $query->get()->result_array();
    }

    // para conocer si un impuesto esta presente en una cotizacion
    //Rafael cuchilla 29/09/20
    public function impuesto_cot($where = null, $like = null)
    {
        $query = $this->db->select("cot_id,axc_id,ixt_id_imp,imp_nombre,imp_porcentaje")
            ->from('cot_cotizacion')
            ->join('axc_articuloxcotizacion', 'axc_id_cot = cot_id')
            ->join('ixt_impuestoxcotizacion', 'ixt_id_axc = axc_id')
            ->join('imp_impuesto', 'imp_id = ixt_id_imp');
        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->like('imp_nombre', $like, 'both');
        }
        $this->db->limit(1);
        return $query->get()->row_array();
    }
    // funcion para conocer el numero de cotizaciones pendiente de acuerdo al usuario que se haya logueado.
    // Rafael Cuchilla  29/09/2018
    public function cot_pendientes($where = null)
    {
        $query = $this->db->query("SELECT count(*) as cantidad
              FROM cot_cotizacion
              JOIN est_estado_cotizacion ON est_id = cot_id_est
              JOIN ven_vendedor ON ven_id = cot_id_ven
              JOIN users u ON u.id = ven_id_usu
              WHERE u.id =" . $where['id'] . " AND cot_estado = 1 AND est_seguimiento = 1
              AND IF(ISNULL(cot_fecha_revisado),DATE_SUB(CURDATE(), INTERVAL 1 DAY),date_format(cot_fecha_revisado,'%Y-%m-%d')) <> '" . $where['cot_fecha_revisado'] . "'", false);

        return $query->row_array();
    }
    // funcion para conocer el ID  de las cotizaciones pendiente de acuerdo al usuario que se haya logueado.
    // Rafael Cuchilla  29/09/2018
    public function id_cot_pendientes($where = null)
    {
        $query = $this->db->query("SELECT cot_id
             FROM cot_cotizacion
             JOIN est_estado_cotizacion ON est_id = cot_id_est
             JOIN ven_vendedor ON ven_id = cot_id_ven
             JOIN users u ON u.id = ven_id_usu
             WHERE u.id =" . $where['id'] . " AND cot_estado = 1 AND est_seguimiento = 1
             AND IF(ISNULL(cot_fecha_revisado),DATE_SUB(CURDATE(), INTERVAL 1 DAY),date_format(cot_fecha_revisado,'%Y-%m-%d')) <> '" . $where['cot_fecha_revisado'] . "'", false);

        return $query->result_array();
    }

    /**
     * 
     * 13/11/2018
     * @autor Elman Ortiz
     * Returna las etapas del producto que posee en caso de ternerlas
     */
    public function verificar_tiene_etapas_cotizacion($where = null)
    {
        $this->db->select('etp_id, etp_nombre')
            ->from('axc_articuloxcotizacion')
            ->join('axr_articulo_materiaxarticulo', 'axc_id = axr_id_axc')
            ->join('etp_etapa', 'axr_id_etp = etp_id')
            ->join('eta_etapa_articulo', 'etp_id = eta_id_etp');

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('etp_id');

        return $this->db->get()->result_array();
    }


    /**
     * @author René Castaneda
     * @since 12-11-2018
     * @return Obtener departamentos.
     */
    public function obtener_departamento($where = null, $campos = "*")
    {
        $query = $this->db->select($campos)
            ->from('dep_departamento')
            ->join('pai_pais', 'pai_id = dep_id_pai', 'left');
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author René Castaneda
     * @since 12-11-2018
     * @return Obtener municipios.
     */
    public function obtener_municipios($where = null, $campos = "*")
    {
        $query = $this->db->select($campos)
            ->from('mun_municipio')
            ->join('dep_departamento', 'dep_id = mun_id_dep', 'left');
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author René Castaneda
     * @since 14-11-2018
     * @return Obtener clientes.
     */
    public function obtener_cliente($where = null, $campos = "*")
    {
        $query = $this->db->select($campos, false)
            ->from('cli_cliente')
            ->join('pai_pais', 'pai_id = cli_id_pai', 'left')
            ->join('pro_profesion', 'pro_id = cli_id_pro', 'left')
            ->join('cxm_clientexmediocontacto', 'cxm_id_cli = cli_id', 'left')
            ->join('tmc_tipo_medio', 'tmc_id = cxm_id_tmc', 'left')
            ->join('tpn_tipo_precio_cliente', 'tpn_id_cli = cli_id', 'left')
            ->join('tlp_tipo_lista_precio', 'tlp_id = tpn_id_tlp', 'left')
            ->join('txc_telefonoxcliente', 'txc_id_cli = cli_id', 'left')
            ->join('tit_tipo_telefono', 'tit_id = txc_id_tit', 'left')
            ->join('tpc_tipo_cliente', 'tpc_id = cli_id_tpc', 'left')
            ->join('mun_municipio', 'mun_id = cli_id_mun', 'left')
            ->join('dep_departamento', 'dep_id = mun_id_dep', 'left')
            ->join('zog_zona_geografica', 'zog_id = cli_id_zog', 'left')
            ->join('sec_sector_cliente', 'sec_id = cli_id_sec', 'left')
            ->join('cac_cartera_cliente', 'cac_id = cli_id_cac', 'left')
            ->join('gir_giro', 'gir_id = cli_id_gir', 'left')
            ->join('dcc_documento_cliente', 'dcc_id_cli = cli_id', 'left')
            ->join('tde_tipo_documento', 'tde_id = dcc_id_tde', 'left')
            ->group_by('cli_id');
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }
    /**
     * @author René Castaneda
     * @since 14-11-2018
     * @return Obtener sucursales clientes.
     */
    public function get_sucursal_cliente($where = null, $campos = "*")
    {
        $query = $this->db->select($campos, false)
            ->from('scl_sucursal_cliente')
            ->join('mun_municipio', 'mun_id=scl_id_mun', 'left')
            ->join('dep_departamento', 'dep_id=mun_id_dep', 'left');
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }


    /**********************************************************/
    /**
     * @author Elman Ortiz  
     * @since 2018-12-05
     * @param array where
     * @return array participacion de ventas por cliente
     */
    public function get_nombre_cliente_personeria()
    {
        $query = "
            SELECT cli_id,
            IF(cli_personeria = 1, CONCAT(cli_codigo, ' - ',cli_nombre, ' ',cli_apellido), CONCAT(cli_codigo, ' - ',cli_apellido)) AS cli_nombre
            FROM cli_cliente          
        ";

        $result = $this->db->query($query);
        return $result->result_array();
    } //Fin get_reporte_participacion_cliente

    /**
     * @author Francisco Orozco
     * @since 20-12-2018
     * @return Obtener Categorias.
     */
    public function obtener_categorias($where = null, $like = null, $campos = "*")
    {
        $query = $this->db->select($campos, false)
            ->from('tia_tipo_articulo')
            ->join('ixr_impuestox_tipo_articulo', 'ixr_id_tia = tia_id', 'left')
            ->join('imp_impuesto', 'imp_id = ixr_id_imp', 'left')
            ->join('cxr_caractxtipo_articulo', 'cxr_id_tia = tia_id', 'left')
            ->join('car_caracteristica', 'car_id = cxr_id_car', 'left')
            ->group_by('tia_id');
        if ($where) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->like($like);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Francisco Orozco
     * @since 20-12-2018
     * @return Obtener productos.
     */
    public function obtener_productos($where = null, $like = null, $campos = "*")
    {
        $query = $this->db->select($campos, false)
            ->from('art_articulo')
            ->join('mrp_marca_producto', 'mrp_id = art_id_mrp', 'left')
            ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
            ->join('cxu_caracxarticulo', 'cxu_id_art = art_id', 'left')
            ->join('cxr_caractxtipo_articulo', 'cxr_id = cxu_id_cxr', 'left')
            ->join('car_caracteristica', 'car_id = cxr_id_car', 'left')
            ->join('gia_galeria_imagen_articulo', 'gia_id_art = art_id', 'left')
            ->group_by('art_id');
        if ($where) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->like($like);
        }

        return $query->get()->result_array();
    }

    /**
     *@author: Elman Ortiz
     *Fecha: 24/11/2017
     *Descripción: obtener clientes.
     */
    public function get_clientes_x_segmento($where = null, $like = null, $like2 = null)
    {
        $query = $this->db->select()
            ->from('cli_cliente')
            ->join('dcc_documento_cliente', 'dcc_id_cli = cli_id', 'left')
            ->join('tde_tipo_documento', 'tde_id = dcc_id_tde', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        /*if ($like != null) {
            $this->db->like("concat_ws(' ', cli_nombre, cli_apellido)",$like);
        }*/

        /*if ($like2 != null) {
            $this->db->like($like2);
        }*/
        return $query->get()->result_array();
    }

    public function productos_ajax($where = null)
    {
        $this->db->select('art_nombre,art_codigo,art_id')
            ->from('art_articulo')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id', 'inner');
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_presupuestos($where = null)
    {
        $this->db->select('
                            *,(select art_nombre from art_articulo where art_id = mpa_id_art_materia) as materia,
                              (select mob_nombre from mob_mano_obra where mob_id = moa_id_mob) as mano,
                              (select esm_nombre from esm_estimacion where esm_id = esr_id_esm) as estimacion
                        ', false)
            ->from('art_articulo')
            ->join('mpa_materia_prima_articulo', 'art_id = mpa_id_art', 'left')
            ->join('moa_mano_obra_articulo', 'art_id = moa_id_art', 'left')
            ->join('esr_estimacion_articulo', 'art_id = esr_id_art', 'left')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id', 'inner')
            ->join('esm_estimacion', 'esm_id = esr_id_art', 'left');
        if ($where) {
            $this->db->where($where);
        }
        $this->db->group_by('art_id');
        return $this->db->get()->result_array();
    }

    public function get_materia($where = null)
    {
        $this->db->select('prv_nombre as proveedor, mep_nombre as medida,mpa_cantidad as cantidad,mpa_precio as precio,
                    (select art_nombre from art_articulo where art_id = mpa_id_art_materia) as materia
                 ')
            ->from('mpa_materia_prima_articulo')
            ->join('art_articulo', 'mpa_id_art = art_id', 'inner')
            ->join('cva_conversion_articulo', 'cva_id = mpa_id_cva', 'left')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'inner')
            ->join('prv_proveedor', 'prv_id = mpa_id_prv', 'left');
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_mano_obra($where = null)
    {
        $this->db->select('
                    emp_nombre as responsable,moa_cantidad as cantidad,moa_precio as precio,
                    (select mob_nombre from mob_mano_obra where mob_id = moa_id_mob) as mano
                    ')
            ->from('moa_mano_obra_articulo')
            ->join('art_articulo', 'art_id = moa_id_art', 'inner')
            ->join('emp_empleado', 'emp_id = moa_id_emp', 'left');
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_esr($where = null)
    {
        $this->db->select('esr_cantidad as cantidad,esr_precio as precio,
                        (select esm_nombre from esm_estimacion where esm_id = esr_id_esm) as estimacion
                       ')
            ->from('esr_estimacion_articulo')
            ->join('art_articulo', 'art_id = esr_id_art', 'left');
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_caracteristicas($where = null)
    {
        $this->db->select('
                car_nombre as nombre,
                cxu_valor as defecto,
                (
                SELECT GROUP_CONCAT(vrl_valor) from vrl_valores_lista where vrl_id_car = car_id            
                )as valores
                ')
            ->from('art_articulo')
            ->join('cxu_caracxarticulo', ' cxu_id_art = art_id', 'inner')
            ->join('cxr_caractxtipo_articulo', ' cxr_id = cxu_id_cxr', 'inner')
            ->join('car_caracteristica', 'car_id = cxr_id_car', 'inner');
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 22/02/2019
     * @return Obtener los seguimientos hecho por cotizacion
     */
    function get_cliente_con_seguimiento_x_cotizacion()
    {

        $this->db->select('cli_id, IF(cli_personeria = 1, CONCAT(cli_nombre," ",cli_apellido), cli_apellido) AS cli_nombre', false)
            ->from('seg_seguimiento')
            ->join('cot_cotizacion', 'seg_id_cot = cot_id')
            ->join('cli_cliente', 'cot_id_cli = cli_id')
            ->group_by('cli_id');

        return $this->db->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 22/02/2019
     * @return Obtener los seguimientos hecho por llamada
     */
    function get_cliente_con_seguimiento_x_llamada()
    {

        $this->db->select('cli_id, IF(cli_personeria = 1, CONCAT(cli_nombre," ",cli_apellido), cli_apellido) AS cli_nombre', false)
            ->from('sel_seguimiento_llamada')
            ->join('tbl_tabla_llamadas', 'sel_id_tbl = tbl_id')
            ->join('cli_cliente', 'tbl_id_cli = cli_id')
            ->group_by('cli_id');

        return $this->db->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 23/02/2019
     * @return Obtener los seguimientos hecho por administracion de cliente
     */
    function get_cliente_con_seguimiento_x_administracion_cliente()
    {

        $this->db->select('cli_id, IF(cli_personeria = 1, CONCAT(cli_nombre," ",cli_apellido), cli_apellido) AS cli_nombre', false)
            ->from('sec_seguimiento_cliente')
            ->join('tbl_tabla_llamadas', 'sec_id = tbl_id_sec')
            ->join('cli_cliente', 'tbl_id_cli = cli_id')
            ->group_by('cli_id');

        return $this->db->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 22/02/2019
     * @return Obtener los datos de reporte de seguimiento de cotizaciones
     */
    public function get_seguimientos_cotizacion($where = null, $where_in = null)
    {
        $query = $this->db->select("
                            cot_id, cot_codigo AS codigo_cotizacion,
                             IF(cli_personeria = 1, cli_nombre, CONCAT(cli_nombre,' - ',cli_apellido)) AS cli_nombre,
                             (
                                SELECT CONCAT(con_nombre, ' ', con_apellidos) 
                                FROM con_contacto
                                WHERE con_id = seg_id_con
                             ) AS nombre_contacto,
                             (
                                SELECT con_telefono
                                FROM con_contacto
                                WHERE con_id = seg_id_con
                             ) AS telefono_contacto,
                             DATE_FORMAT(seg_fecha, '%d-%m-%Y') AS fecha_seguimiento,
                             seg_comentario AS comentario,
                             DATE_FORMAT(seg_fecha_proximo, '%d-%m-%Y') AS fecha_proximo_seguimiento,
                             (
                                SELECT tsg_nombre
                                FROM tsg_tipo_seguimiento
                                WHERE tsg_id = seg_id_tsg
                             ) AS tipo_seguimiento,
                             (
                                SELECT GROUP_CONCAT(art_nombre SEPARATOR '<br>--')
                                FROM axc_articuloxcotizacion
                                JOIN art_articulo ON axc_id_art = art_id
                                WHERE axc_id_cot = cot_id
                             ) AS producto,
                             (
                                SELECT GROUP_CONCAT(axc_cantidad SEPARATOR '<br>--')
                                FROM axc_articuloxcotizacion
                                JOIN art_articulo ON axc_id_art = art_id
                                WHERE axc_id_cot = cot_id
                             ) AS cantidad,
                             cot_total AS monto", false)
            ->from('cli_cliente')
            ->join('cot_cotizacion', 'cli_id = cot_id_cli')
            ->join('seg_seguimiento', 'cot_id = seg_id_cot');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($where_in != 'null') {
            $this->db->where_in('cli_id', $where_in);
        }
        //$this->db->group_by('cot_id');

        return $query->get()->result_array();
        /*print_r($this->db->last_query()); die();*/
    }

    /**
     * @author Elman Ortiz
     * @since 22/02/2019
     * @return Obtener los datos de seguimiento por llamadas.
     */
    public function get_seguimientos_llamada($where = null, $where_in = null)
    {
        $query = $this->db->select("
                            sgd_id,
                            '' AS 'cot_id',
                            '' AS 'codigo_cotizacion',
                            IF (
                                cli_personeria = 1,
                                cli_nombre,
                                CONCAT(
                                    cli_nombre,
                                    ' - ',
                                    cli_apellido
                                )
                            ) AS cli_nombre,
                             sgd_contacto AS nombre_contacto,
                             sgd_contacto AS telefono_contacto,
                             DATE_FORMAT(sgd_fecha, '%d-%m-%Y') AS fecha_seguimiento,
                             sgd_comentario AS comentario,
                             DATE_FORMAT(
                                sgd_fecha_proximo,
                                '%d-%m-%Y'
                            ) AS fecha_proximo_seguimiento,
                            (
                                SELECT
                                    tsg_nombre
                                FROM
                                    tsg_tipo_seguimiento
                                WHERE
                                    tsg_id = sgd_id_tsg
                            ) AS tipo_seguimiento,
                            (
                                SELECT
                                    GROUP_CONCAT(art_nombre SEPARATOR '<br>--')
                                FROM
                                    axc_articuloxcotizacion
                                JOIN art_articulo ON axc_id_art = art_id
                                WHERE axc_id_cot = cot_id
                            ) AS producto,
                            (
                                SELECT
                                    GROUP_CONCAT(axc_cantidad SEPARATOR '<br>--')
                                FROM
                                    axc_articuloxcotizacion
                                JOIN art_articulo ON axc_id_art = art_id
                                WHERE
                                    axc_id_cot = cot_id
                            ) AS cantidad,
                             '' AS 'monto'", false)
            ->from('cli_cliente')
            ->join('drn_directorio_contacto', 'drn_id_cli = cli_id')
            ->join('sgd_seguimiento_directorio', 'sgd_id_drn = drn_id')
            //->join('tbl_tabla_llamadas', 'cli_id = tbl_id_cli')
            //->join('sel_seguimiento_llamada', 'tbl_id = sel_id_tbl')            
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($where_in != 'null') {
            $this->db->where_in('cli_id', $where_in);
        }
        //$this->db->group_by('cot_id');        
        return $query->get()->result_array();
        /*print_r($this->db->last_query()); die();*/
    }

    /**
     * @author Elman Ortiz
     * @since 22/02/2019
     * @return Obtener los datos de reporte de seguimiento de administarcion de cliente
     */
    public function get_seguimientos_x_administracion_cliente($where = null, $where_in = null)
    {
        $query = $this->db->select("
                            sec_id,
                            '' AS 'cot_id',
                            '' AS 'codigo_cotizacion',
                            IF (
                                cli_personeria = 1,
                                cli_nombre,
                                CONCAT(
                                    cli_nombre,
                                    ' - ',
                                    cli_apellido
                                )
                            ) AS cli_nombre,
                             CONCAT(con_nombre, ' ', con_apellidos) AS nombre_contacto,
                             con_telefono AS telefono_contacto,
                             DATE_FORMAT(sec_fecha, '%d-%m-%Y') AS fecha_seguimiento,
                             sec_comentario AS comentario,
                             DATE_FORMAT(
                                sec_fecha_proximo,
                                '%d-%m-%Y'
                            ) AS fecha_proximo_seguimiento,
                             (
                                SELECT
                                    tsg_nombre
                                FROM
                                    tsg_tipo_seguimiento
                                WHERE
                                    tsg_id = sec_id_tsg
                            ) AS tipo_seguimiento,
                             (
                                SELECT
                                    GROUP_CONCAT(art_nombre SEPARATOR '<br>--')
                                FROM
                                    axc_articuloxcotizacion
                                JOIN art_articulo ON axc_id_art = art_id
                                WHERE
                                    axc_id_cot = cot_id
                            ) AS producto,
                             (
                                SELECT
                                    GROUP_CONCAT(
                                        axc_cantidad SEPARATOR '<br>--'
                                    )
                                FROM
                                    axc_articuloxcotizacion
                                JOIN art_articulo ON axc_id_art = art_id
                                WHERE
                                    axc_id_cot = cot_id
                            ) AS cantidad,
                             '' AS 'monto'", false)
            ->from('cli_cliente')
            ->join('con_contacto', 'cli_id = con_id_cli')
            ->join('sec_seguimiento_cliente', 'con_id = sec_id_con');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($where_in != 'null') {
            $this->db->where_in('cli_id', $where_in);
        }

        return $query->get()->result_array();
    }

    function get_productos_bodega_user($where = null, $like = null, $bodega = null){
        $script = "art_id, art_id_bod, art_nombre, art_codigo, art_tipo, art_sinonimo, cva_conversion, cva_medida_equivalente, 
                mep_nombre, cdp_codigo, IFNULL(SUM(sar_cant_actual),0)  as totales";
        $query = $this->db->select($script, false)
            ->from('art_articulo')
            ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep')
            ->join('cdp_codigo_producto', 'cdp_id_art=art_id', 'left')
            ->join('sar_saldo_articulo', 'sar_id_art=art_id ', 'left');

        if ($bodega != null) {
            $this->db->where_in('art_id_bod', $bodega);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->where("(art_nombre LIKE '%$like%' OR art_codigo LIKE '%$like%' OR art_sinonimo LIKE '%$like%' OR cdp_codigo LIKE '%$like%')", null, FALSE);
        }
        $this->db->group_by('art_id');
        $this->db->limit('200');
        return $query->get()->result_array();
    }

    public function get_prod_bod_total($article = null)
    {
        $script = "*, IFNULL(SUM(sar_cant_actual),0) as totales";
        $query  = $this->db->select($script, false)
            ->from('art_articulo')
            ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1')
            ->join('mep_medida_producto', 'mep_id = cva_id_mep')
            ->join('sar_saldo_articulo', 'sar_id_art=art_id ', 'left');
        $this->db->where('cva_defecto', 1);
        if ($article != null) {
            $this->db->where('art_id', $article);
        }
        $this->db->group_by('art_id');
        return $query->get()->result_array();
    }

    public function get_caracteristicas2($where = null)
    {
        $this->db->select("
                    car_nombre as nombre,
                    cxu_valor as valores,
                    cxu_id as id
                ", false)
            ->from('cxu_caracxarticulo')
            ->join('art_articulo', ' cxu_id_art = art_id', 'inner')
            ->join('cxr_caractxtipo_articulo', ' cxr_id = cxu_id_cxr', 'inner')
            ->join('car_caracteristica', 'car_id = cxr_id_car', 'inner');
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_datos_llamada_sac($id)
    {
        $query = $this->db->select('*, GROUP_CONCAT(txt_id_tmc) as medios', false)
            ->from('tbl_tabla_llamadas')
            ->join('txt_tabla_llamadaxtipo_medio', 'txt_id_tbl = tbl_id', 'left')
            ->join('sec_sector_cliente', 'tbl_id_sec = sec_id', 'left')
            ->where('tbl_id', $id);
        return $query->get()->result_array();
    }

    public function get_clientes_sector($where = null)
    {
        $query = $this->db->select('*')
            ->from('cli_cliente')
            ->join('sec_sector_cliente', 'sec_id = cli_id_sec', 'LEFT');

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_sucursal_vendedor($where = null, $campos = '*')
    {
        $query = $this->db->select($campos)
            ->from('suc_sucursal')
            ->join('emp_empleado', 'emp_id_suc = suc_id', 'INNER');

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Nelson Soriano
     * @since  02-08-2019
     * @return Obtien los datos del cliente
     */

    public function get_clientes_info($where = null)
    {
        $query = $this->db->select('*,
                    (
                     SELECT concat(emp_nombre," ",emp_apellido) FROM emp_empleado
                        where  emp_id_usu = cli_usu_crea 
                    )AS creadox,
                    (
                        CASE 
                            WHEN cli_personeria = 1  THEN concat(cli_nombre, " ",cli_apellido)
                            ELSE cli_apellido
                        END
                    )AS nombre,
                    (
                        concat(ven_nombre," ",ven_apellidos)
                    )AS vendedor,
                    (
                        GROUP_CONCAT(DISTINCT tlp_nombre SEPARATOR ", ")
                    ) AS lista
                ', false)
            ->from('cli_cliente')
            ->join('sec_sector_cliente', 'sec_id = cli_id_sec', 'LEFT')
            ->join('tpc_tipo_cliente', 'tpc_id = cli_id_tpc', 'LEFT')
            ->join('tpg_tipo_pago', 'tpg_id = cli_id_tpg', 'left')
            ->join('mun_municipio', 'cli_id_mun = mun_id', 'left')
            ->join('con_contacto', 'con_id_cli= cli_id', 'left')
            ->join('scl_sucursal_cliente', 'scl_id_cli= cli_id', 'left')
            ->join('tpn_tipo_precio_cliente', 'tpn_id_cli= cli_id', 'left')
            ->join('tlp_tipo_lista_precio', 'tpn_id_tlp= tlp_id', 'INNER')
            ->join('txc_telefonoxcliente', 'txc_id_cli = cli_id', 'LEFT')
            ->join('gir_giro', 'cli_id_gir = gir_id', 'LEFT')
            ->join('dcc_documento_cliente', 'dcc_id_cli = cli_id', 'LEFT')
            ->join('tde_tipo_documento', 'tde_id = dcc_id_tde', 'LEFT')
            ->join('ven_vendedor', 'ven_id = cli_id_ven', 'LEFT');

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Raul E.
     * @return preguntar por las metas de un vendedor
     */
    public function get_metasXvendedor($id_vendedor, $fecha1, $fecha2)
    {
        $fecha1 = formatear_fecha('Y-m-d', $fecha1);
        $fecha2 = formatear_fecha('Y-m-d', $fecha2);
        $this->db->select()
            ->from("mtv_meta_vendedor")
            ->where("mtv_id_ven", $id_vendedor)
            ->where("mtv_estado", 1)
            ->where("mtv_periodo BETWEEN '$fecha1' AND '$fecha2'");
        return $this->db->get()->result_array();
    }

    public function get_costo_mpa($articulo, $where = NULL)
    {
        $this->db->select("SUM((CASE WHEN mpa_tipo_precio = 2 THEN (IFNULL((SELECT dxd_precio_unitario FROM dpv_documento_proveedor JOIN dxd_detalle_documento_proveedor ON dxd_id_dpv = dpv_id 
            WHERE dxd_id_art = mpa_id_art_materia ORDER BY dpv_fecha_documento, dpv_id DESC LIMIT 1), 0)) WHEN mpa_tipo_precio = 3 THEN (IFNULL((SELECT (((SELECT 
            IFNULL(SUM(axm_cantidad * axm_precio), 0) FROM axm_articulo_matxarticulo_ord WHERE axm_id_axo = axo_id) + (SELECT IFNULL(SUM(mxo_cantidad * mxo_precio), 0) 
            FROM mxo_mano_obraxarticulo_ord WHERE mxo_id_axo = axo_id) + (SELECT IFNULL(SUM(exr_monto_calculo), 0) FROM exr_estimacionxarticulo WHERE exr_id_axo = axo_id)) / axo_cantidad)
            AS costo FROM axo_articuloxorden WHERE axo_id_art = mpa_id_art_materia ORDER BY axo_id DESC LIMIT 1), 0)) WHEN mpa_tipo_precio = 4 THEN (IFNULL(mpa_precio,0)) 
            ELSE (SELECT IFNULL((SUM(sar_cant_actual * sar_precio) / SUM(sar_cant_actual)),0) FROM sar_saldo_articulo WHERE sar_id_art = mpa_id_art_materia) END) * mpa_cantidad) AS costo", false)
            ->from('mpa_materia_prima_articulo')
            ->where('mpa_id_art', $articulo);
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->row_array();
    }

    public function get_cliente($where = null)
    {
        $this->db->select("*,(SELECT GROUP_CONCAT(txc_numero) FROM txc_telefonoxcliente WHERE txc_id_cli = cli_id) as telefono,
        (SELECT GROUP_CONCAT(CONCAT(tde_nombre,': ',dcc_valor)) FROM dcc_documento_cliente left join tde_tipo_documento on dcc_id_tde = tde_id WHERE dcc_id_cli = cli_id) as documentos,
        (SELECT GROUP_CONCAT(tlp_nombre) FROM tpn_tipo_precio_cliente left join tlp_tipo_lista_precio on tpn_id_tlp = tlp_id WHERE tpn_id_cli = cli_id) as tipo_precio", false)
            ->from('cli_cliente')
            ->join('pai_pais', 'cli_id_pai = pai_id', 'LEFT')
            ->join('mun_municipio', 'cli_id_mun = mun_id', 'LEFT')
            ->join('dep_departamento', 'mun_id_dep = dep_id', 'LEFT')
            ->join('users', 'cli_usu_crea = id', 'LEFT');
        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_info_usuario($where = null)
    {
        $q = $this->db->select()
            ->from('users')
            ->join('emp_empleado', 'usu_id_emp=emp_id', 'left');
        if ($where) {
            $this->db->where($where);
        }
        return $q->get()->result_array();
    }

    public function get_seguimiento_cotizaciones()
    {
        $query = $this->db->select('cli_apellido as nombre, cot_concepto as concepto, seg_lugar as lugar, seg_fecha_proximo as fecha_proximo, seg_id as id_mus_seg, seg_id_cot as id_cab, seg_estado as estado, "CT" as seguimiento', false)
            ->from('seg_seguimiento')
            ->join('cot_cotizacion', 'seg_id_cot = cot_id')
            ->join('cli_cliente', 'cot_id_cli = cli_id')
            ->order_by("cot_ult_fecha_cont");

        $result = $query->get()->row();
        $query_ct = $this->db->last_query();

        $query = $this->db->select('drn_nombre as nombre, sgd_comentario as concepto, sgd_lugar as lugar, sgd_fecha_proximo as fecha_proximo, sgd_id as id_mus_seg, drn_id as id_cab, sgd_estado as estado, if(drn_personeria = 1, "BD1", "BD2") as seguimiento', false)
            ->from('drn_directorio_contacto')
            ->join('cli_cliente', 'drn_id_cli = cli_id', 'left')
            ->join('sgd_seguimiento_directorio', 'sgd_id_drn = drn_id')
            ->order_by("sgd_fecha_proximo");

        $result = $query->get()->row();
        $query_bd = $this->db->last_query();

        $query = $this->db->select('cli_apellido as nombre, sec_comentario as concepto, sec_lugar as lugar, sec_fecha_proximo as fecha_proximo, sec_id as id_mus_seg, cli_id as id_cab, sec_estado as estado, "CL" as seguimiento', false)
            ->from('sec_seguimiento_cliente')
            ->join('con_contacto', 'sec_id_con = con_id', 'left')
            ->join('cli_cliente', 'con_id_cli = cli_id')
            ->order_by("sec_fecha_proximo");

        $result = $query->get()->row();
        $query_cl = $this->db->last_query();

        $query_final = "(" . $query_ct . ") union (" . $query_bd . ") union (" . $query_cl . ")";
        $resultado = $this->db->query($query_final);

        return $resultado->result_array();
    }

    public function get_etapas_cotizacion($where = null, $order_by = null, $group_by = null) {

        $query = $this->db->select()
                ->from('etc_etapa_cotizacion')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    public function get_data_cotizaciones($where = null, $order_by = null, $group_by = null) {
        $query = $this->db->select("*, IFNULL( (SELECT anx_url FROM axe_anexoxempleado JOIN anx_anexo ON anx_id = axe_id_anx 
                WHERE axe_id_emp = emp_id AND anx_imagen = 1 ORDER BY anx_id DESC LIMIT 1), '') AS foto_vendedor", false)
                ->from('cot_cotizacion')
                ->join('cli_cliente','cli_id = cot_id_cli')
			    ->join('ven_vendedor','ven_id = cot_id_ven')
                ->join('users','id = ven_id_usu')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
			    ->join('est_estado_cotizacion','est_id = cot_id_est')
                ->join('pcl_proyecto_cliente','pcl_id = cot_id_pcl', 'left')
                ->join('cog_cotiz_ganada', 'cog_id_cot = cot_id', 'left')
                ->join('per_perdido', 'per_id_cot = cot_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }
} // End model
