<?php

/**
 * @author Francisco Orozco
 * @method Modelo - Modulo Contratos
 */
Class Contratos_Model extends CI_Model {

    function __construct() {
        $this->load->database();
    }

    /**
     * @author Mario Marquez  
     * @method Regresa el listado de clientes por posibles coincidencias
     * @property array $where 'Array de filtros a usar'
     * @property array $like 'Concidencias con el nombre'
     */
    public function get_cliente_servicio($where = null, $like = null) {
        $query = $this->db->select("*, cli_id as cliente, CONCAT(IFNULL(cli_nombre,''), ' ', IFNULL(cli_apellido,'')) as cliente_nombre", false)
                ->from('cli_cliente')
                ->join('sxc_servicioxcliente', 'sxc_id_cli = cli_id', 'left')
                ->join('art_articulo', 'art_id= sxc_id_art', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->like($like);
        }

        return $query->get()->result_array();
    }

    public function get_planes_promocion_cliente_servicio($where = null) {
        $query = $this->db->select()
                ->from('pxl_plan_promoxcliente')
                ->join('pln_plan_promocion', 'pln_id = pxl_id_pln', 'inner')
                ->join('sxc_servicioxcliente', 'sxc_id = pxl_id_sxc', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_cargos_cliente_servicio($where = null) {
        $this->db->select('sxc_id, cli_id, sxc_fecha_contrato, caf_valor, caf_fecha, tcs_id, caf_id, tcs_nombre, caf_estado')
                ->from('caf_cargo_facturacion')
                ->join('tcs_tipo_cargo_servicio', 'tcs_id = caf_id_tcs')
                ->join('sxc_servicioxcliente', 'caf_id_sxc = sxc_id')
                ->join('cli_cliente', 'cli_id = sxc_id_cli')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        $result = $this->db->get()->result_array();
        return $result;
    }

    /*
     * Se obtienen los planes por cliente y servicio, para usarlos en el procesado de facturas
     */

    public function get_planes_fijos($where = null, $fecha_inicio = null, $fecha_fin = null) {
        $query = $this->db->select('sxc_id, cli_id, art_id, art_nombre, pxl_id, pxl_fecha_inicio, 
                      pxl_fecha_fin, pln_id, pln_tipo, pln_nombre, pln_costo, pln_desde, pln_hasta');
        $this->db->from('sxc_servicioxcliente')
                ->join('cli_cliente', 'cli_id = sxc_id_cli ')
                ->join('art_articulo', 'sxc_id_art = art_id ')
                ->join('pxl_plan_promoxcliente', 'sxc_id = pxl_id_sxc ')
                ->join('pln_plan_promocion', 'pxl_id_pln = pln_id ')
        ;

        if ($where != null) {
            $this->db->where($where, null, false);
        }

        $this->db->where(" pxl_id in (SELECT  pxl_id FROM pxl_plan_promoxcliente 
                                 WHERE (pxl_fecha_inicio BETWEEN '" . $fecha_inicio . "' AND '" . $fecha_fin . "')
                                 OR (pxl_fecha_fin BETWEEN '" . $fecha_inicio . "' AND '" . $fecha_fin . "') 
                                 OR (DATE(pxl_fecha_inicio) <=  '" . $fecha_inicio . "' 
                                 AND DATE(pxl_fecha_fin) >=  '" . $fecha_fin . "'))", null, false);
        return $query->get()->result_array();
    }

    public function get_reporte_contratos($where = null, $order_by = null) {
        $query = $this->db->select("*,
            (SELECT max(fac_fecha_fact) from fac_factura WHERE fac_id_cli = cli_id) ultima_factura
            ", false)
                ->from('cli_cliente')
                ->join('sxc_servicioxcliente', 'sxc_id_cli = cli_id', 'inner')
                ->join('art_articulo', 'art_id= sxc_id_art', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 23/10/2017 
        *Descripción: verifica si los planes/promociónes estan duplicados.
    */
    public function verificar_plan_duplicado($where = null, $where2 = null){
        $query = $this->db->select()
            ->from('pxl_plan_promoxcliente')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($where2 != null) {
            $this->db->where($where2);
        }

        return $query->get()->result_array();
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 06/11/2017 
        *Descripción: obtener clientes.
    */
    public function get_clientes_servicios($where = null, $like=null){
        $query = $this->db->select()
            ->from('cli_cliente')
            ->join('sxc_servicioxcliente','sxc_id_cli = cli_id','left')
            ->join('dcc_documento_cliente','dcc_id_cli = cli_id','left')
            ->join('tde_tipo_documento','tde_id = dcc_id_tde','left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->like("CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido)",$like);
        }
        $this->db->group_by('cli_id');
        $this->db->order_by('cli_id','asc');
        return $query->get()->result_array();
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 09/11/2017 
        *Descripción: obtener la existencia de correlativos.
    */
    public function get_existencia_correlativos($where = null){
        $query = $this->db->select( "*, (SELECT IFNULL(max(fac_numero), 0) 
                                        FROM fac_factura 
                                        WHERE fac_numero BETWEEN (cxj_inicio AND cxj_fin) AND fac_id_cof = cof_id) AS cantidad",false )
            ->from('uxc_usuarioxcaja')
            ->join('caj_caja','caj_id = uxc_id_caj')
            ->join('cxj_correlativoxcaja','cxj_id_caj = caj_id')
            ->join('cof_correlativo_factura','cof_id = cxj_id_cof')
            ->join('sef_serie_factura','sef_id = cof_id_sef')
            ->join('tif_tipo_factura','tif_id = sef_id_tif')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 10/11/2017 
        *Descripción: obtener los servicios por clientes que se le crearan factura.
    */
    public function get_cliente_facturar($where = null, $fecha_inicio = null, $fecha_fin = null, $where_extra = null, $where_extra2 = null){
        $query = $this->db->select("*,
            (
                SELECT
                    GROUP_CONCAT(
                        DISTINCT CONCAT_WS('#', imp_id, imp_porcentaje)
                    )
                FROM
                    imp_impuesto
                WHERE
                    (
                        imp_id IN (
                            SELECT
                                ixr_id_imp
                            FROM
                                ixr_impuestox_tipo_articulo
                            WHERE
                                ixr_id_tia = art_id_tia
                        )
                        OR imp_id IN (
                            SELECT
                                ixc_id_imp
                            FROM
                                ixc_impuestoxcliente
                            WHERE
                                ixc_id_cli = cli_id
                            AND ixc_aplica = 1
                        )
                    )
                AND imp_id NOT IN (
                    SELECT
                        ixc_id_imp
                    FROM
                        ixc_impuestoxcliente
                    WHERE
                        ixc_id_cli = cli_id
                    AND ixc_aplica = 0
                )
            ) impuestos",FALSE)
            ->from('sxc_servicioxcliente')
            ->join('cli_cliente', 'cli_id = sxc_id_cli')
            ->join('art_articulo', 'sxc_id_art = art_id ')           
            ->join('tif_tipo_factura', 'tif_id = cli_id_tif')
            ->join('pxl_plan_promoxcliente', 'sxc_id = pxl_id_sxc')
            ->join('pln_plan_promocion', 'pxl_id_pln = pln_id')
        ;
  
        if ($where != null) {
            $this->db->where($where, null, false);
        }
       
        $this->db->where("pxl_id in (SELECT  pxl_id FROM pxl_plan_promoxcliente 
                WHERE (pxl_fecha_inicio BETWEEN '" . $fecha_inicio . "' AND '" . $fecha_fin . "')
                OR ( IFNULL(pxl_fecha_fin, '".$fecha_inicio."' ) BETWEEN '" . $fecha_inicio . "' AND '" . $fecha_fin . "') 
                OR (pxl_fecha_inicio <=  '" . $fecha_inicio . "' AND  IFNULL(pxl_fecha_fin, '".$fecha_inicio."' ) >=  '" . $fecha_fin . "')) ", null, false)
        ;

        if ($where_extra != null) {
            $this->db->where($where_extra, null, false);
        }

        if ($where_extra2 != null) {
            $this->db->where($where_extra2, null, false);
        }

        $this->db->group_by('sxc_id_cli');
        $this->db->order_by('cli_codigo','asc');
        return $query->get()->result_array();
    }
    
    /**
        *@author: Francisco Orozco
        *Fecha: 14/11/2017 
        *Descripción: obbtener servicios, impuestos, cargos adicionales y meses a cobrar por servicio.
    */
    public function get_serviciosxclientes($where = null, $fecha_inicio = null, $fecha_fin = null){
        $query = $this->db->select("sxc_id, pxl_id, art_nombre, art_id, art_id_tia, pxl_fecha_inicio,pxl_costo,cva_id,
            IF (
                pxl_fecha_inicio > '".$fecha_inicio."',
                pxl_fecha_inicio , '".$fecha_inicio."'
            ) AS fecha_inicial,
            pxl_fecha_fin,    
            IF (
                IFNULL(pxl_fecha_fin, '".$fecha_fin."') <= '".$fecha_fin."',
                '".$fecha_fin."',
                pxl_fecha_fin
            ) AS fecha_final,
            (
                TIMESTAMPDIFF(
                MONTH,    
            IF (
                pxl_fecha_inicio > '".$fecha_inicio."',
                pxl_fecha_inicio , '".$fecha_inicio."'
            ),
            IF (
                IFNULL(pxl_fecha_fin, '".$fecha_fin."') >= '".$fecha_fin."',
                '".$fecha_fin."',
                pxl_fecha_fin
            )
            ) + 1) AS meses_facturar,
            (
                SELECT
                GROUP_CONCAT(
                    CONCAT_WS(
                        '#',
                        imp_id,
                        imp_porcentaje
                    )
                )
                FROM ixr_impuestox_tipo_articulo
                JOIN imp_impuesto ON imp_id = ixr_id_imp
                WHERE ixr_id_tia = tia_id
            ) impuestos_cat,
            (
            SELECT
                CONCAT(GROUP_CONCAT(
                    CONCAT_WS(
                        '#',
                        tcs_nombre,
                        caf_monto_cuota,
                        caf_id,
                        art_id_tia,
                        (
                            SELECT
                                count(ixr_id)
                            FROM
                                ixr_impuestox_tipo_articulo
                            WHERE
                                ixr_id_tia = tia_id
                        ),
                        caf_numero_cuota,
                        (caf_numero_cuota - IFNULL(caf_cuota_pagadas,0)),
                        art_id,
                        art_nombre,
                        cva_id
                    )
                )
            )
            FROM
            caf_cargo_facturacion
            JOIN tcs_tipo_cargo_servicio ON tcs_id = caf_id_tcs
            JOIN art_articulo ON art_id = tcs_id_art
            JOIN tia_tipo_articulo ON tia_id = art_id_tia
            JOIN cva_conversion_articulo ON cva_id_art = art_id
            WHERE
            cva_defecto = 1
            AND caf_id_sxc = sxc_id 
            AND caf_estado = 1
            AND caf_numero_cuota > IFNULL(caf_cuota_pagadas, 0)
            ) AS cargo_adicional ",FALSE)
            ->from("sxc_servicioxcliente")
            ->join('art_articulo', 'art_id = sxc_id_art')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
            ->join('pxl_plan_promoxcliente', 'pxl_id_sxc = sxc_id')
            ->join('cva_conversion_articulo','cva_id_art  = art_id')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->where(" ((pxl_fecha_inicio BETWEEN '".$fecha_inicio."' AND '".$fecha_fin."')
            OR ( IFNULL(pxl_fecha_fin, '".$fecha_inicio."' ) BETWEEN '".$fecha_inicio."' AND '".$fecha_inicio."') 
            OR (pxl_fecha_inicio <= '".$fecha_inicio."' AND IFNULL(pxl_fecha_fin, '".$fecha_inicio."' ) >= '".$fecha_inicio."'))", null, false)
        ;

        return $query->get()->result_array();
            
    }

    function get_facturas_info($correlativo_inicial = 0, $correlativo_final =0, $factura_inicial = 0,$factura_final=0){
        $this->db->select("*,(SELECT GROUP_CONCAT(CONCAT_WS('#',def_cantidad,def_descripcion,def_precio, (def_cantidad * def_subtotal) ))
                        FROM def_detalle_fact
                        WHERE def_id_fac = fac_id) AS detalles",false)
        ->from('fac_factura')
        ->join('cli_cliente', 'cli_id = fac_id_cli')
        ->join('ven_vendedor', 'ven_id = fac_id_ven', 'left')
        ->join('gir_giro', 'gir_id = cli_id_gir', 'left')
        ;
        $this->db->where("fac_numero BETWEEN ".$correlativo_inicial." and ".$correlativo_final, NULL, false );
        $this->db->where("fac_id BETWEEN ".$factura_inicial." and ".$factura_final, NULL, false );
        $this->db->order_by('fac_id','asc');
        return $this->db->get()->result_array();
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 29/11/2017 
        *Descripción: obtener reporte de facturas.
    */
    function get_factura_masivas($where = null, $group_by = true){
        $this->db->select("*,
                (
                    SELECT
                    GROUP_CONCAT(art_nombre)
                    FROM
                    def_detalle_fact
                    INNER JOIN art_articulo ON art_id = def_id_art
                    WHERE
                    def_id_fac = fac_id
                ) AS Servicios")
            ->from('fac_factura')
            ->join('cli_cliente','cli_id = fac_id_cli')
            ->join('def_detalle_fact', 'def_id_fac = fac_id')
            ->join('art_articulo', 'art_id = def_id_art')
            ->join('tif_tipo_factura', 'tif_id = fac_id_tif')
            ->join('pln_plan_promocion', 'pln_id = pln_id_art', 'left')
            ->join('ven_vendedor', 'ven_id = fac_id_ven','left')
            ->join('tpg_tipo_pago', 'tpg_id = fac_id_tpg','left')
            ->join('cfc_clasificacion_cliente','cfc_id = cli_id_cfc','left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($group_by == true) {
            $this->db->group_by('fac_id');
        }
        $this->db->order_by('fac_id',"asc");
       
        return $this->db->get()->result_array();
    }


    /**
        *@author: Francisco Orozco
        *Fecha: 29/11/2017 
        *Descripción: obtener clientes con mora para el sobre de cuotas.
    */
    public function get_sobre_cuotas($where = null, $fecha_desde = null, $fecha_hasta = null, $limit = "", $offset ="" ){
        $this->db->select("cli_id, cli_codigo, cli_direccion, tpc_nombre, 
            (SELECT cuota.fac_total FROM fac_factura AS cuota WHERE cuota.fac_generacion_masiva = 1 AND cuota.fac_estado != 0 AND cuota.fac_id_cli = cli_id 
                ORDER BY cuota.fac_fecha_crea DESC LIMIT 1) AS CUOTA, 
            IF (cli_personeria = 1, CONCAT(cli_nombre, ' ', cli_apellido), cli_apellido) AS cliente,
            (SELECT IFNULL(SUM(masiva_f.fac_monto_pendiente), 0) FROM fac_factura AS masiva_f WHERE masiva_f.fac_id_cli = cli_id
                AND (DATE(masiva_f.fac_fecha_pagada) <= '$fecha_hasta' OR masiva_f.fac_fecha_pagada IS NULL)
                AND DATE(masiva_f.fac_fecha_fact) <= LAST_DAY(DATE_ADD('$fecha_hasta', INTERVAL 1 MONTH))
                AND DATE(masiva_f.fac_fecha_fact) >= DATE_ADD(LAST_DAY('$fecha_hasta'), INTERVAL 1 DAY) AND masiva_f.fac_generacion_masiva = 1
                AND (DATE(masiva_f.fac_fecha_anulacion) > '$fecha_hasta' OR masiva_f.fac_fecha_anulacion IS NULL)) AS 'cuota_mensual',
            (SELECT IFNULL(SUM(consumo_f.fac_monto_pendiente), 0) FROM fac_factura AS consumo_f WHERE DATE(consumo_f.fac_fecha_fact) >= '$fecha_desde'
                AND DATE(consumo_f.fac_fecha_fact) <= '$fecha_hasta' AND consumo_f.fac_id_cli = cli_id
                AND (consumo_f.fac_generacion_masiva IS NULL OR consumo_f.fac_generacion_masiva = 0)
                AND (DATE(consumo_f.fac_fecha_pagada) <= '$fecha_hasta' OR consumo_f.fac_fecha_pagada IS NULL)
                AND (DATE(consumo_f.fac_fecha_anulacion) > '$fecha_hasta' OR consumo_f.fac_fecha_anulacion IS NULL)) AS 'vale_consumo',
            (SELECT IFNULL(SUM(deuda_f.fac_total), 0) FROM fac_factura AS deuda_f WHERE DATE(deuda_f.fac_fecha_fact) < '$fecha_desde'
                AND (DATE(deuda_f.fac_fecha_pagada) < '$fecha_desde' OR deuda_f.fac_fecha_pagada IS NULL) AND deuda_f.fac_id_cli = cli_id) AS 'saldo_pendiente',
            (SELECT IFNULL(SUM(abonos_abf.abf_monto), 0) FROM abf_abono_factura AS abonos_abf INNER JOIN abc_abono_cliente AS abono_abc ON abono_abc.abc_id = abonos_abf.abf_id_abc
                INNER JOIN fac_factura AS abonos_fac ON abonos_fac.fac_id = abonos_abf.abf_id_fac WHERE abono_abc.abc_estado = 1 AND DATE(abono_abc.abc_fecha) < '$fecha_hasta' 
                AND DATE(abonos_fac.fac_fecha_fact) < '$fecha_desde' AND (DATE(abonos_fac.fac_fecha_pagada) < '$fecha_desde' OR abonos_fac.fac_fecha_pagada IS NULL)
		        AND abonos_fac.fac_id_cli = cli_id) AS 'abonos_de_saldos_pendientes',
            (SELECT SUM(masiva_f.fac_monto_pendiente) FROM fac_factura AS masiva_f WHERE masiva_f.fac_id_cli = cli_id AND masiva_f.fac_generacion_masiva = 1
                AND masiva_f.fac_estado = 1 AND (DATE(masiva_f.fac_fecha_pagada) < '$fecha_hasta' OR masiva_f.fac_fecha_pagada IS NULL)
                AND masiva_f.fac_fecha_fact >= '$fecha_desde' AND masiva_f.fac_fecha_fact <= '$fecha_hasta'
                AND (masiva_f.fac_fecha_anulacion < '$fecha_hasta' OR masiva_f.fac_fecha_anulacion IS NULL)) AS 'masivas_mes',
            (SELECT COUNT(r.fac_id) FROM fac_factura AS r WHERE r.fac_id_cli = cli_id AND r.fac_generacion_masiva = 1 AND r.fac_estado = 1
                AND DATE(r.fac_fecha_fact) <= '$fecha_hasta' ) AS 'r',
            (SELECT abc.abc_fecha FROM abf_abono_factura AS abf JOIN abc_abono_cliente AS abc ON abc.abc_id = abf.abf_id_abc JOIN fac_factura AS fac ON fac.fac_id = abf.abf_id_fac
                WHERE abc.abc_estado = 1 AND DATE(fac.fac_fecha_fact) <= '$fecha_hasta' AND fac.fac_estado > 0 AND (DATE(fac.fac_fecha_pagada) <= '$fecha_hasta' OR fac.fac_fecha_pagada IS NULL) 
                AND fac.fac_id_cli = cli_id ORDER BY abc.abc_fecha DESC LIMIT 1) AS 'ultimo_abono'", false)
        ->from('cli_cliente')
        ->join('fac_factura', 'fac_id_cli = cli_id')
        ->join('tpc_tipo_cliente','tpc_id = cli_id_tpc','left')
        ;
        
        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('cli_id');
        $this->db->having('(cuota_mensual > 0 OR vale_consumo > 0)', false);
        $this->db->order_by('ABS (cli_codigo)','ASC',false);     

        if ($limit != "" AND $offset != "") {
            $this->db->limit($limit,$offset);
        } else if ($limit != "" ) {
            $this->db->limit($limit);
        }

        return $this->db->get()->result_array();
    }

    /**
        * @author Francsico Orozco
        * @since 2018-03-02
        * @return clientes
        * @param $where array asociativo para condicionar.
        * @param $like string para condicionar.
    */
    public function get_clientes_like($where=null,$like=null,$evaluar_plan=false){
        $query = $this->db->select("*,CONCAT(cli_nombre, ' ', cli_apellido) as 'nombre'",false)
                ->from('cli_cliente');

        if ($evaluar_plan == true) {
            $this->db->join("sxc_servicioxcliente","sxc_id_cli = cli_id")
            ->join("pxl_plan_promoxcliente","pxl_id_sxc = sxc_id");
        }
          
        if ($like != null) {
              $this->db->or_like("CONCAT(cli_nombre, ' ', cli_apellido)", $like);
        }

        if ($like != null) {
            $this->db->or_like("cli_codigo", $like);
        }

        if ($where != null) {
              $this->db->where($where);
        }
        
        $this->db->group_by('cli_id');
        $this->db->limit(100);
        return $query->get()->result_array();
    }

    /**
    * @author René Castaneda
    * @since 2019-03-14
    * @return Filtrar Reporte Servicios
    */
    public function get_servicios_inactivos($where = null) {
        $query = $this->db->select("*", false)
                ->from('cli_cliente')
                ->join('sxc_servicioxcliente', 'sxc_id_cli = cli_id', 'inner')
                ->join('art_articulo', 'art_id= sxc_id_art', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

}
