<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Contabilidad_model extends CI_Model
{

    function __construct()
    {
        $this->load->database();
    }

    public function listado_partida($where = null, $group = null)
    {

        if ($group != null) {
            $this->db->select('cnt_id, cnt_cuenta, cnt_nombre,cnt_aumenta, dpc_concepto, SUM(dpc_debe) as debe, SUM(dpc_haber) as haber,pct_id, pct_total, pct_fecha, pct_concepto, pct_codigo, tpd_nombre, dpc_concepto');
        } else {
            $this->db->select('cnt_id, cnt_cuenta, cnt_nombre,cnt_aumenta, dpc_concepto, dpc_debe, dpc_haber, dpc_debe debe, dpc_haber haber,pct_id, pct_total, pct_fecha, pct_concepto, pct_codigo, tpd_nombre, dpc_concepto');
        }
        $this->db->from('cnt_cuenta_contable')
            ->join('dpc_detalle_partida', 'dpc_id_cnt=cnt_id')
            ->join('pct_partida_contable', 'dpc_id_pct=pct_id')
            ->join('tpd_tipo_partida', 'tpd_id=pct_id_tpd', 'left');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($group != null) {
            $this->db->group_by('cnt_cuenta');
        }
        $this->db->order_by('pct_fecha', 'asc');
        $this->db->order_by('dpc_debe', 'desc');
        $this->db->order_by('cnt_cuenta', 'desc');

        $result = $this->db->get()->result_array();
        //print_r($this->db->last_query()); die();
        foreach ($result as &$mov) {
            $mov['codigo_dependiente'] = " ";

            $query_dependientes = $this->db->select('pct_id, '
                . 'CASE WHEN tra_id IS NOT NULL THEN CONCAT(" - Comprobante # ",tra_comprobante ) '
                . 'WHEN che_id IS NOT NULL THEN CONCAT(" - Cheque #",che_numero )'
                . 'END AS codigo_dependiente', FALSE)
                ->from('pct_partida_contable')
                ->join('tra_transaccion', 'tra_id_pct = pct_id', 'left')
                ->join('che_cheque', 'che_id_pct = pct_id', 'left')
                ->where(array('pct_id' => $mov['pct_id']));

            $resultado_dependientes = $query_dependientes->get()->result_array();

            $mov['codigo_dependiente'] = $resultado_dependientes[0]['codigo_dependiente'];
        }


        return $result;
    }

    public function listado_balance_comprobacion($fecha_inicio, $fecha_fn, $cuenta = null, $centro_costo = null)
    {
        // CASE 
        // 	WHEN cnt_aumenta='D' THEN SUM(dpc_debe)-SUM(dpc_haber)		
        // 	WHEN cnt_aumenta='H' THEN SUM(dpc_haber)-SUM(dpc_debe)	
        // END AS
        // Antes la dpc_detalle_partida y pct_partida_contable tenia left join
        $where_centro = ($centro_costo != null) ? ' and pcc_id_cec = ' . $centro_costo . ' ' : '';
        $where = ($cuenta != null) ? ' where cnt_id = ' . $cuenta . ' ' : '';
        $query = "	SELECT cnt_id,cnt_cuenta,cnt_nombre,cnt_aumenta,SUM(saldo_ant) AS oldSaldo, debe, haber,SUM(saldo) AS newSaldo,cnt_id, cnt_id_cnt_padre
					FROM (
					SELECT  cnt_cuenta,cnt_nombre,cnt_aumenta,0 saldo_ant,SUM(dpc_debe) AS debe,SUM(dpc_haber) AS haber,
							(SUM(dpc_debe)-SUM(dpc_haber) ) AS saldo, cnt_id, cnt_id_cnt_padre
						FROM cnt_cuenta_contable 
							INNER JOIN dpc_detalle_partida ON cnt_id = dpc_id_cnt
							INNER JOIN pct_partida_contable ON pct_id = dpc_id_pct
                            LEFT JOIN pcc_partida_centro_costo ON pcc_id = dpc_id_pcc
								AND (DATE(pct_fecha) between '" . $fecha_inicio . "' AND '" . $fecha_fn . "')
                                $where_centro
						GROUP BY cnt_cuenta,cnt_nombre,cnt_aumenta
					
						)  REPO " . $where .
            "GROUP BY cnt_cuenta,cnt_nombre,cnt_aumenta
						ORDER BY cnt_cuenta ASC
						";

        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function listado_balance_comprobacion_detalle($fecha_inicio, $fecha_fn)
    {
        $query = "	SELECT 
					cnt_id,cnt_cuenta,cnt_nombre,cnt_aumenta, SUM(dpc_debe)-SUM(dpc_haber) as saldo_ant, SUM(dpc_debe) AS debe,SUM(dpc_haber) as haber,0 as saldo, cnt_id_cnt_padre, cnt_id_nic, dpc_id_cnt, pct_id, dpc_id_pct
					FROM cnt_cuenta_contable
						LEFT  JOIN dpc_detalle_partida  on cnt_id=dpc_id_cnt
						LEFT  JOIN pct_partida_contable on pct_id=dpc_id_pct
					WHERE dpc_id IS NULL AND cnt_id_nic BETWEEN 2 AND 3 AND pct_fecha between '" . $fecha_inicio . "' AND '" . $fecha_fn . "'
					GROUP BY cnt_cuenta,cnt_nombre,cnt_aumenta 
					UNION  
					SELECT cnt_id,cnt_cuenta,cnt_nombre,cnt_aumenta, SUM(dpc_debe)-SUM(dpc_haber) as saldo_ant, SUM(dpc_debe) AS debe,SUM(dpc_haber) as haber,0 as saldo, cnt_id_cnt_padre, cnt_id_nic, dpc_id_cnt, pct_id,dpc_id_pct
					FROM cnt_cuenta_contable
						INNER  JOIN dpc_detalle_partida  on cnt_id=dpc_id_cnt
						INNER  JOIN pct_partida_contable on pct_id=dpc_id_pct
					WHERE cnt_id_nic BETWEEN 2 AND 3 AND pct_fecha between '" . $fecha_inicio . "' AND '" . $fecha_fn . "'
					GROUP BY cnt_cuenta,cnt_nombre,cnt_aumenta";

        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function libro_mayor($fecha_inicio, $fecha_fn, $where = null)
    {
        $this->db->select('cnt_id,cnt_cuenta,cnt_nombre,cnt_aumenta, SUM(dpc_debe)-SUM(dpc_haber) as saldo_ant, SUM(dpc_debe) AS debe,SUM(dpc_haber) as haber, cnt_id_cnt_padre, cnt_id_nic, dpc_id_cnt, pct_id, dpc_id_pct')
            ->from('cnt_cuenta_contable')
            ->join('dpc_detalle_partida', 'cnt_id = dpc_id_cnt', 'left')
            ->join('pct_partida_contable', 'pct_id = dpc_id_pct', 'left')
            ->join('pcc_partida_centro_costo', 'pcc_id = dpc_id_pcc', 'left')
            /* 		 ->where('cnt_id_nic',3)
                  ->where('pct_fecha >=',$fecha_inicio);
                  $this->db->where('pct_fecha <=',$fecha_fn) */
            ->group_by('cnt_id')
            // ->group_by('cnt_nombre,cnt_aumenta')
            ->order_by('cnt_id_cnt_padre, cnt_cuenta', 'ASC')
            // ->order_by('cnt_cuenta','ASC')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    public function movimientos_CN3($fecha_inicio, $fecha_fn)
    {
        $this->db->select('dpc_concepto,dpc_debe,dpc_haber, pct_fecha, dpc_id_cnt,cnt_cuenta,cnt_aumenta')
            ->from('dpc_detalle_partida')
            ->join('pct_partida_contable', 'dpc_id_pct=pct_id')
            ->join('cnt_cuenta_contable', 'cnt_id=dpc_id_cnt')
            ->where('pct_fecha >=', $fecha_inicio);
        $this->db->where('pct_fecha <=', $fecha_fn)
            ->where('`dpc_id_cnt` IN (SELECT `cnt_id` FROM `cnt_cuenta_contable` WHERE `cnt_id_nic` = 3 )', NULL, FALSE)
            ->order_by('dpc_id_cnt,pct_fecha,dpc_concepto');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function movimientos_diarios($fecha_inicio, $fecha_fn)
    {
        $this->db->select('dpc_id_cnt,cnt_cuenta,tpd_nombre,SUM(dpc_debe) AS debe, SUM(dpc_haber) AS haber, dpc_concepto,pct_fecha')
            ->from('dpc_detalle_partida')
            ->join('pct_partida_contable', 'dpc_id_pct=pct_id')
            ->join('cnt_cuenta_contable', 'cnt_id=dpc_id_cnt')
            ->join('tpd_tipo_partida', 'tpd_id=pct_id_tpd')
            ->where('pct_fecha >=', $fecha_inicio);
        $this->db->where('pct_fecha <=', $fecha_fn)
            ->where('`dpc_id_cnt` IN (SELECT `cnt_id` FROM `cnt_cuenta_contable` WHERE `cnt_id_nic` = 3 )', NULL, FALSE)
            ->group_by('pct_fecha, tpd_nombre, cnt_cuenta, dpc_concepto')
            ->order_by('pct_fecha, cnt_cuenta');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function mov_diarios_cuentas($fecha_inicio, $fecha_fn, $where = null)
    {
        $this->db->select('dpc_id_cnt,cnt_cuenta,tpd_nombre,SUM(dpc_debe) AS debe, SUM(dpc_haber) AS haber, pct_fecha, nic_numero, cnt_nombre, cnt_id_cnt_padre, cnt_id, cnt_id_cnt_padre, pct_codigo, pct_concepto, dpc_concepto')
            ->from('cnt_cuenta_contable')
            ->join('dpc_detalle_partida', 'cnt_id=dpc_id_cnt', 'left')
            ->join('nic_nivel_cuenta', 'nic_id=cnt_id_nic', 'left')
            ->join('pct_partida_contable', 'pct_id=dpc_id_pct', 'left')
            ->join('tpd_tipo_partida', 'tpd_id=pct_id_tpd', 'left')
            ->join('pcc_partida_centro_costo', 'pcc_id = dpc_id_pcc', 'left')
            ->where('DATE(pct_fecha) >=', $fecha_inicio);
        $this->db->where('DATE(pct_fecha) <=', $fecha_fn)
            ->group_by('cnt_nombre,pct_fecha,cnt_aumenta, dpc_concepto')
            ->order_by('cnt_cuenta, pct_fecha');

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get();
        return $query->result_array();
    }

    public function todas_cuentas($where = null)
    {
        $this->db->select('*')
            ->from('cnt_cuenta_contable')
            ->join('nic_nivel_cuenta', 'nic_id = cnt_id_nic')
            ->order_by('cnt_cuenta');

        if ($where != null) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function cuentas_nivel_3()
    {
        $this->db->select('*')
            ->from('cnt_cuenta_contable')
            // ->join('nic_nivel_cuenta', 'nic_id=cnt_id_nic', left)
            // ->where('nic_numero',3)
            ->order_by('cnt_cuenta');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function cuentas_lib_aux_mayor()
    {
        $this->db->select('*')
            ->from('cnt_cuenta_contable')
            ->join('nic_nivel_cuenta', 'nic_id=cnt_id_nic', left)
            //	 ->where('nic_numero')
            ->order_by('cnt_cuenta');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function cuentas_balance_general()
    {
        $query = "SELECT *from cnt_cuenta_contable 
            LEFT JOIN nic_nivel_cuenta ON cnt_id_nic = nic_id
            where substring(cnt_cuenta,1,1) in 
            (SELECT cnt_cuenta FROM cxf_cuentaxconfiguracion
            INNER JOIN cnt_cuenta_contable ON cnt_id = cxf_id_cnt
            INNER JOIN cfr_configuracion_reporte ON cfr_id = cxf_id_cfr
            INNER JOIN rep_reporte_contable ON rep_id = cfr_id_rep
            INNER JOIN nic_nivel_cuenta ON nic_id = cnt_id_nic
            WHERE cfr_id_rep = 1 ) ORDER BY cnt_cuenta";

        //        $query = "SELECT *from cnt_cuenta_contable
        //            LEFT JOIN nic_nivel_cuenta ON cnt_id_nic = nic_id
        //            where substring(cnt_cuenta,1,1) in
        //            (select cnt_cuenta   from  drp_detalle_reporte
        //            inner join cnt_cuenta_contable on cnt_id=drp_id_cnt
        //            where drp_id_rep = 1 ) ORDER BY cnt_cuenta";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function cuentas_balance_general_individual()
    {
        $query = "SELECT * FROM cnt_cuenta_contable
            LEFT JOIN nic_nivel_cuenta ON cnt_id_nic = nic_id
            WHERE
            substring(cnt_cuenta, 1, 1) IN (
            SELECT cnt_cuenta FROM cxf_cuentaxconfiguracion
            INNER JOIN cnt_cuenta_contable ON cnt_id = cxf_id_cnt
            INNER JOIN cfr_configuracion_reporte ON cfr_id = cxf_id_cfr
            INNER JOIN rep_reporte_contable ON rep_id = cfr_id_rep
            INNER JOIN nic_nivel_cuenta ON nic_id = cnt_id_nic
            WHERE cfr_id_rep = 2 ) ORDER BY cnt_id_nic";

        //        $query = "SELECT * FROM cnt_cuenta_contable
        //            LEFT JOIN nic_nivel_cuenta ON cnt_id_nic = nic_id
        //            WHERE
        //            substring(cnt_cuenta, 1, 1) IN (
        //            SELECT cnt_cuenta FROM drp_detalle_reporte
        //            INNER JOIN cnt_cuenta_contable ON cnt_id = drp_id_cnt
        //            JOIN rep_reporte_contable ON rep_id = drp_id_rep
        //            JOIN nic_nivel_cuenta ON nic_id = cnt_id_nic
        //            WHERE drp_id_rep = 2 ) ORDER BY cnt_id_nic";
        $result = $this->db->query($query);
        return $result->result_array();
    }

    public function get_saldo_anterior($where = null, $array = false, $agrupar = true)
    {
        $this->db->select('SUM(dpc_debe) as Debe, SUM(dpc_haber) as Haber', false)
            ->from('cnt_cuenta_contable')
            ->join('dpc_detalle_partida', 'dpc_id_cnt = cnt_id')
            ->join('pct_partida_contable', 'dpc_id_pct = pct_id')
            ->join('pcc_partida_centro_costo', 'pcc_id = dpc_id_pcc');
        if ($where != null && $where != '') {
            $this->db->where($where, null, false);
        }

        if ($agrupar) {
            $this->db->group_by('pct_id');
        }

        if (!$array) {
            $result = $this->db->get()->row();
        } else {
            $result = $this->db->get()->row_array();
        }

        return $result;
    }

    public function datos_facturas($fecha)
    {
        $this->db->select('fac_fecha_cont, fac_numero, fac_tipo, tif_nombre, cli_codigo, cli_nombre, cli_apellido, fac_total')
            ->from('fac_factura')
            ->join('cli_cliente', 'cli_id = fac_id_cli')
            ->join('tif_tipo_factura', 'fac_id_tif = tif_id', 'left')
            ->where('fac_fecha_cont', $fecha);
        //	 ->where('fac_fecha_fact = "'.$fecha.'"'.' OR fac_fecha_cont = "'.$fecha.'"');

        $result = $this->db->get();
        return $result->result_array();
    }

    function datos_factura($fecha)
    {
        $this->db->select('cnt_cuenta, cli_nombre, cli_apellido, cli_id, fac_id, fac_total, def_precio, def_id, def_id_fac, cnt_id')
            ->from('cnt_cuenta_contable')
            ->join('cxn_cuentaxcliente', 'cxn_id_cnt = cnt_id')
            ->join('cli_cliente', 'cli_id = cxn_id_cli')
            ->join('fac_factura', 'fac_id_cli = cli_id')
            ->join('def_detalle_fact', 'def_id_fac = fac_id')
            ->where('fac_fecha_cont', $fecha)
            ->group_by('fac_id');

        $result = $this->db->get();
        return $result->result_array();
    }

    function sumar_factura($fecha)
    {
        $this->db->select('cnt_cuenta, cli_nombre, cli_apellido, cli_id, cnt_id, fac_id, fac_total, def_precio, def_id, def_id_fac, def_id_fac')
            ->from('cnt_cuenta_contable')
            ->join('cxn_cuentaxcliente', 'cxn_id_cnt = cnt_id')
            ->join('cli_cliente', 'cli_id = cxn_id_cli')
            ->join('fac_factura', 'fac_id_cli = cli_id')
            ->join('def_detalle_fact', 'def_id_fac = fac_id')
            ->where('fac_fecha_cont', $fecha);

        $result = $this->db->get();
        return $result->result_array();
    }

    function datos_impuestos_factura($fecha)
    {
        $this->db->select('imp_nombre, def_id, imp_porcentaje, imp_id, cnt_cuenta, ixf_monto, def_id_fac, def_precio, fac_id, cnt_id,SUM(ixf_monto) AS impuestos')
            ->from('def_detalle_fact')
            ->join('fac_factura', 'fac_id = def_id_fac')
            ->join('ixf_impuestoxfactura', 'ixf_id_def = def_id')
            ->join('imp_impuesto', 'imp_id = ixf_id_imp')
            ->join('cxe_cuentaximpuesto', 'cxe_id_imp = imp_id', 'left')
            ->join('cnt_cuenta_contable', 'cxe_id_cnt = cnt_id', 'left')
            ->join('art_articulo', 'art_id = def_id_art')
            ->where('fac_fecha_cont', $fecha)
            ->group_by('fac_id, imp_id');

        $result = $this->db->get();
        return $result->result_array();
    }

    function sumar_impuestos_factura($fecha)
    {
        $this->db->select('imp_nombre, def_id, imp_porcentaje, imp_id, ci.cnt_cuenta AS cuenta_impuesto, ci.cnt_id AS id_cuenta_impuesto,cc.cnt_cuenta AS cuenta_categoria, cc.cnt_id AS id_cuenta_categoria, ixf_monto, def_id_fac, def_precio, fac_id,  art_id, art_nombre, (def_precio * def_cantidad) as sub_total,def_cantidad, def_precio, ((def_precio * def_cantidad) * (imp_porcentaje/100)) AS total_imp')
            ->from('def_detalle_fact')
            ->join('fac_factura', 'fac_id = def_id_fac')
            ->join('ixf_impuestoxfactura', 'ixf_id_def = def_id', 'left')
            ->join('imp_impuesto', 'imp_id = ixf_id_imp', 'left')
            ->join('cxe_cuentaximpuesto', 'cxe_id_imp = imp_id', 'left')
            ->join('cnt_cuenta_contable AS ci', 'cxe_id_cnt = cnt_id', 'left')
            ->join('art_articulo', 'art_id = def_id_art')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
            ->join('cxa_cuentaxtipo_articulo', 'cxa_id_tia = tia_id')
            ->join('cnt_cuenta_contable AS cc', 'cc.cnt_id = cxa_id_cnt')
            ->where('fac_fecha_cont', $fecha);
        $this->db->where('cxe_tipo', 2);
        $this->db->group_by('def_id_fac, imp_id, def_id')
            ->order_by('fac_id');

        $result = $this->db->get();
        return $result->result_array();
    }

    function sumar_impuestos_factura_new($fecha)
    {
        $this->db->select('imp_nombre, def_id, imp_porcentaje, imp_id, cnt_cuenta, ixf_monto, def_id_fac, def_precio, fac_id, cnt_id, art_id, art_nombre')
            ->from('def_detalle_fact')
            ->join('fac_factura', 'fac_id = def_id_fac')
            ->join('ixf_impuestoxfactura', 'ixf_id_def = def_id', 'left')
            ->join('imp_impuesto', 'imp_id = ixf_id_imp', 'left')
            ->join('cxe_cuentaximpuesto', 'cxe_id_imp = imp_id', 'left')
            ->join('cnt_cuenta_contable', 'cxe_id_cnt = cnt_id', 'left')
            ->join('art_articulo', 'art_id = def_id_art')
            ->where('fac_fecha_cont', $fecha);
        $this->db->where('cxe_tipo', 2);

        $result = $this->db->get();
        return $result->result_array();
    }

    function cuenta_cxr()
    {
        $this->db->select('*')
            ->from('cnt_cuenta_contable')
            ->join('cxr_cuentaxarticulo', 'cxr_id_cnt = cnt_id');
        $result = $this->db->get();
        return $result->result_array();
    }

    function datos_inventario_entrada($fecha, $tipo)
    {
        $this->db->select('bod_nombre, art_codigo, art_nombre, dee_cantidad, dee_precio')
            ->from('dee_detalle_mov')
            ->join('moi_movimiento_inv', 'moi_id = dee_id_moi')
            ->join('bod_bodega', 'bod_id = moi_id_bod')
            ->join('art_articulo', 'art_id = dee_id_art ')
            ->join('tip_tipo_proceso', 'moi_id_tip = tip_id')
            ->where('DATE(moi_fecha_mov) >= ', $fecha . ' 00:00:00');
        $this->db->where('DATE(moi_fecha_mov) <= ', $fecha . ' 23:59:59');

        $result = $this->db->get();
        return $result->result_array();
    }

    function datos_inventario_entrada_unicos($fecha, $tipo)
    {
        $this->db->select('cnt_id, cnt_cuenta, art_id, art_nombre, dee_id, moi_id, cxa_tipo, bod_nombre')
            ->from('dee_detalle_mov')
            ->join('moi_movimiento_inv', 'moi_id = dee_id_moi')
            ->join('art_articulo', 'art_id = dee_id_art ')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
            ->join('cxa_cuentaxtipo_articulo', 'cxa_id_tia = tia_id')
            ->join('cnt_cuenta_contable', 'cnt_id = cxa_id_cnt')
            ->join('tip_tipo_proceso', 'moi_id_tip = tip_id')
            ->join('bod_bodega', 'bod_id=moi_id_bod')
            ->where('moi_fecha_mov >=', $fecha . ' 00:00:00');
        $this->db->where('moi_fecha_mov <=', $fecha . ' 23:59:59');
        $this->db->group_by('moi_id');
        $result = $this->db->get();
        return $result->result_array();
    }

    function datos_inventario_entrada_repetidos($fecha, $tipo)
    {
        $this->db->select('cnt_id, cnt_cuenta, art_id, art_nombre, dee_id, moi_id, (dee_cantidad * dee_precio) AS total, cxa_tipo')
            ->from('dee_detalle_mov')
            ->join('moi_movimiento_inv', 'moi_id = dee_id_moi')
            ->join('art_articulo', 'art_id = dee_id_art ')
            ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
            ->join('cxa_cuentaxtipo_articulo', 'cxa_id_tia = tia_id')
            ->join('cnt_cuenta_contable', 'cnt_id = cxa_id_cnt')
            ->where('moi_fecha_mov >=', $fecha . ' 00:00:00');
        $this->db->where('moi_fecha_mov <=', $fecha . ' 23:59:59');
        $this->db->group_by('dee_id, cxa_tipo');
        $result = $this->db->get();
        return $result->result_array();
    }

    //El parametro $agrupar determina si se agrupa o no
    function get_tipo_planilla($agrupar = false)
    {
        $this->db->select('tpl_id, pla_id, tpl_nombre, pla_fecha_inicio, pla_fecha_fin', false)
            ->from('pla_planilla')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl')
            ->where('pla_id_pct IS NULL', null);
        if ($agrupar) {
            $this->db->group_by('tpl_id');
        }
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_datos_planilla($pla_id)
    {
        $this->db->select('CONCAT( emp_nombre , SPACE( 1 ) , emp_apellido ) AS nombre, emp_salario, 
							dss_valor,
							tdc_nombre, cnt_descuento.cnt_id as descuento_cnt_id, 
							cnt_descuento.cnt_cuenta as descuento_cnt_cuenta , 
							cnt_descuento.cnt_nombre as descuento_cnt_nombre , 
							tig_nombre, 
							tig_id,cnt_ingreso.cnt_id AS ingreso_cnt_id, 
							cnt_ingreso.cnt_nombre AS ingreso_cnt_nombre, 
							cnt_ingreso.cnt_cuenta AS ingreso_cnt_cuenta, ddi_valor
							')
            ->from('emp_empleado')
            ->join('dss_descuento', 'dss_id_emp = emp_id')
            ->join('tdc_tipo_descuento', 'tdc_id = dss_id_tdc', 'left')
            ->join('cnt_cuenta_contable AS cnt_descuento', 'cnt_descuento.cnt_id = tdc_id_cnt', 'left')
            ->join('tpl_tipo_planilla', 'tpl_id = dss_id_tpl')
            ->join('pla_planilla', 'pla_id_tpl = tpl_id')
            ->join('ddi_detalle_ingreso', 'ddi_id_pla = pla_id')
            ->join('tig_tipo_ingreso', 'tig_id = ddi_id_tig')
            ->join('cnt_cuenta_contable AS cnt_ingreso', 'cnt_ingreso.cnt_id = tig_id_cnt')
            ->where('pla_id', $pla_id)
            ->group_by('emp_id')
            ->order_by('emp_id asc');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_ingresos($id_pla)
    {
        $this->db->select('ddi_valor AS valor , emp_id, tig_id, cnt_id, cnt_nombre, cnt_cuenta, tig_nombre')
            ->from('ddi_detalle_ingreso')
            ->join('emp_empleado', 'emp_id = ddi_id_emp')
            ->join('tig_tipo_ingreso', 'tig_id = ddi_id_tig')
            ->join('dti_detalle_tipo_ingreso', 'dti_id_tig = tig_id') // Tabla de Detalle
            ->join('cnt_cuenta_contable', 'cnt_id = dti_id_cnt') // Nueva Relacion
            ->where('ddi_id_emp = emp_empleado.emp_id');
        $this->db->where('ddi_id_pla', $id_pla);
        $this->db->where('ddi_id_tig NOT IN(13)');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_descuentos($id_pla)
    {
        $this->db->select('ddd_valor AS valor, emp_id, tdc_id, cnt_id, cnt_nombre, cnt_cuenta, tdc_nombre')
            ->from('ddd_detalle_descuento')
            ->join('emp_empleado', 'emp_id = ddd_id_emp')
            ->join('tdc_tipo_descuento', 'tdc_id = ddd_id_tdc')
            ->join('cnt_cuenta_contable', 'cnt_id = tdc_id_cnt') // Error
            ->where('ddd_id_emp = emp_empleado.emp_id');
        $this->db->where('ddd_id_pla', $id_pla);
        $result = $this->db->get();
        return $result->result_array();
    }

    public function acc_rtceo_ptda($desde = null, $hasta = null)
    {
        $ans = array();
        $this->db->select('pct_id, rtd_id')->from('rtd_retaceo_documento_proveedor')->join('dpv_documento_proveedor', 'dpv_id = rtd_id_dpv')
            ->join('moi_movimiento_inv', 'moi_id_dpv = dpv_id AND moi_id_prv = dpv_id_prv')->join('pct_partida_contable', 'pct_id = moi_id_pct')
            ->where(array('rtd_estado' => 1, 'dpv_estado' => 1, 'moi_estado' => 1, 'pct_estado' => 1));
        if ($desde) {
            $this->db->where('DATE(pct_fecha) >= ', $desde);
        }
        if ($hasta) {
            $this->db->where('DATE(pct_fecha) <= ', $hasta);
        }
        $datos = $this->db->get()->result_array();
        foreach ($datos as $key => $value) {
            $ans[$value['pct_id']] = $value['rtd_id'];
        }
        return $ans;
    }

    function get_datos_partida($desde, $hasta, $proceso_partida = 0)
    {
        $this->db->select('*, (SELECT prc_estado FROM prc_periodo_contable WHERE prc_id = pct_id_prc) AS prc_estado, 
            (SELECT IFNULL(prc_reactivado, 0) FROM prc_periodo_contable WHERE prc_id  = pct_id_prc) AS prc_reactivado', false)
            ->from('pct_partida_contable')
            ->where('DATE_FORMAT(pct_fecha,"%Y-%m-%d") >= ', $desde);
        $this->db->where('DATE_FORMAT(pct_fecha,"%Y-%m-%d") <= ', $hasta);
        if ($proceso_partida > 0) {

            /*  
            1 - Facturación
            2 - Abono Factura
            3 - Anticipos
            4 - Doc. Proveedor
            5 - Planilla
            6 - Inventario
            7 - Caja Chica
            8 - Contabilidad
            9-12 - Bancos
            */

            switch ($proceso_partida) {
                case '1':
                    $this->db->join('fac_factura', 'fac_id_pct = pct_id OR fac_id_pct_anulacion = pct_id');
                    break;
                case '2':
                    $this->db->join('abc_abono_cliente', 'abc_id_pct = pct_id');
                    break;
                case '3':
                    $this->db->join('anl_anticipo_cliente', 'anl_id_pct = pct_id');
                    break;
                case '4':
                    $this->db->join('dpv_documento_proveedor', 'dpv_id_pct = pct_id');
                    break;
                case '5':
                    $this->db->join('pla_planilla', 'pla_id_pct = pct_id');
                    break;
                case '6':
                    $this->db->join('moi_movimiento_inv', 'moi_id_pct = pct_id');
                    break;
                case '7':
                    $this->db->join('cjc_cierre_caja_chica', 'cjc_id_pct = pct_id');
                    break;
                case '8':
                    $this->db->where("
                    pct_id NOT IN ( SELECT che_id_pct FROM che_cheque WHERE che_id_pct IS NOT NULL )
                    AND pct_id NOT IN ( SELECT nta_id_pct FROM nta_nota_abono WHERE nta_id_pct IS NOT NULL )
                    AND pct_id NOT IN ( SELECT ofp_id_pct FROM ofp_otra_forma_pago WHERE ofp_id_pct IS NOT NULL )
                    AND pct_id NOT IN ( SELECT tra_id_pct FROM tra_transaccion WHERE tra_id_pct IS NOT NULL )
                    AND pct_id NOT IN ( SELECT fac_id_pct FROM fac_factura WHERE fac_id_pct IS NOT NULL)
                    AND pct_id NOT IN ( SELECT fac_id_pct_anulacion FROM fac_factura WHERE fac_id_pct_anulacion IS NOT NULL)
                    AND pct_id NOT IN ( SELECT abc_id_pct FROM abc_abono_cliente WHERE abc_id_pct IS NOT NULL)
                    AND pct_id NOT IN ( SELECT anl_id_pct FROM anl_anticipo_cliente WHERE anl_id_pct IS NOT NULL)
                    AND pct_id NOT IN ( SELECT dpv_id_pct FROM dpv_documento_proveedor WHERE dpv_id_pct IS NOT NULL)
                    AND pct_id NOT IN ( SELECT pla_id_pct FROM pla_planilla WHERE pla_id_pct IS NOT NULL)
                    AND pct_id NOT IN ( SELECT moi_id_pct FROM moi_movimiento_inv WHERE moi_id_pct IS NOT NULL)
                    AND pct_id NOT IN ( SELECT cjc_id_pct FROM cjc_cierre_caja_chica WHERE cjc_id_pct IS NOT NULL)
                    ", null, false);
                    break;
                    /*                case '9':
                    $this->db->where("
                         pct_id IN ( 
                         SELECT che_id_pct FROM che_cheque WHERE che_id_pct IS NOT NULL 
                         UNION  SELECT nta_id_pct FROM nta_nota_abono WHERE nta_id_pct IS NOT NULL 
                         UNION  SELECT ofp_id_pct FROM ofp_otra_forma_pago WHERE ofp_id_pct IS NOT NULL 
                         UNION  SELECT tra_id_pct FROM tra_transaccion WHERE tra_id_pct IS NOT NULL 
                        )
                        ",null, false);
                    break;*/
                case '9': //cheque
                    $this->db->join('che_cheque', 'che_id_pct = pct_id');
                    break;
                case '10': //nota abono
                    $this->db->join('nta_nota_abono', 'nta_id_pct = pct_id');
                    break;
                case '11': //transacciones
                    $this->db->join('tra_transaccion', 'tra_id_pct = pct_id');
                    break;
                case '12': //Otras forma de pago
                    $this->db->join('ofp_otra_forma_pago', 'ofp_id_pct = pct_id');
                    break;
                default:
                    # code...
                    break;
            }
        }
        $this->db->order_by('pct_codigo', 'asc');
        $this->db->group_by('pct_id');

        $result = $this->db->get();
        return $result->result_array();
    }

    function get_detalle_partida($id_pct)
    {
        $this->db->select('*')
            ->from('pct_partida_contable')
            ->join('dpc_detalle_partida', 'dpc_id_pct = pct_id')
            ->join('cnt_cuenta_contable', 'cnt_id = dpc_id_cnt')
            ->join('tpd_tipo_partida', 'tpd_id = pct_id_tpd', 'left')
            ->join('pcc_partida_centro_costo', 'pcc_id = dpc_id_pcc', 'left')
            ->join('cec_centro_costo', 'cec_id = pcc_id_cec', 'left')
            ->where('pct_id', $id_pct);
        $result = $this->db->get();
        return $result->result_array();
    }

    function eliminar_periodos($anio)
    {
        $this->db->select('*')
            ->from('prc_periodo_contable')
            ->join('pct_partida_contable', 'pct_id_prc = prc_id')
            ->where('prc_ano', $anio);
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_cuentas_padre()
    {
        $this->db->select('padre.cnt_id, padre.cnt_cuenta, padre.cnt_nombre')
            ->from('cnt_cuenta_contable padre')
            ->join('cnt_cuenta_contable hijo', 'padre.cnt_id=hijo.cnt_id_cnt_padre')
            ->group_by('padre.cnt_id');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_sub_cuentas($cuenta)
    {
        $this->db->select('COUNT(DISTINCT cnt_cuenta) AS cantidad')
            ->from('cnt_cuenta_contable ')
            ->join('dpc_detalle_partida', 'dpc_id_cnt=cnt_id', 'left')
            ->where('cnt_cuenta like ', $cuenta . '%')
            ->group_by('cnt_id_cnt_padre');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_cuentas_totales($cuenta)
    {
        $this->db->select('SUM(dpc_debe) as debe, SUM(dpc_haber) as haber')
            ->from('cnt_cuenta_contable ')
            ->join('dpc_detalle_partida', 'dpc_id_cnt=cnt_id')
            ->where('cnt_cuenta like ', $cuenta . '%')
            //->where_in('cnt_id', $cuenta);
        ;
        //->group_by('cnt_id_cnt_padre');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_saldo_antxcnt($cuenta, $fecha_inicio)
    {
        $query = "SELECT cnt_cuenta,cnt_nombre,cnt_aumenta, 
					CASE 
						WHEN cnt_aumenta='D' AND pct_fecha IS NOT NULL THEN SUM(dpc_debe)-SUM(dpc_haber)		
						WHEN cnt_aumenta='H' THEN SUM(dpc_debe)-SUM(dpc_haber)	
					END AS saldo_ant, SUM(dpc_debe) AS debe,SUM(dpc_haber) AS haber,0 AS saldo, cnt_id, pct_fecha
				FROM cnt_cuenta_contable 
					INNER JOIN dpc_detalle_partida ON cnt_id=dpc_id_cnt
					INNER JOIN pct_partida_contable ON pct_id=dpc_id_pct
					AND pct_fecha between '1900-01-01' AND date_sub('" . $fecha_inicio . "', INTERVAL 1 DAY)
				WHERE cnt_cuenta LIKE '" . $cuenta . "%'";
        //WHERE cnt_cuenta LIKE '".$cuenta."%'";

        $result = $this->db->query($query);
        return $result->result_array();
    }

    function get_cuentas_padrexcnt($cnt_id)
    {
        $this->db->select('padre.cnt_id, padre.cnt_cuenta, padre.cnt_nombre, hijo.cnt_id_cnt_padre, hijo.cnt_id as id_hijo, 
			hijo.cnt_nombre as hijo')
            ->from('cnt_cuenta_contable padre')
            ->join('cnt_cuenta_contable hijo', 'padre.cnt_id=hijo.cnt_id_cnt_padre')
            ->where_in('hijo.cnt_id_cnt_padre', $cnt_id)
            ->group_by('hijo.cnt_id');
        $result = $this->db->get();
        return $result->result_array();
    }

    public function movimientos_diarios_libro_diario($fecha_inicio = null, $fecha_fn = null, $where = null)
    {
        $this->db->select('dpc_id_cnt,cnt_cuenta,tpd_nombre,SUM(dpc_debe) AS debe, SUM(dpc_haber) AS haber, dpc_concepto,pct_fecha,pct_codigo,pct_concepto,cnt_aumenta')
            ->from('dpc_detalle_partida')
            ->join('pct_partida_contable', 'dpc_id_pct=pct_id')
            ->join('cnt_cuenta_contable', 'cnt_id=dpc_id_cnt')
            ->join('tpd_tipo_partida', 'tpd_id=pct_id_tpd');
        if ($fecha_inicio != null && $fecha_fn != null) {
            $this->db->where('pct_fecha >=', $fecha_inicio);
            $this->db->where('pct_fecha <=', $fecha_fn);
        }

        if ($where) {
            $this->db->where($where);
        }

        //->where('`dpc_id_cnt` IN (SELECT `cnt_id` FROM `cnt_cuenta_contable` WHERE `cnt_id_nic` = 3 )', NULL, FALSE)
        //->group_by('pct_fecha, tpd_nombre, cnt_cuenta, dpc_concepto')
        $this->db->group_by('pct_id')
            ->order_by('pct_fecha, cnt_cuenta');
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * @author Mario Marquez  
     * @method Regresa el listado de proveedores
     * @property array $where 'Array de filtros a usuar'
     */
    public function calcular_saldo_cuenta($cuenta, $fecha_inicio = null, $fecha_fin = null)
    {
        //Se obtiene el nivel de la cuenta proporcionada
        $this->db->join('nic_nivel_cuenta', 'nic_id = cnt_id_nic', 'left');
        $dato_cuenta = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $cuenta));

        $min_nivel = $this->gsatelite->get_parametro('SYS_NIVEL_INICIAL_CNT');

        $arbol_cuentas = $this->contabilidad_model->get_arbol_cuentas();
        $saldo = 0;
        $rango = 0;
        if (count($dato_cuenta) > 0) {
            $nivel_cuenta = $dato_cuenta[0]['nic_numero'];
            //Se recorre el arbol de cuentas
            foreach ($arbol_cuentas as $row) {
                //Si se llega a la cuenta que se necesita buscar, se activa el conteo
                //Y se suma los movimientos de la propia cuenta
                $nivel = ($min_nivel == 0) ? $row['level'] - 1 : $row['level'];
                if ($row['cnt_id'] == $cuenta && $nivel == $nivel_cuenta) {
                    $rango = 1;

                    $movimientos = $this->listado_balance_comprobacion($fecha_inicio, $fecha_fin, $row['cnt_id']);

                    if (count($movimientos) > 0) {
                        $tipo_cuenta = $movimientos[0]['cnt_cuenta'];

                        $saldo_debe = ($movimientos[0]['debe'] != '') ? $movimientos[0]['debe'] : 0;
                        $saldo_haber = ($movimientos[0]['haber'] != '') ? $movimientos[0]['haber'] : 0;
                        $saldo += ($saldo_debe - $saldo_haber);
                        /* if($tipo_cuenta=="D"){
                          $saldo += ($saldo_debe - $saldo_haber);
                          }
                          else{
                          $saldo += ($saldo_haber - $saldo_debe);
                          } */
                    }
                }
                //Sino se termina el loop
                else if ($row['cnt_id'] != $cuenta && $nivel == $nivel_cuenta) {
                    $rango = 0;
                    break;
                }
                //Si el conteo esta activo se realiza el acumulado del saldo                
                if ($rango == 1 && $nivel > $nivel_cuenta) {
                    $cuenta_ = $row['cnt_id'];

                    $movimientos = $this->listado_balance_comprobacion($fecha_inicio, $fecha_fin, $cuenta_);

                    if (count($movimientos) > 0) {
                        $tipo_cuenta = $movimientos[0]['cnt_cuenta'];

                        $saldo_debe = ($movimientos[0]['debe'] != '') ? $movimientos[0]['debe'] : 0;
                        $saldo_haber = ($movimientos[0]['haber'] != '') ? $movimientos[0]['haber'] : 0;
                        $saldo += ($saldo_debe - $saldo_haber);
                        /* if($tipo_cuenta=="D"){
                          $saldo += ($saldo_debe + $saldo_haber);
                          }
                          else{
                          $saldo += ($saldo_haber + $saldo_debe);
                          } */
                    }
                }
            }
        }

        return $saldo;
    }

    public function get_arbol_cuentas()
    {
        $query = "SELECT cnt_id,cnt_nombre, cnt_id_cnt_padre,nic_numero, level  
            FROM
            (
                SELECT  hierarchy_connect_by_cuenta_contable(cnt_id) AS id, @level AS level, nic_numero
                    FROM
                    (
                        SELECT  @start_with := 0,
                            @id := @start_with,@level := 0
                    )vars, cnt_cuenta_contable
                    INNER JOIN nic_nivel_cuenta ON nic_id = cnt_id_nic
                    WHERE   @id IS NOT NULL
            ) ho
            JOIN cnt_cuenta_contable hi
            ON hi.cnt_id = ho.id";

        $listado = $this->db->query($query)->result_array();

        return $listado;
    }

    public function get_cuentas_reportes($where)
    {
        $query = $this->db->select()
            ->from('cxf_cuentaxconfiguracion')
            ->join('cnt_cuenta_contable', 'cnt_id = cxf_id_cnt', 'inner')
            ->join('cfr_configuracion_reporte', 'cfr_id = cxf_id_cfr', 'inner')
            ->join('nic_nivel_cuenta', 'nic_id = cnt_id_nic', 'inner')
            ->order_by('cnt_cuenta', 'ASC');
        //        $query = $this->db->select()
        //                ->from('drp_detalle_reporte')
        //                ->join('cnt_cuenta_contable', 'cnt_id = drp_id_cnt', 'inner')
        //                ->join('nic_nivel_cuenta', 'nic_id = cnt_id_nic', 'inner')
        //                ->order_by('cnt_cuenta', 'ASC')
        //        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_saldo_cuenta($cuenta, $fecha_ini, $fecha_fin, $solo_cuenta = false, $centro_costo = null, $tpd = "")
    {
        $where_centro = ($centro_costo != null) ? ' AND pcc_id_cec = "' . $centro_costo . '" ' : '';
        $where_tpd = ($tpd != "") ? " AND pct_id_tpd IN (" . $tpd . ") " : '';
        $query = "SELECT 
                    cnt_cuenta,
                    cnt_aumenta,
                    SUM(dpc_debe) AS debe,
                    SUM(dpc_haber) AS haber
                   FROM
                           (`cnt_cuenta_contable`)
                   LEFT JOIN `dpc_detalle_partida` ON `cnt_id` = `dpc_id_cnt`
                   LEFT JOIN `nic_nivel_cuenta` ON `nic_id` = `cnt_id_nic`
                   LEFT JOIN `pct_partida_contable` ON `pct_id` = `dpc_id_pct`
                   LEFT JOIN `tpd_tipo_partida` ON `tpd_id` = `pct_id_tpd`
                   LEFT JOIN pcc_partida_centro_costo ON pcc_id = dpc_id_pcc
                   WHERE DATE(pct_fecha) >= '" . $fecha_ini . "' AND DATE(pct_fecha) <= '" . $fecha_fin . "' " . $where_centro . $where_tpd;
        if ($solo_cuenta) {
            $query .= " AND cnt_cuenta ='" . $cuenta . "' ORDER BY cnt_cuenta, pct_fecha";
        } else {
            $query .= "AND cnt_cuenta  LIKE '" . $cuenta . "%' ORDER BY cnt_cuenta, pct_fecha";
        }

        return $this->db->query($query)->result_array();
    }

    public function verificar_int_partida($where)
    {
        $query = $this->db->select("nta_id AS nota, che_id AS cheque, pla_id AS planilla, moi_id AS movimiento, f.fac_id AS factura, a.fac_id AS anulada, 
            ofp_id AS pagos, anl_id AS anticipo, abc_id AS abono,  dpv_id AS dpv")
            ->from('pct_partida_contable')
            ->join('nta_nota_abono', 'nta_id_pct = pct_id', 'left')
            ->join('che_cheque', 'che_id_pct = pct_id', 'left')
            ->join('pla_planilla', 'pla_id_pct = pct_id', 'left')
            ->join('moi_movimiento_inv', 'moi_id_pct = pct_id', 'left')
            ->join('anl_anticipo_cliente', 'anl_id_pct = pct_id', 'left')
            ->join('abc_abono_cliente', 'abc_id_pct = pct_id', 'left')
            ->join('dpv_documento_proveedor', 'dpv_id_pct = pct_id', 'left')
            ->join('fac_factura AS f', 'f.fac_id_pct = pct_id', 'left')
            ->join('fac_factura AS a', 'a.fac_id_pct_anulacion = pct_id', 'left')
            ->join('ofp_otra_forma_pago', 'ofp_id_pct = pct_id', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function ajax_filtro_cuenta_contable($where)
    {
        $query = "SELECT cnt1.cnt_cuenta AS cuenta, cnt1.cnt_nombre AS nombre, (SELECT cnt2.cnt_cuenta FROM cnt_cuenta_contable as cnt2 WHERE cnt1.cnt_id_cnt_padre = cnt2.cnt_id /*GROUP BY cnt1.cnt_id*/) as dependencia,cnt1.cnt_id_nic as nivel,
                    cnt1.cnt_estado as estado,
                    cnt1.cnt_aumenta as dh
                FROM cnt_cuenta_contable as cnt1 ";

        if ($where != null) {
            $query .= 'WHERE ';
            foreach ($where as $key => $w) {
                if ($key == 0) {
                    $query .= $w;
                } else {
                    $query .= ' AND ' . $w;
                }
            }
        }

        $query .= ' ORDER BY cuenta';
        //$query .= ' ORDER BY cnt1.cnt_id_cnt_padre , cnt1.cnt_id ASC';
        //print_r($query); die();
        return $this->db->query($query)->result_array();
    }
    /*
	 * @author Marlon Olmedo  - Grupo Satelite
	 * fehca: 15/5/19
	 * descripcion: se agrego un select con un alias 'otrosimpuestos' donde suma los impuestos enviados en id_imp_exe_internas
*/
    public function get_libros_compras($where1, $where2, $order_by = null, $where3)
    {
        $nota_credito = $this->gsatelite->get_parametro('SYS_ID_TIPO_FACTURA_NOTA_CREDITO');
        $paises_importacion = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_PAIS_IMPORTACION'));
        $nrc_importacion = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('NRC_IMPORTACION'));
        $prv_importacion = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('PRV_IMPORTACION'));
        $paises_importacion = (trim($paises_importacion) != "") ? $paises_importacion : 0;
        $nrc_importacion = (trim($nrc_importacion) != "") ? $nrc_importacion : '0';
        $prv_importacion = (trim($prv_importacion) != "") ? $prv_importacion : '0';

        // $nombre = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('NRC_IMPORTACION'));
        // var_dump($nrc_importacion);die();

        $query = "
            SELECT
            DATE(dpv1.dpv_fecha_documento) AS fecha_ord, 
            '' AS cqc_id,
            dpv_sello_recepcion AS sello_recepcion,
            dpv_numero_control AS numero_control,
            dpv_codigo_generacion AS codigo_generacion,
            prv1.prv_id,
            dpv1.dpv_id,
            dpv1.dpv_id_tif,
            dpv1.dpv_retencion retencion_documento,
            DATE_FORMAT(dpv1.dpv_fecha_documento, '%Y%m%d') AS fecha_ordenar,
            DATE_FORMAT(dpv1.dpv_fecha_documento, '%d-%m-%Y' ) AS fecha_doc,
            CONCAT(tif_abreviacion,'-',dpv_numero_documento) AS doc,
            dpv1.dpv_serie_documento AS serie,
            IF(prv1.prv_id_pai IN ($paises_importacion),
                IF($nrc_importacion = '0',
                    (SELECT dcp_valor FROM dcp_documento_proveedor JOIN tde_tipo_documento ON dcp_id_tde = tde_id 
                        WHERE dcp_id_prv = prv1.prv_id AND tde_id = " . $where2['id_nrc'] . " LIMIT 1
                    ),
                    $nrc_importacion
                ),
                (SELECT dcp_valor FROM dcp_documento_proveedor JOIN tde_tipo_documento ON dcp_id_tde = tde_id
                    WHERE dcp_id_prv = prv1.prv_id AND tde_id = " . $where2['id_nrc'] . " LIMIT 1
                )
            ) AS NRC,
            (
                SELECT  GROUP_CONCAT(dcp_valor)
                FROM    dcp_documento_proveedor
                JOIN    tde_tipo_documento ON dcp_id_tde = tde_id
                WHERE   dcp_id_prv = prv1.prv_id
                AND     (tde_id = " . $where2['id_dui'] . " OR tde_id = " . $where2['id_nit'] . ")
            ) AS nit_cip_dui,
            IF(prv1.prv_id_pai IN ($paises_importacion),
                IF($prv_importacion = '0',
                    IF (prv_tipo_pers = 1, CONCAT(prv_nombre,' ',prv_apellido), prv_apellido),
                    $prv_importacion
                ),
                IF (prv_tipo_pers = 1, CONCAT(prv_nombre,' ',prv_apellido), prv_apellido) 
            ) AS nombre_proveedor,
            (
                SELECT
                IF      (SUM(dxd_total) = 0 OR SUM(dxd_total) IS NULL OR SUM(dxd_total) = '', 0.00, SUM(dxd_total))
                FROM    dpv_documento_proveedor AS dpv2
                JOIN    dxd_detalle_documento_proveedor ON dpv2.dpv_id = dxd_id_dpv
                WHERE   dpv2.dpv_id = dpv1.dpv_id
                AND     dxd_impuesto <= 0 
                AND     (dxd_impuesto IS NULL OR dxd_impuesto = '')
            ) AS total_documento_exenta,
            (
                SELECT  SUM(dxd_total)
                FROM    dpv_documento_proveedor AS dpv2
                JOIN    dxd_detalle_documento_proveedor ON dpv2.dpv_id = dxd_id_dpv
                WHERE   dpv2.dpv_id = dpv1.dpv_id
                AND     (dxd_impuesto > 0 OR (dxd_impuesto < 0 AND dpv2.dpv_id_tif = " . $nota_credito . "))
            ) AS total_documento_gravado,
            (
                SELECT  SUM(dxd_subtotal)
                FROM    dpv_documento_proveedor AS dpv2
                JOIN    dxd_detalle_documento_proveedor ON dpv2.dpv_id = dxd_id_dpv
                WHERE   dpv2.dpv_id = dpv1.dpv_id
                AND     (dxd_impuesto > 0 OR (dxd_impuesto < 0 AND dpv2.dpv_id_tif = " . $nota_credito . "))
            ) AS total_documento_gravado_ex,
            IFNULL(prv1.prv_id_pai, (
                    SELECT  pai_id FROM prv_proveedor AS prv2
                    JOIN    mun_municipio ON prv2.prv_id_mun = mun_id
                    JOIN    dep_departamento ON mun_id_dep = dep_id
                    JOIN    pai_pais ON dep_id_pai = pai_id
                    WHERE   prv2.prv_id = prv1.prv_id
                )
            ) AS id_pais,
            (
                SELECT  round(SUM(dxd_subtotal) * (imp_porcentaje / 100), 4)
                FROM    dpv_documento_proveedor AS dpv2
                JOIN    dxd_detalle_documento_proveedor ON dpv2.dpv_id = dxd_id_dpv
                JOIN    idd_impuestoxdetalle_documento ON dxd_id = idd_id_dxd
                JOIN    imp_impuesto ON idd_id_imp = imp_id                    
                WHERE   dpv2.dpv_id = dpv1.dpv_id
                AND idd_id_imp = " . $where2['id_iva'] . "
            ) AS total_iva,
            ( 
                SELECT  ROUND(SUM(idd_monto),2)
                FROM    dpv_documento_proveedor AS dpv2
                JOIN    dxd_detalle_documento_proveedor ON dpv2.dpv_id = dxd_id_dpv
                JOIN    idd_impuestoxdetalle_documento ON dxd_id = idd_id_dxd
                JOIN    imp_impuesto ON idd_id_imp = imp_id                    
                WHERE   dpv2.dpv_id = dpv1.dpv_id
                AND  idd_id_imp IN (" . $where2['id_imp_exe_internas'] . ")
            ) AS otrosimpuestos,
            IFNULL((
                    SELECT  
                    IF( imp_porcentaje>0,(round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4)), round(SUM(dxd_cantidad * imp_valor), 4))
                    FROM    dpv_documento_proveedor AS dpv2
                    JOIN    dxd_detalle_documento_proveedor ON dpv2.dpv_id = dxd_id_dpv
                    JOIN    idd_impuestoxdetalle_documento ON dxd_id = idd_id_dxd
                    JOIN    imp_impuesto ON idd_id_imp = imp_id
                    WHERE   dpv2.dpv_id = dpv1.dpv_id
                    AND     idd_id_imp != " . $where2['id_iva'] . "
                    ),0
            ) AS total_otros_impuestos,
            (
                SELECT  SUM(dxd_subtotal)
                FROM    dpv_documento_proveedor AS dpv2
                JOIN    dxd_detalle_documento_proveedor ON dpv2.dpv_id = dxd_id_dpv
                WHERE   dpv2.dpv_id = dpv1.dpv_id
            ) AS sub_total,
            (
                SELECT
                IF( round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4) IS NULL OR round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4) = '' 
                OR  round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4) = 0, 0.00, round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4))
                FROM    dpv_documento_proveedor AS dpv2
                JOIN    dxd_detalle_documento_proveedor ON dpv2.dpv_id = dxd_id_dpv
                JOIN    idd_impuestoxdetalle_documento ON dxd_id = idd_id_dxd
                JOIN    imp_impuesto ON idd_id_imp = imp_id
                WHERE   dpv2.dpv_id = dpv1.dpv_id
                AND     dxd_impuesto > 0
                AND     idd_id_imp = " . $where2['id_percep'] . "
            ) AS iva_percep,
            (
                SELECT
                IF( round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4) IS NULL OR round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4) = '' 
                OR  round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4) = 0, 0.00, round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4))
                FROM    dpv_documento_proveedor AS dpv2
                JOIN    dxd_detalle_documento_proveedor ON dpv2.dpv_id = dxd_id_dpv
                JOIN    idd_impuestoxdetalle_documento ON dxd_id = idd_id_dxd
                JOIN    imp_impuesto ON idd_id_imp = imp_id
                WHERE   dpv2.dpv_id = dpv1.dpv_id
                AND     dxd_impuesto > 0
                AND     idd_id_imp = " . $where2['id_cesc'] . "
            ) AS cesc,
            (
                SELECT
                IF( round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4) IS NULL OR round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4) = '' 
                OR  round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4) = 0, 0.00, round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4))
                FROM    dpv_documento_proveedor AS dpv2
                JOIN    dxd_detalle_documento_proveedor ON dpv2.dpv_id = dxd_id_dpv
                JOIN    idd_impuestoxdetalle_documento ON dxd_id = idd_id_dxd
                JOIN    imp_impuesto ON idd_id_imp = imp_id
                WHERE   dpv2.dpv_id = dpv1.dpv_id
             AND dxd_impuesto > 0
             AND idd_id_imp = " . $where2['id_retenc'] . "
            ) AS iva_retenc,
            (
                SELECT
                IF( round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4) IS NULL OR round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4) = '' 
                OR  round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4) = 0, 0.00, round(SUM(dxd_subtotal) * (imp_porcentaje / 100),4))
                FROM    dpv_documento_proveedor AS dpv2
                JOIN    dxd_detalle_documento_proveedor ON dpv2.dpv_id = dxd_id_dpv
                JOIN    idd_impuestoxdetalle_documento ON dxd_id = idd_id_dxd
                JOIN    imp_impuesto ON idd_id_imp = imp_id
                WHERE   dpv2.dpv_id = dpv1.dpv_id
                AND dxd_impuesto > 0
                AND idd_id_imp = " . $where2['id_anticipo_cuenta'] . " 
            ) AS anticipo_cuenta,
            (
                SELECT  SUM(dxd_total)
                FROM    dpv_documento_proveedor AS dpv2
                JOIN    dxd_detalle_documento_proveedor ON dpv2.dpv_id = dxd_id_dpv
                WHERE   dpv2.dpv_id = dpv1.dpv_id 
            ) AS total_compra,
            (
                SELECT  SUM(dxd_total)
                FROM    dpv_documento_proveedor AS dpv2
                JOIN    dxd_detalle_documento_proveedor ON dpv2.dpv_id = dxd_id_dpv
                WHERE   dpv2.dpv_id = dpv1.dpv_id 
            ) AS compra_sujeto_excluido
            FROM    dpv_documento_proveedor AS dpv1
            JOIN    tif_tipo_factura ON dpv_id_tif = tif_id
            JOIN    prv_proveedor AS prv1 ON dpv_id_prv = prv_id
            WHERE   " . $where1 . " 

            UNION

            SELECT 
                DATE(cqc_fecha_documento) AS orden_fecha,
                cqc_id AS cqc_id,
                '' AS dpv_id,
                prv_id,
                NULL AS sello_recepcion,
                NULL AS numero_control,
                NULL AS codigo_generacion,
                cqc_id_tif AS dpv_id_tif,
                cqc_retencion AS retencion_documento,
                DATE_FORMAT(cqc_fecha_documento, '%Y%m%d') AS fecha_ordenar,
                DATE(cqc_fecha_documento) AS fecha_doc, 
                CONCAT(tif_abreviacion,'-',cqc_numero_documento) AS doc,
                '' AS serie,
                IF(prv_id_pai IN ($paises_importacion), 
                    IF($nrc_importacion = '0', 
                        cqc_nrc, 
                        $nrc_importacion
                    ),  
                    cqc_nrc
                ) AS NRC, 
                (
                    SELECT
                        GROUP_CONCAT(dcp_valor)
                    FROM
                        dcp_documento_proveedor
                    JOIN tde_tipo_documento ON dcp_id_tde = tde_id
                    WHERE
                        dcp_id_prv = prv_id
                        AND     (tde_id = " . $where2['id_dui'] . " OR tde_id = " . $where2['id_nit'] . ")
                ) AS nit_cip_dui,
                IF(prv_id_pai IN ($paises_importacion),
                    IF($prv_importacion = '0',
                        IF(prv_tipo_pers = 1, CONCAT( prv_nombre, ' ', prv_apellido ), prv_apellido),
                        $prv_importacion
                    ),
                    IF(prv_tipo_pers = 1, CONCAT( prv_nombre, ' ', prv_apellido ), prv_apellido) 
                ) AS nombre_proveedor, 
                (
                    IF (
                        cqc_impuesto = 0,
                        cqc_total,
                        0.00
                    )
                ) AS total_documento_exenta,
            (

                IF (
                    cqc_impuesto > 0,
                    cqc_total,
                    0.00
                )
            ) AS total_documento_gravado,
            (

                IF (
                    cqc_impuesto > 0,
                    cqc_total,
                    0.00
                )
            ) AS total_documento_gravado_ex,
            IFNULL(prv_id_pai,
                (
                    SELECT
                        pai_id
                    FROM
                        prv_proveedor AS prv2
                    JOIN mun_municipio ON prv2.prv_id_mun = mun_id
                    JOIN dep_departamento ON mun_id_dep = dep_id
                    JOIN pai_pais ON dep_id_pai = pai_id
                    WHERE
                        prv2.prv_id = prv_id
                    LIMIT 1
                )
            ) AS id_pais,
            (
                SELECT
                    SUM(ilc_monto_impuesto)
                FROM
                    ilc_impuesto_liquidacion_comprobante
                WHERE
                    ilc_id_imp = " . $where2['id_iva'] . "
                AND ilc_id_cqc = cqc_id
            ) AS total_iva,
            (
                SELECT
                    IFNULL(SUM(ilc_monto_impuesto), 0)
                FROM
                    ilc_impuesto_liquidacion_comprobante
                WHERE
                    ilc_id_imp IN (" . $where2['id_imp_exe_internas'] . ")
                AND ilc_id_cqc = cqc_id
            ) AS otrosimpuestos,
            (
                SELECT
                    IFNULL(SUM(ilc_monto_impuesto), 0)
                FROM
                    ilc_impuesto_liquidacion_comprobante
                WHERE
                    ilc_id_imp != " . $where2['id_iva'] . "
                AND ilc_id_cqc = cqc_id
            ) AS total_otros_impuestos,
            cqc_monto AS sub_total,
            (
                SELECT
                    SUM(ilc_monto_impuesto)
                FROM
                    ilc_impuesto_liquidacion_comprobante
                WHERE
                    ilc_id_imp = " . $where2['id_percep'] . "
                AND ilc_id_cqc = cqc_id
            ) AS iva_percep,
            (
                SELECT
                    SUM(ilc_monto_impuesto)
                FROM
                    ilc_impuesto_liquidacion_comprobante
                WHERE
                    ilc_id_imp = " . $where2['id_cesc'] . "
                AND ilc_id_cqc = cqc_id
            ) AS cesc,
            (
                SELECT
                    SUM(ilc_monto_impuesto)
                FROM
                    ilc_impuesto_liquidacion_comprobante
                WHERE
                    ilc_id_imp = " . $where2['id_retenc'] . "
                AND ilc_id_cqc = cqc_id
            ) AS iva_retenc,
            (
                SELECT
                    SUM(ilc_monto_impuesto)
                FROM
                    ilc_impuesto_liquidacion_comprobante
                WHERE
                    ilc_id_imp = " . $where2['id_anticipo_cuenta'] . " 
                AND ilc_id_cqc = cqc_id
            ) AS anticipo_cuenta,
                cqc_total as total_compra,
            cqc_total AS compra_sujeto_excluido
            FROM
                cqc_comprobante_liquidacion_caja
            JOIN tif_tipo_factura ON tif_id = cqc_id_tif
            JOIN prv_proveedor ON prv_id = cqc_id_prv
            WHERE   " . $where3 . " 
            ORDER BY fecha_ordenar DESC
        ";
        //ORDER BY fecha_doc DESC
        return $this->db->query($query)->result_array();
    }

    /**
     * Descripción:
     * Función que obtiene los las series a partir de un tipo de factura
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-01-09
     * @param $whwere = Condicion para la consulta
     * @return Devuelve las series de por tipo de factura
     */
    public function ajax_serie_por_factura($where = null, $where_in = null)
    {
        $query = $this->db->select('*')
            ->from('tif_tipo_factura')
            ->join('sef_serie_factura', 'tif_id = sef_id_tif');

        if ($where != null) {
            $this->db->where_in('tif_id', $where_in['idtipofactura']);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_libros_ventasBK($where, $where2)
    {
        //public function get_libros_ventas($where1, $where2) {

        $query = "               
            SELECT
                fac1.fac_id_tif,
                fac1.fac_id,
                fac1.fac_numero,
                fac1.fac_estado,
                cof1.cof_id,
                fac1.fac_fecha_fact,
                fac1.fac_impuesto,
                caj_nombre,
                (
                    SELECT
                        tif_nombre
                    FROM
                        tif_tipo_factura
                    WHERE
                        tif_id = fac1.fac_id_tif
                ) AS tipo_documento,
                cof1.cof_inicio AS del,
                cof1.cof_fin AS al,
                '0.00' AS venta_no_sujeta,
                ((
                    SELECT
                    IF(
                        SUM(fac_total) = 0
                        OR SUM(fac_total) IS NULL
                        OR SUM(fac_total) = '',
                        0.00,
                        SUM(def_subtotal)
                        )
                    FROM
                        fac_factura
                    JOIN def_detalle_fact ON fac_id = def_id_fac
                    WHERE
                        (def_impuesto = 0 OR def_impuesto IS NULL OR def_impuesto = '') AND fac_id_cof = cof1.cof_id AND fac_id = fac1.fac_id
                )) AS total_venta_exenta,
                ((
                 SELECT
                  IF(
                        SUM(fac_total) = 0
                        OR SUM(fac_total) IS NULL
                        OR SUM(fac_total) = '',
                        0.00,
                        SUM(def_subtotal)
                        )       
                 FROM
                    fac_factura
                 JOIN def_detalle_fact ON fac_id = def_id_fac
                 WHERE
                    fac_id_cof = cof1.cof_id
                 AND def_impuesto > 0 AND fac_id = fac1.fac_id
                )) AS total_venta_gravado,
                ((
                    SELECT 
                    IF(SUM(fac_total) IS NULL, 0.00,SUM(fac_total))     
                    FROM fac_factura
                    JOIN tif_tipo_factura ON tif_id = fac_id_tif
                    WHERE 
                            fac_id_cof = cof1.cof_id
                    AND
                            tif_id = " . $where2['id_tif_exportacion'] . "
                    AND fac_id = fac1.fac_id
                )) AS exportacion,
                ((
                SELECT 
                    IF(SUM(def_retencion) IS NULL, '0.00', ROUND(SUM(def_retencion),4) )
                FROM fac_factura
                JOIN def_detalle_fact ON fac_id = def_id_fac
                WHERE fac_id_cof = cof1.cof_id AND fac_id = fac1.fac_id
                )) AS retencion,
                ((
                SELECT 
                    IF(SUM(fac_total) IS NULL, '0.00', ROUND(SUM(fac_total),4) )        
                FROM fac_factura
                JOIN def_detalle_fact ON fac_id = def_id_fac
                WHERE fac_id_cof = cof1.cof_id AND fac_id = fac1.fac_id
                )) AS venta_total
            FROM
                fac_factura AS fac1
            JOIN cof_correlativo_factura AS cof1 ON cof1.cof_id = fac1.fac_id_cof
            INNER JOIN uxc_usuarioxcaja ON uxc_id = fac_id_uxc
            INNER JOIN caj_caja ON caj_id = uxc_id_caj
            WHERE " . $where . "
            ORDER BY fac1.fac_id_tif, cof_id, fac_numero ASC
            -- GROUP BY cof1.cof_id
                
        ";

        return $this->db->query($query)->result_array();
        //return $this->db->last_query();
    }

    public function get_libros_ventas_al_contribuyente($where, $where2){
        $iva_perc = ($this->gsatelite->get_parametro('SYS_ID_IMPUESTO_PERCEPCION') != null) ? $this->gsatelite->get_parametro('SYS_ID_IMPUESTO_PERCEPCION') : 0;
        $tipos_facturas = json_decode(trim($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS')), true);
        $fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
        $consum_final = (count($tipos_facturas) > 0 && isset($tipos_facturas['CONSUMIDOR FINAL'])) ? $tipos_facturas['CONSUMIDOR FINAL'] : '';
        $exportacion = (count($tipos_facturas) > 0 && isset($tipos_facturas['EXPORTACION'])) ? $tipos_facturas['EXPORTACION'] : '';
        $tipos  = (trim($exportacion) != '') ? $exportacion : '';
        $tipos .= (trim($exportacion) != '') ? ',' . $consum_final : $consum_final;
        $types = (trim($tipos) != "") ? trim($tipos) : 0;
        $query = "SELECT fac_id, ";
        $query .= ($fact_elect == 1) ? "fac_codigo_generacion, fac_sello_recepcion, fac_numero_control, " : ""; 
        $query .= "IF(fac_estado = 0, CONCAT('ANULADA - (',IF(cli_personeria = 1, CONCAT(cli_nombre,' ',cli_apellido), cli_apellido),')'), IF ( cli_personeria = 1, CONCAT( cli_nombre, ' ', cli_apellido ), cli_apellido )) AS cli_nombre,
            (SELECT caj_nombre FROM uxc_usuarioxcaja JOIN caj_caja ON caj_id = uxc_id_caj WHERE uxc_id= fac_id_uxc) AS caja_nombre,
            IF(fac_estado = 0, '-', cli_registro) as nrc,
            fac_fecha_fact , fac_referencia_externa,
            fac_numero,                
            (SELECT sef_nombre from sef_serie_factura WHERE sef_id_tif = fac_id_tif ORDER BY sef_fecha_resolucion DESC LIMIT 1) AS serie_fac,
            fac_estado,
            fac_id_tif,
            tif_nombre AS tipo_documento,
            IF(fac_estado = 0, 0, IF((SUM(def_impuesto) = 0 AND fac_id_tif NOT IN ($types)), SUM(def_subtotal), 0)) AS venta_no_sujeta,
            IF(fac_estado = 0, 0, IF((SUM(def_impuesto) = 0 AND fac_id_tif IN ($types)), SUM(def_subtotal), 0)) AS ventas_exentas,
            IF(fac_estado = 0, 0, IF(SUM(def_impuesto) = 0.00,0.00,SUM(def_subtotal))) AS ventas_locales,
            0.00 AS ventas_terceros,
            IF(fac_estado = 0, 0, IF(SUM(def_impuesto) = 0.00, 0.00, (fac_subtotal * (select (par_valor *1)/100 from par_parametro where par_codigo = 'SYS_IVA')))) as debito_fiscal,
            0.00 as debito_fiscal_terceros,
            IF(fac_estado = 0, 0, IFNULL((SELECT ixf_monto FROM ixf_impuestoxfactura WHERE ixf_id_imp = $iva_perc AND ixf_id_def = def_id), 0)) AS iva_percibido,                 
            IF(fac_estado = 0, 0, IF(ISNULL(def_retencion), 0.00, SUM(def_retencion))) AS iva_retenido,
            (SELECT sef_resolucion FROM sef_serie_factura join cof_correlativo_factura on sef_id = cof_id_sef WHERE cof_id = fac_id_cof and sef_id_tif = fac_id_tif LIMIT 1) as num_resolucion
            FROM fac_factura AS fac1
            INNER JOIN def_detalle_fact ON def_id_fac = fac_id
            INNER JOIN cli_cliente ON cli_id = fac_id_cli 
            LEFT JOIN tif_tipo_factura ON tif_id = fac_id_tif
            WHERE " . $where . "  GROUP BY fac_id ";
        return $this->db->query($query)->result_array();
    }

    /**
     * Descripción:
     * Función que obtiene las facturas 
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-02-13
     * @param Ninguno
     * @return Devuelve los productos por factura
     */
    public function obtener_productosxfactura($where = null, $groupby = null, $orderby = null, $def_id = null, $where2 = null){
        $tdc_id_cnt = $where2["dta_id_tcn"];
        $tdc_id_cnt_exenta = $where2["dta_id_tcn_exenta"];

        $cadena = 'fac_id, fac_id_origen_devolucion,
            SUM((SELECT IF(fac_id_origen_devolucion IS NULL, SUM(dcf_monto), SUM(dcf_monto * -1)) FROM dcf_detalle_centrocostoxfactura where dcf_id_def = def_id)) AS subtotal_prod,
            (SELECT IFNULL(cnt_id, 0) AS cnt_id FROM dcf_detalle_centrocostoxfactura AS dcf2 JOIN dta_detalle_tipoarticulo ON dta_id_cec = dcf2.dcf_id_cec
                JOIN cnt_cuenta_contable ON cnt_id = dta_id_cnt
                WHERE dta_id_tcn = IF(IFNULL(IF(fac_id_origen_devolucion IS NULL, def_impuesto,  def_impuesto *-1),0)>0,"' . $tdc_id_cnt . '","' . $tdc_id_cnt_exenta . '")
                AND dcf2.dcf_id_def = def_id AND dta_id_tia = tia_id GROUP BY cnt_id LIMIT 1) AS cuenta_id,
            (SELECT cnt_cuenta FROM dcf_detalle_centrocostoxfactura AS dcf2 JOIN dta_detalle_tipoarticulo ON dta_id_cec = dcf2.dcf_id_cec
                JOIN cnt_cuenta_contable ON cnt_id = dta_id_cnt
                WHERE dta_id_tcn = IF(IFNULL(IF(fac_id_origen_devolucion IS NULL, def_impuesto,  def_impuesto *-1),0)>0,"' . $tdc_id_cnt . '","' . $tdc_id_cnt_exenta . '")
                AND dcf2.dcf_id_def = def_id AND dta_id_tia = tia_id GROUP BY cnt_id LIMIT 1) AS cuenta,
            (SELECT cnt_nombre FROM dcf_detalle_centrocostoxfactura AS dcf2 JOIN dta_detalle_tipoarticulo ON dta_id_cec = dcf2.dcf_id_cec
                JOIN cnt_cuenta_contable ON cnt_id = dta_id_cnt
                WHERE dta_id_tcn = IF(IFNULL(IF(fac_id_origen_devolucion IS NULL, def_impuesto,  def_impuesto *-1) ,0)>0,"' . $tdc_id_cnt . '","' . $tdc_id_cnt_exenta . '")
                AND dcf2.dcf_id_def = def_id AND dta_id_tia = tia_id GROUP BY cnt_id LIMIT 1 ) AS cuenta_nombre,
             def_id AS id_def
            ';

        $query = $this->db->select($cadena, FALSE)
            ->from('def_detalle_fact')
            // ->join('dcf_detalle_centrocostoxfactura AS dcf1', 'dcf1.dcf_id_def = def_id')
            ->join('fac_factura', 'fac_id = def_id_fac')
            ->join('art_articulo', 'def_id_art = art_id')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id')
            //->where('fac_id',115) //descomentar para seguimiento a un id en especifico
            //->limit(50)
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        $datos_query = $query->get()->result_array();
        //echo $this->db->last_query(); echo "===";die();
        return $datos_query;
    }


    public function obtener_productosxfactura_consolidada($where = null, $groupby = null, $orderby = null)
    {
        $query = "
            SELECT  
                fac_id, 
                GROUP_CONCAT(fac_id) AS facturas, 
                tia_id,
                tia_nombre,
                art_nombre,
                cuenta_id,
                cuenta,
                cuenta_nombre,
                ROUND(SUM(a.def_subtotal),2) AS subtotal_prod,
                id_def
            FROM
            (SELECT
                fac_id,  
                tia_id,
                tia_nombre,
                art_nombre,
                (
                    SELECT

                    IF (ISNULL(cnt_id), 0, cnt_id) AS cnt_id
                    FROM
                        dta_detalle_tipoarticulo
                    JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                    WHERE
                        dta_id_tia = tia_id
                    AND dta_id_tcn = 2
                    GROUP BY
                        cnt_id
                    LIMIT 1
                ) AS cuenta_id,
                (
                    SELECT
                        cnt_cuenta
                    FROM
                        dta_detalle_tipoarticulo
                    JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                    WHERE
                        dta_id_tia = tia_id
                    AND dta_id_tcn = 2
                    GROUP BY
                        cnt_id
                    LIMIT 1
                ) AS cuenta,
                (
                    SELECT
                        cnt_nombre
                    FROM
                        dta_detalle_tipoarticulo
                    JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                    WHERE
                        dta_id_tia = tia_id
                    AND dta_id_tcn = 2
                    GROUP BY
                        cnt_id
                    LIMIT 1
                ) AS cuenta_nombre,
                def_subtotal,       
                def_id AS id_def
            FROM
                 def_detalle_fact as def1
            JOIN fac_factura ON fac_id = def1.def_id_fac
            JOIN art_articulo ON def1.def_id_art = art_id
            JOIN tia_tipo_articulo ON art_id_tia = tia_id
            WHERE
                DATE(fac_fecha_cont) = '" . $where['DATE(fac_fecha_cont)'] . "'
            AND `fac_id_pct` IS NULL
            -- -HAVING `fac_id` IS NOT NULL
            GROUP BY fac_id
            )a            
        ";

        $query .= ($groupby) ? "GROUP BY cuenta_id" : "";

        $datos =  $this->db->query($query)->result_array();
        return $datos;
        /*$query = $this->db->select(
            "
            fac_id,
            GROUP_CONCAT(fac_id) as facturas,
            tia_id,
            tia_nombre,
            art_nombre,
            (
            SELECT

            IF (ISNULL(cnt_id), 0, cnt_id) AS cnt_id
            FROM
                dta_detalle_tipoarticulo
            JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
            WHERE
                dta_id_tia = tia_id
            AND dta_id_tcn = 2
            GROUP BY
                cnt_id
            LIMIT 1
            ) AS cuenta_id,
            (
            SELECT
                cnt_cuenta
            FROM
                dta_detalle_tipoarticulo
            JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
            WHERE
                dta_id_tia = tia_id
            AND dta_id_tcn = 2
            GROUP BY
                cnt_id
            LIMIT 1
            ) AS cuenta,
            (
            SELECT
                cnt_nombre
            FROM
                dta_detalle_tipoarticulo
            JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
            WHERE
                dta_id_tia = tia_id
            AND dta_id_tcn = 2
            GROUP BY
                cnt_id
            LIMIT 1
            ) AS cuenta_nombre,
            SUM(def_subtotal) AS subtotal_prod,
            def_id AS id_def

            ", false)
             ->from('def_detalle_fact')
             ->join('fac_factura', 'fac_id = def_id_fac')
             ->join('art_articulo', 'def_id_art = art_id')
             ->join('tia_tipo_articulo', 'art_id_tia = tia_id')
             ->having('fac_id IS NOT NULL')
             ->limit(100)
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }*/

        $query->get()->result_array();
        return $this->db->last_query();
    }

    /**
     * Descripción:
     * Función que obtiene las facturas 
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-02-12
     * @param Ninguno
     * @return Devuelve los impuestos por factura
     */
    public function obtener_impuestosxfactura($where = null, $groupby = null, $orderby = null, $full_mes = 0) {
        $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('IMPUESTOS'));
        $tcn_id = ($tcn_id > 0) ? $tcn_id : 0;
        $parametros = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $not_remi = (isset($parametros['NOTA REMISION'])) ? $parametros['NOTA REMISION'] : 0;
        //print_r($tcn_ida); die();
        //$tcn_id = 17;
        $multiplo_negativo = 1;
        $uxc_where = '';
        if (isset($where['fac_id_uxc'])) {
            $uxc_where = 'AND fac_id_uxc in (' . $where['fac_id_uxc'] . ')';
        }
        if ($orderby) { //Es por detalles        
            $query = $this->db->select("fac_id, fac_id_origen_devolucion, 
                    imp_porcentaje,
                    SUM(DISTINCT
                        (imp_porcentaje / 100) * def_subtotal
                    ) AS subtotximpcuentabk,
                    SUM(IF ( fac_id_origen_devolucion IS NULL, ixf_monto, ixf_monto * $multiplo_negativo)) AS subtotximpcuenta,
                    (def_subtotal-def_retencion) as def_subtotal,
                    (
                       SELECT
                           cxe_id_tcn
                       FROM
                           cnt_cuenta_contable
                       JOIN cxe_cuentaximpuesto ON cxe_id_cnt = cnt_id
                       WHERE
                           cnt_id = cxe_id_cnt 
                            and cxe_id_imp = ixf_id_imp
                            and cxe_id_cec = fac_id_cec
                            and IFNULL(cxe_id_tif,1) = IF((cxe_id_tif IS NULL),1,fac_id_tif)
                           and cxe_id_tcn = $tcn_id LIMIT 1
                    ) cxe_id_tcn,
                 (
                    SELECT
                        cxe_id_cnt
                    FROM
                        cnt_cuenta_contable
                    JOIN cxe_cuentaximpuesto ON cxe_id_cnt = cnt_id
                    WHERE
                        cnt_id = cxe_id_cnt 
                        and cxe_id_cec = fac_id_cec
                        and cxe_id_imp = ixf_id_imp 
                        and IFNULL(cxe_id_tif,1) = IF((cxe_id_tif IS NULL),1,fac_id_tif)
                        and cxe_id_tcn = $tcn_id LIMIT 1
                 ) cxe_id_cnt,
                 (
                    SELECT
                        cnt_cuenta
                    FROM
                        cnt_cuenta_contable
                    JOIN cxe_cuentaximpuesto ON cxe_id_cnt = cnt_id
                    WHERE
                        cnt_id = cxe_id_cnt 
                        and cxe_id_imp = ixf_id_imp
                        and cxe_id_cec = fac_id_cec
                        and IFNULL(cxe_id_tif,1) = IF((cxe_id_tif IS NULL),1,fac_id_tif)
                        and cxe_id_tcn = $tcn_id LIMIT 1
                 ) cuenta,
                 (
                    SELECT
                        CONCAT_WS(' ',cnt_nombre, tif_abreviacion)
                    FROM
                        cnt_cuenta_contable
                    JOIN cxe_cuentaximpuesto ON cxe_id_cnt = cnt_id
                    LEFT JOIN tif_tipo_factura ON tif_id = cxe_id_tif
                    WHERE
                        cnt_id = cxe_id_cnt  
                        and cxe_id_imp = ixf_id_imp
                        and cxe_id_cec = fac_id_cec
                        and IFNULL(cxe_id_tif,1) = IF((cxe_id_tif IS NULL),1,fac_id_tif)
                        and cxe_id_tcn = $tcn_id LIMIT 1
                ) cuenta_nombre
                ", false)
                ->from('def_detalle_fact')
                ->join('fac_factura', 'fac_id = def_id_fac')
                ->join('ixf_impuestoxfactura', 'def_id = ixf_id_def')
                ->join('imp_impuesto', 'ixf_id_imp = imp_id')
                //->join('cxe_cuentaximpuesto', 'ixf_id_imp = cxe_id_imp', 'left')
                // ->join('tif_tipo_factura', 'tif_id = cxe_id_tif', 'left')
                //->having('ISNULL(cxe_id_tcn) OR cxe_id_tcn = '.$tcn_id,false)
                //->limit(50)
            ;
            $this->db->where('fac_id_pct IS NULL');
            if ($where != null) {
                $this->db->where($where);
            }

            if ($groupby != null) {
                $this->db->group_by($groupby);
            }

            if ($orderby != null) {
                $this->db->order_by($orderby);
            }
        } else { //Consolidado
            $campo_fec = ($full_mes > 0) ? "DATE_FORMAT(fac_fecha_cont, '%Y%m')" : "DATE( fac_fecha_cont )";
            $valor_fec = ($full_mes > 0) ? $where["DATE_FORMAT(fac_fecha_cont,'%Y%m')"] : $where['DATE(fac_fecha_cont)'];
            // $fechas = null;
            // foreach ($where as $key => $val) {
            //     if (stristr($key, 'DATE(fac_fecha_cont)') !== FALSE) {
            //         $fechas = $key;
            //     }
            // }
            // $campo_fec = ($full_mes > 0) ? "DATE_FORMAT(fac_fecha_cont, '%Y%m')" : (($fechas) ? $fechas : "DATE( fac_fecha_cont )");
            // $valor_fec = ($full_mes > 0) ? $where["DATE_FORMAT(fac_fecha_cont,'%Y%m')"] : (($fechas) ? '' : $where['DATE(fac_fecha_cont)']);
            // $query_fechas = ($fechas) ? "AND $fechas " : " AND $campo_fec = '$valor_fec'";
            $query = "
                SELECT  a.def_id, 
                        a.fac_id, 
                        a.cxe_id_tcn, 
                        a.imp_porcentaje, 
                        sum(a.subtotximpcuenta) AS subtotximpcuenta,
                        a.def_subtotal,
                        a.cxe_id_cnt,
                        a.cuenta,
                        CONCAT_WS(' ', a.cuenta_nombre, a.tif_nombre ) AS cuenta_nombre,
                        a.cxe_id_cnt,
                        a.tif_nombre,
                        a.tif_abreviacion            
                FROM
                (
                SELECT
                    def_id,
                    fac_id,
                    " . $tcn_id . " cxe_id_tcn,
                    imp_porcentaje,
                    SUM( ( imp_porcentaje / 100 ) * def_subtotal ) AS subtotximpcuentabkY,
                    SUM(IF ( fac_id_origen_devolucion IS NULL,ixf_monto, ixf_monto * $multiplo_negativo)) AS subtotximpcuenta,
                    ( SELECT SUM( ixf_monto ) FROM ixf_impuestoxfactura WHERE ixf_id_def = def_id AND ixf_id_imp = imp_id ) AS subtotximpcuentaBK,
                    ( def_subtotal - def_retencion ) AS def_subtotal,
                    (
                        SELECT
                            cxe_id_cnt 
                        FROM
                            cnt_cuenta_contable
                            JOIN cxe_cuentaximpuesto ON cxe_id_cnt = cnt_id 
                        WHERE
                            cnt_id = cxe_id_cnt 
                            AND cxe_id_imp = ixf_id_imp 
                            AND cxe_id_cec = fac_id_cec 
                            AND IFNULL(cxe_id_tif,1) = IF((cxe_id_tif IS NULL),1,fac_id_tif)
                            AND cxe_id_tcn = " . $tcn_id . " 
                            LIMIT 1 
                    ) AS cxe_id_cnt,
                    (
                        SELECT
                            cnt_cuenta 
                        FROM
                            cnt_cuenta_contable
                            JOIN cxe_cuentaximpuesto ON cxe_id_cnt = cnt_id 
                        WHERE
                            cnt_id = cxe_id_cnt 
                            AND cxe_id_imp = ixf_id_imp 
                            AND cxe_id_cec = fac_id_cec 
                            AND IFNULL(cxe_id_tif,1) = IF((cxe_id_tif IS NULL),1,fac_id_tif)
                            AND cxe_id_tcn = " . $tcn_id . " 
                            LIMIT 1 
                    ) cuenta,
                    (
                        SELECT
                            CONCAT_WS( ' ', cnt_nombre, tif_abreviacion ) 
                        FROM
                            cnt_cuenta_contable
                            JOIN cxe_cuentaximpuesto ON cxe_id_cnt = cnt_id
                        WHERE
                            cnt_id = cxe_id_cnt 
                            AND cxe_id_imp = ixf_id_imp 
                            AND cxe_id_cec = fac_id_cec 
                            AND IFNULL(cxe_id_tif,1) = IF((cxe_id_tif IS NULL),1,fac_id_tif)
                            AND cxe_id_tcn = " . $tcn_id . " 
                            LIMIT 1 
                    ) cuenta_nombre,
                    tif_nombre,
                    " . $tcn_id . " AS cxe_id_tif,
                    tif_abreviacion 
                FROM
                    ( def_detalle_fact )
                    JOIN fac_factura ON fac_id = def_id_fac
                    JOIN ixf_impuestoxfactura ON def_id = ixf_id_def
                    JOIN imp_impuesto ON ixf_id_imp = imp_id
                    JOIN tif_tipo_factura ON tif_id = fac_id_tif 
                WHERE
                    fac_id_pct IS NULL 
                    AND fac_id_tif != $not_remi
                    AND $campo_fec = '$valor_fec' " . $uxc_where . " 
                    AND fac_estado != 0
                GROUP BY
                    fac_id, imp_id
                ) a  GROUP BY a.cxe_id_cnt
            ";
            // $query_fechas AND fac_estado != 0 " . $uxc_where . "   1837/1838  *****/////-----
        }

        if ($orderby) { //Es por detalles            
            $datos_query = $query->get()->result_array();
        } else {
            $datos_query =  $this->db->query($query)->result_array();
        }
        // var_dump( $where, $this->db->last_query());die();
        return $datos_query;
    }

    /**
     * Descripción:
     * Función que obtiene las facturas 
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-02-12
     * @param Ninguno
     * @return Devuelve las retenciones por factura
     */
    public function obtener_retencionesxfactura($where = null, $groupby = null)
    {
        $query = $this->db->select(
            "
            fac_id,
            ret_porcentaje,
            (
                (ret_porcentaje / 100) * def_subtotal
            ) AS subtotxretcuenta,
            def_subtotal,

            IF (
                ISNULL(dcr_id_cnt),
                0,
                dcr_id_cnt
            ) AS dcr_id_cnt

            ",
            false
        )
            ->from('def_detalle_fact')
            ->join('fac_factura', 'fac_id = def_id_fac')
            ->join('rxf_retencionxdetalle_factura', 'def_id = rxf_id_def')
            ->join('ret_retencion', 'rxf_id_ret = ret_id')
            ->join('dcr_detalle_cuenta_retencion', 'ret_id = dcr_id_ret', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        return $query->get()->result_array();
    }

    public function obtener_haber_facturas($where = null, $groupby = null, $orderby = null, $full_mes = 0) {
        $multiplo_negativo = 1;
        $uxc_where = '';
        if (isset($where['fac_id_uxc'])) {
            $uxc_where = 'AND fac_id_uxc in (' . $where['fac_id_uxc'] . ')';
        }
        $idtipo_cnt_cliente = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CUENTA_POR_COBRAR'));
        $idtipo_cnt_cliente = ($idtipo_cnt_cliente > 0) ? $idtipo_cnt_cliente : 0;
        $parametros = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $not_remi = (isset($parametros['NOTA REMISION'])) ? $parametros['NOTA REMISION'] : 0;

        if ($orderby) {
            $select_individual =
                "
                fac1.fac_id, fac1.fac_id_origen_devolucion,
                ( 
                 SELECT (SUM(
                        IF(fac_id_origen_devolucion IS NULL, def_subtotal, def_subtotal * $multiplo_negativo) 
                        +
                        IF(fac_id_origen_devolucion IS NULL, def_impuesto, def_impuesto * $multiplo_negativo)
                        - 
                        (IFNULL(IF(fac_id_origen_devolucion IS NULL, def_retencion, def_retencion * $multiplo_negativo), 0.00) * $multiplo_negativo) ))
                 FROM def_detalle_fact 
                 WHERE def_id_fac = fac1.fac_id
                 ) as total, ( fac1.fac_subtotal + fac1.fac_impuesto) as tota, 
                 tpg_nombre, 
                 frp_nombre,
                (
                 SELECT cnt_id
                    FROM cxn_cuentaxcliente
                 JOIN cnt_cuenta_contable on cnt_id = cxn_id_cnt
                 WHERE cxn_id_tpg = fac1.fac_id_tpg
                 AND fac1.fac_id_cec = cxn_id_cec
                 AND cxn_id_frp = fac1.fac_id_frp
                 AND cxn_id_cli = fac1.fac_id_cli AND cxn_id_tcn = $idtipo_cnt_cliente
                 LIMIT 1
                 ) AS cnt_id, (
                 SELECT cnt_cuenta
                    FROM cxn_cuentaxcliente
                 JOIN cnt_cuenta_contable on cnt_id = cxn_id_cnt
                 WHERE cxn_id_tpg = fac1.fac_id_tpg
                 AND fac1.fac_id_cec = cxn_id_cec
                 AND cxn_id_frp = fac1.fac_id_frp
                 AND cxn_id_cli = fac1.fac_id_cli AND cxn_id_tcn = $idtipo_cnt_cliente
                 LIMIT 1
                 ) AS cnt_cuenta, (
                 SELECT cnt_nombre
                 FROM cxn_cuentaxcliente
                 JOIN cnt_cuenta_contable on cnt_id = cxn_id_cnt
                 WHERE cxn_id_tpg = fac1.fac_id_tpg
                 AND fac1.fac_id_cec = cxn_id_cec
                 AND cxn_id_frp = fac1.fac_id_frp
                 AND cxn_id_cli = fac1.fac_id_cli AND cxn_id_tcn = $idtipo_cnt_cliente
                 LIMIT 1
                 ) AS cnt_nombre
            ";

            //print_r($select); die();
            $query = $this->db->select($select_individual, false)
                ->from('fac_factura AS fac1')
                ->join('cli_cliente', 'fac1.fac_id_cli = cli_id')
                ->join('cxn_cuentaxcliente', 'cli_id = cxn_id_cli', 'left')
                ->join('tpg_tipo_pago', 'cxn_id_tpg = tpg_id', 'left')
                ->join('frp_forma_pago', 'frp_id = cxn_id_frp', 'left')
                ->join('cnt_cuenta_contable', 'cnt_id = cxn_id_cnt', 'left')
                //->limit(50)
            ;

            if ($where != null) {
                $this->db->where($where);
            }

            if ($groupby != null) {
                $this->db->group_by($groupby);
            }

            if ($orderby != null) {
                $this->db->order_by($orderby);
            }
        } else {
            /*
            $fechas = null;
            foreach ($where as $key => $val) {
                if (stristr($key, 'DATE(fac_fecha_cont)') !== FALSE) {
                    $fechas = $key;
                }
            }
            $campo_fec = ($full_mes > 0) ? "DATE_FORMAT(fac_fecha_cont, '%Y%m')" : (($fechas) ? $fechas : "DATE( fac_fecha_cont )");
            $valor_fec = ($full_mes > 0) ? $where["DATE_FORMAT(fac_fecha_cont,'%Y%m')"] : (($fechas) ? '' : $where['DATE(fac_fecha_cont)']);
            $query_fechas = ($fechas) ? "AND $fechas " : " AND $campo_fec = '$valor_fec'";
            */
            $campo_fec = ($full_mes > 0) ? "DATE_FORMAT(fac_fecha_cont, '%Y%m')" : "DATE( fac_fecha_cont )";
            $valor_fec = ($full_mes > 0) ? $where["DATE_FORMAT(fac_fecha_cont,'%Y%m')"] : $where['DATE(fac_fecha_cont)'];
            $select_consolidado =
                "
            SELECT a.fac_id, (SUM(a.total)) as total, tpg_nombre, cnt_id, cnt_cuenta, cnt_nombre, frp_nombre
            FROM
            (
                SELECT DISTINCT(fac1.fac_id),                
                ( 
                    SELECT SUM(((
                            IFNULL(IF(fac_id_origen_devolucion IS NULL,def_subtotal, def_subtotal * $multiplo_negativo),0) 
                            + IFNULL(IF(fac_id_origen_devolucion IS NULL,def_impuesto,def_impuesto * $multiplo_negativo),0.00) 
                            - (IFNULL(IF(fac_id_origen_devolucion IS NULL,def_retencion,def_retencion * $multiplo_negativo), 0.00) * $multiplo_negativo) )))
                    FROM fac_factura AS fac3
                    JOIN def_detalle_fact ON fac3.fac_id = def_id_fac
                    WHERE fac3.fac_id = fac1.fac_id
                ) as total,                
                (
                    SELECT tpg_nombre
                    FROM tpg_tipo_pago
                    WHERE tpg_id = fac1.fac_id_tpg
                ) AS tpg_nombre,
                (SELECT frp_nombre FROM frp_forma_pago WHERE frp_id = fac1.fac_id_frp) AS frp_nombre,
                (
                    SELECT cnt2.cnt_id
                    FROM fac_factura AS fac2
                    LEFT JOIN cli_cliente AS cli2 ON fac2.fac_id_cli = cli2.cli_id
                    LEFT JOIN cxn_cuentaxcliente AS cxn2 ON cli2.cli_id = cxn2.cxn_id_cli AND cxn2.cxn_id_tcn = $idtipo_cnt_cliente
                    LEFT JOIN tpg_tipo_pago AS tpg2 ON cxn2.cxn_id_tpg = tpg2.tpg_id
                    LEFT JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = cxn2.cxn_id_cnt
                    LEFT JOIN frp_forma_pago AS frp2 ON frp2.frp_id = cxn2.cxn_id_frp
                    WHERE cxn2.cxn_id_tpg = fac1.fac_id_tpg
                    AND tpg2.tpg_id = fac1.fac_id_tpg
                    AND frp2.frp_id = fac1.fac_id_frp
                    AND fac2.fac_id = fac1.fac_id
                    AND fac1.fac_id_cec = cxn2.cxn_id_cec
                    LIMIT 1
                ) AS cnt_id,
                (
                    SELECT cnt2.cnt_cuenta
                    FROM fac_factura AS fac2
                    LEFT JOIN cli_cliente AS cli2 ON fac2.fac_id_cli = cli2.cli_id
                    LEFT JOIN cxn_cuentaxcliente AS cxn2 ON cli2.cli_id = cxn2.cxn_id_cli AND cxn2.cxn_id_tcn = $idtipo_cnt_cliente
                    LEFT JOIN tpg_tipo_pago AS tpg2 ON cxn2.cxn_id_tpg = tpg2.tpg_id
                    LEFT JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = cxn2.cxn_id_cnt
                    LEFT JOIN frp_forma_pago AS frp2 ON frp2.frp_id = cxn2.cxn_id_frp
                    WHERE cxn2.cxn_id_tpg = fac1.fac_id_tpg
                    AND tpg2.tpg_id = fac1.fac_id_tpg
                    AND frp2.frp_id = fac1.fac_id_frp
                    AND fac2.fac_id = fac1.fac_id
                    AND fac1.fac_id_cec = cxn2.cxn_id_cec
                    LIMIT 1
                ) AS cnt_cuenta,
                (
                    SELECT cnt2.cnt_nombre
                    FROM fac_factura AS fac2
                    JOIN cli_cliente AS cli2 ON fac2.fac_id_cli = cli2.cli_id
                    JOIN cxn_cuentaxcliente AS cxn2 ON cli2.cli_id = cxn2.cxn_id_cli AND cxn2.cxn_id_tcn = $idtipo_cnt_cliente
                    JOIN tpg_tipo_pago AS tpg2 ON cxn2.cxn_id_tpg = tpg2.tpg_id
                    JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = cxn2.cxn_id_cnt
                    LEFT JOIN frp_forma_pago AS frp2 ON frp2.frp_id = cxn2.cxn_id_frp
                    WHERE cxn2.cxn_id_tpg = fac1.fac_id_tpg
                    AND tpg2.tpg_id = fac1.fac_id_tpg
                    AND frp2.frp_id = fac1.fac_id_frp
                    AND fac2.fac_id = fac1.fac_id
                    AND fac1.fac_id_cec = cxn2.cxn_id_cec
                    LIMIT 1
                ) AS cnt_nombre
                FROM
                    (fac_factura AS fac1)
                JOIN cli_cliente ON fac1.fac_id_cli = cli_id
                LEFT JOIN cxn_cuentaxcliente ON cli_id = cxn_id_cli
                LEFT JOIN tpg_tipo_pago ON cxn_id_tpg = tpg_id
                LEFT JOIN cnt_cuenta_contable ON cnt_id = cxn_id_cnt
                WHERE
                    fac_id_pct IS NULL
                AND $campo_fec = '$valor_fec' " . $uxc_where . "                
                AND fac_estado != 0
                AND fac_id_tif != $not_remi
            ) AS a WHERE !ISNULL(total)
            GROUP BY
                a.cnt_id            
            ";
            $query = $this->db->query($select_consolidado);
        }
        //$select = ($orderby) ? $select_individual : $select_consolidado ; 
        ///$query_fechas AND fac_estado != 0 " . $uxc_where . " //2053/2054 ///////////// *****/////-----

        if ($orderby) { //Detallado
            $return_datos = $query->get()->result_array();
            // echo $this->db->last_query(); die();
            return $return_datos;
        } else {
            $return_datos = $query->result_array();
            // echo $this->db->last_query(); die();
            return $return_datos;
        }

        //$this->db->last_query();
    }

    //Funcion que obtienen los id de las cuentas hijas
    public function get_cuenta_hijas($where)
    {
        $query = $this->db->select("cnt_id")
            ->from('cnt_cuenta_contable');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    //get total por cuenta padre y subcuentas
    public function get_total_cuentapadre_cuentashijas($where_in, $where)
    {
        $query = $this->db->select('(SUM(dpc_debe) - SUM(dpc_haber)) AS total', false)
            ->from('dpc_detalle_partida')
            ->join('pct_partida_contable', 'pct_id = dpc_id_pct')
            ->join('fac_factura', 'pct_id = fac_id_pct');

        if ($where_in != null) {
            $this->db->where_in('dpc_id_cnt', $where_in);
        }

        if ($where_in != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    //get total por cuenta padre y subcuentas
    public function get_total_cuentapadre_cuentashijas_reportes($where_in, $where)
    {
        $id_cnt_padre = '';
        if (count($where_in) > 0) {
            $id_cnt_padre = $where_in[0];
        }
        $query = $this->db->select(
            '
                        (   
                            IF(
                                (
                                    SELECT cnt_aumenta
                                    FROM cnt_cuenta_contable
                                    WHERE cnt_id IN("' . $id_cnt_padre . '")
                                ) = "D",
                                SUM(dpc_debe) - SUM(dpc_haber),
                                SUM(dpc_haber) - SUM(dpc_debe)
                            )
                        ) AS total
                    ',
            false
        )
            ->from('dpc_detalle_partida')
            ->join('pct_partida_contable', 'pct_id = dpc_id_pct')
            ->join('pcc_partida_centro_costo', 'pcc_id = dpc_id_pcc', 'left')
            //->join('fac_factura', 'pct_id = fac_id_pct')                            
        ;

        if ($where_in != null) {
            $this->db->where_in('dpc_id_cnt', $where_in);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        $t = $query->get()->result_array();
        //print_r($this->db->last_query());// die();
        return $t;
    }

    public function get_total_cuentapadre_cuentashijas_reportes2($where_in, $where, $where2)
    {

        $id_cnt_padre = '';
        if (count($where_in) > 0) {
            $id_cnt_padre = $where_in[0];
        }
        $query = $this->db->select(
            '
                        (   
                            IF(
                                (
                                    SELECT cnt_aumenta
                                    FROM cnt_cuenta_contable
                                    WHERE cnt_id IN("' . $id_cnt_padre . '")
                                ) = "D",
                                SUM(dpc_debe) - SUM(dpc_haber),
                                SUM(dpc_haber) - SUM(dpc_debe)
                            )
                        ) AS total
                    ',
            false
        )
            ->from('dpc_detalle_partida')
            ->join('pct_partida_contable', 'pct_id = dpc_id_pct')
            ->join('pcc_partida_centro_costo', 'pcc_id = dpc_id_pcc', 'left');

        if ($where_in != null) {
            $this->db->where_in('dpc_id_cnt', $where_in);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        $a = $query->get()->result_array();
        $query2 = $this->db->select(
            '
                        (   
                            IF(
                                (
                                    SELECT cnt_aumenta
                                    FROM cnt_cuenta_contable
                                    WHERE cnt_id IN("' . $id_cnt_padre . '")
                                ) = "D",
                                SUM(dpc_debe) - SUM(dpc_haber),
                                SUM(dpc_haber) - SUM(dpc_debe)
                            )
                        ) AS anterior
                    ',
            false
        )
            ->from('dpc_detalle_partida')
            ->join('pct_partida_contable', 'pct_id = dpc_id_pct')
            ->join('pcc_partida_centro_costo', 'pcc_id = dpc_id_pcc', 'left');

        if ($where_in != null) {
            $this->db->where_in('dpc_id_cnt', $where_in);
        }

        if ($where2 != null) {
            $this->db->where($where2);
        }

        $b = $query->get()->result_array();
        //print_r($this->db->last_query());// die();
        $t = array_merge($a, $b);
        return $t;
    }

    //get total por cuenta contable por un tipo de cuenta en especifico
    //$where arreglo con las condiciones: fecha de inicio, fecha de fin, tipo partida
    public function get_total_cuentas_partida_consolidada($where)
    {
        $query = $this->db->select(
            '            
            dpc_id_cnt,
            (
                SELECT
                    cnt_cuenta
                FROM
                    cnt_cuenta_contable
                WHERE
                    cnt_id = dpc_id_cnt
            ) as cnt_cuenta,
            (
                SELECT
                    cnt_nombre
                FROM
                    cnt_cuenta_contable
                WHERE
                    cnt_id = dpc_id_cnt
            ) as cnt_nombre,
            SUM(dpc_debe) AS dpc_debe,
            SUM(dpc_haber) AS dpc_haber,
            pct_id_tpd',
            false
        )
            ->from('dpc_detalle_partida')
            ->join('pct_partida_contable', 'pct_id = dpc_id_pct')
            ->join('pcc_partida_centro_costo', 'pcc_id = dpc_id_pcc', 'left')
            ->group_by('dpc_id_cnt');;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * Descripción:
     * Función que obtiene las facturas 
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-03-06
     * @param Ninguno
     * @return Devuelve los productos por movimiento
     */
    public function obtener_productosxfactura_inventario($where = null, $groupby = null, $orderby = null, $def_id = null, $where2 = null)
    {
        $detalle = ($where2) ? $where2['detalle'] : null;
        //$having = ($where2) ? $where2['having']: null;
        $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('EXISTENCIA'));
        //$tdc_id_cnt = $where2["dta_id_tcn"];
        /*echo $having;
        die();*/
        //print_r($where2); die();
        //Valor no detallado
        $cadena1 = '
                tip_id,
                tip_entrada,
                tip_salida,
                tip_traslado,
                tip_nombre,
                moi_documento,
                moi_fecha_mov,
                moi_id,
                GROUP_CONCAT(DISTINCT moi_id) AS facturas,
             SUM(dee_subtotal) AS subtotal_prod,
             (
                SELECT (cnt_id)
              FROM dta_detalle_tipoarticulo
              JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id
              WHERE dta_id_tia = art_id_tia
                AND tcn_id = ' . $tcn_id . '
                AND dta_id_bod = moi_id_bod
                GROUP BY tcn_id
                LIMIT 1
             ) AS cuenta_id,
             (
                SELECT (cnt_cuenta)
              FROM dta_detalle_tipoarticulo
              JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id
              WHERE dta_id_tia = art_id_tia
                AND tcn_id = ' . $tcn_id . '
                AND dta_id_bod = moi_id_bod
                GROUP BY tcn_id
                LIMIT 1
             ) AS cuenta,
             (
                SELECT (cnt_nombre)
              FROM dta_detalle_tipoarticulo
              JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id
              WHERE dta_id_tia = art_id_tia
                AND tcn_id = ' . $tcn_id . '
                AND dta_id_bod = moi_id_bod
                GROUP BY tcn_id
                LIMIT 1
             ) AS cuenta_nombre,
            dee_id
            ';
        //Valor detallado
        $cadena2 = '
                tip_id,
                tip_entrada,
                tip_salida,
                tip_traslado,
                tip_nombre,
                moi_documento,
                moi_fecha_mov,
                moi_id,
                GROUP_CONCAT(DISTINCT moi_id) AS facturas,
             SUM(dee_subtotal) AS subtotal_prod,
             (
                SELECT (cnt_id)
              FROM dta_detalle_tipoarticulo
              JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
               JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id
              WHERE dta_id_tia = art_id_tia
                AND tcn_id = ' . $tcn_id . '
                AND dta_id_bod = moi_id_bod
                GROUP BY tcn_id
                LIMIT 1
             ) AS cuenta_id,
             (
                SELECT (cnt_cuenta)
              FROM dta_detalle_tipoarticulo
              JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id
              WHERE dta_id_tia = art_id_tia
                AND tcn_id = ' . $tcn_id . '
                AND dta_id_bod = moi_id_bod
                GROUP BY tcn_id
                LIMIT 1
             ) AS cuenta,
             (
                SELECT (cnt_nombre)
              FROM dta_detalle_tipoarticulo
              JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id
              WHERE dta_id_tia = art_id_tia
                AND tcn_id = ' . $tcn_id . '
                AND dta_id_bod = moi_id_bod
                GROUP BY tcn_id
                LIMIT 1
             ) AS cuenta_nombre,
            dee_id
            ';
        $cadena = ($detalle) ? $cadena2 : $cadena1;

        $query = $this->db->select($cadena, FALSE)
            ->from('moi_movimiento_inv')
            ->join('dee_detalle_mov', 'moi_id = dee_id_moi')
            ->join('art_articulo', 'art_id = dee_id_art')
            ->join('tip_tipo_proceso', 'moi_id_tip = tip_id');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        /*if($having != null){
            $this->db->having($having,false);
        }*/

        return $query->get()->result_array();
    }


    /**
     * Descripción:
     * Función que obtiene los movimientos
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-03-07
     * @param Ninguno
     * @return Devuelve los productos por movimiento
     */
    public function obtener_haber_movimiento_inventario($where = null, $groupby = null, $orderby = null)
    {
        $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('MOVIMIENTOS'));
        $idtipo_cnt_gasto  = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('GASTO'));
        $idtipo_cnt_costo  = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('COSTO'));
        $tcn_id_proveedor = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('INVENTARIO_EN_TRANSITO'));
        $tcn_id = $tcn_id_proveedor; //siempre en inventario en transito por el momento

        $condicion_aplicar = " AND tcn_id = " . $tcn_id;
        $condicion_aplicar_prv = " AND tcn_id = " . $tcn_id_proveedor;
        if (isset($where['tip_salida']) && $where['tip_salida'] == 1) {
            //$condicion_tipo_tcn = " AND tcn_id = IF(art_gasto, $idtipo_cnt_gasto, $idtipo_cnt_costo)";
            $condicion_traslado = " AND  tcn_id =  IF((SELECT COUNT(*) FROM tra_translado WHERE tra_id_moi_sal = moi_id)>0,$tcn_id_proveedor,IF(art_gasto, $idtipo_cnt_gasto, $idtipo_cnt_costo))";
            $condicion_aplicar =  $condicion_aplicar_prv =  $condicion_traslado;
        }
        //$tcn_id = 18;
        $select_individual = "
        moi_id,
        tip_id,
        SUM(dee_subtotal) AS total,
        CASE 
        WHEN moi_id_dpv IS NULL AND moi_id_fac IS NULL THEN (
            SELECT (cnt_id) FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id WHERE dta_id_tia = art_id_tia
                $condicion_aplicar
                AND dta_id_bod = moi_id_bod GROUP BY tcn_id LIMIT 1) 
        WHEN moi_id_fac IS NOT NULL AND tip_entrada = 1 THEN (
            SELECT (cnt_id) FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id 
                JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id WHERE dta_id_tia = art_id_tia 
                AND  tcn_id = IF((SELECT COUNT(*) FROM tra_translado WHERE tra_id_moi_sal = moi_id) > 0, $tcn_id_proveedor, IF(art_gasto, $idtipo_cnt_gasto, $idtipo_cnt_costo))
                AND dta_id_bod = moi_id_bod GROUP BY tcn_id LIMIT 1)
        ELSE (
            SELECT (cnt_id) FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id 
                JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id WHERE dta_id_tia = art_id_tia
                $condicion_aplicar_prv
                AND dta_id_bod = moi_id_bod GROUP BY tcn_id LIMIT 1)
        END AS cnt_id,
        CASE 
        WHEN moi_id_dpv IS NULL AND moi_id_fac IS NULL THEN (
            SELECT (cnt_cuenta) FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id WHERE dta_id_tia = art_id_tia
                $condicion_aplicar
                AND dta_id_bod = moi_id_bod GROUP BY tcn_id LIMIT 1) 
        WHEN moi_id_fac IS NOT NULL AND tip_entrada = 1 THEN (
            SELECT (cnt_cuenta) FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id WHERE dta_id_tia = art_id_tia
                AND  tcn_id = IF((SELECT COUNT(*) FROM tra_translado WHERE tra_id_moi_sal = moi_id) > 0, $tcn_id_proveedor, IF(art_gasto, $idtipo_cnt_gasto, $idtipo_cnt_costo))
                AND dta_id_bod = moi_id_bod GROUP BY tcn_id LIMIT 1) 
        ELSE (
            SELECT cnt_cuenta FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id WHERE dta_id_tia = art_id_tia
                $condicion_aplicar_prv
                AND dta_id_bod = moi_id_bod GROUP BY tcn_id LIMIT 1)
        END AS cnt_cuenta,
        CASE 
        WHEN moi_id_dpv IS NULL AND moi_id_fac IS NULL THEN (
            SELECT (cnt_nombre) FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
            JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id WHERE dta_id_tia = art_id_tia
                $condicion_aplicar
                AND dta_id_bod = moi_id_bod GROUP BY tcn_id LIMIT 1) 
        WHEN moi_id_fac IS NOT NULL AND tip_entrada = 1 THEN (
            SELECT (cnt_nombre) FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id WHERE dta_id_tia = art_id_tia
                AND  tcn_id = IF((SELECT COUNT(*) FROM tra_translado WHERE tra_id_moi_sal = moi_id) > 0, $tcn_id_proveedor, IF(art_gasto, $idtipo_cnt_gasto, $idtipo_cnt_costo))
                AND dta_id_bod = moi_id_bod GROUP BY tcn_id LIMIT 1) 
        ELSE (
            SELECT cnt_nombre FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
            JOIN tcn_tipo_cuenta ON dta_id_tcn = tcn_id WHERE dta_id_tia = art_id_tia
                $condicion_aplicar_prv
                AND dta_id_bod = moi_id_bod GROUP BY tcn_id LIMIT 1)
        END AS cnt_nombre
        ";
        /*"
        moi_id, 
        SUM(dee_subtotal) AS total, 
        (
        SELECT cnt_id
        FROM cnt_cuenta_contable
        JOIN ctp_cuenta_tipo_proceso AS ctp2 ON cnt_id = ctp2.ctp_id_cnt
        WHERE cnt_id = ctp1.ctp_id_cnt
        AND ctp2.ctp_id_tcn = ".$tcn_id."
        AND ctp2.ctp_id_tip = ctp1.ctp_id_tip
        ) AS cnt_id,
        (
        SELECT cnt_cuenta
        FROM cnt_cuenta_contable
        JOIN ctp_cuenta_tipo_proceso AS ctp2 ON cnt_id = ctp2.ctp_id_cnt
        WHERE cnt_id = ctp1.ctp_id_cnt
        AND ctp2.ctp_id_tcn = ".$tcn_id."
        AND ctp2.ctp_id_tip = ctp1.ctp_id_tip
        ) AS cnt_cuenta,
        (
        SELECT cnt_nombre
        FROM cnt_cuenta_contable
        JOIN ctp_cuenta_tipo_proceso AS ctp2 ON cnt_id = ctp2.ctp_id_cnt
        WHERE cnt_id = ctp1.ctp_id_cnt
        AND ctp2.ctp_id_tcn = ".$tcn_id."
        AND ctp2.ctp_id_tip = ctp1.ctp_id_tip 
        ) AS cnt_nombre    
        ";*/

        $select = $select_individual;
        //$select_consolidado = " ";
        //$select = ($orderby) ? $select_individual : $select_consolidado ; 





        $query = $this->db->select($select, false)
            ->from('moi_movimiento_inv')
            ->join('dee_detalle_mov', 'moi_id = dee_id_moi')
            ->join('art_articulo', 'art_id = dee_id_art')
            ->join('tip_tipo_proceso', 'tip_id = moi_id_tip')
            ->join('dpv_documento_proveedor', 'dpv_id = moi_id_dpv', 'left')
            //->join('ctp_cuenta_tipo_proceso AS ctp1', 'moi_id_tip = ctp1.ctp_id_tip', 'left')             
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }

    /**
     * Descripción:
     * Función que obtiene las facturas 
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-04-24
     * @param Ninguno
     * @return Devuelve los productos por documento por proveedor cuando no afecta inventario
     */
    public function obtener_productosxdocproveedor_no_afecta_inv($where = null, $groupby = null, $orderby = null, $dxd_id = null, $where2 = null){
        //Valor no detallado
        $where2['tcn_id_costo'] = (isset($where2['tcn_id_costo'])) ? $where2['tcn_id_costo'] : $where2['tcn_id'];
        $where2['tcn_id_inv'] = (isset($where2['tcn_id_inv'])) ? $where2['tcn_id_inv'] : $where2['tcn_id'];
        $cadena1 = 'dpv_total, dpv_fecha_contabilizacion, dpv_afecta_inventario, dpv_id,
            SUM(
                IF(art_inventario = 0, 
                    CASE
                        WHEN (pxd_porcentaje > 0) THEN pxd_total
                        WHEN ((SELECT COUNT(s.dxd_id) FROM dxd_detalle_documento_proveedor s WHERE s.dxd_id_dpv = d.dxd_id_dpv AND s.dxd_id_art = d.dxd_id_art AND s.dxd_id != d.dxd_id) > 0) THEN 0
                        ELSE d.dxd_subtotal END
                ,
                    CASE
                        WHEN pxd_porcentaje > 0 THEN pxd_total /* (d.dxd_subtotal * (pxd_porcentaje / 100)) */
                        # WHEN ((SELECT COUNT(s.dxd_id) FROM dxd_detalle_documento_proveedor s WHERE s.dxd_id_dpv = d.dxd_id_dpv AND s.dxd_id_art = d.dxd_id_art AND s.dxd_id != d.dxd_id) > 0) THEN 0
                        ELSE d.dxd_subtotal END
                )
            ) AS subtotal_prod,
            SUM(CASE WHEN pxd_porcentaje > 0 THEN  (dxd_subtotal * (pxd_porcentaje/100)) 
                ELSE dxd_subtotal END) AS subtotal_prod_2,
            SUM(CASE
                WHEN (pxd_porcentaje > 0) THEN pxd_total
                WHEN ( (SELECT COUNT(sub.dxd_id) FROM dxd_detalle_documento_proveedor sub WHERE sub.dxd_id_dpv = d.dxd_id_dpv
                        AND sub.dxd_id_art = d.dxd_id_art AND sub.dxd_id != d.dxd_id ) > 0) THEN 0
                ELSE d.dxd_subtotal END
            ) AS subtotal_prod_3,            
            IFNULL(
                (SELECT cnt_id FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id 
                WHERE dta_id_tcn = IF(art_inventario = 1,' . $where2['tcn_id_inv'] . ', (IF(art_gasto = 1, ' . $where2['tcn_id'] . ', ' . $where2['tcn_id_costo'] . ')))
                AND dta_id_tia = tia_id AND IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dta_id_bod)) = IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dxd_id_bod)) LIMIT 1),
                0
            ) AS cuenta_id,
            IFNULL((
                    SELECT IF (ISNULL(cnt_id), 0, cnt_id) AS cnt_id FROM cnt_cuenta_contable
                    WHERE cnt_id = pxd_id_cnt GROUP BY cnt_id LIMIT 1
                ), IFNULL((
                        SELECT cnt_id FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id      
                        WHERE dta_id_tcn = IF(art_inventario=1,' . $where2['tcn_id_inv'] . ',(IF(art_gasto=1,' . $where2['tcn_id'] . ',' . $where2['tcn_id_costo'] . ')))
                        AND dta_id_tia = tia_id AND IF(art_tipo=1, 1, dta_id_bod) = IF(art_tipo=1, 1, dxd_id_bod) LIMIT 1
            ), 0)) AS cuenta_id_2,
            (SELECT cnt_cuenta FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id      
                WHERE dta_id_tcn = IF(art_inventario = 1, ' . $where2['tcn_id_inv'] . ', (IF(art_gasto = 1,' . $where2['tcn_id'] . ', ' . $where2['tcn_id_costo'] . ')))
                AND dta_id_tia = tia_id AND IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dta_id_bod)) = IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dxd_id_bod)) LIMIT 1
            ) AS cuenta,
            IFNULL(
                (SELECT cnt_cuenta FROM cnt_cuenta_contable WHERE cnt_id = pxd_id_cnt GROUP BY cnt_id LIMIT 1),
                (
                SELECT cnt_cuenta FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id      
                WHERE dta_id_tcn = IF(art_inventario=1,' . $where2['tcn_id_inv'] . ',(IF(art_gasto=1,' . $where2['tcn_id'] . ',' . $where2['tcn_id_costo'] . ')))
                AND dta_id_tia = tia_id AND IF(art_tipo=1, 1, dta_id_bod) = IF(art_tipo=1, 1, dxd_id_bod) LIMIT 1
            )) AS cuenta_2,
            (SELECT cnt_nombre FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                WHERE dta_id_tcn = IF(art_inventario = 1, ' . $where2['tcn_id_inv'] . ', (IF(art_gasto = 1, ' . $where2['tcn_id'] . ', ' . $where2['tcn_id_costo'] . ')))
                AND dta_id_tia = tia_id AND IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dta_id_bod)) = IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dxd_id_bod)) LIMIT 1
            ) AS cuenta_nombre,
            IFNULL((
                    SELECT cnt_nombre FROM cnt_cuenta_contable WHERE cnt_id = pxd_id_cnt GROUP BY cnt_id LIMIT 1
            ),(
                SELECT cnt_nombre FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id      
                WHERE dta_id_tcn = IF(art_inventario=1,' . $where2['tcn_id_inv'] . ',(IF(art_gasto=1,' . $where2['tcn_id'] . ',' . $where2['tcn_id_costo'] . ')))
                AND dta_id_tia = tia_id AND IF(art_tipo=1, 1, dta_id_bod) = IF(art_tipo=1, 1, dxd_id_bod) LIMIT 1
            )) AS cuenta_nombre_2,
            dxd_id
        ';

        //Valor detallado
        $cadena2 = 'dpv_total, dpv_fecha_contabilizacion, dpv_afecta_inventario, dpv_id,
            SUM(IF(art_inventario = 0, 
                    CASE
                        WHEN (pxd_porcentaje > 0) THEN pxd_total
                        WHEN ((SELECT COUNT(s.dxd_id) FROM dxd_detalle_documento_proveedor s WHERE s.dxd_id_dpv = dxd_id_dpv AND s.dxd_id_art = dxd_id_art AND s.dxd_id != dxd_id) > 0) THEN 0
                        ELSE dxd_subtotal END
                ,
                    CASE
                        WHEN pxd_porcentaje > 0 THEN pxd_total /* (d.dxd_subtotal * (pxd_porcentaje / 100)) */
                        WHEN ((SELECT COUNT(s.dxd_id) FROM dxd_detalle_documento_proveedor s WHERE s.dxd_id_dpv = d.dxd_id_dpv AND s.dxd_id_art = d.dxd_id_art AND s.dxd_id != d.dxd_id) > 0) THEN 0
                        ELSE dxd_subtotal END
                )
            ) AS subtotal_prod,
            SUM(CASE WHEN pxd_porcentaje > 0 THEN  (dxd_subtotal * (pxd_porcentaje/100)) 
                ELSE dxd_subtotal END) AS subtotal_prod_2,
            SUM(CASE
                WHEN (pxd_porcentaje > 0) THEN pxd_total
                WHEN ( (SELECT COUNT(sub.dxd_id) FROM dxd_detalle_documento_proveedor sub WHERE sub.dxd_id_dpv = d.dxd_id_dpv
                        AND sub.dxd_id_art = d.dxd_id_art AND sub.dxd_id != d.dxd_id ) > 0) THEN 0
                ELSE d.dxd_subtotal END
            ) AS subtotal_prod_3,
            IFNULL(
                (SELECT cnt_id FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id      
                WHERE dta_id_tcn = IF(art_inventario = 1, ' . $where2['tcn_id_inv'] . ', (IF(art_gasto = 1, ' . $where2['tcn_id'] . ', ' . $where2['tcn_id_costo'] . ')))
                AND dta_id_tia = tia_id AND IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dta_id_bod)) = IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dxd_id_bod)) LIMIT 1
            ), 0) AS cuenta_id,
            (SELECT cnt_cuenta FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id      
                WHERE dta_id_tcn = IF(art_inventario = 1, ' . $where2['tcn_id_inv'] . ', (IF(art_gasto = 1, ' . $where2['tcn_id'] . ', ' . $where2['tcn_id_costo'] . ')))
                AND dta_id_tia = tia_id AND IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dta_id_bod)) = IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dxd_id_bod)) LIMIT 1
            ) AS cuenta,
            (SELECT cnt_nombre FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id 
                WHERE dta_id_tcn = IF(art_inventario = 1, ' . $where2['tcn_id_inv'] . ', (IF(art_gasto = 1, ' . $where2['tcn_id'] . ', ' . $where2['tcn_id_costo'] . ')))
                AND dta_id_tia = tia_id AND IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dta_id_bod)) = IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dxd_id_bod)) LIMIT 1
            ) AS cuenta_nombre,
            dxd_id';

        $cadena = ($orderby) ? $cadena1 : $cadena2;
        $query = $this->db->select($cadena, FALSE)
            ->from('dpv_documento_proveedor')
            ->join('dxd_detalle_documento_proveedor AS d', 'dpv_id = d.dxd_id_dpv')
            ->join('art_articulo', 'd.dxd_id_art = art_id')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id')
            ->join('pxd_prorrateoxdetalle_documento', 'pxd_id_dxd = d.dxd_id', 'left')
            ->where('dpv_id_pct IS NULL');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
            $this->db->having('subtotal_prod <> 0');
        }

        // if ($orderby) {
        //     $return = $query->get()->result_array();
        //     print_r($this->db->last_query());die();
        // } else {
        //     return $query->get()->result_array();
        // }

        return $query->get()->result_array();
    }

    /**
     * Descripción:
     * Función que obtiene las facturas 
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-04-25
     * @param Ninguno
     * @return Devuelve los impuestos por documento por proveedor cuando no afecta inventario
     */
    public function obtener_impuestosxdocproveedor_no_afecta_inv($where = null, $groupby = null, $orderby = null, $dxd_id = null, $where2 = null)
    {
        $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('IMPUESTOS'));

        $cadena1 = 'dpv_id,
            cxe_id_tcn,
            cxe_id_cnt,
            imp_porcentaje,
            IF(imp_valor > 0, 
                SUM(imp_valor * dxd_cantidad), 
                SUM((imp_porcentaje / 100) * dxd_subtotal)
            ) AS subtotximpcuenta,
            dxd_subtotal, 
            (SELECT cnt_id FROM cnt_cuenta_contable WHERE cnt_id = cxe_id_cnt) cuenta_id,
            (SELECT cnt_cuenta FROM cnt_cuenta_contable WHERE cnt_id = cxe_id_cnt) cuenta,
            (SELECT cnt_nombre FROM cnt_cuenta_contable WHERE cnt_id = cxe_id_cnt) cuenta_nombre,
            dxd_id';
        $cadena = $cadena1;
        $query = $this->db->select($cadena, FALSE)
            ->from('dxd_detalle_documento_proveedor')
            ->join('dpv_documento_proveedor', 'dpv_id = dxd_id_dpv')
            ->join('idd_impuestoxdetalle_documento', 'dxd_id = idd_id_dxd')
            ->join('imp_impuesto', 'idd_id_imp = imp_id')
            ->join('cxe_cuentaximpuesto', 'idd_id_imp = cxe_id_imp AND cxe_id_tif = dpv_id_tif AND dpv_id_cec = cxe_id_cec', 'left')
            //->having('ISNULL(cxe_id_tcn) OR cxe_id_tcn = '.$tcn_id,false)
            //->where('dpv_afecta_inventario = 0')
            ->where('dpv_id_pct IS NULL');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }


    public function obtener_haber_docproveedor($where = null, $groupby = null, $orderby = null, $where2 = null)
    {
        $where_tipo_tcn = (isset($where2['tcn_id_prv']) && $where2['tcn_id_prv'] > 0) ? " AND dfp2.dfp_id_tcn = " . $where2['tcn_id_prv'] : '';
        $select_individual =
            "
            dpv1.dpv_id,
            ( dpv1.dpv_total /* - dpv1.dpv_retencion*/ ) as total,
            (
                    SELECT tpg_nombre
                    FROM tpg_tipo_pago
                    WHERE tpg_id = dpv1.dpv_id_tpg
            ) AS tpg_nombre,
            (
                    SELECT cnt2.cnt_id
                    FROM dpv_documento_proveedor AS dpv2
                    LEFT JOIN prv_proveedor AS prv2 ON dpv2.dpv_id_prv = prv2.prv_id
                    LEFT JOIN dfp_detalle_finanza_proveedor AS dfp2 ON prv2.prv_id = dfp2.dfp_id_prv
                    LEFT JOIN tpg_tipo_pago AS tpg2 ON dfp2.dfp_id_tpg = tpg2.tpg_id
                    LEFT JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = dfp2.dfp_id_cnt      
                    WHERE dfp2.dfp_id_tpg = dpv1.dpv_id_tpg
                    AND tpg2.tpg_id = dpv1.dpv_id_tpg
                    AND dpv2.dpv_id = dpv1.dpv_id $where_tipo_tcn
                    LIMIT 1
            ) AS cnt_id,
            (
                    SELECT cnt2.cnt_cuenta
                    FROM dpv_documento_proveedor AS dpv2
                    LEFT JOIN prv_proveedor AS prv2 ON dpv2.dpv_id_prv = prv2.prv_id
                    LEFT JOIN dfp_detalle_finanza_proveedor AS dfp2 ON prv2.prv_id = dfp2.dfp_id_prv
                    LEFT JOIN tpg_tipo_pago AS tpg2 ON dfp2.dfp_id_tpg = tpg2.tpg_id
                    LEFT JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = dfp2.dfp_id_cnt      
                    WHERE dfp2.dfp_id_tpg = dpv1.dpv_id_tpg
                    AND tpg2.tpg_id = dpv1.dpv_id_tpg
                    AND dpv2.dpv_id = dpv1.dpv_id $where_tipo_tcn
                    LIMIT 1
            ) AS cnt_cuenta,
            (
                    SELECT cnt2.cnt_nombre
                    FROM dpv_documento_proveedor AS dpv2
                    LEFT JOIN prv_proveedor AS prv2 ON dpv2.dpv_id_prv = prv2.prv_id
                    LEFT JOIN dfp_detalle_finanza_proveedor AS dfp2 ON prv2.prv_id = dfp2.dfp_id_prv
                    LEFT JOIN tpg_tipo_pago AS tpg2 ON dfp2.dfp_id_tpg = tpg2.tpg_id
                    LEFT JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = dfp2.dfp_id_cnt      
                    WHERE dfp2.dfp_id_tpg = dpv1.dpv_id_tpg
                    AND tpg2.tpg_id = dpv1.dpv_id_tpg
                    AND dpv2.dpv_id = dpv1.dpv_id $where_tipo_tcn
                    LIMIT 1
            ) AS cnt_nombre                
        ";

        $select_consolidado = " ";
        $select = ($orderby) ? $select_individual : $select_consolidado;
        $query = $this->db->select($select, false)
            ->from('dpv_documento_proveedor AS dpv1')
            ->join('prv_proveedor AS prv1', 'prv1.prv_id = dpv1.dpv_id_prv', 'left')
            ->join('dfp_detalle_finanza_proveedor', 'prv_id = dfp_id_prv', 'left')
            ->join('tpg_tipo_pago', 'dfp_id_tpg = tpg_id', 'left')
            ->join('cnt_cuenta_contable', 'cnt_id = dfp_id_cnt', 'left')
            //->where('dpv_afecta_inventario = 0')
            ->where('dpv_id_pct IS NULL');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        return $query->get()->result_array();
    }


    /**
     * Descripción:
     * Función que obtiene la parte de los producto para la partida consolidada
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-04-24
     * @param Ninguno
     * @return Devuelve los productos por documento por proveedor cuando no afecta inventario
     */
    public function obtener_productosxdocproveedor_no_afecta_inv_consolida($where = null, $groupby = null, $orderby = null, $dxd_id = null, $where2 = null, $cuenta_defecto = null)
    {
        //$tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('GASTO'));
        $group['dpv_id IS NOT NULL'] = null;
        //Valor detallado
        $where2['tcn_id_costo'] = (isset($where2['tcn_id_costo'])) ? $where2['tcn_id_costo'] : $where2['tcn_id'];
        $where2['tcn_id_inv'] = (isset($where2['tcn_id_inv'])) ? $where2['tcn_id_inv'] : $where2['tcn_id'];

        $cadena1 = '
             GROUP_CONCAT(DISTINCT dpv_id) AS facturas,
             dpv_fecha_contabilizacion,
             dpv_afecta_inventario,
             dpv_id,
             SUM(dxd_subtotal /*- dxd_retencion*/) AS subtotal_prod,
            IFNULL((
                SELECT
                    cnt_id
                FROM
                    dta_detalle_tipoarticulo
                JOIN
                    cnt_cuenta_contable ON dta_id_cnt = cnt_id      
                WHERE                   
                     dta_id_tcn = IF(art_inventario=1,' . $where2['tcn_id_inv'] . ',(IF(art_gasto=1,' . $where2['tcn_id'] . ',' . $where2['tcn_id_costo'] . ')))
                AND
                    dta_id_tia = tia_id
                AND 
                    IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dta_id_bod)) = IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dxd_id_bod)) 
                LIMIT 1
            ),' . $cuenta_defecto[0]["cnt_id"] . ') AS cuenta_id,
            IFNULL((
                SELECT
                    cnt_cuenta
                FROM
                    dta_detalle_tipoarticulo
                JOIN
                    cnt_cuenta_contable ON dta_id_cnt = cnt_id      
                WHERE                   
                    dta_id_tcn = IF(art_inventario=1,' . $where2['tcn_id_inv'] . ',(IF(art_gasto=1,' . $where2['tcn_id'] . ',' . $where2['tcn_id_costo'] . ')))
                AND
                    dta_id_tia = tia_id
                AND 
                    IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dta_id_bod)) = IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dxd_id_bod)) 
                LIMIT 1
            ),"' . $cuenta_defecto[0]["cnt_cuenta"] . '") AS cuenta,
            IFNULL((
                SELECT
                    cnt_nombre
                FROM
                    dta_detalle_tipoarticulo
                JOIN
                    cnt_cuenta_contable ON dta_id_cnt = cnt_id      
                WHERE                   
                    dta_id_tcn = IF(art_inventario=1,' . $where2['tcn_id_inv'] . ',(IF(art_gasto=1,' . $where2['tcn_id'] . ',' . $where2['tcn_id_costo'] . ')))
                AND
                    dta_id_tia = tia_id
                AND 
                    IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dta_id_bod)) = IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dxd_id_bod)) 
                LIMIT 1
            ),"' . $cuenta_defecto[0]["cnt_nombre"] . '") AS cuenta_nombre,
             dxd_id
         ';

        //Valor no detallado
        // SUM(dxd_subtotal /* - dxd_retencion*/) AS subtotal_prod,
        $cadena2 = '
             dpv_fecha_contabilizacion,
             dpv_afecta_inventario,
             dpv_id,
             SUM(CASE WHEN pxd_porcentaje > 0 THEN  (dxd_subtotal * (pxd_porcentaje/100)) ELSE dxd_subtotal END) AS subtotal_prod,
            IFNULL(
                (SELECT cnt_id FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                    WHERE dta_id_tcn = IF(art_inventario = 1, ' . $where2['tcn_id_inv'] . ', (IF(art_gasto = 1, ' . $where2['tcn_id'] . ', ' . $where2['tcn_id_costo'] . ')))
                    AND dta_id_tia = tia_id AND IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dta_id_bod)) = IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dxd_id_bod)) LIMIT 1),
                ' . $cuenta_defecto[0]["cnt_id"] . ' 
            ) AS cuenta_id,
            IFNULL(
                (SELECT cnt_cuenta FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                    WHERE dta_id_tcn = IF(art_inventario = 1, ' . $where2['tcn_id_inv'] . ', (IF(art_gasto = 1, ' . $where2['tcn_id'] . ', ' . $where2['tcn_id_costo'] . ')))
                    AND dta_id_tia = tia_id AND IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dta_id_bod)) = IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dxd_id_bod)) LIMIT 1),
                ' . $cuenta_defecto[0]["cnt_cuenta"] . '
            ) AS cuenta,
            IFNULL(
                (SELECT cnt_nombre FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                    WHERE dta_id_tcn = IF(art_inventario = 1, ' . $where2['tcn_id_inv'] . ', (IF(art_gasto = 1, ' . $where2['tcn_id'] . ', ' . $where2['tcn_id_costo'] . ')))
                    AND dta_id_tia = tia_id AND IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dta_id_bod)) = IF(art_tipo = 1, 1, IF(art_inventario = 0, 1, dxd_id_bod)) LIMIT 1),
                "' . $cuenta_defecto[0]["cnt_nombre"] . '"
            )AS cuenta_nombre,
            dxd_id
         ';

        $cadena = ($groupby) ? $cadena2 : $cadena1;
        $query = $this->db->select($cadena, FALSE)
            ->from('dpv_documento_proveedor')
            ->join('dxd_detalle_documento_proveedor', 'dpv_id = dxd_id_dpv')
            ->join('art_articulo', 'dxd_id_art = art_id')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id')
            //->where('dpv_afecta_inventario = 0')
            ->where('dpv_id_pct IS NULL');

        if ($groupby) {
            $this->db->join('pxd_prorrateoxdetalle_documento', 'pxd_id_dxd = dxd_id', 'left');
        }

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        /*if($having != null){*/
        $this->db->having($group, false);
        /*}*/

        return $query->get()->result_array();
        // return $this->db->last_query();
    }


    /**
     * Descripción:
     * Función que obtiene los impuestos
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-04-25
     * @param Ninguno
     * @return Devuelve los impuestos por documento por proveedor cuando no afecta inventario
     */
    public function obtener_impuestosxdocproveedor_no_afecta_inv_consolida($where = null, $groupby = null, $orderby = null, $dxd_id = null, $where2 = null)
    {
        $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('IMPUESTOS'));

        $cadena1 = '
             dpv_id,
             cxe_id_tcn,
             cxe_id_cnt,
             imp_porcentaje,
             SUM((imp_porcentaje / 100) * dxd_subtotal) AS subtotximpcuenta,
             dxd_subtotal, 
             (
                    SELECT
                        cnt_id
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = cxe_id_cnt
             ) cuenta_id,
             (
                    SELECT
                        cnt_cuenta
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = cxe_id_cnt
             ) cuenta,
             /* (
                    SELECT
                        cnt_id_cnt_padre
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = cxe_id_cnt
            ) padre, */
             (
                    SELECT
                        cnt_nombre
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = cxe_id_cnt
             ) cuenta_nombre,
             dxd_id
        ';

        $cadena = $cadena1;

        $query = $this->db->select($cadena, FALSE)
            ->from('dxd_detalle_documento_proveedor')
            ->join('dpv_documento_proveedor', 'dpv_id = dxd_id_dpv')
            ->join('idd_impuestoxdetalle_documento', 'dxd_id = idd_id_dxd')
            ->join('imp_impuesto', 'idd_id_imp = imp_id')
            ->join('cxe_cuentaximpuesto', 'idd_id_imp = cxe_id_imp  AND cxe_id_cec = dpv_id_cec AND cxe_id_tif = dpv_id_tif', 'left')
            ->having('ISNULL(cxe_id_tcn) OR cxe_id_tcn = ' . $tcn_id, false)
            //->where('dpv_afecta_inventario = 0')
            ->where('dpv_id_pct IS NULL');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }

    /**
     * Descripción:
     * Función que obtiene el haber para los documentos por proveedor consolidada
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-04-25
     * @param Ninguno
     * @return Devuelve los haber para la partida consolidada
     */
    public function obtener_haber_docproveedor_consolida($where = null, $groupby = null, $orderby = null)
    {
        $tipo_defecto   = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO', 0, null, null);
        $tcn_id_contado = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', 0, null, array('CAJA'));
        $tcn_id_pagar_ = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', 0, null, array('CUENTA_POR_PAGAR'));
        $tcn_id_contado = ($tcn_id_contado != null) ? $tcn_id_contado : $tipo_defecto;
        $tcn_id_pagar = ($tcn_id_pagar_ != null) ? $tcn_id_pagar_ : $tipo_defecto;

        $where_tipo_tcn = ($tcn_id_pagar_ > 0) ? " AND dfp2.dfp_id_tcn = " . $tcn_id_pagar_ : '';

        $select_consolidado =
            "
            DISTINCT(dpv1.dpv_id),
            dpv1.dpv_id,
            SUM(dpv1.dpv_total /* - dpv1.dpv_retencion */) as total,
            (
                    SELECT tpg_nombre
                    FROM tpg_tipo_pago
                    WHERE tpg_id = dpv1.dpv_id_tpg
            ) AS tpg_nombre,
            (
                    SELECT cnt2.cnt_id
                    FROM dpv_documento_proveedor AS dpv2
                    LEFT JOIN prv_proveedor AS prv2 ON dpv2.dpv_id_prv = prv2.prv_id
                    LEFT JOIN dfp_detalle_finanza_proveedor AS dfp2 ON prv2.prv_id = dfp2.dfp_id_prv
                    LEFT JOIN tpg_tipo_pago AS tpg2 ON dfp2.dfp_id_tpg = tpg2.tpg_id
                    LEFT JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = dfp2.dfp_id_cnt      
                    WHERE dfp2.dfp_id_tpg = dpv1.dpv_id_tpg
                    AND tpg2.tpg_id = dpv1.dpv_id_tpg
                    AND dpv2.dpv_id = dpv1.dpv_id
                    $where_tipo_tcn
                    LIMIT 1
            ) AS cuenta_id,
            (
                    SELECT cnt2.cnt_cuenta
                    FROM dpv_documento_proveedor AS dpv2
                    LEFT JOIN prv_proveedor AS prv2 ON dpv2.dpv_id_prv = prv2.prv_id
                    LEFT JOIN dfp_detalle_finanza_proveedor AS dfp2 ON prv2.prv_id = dfp2.dfp_id_prv
                    LEFT JOIN tpg_tipo_pago AS tpg2 ON dfp2.dfp_id_tpg = tpg2.tpg_id
                    LEFT JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = dfp2.dfp_id_cnt      
                    WHERE dfp2.dfp_id_tpg = dpv1.dpv_id_tpg
                    AND tpg2.tpg_id = dpv1.dpv_id_tpg
                    AND dpv2.dpv_id = dpv1.dpv_id
                    $where_tipo_tcn
                    LIMIT 1
            ) AS cnt_cuenta,
            (
                    SELECT cnt2.cnt_nombre
                    FROM dpv_documento_proveedor AS dpv2
                    LEFT JOIN prv_proveedor AS prv2 ON dpv2.dpv_id_prv = prv2.prv_id
                    LEFT JOIN dfp_detalle_finanza_proveedor AS dfp2 ON prv2.prv_id = dfp2.dfp_id_prv
                    LEFT JOIN tpg_tipo_pago AS tpg2 ON dfp2.dfp_id_tpg = tpg2.tpg_id
                    LEFT JOIN cnt_cuenta_contable AS cnt2 ON cnt2.cnt_id = dfp2.dfp_id_cnt      
                    WHERE dfp2.dfp_id_tpg = dpv1.dpv_id_tpg
                    AND tpg2.tpg_id = dpv1.dpv_id_tpg
                    AND dpv2.dpv_id = dpv1.dpv_id
                    $where_tipo_tcn
                    LIMIT 1
            ) AS cnt_nombre                
        ";

        //$select_consolidado = " ";
        $select = $select_consolidado;
        //print_r($select); die();
        $query = $this->db->select($select, false)
            ->from('dpv_documento_proveedor AS dpv1')
            ->join('prv_proveedor AS prv1', 'prv1.prv_id = dpv1.dpv_id_prv', 'left')
            // ->join('dfp_detalle_finanza_proveedor', 'prv_id = dfp_id_prv', 'left')             
            //->join('tpg_tipo_pago', 'dfp_id_tpg = tpg_id', 'left')
            //->join('cnt_cuenta_contable', 'cnt_id = dfp_id_cnt', 'left')
            // ->where('dpv1.dpv_afecta_inventario = 0')
            ->where('dpv1.dpv_id_pct IS NULL');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        return $query->get()->result_array();
    }

    /*************************************************************************/
    /**
     * Descripción:
     * Función que obtiene las facturas 
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-07-02
     * @param Ninguno
     * @return Devuelve las retenciones por factura
     */
    public function obtener_reten_factura($where = null, $groupby = null, $orderby = null)
    {
        $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('RETENCIONES'));
        //print_r($where);die();
        //print_r($tcn_ida); die();
        //$tcn_id = 17;
        if ($orderby) { //Es por detalles        
            $query = $this->db->select("fac_id, fac_id_origen_devolucion, 
                    dcr_id_tcn,
                    ret_porcentaje,
                    rxf_id_ret,
                    SUM(
                        (ret_porcentaje / 100) * def_subtotal
                    ) AS subtotxretcuentabk,
                    SUM(IF ( fac_id_origen_devolucion IS NULL,rxf_monto, rxf_monto * -1)) AS subtotxretcuenta,
                    def_subtotal,
                 IF (ISNULL(dcr_id_cnt),0,dcr_id_cnt) AS dcr_id_cnt,
                 (
                    SELECT
                        cnt_cuenta
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = dcr_id_cnt
                        and dcr_id_ret = ret_id 
                        and dcr_id_cec = fac_id_cec
                        LIMIT 1
                 ) cuenta,
                 (
                    SELECT
                        cnt_nombre
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = dcr_id_cnt 
                        and dcr_id_ret = ret_id 
                        and dcr_id_cec = fac_id_cec
                        LIMIT 1
                ) cuenta_nombre
                ", false)
                ->from('def_detalle_fact')
                ->join('fac_factura', 'fac_id = def_id_fac')
                ->join('rxf_retencionxdetalle_factura', 'def_id = rxf_id_def')
                ->join('ret_retencion', 'rxf_id_ret = ret_id')
                ->join('dcr_detalle_cuenta_retencion', 'rxf_id_ret = dcr_id_ret AND dcr_id_cec = fac_id_cec', 'left')
                //->having('ISNULL(cxe_id_tcn) OR cxe_id_tcn = '.$tcn_id,false)
                //->limit(50)
            ;
            $this->db->where('fac_id_pct IS NULL');
            if ($where != null) {
                $this->db->where($where);
            }

            if ($groupby != null) {
                $this->db->group_by($groupby);
            }

            if ($orderby != null) {
                $this->db->order_by($orderby);
            }
        } else { //Consolidado
            $query = "
                SELECT  a.def_id, 
                        a.fac_id, 
                        a.cxe_id_tcn, 
                        a.imp_porcentaje, 
                        sum(a.subtotximpcuenta) AS subtotximpcuenta,
                        a.def_subtotal,
                        a.cxe_id_cnt,
                        a.cuenta,
                        a.cuenta_nombre,
                        a.cxe_id_cnt                
                FROM
                (
                SELECT
                    def_id,
                    fac_id,
                    cxe_id_tcn,
                    imp_porcentaje,
                    (
                    (imp_porcentaje / 100) * def_subtotal
                    ) AS subtotximpcuenta,
                    def_subtotal,

                IF (
                    ISNULL(cxe_id_cnt),
                    0,
                    cxe_id_cnt
                ) AS cxe_id_cnt,
                 (
                    SELECT
                        cnt_cuenta
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = cxe_id_cnt
                ) cuenta,
                 (
                    SELECT
                        cnt_nombre
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = cxe_id_cnt
                ) cuenta_nombre
                FROM
                    (def_detalle_fact)
                JOIN fac_factura ON fac_id = def_id_fac
                JOIN ixf_impuestoxfactura ON def_id = ixf_id_def
                JOIN imp_impuesto ON ixf_id_imp = imp_id
                LEFT JOIN cxe_cuentaximpuesto ON ixf_id_imp = cxe_id_imp
                WHERE
                    fac_id_pct IS NULL
                AND DATE(fac_fecha_cont) = '" . $where['DATE(fac_fecha_cont)'] . "'
                AND fac_id_pct IS NULL
                GROUP BY fac_id
                -- GROUP BY `cxe_id_cnt`,`cuenta_nombre`
                -- HAVING ISNULL(cxe_id_tcn) OR cxe_id_tcn = " . $tcn_id . "
                LIMIT 50
                ) a
            ";
        }

        if ($orderby) { //Es por detalles            
            return  $query->get()->result_array();
        } else {
            return  $this->db->query($query)->result_array();
        }
        // print_r($this->db->last_query());die(); 
    }

    /***************************************************************************************/

    /**
     * Descripción:
     * Función que obtiene las facturas 
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-07-24
     * @param Ninguno
     * @return Devuelve los titulos y cuentas principales para el reporte
     */
    public function get_titulos_cuentas_principales($where = null)
    {
        $groupby = "cfr_id";
        $orderby = "cfr_orden";
        /****************************************************************************************/
        // SE AUMENTA EL LIMITE DEL GROUPCONCAT EN LA CONSULTA PARA CASOS DE CUENTAS CON DEMASIADAS HIJAS
        $this->db->simple_query("SET SESSION group_concat_max_len = 30000");
        /****************************************************************************************/
        $query = $this->db->select(
            "                            
                    cfr_id,
                    cfr_id_rep,
                    cfr_id_padre,
                    cfr_titulo,
                    cfr_orden,
                    cfr_grupo,
                    cfr_subrayado,
                    cfr_operacion,
                    cfr_alineacion,
                    GROUP_CONCAT(cxf_id_cnt) cuentas
            ",
            false
        )
            ->from('cfr_configuracion_reporte')
            ->join('cxf_cuentaxconfiguracion', 'cxf_id_cfr = cfr_id', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby, 'ASC');
        }

        return $query->get()->result_array();
    }

    /************OTRO************/
    /**
     * Descripción:
     * Función que obtiene las facturas 
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-07-24
     * @param Ninguno
     * @return Devuelve los titulos y cuentas principales para el reporte
     */
    public function get_total_hijos($padre = null, $where = null, $idreporte = null)
    {
        $total = 0;
        $hijos = $this->get_titulos_cuentas_principales(array('cfr_id_rep' => $idreporte, 'cfr_id_padre' => $padre, 'cfr_estado' => 1));
        /*******************************************************************/

        foreach ($hijos as $m => $hijo) {
            $new_array_id = explode(",", $hijo['cuentas']);
            /******************************************************************/
            $new_array_id2 = $this->get_todos_hijos_existentes_cuentas($new_array_id);
            $new_array_id2 .= implode(',', $new_array_id);
            $new_array_id2 = explode(',', $new_array_id2);
            $new_array_id2 = array_filter($new_array_id2, 'strlen');
            $total_padre_e_hijo = $this->get_total_cuentapadre_cuentashijas_reportes($new_array_id, $where);
            if ($hijo['cfr_operacion'] == '+') {
                $total += (isset($total_padre_e_hijo[0]['total'])) ? $total_padre_e_hijo[0]['total'] : 0;
                $total += $this->get_total_hijos($hijo['cfr_id'], $where, $idreporte);
            } else {
                $total -= (isset($total_padre_e_hijo[0]['total'])) ? $total_padre_e_hijo[0]['total'] : 0;
                $total -= $this->get_total_hijos($hijo['cfr_id'], $where, $idreporte);
            }
        }
        return $total;
    }

    public function get_total_hijos2($padre = null, $where = null, $idreporte = null, $where2 = null)
    {
        $total = 0;
        $hijos = $this->get_titulos_cuentas_principales(array('cfr_id_rep' => $idreporte, 'cfr_id_padre' => $padre, 'cfr_estado' => 1));
        /*******************************************************************/

        foreach ($hijos as $m => $hijo) {
            $new_array_id = explode(",", $hijo['cuentas']);
            /******************************************************************/
            $new_array_id2 = $this->get_todos_hijos_existentes_cuentas($new_array_id);
            $new_array_id2 .= implode(',', $new_array_id);
            $new_array_id2 = explode(',', $new_array_id2);
            $new_array_id2 = array_filter($new_array_id2, 'strlen');
            $total_padre_e_hijo = $this->get_total_cuentapadre_cuentashijas_reportes2($new_array_id, $where, $where2);
            var_dump($total_padre_e_hijo);
            if ($hijo['cfr_operacion'] == '+') {
                $s_ant = (isset($total_padre_e_hijo[1]['anterior'])) ? $total_padre_e_hijo[1]['anterior'] : 0;
                $total += (isset($total_padre_e_hijo[0]['total'])) ? $total_padre_e_hijo[0]['total'] : 0;
                $total += $this->get_total_hijos($hijo['cfr_id'], $where, $idreporte);
            } else {
                $total -= (isset($total_padre_e_hijo[0]['total'])) ? $total_padre_e_hijo[0]['total'] : 0;
                $total -= $this->get_total_hijos($hijo['cfr_id'], $where, $idreporte);
            }
        }
        return $total;
    }

    //Aqui se obtienen todos los hijos y subhijo de una cuenta padre
    public function get_todos_hijos_existentes_cuentas($where_in)
    {
        $query = $this->db->select("cnt_id", false)
            ->from('cnt_cuenta_contable');
        $this->db->where_in("cnt_id_cnt_padre", $where_in);
        $elementos_string = $query->get()->result_array();
        $elementos_string = array_column($elementos_string, 'cnt_id');
        $b = $elementos_string;
        if (count($b) > 0) {
            $elementos = implode(",", $elementos_string);
            $re = $elementos;
            $re .= (count($where_in) > 0) ? "," : "";
            $re .= $this->get_todos_hijos_existentes_cuentas($b);
            return $re;
        }
    }

    /****************************************************************************/
    //El parametro $agrupar determina si se agrupa o no
    function get_planilla_x_tipo($where)
    {
        $this->db->select('tpl_id, pla_id, tpl_nombre, pla_fecha_inicio, pla_fecha_fin', false)
            ->from('pla_planilla')
            ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl')
            ->where($where); //id del tipo de planilla                    
        $result = $this->db->get();
        return $result->result_array();
    }

    /**
     * @author: Mario Marquez
     * @since: 22/10/2018
     * @param type $configuracion_partida
     */
    function crear_partida($configuracion_partida)
    {

        //Se verifica que el array de configuracion venga lleno
        if ($configuracion_partida != null && count($configuracion_partida) > 1) {
            //Se obtienen los datos de la partida

            /*
             * Se verifica el concepto de la partida. Si el campo "pct_concepto" es numerico se coloca el valor configurado
             * De lo contrario, se coloca el campo directamente en el concepto de la partida
             */
            $concepto_partida = "";

            if ($configuracion_partida['partida']['pct_concepto'] != null && is_numeric($configuracion_partida['partida']['pct_concepto'])) {
                $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => $configuracion_partida['partida']['pct_concepto']));

                if (count($pct_concepto) > 0) {
                    $concepto_partida = $pct_concepto[0]['ccp_descripcion_concepto'];
                } else {
                    $concepto_partida = 'Concepto no definido';
                }
            } else {
                $concepto_partida = $configuracion_partida['partida']['pct_concepto'];
            }

            /*
             * Se verifica el tipo de la partida. Si el campo "pct_id_tpd" es numerico se coloca el valor configurado
             * De lo contrario, se busca por el nombre del tipo de partida:
             * EXISTENCIA, INGRESO, COSTO, GASTO, REBAJAS, DEVOLUCIONES, ANTICIPOS
             */
            $tipo_partida = 0;
            if ($configuracion_partida['partida']['pct_id_tpd'] != null && !is_numeric($configuracion_partida['partida']['pct_id_tpd'])) {
                $consulta_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array($configuracion_partida['partida']['pct_id_tpd']));
                $tipo_partida = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_id', array('tpd_id' => $consulta_tipo_partida));
            } else {
                $tipo_partida = $configuracion_partida['partida']['pct_id_tpd'];
            }

            //Se obtiene el correlativo de la partida
            $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1;

            /*
             * El codigo de partida se concatenara junto al correlativo. Si no viene vacio se concatenara separado de un 
             * guion
             */
            $codigo_partida = ($configuracion_partida['partida']['pct_codigo'] == '') ? $correlativo_partida : $configuracion_partida['partida']['pct_codigo'] . ' - ' . $correlativo_partida;

            $partida_array = array(
                'pct_id_tpd' => $tipo_partida,
                'pct_concepto' => $concepto_partida,
                'pct_total' => number_format($configuracion_partida['partida']['pct_total'], 4, '.', ''),
                'pct_fecha' => $configuracion_partida['partida']['pct_fecha'],
                'pct_correlativo' => $correlativo_partida,
                'pct_codigo' => $codigo_partida,
                'pct_estado' => 1,
                'pct_fecha_crea' => date('Y-m-d H:i:s'),
                'pct_fecha_mod' => date('Y-m-d H:i:s'),
                'pct_usu_crea' => $this->tank_auth->get_user_id(),
                'pct_usu_mod' => $this->tank_auth->get_user_id()
            );

            //Se ingresa la partida
            $pct_id = $this->gsatelite->ingresar('pct_partida_contable', $partida_array);

            //Se recorren los detalles de a partida
            if (count($configuracion_partida['detalle_partida']) > 0) {

                /*
                 * El Array esta compuesto por dos propiedades "detalle_debe" y "detalle_haber"
                 * Estos se recorren para generar todos los detalles de la partida
                 */
                //Se recorren los DEBE
                foreach ($configuracion_partida['detalle_partida']['detalle_debe'] as $debe) {
                    $array_detalle = array(
                        'dpc_id_cnt' => $debe['dpc_id_cnt'],
                        'dpc_id_pct' => $pct_id,
                        'dpc_concepto' => $debe['dpc_concepto'],
                        'dpc_debe' => $debe['dpc_monto'], //debe
                        'dpc_haber' => 0.00,
                        'dpc_estado' => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                        'dpc_usu_mod' => $this->tank_auth->get_user_id()
                    );

                    $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }

                //Se recorren los HABER
                foreach ($configuracion_partida['detalle_partida']['detalle_haber'] as $haber) {
                    $array_detalle = array(
                        'dpc_id_cnt' => $haber['dpc_id_cnt'],
                        'dpc_id_pct' => $pct_id,
                        'dpc_concepto' => $haber['dpc_concepto'],
                        'dpc_debe' => 0.00,
                        'dpc_haber' => $haber['dpc_monto'],
                        'dpc_estado' => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                        'dpc_usu_mod' => $this->tank_auth->get_user_id()
                    );

                    $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }
            }

            /*
             * Para asociar la partida a su proceso origen, viene un campo en la variable
             * "$configuracion_partida['partida']['tabla_responsable']" y "$configuracion_partida['partida']['registro_responsable']"
             * Donde se a hara el update para asociar la partida a la tabla
             */

            $tabla_responsable = $configuracion_partida['partida']['tabla_responsable'];
            $inicial_responsable = reset(explode('_', $tabla_responsable));
            $campo_primario_responsable = $inicial_responsable . '_id';

            $responsable_array = array(
                $inicial_responsable . '_id_pct' => $pct_id
            );

            $where_responsable = array(
                $campo_primario_responsable => $configuracion_partida['partida']['registro_responsable']
            );

            $this->gsatelite->actualizar_array($tabla_responsable, $responsable_array, $where_responsable);
        }
    }

    /**
     * @author: Mario Marquez
     * @descripcion: Se obtienen los detalles prorrateados de un Documento por Proveedor para una salida de inventario
     * @return: Listado de cuentas para salida de documento por proveedor
     */

    function get_cuentas_doc_proveedor_salida_inv_debe($where = null)
    {

        $query = $this->db->select("
                tia_id,
                tia_nombre,
                art_nombre,
                (
                    SELECT
                        IF (ISNULL(cnt_id), 0, cnt_id) AS cnt_id
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = pxd_id_cnt         
                    GROUP BY
                        cnt_id
                    LIMIT 1
                ) AS cnt_id,
                (
                    SELECT
                        CONCAT(cnt_cuenta,' - ',cnt_nombre)
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = pxd_id_cnt     
                    GROUP BY
                        cnt_id
                    LIMIT 1
                ) AS cnt_nombre,
                SUM(CASE WHEN pxd_porcentaje > 0 THEN  (dxd_subtotal * (pxd_porcentaje/100)) 
                ELSE dxd_subtotal END) AS subtotal_prod,
                dxd_id
            ", false)
            ->from('moi_movimiento_inv')
            //->join('dee_detalle_mov', 'dee_id_moi = moi_id', 'inner')
            ->join('dpv_documento_proveedor', 'dpv_id = moi_id_dpv', 'inner')
            ->join('tip_tipo_proceso', 'tip_id = moi_id_tip', 'inner')
            ->join('dxd_detalle_documento_proveedor', 'dpv_id = dxd_id_dpv', 'inner')
            ->join('art_articulo', 'dxd_id_art = art_id', 'inner')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id', 'inner')
            ->join('pxd_prorrateoxdetalle_documento', 'pxd_id_dxd = dxd_id', 'left')
            ->join('ctp_cuenta_tipo_proceso', 'ctp_id_tip = moi_id_tip AND ctp_id_bod = moi_id_bod AND ctp_id_cec = pxd_id_cec', 'left')
            ->group_by('cnt_id');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author: Mario Marquez
     * @descripcion: Se obtienen los detalles prorrateados de un Documento por Proveedor para una salida de inventario
     * @return: Listado de cuentas para salida de documento por proveedor
     */

    function get_cuentas_doc_proveedor_salida_inv_haber($where = null)
    {

        $query = $this->db->select("
                tia_id,
                tia_nombre,
                art_nombre,
                (
                    SELECT
                        IF (ISNULL(cnt_id), 0, cnt_id) AS cnt_id
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = dta_id_cnt         
                    GROUP BY
                        cnt_id
                    LIMIT 1
                ) AS cnt_id,
                (
                    SELECT
                        CONCAT(cnt_cuenta,' - ',cnt_nombre)
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = dta_id_cnt     
                    GROUP BY
                        cnt_id
                    LIMIT 1
                ) AS cnt_nombre,
                SUM(DISTINCT dee_subtotal) AS subtotal_prod
            ", false)
            ->from('moi_movimiento_inv')
            ->join('dee_detalle_mov', 'dee_id_moi = moi_id', 'inner')
            ->join('tip_tipo_proceso', 'tip_id = moi_id_tip', 'inner')
            ->join('art_articulo', 'dee_id_art = art_id', 'inner')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id', 'inner')
            ->join('dta_detalle_tipoarticulo', 'dta_id_tia = tia_id AND dta_id_bod = moi_id_bod', 'left')
            ->group_by('cnt_id');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author: René Castaneda
     * @since: 15-01-2019
     * @return: saldo anterior a x fecha sobre una cuenta contable de forma recursiva
     */
    public function get_saldo_anterior_cuenta($where = null, $return_query = 0, $aplica_codigo = 0)
    {
        $resultado['monto_debe'] = 0;
        $resultado['monto_haber'] = 0;
        $resultado['cuentas_partida'] = '';
        $resultado['fecha_inicio'] = '';
        $resultado['fecha_fin'] = '';
        $resultado['nivel'] = '';
        $resultado['padre'] = '';
        $script_codigo = ($aplica_codigo) ? "CONCAT_WS('',
            (SELECT GROUP_CONCAT( DISTINCT CONCAT(' - Cheque #',che_numero )) from che_cheque where che_id_pct = pct_id),
            (SELECT GROUP_CONCAT( DISTINCT CONCAT(' - Comprobante # ',tra_comprobante )) from tra_transaccion where tra_id_pct = pct_id)
            )" : "''";
        $q = $this->db->select("*, IFNULL(SUM(ROUND(IFNULL(dpc_debe,0),2)),0) monto_debe, IFNULL(SUM(ROUND(IFNULL(dpc_haber,0),2)),0) monto_haber, 
            GROUP_CONCAT(DISTINCT dpc_id_cnt) cuentas_partida, DATE(MIN(pct_fecha)) fecha_inicio, DATE(MAX(pct_fecha)) fecha_fin,
            CONCAT(IFNULL(GROUP_CONCAT(DISTINCT pct_id),0),',') ids_partidas
            , $script_codigo AS codigo_dependiente
             ", false)
            ->from('dpc_detalle_partida')
            ->join('pct_partida_contable', 'pct_id = dpc_id_pct')
            ->join('cnt_cuenta_contable', 'cnt_id = dpc_id_cnt')
            ->join('pcc_partida_centro_costo', 'pcc_id = dpc_id_pcc', 'left')
            ->where('pct_estado', 1);

        if ($where) {
            $this->db->where($where);
        }
        if ($return_query) {
            return $q->get()->result_array();
        }
        $query = $q->get()->row_array();
        if ($query) {
            /* $resultado['monto_debe'] = ($query['monto_debe'] > 0)? $query['monto_debe']:0;
            $resultado['monto_haber'] = ($query['monto_haber'] > 0)? $query['monto_haber']:0;*/
            $resultado['monto_debe'] = ($query['monto_debe'] != 0) ? $query['monto_debe'] : 0;
            $resultado['monto_haber'] = ($query['monto_haber'] != 0) ? $query['monto_haber'] : 0;
            $resultado['cuentas_partida'] = $query['cuentas_partida'];
            $resultado['fecha_inicio'] = $query['fecha_inicio'];
            $resultado['fecha_fin'] = $query['fecha_fin'];
            $resultado['nivel'] = $query['cnt_id_nic'];
            $resultado['padre'] = $query['cnt_id_cnt_padre'];
        }

        return $resultado;
        // foreach ($query as $fila) {
        //     $date1 = (trim($fila['fecha_inicio']) !='')? new DateTime($fila['fecha_inicio']):'';
        //     $date2 = (trim($fila['fecha_fin']) !='')? new DateTime($fila['fecha_fin']):'';

        //     $resultado['monto_debe'] += $fila['debe'];
        //     $resultado['monto_haber'] += $fila['haber'];
        //     $resultado['monto_diferencia'] += ($fila['debe'] - $fila['haber']);
        //     $resultado['cuentas_partida'] = $fila['cuentas_partida'];
        //     $resultado['fecha_inicio'] = ($date1!='')? $date1:$fila['fecha_inicio'];
        //     $resultado['fecha_fin'] = ($date2!='')? $date2:$fila['fecha_fin'];
        //     $n_resultado = $this->get_saldo_anterior_cuenta($fila['cnt_id'],$where);

        //     $date_1 = (trim($n_resultado['fecha_inicio']) !='')? new DateTime($n_resultado['fecha_inicio']):'';
        //     $date_2 = (trim($n_resultado['fecha_fin']) !='')? new DateTime($n_resultado['fecha_fin']):'';

        //     $resultado['monto_debe'] +=  $n_resultado['monto_debe'];
        //     $resultado['monto_haber'] +=  $n_resultado['monto_haber'];
        //     $resultado['monto_diferencia'] +=  $n_resultado['monto_diferencia'];
        //     $resultado['cuentas_partida'] .= $n_resultado['cuentas_partida'];
        //     $resultado['fecha_inicio'] = ($date_1!='' && $date_1 < $date1 )? $date_1:$date1;
        //     $resultado['fecha_fin'] = ($date_2!=''  && $date_2 > $date2 )? $date_2:$date2;
        // }

        // return $resultado;

    }

    public function get_debe_haber_anterior_cuenta($where = null)
    {
        $query = $this->db->select("SUM(ROUND(IFNULL(dpc_debe,0),2)) AS monto_debe, SUM(ROUND(IFNULL(dpc_haber,0),2)) AS monto_haber", false)
            ->from('dpc_detalle_partida')
            ->join('pct_partida_contable', 'pct_id = dpc_id_pct')
            ->join('cnt_cuenta_contable', 'cnt_id = dpc_id_cnt ')
            ->join('pcc_partida_centro_costo', 'pcc_id = dpc_id_pcc', 'left')
            ->where('pct_estado', 1);
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author: René Castaneda
     * @since: 16-01-2019
     * @return: ids_cuentas hijas
     */
    public function get_ids_cuentas_hijas($id_padre = null, $where = null)
    {
        $cadena_ids = "";
        if ($where) {
            $this->db->where($where);
        }
        $q = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre' => $id_padre));
        if ($q) {
            foreach ($q as $fila) {
                $cadena_ids .= $fila['cnt_id'] . ',';
                $cadena_ids .= $this->get_ids_cuentas_hijas($fila['cnt_id'], $where);
            }
        }
        return $cadena_ids;
    }

    /**
     * @author: Francisco Orozco
     * @since: 28-01-2019
     * @return: devuelve los saldos anteriores
     */
    public function get_saldos_anteriores($select = "", $where = null, $group_by = null)
    {
        $select = ($select != "") ? ", " . $select : "";
        $query = $this->db->select('SUM(dpc_debe) as Debe, SUM(dpc_haber) as Haber ' . $select, false)
            ->from('cnt_cuenta_contable')
            ->join('dpc_detalle_partida', 'dpc_id_cnt=cnt_id')
            ->join('pct_partida_contable', 'dpc_id_pct=pct_id');

        if ($where != null) {
            $this->db->where($where);
        }
        if ($group_by != null) {
            $this->db->group_by($group_by);
        }
        return $query->get()->result_array();
    }

    /**
     * @author: René Castaneda
     * @since: 31-01-2019
     * @return: información para generar la partida contable en base a cheque pendiente planilla
     */
    public function get_cheque_pendiente_info($where)
    {
        $defecto_cnt = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $tipo_cuenta_banco = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('BANCOS'));

        $query = $this->db->select("che_cheque.*,
                IFNULL(emp_id_cnt,'$defecto_cnt') cuenta_empleado,
                CONCAT_WS(' ','cheque planilla #',che_numero, emp_nombre, emp_apellido) concepto,
                IFNULL((
                SELECT cxb_id_cnt from cxb_cuentaxcuenta_bancaria
                WHERE cxb_id_cub = cub_id AND cxb_id_tcn = '$tipo_cuenta_banco'
                LIMIT 1
                ),'$defecto_cnt') cuenta_banco", false)
            ->from('chp_cheque_pendiente')
            ->join('che_cheque', 'che_id = chp_id_che')
            ->join('chq_chequera', 'che_id = chp_id_che', 'left')
            ->join('cub_cuenta_bancaria', 'cub_id = chq_id_cub', 'left')
            ->join('emp_empleado', 'emp_id = chp_id_emp')
            ->group_by('che_id')
            ->limit(1);
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->row_array();
    }

    public function get_libros_ventas($where)
    {
        $id_iva = $this->gsatelite->get_parametro('SYS_ID_IVA');
        $dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI', 0);
        $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT', 0);
        $tvns = $this->gsatelite->get_parametro_emp('SYS_TPV_NO_SUJETA', 0);
        $query = $this->db->select("fac_factura.*, 0 AS correlativo, fac_estado estado_factura, CONCAT(fac_id_tif,DATE_FORMAT(fac_fecha_fact,'%d%m%Y')) AS codigo_fecha,
                CONCAT(fac_id_tif,'-',DATE_FORMAT(fac_fecha_fact, '%d%m%Y'),'-',IF(fac_estado = 0,'A',(IF(fac_impuesto=0,'E','N')))) AS codigo_fecha_estado,
                DATE_FORMAT(fac_fecha_fact,'%d-%m-%Y') AS fecha, tif_abreviacion, caj_nombre, caj_numero_registradora,
                (SELECT sef_resolucion FROM sef_serie_factura WHERE sef_id = cof_id_sef AND sef_id_tif = tif_id) AS num_resolucion, cof_inicio, cof_fin,
                (SELECT sef_nombre FROM sef_serie_factura JOIN cof_correlativo_factura ON cof_id_sef = sef_id WHERE sef_id_tif = fac_id_tif AND cof_id = fac_id_cof 
                    ORDER BY sef_fecha_resolucion DESC LIMIT 1) AS serie, fac_numero numero, 
                ROUND((SELECT IF(((def_impuesto = 0 OR def_impuesto IS NULL OR def_impuesto = '') AND (def_id_tpv IS NOT NULL AND def_id_tpv = $tvns)), SUM(def_subtotal), 0) FROM def_detalle_fact WHERE def_id_fac = fac_id), 4) AS venta_no_sujeta,
                ROUND((SELECT IF(((def_impuesto = 0 OR def_impuesto IS NULL OR def_impuesto = '') AND (def_id_tpv <> $tvns OR def_id_tpv IS NULL)), SUM(def_subtotal), 0 ) FROM def_detalle_fact WHERE def_id_fac = fac_id AND def_impuesto = 0), 4) AS total_venta_exenta,
                ROUND((SELECT IF((def_impuesto = 0 OR def_impuesto IS NULL OR def_impuesto = ''), 0, SUM(def_subtotal)) FROM def_detalle_fact WHERE def_id_fac = fac_id AND  def_impuesto <> 0 ), 4) AS total_venta_gravado,
                ROUND((SELECT SUM(IFNULL(ixf_monto,0)) FROM ixf_impuestoxfactura JOIN def_detalle_fact ON ixf_id_def = def_id WHERE ixf_id_imp = $id_iva AND def_id_fac = fac_id),4) AS impuesto_fac,
                ROUND(IF(fac_id_tif IN (" . $where['ids_exportacion'] . "), (SELECT SUM(def_subtotal) FROM def_detalle_fact WHERE def_id_fac = fac_id), 0), 2) AS fac_exportaciones,
                (SELECT IF(cli_personeria > 1,cli_apellido,CONCAT_WS(' ',cli_nombre,cli_apellido)) FROM cli_cliente WHERE cli_id = fac_id_cli) AS cli_nombre,
                IFNULL(fac_documento_cliente, IFNULL((SELECT dcc_valor FROM dcc_documento_cliente WHERE dcc_id_cli = fac_id_cli AND dcc_estado = 1 AND dcc_id_tde = $dui), (SELECT dcc_valor FROM dcc_documento_cliente WHERE dcc_id_cli = fac_id_cli AND dcc_estado = 1 AND dcc_id_tde = $nit))) AS documento_cliente,
                IF(fac_id_tif = 18, fac_total_retencion *(-1),fac_total_retencion) AS retencion_fac,
                IF(fac_id_tif = 18, fac_subtotal *(-1),fac_subtotal) AS subtotal_fac,
                IF(fac_id_tif = 18, fac_total *(-1),fac_total) AS venta_total, caj_id", false)
            ->from("fac_factura")
            ->join("tif_tipo_factura", "tif_id = fac_id_tif")
            ->join("uxc_usuarioxcaja", "uxc_id = fac_id_uxc")
            ->join("caj_caja", "caj_id = uxc_id_caj", 'LEFT')
            ->join("cof_correlativo_factura", "cof_id = fac_id_cof", 'LEFT')
            ->group_by('fac_id')
            ->order_by("caj_id,fac_id_tif,cof_id_sef,fac_numero", 'ASC');
        unset($where['ids_exportacion']);
        if ($where) {
            $this->db->where($where);
        }
        // $this->db->where('fac_estado !=', 0);

        return $query->get()->result_array();
        //return $this->db->last_query();
    }

    public function get_libros_ventas_agrupado($where){
        $id_iva = $this->gsatelite->get_parametro('SYS_ID_IVA');        
        $tvns = $this->gsatelite->get_parametro_emp('SYS_TPV_NO_SUJETA', 0);
        $query = $this->db->select("DATE(f.fac_fecha_cont) AS fac_fecha_cont, MIN(f.fac_numero_control) AS nmin, MAX(f.fac_numero_control) AS nmax, tif_abreviacion, tif_codigo_fact_elect,
            (SELECT s.fac_codigo_generacion FROM fac_factura AS s WHERE DATE(s.fac_fecha_cont) = DATE(f.fac_fecha_cont) ORDER BY fac_fecha_crea ASC LIMIT 1) AS firstdte,
            (SELECT s.fac_codigo_generacion FROM fac_factura AS s WHERE DATE(s.fac_fecha_cont) = DATE(f.fac_fecha_cont) ORDER BY fac_fecha_crea DESC LIMIT 1) AS lastdte,
            SUM(IF(f.fac_estado = 0, 0, (SELECT IF(((def_id_tpv <> $tvns OR def_id_tpv IS NULL) AND (def_impuesto = 0 OR def_impuesto IS NULL OR def_impuesto = '')), SUM(ABS(def_subtotal)), 0) FROM def_detalle_fact WHERE def_id_fac = f.fac_id AND def_impuesto = 0))) AS total_venta_exenta,
            SUM(IF(f.fac_estado = 0, 0, (SELECT IF(def_impuesto = 0 OR def_impuesto IS NULL OR def_impuesto = '',0, SUM(ABS(def_subtotal))) FROM def_detalle_fact WHERE def_id_fac = f.fac_id AND def_impuesto <> 0))) AS total_venta_gravado,
            SUM(IF(f.fac_estado = 0, 0, (SELECT SUM(ABS(IFNULL(ixf_monto, 0))) FROM ixf_impuestoxfactura JOIN def_detalle_fact ON ixf_id_def = def_id WHERE ixf_id_imp = $id_iva AND def_id_fac = f.fac_id))) AS impuesto_fac,
            SUM(IF(f.fac_estado = 0, 0, (SELECT IF(def_id_tpv = $tvns AND (def_impuesto = 0 OR def_impuesto IS NULL OR def_impuesto = ''), SUM(ABS(def_subtotal)), 0) FROM def_detalle_fact WHERE def_id_fac = f.fac_id AND def_impuesto = 0 ))) AS venta_no_sujeta,
            SUM(IF(f.fac_estado = 0, 0, (IF(f.fac_id_tif IN (" . $where['ids_exportacion'] . "), (SELECT SUM(ABS(def_subtotal)) FROM def_detalle_fact WHERE def_id_fac = f.fac_id), 0)))) AS fac_exportaciones,
            SUM(IF(f.fac_estado = 0, 0, (IF(f.fac_id_tif IN (" . $where['ids_exportacion'] . "), (SELECT SUM(ABS(def_subtotal)) FROM def_detalle_fact JOIN fac_factura AS s ON s.fac_id = def_id_fac JOIN cli_cliente ON cli_id = s.fac_id_cli JOIN pai_pais ON pai_id = cli_id_pai WHERE pai_codigo_fact_elect IN ('GT', 'HN', 'NI', 'SV', 'CR')), 0)))) AS fac_exportaciones_centroamerica,
            SUM(IF(f.fac_estado = 0, 0, (IF(f.fac_id_tif IN (" . $where['ids_exportacion'] . "), (SELECT SUM(ABS(def_subtotal)) FROM def_detalle_fact JOIN fac_factura AS s ON s.fac_id = def_id_fac JOIN cli_cliente ON cli_id = s.fac_id_cli JOIN pai_pais ON pai_id = cli_id_pai WHERE pai_codigo_fact_elect NOT IN ('GT', 'HN', 'NI', 'SV', 'CR')), 0)))) AS fac_exportaciones_mundial,
            SUM(IF(f.fac_estado = 0, 0, ABS(f.fac_total_retencion))) AS retencion_fac, 
            SUM(IF(f.fac_estado = 0, 0, ABS(f.fac_subtotal))) AS subtotal_fac, 
            SUM(IF(f.fac_estado = 0, 0, ABS(f.fac_total))) AS venta_total, caj_nombre, caj_id", false)
            ->from("fac_factura AS f")
            ->join("tif_tipo_factura", "tif_id = f.fac_id_tif")
            ->join("uxc_usuarioxcaja", "uxc_id = f.fac_id_uxc")
            ->join("caj_caja", "caj_id = uxc_id_caj")
            ->join("cof_correlativo_factura", "cof_id = f.fac_id_cof", 'LEFT')
            ->group_by('DATE(f.fac_fecha_cont), caj_id, f.fac_id_tif')
            ->order_by("DATE(f.fac_fecha_cont), caj_id, f.fac_id_tif", 'ASC')
        ;
        unset($where['ids_exportacion']);
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
        //return $this->db->last_query();
    }


    /**
     * @author: René Castaneda
     * @since: 06-03-2019
     * @descripcion: Se obtienen los detalles  de un Documento por Proveedor para una salida de inventario
     * @return: Listado de cuentas para salida de documento por proveedor
     */

    function get_cuentas_doc_proveedor_salida_inv_haber_dpv($where = null)
    {

        $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('EXISTENCIA'));
        $nombre_defecto = "";
        $query = $this->db->select("
                tia_id,
                tia_nombre,
                art_nombre,
                (
                SELECT dta_id_cnt FROM dta_detalle_tipoarticulo 
                WHERE dta_id_tia = art_id_tia AND dta_id_tcn = $tcn_id LIMIT 1
                ) AS cnt_id,
                (
                 SELECT cnt_nombre FROM dta_detalle_tipoarticulo 
                 JOIN cnt_cuenta_contable on cnt_id = dta_id_cnt
                WHERE dta_id_tia = art_id_tia AND dta_id_tcn = $tcn_id LIMIT 1
                ) AS cuenta_nombre,
                SUM(dxd_subtotal) AS subtotal_prod", false)
            ->from('dpv_documento_proveedor')
            ->join('dxd_detalle_documento_proveedor', 'dpv_id = dxd_id_dpv', 'inner')
            ->join('art_articulo', 'dxd_id_art = art_id', 'inner')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id', 'inner')
            ->group_by('cnt_id');

        if ($where != null) {
            $this->db->where($where);
        }

        $resultado = $query->get()->result_array();


        return $resultado;
    }

    /**
     * @author: René Castaneda
     * @since: 24-04-2019
     * @descripcion: Se obtiene el detalle de las facturas para generar partida consolidada
     * @return: Result query (array)
     */
    public function obtener_productosxfactura_consolidada_new($where = null, $groupby = null, $orderby = null){
        $id_pais_defecto = $this->tank_auth->get_all_empresa()->emr_id_pai;
        $id_cnt_defecto =  $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $registro_cuenta_def = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $id_cnt_defecto));
        $num_cuenta_defecto = $registro_cuenta_def[0]['cnt_cuenta'];
        $nombre_cuenta_defecto = $registro_cuenta_def[0]['cnt_nombre'];
        $idtipo_cnt_tpg1 = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CAJA'));
        $idtipo_cnt_tpg2 = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('INGRESO'));
        $idtipo_cnt_excenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('INGRESO_EXENTA'));
        $idtipo_cnt_excenta = ($idtipo_cnt_excenta > 0) ? $idtipo_cnt_excenta : 0;
        // $this->db->query("SET GLOBAL group_concat_max_len=4194304;");
        // $query = $this->db->select(
        //     "fac_id,
        //     GROUP_CONCAT(DISTINCT fac_id) AS facturas, 
        //     tia_id,
        //     tia_nombre,
        //     art_nombre,
        //     IFNULL((
        //     SELECT dcf2.dcf_id_cnt
        //     FROM dcf_detalle_centrocostoxfactura AS dcf2
        //     JOIN dta_detalle_tipoarticulo ON dta_id_cec = dcf2.dcf_id_cec AND dta_id_pai = IFNULL(dcf_id_pai,'$id_pais_defecto')
        //     WHERE dcf2.dcf_id_def = def_id AND dcf_id_tcn = IF(IFNULL(def_impuesto,0)>0,'$idtipo_cnt_tpg2','$idtipo_cnt_excenta')  AND dta_id_tia = tia_id LIMIT 1
        //     ),'$id_cnt_defecto') AS cuenta_id,
        //     IFNULL((
        //     SELECT cnt_cuenta
        //     FROM dcf_detalle_centrocostoxfactura AS dcf2
        //     JOIN cnt_cuenta_contable ON dcf2.dcf_id_cnt = cnt_id
        //     JOIN dta_detalle_tipoarticulo ON dta_id_cec = dcf2.dcf_id_cec AND dta_id_pai = IFNULL(dcf_id_pai,'$id_pais_defecto')
        //     WHERE dcf2.dcf_id_def = def_id AND dcf_id_tcn = IF(IFNULL(def_impuesto,0)>0,'$idtipo_cnt_tpg2','$idtipo_cnt_excenta')   AND dta_id_tia = tia_id LIMIT 1
        //     ),'$num_cuenta_defecto') AS cuenta,
        //     IFNULL((
        //     SELECT cnt_nombre
        //     FROM dcf_detalle_centrocostoxfactura AS dcf2
        //     JOIN cnt_cuenta_contable ON dcf2.dcf_id_cnt = cnt_id
        //     JOIN dta_detalle_tipoarticulo ON dta_id_cec = dcf2.dcf_id_cec AND dta_id_pai = IFNULL(dcf_id_pai,'$id_pais_defecto')
        //     WHERE dcf2.dcf_id_def = def_id AND dcf_id_tcn = IF(IFNULL(def_impuesto,0)>0,'$idtipo_cnt_tpg2','$idtipo_cnt_excenta')  AND dta_id_tia = tia_id LIMIT 1
        //     ),'$nombre_cuenta_defecto') AS cuenta_nombre,
        //     SUM(IFNULL(dcf_monto,0)) subTotal_dcf,
        //     SUM(IFNULL(def_subtotal,0)) subTotal_def,
        //     SUM( IF( ISNULL(dcf_monto), IFNULL(def_subtotal, 0), IF(dcf_monto = def_subtotal, dcf_monto, def_subtotal) ) - def_retencion) subTotal_dcf2,
        //     SUM(IFNULL(dcf_monto,(def_subtotal))) AS subtotal_prod,
        //     def_id id_def
        //     ", false)
        //      ->from('fac_factura')
        //      ->join('def_detalle_fact', 'fac_id = def_id_fac')
        //      ->join('dcf_detalle_centrocostoxfactura AS dcf1', 'dcf1.dcf_id_def = def_id','LEFT')
        //      ->join('art_articulo', 'def_id_art = art_id')
        //      ->join('tia_tipo_articulo', 'art_id_tia = tia_id')
        //     ;
        $multiplo_negativo = 1;
        $cadena = '
            fac_id, GROUP_CONCAT(DISTINCT fac_id) AS facturas,
            IFNULL(
            SUM( 
            IF(
            ( SELECT SUM( IF ( fac_id_origen_devolucion IS NULL, dcf_monto, dcf_monto * "' . $multiplo_negativo . '" )) FROM dcf_detalle_centrocostoxfactura WHERE dcf_id_def = def_id ) != def_subtotal
            , 
            
            IF ( fac_id_origen_devolucion IS NULL, def_subtotal, def_subtotal * "' . $multiplo_negativo . '" ) /* - IFNULL( IF ( fac_id_origen_devolucion IS NULL, def_retencion, def_retencion * "' . $multiplo_negativo . '" ), 0.00 ) */
            
            , 
            ( SELECT SUM( IF ( fac_id_origen_devolucion IS NULL, dcf_monto, dcf_monto * "' . $multiplo_negativo . '" ) /* - IFNULL( IF ( fac_id_origen_devolucion IS NULL, def_retencion, def_retencion * "' . $multiplo_negativo . '" ), 0.00 ) */ ) FROM dcf_detalle_centrocostoxfactura WHERE dcf_id_def = def_id )
            ) 
            ),
            SUM( IF ( fac_id_origen_devolucion IS NULL, def_subtotal, def_subtotal * "' . $multiplo_negativo . '" ) ) 
            ) AS subTotal_dcf2,
             IFNULL(
              (SELECT
              IFNULL(cnt_id, 0) AS cnt_id
              FROM
               dcf_detalle_centrocostoxfactura AS dcf2
              JOIN cnt_cuenta_contable ON dcf2.dcf_id_cnt = cnt_id
              JOIN dta_detalle_tipoarticulo ON dta_id_cec = dcf2.dcf_id_cec
              WHERE              
                dta_id_tcn = IF(IFNULL(IF (fac_id_origen_devolucion IS NULL,def_impuesto,def_impuesto * "' . $multiplo_negativo . '"),0) != 0,"' . $idtipo_cnt_tpg2 . '","' . $idtipo_cnt_excenta . '")
              AND 
                dcf2.dcf_id_def = def_id
              AND
               dta_id_tia = tia_id
              GROUP BY
               cnt_id
              LIMIT 1
             ),' . $id_cnt_defecto . ') AS cuenta_id,
             IFNULL((
              SELECT
               cnt_cuenta
              FROM
               dcf_detalle_centrocostoxfactura AS dcf2
              JOIN cnt_cuenta_contable ON dcf2.dcf_id_cnt = cnt_id
              JOIN dta_detalle_tipoarticulo ON dta_id_cec = dcf2.dcf_id_cec
             WHERE              
               dta_id_tcn = IF(IFNULL(IF (fac_id_origen_devolucion IS NULL,def_impuesto,def_impuesto * "' . $multiplo_negativo . '"),0) != 0,"' . $idtipo_cnt_tpg2 . '","' . $idtipo_cnt_excenta . '")
             AND 
               dcf2.dcf_id_def = def_id
             AND
               dta_id_tia = tia_id
              GROUP BY
               cnt_id
              LIMIT 1
             ),"' . $num_cuenta_defecto . '") AS cuenta,
             IFNULL((
              SELECT
               cnt_nombre
              FROM
                dcf_detalle_centrocostoxfactura AS dcf2
              JOIN cnt_cuenta_contable ON dcf2.dcf_id_cnt = cnt_id
              JOIN dta_detalle_tipoarticulo ON dta_id_cec = dcf2.dcf_id_cec
              WHERE              
                dta_id_tcn = IF(IFNULL(IF (fac_id_origen_devolucion IS NULL,def_impuesto,def_impuesto * "' . $multiplo_negativo . '"),0) != 0,"' . $idtipo_cnt_tpg2 . '","' . $idtipo_cnt_excenta . '")
              AND
               dcf2.dcf_id_def = def_id
              AND
               dta_id_tia = tia_id
              GROUP BY
               cnt_id
              LIMIT 1
             ),"' . $nombre_cuenta_defecto . '") AS cuenta_nombre,
             
             def_id AS id_def
            ';

        $query = $this->db->select($cadena, FALSE)
            ->from('def_detalle_fact')
            // ->join('dcf_detalle_centrocostoxfactura AS dcf1', 'dcf1.dcf_id_def = def_id')
            ->join('fac_factura', 'fac_id = def_id_fac')
            ->join('art_articulo', 'def_id_art = art_id')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id')
            //->where('fac_id',115) //descomentar para seguimiento a un id en especifico
            //->limit(50)
        ;
        $this->db->where('def_subtotal !=', 0);
        if ($where != null) {
            $this->db->where($where);
        } else {
            $this->db->where('fac_id_pct IS NULL');
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        } else {
            //$this->db->group_by('cuenta_id');
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }

        $return_query  =  $query->get()->result_array();
        //print_r($this->db->last_query()); echo " ===";   
        //die();
        return $return_query;
    }

    /**
     * Descripción:
     * Conculta para imprimir partidas contables ordenas por detalle de cuentas
     * @author Nelson Soriano
     * @since  29-07-2019
     * @param  id cuenta contable
     * @return Registros de cuentas por detalle
     */
    function get_partida_por_detalle($id_pct)
    {
        $this->db->select('
                    cnt_id,
                    pct_id,
                    pct_concepto,
                    tpd_nombre,
                    cnt_cuenta,
                    cnt_nombre,
                    dpc_concepto,
                    dpc_debe,
                    pct_fecha,
                    dpc_haber,
                    cnt_id_nic,
                    cnt_id_cnt_padre,
                    sum(dpc_debe) as sum_debe,
                    SUM(dpc_haber) as sum_haber,
                    cnt_id_cnt_padre as padre,
                    (
                        SELECT concat(c.cnt_cuenta,"-",c.cnt_nombre) from cnt_cuenta_contable c 
                        where c.cnt_id = a.cnt_id_cnt_padre
                    ) as cuenta_padre
                ', false)
            ->from('pct_partida_contable')
            ->join('dpc_detalle_partida', 'dpc_id_pct  = pct_id', 'left')
            ->join('cnt_cuenta_contable a', 'a.cnt_id      = dpc_id_cnt', 'left')
            ->join('tpd_tipo_partida', 'tpd_id         = pct_id_tpd', 'left')
            ->join('pcc_partida_centro_costo', 'pcc_id = dpc_id_pcc', 'left')
            ->join('cec_centro_costo', 'cec_id         = pcc_id_cec', 'left')
            ->where('pct_id', $id_pct);
        $this->db->group_by('cnt_id', 'cnt_id_cnt_padre');
        $this->db->order_by('sum_debe', 'DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    /**
     * Descripción:
     * Función que obtiene las retenciones
     * @author Francisco ORozco - Grupo Satélite
     * @since 2019-08-29
     * @param Ninguno
     * @return Devuelve las retenciones por documento por proveedor cuando no afecta inventario
     */
    public function obtener_retencioensxdocproveedor_no_afecta_inv($where = null, $groupby = null, $orderby = null, $dxd_id = null, $where2 = null)
    {
        /*$tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('RETENCIONES'));
        if ( $tcn_id == null) {
            $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO',0,null,null);
        }*/
        $cadena1 = '
            dpv_id, 
             (SELECT
             cnt_id
             FROM
             cnt_cuenta_contable
             JOIN dcr_detalle_cuenta_retencion on dcr_id_cnt = cnt_id
             WHERE
             dcr_id_ret = rxd_id_ret
             LIMIT 1
             ) dcr_id_cnt, 
            ret_porcentaje, 
            SUM(rxd_monto) AS subtotxretencion, dxd_subtotal, 
            (
             SELECT
             cnt_id
             FROM
             cnt_cuenta_contable
             JOIN dcr_detalle_cuenta_retencion on dcr_id_cnt = cnt_id
             WHERE
             dcr_id_ret = rxd_id_ret
             LIMIT 1
             ) cuenta_id, (
             SELECT
             cnt_cuenta
             FROM
             cnt_cuenta_contable
             JOIN dcr_detalle_cuenta_retencion on dcr_id_cnt = cnt_id
             WHERE
             dcr_id_ret = rxd_id_ret
             LIMIT 1
             ) cuenta, (
             SELECT
             cnt_nombre
             FROM
             cnt_cuenta_contable
             JOIN dcr_detalle_cuenta_retencion on dcr_id_cnt = cnt_id
             WHERE
             dcr_id_ret = rxd_id_ret
             LIMIT 1
             ) cuenta_nombre, dxd_id';

        $cadena = $cadena1;

        $query = $this->db->select($cadena, FALSE)
            ->from('dxd_detalle_documento_proveedor')
            ->join('dpv_documento_proveedor', 'dpv_id = dxd_id_dpv')
            ->join('rxd_retencionxdetalle_documento', 'dxd_id = rxd_id_dxd')
            ->join('ret_retencion', 'rxd_id_ret = ret_id')
            ->where('dpv_id_pct IS NULL')

            // ->where(' dcr_id = (
            //     SELECT
            //         t1.dcr_id
            //     FROM
            //         dcr_detalle_cuenta_retencion as t1
            //     WHERE
            //         t1.dcr_id_ret = rxd_id_ret
            //     LIMIT 1
            // )',null,false)
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        $resultado_query = $query->get()->result_array();
        // echo $this->db->last_query(); die(); 
        return $resultado_query;
    }

    /**
     * Descripción:
     * Función para calcular renta complementaria (Reporte).
     * Se utiliza para el reporte de renta y el reporte de renta complementaria.
     * @author Edit herrrera - Grupo Satélite
     * @since  2019-09-10
     * @param  ninguno
     * @return Consulta de renta según tabla asociada a la planilla.
     */
    public function get_isr_planilla($where = null, $group = null, $year = null, $tipo = 0)
    {
        $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
        $bon = $this->gsatelite->get_parametro('INGRESO_BONIFICACIONES');
        $agi = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');
        $isr = $this->gsatelite->get_parametro('DESCUENTO_ISR');
        $iss = $this->gsatelite->get_parametro('DESCUENTO_ISS');
        $afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
        $ingreso = array();
        array_push($ingreso, $this->gsatelite->get_parametro('INGRESO_SALARIO'));
        array_push($ingreso, $this->gsatelite->get_parametro('INGRESO_HED'));
        array_push($ingreso, $this->gsatelite->get_parametro('INGRESO_HEN'));
        array_push($ingreso, $this->gsatelite->get_parametro('INGRESO_VACACIONES'));
        $devengado = implode(',', $ingreso);
        if ($tipo == 0) {
            $formato_de_fecha = '%Y';
        } else {
            $formato_de_fecha = '%m-%Y';
        }
        if ($year != null) {
            $query = $this->db->select("emp_id, emp_codigo, CONCAT(emp_apellido,', ',emp_nombre) AS empleado, emp_es_jubilado,
                    IFNULL(
                        (SELECT MAX(dce_valor) FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = $dui),
                        (SELECT MAX(dce_valor) FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = $nit)
                    ) AS nit,
                    (SELECT MAX(dce_valor) FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = $nit) AS doc_nit,
                    (SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla p ON ddi_id_pla = p.pla_id 
                        WHERE ddi_id_emp = emp_id AND p.pla_estado = 3 AND DATE_FORMAT(p.pla_fecha_inicio, '" . $formato_de_fecha . "') = $year AND ddi_id_tig IN ( $devengado ) ) AS devengado,
                    IFNULL(
                        (SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso d1 JOIN pla_planilla p1 ON d1.ddi_id_pla = p1.pla_id 
                            WHERE ddi_id_emp = emp_id AND DATE_FORMAT(pla_fecha_corte, '" . $formato_de_fecha . "') = $year AND ddi_id_tig = $bon)
                    ,0) as bonificaciones,
                    (SELECT sum(ddd_valor) FROM ddd_detalle_descuento d3 join pla_planilla p3 on d3.ddd_id_pla = p3.pla_id 
                        WHERE d3.ddd_id_emp = emp_id  AND d3.ddd_id_tdc = $isr) AS renta_old,
                    SUM(ddd_valor) AS renta,
                    IFNULL(
                        (SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso d2 JOIN pla_planilla p2 on d2.ddi_id_pla = p2.pla_id 
                            WHERE d2.ddi_id_emp = emp_id AND DATE_FORMAT(pla_fecha_corte, '" . $formato_de_fecha . "') = $year AND ddi_id_tig = $agi)
                    ,0) as aguinaldo,
                    IFNULL(
                        (SELECT SUM(ddd_valor) FROM ddd_detalle_descuento d3 join pla_planilla p3 on d3.ddd_id_pla = p3.pla_id 
                            WHERE d3.ddd_id_emp = emp_id  AND d3.ddd_id_tdc = $iss AND p3.pla_estado = 3 AND DATE_FORMAT(p3.pla_fecha_inicio, '" . $formato_de_fecha . "') = $year )
                    ,0) as isss,
                    IFNULL(
                        (SELECT sum(ddd_valor) FROM ddd_detalle_descuento d3 join pla_planilla p3 on d3.ddd_id_pla = p3.pla_id 
                            WHERE d3.ddd_id_emp = emp_id  AND d3.ddd_id_tdc = $afp AND p3.pla_estado = 3 AND DATE_FORMAT(p3.pla_fecha_inicio, '" . $formato_de_fecha . "') = $year )
                    ,0) as afp,
                    (SELECT afp_codigo FROM afp_afp WHERE afp_id = emp_id_afp) AS afp_codigo,
                    ddd_id_pla, MONTH( pla_fecha_inicio) AS mes, ddd_id_tdc, tdc_nombre, ddd_dias_descuento, ddd_ingreso_afecto, ddd_valor, 
                    SUM(ddd_ingreso_afecto) as ingreso, 
                    SUM(ddd_valor) AS isr, 
                    SUM(((SELECT SUM(d2.ddi_valor) from ddi_detalle_ingreso d2 where d2.ddi_id_pla=pla_id and d2.ddi_id_emp=emp_id AND DATE_FORMAT(ddi_fecha_mod,'" . $formato_de_fecha . "') = $year)
             )) AS total", FALSE);
        } else {
            $query = $this->db->select("emp_id, emp_codigo, CONCAT(emp_apellido,', ',emp_nombre) AS empleado, emp_es_jubilado,
                    ddd_id_pla, MONTH( pla_fecha_inicio) AS mes, ddd_id_tdc, tdc_nombre, ddd_dias_descuento, ddd_ingreso_afecto, 
                    ddd_valor, SUM(ddd_ingreso_afecto) as ingreso , SUM(ddd_valor) AS isr ", FALSE);
        }
        $this->db->from('emp_empleado')
            ->join('txe_tipo_planillaxempleado', 'emp_id = txe_id_emp')
            ->join('tpl_tipo_planilla', 'txe_id_tpl = tpl_id')
            ->join('pla_planilla', 'pla_id_tpl = tpl_id')
            ->join('ddd_detalle_descuento', 'pla_id = ddd_id_pla AND ddd_id_emp = emp_id')
            ->join('tdc_tipo_descuento', 'ddd_id_tdc = tdc_id')
            ->where('pla_estado', 3);

        if ($where != null) {
            $this->db->where($where);
        }

        if ($group != null) {
            $this->db->group_by($group);
        } else {
            $this->db->group_by('emp_id, MONTH( pla_fecha_inicio)');
        }
        $this->db->order_by('emp_apellido, MONTH( pla_fecha_inicio)', 'ASC');

        return $query->get()->result_array();
    }

    public function get_f910_01($where = null, $having = null, $year = 0, $tipo = 0)
    {
        if ($tipo == 0) {
            $formato_de_fecha = '%Y';
        } else {
            $formato_de_fecha = '%m-%Y';
        }
        $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
        $bon = $this->gsatelite->get_parametro('INGRESO_BONIFICACIONES');
        $agi = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');
        $tag = $this->gsatelite->get_parametro('AGRUPADOR_ISR');
        $isr = $this->gsatelite->get_parametro('DESCUENTO_ISR');
        $iss = $this->gsatelite->get_parametro('DESCUENTO_ISS');
        $afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
        $resultado = array();
        $query = $this->db->select("emp_id, CONCAT(emp_apellido, ', ', emp_nombre) AS empleado,  emp_es_jubilado, (SELECT MAX(dce_valor) FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = $nit) as nit,
                IFNULL((SELECT MAX(dce_valor) FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = $dui), (SELECT MAX(dce_valor) FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = $nit)) AS documento,
                IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_estado = 3
                AND DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "') = '$year' AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag = $tag AND deg_id_tig IS NOT NULL 
                AND deg_id_tig <> $agi)), 0) AS devengado, IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla 
                WHERE ddi_id_emp = emp_id AND pla_estado = 3 AND DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "') = '$year' AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador
                WHERE deg_id_tag = $tag AND deg_id_tig IS NOT NULL)), 0) AS total_anual, IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento
                JOIN pla_planilla ON pla_id = ddd_id_pla WHERE ddd_id_emp  = emp_id AND pla_estado = 3 AND DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "') = '$year' 
                AND ddd_id_tdc = $afp), 0) AS total_afp, IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento JOIN pla_planilla ON pla_id = ddd_id_pla 
                WHERE ddd_id_emp  = emp_id AND pla_estado = 3 AND DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "') = '$year' AND ddd_id_tdc = $iss), 0) AS total_isss, 
                IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla  WHERE ddi_id_emp = emp_id AND pla_estado = 3
                AND DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "') = '$year' AND ddi_id_tig = $agi),0) AS aguinaldo, IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento 
                JOIN pla_planilla ON pla_id = ddd_id_pla WHERE ddd_id_emp = emp_id AND pla_estado = 3 AND DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "') = '$year' 
                AND ddd_id_tdc = $isr),0) AS total_isr, (SELECT afp_codigo FROM afp_afp WHERE afp_id = emp_id_afp) AS afp_codigo, IFNULL(NULL,0) AS gratificaciones,
                IFNULL(NULL,0) AS cefafa, IFNULL(NULL,0) AS bien_magist", false)
            ->from("emp_empleado")
            ->where("(emp_estado = 1 OR (emp_estado = 0 AND DATE_FORMAT(emp_fecha_retiro,'" . $formato_de_fecha . "') = '$year'))")
            ->having("total_anual > 0")
            ->order_by("emp_apellido, emp_nombre ASC");
        if ($where) {
            $this->db->where($where);
        }
        //-- HAVING devengado != 0
        $empleados = $query->get()->result_array();
        // var_dump($this->db->last_query());die();
        if (count($empleados) > 0) {
            foreach ($empleados as $k => $val) {
                $resultado[$val['emp_id']] = $val;
                $resultado[$val['emp_id']]['meses_afp'] = $this->get_afp_mensual(array('ddd_id_emp' => $val['emp_id'], "DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "')" => $year), 1);
                $resultado[$val['emp_id']]['meses_isr'] = $this->get_isr_mensual(array('ddd_id_emp' => $val['emp_id'], "DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "')" => $year));
            }
        }
        return $resultado;
    }

    public function get_f910_11($where = null, $having = null, $year = 0, $tipo = 0)
    {
        if ($tipo == 0) {
            $formato_de_fecha = '%Y';
        } else {
            $formato_de_fecha = '%m-%Y';
        }
        $isr = $this->gsatelite->get_parametro('DESCUENTO_ISR10');
        $tag = $this->gsatelite->get_parametro('AGRUPADOR_ISR10');
        $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
        $bon = $this->gsatelite->get_parametro('INGRESO_BONIFICACIONES');
        $query = $this->db->select("emp_id, CONCAT(emp_apellido, ', ', emp_nombre) AS empleado,  emp_es_jubilado, IFNULL(NULL,0) AS total_isss, IFNULL(NULL,0) AS total_afp,
                IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_estado = 3
                AND DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "') = '$year'), 0) AS total_anual, IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla
                WHERE ddi_id_emp = emp_id AND pla_estado = 3 AND DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "') = '$year' AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador 
                WHERE deg_id_tag = $tag AND deg_id_tig IS NOT NULL AND deg_id_tig <> $bon)), 0) AS devengado, IFNULL((SELECT MAX(dce_valor) FROM dce_documento_emp 
                WHERE dce_id_emp = emp_id AND dce_id_tde = $dui), (SELECT MAX(dce_valor) FROM dce_documento_emp WHERE dce_id_emp = emp_id AND dce_id_tde = $nit)) AS documento,
                IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento JOIN pla_planilla ON pla_id = ddd_id_pla WHERE ddd_id_emp = emp_id AND pla_estado = 3 
                AND DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "') = '$year' AND ddd_id_tdc = $isr),0) AS total_isr, IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso 
                JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_emp = emp_id AND pla_estado = 3 AND DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "') = '$year' 
                AND ddi_id_tig = $bon), 0) AS gratificaciones, NULL AS meses_afp, NULL AS meses_isr,
                IFNULL(NULL,0) AS aguinaldo, '' AS afp_codigo, IFNULL(NULL,0) AS cefafa, IFNULL(NULL,0) AS bien_magist", false)
            ->from("emp_empleado")
            ->join("ddd_detalle_descuento", "ddd_id_emp = emp_id AND ddd_id_tdc = $isr")
            ->join("pla_planilla", "pla_id = ddd_id_pla AND DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "') = '$year'")
            ->where("(emp_estado = 1 OR (emp_estado = 0 AND DATE_FORMAT(emp_fecha_retiro,'" . $formato_de_fecha . "') = '$year'))")
            ->group_by("emp_id")
            ->order_by("emp_apellido, emp_nombre ASC");
        if ($where) {
            $this->db->where($where);
        }
        $empleados = $query->get()->result_array();

        if (count($empleados) > 0) {
            foreach ($empleados as $k => $val) {
                $resultado[$val['emp_id']] = $val;
                $resultado[$val['emp_id']]['meses_afp'] = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
                $resultado[$val['emp_id']]['meses_isr'] = $this->get_isr_mensual(array('ddd_id_emp' => $val['emp_id'], "DATE_FORMAT(pla_fecha_inicio,'" . $formato_de_fecha . "')" => $year), 1);
            }
        }
        return $resultado;
    }

    public function get_isr_mensual($where = null, $tipo_isr = 0)
    {
        $valores = array();
        $isr = ($tipo_isr > 0) ? $this->gsatelite->get_parametro('DESCUENTO_ISR10') : $this->gsatelite->get_parametro('DESCUENTO_ISR');
        for ($i = 1; $i <= 12; $i++) {
            $this->db->select("IFNULL(SUM(ddd_valor), 0) AS isr_mes, IFNULL(SUM(ddd_ingreso_afecto), 0) AS afecto", false)
                ->from('ddd_detalle_descuento')
                ->join('pla_planilla', 'ddd_id_pla = pla_id')
                ->where('pla_estado', 3)
                ->where('MONTH(pla_fecha_inicio)', $i)
                ->where('ddd_id_tdc', $isr);
            if ($where) {
                $this->db->where($where);
            }
            $result = $this->db->get()->row();
            $valores[$i]['afecto'] = $result->afecto;
            $valores[$i]['mensual'] = $result->isr_mes;
        }
        return $valores;
    }

    /**
     * Descripción:
     * Función para calcular renta complementaria (Reporte).
     * Se utiliza para el reporte de renta y el reporte de renta complementaria.
     * @author Francisco Orozco - Grupo Satélite
     * @since  2019-09-10
     * @param  ninguno
     * @return Consulta de renta según tabla asociada a la planilla.
     */
    public function get_planilla_proveedores($where = null, $group = null, $year = null, $renta = null)
    {
        if ($year != null) {
            $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
            $query = $this->db->select("prv_codigo, prv_id,dpv_fecha_contabilizacion, MONTH( dpv_fecha_contabilizacion) AS mes,
                    IF ( prv_tipo_pers = 1, CONCAT(prv_nombre, ' ', prv_apellido), prv_apellido) AS proveedor,
                    (SELECT dcp_valor FROM dcp_documento_proveedor WHERE dcp_id_prv = prv_id AND dcp_id_tde = $nit) AS nit,
                    SUM(IFNULL(dpv_retencion, 0)) AS retenciones,
                    sum(dpv_total) as total", FALSE);
        } else {
            $query = $this->db->select('prv_codigo, prv_id,
                    dpv_fecha_contabilizacion, MONTH( dpv_fecha_contabilizacion) AS mes,
                    IF ( prv_tipo_pers = 1,
                        CONCAT_WS(
                            " ",
                            prv_nombre,
                            prv_apellido
                        ),                
                        prv_apellido
                    ) AS proveedor,
                    sum(dpv_total) as total', FALSE);
        }

        $this->db->from('dpv_documento_proveedor')
            ->join('dxd_detalle_documento_proveedor', 'dxd_id_dpv = dpv_id')
            ->join('prv_proveedor', 'prv_id = dpv_id_prv');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($renta != null) {
            $this->db->where('dxd_id IN', ' (SELECT rxd_id_dxd FROM rxd_retencionxdetalle_documento WHERE rxd_id_ret = ' . $renta . ') ', FALSE);
        }

        if ($group != null) {
            $this->db->group_by($group);
        }
        $this->db->order_by('prv_nombre, MONTH( dpv_fecha_contabilizacion)', 'ASC');
        return $query->get()->result_array();
    }

    public function get_conta_centro_costo($fecha_ini, $fecha_fin)
    {
        $cadena = "cec_codigo, cec_nombre, IFNULL( (SELECT SUM(fac_total) FROM fac_factura WHERE cec_id = fac_id_cec AND fac_estado > 0 AND fac_fecha_fact BETWEEN ' $fecha_ini ' 
        AND ' $fecha_fin '), 0) AS facturacion, IFNULL( (SELECT SUM(dpv_total) FROM dpv_documento_proveedor  WHERE cec_id = dpv_id_cec AND dpv_estado > 0  
        AND dpv_fecha_documento BETWEEN ' $fecha_ini ' AND ' $fecha_fin '), 0) AS compras";
        $query = $this->db->select($cadena, FALSE)
            ->from('cec_centro_costo')
            ->group_by('cec_id')
            ->having('facturacion > 0 OR compras > 0');
        return $query->get()->result_array();
    }

    /**
     * @author René Castaneda
     * @since 27/10/2019
     * @method Se obtiene los abonos a quienes se les hará partida contable
     */
    public function get_pago_cliente_partida($where = null, $group_by = null)
    {
        $this->db->select("
                GROUP_CONCAT(DISTINCT DATE_FORMAT(abc_fecha,'%Y%m%d')) fecha_codigo,
                GROUP_CONCAT(DISTINCT abc_id) id_referencia,
                GROUP_CONCAT(DISTINCT IFNULL((SELECT GROUP_CONCAT(DISTINCT anl_id) from anl_anticipo_cliente where anl_id_cli = abc_id_cli AND 
                 anl_id_abc_origen = abc_id AND anl_id_pct IS NULL), '0'))  id_referencia_otros,
                CONCAT_WS(' ','Pago Factura(s) #:',(IF('$group_by'='abc_id',CONCAT(GROUP_CONCAT(DISTINCT fac_numero),' (',(SELECT IF(cli_personeria > 1,cli_apellido,CONCAT(cli_nombre,' ',cli_apellido)) FROM cli_cliente WHERE cli_id = abc_id_cli),')'), CONCAT_WS(' ',(MIN(fac_numero)),' a ', (MAX(fac_numero)))) ) ) concepto_partida,
                (SUM(abf_monto) + SUM(IFNULL(( SELECT SUM(anl_monto) from anl_anticipo_cliente where anl_id_abc_origen = abc_id AND anl_id_pct IS NULL ), 0)) )   AS total_partida
                ", false)
            ->from('abc_abono_cliente')
            ->join('abf_abono_factura', 'abf_id_abc=abc_id')
            ->join('fac_factura', 'fac_id=abf_id_fac')
            ->where('fac_estado > 0');
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }


        $datos_query = $this->db->get()->result_array();
        //print_r($this->db->last_query());die();
        return $datos_query;
    }

    /**
     * @author René Castaneda
     * @since 27/10/2019
     * @method Se obtiene los abonos (debe) a quienes se les hará partida contable
     */
    public function get_pago_cliente_partida_debe($where = null, $where2 = null, $group_by = 'abc_id')
    {

        // Cuenta contable por defecto
        $defecto_cnt_reg = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
        $defecto_cnt = $defecto_cnt_reg[0]['cnt_id'];
        $defecto_cnt_nombre = $defecto_cnt_reg[0]['cnt_nombre'];
        $defecto_cnt_cuenta = $defecto_cnt_reg[0]['cnt_cuenta'];

        $tcn_id_debe = (isset($where2['tcn_id_debe']) && $where2['tcn_id_debe'] > 0) ? $where2['tcn_id_debe'] : 0;

        $this->db->select("
                GROUP_CONCAT(DISTINCT DATE_FORMAT(abc_fecha,'%Y%m%d')) fecha_codigo,
                abc_id id_referencia,
                GROUP_CONCAT(DISTINCT IFNULL((SELECT GROUP_CONCAT(DISTINCT anl_id) from anl_anticipo_cliente where anl_id_cli = abc_id_cli AND 
                 anl_id_abc_origen = abc_id AND anl_id_pct IS NULL), '0')) id_referencia_otros,
                (SUM(abf_monto) + SUM(IFNULL(( SELECT SUM(anl_monto) from anl_anticipo_cliente where anl_id_abc_origen = abc_id AND anl_id_pct IS NULL ), 0)) ) - SUM(IFNULL(abc_anticipo,0)) AS total_debe,
                0.00 AS total_haber,
                IFNULL((
                    SELECT
                        cnt_id
                    FROM
                        cli_cliente
                    JOIN cxn_cuentaxcliente ON cli_id = cxn_id_cli
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cli_id = fac_id_cli
                    AND cxn_id_tcn = " . $tcn_id_debe . "
                    AND cxn_id_tpg = fac_id_tpg
                    LIMIT 1
                ),'$defecto_cnt') AS cnt_id,
                IFNULL((
                    SELECT
                        cnt_cuenta
                    FROM
                        cli_cliente
                    JOIN cxn_cuentaxcliente ON cli_id = cxn_id_cli
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cli_id = fac_id_cli
                    AND cxn_id_tcn = " . $tcn_id_debe . "
                    AND cxn_id_tpg = fac_id_tpg
                    LIMIT 1
                ),'$defecto_cnt_cuenta') AS cuenta,
                IFNULL((
                    SELECT
                        cnt_nombre
                    FROM
                        cli_cliente
                    JOIN cxn_cuentaxcliente ON cli_id = cxn_id_cli
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cli_id = fac_id_cli
                    AND cxn_id_tcn = " . $tcn_id_debe . "
                    AND cxn_id_tpg = fac_id_tpg
                    LIMIT 1
                ),'$defecto_cnt_nombre') AS cnt_nombre
                ", false)
            ->from('abc_abono_cliente')
            ->join('abf_abono_factura', 'abf_id_abc=abc_id')
            ->join('fac_factura', 'fac_id=abf_id_fac');
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }


        $datos_query = $this->db->get()->result_array();
        //echo $this->db->last_query(); die();
        return $datos_query;
    }

    /***************************************************************/
    /**
     * @author Mario Marquez
     * @since 02/02/2020
     * @method Se obtiene los montos por detalles de abono (dab_detalle_abono) y segregar estos montos
     */
    public function get_pago_cliente_partida_debe_detalle_abono($where = null, $groupby = null)
    {
        //Se verifica si el abono no tiene configuración a detalle de abonos por cuentas bancadias
        // $query_detalle_abono = "
        //     SELECT 
        //         NULL as fac_id,
        //         dab_monto AS total_abonar,
        //         cnt_id,
        //         cuenta,
        //         cnt_nombre
        //         FROM cnt_cuenta_contable 
        //         INNER JOIN cxb_cuentaxcuenta_bancaria ON cxb_id_cnt = cnt_id
        //         INNER JOIN tra_transaccion ON tra_id_cub = cxb_id_cub
        //         INNER JOIN dab_detalle_abono ON dab_id_tra = tra_id
        //         INNER JOIN abc_abono_cliente ON abc_id = dab_id_abc
        //         WHERE abc_id = ".$abc_id." AND cxb_id_tcn = ".$tcn_id_debe_cub."
        // ";


        $query = $this->db->select(
            "GROUP_CONCAT(DISTINCT DATE_FORMAT(dab_fecha,'%Y%m%d')) fecha_codigo,
            abc_id id_referencia,
            0 AS id_referencia_otros,
            SUM(dab_monto) AS total_debe,
            0.00 AS total_haber,
            cnt_id,
            cnt_cuenta as cuenta,
            cnt_nombre",
            FALSE
        )
            ->from('cnt_cuenta_contable')
            ->join('cxb_cuentaxcuenta_bancaria', 'cxb_id_cnt = cnt_id', 'inner')
            ->join('tra_transaccion', 'tra_id_cub = cxb_id_cub', 'inner')
            ->join('dab_detalle_abono', 'dab_id_tra = tra_id', 'inner')
            ->join('abc_abono_cliente', 'abc_id = dab_id_abc', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        $datos_query = $this->db->get()->result_array();

        return $datos_query;
    }


    /***************************************************************/
    /**
     * @author René Castaneda
     * @since 27/10/2019
     * @method Se obtiene los abonos (haber) a quienes se les hará partida contable
     */
    public function get_pago_cliente_partida_haber($where = null, $where2 = null, $group_by = 'abc_id')
    {

        $defecto_cnt_reg = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
        $defecto_cnt = $defecto_cnt_reg[0]['cnt_id'];
        $defecto_cnt_nombre = $defecto_cnt_reg[0]['cnt_nombre'];
        $defecto_cnt_cuenta = $defecto_cnt_reg[0]['cnt_cuenta'];
        $tcn_id_haber = (isset($where2['tcn_id_haber']) && $where2['tcn_id_haber'] > 0) ? $where2['tcn_id_haber'] : 0;
        // no utilizada
        //$tcn_id_haber_tran = (isset($where2['tcn_id_haber_tran']) && $where2['tcn_id_haber_tran'] > 0)? $where2['tcn_id_haber_tran']:0;

        $this->db->select("
                GROUP_CONCAT(DISTINCT DATE_FORMAT(abc_fecha,'%Y%m%d')) fecha_codigo,
                abc_id id_referencia,
                '0' id_referencia_otros,
                0.00 AS total_debe,
                sum(abf_monto) AS total_haber,
                IFNULL((
                    SELECT
                        cnt_id
                    FROM
                        cli_cliente
                    JOIN cxn_cuentaxcliente ON cli_id = cxn_id_cli
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cli_id = fac_id_cli
                    AND cxn_id_tcn = " . $tcn_id_haber . "
                    AND cxn_id_cec = fac_id_cec
                    AND cxn_id_tpg = fac_id_tpg
                    LIMIT 1
                ), '$defecto_cnt') AS cnt_id,
                IFNULL((
                    SELECT
                        cnt_cuenta
                    FROM
                        cli_cliente
                    JOIN cxn_cuentaxcliente ON cli_id = cxn_id_cli
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cli_id = fac_id_cli
                    AND cxn_id_tcn = " . $tcn_id_haber . "
                    AND cxn_id_cec = fac_id_cec
                    AND cxn_id_tpg = fac_id_tpg
                    LIMIT 1
                ), '$defecto_cnt_cuenta') AS cuenta,
                IFNULL((
                    SELECT
                        cnt_nombre
                    FROM
                        cli_cliente
                    JOIN cxn_cuentaxcliente ON cli_id = cxn_id_cli
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cli_id = fac_id_cli
                    AND cxn_id_tcn = " . $tcn_id_haber . "
                    AND cxn_id_tpg = fac_id_tpg
                    AND cxn_id_cec = fac_id_cec
                    LIMIT 1
                ), '$defecto_cnt_nombre') AS cnt_nombre
                ", false)
            ->from('abc_abono_cliente')
            ->join('abf_abono_factura', 'abf_id_abc=abc_id')
            ->join('fac_factura', 'fac_id=abf_id_fac')
            ->where('fac_estado > 0');
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }


        $datos_query = $this->db->get()->result_array();
        return $datos_query;
    }


    /**
     * @author René Castaneda
     * @since 15/11/2019
     * @method Se obtiene los anticipos del cliente a los cuales se les hará partida contable
     */
    public function get_anticipo_cliente_partida($where = null, $group_by = null)
    {
        $this->db->select("
                GROUP_CONCAT(DISTINCT DATE_FORMAT(anl_fecha,'%Y%m%d')) fecha_codigo,
                GROUP_CONCAT(DISTINCT anl_id) id_referencia,
                GROUP_CONCAT(DISTINCT anl_comprobante) anl_comprobante,
                IF(cli_personeria = 1, CONCAT(cli_nombre, ' ', cli_apellido), cli_apellido) anl_cliente,
                '0' id_referencia_otros,
                'Anticipo de cliente' concepto_partida,
                SUM(anl_monto) AS total_partida
                ", false)
            ->from('anl_anticipo_cliente')
            ->join('cli_cliente', 'cli_id =  anl_id_cli');
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }


        $datos_query = $this->db->get()->result_array();
        return $datos_query;
    }

    public function get_depreciar_partida($where = null, $group_by = null)
    {
        $this->db->simple_query("SET SESSION group_concat_max_len = 30000");
        $this->db->select("act_id_tac, GROUP_CONCAT(DISTINCT dep_id) AS ids_referencias, 'Depreciación de Activo Fijo' AS concepto_partida, SUM(dep_monto) AS total_partida,
            (SELECT tac_nombre FROM tac_tipo_activofijo WHERE tac_id = act_id_tac) AS tac_nombre", false)
            ->from('dep_depreciacion')
            ->join('act_activo_fijo', 'act_id = dep_id_act ');
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }
        return $this->db->get()->result_array();
    }

    public function get_debe_depreciar_partida($where = null, $group_by = null)
    {
        $this->db->simple_query("SET SESSION group_concat_max_len = 30000");
        $tbl_defecto_cnt = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1))[0];
        $id_cta_def = $tbl_defecto_cnt['cnt_id'];
        $name_cta_def = $tbl_defecto_cnt['cnt_nombre'];
        $num_cta_def = $tbl_defecto_cnt['cnt_cuenta'];
        $tcn_id_parm = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('DEPRECIACIONES'));
        $this->db->select("act_id_tac, GROUP_CONCAT(DISTINCT dep_id) AS ids_referencias, SUM(dep_monto) AS total_debe, 0 AS total_haber,
            IFNULL((SELECT cnt_id FROM dtv_detalle_tipo_activo JOIN cnt_cuenta_contable ON cnt_id = dtv_id_cnt WHERE dtv_id_tcn = $tcn_id_parm
            AND dtv_tipo_proceso = 1 AND dtv_id_tac = act_id_tac AND dtv_id_cec = act_id_cec LIMIT 1), '$id_cta_def') AS cnt_id,
            IFNULL((SELECT cnt_cuenta FROM dtv_detalle_tipo_activo JOIN cnt_cuenta_contable ON cnt_id = dtv_id_cnt WHERE dtv_id_tcn = $tcn_id_parm
            AND dtv_tipo_proceso = 1 AND dtv_id_tac = act_id_tac AND dtv_id_cec = act_id_cec LIMIT 1), '$num_cta_def') AS cuenta,
            IFNULL((SELECT cnt_nombre FROM dtv_detalle_tipo_activo JOIN cnt_cuenta_contable ON cnt_id = dtv_id_cnt WHERE dtv_id_tcn = $tcn_id_parm
            AND dtv_tipo_proceso = 1  AND dtv_id_tac = act_id_tac AND dtv_id_cec = act_id_cec LIMIT 1), '$name_cta_def') AS cnt_nombre", false)
            ->from('dep_depreciacion')
            ->join('act_activo_fijo', 'act_id = dep_id_act');
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }
        return $this->db->get()->result_array();
    }

    public function get_haber_depreciar_partida($where = null, $group_by = null)
    {
        $this->db->simple_query("SET SESSION group_concat_max_len = 30000");
        $tbl_defecto_cnt = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1))[0];
        $id_cta_def = $tbl_defecto_cnt['cnt_id'];
        $name_cta_def = $tbl_defecto_cnt['cnt_nombre'];
        $num_cta_def = $tbl_defecto_cnt['cnt_cuenta'];
        $tcn_id_parm = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('DEPRECIACIONES'));
        $this->db->select("act_id_tac, GROUP_CONCAT(DISTINCT dep_id) AS ids_referencias, 0 AS total_debe, SUM(dep_monto) AS total_haber,
            IFNULL((SELECT cnt_id FROM dtv_detalle_tipo_activo JOIN cnt_cuenta_contable ON cnt_id = dtv_id_cnt WHERE dtv_id_tcn = $tcn_id_parm
            AND dtv_tipo_proceso = 2 AND dtv_id_tac = act_id_tac AND dtv_id_cec = act_id_cec LIMIT 1), '$id_cta_def') AS cnt_id,
            IFNULL((SELECT cnt_cuenta FROM dtv_detalle_tipo_activo JOIN cnt_cuenta_contable ON cnt_id = dtv_id_cnt WHERE dtv_id_tcn = $tcn_id_parm
            AND dtv_tipo_proceso = 2 AND dtv_id_tac = act_id_tac AND dtv_id_cec = act_id_cec LIMIT 1), '$num_cta_def') AS cuenta,
            IFNULL((SELECT cnt_nombre FROM dtv_detalle_tipo_activo JOIN cnt_cuenta_contable ON cnt_id = dtv_id_cnt WHERE dtv_id_tcn = $tcn_id_parm
            AND dtv_tipo_proceso = 2  AND dtv_id_tac = act_id_tac AND dtv_id_cec = act_id_cec LIMIT 1), '$name_cta_def') AS cnt_nombre", false)
            ->from('dep_depreciacion')
            ->join('act_activo_fijo', 'act_id = dep_id_act');
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }
        return $this->db->get()->result_array();
    }


    public function get_anticipo_cliente_partida_debe($where = null, $where2 = null, $group_by = 'abc_id')
    {

        $defecto_cnt_reg = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
        $defecto_cnt = $defecto_cnt_reg[0]['cnt_id'];
        $defecto_cnt_nombre = $defecto_cnt_reg[0]['cnt_nombre'];
        $defecto_cnt_cuenta = $defecto_cnt_reg[0]['cnt_cuenta'];
        $tcn_id_debe = (isset($where2['tcn_id_debe']) && $where2['tcn_id_debe'] > 0) ? $where2['tcn_id_debe'] : 0;
        // no utilizada
        //$tcn_id_haber_tran = (isset($where2['tcn_id_haber_tran']) && $where2['tcn_id_haber_tran'] > 0)? $where2['tcn_id_haber_tran']:0;

        $this->db->select("
                GROUP_CONCAT(DISTINCT DATE_FORMAT(anl_fecha,'%Y%m%d')) fecha_codigo,
                anl_id id_referencia,
                '0' id_referencia_otros,
                sum(anl_monto) AS total_debe,
                0.00 AS total_haber,
                IFNULL((
                    SELECT
                        cnt_id
                    FROM
                        cxn_cuentaxcliente
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cxn_id_cli = cli_id
                    AND cxn_id_tcn = " . $tcn_id_debe . "
                    LIMIT 1
                ), '$defecto_cnt') AS cnt_id,
                IFNULL((
                    SELECT
                        cnt_cuenta
                    FROM
                        cxn_cuentaxcliente
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cxn_id_cli = cli_id
                    AND cxn_id_tcn = " . $tcn_id_debe . "
                    LIMIT 1
                ), '$defecto_cnt_cuenta') AS cuenta,
                IFNULL((
                    SELECT
                        cnt_nombre
                    FROM
                        cxn_cuentaxcliente
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cxn_id_cli = cli_id
                    AND cxn_id_tcn = " . $tcn_id_debe . "
                    LIMIT 1
                ), '$defecto_cnt_nombre') AS cnt_nombre
                ", false)
            ->from('anl_anticipo_cliente')
            ->join('cli_cliente', 'cli_id =  anl_id_cli');
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }


        $datos_query = $this->db->get()->result_array();
        return $datos_query;
    }

    public function get_anticipo_cliente_partida_haber($where = null, $where2 = null, $group_by = 'abc_id', $unido_abf = 0)
    {

        $defecto_cnt_reg = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
        $defecto_cnt = $defecto_cnt_reg[0]['cnt_id'];
        $defecto_cnt_nombre = $defecto_cnt_reg[0]['cnt_nombre'];
        $defecto_cnt_cuenta = $defecto_cnt_reg[0]['cnt_cuenta'];
        $tcn_id_haber = (isset($where2['tcn_id_haber']) && $where2['tcn_id_haber'] > 0) ? $where2['tcn_id_haber'] : 0;
        // no utilizada
        //$tcn_id_haber_tran = (isset($where2['tcn_id_haber_tran']) && $where2['tcn_id_haber_tran'] > 0)? $where2['tcn_id_haber_tran']:0;

        $this->db->select("
                GROUP_CONCAT(DISTINCT DATE_FORMAT(anl_fecha,'%Y%m%d')) fecha_codigo,
                anl_id id_referencia,
                '0' id_referencia_otros,
                0.00 AS total_debe,
                sum(anl_monto) AS total_haber,
                IFNULL((
                    SELECT
                        cnt_id
                    FROM
                        cxn_cuentaxcliente
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cxn_id_cli = cli_id
                    AND cxn_id_tcn = " . $tcn_id_haber . "
                    LIMIT 1
                ), '$defecto_cnt') AS cnt_id,
                IFNULL((
                    SELECT
                        cnt_cuenta
                    FROM
                        cxn_cuentaxcliente
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cxn_id_cli = cli_id
                    AND cxn_id_tcn = " . $tcn_id_haber . "
                    LIMIT 1
                ), '$defecto_cnt_cuenta') AS cuenta,
                IFNULL((
                    SELECT
                        cnt_nombre
                    FROM
                        cxn_cuentaxcliente
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cxn_id_cli = cli_id
                    AND cxn_id_tcn = " . $tcn_id_haber . "
                    LIMIT 1
                ), '$defecto_cnt_nombre') AS cnt_nombre
                ", false)
            ->from('anl_anticipo_cliente')
            ->join('cli_cliente', 'cli_id =  anl_id_cli');
        if ($unido_abf) {
            $this->db->join('abc_abono_cliente', "abc_id = anl_id_abc_origen");
        }
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }


        $datos_query = $this->db->get()->result_array();
        return $datos_query;
    }

    /**
     * @author René Castaneda
     * @since 27/10/2019
     * @method Se obtiene los anticipos usados para abonos (debe) a quienes se les hará partida contable
     */
    public function get_pago_anticipo_cliente_partida_debe($where = null, $where2 = null, $group_by = 'abc_id')
    {

        // Cuenta contable por defecto
        $defecto_cnt_reg = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
        $defecto_cnt = $defecto_cnt_reg[0]['cnt_id'];
        $defecto_cnt_nombre = $defecto_cnt_reg[0]['cnt_nombre'];
        $defecto_cnt_cuenta = $defecto_cnt_reg[0]['cnt_cuenta'];

        $tcn_id_debe = (isset($where2['tcn_id_debe']) && $where2['tcn_id_debe'] > 0) ? $where2['tcn_id_debe'] : 0;

        $this->db->select("
                GROUP_CONCAT(DISTINCT DATE_FORMAT(abc_fecha,'%Y%m%d')) fecha_codigo,
                abc_id id_referencia,
                GROUP_CONCAT(DISTINCT IFNULL((SELECT GROUP_CONCAT(DISTINCT anl_id) from anl_anticipo_cliente where anl_id_cli = abc_id_cli AND 
                 anl_id_abc_origen = abc_id AND anl_id_pct IS NULL), '0')) id_referencia_otros,
                SUM(abc_anticipo)  AS total_debe,
                0.00 AS total_haber,
                (SELECT GROUP_CONCAT(DISTINCT anl_comprobante) FROM anl_anticipo_cliente JOIN ana_anticipo_abono ON ana_id_anl = anl_id WHERE ana_id_abc = abc_id) AS anl_comprobante,
                IFNULL((
                    SELECT
                        cnt_id
                    FROM
                        cli_cliente
                    JOIN cxn_cuentaxcliente ON cli_id = cxn_id_cli
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cli_id = fac_id_cli
                    AND cxn_id_tcn = " . $tcn_id_debe . "
                    AND cxn_id_tpg = fac_id_tpg
                    LIMIT 1
                ),'$defecto_cnt') AS cnt_id,
                IFNULL((
                    SELECT
                        cnt_cuenta
                    FROM
                        cli_cliente
                    JOIN cxn_cuentaxcliente ON cli_id = cxn_id_cli
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cli_id = fac_id_cli
                    AND cxn_id_tcn = " . $tcn_id_debe . "
                    AND cxn_id_tpg = fac_id_tpg
                    LIMIT 1
                ),'$defecto_cnt_cuenta') AS cuenta,
                IFNULL((
                    SELECT
                        cnt_nombre
                    FROM
                        cli_cliente
                    JOIN cxn_cuentaxcliente ON cli_id = cxn_id_cli
                    JOIN cnt_cuenta_contable ON cxn_id_cnt = cnt_id
                    WHERE
                        cli_id = fac_id_cli
                    AND cxn_id_tcn = " . $tcn_id_debe . "
                    AND cxn_id_tpg = fac_id_tpg
                    LIMIT 1
                ),'$defecto_cnt_nombre') AS cnt_nombre
                ", false)
            ->from('abc_abono_cliente')
            ->join('abf_abono_factura', 'abf_id_abc=abc_id')
            ->join('fac_factura', 'fac_id=abf_id_fac');
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }


        $datos_query = $this->db->get()->result_array();
        //echo $this->db->last_query(); die();
        return $datos_query;
    }

    /**
     * @author Raul Escalante
     * @since Dic/2019
     * @method Obtiene los montos de los descuentos de AFP
     */
    public function get_afp_mensual($where = null, $completo = null)
    {
        $afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
        if ($completo) {
            $valores = array();
            for ($i = 1; $i <= 12; $i++) {
                $this->db->select("IFNULL(SUM(ddd_valor),0) AS mes", false)
                    ->from('ddd_detalle_descuento')
                    ->join('pla_planilla', 'ddd_id_pla = pla_id')
                    ->where('pla_estado', 3)
                    ->where('MONTH(pla_fecha_inicio)', $i)
                    ->where('ddd_id_tdc', $afp);
                if ($where) {
                    $this->db->where($where);
                }
                $result = $this->db->get()->row();
                $valores[$i] = $result->mes;
            }
            return $valores;
        } else {
            $this->db->select("MONTH(pla_fecha_inicio) AS mes, IFNULL(SUM(ddd_valor),0) AS afp", false)
                ->from('ddd_detalle_descuento')
                ->join('pla_planilla', 'ddd_id_pla = pla_id')
                ->where('pla_estado', 3)
                ->where('ddd_id_tdc', $afp)
                ->group_by('MONTH(pla_fecha_inicio)');
            if ($where) {
                $this->db->where($where);
            }
            return $this->db->get()->result_array();
        }
    }

    /**
     * @author Raul Escalante
     * @since Ene/2020
     * @method Obtiene los clientes o proveedores que no poseen una tcn
     */
    public function get_config_pendiente($tipo_busqueda, $tcn_id)
    {
        if ($tipo_busqueda > 0) {
            $query = "SELECT * FROM cli_cliente WHERE cli_id NOT IN (SELECT cxn_id_cli FROM cxn_cuentaxcliente WHERE cxn_id_tcn = $tcn_id);";
        } else {
            $query = "SELECT * FROM prv_proveedor WHERE prv_id NOT IN (SELECT dfp_id_prv from dfp_detalle_finanza_proveedor WHERE dfp_id_tcn = $tcn_id);";
        }
        $result = $this->db->query($query);
        return $result->result_array();
    }

    /**
     * @author Raul Escalante
     * @since Ene/2020
     * @method Obtiene los clientes o proveedores que no poseen una tcn
     */
    public function get_otras_formas_pago_partida($where = null, $group_by  = null)
    {
        $this->db->select("GROUP_CONCAT(DISTINCT DATE_FORMAT(ofp_fecha, '%Y%m%d')) AS fecha_codigo, 
            GROUP_CONCAT(DISTINCT ofp_id) AS id_referencia, 
            GROUP_CONCAT(DISTINCT dpv_numero_documento) AS ofp_documento, 
            dpv_id_prv AS proveedor,
            GROUP_CONCAT(DISTINCT ofp_id_frp) AS forma_pago,
            GROUP_CONCAT(DISTINCT ofp_orden) AS ofp_orden, 
            '0' AS id_referencia_otros, 
            'Otras Formas de Pago' AS concepto_partida, 
            SUM(ofp_monto) AS total_partida
            ", false)
            ->from('ofp_otra_forma_pago')
            ->join('dpv_documento_proveedor', 'dpv_id = ofp_id_dpv');
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }
        $datos_query = $this->db->get()->result_array();
        return $datos_query;
    }

    public function get_otras_formas_pago_debe($where = null, $group_by = null)
    {
        $defecto_cnt_reg = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
        $defecto_cnt = $defecto_cnt_reg[0]['cnt_id'];
        $defecto_cnt_nombre = $defecto_cnt_reg[0]['cnt_nombre'];
        $defecto_cnt_cuenta = $defecto_cnt_reg[0]['cnt_cuenta'];
        $this->db->select("GROUP_CONCAT(DISTINCT DATE_FORMAT(ofp_fecha, '%Y%m%d')) AS fecha_codigo, GROUP_CONCAT(DISTINCT ofp_id) AS id_referencia, 
            GROUP_CONCAT(DISTINCT dpv_numero_documento) AS ofp_documento, '0' AS id_referencia_otros, SUM(ofp_monto) AS total_debe, 0.00 AS total_haber, 
            IFNULL((SELECT cnt_id FROM dfp_detalle_finanza_proveedor JOIN cnt_cuenta_contable ON dfp_id_cnt = cnt_id WHERE dfp_id_prv = dpv_id_prv AND dfp_id_tpg = 2 LIMIT 1), 
                $defecto_cnt) AS cnt_id,
            IFNULL((SELECT cnt_cuenta FROM dfp_detalle_finanza_proveedor JOIN cnt_cuenta_contable ON dfp_id_cnt = cnt_id WHERE dfp_id_prv = dpv_id_prv AND dfp_id_tpg = 2 LIMIT 1), 
                $defecto_cnt_cuenta) AS cuenta, 
            IFNULL((SELECT cnt_nombre FROM dfp_detalle_finanza_proveedor JOIN cnt_cuenta_contable ON dfp_id_cnt = cnt_id WHERE dfp_id_prv = dpv_id_prv AND dfp_id_tpg = 2 LIMIT 1), 
                '$defecto_cnt_nombre') AS cnt_nombre", false)
            ->from('ofp_otra_forma_pago')
            ->join('dpv_documento_proveedor', 'dpv_id = ofp_id_dpv');
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }
        $datos_query = $this->db->get()->result_array();
        return $datos_query;
    }

    public function get_otras_formas_pago_haber($where = null, $where2 = null, $group_by = null)
    {
        $defecto_cnt_reg = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
        $defecto_cnt = $defecto_cnt_reg[0]['cnt_id'];
        $defecto_cnt_nombre = $defecto_cnt_reg[0]['cnt_nombre'];
        $defecto_cnt_cuenta = $defecto_cnt_reg[0]['cnt_cuenta'];
        $tcn_id_haber = (isset($where2) && isset($where2['tcn_id_debe']) && is_numeric($where2['tcn_id_debe'])) ? $where2 : 0;
        $this->db->select("GROUP_CONCAT(DISTINCT DATE_FORMAT(ofp_fecha,'%Y%m%d')) fecha_codigo, GROUP_CONCAT(DISTINCT ofp_id) AS id_referencia,
            GROUP_CONCAT(DISTINCT dpv_numero_documento) AS ofp_documento, '0' AS id_referencia_otros, 0.00 AS total_debe, SUM(ofp_monto) AS total_haber,
            IFNULL((SELECT cnt_id FROM cnt_cuenta_contable WHERE cnt_id = $tcn_id_haber LIMIT 1), $defecto_cnt) AS cnt_id,
            IFNULL((SELECT cnt_cuenta FROM cnt_cuenta_contable WHERE cnt_id = $tcn_id_haber LIMIT 1), '$defecto_cnt_cuenta') AS cuenta,
            IFNULL((SELECT cnt_nombre FROM cnt_cuenta_contable WHERE cnt_id = $tcn_id_haber LIMIT 1), '$defecto_cnt_nombre') AS cnt_nombre
                ", false)
            ->from('ofp_otra_forma_pago')
            ->join('dpv_documento_proveedor', 'dpv_id = ofp_id_dpv');
        if ($where) {
            $this->db->where($where);
        }
        if ($group_by) {
            $this->db->group_by($group_by);
        }


        $datos_query = $this->db->get()->result_array();
        return $datos_query;
    }

    public function obtener_haber_docproveedor_caja_chica($where = null, $groupby = null, $orderby = null)
    {
        $tcn_cch = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('FONDOS_CAJA_CHICA'));
        $consult = $this->gsatelite->get_tabla('tcn_tipo_cuenta', array('tcn_id' => $tcn_cch, 'tcn_estado' => 1));
        $tcn_cch = (count($consult) > 0) ? $tcn_cch : 0;
        $defecto = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
        $select = "dpv1.dpv_id, dpv1.dpv_total AS total, (SELECT tpg_nombre FROM tpg_tipo_pago WHERE tpg_id = dpv1.dpv_id_tpg ) AS tpg_nombre,
            IFNULL((SELECT cnt_id FROM dpv_documento_proveedor AS dpv2 LEFT JOIN cch_caja_chica ON dpv2.dpv_id_cch = cch_id LEFT JOIN cnj_cuenta_caja_chica ON cnj_id_cch = cch_id
                    LEFT JOIN cnt_cuenta_contable ON cnt_id = cnj_id_cnt WHERE dpv2.dpv_id = dpv1.dpv_id AND cnj_id_tcn = $tcn_cch LIMIT 1), '" . $defecto[0]['cnt_id'] . "'
            ) AS cnt_id,
            IFNULL((SELECT cnt_cuenta FROM dpv_documento_proveedor AS dpv2 LEFT JOIN cch_caja_chica ON dpv2.dpv_id_cch = cch_id LEFT JOIN cnj_cuenta_caja_chica ON cnj_id_cch = cch_id
                    LEFT JOIN cnt_cuenta_contable ON cnt_id = cnj_id_cnt WHERE dpv2.dpv_id = dpv1.dpv_id AND cnj_id_tcn = $tcn_cch LIMIT 1), '" . $defecto[0]['cnt_cuenta'] . "'
            ) AS cnt_cuenta,
            IFNULL((SELECT cnt_nombre FROM dpv_documento_proveedor AS dpv2 LEFT JOIN cch_caja_chica ON dpv2.dpv_id_cch = cch_id LEFT JOIN cnj_cuenta_caja_chica ON cnj_id_cch = cch_id
                    LEFT JOIN cnt_cuenta_contable ON cnt_id = cnj_id_cnt WHERE  dpv2.dpv_id = dpv1.dpv_id AND cnj_id_tcn = $tcn_cch LIMIT 1), '" . $defecto[0]['cnt_nombre'] . "'           
            ) AS cnt_nombre    
        ";
        $query = $this->db->select($select, false)
            ->from('dpv_documento_proveedor AS dpv1')
            ->join('prv_proveedor AS prv1', 'prv1.prv_id = dpv1.dpv_id_prv', 'left')
            ->where('dpv_id_pct IS NULL');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        return $query->get()->result_array();
    }

    public function obtener_haber_docproveedor_caja_chica_consolidada($where = null, $groupby = null, $orderby = null)
    {
        $tcn_cch = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('FONDOS_CAJA_CHICA'));
        $consult = $this->gsatelite->get_tabla('tcn_tipo_cuenta', array('tcn_id' => $tcn_cch, 'tcn_estado' => 1));
        $tcn_cch = (count($consult) > 0) ? $tcn_cch : 0;
        $defecto = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
        $select = "DISTINCT(dpv1.dpv_id), SUM(dpv1.dpv_total) as total, (SELECT tpg_nombre FROM tpg_tipo_pago WHERE tpg_id = dpv1.dpv_id_tpg) AS tpg_nombre, 
            IFNULL((SELECT cnt_id FROM dpv_documento_proveedor AS dpv2 LEFT JOIN cch_caja_chica ON dpv2.dpv_id_cch = cch_id LEFT JOIN cnj_cuenta_caja_chica ON cnj_id_cch = cch_id 
                LEFT JOIN cnt_cuenta_contable ON cnt_id = cnj_id_cnt WHERE dpv2.dpv_id = dpv1.dpv_id AND cnj_id_tcn = $tcn_cch LIMIT 1), '" . $defecto[0]['cnt_id'] . "'
            ) AS cnt_id,
            IFNULL((SELECT cnt_cuenta FROM dpv_documento_proveedor AS dpv2 LEFT JOIN cch_caja_chica ON dpv2.dpv_id_cch = cch_id LEFT JOIN cnj_cuenta_caja_chica ON cnj_id_cch = cch_id
                    LEFT JOIN cnt_cuenta_contable ON cnt_id = cnj_id_cnt WHERE dpv2.dpv_id = dpv1.dpv_id AND cnj_id_tcn = $tcn_cch LIMIT 1), '" . $defecto[0]['cnt_cuenta'] . "'
            ) AS cnt_cuenta,
            IFNULL((SELECT cnt_nombre FROM dpv_documento_proveedor AS dpv2 LEFT JOIN cch_caja_chica ON dpv2.dpv_id_cch = cch_id LEFT JOIN cnj_cuenta_caja_chica ON cnj_id_cch = cch_id
                    LEFT JOIN cnt_cuenta_contable ON cnt_id = cnj_id_cnt WHERE  dpv2.dpv_id = dpv1.dpv_id AND cnj_id_tcn = $tcn_cch LIMIT 1), '" . $defecto[0]['cnt_nombre'] . "'           
            ) AS cnt_nombre
        ";
        $query = $this->db->select($select, false)
            ->from('dpv_documento_proveedor AS dpv1')
            ->join('prv_proveedor AS prv1', 'prv1.prv_id = dpv1.dpv_id_prv', 'left')
            ->where('dpv_id_pct IS NULL');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        return $query->get()->result_array();
    }

    public function get_debe_anul_doc_prov($where = null, $groupby = null, $orderby = null, $defecto = null)
    {
        $cnt_id = $defecto[0]['cnt_id'];
        $cnt_cta = $defecto[0]['cnt_cuenta'];
        $cnt_nom = $defecto[0]['cnt_nombre'];
        $tcn_cash = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('CAJA'));
        $tcn_cred = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('CUENTA_POR_PAGAR'));
        $select = "dpv_id, SUM(dpv_total) AS sub_total, SUM(dpv_total + IFNULL(dpv_retencion, 0)) AS gran_total, 
        (SELECT tpg_nombre FROM tpg_tipo_pago WHERE tpg_id = dpv_id_tpg) AS tipo_pago, GROUP_CONCAT(DISTINCT dpv_id) AS facturas,
        IFNULL((SELECT cnt_id FROM cnt_cuenta_contable JOIN dfp_detalle_finanza_proveedor ON dfp_id_cnt = cnt_id WHERE dfp_id_prv = dpv_id_prv AND dfp_id_tpg = dpv_id_tpg 
        AND dfp_id_tcn = IF(dpv_id_tpg = 1, $tcn_cash, $tcn_cred) LIMIT 1), '$cnt_id') AS cnt_id,
        IFNULL((SELECT cnt_cuenta FROM cnt_cuenta_contable JOIN dfp_detalle_finanza_proveedor ON dfp_id_cnt = cnt_id WHERE dfp_id_prv = dpv_id_prv AND dfp_id_tpg = dpv_id_tpg 
        AND dfp_id_tcn = IF(dpv_id_tpg = 1, $tcn_cash, $tcn_cred) LIMIT 1), '$cnt_cta') AS cnt_cuenta,
        IFNULL((SELECT cnt_nombre FROM cnt_cuenta_contable JOIN dfp_detalle_finanza_proveedor ON dfp_id_cnt = cnt_id WHERE dfp_id_prv = dpv_id_prv AND dfp_id_tpg = dpv_id_tpg 
        AND dfp_id_tcn = IF(dpv_id_tpg = 1, $tcn_cash, $tcn_cred) LIMIT 1), '$cnt_nom') AS cnt_nombre";
        $query = $this->db->select($select, false)
            ->from('dpv_documento_proveedor')
            ->join('prv_proveedor', 'prv_id = dpv_id_prv');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        return $query->get()->result_array();
    }

    public function get_retenc_anul_doc_prov($where = null, $groupby = null, $orderby = null, $defecto = null)
    {
        $def_id = $defecto[0]['cnt_id'];
        $def_cta = $defecto[0]['cnt_cuenta'];
        $def_nom = $defecto[0]['cnt_nombre'];
        $select = "dpv_id, IFNULL(ret_porcentaje, 0) AS ret_porcentaje, SUM(IFNULL(rxd_monto, 0)) AS subtotxretencion, dxd_subtotal, dxd_id,
        IFNULL((SELECT cnt_id FROM cnt_cuenta_contable JOIN dcr_detalle_cuenta_retencion on dcr_id_cnt = cnt_id WHERE dcr_id_ret = rxd_id_ret LIMIT 1), '$def_id') AS cuenta_id, 
        IFNULL((SELECT cnt_cuenta FROM cnt_cuenta_contable JOIN dcr_detalle_cuenta_retencion on dcr_id_cnt = cnt_id WHERE dcr_id_ret = rxd_id_ret LIMIT 1), '$def_cta') AS cuenta_num, 
        IFNULL((SELECT cnt_nombre FROM cnt_cuenta_contable JOIN dcr_detalle_cuenta_retencion on dcr_id_cnt = cnt_id WHERE dcr_id_ret = rxd_id_ret LIMIT 1), '$def_nom') AS cuenta_nombre";
        $query = $this->db->select($select, false)
            ->from('dxd_detalle_documento_proveedor')
            ->join('dpv_documento_proveedor', 'dpv_id = dxd_id_dpv')
            ->join('rxd_retencionxdetalle_documento', 'dxd_id = rxd_id_dxd', 'LEFT')
            ->join('ret_retencion', 'rxd_id_ret = ret_id', 'LEFT')
            ->having('subtotxretencion > 0');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        return $query->get()->result_array();
    }

    public function get_detalle_anul_doc_prov($where = null, $groupby = null, $orderby = null, $defecto = null, $centro_defecto = 0)
    {
        $cnt_id = $defecto[0]['cnt_id'];
        $cnt_cta = $defecto[0]['cnt_cuenta'];
        $cnt_nom = $defecto[0]['cnt_nombre'];
        $tcn_gto = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('GASTO'));
        $tcn_inv = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('INVENTARIO_EN_TRANSITO'));
        $tcn_cto = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('COSTO'));
        $query = $this->db->select("GROUP_CONCAT(DISTINCT dpv_id) AS facturas, dpv_id, IFNULL(pxd_id_cec, IFNULL(dpv_id_cec, '$centro_defecto')) AS centro,
            IFNULL(pxd_id_cnt, IFNULL((SELECT cnt_id FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id 
                WHERE dta_id_tcn = IF(art_inventario = 1, '$tcn_inv', (IF(art_gasto = 1, '$tcn_gto', '$tcn_cto'))) AND dta_id_tia = tia_id 
                AND IF(art_tipo=1, 1, dta_id_bod) = IF(art_tipo=1, 1, dxd_id_bod) LIMIT 1), '$cnt_id')
            ) AS cuenta,
            IFNULL((SELECT cnt_cuenta FROM cnt_cuenta_contable WHERE cnt_id = pxd_id_cnt),
                IFNULL((SELECT cnt_cuenta FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id 
                WHERE dta_id_tcn = IF(art_inventario = 1, '$tcn_inv', (IF(art_gasto = 1, '$tcn_gto', '$tcn_cto'))) AND dta_id_tia = tia_id 
                AND IF(art_tipo=1, 1, dta_id_bod) = IF(art_tipo=1, 1, dxd_id_bod) LIMIT 1), '$cnt_cta')
            ) AS num_cta,
            IFNULL((SELECT cnt_nombre FROM cnt_cuenta_contable WHERE cnt_id = pxd_id_cnt), 
                IFNULL((SELECT cnt_nombre FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id 
                WHERE dta_id_tcn = IF(art_inventario = 1, '$tcn_inv', (IF(art_gasto = 1, '$tcn_gto', '$tcn_cto'))) AND dta_id_tia = tia_id 
                AND IF(art_tipo=1, 1, dta_id_bod) = IF(art_tipo=1, 1, dxd_id_bod) LIMIT 1), '$cnt_nom')
            ) AS nomb_cta,
            IFNULL(SUM(CASE WHEN pxd_porcentaje > 0 THEN  (dxd_total * (pxd_porcentaje/100)) ELSE dxd_total END),0) AS suma_haber,
            IFNULL(SUM(CASE WHEN pxd_porcentaje > 0 THEN  (dxd_cantidad * (pxd_porcentaje/100)) ELSE dxd_cantidad END), 0) AS cantidad, 
            IFNULL(SUM(CASE WHEN pxd_porcentaje > 0 THEN  (dxd_subtotal * (pxd_porcentaje/100)) ELSE dxd_subtotal END), 0) AS sub_total
            ", false)
            ->from('dxd_detalle_documento_proveedor')
            ->join('dpv_documento_proveedor', 'dpv_id = dxd_id_dpv')
            ->join('prv_proveedor', 'prv_id = dpv_id_prv')
            ->join('art_articulo', 'dxd_id_art = art_id')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id')
            ->join('pxd_prorrateoxdetalle_documento', 'pxd_id_dxd = dxd_id', 'LEFT')
            ->join('cnt_cuenta_contable', 'cnt_id = pxd_id_cnt', 'LEFT');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        return $query->get()->result_array();
    }

    public function get_imp_anul_doc_prov($where = null, $groupby = null, $orderby = null, $defecto = null)
    {
        $cnt_id = $defecto[0]['cnt_id'];
        $cnt_cta = $defecto[0]['cnt_cuenta'];
        $cnt_nom = $defecto[0]['cnt_nombre'];
        $tcn_imp = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('IMPUESTOS'));
        $select = "dpv_id, cxe_id_tcn, cxe_id_cnt, imp_porcentaje, imp_valor, dxd_subtotal, dxd_id, SUM(IFNULL(idd_monto,0)) AS subtotximpcuenta,
        IFNULL((SELECT cnt_id FROM cnt_cuenta_contable WHERE cnt_id = cxe_id_cnt), '442') AS cuenta_id,
        IFNULL((SELECT cnt_cuenta FROM cnt_cuenta_contable WHERE cnt_id = cxe_id_cnt), 'CUENTA') AS cuenta,
        IFNULL((SELECT cnt_nombre FROM cnt_cuenta_contable WHERE cnt_id = cxe_id_cnt), 'NOMBRE') as cuenta_nombre";
        $query = $this->db->select($select, false)
            ->from('dxd_detalle_documento_proveedor')
            ->join('dpv_documento_proveedor', 'dpv_id = dxd_id_dpv')
            ->join('idd_impuestoxdetalle_documento', 'dxd_id = idd_id_dxd')
            ->join('imp_impuesto', 'idd_id_imp = imp_id')
            ->join('cxe_cuentaximpuesto', 'idd_id_imp = cxe_id_imp  AND cxe_id_cec = dpv_id_cec AND cxe_id_tif = dpv_id_tif', 'LEFT')
            ->where('cxe_id_tcn', $tcn_imp);
        if ($where != null) {
            $this->db->where($where);
        }
        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        return $query->get()->result_array();
    }
}// end class
