<?php

class Consultas extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    function obtenter_detalles_egresos($id_banco, $cub_id) {
        $this->db->select(array(
            'che_numero'
            , 'che_monto'
            , 'che_concepto'
            , 'che_fecha'
            , 'ban_nombre'
            , 'cub_numero'
            , 'cub_saldo_inicial'
            , 'cub_nombre'
        ));
        $this->db->from('cub_cuenta_bancaria')
                ->join('ban_banco', 'cub_id_ban = ban_id')
                ->join('chq_chequera', 'chq_id_cub = cub_id', 'left')
                ->join('che_cheque', 'che_id_chq = chq_id', 'left')
                ->where('cub_id', $cub_id)
        ;

        $informacion = $this->db->get();
        return $informacion->result_array();
    }

    function rpt_control_egresos($tipo, $desde, $hasta, $cub_tipo = "", $where = null) {
        if ($tipo == 'E') {
            $where_tipo = array('ttb_estado' => 1, '(ttb_retiro = 1 OR ttb_id_ttb_retiro IS NOT NULL)' => null);
            // $tipos = array(2, 6, 3);
        } else if ($tipo == 'I') {
            $where_tipo = array('ttb_estado' => 1, '(ttb_deposito = 1 OR ttb_id_ttb_deposito IS NOT NULL)' => null);
            // $tipos = array(1, 5, 3);
        }
        $ids  = $this->db->select('ttb_id')->from('ttb_tipo_transact_bancaria')->where($where_tipo)->get()->result_array();
        $tipos = array_column($ids, 'ttb_id');

        $this->db->select(" 
          tra_fecha As fecha
        , tra_operacion As operacion
        , ttb_nombre As concepto
        , tra_monto As monto
        , tra_id_ttb
        , tra_comprobante
        , che_numero As numero
        , cub_numero As cuenta
        , cub_nombre As cuenta_nombre
        , IFNULL(che_orden,nta_orden) As alaorden
        , CASE WHEN tra_monto<0 THEN 'true' ELSE 'false' END,
        ban_nombre,
        IFNULL(che_concepto, IFNULL(nta_concepto, tra_comprobante)) As concepto_2,
        ttb_nombre, tra_id_cub", false);
        $this->db->from('tra_transaccion');
        $this->db->join('cub_cuenta_bancaria', 'cub_id = tra_id_cub');
        $this->db->join('ban_banco', 'cub_id_ban = ban_id');
        $this->db->join('che_cheque', 'che_id_tra = tra_id', 'left');
        $this->db->join('nta_nota_abono', 'nta_id_tra = tra_id', 'left');
        $this->db->join('ttb_tipo_transact_bancaria','ttb_id = tra_id_ttb', 'INNER');        
        $this->db->where("DATE(tra_fecha) BETWEEN '{$desde}' AND  '{$hasta}'", null, false);
        $this->db->where('cub_estado', 1);
        if ($cub_tipo != "") {
            $this->db->where('cub_id_tpc', (int) $cub_tipo);
        }
        if($where){
            $this->db->where($where);    
        }        
        $this->db->where_in('tra_id_ttb', $tipos);
        $this->db->order_by('cub_numero', 'asc');
        $result = $this->db->get()->result();
        return $result;
    }

    function rpt_renta($desde, $hasta) {
        $this->db->select("
        cub_numero AS cuenta
        , che_fecha AS fecha
        , che_numero AS cheque
        , che_concepto As concepto
        , prv_nombre AS contribuyente,
        (select dcp_valor FROM dcp_documento_proveedor where dcp_id_prv = prv_id AND dcp_id_tde = (SELECT par_valor FROM par_parametro WHERE par_codigo = 'TIPO_DOCUMENTO_NIT_PROVEEDOR') LIMIT 1) as nit
        , che_monto_suj AS valor
        , che_renta_monto As renta");
        $this->db->from('che_cheque');
        $this->db->join('dch_detalle_cheque', 'dch_id_che = che_id', 'left');
        $this->db->join('chq_chequera', 'chq_id = che_id_chq', 'left');
        $this->db->join('cub_cuenta_bancaria', 'cub_id = chq_id_cub', 'left');
        $this->db->join('prv_proveedor', 'che_id_prv = prv_id', 'left');
        $this->db->where("DATE_FORMAT(che_fecha, '%Y-%m-%d') BETWEEN '" . date('Y-m-d', strtotime($desde)) . "' AND '" . date('Y-m-d', strtotime($hasta)) . "'", null, false);
        // $this->db->where('che_monto_a_retener > ', 0);
        $this->db->where('che_monto_suj > ', 0);
        //$this->db->where('pro_get_orden_actual(1, che_id) >', 0);

        return $this->db->get()->result();
    }

    function merge_tra_cheque($id_banco, $cub_id, $fecha_a, $fecha_b, $aplicar) {
        $this->db->select(
                        'tra_monto AS monto
      , tra_operacion AS concepto
      , DATE_FORMAT(tra_fecha, "%d/%m/%Y") AS fecha
      , tra_comprobante AS numero
      , tra_id_ttb AS id_ttb
      , tra_id AS identificador', false)
                ->from('tra_transaccion')
                ->where('tra_id_cub', $cub_id)
                ->where("DATE_FORMAT(tra_fecha, '%Y-%m-%d') BETWEEN '{$fecha_a}' AND  '{$fecha_b}'", null, false);
        if ($aplicar == 1) {
            $this->db->where('tra_aplicar', 0);
        } else {
            $this->db->where('tra_aplicar', 1);
        }
        $this->db->order_by('tra_fecha');

        $informacion = $this->db->get();
        // echo $this->db->last_query(); print_r($informacion); die();
        return $informacion->result_array();
    }

    function generar_informacion_cuentas($fecha1, $fecha2) {
        $query = "SELECT cp_id, cp_codigo, cpr_deudor_monetario, cpr_cuenta_ingreso, cp_nombre, sum(monto) as monto FROM (SELECT cp_cuenta_presupuestaria.cpr_id cp_id,cp_cuenta_presupuestaria.cpr_numero cp_codigo, cpr_deudor_monetario, cpr_cuenta_ingreso, cp_cuenta_presupuestaria.cpr_nombre cp_nombre,
        SUM(fud_funo_deta_libre.fud_monto) as monto
        FROM    (   fud_funo_deta_libre fud_funo_deta_libre
           JOIN
           cpr_cuenta_presupuesto cp_cuenta_presupuestaria
           ON (fud_funo_deta_libre.fud_id_cpr = cp_cuenta_presupuestaria.cpr_id))
    JOIN
    fun_funo fun_funo
    ON (fud_funo_deta_libre.fud_id_fun = fun_funo.fun_id)
    where DATE_FORMAT(fun_fecha, '%Y-%m-%d') >= '" . $fecha1 . "' and DATE_FORMAT(fun_fecha, '%Y-%m-%d') <= '" . $fecha2 . "'
    group by cp_cuenta_presupuestaria.cpr_id
    UNION
    SELECT
    cpr_id,
    cpr_numero,
    cpr_deudor_monetario, cpr_cuenta_ingreso,
    cpr_nombre,
    SUM(
      det_monto
      ) AS monto
    FROM
    fun_funo
    JOIN fxd_funoxdetalle_cntc ON fxd_id_fun=fun_id
    JOIN det_detalle_cntc ON det_id=fxd_id_det
    JOIN sxc_servicioxcuenta_corriente ON sxc_id=det_id_sxc
    JOIN srv_servicio ON srv_id=sxc_id_srv
    JOIN cpr_cuenta_presupuesto ON cpr_id=srv_id_cpr_actual 
    WHERE
    DATE_FORMAT(fun_fecha, '%Y-%m-%d') >= '" . $fecha1 . "'
    AND DATE_FORMAT(fun_fecha, '%Y-%m-%d') <= '" . $fecha2 . "'
    GROUP BY
    cpr_id) as datos GROUP BY cp_id
    ";

        $informacion = $this->db->query($query);

        return $informacion->result_array();
    }

    function obtener_retension_cheques($where = null) {
        $this->db->select('
                (CASE 
                    WHEN prv_tipo_pers = 1 THEN concat(prv_nombre," ",prv_apellido)
                    WHEN prv_tipo_pers = 2 THEN prv_apellido
                END 
                )as proveedor,
                che_fecha as fecha,
                che_numero as referencia, 
                che_monto_suj as m_sujeto,
                ret_nombre as tipo, 
                SUM(rdc_monto) as r_monto
            ',false);
        $this->db->from('prv_proveedor');
        $this->db->join('che_cheque', 'che_cheque.che_id_prv = prv_proveedor.prv_id','LEFT');
        $this->db->join('dch_detalle_cheque', 'dch_id_che = che_id');
        $this->db->join('rdc_retencion_detalle_cheque', 'rdc_id_dch = dch_id','inner');
        $this->db->join('ret_retencion', 'ret_id = rdc_id_ret', 'inner');
        $this->db->group_by('che_id');
        if ($where !== null) {
          $this->db->where($where);
        }
        $rs = $this->db->get();
        return $rs->result_array();
    }

    public function obtener_retension_notas($where = null){
        $this->db->select('
                (CASE 
                    WHEN prv_tipo_pers = 1 THEN concat(prv_nombre," ",prv_apellido)
                    WHEN prv_tipo_pers = 2 THEN prv_apellido
                END) AS proveedor,
                nta_fecha  as fecha,
                nta_codigo as referencia,
                nta_monto_sujeto  as m_sujeto,
                ret_nombre as tipo,
                SUM(rdn_monto) as r_monto 
            ',false)->from('prv_proveedor')
                    ->join('nta_nota_abono','nta_id_prv = prv_id','LEFT')
                    ->join('dna_detalle_nota_abono', 'dna_id_nta = nta_id')
                    ->join('rdn_retencion_detalle_nota', 'rdn_id_dna = dna_id','INNER')
                    ->join('ret_retencion', 'ret_id = rdn_id_ret','INNER');
        $this->db->group_by('nta_id');
        if ($where !== null) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();


    }

    public function obtener_prov($id = false){
        if ($id !== null) {
            return $this->db->select('
               (CASE 
                    WHEN prv_tipo_pers = 1 THEN concat(prv_nombre," ",prv_apellido)
                    WHEN prv_tipo_pers = 2 THEN prv_apellido
                END) as proveedor

                ',false)->from('prv_proveedor')
                  ->where(array('prv_id' => $id))->get()->result_array();
        }else{
            return '';
        }
    }

    public function cargar_todo($tabla) {
        $this->db->select();
        $this->db->from($tabla);
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
    * @author Nelson Soriano
    * @since  15-01-2019
    * @return Notas de abono actuales
    * @param  Rango de fechas / numero cuenta
    **/
    public function get_reporte_notas($where = null){
        $this->db->select('dpv_numero_documento,nta_fecha,nta_orden,SUM(dna_valor) AS nta_monto,nta_id, (SELECT IF(prv_tipo_pers > 1,prv_apellido,CONCAT(prv_nombre," ",prv_apellido)) FROM prv_proveedor WHERE prv_id = dpv_id_prv) AS proveedor', false)
                 ->from('nta_nota_abono')
                 ->join('dna_detalle_nota_abono','dna_id_nta = nta_id')
                 ->join('dpv_documento_proveedor','dna_id_dpv = dpv_id','left')
                 ->join('cub_cuenta_bancaria', 'cub_id = nta_id_cub', 'inner');
            if ($where) {
                $this->db->where($where);
            }
        $this->db->group_by('dpv_id, nta_id');
        $this->db->order_by('nta_id ASC');
        $query = $this->db->get();
        //print_r($this->db->last_query()); die();
        return $query->result_array();
    }

    public function cargar_bancos_que_tienen_cuentas() {
        $this->db->select('*')
                ->from('ban_banco')
                ->join('cub_cuenta_bancaria', 'cub_id_ban = ban_id', 'inner')
                ->group_by('ban_id')
                ->order_by('ban_nombre');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function cargar_todo2($tabla) {
        $this->db->distinct()->select();
        $this->db->from($tabla);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function cargar_registros($tabla, $campo, $id) {
        $this->db->select();
        $this->db->from($tabla);
        $this->db->where($campo, $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function cargar_registros2($tabla, $campo, $id) {

        $this->db->select();
        $this->db->from($tabla);
        $this->db->where_in($campo, $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function cargar_registro($tabla, $campo, $id) {
        $this->db->select();
        $this->db->from($tabla);
        $this->db->where($campo, $id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function get_tabla($tabla, $where = 0) {
        //Obtiene todos los campos de una tabla con opcion a condicional WHERE en forma de Array
        $this->db->select();

        if ($where != 0) {
            $this->db->where($where);
        }

        $this->db->from($tabla);
        $query = $this->db->get();

        return $query->result_array();
    }

    public function obtener_depart_region($id_proveedor) {
        $query = "select prv_id_reg_municipio as municipio, prv_id_reg_pais as pais,(select reg_padre from reg_region reg where 
        reg.reg_id=prv.prv_id_reg_municipio ) as departamento, (select reg_padre from reg_region reg where 
        reg.reg_id=departamento ) as region from prv_proveedor prv inner join reg_region on reg_id=prv_id_reg_municipio 
where prv_id=" . $id_proveedor;
        $valores = $this->db->query($query);
        return $valores->row();
    }

    public function cargar_entradas($identificador_bodega) {
        $query = "bod_id,art_id,art_nombre,sar_cant_actual";
        $this->db->select($query);
        $this->db->from('sar_saldos_articulos');
        $this->db->join('bod_bodega', 'sar_id_bod=bod_id');
        $this->db->join('art_articulo', 'sar_id_art=art_id');
        $this->db->where('bod_id =', $identificador_bodega);
        $this->db->where('sar_cant_actual >', 0);
        $this->db->group_by('art_nombre');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function cargar_articulos($iden_bod, $iden_art) {
        $query = "MIN(sar_id) as identificador,sar_precio,sar_cant_actual";
        $this->db->select($query);
        $this->db->from('sar_saldos_articulos');
        $this->db->where('sar_cant_actual >', 0);
        $this->db->where('sar_id_bod =', $iden_bod);
        $this->db->where('sar_id_art =', $iden_art);
        $query = $this->db->get();
        return $query->row_array();
    }

//end fucntion cargar_articulos

    public function comprobar_existencias($valor_articulo, $bodega) {
        $query = "SUM(sar_cant_actual) as existencias";
        $this->db->select($query);
        $this->db->from('sar_saldos_articulos');
        $this->db->where('sar_id_art', $valor_articulo);
        $this->db->where('sar_id_bod', $bodega);
        $query2 = $this->db->get();
        return $query2->row_array();
    }

//end fucntion  comprobar_existencias

    public function costo_promedio($id_articulo) {
        $query = "Select SUM(precio*total)/SUM(total) as costo 
        From (select sar_precio as precio, sar_cant_actual as cant, sar_cant_actual * sar_precio as total 
          from sar_saldos_articulos where sar_cant_actual > 0 AND sar_id_art = $id_articulo) as f";
        $valores = $this->db->query($query);
        return $valores->row();
    }

    public function detalles_inventario($proceso, $fecha1, $fecha2) {
        $query = "moi_movimiento_inv.moi_detalle as detalle,moi_movimiento_inv.moi_fecha_mov as fecha,dee_detalle_mov.dee_cantidad as cantidad,dee_detalle_mov.dee_precio as precio,art_articulo.art_nombre as articulo,tia_tipo_articulos.tia_nombre as categoria,bod_bodega.bod_nombre as bodega,(dee_detalle_mov.dee_cantidad * dee_detalle_mov.dee_precio) as subtotal";
        $this->db->select($query);
        $this->db->from('moi_movimiento_inv');
        $this->db->join('dee_detalle_mov', 'moi_movimiento_inv.moi_id=dee_detalle_mov.dee_id_moi');
        $this->db->join('art_articulo', 'dee_detalle_mov.dee_id_art = art_articulo.art_id');
        $this->db->join('tia_tipo_articulos', 'art_articulo.art_id_tia = tia_tipo_articulos.tia_id');
        $this->db->join('bod_bodega', 'moi_movimiento_inv.moi_id_bod=bod_bodega.bod_id');
        $this->db->where('moi_movimiento_inv.moi_id_tip =', $proceso);
        $this->db->where('moi_movimiento_inv.moi_fecha_mov >=', $fecha1);
        $this->db->where('moi_movimiento_inv.moi_fecha_mov <=', $fecha2);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

//end function detalles_inventario

    function cargar_solicitudes($orden = 0, $tipo = '=') {
        $query = "tra_transporte.tra_id as identificador,tra_transporte.tra_fecha as fecha,tra_transporte.tra_entrada as entrada,tra_transporte.tra_salida as salida,tra_transporte.tra_hora as hora,tra_transporte.tra_destino as destino,tra_transporte.tra_motivo as motivo,(select count(int_integrante.int_id_emp) from int_integrante where int_id_tra=tra_id) as empleados";
        $this->db->select($query);
        $this->db->from('tra_transporte');
        $this->db->join('int_integrante', 'int_id_tra = tra_id', 'left');
        $this->db->join('rut_ruta', 'rut_id_tra = tra_id', 'left');
        if ($orden) {
            $this->db->where('pro_get_orden_actual(3, tra_id)' . $tipo, $orden);
        }
        $this->db->group_by('tra_transporte.tra_id');
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function cargar_solicitudes_vehiculos() {
        $query = "tra_transporte.tra_id as identificador,tra_transporte.tra_fecha as fecha,tra_transporte.tra_hora as hora,tra_transporte.tra_destino as destino,tra_transporte.tra_motivo as motivo,tra_id_veh,(select count(int_integrante.int_id_emp) from int_integrante where int_id_tra=tra_id) as empleados,veh_vehiculo.veh_marca as marca,veh_vehiculo.veh_modelo as modelo,c1.cat_nombre as marca, c2.cat_nombre as modelo, pla_numero as placa";
        $this->db->select($query);
        $this->db->from('tra_transporte');
        $this->db->join('int_integrante', 'int_id_tra = tra_id', 'left');
        $this->db->join('rut_ruta', 'rut_id_tra = tra_id', 'left');
        $this->db->join('veh_vehiculo', 'tra_transporte.tra_id_veh = veh_vehiculo.veh_id', 'left');
        $this->db->join('cat_catalogo c1', 'veh_marca = c1.cat_id ');
        $this->db->join('cat_catalogo c2', 'veh_modelo = c2.cat_id');
        $this->db->join('pla_placa', 'veh_id = pla_id_veh AND pla_estado = 1');
        $this->db->group_by('tra_transporte.tra_id');
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function cargar_solicitudes_detalles($id_detalle) {
        $query = "tra_transporte.tra_id as identificador,tra_transporte.tra_fecha as fecha,tra_transporte.tra_hora as hora,tra_transporte.tra_destino as destino,tra_transporte.tra_motivo as motivo,(select count(int_integrante.int_id_emp) from int_integrante where int_id_tra=tra_id) as empleados";
        $this->db->select($query);
        $this->db->from('int_integrante');
        $this->db->join('tra_transporte', 'int_integrante.int_id_tra = tra_transporte.tra_id');
        $this->db->join('rut_ruta', 'rut_ruta.rut_id_tra = tra_transporte.tra_id');
        $this->db->where('tra_transporte.tra_id', $id_detalle);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function obtener_ruta($id) {
        $query = "mun_municipio.mun_nombre,mun_municipio.mun_id";
        $this->db->select($query);
        $this->db->from('rut_ruta');
        $this->db->join('tra_transporte', 'rut_ruta.rut_id_tra = tra_transporte.tra_id');
        $this->db->join('mun_municipio', 'rut_ruta.rut_id_mun = mun_municipio.mun_id');
        $this->db->where('rut_ruta.rut_id_tra', $id);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    public function ver_telefono($con_id) {
        $query = "tel_id, tel_telefono, tel_nombre";
        $this->db->select($query);
        $this->db->from('tel_telefono');
        $this->db->join('txc_telefonoxcontacto', 'txc_id_tel=tel_id');
        $this->db->where('txc_id_con =', $con_id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function ver_correo($con_id) {
        $query = "cor_id, cor_correo, cor_nombre";
        $this->db->select($query);
        $this->db->from('cor_correo');
        $this->db->join('cxc_correoxcontacto', 'cxc_id_cor=cor_id');
        $this->db->where('cxc_id_con =', $con_id);
        $query = $this->db->get();
        return $query->result_array();
    }

    function obtener_empleado($em) {
        $query = "tra_transporte.tra_id,int_integrante.int_id_emp,int_integrante.int_id,emp_empleado.emp_nombres,emp_empleado.emp_apellidos,emp_empleado.emp_id,emp_empleado.emp_estado,emp_empleado.emp_codigo,emp_empleado.emp_id_car,emp_empleado.emp_id_are,are_area.are_nombre,are_area.are_id,car_cargo.car_cargo";
        $this->db->select($query);
        $this->db->from('emp_empleado');
        $this->db->join('car_cargo', 'emp_empleado.emp_id_car = car_cargo.car_id');
        $this->db->join('are_area', 'emp_empleado.emp_id_are = are_area.are_id');
        $this->db->join('int_integrante', 'int_integrante.int_id_emp = emp_empleado.emp_id');
        $this->db->join('tra_transporte', 'int_integrante.int_id_tra = tra_transporte.tra_id');
        $this->db->where('int_integrante.int_id_tra', $em);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function empleado_unidad() {
        $query = "are_area.are_nombre as area,emp_empleado.emp_nombres as empleado,emp_empleado.emp_apellidos as apellido,are_area.are_id as id_area,emp_empleado.emp_id as id_empleado";
        $this->db->select($query);
        $this->db->from('emp_empleado');
        $this->db->join('are_area', 'emp_empleado.emp_id_are = are_area.are_id');
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function motoristas() {
        $query = "are_area.are_nombre,emp_empleado.emp_nombres,emp_empleado.emp_apellidos,are_area.are_id,mot_motorista.mot_licencia,mot_motorista.mot_id";
        $this->db->select($query);
        $this->db->from('emp_empleado');
        $this->db->join('are_area', 'emp_empleado.emp_id_are = are_area.are_id');
        $this->db->join('mot_motorista', 'mot_motorista.mot_id_emp = emp_empleado.emp_id');
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function motorista_vehiculo($filtro_busqueda) {
        $query = "emp_empleado.emp_nombres,emp_empleado.emp_apellidos,mot_motorista.mot_licencia,mot_motorista.mot_id";
        $query = "emp_empleado.emp_nombres,emp_empleado.emp_apellidos,mot_motorista.mot_licencia,tra_transporte.tra_id,mot_motorista.mot_id";
        $this->db->select($query);
        $this->db->from('mot_motorista');
        $this->db->join('emp_empleado', 'mot_motorista.mot_id_emp = emp_empleado.emp_id');
        $this->db->join('tra_transporte', 'tra_transporte.tra_id_mot = mot_motorista.mot_id');
        $this->db->where('tra_transporte.tra_id', $filtro_busqueda);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function mostrar_vehiculo($solicitud) {
        $query = "veh_vehiculo.veh_id as id,,veh_vehiculo.veh_marca as marca,veh_vehiculo.veh_modelo as modelo";
        $this->db->select($query);
        $this->db->from('tra_transporte');
        $this->db->join('veh_vehiculo', 'tra_transporte.tra_id_veh = veh_vehiculo.veh_id');
        if ($solicitud != "")
            $this->db->where('tra_transporte.tra_id', $solicitud);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function cargar_serie($id) {
        $query = "distinct(val_serie)";
        $this->db->select($query);
        $this->db->from('val_vale');
        $this->db->where('val_id_vat', $id);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function cargar_numeros($para1, $para2) {

        $query = "val_numero";
        $this->db->select($query);
        $this->db->from('val_vale');
        $this->db->where('val_id_fdf', $para1);
        $this->db->where_in('val_id', $para2);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function obtener_id_vales($fuente, $i) {
        $query = "val_id";
        $this->db->select($query);
        $this->db->from('val_vale');
        $this->db->where('val_id_fdf', $fuente);
        $this->db->where('val_numero', $i);
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function consultar_vales() {
        $query = "txv_transportexvale.tra_id, if(txv_transportexvale.tra_id != '','true','false') as condicion";
        $this->db->select($query, false);
        $this->db->from('txv_transportexvale');
        $this->db->join('tra_transporte', 'txv_transportexvale.tra_id = tra_transporte.tra_id');
        $this->db->group_by('txv_transportexvale.tra_id');
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function get_registro($tabla, $where = null) {

        if (!$tabla && !is_string($tabla)) {
            return null;
        }

        if ($where) {
            $this->db->where($where);
        }
        $result = $this->db->get($tabla);

        if ($result->num_rows() > 1) {
            return $result->result();
        } else
        if ($result->num_rows() == 1) {
            return $result->row();
        }
    }

    function get_campo($tabla, $campo, $where) {
        //die($where);
        //obtenemos el registro
        $registro = $this->get_registro($tabla, $where);

        if ($registro) {
            foreach ($registro as $field => $value) {
                if ($field == $campo) {
                    return $value;
                }
            }
        }
        return null;
    }

    function vales_factura() {
        $query = "txf_id_val";
        $this->db->select();
        $this->db->from('txf_transportexfactura');
        $resultado = $this->db->get();
        return $resultado->result_array();
    }

    function mostrar_vales_asignados($id_solicitud) {
        $sub_consulta = $this->vales_factura();
        if (count($sub_consulta) == 0)
            $sub_consulta = array('txf_id_val' => 0);
        $query = "txv_transportexvale.val_id";
        $this->db->select($query);
        $this->db->from('txv_transportexvale');
        $this->db->where('txv_transportexvale.tra_id', $id_solicitud);
        $this->db->where_not_in('val_id', $sub_consulta['txf_id_val']);
        $informacion = $this->db->get();
        return $informacion->result_array();
    }

    function mostrar_placa() {
        $query = "pla_placa.pla_numero, veh_vehiculo.veh_id";
        $this->db->select($query);
        $this->db->from('pla_placa');
        $this->db->join('veh_vehiculo', 'pla_placa.pla_id_veh = veh_vehiculo.veh_id');
        $informacion = $this->db->get();
        return $informacion->result_array();
    }

    function get_padre($id) {
        $hijo = $this->cargar_registro('ubi_ubicacion', 'ubi_id', $id);
        $padre = $this->cargar_registro('ubi_ubicacion', 'ubi_id', $hijo['ubi_padre']);
        if (isset($padre['ubi_id'])) {
            $cadena = $hijo['ubi_nombre'] . ' ' . $padre['ubi_nombre'] . ' ';
            while ($padre['ubi_padre'] != null) {
                $padre = $this->cargar_registro('ubi_ubicacion', 'ubi_id', $padre['ubi_padre']);
                $cadena .= $padre['ubi_nombre'] . ' ';
            }
            return $cadena;
        } else
            return '';
    }

    function get_registros_inventario($ubicacion, $fecha) {
        $query = "dif_detalle_inventario_fisico.dif_id_act";
        $this->db->select($query);
        $this->db->from('dif_detalle_inventario_fisico');
        $this->db->join('inf_inventario_fisico', 'dif_detalle_inventario_fisico.dif_id_inf = inf_inventario_fisico.inf_id');
        $this->db->where('inf_id_ubi', $ubicacion);
        $this->db->where('inf_fecha', $fecha);
        $informacion = $this->db->get();
        return $informacion->result_array();
    }

    function get_id_activos($id) {
        if ($id != null) {
            $query = "axe_activoxempleado.axe_id_act";
            $this->db->select($query);
            $this->db->from('axe_activoxempleado');
            $this->db->where('axe_activoxempleado.axe_id_ubi', $id);
            $informacion = $this->db->get();
            return $informacion->result_array();
        } else {
            return '';
        }
    }

    function obtener_detalles($id_activos) {
        $query = "axe_activoxempleado.axe_id,act_activo_fijo.act_nombre,act_activo_fijo.act_codigo,emp_empleado.emp_nombres,emp_empleado.emp_apellidos,emp_empleado.emp_nit,emp_empleado.emp_dui,emp_empleado.emp_salario,emp_empleado.emp_fecha_ingreso,emp_empleado.emp_telefono";
        $this->db->select($query);
        $this->db->from('axe_activoxempleado');
        $this->db->join('emp_empleado', 'axe_activoxempleado.axe_id_emp = emp_empleado.emp_id');
        $this->db->join('act_activo_fijo', 'axe_activoxempleado.axe_id_act = act_activo_fijo.act_id');
        $this->db->where_in('act_activo_fijo.act_id', $id_activos);

        $informacion = $this->db->get();
        return $informacion->result_array();
    }

    function cargar_ubicaciones_por_tipo($id) {
        $this->db->select();
        $this->db->from('ubi_ubicacion');
        $this->db->where('ubi_id_tiu', $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * @author Alexis
     * @since 2013-11-26
     */
    function cargar_oficinas($id, $selected = null) {
        $data['response'] = true;
        $data['message'] = $this->gsatelite->get_dropdown('vw_oficina', '{nivel} >> {oficina}', '', array('regional_id' => $id), $selected, '', 'ubi_id', true);
        return $data;
    }

    /**
     * @author Ronald
     * @author Alexis 20131126
     */
    function cargar_areas($id, $selected = null) {

        $this->db->select('are_id, are_nombre');
        $this->db->from('are_area');
        $this->db->join('axu_areaxubicacion', 'axu_id_are = are_id');
        $this->db->join('vw_oficina', 'axu_id_ubi = ubi_id');
        $this->db->where('regional_id', $id);
        $this->db->group_by('are_id');
        $query = $this->db->get();

        $data['response'] = ($query->num_rows() > 0);
        $data['message'] = array();
        if (is_object($query) && $query->num_rows() > 0) {

            foreach ($query->result() as $row) {
                $data['message'][] = array('are_id' => $row->are_id, 'are_nombre' => $row->
                    are_nombre);
            }
        }
        return $data;
    }

    function obtener_detalles_fecha($array_id, $fecha, $ubicacion) {
        $query = "act_activo_fijo.act_nombre,act_activo_fijo.act_codigo,emp_empleado.emp_nombres,emp_empleado.emp_apellidos,emp_empleado.emp_telefono";
        $this->db->select();
        $this->db->from('dif_detalle_inventario_fisico');
        $this->db->join('inf_inventario_fisico', 'dif_detalle_inventario_fisico.dif_id_inf = inf_inventario_fisico.inf_id', 'left');
        $this->db->join('act_activo_fijo', 'dif_detalle_inventario_fisico.dif_id_act = act_activo_fijo.act_id', 'left');
        $this->db->join('axe_activoxempleado', 'axe_activoxempleado.axe_id_act = act_activo_fijo.act_id and axe_activoxempleado.axe_estado = 1 and axe_activoxempleado.axe_id_ubi=' .
                $ubicacion, 'left');
        $this->db->join('emp_empleado', 'axe_activoxempleado.axe_id_emp = emp_empleado.emp_id', 'left');
        $this->db->where_in('act_activo_fijo.act_id', $array_id);
        $this->db->where('inf_fecha', $fecha);
        $query = $this->db->get();
        return $query->result_array();
    }

    function cargar_catalogo_por_tipo($valores) {
        $this->db->select();
        $this->db->from('cat_catalogo');
        $this->db->where($valores);
        $query = $this->db->get();
        return $query->result_array();
    }

    function get_padre_region($id) {
        $hijo = $this->cargar_registro('reg_region', 'reg_id', $id);
        $padre = $this->cargar_registro('reg_region', 'reg_id', $hijo['reg_padre']);
        if (isset($padre['reg_id'])) {
            $cadena = $hijo['reg_nombre'] . ' - ' . $padre['reg_nombre'];
            while ($padre['reg_padre'] != null) {
                $padre = $this->cargar_registro('reg_region', 'reg_id', $padre['reg_padre']);
                $cadena .= ' - ' . $padre['reg_nombre'];
            }
            return $cadena;
        } else
            return '';
    }

    function get_padre_area($id) {
        $hijo = $this->cargar_registro('are_area', 'are_id', $id);
        $padre = $this->cargar_registro('are_area', 'are_id', $hijo['are_padre']);
        if (isset($padre['are_id'])) {
            $cadena = $hijo['are_nombre'] . ' < ' . $padre['are_nombre'];
            while ($padre['are_padre'] != null) {
                $padre = $this->cargar_registro('are_area', 'are_id', $padre['are_padre']);
                $cadena .= ' < ' . $padre['are_nombre'];
            }
            return $cadena;
        } else
            return '';
    }

    function actualizar_axu($id, $info) {
        $this->db->where('axu_id', $id);
        $this->db->update('axu_areaxubicacion', $info);
        return true;
    }

    function obtener_informacion_scondicion($arreglo_id) {
        $query = "cat_catalogo.cat_nombre, pro_proceso.pro_id as identificador,pro_proceso.pro_id,pro_proceso.pro_nombre,pro_proceso.pro_codigo,pro_proceso.pro_tipo,are_area.are_nombre,acc_accion.acc_desc as descripcion,prv_proveedor.prv_nombre,prv_proveedor.prv_codigo,prv_proveedor.prv_id";
        $this->db->select($query);
        $this->db->from('pro_proceso');
        $this->db->join('req_requisicion', 'req_requisicion.req_id = pro_proceso.pro_id_req');
        $this->db->join('erpconamype.pxp_procesoxproveedor', 'pxp_procesoxproveedor.pxp_id_pro = pro_proceso.pro_id ');
        $this->db->join('prv_proveedor', 'prv_proveedor.prv_id = pxp_procesoxproveedor.pxp_id_prv');
        $this->db->join('acc_accion', 'acc_accion.acc_id = req_requisicion.req_id_acc');
        $this->db->join('pre_presupuesto', 'pre_presupuesto.pre_id = acc_accion.acc_id_pre');
        $this->db->join('are_area', 'are_area.are_id = pre_presupuesto.pre_id_are');
        $this->db->join('cat_catalogo', 'pro_proceso.pro_tipo= cat_catalogo.cat_id');
        $this->db->where_in('pro_id', $arreglo_id);
        $rs = $this->db->get();
        //echo $this->db->last_query();
        return $rs->result_array();
    }

    function obtener_informacion_scondicion_sin_contrato($arreglo_id, $sin_contrato) {
        $query = "con_contrato.con_id as con_id, con_contrato.con_codigo, con_contrato.con_fecha_firma, con_contrato.con_fecha_fin, con_contrato.con_monto, pro_proceso.pro_id as identificador,pro_proceso.pro_id,pro_proceso.pro_nombre,pro_proceso.pro_codigo,pro_proceso.pro_tipo,are_area.are_nombre,acc_accion.acc_desc as descripcion,prv_proveedor.prv_nombre,prv_proveedor.prv_codigo,prv_proveedor.prv_id, con_contrato.con_admin";
        $this->db->select($query);
        $this->db->from('pro_proceso');
        $this->db->join('req_requisicion', 'req_requisicion.req_id = pro_proceso.pro_id_req');
        $this->db->join('pxp_procesoxproveedor', 'pxp_procesoxproveedor.pxp_id_pro = pro_proceso.pro_id');
        $this->db->join('prv_proveedor', 'prv_proveedor.prv_id = pxp_procesoxproveedor.pxp_id_prv');
        $this->db->join('acc_accion', 'acc_accion.acc_id = req_requisicion.req_id_acc');
        $this->db->join('pre_presupuesto', 'pre_presupuesto.pre_id = acc_accion.acc_id_pre');
        $this->db->join('are_area', 'are_area.are_id = pre_presupuesto.pre_id_are');
        $this->db->join('con_contrato', 'con_contrato.con_id_pro = pro_proceso.pro_id', "LEFT");
        $this->db->where_in('pro_id', $arreglo_id);

        if ($sin_contrato == 1) {
            $this->db->where("con_contrato.con_id IS NULL");
        } else {
            $this->db->where("IFNULL(con_contrato.con_id, 0) > 0");
        }


        $rs = $this->db->get();
        return $rs->result_array();
        //echo $this->db->last_query();
    }

    function obtener_informacion_condicion($arreglo_id, $fuente = '', $tipo = '', $area = '') {
        $query = "pro_proceso.pro_id as identificador,pro_proceso.pro_nombre,pro_proceso.pro_codigo,pro_proceso.pro_tipo,are_area.are_nombre,cat_catalogo.cat_nombre as tipo,acc_accion.acc_desc as descripcion,prv_proveedor.prv_nombre,prv_proveedor.prv_codigo,prv_proveedor.prv_id";
        $this->db->select($query);
        if ($area == '') {
            $cadena = 'are_area.are_id = pre_presupuesto.pre_id_are';
        } else {
            $cadena = 'are_area.are_id = pre_presupuesto.pre_id_are AND are_area.are_id =' .
                    $area;
        }

        if ($tipo == '') {
            $cadena_tipo = 'cat_catalogo.cat_id = acc_accion.acc_tipo';
        } else {
            $cadena_tipo = 'cat_catalogo.cat_id = acc_accion.acc_tipo AND cat_catalogo.cat_id =' .
                    $tipo;
        }
        $this->db->from('pro_proceso');
        $this->db->join('req_requisicion', 'req_requisicion.req_id = pro_proceso.pro_id_req');
        $this->db->join('pxp_procesoxproveedor', 'pxp_procesoxproveedor.pxp_id_pro = pro_proceso.pro_id');
        $this->db->join('prv_proveedor', 'prv_proveedor.prv_id = pxp_procesoxproveedor.pxp_id_prv');
        $this->db->join('acc_accion', 'acc_accion.acc_id = req_requisicion.req_id_acc');
        $this->db->join('pre_presupuesto', 'pre_presupuesto.pre_id = acc_accion.acc_id_pre');
        $this->db->join('are_area', $cadena);
        $this->db->join('cat_catalogo', $cadena_tipo);
        $this->db->where_in('pro_id', $arreglo_id);
        $rs = $this->db->get();
        return $rs->result_array();
    }

    function obtener_fuente_financiamiento($area) {
        $query = "are_area.are_nombre,fdf_fuente_financiamiento.fdf_codigo,fdf_fuente_financiamiento.fdf_nombre,fdf_fuente_financiamiento.fdf_id,are_area.are_id";
        $this->db->select($query);
        $this->db->from('pre_presupuesto');
        $this->db->join('cov_convenio', 'pre_presupuesto.pre_id_cov = cov_convenio.cov_id');
        $this->db->join('are_area', 'pre_presupuesto.pre_id_are = are_area.are_id');
        $this->db->join('cxf_convenioxfuente', 'cxf_convenioxfuente.cxf_id_cov = cov_convenio.cov_id');
        $this->db->join('fdf_fuente_financiamiento', 'cxf_convenioxfuente.cxf_id_fdf = fdf_fuente_financiamiento.fdf_id');
        if ($area != 'todas') {
            $this->db->where('are_id', $area);
        }

        $this->db->group_by('fdf_fuente_financiamiento.fdf_id');
        $rs = $this->db->get();
        return $rs->result_array();
    }

    function generar_programacion_ejecutable_presupuestaria($area, $fuente_financiamiento, $acciones_aprobadas_ids = null) {

        $where = '';
        if ($area != 'todas') {
            $where .= "where pre_presupuesto.pre_id_are = '$area' ";
        }

        if ($area != 'todas' && $fuente_financiamiento != 'todas') {
            $where .= " and ";
        }
        if ($fuente_financiamiento != 'todas') {
            $where .= " pre_presupuesto.pre_id_fdf = '$fuente_financiamiento' ";
        }

        if ($fuente_financiamiento != 'todas' and $area == 'todas') {
            $where = '';
            $where .= "WHERE pre_presupuesto.pre_id_fdf = '$fuente_financiamiento' ";
        }
        if ($area != 'todas' and $fuente_financiamiento == 'todas') {
            $where = '';
            $where .= "WHERE pre_presupuesto.pre_id_are = '$area' ";
        }
        // echo 'este where es de la modelo.'.$where.'<br>';

        if ($where != '') {
            $rs = 'SELECT dac.dac_mes,SUM(dac.dac_monto) AS monto,cpr_cuenta_presupuesto.cpr_numero, GROUP_CONCAT(dac.`dac_id`) AS dacs FROM acc_accion 
            INNER JOIN dac_detalle_accion dac ON dac.dac_id_acc = acc_accion.`acc_id`
            inner join cpr_cuenta_presupuesto ON dac.dac_id_cpr = cpr_cuenta_presupuesto.cpr_id
            WHERE acc_accion.acc_id_pre IN(
                (SELECT pre_presupuesto.pre_id    
                  from pre_presupuesto
                  ' . $where . '
                  ))
and dac.dac_id IN (' . $acciones_aprobadas_ids .
                    ')
group by dac.dac_mes,cpr_cuenta_presupuesto.cpr_numero';
        } else {
            $rs = 'SELECT dac.dac_mes,SUM(dac.dac_monto) AS monto,cpr_cuenta_presupuesto.cpr_numero, GROUP_CONCAT(dac.`dac_id`) AS dacs FROM acc_accion 
    INNER JOIN dac_detalle_accion dac ON dac.dac_id_acc = acc_accion.`acc_id`
    inner join cpr_cuenta_presupuesto ON dac.dac_id_cpr = cpr_cuenta_presupuesto.cpr_id
    WHERE acc_accion.acc_id_pre IN(
        (SELECT pre_presupuesto.pre_id    
          from pre_presupuesto
          ))
and dac.dac_id IN (' . $acciones_aprobadas_ids .
                    ')
group by dac.dac_mes,cpr_cuenta_presupuesto.cpr_numero';
        }


        $obtener_informacion = $this->db->query($rs);
        // echo $this->db->last_query();
        return $obtener_informacion->result_array();
    }

    function get_informacion_reprogramacion($id_usuario) {
        $id_usuario = 7;
        $query = "select acc_id,acc_desc, acc_monto, 
    @entrada:=(select SUM(drp_monto) from drp_detalle_reprogramacion where acc_id=drp_id_acc_destino)  as entrada,
    @salida:=(select SUM(drp_monto) from drp_detalle_reprogramacion where acc_id=drp_id_acc_origen) as salida,
    @total:= acc_monto+(IF(@entrada != 'null',@entrada,0)-IF(@salida != 'null',@salida,0)) as total,
    fdf_fuente_financiamiento.fdf_codigo,
    fdf_fuente_financiamiento.fdf_nombre
    FROM are_area
    INNER JOIN pre_presupuesto ON pre_presupuesto.pre_id_are = are_area.are_id
    INNER JOIN acc_accion ON acc_accion.acc_id_pre = pre_presupuesto.pre_id
    INNER JOIN fdf_fuente_financiamiento ON fdf_fuente_financiamiento.fdf_id = pre_presupuesto.pre_id_fdf
    WHERE are_area.are_id = (select are_area.are_id from users inner join are_area ON (users.use_id_are = are_area.are_id)
       where users.id =" . $id_usuario . ")";
        $obtener_informacion = $this->db->query($query);
        return $obtener_informacion->result_array();
    }

    /**
     * Consultas::get_acc_montos()
     * 
     * @author Alexis Beltran
     * @since 2013-08-13
     * @return result
     */
    function get_acc_montos($acc_id) {
        $query = 'Select
        acc_accion.acc_id,
        acc_accion.acc_monto As original,
        @reservado := (If(IfNull(req.req_id, 0) And IfNull(con_contrato.con_monto,
          0) = 0, rep.total, 0.0)) As reservado,
@comprometido := If(IfNull(con_contrato.con_monto, 0), con_contrato.con_monto,
  0.0) As comprometido,
If(@comprometido > 0 And IfNull(con_contrato.con_monto, 0), rep.total -
  con_contrato.con_monto, If(@reservado = 0, rep.total, 0.0)) As disponible
From
acc_accion Left Join
(Select
    req_requisicion.req_id_acc,
    req_requisicion.req_id
    From
    req_requisicion
    Group By
    req_requisicion.req_id_acc
    Order By
    req_requisicion.req_fecha Desc) As req On acc_accion.acc_id = req.req_id_acc
Left Join
pro_proceso On req.req_id = pro_proceso.pro_id_req Left Join
con_contrato On con_contrato.con_id_pro = pro_proceso.pro_id Inner Join
(Select
    acc.acc_id,
    @entrada := (Select
      Sum(drp_detalle_reprogramacion.drp_monto)
      From
      drp_detalle_reprogramacion
      Where
      acc.acc_id = drp_detalle_reprogramacion.drp_id_acc_destino) As entrada,
@salida := (Select
  Sum(drp_detalle_reprogramacion.drp_monto)
  From
  drp_detalle_reprogramacion
  Where
  acc.acc_id = drp_detalle_reprogramacion.drp_id_acc_origen) As salida,
acc.acc_monto + (If(IfNull(@entrada, 0), @entrada, 0.0) -
    If(IfNull(@salida, 0), @salida, 0.0)) As total
From
acc_accion acc) As rep On acc_accion.acc_id = rep.acc_id
Where
acc_accion.acc_id = ' . $acc_id . '  
Order By
acc_accion.acc_id';
        $return = $this->db->query($query);
        return $return->result_array();
    }

    function informacion_empleado($id_usuario) {
        $query = "are_area.are_nombre, users.username, users.email,users.id";
        $this->db->select($query);
        $this->db->from('users');
        $this->db->join('are_area', 'users.use_id_are = are_area.are_id');
        $this->db->where('users.id', $id_usuario);
        $rs = $this->db->get();
        return $rs->result_array();
    }

    function obtener_rubros($id_accion) {
        $query = 'SELECT cpr_cuenta_presupuesto.cpr_rubro, cpr_cuenta_presupuesto.cpr_id
    FROM    (   (   pre_presupuesto pre_presupuesto
       INNER JOIN
       are_area are_area
       ON (pre_presupuesto.pre_id_are = are_area.are_id))
INNER JOIN
acc_accion acc_accion
ON (acc_accion.acc_id_pre = pre_presupuesto.pre_id))
INNER JOIN
cpr_cuenta_presupuesto cpr_cuenta_presupuesto
ON (acc_accion.acc_id_cpr = cpr_cuenta_presupuesto.cpr_id)
WHERE are_area.are_id = (select are_area.are_id from users inner join are_area ON (users.use_id_are = are_area.are_id)
   where users.id = ' . $id_accion . ')';
        $obtener_informacion = $this->db->query($query);
        return $obtener_informacion->result_array();
    }

    function obtener_accionesxrubro($id_accion) {
        $query = 'select are_area.are_nombre,acc_accion.acc_desc,vw_acc_montos.disponible as disponible,vw_acc_montos.acc_id as accion from acc_accion 
    LEFT JOIN vw_acc_montos ON acc_accion.acc_id = vw_acc_montos.acc_id
    LEFT JOIN cpr_cuenta_presupuesto ON cpr_cuenta_presupuesto.cpr_id = acc_accion.acc_id_cpr
    LEFT JOIN pre_presupuesto ON acc_accion.acc_id_pre = pre_presupuesto.pre_id
    LEFT JOIN are_area ON are_area.are_id = pre_presupuesto.pre_id_are
    WHERE cpr_cuenta_presupuesto.cpr_rubro = (Select
        cpr_cuenta_presupuesto.cpr_rubro
        From
        acc_accion Inner Join
        cpr_cuenta_presupuesto On acc_accion.acc_id_cpr =
        cpr_cuenta_presupuesto.cpr_id
        Where
        acc_accion.acc_id = ' . $id_accion .
                ') AND vw_acc_montos.disponible > 0 AND acc_accion.acc_id NOT IN (' . $id_accion .
                ')';

        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function obtener_areas($id_usuario) {
        $query = 'SELECT are_area.are_id
    FROM    users users
    INNER JOIN
    are_area are_area
    ON (users.use_id_are = are_area.are_id)
    WHERE users.id =' . $id_usuario;
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function conteo_requisicionxaccion($id_accion) {
        $query = 'COUNT(rep_reprogramacion.rep_id) as total_reprogramaciones';
        $this->db->select($query);
        $this->db->from('acc_accion');
        $this->db->join('drp_detalle_reprogramacion', 'drp_detalle_reprogramacion.drp_id_acc_destino = acc_accion.acc_id');
        $this->db->join('rep_reprogramacion', 'rep_reprogramacion.rep_id = drp_detalle_reprogramacion.drp_id_rep', 'left');
        $this->db->where('drp_detalle_reprogramacion.drp_id_acc_destino', $id_accion);
        $rs = $this->db->get();
        return $rs->result_array();
    }

    function verificar_registros($from, $where) {
        $this->db->select();
        $this->db->from($from);
        $this->db->where($where);
        $query = $this->db->get();
        return $query->result_array();
    }

    function verificar_registro($from, $where) {
        $this->db->select();
        $this->db->from($from);
        $this->db->where($where);
        $query = $this->db->get();
        return $query->row_array();
    }

    function cargar_filtros($rep_id) {
        $this->db->select();
        $this->db->from('fil_filtro');
        $this->db->where('fil_id_rep', $rep_id);
        $query = $this->db->get();

        $data['response'] = true;
        $data['message'] = array();
        if (is_object($query) && $query->num_rows() > 0) {

            foreach ($query->result() as $row) {
                $data['message'][] = array('are_id' => $row->are_id, 'are_nombre' => $row->
                    are_nombre);
            }
        }
        return $data;
    }

    function cargar_reportes($rol) {
        $this->db->select();
        $this->db->from('rep_reporte');
        $this->db->join('rxr_reportexrol', ' rep_reporte.rep_id = rxr_reportexrol.rxr_id_rep');
        $this->db->where('rxr_reportexrol.rxr_id_rol', $rol);
        $rs = $this->db->get();
        return $rs->result_array();
    }

    function asignacion_empleado_inventario($id_area) {
        $query = "users.id,users.username,are_nombre";
        $this->db->select($query);
        $this->db->from('users');
        $this->db->join('are_area', 'are_area.are_id = users.use_id_are');
        $this->db->where('are_area.are_id', $id_area);
        $rs = $this->db->get();
        return $rs->result_array();
    }

    function get_solicitudes_inventario($id_solicitud = '-') {
        $query = "";
        if ($id_solicitud == "-") {
            $query = "SELECT GROUP_CONCAT(art_articulo.art_nombre SEPARATOR ',') as conjunto,
        are_area.are_nombre,
        users.username,
        rxi_requisicion_inventario.rxi_id,
        rxi_requisicion_inventario.rxi_fecha
        FROM    (   (   (   users users
           INNER JOIN
           are_area are_area
           ON (users.use_id_are = are_area.are_id))
INNER JOIN
rxi_requisicion_inventario
ON (rxi_requisicion_inventario.rxi_id_user = users.id))
INNER JOIN
dri_detalle_requisicion_inventario
ON (dri_detalle_requisicion_inventario.dri_id_rxi =
  rxi_requisicion_inventario.rxi_id))
INNER JOIN
art_articulo art_articulo
ON (dri_detalle_requisicion_inventario.dri_id_art = art_articulo.art_id)
WHERE rxi_estado = 1
Group by rxi_requisicion_inventario.rxi_id";
        } else {
            $query = "SELECT GROUP_CONCAT(art_articulo.art_nombre SEPARATOR ',') as conjunto,
    are_area.are_nombre,
    users.username,
    rxi_requisicion_inventario.rxi_id,
    rxi_requisicion_inventario.rxi_fecha
    FROM    (   (   (   users users
       INNER JOIN
       are_area are_area
       ON (users.use_id_are = are_area.are_id))
INNER JOIN
rxi_requisicion_inventario
ON (rxi_requisicion_inventario.rxi_id_user = users.id))
INNER JOIN
dri_detalle_requisicion_inventario
ON (dri_detalle_requisicion_inventario.dri_id_rxi =
  rxi_requisicion_inventario.rxi_id))
INNER JOIN
art_articulo art_articulo
ON (dri_detalle_requisicion_inventario.dri_id_art = art_articulo.art_id)
WHERE rxi_estado = 1 AND rxi_requisicion_inventario.rxi_id =" . $id_solicitud .
                    "
Group by rxi_requisicion_inventario.rxi_id ";
        }
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function productos_solicitud_inventario($id_solicitud) {
        $campos = "art_articulo.art_nombre,art_articulo.art_id";
        $this->db->select($campos);
        $this->db->from('dri_detalle_requisicion_inventario');
        $this->db->join('art_articulo', 'dri_detalle_requisicion_inventario.dri_id_art = art_articulo.art_id');
        $this->db->join('rxi_requisicion_inventario', 'dri_detalle_requisicion_inventario.dri_id_rxi =  rxi_requisicion_inventario.rxi_id');
        $this->db->where('rxi_requisicion_inventario.rxi_id', $id_solicitud);
        $this->db->where('rxi_estado', 1);
        $rs = $this->db->get();
        return $rs->result_array();
    }

    function get_cantidad_articulos_solicitud($id_articulo, $id_solicitud) {
        $query = "SELECT dri_detalle_requisicion_inventario.dri_cantidad
    FROM    dri_detalle_requisicion_inventario
    INNER JOIN
    rxi_requisicion_inventario
    ON (dri_detalle_requisicion_inventario.dri_id_rxi =
      rxi_requisicion_inventario.rxi_id)
where rxi_requisicion_inventario.rxi_id =" . $id_solicitud .
                " and dri_detalle_requisicion_inventario.dri_id_art =" . $id_articulo . "
and rxi_requisicion_inventario.rxi_estado = 1";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_bodegas_articulos($id_articulo) {
        $query = "SELECT bod_bodega.bod_id, bod_bodega.bod_nombre
    FROM    (   sar_saldos_articulos sar_saldos_articulos
       INNER JOIN
       bod_bodega bod_bodega
       ON (sar_saldos_articulos.sar_id_bod = bod_bodega.bod_id))
INNER JOIN
art_articulo art_articulo
ON (sar_saldos_articulos.sar_id_art = art_articulo.art_id)
WHERE art_articulo.art_id =" . $id_articulo .
                " AND sar_saldos_articulos.sar_cant_actual > 0";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_fuentes_vales() {
        $query = "
    Select
    Count(*) As cantidad,
    vat_tipo.vat_valor As valor,
    fdf_fuente_financiamiento.fdf_id,
    fdf_fuente_financiamiento.fdf_codigo,
    fdf_fuente_financiamiento.fdf_nombre
    From
    fdf_fuente_financiamiento Inner Join
    val_vale On val_vale.val_id_fdf = fdf_fuente_financiamiento.fdf_id Inner Join
    vat_tipo On val_vale.val_id_vat = vat_tipo.vat_id
    Where
    pro_get_orden_actual(5, val_vale.val_id) = 2
    Group By
    fdf_fuente_financiamiento.fdf_id,
    fdf_fuente_financiamiento.fdf_codigo, fdf_fuente_financiamiento.fdf_nombre";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function numero_vales($id_fuente) {
        $this->db->select('COUNT(val_id) as cantidad');
        $this->db->from('val_vale');
        $this->db->where('val_id_fdf', $id_fuente);
        $rs = $this->db->get();
        return $rs->result_array();
    }

    function vehiculo_disponible($fecha) {

        $query = "select veh_id,c1.cat_nombre as marca, c2.cat_nombre as modelo, pla_numero as placa from veh_vehiculo 
    INNER JOIN cat_catalogo c1 ON veh_marca = c1.cat_id 
    INNER JOIN cat_catalogo c2 ON veh_modelo = c2.cat_id 
    INNER JOIN pla_placa ON veh_id = pla_id_veh AND pla_estado = 1
    WHERE veh_id NOT IN(select veh_id from tra_transporte INNER JOIN veh_vehiculo ON tra_id_veh = veh_id WHERE tra_fecha ='" .
                $fecha . "')";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_vales_asignados($id_solicitud) {
        $query = "
    Select
    val_vale.val_id,
    val_vale.val_serie,
    val_vale.val_numero
    From
    val_vale Left Join
    vxf_valexfactura On vxf_valexfactura.vxf_id_val = val_vale.val_id Inner Join
    txv_transportexvale On txv_transportexvale.val_id = val_vale.val_id
    Where
    txv_transportexvale.tra_id = $id_solicitud And
    vxf_valexfactura.vxf_id_fac Is Null";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_productos_bodega_cantidad($bodega) {
        $query = "SELECT sum(sar_saldos_articulos.sar_cant_actual) as sar_cant_actual,
    art_articulo.art_id,
    art_articulo.art_nombre
    FROM    (   sar_saldos_articulos sar_saldos_articulos
       INNER JOIN
       bod_bodega bod_bodega
       ON (sar_saldos_articulos.sar_id_bod = bod_bodega.bod_id))
INNER JOIN
art_articulo art_articulo
ON (sar_saldos_articulos.sar_id_art = art_articulo.art_id)
WHERE bod_bodega.bod_id = " . $bodega . "
GROUP BY art_id
";

        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function historial_solicitudes($usuario) {
        $query = "SELECT GROUP_CONCAT(art_articulo.art_nombre SEPARATOR ',') as conjunto,
    are_area.are_nombre,
    users.username,
    rxi_requisicion_inventario.rxi_id,
    rxi_requisicion_inventario.rxi_fecha,
    rxi_requisicion_inventario.rxi_estado,
    rxi_requisicion_inventario.rxi_documento
    FROM    (   (   (   users users
       INNER JOIN
       are_area are_area
       ON (users.use_id_are = are_area.are_id))
INNER JOIN
rxi_requisicion_inventario
ON (rxi_requisicion_inventario.rxi_id_user = users.id))
INNER JOIN
dri_detalle_requisicion_inventario
ON (dri_detalle_requisicion_inventario.dri_id_rxi =
  rxi_requisicion_inventario.rxi_id))
INNER JOIN
art_articulo art_articulo
ON (dri_detalle_requisicion_inventario.dri_id_art = art_articulo.art_id)
WHERE users.id = " . $usuario .
                " Group by rxi_requisicion_inventario.rxi_id";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function detalle_requisicion_inventario($id_solicitud) {
        $query = "select dri_id,dri_cantidad,art_nombre, rxi_requisicion_inventario.rxi_id,art_id,sar_cant_actual FROM dri_detalle_requisicion_inventario
    INNER JOIN rxi_requisicion_inventario
    ON rxi_requisicion_inventario.rxi_id = dri_detalle_requisicion_inventario.dri_id_rxi
    INNER JOIN art_articulo
    ON dri_detalle_requisicion_inventario.dri_id_art = art_articulo.art_id
    INNER JOIN sar_saldos_articulos
    ON dri_detalle_requisicion_inventario.dri_id_art = sar_saldos_articulos.sar_id_art
    WHERE rxi_id = " . $id_solicitud .
                " AND rxi_requisicion_inventario.rxi_estado = 1
    GROUP BY dri_detalle_requisicion_inventario.dri_id";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_return_vale($id_solicitud) {
        $query = "select val_id from txv_transportexvale where tra_id = " . $id_solicitud;
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    public function prueba_vales($id_solicitud) {
        $this->db->select('*');
        $this->db->from('txv_transportexvale');
        $this->db->where('txv_transportexvale.tra_id', $id_solicitud);
        $rs = $this->db->get();
        return $rs->result_array();
    }

    function solicitudes_rechazadas($solicitudes_rechazadas) {
        $query = "select GROUP_CONCAT(val_vale.val_numero SEPARATOR ',') as conjunto,
    COUNT(val_vale.val_numero) as conteo,
    tra_transporte.tra_destino,
    tra_transporte.tra_motivo,
    tra_transporte.tra_fecha,
    tra_transporte.tra_id
    FROM txv_transportexvale
    INNER JOIN val_vale ON val_vale.val_id = txv_transportexvale.val_id
    INNER JOIN tra_transporte ON tra_transporte.tra_id = txv_transportexvale.tra_id
    WHERE tra_transporte.tra_id IN (" . $solicitudes_rechazadas . ")
    group by tra_transporte.tra_id";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_solicitudes_rechazadas() {
        $query = "select * from tra_transporte where pro_get_orden_actual(3, tra_id) < 0";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function pdf_detalle_requisicion_inventario($id_solicitud) {
        $query = "SELECT distinct art_articulo.art_nombre,
    dri_detalle_requisicion_inventario.dri_cantidad,
    sar_saldos_articulos.sar_precio
    FROM    (   (   (   (   rxi_requisicion_inventario rxi_requisicion_inventario
       INNER JOIN
       users users
       ON (rxi_requisicion_inventario.rxi_id_user = users.id))
INNER JOIN
dri_detalle_requisicion_inventario dri_detalle_requisicion_inventario
ON (dri_detalle_requisicion_inventario.dri_id_rxi =
  rxi_requisicion_inventario.rxi_id))
INNER JOIN
bod_bodega bod_bodega
ON (rxi_requisicion_inventario.rxi_id_bod = bod_bodega.bod_id))
INNER JOIN
sar_saldos_articulos sar_saldos_articulos
ON (sar_saldos_articulos.sar_id_bod = bod_bodega.bod_id))
INNER JOIN
art_articulo art_articulo
ON (sar_saldos_articulos.sar_id_art = art_articulo.art_id)
WHERE rxi_requisicion_inventario.rxi_id = 12";
        $rs = $this->db->query($query);
        return $rs->result_array();
    }

    function get_movimientos() {
        $sql = "Select
    moi_movimiento_inv.moi_id,
    rxi_requisicion_inventario.rxi_id,
    tip_tipo_proceso.tip_id,
    moi_movimiento_inv.moi_id_bod As bod_id,
    tip_tipo_proceso.tip_nombre As tipo,
    Group_Concat(Distinct art_articulo.art_nombre) As detalle,
    moi_movimiento_inv.moi_fecha_mov As fecha,
    Sum(Case tip_tipo_proceso.tip_entrada
        When 1 Then dee_detalle_mov.dee_precio * dee_detalle_mov.dee_cantidad Else 0
        End) As entrada,
Sum(Case tip_tipo_proceso.tip_salida
    When 1 Then dee_detalle_mov.dee_precio * dee_detalle_mov.dee_cantidad Else 0
    End) As salida
From
moi_movimiento_inv Inner Join
tip_tipo_proceso On moi_movimiento_inv.moi_id_tip = tip_tipo_proceso.tip_id
Inner Join
dee_detalle_mov On dee_detalle_mov.dee_id_moi = moi_movimiento_inv.moi_id
Inner Join
art_articulo On dee_detalle_mov.dee_id_art = art_articulo.art_id Left Join
rxi_requisicion_inventario On rxi_requisicion_inventario.rxi_id_moi =
moi_movimiento_inv.moi_id
Group By
moi_movimiento_inv.moi_id
Order By
fecha
";

        return $this->db->query($sql)->result();
    }

    /**
     * @author Boris Estrada
     */
    public function ingresos() {
        $consulta = $this->db->select()
                ->from('tig_tipo_ingreso')
                ->get();
        $ingresos = $consulta->result_array();
        $ids = array();
        foreach ($ingresos as $ingreso) {
            $ids[] = $ingreso['tig_id'];
        }
        return (count($ids) > 0) ? implode(',', $ids) : '0';
    }

    /**
     * @author Boris Estrada
     */
    public function descuentos() {
        $consulta = $this->db->select()
                ->from('tdc_tipo_descuento')
                ->get();
        $descuentos = $consulta->result_array();
        $ids = array();
        foreach ($descuentos as $descuento) {
            $ids[] = $descuento['tdc_id'];
        }
        return (count($ids) > 0) ? implode(',', $ids) : '0';
    }

    /** Inicio de migracion de la funcionalidad de modulo de Tesoreria 12-5-2014 * */

    /**
     * @author Rene Castanda
     * * */
    function ids_servicios_funo() {
        $servicios = $this->db->query("SELECT 
                                    *,
                                    srv_nombre 
                                    FROM
                                    (srv_servicio) 
                                    JOIN csr_categoria_servicio 
                                    ON csr_id = srv_id_csr 
                                    AND csr_id_tsr = 2  
                                    WHERE srv_estado = 1 and (srv_tipo = 1 or srv_tipo is null)
                                    ORDER BY srv_servicio.srv_nombre")->result_array();
        $ids = array();
        foreach ($servicios as $ser) {
            $ids[] = $ser['srv_id'];
        }
        return (count($ids) > 0) ? implode(',', $ids) : '0';
    }

    /*     * */

    public function carga_laboral($generador = null) {
        if ($this->gsatelite->get_parametro('UATM_LIQUIDACIONES') == 1) {
            $this->db->query('CALL verificar_liquidaciones()')->result();
            $select = "liq_id as id, liq_fecha as fecha, liq_contribuyente as contribuyente, liq_concepto as concepto, liq_total as total";
            $this->db->select($select);
            $this->db->from('liq_liquidacion');
            $this->db->join("esl_estado_liquidacion", "liq_id_esl = esl_id");
            $this->db->join("fun_funo", "fun_id_liq = liq_id", 'left');
            $this->db->where('esl_id', 1);
            if ($generador == null) {
                $this->db->where('liq_id_gen<>', 3);
            } else {
                $this->db->where('liq_id_gen', $generador);
            }
            $result = $this->db->get()->result_array();
            return $result;
        } else {
            $select = "fun_id as id, fun_contribuyente as contribuyente, fun_concepto as concepto, fun_fecha as fecha, fun_subtotal as subtotal, fun_impuesto as fiestas, fun_total as total";
            $this->db->select($select);
            $this->db->from('fun_funo');
            $this->db->where('fun_funo.fun_estado', 1);
            if ($generador == null) {
                $this->db->where('fun_id_gen <>', 3);
            } else {
                $this->db->where('fun_id_gen', $generador);
            }
            $result = $this->db->get();
            return $result->result_array();
        }
    }

    public function cuentas_x_clasificacion($tipo_cuenta) {
        $this->db->select('ban_nombre, cub_numero, cub_id')
                ->from('cub_cuenta_bancaria')
                ->join('ban_banco', 'ban_id = cub_id_ban')
                ;
        $result = $this->db->get();
        return $result->result_array();
    }

    public function get_tipo_activo($tipo = null) {
        $this->db->select('tac_id, tac_nombre, tac_codigo, tac_depreciacion, tac_vida_util, tac_estado, GROUP_CONCAT(car_id) as caracteristicas')
                ->from('tac_tipo_activofijo')
                ->join('cxi_caracteristicaxtipo', 'cxi_id_tac=tac_id', 'left')
                ->join('car_caracteristica', 'car_id=cxi_id_car', 'left');

        if ($tipo != null) {
            $this->db->where('tac_id', $tipo);
        }
        $this->db->group_by('tac_id');

        $result = $this->db->get();
        return $result->row();
    }

    public function get_detalle_tipo_activo($tipo = null) {
        $this->db->select('tac_id, cnt_id, cnt_nombre, cec_id, cec_nombre, tcn_id, tcn_nombre, dtv_tipo_proceso')
                ->from('tac_tipo_activofijo')
                ->join('dtv_detalle_tipo_activo', 'dtv_id_tac=tac_id')
                ->join('cnt_cuenta_contable', 'cnt_id=dtv_id_cnt')
                ->join('cec_centro_costo', 'cec_id=dtv_id_cec')
                ->join('tcn_tipo_cuenta', 'tcn_id=dtv_id_tcn');

        if ($tipo != null) {
            $this->db->where('tac_id', $tipo);
        }

        $result = $this->db->get();
        return $result->result_array();
    }

    public function get_max_codigo($tabla, $campo) {
        $this->db->select('MAX( CAST(' . $campo . ' as unsigned integer)) as codigo', FALSE)
                ->from($tabla)
        ;
        $result = $this->db->get();
        return $result->row();
    }

    public function obtener_retension_notas2($where = null){
        $nit = $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NIT_PROVEEDOR', 2);
        $this->db->select('
                (CASE 
                    WHEN prv_tipo_pers = 1 THEN concat(prv_nombre," ",prv_apellido)
                    WHEN prv_tipo_pers = 2 THEN prv_apellido
                END) AS proveedor,
                nta_fecha  as fecha,
                nta_codigo as referencia,
                nta_monto_sujeto  as m_sujeto,
                ret_nombre as tipo,
                rdn_monto as r_monto,
                dpv_numero_documento as numero,
                dna_valor as valor,
                dna_retencion as ret,
                dna_retencion_calculada as calculada,
                dna_subtotal as subtotal,
                dcp_valor as valor,
                (SELECT ban_nombre FROM tra_transaccion left join cub_cuenta_bancaria on tra_id_cub = cub_id left join ban_banco on cub_id_ban = ban_id where nta_id_tra = tra_id) as banco
            ',false)->from('prv_proveedor')
                    ->join('nta_nota_abono','nta_id_prv = prv_id','LEFT')
                    ->join('dna_detalle_nota_abono', 'dna_id_nta = nta_id')
                    ->join('rdn_retencion_detalle_nota', 'rdn_id_dna = dna_id','INNER')
                    ->join('ret_retencion', 'ret_id = rdn_id_ret','INNER')
                    ->join('dpv_documento_proveedor', 'dna_id_dpv = dpv_id','LEFT')
                    ->join("dcp_documento_proveedor", "nta_id_prv = prv_id AND dcp_id_tde = $nit", "left");
        if ($where !== null) {
            $this->db->where($where);
        }
        $this->db->group_by('nta_id');

        return $this->db->get()->result_array();


    }

    /**
     * Cambia el area/sucursal de los activos, Si activos == null se buscan activos asignados al empleado  
     *
     * @param int    $are_id      Nueva area de los activos
     * @param array  $activos     Activos a los que se le aplicara el cambio de area
     * @param int    $emp_id      Id del empleado
     * @return bool               Si todo esta correcto retorna true           
     */
    public function actualizar_area_activos($are_id, $activos = null, $emp_id = null) {
        if ($activos === null) {
                                  $this->db->where(['axe_id_emp' => $emp_id, 'axe_estado' => 1]);
            $activos_x_empleado = $this->db->get('axe_activoxempleado')->result_array();
            $activos = array_column($activos_x_empleado, 'axe_id_act');
        }
                $this->db->where(['are_id' => $are_id]);
        $area = $this->db->get('are_area')->result_array();
        if (!empty($activos) && !empty($area)) {
            $area = $area[0];
            $actualizar_activos = [
                'act_id_are' => $area['are_id'],
                'act_id_suc' => $area['are_id_suc'],
                'act_usu_modificacion' => $this->tank_auth->get_user_id(),
                'act_fecha_modificacion' => date('Y-m-d H:i:s')
            ];

            $this->db->where_in('act_id', $activos);
            $this->db->update('act_activo_fijo', $actualizar_activos);
        } else {
            return false;
        }

        return true;

    }    

}

/*END*/