<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class Configuracion_Model extends CI_Model
{

    function __construct()
    {
        $this->load->database();
    }

    //region Funcions de Pasos

    function get_roles_paso($where = null)
    {
        $query = $this->db->select()
            ->from('rxp_rolxpaso')
            ->join('rol_rol', 'rxp_id_rol = rol_id', 'inner')
            ->join('psf_paso_flujo', 'rxp_id_psf = psf_id', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_acciones_rol($where = null)
    {
        $query = $this->db->select("DISTINCT *", FALSE)
            ->from('axr_accionxrol_paso')
            ->join('acc_accion', 'acc_id = axr_id_acc', 'inner')
            ->join('rxp_rolxpaso', 'axr_id_rxp = rxp_id', 'inner');

        if ($where != null) {
            $this->db->where($where);
        }

        //$this->db->group_by('acc_id');

        return $query->get()->result_array();
    }

    function get_primer_paso_flujo($flujo_id)
    {
        $query = "SELECT * FROM psf_paso_flujo AS psf INNER JOIN flu_flujo AS flu
            ON flu.flu_id = psf.psf_id_flu WHERE psf.psf_id_flu = " . $flujo_id . "
            AND psf.psf_orden = (SELECT MIN(psf_orden) FROM psf_paso_flujo WHERE psf_id_flu = " . $flujo_id . ")";

        $result = $this->db->query($query);

        return $result->result_array();
    }

    function iniciar_flujo_evento($data)
    {
        $bit_id = 0;
        $primer_paso = $this->get_primer_paso_flujo($data['flu_id']);
        if (count($primer_paso) > 0) {

            $bitacora = array(
                "bit_id_psf" => $primer_paso[0]['psf_id'],
                "bit_id_prc" => $data['evento']['eve_id_prc'],
                "bit_id_usu" => $this->tank_auth->get_user_id(),
                "bit_id_eve" => $data['evento']['eve_id'],
                "bit_usu_cierre" => null,
                "bit_nombre_evento" => $data['evento']['eve_nombre'],
                "bit_fecha_entrada" => date('Y-m-d H:i:s'),
                "bit_fecha_salida" => null,
                "bit_comentario" => null,
                "bit_url_anexo" => null,
                "bit_estado" => 1,
                "bit_usu_creacion" => $this->tank_auth->get_user_id(),
                "bit_fecha_creacion" => date('Y-m-d H:i:s'),
                "bit_usu_modificacion" => $this->tank_auth->get_user_id(),
                "bit_fecha_modificacion" => date('Y-m-d H:i:s')
            );

            $bit_id = $this->gsatelite->ingresar('bit_bitacora', $bitacora);
        }

        return $bit_id;
    }

    /*
     * tipo flujo: 1- Requisiciones, 2- Orden de Compra, 4- Comparativo
     */

    function get_paso_actual($registro)
    {

        $paso_actual = null;

        $flujo_id = $this->gsatelite->get_campo('eve_evento', 'eve_id_flu', array('eve_id' => $registro));

        $where = array(
            'psf_id_flu' => $flujo_id,
            'bit_id_eve' => $registro,
            'bit_fecha_salida' => null
        );

        $query = $this->db->select()
            ->from('bit_bitacora')
            ->join('psf_paso_flujo', 'psf_id = bit_id_psf', 'inner')
            ->where($where);

        $paso_actual = $query->get()->result_array();
        return $paso_actual;
    }

    public function cerrar_paso_actual($registro)
    {
        $paso_actual = null;

        $flujo_id = $this->gsatelite->get_campo('eve_evento', 'eve_id_flu', array('eve_id' => $registro));

        $where = array(
            'psf_id_flu' => $flujo_id,
            'bit_id_eve' => $registro,
            'bit_fecha_salida' => null
        );

        $query = $this->db->select()
            ->from('bit_bitacora')
            ->join('psf_paso_flujo', 'psf_id = bit_id_psf', 'inner')
            ->where($where);

        $paso_actual = $query->get()->result_array();
        if (count($paso_actual) == 1) {
            //Se inactiva el evento anterior
            $bitacora_array = array(
                'bit_usu_cierre' => $this->tank_auth->get_user_id(),
                'bit_fecha_salida' => date('Y-m-d H:i:s'),
                'bit_usu_modificacion' => $this->tank_auth->get_user_id(),
                'bit_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $this->gsatelite->actualizar_array('bit_bitacora', $bitacora_array, array('bit_id' => $paso_actual[0]['bit_id']));
        }
    }

    public function ingresar_siguiente_paso($registro, $proceso)
    {
        $paso_actual = $this->get_paso_actual($registro);

        //Se cierra el paso actual
        $this->cerrar_paso_actual($registro);

        if (count($paso_actual) > 0) {

            $paso_siguiente = $this->db->select()
                ->from('psf_paso_flujo')
                ->where(
                    array(
                        'psf_id_flu' => $paso_actual[0]['psf_id_flu'],
                        'psf_orden' => $paso_actual[0]['psf_paso_siguiente'],
                    )
                )->get()->result_array();

            if (count($paso_siguiente) > 0) {

                //Se ingresa el nuevo paso
                $bitacora_array = array(
                    "bit_id_psf" => $paso_siguiente[0]['psf_id'],
                    "bit_id_prc" => $proceso,
                    "bit_id_usu" => $this->tank_auth->get_user_id(),
                    "bit_id_eve" => $registro,
                    "bit_usu_cierre" => null,
                    "bit_nombre_evento" => $paso_siguiente[0]['psf_nombre'],
                    "bit_fecha_entrada" => date('Y-m-d H:i:s'),
                    "bit_fecha_salida" => null,
                    "bit_comentario" => null,
                    "bit_url_anexo" => null,
                    "bit_estado" => 1,
                    "bit_usu_creacion" => $this->tank_auth->get_user_id(),
                    "bit_fecha_creacion" => date('Y-m-d H:i:s'),
                    "bit_usu_modificacion" => $this->tank_auth->get_user_id(),
                    "bit_fecha_modificacion" => date('Y-m-d H:i:s')
                );

                $bit_id = $this->gsatelite->ingresar('bit_bitacora', $bitacora_array);
            }
        }
    }

    /*
     * tipo flujo: 1- Formulación, 2- Seguimiento, 3- Reprogramación, 4 - Solicitud, 5 - Modificación
     */

    function get_paso_actual_planificacion($registro, $tipo_flujo)
    {
        $paso_actual = null;

        $flujo_id = 0;
        $where = array();
        $tabla = "";
        $join = "";
        $id_seguimiento = "";

        switch ($tipo_flujo) {
            case 1:
                $flujo_id = $this->gsatelite->get_campo('pxu_plan_operativoxunidad', 'pxu_id_flu', array('pxu_id' => $registro));
                $where['sgf_id_pxu'] = $registro;
                $where['sgf_fecha_salida'] = null;
                $tabla = "sgf_seguim_formulacion";
                $join = 'psf_id = sgf_id_psf';
                $id_seguimiento = "sgf_id as id_seguimiento";
                break;
            case 2:
                $flujo_id = $this->gsatelite->get_campo('sgn_seguimiento_resumen_poa', 'sgn_id_flu', array('sgn_id' => $registro));
                $where['sgp_id_sgn'] = $registro;
                $where['sgp_fecha_salida'] = null;
                $tabla = "sgp_seguimiento_programacion";
                $join = 'psf_id = sgp_id_psf';
                $id_seguimiento = "sgp_id as id_seguimiento";
                break;
            case 3:
                $flujo_id = $this->gsatelite->get_campo('rpr_reprogramacion_resumen', 'rpr_id_flu', array('rpr_id' => $registro));
                $where['spr_id_rpr'] = $registro;
                $where['spr_fecha_salida'] = null;
                $tabla = "spr_seguimiento_reprogramacion";
                $join = 'psf_id = spr_id_psf';
                $id_seguimiento = "spr_id as id_seguimiento";
                break;
            case 4:
                $flujo_id = $this->gsatelite->get_campo('slr_solicitud_reprogramacion', 'slr_id_flu', array('slr_id' => $registro));
                //$where['spr_id_rpr'] = $registro;
                break;
            case 5:
                $flujo_id = $this->gsatelite->get_campo('pxu_plan_operativoxunidad', 'pxu_id_flu', array('pxu_id' => $registro));
                $where['sgf_id_pxu'] = $registro;
                $where['sgf_fecha_salida'] = null;
                $tabla = "sgf_seguim_formulacion";
                $join = 'psf_id = sgf_id_psf';
                $id_seguimiento = "sgp_id as id_seguimiento";
                break;
        }

        $where['psf_id_flu'] = $flujo_id;

        $query = $this->db->select("* , " . $id_seguimiento)
            ->from($tabla)
            ->join('psf_paso_flujo', $join, 'inner')
            ->where($where);

        $paso_actual = $query->get()->result_array();
        return $paso_actual;
    }

    /*
     * tipo flujo: 1- Formulación, 2- Seguimiento, 3- Reprogramación, 4 - Solicitud, 5 - Modificación
     */

    function get_paso_siguiente_planificacion($registro, $tipo_flujo)
    {

        $paso_actual = null;
        if ($registro != null && $tipo_flujo != null) {
            $tabla_flujo = "";
            $campo_flujo = "";
            $campo_id_registro = "";
            $tabla_seguimiento = "";
            $join_seguimiento = "";

            $where_obligatorios = array();
            $where_opcionales = array();
            $where_siguiente = array();

            switch ($tipo_flujo) {
                case 1:
                    $tabla_flujo = "pxu_plan_operativoxunidad";
                    $campo_flujo = "pxu_id_flu";
                    $campo_id_registro = "pxu_id";
                    $tabla_seguimiento = "sgf_seguim_formulacion";
                    $join_seguimiento = "psf_id = sgf_id_psf";

                    $where_obligatorios['sgf_id_pxu'] = $registro;
                    $where_obligatorios['sgf_fecha_salida'] = null;

                    $where_opcionales['sgf_id_pxu'] = $registro;
                    $where_opcionales['sgf_fecha_salida'] = null;

                    $where_siguiente['sgf_id_pxu'] = $registro;
                    $where_siguiente['sgf_fecha_salida'] = null;

                    break;

                case 2:
                    $tabla_flujo = "sgn_seguimiento_resumen_poa";
                    $campo_flujo = "sgn_id_flu";
                    $campo_id_registro = "sgn_id";
                    $tabla_seguimiento = "sgp_seguimiento_programacion";
                    $join_seguimiento = "psf_id = sgp_id_psf";

                    $where_obligatorios['sgp_id_sgn'] = $registro;
                    $where_obligatorios['sgp_fecha_salida'] = null;

                    $where_opcionales['sgp_id_sgn'] = $registro;
                    $where_opcionales['sgp_fecha_salida'] = null;

                    $where_siguiente['sgp_id_sgn'] = $registro;
                    $where_siguiente['sgp_fecha_salida'] = null;

                    break;
            }

            //SE OBTIENE EL ID_FLUJO
            $flujo_id = $this->gsatelite->get_campo($tabla_flujo, $campo_flujo, array($campo_id_registro => $registro));

            //SE OBTIENE EL PASO MENOR DEL FLUJO
            $num_siguiente = $this->gsatelite->get_min('psf_paso_flujo', 'psf_orden', array('psf_id_flu' => $flujo_id));

            $obligatorio = null;

            //SE VERIFICA QUE EL PLAN CONTENGA UN PASO EN EL FLUJO.
            //Como prioridad se busca un paso obligtorio

            $where_obligatorios['psf_id_flu'] = $flujo_id;
            $where_obligatorios['psf_obligatorio'] = 1;

            $this->db->join($tabla_seguimiento, $join_seguimiento, 'inner');
            $this->db->group_by('psf_orden');
            $num_obligatorios = $this->gsatelite->count('psf_paso_flujo', $where_obligatorios);

            //  Si no se encuentra un paso obligatorio en proceso
            //  se busca un paso opcional

            $where_opcionales['psf_id_flu'] = $flujo_id;
            $where_opcionales['psf_obligatorio'] = 0;

            $this->db->join($tabla_seguimiento, $join_seguimiento, 'inner');
            $this->db->group_by('psf_orden');
            $num_opcionales = $this->gsatelite->count('psf_paso_flujo', $where_opcionales);

            //   Se setea la variable $obligagorio con su valor respectivo dependiendo de
            //   el tipo de paso que se encuentre
            //   1: Obligatorio, 0: Opcional

            if ($num_obligatorios > 0) {
                $obligatorio = 1;
            }
            if ($num_opcionales > 0) {
                $obligatorio = 0;
            }

            // SI SE TIENE UN PASO EN PROCESO SE OBTIENE DICHO PASO
            if ($num_obligatorios > 0 || $num_opcionales > 0) {

                $where_siguiente['psf_id_flu'] = $flujo_id;
                $where_siguiente['psf_obligatorio'] = $obligatorio;

                $this->db->join($tabla_seguimiento, $join_seguimiento, 'inner');
                $num_siguiente = $this->gsatelite->get_campo('psf_paso_flujo', 'psf_paso_siguiente', $where_siguiente);

            }

            $this->db->limit(1);
            $paso_siguiente = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id_flu' => $flujo_id, 'psf_orden' => $num_siguiente));
        }
        return $paso_siguiente;
    }

    /*
    * tipo flujo: 1- Formulación, 2- Seguimiento, 3- Reprogramación, 4 - Solicitud, 5 - Modificación
    */
    function get_paso_anterior($registro, $tipo_flujo)
    {

        $paso_anterior = null;
        if ($registro != null && $tipo_flujo != null) {

            $tabla_flujo = "";
            $campo_flujo = "";
            $campo_id_registro = "";
            $join_flujo = "";
            $where = array();

            switch ($tipo_flujo) {
                case 1:
                    $tabla_flujo = "pxu_plan_operativoxunidad";
                    $campo_flujo = "pxu_id_flu";
                    $campo_id_registro = "pxu_id";
                    $join_flujo = 'pxu_id_flu = flu_id';
                    $where['pxu_id'] = $registro;
                    break;
            }

            //SE OBTIENE EL ID_FLUJO
            $flujo_id = $this->gsatelite->get_campo($tabla_flujo, $campo_flujo, array($campo_id_registro => $registro));

            //SE OBTIENE EL PASO ACTUAL
            $paso_actual = $this->get_paso_actual_planificacion($registro, $tipo_flujo);

            //Si hay un paso actual se obtienen el paso anterior
            if (count($paso_actual) > 0) {

                $orden_actual = $paso_actual[0]['psf_orden'];

                $where['flu_id'] = $flujo_id;
                $where['psf_paso_siguiente'] = $orden_actual;

                //Se obtiene el paso anterior, del orden siguiente.
                $query = $this->db->select()
                    ->from('psf_paso_flujo')
                    ->join('flu_flujo', 'psf_id_flu = flu_id', 'inner')
                    ->join($tabla_flujo, $join_flujo, 'inner')
                    ->where($where);


                $paso_anterior = $query->get()->result_array();
            }
        }
        return $paso_anterior;
    }


    public function ingresar_paso_siguiente($registro, $tipo_flujo, $paso_actual, $paso_siguiente, $comentario, $anexo = "")
    {
        switch ($tipo_flujo) {
            case 1:
                //Se cierra el paso actual
                $seguimiento_array = array(
                    'sgf_usu_cierra' => $this->tank_auth->get_user_id(),
                    'sgf_observacion' => $comentario,
                    'sgf_fecha_salida' => date('Y-m-d H:i:s'),
                    'sgf_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgf_fecha_modificacion' => date('Y-m-d h:i:s')
                );

                $this->gsatelite->actualizar_array('sgf_seguim_formulacion', $seguimiento_array, array('sgf_id' => $paso_actual));

                //Si existe un paso Anterior se ingresa
                if ($paso_siguiente > 0) {
                    $seguimiento_ante = array(
                        'sgf_id_pxu' => $registro,
                        'sgf_id_psf' => $paso_siguiente,
                        'sgf_usu_apertura' => $this->tank_auth->get_user_id(),
                        'sgf_fecha_entrada' => date('Y-m-d H:i:s'),
                        'sgf_estado' => 1,
                        'sgf_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sgf_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgf_fecha_creacion' => date('Y-m-d h:i:s'),
                        'sgf_fecha_modificacion' => date('Y-m-d h:i:s')
                    );

                    $seguimiento = $this->gsatelite->ingresar('sgf_seguim_formulacion', $seguimiento_ante);
                }

                break;

            case 2:
                //Se cierra el paso actual
                $seguimiento_array = array(
                    'sgp_usu_cierra' => $this->tank_auth->get_user_id(),
                    'sgp_observacion' => $comentario,
                    'sgp_fecha_salida' => date('Y-m-d H:i:s'),
                    'sgp_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgp_fecha_modificacion' => date('Y-m-d h:i:s')
                );

                $this->gsatelite->actualizar_array('sgp_seguimiento_programacion', $seguimiento_array, array('sgp_id' => $paso_actual));

                //Si existe un siguiente paso se ingresa
                if ($paso_siguiente > 0) {
                    $seguimiento_ante = array(
                        'sgp_id_sgn' => $registro,
                        'sgp_id_psf' => $paso_siguiente,
                        'sgp_usu_apertura' => $this->tank_auth->get_user_id(),
                        'sgp_fecha_entrada' => date('Y-m-d H:i:s'),
                        'sgp_estado' => 1,
                        'sgp_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sgp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgp_fecha_creacion' => date('Y-m-d h:i:s'),
                        'sgp_fecha_modificacion' => date('Y-m-d h:i:s')
                    );

                    $seguimiento = $this->gsatelite->ingresar('sgp_seguimiento_programacion', $seguimiento_ante);
                }

                break;

        }
    }


    /*
    * tipo flujo: 1- Formulación, 2- Seguimiento, 3- Reprogramación, 4 - Solicitud, 5 - Modificación
    */

    public function regresar_paso($registro, $tipo_flujo, $paso_actual, $paso_anterior, $comentario, $anexo = "")
    {
        switch ($tipo_flujo) {
            case 1:
                //Se cierra el paso actual
                $seguimiento_array = array(
                    'sgf_usu_cierra' => $this->tank_auth->get_user_id(),
                    'sgf_observacion' => $comentario,
                    'sgf_fecha_salida' => date('Y-m-d H:i:s'),
                    'sgf_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgf_fecha_modificacion' => date('Y-m-d h:i:s')
                );

                $this->gsatelite->actualizar_array('sgf_seguim_formulacion', $seguimiento_array, array('sgf_id' => $paso_actual));

                //Si existe un paso Anterior se ingresa
                if ($paso_anterior > 0) {
                    $seguimiento_ante = array(
                        'sgf_id_pxu' => $registro,
                        'sgf_id_psf' => $paso_anterior,
                        'sgf_usu_apertura' => $this->tank_auth->get_user_id(),
                        'sgf_fecha_entrada' => date('Y-m-d H:i:s'),
                        'sgf_estado' => 1,
                        'sgf_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sgf_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgf_fecha_creacion' => date('Y-m-d h:i:s'),
                        'sgf_fecha_modificacion' => date('Y-m-d h:i:s')
                    );

                    $seguimiento = $this->gsatelite->ingresar('sgf_seguim_formulacion', $seguimiento_ante);
                }

                break;

            case 2:
                //Se cierra el paso actual
                $seguimiento_array = array(
                    'sgp_usu_cierra' => $this->tank_auth->get_user_id(),
                    'sgp_observacion' => $comentario,
                    'sgp_fecha_salida' => date('Y-m-d H:i:s'),
                    'sgp_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgp_fecha_modificacion' => date('Y-m-d h:i:s')
                );

                $this->gsatelite->actualizar_array('sgf_seguim_formulacion', $seguimiento_array, array('sgf_id' => $paso_actual));

                //Si existe un paso Anterior se ingresa
                if ($paso_anterior > 0) {
                    $seguimiento_ante = array(
                        'sgp_id_sgn' => $registro,
                        'sgp_id_psf' => $paso_anterior,
                        'sgp_usu_apertura' => $this->tank_auth->get_user_id(),
                        'sgp_fecha_entrada' => date('Y-m-d H:i:s'),
                        'sgp_estado' => 1,
                        'sgp_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sgp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgp_fecha_creacion' => date('Y-m-d h:i:s'),
                        'sgp_fecha_modificacion' => date('Y-m-d h:i:s')
                    );

                    $seguimiento = $this->gsatelite->ingresar('sgf_seguim_formulacion', $seguimiento_ante);
                }

                break;
        }
    }

    /*
     * tipo flujo: 1- Formulación, 2- Seguimiento, 3- Reprogramación, 4 - Solicitud, 5 - Modificación
     */

    public function get_historial_paso($registro, $tipo_flujo)
    {

        $historial = null;
        if ($registro != null && $tipo_flujo != null) {

            switch ($tipo_flujo) {
                case 1:
                    $where = array(
                        'pxu_id' => $registro,
                    );

                    $query = $this->db->select("
                                psf_nombre as paso,
                                aper.username as usuario_responsable,
                                cierra.username as usuario_cierra,
                                CONCAT(emp_aper.emp_nombre,' ',emp_aper.emp_apellido) as responsable,
                                CONCAT(emp_cierra.emp_nombre,' ',emp_cierra.emp_apellido) as responsable_cierra,
                                sgf_fecha_entrada as fecha_entrada,
                                sgf_fecha_salida as fecha_salida,
                                sgf_observacion as comentario,
                                sgf_anexo as anexo
                            "
                        , false)
                        ->from('pxu_plan_operativoxunidad')
                        ->join('sgf_seguim_formulacion', 'sgf_id_pxu = pxu_id', 'inner')
                        ->join('psf_paso_flujo', 'psf_id = sgf_id_psf', 'inner')
                        ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
                        ->join('users as aper', 'sgf_usu_apertura = aper.id', 'inner')
                        ->join('emp_empleado as emp_aper', 'emp_aper.emp_id = aper.usu_id_emp', 'left')
                        ->join('users as cierra', 'sgf_usu_cierra = cierra.id', 'left')
                        ->join('emp_empleado emp_cierra', 'emp_cierra.emp_id = cierra.usu_id_emp', 'left');

                    $this->db->where($where);
                    $this->db->order_by('sgf_fecha_entrada DESC');


                    $historial = $query->get()->result_array();

                    break;
                case 2:
                    $where = array(
                        'sgn_id' => $registro,
                    );

                    $query = $this->db->select("
                                psf_nombre as paso,
                                aper.username as usuario_responsable,
                                cierra.username as usuario_cierra,
                                CONCAT(emp_aper.emp_nombre,' ',emp_aper.emp_apellido) as responsable,
                                CONCAT(emp_cierra.emp_nombre,' ',emp_cierra.emp_apellido) as responsable_cierra,
                                sgp_fecha_entrada as fecha_entrada,
                                sgp_fecha_salida as fecha_salida,
                                sgp_observacion as comentario,
                                sgp_anexo as anexo
                            "
                        , false)
                        ->from('pxu_plan_operativoxunidad')
                        ->join('sgn_seguimiento_resumen_poa', 'sgn_id_pxu = pxu_id', 'inner')
                        ->join('sgp_seguimiento_programacion', 'sgp_id_sgn = sgn_id', 'inner')
                        ->join('psf_paso_flujo', 'psf_id = sgp_id_psf', 'inner')
                        ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
                        ->join('users as aper', 'sgp_usu_apertura = aper.id', 'inner')
                        ->join('emp_empleado as emp_aper', 'emp_aper.emp_id = aper.usu_id_emp', 'left')
                        ->join('users as cierra', 'sgp_usu_cierra = cierra.id', 'left')
                        ->join('emp_empleado emp_cierra', 'emp_cierra.emp_id = cierra.usu_id_emp', 'left');

                    $this->db->where($where);
                    $this->db->order_by('sgp_fecha_entrada DESC');


                    $historial = $query->get()->result_array();

                    break;
            }
        }
        return $historial;
    }

    public function get_backlog_planificacion($where = null, $tipo = null)
    {
        if ($where != null) {
            $where_formulacion = $where['formulacion'];
            $where_seguimiento = $where['seguimiento'];
            $where_reprogramacion = $where['reprogramacion'];
            $where_solicitud = $where['solicitud'];
            $where_modificacion = $where['modificacion'];
        }

        //Query Formulación
        $query = $this->db->select(
            "       pxu_id as registro,
                    1 as tipo_flujo,
                    poa_anio,
                    poa_id,
                    'Formulación' as tipo,
                    sgf_fecha_entrada as fecha_entrada,
                    psf_nombre as paso_actual,
                    pxu_estado as estado_registro,
                    arc_poa.are_nombre as area,
                    arc_poa.are_id as are_id,
                    psf_id as paso,
                    GROUP_CONCAT(rxp_id) as id_rxp,
                    0 as per_id
                    ", false)
            ->from('pxu_plan_operativoxunidad')
            ->join('poa_plan_operativo', 'poa_id = pxu_id_poa', 'inner')
            ->join('are_area as arc_poa', 'arc_poa.are_id = pxu_id_are', 'left')
            ->join('sgf_seguim_formulacion', 'sgf_id_pxu = pxu_id', 'inner')
            ->join('psf_paso_flujo', 'psf_id = sgf_id_psf', 'inner')
            ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
            ->join('rxp_rolxpaso', 'rxp_id_psf = psf_id', 'inner')
            ->join('uxr_usuarioxrol', 'uxr_id_rol = rxp_id_rol', 'inner')
            ->join('users', 'id = uxr_id_usu', 'inner')
            ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
            ->join('are_area as are', 'are.are_id = emp_id_are', 'left')
            ->join('pea_periodo_activacion as pea', 'pea_id = (SELECT MAX(pea_id) FROM pxo_periodoxpoa INNER JOIN pea_periodo_activacion ON pea_id = pxo_id_pea WHERE pxo_id_pxu = pxu_id AND DATE(NOW()) BETWEEN DATE(pea_fecha_inicio) AND DATE(pea_fecha_cierre) AND pea_tipo = 1)', 'inner', FALSE)
            ->group_by('pxu_id');

        $area = 0;

        if ($where_formulacion['area'] != null) {
            $area = $where_formulacion['area'];
            unset($where_formulacion['area']);
        }

        $this->db->where('((psf_area = 1 AND (emp_id_are = ' . $area . ')) OR psf_area = 0)');

        if ($where_formulacion != null) {
            $this->db->where($where_formulacion);
        }

        $result = $query->get()->result_array();
        $query_formulacion = $this->db->last_query();

        //Query Seguimiento
        $query = $this->db->select(
            "       sgn_id as registro,
                    2 as tipo_flujo,
                    poa_anio,
                    poa_id,
                    CONCAT('Seguimiento - ', per_codigo) as tipo,
                    sgp_fecha_entrada as fecha_entrada,
                    psf_nombre as paso_actual,
                    pxu_estado as estado_registro,
                    arc_poa.are_nombre as area,
                    arc_poa.are_id as are_id,
                    psf_id as paso,
                    GROUP_CONCAT(rxp_id) as id_rxp,
                    sgn_id_per as per_id
                    ", false)
            ->from('pxu_plan_operativoxunidad')
            ->join('poa_plan_operativo', 'poa_id = pxu_id_poa', 'inner')
            ->join('sgn_seguimiento_resumen_poa', 'pxu_id = sgn_id_pxu', 'inner')
            ->join('per_periodo', 'per_id = sgn_id_per', 'inner')
            ->join('are_area as arc_poa', 'arc_poa.are_id = pxu_id_are', 'left')
            ->join('sgp_seguimiento_programacion', 'sgp_id_sgn = sgn_id', 'inner')
            ->join('psf_paso_flujo', 'psf_id = sgp_id_psf', 'inner')
            ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
            ->join('rxp_rolxpaso', 'rxp_id_psf = psf_id', 'inner')
            ->join('uxr_usuarioxrol', 'uxr_id_rol = rxp_id_rol', 'inner')
            ->join('users', 'id = uxr_id_usu', 'inner')
            ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
            ->join('are_area as are', 'are.are_id = emp_id_are', 'left')
            ->join('pea_periodo_activacion as pea', 'pea_id = (SELECT MAX(pea_id) FROM pxo_periodoxpoa INNER JOIN pea_periodo_activacion ON pea_id = pxo_id_pea WHERE pxo_id_pxu = pxu_id AND DATE(NOW()) BETWEEN DATE(pea_fecha_inicio) AND DATE(pea_fecha_cierre) AND pea_tipo = 1)', 'inner', FALSE)
            ->group_by('pxu_id');

        $area = 0;

        if ($where_seguimiento['area'] != null) {
            $area = $where_seguimiento['area'];
            unset($where_seguimiento['area']);
        }

        $this->db->where('((psf_area = 1 AND (emp_id_are = ' . $area . ')) OR psf_area = 0)');

        if ($where_seguimiento != null) {
            $this->db->where($where_seguimiento);
        }

        $result = $query->get()->result_array();
        $query_seguimiento = $this->db->last_query();


        /*//Query comparativo
        $query = $this->db->select("
                ccc_id AS registro,
                4 AS tipo_flujo,
                rxi_numero AS codigo_registro,
                'Comparativo de cotización' AS tipo,
                ccc_fecha AS fecha_entrada,
                psf_nombre AS paso_actual,
                ccc_estado AS estado_registro,
                'arc_orc.are' AS area,
                psf_id AS paso,
                rxp_id AS rol_paso,
                GROUP_CONCAT(rxp_id) AS id_rxp,
                'are.are_nombre' AS area_solicitante2,
                ccc_observacion AS detalles,
                (
                    SELECT
                        are_nombre
                    FROM
                        emp_empleado
                    JOIN users ON emp_id_usu = id
                    JOIN are_area ON are_id = emp_id_are
                    WHERE
                        id = rxi_id_usu_solicita
                    LIMIT 1
                ) area_solicitante,
                pcl_codigo,
                (
                    SELECT
                        username
                    FROM
                        users
                    WHERE
                        id = ccc_id_usu_crea
                ) user_solicitante", false)
            ->from('ccc_comparativo_cotizacion_compra')
            ->join('rxi_requisicion_inventario', 'rxi_id = ccc_id_rxi', 'INNER')
            ->join('scm_seguimiento_comparativo_compra', 'scm_id_ccc = ccc_id', 'INNER')
            ->join('psf_paso_flujo', 'psf_id = scm_id_psf', 'INNER')
            ->join('rxp_rolxpaso', 'rxp_id_psf = psf_id', 'INNER')
            ->join('uxr_usuarioxrol', 'uxr_id_rol = rxp_id_rol', 'inner')
            ->join('users', 'id = uxr_id_usu', 'inner')
            ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
            ->join('pcl_proyecto_cliente', 'pcl_id = rxi_id_pcl', 'LEFT')
            ->group_by('ccc_id');

        $area = 0;

        if ($where_comparativo['area'] != null) {
            $area = $where_comparativo['area'];
            unset($where_comparativo['area']);
        }

        $this->db->where('((psf_area = 1 AND (emp_id_are = ' . $area . ')) OR psf_area = 0)');

        if ($where_comparativo != null) {
            $this->db->where($where_comparativo);
        }

        $result = $query->get()->result_array();
        $query_comparativo = $this->db->last_query();*/

        /*
         * Se valida el tipo de solicitud buscada
         * Tipo 1 = requisiciones, 2 = Ordenes de Compra
         */

        if ($tipo == 1) {
            $query_final = $query_formulacion;
        } else if ($tipo == 2) {
            //$query_final = $query_ordenes;
        } else {
            //Se unifican las consultas para generar el listado
            $query_final = "SELECT * FROM( (" . $query_formulacion . ") UNION (" . $query_seguimiento . ") ) AS principal ORDER BY principal.fecha_entrada DESC";
            //$query_final = "SELECT * FROM( (" . $query_formulacion . ") UNION (" . $query_ordenes . ") UNION (" . $query_comparativo . ") ) AS principal ORDER BY principal.fecha_entrada DESC";
        }

        $resultado = $this->db->query($query_final);
        return $resultado->result_array();
    }
    //endregion

    //region Backlog de Eventos
    public function get_backlog_eventos($where = null)
    {

        $query = $this->db->select("DISTINCT
                eve_evento.*,
                bit_bitacora.*,
                psf_id,
                psf_nombre,
                psf_descripcion,
                rxp_id,
                tip_nombre,
                prc_id,
                prc_nombre,
                prc_descripcion,
                ins_nombre", FALSE)
            ->from('eve_evento')
            ->join('bit_bitacora', 'bit_id_eve = eve_id', 'inner')
            ->join('psf_paso_flujo', 'psf_id = bit_id_psf', 'inner')
            ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
            ->join('rxp_rolxpaso', 'rxp_id_psf = psf_id', 'inner')
            ->join('uxr_usuarioxrol', 'uxr_id_rol = rxp_id_rol', 'inner')
            ->join('usu_usuario', 'usu_id = uxr_id_usu', 'inner')
            ->join('tip_tipo_programa', 'tip_id = eve_id_tip', 'inner')
            ->join('prc_proceso', 'prc_id = eve_id_prc', 'inner')
            ->join('ins_institucion', 'ins_id = eve_id_ins', 'left')
            ->join('prp_programa_proyecto', 'prp_id = eve_id_prp', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();

    }

    public function get_bitacora($registro, $order_by = 'bit_fecha_entrada DESC')
    {


        $where = array(
            'eve_id' => $registro,
        );

        $query = $this->db->select("
                                psf_nombre as paso,
                                usu_usuario as usuario_responsable,
                                CONCAT(usu_nombres,' ',usu_apellidos) as responsable,
                                bit_fecha_entrada as fecha_entrada,
                                bit_fecha_salida as fecha_salida,
                                bit_comentario as comentario,
                                bit_url_anexo as anexo,
                                flu_id as id_flujo,
                                psf_orden as num_paso
                            "
            , false)
            ->from('eve_evento')
            ->join('bit_bitacora', 'bit_id_eve = eve_id', 'inner')
            ->join('psf_paso_flujo', 'psf_id = bit_id_psf', 'inner')
            ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
            ->join('usu_usuario', 'bit_id_usu = usu_id', 'inner');

        $this->db->where($where);
        $this->db->order_by($order_by);
        $historial = $query->get()->result_array();

        return $historial;
    }
    //endregion

}