<?php

/**
 * @author Mario Marquez
 * @method Modelo - Modulo Compras
 */
Class Compras_Model extends CI_Model {

    function __construct() {
        $this->load->database();
    }

    /**
     * @author Mario Marquez
     * @method Regresa el listado de proveedores
     * @property array $where 'Array de filtros a usar'
     */
    public function get_proveedores($where = null, $like=null, $select='*') {
        $query = $this->db->select($select, FALSE)
                ->from('prv_proveedor')
                ->join('acp_act_economica_prov', 'acp_id = prv_id_acp', 'left')
                ->join('mun_municipio', 'mun_id = prv_id_mun', 'left')
                ->join('dep_departamento', 'dep_id = mun_id_dep', 'left')
                ->join('pai_pais', 'pai_id  = prv_id_pai', 'left')
                ->join('tap_tamano_prov', ' tap_id = prv_id_tap', 'left')
                ->join('gir_giro', 'gir_id = prv_id_gir', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->or_like($like);
        }
        $this->db->order_by('prv_codigo');

        return $query->get()->result_array();
    }

    function get_primer_paso_flujo($flujo_id) {
        $query = "SELECT * FROM psf_paso_flujo AS psf INNER JOIN flu_flujo AS flu
            ON flu.flu_id = psf.psf_id_flu WHERE psf.psf_id_flu = " . $flujo_id . "
            AND psf.psf_orden = (SELECT MIN(psf_orden) FROM psf_paso_flujo WHERE psf_id_flu = " . $flujo_id . ")";

        $result = $this->db->query($query);

        return $result->result_array();
    }

    function get_backlog_requisiciones($where = null, $area = 0) {

        $query = $this->db->select('*,(
                        SELECT
                            COUNT(coc_id)
                        FROM
                            coc_cotizacion_compra
                        WHERE
                            coc_id_rxi = rxi_id
                        AND coc_estado = 2
                    ) cotizaciones_aprobadas', false)
                ->from('rxi_requisicion_inventario')
                ->join('bod_bodega', 'bod_id = rxi_id_bod', 'left')
                ->join('sgr_seguimiento_requisicion', 'sgr_id_rxi = rxi_id', 'inner')
                ->join('psf_paso_flujo', 'psf_id = sgr_id_psf', 'inner')
                ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
                ->join('rxp_rolxpaso', 'rxp_id_psf = psf_id', 'inner')
                ->join('uxr_usuarioxrol', 'uxr_id_rol = rxp_id_rol', 'inner')
                ->join('users', 'id = uxr_id_usu', 'inner')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                ->join('pcl_proyecto_cliente', 'pcl_id = rxi_id_pcl', 'left')
                ->order_by('rxi_fecha','DESC')
                ->group_by('rxi_id');
        ;

        $this->db->where('(
		(
                    psf_area = 1
                    AND
                    (emp_id_are = ' . $area . ')
		)
		OR
		psf_area = 0
            )
        ');

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /*
     * tipo flujo: 1- Requisiciones, 2- Orden de Compra, 4- Comparativo
     */

    function get_paso_actual($registro, $tipo_flujo) {

        $paso_actual = null;
        if ($registro != null && $tipo_flujo != null) {

            switch ($tipo_flujo) {
                case 1:

                    $flujo_id = $this->gsatelite->get_campo('rxi_requisicion_inventario', 'rxi_id_flu', array('rxi_id' => $registro));

                    $where = array(
                        'psf_id_flu' => $flujo_id,
                        'sgr_id_rxi' => $registro,
                        'sgr_fecha_salida' => null
                    );

                    $query = $this->db->select()
                            ->from('sgr_seguimiento_requisicion')
                            ->join('psf_paso_flujo', 'psf_id = sgr_id_psf', 'inner')
                            ->where($where)
                    ;

                    $paso_actual = $query->get()->result_array();

                    break;
                case 2:
                    $flujo_id = $this->gsatelite->get_campo('orc_orden_compra', 'orc_id_flu', array('orc_id' => $registro));

                    $where = array(
                        'psf_id_flu' => $flujo_id,
                        'sgo_id_orc' => $registro,
                        'sgo_fecha_salida' => null
                    );

                    $query = $this->db->select()
                            ->from('sgo_seguimiento_orden')
                            ->join('psf_paso_flujo', 'psf_id = sgo_id_psf', 'inner')
                            ->where($where)
                    ;

                    $paso_actual = $query->get()->result_array();

                    break;
                case 4:
                    $flujo_id = $this->gsatelite->get_campo('ccc_comparativo_cotizacion_compra', 'ccc_id_flu', array('ccc_id' => $registro));
                    $where = array(
                        'psf_id_flu'        => $flujo_id,
                        'scm_id_ccc'        => $registro,
                        'scm_fecha_salida'  => null
                    );

                    $query = $this->db->select()
                            ->from('scm_seguimiento_comparativo_compra')
                            ->join('psf_paso_flujo', 'psf_id = scm_id_psf', 'inner')
                            ->where($where)
                    ;

                    $paso_actual = $query->get()->result_array();

                    break;
            }
        }
        return $paso_actual;
    }

    /*
     * tipo flujo: 1- Requisiciones, 2- Orden de Compra, 4- Comparativo
     */

    function get_paso_siguiente($registro, $tipo_flujo) {

        $paso_actual = null;
        if ($registro != null && $tipo_flujo != null) {

            switch ($tipo_flujo) {
                case 1:
                    //SE OBTIENE EL ID_FLUJO
                    $flujo_id = $this->gsatelite->get_campo('rxi_requisicion_inventario', 'rxi_id_flu', array('rxi_id' => $registro));

                    //SE OBTIENE EL PASO MENOR DEL FLUJO
                    $num_siguiente = $this->gsatelite->get_min('psf_paso_flujo', 'psf_orden', array('psf_id_flu' => $flujo_id));

                    $obligatorio = null;

                    //SE VERIFICA QUE EL PLAN CONTENGA UN PASO EN EL FLUJO.
                    //Como prioridad se busca un paso obligtorio
                    $where_obligatorios = array(
                        'psf_id_flu' => $flujo_id,
                        'sgr_id_rxi' => $registro,
                        'psf_obligatorio' => 1,
                        'sgr_fecha_salida' => null
                    );
                    $this->db->join('sgr_seguimiento_requisicion', 'psf_id = sgr_id_psf', 'inner');
                    $this->db->group_by('psf_orden');
                    $num_obligatorios = $this->gsatelite->count('psf_paso_flujo', $where_obligatorios);

                    //  Si no se encuentra un paso obligatorio en proceso
                    //  se busca un paso opcional
                    $where_opcionales = array(
                        'psf_id_flu' => $flujo_id,
                        'sgr_id_rxi' => $registro,
                        'psf_obligatorio' => 0,
                        'sgr_fecha_salida' => null
                    );
                    $this->db->join('sgr_seguimiento_requisicion', 'psf_id = sgr_id_psf', 'inner');
                    $this->db->group_by('psf_orden');
                    $num_opcionales = $this->gsatelite->count('psf_paso_flujo', $where_opcionales);


                    //   Se setea la variable $obligagorio con su valor respectivo dependiendo de
                    //   el tipo de paso que se encuentre
                    //   1: Obligatorio, 0: Opcional

                    if ($num_obligatorios > 0) {
                        $obligatorio = 1;
                    }
                    if ($num_opcionales > 0) {
                        $obligatorio = 0;
                    }

                    // SI SE TIENE UN PASO EN PROCESO SE OBTIENE DICHO PASO
                    if ($num_obligatorios > 0 || $num_opcionales > 0) {

                        $where_siguiente = array(
                            'psf_id_flu' => $flujo_id,
                            'sgr_id_rxi' => $registro,
                            'psf_obligatorio' => $obligatorio,
                            'sgr_fecha_salida' => null
                        );
                        $this->db->join('sgr_seguimiento_requisicion', 'psf_id = sgr_id_psf', 'inner');
                        $num_siguiente = $this->gsatelite->get_campo('psf_paso_flujo', 'psf_paso_siguiente', $where_siguiente);
                    }

                    $this->db->limit(1);
                    $paso_siguiente = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id_flu' => $flujo_id, 'psf_orden' => $num_siguiente));
                    break;

                case 2:
                    //SE OBTIENE EL ID_FLUJO
                    $flujo_id = $this->gsatelite->get_campo('orc_orden_compra', 'orc_id_flu', array('orc_id' => $registro));

                    //SE OBTIENE EL PASO MENOR DEL FLUJO
                    $num_siguiente = $this->gsatelite->get_min('psf_paso_flujo', 'psf_orden', array('psf_id_flu' => $flujo_id));

                    $obligatorio = null;

                    //SE VERIFICA QUE EL PLAN CONTENGA UN PASO EN EL FLUJO.
                    //Como prioridad se busca un paso obligtorio
                    $where_obligatorios = array(
                        'psf_id_flu' => $flujo_id,
                        'sgo_id_orc' => $registro,
                        'psf_obligatorio' => 1,
                        'sgo_fecha_salida' => null
                    );
                    $this->db->join('sgo_seguimiento_orden', 'psf_id = sgo_id_psf', 'inner');
                    $this->db->group_by('psf_orden');
                    $num_obligatorios = $this->gsatelite->count('psf_paso_flujo', $where_obligatorios);

                    //  Si no se encuentra un paso obligatorio en proceso
                    //  se busca un paso opcional
                    $where_opcionales = array(
                        'psf_id_flu' => $flujo_id,
                        'sgo_id_orc' => $registro,
                        'psf_obligatorio' => 0,
                        'sgo_fecha_salida' => null
                    );
                    $this->db->join('sgo_seguimiento_orden', 'psf_id = sgo_id_psf', 'inner');
                    $this->db->group_by('psf_orden');
                    $num_opcionales = $this->gsatelite->count('psf_paso_flujo', $where_opcionales);


                    //   Se setea la variable $obligagorio con su valor respectivo dependiendo de
                    //   el tipo de paso que se encuentre
                    //   1: Obligatorio, 0: Opcional

                    if ($num_obligatorios > 0) {
                        $obligatorio = 1;
                    }
                    if ($num_opcionales > 0) {
                        $obligatorio = 0;
                    }

                    // SI SE TIENE UN PASO EN PROCESO SE OBTIENE DICHO PASO
                    if ($num_obligatorios > 0 || $num_opcionales > 0) {

                        $where_siguiente = array(
                            'psf_id_flu' => $flujo_id,
                            'sgo_id_orc' => $registro,
                            'psf_obligatorio' => $obligatorio,
                            'sgo_fecha_salida' => null
                        );

                        $this->db->order_by('psf_paso_siguiente','ASC'); // ORDENAR DE FORMA ASCENDENTE
                        $this->db->limit(1);// QUE SOLO OBTENGA UN RESULTADO.

                        $this->db->join('sgo_seguimiento_orden', 'psf_id = sgo_id_psf', 'inner');
                        $num_siguiente = $this->gsatelite->get_campo('psf_paso_flujo', 'psf_paso_siguiente', $where_siguiente);
                    }

                    $this->db->limit(1);
                    $paso_siguiente = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id_flu' => $flujo_id, 'psf_orden' => $num_siguiente));
                    break;
                
                case 4:
                    //SE OBTIENE EL ID_FLUJO
                    $flujo_id = $this->gsatelite->get_campo('ccc_comparativo_cotizacion_compra', 'ccc_id_flu', array('ccc_id' => $registro));
                    //SE OBTIENE EL PASO MENOR DEL FLUJO
                    $num_siguiente = $this->gsatelite->get_min('psf_paso_flujo','psf_orden', array('psf_id_flu' => $flujo_id));

                    $obligatorio = null;

                    //SE VERIFICA QUE EL PLAN CONTENGA UN PASO EN EL FLUJO.
                    //Como prioridad se busca un paso obligtorio
                    $where_obligatorios = array(
                        'psf_id_flu'        => $flujo_id,
                        'scm_id_ccc'        => $registro,
                        'psf_obligatorio'   => 1,
                        'scm_fecha_salida'  => null
                    );
                    $this->db->join('scm_seguimiento_comparativo_compra', 'psf_id = scm_id_psf', 'inner');
                    $this->db->group_by('psf_orden');
                    $num_obligatorios = $this->gsatelite->count('psf_paso_flujo', $where_obligatorios);

                    //  Si no se encuentra un paso obligatorio en proceso
                    //  se busca un paso opcional
                    $where_opcionales = array(
                        'psf_id_flu'        => $flujo_id,
                        'scm_id_ccc'        => $registro,
                        'psf_obligatorio'   => 0,
                        'scm_fecha_salida'  => null
                    );
                    $this->db->join('scm_seguimiento_comparativo_compra', 'psf_id = scm_id_psf', 'inner');
                    $this->db->group_by('psf_orden');
                    $num_opcionales = $this->gsatelite->count('psf_paso_flujo', $where_opcionales);

                    //   Se setea la variable $obligagorio con su valor respectivo dependiendo de
                    //   el tipo de paso que se encuentre
                    //   1: Obligatorio, 0: Opcional

                    if ($num_obligatorios > 0) {
                        $obligatorio = 1;
                    }
                    if ($num_opcionales > 0) {
                        $obligatorio = 0;
                    }

                    // SI SE TIENE UN PASO EN PROCESO SE OBTIENE DICHO PASO
                    if ($num_obligatorios > 0 || $num_opcionales > 0) {
                        $where_siguiente = array(
                            'psf_id_flu'        => $flujo_id,
                            'scm_id_ccc'        => $registro,
                            'psf_obligatorio'   => $obligatorio,
                            'scm_fecha_salida'  => null
                        );
                        $this->db->join('scm_seguimiento_comparativo_compra', 'psf_id = scm_id_psf', 'inner');
                        $num_siguiente = $this->gsatelite->get_campo('psf_paso_flujo', 'psf_paso_siguiente', $where_siguiente);
                    }

                    $this->db->limit(1);
                    $paso_siguiente = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id_flu' => $flujo_id, 'psf_orden' => $num_siguiente));
                    break;

                    break;
            }
        }
        return $paso_siguiente;
    }

    function get_paso_anterior($registro, $tipo_flujo) {
        $paso_anterior = null;
        if ($registro != null && $tipo_flujo != null) {
            switch ($tipo_flujo) {
                case 1:
                    //SE OBTIENE EL ID_FLUJO
                    $flujo_id = $this->gsatelite->get_campo('rxi_requisicion_inventario', 'rxi_id_flu', array('rxi_id' => $registro));
                    //SE OBTIENE EL PASO ACTUAL
                    $paso_actual = $this->get_paso_actual($registro, $tipo_flujo);
                    //Si hay un paso actual se obtienen el paso anterior
                    if (count($paso_actual) > 0) {
                        $orden_actual = $paso_actual[0]['psf_orden'];
                        $where = array(
                            'rxi_id' => $registro,
                            'flu_id' => $flujo_id,
                            'psf_paso_siguiente <= ' => $orden_actual,
                            'psf_paso_siguiente > ' => 0
                        );
                        //Se obtiene el paso anterior, del orden siguiente.
                        $query = $this->db->select()
                                ->from('psf_paso_flujo')
                                ->join('flu_flujo', 'psf_id_flu = flu_id', 'inner')
                                ->join('rxi_requisicion_inventario', 'rxi_id_flu = flu_id')
                                ->where($where)
                                ->order_by('psf_orden', 'DESC')
                        ;
                        $paso_anterior = $query->get()->result_array();
                    }
                    break;
                case 2:
                    //SE OBTIENE EL ID_FLUJO
                    $flujo_id = $this->gsatelite->get_campo('orc_orden_compra', 'orc_id_flu', array('orc_id' => $registro));

                    //SE OBTIENE EL PASO ACTUAL
                    $paso_actual = $this->get_paso_actual($registro, $tipo_flujo);

                    //Si hay un paso actual se obtienen el paso anterior
                    if (count($paso_actual) > 0) {

                        $orden_actual = $paso_actual[0]['psf_orden'];

                        $where = array(
                            'orc_id' => $registro,
                            'flu_id' => $flujo_id,
                            'psf_paso_siguiente' => $orden_actual
                        );
                        //Se obtiene el paso anterior, del orden siguiente.
                        $query = $this->db->select()
                                ->from('psf_paso_flujo')
                                ->join('flu_flujo', 'psf_id_flu = flu_id', 'inner')
                                ->join('orc_orden_compra', 'orc_id_flu = flu_id')
                                ->where($where)
                        ;

                        $paso_anterior = $query->get()->result_array();
                    }
                    break;
                case 4:
                    //SE OBTIENE EL ID_FLUJO
                    $flujo_id = $this->gsatelite->get_campo('ccc_comparativo_cotizacion_compra', 'ccc_id_flu', array('ccc_id' => $registro));
                    //SE OBTIENE EL PASO ACTUAL
                    $paso_actual = $this->get_paso_actual($registro, $tipo_flujo);
                    //Si hay un paso actual se obtienen el paso anterior
                    if (count($paso_actual) > 0) {
                        $orden_actual = $paso_actual[0]['psf_orden'];
                        $where = array(
                            'ccc_id' => $registro,
                            'flu_id' => $flujo_id,
                            'psf_paso_siguiente <= ' => $orden_actual,
                            'psf_paso_siguiente > ' => 0
                        );
                        //Se obtiene el paso anterior, del orden siguiente.
                        $query = $this->db->select()
                                ->from('psf_paso_flujo')
                                ->join('flu_flujo', 'psf_id_flu = flu_id', 'inner')
                                ->join('ccc_comparativo_cotizacion_compra', 'ccc_id_flu = flu_id')
                                ->where($where)
                                ->order_by('psf_orden', 'DESC')
                        ;
                        $paso_anterior = $query->get()->result_array();
                    }                    
                    break;
            }
        }
        return $paso_anterior;
    }

    /*
     * tipo flujo: 1- Requisiciones, 2- Orden de Compra, 4- Comparativo de compras.
     */

    public function get_historial_paso($registro, $tipo_flujo) {

        $historial = null;
        if ($registro != null && $tipo_flujo != null) {

            switch ($tipo_flujo) {
                case 1:

                    $where = array(
                        'rxi_id' => $registro,
                    );

                    $query = $this->db->select("
                                psf_nombre as paso,
                                username as usuario_responsable,
                                CONCAT(emp_nombre,' ',emp_apellido) as responsable,
                                sgr_fecha_entrada as fecha_entrada,
                                sgr_fecha_salida as fecha_salida,
                                sgr_observacion as comentario,
                                sgr_anexo as anexo
                            "
                                    , false)
                            ->from('rxi_requisicion_inventario')
                            ->join('sgr_seguimiento_requisicion', 'sgr_id_rxi = rxi_id', 'inner')
                            ->join('psf_paso_flujo', 'psf_id = sgr_id_psf', 'inner')
                            ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
                            ->join('users', 'sgr_id_usu = id', 'inner')
                            ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                    ;

                    $this->db->where($where);
                    $this->db->order_by('sgr_fecha_entrada DESC');
                    $historial = $query->get()->result_array();

                    break;
                case 2:

                    $where = array(
                        'orc_id' => $registro,
                    );

                    $query = $this->db->select("
                                psf_nombre as paso,
                                username as usuario_responsable,
                                CONCAT(emp_nombre,' ',emp_apellido) as responsable,
                                sgo_fecha_entrada as fecha_entrada,
                                sgo_fecha_salida as fecha_salida,
                                sgo_observacion as comentario,
                                sgo_anexo as anexo
                            "
                                    , false)
                            ->from('orc_orden_compra')
                            ->join('sgo_seguimiento_orden', 'sgo_id_orc = orc_id', 'inner')
                            ->join('psf_paso_flujo', 'psf_id = sgo_id_psf', 'inner')
                            ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
                            ->join('users', 'sgo_id_usu = id', 'inner')
                            ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                    ;

                    $this->db->where($where);
                    $this->db->order_by('sgo_fecha_entrada DESC');
                    $historial = $query->get()->result_array();

                    break;
                case 4:

                    $where = array(
                        'ccc_id' => $registro,
                    );

                    $query = $this->db->select("
                                psf_nombre as paso,
                                username as usuario_responsable,
                                CONCAT(emp_nombre,' ',emp_apellido) as responsable,
                                scm_fecha_entrada as fecha_entrada,
                                scm_fecha_salida as fecha_salida,
                                scm_observacion as comentario,
                                scm_anexo as anexo
                            "
                                    , false)
                            ->from('ccc_comparativo_cotizacion_compra')
                            ->join('scm_seguimiento_comparativo_compra', 'scm_id_ccc = ccc_id', 'inner')
                            ->join('psf_paso_flujo', 'psf_id = scm_id_psf', 'inner')
                            ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
                            ->join('users', 'scm_usu_creacion = id', 'inner')
                            ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                    ;

                    $this->db->where($where);
                    $this->db->order_by('scm_fecha_entrada DESC');
                    $historial = $query->get()->result_array();

            }
        }
        return $historial;
    }

    function get_backlog_ordenes_compra($where = null, $area = 0) {

        $query = $this->db->select('*, GROUP_CONCAT(DISTINCT rxp_id) id_rxp, GROUP_CONCAT(DISTINCT rxp_id_rol) id_rol', false)
                ->from('orc_orden_compra')
                ->join('prv_proveedor', 'prv_id = orc_id_prv', 'left')
                ->join('rxi_requisicion_inventario', 'orc_id_rxi = rxi_id', 'left')
                ->join('sgo_seguimiento_orden', 'sgo_id_orc = orc_id', 'inner')
                ->join('psf_paso_flujo', 'psf_id = sgo_id_psf', 'inner')
                ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
                ->join('rxp_rolxpaso', 'rxp_id_psf = psf_id', 'inner')
                ->join('uxr_usuarioxrol', 'uxr_id_rol = rxp_id_rol', 'inner')
                ->join('users', 'id = uxr_id_usu', 'inner')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                ->join('pcl_proyecto_cliente', 'pcl_id = orc_id_pcl', 'left')
                ->order_by('orc_fecha_creacion','DESC')
        ;

        $this->db->where('((psf_area = 1 AND (emp_id_are = ' . $area . ')) OR psf_area = 0)');
        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('orc_id');
        return $query->get()->result_array();
    }

    public function get_detalle_orden_compra($where = null) {
        $query = $this->db->select("*, IF(orc_estado = 7,(SELECT moi_id_bod FROM moi_movimiento_inv WHERE moi_id_orc = orc_id),0) AS bodega_moi,
                    IF(art_codigo IS NOT NULL,art_codigo,act_codigo) as codigo,
                    IF(art_nombre IS NOT NULL,art_nombre,act_nombre) as nombre,
                    IF(mep_nombre IS NOT NULL,mep_nombre, ' -- ') as medida", FALSE)
                ->from('dor_detalle_orden_compra')
                ->join('orc_orden_compra', 'orc_id = dor_id_orc')
                ->join('prv_proveedor', 'prv_id = orc_id_prv', 'left')
                ->join('art_articulo', 'art_id = dor_id_art', 'left')
                ->join('act_activo_fijo', 'act_id = dor_id_act', 'left')
                ->join('cva_conversion_articulo', 'cva_id = dor_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
                ->join('bod_bodega', 'bod_id = art_id_bod', 'left')
                ->join('sxb_sectorxbodega', 'sxb_id = art_id_sxb', 'left')
                ->join('seb_sector_bodega', 'seb_id = sxb_id_seb', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_impuestos_detalle_orden($where = null) {
        $query = $this->db->select()
                ->from('ixo_impuestoxdetalle_orden')
                ->join('imp_impuesto', 'imp_id = ixo_id_imp', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_gastos_detalle_orden($where = null) {
        $query = $this->db->select()
                ->from('gxd_gastosxdetalle_orden')
                ->join('gst_gasto', 'gst_id = gxd_id_gst', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_articulo_like($articulo, $servicio, $where = null, $where_in = null) {
        $this->db->select();
        $this->db->from('art_articulo');
        $this->db->like('art_nombre', $articulo);
        $this->db->or_like('art_sinonimo', $articulo);
        $this->db->or_like('art_codigo', $articulo);
        $this->db->limit(100);
        if ($servicio == 'servicio') {
            $this->db->where('art_tipo', 1);
        } elseif ($servicio == 'articulo') {
            $this->db->where('art_tipo', 0);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        if ($where_in != null) {
            $this->db->where_in('art_id_tia', $where_in);
        }

        $this->db->where('art_estado', 1);
        $query = $this->db->get();

        return $query->result_array();
    }

    public function insertar_prorrateos_gastos($nombre, $usuario_id) {
        $dato_prorrateo = array(
            'ptg_nombre'            => $nombre,
            'ptg_fecha_registro'    => date('Y-m-d H:i:s'),
            'ptg_estado'            => 1,
            'ptg_usu_creacion'      => $usuario_id,
            'ptg_usu_modificacion'  => $usuario_id,
            'ptg_fecha_creacion'    => date('Y-m-d H:i:s'),
            'ptg_fecha_modificacion'=> date('Y-m-d H:i:s')
        );
        $this->db->insert('ptg_prorrateo_gasto', $dato_prorrateo);
        return $this->db->insert_id();
    }

    public function insertar_detalle_prorrateo($data, $prorrateo_id, $usuario_id) {
        //agregar detalle prorrateos
        foreach ($data['porcentaje'] as $key => $datos) {
            $datos = array(
                'dpr_id_ptg'                => $prorrateo_id,
                'dpr_id_cec'                => $data['txt_centro_costo'][$key],
                'dpr_id_cnt'                => $data['txt_cuenta_contable'][$key],
                'dpr_porcentaje'            => substr($data['porcentaje'][$key], 0, -1),
                'dpr_estado'                => 1,
                'dpr_usu_creacion'          => $usuario_id,
                'dpr_fecha_creacion'        => date('Y-m-d H:i:s'),
                'dpr_usu_modificacion'      => $usuario_id,
                'dpr_fecha_modificacion'    => date('Y-m-d H:i:s')
            );
            $this->db->insert('dpr_detalle_prorrateo', $datos);
        }
        return $prorrateo_id;
    }

    public function obtener_detalleprorrateo($prorrateo_id) {
        $this->db->select()
                ->from('dpr_detalle_prorrateo')
                ->join('cec_centro_costo', ' cec_id = dpr_id_cec')                
                ->join('cnt_cuenta_contable', ' dpr_id_cnt = cnt_id','left')                
                ->join('art_articulo', ' art_id = dpr_id_art', 'left')
                ->where('dpr_id_ptg', $prorrateo_id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_backlog_compras($where = null, $tipo = null) {
        if ($where != null) {
            $where_req          = $where['requisiciones'];
            $where_comp         = $where['ordenes'];
            $where_comparativo  = $where['comparativo'];
        }

        //Query Requisiciones
        $query = $this->db->select(
                        "rxi_id as registro,
                    1 as tipo_flujo,
                    rxi_numero as codigo_registro,
                    'Requisición' as tipo,
                    sgr_fecha_entrada as fecha_entrada,
                    rxi_fecha as fecha_documento,
                    psf_nombre as paso_actual,
                    rxi_estado as estado_registro,
                    arc_orc.are_nombre as area,
                    psf_id as paso,
                    rxp_id as rol_paso,
                    GROUP_CONCAT(rxp_id) as id_rxp,
                    are.are_nombre as area_solicitante2,
                    rxi_descripcion as detalles,
                    (
                        SELECT are_nombre from emp_empleado
                        JOIN users on emp_id_usu = id
                        JOIN are_area on are_id = emp_id_are
                        where id = rxi_id_usu_solicita
                        limit 1
                    ) area_solicitante, pcl_codigo,
                    (
                        SELECT username FROM users 
                        WHERE id = rxi_id_usu_solicita
                    ) user_solicitante
                    ", false)
                ->from('rxi_requisicion_inventario')
                ->join('bod_bodega', 'bod_id = rxi_id_bod', 'left')
                ->join('orc_orden_compra', 'orc_id_rxi = rxi_id', 'left')
                ->join('prv_proveedor', 'prv_id = orc_id_prv', 'left')
                ->join('are_area as arc_orc', 'arc_orc.are_id = orc_id_are', 'left')
                ->join('sgr_seguimiento_requisicion', 'sgr_id_rxi = rxi_id', 'inner')
                ->join('psf_paso_flujo', 'psf_id = sgr_id_psf', 'inner')
                ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
                ->join('rxp_rolxpaso', 'rxp_id_psf = psf_id', 'inner')
                ->join('uxr_usuarioxrol', 'uxr_id_rol = rxp_id_rol', 'inner')
                ->join('users', 'id = uxr_id_usu', 'inner')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                ->join('are_area as are', 'are.are_id = emp_id_are', 'left')
                ->join('pcl_proyecto_cliente', 'pcl_id = rxi_id_pcl', 'left')
                ->group_by('rxi_id')
        ;

        $area = 0;

        if ($where_req['area'] != null) {
            $area = $where_req['area'];
            unset($where_req['area']);
        }

        $this->db->where('((psf_area = 1 AND (emp_id_are = ' . $area . ')) OR psf_area = 0)');

        if ($where_req != null) {
            $this->db->where($where_req);
        }

        $result = $query->get()->result_array();
        $query_requisicion = $this->db->last_query();

        //Query ordenes de compra
        $query = $this->db->select("orc_id as registro,
                    2 as tipo_flujo,
                    orc_numero as codigo_registro,
                    'Orden de compra' as tipo,
                    sgo_fecha_entrada as fecha_entrada,
                    orc_fecha_orden as fecha_documento,
                    psf_nombre as paso_actual,
                    orc_estado as estado_registro,
                    arc_orc.are_nombre as area,
                    psf_id as paso,
                    rxp_id as rol_paso,
                    GROUP_CONCAT(rxp_id) as id_rxp,
                    are.are_nombre as area_solicitante2,
                    orc_descripcion as detalles,
                    (
                        SELECT are_nombre from emp_empleado
                        JOIN users on emp_id_usu = id
                        JOIN are_area on are_id = emp_id_are
                        where id = orc_id_usu_solicita
                        limit 1
                    ) area_solicitante,
                    pcl_codigo,
                    (
                        SELECT username FROM users 
                        WHERE id = orc_id_usu_solicita
                    ) user_solicitante
                    ", false)
                ->from('orc_orden_compra')
                ->join('prv_proveedor', 'prv_id = orc_id_prv', 'left')
                ->join('are_area as arc_orc', 'arc_orc.are_id = orc_id_are', 'left')
                ->join('rxi_requisicion_inventario', 'orc_id_rxi = rxi_id', 'left')
                ->join('sgo_seguimiento_orden', 'sgo_id_orc = orc_id', 'inner')
                ->join('psf_paso_flujo', 'psf_id = sgo_id_psf', 'inner')
                ->join('flu_flujo', 'flu_id = psf_id_flu', 'inner')
                ->join('rxp_rolxpaso', 'rxp_id_psf = psf_id', 'inner')
                ->join('uxr_usuarioxrol', 'uxr_id_rol = rxp_id_rol', 'inner')
                ->join('users', 'id = uxr_id_usu', 'inner')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                ->join('are_area as are', 'are.are_id = emp_id_are', 'left')
                ->join('pcl_proyecto_cliente', 'pcl_id = orc_id_pcl', 'left')
                ->group_by('orc_id')
        ;

        $area = 0;

        if ($where_comp['area'] != null) {
            $area = $where_comp['area'];
            unset($where_comp['area']);
        }

        $this->db->where('((psf_area = 1 AND (emp_id_are = ' . $area . ')) OR psf_area = 0)');

        if ($where_comp != null) {
            $this->db->where($where_comp);
        }

        $result = $query->get()->result_array();
        $query_ordenes = $this->db->last_query();


        //Query comparativo 
        $query = $this->db->select("
                ccc_id AS registro,
                4 AS tipo_flujo,
                rxi_numero AS codigo_registro,
                'Comparativo de cotización' AS tipo,
                scm_fecha_entrada AS fecha_entrada,
                ccc_fecha AS fecha_documento,
                psf_nombre AS paso_actual,
                ccc_estado AS estado_registro,
                'arc_orc.are' AS area,
                psf_id AS paso,
                rxp_id AS rol_paso,
                GROUP_CONCAT(rxp_id) AS id_rxp,
                'are.are_nombre' AS area_solicitante2,
                ccc_observacion AS detalles,
                (
                    SELECT
                        are_nombre
                    FROM
                        emp_empleado
                    JOIN users ON emp_id_usu = id
                    JOIN are_area ON are_id = emp_id_are
                    WHERE
                        id = rxi_id_usu_solicita
                    LIMIT 1
                ) area_solicitante,
                pcl_codigo,
                (
                    SELECT
                        username
                    FROM
                        users
                    WHERE
                        id = ccc_id_usu_crea
                ) user_solicitante",false)
            ->from('ccc_comparativo_cotizacion_compra')
            ->join('rxi_requisicion_inventario','rxi_id = ccc_id_rxi','INNER')
            ->join('scm_seguimiento_comparativo_compra','scm_id_ccc = ccc_id','INNER')
            ->join('psf_paso_flujo','psf_id = scm_id_psf','INNER')
            ->join('rxp_rolxpaso','rxp_id_psf = psf_id','INNER')
            ->join('uxr_usuarioxrol', 'uxr_id_rol = rxp_id_rol', 'inner')
            ->join('users', 'id = uxr_id_usu', 'inner')
            ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
            ->join('pcl_proyecto_cliente','pcl_id = rxi_id_pcl','LEFT')
            ->group_by('ccc_id')
        ;

        $area = 0;
        
        if ($where_comparativo['area'] != null) {
            $area = $where_comparativo['area'];
            unset($where_comparativo['area']);
        }

        $this->db->where('((psf_area = 1 AND (emp_id_are = ' . $area . ')) OR psf_area = 0)');

        if ($where_comparativo != null) {
            $this->db->where($where_comparativo);
        }

        $result = $query->get()->result_array();
        $query_comparativo = $this->db->last_query();

        /*
         * Se valida el tipo de solicitud buscada
         * Tipo 1 = requisiciones, 2 = Ordenes de Compra
         */
        if ($tipo == 1) {
            $query_final = $query_requisicion;
        } else if ($tipo == 2) {
            $query_final = $query_ordenes;
        } else {
            //Se unifican las consultas para generar el listado
            $query_final = "SELECT * FROM( (" . $query_requisicion . ") UNION (" . $query_ordenes . ") UNION (" . $query_comparativo . ") ) AS principal ORDER BY principal.fecha_entrada DESC";
        }
       
        $resultado = $this->db->query($query_final);
        return $resultado->result_array();
    }

    public function get_ordenes_compra($where = null) {
        //Query ordenes de compra
        $query = $this->db->select()
                ->from('orc_orden_compra')
                ->join('prv_proveedor', 'prv_id = orc_id_prv', 'left')
                ->join('are_area', 'are_id = orc_id_are', 'left')
                ->join('prd_prioridad', 'prd_id = orc_id_prd', 'left')
                ->join('users', 'id = orc_id_usu_solicita', 'left')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                ->join('rxi_requisicion_inventario', 'orc_id_rxi = rxi_id', 'left')
                ->join('pcl_proyecto_cliente', 'pcl_id = orc_id_pcl', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function cambiar_estado_registro_flujo($registro, $tipoFlujo, $estado) {

        $registro_array = array();
        $tabla = "";
        $where = null;
        //Se modifica el estado en base al tipo de flujo.
        switch ($tipoFlujo) {
            case 1:

                $registro_array['rxi_estado'] = $estado;
                $registro_array['rxi_usu_modificacion'] = $this->tank_auth->get_user_id();
                $registro_array['rxi_fecha_modificacion'] = date('Y-m-d H:i:s');
                $tabla = "rxi_requisicion_inventario";
                $where = array('rxi_id' => $registro);
                break;
            case 2:

                $registro_array['orc_estado'] = $estado;
                $registro_array['orc_usu_modificacion'] = $this->tank_auth->get_user_id();
                $registro_array['orc_fecha_modificacion'] = date('Y-m-d H:i:s');
                $tabla = "orc_orden_compra";
                $where = array('orc_id' => $registro);
                break;
            case 4:

                $registro_array['ccc_estado']               = $estado;
                $registro_array['ccc_usu_modificacion']     = $this->tank_auth->get_user_id();
                $registro_array['ccc_fecha_modificacion']   = date('Y-m-d H:i:s');
                $tabla                                      = "ccc_comparativo_cotizacion_compra";
                $where                                      = array('ccc_id' => $registro);
                break;
        }

        if (count($registro_array) > 0 && $tabla != '' && $where != null) {
            $resultado = $this->gsatelite->actualizar_array($tabla, $registro_array, $where);
        }

        return $resultado;
    }

    public function get_contratos_proveedor($contrato) {
        $query = $this->db->select()
                ->from('cop_contrato_proveedor')
                ->join('prv_proveedor', 'prv_id = cop_id_prv')
                ->join('art_articulo', 'art_id = cop_id_art')
                ->where('cop_id', $contrato);
        return $query->get()->result_array();
    }

    public function get_compras_proveedor($where = null) {
        /*
            SELECT 
                orc_numero numero, prv_tipo_pers, prv_nombre, prv_apellido, orc_fecha_orden fecha_orden, orc_total total
            FROM
                (`orc_orden_compra`)
            LEFT JOIN `prv_proveedor` ON `prv_id` = `orc_id_prv`
            WHERE
                `orc_fecha_orden` >= '2019-11-01'
            AND `orc_fecha_orden` <= '2019-11-08'
            UNION
            SELECT 
                dpv_numero_documento numero, prv_tipo_pers, prv_nombre, prv_apellido, dpv_fecha_documento fecha_orden, dpv_total total
            FROM
                (`dpv_documento_proveedor`)
            LEFT JOIN `prv_proveedor` ON `prv_id` = `dpv_id_prv`
            WHERE
                `dpv_fecha_documento` >= '2019-11-01'
            AND `dpv_fecha_documento` <= '2019-11-08'
        */
        $query = "SELECT 
                    orc_numero numero, prv_tipo_pers, prv_nombre, prv_apellido, orc_fecha_orden fecha_orden, orc_total total
                FROM
                    (`orc_orden_compra`)
                LEFT JOIN `prv_proveedor` ON `prv_id` = `orc_id_prv`
                    ".(($where[0] != "")?" WHERE ".$where[0]:"")."
                UNION
                SELECT 
                    dpv_numero_documento numero, prv_tipo_pers, prv_nombre, prv_apellido, dpv_fecha_documento fecha_orden, dpv_total total
                FROM
                    (`dpv_documento_proveedor`)
                LEFT JOIN `prv_proveedor` ON `prv_id` = `dpv_id_prv`
                ".(($where[1] != "")?" WHERE ".$where[1]:"")." ";

        return $this->db->query($query, false)->result_array();

        // $query = $this->db->select()
        //         ->from('orc_orden_compra')
        //         ->join('prv_proveedor', 'prv_id = orc_id_prv', 'left')
        // ;
        // if ($where != null) {
        //     $this->db->where($where);
        // }
        // return $query->get()->result_array();
    }
    /*
     * @modify Manuel Anzora
     * undate: el join a la tabla are_area se hizo left join
     * date: 10-12-2018
     */
    public function get_reporte_requisiciones($where = null) {
        $query = $this->db->select()
                ->from('rxi_requisicion_inventario')
                ->join('bod_bodega', 'bod_id = rxi_id_bod', 'left')
                ->join('suc_sucursal', 'suc_id = bod_id_suc', 'left')
                ->join('users', 'id = rxi_id_usu_solicita', 'inner')
                ->join('emp_empleado', 'emp_id_usu = id', 'left')
                ->join('are_area', 'are_id = emp_id_are','left')

        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_categoria_like($categoria) {
        $this->db->select();
        $this->db->from('tia_tipo_articulo');
        $this->db->like('tia_nombre', $categoria);
        $this->db->or_like('tia_codigo', $categoria);
        $this->db->limit(100);
        $this->db->where('tia_estado', 1);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_reporte_compras_producto($where = null) {
        $query = $this->db->select()
                ->from('dpv_documento_proveedor')
                ->join('dxd_detalle_documento_proveedor', 'dxd_id_dpv = dpv_id')
                ->join('prv_proveedor', 'prv_id = dpv_id_prv', 'left')
                ->join('art_articulo', 'art_id = dxd_id_art', 'left')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia', 'left')
                ->join('cva_conversion_articulo', 'cva_id = dxd_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        //print_r($query); die();
        return $query->get()->result_array();
    }

    public function get_total_reporte_compras_roducto($where = null) {
        $query = $this->db->select_sum('dpv_total')
                ->from('dpv_documento_proveedor')
                ->join('dxd_detalle_documento_proveedor', 'dxd_id_dpv = dpv_id')
                ->join('art_articulo', 'art_id = dxd_id_art')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_detalle_requisicion($where = null) {
        $this->db->select()
                ->from('dri_detalle_requisicion_inventario')
                ->join('rxi_requisicion_inventario', 'rxi_id = dri_id_rxi')
                ->join('art_articulo', 'art_id = dri_id_art', 'left')
                ->join('tia_tipo_articulo', 'art_id_tia = tia_id', 'left')
                ->join('cva_conversion_articulo', 'cva_id = dri_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
                ->join('act_activo_fijo', 'act_id = dri_id_act', 'left')
                ->join('tac_tipo_activofijo', 'act_id_tac = tac_id', 'left')
                ->join('ace_actividad_especifica', 'ace_id = rxi_id_ace', 'left')
                ->join('users', 'id = rxi_id_usu_solicita', 'left')
                ->join('pcl_proyecto_cliente', 'pcl_id = rxi_id_pcl', 'left')//agrega los datos de proyecto para sustraer su nombre
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        $query = $this->db->get()->result_array();
        return $query;
    }

    public function get_datos_dpv($where = null) {
        $query = $this->db->select("*, (SELECT tif_nombre FROM tif_tipo_factura WHERE tif_id = d.dpv_id_tif) AS tipo_doc,
            (SELECT tpg_nombre FROM tpg_tipo_pago WHERE tpg_id = d.dpv_id_tpg) AS tipo_pago_nombre, (SELECT orc_numero FROM orc_orden_compra WHERE orc_id = d.dpv_id_orc) AS orden_compra,
            (SELECT cec_nombre FROM cec_centro_costo WHERE cec_id = d.dpv_id_cec) AS centro_compra, (SELECT cch_nombre FROM cch_caja_chica WHERE cch_id = d.dpv_id_cch) AS caja_chica, 
            (SELECT cod_nombre FROM cod_condicion WHERE cod_id = d.dpv_id_cod) AS condicion_pago, (SELECT tmt_nombre FROM tmt_tipo_monto WHERE tmt_id = d.dpv_id_tmt) AS tipo_monto,
            (SELECT CONCAT(t.tif_abreviacion,' - ',a.dpv_numero_documento) FROM dpv_documento_proveedor AS a JOIN tif_tipo_factura AS t ON t.tif_id = a.dpv_id_tif 
            WHERE a.dpv_id = d.dpv_id_dpv_afecta) AS doc_afecta, (SELECT CONCAT(prv_codigo,' - ',IF(prv_tipo_pers > 1, prv_apellido,CONCAT(prv_nombre,' ',prv_apellido))) FROM prv_proveedor 
            WHERE prv_id = d.dpv_id_prv) AS proveedor, (SELECT mep_nombre FROM mep_medida_producto JOIN cva_conversion_articulo ON cva_id_mep = mep_id WHERE cva_id = dxd_id_cva) AS medida", false)
            ->from('dpv_documento_proveedor AS d')
            ->join('dxd_detalle_documento_proveedor', 'dxd_id_dpv = d.dpv_id')
            ->join('art_articulo', 'art_id = dxd_id_art', 'left')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_documentos_proveedor($where = null, $where_in = null) {        
        $query = $this->db->select('*, (SELECT count(*) '
                        . 'FROM chp_cheque_pendiente '
                        . 'WHERE chp_id_dpv = dpv_id AND chp_generado = 0 and chp_estado = 1) as cheques_pendientes,'
                        . '(SELECT count(*) FROM che_cheque
                            inner join dch_detalle_cheque on che_id = dch_id_che 
                            WHERE dch_id_dpv = dpv_id and che_estado=1) as cheque'
                        . ',(SELECT COUNT(*) FROM agp_agenda_pago
                    INNER JOIN chp_cheque_pendiente ON chp_id_agp = agp_id
                    WHERE agp_id_dpv = dpv_id) as agendas_pendientes,
                     (SELECT count(che_id) FROM che_cheque
                    INNER JOIN chp_cheque_pendiente ON che_id = chp_id_che
                    INNER JOIN tra_transaccion ON tra_id = che_id_tra
                    WHERE chp_id_dpv = dpv_id AND tra_aplicar = 0) as cheque_sin_aplicar,
                    (
                        SELECT COUNT(*)
                        FROM dpv_documento_proveedor as b
                        WHERE a.dpv_id = b.dpv_id_dpv_afecta
                    ) as tiene_nota', false)
                ->from('dpv_documento_proveedor as a')
                ->join('orc_orden_compra', 'orc_id = a.dpv_id_orc', 'left')
                ->join('tpg_tipo_pago', 'tpg_id = a.dpv_id_tpg', 'left')
                ->join('prv_proveedor', 'prv_id = a.dpv_id_prv', 'inner')
                ->join('tif_tipo_factura', 'tif_id = a.dpv_id_tif', 'left')
                ->join('cch_caja_chica', 'cch_id = dpv_id_cch', 'left')
                ->join('rtd_retaceo_documento_proveedor', 'rtd_id_dpv = a.dpv_id', 'left')
                ->join('pcl_proyecto_cliente', 'pcl_id = a.dpv_id_pcl', 'left')
                ->join('dgp_detalle_gasto_prespuesto', 'dgp_id_dpv = a.dpv_id', 'left')
                ->join('dps_detalle_presupuesto', 'dps_id = dgp_id_dps', 'left')
                ->join('ace_actividad_especifica', 'ace_id = dps_id_ace', 'left')
        ;
        $this->db->where('a.dpv_estado > ', 0 );

        if ($where != null) {
            $this->db->where($where);
        }

        if (is_array($where_in) && count($where_in) > 0) {
            $this->db->where_in('a.dpv_id', $where_in);
            $this->db->group_by('a.dpv_id');
        }

        return $query->get()->result_array();        
    }

    public function get_grid_documentos_proveedor($where = null){
        $query = $this->db->select("dpv_id, dpv_afecta_inventario, dpv_estado, dpv_fecha_documento, dpv_id_dpv_afecta, dpv_id_usu_anula, dpv_monto_abono, dpv_monto_nta_credito, dpv_monto_nta_debito, dpv_numero_documento, dpv_pagado, dpv_tipo, dpv_total, dpv_usu_creacion, prv_nombre, prv_apellido, prv_tipo_pers, orc_numero, pcl_codigo, dpv_id_tif, dpv_sello_recepcion, dpv_retencion,
            dpv_monto_pendiente, tif_aplica_nota_credito, tif_aplica_nota_debito, tif_nombre, rtd_id, (SELECT cch_nombre FROM cch_caja_chica WHERE cch_id = dpv_id_cch) AS caja_chica,
            (CASE 
                WHEN dpv_pagado = 1 THEN 'Pagado'
                WHEN dpv_monto_abono = 0 THEN 'Pendiente'
                WHEN dpv_monto_pendiente > 0 AND dpv_pagado = 0 THEN 'Creado'
                ELSE ''
            END) AS estadox,
            (IF(dpv_retencion > 0, (SELECT SUM(IFNULL(ret_aplica_renta,0)) FROM rxd_retencionxdetalle_documento JOIN ret_retencion ON ret_id = rxd_id_ret 
                JOIN dxd_detalle_documento_proveedor ON dxd_id = rxd_id_dxd WHERE dxd_id_dpv = dpv_id),NULL)) AS rete_renta,
            IF(prv_tipo_pers = 1,CONCAT_WS(' ',prv_nombre,prv_apellido),prv_apellido) AS proveedor,
            (SELECT COUNT(chp_id) FROM chp_cheque_pendiente WHERE chp_id_dpv = dpv_id AND chp_generado = 0 AND chp_estado = 1) AS cheques_pendientes,
            (SELECT COUNT(ntp_id) FROM ntp_nota_abono_pendiente WHERE ntp_id_dpv = dpv_id AND ntp_generado = 0 AND ntp_estado = 1) AS transferencia_pendientes,
            (SELECT COUNT(otp_id) FROM otp_otra_forma_pgpendiente WHERE otp_id_dpv = dpv_id AND otp_generado = 0 AND otp_estado = 1) AS otras_formas_pendientes, 
            (SELECT COUNT(che_id) FROM che_cheque JOIN dch_detalle_cheque ON che_id = dch_id_che WHERE dch_id_dpv = dpv_id AND che_estado = 1) AS cheque, 
            (SELECT COUNT(agp_id) FROM agp_agenda_pago JOIN chp_cheque_pendiente ON chp_id_agp = agp_id WHERE agp_id_dpv = dpv_id) AS agendas_pendientes,
            (SELECT COUNT(a.dpv_id) FROM dpv_documento_proveedor AS a WHERE a.dpv_id_dpv_afecta = dpv_id) AS tiene_nota,
            (SELECT COUNT(che_id) FROM che_cheque JOIN chp_cheque_pendiente ON che_id = chp_id_che JOIN tra_transaccion ON tra_id = che_id_tra WHERE chp_id_dpv = dpv_id AND tra_aplicar = 0) AS cheque_sin_aplicar", false)
            ->from('dpv_documento_proveedor')
            ->join('prv_proveedor', 'prv_id = dpv_id_prv')
            ->join('orc_orden_compra', 'orc_id = dpv_id_orc', 'LEFT')
            ->join('pcl_proyecto_cliente', 'pcl_id = dpv_id_pcl', 'LEFT')
            ->join('tif_tipo_factura', 'tif_id = dpv_id_tif', 'LEFT')
            ->join('rtd_retaceo_documento_proveedor', 'rtd_id_dpv = dpv_id', 'LEFT')
            ->where('dpv_estado > 0')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    } 

    public function comp_retenc_renta($where=null){
        $nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT', 0);
        $query = $this->db->select("dpv_fecha_documento, IF(prv_tipo_pers > 1, prv_apellido , CONCAT_WS(' ',prv_nombre,prv_apellido)) AS nombre_prv, 
            (SELECT dcp_valor FROM dcp_documento_proveedor WHERE dcp_id_prv = prv_id AND dcp_id_tde = $nit) AS nit, 
            IFNULL((SELECT dis_nombre FROM dis_distrito WHERE dis_id = prv_id_dis), (SELECT mun_nombre FROM mun_municipio WHERE mun_id = prv_id_mun)) AS domicilio, 
            ret_porcentaje, SUM(rxd_monto) as monto, dpv_concepto, SUM(dxd_subtotal) AS msujeto", false)
                ->from('rxd_retencionxdetalle_documento')
                ->join('ret_retencion', 'ret_id = rxd_id_ret')
                ->join('dxd_detalle_documento_proveedor', 'dxd_id = rxd_id_dxd')
                ->join('dpv_documento_proveedor', 'dpv_id = dxd_id_dpv')
                ->join('prv_proveedor', 'prv_id = dpv_id_prv')
                ->where('ret_aplica_renta', 1)
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }
    
    public function get_detalle_doc_proveedor($where = null) {
        $query = $this->db->select('*, cva.cva_conversion as conversion1, cva2.cva_conversion as conversion2')
                ->from('dxd_detalle_documento_proveedor')
                ->join('art_articulo', 'art_id = dxd_id_art', 'left')
                ->join('act_activo_fijo', 'act_id = dxd_id_act', 'left')
                ->join('cva_conversion_articulo as cva', 'cva.cva_id = dxd_id_cva', 'left')
                ->join('cva_conversion_articulo as cva2', 'cva2.cva_id_art = art_id and cva2.cva_defecto = 1 and cva2.cva_estado = 1', 'left')
                ->join('mep_medida_producto', 'mep_id = cva.cva_id_mep', 'left')
                ->join('tpv_tipo_venta', 'tpv_id = dxd_id_tpv', 'left')
                ->join('bod_bodega', 'bod_id = dxd_id_bod', 'left')
                ->join('sxb_sectorxbodega', 'sxb_id = dxd_id_sxb', 'left')
                ->join('seb_sector_bodega', 'seb_id = sxb_id_seb', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_impuestos_detalle_docProveedor($where = null) {
        $query = $this->db->select()
                ->from('idd_impuestoxdetalle_documento')
                ->join('imp_impuesto', 'imp_id = idd_id_imp', 'inner')
                ->join('dxd_detalle_documento_proveedor', 'dxd_id = idd_id_dxd', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_retenciones_detalle_docProveedor($where = null) {
        $query = $this->db->select()
                ->from('rxd_retencionxdetalle_documento')
                ->join('ret_retencion', 'ret_id = rxd_id_ret', 'inner')
                ->join('dxd_detalle_documento_proveedor', 'dxd_id = rxd_id_dxd', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_slct_prvdrs_comp_ret($where = null) {
        $query = $this->db->select("prv_id, prv_tipo_pers, prv_codigo, prv_apellido,prv_nombre")
                ->from('dpv_documento_proveedor')
                ->join('prv_proveedor', 'prv_id = dpv_id_prv', 'inner')
                ->join('dxr_document_prov_retencion', 'dxr_id_dpv = dpv_id', 'left')
                ->join('cre_comprobante_retencion', 'cre_id = dxr_id_cre  AND cre_estado > 0', 'left')
                ->where("dpv_retencion > 0")
                ->where("dpv_estado > 0")
                ->where("cre_id IS NULL")
                ->group_by('prv_id')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_slct_dpv_prv_comp_ret($where = null) {
        $query = $this->db->select("tif_abreviacion, dpv_id, dpv_numero_documento, dpv_fecha_documento, dpv_retencion", false)
                ->from('dpv_documento_proveedor')
                ->join('tif_tipo_factura', 'tif_id = dpv_id_tif', 'inner')
                ->join('dxr_document_prov_retencion', 'dxr_id_dpv = dpv_id', 'left')
                ->where("dpv_retencion > 0")
                ->where("dxr_id IS NULL")
                ->group_by('dpv_id')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function datos_grid_comp_ret_masv($where = null) {
        $query = $this->db->select("tif_abreviacion, dpv_id, dpv_numero_documento, dpv_fecha_documento, dpv_retencion", false)
                ->from('dpv_documento_proveedor')
                ->join('tif_tipo_factura', 'tif_id = dpv_id_tif', 'inner')
                ->join('dxr_document_prov_retencion', 'dxr_id_dpv = dpv_id', 'left')
                ->where("dpv_retencion > 0")
                ->where("dxr_id IS NULL")
                ->group_by('dpv_id')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_retaceos($where = null) {
        $query = $this->db->select()
                ->from('rtd_retaceo_documento_proveedor')
                ->join('dpv_documento_proveedor', 'dpv_id = rtd_id_dpv', 'inner')
                ->join('prv_proveedor', 'dpv_id_prv = prv_id', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_retaceos_consolidado($where = null) {
        $query = $this->db->select()
                ->from('rdv_retaceo_documento_proveedor')
                ->join('rtd_retaceo_documento_proveedor', 'rtd_id = rdv_id_rtd')
                ->join('dpv_documento_proveedor', 'dpv_id = rdv_id_dpv')
                ->join('prv_proveedor', 'prv_id = dpv_id_prv')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_detalle_retaceo($where = null) {
        $query = $this->db->select()
                ->from('drc_detalle_retaceo')
                ->join('art_articulo', 'art_id = drc_id_art', 'left')
                ->join('cva_conversion_articulo', 'cva_id = drc_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
                ->join('rtd_retaceo_documento_proveedor', 'rtd_id = drc_id_rtd')
                ->join('dpv_documento_proveedor', 'dpv_id = rtd_id_dpv')
                ->join('prv_proveedor', 'prv_id = dpv_id_prv')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_retaceo_consolida($where = null) {
        $query = $this->db->select()
                ->from('drc_detalle_retaceo')
                ->join('dxd_detalle_documento_proveedor', 'dxd_id = drc_id_dxd')
                ->join('dpv_documento_proveedor', 'dpv_id = dxd_id_dpv')
                ->join('art_articulo', 'art_id = drc_id_art', 'left')
                ->join('cva_conversion_articulo', 'cva_id = drc_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_gastos_retaceo($where = null) {
        $query = $this->db->select("*, (SELECT GROUP_CONCAT(art_nombre SEPARATOR ',<br>')
                                        FROM art_articulo
                                        INNER JOIN dxd_detalle_documento_proveedor ON dxd_id_art = art_id
                                        INNER JOIN gxd_gastoxdetalle_documento ON gxd_id_dxd = dxd_id
                                        WHERE gxd_id_grc = grc_id) AS productos,

                                        (SELECT GROUP_CONCAT(dxd_id_art)
                                        FROM dxd_detalle_documento_proveedor
                                        INNER JOIN gxd_gastoxdetalle_documento ON gxd_id_dxd = dxd_id
                                        WHERE gxd_id_grc = grc_id) AS productos_id,

                                        (SELECT GROUP_CONCAT(CONCAT('tr_',dxd_id_art,'-',dxd_id_dpv,dxd_id))
                                        FROM dxd_detalle_documento_proveedor
                                        INNER JOIN gxd_gastoxdetalle_documento ON gxd_id_dxd = dxd_id
                                        WHERE gxd_id_grc = grc_id) AS productos_x,

                                        (SELECT COUNT(art_id) FROM art_articulo
                                        INNER JOIN dxd_detalle_documento_proveedor ON dxd_id_art = art_id
                                        INNER JOIN gxd_gastoxdetalle_documento ON gxd_id_dxd = dxd_id
                                        WHERE gxd_id_grc = grc_id) AS cantidad_productos",false)
                ->from('grc_gasto_retaceo')
                ->join('gst_gasto', 'gst_id = grc_id_gst', 'left')
                ->join('dpv_documento_proveedor', 'dpv_id = grc_id_dpv', 'left')
                ->join('prv_proveedor', 'dpv_id_prv = prv_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_producto_mas_comprado($where = null, $limit = null, $order = 1) {
        // $query = $this->db->select("art_codigo,art_nombre,mep_nombre,
        //             (SELECT COUNT(dor_id_art)
        //             FROM art_articulo a
        //             WHERE a.art_id = dor_id_art
        //             ) cant,
        //             (
        //             SELECT orc_fecha_orden
        //             FROM orc_orden_compra AS orc
        //             WHERE orc.orc_id = dor_id_orc
        //             ORDER BY orc_id DESC
        //             LIMIT 1
        //             ) as ultima_fecha,
        //             SUM(dor_cantidad) as cantidad
        //             ")
        //         ->from('orc_orden_compra')
        //         ->join('dor_detalle_orden_compra', 'dor_id_orc = orc_id')
        //         ->join('art_articulo', 'art_id = dor_id_art')
        //         ->join('cva_conversion_articulo', 'cva_id = dor_id_cva')
        //         ->join('mep_medida_producto', 'mep_id = cva_id_mep')
        //         ->join('tia_tipo_articulo', 'tia_id = art_id_tia')
        //         ->group_by('dor_id_art')
        // ;

        $query = "SELECT `art_codigo`, `art_nombre`, `mep_nombre`, tia_codigo, tia_nombre,
                (SELECT COUNT(dor_id_art) FROM art_articulo a WHERE a.art_id = dor_id_art) cant, 
                (
                 SELECT orc_fecha_orden
                 FROM orc_orden_compra AS orc
                 WHERE orc.orc_id = dor_id_orc
                 ORDER BY orc_id DESC
                 LIMIT 1
                 ) as ultima_fecha, SUM(dor_cantidad) as cantidad
                FROM (`orc_orden_compra`)
                JOIN `dor_detalle_orden_compra` ON `dor_id_orc` = `orc_id`
                JOIN `art_articulo` ON `art_id` = `dor_id_art`
                JOIN `cva_conversion_articulo` ON `cva_id` = `dor_id_cva`
                JOIN `mep_medida_producto` ON `mep_id` = `cva_id_mep`
                JOIN `tia_tipo_articulo` ON `tia_id` = `art_id_tia` WHERE
                ".(($where[0] != "")?"  ".$where[0]:"")."
                GROUP BY `dor_id_art`
                UNION
                SELECT `art_codigo`, `art_nombre`, `mep_nombre`, tia_codigo, tia_nombre, 
                (SELECT COUNT(dxd_id_art) FROM art_articulo a WHERE a.art_id = dxd_id_art) cant, 
                (
                 SELECT dpv_fecha_documento
                 FROM dpv_documento_proveedor AS prv
                 WHERE prv.dpv_id = dxd_id_dpv
                 ORDER BY dpv_id DESC
                 LIMIT 1
                 ) as ultima_fecha, SUM(dxd_cantidad) as cantidad
                FROM (`dpv_documento_proveedor`)
                JOIN `dxd_detalle_documento_proveedor` ON `dxd_id_dpv` = `dpv_id`
                JOIN `art_articulo` ON `art_id` = `dxd_id_art`
                JOIN `cva_conversion_articulo` ON `cva_id` = `dxd_id_cva`
                JOIN `mep_medida_producto` ON `mep_id` = `cva_id_mep`
                JOIN `tia_tipo_articulo` ON `tia_id` = `art_id_tia` WHERE
                ".(($where[1] != "")?"  ".$where[1]:"")."
                GROUP BY `dxd_id_art`

                ORDER BY `cantidad` desc
                LIMIT ".$limit."";

        return $this->db->query($query, false)->result_array();

        // if ($where != null) {
        //     $this->db->where($where);
        // }

        // if ($limit != null) {
        //     $this->db->limit($limit);
        // } else {
        //     $this->db->limit(10);
        // }

        // if ($order != 1) {
        //     $this->db->order_by('cantidad', 'asc');
        // } else {
        //     $this->db->order_by('cantidad', 'desc');
        // }

        // return $query->get()->result_array();
    }

    public function get_cotizaciones($where = null) {
        $query = $this->db->select("*, sum(dco_total) as total",false)
                ->from('coc_cotizacion_compra')
                ->join('dco_detalle_cotizacion', 'dco_id_coc = coc_id')
                ->join('prv_proveedor', 'prv_id = coc_id_prv', 'left')
                ->join('rxi_requisicion_inventario', 'rxi_id = coc_id_rxi', 'left')
                ->join('users', 'id = coc_usu_creacion', 'inner')
                ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
                ->join('orc_orden_compra', 'orc_id_rxi=rxi_id AND orc_id_coc = coc_id', 'left')
                ->join('pcl_proyecto_cliente', 'pcl_id = rxi_id_pcl', 'left')
                ->order_by('coc_fecha','DESC')
                ->group_by('coc_id')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * 
     * Descripcion:
     * Funcion que devuelve las requisiciones que no han sido amarradas a una orden de compra
     * @author: Nelson Soriano
     * @since: 13-12-2018
     * @param: none;
     * @return: arreglo con los id de aquellas requisiciones no relacionadas a una orden de compra
    **/
    public function get_requisiciones_sin_orden(){
        $query=$this->db->select('*')
                    ->from('rxi_requisicion_inventario')
                    ->where('(rxi_estado = 3 or rxi_estado = 6) ',NULL,FALSE)
                    ->order_by('rxi_id','DESC');
        return $query->get()->result_array();                       
            
    }

     /**
     * 
     * Descripcion:
     * Funcion que devuelve las ordenes que no han sido amarradas a un documento por proveedor
     * @author: Nelson Soriano
     * @since: 13-12-2018
     * @param: none;
     * @return: arreglo con los id de aquellas ordenes de compra que no esten relacionadas a un documento por proveedor
    **/

    public function get_orden_dxp(){
        $query= $this->db->select('*, IF((IFNULL((SELECT SUM(dxd_cantidad) FROM dpv_documento_proveedor INNER JOIN dxd_detalle_documento_proveedor ON dxd_id_dpv = dpv_id
            WHERE orc_id = dpv_id_orc), 0) < SUM(dor_cantidad)), 1, 0) AS valido', false)
            ->from('orc_orden_compra')
            ->join('dor_detalle_orden_compra', 'dor_id_orc = orc_id', 'inner')
            ->where('orc_estado', 3)
            ->or_where('orc_estado', 7)
            ->group_by('orc_id')
            ->order_by('orc_id','DESC')
        ;
        return $query->get()->result_array();          
    }


    /**
     * 
     * Descripcion:
     * Funcion para validar si existe una nota de abono pendiente 
     * @author: Nelson Soriano
     * @since: 14-12-2018
     * @param: id documento proveedor;
     * @return: retorna un valor verdadero / falso si existe una nota de abono pendiente
    **/
    public function validar_nota_abono_dxp($id_dpv){
        $this->db->select('dpv_monto_pendiente')
                 ->from('dpv_documento_proveedor')
                 ->where(array('dpv_estado <>' => 0 , 'dpv_pagado <>' => 1 ,'dpv_id' => $id_dpv));
        $query   = $this->db->get();
        $dpv_row = $query->row();
        if ($query->num_rows() > 0) {
           $this->db->select('sum(ntp_monto) as total')
                ->from('ntp_nota_abono_pendiente')
                ->where(array('ntp_id_dpv' => $id_dpv, 'ntp_estado <>' => 0 ));
            $nota     = $this->db->get();
            $nota_row = $nota->row();
            if ($nota->num_rows() == 0 ) {
               return true;
            }else{
                if (($nota_row->total < $dpv_row->dpv_monto_pendiente)) {
                    return true;
                }else{
                    return false;
                }
            }

        }else{
            return false;
        }
    }

    /**
     * 
     * Descripcion:
     * Funcion que devuelve los datos de un dpv y la informacion del prv
     * @author: Nelson Soriano
     * @since: 14-12-2018
     * @param: id dpv;
     * @return: devuelve una fila con la informacion de un dpv y su prv
    **/
    public function get_informacion_dpv_drp($id_dpv){
        $this->db->select('*')
                 ->from('dpv_documento_proveedor')
                 ->join('prv_proveedor','dpv_id_prv = prv_id','inner')
                 ->where(array('dpv_id' => $id_dpv));
        $row = $this->db->get()->row();
        return $row;

    }

    /**
     * 
     * Descripcion:
     * Funcion que devuelve las cotizaciones para hacer comprativos entre proveedores
     * @author: Nelson Soriano
     * @since:  8-02-2019
     * @param:  Fechas de busqueda, articulo a consulta, proveedores involucrados
     * @return: devuelve una arreglo con las cotizaciones de los proveedores
    **/

    public function get_cotizaciones_comparativo($where = null,$groupby = null) {
        $query = $this->db->select('
                IF(prv_tipo_pers = 1, CONCAT_WS( " ", prv_nombre, prv_apellido ), prv_apellido ) AS proveedor,
                dco_cantidad AS axr_cantidad,
                dco_precio_unitario AS precio,
                mep_nombre AS medida,
                art_nombre as articulo,
                art_codigo as codigo
                ',false)
                ->from('coc_cotizacion_compra')
                ->join('dco_detalle_cotizacion', 'dco_id_coc = coc_id')
                ->join('prv_proveedor', 'prv_id = coc_id_prv')
                ->join('art_articulo', 'art_id = dco_id_art')
                ->join('cva_conversion_articulo','cva_id = dco_id_cva', 'left')
                ->join('mep_medida_producto','cva_id_mep = mep_id','left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby) {
            $this->db->group_by($groupby);
        }

        return $query->get()->result_array();
    }

    public function return_cot($where = null){
        $this->db->select("
                    art_id  as id,
                    CONCAT_WS(' ',art_codigo,'-', art_nombre) as nombre
                ",FALSE)
                 ->from('coc_cotizacion_compra')
                 ->join('dco_detalle_cotizacion', 'dco_id_coc = coc_id')
                 ->join('art_articulo','art_id = dco_id_art');
        if ($where) {
            $this->db->where($where);
        }

        return $this->db->get()->result_array();
    }

    public function get_quedan($where = null) {
        $query = $this->db->select()
                ->from('dpv_documento_proveedor')
                ->join('prv_proveedor', 'prv_id = dpv_id_prv')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_cotizacion($where = null) {
        $query = $this->db->select()
                ->from('dco_detalle_cotizacion')
                ->join('coc_cotizacion_compra', 'coc_id=dco_id_coc')
                ->join('art_articulo', 'art_id = dco_id_art', 'left')
                ->join('tia_tipo_articulo', 'tia_id = art_id_tia', 'left')
                ->join('cva_conversion_articulo', 'cva_id = dco_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
                ->join('act_activo_fijo', 'act_id = dco_id_act', 'left')
                ->join('tac_tipo_activofijo', 'tac_id = act_id_tac', 'left')
                ->join('rxi_requisicion_inventario', 'rxi_id = coc_id_rxi', 'left')
                ->join('dpm_detalle_comparativo_compra', 'dpm_id_dco = dco_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_usuarios_autorizan_compra($where = null, $where_in = null) {
        $query = $this->db->select()
                ->from('sgo_seguimiento_orden')
                ->join('users', 'id = sgo_id_usu')
                ->join('emp_empleado', 'emp_id = usu_id_emp')
                ->join('psf_paso_flujo', 'psf_id = sgo_id_psf')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($where_in != null) {
            $this->db->where_in('psf_id', $where_in);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_prorrateo_docProv($where = null) {
        $query = $this->db->select("pxd_id, pxd_id_cnt, dpr_id_ptg,
                    dpr_id,
                    cnt_id,
                    pxd_id_cec,
                    IFNULL(cec1.cec_nombre,cec2.cec_nombre) cec_nombre,
                    IFNULL(cec1.cec_id,cec2.cec_id) cec_id,
                    pxd_porcentaje,
                    pxd_total,
                    CONCAT(cnt_cuenta,' - ',cnt_nombre) cnt_nombre", false)
                ->from('pxd_prorrateoxdetalle_documento')
                ->join('cnt_cuenta_contable', 'cnt_id = pxd_id_cnt', 'left')
                ->join('cec_centro_costo cec2', 'cec2.cec_id = pxd_id_cec', 'left')
                ->join('dpr_detalle_prorrateo', 'pxd_id_dpr = dpr_id', 'left')
                ->join('cec_centro_costo cec1', 'cec1.cec_id = dpr_id_cec', 'left')
                ->join('art_articulo', ' art_id = dpr_id_art', 'left');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_prorrateo_Retaceo($where = null) {
        $query = $this->db->select()
                ->from('dar_detalle_aplicacion_retaceo')
                ->join('pxd_prorrateoxdetalle_documento', 'dar_id_pxd = pxd_id', 'inner')
                ->join('dpr_detalle_prorrateo', 'pxd_id_dpr = dpr_id', 'inner')
                ->join('cec_centro_costo', ' cec_id = dpr_id_cec', 'inner')
                ->join('art_articulo', ' art_id = dpr_id_art');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_proveedor_pers($where = null) {
        $query = $this->db->select("prv_detalle_condicion as det, prv_dias_plazo, prv_id,
                                    CASE WHEN prv_tipo_pers = 1 
                                    THEN CONCAT_WS(' ',prv_codigo,' - ', prv_nombre, prv_apellido)
                                    ELSE  CONCAT_WS(' ',prv_codigo,' - ', prv_apellido) END as pro,
                                    CASE WHEN prv_tipo_pers = 1 
                                    THEN CONCAT_WS(' ',prv_nombre, prv_apellido)
                                    ELSE  prv_apellido END as nombre,
                                    prv_id_cod, ", FALSE)
                ->from('prv_proveedor')
                ->where('prv_estado', 1);

        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->order_by('prv_id', 'ASC');
        return $query->get()->result_array();
    }

    public function get_cuentas_proveedor($where = null) {
        $query = $this->db->select()
                ->from('dfp_detalle_finanza_proveedor')
                ->join('cnt_cuenta_contable', 'dfp_id_cnt = cnt_id', 'inner')
                ->join('tcn_tipo_cuenta', 'dfp_id_tcn = tcn_id', 'inner')
                ->join('cec_centro_costo', ' cec_id = dfp_id_cec', 'inner')
                ->join('tpg_tipo_pago','tpg_id = dfp_id_tpg','left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /*
     * @autho Elman Ortiz
     * @retun Si esta o no asociado en centro de costos con la categoria del producto
     **/
    public function get_cen_cos_aso_catprod($where = null){
        //print_r($where); die();
        $query = $this->db->select('*');
                $this->db->from('art_articulo');
                $this->db->join('tia_tipo_articulo','art_id_tia = tia_id');
                $this->db->join('dta_detalle_tipoarticulo','dta_id_tia = tia_id');
                $this->db->where($where);
        return $query->get()->result_array();
    }

     public function get_cheques($where=null){
        $query = $this->db->select()
                ->from('che_cheque')
                ->join('tra_transaccion', 'che_id_tra = tra_id', 'inner')
        ;

        $this->db->where('che_estado', 1);
        $this->db->where('tra_aplicar', 1);

        if($where!=null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_periodo_caja($where=null){
        $query = $this->db->select("*, (SELECT SUM(lcc.lcc_disponible) FROM lcc_liquidacion_caja_chica lcc WHERE lcc.lcc_id_cch = cch_id AND lcc.lcc_id >= lc.lcc_id) as monto", FALSE)
                ->from('lcc_liquidacion_caja_chica AS lc')
                ->join('cch_caja_chica', 'cch_id = lcc_id_cch', 'inner')
                ->join('emp_empleado', 'cch_id_emp = emp_id', 'left')
            ;

        if($where!=null){
            $this->db->where($where);
        }
        $this->db->order_by("lcc_fecha_inicio","desc");

        return $query->get()->result_array();
    }

    public function get_disponible($where=null){
        $query = $this->db->select()
                ->from('lcc_liquidacion_caja_chica AS lc')
                ->join('cch_caja_chica', 'cch_id = lcc_id_cch', 'inner')
                ->join('emp_empleado', 'cch_id_emp = emp_id', 'left')
                ->join('rcc_reintegro_caja_chica', 'rcc_id_lcc= lcc_id', 'left')
            ;

        if($where!=null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_comprobantes($where=null){
        $query = $this->db->select("* , (select count(*) from moi_movimiento_inv where moi_id_dpv = cqc_id_dpv) as moi_id")
                ->from('cqc_comprobante_liquidacion_caja')
                ->join('prv_proveedor', 'cqc_id_prv = prv_id')
                ->join('tif_tipo_factura', 'tif_id=cqc_id_tif', 'left')
                ->join('tpv_tipo_venta', 'tpv_id=cqc_id_tpv', 'left')
                //->join('moi_movimiento_inv', 'moi_id_dpv = cqc_id_dpv','left')
            ;

        if($where!=null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_impuestos_doc($where=null){
        $query = $this->db->select("dxd_id, dxd_subtotal, dxd_impuesto, dxd_retencion, 
            idd_id_imp, imp_porcentaje,
            (dxd_subtotal * (imp_porcentaje/100)) AS monto_imp,
            (dxd_cantidad * IFNULL(imp_valor,0)) AS monto_imp2,
            IF(prv_tipo_pers = 1,CONCAT(prv_nombre,' ',prv_apellido),prv_apellido) as proveedor,
            dpv_fecha_documento as fecha,dpv_numero_documento as numero,
            imp_nombre as impues
            ", FALSE)
                ->from('dxd_detalle_documento_proveedor')
                ->join('idd_impuestoxdetalle_documento', 'dxd_id = idd_id_dxd')
                ->join('imp_impuesto', 'imp_id = idd_id_imp')
                ->join('dpv_documento_proveedor', 'dpv_id = dxd_id_dpv')
                ->join('prv_proveedor','prv_id = dpv_id_prv','LEFT')
            ;

        if($where!=null){
            $this->db->where($where);
        }
        $this->db->group_by('idd_id');
        return $query->get()->result_array();
    }

    public function get_retenciones_doc($where=null){
        $doc_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $query = $this->db->select("dxd_id, dxd_subtotal, dxd_impuesto, dxd_retencion, 
            rxd_id_ret, ret_porcentaje, 
            (dxd_subtotal * (ret_porcentaje/100)) AS monto_ret,
            (dxd_cantidad * IFNULL(ret_valor,0)) AS monto_ret2,
            DATE_FORMAT(dpv_fecha_documento, '%m%Y') as periodo, dpv_numero_documento as numero,ret_nombre as ret_name,
            (SELECT tif_codigo_hacienda FROM tif_tipo_factura WHERE tif_id = dpv_id_tif) AS code_tif,
            (SELECT tif_nombre FROM tif_tipo_factura WHERE tif_id = dpv_id_tif) AS name_tif,
            IF(prv_tipo_pers = 1, CONCAT(prv_apellido, ', ', prv_nombre), prv_apellido) AS proveedor,
            (SELECT dcp_valor FROM dcp_documento_proveedor WHERE dcp_id_prv = dpv_id_prv AND dcp_id_tde = 2) AS nit_prv
            ", FALSE)
                ->from('dxd_detalle_documento_proveedor')
                ->join('rxd_retencionxdetalle_documento', 'dxd_id = rxd_id_dxd')
                ->join('ret_retencion', 'ret_id = rxd_id_ret')
                ->join('dpv_documento_proveedor', 'dpv_id = dxd_id_dpv')
                ->join('prv_proveedor', 'prv_id = dpv_id_prv', 'LEFT')
            ;

        if($where!=null){
            $this->db->where($where);
        }
        $this->db->group_by('rxd_id');
        return $query->get()->result_array();
    }

    public function get_documento($where=null){
        $query = $this->db->select("prv_id, dcp_valor")
                ->from('prv_proveedor')
                ->join('dcp_documento_proveedor', 'dcp_id_prv=prv_id')
                ->join('tde_tipo_documento', 'tde_id=dcp_id_tde')
            ;

        if($where!=null){
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

     public function get_reintegros($where=null){
        $query = $this->db->select()
                ->from('lcc_liquidacion_caja_chica')
                ->join('rcc_reintegro_caja_chica', 'rcc_id_lcc=lcc_id AND rcc_estado=1' )
                ->join('che_cheque', 'rcc_id_che=che_id', 'left' )
                ->join('nta_nota_abono', 'nta_id = rcc_id_nta', 'left' )
            ;

        if($where!=null){
            $this->db->where($where);
        }

        //$this->db->group_by('rcc_id');

        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since 25/11/2017
     * @resume Regresa el listado de proveedores
    */
    public function get_proyectos($where=null){
        $query = $this->db->select()
                ->from('pcl_proyecto_cliente')
                ->join('cli_cliente', 'cli_id = pcl_id_cli', 'inner')
                ->join('epr_estado_proyecto','epr_id = pcl_id_epr', 'inner');
            ;

        if($where!=null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 08/12/2017
     * @method Tipos de pagos asociados a todos los documentos por proveedor
    */
    public function get_tipos_pagoxdoc($where = null){
        $query = $this->db->select()
                ->from('tpg_tipo_pago')
                ->join('dpv_documento_proveedor', 'tpg_id = dpv_id_tpg')
                ->group_by('tpg_id');

        if($where!=null){
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 08/12/2017
     * @resume Se obtiene la Cuenta contable del producto (Cuando el documento por proveedor no afecta el inventario)
    */
    public function get_cnt_x_prod_x_docproveedor($where = null){
        $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('GASTO'));
        $tcn_id_costo = $tcn_id; // $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('COSTO'));
        /*$query = "
                SELECT
                    tia_id,
                    tia_nombre,
                    art_nombre,
                    (
                        SELECT
                            IF(ISNULL(cnt_id), 0, cnt_id) AS cnt_id
                        FROM
                            dta_detalle_tipoarticulo
                        JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                        WHERE
                            dta_id_tia = tia_id
                        AND dta_id_tcn = ".$tcn_id."
                        GROUP BY
                            cnt_id
                        LIMIT 1
                    ) AS cuenta_id,
                    (
                        SELECT
                            cnt_nombre
                        FROM
                            dta_detalle_tipoarticulo
                        JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id
                        WHERE
                            dta_id_tia = tia_id
                        AND dta_id_tcn = ".$tcn_id."
                        GROUP BY
                            cnt_id
                        LIMIT 1
                    ) AS cuenta_nombre,
                    SUM(dxd_subtotal) AS subtotal_prod,
                    dxd1.dxd_id AS id_detxdoc
                FROM dpv_documento_proveedor
                JOIN dxd_detalle_documento_proveedor AS dxd1 ON dpv_id = dxd_id_dpv
                JOIN art_articulo ON dxd1.dxd_id_art = art_id
                JOIN tia_tipo_articulo ON art_id_tia = tia_id
                WHERE
                dxd_id_dpv = ".$where['dpv_id'].""
        ;*/

        /*$query = "
            SELECT
                tia_id,
                tia_nombre,
                art_nombre,
                (
                    SELECT
                        IF (ISNULL(cnt_id), 0, cnt_id) AS cnt_id
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = dpr_id_cnt         
                    GROUP BY
                        cnt_id
                    LIMIT 1
                ) AS cuenta_id,
                (
                    SELECT
                        cnt_nombre
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = dpr_id_cnt     
                    GROUP BY
                        cnt_id
                    LIMIT 1
                ) AS cuenta_nombre,
                (dxd_subtotal * (dpr_porcentaje/100)) AS subtotal_prod,
                dxd1.dxd_id AS id_detxdoc,
                dpr_porcentaje
            FROM
                dpv_documento_proveedor
            JOIN dxd_detalle_documento_proveedor AS dxd1 ON dpv_id = dxd_id_dpv
            JOIN art_articulo ON dxd1.dxd_id_art = art_id
            JOIN tia_tipo_articulo ON art_id_tia = tia_id
            JOIN dpr_detalle_prorrateo ON art_id = dpr_id_art
            WHERE
                dxd_id_dpv = ".$where['dpv_id']."
        ";*/

        $query = $this->db->select("
                tia_id,
                tia_nombre,
                art_nombre,
                IFNULL((
                    SELECT
                        IF (ISNULL(cnt_id), 0, cnt_id) AS cnt_id
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = pxd_id_cnt         
                    GROUP BY
                        cnt_id
                    LIMIT 1
                ),(
                SELECT dta_id_cnt FROM dta_detalle_tipoarticulo 
                WHERE dta_id_tia = art_id_tia AND dta_id_tcn = $tcn_id_costo LIMIT 1
                )) AS cuenta_id,

                IFNULL((
                    SELECT
                        cnt_nombre
                    FROM
                        cnt_cuenta_contable
                    WHERE
                        cnt_id = pxd_id_cnt     
                    GROUP BY
                        cnt_id
                    LIMIT 1
                ), (
                 SELECT cnt_nombre FROM dta_detalle_tipoarticulo 
                 JOIN cnt_cuenta_contable on cnt_id = dta_id_cnt
                WHERE dta_id_tia = art_id_tia AND dta_id_tcn = $tcn_id_costo LIMIT 1
                ) ) AS cuenta_nombre,
                SUM(CASE WHEN pxd_porcentaje > 0 THEN  (dxd_subtotal * (pxd_porcentaje/100)) 
                ELSE dxd_subtotal END) AS subtotal_prod,
                dxd_id AS id_detxdoc,
                pxd_porcentaje", false)
                ->from('dpv_documento_proveedor')
                ->join('dxd_detalle_documento_proveedor', 'dpv_id = dxd_id_dpv','inner')
                ->join('art_articulo', 'dxd_id_art = art_id','inner')
                ->join('tia_tipo_articulo', 'art_id_tia = tia_id','inner')
                ->join('pxd_prorrateoxdetalle_documento', 'pxd_id_dxd = dxd_id','left')
                ->group_by('cuenta_id')
        ;

        if($where!=null){
            $this->db->where($where);
        }

        $resultado = $query->get()->result_array();


        return $resultado;//$this->db->query($query)->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 31/01/2018
     * @method Se obtiene la Cuenta contable del impuesto (Cuando el documento por proveedor no afecta el inventario)
    */
    public function get_cnt_x_impu_x_docproveedor($where){
        $query = "
                    SELECT
                        cxe_tipo,
                        imp_porcentaje,
                        SUM(
                            CASE WHEN imp_porcentaje > 0 THEN  (imp_porcentaje / 100 ) * dxd_subtotal 
                                ELSE imp_valor * dxd_cantidad END
                        ) AS subtotximpcuenta,
                        dxd_subtotal,
                        IF(ISNULL(cxe_id_cnt), 0, cxe_id_cnt) AS cxe_id_cnt
                    FROM
                        dxd_detalle_documento_proveedor
                    JOIN idd_impuestoxdetalle_documento ON dxd_id = idd_id_dxd
                    JOIN imp_impuesto ON idd_id_imp = imp_id
                    LEFT JOIN cxe_cuentaximpuesto ON idd_id_imp = cxe_id_imp
                    WHERE
                        dxd_id_dpv = ".$where['dpv_id']."
                    GROUP BY cxe_id_cnt"
        ;

        return $this->db->query($query)->result_array();
    }

    /**
     * @author Elman Ortiz
     * @since 31/01/2018
     * @resume Se obtiene la Cuenta contable del retencion (Cuando el documento por proveedor no afecta el inventario)
    */
    public function get_cnt_x_ret_x_docproveedor($where){
        $query = "
                    SELECT
                        ret_porcentaje,
                      ( SUM(
                            (ret_porcentaje / 100) * dxd_subtotal
                        ) / COUNT(DISTINCT dcr_id )) AS subtotxretcuenta,
                        dxd_subtotal,
                        IF(ISNULL(dcr_id_cnt), 0, dcr_id_cnt) AS dcr_id_cnt
                    FROM
                        dxd_detalle_documento_proveedor
                    JOIN rxd_retencionxdetalle_documento ON dxd_id = rxd_id_dxd
                    JOIN ret_retencion ON rxd_id_ret = ret_id
                    LEFT JOIN dcr_detalle_cuenta_retencion ON ret_id = dcr_id_ret
                    WHERE
                        dxd_id_dpv = ".$where['dpv_id']."
                    GROUP BY dcr_id_cnt"
        ;

        return $this->db->query($query)->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-01-31
     * @return Obtiene todos los estados de proyectos para un cliente
    */
    public function get_estados_proyectos($where = null) {
        $query = $this->db->distinct()
                ->select('epr_id,epr_nombre')
                ->from('pcl_proyecto_cliente')
                ->join('epr_estado_proyecto', 'pcl_id_epr = epr_id')
                ->join('cli_cliente', 'pcl_id_cli = cli_id');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-02-01
     * @return Obtiene todos los componentes
    */
    public function get_orden_compra_proyecto($where = null){
        /*SELECT
            orc_numero,
            orc_fecha_orden,
            CONCAT_WS(
                ' - ',
                cli_codigo,
                cli_nombre
            ) cliente,
            CONCAT_WS(
                ' - ',
                pcl_codigo,
                pcl_nombre
            ) proyecto,
            epr_nombre,
            prv_nombre,
            SUM(orc_subtotal) subtotal,
            SUM(orc_descuento) descuento,
            SUM(orc_impuesto) impuesto,
            (SUM(orc_subtotal) + SUM(orc_impuesto) - SUM(orc_descuento)) total
        FROM
            orc_orden_compra
        INNER JOIN pcl_proyecto_cliente ON pcl_id = orc_id_pcl
        INNER JOIN cli_cliente ON cli_id = pcl_id_cli
        LEFT JOIN prv_proveedor ON prv_id = orc_id_prv
        INNER JOIN epr_estado_proyecto ON epr_id = pcl_id_epr
        GROUP BY
            pcl_id,
            prv_id*/
        $query = $this->db->select("
                orc_numero,
                orc_fecha_orden,
                CONCAT_WS(
                    ' - ',
                    cli_codigo,
                    cli_nombre
                ) cliente,
                CONCAT_WS(
                    ' - ',
                    pcl_codigo,
                    pcl_nombre
                ) proyecto,
                epr_nombre,
                prv_nombre,
                SUM(orc_subtotal) subtotal,
                SUM(orc_descuento) descuento,
                SUM(orc_impuesto) impuesto,
                (SUM(orc_subtotal) + SUM(orc_impuesto) - SUM(orc_descuento)) total", false)
            ->from('orc_orden_compra')
            ->join('pcl_proyecto_cliente','pcl_id = orc_id_pcl','inner')
            ->join('cli_cliente','cli_id = pcl_id_cli','inner')
            ->join('prv_proveedor','prv_id = orc_id_prv','left')
            ->join('epr_estado_proyecto','epr_id = pcl_id_epr','inner')
            ->group_by('pcl_id, prv_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-02-01
     * @return Obtiene todos los componentes
    */
    public function get_orden_compra_proyecto_detallado($where = null){
        /*
            SELECT
                orc_numero,
                art_codigo,
                art_nombre,
                if(prv_tipo_pers = 1, CONCAT_WS(' ',prv_nombre,prv_apellido), prv_apellido) proveedor,
                SUM(dor_cantidad) cantidad,
                SUM(dor_precio_unitario) precio,
                SUM(dor_subtotal) subtotal,
                SUM(dor_descuento) descuento,
                SUM(dor_impuesto) impuesto,
                SUM(dor_total) total
            FROM
                dor_detalle_orden_compra
            INNER JOIN orc_orden_compra ON orc_id = dor_id_orc
            INNER JOIN pcl_proyecto_cliente ON pcl_id = orc_id_pcl
            INNER JOIN art_articulo ON art_id = dor_id_art
            LEFT JOIN prv_proveedor ON prv_id = orc_id_prv
            INNER JOIN epr_estado_proyecto ON epr_id = pcl_id_epr
            GROUP BY
                art_id,
                orc_id

        */
        $query = $this->db->select("
            orc_numero,
            art_codigo,
            art_nombre,
            IF (
                prv_tipo_pers = 1,
                CONCAT_WS(
                    ' ',
                    prv_nombre,
                    prv_apellido
                ),
                prv_apellido
            ) proveedor,
            SUM(dor_cantidad) cantidad,
            SUM(dor_precio_unitario) precio,
            SUM(dor_subtotal) subtotal,
            SUM(dor_descuento) descuento,
            SUM(dor_impuesto) impuesto,
            SUM(dor_total) total", false)
        ->from('dor_detalle_orden_compra')
        ->join('orc_orden_compra','orc_id = dor_id_orc','inner')
        ->join('pcl_proyecto_cliente','pcl_id = orc_id_pcl','inner')
        ->join('art_articulo','art_id = dor_id_art','inner')
        ->join('prv_proveedor','prv_id = orc_id_prv','left')
        ->join('epr_estado_proyecto','epr_id = pcl_id_epr','inner')
        ->group_by('art_id, orc_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Habby Lovo
     * @since  2018-02-07
     * @return Obtiene todos los componentes
    */
    public function get_documento_proyecto($where = null){
        /*
            SELECT
                CASE dpv_tipo
                WHEN 1 THEN
                    "Producto"
                WHEN 2 THEN
                    "servicio"
                WHEN 3 THEN
                    "activo fijo"
                WHEN 4 THEN
                    "Productos y Servicios"
                END AS tipo,
                dpv_numero_documento,
                dpv_fecha_documento,
                orc_numero,

            IF (
                cli_personeria = 1,
                CONCAT(
                    cli_codigo,
                    ' - ',
                    cli_nombre,
                    ' ',
                    cli_apellido
                ),
                CONCAT(
                    cli_codigo,
                    ' - ',
                    cli_apellido
                )
            ) cliente,
             CONCAT_WS(
                ' - ',
                pcl_codigo,
                pcl_nombre
            ) proyecto,
             epr_nombre,
            prv_nombre,
            SUM(dpv_subtotal) subtotal,
            SUM(dpv_descuento) descuento,
            SUM(dpv_impuesto) impuesto,
            SUM(dpv_total) total
            FROM
                dpv_documento_proveedor
            INNER JOIN pcl_proyecto_cliente ON pcl_id = dpv_id_pcl
            INNER JOIN cli_cliente ON cli_id = pcl_id_cli
            INNER JOIN epr_estado_proyecto ON epr_id = pcl_id_epr
            LEFT JOIN orc_orden_compra ON orc_id = dpv_id_orc
            LEFT JOIN `prv_proveedor` ON prv_id = orc_id_prv
            GROUP BY
                dpv_id,
                prv_id
        */
        $query = $this->db->select("
            tif_nombre tipo,
                dpv_numero_documento,
                dpv_fecha_documento,
                orc_numero,

            IF (
                cli_personeria = 1,
                CONCAT(
                    cli_codigo,
                    ' - ',
                    cli_nombre,
                    ' ',
                    cli_apellido
                ),
                CONCAT(
                    cli_codigo,
                    ' - ',
                    cli_apellido
                )
            ) cliente,
             CONCAT_WS(
                ' - ',
                pcl_codigo,
                pcl_nombre
            ) proyecto,
             epr_nombre,
            prv_nombre,
            SUM(dpv_subtotal) subtotal,
            SUM(dpv_descuento) descuento,
            SUM(dpv_impuesto) impuesto,
            SUM(dpv_total) total", false)
        ->from('dpv_documento_proveedor')
        ->join('tif_tipo_factura','tif_id = dpv_id_tif','inner')
        ->join('pcl_proyecto_cliente','pcl_id = dpv_id_pcl','inner')
        ->join('cli_cliente','cli_id = pcl_id_cli','inner')
        ->join('epr_estado_proyecto','epr_id = pcl_id_epr','inner')
        ->join('orc_orden_compra','orc_id = dpv_id_orc','left')
        ->join('prv_proveedor','prv_id = orc_id_prv','left')
        ->group_by('dpv_id, prv_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_documento_proyecto_detalle($where = null){
        /*
            SELECT
                dpv_numero_documento,
                art_codigo,
                art_nombre,

            IF (
                prv_tipo_pers = 1,
                CONCAT_WS(
                    ' ',
                    prv_nombre,
                    prv_apellido
                ),
                prv_apellido
            ) proveedor,
             dxd_cantidad,
             SUM(dxd_precio_unitario) precio,
             SUM(dxd_subtotal) subtotal,
             SUM((dxd_cantidad*dxd_precio_unitario)*(dxd_descuento/100)) descuento,
             SUM(dxd_impuesto) impuesto,
             SUM(dxd_total) total
            FROM
                dxd_detalle_documento_proveedor
            INNER JOIN dpv_documento_proveedor ON dpv_id = dxd_id_dpv
            INNER JOIN art_articulo ON art_id = dxd_id_art
            INNER JOIN pcl_proyecto_cliente ON pcl_id = dpv_id_pcl
            LEFT JOIN orc_orden_compra ON orc_id = dpv_id_orc
            LEFT JOIN `prv_proveedor` ON prv_id = orc_id_prv
            GROUP BY
                dpv_id,
                art_id
        */
        $query = $this->db->select("
            dpv_numero_documento,
            art_codigo,
            pcl_nombre,
            pcl_id,
            art_nombre,
            CONCAT_WS(' ',cli_nombre,cli_apellido) cliente,

            IF (
                prv_tipo_pers = 1,
                CONCAT_WS(
                    ' ',
                    prv_nombre,
                    prv_apellido
                ),
                prv_apellido
            ) proveedor,
            SUM(dxd_cantidad) cantidad,
            SUM(dxd_precio_unitario) precio,
            SUM(dxd_subtotal) subtotal,
            SUM((dxd_cantidad*dxd_precio_unitario)*(dxd_descuento/100)) descuento,
            SUM(dxd_impuesto) impuesto,
            SUM(dxd_total) total", false)
        ->from('dxd_detalle_documento_proveedor')
        ->join('dpv_documento_proveedor','dpv_id = dxd_id_dpv','inner')
        ->join('art_articulo','art_id = dxd_id_art','inner')
        ->join('pcl_proyecto_cliente','pcl_id = dpv_id_pcl','left')
        ->join('orc_orden_compra','orc_id = dpv_id_orc','left')
        ->join('prv_proveedor','prv_id = orc_id_prv','left')
        ->join('cli_cliente','cli_id = pcl_id_cli','inner')
        ->group_by('dpv_id, art_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_estado_proyecto_cliente($where = null) {
        $query = $this->db->distinct()
                ->select('epr_id,epr_nombre')
                ->from('pcl_proyecto_cliente')
                ->join('epr_estado_proyecto', 'pcl_id_epr = epr_id');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_prorrateo($where = null, $sub_where = ''){
        $id_cnt_defe =$this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $query = $this->db->distinct()
                ->select('*,(SELECT CONCAT_WS(",",cnt_id,cnt_nombre)
                        FROM dta_detalle_tipoarticulo
                        JOIN cnt_cuenta_contable ON cnt_id = dta_id_cnt
                        '.$sub_where.'
                        limit 1) AS cuenta_contable',false)
                ->from('dpr_detalle_prorrateo')
                ->join('cec_centro_costo','cec_id = dpr_id_cec');
        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
        //print_r($this->db->last_query()); die();
    }

    function get_productos_like($where = null, $like = null) {

        //$query = $this->db->select("*,sum(sar_cant_actual) as saldo")
        $query = $this->db->select("*")
                ->from('art_articulo')
                ->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep')
                ->join('cdp_codigo_producto', 'cdp_id_art = art_id AND cdp_estado = 1', 'left')
                //->join('sar_saldo_articulo', 'sar_id_art=art_id ', 'left')
                
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($like != null) {
            $this->db->where($like);
        }
        $this->db->group_by('art_id');
        $this->db->limit('500');
        return $query->get()->result_array();
    }

    function get_precios_compras($where = null, $groupby = null, $orderby = null) {
        $query = $this->db->select("
                    art_codigo,
                    art_nombre,
                    IF (
                        prv_tipo_pers = 1,
                        CONCAT(prv_nombre, ' ', prv_apellido),
                        prv_apellido
                    ) AS proveedor_2,
                    GROUP_CONCAT(DISTINCT IF( prv_tipo_pers = 1, CONCAT( prv_nombre, ' ', prv_apellido ), prv_apellido )) AS proveedor,
                    dxd_precio_unitario,
                    dee_precio,
                    bod_nombre,
                    mma_maximo,
                    mma_minimo,
                    mep_nombre,
                    MIN(dee_precio) AS precio_minino, 
                    MAX(dee_precio) AS precio_maximo
                ", false)
                ->from('moi_movimiento_inv')
                ->join('dee_detalle_mov', 'moi_id = dee_id_moi', 'left')
                ->join('tip_tipo_proceso', 'tip_id = moi_id_tip', 'left')
                ->join('prv_proveedor', 'moi_id_prv = prv_id', 'left')
                ->join('art_articulo', 'dee_id_art = art_id ', 'left')
                ->join('dpv_documento_proveedor', 'dpv_id = moi_id_dpv', 'left')
                ->join('dxd_detalle_documento_proveedor', 'dpv_id = dxd_id_dpv and dxd_id_art = art_id', 'left')
                ->join('bod_bodega', 'bod_id = moi_id_bod ', 'left')
                ->join('mma_mimino_maximoxarticulo', 'mma_id_art = art_id and mma_id_bod = bod_id', 'left')
                ->join('cva_conversion_articulo','cva_id_art = art_id','inner')
                ->join('mep_medida_producto','mep_id = cva_id_mep','inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($orderby != null) {
            $this->db->order_by($orderby);
        }
        $this->db->group_by('art_id');
        return $query->get()->result_array();
    }
// Rafael Cuchilla
// 02/08/2018

    public function get_precio_ultima_entrada($where=null){
        $query = $this->db->select("moi_id, moi_id_tip, sar_precio,dee_id_cva, cva_conversion,
        IF(prv_tipo_pers=2,prv_nombre,CONCAT_WS(' ',prv_nombre,prv_apellido)) as proveedor,
(SELECT x.cva_conversion from cva_conversion_articulo x WHERE x.cva_id_art = sar_id_art and x.cva_defecto =1 ) as defecto", FALSE)
             ->from('moi_movimiento_inv ')
             ->join('dee_detalle_mov', 'dee_id_moi = moi_id')
             ->join('sar_saldo_articulo','sar_id = dee_id_sar')
             ->join('tip_tipo_proceso','tip_id = moi_id_tip')
             ->join('prv_proveedor','prv_id = moi_id_prv')
             ->join('cva_conversion_articulo', 'cva_id = dee_id_cva')
             ->limit(1)
             ->order_by('moi_id', 'DESC')
            ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->row_array();
    }

// Rafael A. Cuchilla
    public function get_datos_liquidacion_caja_chica($where=null){
        $query = "SELECT 
                    x.fecha,x.nombre,
                    x.tif_nombre,
                    x.cqc_numero_documento,
                    x.cqc_concepto,
                    x.cqc_monto,
                    x.cqc_retencion,
                    GROUP_CONCAT(IFNULL(x.impuesto,'Sin Impuestos')) AS impuesto,
                    GROUP_CONCAT(IFNULL(x.monto_imp,0)) AS monto_imp
                FROM(
                    SELECT date(cqc_fecha_documento) AS fecha, IF(prv_tipo_pers=1,
                        CONCAT_WS(' ',prv_nombre,prv_apellido),prv_nombre) AS nombre,
                        tif_nombre, cqc_numero_documento, cqc_concepto,(cqc_monto * cqc_cantidad) as cqc_monto,
                        imp_nombre AS impuesto, cqc_retencion,
                        SUM(IFNULL(ilc_monto_impuesto,0)) AS monto_imp,
                        cch_id, cqc_id
                    FROM
                        cch_caja_chica 
                    JOIN lcc_liquidacion_caja_chica ON lcc_id_cch = cch_id
                    JOIN cqc_comprobante_liquidacion_caja on cqc_id_lcc = lcc_id
                    JOIN prv_proveedor on prv_id = cqc_id_prv
                    JOIN tif_tipo_factura on tif_id = cqc_id_tif
                    LEFT JOIN ilc_impuesto_liquidacion_comprobante on ilc_id_cqc = cqc_id
                    LEFT JOIN imp_impuesto on imp_id = ilc_id_imp
                    WHERE cch_id =".$where['cch_id']." 
                        /*#AND DATE(cqc_fecha_documento) BETWEEN '".$where['fecha_ini']."' AND '".$where['fecha_fin']."'*/
                        AND cqc_id_lcc in (".$where['ids_lcc'].")
                        AND cqc_estado > 0
                    GROUP BY cqc_id,ilc_id_imp) x
                    GROUP BY x.cqc_id
                    ORDER BY x.fecha ASC";

        return $this->db->query($query)->result_array();
    }

    public function get_compras_sugeridas($where = null)
    {
      $query = $this->db->select("art_nombre,SUM(sar_cant_actual) as cantidad,
				prv_tipo_pers,prv_nombre,prv_apellido,
				mma_maximo,mma_minimo,suc_nombre,bod_nombre,
				art_id, bod_id, suc_id, mma_id", FALSE)
           ->from('moi_movimiento_inv ')
           ->join('dee_detalle_mov', 'dee_id_moi = moi_id')
           ->join('sar_saldo_articulo','sar_id = dee_id_sar')
           ->join('tip_tipo_proceso','tip_id = moi_id_tip and tip_entrada = 1')
           ->join('prv_proveedor','prv_id = moi_id_prv','left')
           ->join('art_articulo', 'art_id = sar_id_art')
           ->join('bod_bodega', 'bod_id = sar_id_bod','left')
           ->join('suc_sucursal', 'suc_id = bod_id_suc','left')
           ->join('mma_mimino_maximoxarticulo','mma_id_bod = bod_id and mma_id_art = art_id')

           ->order_by('moi_id', 'DESC')
          ;

      if ($where != null) {
          $this->db->where($where);
      }
      $this->db->group_by('art_id, bod_id, suc_id');
      return $query->get()->result_array();
    }

    /**
     * @author Elman Ortiz
     * @method Retorna los datos para el concepto de la partida
     * @property array $where 'Array de filtros a usar'
     */
    public function get_datos_doc_prove($where = null) {
        $select = "*";
        $query = $this->db->select($select, FALSE)
                ->from('prv_proveedor')
                ->join('dpv_documento_proveedor', 'prv_id = dpv_id_prv')
        ;

        if ($where != null) {
            $this->db->where($where);
        }        

        return $query->get()->result_array();
    }   

    public function get_ultimo_ingreso_caja_chica($where=null)
    {
            $this->db->select()
                ->from('rcc_reintegro_caja_chica')
                ->join('lcc_liquidacion_caja_chica', 'lcc_id = rcc_id_lcc')
                ->order_by('lcc_id')
                ->limit(1)
        ;

        if ($where) {
            $this->db->where($where);
        }        

        return $this->db->get()->row_array();
    }

    /**
     * @author René Castaneda
     * @since 08/12/2018
     * @return Retorna registros en array asociativo
     * @param array $where para la query
     */
    public function informe_compras_proveedores($where = null) {
        $tipo_documento_dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
        $tipo_documento_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $tipo_documento_nrc = $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NRC_PROVEEDOR');
        $impuesto_iva = ($this->gsatelite->get_parametro('SYS_ID_IVA_CREDITO') > 0)? $this->gsatelite->get_parametro('SYS_ID_IVA_CREDITO'):1;
        $select = "*,
        DATE(dpv_fecha_documento) fecha_compra,
        DATE_FORMAT(dpv_fecha_documento,'%Y%m%d') fecha_compra_prn,
        ( 
            SELECT CONCAT_WS(':#',tde_nombre, dcp_valor,tde_codigo_hacienda) FROM dcp_documento_proveedor
            JOIN tde_tipo_documento on tde_id = dcp_id_tde 
            WHERE dcp_id_prv = dpv_id_prv AND (dcp_id_tde = $tipo_documento_nit  OR dcp_id_tde = $tipo_documento_nrc)
            LIMIT 1
        ) documento,
        ( 
            SELECT CONCAT_WS(':#', tde_nombre, dcp_valor,tde_codigo_hacienda) FROM dcp_documento_proveedor
            JOIN tde_tipo_documento on tde_id = dcp_id_tde 
            WHERE dcp_id_prv = dpv_id_prv AND (dcp_id_tde = $tipo_documento_nit  OR dcp_id_tde = $tipo_documento_nrc OR dcp_id_tde = $tipo_documento_dui)
            LIMIT 1
        ) documento_icv,
        ( 
            SELECT CONCAT_WS(':#', tde_nombre, dcp_valor,tde_codigo_hacienda) FROM dcp_documento_proveedor
            JOIN tde_tipo_documento on tde_id = dcp_id_tde 
            WHERE dcp_id_prv = dpv_id_prv AND (dcp_id_tde = $tipo_documento_nit  OR dcp_id_tde = $tipo_documento_dui)
            LIMIT 1
        ) documento_iva,
        ( 
            SELECT CONCAT_WS(':#', tde_nombre, dcp_valor,tde_codigo_hacienda) FROM dcp_documento_proveedor
            JOIN tde_tipo_documento on tde_id = dcp_id_tde 
            WHERE dcp_id_prv = dpv_id_prv
            LIMIT 1
        ) documento_extranjero,
        , IFNULL(ROUND(SUM((
        SELECT SUM(idd_monto) from idd_impuestoxdetalle_documento
        JOIN dxd_detalle_documento_proveedor on dxd_id = idd_id_dxd
        WHERE dxd_id_dpv = dpv_id AND idd_id_imp = $impuesto_iva

        )),2),0) monto_iva
        , ROUND(SUM((
        SELECT SUM(idd_monto) from idd_impuestoxdetalle_documento
        JOIN dxd_detalle_documento_proveedor on dxd_id = idd_id_dxd
        WHERE dxd_id_dpv = dpv_id AND idd_id_imp != $impuesto_iva
        )),2) otros_impuestos,
        ROUND(SUM(ROUND(dpv_total,4)),2) total_proveedor,
        ROUND(SUM(ROUND(dpv_subtotal,4)),2) subtotal_proveedor,
        DATE_FORMAT(dpv_fecha_documento,'%Y%m') mes_anio,
        DATE_FORMAT(dpv_fecha_documento,'%m') mes,
        DATE_FORMAT(dpv_fecha_documento,'%Y') anio
        ";

        $query = $this->db->select($select, false)
                ->from('dpv_documento_proveedor')
                ->join('prv_proveedor', 'prv_id=dpv_id_prv')
                ->join('tif_tipo_factura', 'tif_id=dpv_id_tif')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('dpv_id');
       // $this->db->group_by("dpv_id_prv, MONTH(dpv_fecha_documento), YEAR(dpv_fecha_documento)",false);        
        $datos_query = $query->get()->result_array();
        return $datos_query;
    }  

    /**
     * @author René Castaneda
     * @since 10/01/2019
     * @return Retorna las fecha inicio y fin
     * @param array $where para la query
     */
    public function get_inicio_fin_cortes($where=null)
     {
          $query = $this->db->select("DATE(MIN(lcc_fecha_inicio)) fecha_inicio, DATE(MAX(lcc_fecha_fin)) fecha_fin", false)
                  ->from('lcc_liquidacion_caja_chica')
          ;

          if ($where != null) {
              $this->db->where($where);
          }       
          $datos_query = $query->get()->row_array();
          return $datos_query;
     }

     /**
      * @author Elman Ortiz
      * @method Retorna los los cheques por caja
      * @property array $where 'Array de filtros a usar'
      */
     public function get_cheques_por_caja_chica($where = null, $having = null) {        
        $where_in = explode(',', $where['ids_lcc']);
        $select = "            
            (
                SELECT che_id
                FROM che_cheque
                WHERE che_id = rcc_id_che
            ) AS che_id,
            lcc_id,
            (
                SELECT che_numero
                FROM che_cheque
                WHERE che_id = rcc_id_che
            ) AS che_numero,
            (
                SELECT che_concepto
                FROM che_cheque
                WHERE che_id = rcc_id_che
            ) AS che_concepto,
            (
                SELECT che_monto
                FROM che_cheque
                WHERE che_id = rcc_id_che
            ) AS che_monto,
            (
                SELECT che_fecha
                FROM che_cheque
                WHERE che_id = rcc_id_che
            ) AS che_fecha
        ";
        $query = $this->db->select($select, FALSE)
                 ->from('lcc_liquidacion_caja_chica')
                 ->join('rcc_reintegro_caja_chica', 'lcc_id = rcc_id_lcc')
        ;
        if($where != null) {            
            $this->db->where('lcc_id_cch', $where['cch_id']);
            $this->db->where_in('lcc_id', $where_in);
        }
        if($having != null) {                        
            $this->db->having($having);
        }

        return $query->get()->result_array();
    }

     /**
      * @author Elman Ortiz
      * @method Retorna los los cheques por caja
      * @property array $where 'Array de filtros a usar'
      */
     public function get_doc_proveedor_sin_salida($where = null) {        
        
        $select = "*,SUM(IFNULL(tip_entrada,0)) entrada, SUM(IFNULL(tip_salida,0)) salida, 
                    IF(prv_tipo_pers = 1, CONCAT(prv_nombre,' ',prv_apellido), prv_apellido) AS nombre_proveedor,
                    tif_nombre AS tipo_documento        
            ";
        $query = $this->db->select($select, FALSE)
                ->from('dpv_documento_proveedor')
                ->join('prv_proveedor', 'prv_id = dpv_id_prv')
                ->join('tif_tipo_factura', 'tif_id = dpv_id_tif')
                ->join('moi_movimiento_inv', 'dpv_id = moi_id_dpv', 'left')
                ->join('tip_tipo_proceso', 'tip_id = moi_id_tip', 'left')
                ->group_by('dpv_id')
        ;

        if($where != null) {            
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    function get_actividades_x_presupusto($select= "*", $where = null, $group_by = null){
        $query = $this->db->select($select, false)
                ->from("dps_detalle_presupuesto")
                ->join("acg_actividad_general"," acg_id = dps_id_acg")
                ->join("ace_actividad_especifica"," ace_id = dps_id_ace")
        ;

        if($where != null) {            
            $this->db->where($where);
        }

        if($group_by != null) {            
            $this->db->group_by($group_by);
        }

        return $query->get()->result_array();
    }


    /**
      * @author Raul Escalante
      * @method Retorna las cotizaciones asociadas a una requision
      * @param  Array $where: Array de filtros a usar
      */
    public function get_cotizaciones_req($where = null)
    {
        $select = "
                *,
                ( SELECT mep_nombre FROM mep_medida_producto WHERE cva_id_mep = mep_id ) AS mep_nombre,
                ( SELECT
                    IF ( ( prv_tipo_pers = 2 ), prv_apellido, CONCAT( prv_nombre, ' ', prv_apellido ) ) 
                    FROM prv_proveedor WHERE prv_id = coc_id_prv 
                ) AS prv_nombre,
                ( SELECT art_nombre FROM art_articulo WHERE art_id = dco_id_art ) AS art_nombre,
                ( SELECT count( DISTINCT coc_id ) FROM coc_cotizacion_compra WHERE coc_id_rxi = rxi_id ) AS cantidad,
                count( dco_id_art ) AS cant_prod";
        $query = $this->db->select($select, false)
                          ->from("rxi_requisicion_inventario")
                          ->join("coc_cotizacion_compra","coc_id_rxi = rxi_id")
                          ->join("dco_detalle_cotizacion","dco_id_coc = coc_id")
                          ->join("dri_detalle_requisicion_inventario","dri_id_rxi = rxi_id")
                          ->join("cva_conversion_articulo","dco_id_cva = cva_id","left");
        if(!is_null($where)) {            
            $this->db->where($where);
        }
        $this->db->group_by(array("coc_id", "dco_id")); 
        return $query->get()->result_array();
    }

    public function get_detalle_cotizaciones($where = null, $groupby = null, $order_by = null) {
        $query = $this->db->select('*, CONCAT(art_id, "-" ,prv_id) AS clave',false)
                ->from('coc_cotizacion_compra')
                ->join('dco_detalle_cotizacion', 'dco_id_coc = coc_id')
                ->join('art_articulo','art_id = dco_id_art')
                ->join('prv_proveedor', 'prv_id = coc_id_prv','left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }

    public function get_detalle_cotizaciones_comparativo($where = null, $groupby = null, $order_by = null) {
        $query = $this->db->select('*, CONCAT(art_id, "-" ,prv_id) AS clave,
                (select username from users where ccc_id_usu_autoriza = id) as autoriza,
                (select username from users where ccc_id_usu_crea = id) as elaboro'        
                ,false)
                ->from('coc_cotizacion_compra')
                ->join('dco_detalle_cotizacion', 'dco_id_coc = coc_id')
                ->join('art_articulo','art_id = dco_id_art')
                ->join('prv_proveedor', 'prv_id = coc_id_prv','left')
                ->join('ccc_comparativo_cotizacion_compra', 'ccc_id_rxi = coc_id_rxi','left')
                ->join('dpm_detalle_comparativo_compra', 'dpm_id_dco = dco_id AND dpm_id_ccc = ccc_id','left')
        ;    

        if ($where != null) {
            $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }

        if ($order_by != null) {
            $this->db->order_by($order_by);
        }

        return $query->get()->result_array();
    }
    
    /**
    * @author Francsico Orozco 
    * @method regresa las cotizaciones que han sido aprobadas por el comparativo
    * @property array $where 'Array de filtros a usar'
    */
    public function get_cotizaciones_aprobadas($where = null) {
        $query = $this->db->select('
                    *, (
                        SELECT
                            count(dpm_id)
                        FROM
                            dco_detalle_cotizacion
                        INNER JOIN dpm_detalle_comparativo_compra ON dpm_id_dco = dco_id
                        WHERE
                            dco_id_coc = coc_id
                    ) aprobadas',false)
                ->from('coc_cotizacion_compra')
                ->join('rxi_requisicion_inventario', 'rxi_id = coc_id_rxi')
        ;    

        if ($where != null) {
            $this->db->where($where);
        }      
      
        return $query->get()->result_array();
    }

    /**
    * @author Francsico Orozco 
    * @method regresa los comparativos de cotizaciones 
    * @property array $where 'Array de filtros a usar'
    */
    public function get_comparativos_cotizaciones($where = null, $group_by = null){
        $query = $this->db->select()
            ->from('ccc_comparativo_cotizacion_compra')
            ->join('dpm_detalle_comparativo_compra', 'dpm_id_ccc = ccc_id')
            ->join('rxi_requisicion_inventario', 'rxi_id = ccc_id_rxi')
            ->join('users', 'id = rxi_usu_creacion', 'inner')
            ->join('emp_empleado', 'emp_id = usu_id_emp', 'left')
            ->join('ace_actividad_especifica', 'ace_id = rxi_id_ace','left')
        ;    

        if ($where != null) {
            $this->db->where($where);
        }   

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }   

        return $query->get()->result_array();
    }

    /**
        * @author Francsico Orozco 
        * @method regresa las comparativos de cotizaciones 
        * @property array $where 'Array de filtros a usar'
    */
    public function get_disponibilidad_mensual($date = null, $where = null, $group_by = null){
        if ($date == null) {
            $periodo    = date('Ym');
            $fecha      = date('Y-m-d');
        } else {
            $periodo    = date('Ym', strtotime( $date ) );
            $fecha      = date('Y-m-d', strtotime( $date ) );
        }

        $query = $this->db->select('
                (
                    SELECT
                        pcp_monto
                    FROM
                        pcp_plan_compra_presupuesto
                    WHERE
                        pcp_estado = 1
                    AND pcp_id_dps = dps_id
                    AND "'.$periodo.'" = pcp_periodo
                ) AS permitido,
                (
                    SELECT
                        IFNULL(sum(orc_total), 0)
                    FROM
                        orc_orden_compra
                    WHERE
                        orc_id_psp = dps_id_psp
                    AND orc_id_ace = dps_id_ace
                    AND orc_fecha_orden >= DATE_FORMAT("'.$fecha.'", "%Y-%m-01")
                    AND orc_fecha_orden <= LAST_DAY("'.$fecha.'")
                ) AS monto_comprometido_mensual,
                (
                    SELECT
                        IFNULL(sum(dpv_total), 0)
                    FROM
                        dpv_documento_proveedor
                    WHERE
                        dpv_id_psp = dps_id_psp
                    AND dpv_id_ace = dpv_id_ace
                    AND ISNULL(dpv_id_orc)
                    AND dpv_fecha_documento >= DATE_FORMAT("'.$fecha.'", "%Y-%m-01")
                    AND dpv_fecha_documento <= LAST_DAY("'.$fecha.'")
                ) AS monto_pagado_mensual',false)
            ->from("dps_detalle_presupuesto")
            ->join("acg_actividad_general"," acg_id = dps_id_acg")
            ->join("ace_actividad_especifica"," ace_id = dps_id_ace")
        ;    

        if ($where != null) {
            $this->db->where($where);
        }   

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }   

        return $query->get()->result_array();
    }

    /**
        * @author Francsico Orozco 
        * @method regresa las comparativos de cotizaciones 
        * @property array $where 'Array de filtros a usar'
    */
    public function get_actividades_especificas_x_actividad_general( $fecha = null, $periodo = null, $where = null, $group_by = null){
        
        if ($fecha == null) {
            $fecha      = date('Y-m-d');
        } 
        if ($periodo == null) {
            $periodo    = date('Ym', strtotime( $fecha ) );
        }

        $query = $this->db->select('*,
                (
                    IFNULL(
                        (
                            SELECT
                                SUM(dgp_monto)
                            FROM
                                dgp_detalle_gasto_prespuesto
                            INNER JOIN dpv_documento_proveedor ON dpv_id = dgp_id_dpv
                            LEFT JOIN orc_orden_compra ON orc_id = dpv_id_orc
                            LEFT JOIN rxi_requisicion_inventario ON rxi_id = orc_id_rxi
                            WHERE
                                dgp_id_dps = dps_id
                            AND dgp_estado = 1
                        ),
                        0
                    )
                ) AS utilizado,
                (
                    sum(dps_presupuesto_actividad) - IFNULL(
                        (
                            SELECT
                                SUM(dgp_monto)
                            FROM
                                dgp_detalle_gasto_prespuesto
                            WHERE
                                dgp_id_dps = dps_id
                            AND dgp_estado = 1
                        ),
                        0
                    )
                ) AS total,
                (
                    SELECT
                        IFNULL(
                            (
                                sum(orc_total) - IFNULL(sum(dpv_total), 0)
                            ) + IFNULL(sum(dpv_monto_pendiente), 0),
                            0
                        )
                    FROM
                        orc_orden_compra
                    LEFT JOIN dpv_documento_proveedor ON dpv_id_orc = orc_id
                    WHERE
                        orc_id_psp = dps_id_psp
                    AND orc_id_ace = dps_id_ace
                ) AS monto_comprometido,
                (
                    SELECT
                        pcp_monto
                    FROM
                        pcp_plan_compra_presupuesto
                    WHERE
                        pcp_estado = 1
                    AND pcp_id_dps = dps_id
                    AND "'.$periodo.'" = pcp_periodo
                ) AS permitido,
                (
                    SELECT
                        IFNULL(sum(orc_total), 0)
                    FROM
                        orc_orden_compra
                    WHERE
                        orc_id_psp = dps_id_psp
                    AND orc_id_ace = dps_id_ace
                    AND orc_fecha_orden >= DATE_FORMAT("'.$fecha.'", "%Y-%m-01")
                    AND orc_fecha_orden <= LAST_DAY("'.$fecha.'")
                ) AS monto_comprometido_mensual,
                (
                    SELECT
                        IFNULL(sum(dpv_total), 0)
                    FROM
                        dpv_documento_proveedor
                    WHERE
                        dpv_id_psp = dps_id_psp
                    AND dpv_id_ace = dpv_id_ace
                    AND ISNULL(dpv_id_orc)
                    AND dpv_fecha_documento >= DATE_FORMAT("'.$fecha.'", "%Y-%m-01")
                    AND dpv_fecha_documento <= LAST_DAY("'.$fecha.'")
                ) AS monto_pagado_mensual,
                (
                    SELECT
                        GROUP_CONCAT( udp_id_usu )
                    FROM
                        udp_usuarioxdetalle_presupuesto
                    WHERE
                        udp_id_dps = dps_id
                ) usuarios_permitidos
                /*,(
                    SELECT
                        COUNT(pcp_id)
                    FROM
                        pcp_plan_compra_presupuesto
                    WHERE
                        pcp_estado = 1
                    AND pcp_id_dps = dps_id
                ) AS planes*/',false)
            ->from("dps_detalle_presupuesto")
            ->join("acg_actividad_general"," acg_id = dps_id_acg")
            ->join("ace_actividad_especifica"," ace_id = dps_id_ace")
        ;

        if ($where != null) {
            $this->db->where($where);
        }   

        if ($group_by != null) {
            $this->db->group_by($group_by);
        }   

        return $query->get()->result_array();
    }

    /**
        * @author Francsico Orozco 
        * @since: 22-05-2019
        * @method regresa el backlog de comparativos de cotizaciones 
        * @param array $where 'Array de filtros a usar'
        * @param: $area 'id area'
    **/
    function get_backlog_comparativos($where = null, $area = 0) {
        $query = $this->db->select('*', false)
                ->from('ccc_comparativo_cotizacion_compra')
                ->join('rxi_requisicion_inventario', 'rxi_id = ccc_id_rxi','inner')
                //->join('users', 'id = rxi_usu_creacion', 'inner')
                ->join('emp_empleado', 'emp_id_usu = rxi_usu_creacion', 'left')
                ->join('scm_seguimiento_comparativo_compra', 'scm_id_ccc = ccc_id', 'inner')
                ->join('psf_paso_flujo', 'psf_id = scm_id_psf', 'inner')
                ->join('ace_actividad_especifica', 'ace_id = rxi_id_ace','left')            
                ->join('flu_flujo', 'flu_id = ccc_id_flu', 'inner')
                ->join('rxp_rolxpaso', 'rxp_id_psf = psf_id', 'inner')
                ->join('uxr_usuarioxrol', 'uxr_id_rol = rxp_id_rol', 'inner')
                ->join('users', 'id = uxr_id_usu', 'inner')
                ->order_by('ccc_fecha','DESC')
                ->group_by('ccc_id')
        ;

        if ( $area > 0) {
            $this->db->where('(
                (
                    psf_area = 1
                    AND
                    (emp_id_are = ' . $area . ')
                )
                    OR
                    psf_area = 0
                )'
            );
        }

        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
        * @author: Francsico Orozco 
        * @since: 06-06-2019
        * @method regresa registros de seguimientos (requisiciones, ordenes de compras, comparativos)
        * @param: $tabla_seguimiento 'tabla de seguimientos a utilizar'
        * @param: array $where 'Array de filtros a usar'        
    **/
    public function get_usuarios_firmas_reportes($tabla_seguimiento = "", $where = null) {
        $prefijo_tbl_seg    = substr($tabla_seguimiento,0,3);
        $query = $this->db->select('*, '.$prefijo_tbl_seg.'_fecha_salida as fecha_salida', false)
                ->from($tabla_seguimiento)
                ->join('users','id = '.$prefijo_tbl_seg.'_id_usu','INNER')
                ->join('psf_paso_flujo','psf_id = '.$prefijo_tbl_seg.'_id_psf','INNER')
                ->order_by($prefijo_tbl_seg.'_id', 'ASC')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /******************************************************************************/
    /**
        * @author Elman Ortiz
        * @method regresa las comparativos de cotizaciones 
        * @property array $where 'Array de filtros a usar'
    */

    public function get_documentos_proveedor_retaceo_macivo($id_prv, $global_iddpvs){
        //print_r($global_iddpvs); die();
        $where = [];
        //$where['rtd_id_dpv IS NULL'] = false;
        $where['dpv_id_prv'] = $id_prv;

        $query = $this->db->select('*, 
            (SELECT tif_nombre FROM tif_tipo_factura WHERE tif_id = dpv_id_tif) AS tipo_factura_id,
            (SELECT tif_nombre FROM tif_tipo_factura WHERE tif_id = dpv_id_tif) AS tipo_factura',false)
            ->from("dpv_documento_proveedor")
            ->join("rdv_retaceo_documento_proveedor","dpv_id = rdv_id_dpv", "left")
            ->where("rdv_id_dpv IS NULL", null)            
        ;


        if ($where != null) {
            $this->db->where($where);
        }

        if ($global_iddpvs != null) {
            $this->db->where("dpv_id NOT IN(".$global_iddpvs.")", null);
        }

        /*if ($group_by != null) {
            $this->db->group_by($group_by);
        }*/   

        return $query->get()->result_array();
        //print_r($this->db->last_query()); die();
    }


    /**
    * @author Elman Ortiz
    * @method regresa las comparativos de cotizaciones 
    * @property array $where 'Array de filtros a usar'
    */
    public function get_detalles_documentos_proveedor_retaceo_macivo($global_iddpvs, $where = null){        
        $array_ids_dpvs = explode(',', $global_iddpvs);
        //print_r(count($array_ids_dpvs)); die();
        /*$query = $this->db->select('*, (
                SELECT mep_nombre
                FROM cva_conversion_articulo
                JOIN mep_medida_producto ON cva_id_mep = mep_id
                WHERE cva_id = dxd_id_cva AND cva_id_art = art_id
            ) AS nombre_unidad')             
            ->from("dxd_detalle_documento_proveedor")
            ->join("art_articulo", "dxd_id_art = art_id")
            ->where_in("dxd_id_dpv", $array_ids_dpvs)            
        ;*/

        $query = $this->db->select('*, cva.cva_conversion as conversion1, cva2.cva_conversion as conversion2,
                    (SELECT dpv_numero_documento FROM dpv_documento_proveedor WHERE dpv_id = dxd_id_dpv) as numero_documento', false)
                ->from('dxd_detalle_documento_proveedor')
                ->join('art_articulo', 'art_id = dxd_id_art', 'left')
                ->join('act_activo_fijo', 'act_id = dxd_id_act', 'left')
                ->join('cva_conversion_articulo as cva', 'cva.cva_id = dxd_id_cva', 'left')
                ->join('cva_conversion_articulo as cva2', 'cva2.cva_id_art = art_id and cva2.cva_defecto = 1', 'left')
                ->join('mep_medida_producto', 'mep_id = cva.cva_id_mep', 'left')
                ->join('tpv_tipo_venta', 'tpv_id = dxd_id_tpv', 'left')
                ->join('bod_bodega', 'bod_id = dxd_id_bod', 'left')
                ->join('sxb_sectorxbodega', 'sxb_id = dxd_id_sxb', 'left')
                ->join('seb_sector_bodega', 'seb_id = sxb_id_seb', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        if (count($array_ids_dpvs) > 0) {
            $this->db->where_in('dxd_id_dpv', $array_ids_dpvs);
        }

        $this->db->order_by('dxd_id_dpv', 'ASC');

        return $query->get()->result_array();        
    }    

    /*******************************************************/
    public function get_documentos_proveedor_retaceo_macivo_detalles($where = null, $global_iddpvs = null) {
        $array_ids_dpvs = explode(',', $global_iddpvs);

        $query = $this->db->select('*, (SELECT count(*) '
                        . 'FROM chp_cheque_pendiente '
                        . 'WHERE chp_id_dpv = dpv_id AND chp_generado = 0 and chp_estado = 1) as cheques_pendientes,'
                        . '(SELECT COUNT(*) FROM agp_agenda_pago
                    INNER JOIN chp_cheque_pendiente ON chp_id_agp = agp_id
                    WHERE agp_id_dpv = dpv_id) as agendas_pendientes,
                     (SELECT count(che_id) FROM che_cheque
                    INNER JOIN chp_cheque_pendiente ON che_id = chp_id_che
                    INNER JOIN tra_transaccion ON tra_id = che_id_tra
                    WHERE chp_id_dpv = dpv_id AND tra_aplicar = 0) as cheque_sin_aplicar,
                    (
                        SELECT COUNT(*)
                        FROM dpv_documento_proveedor as b
                        WHERE a.dpv_id = b.dpv_id_dpv_afecta
                    ) as tiene_nota', false)
                ->from('dpv_documento_proveedor as a')
                ->join('orc_orden_compra', 'orc_id = a.dpv_id_orc', 'left')
                ->join('tpg_tipo_pago', 'tpg_id = a.dpv_id_tpg', 'left')
                ->join('prv_proveedor', 'prv_id = a.dpv_id_prv', 'inner')
                ->join('tif_tipo_factura', 'tif_id = a.dpv_id_tif', 'left')
                ->join('cch_caja_chica', 'cch_id = dpv_id_cch', 'left')
                ->join('rtd_retaceo_documento_proveedor', 'rtd_id_dpv = a.dpv_id', 'left')
                ->join('pcl_proyecto_cliente', 'pcl_id = a.dpv_id_pcl', 'left')
                ->join('dgp_detalle_gasto_prespuesto', 'dgp_id_dpv = a.dpv_id', 'left')
                ->join('dps_detalle_presupuesto', 'dps_id = dgp_id_dps', 'left')
                ->join('ace_actividad_especifica', 'ace_id = dps_id_ace', 'left')
        ;
        $this->db->where('a.dpv_estado > ', 0 );

        if ($where != null) {
            $this->db->where($where);
        }

        if (count($array_ids_dpvs) > 0) {
            $this->db->where_in('a.dpv_id', $array_ids_dpvs);
        }

        $this->db->order_by('a.dpv_id', 'ASC');

        return $query->get()->result_array();        
    }

    public function get_retaceos_consolidados_lista($where = null) {
        $query = $this->db->select()
                ->from('rtd_retaceo_documento_proveedor')
                ->join('rdv_retaceo_documento_proveedor', 'rtd_id = rdv_id_rtd', 'inner')
                ->join('dpv_documento_proveedor', 'dpv_id = rdv_id_dpv', 'inner')
                ->join('prv_proveedor', 'dpv_id_prv = prv_id', 'inner')
                ->where('rtd_estado', 1)
        ;

        $this->db->group_by('rtd_id');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
        * @author: Marlon Olmedo
        * @since: 13-06-2019
        * @method busca los contratos proveedores
        * @param: where
        * @return: tabla cop_contrato_proveedor        
    **/
    public function get_cop_contrato_proveedor($where=null) {
        $query = $this->db->select('*')
            ->from('cop_contrato_proveedor')
            ->join('prv_proveedor', 'prv_id = cop_id_prv')
            ->join('art_articulo', 'art_id = cop_id_art')
            ->join('tif_tipo_factura', 'tif_id = cop_id_tif', 'left')
            ->join('tpg_tipo_pago', 'tpg_id = cop_id_tpg', 'left')
            ->join('itv_impuesto_contrato_proveedor', 'itv_id_cop = cop_id', 'left')
            ->join('imp_impuesto', 'imp_id = itv_id_imp', 'left')
        ;    

        if ($where != null) {
            $this->db->where($where);
        }   

        return $query->get()->result_array();
    }

        /**
        * @author: Marlon Olmedo
        * @since: 15-06-2019
        * @method trae los datos de contrato proveedor
        * @param: where
        * @return: tabla ccv_contrato_proveedor       
    **/
    public function get_ccv_contrato_proveedor($where=null) {
        $query = $this->db->select('*')
            ->from('ccv_cuota_contrato_proveedor')
            ->join('cop_contrato_proveedor', 'ccv_id_cop = cop_id')
            ->join('dpv_documento_proveedor', 'ccv_id_dpv = dpv_id','left')
        ;    

        if ($where != null) {
            $this->db->where($where);
        }   

        return $query->get()->result_array();
    }

    /**
    * @author Elman Ortiz
    * @method Obtener los documentos de proveedor guardados previamente
    * @property array $where 'Array de filtros a usar'
    */                  
    public function get_editar_documentos_proveedor_retaceo_macivo($where = null) {
        $query = $this->db->select('(
                                    SELECT prv_codigo
                                    FROM prv_proveedor
                                    WHERE prv_id = dpv_id_prv
                                    ) AS codigo_proveedor,
                                    (
                                    SELECT IF(prv_tipo_pers = 1, CONCAT(prv_nombre, "", prv_apellido) , prv_apellido)
                                    FROM prv_proveedor
                                    WHERE prv_id = dpv_id_prv
                                    ) AS proveedor,
                                    dpv_numero_documento,
                                    (
                                        SELECT tif_nombre
                                        FROM tif_tipo_factura
                                        WHERE tif_id = dpv_id_tif
                                    ) AS tipo_factura,
                                    dpv_id,
                                    dpv_subtotal', false)
                ->from('dpv_documento_proveedor')
                ->join('rdv_retaceo_documento_proveedor', 'dpv_id = rdv_id_dpv', 'inner')
                ->join('rtd_retaceo_documento_proveedor', 'rdv_id_rtd = rtd_id', 'inner')
                ->group_by('dpv_id')
                ;

                if ($where != null) {
                    $this->db->where($where);
                }

                return $query->get()->result_array();
    }

    /**
        * @author: Marlon Olmedo
        * @since: 18-06-2019
        * @method trae los detalle de cheques y che_cheque
        * @param: where
        * @return: tabla dch_detalle_cheque       
    **/
    public function get_dch_detalle_cheque($where=null) {
        $query = $this->db->select('*')
            ->from('dch_detalle_cheque')
            ->join('che_cheque', 'dch_id_che = che_id')
            ->join('dpv_documento_proveedor', 'dch_id_dpv = dpv_id')
        ;    

        if ($where != null) {
            $this->db->where($where);
        }   

        return $query->get()->result_array();
    }

    /**
    * @author: Elman Ortiz
    * @since: 21-06-2019
    * @method Obtiene los documentos de proveedor para editar el retaceo consolidado
    * @param: where
    * @return: Lista de docuementos de proveedor a ser editado
    **/
    public function get_lista_documentos_editar_retaceo_consolidado($where = null) {
        $query = $this->db->select()
                ->from('rtd_retaceo_documento_proveedor')
                ->join('rdv_retaceo_documento_proveedor', 'rtd_id = rdv_id_rtd', 'inner')
                ->join('dpv_documento_proveedor', 'dpv_id = rdv_id_dpv', 'inner')
                ->join('prv_proveedor', 'dpv_id_prv = prv_id', 'inner')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

            /**
        * @author: Marlon Olmedo
        * @since: 22-06-2019
        * @method trae la sumatoria de los detalle de proveedor
        * @param: where
        * @return: tabla sumatoria de dxd_total      
    **/
    public function get_sum_dxd_detalle_documento_proveedor($where=null) {
        $query = $this->db->select('sum(dxd_total) as suma')
            ->from('dxd_detalle_documento_proveedor')
            ->join('dpv_documento_proveedor', 'dpv_id = dxd_id_dpv')
            ->join('ccv_cuota_contrato_proveedor', 'dpv_id = ccv_id_dpv')
            ->join('cop_contrato_proveedor', 'cop_id = ccv_id_cop')
        ;    

        if ($where != null) {
            $this->db->where($where);
        }   
        
        return $query->get()->result_array();
    }

    /**
    * @author: Raul Escalante
    * @since: 19-07-2019
    * @method muestra el precio de la ultima compra segun los detalle de docs proveedor
    **/
    function get_precios_compras_dpv($where = null) {
        $query = $this->db->select("art_codigo, art_nombre, dxd_cantidad, dxd_precio_unitario, mep_nombre,
                                    IF (prv_tipo_pers = 1, CONCAT(prv_nombre, ' ', prv_apellido), prv_apellido) AS prv_nombre, 
                                    dpv_id, dxd_id, art_id, dpv_numero_documento, dpv_fecha_documento
                ", false)
                ->from('dpv_documento_proveedor')
                ->join('dxd_detalle_documento_proveedor', 'dpv_id = dxd_id_dpv')
                ->join('prv_proveedor', 'dpv_id_prv = prv_id')
                ->join('art_articulo', 'dxd_id_art = art_id')
                ->join('cva_conversion_articulo', 'dxd_id_cva = cva_id')
                ->join('mep_medida_producto','mep_id = cva_id_mep')
        ;
        $this->db->order_by('dpv_id, dxd_id DESC');
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
        * @author: Francisco Orozco
        * @since: 15-07-2019
        * @method Obtener detalles del documento proveedor para generar patida contable
        * @param: where
        * @return: detalle de documentos del proveedor
    **/
    public function get_detalle_doc_proveedor_partida($where = null, $cuenta_defecto = 0, $centro_defecto = 0) {
        $tcn_gto = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('GASTO'));
        $tcn_cto = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('COSTO'));
        $tcn_inv = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INVENTARIO_EN_TRANSITO'));
        $query = $this->db->select("*,
                IFNULL(pxd_id_cnt, IFNULL((SELECT cnt_id FROM dta_detalle_tipoarticulo JOIN cnt_cuenta_contable ON dta_id_cnt = cnt_id 
                    WHERE dta_id_tcn = IF(art_inventario = 1, '$tcn_inv', (IF(art_gasto = 1, '$tcn_gto', '$tcn_cto'))) AND dta_id_tia = tia_id 
                    AND IF(art_tipo=1, 1, dta_id_bod) = IF(art_tipo=1, 1, dxd_id_bod) LIMIT 1), '$cuenta_defecto')
                ) AS cuenta,
                IFNULL(pxd_id_cec, IFNULL(dpv_id_cec, '$centro_defecto')) AS centro,
                IFNULL(SUM(CASE WHEN pxd_porcentaje > 0 THEN  (dxd_total * (pxd_porcentaje/100)) ELSE dxd_total END),0) AS suma_haber,
                IFNULL(SUM(CASE WHEN pxd_porcentaje > 0 THEN  (dxd_cantidad * (pxd_porcentaje/100)) ELSE dxd_cantidad END), 0) AS cantidad, 
                IFNULL(SUM(CASE WHEN pxd_porcentaje > 0 THEN  (dxd_subtotal * (pxd_porcentaje/100)) ELSE dxd_subtotal END), 0) AS total, 
                GROUP_CONCAT((SELECT GROUP_CONCAT(CONCAT_WS('#', IFNULL(cxe_id_cnt, '$cuenta_defecto'), idd_id_imp, 
                    IFNULL(CASE WHEN pxd_porcentaje > 0 THEN (idd_monto * (pxd_porcentaje/100)) ELSE idd_monto END, 0))) 
                    FROM idd_impuestoxdetalle_documento INNER JOIN cxe_cuentaximpuesto ON cxe_id_imp = idd_id_imp WHERE idd_id_dxd = dxd_id 
                    AND cxe_id = (SELECT i2.cxe_id FROM cxe_cuentaximpuesto i2 WHERE i2.cxe_id_imp = idd_id_imp LIMIT 1) LIMIT 1)
                ) AS impuestos, 
                GROUP_CONCAT((SELECT GROUP_CONCAT(CONCAT_WS('#', IFNULL(dcr_id_cnt, '$cuenta_defecto'), rxd_id_ret, 
                    IFNULL(CASE WHEN pxd_porcentaje > 0 THEN (rxd_monto * (pxd_porcentaje/100)) ELSE rxd_monto END, 0))) 
                    FROM dcr_detalle_cuenta_retencion INNER JOIN rxd_retencionxdetalle_documento ON rxd_id_ret = dcr_id_ret WHERE rxd_id_dxd = dxd_id 
                    AND dcr_id = (SELECT r2.dcr_id FROM dcr_detalle_cuenta_retencion r2 WHERE r2.dcr_id_ret = rxd_id_ret LIMIT 1) LIMIT 1)
                ) AS retenciones",false)
            ->from('dxd_detalle_documento_proveedor')
            ->join('dpv_documento_proveedor','dpv_id = dxd_id_dpv','INNER') 
            ->join('prv_proveedor', 'prv_id = dpv_id_prv', 'INNER') 
            ->join('art_articulo', 'dxd_id_art = art_id', 'INNER')
            ->join('tia_tipo_articulo', 'art_id_tia = tia_id', 'INNER')
            ->join('pxd_prorrateoxdetalle_documento', 'pxd_id_dxd = dxd_id', 'LEFT')            
            ->join('cnt_cuenta_contable','cnt_id = pxd_id_cnt','LEFT')
            ->group_by('cuenta, centro')                           
        ;

        if ($where != null) {
            $this->db->where($where);
        }
    
        return $query->get()->result_array();
    }

    /**
        * @author: Francisco Orozco
        * @since: 19-07-2019
        * @method Obtener cuentas del impuesto
        * @param: where
        * @return: cuentas de los impuestos
    **/
    public function get_cuentas_impuestos($where = null) { 
        $query = $this->db->select()
            ->from('imp_impuesto')
            ->join('cxe_cuentaximpuesto','cxe_id_imp = imp_id','INNER')
            ->join('cnt_cuenta_contable', 'cnt_id = cxe_id_cnt', 'INNER')  
            ->group_by('imp_id')                           
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
        * @author: Francisco Orozco
        * @since: 19-07-2019
        * @method Obtener cuentas del retenciones
        * @param: where
        * @return: cuentas de retenciones
    **/
    public function get_cuentas_retenciones($where = null) { 
        $query = $this->db->select()
            ->from('ret_retencion')
            ->join('dcr_detalle_cuenta_retencion','dcr_id_ret = ret_id','INNER')
            ->join('cnt_cuenta_contable', 'cnt_id = dcr_id_cnt', 'INNER')  
            ->group_by('ret_id')                           
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

     /**
        * @author: Francisco Orozco
        * @since: 22-07-2019
        * @method Obtener partidas contables
        * @param: where
        * @return: detalle de documentos del proveedor
    **/
    public function get_partida_contable($where = null) { 
        $query = $this->db->select()
            ->from('pct_partida_contable')
            ->join('dpc_detalle_partida', 'dpc_id_pct = pct_id', 'INNER')    
            ->join('pcc_partida_centro_costo','pcc_id = dpc_id_pcc','LEFT')                      
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
        * @author: Francisco Orozco
        * @since: 22-07-2019
        * @method Obtener rubro
        * @param: where
        * @return: rubros
    **/
    public function get_rubros($where = null) { 
        $query = $this->db->select()
            ->from('ace_actividad_especifica')
            ->join('acg_actividad_general','acg_id = ace_id_acg','JOIN')                      
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_retaceos_cons($where = null) {
        $query = $this->db->select("rtd_id,rtd_numero", FALSE)
                ->from('dpv_documento_proveedor')
                ->join('rdv_retaceo_documento_proveedor','rdv_id_dpv = dpv_id')
                ->join('rtd_retaceo_documento_proveedor','rdv_id_rtd = rtd_id')
                ->where('rtd_estado', 1)
                ->where('rtd_id_dpv IS NULL')
                ;
        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('rtd_id');
        return $query->get()->result_array();
    }

    public function get_detalle_retaceo_cons($where = null) {
        $query = $this->db->select()
                ->from('rtd_retaceo_documento_proveedor')
                ->join('drc_detalle_retaceo', 'drc_id_rtd = rtd_id')
                ->join('art_articulo', 'art_id = drc_id_art', 'left')
                ->join('cva_conversion_articulo', 'cva_id = drc_id_cva', 'left')
                ->join('mep_medida_producto', 'mep_id = cva_id_mep', 'left')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_docs_retaceo_cons($where = null) {
        $query = $this->db->select()
                ->from('rdv_retaceo_documento_proveedor')
                ->join('dpv_documento_proveedor', 'dpv_id = rdv_id_dpv')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_gastos_retaceo_cons($where = null) {
        $query = $this->db->select()
                ->from('grc_gasto_retaceo')
                ->join('gst_gasto', 'grc_id_gst = gst_id')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_impuestos_categoria($where = null) {
        $query = $this->db->select()
                ->from('imp_impuesto')
                ->join('ixr_impuestox_tipo_articulo', 'imp_id = ixr_id_imp', 'LEFT')
                ->group_by('imp_id')
        ;

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    public function get_config_cnj($where = null){
        $query = $this->db->select()
                ->from('cjc_cierre_caja_chica')
                ->join('lcc_liquidacion_caja_chica', 'lcc_id = cjc_id_lcc')
                ->join('cnj_cuenta_caja_chica', 'cnj_id_cch = lcc_id_cch')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    function get_numeros_facturas($where = null, $limit = null) {
        $query = $this->db->select()
            ->from('dpv_documento_proveedor')
            ->order_by('CAST(dpv_numero_documento AS UNSIGNED)','DESC')
        ;
        if ($where) {
            $this->db->where($where);
        }
        if ($limit) {
            $this->db->limit(1);
        }
        return $query->get()->result_array();
    }

    public function get_caja_doc_prv_suj_exc($where=null){
        $query = $this->db->select("sef_nombre")
            ->from('cxj_correlativoxcaja')
            ->join('caj_caja', 'caj_id = cxj_id_caj')
            ->join('cof_correlativo_factura', 'cof_id = cxj_id_cof')
            ->join('sef_serie_factura', 'sef_id = cof_id_sef')
            ->where('cof_estado', 1)
            ->where('cxj_estado', 1)
            ->where('cxj_fin < ', 0)
            ->where('caj_id_suc IS NOT NULL')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_datos_dpv_ret($where = null) {
        $query = $this->db->select("*, (SELECT tif_nombre FROM tif_tipo_factura WHERE tif_id = d.dpv_id_tif) AS tipo_doc,
            (SELECT tpg_nombre FROM tpg_tipo_pago WHERE tpg_id = d.dpv_id_tpg) AS tipo_pago_nombre, (SELECT orc_numero FROM orc_orden_compra WHERE orc_id = d.dpv_id_orc) AS orden_compra,
            (SELECT cec_nombre FROM cec_centro_costo WHERE cec_id = d.dpv_id_cec) AS centro_compra, (SELECT cch_nombre FROM cch_caja_chica WHERE cch_id = d.dpv_id_cch) AS caja_chica, 
            (SELECT cod_nombre FROM cod_condicion WHERE cod_id = d.dpv_id_cod) AS condicion_pago, (SELECT tmt_nombre FROM tmt_tipo_monto WHERE tmt_id = d.dpv_id_tmt) AS tipo_monto,
            (SELECT CONCAT(t.tif_abreviacion,' - ',a.dpv_numero_documento) FROM dpv_documento_proveedor AS a JOIN tif_tipo_factura AS t ON t.tif_id = a.dpv_id_tif 
            WHERE a.dpv_id = d.dpv_id_dpv_afecta) AS doc_afecta, (SELECT CONCAT(prv_codigo,' - ',IF(prv_tipo_pers > 1, prv_apellido,CONCAT(prv_nombre,' ',prv_apellido))) FROM prv_proveedor 
            WHERE prv_id = d.dpv_id_prv) AS proveedor, 
            (SELECT mep_nombre FROM mep_medida_producto JOIN cva_conversion_articulo ON cva_id_mep = mep_id WHERE cva_id = dxd_id_cva) AS medida", false)
            ->from('dpv_documento_proveedor AS d')
            ->join('dxd_detalle_documento_proveedor', 'dxd_id_dpv = d.dpv_id')
            ->join('rxd_retencionxdetalle_documento', 'rxd_id_dxd = dxd_id')
            ->join('ret_retencion', 'rxd_id_ret = ret_id')
            ->join('art_articulo', 'art_id = dxd_id_art', 'left')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }    


    #***********************************************************************************************#
    #************************************LECTOR DE JSON ********************************************#
    #***********************************************************************************************#

    public function normalize($s){
        if ($s === null) return '';
        $s = strtoupper($s);
        $tr = @iconv('UTF-8','ASCII//TRANSLIT',$s);
        if ($tr !== false) $s = $tr;
        $s = preg_replace('/[^A-Z0-9 ]+/', ' ', $s);
        $s = preg_replace('/\s+/', ' ', trim($s));
        return $s;
    }

    private function first_tokens($s, $n=3){
        $parts = explode(' ', $s); $out=array();
        foreach($parts as $p){ if($p!=='') $out[]=$p; if(count($out)>=$n) break; }
        return $out;
    }

    public function get_by_codigo($codigo, $prv)
    {
        if (!$codigo) return null;

        $this->db->select('a.*') // todos los campos de art_articulo
                 ->from('cpc_codigo_producto_compras c')
                 ->join('art_articulo a', 'a.art_id = c.cpc_id_art')
                 ->where('c.cpc_id_prv', $prv)
                 ->where('c.cpc_codigo', $codigo)
                 ->where('c.cpc_estado', 1) // opcional: solo activos
                 ->limit(1);

        return $this->db->get()->row_array();
    }


    public function candidates_by_nombre($nombre_externo, $limit = 12)
    {
        $norm = $this->normalize($nombre_externo);
        if ($norm === '') return array();

        $human = strtoupper(trim(preg_replace('/\s+/', ' ', $nombre_externo)));
        $terms = preg_split('/\s+/', $human);

        $STOP = array('DE','DEL','LA','EL','LOS','LAS','Y','CON','SIN','PARA',
                      'PRO','UL','ML','LT','LTS','GALON','GALÓN','GAL','UNIDAD','UNI','UND',
                      'OTROS','OTRO','PRODUCTOS','PROD','PROD.');

        $tokens = array();
        foreach ($terms as $t) {
            $t = trim($t);
            if ($t === '' || strlen($t) < 2) continue;
            if (in_array($t, $STOP, true)) continue;
            $tokens[] = $t;
        }
        if (empty($tokens)) $tokens = $terms;

        $strong = array();
        foreach ($tokens as $t) {
            if (strlen($t) >= 4 || (strlen($t) >= 3 && !ctype_digit($t))) $strong[] = $t;
        }
        if (empty($strong)) $strong = $tokens;

        $first = isset($strong[0]) ? $strong[0] : null;

        $this->db->select('art_id, art_codigo, art_nombre');
        $this->db->from('art_articulo');

        $clauses = array();

        $clauses[] = "UPPER(art_nombre) LIKE " . $this->db->escape('%' . $human . '%');

        if ($first) {
            $clauses[] = "UPPER(art_nombre) LIKE " . $this->db->escape($first . '%');
        }

        if (!empty($strong)) {
            $ands = array();
            foreach ($strong as $t) {
                $ands[] = "UPPER(art_nombre) LIKE " . $this->db->escape('%' . $t . '%');
            }
            $clauses[] = '(' . implode(' AND ', $ands) . ')';
        }

        $compactHuman = strtoupper(preg_replace('/[\s\-_]+/', '', $human));
        $exprCompact  = "REPLACE(REPLACE(REPLACE(UPPER(art_nombre),' ',''),'-',''),'_','')";
        $clauses[]    = $exprCompact . " LIKE " . $this->db->escape('%' . $compactHuman . '%');

        $where = '(' . implode(' OR ', $clauses) . ')';
        $this->db->where($where, NULL, FALSE);
        $this->db->limit(250);

        $rows = $this->db->get()->result_array();

        $scored = array();
        foreach ($rows as $r) {
            $nameUpper = strtoupper($r['art_nombre']);
            $nBase     = $this->normalize($r['art_nombre']);

            $pct = 0.0; similar_text($norm, $nBase, $pct);
            $sim = $pct / 100.0;

            $hits = 0;
            foreach ($strong as $t) if (strpos($nameUpper, $t) !== FALSE) $hits++;
            $coverage = !empty($strong) ? $hits / max(1, count($strong)) : 0.0;

            $prefix = ($first && strpos($nameUpper, $first) === 0) ? 1.0 : 0.0;

            $seqBonus = 0.0;
            if (count($strong) >= 2) {
                $p = '/\b' . preg_quote($strong[0], '/') . '\b.*\b' . preg_quote($strong[1], '/') . '\b/i';
                if (preg_match($p, $nameUpper)) $seqBonus += 0.05;
            }

            $phraseBonus = (strpos($nameUpper, $human) !== FALSE) ? 0.10 : 0.0;

            $score = max($sim, $coverage * 0.9);
            if ($prefix)  $score = max($score, 0.95);
            $score = min(1.0, $score + $seqBonus + $phraseBonus);
            if ($nBase === $norm) $score = 1.0;

            $r['score'] = round($score, 4);
            $scored[]   = $r;
        }

        usort($scored, function($a, $b){
            if ($a['score'] == $b['score']) return strcasecmp($a['art_nombre'], $b['art_nombre']);
            return ($a['score'] < $b['score']) ? 1 : -1;
        });

        return array_slice($scored, 0, $limit);
    }

    #***********************************************************************************************#
    #********************************** END LECTOR DE JSON *****************************************#
    #***********************************************************************************************#




} // End of class