<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Caja_model extends CI_Model
{

    public $variable;

    public function __construct()
    {
        parent::__construct();
        //Do your magic here!
        $this->load->database();
    }
    
    /**
     * Caja_model::operacionCaja()
     * Transacciones de Caja
     * tipo: 1-Apertura, 2-Cierre, 3-Remesa
     * 
     * @param int $tipo
     * @param date $fecha
     * @param int $caja
     * @param int $usuario
     * @param decimal $monto
     * @return int
     */
    public function operacionCaja($tipo, $fecha, $caja, $usuario, $monto){
        try{
            
            //TODO: No se puede procesar cierre ni apertura si hay transacciones pendientes
            
            $this->db->insert(
                'cxu_cajaxusuario'
              , array(
                    'cxu_id_caj'    => $caja
                  , 'cxu_id_usu'    => $usuario
                  , 'cxu_tipo'      => $tipo
                  , 'cxu_entrada'   => ( in_array($tipo, array(1, 3)) ) ? $monto : 0   //apertura, remesa
                  , 'cxu_salida'    => ( in_array($tipo, array(2)) ) ? $monto : 0   //cierre 
                  , 'cxu_fecha'     => date('Y-m-d H:i:s', strtotime($fecha))
                  , 'cxu_usu_mod'   => $this->tank_auth->get_user_id()
                  , 'cxu_fecha_mod' => date('Y-m-d H:i:s')
                )
            );
            return $this->db->insert_id();
        }catch(Exception $e){
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }
    
    function getCargaLAboral(){
        try{
            $carga = array();
            
            $usu_id = $this->tank_auth->get_user_id();
            $fecha  = date('Y-m-d');
            
            $apertura = $this->db
                ->from('cxu_cajaxusuario')
                ->where('cxu_id_usu', $usu_id)
                ->where('cxu_fecha', $fecha)
                ->where('cxu_tipo', 1)
                ->get()
                ->row()
            ;
            
            //si hay apertura
            if( count($apertura) == 1 && $apertura->cxu_id > 0 ){
                
                $cierre = $this->db
                    ->from('cxu_cajaxusuario')
                    ->where('cxu_id_usu', $usu_id)
                    ->where('cxu_fecha', $fecha)
                    ->where('cxu_tipo', 2)
                    ->get()
                    ->row()
                ;
                //mientra no hay cierre
                if( count($cierre) == 0 ){
                    
                    $pendientes = $this->db
                        ->from('fun_funo')
                        ->where('fun_estado', 1)
                        ->get()
                        ->result()
                    ;
                    
                }
            }
            
            return $pendientes;
        }catch(Exception $e){
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }
    
    /**
     * Obtiene ID de cuenta presupuestaria de acuerdo a la fecha de insercion de pago
     * @param  integer $id_detalle ID detalle de cargo
     * @return integer ID de cuenta presupuestaria
     */
    public function getIdCuentaPresupuestaria($id_detalle = 0)
    {
        $query_cuenta_presupuestaria = "SELECT CASE
        WHEN  YEAR(det_fecha) < YEAR(NOW()) THEN servicio.srv_id_cpr_pasado
        WHEN  YEAR(det_fecha) = YEAR(NOW()) THEN servicio.srv_id_cpr_actual
        WHEN  YEAR(det_fecha) > YEAR(NOW()) THEN servicio.srv_id_cpr_futuro
        END AS cuenta_presupuestaria
        FROM det_detalle_cntc AS detalle_cuenta
        INNER JOIN sxc_servicioxcuenta_corriente AS sxc ON sxc.sxc_id = detalle_cuenta.det_id_sxc
        INNER JOIN srv_servicio AS servicio ON servicio.srv_id = sxc.sxc_id_srv
        WHERE detalle_cuenta.det_id = ?";

        $resultado = $this->db->query($query_cuenta_presupuestaria, array($id_detalle));
        return (is_object($resultado) && $resultado->num_rows() > 0) ? $resultado->row()->cuenta_presupuestaria : false;
    }

    /**
     * Establece a que cuenta presupuestaria pertenece el cobro de cada detalle de cargo mensual
     * @param  integer $id_detalle ID detalle cargo
     * @param  integer $id_cuenta_presupuestaria ID cuenta presupuestaria
     * @return boolean resultado actualizacion
     */
    //TODO: ELIMINAR
    public function actualizarCuentaPresupuestaria($id_detalle, $id_cuenta_presupuestaria)
    {
        $data_detalle = array('det_id_cpr' => $id_cuenta_presupuestaria);
        $this->db->where('det_id', $id_detalle);
        $this->db->update('det_detalle_cntc', $data_detalle);

        return true;
    }

    public function verificar_plan($fun_id)
    {
        $cxp = $this->_verificar_plan($fun_id);

        if (isset($cxp['cxp_id'])) {
            $result = $this->mod_registro('cxp_cuotaxplan', array('cxp_id' => $cxp['cxp_id']), array('cxp_estado' => 0));
        }
    }

    public function _verificar_plan($fun_id)
    {
        $this->db
            ->select('cxp_id')
            ->from('cxp_cuotaxplan')
            ->where('cxp_id_fun_pasado', $fun_id)
            ->or_where('cxp_id_fun_actual', $fun_id)
        ;
        $query = $this->db->get();
        return $query->row_array();
    }

    public function mod_registro($tabla, $where, $set)
    {
        $this->db->where($where);
        $this->db->update($tabla, $set);
        return $this->db->affected_rows();
    }



/**
 * @author René Castaneda
 * @return generadores de una caja gxc_generadorxcaja
 */
    function get_generadoresxCaja($id_caja=0) 
    {

       $this->db->select()
            ->FROM('gxc_generadorxcaja')
            ->join('gen_generador','gxc_generadorxcaja.gxc_id_gen = gen_generador.gen_id')
            ->where('gxc_id_caj',$id_caja)
            ->where('gen_estado',1)
            ->order_by('gxc_id','ASC');

          $query=$this->db->get();
          return $query;
    } 


/**
 * @author René Castaneda
 * @return extrae los fun_funo segun el fun_id_gen
 */
    function get_funoxGenerador($id_generador) 
    {

   $query = "esl_estado_liquidacion.esl_id, esl_estado_liquidacion.esl_nombre, fun_funo.* ";
   $this->db->select($query);    
   $this->db->from('liq_liquidacion');
   $this->db->join("esl_estado_liquidacion","liq_liquidacion.liq_id_esl = esl_estado_liquidacion.esl_id");
   $this->db->join("fun_funo","fun_funo.fun_id_liq = liq_liquidacion.liq_id");
   $this->db->where('esl_estado_liquidacion.esl_nombre','impaga');
   $this->db->where('fun_funo.fun_estado',1);
   $this->db->where('fun_funo.fun_id_gen',$id_generador);
   $result = $this->db->get();
   return  $result->result_array();
   
    } 

  /**
   * @author René Castaneda
   * @return extrae los servicios segun el grupo
   */
    function get_servicosxgrupo($id_grupo) 
    {
   $this->db->select();    
   $this->db->from('grs_grupo_servicio');
   $this->db->join("sxg_servicio_grupo","sxg_servicio_grupo.sxg_id_grs = grs_grupo_servicio.grs_id");
   $this->db->join("srv_servicio","sxg_servicio_grupo.sxg_id_srv = srv_servicio.srv_id");
   $this->db->where('srv_estado',1);
   $this->db->where('sxg_estado',1);
   $this->db->where('grs_id',$id_grupo);
   $result = $this->db->get();
   return  $result->result_array();
   
    } 

 /**
   * @author René Castaneda
   * @return extrae los funos que ya fueron procesados en carga laboral
   */
    public function funos_pagados($condicion=null)
 {
   $this->db->select();    
   $this->db->from('fun_funo');
   if($condicion!=null){
   $this->db->where($condicion); 
   }
   $this->db->where('fun_funo.fun_estado',0);
   $this->db->where('fun_funo.fun_numero IS NOT NULL');
   $this->db->where('fun_funo.fun_id_caj IS NOT NULL');
   $this->db->order_by('fun_funo.fun_numero','DESC');
   $this->db->order_by('fun_funo.fun_id','DESC');
   $result = $this->db->get();
   return  $result->result_array();
 }

  /**
   * @author René Castaneda
   * @return los detalles correspondiente a un funo
   */
    public function detallesxfuno($id_funo)
 {
  $detalles = $this->db
   ->from('fxd_funoxdetalle_cntc')
   ->join('det_detalle_cntc', 'det_id = fxd_id_det')
   ->where('fxd_id_fun', $id_funo)
   ->get()
   ->result();
   return  $detalles;
 }



}

/* End of file caja.php */
/* Location: ./application/models/caja.php */
