<?php

/**
 * @author Mario Marquez  
 * @method Modelo - Modulo Avisos
 */
Class Avisos_Model extends CI_Model {

    function __construct() {
        $this->load->database();
    }

    function get_avisos($where = null) {

        $query = $this->db->select()
                ->from('avi_aviso');

        if ($where != null) {
            $this->db->where($where);
        }

        return $query->get()->result_array();
    }

    /**
     * @author Mario Marquez
     * @since 2018-07-15
     * @return Obtener información del usuario
     */
    public function get_info_usuario($where = null) {
        $q = $this->db->select()
                ->from('users')
                ->join('emp_empleado', 'usu_id_emp=emp_id')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $q->get()->result_array();
    }

    function get_avisos_usuario($where = null) {
        $query = $this->db->select("avi_aviso.*,emp_empleado.emp_nombre, emp_empleado.emp_apellido")
                ->from('avi_aviso')
                ->join('vxr_avisoxrol', 'vxr_id_avi = avi_id')
                ->join('uxr_usuarioxrol', 'uxr_id_rol = vxr_id_rol')
                ->join('users','id = avi_id_usu')
                ->join('emp_empleado', 'usu_id_emp=emp_id', 'left')
        ;

        if ($where != null) {
            $this->db->where($where);
        }
        $this->db->group_by('avi_id');

        $resultado = $query->get()->result_array();
        
        //Se obtienen los adjuntos de cada Aviso
        foreach($resultado as &$aviso){
            $aviso['anexos'] = $this->gsatelite->get_tabla('ani_anexo_aviso', array('ani_id_avi' => $aviso['avi_id']));
        }
        return $resultado;
    }

}
