<?php
/**
 *  
 * 2015-06-22
 * 
 * @package 
 * @author Melbin Crz
 * @copyright 2015
 * @version RC1
 * @access public
 */

class Auto_gestion_model extends CI_Model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    // Funciones del Modelo
    function get_tipo_contrato($where)
    {
        $puesto = $this->db->select()
        ->from('txe_tipo_planillaxempleado')
        ->join('tpl_tipo_planilla', 'txe_id_tpl=tpl_id')
        ->where($where)
        ->get();
        return $puesto->result_array();
    }

    public function get_horas_extras($where=null) {
        $query= $this->db->select()
        ->from('hxe_hora_extraxempleado')
        ->join('emp_empleado','hxe_hora_extraxempleado.hxe_id_emp = emp_empleado.emp_id')
        ->join('inn_ingreso','inn_ingreso.inn_id_hxe = hxe_hora_extraxempleado.hxe_id', 'left')
        ->join('pla_planilla','hxe_hora_extraxempleado.hxe_id_pla = pla_planilla.pla_id', 'left')
        ->join('the_tipo_hora_extra','hxe_hora_extraxempleado.hxe_id_the = the_tipo_hora_extra.the_id', 'left')
        ->join('tpl_tipo_planilla','inn_ingreso.inn_id_tpl = tpl_tipo_planilla.tpl_id', 'left')
        //->where('hxe_hora_extraxempleado.hxe_id_emp',$id_emp)
        ->group_by('hxe_hora_extraxempleado.hxe_id')
        ->order_by('hxe_hora_extraxempleado.hxe_id','DESC');
        if($where!=null){
            $this->db->where($where);
        }
         return $query->get()->result_array();       
    }

    public function grid_vacaciones_empleado($empleado=null) {
        $query1 = $this->db->select("IFNULL(gva_id, 0) AS gva_id, slv_id, prv_nombre, slv_cantidad_dias, gva_dias, IFNULL(gva_desde, slv_fecha_desde) AS fecha_desde, IFNULL(gva_hasta, slv_fecha_hasta) AS fecha_hasta, slv_estado",false)
            ->from('slv_solicitud_vacacion')
            ->join('vac_vacacion','vac_id = slv_id_vac')
            ->join('prv_periodo_vacacion','prv_id = vac_id_prv')
            ->join('gva_goce_vacacion','gva_id = slv_id_gva','left')
        ;
        if($empleado){
            $this->db->where("slv_id_emp = $empleado");
        }
        $return = $query1->get()->result_array();
        if ($empleado) {
            $query2 = "SELECT gva_id, 0 AS slv_id, prv_nombre, NULL AS slv_cantidad_dias, gva_dias, gva_desde AS fecha_desde, gva_hasta AS fecha_hasta,
                2 AS slv_estado FROM gva_goce_vacacion JOIN vac_vacacion ON vac_id = gva_id_vac JOIN prv_periodo_vacacion ON prv_id = vac_id_prv 
                WHERE gva_id NOT IN (SELECT DISTINCT slv_id_gva FROM slv_solicitud_vacacion  WHERE slv_id_gva IS NOT NULL AND slv_id_emp = gva_id_emp) 
                AND gva_id_emp = $empleado;";
            $result = $this->db->query($query2)->result_array();
            if (count($result) > 0) {
                $return = array_merge($return, $result);
                usort($return, function ($a, $b) {
                    return ($a['gva_id'] < $b['gva_id']) ? -1 : 1;
                });
            }
        }
        return $return;
    }

    public function get_consumo_permiso($emp_id = 0, $year = 0) {
        $y = ($year > 0) ? $year : date("Y");
        $query = "SELECT thf_nombre, thf_horas_ley, IFNULL((SELECT SUM(uhp_numero_horas) FROM uhp_uso_horas_permisos JOIN hxe_hora_extraxempleado ON hxe_id = uhp_id_hxe 
            WHERE uhp_id_thf = thf_id AND hxe_id_emp = $emp_id AND YEAR(hxe_fecha) = $y), 0) AS usado, IFNULL((SELECT hpe_horas_limite FROM hpe_hora_permiso_x_empleado 
            WHERE hpe_id_emp = $emp_id AND hpe_id_thf = thf_id), 0) AS limite FROM thf_tipo_hora_faltante WHERE thf_estado = 1";
        $result = $this->db->query($query);
        return $result->result_array();
    }

}
?>