<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Api_facturacion_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function validar_access_token($access_token)
    {
        $this->db->from('apt_api_tokens');
        $this->db->where('apt_access_token', $access_token);
        $this->db->where('apt_estado', 1);
        $this->db->where('apt_expira_en >=', date('Y-m-d H:i:s'));
        $query = $this->db->get();

        if ($query->num_rows() === 1) {
            return [
                'usuario_id' => $query->row()->apt_usu_id,
                'token_id' => $query->row()->apt_id,
                'expira_en' => $query->row()->apt_expira_en
            ];
        }

        return null;
    }

    public function validar_refresh_token($refresh_token)
    {
        $this->db->where('apt_refresh_token', $refresh_token);
        $this->db->where('apt_estado', 1);
        $this->db->limit(1);
        $query = $this->db->get('apt_api_tokens');

        $timestamp = date('Y-m-d H:i:s');
        $ip = $_SERVER['REMOTE_ADDR'] ? $_SERVER['REMOTE_ADDR'] : 'unknown';

        if ($query->num_rows() === 1) {
            $row = $query->row_array();
            $log_entry = [
                'accion' => 'refresh_token_validado',
                'fecha' => $timestamp,
                'ip' => $ip
            ];

            $log_actual = json_decode($row['apt_log_accion'], true) ?: [];
            $log_actual[] = $log_entry;

            $this->db->where('apt_id', $row['apt_id']);
            $this->db->update('apt_api_tokens', [
                'apt_log_accion' => json_encode($log_actual, JSON_UNESCAPED_UNICODE)
            ]);

            return [
                'apt_id' => $row['apt_id'],
                'apt_usu_id' => $row['apt_usu_id']
            ];
        }

        $this->db->where('apt_refresh_token', $refresh_token);
        $query = $this->db->get('apt_api_tokens');
        if ($query->num_rows() === 1) {
            $row = $query->row_array();

            $log_entry = [
                'accion' => 'refresh_token_invalido',
                'fecha' => $timestamp,
                'ip' => $ip
            ];

            $log_actual = json_decode($row['apt_log_accion'], true) ?: [];
            $log_actual[] = $log_entry;

            $this->db->where('apt_id', $row['apt_id']);
            $this->db->update('apt_api_tokens', [
                'apt_log_accion' => json_encode($log_actual, JSON_UNESCAPED_UNICODE)
            ]);
        }

        return false;
    }


    function verificar_certificado_usuario($user){

        $query = $this->db->select("*")
                 ->from("users")
                 ->join("emp_empleado","emp_id_usu = id","inner")
                 ->join("suc_sucursal","emp_id_suc = suc_id","inner")
                 ->join("emr_empresa","suc_id_emr = emr_id","inner")
                 ->join("cer_certificados","cer_emr_id = emr_id","inner")
                 ->where("id", $user)
                 ->where('cer_estado', '1')
                 ->get()
                 ->row();

        return $query;

    }



}
