<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Descripcion
 * Accede a la base de datos y manipula informacion concerniente a activo fijo dentro 
 * de la base de datos, tambien realiza procesos de calculo y prepara la informacion 
 * antes de ser insertada o enviada a la vista.
 * 
 * @author:     Alan Alvarenga - Grupo Satelite 
 * @version:    v0.4.1 - 2013-07-31
 * @since:      2013-07-18 
 * @package:    CONAMYPE
 * =================================================================================================
 * Nomenclatura:
 * + AGREGADO
 * - ELIMINADO
 * * ACTUALIZADO
 * -------------------------------------------------------------------------------------------------
 * Bitacora:
 * TODO:    INSERTAR axe_use_mod --> usuario que creo el registro en todas las transacciones de 
 *          activo por empleado
 * -------------------------------------------------------------------------------------------------
 * 2013-08-02 v0.5.1
 * + get_datos_simulacion   -   Obtiene listado de depreciaciones por ID de activo fijo 
 * + get_diferencia_meses   -   Obtiene la diferencia en meses de un rango de fechas determinado
 * + generar_simulacion     -   Generacion de simulacion de depreciacion de activo fijo por 
 *                              ID de activo
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 * 2013-08-01 v0.5
 * + get_detalles_activo_completo   -   Obtiene todos los detalles relacionados a un activo 
 *                                      por ID de activo
 * + get_depreciacion_acumulada     -   Calcula los meses y cargos de depreciacion 
 *                                      por activo fijo ID                                     
 *
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 * 2013-07-31 v0.4.1 
 * + get_listado_depreciacion   -   Obtiene listado de activos, costo, monto de depreciacion
 *                                  acumulado  y los meses depreciados 
 *
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 * 2013-07-30 v0.4
 * + get_depreciacion_anual     -   Obtiene el monto de depreciacion anual por ID de activo fijo
 * * set_activo_fijo_x_empleado     -   Agregado, campo axe_id_ubi en nueva asignacion de activo
 * + get_ubicaciones_area   -   Obtiene ubicaciones por ID de Area
 *
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 * 2013-07-29 v0.3.1
 * + get_porcentaje_depreaciacion   -   Obtiene porcentaje de depreciacion por ID de tipo 
 *                                      de depreciacion
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 * 2013-07-27 v0.3
 * + set_baja_activo    -   Cambia el estado del activo a fijo a desactivado
 *
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 * 2013-07-26 v0.2.1
 * + set_traslado_activo    -   Trasladar activo fijo
 * + get_detalles_activo_fijo   -   Obtiene detalles de activo fijo por ID 
 *
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 * 2013-07-25 v0.2
 * + set_activo_fijo_x_empleado     -   Asignacion de activo fijo por empleado y area
 * - get_filtro_caracteristica  -   Implementado Filtro AJAX Genericos gSateliteBlue package
 *
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 * 2013-07-23 v0.1.1
 * + insert_registro    -   Insetar Registros en la base de datos en una tabla especifica
 * + registrar_activo   -   Registrar Nuevo Activo Fijo
 * + get_filtro_caracteristica  -   GET caracteristicas filtradas por id de tipo de caracteristica
 * 
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 * 2013-07-18 v0.1 - Inicio Spring 2
 * + get_registros_where    -   Obtiene listado de Tipo registros correspondientes a una tabla en 
 *                              especifico con un filtro de tipo where
 * + get_registros          -   Obtiene listado de registros correspondientes a una tabla en 
 *                              especifico.
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 */
class Activo_Fijo extends CI_Model {

    public function __construct()
    {
        parent::__construct();
        
    }

    /**
     * Registro A-F - Obtiene listado de registros correspondientes a una tabla en especifico
     * @param  string $tabla Nombre de la tabla
     * @return CI_Object_Array Array con el listado de resultados obtenidos
     */
    public function get_registros( $tabla='' )
    {
        //Verificar si el nombre de la tabla fue enviado
        if ( $tabla !== '' ){
            //Obtener datos de la tabla
            $query_tabla = $this->db->get($tabla);
        }

        return ( is_object( $query_tabla ) && $query_tabla->num_rows() > 0 ) ? $query_tabla : false;
    }

    public function get_acts_ajx($where = null, $like = null){
        $query = $this->db->select("act_id AS id, CONCAT_WS(' ',act_codigo,act_nombre) AS nombre", false)->from('act_activo_fijo');
        if ($where != null) {
            $this->db->where($where);
        }
        if ($like != null) {
            $this->db->like($like);
        }
        return $query->get()->result_array();
    }

    public function get_activosxempleado($where = null){
      $this->db->select('emp_id,
                (CONCAT(emp_nombre, " ",emp_apellido)  ) as asig_emp
                 ',false)
                ->from('axe_activoxempleado')
                ->join('act_activo_fijo', 'act_id = axe_id_act')
                ->join('emp_empleado', 'emp_id = axe_id_emp')
                ;
                if ($where !== null) {
                   $this->db->where($where);
                }
                return $this->db->get()->result_array();
    }

    public function get_areas_hijas()
    {
            $query_padres="SELECT DISTINCT are_padre FROM are_area";
      $padres=$this->db->query($query_padres)->result_array();

      $cadena_in="";
      foreach ($padres as $key => $value) {
        if($value['are_padre'] != ""){
          $cadena_in.=$value['are_padre'].","; 
        }
               
      }
      $cadena_final=substr($cadena_in,0,-1);
        if($cadena_final == '')
      {
        $cadena_final=0;
      }
      $query_no_tienen_hijos="SELECT are_id FROM are_area WHERE are_id NOT IN (".$cadena_final.")";
      $no_tienen_hijos=$this->db->query($query_no_tienen_hijos)->result_array();
      $cadena_in2="";
      foreach ($no_tienen_hijos as $key2 => $value2) {
        if($value2['are_id'] != ""){
          $cadena_in2.=$value2['are_id'].","; 
        }
               
      }
      $cadena_final2=substr($cadena_in2,0,-1);
      if($cadena_final2 == '')
      {
        $cadena_final2=0;
      }
      $query="SELECT * FROM are_area WHERE are_id IN (".$cadena_final2. ")";
      $resultado=$this->db->query($query);
      return $resultado->result_array();
    }

    public function inventarioxfecha($area, $tipo_activo = null)
    {
      $this->db->select()
               ->from('inf_inventario_fisico')
               ->where('inf_id_are',$area);
      if ($tipo_activo) {
        //$this->db->where($tipo_activo);
      }
      $resultado=$this->db->get()->result_array();
      return $resultado;
    }

    public function lista_adquisicion($fecha1, $fecha2, $where = null)
    {
      $this->db->select('*,
              IF(prv1.prv_id IS NULL,
              TRIM(IF(prv2.prv_tipo_pers = 1,CONCAT_WS(" ",prv2.prv_nombre,prv2.prv_apellido),IF((prv2.prv_apellido IS NULL OR TRIM(prv2.prv_apellido) = ""),prv2.prv_nombre, prv2.prv_apellido))),
              TRIM(IF(prv1.prv_tipo_pers = 1,CONCAT_WS(" ",prv1.prv_nombre,prv1.prv_apellido),IF((prv1.prv_apellido IS NULL OR TRIM(prv1.prv_apellido) = ""),prv1.prv_nombre, prv1.prv_apellido))))
                as prov,
              IFNULL(dpv_numero_documento,act_factura_compra) AS documento, are_nombre as dep
                ',false)
               ->from('act_activo_fijo')
               ->join('are_area','are_id = act_id_are', 'left')
               ->join('dxd_detalle_documento_proveedor','dxd_id_act = act_id' ,'LEFT')
               ->join('dpv_documento_proveedor','dpv_id = dxd_id_dpv', 'left')
               ->join('prv_proveedor prv1', 'prv1.prv_id = dpv_id_prv','LEFT')
               ->join('prv_proveedor prv2', 'prv2.prv_id = act_id_prv','LEFT')
               ;
      if ($fecha1) {
        $this->db->where('DATE(act_fecha_adq) >=',$fecha1);
      }
      if ($fecha2) {
        $this->db->where('DATE(act_fecha_adq) <=',$fecha2);
      }
               
      if ($where != null) {
            $this->db->where($where);
        }

      $resultado=$this->db->get()->result_array();
      return $resultado;
    } 

    public function lista_activos()
    {
      $lista=$this->db->select("*,
                  (SELECT round(sum(dep_monto), 2) FROM dep_depreciacion WHERE dep_id_act = act_id) AS depreciacion_acumulada
                  , (SELECT MAX(DATE_FORMAT(CONCAT(prd_ano,'-',prd_mes,'-','01'),'%Y-%m')) from dep_depreciacion JOIN prd_periodo_deprec on prd_id=dep_id_prd WHERE dep_id_act = act_id ) ultima_fecha_depreciacion ",false)
                  ->from('act_activo_fijo')
                  ->join('axe_activoxempleado','axe_id_act=act_id and axe_estado = 1','left')
                  ->join('emp_empleado','emp_id=axe_id_emp','left')
                  ->join('are_area','are_id=act_id_are','left')
                  ->join('suc_sucursal','suc_id=emp_id_suc','left')
                  ->group_by('act_id')->get()->result_array();
      return $lista;
    }

    public function busqueda_activos($cla,$sub,$emp,$parametro,$depto,$cec=0,$name="",$state=null){
        $query = "SELECT * FROM act_activo_fijo
            LEFT JOIN axe_activoxempleado ON axe_id_act = act_id AND axe_estado = 1
            LEFT JOIN emp_empleado ON emp_id = axe_id_emp ";
        $where = "";
        if($depto > 0){
            $where = "WHERE act_id_are = $depto ";
        }
        if($cla > 0){
            $where .= ($where != "") ? "AND " : "WHERE ";
            $where .= "act_id_tac = $cla ";
        }
        if($sub > 0){
            $where .= ($where != "") ? "AND " : "WHERE ";
            $where .= "act_id_grp = $sub ";
        }
        if($emp > 0){
            $where .= ($where != "") ? "AND " : "WHERE ";
            $where .= "axe_id_emp = $emp ";
        }
        if($state && is_array($state)){
            $estados = implode(',', $state);
            $where .= ($where != "") ? "AND " : "WHERE ";
            $where .= "act_estado IN ($estados) ";
        }
        if($cec > 0){
            $where .= ($where != "") ? "AND " : "WHERE ";
            $where .= "act_id_cec = $cec    ";
        }
        if(trim($parametro) != ""){
            $where .= ($where != "") ? "AND " : "WHERE ";
            $where .= "act_codigo LIKE '%" . trim($parametro) . "%' ";
        }
        if(trim($name) != "" && strlen($name) > 0){
            $where .= ($where != "") ? "AND " : "WHERE ";
            $where .= "act_nombre LIKE  '%" . trim($name) . "%'";
        }
        // if($cla!=0 && $sub!=0 && $emp==0 && strlen($parametro)>0){
        //     $query.=" WHERE axe_estado= 1 AND act_id_tac = ".$cla." AND act_id_grp = ".$sub." AND act_nombre LIKE '%".$parametro."%'";
        // }
        // if($cla!=0 && $sub!=0 && $emp!=0 && strlen($parametro)==0){
        //     $query.=" WHERE act_id_tac = ".$cla." AND act_id_grp = ".$sub." AND axe_id_emp = ".$emp;
        // }
        // if($cla!=0 && $sub==0 && $emp==0 && strlen($parametro)==0){
        //     $query.=" WHERE axe_estado= 1 AND act_id_tac = ".$cla;
        // }
        // if($cla==0 && $sub==0 && $emp==0 && strlen($parametro)>0){
        //     $query.=" WHERE axe_estado= 1 AND act_nombre LIKE '%".$parametro."%'";
        // }
        // if($cla==0 && $sub==0 && $emp==0 && strlen($parametro)==0 && $depto>0){
        //     $query.=" WHERE act_estado= 1 AND act_id_are =".$depto;
        // }
        $query .= $where;
        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }

    public function datos_traslados($area)
    {
      $query_activos="SELECT DISTINCT axe_id_act FROM axe_activoxempleado WHERE axe_id_are=".$area;
      $activos = $this->db->query($query_activos)->result_array();
      $traslados = array();
      foreach ($activos as $key => $value) {
        $query_traslados="SELECT * FROM axe_activoxempleado
        INNER JOIN act_activo_fijo ON act_id = axe_id_act 
        INNER JOIN emp_empleado ON emp_id = axe_id_emp
        INNER JOIN are_area ON are_id = axe_id_are
        WHERE axe_id_act=".$value['axe_id_act']." LIMIT 2";
        $resul=$this->db->query($query_traslados)->result_array();
        array_push($traslados, $resul);
      }
      return $traslados;
    }


    public function procesarProductos($nombreArchivo,$fecha,$ubicacion)
    {
            //    Abrir archivo.
      $archivo = fopen($nombreArchivo, "r") or exit("Imposible abrir archivo");
      $inf_inventario = array('inf_id_usu' => $this->tank_auth->get_user_id(),
                              'inf_id_are' => $ubicacion,
                              'inf_fecha' => $fecha,
                              'inf_usu_mod'=>$this->tank_auth->get_user_id(),
                              'inf_fecha_mod'=> date('Y:m:d h:i:s'));
      $this->db->insert('inf_inventario_fisico',$inf_inventario);

      $dif_id_inf=$this->db->insert_id();
            //    Recorrerlo.
      while (!feof($archivo))
      {       
        $linea = fgets($archivo);
        if (trim($linea) != "")
        {
          $total_activos[]=$this->separarEInsertarProducto($linea,$dif_id_inf,$ubicacion);

        }               
      }
      fclose($archivo);

      $existe_con_ubicacion=array();
      $no_existe = array();
      $existe_sin_ubicacion=array();

      foreach ($total_activos as $key => $value) {
        if(isset($value['existe_con_ubicacion'])){
          array_push($existe_con_ubicacion, $value['existe_con_ubicacion']);
        }
        elseif (isset($value['existe_sin_ubicacion'])) {
         array_push($existe_sin_ubicacion, $value['existe_sin_ubicacion']);
       }
       elseif (isset($value['no_existe'])) {
         array_push($no_existe, $value['no_existe']);
       }
     }


     if(!empty($existe_con_ubicacion)){
       $this->db->select()
                 ->from('act_activo_fijo')
                 ->join('tac_tipo_activofijo','tac_id=act_id_tac')
                 ->join('dif_detalle_inventario_fisico','dif_id_act=act_id')
                 ->join('inf_inventario_fisico','inf_id=dif_id_inf')
                 ->join('axe_activoxempleado','axe_id_act=act_id')
                 ->join('are_area','are_id=axe_id_are')
                 ->join('emp_empleado','emp_id=axe_id_emp')
                 ->where('dif_id_inf',$dif_id_inf)
                 ->where('axe_estado',1)
                 ->where_in('dif_id_act',$existe_con_ubicacion);
       
       $ingresados=$this->db->get()->result_array();
       $data['existen']=$ingresados;
     }

     if(!empty($existe_sin_ubicacion)){
       $this->db->select()
                 ->from('act_activo_fijo')
                 ->join('tac_tipo_activofijo','tac_id=act_id_tac')
                 ->where_in('act_id',$existe_sin_ubicacion); 
       $indiferentes=$this->db->get()->result_array();
       $data['existen_sin_ubicacion']=$indiferentes;
     } 

     
     $data['no_existen']=$no_existe;


     return $data;
   }
 private function separarEInsertarProducto($fila,$dif_id_inf,$ubicacion)
 {  

  $existe_con_ubicacion=$this->verificar_existencia(trim($fila));

  if(!$existe_con_ubicacion){
    $existe_sin_ubicacion=$this->verificar_existencia_en_activo(trim($fila)); 
  }

  if($existe_con_ubicacion){

    $datos = array( 'dif_id_inf'=>$dif_id_inf,
                    'dif_id_act'=>$existe_con_ubicacion['act_id'],
                    'dif_codigo'=>$fila,
                    'dif_usu_mod'=>$this->tank_auth->get_user_id(),
                    'dif_fecha_mod'=>date('Y-m-d h:i:s'));

    $this->db->insert('dif_detalle_inventario_fisico',$datos);
    $id_dif=$this->db->insert_id();

    $data['existe_con_ubicacion']=$existe_con_ubicacion['act_id'];
    
  }

  elseif ($existe_sin_ubicacion) {

   $datos = array(  'dif_id_inf'=>$dif_id_inf,
                    'dif_id_act'=>$existe_sin_ubicacion['act_id'],
                    'dif_codigo'=>$fila,
                    'dif_usu_mod'=>$this->tank_auth->get_user_id(),
                    'dif_fecha_mod'=>date('Y-m-d h:i:s'));

   $this->db->insert('dif_detalle_inventario_fisico',$datos);
   $id_dif=$this->db->insert_id();

   $data['existe_sin_ubicacion']=$existe_sin_ubicacion['act_id'];

 }

 else{

  $datos = array( 'dif_id_inf'=>$dif_id_inf,
                  'dif_codigo'=>$fila,
                  'dif_usu_mod'=>$this->tank_auth->get_user_id(),
                  'dif_fecha_mod'=>date('Y-m-d h:i:s'));
  $this->db->insert('dif_detalle_inventario_fisico',$datos);
  $id_dif=$this->db->insert_id();

  $data['no_existe']=$fila;
}     
return $data;
}

public function verificar_existencia($linea)
{
    $this->db->select('act_id')
              ->from('act_activo_fijo')
              ->join('axe_activoxempleado','axe_id_act=act_id')
              ->where('axe_estado',1)
              ->where('act_codigo',$linea);
    $resultado=$this->db->get()->row_array();
    return $resultado;
}
public function verificar_existencia_en_activo($linea)
{
    $this->db->select('act_id')
              ->from('act_activo_fijo')
              ->where('act_codigo',$linea);
    $resultado=$this->db->get()->row_array();
    return $resultado;
}

public function recuperar_inventario($inf_id,$where= null)
{
  $codigos_id=$this->db->select('dif_id_act,dif_codigo')
                       ->from('dif_detalle_inventario_fisico')
                       ->where('dif_id_inf',$inf_id)
                       ->get()->result_array();
  foreach ($codigos_id as $key => $value) {
    if(isset($value['dif_id_act']))
    {
      $act_id[]=$value['dif_id_act'];
    }
    else{
      $solo_codigo[]=$value['dif_codigo'];
    }
  }

  $existe_sin_ubicacion=array();
  $existe_con_ubicacion=array();

  foreach ($act_id as $key) {
    $con_ubicacion=$this->datos_asignacion($key,$where);
    if(!empty($con_ubicacion)){
    array_push($existe_con_ubicacion, $con_ubicacion);
  }

  if(!$con_ubicacion){
    $sin_ubicacion=$this->datos_activo($key,$where);
    array_push($existe_sin_ubicacion, $sin_ubicacion); 
  }
  }
  $data['existe_con_ubicacion']=$existe_con_ubicacion;
  $data['existe_sin_ubicacion']=$existe_sin_ubicacion;
  $data['solo_codigo']=$solo_codigo;
  return $data;
}

public function datos_asignacion($linea,$where = null)
{
  $this->db->select()
              ->from('act_activo_fijo')
              ->join('axe_activoxempleado','axe_id_act=act_id' ,'LEFT')
              ->join('emp_empleado','emp_id=axe_id_emp','LEFT')
              ->join('are_area','are_id=axe_id_are','LEFT')
              ->join('tac_tipo_activofijo','tac_id=act_id_tac','LEFT')
              ->where('axe_estado',1)
              ->where('act_id',$linea);
              if ($where) {
                $this->db->where($where);
              }
    $resultado=$this->db->get()->row_array();
    return $resultado;
}

public function datos_activo($linea,$where)
{
  $this->db->select()
              ->from('act_activo_fijo')
              ->join('tac_tipo_activofijo','tac_id=act_id_tac')
              ->where('act_id',$linea);
              if ($where) {
                $this->db->where($where);
              }
    $resultado=$this->db->get()->row_array();
    return $resultado;
}



    /**
     * Registro A-F - Obtiene listado de Tipo registros correspondientes a una tabla en 
     * especifico con un filtro de tipo where
     * @param  string $tabla Nombre de la tabla 
     * @param  array  $where Parametros a cumplir para realizar la busqueda
     * @return CI_Object_Array Array con el listado de resultados obtenidos
     */
    public function get_registros_where( $tabla = '', $where = array() )
    {
        //Verificar tabla y listado de condicionales
        if ( $tabla != ''  && is_array( $where ) ){
            //Obtiene tipos de adquisiciones
            $query_opciones_where = $this->db->get_where( $tabla, $where ); 
        }
        
        return ( is_object( $query_opciones_where ) && $query_opciones_where->num_rows() > 0 )
        ? $query_opciones_where
        : false;
    }
    
    /**
     * 
     * @author Alexis Beltran
     * @since  2013-10-01 
     */
    public function get_caracteristicas($tipo)
    {
        $query="SELECT cxt_caracteristicaxtipo.cxt_id AS cxt_id,
        CONCAT( IFNULL(cxt_nombre,''), IFNULL(cat_nombre,'')) AS nombre,
        cat_catalogo.cat_id AS padre
        FROM (cxt_caracteristicaxtipo)
        LEFT JOIN cat_catalogo ON cxt_id_cat = cat_id
        WHERE cxt_id_tac = ".$tipo;
        $resultado = $this->db->query($query);
        return $resultado->result();
        /*$this->db->select('
    cxt_caracteristicaxtipo.cxt_id As cxt_id,
  CONCAT( IFNULL(cxt_nombre,""), IFNULL(cat_nombre,"")) As nombre,
  cat_catalogo.cat_id As padre
        ');
        $this->db->join('cat_catalogo', 'cxt_id_cat = cat_id', 'left');
        return $this->db->get_where('cxt_caracteristicaxtipo', array('cxt_id_tac' => $tipo))->result();*/
    }
  /*  
    public function get_nuevo_correlativo()
    {
        $this->db->select('MAX(act_id) as nuevo');
        $raw = $this->db->get('act_activo_fijo')->row();
        return ( $raw && $raw->nuevo )? $raw->nuevo + 1 : '1';
    }
  */

    public function get_nuevo_correlativo($id_dep)
    {
        $this->db->select('COUNT(act_id) as nuevo');
        $raw = $this->db->get_where('act_activo_fijo', array('act_id_are' => $id_dep))->row();
        // $raw = $this->db->get('act_activo_fijo')->row();
        return ( $raw && $raw->nuevo )? $raw->nuevo + 1 : '1';
    }

    public function get_nuevo_codigo()
    {

    }
    
    public function get_ordenes()
    {
        $this->db->select('con_contrato.con_id,
          con_contrato.con_codigo As codigo,
          prv_proveedor.prv_nombre As proveedor,
          con_contrato.con_fecha As fecha,
          con_contrato.con_monto As monto');
        $this->db->join('prv_proveedor', 'con_id_prv = prv_id');
        $raw = $this->db->get_where('con_contrato', array('con_tipo' => 104))->result();

        
        return ( $raw )? $raw : array();
    }

    public function get_sucursales()
    {
        $query="SELECT * FROM ubi_ubicacion WHERE ubi_id_tiu = 2";
        $resultado = $this->db->query($query)->result_array();
        return $resultado;
    }

    public function get_areas()
    {
        $this->db->select()
        ->from('are_area');
        $areas=$this->db->get();
        return $areas->result_array();
    }

    public function padre_area($id)
    {
        $this->db->select()
        ->from('are_area')
        ->where('are_id',$id);
        $padre = $this->db->get();
        return $padre->result_array();
    }

    public function activoxempleado()
    {
        $query="SELECT * FROM act_activo_fijo AS activo
        LEFT JOIN axe_activoxempleado AS axe ON axe.axe_id_act = activo.act_id
        WHERE axe.axe_id_act IS NULL";
        $resultado=$this->db->query($query)->result_array();
        return $resultado;
    }

    public function empleados_con_activos($emp=null, $area=null)
    {
       /* if($emp==null){
            $query="SELECT * FROM emp_empleado AS empleado
            INNER JOIN axe_activoxempleado AS axe ON axe.axe_id_emp = empleado.emp_id
            LEFT JOIN plz_plaza AS p ON p.plz_id = empleado.emp_id_plz
            WHERE axe.axe_estado = 1 GROUP BY emp_id";
        }
        else{
            $query="SELECT * FROM emp_empleado AS empleado
            INNER JOIN axe_activoxempleado AS axe ON axe.axe_id_emp = empleado.emp_id
            INNER JOIN act_activo_fijo AS activo ON activo.act_id=axe.axe_id_act
            WHERE axe.axe_estado = 1 AND axe.axe_id_emp = ".$emp;
        }*/
          $query=$this->db->select()
             ->from('emp_empleado')
             ->join('axe_activoxempleado', 'axe_id_emp = emp_id')
             ->join('act_activo_fijo','act_id=axe_id_act')
             ->join('are_area','are_id=emp_id_are')
             ->join('plz_plaza','plz_id = emp_id_plz', 'left')
             ->where('axe_id_act IS NOT NULL', null, false)
             ->where('axe_estado >', 0);
             
            if($emp!=null){
              $this->db->where('axe_id_emp', $emp);
            }

            if($area!=null){
              $this->db->where('axe_id_are', $area);
            }

      $this->db->group_by('emp_id');
      $this->db->order_by('are_id');
      return $query->get()->result_array();


        $resultado=$this->db->query($query)->result_array();
        return $resultado;
    }

    public function get_empleados_sucursal($area)
    {
        $query="SELECT * FROM emp_empleado
                left JOIN plz_plaza ON plz_id = emp_id_plz
                WHERE emp_id_are= ".$area;
        $resultado=$this->db->query($query)->result_array();
        return $resultado;
    }

    public function get_oficinas_sucursal($suc)
    {
        $query="SELECT * FROM vw_oficina WHERE regional_id = ".$suc;
        $resultado=$this->db->query($query)->result_array();
        return $resultado;
    }

    /**
     * Registro A-F - Insertar Registros en la base de datos en una tabla especifica
     * @param  string $tabla Nombre de la tabla 
     * @param  array  $data  Datos a insertar
     * @return int id del registro insertado
     */
    public function insert_registro( $tabla = '', $data = array() )
    {   
        //Verificar datos a insertar y donde se ingresaran
        if ( $tabla != '' && is_array( $data ) ){
            //Insertar Datos
            $this->db->insert( $tabla, $data );
            $result = $this->db->insert_id();
        }else{
            //En caso de fallo
            $result = false;
        }

        return $result;
    }

    /**
     * Registro A-F - Registrar Nuevo Activo Fijo
     * @param  array  $data datos a insertar en la tabla
     * @return int    id del nuevo activo, false si hay error
     */
    public function registrar_activo( $data )
    {
        //Obtener Caracteristicas
        $caracteristicas = $data['act_caracteristicas'];
        $cov_id = $data['act_proyecto_id'];
        $con_id = $data['con_id'];
        
        //Sacar el ultimo elemento porque estorba
        array_pop( $data );
        array_pop( $data );
        array_pop( $data );

        //Registrar Activo Fijo
        $id_nuevo_activo = $this->insert_registro( 'act_activo_fijo', $data );
        
        
        //Insertar Caracteristicas
        foreach ( $caracteristicas as $caracteristica ) {
            //Formato caracteristicas = "int[id_padre], string[descripcion]"
            $data_caracteristica  = array( 
                'car_id_act'    => $id_nuevo_activo,
                'car_id_cxt'    => (int) $caracteristica->cxt_id
                );
            if( $caracteristica->cat ){
                $data_caracteristica['car_id_cat']  = (int) $caracteristica->value;
            }else{
                $data_caracteristica['car_valor']   = $caracteristica->value;
            }

            //Verificar si el ID padre fue ingresado correctamente
            if ( isset( $id_nuevo_activo ) && $id_nuevo_activo > 0 ){
                //Insertar Caracteristica
                $id_caracteristica = $this->insert_registro( 'car_caracteristica', $data_caracteristica );
            }
            
        }
        
        //Insertar proyecto Alexis Beltran 2013-09-14
        $id_cxa = $id_axc = null;
        if( $cov_id > 0 ){
            $data_axc =array(
                'axc_id_cov'    => $cov_id,
                'axc_id_act'    => $id_nuevo_activo
                );
            $id_axc = $this->insert_registro('axc_activo_fijoxconvenio', $data_axc);
        }
        
        //Insertar Orden de Compra Alexis Beltran 2013-09-14
        if( $con_id > 0 ){
            $data_axc =array(
                'cxa_id_con'    => $con_id,
                'cxa_id_act'    => $id_nuevo_activo
                );
            $id_cxa = $this->insert_registro('cxa_contratoxactivo_fijo', $data_axc);
        }

        //Resultado del registro
        return ( is_numeric( $id_nuevo_activo ) && is_numeric( $id_caracteristica ) )
        ? $id_nuevo_activo
        : false;
        
    }

    /**
     * Registro AF: Obtiene porcentaje de depreciacion por ID de tipo de depreciacion
     * @param  integer $id_tipo ID tipo de activo
     * @return json porcentaje de depreciacion
     */
    public function get_porcentaje_depreaciacion( $id_tipo = 0 )
    {
        $tipo_activo = $this->get_registros_where( 'tac_tipo_activofijo', array( 
            'tac_id' => $id_tipo
            )
        );
        //Declarar array respuesta 
        $data             = array();
        $data['response'] = true;
        $data['message']  = array();


        if ( is_object( $tipo_activo ) && $tipo_activo->num_rows() > 0 ){

            $data['message'] = array( 
                'porcentaje' => $tipo_activo->row()->tac_depreciacion
                );
        }

        return ( is_object( $tipo_activo ) && $tipo_activo->num_rows() > 0 )
        ? json_encode( $data )
        : false;
    }

    public function get_porcentaje_depreaciacion2( $id_tipo = 0 )
    {
        $tipo_activo = $this->get_registros_where( 'grp_grupo', array( 
            'grp_id' => $id_tipo
            )
        );
        //Declarar array respuesta 
        $data             = array();
        $data['response'] = true;
        $data['message']  = array();


        if ( is_object( $tipo_activo ) && $tipo_activo->num_rows() > 0 ){

            $data['message'] = array( 
                'porcentaje' => $tipo_activo->row()->grp_depreciacion
                );
        }

        return ( is_object( $tipo_activo ) && $tipo_activo->num_rows() > 0 )
        ? json_encode( $data )
        : false;
    }

    /**
     * Asignacion A-F - Obtener listado de activos fijos disponibles para asignacion
     * @return CI_Object_Array Array con el listado de resultados obtenidos
     */
    public function get_listado_asignacion()
    {
        //Consulta para obtener listado de activos fijos disponibles
        $query_activos = "SELECT *
        FROM act_activo_fijo
        WHERE act_id NOT IN
        (SELECT axe_id_act
           FROM axe_activoxempleado)";

        //Obtener resultados        
$result = $this->db->query($query_activos);

return ( is_object( $result ) && $result->num_rows() > 0 )
? $result
: false;

}


    /**
     * Asignacion A-F: Asignacion de activo fijo por empleado y area
     * @param integer $asi_empleado ID de empleado
     * @param integer $asi_area     ID de area
     * @param array   $asi_listado  Listado de ID de activo fijo
     * @param string  $asi_observacion Observaciones de la asignacion del activo
     * @return boolean
     */
    public function set_activo_fijo_x_empleado( 
        $asi_empleado = 0, 
        $asi_area = 0,
        $asi_listado = array(), 
        $asi_ubicacion, 
        $asi_observacion = '' 
        )
    {
        foreach ($asi_listado as $activo) {

            $data_axe = array (
                'axe_id_act' => $activo,
                'axe_id_emp' => $asi_empleado,
                'axe_id_are' => $asi_area,
                'axe_id_ubi' => $asi_ubicacion,
                'axe_fecha'  => (isset($_POST['fecha_ad']))? formatear_fecha('Y-m-d', $_POST['fecha_ad']):date( 'Y-m-d' ),
                'axe_obs'    => $asi_observacion,
                'axe_use_mod' => 0
                );

            $result = $this->insert_registro( 'axe_activoxempleado', $data_axe );
        }

        return ( is_numeric( $result ) ) 
        ? true
        : false;
    }

    /**
     * Asignacion A-F: Obtiene ubicaciones por ID de Area
     * @param  integer $id_area ID de area
     * @return json ID de ubicacion por ID area
     */
    public function get_ubicaciones_area( $id_area = 0 )
    {
        $query_ubicaciones =   "SELECT ubi_id
        FROM axu_areaxubicacion
        INNER JOIN are_area ON are_id = axu_id_are
        INNER JOIN ubi_ubicacion ON ubi_id = axu_id_ubi
        WHERE axu_id_are = ?";

        $query_result = $this->db->query( $query_ubicaciones, array( 'axu_id_are' => $id_area ) );

        return ( is_object( $query_result ) && $query_result->num_rows() > 0 )
        ? $query_result->row()->ubi_id
        : false;
    }

    /**
     * Traslado A-F: Obtiene detalles de activo fijo por ID 
     * @param  integer $id_activo_fijo ID de activo fijo (traslado)
     * @return json listado de detalles de activo fijo (traslado)
     */
    public function get_detalles_activo_fijo( $id_activo_fijo = 0 )
    {
        //Too lazy to repeat this, in CI
        $query_detalles = " SELECT axe_id AS tra_id,
        axe_estado AS tra_estado,
        axe_fecha AS tra_fecha,
        act_activo_fijo.* ,
        emp_id,
        emp_nombre,
        emp_apellido,
        emp_codigo,
        are_id,
        are_nombre
        FROM axe_activoxempleado
        INNER JOIN act_activo_fijo ON act_id = axe_id_act
        INNER JOIN emp_empleado ON emp_id = axe_id_emp
        INNER JOIN are_area ON are_id = axe_id_are
        WHERE axe_id = ?";

        $query_result = $this->db->query( $query_detalles, array( 'axe_id' => $id_activo_fijo ) );

        //Valor default del resultado
        $result = false;

        //Verificar la consulta retorno uno o mas registros
        if ( is_object( $query_result ) && $query_result->num_rows() > 0 ){

            //Declarar array respuesta 
            $data             = array();
            $data['response'] = true;
            $data['message']  = array();

            //Almacenar el resultado de cada fila en un array
            foreach ( $query_result->result() as $row ) {
                //construir nombre del empleado
                $nombre = $row->emp_apellidos.', '.$row->emp_nombre;
                //Mensaje de respuesta del servidor
                $data['message'] = array(
                    'id'               => $row->tra_id,
                    'estado'           => $row->tra_estado,
                    'nombre'           => $row->act_nombre,
                    'codigo'           => $row->act_codigo,
                    'descripcion'      => $row->act_desc,
                    'fecha_asignacion' => $row->tra_fecha,
                    'empleado'         => $nombre,
                    'area'             => $row->are_nombre
                    );
            }
            
            //Convertir el resultado a formato JSON
            $result = json_encode( $data );
        } 

        return $result;
    }

    /**
     * Traslado A-F: Trasladar activo fijo
     * @param array $activos       listado de activos a trasladar
     * @param integer $asignar_a     ID de persona a la que se le trasladara el activo
     * @param string $observaciones observaciones hechas a la hora del traslado
     */
    public function set_traslado_activo( $activos, $asignar_a, $observaciones = '' )
    {
        foreach ( $activos as $activo_id ) {
            //Actualizando estado del activo
            $this->db->where( 'axe_id', $activo_id );
            $this->db->update( 'axe_activoxempleado', array( 'axe_estado' => 0 ) );

            
            //Obteniendo ID de activo fijo a trasladar
            $id_activo_fijo = $this->get_registros_where( 
                'axe_activoxempleado', 
                array( 'axe_id' => $activo_id )
                )->row()->axe_id_act;

            $area = $this->get_registros_where( 'empleados', array( 'emp_id' => $asignar_a ) )
            ->row()->area;

            //Establecer data de traslado
            $data_traslado = array (
                'axe_id_act'  => $id_activo_fijo,
                'axe_id_emp'  => $asignar_a,
                'axe_id_are'  => $area,
                'axe_fecha'   => date( 'Y-m-d' ),
                'axe_obs'     => $observaciones,
                'axe_use_mod' => $this->tank_auth->get_user_id()
                );

            //Insertar traslado
            $result = $this->insert_registro( 'axe_activoxempleado', $data_traslado );
        }
        
        return ( is_numeric( $result ) )
        ? true
        : false;
    }

    /**
     * Baja A-F: Cambia el estado del activo a fijo a desactivado
     * @param integer $id_activo ID del activo fijo a desactivar
     */
    public function set_baja_activo( $id_activo = 0, $obs = null, $motivo = null, $fecha = null) {
        $actualiza = array(
            'act_id_mba'       => $motivo,
            'act_estado'       => 0,
            'act_fecha_desact' => ($fecha != '')?$fecha:date('Y-m-d H:i:s'),
            'act_obs_desact'   => $obs,
            'act_usu_modificacion' => $this->tank_auth->get_user_id(),
            'act_fecha_modificacion' => date('Y-m-d H:i:s')
        );
                  $this->db->where('act_id', $id_activo);
        $result = $this->db->update('act_activo_fijo', $actualiza);
        //Declarar array respuesta 
        $data             = array();
        $data['response'] = true;
        $data['message']  = array( 'resultado' => true );
        return ( $result ) ? $data : false;
    }
    

   /**
    * Depreciacion A-F: Obtiene listado de activos, costo, monto de depreciacion acumulado 
    * y los meses depreciados 
    * @return CI Object Array Listado de activos
    */
   public function get_listado_depreciacion($activo=null,$estado=null, $tipo_activo=null, $grupo=null, $area=null, $depreciacion=null, $fecha_inicio=null, $fecha_fin=null, $where = null,$costo_x = null, $proyecto=null)

   { 
   $where_general = array();
   $fecha_campo='act_fecha_adq';
   $estado = (is_array($estado) && count($estado)>0)? implode(',', $estado):$estado; 
    //print_r($costo_x); die();
    if($where != null){
      $where = ' and act_depreciable = 1';
      $where_general['act_depreciable'] = 1;
    } else{
      $where = '';
    }
   //print_r($estado);exit();  
    $valor_depreciable = 0;// $this->gsatelite->get_parametro('ACT_DEP_MONTO');
    ($activo != null) ? $condicion_ac=" AND act_id=".$activo : $condicion_ac="";
    ($tipo_activo > 0) ? $condicion_tac=" AND tac_id=".$tipo_activo : $condicion_tac="";
    ($grupo != null) ? $condicion_grp=" AND grp_id=".$grupo : $condicion_grp="";
    ($area != null) ? $condicion_are=" AND are_id=".$area : $condicion_are="";

    if($activo > 0 ) $where_general['act_id'] = $activo;
    if($tipo_activo > 0 ) $where_general['tac_id'] = $tipo_activo;
    if($grupo > 0 ) $where_general['grp_id'] = $grupo;
    if($area > 0 ) $where_general['are_id'] = $area;
    if($depreciacion !=null) $where_general['act_depreciable'] = $depreciacion;
    if($fecha_inicio !=null) $where_general['DATE('.$fecha_campo.') >='] = $fecha_inicio;
    if($fecha_fin !=null) $where_general['DATE('.$fecha_campo.') <='] = $fecha_fin;
    if($estado !=null) $where_general["act_estado IN (".$estado.") "] = null;
    if($costo_x > 0 ) $where_general['act_id_cec'] = $costo_x;
    if($valor_depreciable > 0 ) $where_general['act_valor_cont >='] = $valor_depreciable;
    if($proyecto > 0 ) $where_general['act_aplica_flujo_proyecto'] = 1;

        $this->db->select("act_id, act_id_are, are_nombre, tac_id, tac_nombre, grp_id, grp_nombre, act_estado,
         act_nombre, act_codigo,
         act_fecha_adq AS fecha_adquisicion,act_fecha_desact,
         act_valor_cont AS costo_bk, act_valor_compra AS costo , act_valor_compra,

         (SELECT round(sum(dep_monto), 2)
           FROM dep_depreciacion
           WHERE dep_id_act = act_id) AS depreciacion_acumulada,
         (SELECT dep_monto
           FROM dep_depreciacion
           WHERE dep_id_act = act_id LIMIT 1) AS depreciacion_mensual,
           IFNULL((SELECT ROUND(SUM(dph_monto), 2) FROM dph_depreciacion_historica WHERE dph_id_act = act_id), 0) AS depreciacion_acumulada_historico,

        (SELECT count(dep_fecha)
           FROM dep_depreciacion
           WHERE dep_id_act = act_id) AS meses_depreciados,
        (SELECT CONCAT(MIN(prd_codigo), ' - ', MAX(prd_codigo))
           FROM dep_depreciacion
           INNER JOIN prd_periodo_deprec ON prd_id = dep_id_prd
           WHERE dep_id_act = act_id) AS periodo_depreciacion,
        (SELECT COUNT(act2.act_id) from act_activo_fijo act2 WHERE act2.act_id_act_dependencia = act_activo_fijo.act_id) AS n_dependencia,
        (SELECT COUNT(dep_id) FROM dep_depreciacion WHERE dep_id_act = act_activo_fijo.act_id ) AS n_depreciaciones,
        CONCAT_WS(' ', act_codigo, act_nombre) nombre_activo
        ",false)
        ->from('act_activo_fijo')
        ->join('tac_tipo_activofijo','tac_id = act_id_tac','LEFT')
        ->join('grp_grupo','grp_id =act_id_grp','LEFT')
        ->join('are_area','are_id =act_id_are','LEFT')
        ->order_by('act_activo_fijo.act_id_are, act_activo_fijo.act_id_tac','ASC')
    ;
    if($where_general) {
      $this->db->where($where_general);
    }
  $query_result = $this->db->get();
    return ( is_object( $query_result ) && $query_result->num_rows() > 0 )      ? $query_result      : false;

    ($depreciacion != null) ? $condicion_depre=" AND act_depreciable='".$depreciacion."'" : $condicion_depre="";
    

    if ($fecha_inicio != null && $fecha_fin != null) {
      $condicion_fecha = " AND (DATE('".$fecha_campo."') >='".$fecha_inicio. "' AND DATE('".$fecha_campo."') <='".$fecha_fin. "')";

    } elseif($fecha_inicio != null) {
      
      $condicion_fecha = " AND (DATE('".$fecha_campo."') >='".$fecha_inicio. "')";
    } elseif($fecha_fin != null){
      $condicion_fecha = " AND (DATE('".$fecha_campo."') <='".$fecha_fin. "')";
    }


  
    if($estado != null){
      $query_listado .= " WHERE act_estado in (".$estado.") " . $where;
    } else{
      //$query_listado .= " WHERE (act_estado = 1 OR act_estado = -1)".$where;
      $query_listado .= " ".$where;
    }
    if ($costo_x != null) {
        $query_listado.=" AND act_id_cec = ".$costo_x;
    }
    if($valor_depreciable!=null){
      $query_listado.=" AND act_valor_cont >= ".$valor_depreciable;
    }
    if($proyecto != null){
      $query_listado.=" AND act_aplica_flujo_proyecto = 1";
    }
  

     $query_listado = "SELECT 
     act_id, act_id_are, are_nombre, tac_id, tac_nombre, grp_id, grp_nombre, act_estado,
     act_nombre, act_codigo,
     act_fecha_adq AS fecha_adquisicion,act_fecha_desact,
     act_valor_cont AS costo_bk, act_valor_compra AS costo , act_valor_compra,
     (SELECT SUM(mej.mej_valor) from mej_mejora_activo mej where mej.mej_id_act = act_id) as total_mej,
     (SELECT round(sum(dep_monto), 2)
       FROM dep_depreciacion
       WHERE dep_id_act = act_id) AS depreciacion_acumulada,
     (SELECT dep_monto
       FROM dep_depreciacion
       WHERE dep_id_act = act_id LIMIT 1) AS depreciacion_mensual,

    (SELECT count(dep_fecha)
       FROM dep_depreciacion
       WHERE dep_id_act = act_id) AS meses_depreciados,
    (SELECT COUNT(act2.act_id) from act_activo_fijo act2 WHERE act2.act_id_act_dependencia = act_activo_fijo.act_id) AS n_dependencia,
    (SELECT COUNT(dep_id) FROM dep_depreciacion WHERE dep_id_act = act_activo_fijo.act_id ) AS n_depreciaciones
    FROM act_activo_fijo
    LEFT JOIN tac_tipo_activofijo ON tac_id = act_id_tac
    LEFT JOIN grp_grupo ON grp_id =act_id_grp 
    LEFT JOIN are_area ON are_id =act_id_are
    LEFT JOIN mej_mejora_activo on mej_id_act =  act_id";

    if($estado != null){
      $query_listado .= " WHERE act_estado in (".$estado.") " . $where;
    } else{
      //$query_listado .= " WHERE (act_estado = 1 OR act_estado = -1)".$where;
      $query_listado .= " ".$where;
    }
    if ($costo_x != null) {
        $query_listado.=" AND act_id_cec = ".$costo_x;
    }
    if($valor_depreciable!=null){
      $query_listado.=" AND act_valor_cont >= ".$valor_depreciable;
    }
    if($proyecto != null){
      $query_listado.=" AND act_aplica_flujo_proyecto = 1";
    }
    
      $query_listado.=" ".$condicion_ac." ".$condicion_tac." ".$condicion_grp." ".$condicion_are. " ". $condicion_depre. " ".$condicion_fecha. " ORDER BY act_activo_fijo.act_id_are, act_activo_fijo.act_id_tac ASC ";

        //Obtener listado
      $query_result = $this->db->query( $query_listado );
      //echo $this->db->last_query();

      return ( is_object( $query_result ) && $query_result->num_rows() > 0 )      ? $query_result      : false;

      }


    /**
    * Depreciacion A-F: Obtiene listado de activos, costo, monto de depreciacion acumulado 
    * y los meses depreciados 
    * @author Carlos Alberto Noyola
    * @since 2018-03-20
    * @param $activo id del activo, $estado: estado del activo {-1,0-1}, $tipo_activo: tipo, $where: es un Custom where 
    * @param (null, array(-1,0,1), null, null)
    * @return CI Object Array Listado de activos 
    */
    public function get_listado_depreciacion_busqueda($activo = null, $array_estado = null, $tipo_activo = null,  $where = null,$codigo = null){
        $sub_query1 = "(SELECT round(sum(dep_monto), 2) FROM dep_depreciacion WHERE dep_id_act = act_id)";
        $sub_query2 = "(SELECT dep_monto FROM dep_depreciacion WHERE dep_id_act = act_id LIMIT 1)";
        $sub_query3 = "(SELECT count(dep_fecha) FROM dep_depreciacion WHERE dep_id_act = act_id)";
        $sub_query4 = "(SELECT COUNT(act2.act_id) FROM act_activo_fijo act2 WHERE act2.act_id_act_dependencia = act_activo_fijo.act_id)"; 

        $query = $this->db->select("act_id, 
            act_estado,
            concat_ws(' - ', act_codigo, act_nombre) AS nombre_activo,
            act_nombre, 
            act_codigo,
            act_fecha_adq AS fecha_adquisicion,
            act_valor_cont AS costo_bk, 
            act_valor_compra AS costo, 
            (select sum(mej.mej_valor) as total from  mej_mejora_activo mej where mej.mej_id_act = act_id)  as total_mej,
            act_valor_compra,"
            .$sub_query1." AS depreciacion_acumulada,"
            .$sub_query2." AS depreciacion_mensual,"
            .$sub_query3." AS meses_depreciados,"
            .$sub_query4." AS n_dependencia", false)
        ->from('act_activo_fijo')
        ->join('tac_tipo_activofijo', 'tac_id = act_id_tac', 'LEFT')
        ->join('grp_grupo', 'grp_id = act_id_grp', 'LEFT')
        ->join('are_area', 'are_id = act_id_are', 'LEFT')
        ->join('mej_mejora_activo', 'mej_id_act = act_id', 'LEFT');
        #Si es null o 0 no ejecuta la busqueda por ID
        if ($activo) {
            $this->db->where('act_id', $activo);
        } 
        if ($codigo !== null) {
            $this->db->where('act_codigo' , $codigo);        
        }
        if ($tipo_activo) {
            $this->db->where('tac_id', $tipo_activo);
        }
        #Si el array  tiene elementos, buscara los estados del activo que se desean
        #Se group_start() y group_end() solo funcionan en v3.0 ó superior 
        if (!empty($array_estado) and $array != null) {
            $query_where = "(";
            foreach ($array_estado as $estado) {
                #Si es el primer elemento colocara WHERE, sino colocara OR inmediatamente
                if ($estado === reset($array_estado)) {
                    $query_where .= " act_estado=".$estado ;
                } elseif ($estado === end($array_estado)) {
                    $query_where .= " OR act_estado=".$estado;
                }else{
                    $query_where .= " OR act_estado=".$estado;
                }                
            }
            $query_where = ")";
            $this->db->where($query_where, NULL, FALSE);
        }
        #$query = $this->db->get(); return $this->db->last_query();
        $query = $this->db->get();
        return $query->result();
    }

   public function get_listado_depreciacion_baja($activo=null)
   {    
    $valor_depreciable = $this->gsatelite->get_parametro('ACT_DEP_MONTO');
    ($activo != null) ? $condicion=" AND act_id=".$activo : $condicion="";
     $query_listado = "SELECT act_id, 
     concat_ws(' - ', act_codigo, act_nombre) AS nombre_activo,
     act_fecha_adq AS fecha_adquisicion,
     act_valor_cont AS costo,

     (SELECT round(sum(dep_monto), 2)
       FROM dep_depreciacion
       WHERE dep_id_act = act_id) AS depreciacion_acumulada,

(SELECT count(dep_fecha)
   FROM dep_depreciacion
   WHERE dep_id_act = act_id) AS meses_depreciados
FROM act_activo_fijo
INNER JOIN tac_tipo_activofijo ON tac_id = act_id_tac
WHERE act_estado = 0 AND act_valor_cont > ".$valor_depreciable." ".$condicion;

        //Obtener listado
$query_result = $this->db->query( $query_listado );

return ( is_object( $query_result ) && $query_result->num_rows() > 0 )
? $query_result
: false;

}

   /**
    * Depreciacion A-F: Obtiene todos los detalles relacionados a un activo por ID de activo
    * @param  integer $id_activo ID del activo
    * @return CI Array Object Resultado de la consulta 
    */
   public function get_detalles_activo_completo( $id_activo = 0 )
   {

    $query_completo =  "SELECT
  concat_ws(
    ' - ',
    act_codigo,
    act_nombre
  ) AS nombre_activo,
  act_fecha_adq AS fecha_activacion,
  grp_nombre,
  act_foto,
  are_nombre AS departamento,
  cast(
    round(act_valor_compra, 2) AS DECIMAL (8, 2)
  ) AS valor_compra, act_codigo, act_nombre,act_fecha_adq, 
  act_valor_compra, act_vida_util, act_descripcion, act_valor_residual,
  act_valor_cont AS valor_contable, act_valor_dep,
  act_porcentaje_dep AS porcentaje_anual,
  group_concat(
    -- '[] : ',
    (
      SELECT
        car_nombre
      FROM
        car_caracteristica 
      WHERE
       car_id = cxi_id_car
    ) SEPARATOR ','
  ) AS caracteristicas,
  tad_nombre AS tipo_adquicision,
  tac_nombre AS tipo_activo,
  act_vida_util AS vida_util,
  cnt_cuenta,
  CASE
WHEN emp_nombre IS NULL THEN
  'Encargado No Asignado'
WHEN emp_nombre IS NOT NULL THEN
  concat(
    emp_codigo,
    ' - ',
    emp_apellido,
    ', ',
    emp_nombre
  )
END AS nombre_empleado
FROM
  act_activo_fijo
LEFT JOIN tad_tipo_adquisicion ON tad_id = act_id_tad
LEFT JOIN tac_tipo_activofijo ON tac_id = act_id_tac
LEFT JOIN grp_grupo ON act_id_grp=grp_id
LEFT JOIN are_area ON act_id_are=are_id
LEFT JOIN axe_activoxempleado ON axe_id_act = act_id
LEFT JOIN emp_empleado ON emp_id = axe_id_emp
LEFT JOIN cxc_caracterxactivo ON cxc_id_act=act_id
LEFT JOIN cxi_caracteristicaxtipo ON cxi_id_tac=tac_id
LEFT JOIN car_caracteristica ON car_id = cxi_id_car
LEFT JOIN dtv_detalle_tipo_activo ON dtv_id_tac=tac_id
LEFT JOIN cnt_cuenta_contable ON cnt_id= dtv_id_cnt
WHERE
  act_id = ".$id_activo;


        //Obtener resultados de la consulta
$query_result = $this->db->query($query_completo, array( 'act_id' => $id_activo ) );

return ( is_object( $query_result ) && $query_result->num_rows() > 0 )
? $query_result
: false;
}

   /**
    * Despreciacion A-F: Calcula los meses y cargos de depreciacion por activo fijo ID
    * @param  integer $id_activo ID del activo fijo
    * @return CI Array Object
    */
   public function get_depreciacion_acumulada( $id_activo = 0 )
   {
    $query_acumulada = "SELECT dep_id, dep_fecha AS fecha_depreciacion, prd_mes AS periodo, 
    prd_ano AS anio, round(dep_monto, 4) AS monto_depreciacion,
    act_valor_cont AS valor_contable, act_valor_compra, act_vida_util,
    last_day(concat_ws('-',prd_ano,prd_mes,'01')) periodo_dep,
     (SELECT sum(dep_monto)
       FROM dep_depreciacion
       WHERE dep_id_act = act_id) AS depreciacion_acumulada
    FROM dep_depreciacion
    INNER JOIN act_activo_fijo ON act_id=dep_id_act
    LEFT JOIN prd_periodo_deprec ON prd_id = dep_id_prd
    WHERE dep_estado = 1 ";
    $query_acumulada.=" AND dep_id_act = ".$id_activo. " ORDER BY last_day(concat_ws('-',prd_ano,prd_mes,'01')) asc";

        //Obtener resultados de la consulta
    $query_result = $this->db->query($query_acumulada)->result_array();
    
    return $query_result;
}

    public function get_depreciacion_acumulada_historico($id_act = 0){
        $queryh = "SELECT pool.*,act_valor_cont AS valor_contable, act_valor_compra, act_vida_util FROM (
            SELECT dep_id_act AS idact, dep_fecha AS fecha_depreciacion, prd_mes AS periodo, prd_ano AS anio, round(dep_monto, 4) AS monto_depreciacion,
                LAST_DAY(CONCAT_WS('-', prd_ano, prd_mes, '01')) AS periodo_dep, IFNULL(dep_monto, 0) AS montoD, NULL AS montoH,
                (SELECT SUM(dep_monto) FROM dep_depreciacion WHERE dep_id_act = $id_act) AS depreciacion_acumulada
                FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_id_act = $id_act AND dep_estado = 1
            UNION ALL
            SELECT dph_id_act AS idact, dph_fecha AS fecha_depreciacion, prd_mes AS periodo, prd_ano AS anio, round(dph_monto, 4) AS monto_depreciacion,
                LAST_DAY(CONCAT_WS('-', prd_ano, prd_mes,'01')) AS periodo_dep, NULL AS montoD, IFNULL(dph_monto, 0) AS montoH,
                (SELECT SUM(dph_monto) FROM dph_depreciacion_historica WHERE dph_id_act = $id_act) AS depreciacion_acumulada
                FROM dph_depreciacion_historica JOIN prd_periodo_deprec ON prd_id = dph_id_prd WHERE dph_id_act = $id_act AND dph_estado = 1
        ) AS pool JOIN act_activo_fijo ON act_id = idact ORDER BY periodo_dep ASC;";
        $query_result = $this->db->query($queryh)->result_array();
        return $query_result;
    }

    public function get_depreciacion_acumulada_historico_anual($id_act = 0){
        $queryh = "SELECT pool.*, act_valor_cont AS valor_contable, act_valor_compra, act_vida_util, SUM(pool.monto_depreciacion) AS depanual, 
        MAX(periodo_dep) AS max_prd  FROM (
            SELECT dep_id_act AS idact, dep_fecha AS fecha_depreciacion, prd_mes AS periodo, prd_ano AS anio, round(dep_monto, 4) AS monto_depreciacion,
                LAST_DAY(CONCAT_WS('-', prd_ano, prd_mes, '01')) AS periodo_dep, IFNULL(dep_monto, 0) AS montoD, NULL AS montoH,
                (SELECT SUM(dep_monto) FROM dep_depreciacion WHERE dep_id_act = $id_act) AS depreciacion_acumulada
                FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_id_act = $id_act AND dep_estado = 1
            UNION ALL
            SELECT dph_id_act AS idact, dph_fecha AS fecha_depreciacion, prd_mes AS periodo, prd_ano AS anio, round(dph_monto, 4) AS monto_depreciacion,
                LAST_DAY(CONCAT_WS('-', prd_ano, prd_mes,'01')) AS periodo_dep, NULL AS montoD, IFNULL(dph_monto, 0) AS montoH,
                (SELECT SUM(dph_monto) FROM dph_depreciacion_historica WHERE dph_id_act = $id_act) AS depreciacion_acumulada
                FROM dph_depreciacion_historica JOIN prd_periodo_deprec ON prd_id = dph_id_prd WHERE dph_id_act = $id_act AND dph_estado = 1
        ) AS pool JOIN act_activo_fijo ON act_id = idact GROUP BY pool.anio ORDER BY periodo_dep ASC;";
        $query_result = $this->db->query($queryh)->result_array();
        return $query_result;
    }

public function get_activosxclasificacion($clasificacion = null, $grupo = null, $departamento = null,$estado = null,$costo = null)
{
  
  $query="SELECT act_id, 
  act_nombre AS nombre,
  act_codigo AS codigo,
  act_fecha_adq AS fecha_adquisicion,
  act_valor_cont AS costo,
  (SELECT round(dep_monto, 2)
    FROM dep_depreciacion
    WHERE dep_id_act = act_id LIMIT 1) AS depreciacion_mes,

  (SELECT round(sum(dep_monto), 2)
    FROM dep_depreciacion
    WHERE dep_id_act = act_id) AS depreciacion_acumulada,

(SELECT count(dep_fecha)
 FROM dep_depreciacion
 WHERE dep_id_act = act_id) AS meses_depreciados
FROM act_activo_fijo
INNER JOIN tac_tipo_activofijo ON tac_id = act_id_tac
WHERE act_estado = ".$estado."";
if ($clasificacion) {
  $query.=" AND act_id_tac=".$clasificacion;
}
if($grupo != null){
  $query.=" AND act_id_grp=".$grupo;
}
//Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
if($departamento != null){
  $query.=" AND act_id_are=".$departamento;
}
if ($costo !== null) {
    $query.=" AND act_id_cec=".$costo;
}

$valores= $this->db->query($query)->result_array();
return $valores;
}

   /**
    * Depreciacion A-F: Generacion de simulacion de depreciacion de activo fijo por ID de activo
    * @param  integer $id_activo ID de activo fijo
    */
   public function generar_simulacion( $id_activo, $nmeses=0  ){
    $query_simulacion = "SELECT act_id,
    concat_ws(' - ', act_codigo, act_nombre) AS nombre_activo,
    act_fecha_inicia_dep AS act_fecha_inicia_dep,
    act_valor_cont AS costo_bk,
    act_valor_compra AS costo,
    IFNULL(act_valor_residual,0) AS act_valor_residual,
    act_vida_util AS vida_util,
    tac_vida_util AS vida_util_bk,
    (tac_vida_util * 12) AS numero_meses_bk,
    (act_vida_util * 12) AS numero_meses
    FROM act_activo_fijo
    INNER JOIN tac_tipo_activofijo ON tac_id = act_id_tac
    WHERE act_estado = 1 AND act_id = ?";
    //borrar la simulación existente para regenerar la nueva.
    $this->gsatelite->borrado_general('des_simulacion_dep',array('des_id_act'=>$id_activo));

    $query_result = $this->db->query( $query_simulacion, array( 'act_id' => $id_activo ) );

    if ( is_object( $query_result ) && $query_result->num_rows() > 0 ){

        $query_verificar = $this->get_registros_where( 'des_simulacion_dep', array( 'des_id_act' => $id_activo ) );

        $data_simulacion = array();

            //Verificar si ya se genero una simulacion para este activo fijo
        if ( !is_object( $query_verificar ) ){

                //Obtener la los valores de la fila actual
            $activo_detalles = $query_result->row();

                //Calcular la depreciacion mensual
            $depreciacion_mensual = round( ( ($activo_detalles->costo - $activo_detalles->act_valor_residual)/ $activo_detalles->numero_meses ), 4);

                //Fecha sepcionada
            //print_r($activo_detalles); exit;
            //die($activo_detalles->act_fecha_inicia_dep);
            if ($activo_detalles->act_fecha_inicia_dep) {
                $year  = formatear_fecha('Y', $activo_detalles->act_fecha_inicia_dep); //date( 'Y' );
                $month = formatear_fecha('m', $activo_detalles->act_fecha_inicia_dep); //date( 'm' );
                $day   = formatear_fecha('d', $activo_detalles->act_fecha_inicia_dep); //date( 'd' );
                $fecha_cargo = $year.'-'.$month.'-'.$day;

                $dayInicio = intval(formatear_fecha('t', $activo_detalles->act_fecha_inicia_dep)) - intval($day);
                $nveces = ($activo_detalles->numero_meses + $nmeses);
                $cuota_uno = ($day!='01')? (($depreciacion_mensual / 30) * intval($dayInicio)) : $depreciacion_mensual; 
                $cuota_fin = ($day!='01')? ($depreciacion_mensual - $cuota_uno):$depreciacion_mensual;
                //Insertar depreciacion por cada mes
                for ( $i=1; $i <= ($activo_detalles->numero_meses + $nmeses); $i++ ) { 

                    //Contador de meses 
                    if ( $month == 13 ){
                        $month = 1;
                        $year++;
                    }
                    //Fecha de cargo 
                    $fecha_cargo = $year.'-'.$month.'-'.$day;        


                    //Datos a insertar
                $data_simulacion = array (
                    'des_id_act' => $id_activo,
                    'des_monto'  => ($i==1) ? $cuota_uno : (($i==$nveces) ? $cuota_fin : $depreciacion_mensual),
                    'des_fecha'  =>  formatear_fecha('Y-m-t', $fecha_cargo)
                );

                    //Insertar depreciacion
                $this->insert_registro( 'des_simulacion_dep', $data_simulacion );
                    //Incrementar mes
                $month++;
                    //Formatear mes
                if ( $month < 10 ){ $month = '0'.$month; }
            }

          }

        }
    }
}

    /**
     * Depreciacion A-F: Obtiene la diferencia en meses de un rango de fechas determinado
     * @param  date $inicio Inicio rango de fecha
     * @param  date $fin    Fin rango de fecha
     * @return CI Query Object Diferencia en meses de los rangos de fecha
     */
    public function get_diferencia_meses( $inicio, $fin )
    {
        //Query
        $this->query ="SELECT TIMESTAMPDIFF(MONTH, ?, ?) as meses";

        //Set rango de fechas
        $data = array($inicio, $fin);

        //Run query 
        $result = $this->db->query( $this->query, $data )->row();

        return $result;
    }

    /**
     * Depreciacion A-F: Obtiene listado de depreciaciones por ID de activo fijo 
     * @param  integer $id_activo    ID del activo fijo
     * @param  string  $fecha_inicio Inicio del rango de fechas
     * @param  string  $fecha_fin    Fin del rango de fechas
     * @param  int  $agrupar    0=mensual, anual
     * @return json datos necesarios para la generacion de tabla de depreciaciones
     */
    public function get_datos_simulacion( $id_activo = 0, $fecha_inicio = "", $fecha_fin = "" , $agrupar = 0){
        $where_query['des_id_act'] =  $id_activo;
        if (trim($fecha_inicio) != '') {
            $where_query['des_fecha >='] =  $fecha_inicio;
        }
        if (trim($fecha_fin) != '') {
            $where_query['des_fecha <='] =  $fecha_fin;
        }
        $where_query['des_id_act'] =  $id_activo;
        if ($agrupar) { //hacerlo agrupado de forma anual
            $datos_simulacion = $this->db->select("SUM(IFNULL(des_monto,0)) des_monto, CONCAT_WS(' / ',DATE_FORMAT(MIN(des_fecha),'%d-%m-%Y'),DATE_FORMAT(MAX(des_fecha),'%d-%m-%Y')) des_fecha, DATE_FORMAT(MAX(des_fecha),'%d-%m-%Y') ultima_fecha ", false)
                        ->from('des_simulacion_dep')
                        ->where($where_query)
                        ->group_by('(YEAR(des_fecha))')
                        ->get()
                        ; 
        } else {
            //$datos_simulacion = $this->get_registros_where('des_simulacion_dep', $where_query );
            $datos_simulacion = $this->db->select("des_id, des_id_act, des_monto, DATE_FORMAT(des_fecha,'%d-%m-%Y') des_fecha, DATE_FORMAT(des_fecha,'%d-%m-%Y') ultima_fecha", false)
                    ->from('des_simulacion_dep')
                    ->where($where_query)
                    ->get()
                    ; 
        }
        $numero_iteraciones = $this->get_diferencia_meses( $fecha_inicio, $fecha_fin );
        $data = array();
        $data['response'] = false;
        $data['message']  = array();
        $data['cantidad'] = $numero_iteraciones->meses;        
        //Verificar si hay resultados
        if ( is_object( $datos_simulacion ) && $datos_simulacion->num_rows() > 0 ){
            //Cambiar respuesta del servidor
            $data['response'] = true;
            //Almacenar los resultados
            foreach ( $datos_simulacion->result() as $row ) {
                $data['message'][] = array(
                    'fecha' => $row->des_fecha, 
                    'monto' => $row->des_monto,
                    'ultima_fecha' => $row->ultima_fecha
                    );
            }
        }
        return ( is_object( $datos_simulacion ) && $datos_simulacion->num_rows() > 0 ) ? json_encode( $data ) : false;
    } // End get_datos_simulados

    public function get_caracteristicaxactivo($id_activo=0)
    {
          $this->db->select('car_nombre, cxc_valor, cxc_estado')
                    ->from('cxc_caracterxactivo')
                    ->join('cxi_caracteristicaxtipo', 'cxi_id = cxc_id_cxi')
                    ->join('car_caracteristica', 'car_id = cxi_id_car')
                    ->where('cxc_id_act',$id_activo)
                    ->where('cxc_estado',1)
                    ;
          $query = $this->db->get()->result_array();                          
          return $query;
    } // End get_caracteristicaxactivo


    public function get_activo($id_activo){
        $this->db->select()
                ->from('act_activo_fijo')
                ->join('grp_grupo', 'act_id_grp=grp_id')
                ->join('tad_tipo_adquisicion','tad_id=act_id_tad','left')
                ->join('tac_tipo_activofijo','tac_id=act_id_tac','left')
                ->join('are_area','are_id=act_id_are','left')
               // ->join('con_contrato','con_id=act_id_con','left')
               // ->join('prv_proveedor','prv_id=con_id_prv','left')
                ->where('act_id',$id_activo);

            $query=$this->db->get()->row_array();
            return $query;
    }

    public function foto_activo($id_act)
{
    $query=$this->db->select()
            ->from('act_activo_fijo')
            ->join('axa_anexoxactivo','act_id = axa_id_act')
            ->join('anx_anexo','anx_id = axa_id_anx')
            //->where('anx_imagen',1)
            ->where('act_id',$id_act);
    $resultado = $this->db->get();
    return $resultado->result_array();
}

  public function reporte_activos_area($id_area) {
    $query="SELECT
                * , (
                    SELECT
                        round(
                            sum(dep_monto),
                            2)
                        FROM
                            dep_depreciacion
                        WHERE
                            dep_id_act = act_id
                        ) AS depreciacion_acumulada
                
            FROM
                act_activo_fijo
            LEFT JOIN axe_activoxempleado ON axe_id_act = act_id and axe_estado=1
            LEFT JOIN emp_empleado ON axe_id_emp = emp_id
            LEFT JOIN are_area ON axe_id_are = are_id
            WHERE
                act_id_are =".$id_area."
            AND act_estado = 1";
        $lista=$this->db->query($query)->result_array();
        return $lista;
  }

  //
  public function reporte_activos_area2($area,$fecha_ini,$fecha_fin,$depreciacion) {
    $query="SELECT
                * , (
                    SELECT
                        round(
                            sum(dep_monto),
                            2)
                        FROM
                            dep_depreciacion
                        WHERE
                            dep_id_act = act_id
                        ) AS depreciacion_acumulada
                
            FROM
                act_activo_fijo
            LEFT JOIN axe_activoxempleado ON axe_id_act = act_id and axe_estado=1
            LEFT JOIN emp_empleado ON axe_id_emp = emp_id
            LEFT JOIN are_area ON axe_id_are = are_id
            WHERE
                act_estado = 1
                AND act_fecha_adq >= '". $fecha_ini."' AND '".$fecha_fin."'"
                ;
        if ($depreciacion != null){
            $query.=  " AND act_depreciable = '".$depreciacion ."'";
        }

        if ($area != null){
            $query.=  " AND act_id_are = '".$area."'";
        }

        $lista=$this->db->query($query)->result_array();

        return $lista;
  }

  public function listado_asignacion(){
      $query=$this->db->select()
             ->from('act_activo_fijo')
             ->join('axe_activoxempleado', 'axe_id_act = act_id')
             ->join('emp_empleado','axe_id_emp=emp_id')
             ->join('are_area','are_id=axe_id_are', 'left');
      $this->db->group_by('emp_id');
      $this->db->order_by('are_id');
      return $query->get()->result_array();
  }

    function activoxarea($area=null, $asig=null, $usados=null, $not=null,$suc = null){
        $query=$this->db->select()
            ->from('act_activo_fijo')
            ->join('are_area','are_id=act_id_are')
            ->join('axe_activoxempleado', 'axe_id_act = act_id', 'left')
            ->join('emp_empleado','axe_id_emp=emp_id', 'left')
            ->where('act_estado',1)
        ;
        if($not==null){
            if($asig!=null){
                $this->db->where('axe_id_act IS NOT NULL', null, false);
            }else{
                $this->db->where('axe_id_act IS NULL', null, false);
            }
        }

        if($area!=null){
            $this->db->where('are_id',$area);
        }
        if ($suc != null) {
            $this->db->where(array('act_id_suc' => $suc));
        }
        if($usados!=''){
            $this->db->or_where_in('axe_id_act', $usados);
        }
        $this->db->group_by('act_id');
        return $query->get()->result_array();
    }

    public function listado_traslado(){
      $query=$this->db->select()
             ->from('act_activo_fijo')
             ->join('axe_activoxempleado', 'axe_id_act = act_id', 'left')
             ->join('emp_empleado','axe_id_emp=emp_id')
             ->join('are_area','are_id=axe_id_are', 'left')
             ->where('axe_id_act IS NOT NULL', null, false)
             ->where('axe_id_act IN (select axe_id_act from axe_activoxempleado ax WHERE axe_estado = 0)', null, false)
             ->where('axe_estado',1)
             ;
      $this->db->group_by('emp_id');
      $this->db->order_by('are_id');
      return $query->get()->result_array();
  }

    public function lista_pdte_asignar($id){
        $query=$this->db->select()
            ->from('axs_activo_solicitud')
            ->join('act_activo_fijo', 'act_id = axs_id_act')
            ->join('slt_solicitud_activos', 'slt_id = axs_id_slt')
            ->join('emp_empleado', 'emp_id = slt_id_emp')
            ->where('axs_id_slt', $id)
            ->order_by('act_id')
        ;
        return $query->get()->result_array();
    }

  public function get_usuario_traslado(){
      $query=$this->db->select()
             ->from('act_activo_fijo')
             ->join('axe_activoxempleado', 'axe_id_act = act_id', 'left')
             ->join('emp_empleado','axe_id_emp=emp_id')
             ->join('are_area','are_id=axe_id_are', 'left')
             ->where('axe_id_act IS NOT NULL', null, false)
             ->where('axe_id_act IN (select axe_id_act from axe_activoxempleado ax WHERE axe_estado = 0)', null, false)
             ->where('axe_estado',1)
             ;
      $this->db->group_by('emp_id');
      $this->db->order_by('are_id');
      return $query->get()->result_array();
      /*
        select emp_nombre, ( SELECT count(axe_id_act) from axe_activoxempleado a WHERE a.axe_id_act = act_id ) as veces
from emp_empleado
join axe_activoxempleado on emp_id = axe_id_emp
join act_activo_fijo on act_id = axe_id_act
GROUP BY emp_id
having veces > 1
      */
  }

  function activoxarea_trs($area=null, $emp=null, $usados=null){
    // $query=$this->db->select()
    //            ->from('act_activo_fijo')
    //            ->join('are_area','are_id=act_id_are')
    //            ->join('axe_activoxempleado', 'axe_id_act = act_id', 'left')
    //            ->join('emp_empleado','axe_id_emp=emp_id', 'left');

    //           $this->db->where('axe_id_act IS NOT NULL', null, false);
// $area=null;
    $query=$this->db->select("axe_id_emp AS 'emp_ids', CONCAT(emp_nombre,' ', emp_apellido) AS 'responsables', act_codigo, act_nombre, act_valor_cont, act_id",false)
               ->from("act_activo_fijo")
               ->join("are_area","are_id=act_id_are")
               ->join("axe_activoxempleado", "axe_id_act=act_id", "left")
               ->join("emp_empleado","axe_id_emp=emp_id", "left");

              $this->db->where('axe_id_act IS NOT NULL', null, false);
             

    if($area!=null && $usados!=null){
      $this->db->where('axe_id_are = '.$area.' OR axe_id_act IN ('.$usados.')', null, false);
    }else if($area!=null && $usados==null){
      $this->db->where('axe_id_are', $area);
    }

    if($emp!=null && $usados!=null){
       $this->db->where('axe_id_emp = '.$emp.' OR axe_id_act IN ('.$usados.')', null, false);
    }else if($emp!=null && $usados==null){
      $this->db->where('axe_id_emp', $emp);
    }
    if($usados!=''){
      //$this->db->or_where_in('axe_id_act', $usados);
    }

     $this->db->where('axe_estado', 1)->group_by("act_id");

    return $query->get()->result_array();
  }

    function activo_report($act,$emp_id){
        $query=$this->db->select('*, (SELECT COUNT(a.axe_id_act) FROM axe_activoxempleado AS a WHERE	a.axe_id_act = act_id) veces, 
            (SELECT GROUP_CONCAT(CONCAT(car_nombre,": ", cxc_valor) SEPARATOR "; ") FROM cxc_caracterxactivo JOIN cxi_caracteristicaxtipo ON cxi_id = cxc_id_cxi 
            JOIN car_caracteristica ON car_id = cxi_id_car WHERE cxc_id_act = act_id) AS caracteristicas', false)
               ->from('axe_activoxempleado')
               ->join('act_activo_fijo','act_id = axe_id_act')
               ->join('emp_empleado', 'emp_id = axe_id_emp')
               ->join('are_area','are_id = emp_id_are');
        $this->db->where_in('act_id', $act);
        $this->db->where('axe_estado',1);
        $this->db->where('axe_id_emp',$emp_id);
        $this->db->order_by('act_codigo','asc');
        return $query->get()->result();
    }

    public function get_reporte_codigo_activo($where = null){
       $query = $this->db->select()
                ->from('act_activo_fijo')
                ->join('are_area','are_id = act_id_are')
                ->join('grp_grupo', 'grp_id = act_id_grp')
                ->join('suc_sucursal', 'suc_id = are_id_suc', 'left')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_detalle_rpte_compra_activos($where = null, $car_ids){
        $car_ids = ($car_ids != "") ? $car_ids : 0;
        $query = $this->db->select("act_id, IFNULL(act_id_are, 0) AS are_id, IFNULL(are_nombre, '--') AS are_nombre, act_codigo, act_nombre, act_valor_compra,
                act_fecha_adq, act_valor_cont, IFNULL((SELECT SUM(dep_monto) FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd 
                WHERE dep_estado = 1 AND dep_id_act = act_id AND prd_codigo <= DATE_FORMAT(CURDATE(),'%Y%m')), 0) AS depreciacion, 
                IFNULL((SELECT GROUP_CONCAT(DISTINCT CONCAT_WS('#', cxi_id_car, cxc_valor) SEPARATOR '@#@') FROM cxc_caracterxactivo JOIN cxi_caracteristicaxtipo ON cxi_id = cxc_id_cxi 
                WHERE cxc_estado = 1 AND cxc_id_act = act_id AND cxi_id_tac = act_id_tac AND cxi_id_car IN ($car_ids)), '') AS caracteristics", false)
            ->from('act_activo_fijo')
            ->join('are_area','are_id = act_id_are', 'left')
            ->order_by('act_id_are')
            ->where('act_estado', 1)
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_detalle_rpte_activos_baja($where = null, $car_ids){
        $car_ids = ($car_ids != "") ? $car_ids : 0;
        $query = $this->db->select("act_id, mba_id, act_codigo, act_nombre, act_descripcion, act_fecha_desact, mba_nombre, act_obs_desact, IFNULL((SELECT are_nombre FROM are_area 
            WHERE are_id = act_id_are), 'No Asignada') AS are_nombre, act_fecha_adq, act_valor_compra, act_valor_cont, IFNULL((SELECT SUM(dep_monto) FROM dep_depreciacion 
            JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_estado = 1 AND dep_id_act = act_id AND prd_codigo <= DATE_FORMAT(CURDATE(), '%Y%m')), 0) AS depreciacion,
            IFNULL((SELECT GROUP_CONCAT(DISTINCT CONCAT_WS('#', cxi_id_car, cxc_valor) SEPARATOR '@#@') FROM cxc_caracterxactivo JOIN cxi_caracteristicaxtipo ON cxi_id = cxc_id_cxi 
            WHERE cxc_estado = 1 AND cxc_id_act = act_id AND cxi_id_tac = act_id_tac AND cxi_id_car IN ($car_ids)), '') AS caracteristics, act_valor_residual", false)
            ->from('act_activo_fijo')
            ->join('mba_motivo_baja_activo', 'mba_id = act_id_mba', 'left')
            ->order_by('act_fecha_desact')
            ->where('act_estado', 0)
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_detalle_rpte_asgn_act($where = null, $car_ids){
        $car_ids = ($car_ids != "") ? $car_ids : 0;
        $query = $this->db->select("act_depreciable, act_id, emp_id, are_id, act_codigo, act_nombre, emp_codigo, CONCAT(emp_nombre, ' ', emp_apellido) AS emp_nombre, 
                are_nombre, act_fecha_adq,  act_valor_compra, act_valor_cont, axe_fecha, IFNULL((SELECT SUM(dep_monto) FROM dep_depreciacion 
                JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_estado = 1 AND dep_id_act = act_id AND prd_codigo <= DATE_FORMAT(CURDATE(), '%Y%m')), 0) AS depreciacion, 
                IFNULL((SELECT GROUP_CONCAT(DISTINCT CONCAT_WS('#', cxi_id_car, cxc_valor) SEPARATOR '@#@') FROM cxc_caracterxactivo JOIN cxi_caracteristicaxtipo ON cxi_id = cxc_id_cxi 
                WHERE cxc_estado = 1 AND cxc_id_act = act_id AND cxi_id_tac = act_id_tac AND cxi_id_car IN ($car_ids)), '') AS caracteristics", false)
            ->from('axe_activoxempleado')
            ->join('act_activo_fijo','act_id = axe_id_act')
            ->join('are_area','are_id = axe_id_are')
            ->join('emp_empleado','emp_id = axe_id_emp')
            ->order_by('act_depreciable DESC, act_id ASC')
            ->where('act_estado', 1)
            ->where('axe_estado', 1)
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_detalle_rpte_trasl_asgn($where = null, $car_ids){
        $car_ids = ($car_ids != "") ? $car_ids : 0;
        $query = $this->db->select("act_id, axe_fecha, are_id, emp_id, act_codigo, act_nombre, axe_estado, emp_codigo, CONCAT(emp_nombre,' ',emp_apellido) AS emp_nombre, act_valor_cont, 
                are_nombre, act_valor_compra, IFNULL((SELECT are_nombre FROM are_area WHERE are_id = act_id_are),'') AS area_compra, IFNULL((SELECT SUM(dep_monto) FROM dep_depreciacion 
                JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_estado = 1 AND dep_id_act = act_id AND prd_codigo <= DATE_FORMAT(CURDATE(), '%Y%m')), 0) AS depreciacion, 
                IFNULL((SELECT GROUP_CONCAT(DISTINCT CONCAT_WS('#', cxi_id_car, cxc_valor) SEPARATOR '@#@') FROM cxc_caracterxactivo JOIN cxi_caracteristicaxtipo ON cxi_id = cxc_id_cxi 
                WHERE cxc_estado = 1 AND cxc_id_act = act_id AND cxi_id_tac = act_id_tac AND cxi_id_car IN ($car_ids)), '') AS caracteristics", false)
            ->from('axe_activoxempleado')
            ->join('act_activo_fijo','act_id = axe_id_act')
            ->join('are_area','are_id = axe_id_are')
            ->join('emp_empleado','emp_id = axe_id_emp')
            ->order_by('act_id, axe_fecha')
            ->where('act_estado', 1)
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_detalle_rpte_activos_grupo($where = null, $car_ids){
        $car_ids = ($car_ids != "") ? $car_ids : 0;
        $query = $this->db->select("grp_id, act_id, grp_codigo, grp_nombre, IFNULL(are_nombre, '--') AS are_nombre, act_codigo, act_nombre, act_valor_compra, 
            act_fecha_adq, (SELECT tac_nombre FROM tac_tipo_activofijo WHERE tac_id = grp_id_tac) AS tac_nombre, act_valor_cont, 
            IFNULL(
                IFNULL((SELECT SUM(dep_monto) FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_estado = 1 AND dep_id_act = act_id 
                AND prd_codigo <= DATE_FORMAT(CURDATE(), '%Y%m')), 0)
                +
                IFNULL((SELECT SUM(dph_monto) FROM dph_depreciacion_historica JOIN prd_periodo_deprec ON prd_id = dph_id_prd WHERE dph_estado = 1 AND dph_id_act = act_id AND prd_codigo <= DATE_FORMAT(CURDATE(), '%Y%m')) ,0)
            , 0) AS depreciacion, 
            IFNULL((SELECT GROUP_CONCAT(DISTINCT CONCAT_WS('#', cxi_id_car, cxc_valor) SEPARATOR '@#@') FROM cxc_caracterxactivo JOIN cxi_caracteristicaxtipo 
                ON cxi_id = cxc_id_cxi WHERE cxc_estado = 1 AND cxc_id_act = act_id AND cxi_id_tac = act_id_tac AND cxi_id_car IN ($car_ids)),'') AS caracteristics",
            false)
            ->from('act_activo_fijo')
            ->join('grp_grupo','grp_id = act_id_grp')
            ->join('are_area','are_id = act_id_are', 'left')
            ->order_by('act_id_grp')
            ->where('act_estado', 1)
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_det_rpte_act_x_tipo($where = null, $car_ids){
        $car_ids = ($car_ids != "") ? $car_ids : 0;
        $query = $this->db->select("IFNULL(act_id_are,0) AS act_id_are, act_id_tac, tac_codigo, tac_nombre, act_codigo, act_nombre, act_valor_compra, act_fecha_adq, act_valor_cont, IFNULL((SELECT are_nombre FROM are_area WHERE are_id = act_id_are), 'No Asignada') AS are_nombre,
            IFNULL(
                IFNULL((SELECT SUM(dep_monto) FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_estado = 1 AND dep_id_act = act_id 
                AND prd_codigo <= DATE_FORMAT(CURDATE(), '%Y%m')), 0)
                +
                IFNULL((SELECT SUM(dph_monto) FROM dph_depreciacion_historica JOIN prd_periodo_deprec ON prd_id = dph_id_prd WHERE dph_estado = 1 AND dph_id_act = act_id AND prd_codigo <= DATE_FORMAT(CURDATE(), '%Y%m')) ,0)
            , 0) AS depreciacion,
            IFNULL((SELECT GROUP_CONCAT(DISTINCT CONCAT_WS('#', cxi_id_car, cxc_valor) SEPARATOR '@#@') FROM cxc_caracterxactivo JOIN cxi_caracteristicaxtipo ON cxi_id = cxc_id_cxi 
                WHERE cxc_estado = 1 AND cxc_id_act = act_id AND cxi_id_tac = act_id_tac AND cxi_id_car IN ($car_ids)), '') AS caracteristics", false)
            ->from('act_activo_fijo')
            ->join('tac_tipo_activofijo','tac_id = act_id_tac')
            ->order_by('act_id_are, act_id_tac')
            ->where('act_estado', 1)
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_det_rpte_act_x_cta_adq($where = null, $car_ids){
        $car_ids = ($car_ids != "") ? $car_ids : 0;
        $query = $this->db->select("act_depreciable, IFNULL(cnt_id,0) AS cnt_id, IFNULL(cnt_cuenta,'') AS cnt_cuenta, cnt_nombre, act_codigo, act_valor_compra, 
                    act_nombre, act_fecha_adq, act_valor_cont, IFNULL((SELECT are_nombre FROM are_area WHERE are_id = act_id_are), 'No Asignada') AS are_nombre, 
                    IF(act_id_tad IS NULL, '', CONCAT(' (',(SELECT tad_nombre FROM tad_tipo_adquisicion WHERE tad_id = act_id_tad),')')) AS tipo_compra, 
                    IFNULL((SELECT SUM(dep_monto) FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_estado = 1 AND dep_id_act = act_id 
                    AND prd_codigo <= DATE_FORMAT(CURDATE(), '%Y%m')), 0) AS depreciacion, IFNULL((SELECT GROUP_CONCAT(DISTINCT CONCAT_WS('#', cxi_id_car, cxc_valor) SEPARATOR '@#@') 
                    FROM cxc_caracterxactivo JOIN cxi_caracteristicaxtipo ON cxi_id = cxc_id_cxi WHERE cxc_estado = 1 AND cxc_id_act = act_id AND cxi_id_tac = act_id_tac 
                    AND cxi_id_car IN ($car_ids)), '') AS caracteristics", false)
            ->from('act_activo_fijo')
            ->join('tac_tipo_activofijo', 'tac_id = act_id_tac ')
            ->join('dtv_detalle_tipo_activo', 'dtv_id_tac = act_id_tac')
            ->join('cnt_cuenta_contable', 'cnt_id = dtv_id_cnt', 'left')
            ->join('tcn_tipo_cuenta', 'tcn_id = dtv_id_tcn AND tcn_estado = 1', 'left')
            ->order_by('act_depreciable DESC, cnt_id ASC')
            ->where('act_estado', 1)
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    public function get_reporte_activo_cuenta_contable($where = null){
      $query = $this->db->select("*, GROUP_CONCAT(DISTINCT tcn_nombre) as 'tipo_cuenta', GROUP_CONCAT(DISTINCT cnt_nombre) as 'cuenta_contable'")
                ->from('act_activo_fijo')
                ->join('grp_grupo', 'grp_id = act_id_grp')
                ->join('tac_tipo_activofijo','tac_id = act_id_tac')
                ->join('dtv_detalle_tipo_activo', 'dtv_id_tac = tac_id','left')
                ->join('cnt_cuenta_contable', 'cnt_id = dtv_id_cnt','left')
                ->join('tcn_tipo_cuenta', 'tcn_id = dtv_id_tcn and tcn_estado = 1','left');
  
        if ($where != null) {
            $this->db->where($where);
        }

        $this->db->group_by('act_id');
        return $query->get()->result_array();
    }

    public function get_reporte_asignacion($where=null){
        $query = $this->db->select()
                ->from('act_activo_fijo')
                ->join('axe_activoxempleado', 'axe_id_act = act_id')
                ->join('emp_empleado', 'axe_id_emp = emp_id')
                ->join('are_area','are_id = act_id_are')
                ->group_by('axe_id_act')
        ;
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

    /**
    *@author: Francisco Orozco
    *fecha: 28/02/2017 
    *descripcion: dependiendo de la agrupación ($group) se obtiene obtiene los empleados o los activos que poseen segun la variable $having
    *             sera con respespecto a veces para obtener si solo son los asignados ( igual a 1 ) ó (mayor que 1) para obtener los traslados
    */
   public function listado_empleados_asignacion($where=null,$having=null, $group=null){
      $ultima_asignacion = ($group)? 'MAX(axe_id) ':'';//Add 07-08-2017 by René Castaneda (obtener la ultima asignación del activo  para ser utilizado en la generación de reporte)
      $query = $this->db->select("$ultima_asignacion axe_id, axe_id_act, are_nombre, emp_nombre, emp_apellido, act_estado, emp_id, act_id, act_nombre, act_descripcion , act_codigo, act_valor_cont, axe_fecha,(SELECT COUNT(a.axe_id_act) FROM axe_activoxempleado as a WHERE a.axe_id_act = act_id) AS veces,
        (SELECT GROUP_CONCAT(CONCAT(car_nombre,': ',cxc_valor) SEPARATOR '; ') FROM cxc_caracterxactivo JOIN cxi_caracteristicaxtipo ON cxi_id = cxc_id_cxi 
        JOIN car_caracteristica ON car_id = cxi_id_car WHERE cxc_id_act = act_id) AS caracteristicas", false)
                ->from('emp_empleado')
                ->join('axe_activoxempleado', 'axe_id_emp = emp_id')
                ->join('act_activo_fijo', 'act_id = axe_id_act')
                ->join('are_area','are_id = axe_id_are')
                ->order_by('are_id')
                ->order_by('emp_id')
                ->order_by('axe_fecha')
      ;
      if ($where != null) {
            $this->db->where($where);
      }
      if ($having != null) {
            $this->db->having($having);
      }
      if ($group != null) {
            $this->db->group_by($group);
      }
    
      return $query->get()->result_array();
  }

  public function get_reporte_activo_cuenta($where = null, $cuenta=null, $desde=null, $hasta=null){  // FECHA DE DEPRECIACION
            $query = $this->db->select(
            "*, GROUP_CONCAT(DISTINCT tcn_nombre) AS 'tipo_cuenta',
            GROUP_CONCAT(DISTINCT cnt_nombre) AS 'cuenta_contable',
            SUM(dep_monto) / (
                SELECT
                    COUNT(dtv.dtv_id)
                FROM
                    dtv_detalle_tipo_activo as dtv
                WHERE
                    dtv.dtv_id_tac = tac_id
            ) AS monto
            ")
            ->from('act_activo_fijo')
            ->join('grp_grupo', 'grp_id = act_id_grp')
            ->join('tac_tipo_activofijo','tac_id = act_id_tac')
            ->join('dtv_detalle_tipo_activo', 'dtv_id_tac = tac_id')
            ->join('dep_depreciacion', 'dep_id_act=act_id', 'left')
            ->join('prd_periodo_deprec', 'prd_id=dep_id_prd', 'left')
            ->join('cnt_cuenta_contable', 'cnt_id = dtv_id_cnt', 'left')
            ->join('tcn_tipo_cuenta', 'tcn_id = dtv_id_tcn and tcn_estado = 1','left');     

        if($cuenta!=null){
          $this->db->where('cnt_id', $cuenta);
        }

        if ($where != null) {
            $this->db->where($where);
        }

        if($desde!=null && $hasta!=null){
         // $this->db->where('((date_format(dep_fecha,"%Y-%m-%d") >= "'.$desde.'" AND date_format(dep_fecha,"%Y-%m-%d") <= "'.$hasta.'") OR dep_fecha IS NULL )');
          $this->db->where("DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')) ),'%Y-%m-01') BETWEEN '$desde' AND '$hasta'");
        }

        $this->db->group_by('cnt_id');
        return $query->get()->result_array();
  }

  public function documentoxproveedor($det=null, $where=null){
    $query = $this->db->select("
            	dpv_id,
                prv_id,
                tac_id,
                prv_tipo_pers,
                prv_nombre,
                prv_apellido,
                dpv_numero_documento,
                act_nombre,
                dxd_id,
                dxd_precio_unitario,
                dxd_total,
                (
                    dxd_cantidad - dxd_procesado_inventario
                ) AS cant
            ", FALSE)
            ->from('dpv_documento_proveedor')
            ->join('dxd_detalle_documento_proveedor', 'dxd_id_dpv = dpv_id')
            ->join('act_activo_fijo', 'dxd_id_act = act_id')
            ->join('tac_tipo_activofijo', 'act_id_tac = tac_id')
            ->join('prv_proveedor','prv_id = dpv_id_prv') 
            ->where('dpv_tipo', 3); //Solo activo fijo.
       
        if ($where != null) {
            $this->db->where($where);
        }

        if($det==2){
          $this->db->group_by('dxd_id');
        }else{
          $this->db->group_by('dpv_id');
        }

        return $query->get()->result_array();
  }

  /**
  * @author René Castaneda
  * @since 2017-08-02
  * @return información de un activo
   */
    public function get_info_activo($where=null) {
        $query = $this->db->select("*, (SELECT GROUP_CONCAT(CONCAT(car_nombre,': ',cxc_valor) SEPARATOR '; ') FROM cxc_caracterxactivo 
            JOIN cxi_caracteristicaxtipo ON cxi_id = cxc_id_cxi JOIN car_caracteristica ON car_id = cxi_id_car WHERE cxc_id_act = act_id) AS caracteristicas", false)
            ->from('act_activo_fijo')
            ->join('tac_tipo_activofijo', 'tac_id = act_id_tac', 'left')
            ->join('grp_grupo', 'grp_id = act_id_grp', 'left')
            ->join('tad_tipo_adquisicion','tad_id = act_id_tad', 'left')
            ->join('are_area','are_id = act_id_are', 'left') 
        ; 
        if ($where != null) {
            $this->db->where($where);
        }
        return $query->get()->result_array();
    }

  /**
  * @author René Castaneda
  * @since 2017-08-02
  * @return información de la asignación de un activo
   */
  public function get_info_activo_asignacion($where=null)
  {
    $query = $this->db->select()
                ->from('axe_activoxempleado')
                ->join('act_activo_fijo', 'act_id = axe_id_act')
                ->join('emp_empleado', 'emp_id = axe_id_emp', 'left')
                ->join('are_area', 'are_id = axe_id_are', 'left')
                ->order_by('axe_id','DESC')
                ; 
        if ($where != null) {
            $this->db->where($where);
        }

      return $query->get()->result_array();

  }

  /**
  * @author René Castaneda
  * @since 2017-08-08
  * @return información de todos los activos
   */
  public function get_info_total_activo($where=null,$order_by=null)
  {
    /*
     SELECT 
          IFNULL(CONCAT_WS(' ', emp_nombre, emp_apellido),'')
          FROM emp_empleado 
          JOIN axe_activoxempleado on axe_id_emp = emp_id
          WHERE axe_id_act = act_id AND axe_estado = 1  ORDER BY axe_id DESC LIMIT 1
          ) responsable,
    */
    $query = $this->db->select("*, 
          (
          IFNULL(CONCAT_WS(' ', emp_nombre, emp_apellido),'')
          ) responsable,
          
       ROUND((IFNULL((act_valor_compra - IFNULL(act_valor_residual,0)),0) / (act_vida_util * 12)), 6) depreciacion_mensual,
       (
            SELECT GROUP_CONCAT( DISTINCT CONCAT_WS(': ',car_nombre,cxc_valor) SEPARATOR '###') caract from cxc_caracterxactivo
            JOIN cxi_caracteristicaxtipo on cxi_id = cxc_id_cxi
            JOIN car_caracteristica on car_id = cxi_id_car
            WHERE cxc_estado = 1 AND act_id = cxc_id_act
       ) AS caracteristicas_activo,
      IF(act_fecha_inicia_dep IS NOT NULL,DATE_FORMAT(ADDDATE(act_fecha_inicia_dep, INTERVAL act_vida_util YEAR),'%Y-%m-%d'),'') fecha_fin_dep
       ", false)
                ->from('act_activo_fijo')
                ->join('tac_tipo_activofijo', 'tac_id = act_id_tac', 'left')
                ->join('grp_grupo', 'grp_id = act_id_grp', 'left')
                ->join('tad_tipo_adquisicion','tad_id = act_id_tad', 'left')
                ->join('are_area','are_id = act_id_are', 'left') 
                ->join('axe_activoxempleado','axe_id_act = act_id and axe_estado = 1', 'left') 
                ->join('emp_empleado','emp_id = axe_id_emp', 'left') 
                ->group_by('act_id')
                ; 
       
        if ($where != null) {
            $this->db->where($where);
        }
        if ($order_by) {
          foreach ($order_by as $key => $value) {
            $this->db->order_by($key, $value);
          }
        }

      return $query->get()->result_array();

  }

  public function get_activo_empleado($where = null, $orderby = null){
    /*SELECT DISTINCT axe_id_act FROM axe_activoxempleado WHERE axe_id_are=".$area
  
      SELECT * FROM axe_activoxempleado
        INNER JOIN act_activo_fijo ON act_id = axe_id_act
        INNER JOIN emp_empleado ON emp_id = axe_id_emp
        INNER JOIN are_area ON are_id = axe_id_are
        INNER JOIN suc_sucursal ON suc_id = emp_id_suc
        ORDER BY axe_id_act, axe_id, axe_fecha

    */
    $query = $this->db->select("*")
          ->from('axe_activoxempleado')
          ->join('act_activo_fijo','act_id = axe_id_act','inner')
          ->join('emp_empleado','emp_id = axe_id_emp','inner')
          ->join('are_area','are_id = axe_id_are','inner')
          // ->join('suc_sucursal','suc_id = emp_id_suc','inner')
          ->join('suc_sucursal','suc_id = are_id_suc','inner')
          ->order_by('axe_id_act, axe_id, axe_fecha')
    ;
    if($where != null){
        $this->db->where($where);
    }
    if ($orderby != null) {
        $this->db->order_by($orderby);
    }
    //$query->get()->result_array();
    //echo $this->db->last_query();

    return $query->get()->result_array();
  }


  /**
  * @author René Castaneda
  * @since 2017-09-07
  * @return/descripción: actualizar código de activo luego de traslado
   */
  public function actualizar_codigo_area_activo($ids_axe)
  { 
    if ($this->gsatelite->get_parametro('FORMATO_CODIGO_ACTIVO') == 1 and count($ids_axe) > 0 ) { //caso alcaldias
        $abreviacion_emp = $this->gsatelite->get_parametro('ACT_ABBR_EMPRESA');
        $id_traslado = ( count($ids_axe) > 0 )? implode(',', $ids_axe):0;
        $usuario = $this->tank_auth->get_user_id();
        $fecha = date("Y-m-d H:i:s");
        $this->db->query("
          UPDATE act_activo_fijo act2
          JOIN (
          SELECT act_id, act_id_are, act_codigo, act_nombre, 
          REPLACE(act_codigo,CONCAT_WS('-','$abreviacion_emp',TRIM(a2.are_prefijo)),CONCAT_WS('-','$abreviacion_emp',a1.are_prefijo)) NUEVO_COD,
           CONCAT_WS('-','$abreviacion_emp',a2.are_prefijo) antes, 
          CONCAT_WS('-','$abreviacion_emp',a1.are_prefijo) nuevo , axe_id, axe_id_are, axe_estado
          from act_activo_fijo 
          join axe_activoxempleado on axe_id_act = act_id
          JOIN are_area a1 on a1.are_id = axe_id_are
          JOIN are_area a2 on a2.are_id = act_id_are
          where axe_estado = 1
          AND axe_id in ($id_traslado)
          GROUP BY act_id
          ORDER by act_id DESC
          )
          AS axe2 ON axe2.act_id = act2.act_id
          SET act2.act_codigo = axe2.NUEVO_COD
              ,act2.act_id_are = axe2.axe_id_are
              ,act2.act_usu_modificacion = $usuario
              ,act2.act_fecha_modificacion = '$fecha'
          WHERE axe2.axe_estado = 1
          AND axe2.axe_id in ($id_traslado);
          ");
    }

  }

    /**
    * @author René Castaneda
    * @since 2017-09-21
    * @return información de todos los activos
    */
    public function get_depreciacion_activo($where=null,$order_by=null, $fecha_depIni=null, $fecha_depFin=null, $where_baja = null)  {
        $fecha_depIni = ($fecha_depIni) ? formatear_fecha('Y-m', $fecha_depIni) :'';
        $fecha_depFin = ($fecha_depFin) ? formatear_fecha('Y-m', $fecha_depFin) :'';
        $condicion_fecha_depreciacion = "";
        $where_periodo_dep = '';
        if (trim($fecha_depIni) != '' && trim($fecha_depIni) != '') {
            $condicion_fecha_depreciacion = "AND DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01'))),'%Y-%m') BETWEEN '$fecha_depIni' AND '$fecha_depFin'";
            $condicion_fecha_dep_acumulad = "AND DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01'))),'%Y-%m') BETWEEN DATE_FORMAT(act_fecha_adq,'%Y-%m') AND '$fecha_depFin'";
            $cond_fecha_depreciacion_inic = "AND DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01'))),'%Y-%m') < '$fecha_depFin'";
            $where_periodo_dep = " act_id in (SELECT DISTINCT dep_id_act FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd
                WHERE DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')) ),'%Y-%m') BETWEEN '$fecha_depIni' AND '$fecha_depFin')";
        }
        $anio_hasta1 = (trim($fecha_depFin) != '') ? formatear_fecha("Y-01",$fecha_depFin):date("Y-01");
        $anio_hasta2 = (trim($fecha_depFin) != '') ? formatear_fecha("Y-m",$fecha_depFin):date("Y-m");

        // CASO SERSAPROSA
        $anio_hasta3 = $anio_hasta2;
        $anio_previo = (formatear_fecha('Y', $anio_hasta3) - 1) . '-12';
        $cond_dep_inic_lastyear = "AND DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01'))),'%Y-%m') <= '$anio_previo'";

        $fechaO = date_create(($anio_hasta2.'-15'));
        date_add($fechaO, date_interval_create_from_date_string('-1 months'));
        $anio_hasta2 = date_format($fechaO, 'Y-m');

        $query = $this->db->select("
            act_activo_fijo.*, tac_tipo_activofijo.*, DATE_FORMAT(act_fecha_adq,'%d-%m-%Y') fecha_adquisicion,
            DATE_FORMAT(DATE( ADDDATE(act_fecha_adq, INTERVAL (IFNULL(act_vida_util,0) * 12 ) MONTH)),'%d-%m-%Y') fecha_fin_dep,
            act_porcentaje_dep porcentaje_anual_dep,
            ROUND(((IFNULL((act_valor_compra - IFNULL(act_valor_residual, 0)), 0) / (act_vida_util))/12), 8) depreciacion_mensual,
            ROUND((IFNULL((act_valor_compra - IFNULL(act_valor_residual, 0)), 0) / (act_vida_util)), 8) depreciacion_anual,
            IFNULL(((act_valor_compra - IFNULL(act_valor_residual, 0)) / DATEDIFF(DATE_ADD(act_fecha_inicia_dep,INTERVAL ROUND(act_vida_util) YEAR),  act_fecha_inicia_dep)),0) AS cuota_dep_diaria,
            (SELECT ROUND(SUM(IF(dep_monto > 0,dep_monto,0)),8) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id $condicion_fecha_dep_acumulad) AS depreciacion_acumulada,
            (SELECT ROUND(SUM(dep_monto),8) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id $cond_fecha_depreciacion_inic) AS saldo_depreciacion_ini,
            (SELECT ROUND(SUM(IF(dep_monto > 0,dep_monto,0)),8) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id $cond_dep_inic_lastyear) AS saldo_depreciacion_last_year,  
            (SELECT CONCAT(IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-', prd_ano) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id 
            $condicion_fecha_depreciacion 
            ORDER BY LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')) desc limit 1) ultima_depreciacion,            
            (SELECT dep_monto FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id 
            $condicion_fecha_depreciacion 
            ORDER BY LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')) desc limit 1) ultima_depreciacion_mensual,
            (SELECT GROUP_CONCAT(DISTINCT cnt_cuenta) FROM cnt_cuenta_contable JOIN dtv_detalle_tipo_activo on dtv_id_cnt = cnt_id WHERE dtv_id_tac =  tac_id) cuenta_contable,
            (SELECT ROUND(SUM(dep_monto),8) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id 
            and DATE_FORMAT(LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')),'%Y-%m') BETWEEN date_format(act_fecha_inicia_dep, '%Y-%m') 
            AND  date_format(act_fecha_inicia_dep, '%Y-12') )  depreciacion_acumulada_anio1,
            (SELECT ROUND(SUM(dep_monto),8) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id
            AND DATE_FORMAT(LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')),'%Y-%m') BETWEEN '$anio_hasta1' AND '$anio_hasta3') depreciacion_anio_filtro,
            (SELECT ROUND(SUM(dep_monto),8) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id 
            and DATE_FORMAT(LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')),'%Y-%m') BETWEEN '$anio_hasta1' AND '$anio_hasta2') depreciacion_acumulada_anio_hasta
        ", false)
                ->from('act_activo_fijo')
                ->join('tac_tipo_activofijo', 'tac_id = act_id_tac', 'left')
                ->join('are_area','are_id = act_id_are', 'left') 
                ->join('grp_grupo', 'grp_id = act_id_grp', 'left')
                ->group_by('act_id')
        ; 

        if ($where != null) {
            $this->db->where($where);
        }
        if ($where_periodo_dep) {
            $this->db->where("$where_periodo_dep",null, false);
        }
        if (trim($where_baja) != '' ) {
            $where_cec = (isset($where['act_id_cec']))? "AND act_id_cec = ".$where['act_id_cec']:'';
            $query_baja = "act_id in ( SELECT act_id from act_activo_fijo WHERE
            $where_baja and act_estado = 0 AND act_depreciable = '1' $where_cec)";
            $this->db->or_where("$query_baja",null, false);
        }
        if ($order_by) {
            foreach ($order_by as $key => $value) {
                $this->db->order_by($key, $value);
            }
        }
        //$query->get()->result_array();
        //echo $this->db->last_query();
        return $query->get()->result_array();
    }

    public function get_depreciacion_activo_historico($where=null,$order_by=null, $fecha_depIni=null, $fecha_depFin=null, $where_baja = null)  {
        $fecha_depIni = ($fecha_depIni) ? formatear_fecha('Y-m', $fecha_depIni) :'';
        $fecha_depFin = ($fecha_depFin) ? formatear_fecha('Y-m', $fecha_depFin) :'';
        $condicion_fecha_depreciacion = "";
        $where_periodo_dep = '';
        if (trim($fecha_depIni) != '' && trim($fecha_depIni) != '') {
            $condicion_fecha_depreciacion = "AND DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01'))),'%Y-%m') BETWEEN '$fecha_depIni' AND '$fecha_depFin'";
            $condicion_fecha_dep_acumulad = "AND DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes > 9, prd_mes, CONCAT('0',prd_mes)),'-01'))),'%Y-%m') BETWEEN DATE_FORMAT(act_fecha_adq,'%Y-%m') AND '$fecha_depFin'";
            $cond_fecha_depreciacion_inic = "AND DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01'))),'%Y-%m') < '$fecha_depFin'";
            // $where_periodo_dep = "((act_id IN (SELECT DISTINCT dep_id_act FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE 
            //     DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes > 9, prd_mes, CONCAT('0',prd_mes)), '-01'))),'%Y-%m') BETWEEN '$fecha_depIni' AND '$fecha_depFin')) OR 
            //     (act_id IN (SELECT DISTINCT dph_id_act FROM dph_depreciacion_historica JOIN prd_periodo_deprec on prd_id = dph_id_prd WHERE 
            //     DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-', IF(prd_mes > 9,prd_mes,CONCAT('0',prd_mes)),'-01')) ),'%Y-%m') BETWEEN '$fecha_depIni' AND '$fecha_depFin')) )";
            $where_periodo_dep = "DATE_FORMAT(act_fecha_adq,'%Y-%m') BETWEEN '$fecha_depIni' AND '$fecha_depFin'";
        }
        $anio_hasta1 = (trim($fecha_depFin) != '') ? formatear_fecha("Y-01",$fecha_depFin):date("Y-01");
        $anio_hasta2 = (trim($fecha_depFin) != '') ? formatear_fecha("Y-m",$fecha_depFin):date("Y-m");
        // CASO SERSAPROSA
        $anio_hasta3 = $anio_hasta2;
        $anio_previo = (formatear_fecha('Y', $anio_hasta3) - 1) . '-12';
        $cond_dep_inic_lastyear = "AND DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01'))),'%Y-%m') <= '$anio_previo'";
        $fechaO = date_create(($anio_hasta2.'-15'));
        date_add($fechaO, date_interval_create_from_date_string('-1 months'));
        $anio_hasta2 = date_format($fechaO, 'Y-m');
        $query = $this->db->select("
            act_activo_fijo.*, tac_tipo_activofijo.*, agr_agrupacion_activos.*, DATE_FORMAT(act_fecha_adq,'%d-%m-%Y') fecha_adquisicion,
            DATE_FORMAT(DATE( ADDDATE(act_fecha_adq, INTERVAL (IFNULL(act_vida_util,0) * 12 ) MONTH)),'%d-%m-%Y') fecha_fin_dep,
            act_porcentaje_dep porcentaje_anual_dep,
            ROUND(((IFNULL((act_valor_compra - IFNULL(act_valor_residual, 0)), 0) / (act_vida_util))/12), 8) depreciacion_mensual,
            ROUND((IFNULL((act_valor_compra - IFNULL(act_valor_residual, 0)), 0) / (act_vida_util)), 8) depreciacion_anual,
            (IFNULL((SELECT ROUND(SUM(IFNULL(dep_monto, 0)), 8) FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_id_act = act_id $condicion_fecha_dep_acumulad), 0) + IFNULL((SELECT ROUND(SUM(IFNULL(dph_monto, 0)), 8) FROM dph_depreciacion_historica JOIN prd_periodo_deprec ON prd_id = dph_id_prd WHERE dph_id_act = act_id $condicion_fecha_dep_acumulad), 0)) AS depreciacion_acumulada,
            (SELECT ROUND(SUM(dep_monto),8) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id $cond_fecha_depreciacion_inic) AS saldo_depreciacion_ini,
            (SELECT ROUND(SUM(IF(dep_monto > 0,dep_monto,0)),8) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id $cond_dep_inic_lastyear) AS saldo_depreciacion_last_year,
            IFNULL( (SELECT CONCAT(IF(prd_mes > 9, prd_mes, CONCAT('0', prd_mes)), '-', prd_ano) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id $condicion_fecha_depreciacion ORDER BY LAST_DAY(CONCAT(prd_ano, '-', IF(prd_mes > 9, prd_mes, CONCAT('0', prd_mes)), '-01')) DESC LIMIT 1), 
                (SELECT CONCAT(IF(prd_mes > 9, prd_mes, CONCAT('0', prd_mes)), '-', prd_ano) FROM dph_depreciacion_historica JOIN prd_periodo_deprec on prd_id = dph_id_prd WHERE dph_id_act = act_id $condicion_fecha_depreciacion ORDER BY LAST_DAY(CONCAT(prd_ano, '-', IF(prd_mes > 9, prd_mes, CONCAT('0', prd_mes)), '-01')) DESC LIMIT 1)
            ) AS ultima_depreciacion, 
            IFNULL( (SELECT dep_monto FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_id_act = act_id $condicion_fecha_depreciacion ORDER BY LAST_DAY(CONCAT(prd_ano, '-', IF(prd_mes > 9, prd_mes, CONCAT('0', prd_mes)), '-01')) DESC LIMIT 1), IFNULL( (SELECT dph_monto FROM dph_depreciacion_historica JOIN prd_periodo_deprec ON prd_id = dph_id_prd WHERE dph_id_act = act_id $condicion_fecha_depreciacion ORDER BY LAST_DAY(CONCAT(prd_ano, '-', IF(prd_mes > 9, prd_mes, CONCAT('0', prd_mes)), '-01')) DESC LIMIT 1), 0) ) ultima_depreciacion_mensual,
            (SELECT GROUP_CONCAT(DISTINCT cnt_cuenta) FROM cnt_cuenta_contable JOIN dtv_detalle_tipo_activo on dtv_id_cnt = cnt_id WHERE dtv_id_tac =  tac_id) cuenta_contable,
            (SELECT ROUND(SUM(dep_monto),8) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id 
            and DATE_FORMAT(LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')),'%Y-%m') BETWEEN date_format(act_fecha_inicia_dep, '%Y-%m') 
            AND  date_format(act_fecha_inicia_dep, '%Y-12') )  depreciacion_acumulada_anio1,
            (IFNULL((SELECT ROUND(SUM(dep_monto),8) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id AND 
                DATE_FORMAT(LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')),'%Y-%m') BETWEEN '$anio_hasta1' AND '$anio_hasta3'), 0) + 
                IFNULL((SELECT ROUND(SUM(dph_monto),8) FROM dph_depreciacion_historica JOIN prd_periodo_deprec on prd_id = dph_id_prd WHERE dph_id_act = act_id AND 
                DATE_FORMAT(LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')),'%Y-%m') BETWEEN '$anio_hasta1' AND '$anio_hasta3'), 0)) 
                AS depreciacion_anio_filtro,
            (SELECT ROUND(SUM(dep_monto),8) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id 
            and DATE_FORMAT(LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')),'%Y-%m') BETWEEN '$anio_hasta1' AND '$anio_hasta2') depreciacion_acumulada_anio_hasta
        ", false)
                ->from('act_activo_fijo')
                ->join('tac_tipo_activofijo', 'tac_id = act_id_tac', 'left')
                ->join('are_area','are_id = act_id_are', 'left') 
                ->join('grp_grupo', 'grp_id = act_id_grp', 'left')
                ->join('agr_agrupacion_activos', 'agr_id = grp_id_agr', 'left')
                ->group_by('act_id')
        ; 
        if ($where != null) {
            $this->db->where($where);
        }
        if ($where_periodo_dep) {
            $this->db->where($where_periodo_dep);
        }
        if (trim($where_baja) != '' ) {
            $where_cec = (isset($where['act_id_cec']))? "AND act_id_cec = ".$where['act_id_cec']:'';
            $query_baja = "act_id in ( SELECT act_id from act_activo_fijo WHERE
            $where_baja and act_estado = 0 AND act_depreciable = '1' $where_cec)";
            $this->db->or_where("$query_baja",null, false);
        }
        if ($order_by) {
            foreach ($order_by as $key => $value) {
                $this->db->order_by($key, $value);
            }
        }
        return $query->get()->result_array();
    }

    public function get_depreciacion_activo2($where=null, $order_by=null, $fecha_depIni=null, $fecha_depFin=null, $where_baja = null, $caso_sersa = null)  {
        $fecha_depIni = ($fecha_depIni) ? formatear_fecha('Y-m', $fecha_depIni) : '0001-01';
        $fecha_depFin = ($fecha_depFin) ? formatear_fecha('Y-m', $fecha_depFin) : date('Y-m');
        $ult_adq_f = formatear_fecha('Ym',$fecha_depFin);
        $this_year = formatear_fecha('Y', $fecha_depFin);
        $last_year = formatear_fecha('Y', $fecha_depFin) - 1;
        $where_dep = (strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS'))) == 'sersaprosa') ? "(" : "";
        $where_dep .= "act_id IN (SELECT DISTINCT dep_id_act FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd 
            WHERE CONCAT(prd_ano, '-', RIGHT(CONCAT('00', prd_mes), 2)) BETWEEN '$fecha_depIni' AND '$fecha_depFin')";
        if (strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS'))) == 'sersaprosa') {
            $where_dep .= " OR (DATE_FORMAT(act_fecha_adq, '%Y%m') <= '$ult_adq_f' AND DATE_FORMAT(act_fecha_inicia_dep, '%Y%m') > '$ult_adq_f'))";
        }

        $query = $this->db->select("act_id, act_id_tac, act_id_grp, act_id_suc, act_id_cec, act_codigo, act_nombre, act_descripcion, act_fecha_adq, act_depreciable, act_valor_compra,
            act_valor_residual, act_porcentaje_dep, act_fecha_desact, act_fecha_inicia_dep, act_estado, act_cuota_mensual, act_depreciacion_anual, act_id_act_dependencia, act_fecha_desact, 
            tac_id, tac_nombre, tac_codigo, tac_depreciacion,  tac_vida_util,
            (SELECT GROUP_CONCAT(DISTINCT x.act_codigo SEPARATOR ', ') FROM act_activo_fijo AS x WHERE x.act_id_act_dependencia = act_activo_fijo.act_id) AS mejoras,
            IF(act_id_act_dependencia > 0,(SELECT padre.act_codigo FROM act_activo_fijo AS padre WHERE padre.act_id = act_activo_fijo.act_id_act_dependencia),NULL) AS act_padre,
            ROUND( (((act_valor_compra - act_valor_residual) * (act_porcentaje_dep / 100)) / 12), 2) AS cuota_dep_mens,
            IFNULL((SELECT ROUND(SUM(IF(dep_monto > 0, dep_monto, 0)), 4) FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_id_act = act_id 
              AND prd_ano <= '$last_year'), 0) AS saldo_depreciacion_last_year,
            IFNULL((SELECT ROUND(SUM(IF(dep_monto > 0, dep_monto, 0)), 4) FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_id_act = act_id 
              AND CONCAT(prd_ano, '-', RIGHT(CONCAT('00', prd_mes), 2)) BETWEEN '$this_year-01' AND '$fecha_depFin'), 0) AS depreciacion_anio_filtro,
            IFNULL((SELECT IF(dep_monto > 0, dep_monto, 0) FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_id_act = act_id 
            AND CONCAT(prd_ano, '-', RIGHT(CONCAT('00', prd_mes), 2)) = '$fecha_depFin'), 0) AS depreciacion_this_month, 
            IFNULL((SELECT ROUND(SUM(IF(dep_monto > 0, dep_monto, 0)), 4) FROM dep_depreciacion JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id 
              AND CONCAT(prd_ano, '-', RIGHT(CONCAT('00', prd_mes), 2)) BETWEEN DATE_FORMAT(act_fecha_adq, '%Y-%m') AND '$fecha_depFin'), 0) AS depreciacion_acumulada
            ", false)
          ->from('act_activo_fijo')
          ->join('tac_tipo_activofijo', 'tac_id = act_id_tac', 'left')
          ->join('grp_grupo', 'grp_id = act_id_grp', 'left')
          ->join('are_area','are_id = act_id_are', 'left')
        ;
        if ($where) {
            $this->db->where($where);
        }
        if ($where_dep) {
            $this->db->where("$where_dep", null, false);
        }
        if (trim($where_baja) != '' ) {
          $where_cec = (isset($where['act_id_cec'])) ? "AND act_id_cec = " . $where['act_id_cec'] : '';
          $query_baja = "act_id IN ( SELECT act_id from act_activo_fijo WHERE $where_baja AND act_estado = 0 AND act_depreciable = '1' $where_cec)";
          $this->db->or_where("$query_baja",null, false);
        }
        if ($order_by) {
            foreach ($order_by as $key => $value) {
                $this->db->order_by($key, $value);
            }
        }
        return $query->get()->result_array();
    }

  public function get_caracteristicas_activos($where = null, $groupby = null) {
    $query = $this->db->select()
      ->from('cxc_caracterxactivo')
      ->join('act_activo_fijo','act_id = cxc_id_act')
    ;
      

    if($where != null) {
        $this->db->where($where);
    }

    if($groupby != null) {
        $this->db->group_by($groupby);
    }

    return $query->get()->result_array();
  }

    public function get_cuentas_mayores_menores($where = null) {
        $minimo_par = floatval($this->gsatelite->get_parametro('ACT_DEP_MONTO', '600'));

        $query_listado = "SELECT act_id, act_estado, CONCAT_WS(' - ', act_codigo, act_nombre) AS nombre_activo, act_nombre, act_codigo, act_valor_compra,
        act_fecha_adq AS fecha_adquisicion, act_valor_cont AS costo_bk, act_valor_compra AS costo , act_valor_compra,
        ROUND(((SELECT SUM(dep_monto) FROM dep_depreciacion WHERE dep_id_act = act_id) + IFNULL((SELECT SUM(dph_monto) FROM dph_depreciacion_historica WHERE dph_id_act = act_id), 0)), 2) AS depreciacion_acumulada,
        (SELECT dep_monto FROM dep_depreciacion WHERE dep_id_act = act_id ORDER BY dep_id DESC LIMIT 1) AS depreciacion_mensual,
        ((SELECT COUNT(dep_fecha) FROM dep_depreciacion WHERE dep_id_act = act_id) + IFNULL((SELECT COUNT(dph_fecha) FROM dph_depreciacion_historica WHERE dph_id_act = act_id), 0))  AS meses_depreciados
        FROM act_activo_fijo
        INNER JOIN tac_tipo_activofijo ON tac_id = act_id_tac
        INNER JOIN grp_grupo ON grp_id =act_id_grp 
        LEFT JOIN are_area ON are_id =act_id_are";
        $w = array();
        foreach ($where as $k => $v) {
            if ($v && $v != "") {
                switch ($k) {
                    case 'fecha_ini':
                        if ($v != "") {
                            $w[] = "act_fecha_adq >= '$v'";
                        }
                    break;
                    case 'fecha_fin':
                        if ($v != "") {
                            $w[] = "act_fecha_adq <= '$v'";
                        }
                    break;
                    case 'tipo_depr':
                        if ($v < 3) {
                            if ($v > 0) {
                                $w[] = "act_valor_compra >= $minimo_par";
                            } else {
                                $w[] = "act_valor_compra < $minimo_par";
                            }                        
                        }
                    break;
                    case 'area_actv':
                        if ($v > 0) {
                            $w[] = "are_id = $v";
                        }
                    break;
                    case 'tipo_actv':
                        if ($v > 0) {
                            $w[] = "tac_id = $v";
                        }
                    break;
                    case 'grpo_actv':
                        if ($v > 0) {
                            $w[] = "grp_id = $v";
                        }
                    break;
                    case 'stado_act':
                        if ($v != "") {
                            $w[] = "act_estado = $v";
                        }
                    break;
                    case 'cec_activ':
                        if ($v > 0) {
                            $w[] = "act_id_cec = $v";
                        }
                    break;
                    case 'ver_desde':
                        if ($v > 0) {
                            $w[] = "act_valor_compra >= $v";
                        }
                    break;
                    case 'deprecibl':
                        if ($v > 0) {
                            if ($v > 1) {
                                $w[] = "act_depreciable = 0";
                            } else {
                                $w[] = "act_depreciable = 1";
                            }
                        }
                    break;
                }
            }
        }
        $where_query = "";
        if (count($w) > 0) {
            $where_query = " WHERE ";
            $implode = implode(" AND ", $w);
            $where_query .= $implode;
        }
        $query_listado .= $where_query;
        $query_result = $this->db->query( $query_listado );
        /*
        $condicion_tac = $tipo_activo > 0 ? " AND tac_id = ".$tipo_activo : "";
        $condicion_grp = $grupo != null ? " AND grp_id=".$grupo : "";
        $condicion_are = $area != null ? " AND are_id = ".$area : "";

        if ($depreciacion != null) {
            if ($depreciacion == 3) {
                $condicion_depre=" AND act_depreciable = 1 ";//OR act_depreciable = 0
            } else {
                if ($depreciacion == 1) {
                    $condicion_depre = $depreciacion != null ? " AND act_depreciable = 1 AND act_valor_compra > $minimo_par " : "";
                } else {
                    $condicion_depre = $depreciacion != null ? " AND act_depreciable = 1 AND act_valor_compra <= $minimo_par " : "";
                }
            }
        }
        if ($fecha_inicio != null && $fecha_fin != null) {
            $condicion_fecha = " AND (act_fecha_adq >='".$fecha_inicio. "' AND act_fecha_adq <='".$fecha_fin. "')";
        } elseif($fecha_inicio != null) {
            $condicion_fecha = " AND (act_fecha_adq >='".$fecha_inicio. "')";
        }elseif($fecha_fin != null){
            $condicion_fecha = " AND (act_fecha_adq <='".$fecha_fin. "')";
        }
    
        $query_listado = "SELECT act_id, act_estado,
        concat_ws(' - ', act_codigo, act_nombre) AS nombre_activo, act_nombre, act_codigo,
        act_fecha_adq AS fecha_adquisicion,
        act_valor_cont AS costo_bk, act_valor_compra AS costo , act_valor_compra,
         (SELECT round(sum(dep_monto), 2)
           FROM dep_depreciacion
           WHERE dep_id_act = act_id) AS depreciacion_acumulada,
         (SELECT dep_monto
           FROM dep_depreciacion
           WHERE dep_id_act = act_id LIMIT 1) AS depreciacion_mensual,
          (SELECT count(dep_fecha)
             FROM dep_depreciacion
             WHERE dep_id_act = act_id) AS meses_depreciados
          FROM act_activo_fijo
          INNER JOIN tac_tipo_activofijo ON tac_id = act_id_tac
          INNER JOIN grp_grupo ON grp_id =act_id_grp 
          INNER JOIN are_area ON are_id =act_id_are";
        // se modificaria si el estado puede ser 2
        if($estado != 2){
          $query_listado .= " WHERE act_estado = ".$estado;
        } else{
          $query_listado .= " WHERE (act_estado = 1 OR act_estado = -1)";
        }
        if($valor_depreciable!=null){
          $query_listado.=" AND act_valor_cont >= ".$valor_depreciable;
        }
        if ($cec !== null) {
         $query_listado.=" AND act_id_cec = ".$cec;
        }
        
        $query_listado.= " ".$condicion_tac." ".$condicion_grp." ".$condicion_are. " ". $condicion_depre. " ".$condicion_fecha;
        $query_result = $this->db->query( $query_listado );
        */
        return (is_object($query_result) && $query_result->num_rows() > 0) ? $query_result : false;
    }

  /**
  * @author Israel Alfaro
  * @since  2018-09-26
  * @param  $where que es la condicion del filtro y $like que es el like a mandar a la consulta
  * @return información de todos los activos segun los filtros
  */
  public function get_activos_like($where = null, $like = null) {
    satelite_validar(true);
    
    $query = $this->db->select("*")->from('act_activo_fijo');

    if ($where != null) {
      $this->db->where($where);
    }
    if ($like != null) {
      $this->db->where($like);
    }

    $this->db->group_by('act_id');
    return $query->get()->result_array();
  }

  public function empleados_activos_like($where = null, $like = null)
  {
    $query=$this->db->select('emp_id, emp_nombre, emp_apellido, IFNULL(plz_nombre,"") AS plz_nombre, are_id', FALSE)
             ->from('emp_empleado')
             ->join('axe_activoxempleado', 'axe_id_emp = emp_id')
             ->join('act_activo_fijo','act_id=axe_id_act')
             ->join('are_area','are_id=emp_id_are')
             ->join('plz_plaza','plz_id = emp_id_plz', 'left')
             ->where('axe_id_act IS NOT NULL', null, false)
             ->where('axe_estado >', 0);
             
            if($where!=null){
              $this->db->where($where);
            }

            if($like!=null){
              $this->db->where($like);
            }

      $this->db->group_by('emp_id');  
      $this->db->order_by('are_id');    
      return $query->get()->result_array();


       /* $resultado=$this->db->query($query)->result_array();
        return $resultado;*/
    
  }

  /**
  * @author Israel Alfaro
  * @since  2018-10-03
  * @param  $fecha_desde, $fecha_hasta que son las fechas del rango a buscar y $area que es por el tipo de departamento
  * @return información de todos los activos segun los filtros
  */
  public function get_toma_fisica_activo_fijo($fecha_desde, $fecha_hasta, $area = null, $where = null,$estado = 1) {
    satelite_validar();
    //Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
    $where_area = array();
        if (count($where) > 0) {
            $where_area = $where;
        }
    $query = $this->db->select('*')->from('act_activo_fijo')->order_by('act_id_are, act_id_grp, act_fecha_adq', 'asc');

    
    $condicion_fechas = '';
    if ($fecha_desde !== null && $fecha_hasta !== null) {
      $condicion_fechas = "( date_format(act_fecha_adq,'%Y-%m-%d') >= '".$fecha_desde. "' AND date_format(act_fecha_adq,'%Y-%m-%d') <='".$fecha_hasta. "')";
    } elseif($fecha_desde !== null) {
      $condicion_fechas = "(date_format(act_fecha_adq,'%Y-%m-%d') >= '".$fecha_desde. "')";
    } elseif($fecha_hasta !== null){
      $condicion_fechas = "(date_format(act_fecha_adq,'%Y-%m-%d') <= '".$fecha_hasta. "')";
    }

    $condicion_area = '';
    if ($area !== null) {
      $condicion_area = (trim($condicion_fechas)!="")? " AND act_id_are = " .$area:"act_id_are = " .$area;
    }
    $condicion = $condicion_fechas . $condicion_area ;
    $this->db->join('grp_grupo', 'grp_id = act_id_grp', 'left');
    $this->db->join('are_area', 'are_id = act_id_are', 'left');
    ($condicion)?$this->db->where($condicion):'';
    $this->db->where($where_area);
    $this->db->order_by("act_id_are, act_id_grp ASC"); 
    return $query->get()->result_array();
  }

  /**
  * @author Israel Alfaro
  * @since  2018-10-03
  * @param  $fecha_desde, $fecha_hasta que son las fechas del rango a buscar y $tipo que es por el tipo de reporte(retirado o baja)
  * @return información de todos los activos segun los filtros
  */
    public function get_activos_retirados_dados_baja($fecha_desde, $fecha_hasta, $tipo, $where = null) {
        satelite_validar();
        $where_area = array();
        if (count($where) > 0) {
            $where_area = $where;
        }
        $query = $this->db->select('*')->from('act_activo_fijo');
        $condicion  = null;
        if (($fecha_desde !== null) && ($fecha_hasta !== null)) {
            $condicion_fechas = "( date_format(act_fecha_desact,'%Y-%m-%d') >='".$fecha_desde. "' AND date_format(act_fecha_desact,'%Y-%m-%d') <='".$fecha_hasta. "')";
        } elseif($fecha_desde !== null) {
            $condicion_fechas = "(date_format(act_fecha_desact,'%Y-%m-%d') >='".$fecha_desde. "')";
        } elseif($fecha_hasta !== null){
            $condicion_fechas = "( date_format(act_fecha_desact,'%Y-%m-%d') <='".$fecha_hasta. "')";
        }        
        $condicion = $condicion_fechas;
        if ($condicion_fechas) {
            $this->db->where($condicion_fechas);
        }        
        $this->db->where($where_area);
        return $query->get()->result_array();
    }
  
  /**
    * @author Mario Marquez
    * @since 2018-10-14
    * @return Activos por Area
     */
    public function get_activos_area($where = null) {

        //Se obtienen el listado de tipos de activos
        $where_tipo_activo = array();
        if (count($where) > 0) {
            $where_tipo_activo = $where;
            $where_tipo_activo['tac_estado'] = 1;
        }

      //print_r($where_tipo_activo); die();
        $query_tipo_activo = $this->db->select('tac_tipo_activofijo.*')
                ->from('tac_tipo_activofijo')
                ->join('act_activo_fijo', 'act_id_tac = tac_id', 'inner')
                ->where($where_tipo_activo)
                ->group_by('tac_id')
                ->order_by('tac_codigo asc')
        ;

        $result_tipo_activo = $query_tipo_activo->get()->result_array();
        //echo $this->db->last_query(); die();
        //Se obtienen las areas por tipo de activo
        foreach ($result_tipo_activo as &$tipo) {

            $where_area = array();
            if (count($where) > 0) {
                $where_area = $where;
                $where_area['act_id_tac'] = $tipo['tac_id'];
            }

            $query_area = $this->db->select('are_area.*')
                    ->from('are_area')
                    ->join('act_activo_fijo', 'act_id_are = are_id', 'inner')
                    ->where($where_area)
                    ->group_by('are_id')
                    ->order_by('are_nombre asc')
            ;

            $result_area = $query_area->get()->result_array();
            //echo $this->db->last_query(); die();

            foreach ($result_area as &$area) {
                $where_activos = array();
                if (count($where) > 0) {
                    $where_activos = $where;
                }
                $where_activos['act_id_tac'] = $tipo['tac_id'];
                $where_activos['act_id_are'] = $area['are_id'];
                //$where_activos['dda_id_act IS NULL'] = null;


                //Se obtienen los activos por area y tipo
                $query_activos = $this->db->select("act_activo_fijo.*, "
                         . "  ((act_valor_compra-act_valor_residual)/act_vida_util)/12 as cuota_mensual, "
                . "((act_valor_compra-act_valor_residual)/act_vida_util) as cuota_anual,"
                        . "IFNULL((
                                select sum(dep_monto) from dep_depreciacion 
                                INNER JOIN prd_periodo_deprec ON prd_id = dep_id_prd
                                where dep_id_act = act_id
                                AND CONVERT(prd_codigo, SIGNED INTEGER) BETWEEN DATE_FORMAT(NOW(),'%Y01') AND DATE_FORMAT(NOW(),'%Y%m') 
                                ),0) as depreciacion_anio,
                                IFNULL((
                                select sum(dep_monto) from dep_depreciacion 
                                INNER JOIN prd_periodo_deprec ON prd_id = dep_id_prd
                                where dep_id_act = act_id
                                AND CONVERT(prd_codigo, SIGNED INTEGER) <= DATE_FORMAT(NOW(),'%Y%m') 
                                ),0) as depreciacion_acumulada,
                                (act_valor_compra - IFNULL(act_valor_residual,0)) - IFNULL((
                                select sum(dep_monto) from dep_depreciacion 
                                INNER JOIN prd_periodo_deprec ON prd_id = dep_id_prd
                                where dep_id_act = act_id
                                AND CONVERT(prd_codigo, SIGNED INTEGER) <= DATE_FORMAT(NOW(),'%Y%m') 
                                ),0) as pendiente_depreciar"
                        , FALSE)
                        ->from('act_activo_fijo')
                        //->join('dda_distribucion_depreciacion_activo', 'dda_id_act = act_id','left')
                        ->where($where_activos)
                ;

                $area['activos'] = $query_activos->get()->result_array();
               // echo $this->db->last_query(); die();
            }
            $tipo['areas'] = $result_area;
        }
        
         //Se obtienen el listado de las cuentas contables con depreciacion segmentada
        //Se obtienen el listado de tipos de activos
        $where_cuenta_activo = array();
        if (count($where) > 0) {
            $where_cuenta_activo = $where;
        }
        
       // if (isset($where_cuenta_activo['dda_id_act IS NULL'])) {
      //    unset($where_cuenta_activo['dda_id_act IS NULL']);
      //  }
        $query_cuenta_activo = $this->db->select('cnt_cuenta_contable.*')
                ->from('cnt_cuenta_contable')
                ->join('dda_distribucion_depreciacion_activo','dda_id_cnt = cnt_id','inner')
                ->join('act_activo_fijo', 'dda_id_act = act_id', 'inner')
                ->where($where_cuenta_activo)
                ->group_by('cnt_id')
                ->order_by('cnt_nombre asc')
        ;
        
        $result_cuenta_activo = $query_cuenta_activo->get()->result_array();
        
        foreach($result_cuenta_activo as &$cuenta){
            
            //Se obtiene las areas de los activos segmentados
            $where_area = array();
            if (count($where) > 0) {
                $where_area = $where;
                $where_area['dda_id_cnt'] = $tipo['cnt_id'];
            }

           // if (isset($where_area['dda_id_act IS NULL'])) {
          //    unset($where_area['dda_id_act IS NULL']);
          //  }

            $query_area_activo = $this->db->select('are_area.*')
                ->from('are_area')
                ->join('act_activo_fijo', 'are_id = act_id_are', 'inner')
                ->join('dda_distribucion_depreciacion_activo','dda_id_act = act_id','inner')
                ->where($where_area)
                ->group_by('are_id')
                ->order_by('are_nombre asc')
            ;
            
            $result_area = $query_area_activo->get()->result_array();
            
            $cuenta['areas'] = $result_area;
        }
        
        $result = array('tipo_activo' =>$result_tipo_activo, 'depreciacion_segmentada'  => $result_cuenta_activo);
        
        return $result;
    }
    
     /**
    * @author Mario Marquez
    * @since 2018-10-15
    * @return Activos por Area
     */
    public function get_adquisicion_activo($where = null) {
        //Se obtienen las areas por tipo de activo
        $where_area = array();
        if (count($where) > 0) {
            $where_area = $where;
        }
        $query_area = $this->db->select('are_area.*')
                ->from('are_area')
                ->join('act_activo_fijo', 'act_id_are = are_id', 'inner')
                ->where($where_area)
                ->group_by('are_id')
                ->order_by('are_nombre asc')
        ;
        $result_area = $query_area->get()->result_array();
        foreach ($result_area as &$area) {
            $where_activos = array();
            if (count($where) > 0) {
                $where_activos = $where;
            }
            $where_activos['act_id_are'] = $area['are_id'];

            //Se obtienen los activos por area y tipo
            $query_activos = $this->db->select()
                    ->from('act_activo_fijo')
                    ->join('prv_proveedor','prv_id = act_id_prv','left')
                    ->where($where_activos)
                    ->order_by('act_codigo ASC');
            $area['activos'] = $query_activos->get()->result_array();
        }

        return $result_area;
    }
    
     /**
    * @author Mario Marquez
    * @since 2018-10-15
    * @return Activos por Area
     */
    public function get_activos_depreciados($where = null) {
        //Se obtienen las areas por tipo de activo
        $where_area = array();
        if (count($where) > 0) {
            $where_area = $where;
        }

        $query_area = $this->db->select('are_area.*')
                ->from('are_area')
                ->join('act_activo_fijo', 'act_id_are = are_id', 'inner')
                ->where($where_area)
                ->group_by('are_id')
                ->order_by('are_nombre asc')
        ;

        $result_area = $query_area->get()->result_array();


        foreach ($result_area as &$area) {
            $where_activos = array();
            if (count($where) > 0) {
                $where_activos = $where;
            }
            $where_activos['act_id_are'] = $area['are_id'];

            //Se obtienen los activos por area y tipo
            $query_activos = $this->db->select('act_activo_fijo.*, prv_proveedor.*, '
                    . '  ((act_valor_compra-act_valor_residual)/act_vida_util)/12 as cuota_mensual, '
                . '((act_valor_compra-act_valor_residual)/act_vida_util) as cuota_anual,
                (IFNULL((SELECT SUM(dep_monto) FROM dep_depreciacion WHERE dep_id_act = act_id) ,0) + 
                IFNULL((SELECT SUM(dph_monto) FROM dph_depreciacion_historica WHERE dph_id_act = act_id), 0)) AS suma_dep', false)
                    ->from('act_activo_fijo')
                    ->join('prv_proveedor','prv_id = act_id_prv','left')
                    ->where($where_activos)
                    ->order_by('act_codigo ASC');
            $area['activos'] = $query_activos->get()->result_array();
        }

        return $result_area;
    }

    /**
    * @author René Castaneda
    * @since 2017-09-21
    * @return información de todos los activos
     */
    public function get_depreciacion_activo_consolidado($where=null,$order_by=null, $fecha_depIni=null, $fecha_depFin=null, $group_by="act_id_tac"){
      //echo $fecha_depFin;
      $fecha_depIni = ($fecha_depIni)? formatear_fecha('Y-m',$fecha_depIni):'';
      $fecha_depFin = ($fecha_depFin)? formatear_fecha('Y-m',$fecha_depFin):'';
      $condicion_fecha_depreciacion = "";
      $where_periodo_dep = '';
      if (trim($fecha_depIni)!='' and trim($fecha_depFin)!='') {
      $condicion_fecha_depreciacion = "and  DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')) ),'%Y-%m') BETWEEN '$fecha_depIni' AND '$fecha_depFin'";
      }
      if (trim($fecha_depFin) != '') {
        $where_periodo_dep = " act_id in ( SELECT DISTINCT dep_id_act FROM dep_depreciacion 
            JOIN prd_periodo_deprec on prd_id = dep_id_prd
            WHERE DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')) ),'%Y-%m') BETWEEN '0001-01' AND '$fecha_depFin'
              )";
      }

      $query = $this->db->select(" act_codigo, act_nombre, act_id_tac,
        tac_codigo, tac_nombre, SUM(IFNULL(act_valor_compra,0)) valor_compra,
        SUM(IFNULL(act_valor_residual,0)) valor_residual, 
        SUM((IFNULL(act_valor_compra,0) - IFNULL(act_valor_residual,0))) valor_depreciar,
        SUM(((IFNULL(act_valor_compra,0) - IFNULL(act_valor_residual,0))/IFNULL(act_vida_util,1))) cuota_anual,
        SUM(( 
          SELECT SUM(IFNULL(dep_monto,0)) from dep_depreciacion
          JOIN prd_periodo_deprec on prd_id = dep_id_prd
          WHERE dep_id_act = act_id $condicion_fecha_depreciacion
        )) dep_periodo_anio,    
        SUM(( 
          SELECT SUM(IFNULL(ROUND(dep_monto,2),0)) from dep_depreciacion
          JOIN prd_periodo_deprec on prd_id = dep_id_prd
          WHERE dep_id_act = act_id 
          AND 
          DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')) ),'%Y-%m') <= '$fecha_depFin'
        )) dep_acumulada,

        ,SUM(ROUND(((IFNULL((ROUND(act_valor_compra,2) - ROUND(IFNULL(act_valor_residual, 0),2)), 0) / (act_vida_util))/12), 2)) depreciacion_mensual
        ,SUM(ROUND((IFNULL((ROUND(act_valor_compra,2) - ROUND(IFNULL(act_valor_residual, 0),2) ), 0) / (act_vida_util)), 2)) depreciacion_anual,
        
        , SUM(IF(((ROUND(act_valor_compra- ( 
          SELECT SUM(IFNULL(ROUND(dep_monto,2),0)) from dep_depreciacion
          JOIN prd_periodo_deprec on prd_id = dep_id_prd
          WHERE dep_id_act = act_id 
          AND 
          DATE_FORMAT((LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')) ),'%Y-%m') <= '$fecha_depFin'
        ),0) ) = ROUND(act_valor_residual,0) AND (

        (SELECT CONCAT(IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-', prd_ano) FROM dep_depreciacion 
      JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id 
      $condicion_fecha_depreciacion 
      ORDER BY LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')) desc limit 1) != '$fecha_depFin'

        ) ),0,(SELECT dep_monto FROM dep_depreciacion 
        JOIN prd_periodo_deprec on prd_id = dep_id_prd WHERE dep_id_act = act_id 
        $condicion_fecha_depreciacion 
        ORDER BY LAST_DAY(CONCAT(prd_ano,'-',IF(prd_mes >9, prd_mes, CONCAT('0',prd_mes)),'-01')) desc limit 1)) ) ultima_depreciacion_mensual
        ", false)
                  ->from('act_activo_fijo')
                  ->join('tac_tipo_activofijo', 'tac_id = act_id_tac', 'left')
                  ->group_by($group_by)
                  ; 
         
          if ($where != null) {
              $this->db->where($where);
          }
          if ($where_periodo_dep) {
            $this->db->where("$where_periodo_dep",null, false);
          }
          if ($order_by) {
            foreach ($order_by as $key => $value) {
              $this->db->order_by($key, $value);
            }
          }

        //$query->get()->result_array();
        //echo $this->db->last_query();
        return $query->get()->result_array();

    }

    /**
    * @author Luis Navarro
    * @since 2018-11-20
    * @return información de todos los activos
     */    
    public function obtener_activos_fijo_dar_baja($where = null, $groupby = null, $orderby = null) {
       $query = $this->db->select(
            "
              act_activo_fijo.*, 
              (
                SELECT
                  DATE(
                    CONCAT_WS(
                      '-',
                      LEFT (prd_codigo, 4),
                      RIGHT (prd_codigo, 2),
                      '01'
                    )
                  ) c
                FROM
                  dep_depreciacion
                JOIN prd_periodo_deprec ON prd_id = dep_id_prd
                WHERE
                  dep_id_act = act_id
                ORDER BY
                  DATE(
                    CONCAT_WS(
                      '-',
                      LEFT (prd_codigo, 4),
                      RIGHT (prd_codigo, 2),
                      '01'
                    )
                  ) DESC
                LIMIT 1
              ) ultima_fecha_dep
            ", false)
                ->from('act_activo_fijo');
        ;

        if ($where != null) {
              $this->db->where($where);
        }

        if ($groupby != null) {
            $this->db->group_by($groupby);
        }
        
        return $query->get()->result_array(); 
    }

    //METODO PARA BUSCAR LOS PROVEEDORES
    public function get_prv($table,$where,$fields){
      $this->db->select($fields);
      $this->db->from($table);
      $this->db->where($where);
      return $this->db->get()->result_array();
    }
    public function get_dxd_document($doc_id){
      $this->db->select('dxd_id, IFNULL(`act_nombre`, art_nombre) as nombre, act_id, dxd_precio_unitario, dxd_cantidad, tac_id, dxd_total, (SELECT count(act_id) FROM act_activo_fijo WHERE act_id_dxd = dxd_id) as cantidad_act', false)
        ->from('dxd_detalle_documento_proveedor')
        ->join('act_activo_fijo','act_id = dxd_id_act', 'left')
        ->join('tac_tipo_activofijo','act_id_tac = tac_id', 'left')
        ->join('art_articulo','art_id = dxd_id_art', 'left')
        ->where('act_id_dxd is NULL')
        ->where(['dxd_id_dpv'=>$doc_id]);
        return $this->db->get()->result_array();

    }
    public function search_activo_like($where = null, $like){
      $this->db->select('act_id, act_nombre activo, act_codigo codigo', false);
      $this->db->from('act_activo_fijo');
      $this->db->like($like);
      if ($where) {
        $this->db->where($where);
      }
      return $this->db->get()->result_array();
    }
    public function get_activo_mejora($where){
      $this->db->select('act_nombre, act_id')
        ->from('act_activo_fijo')
        ->where($where);
      return $this->db->get()->result_array();
    }

    public function get_act_fijo($where){
      $this->db->select('act_id as activo_id, act_correlativo as correlativo, act_id_suc, act_id_tac, act_id_tac as act_tipo_activo, act_id_grp as act_grupo, act_id_tad, act_id_tad AS act_tipo_tad, act_id_are as departamento, act_id_dxd, act_id_cec AS centro_costo, act_codigo, act_nombre, act_descripcion as descripcion, act_fecha_adq, act_depreciable as act_depreciacion, act_valor_compra, act_valor_cont, act_valor_residual, act_porcentaje_dep, act_observacion, act_vida_util, act_fecha_inicia_dep as fecha_ini_dep, act_foto as foto_activo, act_fecha_vence_garantia as fecha_ven, act_dias_garantia as dias_gar, act_observacion_garantia as observacion_gar, act_estado', false)
        ->from('act_activo_fijo')
        ->where($where);
        return $this->db->get()->result_array();
    }

public function get_reporte_general($where = null){
    $sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));

    // Condición para defensoria en el JOIN de axe_activoxempleado
    $axeactivo = ($sig_emp == 'defensoria') ? "axe_id_act = act_id AND axe_estado = 1" : "axe_id_act = act_id";

    $this->db->select('
        act_activo_fijo.*, 
        suc_sucursal.suc_nombre AS sucursal_nombre, 
        are_area.are_nombre AS area_nombre, 
        prv_proveedor.prv_nombre AS proveedor_nombre, 
        tac_tipo_activofijo.tac_nombre AS tipo_activo_nombre, 
        tad_tipo_adquisicion.tad_nombre AS tipo_adquisicion_nombre, 
        cec_centro_costo.cec_nombre AS centro_costo_nombre, 
        pcl_proyecto_cliente.pcl_nombre AS proyecto_cliente_nombre, 
        (GROUP_CONCAT(CONCAT(emp_nombre, " ", emp_apellido) SEPARATOR ", ")) AS responsables,
        (
            SELECT GROUP_CONCAT(CONCAT(car_nombre, ": ", cxc_valor) SEPARATOR ", ")
            FROM cxc_caracterxactivo 
            JOIN cxi_caracteristicaxtipo ON cxi_id = cxc_id_cxi 
            JOIN car_caracteristica ON car_id = cxi_id_car 
            WHERE cxc_estado = 1 AND car_estado = 1 AND cxc_id_act = act_id
        ) AS caracteristicas
    ', false)
    ->from('act_activo_fijo')
    ->join('suc_sucursal', 'suc_id = act_id_suc', 'LEFT')
    ->join('tac_tipo_activofijo', 'tac_id = act_id_tac', 'LEFT')
    ->join('prv_proveedor', 'prv_id = act_id_prv', 'LEFT')
    ->join('tad_tipo_adquisicion', 'tad_id = act_id_tad', 'LEFT')
    ->join('axe_activoxempleado', $axeactivo, 'LEFT')
    ->join('emp_empleado', 'emp_id = axe_id_emp', 'LEFT');

    // JOIN condicional para área
    if ($sig_emp == 'defensoria') {
        $this->db->join('are_area', 'are_id = axe_id_are', 'LEFT');
    } else {
        $this->db->join('are_area', 'are_id = act_id_are', 'LEFT');
    }

    $this->db->join('cec_centro_costo', 'cec_id = act_id_cec', 'LEFT')
             ->join('pcl_proyecto_cliente', 'pcl_id = act_id_pcl', 'LEFT');

    if ($where != null) {
        $this->db->where($where);
    }

    $this->db->group_by('act_id');

    $query = $this->db->get();

    if (!$query) {
        log_message('error', $this->db->last_query());
        log_message('error', print_r($this->db->error(), true));
        return [];
    }

    return $query->result_array();
}



    public function get_capitalizacion($where = null, $fhasta = null){
        $fltf = ($fhasta) ? 'AND prd_codigo <= ' . $fhasta : '';
        $this->db->select("act_id, act_id_grp, (SELECT agr_nombre FROM agr_agrupacion_activos WHERE agr_id = grp_id_agr) AS agr_nombre, IFNULL(grp_id_agr,0) AS id_agr,
            IFNULL((SELECT agr_orden FROM agr_agrupacion_activos WHERE agr_id = grp_id_agr), ((SELECT MAX(agr_orden) FROM agr_agrupacion_activos) + 1)) AS orden_agr,
            SUM(act_valor_compra) AS vCompra, SUM(act_valor_residual) AS vResid, SUM(act_valor_cont) AS vConta,
            SUM((IFNULL((SELECT SUM(IFNULL(dph_monto, 0)) FROM dph_depreciacion_historica JOIN prd_periodo_deprec ON prd_id = dph_id_prd WHERE dph_id_act = act_id $fltf), 0) +
                IFNULL((SELECT SUM(IFNULL(dep_monto, 0)) FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_id_act = act_id $fltf),0))) AS tDeph,
            SUM(act_valor_dep) AS vDep, SUM(act_valor_libro) AS vLibro", false)
            ->from('act_activo_fijo')
            ->join('grp_grupo', 'grp_id = act_id_grp')
            ->group_by('grp_id_agr')
            ->order_by('orden_agr')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_det_capitaliza($where = null, $fhasta = null, $yhasta = null, $full = null){
        $ymint = $this->gsatelite->get_min('act_activo_fijo', 'act_fecha_adq', array('act_depreciable' => 1, 'act_estado > ' => 0));
        $ycero = ($ymint) ? formatear_fecha('Y', $ymint) : $yhasta;
        $hasta = ($fhasta) ? $fhasta : date('Ym');
        $inifl = $yhasta . "01";
        $lasty = $yhasta - 1;
        $twoya = $yhasta - 2;
        $saldo = $yhasta - 3;
        $respuesta = array('minimo' => $ycero);
        $this->db->select("*, IFNULL(agr_id, ((SELECT MAX(o.agr_id) FROM agr_agrupacion_activos AS o) + 1)) AS id_orden, IFNULL(agr_nombre, 'Sin Clasificar') AS nombre_orden,
            (IFNULL((SELECT SUM(IFNULL(dph_monto, 0)) FROM dph_depreciacion_historica JOIN prd_periodo_deprec ON prd_id = dph_id_prd WHERE dph_id_act = act_id 
            AND prd_ano <= '$saldo'), 0) + IFNULL((SELECT SUM(IFNULL(dep_monto, 0)) FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd 
            WHERE dep_id_act = act_id AND prd_ano <= '$saldo'), 0)) AS saldo_depreciacion_vienen,
            (IFNULL((SELECT SUM(IFNULL(dph_monto, 0)) FROM dph_depreciacion_historica JOIN prd_periodo_deprec ON prd_id = dph_id_prd WHERE dph_id_act = act_id 
            AND prd_ano = '$twoya'), 0) + IFNULL((SELECT SUM(IFNULL(dep_monto, 0)) FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd 
            WHERE dep_id_act = act_id AND prd_ano = '$twoya'), 0)) AS saldo_dep_two_year_ago,
            (IFNULL((SELECT SUM(IFNULL(dph_monto, 0)) FROM dph_depreciacion_historica JOIN prd_periodo_deprec ON prd_id = dph_id_prd WHERE dph_id_act = act_id 
            AND prd_ano = '$lasty'), 0) + IFNULL((SELECT SUM(IFNULL(dep_monto, 0)) FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd 
            WHERE dep_id_act = act_id AND prd_ano = '$lasty'), 0)) AS saldo_depreciacion_last_year,
            (IFNULL((SELECT SUM(IFNULL(dph_monto, 0)) FROM dph_depreciacion_historica JOIN prd_periodo_deprec ON prd_id = dph_id_prd WHERE dph_id_act = act_id 
            AND CONCAT(prd_ano, RIGHT(CONCAT('00', prd_mes), 2)) BETWEEN '$inifl' AND '$hasta'), 0) + IFNULL((SELECT SUM(IFNULL(dep_monto, 0)) FROM dep_depreciacion 
            JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_id_act = act_id AND CONCAT(prd_ano, RIGHT(CONCAT('00', prd_mes), 2)) BETWEEN '$inifl' AND '$hasta'), 
            0)) AS depreciacion_anio_filtro,
            (IFNULL((SELECT SUM(IFNULL(dph_monto, 0)) FROM dph_depreciacion_historica JOIN prd_periodo_deprec ON prd_id = dph_id_prd WHERE dph_id_act = act_id 
            AND CONCAT(prd_ano, RIGHT(CONCAT('00', prd_mes), 2)) BETWEEN DATE_FORMAT(act_fecha_adq, '%Y%m') AND '$hasta'), 0) + IFNULL((SELECT SUM(IFNULL(dep_monto, 0)) 
            FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd WHERE dep_id_act = act_id AND CONCAT(prd_ano, RIGHT(CONCAT('00', prd_mes), 2)) 
            BETWEEN DATE_FORMAT(act_fecha_adq, '%Y%m') AND '$hasta'), 0)) AS depreciacion_acumulada", false)
            ->from('act_activo_fijo')
            ->join('grp_grupo', 'grp_id = act_id_grp', 'left')
            ->join('agr_agrupacion_activos', 'agr_id = grp_id_agr', 'left')
            ->order_by('agr_orden, act_id')
        ;
        if ($where) {
            $this->db->where($where);
        }
        $activos = $this->db->get()->result_array();
        $respuesta['activos'] = $activos;
        if ($full && count($activos) > 0) {
            $actIds = array_column($activos, 'act_id');
            $consulta = "SELECT idAct, dYear, SUM(IFNULL(montoH,montoD)) AS monto FROM (
                SELECT dep_id_act AS idAct, prd_ano AS dYear, IFNULL(dep_monto, 0) AS montoD, NULL AS montoH, (SELECT act_estado FROM act_activo_fijo 
                    WHERE act_id = dep_id_act) AS estado FROM dep_depreciacion JOIN prd_periodo_deprec ON prd_id = dep_id_prd 
                    WHERE prd_codigo <= '$hasta'
                UNION ALL
                SELECT dph_id_act AS idAct, prd_ano AS dYear, NULL AS montoD, IFNULL(dph_monto, 0) AS montoH, (SELECT act_estado FROM act_activo_fijo 
                    WHERE act_id = dph_id_act) AS estado FROM dph_depreciacion_historica JOIN prd_periodo_deprec ON prd_id = dph_id_prd 
                    WHERE prd_codigo <= '$hasta'
            ) AS pool WHERE estado = 1 GROUP BY idAct,dYear ORDER BY idAct, dYear";
            $detallado = $this->db->query($consulta)->result_array();
            if (count($detallado) > 0) {
                foreach ($detallado as $k => $v) {
                    $respuesta['historico'][$v['idAct']][$v['dYear']] = $v['monto'];
                }
            }
        }
        return $respuesta;
    }

    public function validar_cantidades($where = null){
      $this->db->select('COUNT(*) as registros, dxd_cantidad')
               ->from('act_activo_fijo')
               ->join('dxd_detalle_documento_proveedor', 'dxd_id = act_id_dxd', 'LEFT')
              ;
            if ($where != null) {
              $this->db->where($where);
            }
          return $this->db->get()->result_array();
    }

    public function obtenerActivosxSolicitud($where = null) {
        $this->db->select("act_nombre as nombre, act_codigo as codigo, GROUP_CONCAT(CONCAT_WS(': ', car_nombre, cxc_valor)SEPARATOR ', ') AS caracteristicas, tac_nombre AS tipo_activo", false)
            ->from('axs_activo_solicitud')
            ->join('act_activo_fijo', 'act_id = axs_id_act')
            ->join('tac_tipo_activofijo', 'tac_id = act_id_tac')
            ->join('cxc_caracterxactivo', 'cxc_id_act = act_id', 'LEFT')
            ->join('cxi_caracteristicaxtipo', 'cxc_id_cxi = cxi_id', 'LEFT')
            ->join('car_caracteristica', 'cxi_id_car = car_id', 'LEFT')
            ->group_by('act_id')
            ;

        if ($where != null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

  function activoxarea_trs_empleado($area=null, $emp=null, $usados=null){
    // $query=$this->db->select()
    //            ->from('act_activo_fijo')
    //            ->join('are_area','are_id=act_id_are')
    //            ->join('axe_activoxempleado', 'axe_id_act = act_id', 'left')
    //            ->join('emp_empleado','axe_id_emp=emp_id', 'left');

    //           $this->db->where('axe_id_act IS NOT NULL', null, false);

    $query=$this->db->select("axe_id_emp AS 'emp_ids', CONCAT(emp_nombre,' ', emp_apellido) AS 'responsables', act_codigo, act_nombre, act_valor_cont, act_id, (SELECT COUNT(*) FROM slt_solicitud_activos
        JOIN axs_activo_solicitud ON axs_id_slt = slt_id
        WHERE slt_estado = 1 AND axs_id_act = axe_id_act AND slt_tipo_solicitud = 1) AS activo_en_solicitud_traslado", false)
               ->from("act_activo_fijo")
               ->join("are_area","are_id=act_id_are")
               ->join("axe_activoxempleado", "axe_id_act=act_id", "left")
               ->join("emp_empleado","axe_id_emp=emp_id", "left")
               ->having('activo_en_solicitud_traslado = 0');

              $this->db->where('axe_id_act IS NOT NULL', null, false);
             

    if($area!=null && $usados!=null){
      $this->db->where('axe_id_are = '.$area.' OR axe_id_act IN ('.$usados.')', null, false);
    }else if($area!=null && $usados==null){
      $this->db->where('axe_id_are', $area);
    }

    if($emp!=null && $usados!=null){
       $this->db->where('axe_id_emp = '.$emp.' OR axe_id_act IN ('.$usados.')', null, false);
    }else if($emp!=null && $usados==null){
      $this->db->where('axe_id_emp', $emp);
    }
    if($usados!=''){
      //$this->db->or_where_in('axe_id_act', $usados);
    }

     $this->db->where('axe_estado', 1)->group_by("act_id");

    return $query->get()->result_array();
  } 

  public function asignarCorrelativo($slt_id){
    $year = date('Y');
    $n = 1;
    $affected_rows = 0;

    $registro = $this->getLastCorrelativo($year);

    if ($registro == null || empty($registro)) {
        $correlativo = "{$n}-{$year}";

        $this->db->where('slt_id', $slt_id );
        $this->db->where('slt_correlativo IS NULL', null, false);      
        $this->db->update('slt_solicitud_activos', array('slt_correlativo' => $correlativo) );
        $affected_rows = $this->db->affected_rows();
    } else {
        $correlativoActual = $registro['slt_correlativo'];
        $partes = explode('-', $correlativoActual);
        if ($partes[1] == $year) {
            $n = $partes[0] + 1;
        }

        $correlativo = "{$n}-{$year}";

        $this->db->where('slt_id', $slt_id );
        $this->db->where('slt_correlativo IS NULL', null, false);
        $this->db->update('slt_solicitud_activos', array('slt_correlativo' => $correlativo) );
        $affected_rows = $this->db->affected_rows();
    }
    return $affected_rows;
}

public function getLastCorrelativo($year){
    $query = "
        SELECT * FROM slt_solicitud_activos WHERE slt_correlativo IS NOT NULL AND slt_correlativo AND RIGHT(slt_correlativo, 4) = '{$year}'
        ORDER BY
        CAST(SUBSTRING_INDEX(slt_correlativo, '-', -1) AS UNSIGNED) DESC,
        CAST(SUBSTRING_INDEX(slt_correlativo, '-', 1) AS UNSIGNED) DESC
        LIMIT 1;
    ";

    $result = $this->db->query($query)->first_row('array');
    return $result;
}    
    public function reporte_solicitud_traslado($where = null) {
        $query = $this->db->select("
            CASE 
              WHEN slt_tipo_movimiento = 1 THEN 'Traslado'
              WHEN slt_tipo_movimiento = 1 THEN 'Prestamo'
              WHEN slt_tipo_movimiento = 1 THEN 'Devolución'
              ELSE 'Traslado'
            END AS tipo_movimiento,
            emp_entrega.emp_nombre as nombre_entrega,
            emp_entrega.emp_apellido as apellido_entrega,
            are_entrega.are_nombre as area_entrega,
            emp_recibe.emp_nombre as nombre_recibe,
            emp_recibe.emp_nombre as apellido_recibe,
            are_recibe.are_nombre as area_recibe,
            slt_fecha_aprobacion,
            act_codigo,
            act_nombre", false)
       ->from("slt_solicitud_activos")
       ->join("axs_activo_solicitud", "axs_id_slt = slt_id")        
       ->join("act_activo_fijo", "act_id = axs_id_act")        
       ->join("emp_empleado emp_entrega", "emp_entrega.emp_id = slt_id_emp_origen")        
       ->join("emp_empleado emp_recibe", "emp_recibe.emp_id = slt_id_emp")        
       ->join("are_area are_entrega", "are_entrega.are_id = emp_entrega.emp_id_are")        
       ->join("are_area are_recibe", "are_recibe.are_id = emp_recibe.emp_id_are")
       ->order_by('slt_id ASC')        
       ->order_by('act_id ASC');

       if ($where) {
        $this->db->where($where);
       }   
        return $query->get()->result_array();

    }
   
}

/* End of file activo_fijo.php */
/* Location: ./application/models/activo_fijo.php */