<?php
class Accion_personal_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    public function get_tabla($tabla,$where=0)
    {    
        $this->db->select();
        if($where!=0)
          $this->db->where($where);
      $this->db->from($tabla);
      $query=$this->db->get();    
      return $query->result_array();
  }

  public function get_horas_extras($where=null) {
    $query= $this->db->select("*, (SELECT tpl_nombre FROM tpl_tipo_planilla JOIN pla_planilla ON pla_id_tpl = tpl_id WHERE pla_id = hxe_id_pla) AS tpl_hxe", false)
            ->from('hxe_hora_extraxempleado')
            ->join('emp_empleado','hxe_hora_extraxempleado.hxe_id_emp = emp_empleado.emp_id')
            ->join('inn_ingreso','inn_ingreso.inn_id_hxe = hxe_hora_extraxempleado.hxe_id', 'left')
            ->join('pla_planilla','hxe_hora_extraxempleado.hxe_id_pla = pla_planilla.pla_id', 'left')
            ->join('the_tipo_hora_extra','hxe_hora_extraxempleado.hxe_id_the = the_tipo_hora_extra.the_id')
            ->join('tpl_tipo_planilla','inn_ingreso.inn_id_tpl = tpl_tipo_planilla.tpl_id', 'left')
            ->join('tig_tipo_ingreso','tig_tipo_ingreso.tig_id = inn_ingreso.inn_id_tig')
            ->group_by('hxe_hora_extraxempleado.hxe_id')
            ->order_by('hxe_hora_extraxempleado.hxe_id','DESC');
            if($where!=null){
                $this->db->where($where);
            }
    
    return $query->get()->result_array();                 
  }

  public function get_horas_faltantes($where=null) {
    $query= $this->db->select("*, (SELECT CONCAT(IFNULL(dpr_numero_eventos,''),'##',IFNULL(dpr_fecha_limite,'')) FROM dpr_detalle_permiso_recurrente 
      WHERE dpr_id_hxe = hxe_id LIMIT 1) AS recurrente", false)
            ->from('hxe_hora_extraxempleado')
            ->join('emp_empleado','hxe_id_emp = emp_id')
            ->join('dss_descuento','dss_id_hxe = hxe_id', 'left')
            ->join('pla_planilla','hxe_id_pla = pla_id', 'left')
            ->join('thf_tipo_hora_faltante','hxe_id_thf = thf_id')
            ->join('tpl_tipo_planilla','dss_id_tpl = tpl_id', 'left')
            //->where('hxe_id_emp',$id_emp)
            ->group_by('hxe_id')
            ->order_by('hxe_id','DESC');
            if($where!=null){
                $this->db->where($where);
            }
     return $query->get()->result_array();       
  }

    /**
    * @author René Castaneda
    * @since 2018-01-09
    * @return información de las vacaciones del empleado
     */
    public function get_vacaciones_empleado($where=null) {
      //planilla2 (pago), planilla1 (goce) (el tpl_tipo_planilla es la del goce)
        $query= $this->db->select("*, 
          IF(inn_id IS NULL, '', CONCAT(IFNULL(tpl_nombre,''),'##',GROUP_CONCAT( DISTINCT CONCAT(IFNULL(tig_nombre,''),'(',IFNULL(inn_fecha_desde,''),')') SEPARATOR '##'))) AS detalle_planilla,
          IF(inn_id IS NULL, 0, GROUP_CONCAT((SELECT pla_estado FROM ddi_detalle_ingreso JOIN pla_planilla ON pla_id = ddi_id_pla WHERE ddi_id_inn = inn_id AND pla_id_tpl = tpl_id))) AS pla_estado
          ",false)
            ->from('gva_goce_vacacion')
            ->join('inn_ingreso',' inn_id_gva = gva_id','left')
            ->join('tpl_tipo_planilla',' tpl_id = inn_id_tpl','left')
            ->join('tig_tipo_ingreso',' tig_id = inn_id_tig','left')
            ->join('vac_vacacion','vac_id = gva_id_vac')
            ->join('prv_periodo_vacacion','prv_id = vac_id_prv')
            ->group_by('gva_id')
            ->order_by('gva_desde','DESC');
            if($where!=null){
                $this->db->where($where);
            }
     return $query->get()->result_array();       
  }

  function get_empleados_vacaciones_generadas($array_id_emp,$id_vac=null) {
    $condicion = ($id_vac)? " and emp_id=$array_id_emp and vac_id=$id_vac ":" and emp_id in (".implode(',', $array_id_emp).")";
      $query = "select *, sum(inn_valor) as monto from gva_goce_vacacion 
      join vac_vacacion on vac_id = gva_id_vac
      join emp_empleado on gva_id_emp = emp_id
      join inn_ingreso on inn_id_gva = gva_id
      join pla_planilla on pla_id = gva_id_pla_pago
      where pla_estado = 2
      $condicion
      GROUP BY vac_id, gva_id_emp";
    return  $this->db->query($query)->result_array();   
  }



  /**
  *@author René Castaneda
  *@return el promedio del total devengado por un empleado basado en una cantidad
  * determinada planillas autorizadas
  */
  function get_promedio_ingreso_empleado($id_empleado=0,$n_num_periodos=null) {
    //$id_empleado = empleado al que se le hara el calculo
    //$n_num_periodos = numero de planillas ya procesadas (autorizadas) para preguntar por los ingresos y hacer un promedio
    //si el dato viene nulo se tomara como valor el parametro preestablecido "NUM_PLANILLAS_CALCULO_VACACION"
    //al final el promedio se obtendra de la suma de los ingresos por planilla 
    //divida entre el numero de planillas encontradas (el limit no me asegura que se encuntre dicha cantidad exacta 
    //asi que lo mas seguro es hacer por el numero de registro devuelto por la consulta)
    if($n_num_periodos) {
      $n_num_periodos=$n_num_periodos;
    }
    else {
      //preguntar por el parametro
      $parametro_calculo_vacacion=$this->gsatelite->get_parametro('NUM_PLANILLAS_CALCULO_VACACION');
      $n_num_periodos = $parametro_calculo_vacacion;
    }
    //NOTA NO SE UTILIZÓ  LA FUNCION AVG O SUM PORQUE EL CALCULO NO SE BASABA EN EL LIMIT Y EL CALCULO ERRA EL ERRONEO

    //OBTENER EL NUMERO DE PLANILLAS ENCONTRADAS SEGUN EL LIMIT
    $query_pla = $this->db->select('ddi_id_pla')
              ->from("ddi_detalle_ingreso")
              ->join("pla_planilla","pla_id = ddi_id_pla")
              ->where("ddi_id_emp",$id_empleado)
              ->where("pla_estado",3) // estado autorizada
              ->group_by("pla_id")
              ->order_by("pla_id","DESC")
              ->limit($n_num_periodos)
              ->get()->result_array();
    $id_planillas = array(0);
    foreach ($query_pla as $fila_pla) {
      $id_planillas[] = $fila_pla['ddi_id_pla'];
    }
    $n_planillas_encontradas = count($query_pla);
   //  print_r($n_planillas_encontradas); die();

    $query = $this->db->select('ddi_valor')
              ->from("ddi_detalle_ingreso")
              ->join("pla_planilla","pla_id = ddi_id_pla")
              ->where("ddi_id_emp",$id_empleado)
              ->where("pla_estado",3) // estado autorizada
              ->where_in('ddi_id_pla',$id_planillas)
              ->order_by("pla_id","DESC")
              ->get()->result_array();
    //     echo $this->db->last_query(); die(); 
     
     $suma_ingresos=0;
     foreach ($query as $fila_v) {
      $suma_ingresos += $fila_v['ddi_valor'];
     }
     $promedio = ($suma_ingresos>0)? round(($suma_ingresos / $n_planillas_encontradas),2):0;
   //  echo $promedio; die();
     return $promedio;
     
  }

  function get_info_solicitud($where = null){
    $this->db->select()
             ->from('slv_solicitud_vacacion')
             ->join('emp_empleado', 'emp_id = slv_id_emp')
             ->join('vac_vacacion', 'vac_id = slv_id_vac')
             ->join('prv_periodo_vacacion', 'prv_id = vac_id_prv')
             ;
    if ($where) {
      $this->db->where($where);
    }    
    return $this->db->get()->result_array();
  }

  function get_horas_extras_reporte($empleado = null, $fecha_ini=null, $fecha_fin=null){
    $this->db->select("emp_codigo, CONCAT(emp_nombre, ' ', emp_apellido) AS nombre, pla_fecha_inicio, pla_fecha_fin, hxe_num_hora, the_factor, 
      (the_factor * hxe_num_hora) AS ctdad_horas, IFNULL(inn_valor,0) AS monto, hxe_fecha, the_nombre", false)
             ->from('emp_empleado')
             ->join('hxe_hora_extraxempleado', 'hxe_id_emp = emp_id')
             ->join('pla_planilla', 'pla_id = hxe_id_pla')
             ->join('the_tipo_hora_extra', 'the_id = hxe_id_the')
             ->join('inn_ingreso', 'inn_id_hxe = hxe_id', 'left')
             ->order_by('emp_id, pla_fecha_corte')
             ;
    if ($empleado != null) {
      $this->db->where('emp_id', $empleado);
    }
    if ($fecha_ini != null) {
      $this->db->where('hxe_fecha >= ', $fecha_ini);
    }
    if ($fecha_fin !=null) {      
      $this->db->where('hxe_fecha <= ', $fecha_fin);
    }
    return $this->db->get()->result_array();
  }

  function get_horas_faltantes_reporte($where = null){
    $this->db->select("emp_codigo, CONCAT(emp_nombre, ' ', emp_apellido) AS nombre, pla_fecha_inicio, pla_fecha_fin, hxe_num_hora, hxe_estado, 
      thf_factor, (thf_factor * hxe_num_hora) AS ctdad_horas, IFNULL(dss_valor, 0) AS monto, hxe_fecha, thf_nombre, mtp_nombre", false)
             ->from('emp_empleado')
             ->join('hxe_hora_extraxempleado', 'hxe_id_emp = emp_id')
             ->join('pla_planilla', 'pla_id = hxe_id_pla', 'left')
             ->join('thf_tipo_hora_faltante', 'thf_id = hxe_id_thf')
             ->join('mtp_motivo_permiso', 'hxe_id_mtp = mtp_id', 'left')
             ->join('dss_descuento', 'dss_id_hxe = hxe_id', 'left')
             ->order_by('emp_id, pla_fecha_corte')
             ;
    if ($where) {
      $this->db->where($where);
    }    
    return $this->db->get()->result_array();
  }

    public function get_resumen_permisos($year, $where = null){
        $horas = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA', 8);
        $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
        $activo = ($empresa == 'ute') ? 1 : 0; //DE MOMENTO UNICAMENTE EN UTE SE VALIDA QUE ESTEN EN ESTADO 2 (AUTORIZADO)
        $query_p = $this->db->select("hxe_id_emp AS empl, CONCAT(1,'_',hxe_id_emp,'_',thf_id) AS llave, DATE_FORMAT(hxe_fecha,'%c') AS mes, hxe_id_thf AS tipo_per,
            SUM(hxe_num_hora) AS horas, thf_nombre AS nombre_per", false)
            ->from('hxe_hora_extraxempleado')
            ->join('thf_tipo_hora_faltante', 'thf_id = hxe_id_thf')
            ->where("hxe_estado > $activo AND DATE_FORMAT(hxe_fecha,'%Y') = $year")
            ->group_by('empl, mes, tipo_per')
        ;
        $result = $query_p->get()->result_array();
        $query_permiso = $this->db->last_query();
        $query_i = $this->db->select("inc_id_emp AS empl, CONCAT(2,'_',inc_id_emp,'_',tnc_id) AS llave, DATE_FORMAT(inc_fecha_inicio,'%c') AS mes, inc_id_tnc AS tipo_per,
            SUM((inc_dias * $horas)) AS horas, tnc_nombre AS nombre_per", false)
            ->from('inc_incapacidad')
            ->join('tnc_tipo_incapacidad', 'tnc_id = inc_id_tnc')
            ->where("inc_estado > 0 AND DATE_FORMAT(inc_fecha_inicio,'%Y') = $year")
            ->group_by('empl, mes, tipo_per')
        ;
        $result = $query_i->get()->result_array();
        $query_incapacidad = $this->db->last_query();        
        $query_final = "SELECT ppal.* FROM (($query_permiso) UNION ($query_incapacidad)) AS ppal JOIN emp_empleado ON emp_id = ppal.empl WHERE emp_estado > 0";
        if ($where != null && is_array($where)) {
            foreach ($where as $key => $value) {
                $query_final .= " AND " . $key . " = " . $value;
            }
        }
        $query_final .= " ORDER BY empl, llave, mes ASC";
        $resultado = $this->db->query($query_final);
        return $resultado->result_array();
    }
  

  public function get_vacaciones_empleado_reporte($where = null) {
    $vac = $this->gsatelite->get_parametro('ID_TIG_VACACION', 0);
    $fac = $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION', 0);
    //planilla2 (pago), planilla1 (goce) (el tpl_tipo_planilla es la del goce)
    $this->db->select(" *,
        pla_planilla1.pla_id_tpl AS p1_pla_id_tpl,
        pla_planilla1.pla_codigo AS p1_pla_codigo,
        pla_planilla1.pla_fecha_inicio AS p1_pla_fecha_inicio,
        pla_planilla1.pla_fecha_pago AS p1_pla_fecha_pago,
        pla_planilla2.pla_id_tpl AS p2_pla_id_tpl,
        pla_planilla2.pla_codigo AS p2_pla_codigo,
        pla_planilla2.pla_fecha_inicio AS p2_pla_fecha_inicio,
        pla_planilla2.pla_fecha_fin AS pla2_fecha_fin,
        pla_planilla2.pla_fecha_pago AS p2_pla_fecha_pago,
        IFNULL((SELECT (ddi_valor) FROM ddi_detalle_ingreso JOIN inn_ingreso ON ddi_id_inn = inn_id 
            WHERE inn_id_tig = $vac AND inn_id_gva = gva_id AND ddi_id_pla = gva_id_pla_pago), 0) AS pago_vacacion,
        IFNULL((SELECT (ddi_valor) FROM ddi_detalle_ingreso JOIN inn_ingreso ON ddi_id_inn = inn_id 
        WHERE inn_id_tig = $fac AND inn_id_gva = gva_id AND ddi_id_pla = gva_id_pla_pago_factor), 0) AS pago_factor,
        IFNULL((SELECT GROUP_CONCAT(DISTINCT IF(TRIM(inn_motivo) != '', TRIM(inn_motivo), '')) FROM inn_ingreso WHERE inn_id_gva = gva_id),'')  AS observaciones
        ", false)
      ->from('gva_goce_vacacion')
      ->join('pla_planilla pla_planilla1','gva_goce_vacacion.gva_id_pla_goce = pla_planilla1.pla_id','left')
      ->join('pla_planilla pla_planilla2','gva_goce_vacacion.gva_id_pla_pago = pla_planilla2.pla_id')
      ->join('tpl_tipo_planilla','pla_planilla2.pla_id_tpl = tpl_tipo_planilla.tpl_id')
      ->join('vac_vacacion','gva_goce_vacacion.gva_id_vac = vac_vacacion.vac_id')
      ->join('prv_periodo_vacacion','vac_vacacion.vac_id_prv = prv_periodo_vacacion.prv_id')
      ->join('emp_empleado','emp_id=gva_id_emp')
      ->where('gva_estado', 1)
      ->group_by('gva_goce_vacacion.gva_id')
      ->order_by('gva_goce_vacacion.gva_desde','ASC')
    ;
    if ($where != null) {
      $this->db->where($where);
    }
    return $this->db->get()->result_array();      
  }

    public function get_acciones_personal_reporte($empleado = null, $tipo = null, $fecha_ini = null, $fecha_fin = null){
        $this->db->select('*')
                 ->from('acp_accion_personal')
                 ->join('emp_empleado', 'emp_id = acp_id_emp')
                 ->join('tac_tipo_accion','tac_id = acp_id_tac')
        ;
        if ($empleado != null) {
            $this->db->where('acp_id_emp', $empleado);
        }
        if ($tipo != null) {
            $this->db->where("acp_id_tac IN($tipo)");
        }
        if ($fecha_ini!='' && $fecha_fin!='') {          
            $this->db->where("((acp_fecha_desde >= '$fecha_ini' AND acp_fecha_desde <= '$fecha_fin') OR (acp_fecha_hasta >= '$fecha_ini' AND acp_fecha_hasta <= '$fecha_fin'))");
        }
        return $this->db->get()->result_array();
    }

    public function get_consumo_permisos($where = null){
        $this->db->select('*')
                 ->from('uhp_uso_horas_permisos')
                 ->join('hxe_hora_extraxempleado','hxe_id = uhp_id_hxe')
                 ->join('emp_empleado', 'emp_id = hxe_id_emp')
                 ->join('thf_tipo_hora_faltante', 'thf_id = hxe_id_thf')
                 ->join('are_area','are_id = emp_id_are', 'left')
                 ->join('cfp_configuracion_tipo_permiso','cfp_id_thf = thf_id', 'left')
        ;
        if ($where) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

  function tipos_incapacidad($where=null){
      $query = $this->db->select('tnc_id, tnc_nombre, tnc_estado, tnc_salario_maximo, tig_id, tig_nombre, tdc_id, tdc_nombre, tnc_horas_ley, tnc_aplica_planilla, (SELECT 
        GROUP_CONCAT(DISTINCT tig_nombre SEPARATOR ", ") FROM cti_configuracion_tipo_incapacidad LEFT JOIN tig_tipo_ingreso ON tig_id = cti_id_tig WHERE cti_id_tnc = tnc_id) AS ingresos', false)
              ->from('tnc_tipo_incapacidad')
              ->join('tig_tipo_ingreso','tnc_id_tig = tig_id','left')
              ->join('tdc_tipo_descuento','tnc_id_tdc= tdc_id','left')
      ;
      if($where != null){
        $this->db->where($where);
      }
      return $query->get()->result_array();
  }

    /**
     * @author Francisco Orozco
     * @since 2017-12-18
     * @param array where
     * @return array retiro de los empleados
     */
    public function get_retiro_empleados($where=NULL) {
      
              $this->db->select('emp_empleado.*, rte_retiro_empleado.*, are_area.are_nombre, gen_nombre,
                               padre.are_nombre as padre, tic_nombre, 
                               TIMESTAMPDIFF(YEAR,`emp_fecha_nac`,CURDATE()) AS edad')
                    ->from('rte_retiro_empleado')
                    ->join('emp_empleado','emp_id = rte_id_emp')
                    ->join('plz_plaza','plz_id = emp_id_plz','left')
                    ->join('are_area','are_id=emp_id_are')
                    ->join('gen_genero', 'gen_id=emp_id_gen')
                    ->join('tic_tipo_contrato',' tic_id = emp_id_tic','left')
                    ->join('`are_area` AS padre','padre.are_id = are_area.are_padre','left')
              ;
      
              if ($where) {
                  $this->db->where($where);
              }
              $this->db->order_by('emp_id,rte_fecha_retiro','asc');
      
              return $this->db->get()->result_array();
      }

    /**
    *@author Raul E.
    *@return tpl seleccionado del ingreso descuento de un goze de vacacion.
    */
    public function get_tpl_vac_inn($where = null){
      $query = $this->db->select('DISTINCT tpl_id', false)
        ->from('gva_goce_vacacion')
        ->join('inn_ingreso', 'inn_id_gva = gva_id')
        ->join('tpl_tipo_planilla', 'tpl_id = inn_id_tpl')
      ;
      if($where != null){
        $this->db->where($where);
      }
      return $query->get()->row();
    }

    public function get_tpl_vac_dss($where = null){
      $query = $this->db->select('DISTINCT tpl_id', false)
        ->from('gva_goce_vacacion')
        ->join('dss_descuento', 'dss_id_gva = gva_id')
        ->join('tpl_tipo_planilla', 'tpl_id = dss_id_tpl')
      ;
      if($where != null){
        $this->db->where($where);
      }
      return $query->get()->row();
    }

    public function get_pla_slctd($where = null, $tipo = 'I'){
      if ($tipo == 'I') {
        $query = $this->db->select('pla_id, inn_id')
          ->from('inn_ingreso')
          ->join('tpl_tipo_planilla', 'inn_id_tpl = tpl_id')
          ->join('ddi_detalle_ingreso', 'ddi_id_inn = inn_id')
          ->join('pla_planilla', 'pla_id = ddi_id_pla')
        ;
      } else {
        $query = $this->db->select('pla_id, dss_id')
          ->from('dss_descuento')
          ->join('tpl_tipo_planilla', 'tpl_id = dss_id_tpl')
          ->join('ddd_detalle_descuento', 'ddd_id_dss = dss_id')
          ->join('pla_planilla', 'pla_id = ddd_id_pla')
        ;
      }
      if($where != null){
        $this->db->where($where);
      }
      return $query->get()->row();
    }


   /**
   *@author René Castaneda
   *@return double salario promediado (si aplica) del empleado segun el agrupador y hacer los calculos respectivos para vacación.
   */
    public function promedio_salario_vacacion_empleado($id_emp = 0) {
               $this->db->join('plz_plaza', 'plz_id = emp_id_plz','left');
               $this->db->join('pto_puesto', 'pto_id = plz_id_pto','left');
        $emp = $this->gsatelite->get_registro('emp_empleado', 'emp_id', $id_emp);
        $salario_emp_vac = $emp->emp_salario;
        $planilla = $this->db->select()->from('pla_planilla')
                 ->join('ddi_detalle_ingreso', 'ddi_id_pla=pla_id')
                 ->where('ddi_id_emp', $id_emp)
                 ->where('pla_estado', 3) //autorizada
                 ->order_by('pla_fecha_inicio', 'DESC')->get()->row()
        ; //ULTIMA PLANILLA AUTORIZADA
        //preguntar si es promediado
        if ($emp->pto_salario_promediado) {
            //consultar las configuraciones
            $configuracion_vacacion = json_decode($this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_VACACION'));
            if (!is_object($configuracion_vacacion)) return null;
            $configuracion_vacacion = (array) $configuracion_vacacion;
            $id_tag_vacacion = (trim($configuracion_vacacion['ID_AGRUPADOR_VACACION']) > 0 ) ? $configuracion_vacacion['ID_AGRUPADOR_VACACION'] : 0;
            $numero_meses = (trim($configuracion_vacacion['NUMERO_MESES_PARA_VACACION']) > 0) ? $configuracion_vacacion['NUMERO_MESES_PARA_VACACION'] : 6;
            $mes = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30);

            //BUSCAR LA FECHA INICIO DE LA VACACION PARA BUSCAR LAS COMISIONES HASTA EL MES INMEDIATO ANTERIOR
                        $this->db->order_by('gva_desde DESC, gva_id DESC');
            $last_gva = $this->db->get_where('gva_goce_vacacion', array('gva_id_emp' => $emp->emp_id, 'gva_estado' => 1), 1)->result_array();
            if (count($last_gva) > 0) {
                $fecha_desde = date_create($last_gva[0]['gva_desde']);
                $fecha_hasta = date_create($last_gva[0]['gva_desde']);
                $fecha_desde->modify("first day of -$numero_meses month");
                $fecha_hasta->modify("last day of last month");
                $f1 = date_format($fecha_desde, 'Y-m-d'); 
                $f2 = date_format($fecha_hasta, 'Y-m-d');
            } else {
                return null; //SI NO HAY VACACION ACTIVA ABORTAR PROCESO 
            }
            $where_dias = array('djm_estado' => 1, 'djm_periodo >= ' => formatear_fecha('Ym', $f1), 'djm_periodo <= ' => formatear_fecha('Ym', $f2));
            $dias_segun_mes = $this->gsatelite->get_tabla('djm_dias_trajado_mes', $where_dias);
            $array_dias_meses = (count($dias_segun_mes) > 0) ? array_column($dias_segun_mes, 'djm_dias','djm_periodo') : array();
            if (count($array_dias_meses) > 0) {
                $fini = $f1; 
                $ffin = $f2;
                $id_tag_vacacion = ($configuracion_vacacion['ID_AGRUPADOR_VACACION_VARIABLE'] > 0) ? $configuracion_vacacion['ID_AGRUPADOR_VACACION_VARIABLE'] : $id_tag_vacacion;
            } else {
                $fecha = date_create($planilla->pla_fecha_inicio);
                date_add($fecha, date_interval_create_from_date_string("-1 month"));
                $ffin_ = date_format($fecha, 'Y-m-01');
                $numero_meses = ($numero_meses - 1); //SE QUITA 1 MES PUES EN LA SECCION ANTERIOR YA SE RECORRIO 1 MES HACIA ATRAS
                $fecha = date_create($ffin_);
                date_add($fecha, date_interval_create_from_date_string("-$numero_meses month"));
                $fini = date_format($fecha, 'Y-m-01');
                $ffin = formatear_fecha('Y-m-t', $ffin_);
            }
            //consultar por los ingresos y descuento segun el agrupador
            $q_ing = $this->db->select("IFNULL(SUM(ddi_valor),0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses, 
                GROUP_CONCAT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y%m')) AS meses_periodo",false)
                    ->from("ddi_detalle_ingreso")
                    ->join("pla_planilla","pla_id = ddi_id_pla")
                    ->where("ddi_id_emp", $emp->emp_id)
                    ->where("pla_estado", 3)
                    ->where("pla_fecha_inicio >=", $fini)
                    ->where("pla_fecha_fin <=", $ffin)
                    ->where("ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag = $id_tag_vacacion AND deg_id_tig IS NOT NULL)")
                    ->get()->row_array();
            $q_des = $this->db->select("IFNULL(SUM(ddd_valor),0) AS descuentos",false)
                    ->from("ddd_detalle_descuento")
                    ->join("pla_planilla","pla_id = ddd_id_pla")
                    ->where("ddd_id_emp", $emp->emp_id)
                    ->where("pla_estado", 3)
                    ->where("pla_fecha_inicio >=", $fini)
                    ->where("pla_fecha_fin <=", $ffin)
                    ->where("ddd_id_tdc in ( SELECT deg_id_tdc from deg_detalle_agrupador where deg_id_tag = $id_tag_vacacion AND deg_id_tdc is not null )")
                    ->get()->row_array();
            
            if (count($array_dias_meses) > 0) {
                $dias_promediar = 0;
                foreach ($array_dias_meses as $k => $v) {
                    $dias_promediar += (trim($v) != "") ? intval($v) : 0;
                }
                $dias_promediar = ($dias_promediar > 0) ? $dias_promediar : $dias_mes;
                $suma_salarios = ($q_ing['ingresos'] > 0) ? ($q_ing['ingresos'] - $q_des['descuentos']) : 0;
                $salario_dia_variable += (($dias_promediar > 0) ? ($suma_salarios / $dias_promediar) : 0);
                if ($salario_dia_variable > 0) {
                    $salario_emp_vac += round(($salario_dia_variable * $mes), 2);
                }
            } else {
                $salario_emp_vac = ($q_ing['ingresos'] > 0 ) ? (($q_ing['ingresos'] - $q_des['descuentos']) / $q_ing['meses']) : $emp->emp_salario;
            }
        }        
        return $salario_emp_vac;

   }

   /**
   * @author René Castaneda
   * @since 2018-01-11
   * @return  Datos detalle
    */
   public function get_detalle_vacacion($where=null)
   {
        $this->db->select("*, (CONCAT(DATE_FORMAT(pla_ing.pla_fecha_inicio, '%d-%m-%Y'), ' # ', DATE_FORMAT(pla_ing.pla_fecha_fin, '%d-%m-%Y'))) ingreso_vacacion, 
                        (CONCAT(DATE_FORMAT(pla_fac.pla_fecha_inicio, '%d-%m-%Y'), ' # ', DATE_FORMAT(pla_fac.pla_fecha_fin, '%d-%m-%Y'))) ingreso_prima, GROUP_CONCAT( DISTINCT inn_observacion ) observaciones", false)
              ->from('gva_goce_vacacion')
              ->join('vac_vacacion','vac_id = gva_id_vac')
              ->join('prv_periodo_vacacion','prv_id = vac_id_prv')
              ->join('emp_empleado','emp_id = gva_id_emp')
              ->join('inn_ingreso','inn_id_gva = gva_id','left')
              ->join('pla_planilla AS pla_ing','pla_ing.pla_id = gva_id_pla_pago','left')
              ->join('pla_planilla AS pla_fac', 'pla_fac.pla_id = gva_id_pla_pago_factor','left')
              ->join('tpl_tipo_planilla','tpl_id = pla_ing.pla_id_tpl or tpl_id = pla_fac.pla_id_tpl','left')
              ->group_by("gva_id")
        ;
        
        if ($where) {
            $this->db->where($where);
        }
        
        return $this->db->get()->result_array();
   }

   /**
    * @author René Castaneda
    * @since 2018-08-27
    * @param array where
    * @return array información de retiro del empleado
    */
   public function get_info_empleado_liquidacion($where = null)
   {
     $this->db->select()
           ->from('emp_empleado')
           ->join('rte_retiro_empleado','rte_id_emp = emp_id')
           ->join('ctr_categoria_retiro','ctr_id = rte_id_ctr', 'left')
           ->join('plz_plaza', 'plz_id = emp_id_plz', 'left')
           ->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
           ->join('lqe_liquidacion_empleado', 'lqe_id_rte = rte_id', 'left')
           ->join('pla_planilla', 'pla_id = lqe_id_pla', 'left')
           ->group_by("rte_id")
     ;
     
     if ($where) {
         $this->db->where($where);
     }
     
     return $this->db->get()->result_array();
   }

    public function get_info_empleado_indem($where = null){
        $this->db->select()
            ->from('emp_empleado')
            ->join('plz_plaza', 'plz_id = emp_id_plz', 'left')
            ->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
            ->join('inv_indemnizacion_voluntaria', 'inv_id_emp = emp_id AND inv_estado = 1', 'left')
            ->join('lqe_liquidacion_empleado', 'lqe_id_inv = inv_id', 'left')
            ->join('pla_planilla', 'pla_id = lqe_id_pla', 'left')
        ;
        if ($where) {
            $this->db->where($where);
        }        
        return $this->db->get()->result_array();
    }

    public function get_datos_permiso($where = null){
        $this->db->select('*, (SELECT plz_nombre FROM plz_plaza WHERE plz_id = emp_id_plz) AS plaza, (SELECT are_nombre FROM are_area WHERE are_id = emp_id_are) AS area', false)
            ->from('hxe_hora_extraxempleado')
            ->join('emp_empleado','emp_id = hxe_id_emp')
            ->join('thf_tipo_hora_faltante','thf_id = hxe_id_thf')
            ->join('tdc_tipo_descuento', 'tdc_id = thf_id_tdc', 'left')
            ->join('dss_descuento', 'dss_id_hxe = hxe_id', 'left')
            ;
        if ($where) {
        $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_datos_permiso_unico($where = null){
        $this->db->select('*, (SELECT plz_nombre FROM plz_plaza WHERE plz_id = emp_id_plz) AS plaza, (SELECT are_nombre FROM are_area WHERE are_id = emp_id_are) AS area', false)
            ->from('hxe_hora_extraxempleado')
            ->join('emp_empleado','emp_id = hxe_id_emp', 'left')
            ->join('thf_tipo_hora_faltante','thf_id = hxe_id_thf', 'left')
            ->join('tdc_tipo_descuento', 'tdc_id = thf_id_tdc', 'left')
            ->join('dss_descuento', 'dss_id_hxe = hxe_id', 'left')
            ;
        if ($where) {
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get()->row_array();
    }


   /**
   * @author René Castaneda
   * @since 31-08-2018
   * @Description: 
   * función para el cálculo del aguinaldo de un empleado
   * @param array object $empleado (información del empleado)
   * @param array object $planilla (información de la planilla)
   * @param int  $es_retiro (saber si es retiro o no. 1=true, 0=false)
   */
    public function calculo_aguinaldo_empleado($emp=null, $emp_fecha_antiguedad=null, $emp_fecha_retiro=null, $aguinaldo_fecha_corte=null, $dias_laborados_aguinaldo=0, $segun_dias_laborados=0) {
        $aguinaldo_fecha_corte = (trim($aguinaldo_fecha_corte) != '')? formatear_fecha("Y-m-d",$aguinaldo_fecha_corte):$emp_fecha_antiguedad;
        $pago_aguinaldo = 0;
        if ( trim($emp_fecha_antiguedad) == '' ) {
            return null;
        }
        $dias_mes = (trim($this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES')) != '' )? $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES') : 30;
        $id_tig_aguinaldo = (trim($this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO')) > 0 )? $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO') : 0;
        $configuracion_aguinaldo = $this->gsatelite->get_parametro('SYS_CONFIGURACION_AGUINALDO'); //consultar las configuraciones
        $configuracion_aguinaldo = json_decode($configuracion_aguinaldo);
        if (!is_object($configuracion_aguinaldo)) return null;
        $configuracion_aguinaldo = (array) $configuracion_aguinaldo;
        $dias_anio_aguinaldo = (trim($configuracion_aguinaldo['DIAS_ANIO_AGUINALDO']) > 0 ) ? $configuracion_aguinaldo['DIAS_ANIO_AGUINALDO'] : 0;
        $n = $this->gsatelite->get_intervalo_dias($emp_fecha_antiguedad, $emp_fecha_retiro); //ENTRE FECHA DE INGRESO Y DE RETIRO
        $n_dias = $n + 1;
        $n_dias_ = $this->gsatelite->get_intervalo_dias($aguinaldo_fecha_corte, $emp_fecha_retiro); //ENTRE ULTIMO AGUINALDO Y RETIRO
        $n_dias_ = $n_dias_ + 1;
        $dias_considerados = $n_dias_;
        // var_dump($aguinaldo_fecha_corte, $emp_fecha_retiro, $dias_considerados);die();
        $dias_considerados = ($dias_laborados_aguinaldo > 0) ? $dias_laborados_aguinaldo : $dias_considerados;
        $anios_trabajado = $n_dias/365; //determinar los anios trabajados en la empresa.
        $salario_emp_agui = $emp->emp_salario;
        // $variable = false;
        $meses = (trim($configuracion_aguinaldo['NUMERO_MESES_PARA_AGUINALDO']) > 0) ? $configuracion_aguinaldo['NUMERO_MESES_PARA_AGUINALDO'] : 6;
        $id_tag_aguinaldo = (trim($configuracion_aguinaldo['ID_AGRUPADOR_AGUINALDO']) > 0) ? $configuracion_aguinaldo['ID_AGRUPADOR_AGUINALDO'] : 0;
        //preguntar si es promediado
        // var_dump($emp->pto_salario_promediado);die();
        if ($emp->pto_salario_promediado > 0) {
            $fecha_desde = date_create($emp_fecha_retiro);
            $fecha_hasta = date_create($emp_fecha_retiro);
            $fecha_desde->modify("first day of -$meses month");
            $fecha_hasta->modify("last day of last month");
            $fini = date_format($fecha_desde, 'Y-m-d'); 
            $ffin = date_format($fecha_hasta, 'Y-m-d');  
            if ($segun_dias_laborados > 0) {
                //SI SE MARCO EN BASE A DIAS SE BUSCAN LOS DIAS LABORALES Y HACE EL CALCULO DEL PROMEDIO DE COMISIONES QUE SE SUMA AL SALARIO
                $where_dias = array('djm_estado' => 1, 'djm_periodo >= ' => formatear_fecha('Ym', $fini), 'djm_periodo <= ' => formatear_fecha('Ym', $ffin));
                $dias_segun_mes = $this->gsatelite->get_tabla('djm_dias_trajado_mes', $where_dias); 
                $array_dias_meses = (count($dias_segun_mes) > 0) ? array_column($dias_segun_mes, 'djm_dias', 'djm_periodo') : array();
                $id_tag_aguinaldo_variable = (trim($configuracion_aguinaldo['ID_AGRUPADOR_AGUINALDO_VARIABLE']) > 0) ? $configuracion_aguinaldo['ID_AGRUPADOR_AGUINALDO_VARIABLE'] : 0;
                $agrupador = ($id_tag_aguinaldo_variable > 0) ? $id_tag_aguinaldo_variable : $id_tag_aguinaldo;
                $q_ing_v = $this->db->select("IFNULL(SUM(ddi_valor),0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses, 
                    GROUP_CONCAT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y%m')) AS meses_periodo",false)
                    ->from("ddi_detalle_ingreso")
                    ->join("pla_planilla","pla_id = ddi_id_pla")
                    ->where("ddi_id_emp", $emp->emp_id)
                    ->where("pla_estado", 3)
                    ->where("pla_fecha_inicio >=", $fini)
                    ->where("pla_fecha_fin <=", $ffin)
                    ->where("ddi_id_tig IN ( SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag = $agrupador AND deg_id_tig IS NOT NULL )")
                    ->get()->row_array()
                ;
                $q_des_v = $this->db->select("IFNULL(SUM(ddd_valor),0) AS descuentos",false)
                    ->from("ddd_detalle_descuento")
                    ->join("pla_planilla","pla_id = ddd_id_pla")
                    ->where("ddd_id_emp", $emp->emp_id)
                    ->where("pla_estado", 3)
                    ->where("pla_fecha_inicio >=", $fini)
                    ->where("pla_fecha_fin <=", $ffin)
                    ->where("ddd_id_tdc IN ( SELECT deg_id_tdc FROM deg_detalle_agrupador WHERE deg_id_tag = $agrupador AND deg_id_tdc IS NOT NULL )")
                    ->get()->row_array()
                ;
                $suma_salarios = ($q_ing_v['ingresos'] > 0) ? ($q_ing_v['ingresos'] - $q_des_v['descuentos']) : 0;
                $salario_dia_variable = $salario_emp_agui / $dias_mes;
                if($suma_salarios > 0) {
                    $dias_promediar = 0;
                    foreach ($array_dias_meses as $k => $v) {
                        $dias_promediar += (trim($v) != "") ? intval($v) : 0;
                    }
                    $dias_promediar = ($dias_promediar > 0) ? $dias_promediar : $dias_mes;
                    $salario_dia_variable += (($dias_promediar > 0) ? ($suma_salarios / $dias_promediar) : 0);
                }
                $salario_emp_agui = ($salario_dia_variable > 0) ? round( ($salario_dia_variable * $dias_mes), 2) : $emp->emp_salario;;
            } else {
                //SI NO ES POR DIAS SE HARA EL PROMEDIO DE LOS INGRESOS DE 6 MESES
                $q_ing = $this->db->select("IFNULL(SUM(ddi_valor), 0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio, '%Y-%m')) AS meses, 
                    GROUP_CONCAT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y%m')) AS meses_periodo", false)
                    ->from("ddi_detalle_ingreso")
                    ->join("pla_planilla","pla_id = ddi_id_pla")
                    ->where("ddi_id_emp", $emp->emp_id)
                    ->where("pla_estado", 3)
                    ->where("pla_fecha_inicio >=", $fini)
                    ->where("pla_fecha_fin <=", $ffin)
                    ->where("ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag = $id_tag_aguinaldo AND deg_id_tig IS NOT NULL )")
                    ->get()->row_array()
                ;
                $q_des = $this->db->select("IFNULL(SUM(ddd_valor),0) AS descuentos", false)
                    ->from("ddd_detalle_descuento")
                    ->join("pla_planilla","pla_id = ddd_id_pla")
                    ->where("ddd_id_emp", $emp->emp_id)
                    ->where("pla_estado", 3)
                    ->where("pla_fecha_inicio >=", $fini)
                    ->where("pla_fecha_fin <=", $ffin)
                    ->where("ddd_id_tdc in ( SELECT deg_id_tdc FROM deg_detalle_agrupador WHERE deg_id_tag = $id_tag_aguinaldo AND deg_id_tdc IS NOT NULL )")
                    ->get()->row_array()
                ;
                $salario_emp_agui = ($q_ing['ingresos'] > 0 ) ? (($q_ing['ingresos'] - $q_des['descuentos']) / $q_ing['meses']) : $emp->emp_salario;
            }
            /*
              CODIGO ANTERIOR
              $dias_segun_mes = $this->gsatelite->get_tabla('djm_dias_trajado_mes', array('djm_estado'=>1));
              $array_dias_meses = ($dias_segun_mes) ? array_column($dias_segun_mes, 'djm_dias','djm_periodo') : array();
              $dias_segun_mes = ($segun_dias_laborados) ? $dias_segun_mes : null;
              $id_tag_aguinaldo_variable = (trim($configuracion_aguinaldo['ID_AGRUPADOR_AGUINALDO_VARIABLE']) > 0 )? $configuracion_aguinaldo['ID_AGRUPADOR_AGUINALDO_VARIABLE']:0;
              $numero_meses = (trim($configuracion_aguinaldo['NUMERO_MESES_PARA_AGUINALDO']) > 0 )? $configuracion_aguinaldo['NUMERO_MESES_PARA_AGUINALDO']:6;
              $id_tag_aguinaldo = (trim($configuracion_aguinaldo['ID_AGRUPADOR_AGUINALDO']) > 0 )? $configuracion_aguinaldo['ID_AGRUPADOR_AGUINALDO']:0;
              //preguntar por los meses anteriores excluyendo el actual
              $fecha = date_create($emp_fecha_retiro); //31-MARZO
              date_add($fecha, date_interval_create_from_date_string("-1 month")); //"30 de feb" deberia ser  sale 3-mar 
              $ffin_ = date_format($fecha, 'Y-m-01'); //deberia ser 1-fe, sale 1-mar 
              $numero_meses = ($numero_meses - 1);
              $fecha = date_create($ffin_); ////deberia ser 1-fe, sale 1-mar 
              date_add($fecha, date_interval_create_from_date_string("-$numero_meses month")); 
              $fini = date_format($fecha, 'Y-m-01'); //1-OCT DEBERIA SER 1-SEP
              $ffin = formatear_fecha('Y-m-t', $ffin_);//SALE 31-MAR  DEBEIA SER 28-FEB
              //consultar por los ingresos y descuento segun el agrupador (fijo) 
              $q_ing = $this->db->select("IFNULL(SUM(ddi_valor),0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses, GROUP_CONCAT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y%m')) AS meses_periodo",false)
                         ->from("ddi_detalle_ingreso")
                         ->join("pla_planilla","pla_id = ddi_id_pla")
                         ->where("ddi_id_emp", $emp->emp_id)
                         ->where("pla_estado", 3) //solo autorizadas
                         ->where("pla_fecha_inicio >=", $fini)
                         ->where("pla_fecha_fin <=", $ffin)
                         ->where("ddi_id_tig in ( SELECT deg_id_tig from deg_detalle_agrupador where deg_id_tag = $id_tag_aguinaldo AND deg_id_tig is not null )")
                         ->get()->row_array()
                         ;
              $q_des = $this->db->select("IFNULL(SUM(ddd_valor),0) AS descuentos",false)
                         ->from("ddd_detalle_descuento")
                         ->join("pla_planilla","pla_id = ddd_id_pla")
                         ->where("ddd_id_emp", $emp->emp_id)
                         ->where("pla_estado", 3) //solo autorizadas
                         ->where("pla_fecha_inicio >=", $fini)
                         ->where("pla_fecha_fin <=", $ffin)
                         ->where("ddd_id_tdc in ( SELECT deg_id_tdc from deg_detalle_agrupador where deg_id_tag = $id_tag_aguinaldo AND deg_id_tdc is not null )")
                         ->get()->row_array()
                         ;
              $salario_emp_agui = ($q_ing['ingresos'] > 0 ) ? (($q_ing['ingresos'] - $q_des['descuentos']) / $q_ing['meses']) : $emp->emp_salario; //705/2 = 362.50
              //consultar por los ingresos y descuento segun el agrupador (variable)
              if($dias_segun_mes && $id_tag_aguinaldo_variable > 0){
                $variable = true;
                //obtener el salario promediado fijo a los numero de dias según el parametro)
                $salario_dia_variable = $salario_emp_agui/$dias_mes;
                $q_ing_v = $this->db->select("IFNULL(SUM(ddi_valor),0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses, GROUP_CONCAT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y%m')) AS meses_periodo",false)
                          ->from("ddi_detalle_ingreso")
                          ->join("pla_planilla","pla_id = ddi_id_pla")
                          ->where("ddi_id_emp", $emp->emp_id)
                          ->where("pla_estado", 3) //solo autorizadas
                          ->where("pla_fecha_inicio >=", $fini)
                          ->where("pla_fecha_fin <=", $ffin)
                          ->where("ddi_id_tig in ( SELECT deg_id_tig from deg_detalle_agrupador where deg_id_tag = $id_tag_aguinaldo_variable AND deg_id_tig is not null )")
                          ->get()->row_array()
                          ;
                //print_r($this->db->last_query()); die();   //para debuger
                $q_des_v = $this->db->select("IFNULL(SUM(ddd_valor),0) AS descuentos",false)
                          ->from("ddd_detalle_descuento")
                          ->join("pla_planilla","pla_id = ddd_id_pla")
                          ->where("ddd_id_emp", $emp->emp_id)
                          ->where("pla_estado", 3) //solo autorizadas
                          ->where("pla_fecha_inicio >=", $fini)
                          ->where("pla_fecha_fin <=", $ffin)
                          ->where("ddd_id_tdc in ( SELECT deg_id_tdc from deg_detalle_agrupador where deg_id_tag = $id_tag_aguinaldo_variable AND deg_id_tdc is not null )")
                          ->get()->row_array()
                          ;
                $salario_emp_agui_v = ($q_ing_v['ingresos'] > 0 )? ($q_ing_v['ingresos'] - $q_des_v['descuentos']):0;
                if($q_ing_v && $salario_emp_agui_v > 0) {
                    $dias_promediar = 0;
                    $datos_periodo = explode(',', $q_ing_v['meses_periodo']);
                    for($j = 0; $j < count($datos_periodo); $j++) {
                        $dias_promediar += (array_key_exists($datos_periodo[$j], $array_dias_meses)) ? intval($array_dias_meses[$datos_periodo[$j]]) : $dias_mes;
                    }
                    $salario_dia_variable += (($dias_promediar > 0) ? ($salario_emp_agui_v/$dias_promediar):0);                
                }
              }
            */
        }
        $salary_by_incomes = $this->get_ultimo_ingreso_plan($emp->emp_id);
        $salario_emp_agui = ($salario_emp_agui > 0) ? $salario_emp_agui : $salary_by_incomes;
        $salario_dia = ($salario_emp_agui / $dias_mes);
        $pregunta_goze = $this->gsatelite->get_tabla('agd_aguinaldo', array('agd_estado' => 1));
        $dias_goze = 0;
        foreach ($pregunta_goze as $fpregunta) {
            if ($anios_trabajado >= $fpregunta['agd_desde'] and $anios_trabajado <= $fpregunta['agd_hasta']) {
                $dias_goze = $fpregunta['agd_dias_derecho'];
            }
        }
        // var_dump($salario_emp_agui, $salario_dia, $dias_goze);die();
        $salario_dias_ley = $salario_dia * $dias_goze;
        // var_dump($salario_dias_ley); die();
        $dias_anio_aguinaldo = ($dias_anio_aguinaldo > 365) ? 365 : $dias_anio_aguinaldo;
        // var_dump($salario_dias_ley, $dias_considerados, $dias_anio_aguinaldo);die();
        $pago_aguinaldo = ($salario_dias_ley * $dias_considerados) / $dias_anio_aguinaldo; //calculo de los dias de goze.
        // var_dump($pago_aguinaldo); die();
        return $pago_aguinaldo;
    }

    /**
    * @author René Castaneda
    * @since 01-09-2018
    * @Description: 
    * Función para el cálculo de vacación a un empleado
    */
    public function calculo_vacacion_empleado($emp = null, $emp_fecha_contrato = null, $emp_fecha_retiro = null, $base_dias_laboral = 0 ){
        $es_retiro = true;
        $porcentaje_vacacion[0] = 100; //% vacación
        $porcentaje_vacacion[1] = 100; //% prima vacación
        $monto_vacacion['vacacion'] = 0;
        $monto_vacacion['prima'] = 0;
        //consultar las configuraciones
        $configuracion_vacacion = $this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_VACACION'); 
        $dias_mes = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30);
        //numero de dias trabajados para tener derecho a vacación.
        $numero_dias_aplica_vacacion = $this->gsatelite->get_parametro('NUM_DIAS_APLICA_VACACION');
        $numero_dias_aplica_vacacion = ($numero_dias_aplica_vacacion > 0) ? $numero_dias_aplica_vacacion : 1; 
        $configuracion_vacacion = json_decode($configuracion_vacacion);
        if (!is_object($configuracion_vacacion)) return null;
        $configuracion_vacacion = (array) $configuracion_vacacion;
        $dias_anio_vacacion = (trim($configuracion_vacacion['DIAS_ANIO_VACACION']) > 0 ) ? $configuracion_vacacion['DIAS_ANIO_VACACION'] : 0;
        $n = $this->gsatelite->get_intervalo_dias($emp_fecha_contrato, $emp_fecha_retiro);
        $n_dias = $dias_rango = $n + 1;
        //if ($n <= 0) { return null;} //si dio negativa detener el proceso.       
        $dias_considerados = ($n_dias >= $dias_anio_vacacion) ? $dias_anio_vacacion : $n_dias; //el menor de ambos casos
        if($base_dias_laboral) {
            // SI SE QUIERE MODIFICAR EL CALCULO DE DIAS SE DEBE LLENAR LA TABLA djv_dias_trajado_vacacion SI ESTA VACIA, SE MANTIENE LA CANTIDAD DE DIAS ANTES CALCULADA
            // EJEMPLO EN 2 MESES "NORMALES" SERIAN 60 DIAS PERO SI EXISTEN EN LA TABLA COMO 25/27, NO SERA SALARIO_DIARIO x 60, SINO SALARIO_DIARIO x 52  
            $dias_segun_mes = $this->gsatelite->get_tabla('djv_dias_trajado_vacacion', array('djv_estado' => 1));
            $array_dias_meses = ($dias_segun_mes) ? array_column($dias_segun_mes, 'djv_dias', 'djv_periodo') : array();
            if($dias_segun_mes) {
                $mes_incluido = true;
                $fecha_ini_p = formatear_fecha('Ym',$emp_fecha_contrato);
                $fecha_fin_p = formatear_fecha('Ym',$emp_fecha_retiro);
                $dias_segun_periodo = 0;
                $mes_contador = 0;
                while ($mes_incluido) {
                    $fecha_periodo = date_create($emp_fecha_contrato);
                    date_add($fecha_periodo, date_interval_create_from_date_string("+$mes_contador month")); ///////////// + 0,1,2,3 ..... meses
                    $ffin_periodo = date_format($fecha_periodo, 'Ym');
                    // var_dump($ffin_periodo);var_dump( intval( $array_dias_meses[$ffin_periodo] ) ); echo " | "; 
                    $dias_segun_periodo += (array_key_exists($ffin_periodo, $array_dias_meses)) ? intval($array_dias_meses[$ffin_periodo]) : 0;
                    if($ffin_periodo == $fecha_fin_p) {
                        $mes_incluido = false;
                    }
                    $mes_contador++;
                }
                $dias_considerados = ($dias_segun_periodo > 0) ? $dias_segun_periodo : $dias_considerados;
            }
        }
        $anio_dif = (formatear_fecha('Y',$emp_fecha_contrato) - formatear_fecha('Y',$emp_fecha_contrato));
        $fecha = date_create($emp->emp_fecha_contrato);
        date_add($fecha, date_interval_create_from_date_string("+$anio_dif year")); //cuadrar al año actual
        $fecha_con = date_format($fecha, 'Y-m-d'); 
        $date_1 = new DateTime($fecha_con); 
        $date_2 = new DateTime($emp_fecha_contrato); 
        $date_3 = new DateTime($emp_fecha_retiro); 
        $aniversario = ($date_1 >= $date_2 && $date_1 <= $date_3 ) ? true : false; //preguntar si tiene aniversario
        //si posee los dias de antiguedad laborados que aplique la vacación o que se trate de un retiro
        if ( $aniversario == true && ($n_dias >= $numero_dias_aplica_vacacion) || ($es_retiro == true and $n_dias >= 1 )) {            
            $porcentaje_vac = (trim($this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION')) != '' )? $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION') : 0.3;
            $id_tig_vacacion = (trim($this->gsatelite->get_parametro('ID_TIG_VACACION')) > 0 ) ? $this->gsatelite->get_parametro('ID_TIG_VACACION') : 0;
            $id_tig_vacacion_prima = (trim($this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION')) > 0 )? $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION') : 0;
            $salario_emp_vac = $emp->emp_salario;
            //preguntar si es promediado
            if ($emp->pto_salario_promediado) {
                $numero_meses = (trim($configuracion_vacacion['NUMERO_MESES_PARA_VACACION']) > 0) ? $configuracion_vacacion['NUMERO_MESES_PARA_VACACION'] : 6;
                $id_tag_vacacion = ($configuracion_vacacion['ID_AGRUPADOR_VACACION'] > 0) ? $configuracion_vacacion['ID_AGRUPADOR_VACACION'] : 0;
                // SI MARCO EN BASE A DIAS SE HACE SUMA DE COMISIONES DE 6 MESES ATRAS ENTRE SUMA DE DIAS SEGUN TABLA djm_dias_trajado_mes
                if ($base_dias_laboral > 0) {
                    $id_tag_vacacion = ($configuracion_vacacion['ID_AGRUPADOR_VACACION_VARIABLE'] > 0) ? $configuracion_vacacion['ID_AGRUPADOR_VACACION_VARIABLE'] : $id_tag_vacacion;
                    $fecha_desde = date_create($emp_fecha_retiro);
                    $fecha_hasta = date_create($emp_fecha_retiro);
                    $fecha_desde->modify("first day of -$numero_meses month");
                    $fecha_hasta->modify("last day of last month");
                    $fini = date_format($fecha_desde, 'Y-m-d'); 
                    $ffin = date_format($fecha_hasta, 'Y-m-d');
                } else {
                    //preguntar por los meses anteriores excluyendo el actual
                    $fecha = date_create($emp_fecha_contrato);
                    date_add($fecha, date_interval_create_from_date_string("-1 month")); 
                    $ffin_ = date_format($fecha, 'Y-m-01'); 
                    $fecha = date_create($ffin_);
                    date_add($fecha, date_interval_create_from_date_string("-$numero_meses month")); 
                    $fini = date_format($fecha, 'Y-m-01'); 
                    $ffin = formatear_fecha('Y-m-t', $ffin_);
                }
                //consultar por los ingresos y descuento segun el agrupador
                $q_ing = $this->db->select("IFNULL(SUM(ddi_valor),0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses", false)
                    ->from("ddi_detalle_ingreso")
                    ->join("pla_planilla","pla_id = ddi_id_pla")
                    ->where("ddi_id_emp", $emp->emp_id)
                    ->where("pla_estado", 3)
                    ->where("pla_fecha_inicio >=", $fini)
                    ->where("pla_fecha_fin <=", $ffin)
                    ->where("ddi_id_tig in ( SELECT deg_id_tig from deg_detalle_agrupador where deg_id_tag = $id_tag_vacacion AND deg_id_tig is not null )")
                    ->get()->row_array()
                ;
                $q_des = $this->db->select("IFNULL(SUM(ddd_valor),0) AS descuentos",false)
                    ->from("ddd_detalle_descuento")
                    ->join("pla_planilla","pla_id = ddd_id_pla")
                    ->where("ddd_id_emp", $emp->emp_id)
                    ->where("pla_estado", 3)
                    ->where("pla_fecha_inicio >=", $fini)
                    ->where("pla_fecha_fin <=", $ffin)
                    ->where("ddd_id_tdc in ( SELECT deg_id_tdc from deg_detalle_agrupador where deg_id_tag = $id_tag_vacacion AND deg_id_tdc is not null )")
                    ->get()->row_array()
                ;
                //obtener el salario promediado.
                if ($base_dias_laboral > 0) {
                    $where_dias = array('djm_estado' => 1, 'djm_periodo >= ' => formatear_fecha('Ym', $fini), 'djm_periodo <= ' => formatear_fecha('Ym', $ffin));
                    $dias_segun_mes = $this->gsatelite->get_tabla('djm_dias_trajado_mes', $where_dias); 
                    $array_dias_meses = (count($dias_segun_mes) > 0) ? array_column($dias_segun_mes, 'djm_dias', 'djm_periodo') : array();
                    $suma_salarios = ($q_ing['ingresos'] > 0) ? ($q_ing['ingresos'] - $q_des['descuentos']) : 0;
                    $salario_dia_variable = $salario_emp_vac / $dias_mes;
                    if($suma_salarios > 0) {
                        $dias_promediar = 0;
                        foreach ($array_dias_meses as $k => $v) {
                            $dias_promediar += (trim($v) != "") ? intval($v) : 0;
                        }
                        $dias_promediar = ($dias_promediar > 0) ? $dias_promediar : $dias_mes;
                        $salario_dia_variable += (($dias_promediar > 0) ? ($suma_salarios / $dias_promediar) : 0);
                    }
                    $salario_emp_vac = ($salario_dia_variable > 0) ? round(($salario_dia_variable * $dias_mes), 2) : $emp->emp_salario;
                } else {
                    $salario_emp_vac = ($q_ing['ingresos'] > 0 ) ? (($q_ing['ingresos'] - $q_des['descuentos']) / $q_ing['meses']) : $emp->emp_salario;
                }
            } 
            $salary_by_incomes = $this->get_ultimo_ingreso_plan($emp->emp_id);
            $salario_emp_vac = ($salario_emp_vac > 0) ? $salario_emp_vac : $salary_by_incomes;
            $metodo_vacacion = $this->gsatelite->get_parametro('METODO_CALCULO_VACACION');
            if ($metodo_vacacion == 3) {
                //3 periodos de 7 dias c/u 21 dias en total
                $salario_dia = $salario_emp_vac / $dias_mes;
                $anio_ini = '01-01-' . formatear_fecha('Y', $emp_fecha_retiro);
                $anio_fin = '31-12-' . formatear_fecha('Y', $emp_fecha_retiro);
                $anio = ($this->gsatelite->get_intervalo_dias($anio_ini, $anio_fin) + 1);
                $periodo_plan = $this->gsatelite->get_intervalo_dias($emp_fecha_contrato, $emp_fecha_retiro);
                if ($es_retiro) {
                    $salario_completo = ($salario_dia * 21);
                    $vacacion_completa = ($salario_completo * $porcentaje_vac);
                    $salario_dias_ley = (($salario_completo / $anio) * ($periodo_plan + 1));
                    $porcentaje_vacacion = (($vacacion_completa / $anio) * ($periodo_plan + 1));                
                } else {
                    $salario_dias_ley = (($salario_dia * 15) / $anio) * $periodo_plan;
                    $porcentaje_vacacion = $salario_dias_ley * $porcentaje_vac;
                }              
            } else {
                $salario_dia = $salario_emp_vac / $dias_mes; 
                $salario_dias_ley = $salario_dia * (($configuracion_vacacion['DIAS_LEY_VACACION'] > 0)? $configuracion_vacacion['DIAS_LEY_VACACION'] : 15);
                $porcentaje_vacacion = $salario_dias_ley * $porcentaje_vac;
                $salario_dias_ley = ($salario_dias_ley * $dias_considerados) / $dias_anio_vacacion;
                $porcentaje_vacacion = ($porcentaje_vacacion * $dias_considerados) / $dias_anio_vacacion;
            }
            $monto_vacacion['vacacion'] = $salario_dias_ley;
            $monto_vacacion['prima'] = $porcentaje_vacacion;
            return $monto_vacacion;
        }
    }


    /**
    * @author René Castaneda
    * @since 03-09-2018
    * @Description: 
    * función para el cálculo del indemnización de un empleado
    */
    public function calculo_indemnizacion_empleado($emp = null, $fecha_ult_liq = null, $base_salario_minimo = 0, $segun_dias_laborados = 0, $renuncia_voluntaria = 0, $fecha_hasta = null){
        if (trim($fecha_ult_liq) == '') {
            return null;
        }
        $rte_fecha_retiro = $this->gsatelite->get_tabla('rte_retiro_empleado', array('rte_estado' => 1, 'rte_id_emp' => $emp->emp_id));
        $fecha_retiro = (trim($emp->emp_fecha_retiro) != "") ? $emp->emp_fecha_retiro : formatear_fecha('Y-m-d', $rte_fecha_retiro[0]['rte_fecha_retiro']); 
        // SI ES RETIRO, AQUI DEBERA QUEDAR UNA FECHA Y $fecha_hasta SERA NULL, SINO ES QUE SOLO ESTA PIDIENDO SU TIEMPO
        $fecha_retiro = ($fecha_hasta) ? $fecha_hasta : $fecha_retiro;  
        $dias_mes = (trim($this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES')) != '' )? $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES') : 30;
        $salario_minimo = $this->gsatelite->get_parametro('MONTO_SALARIO_MINIMO');
        $id_tig_indemnizacion = (trim($this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION')) > 0 ) ? $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION') : 0;
        $configuracion_indemnizacion = $this->gsatelite->get_parametro('SYS_CONFIGURACION_INDEMNIZACION'); //consultar las configuraciones
        $configuracion_indemnizacion = json_decode($configuracion_indemnizacion);
        if (!is_object($configuracion_indemnizacion)) return null;
        $configuracion_indemnizacion = (array) $configuracion_indemnizacion;
        $n = $this->gsatelite->get_intervalo_dias($fecha_ult_liq, $fecha_retiro);
        $n_dias = $n + 1;
        if ($renuncia_voluntaria > 0) {
            $suma_salarios = $salario_minimo * $configuracion_indemnizacion['NUM_CANTIDAD_SALARIO_MINIMO_VOLUNTARIO'];//730
        } else {
            $suma_salarios = $salario_minimo * $configuracion_indemnizacion['NUM_CANTIDAD_SALARIO_MINIMO'];//1460
        }
        $salario_emp_indem = $emp->emp_salario;
        // var_dump($salario_emp_indem, $emp->pto_salario_promediado);die();
        if ($emp->pto_salario_promediado) {
            //preguntar si es promediado
            $id_tag_indemnizacion = (trim($configuracion_indemnizacion['ID_AGRUPADOR_INDEMNIZACION']) > 0) ? $configuracion_indemnizacion['ID_AGRUPADOR_INDEMNIZACION'] : 0;
            $numero_meses = (trim($configuracion_indemnizacion['NUMERO_MESES_PARA_INDEMNIZACION']) > 0) ? $configuracion_indemnizacion['NUMERO_MESES_PARA_INDEMNIZACION'] : 6;
            $fecha_desde = date_create($fecha_retiro);
            $fecha_hasta = date_create($fecha_retiro);
            $fecha_desde->modify("first day of -$numero_meses month");
            $fecha_hasta->modify("last day of last month");
            $fini = date_format($fecha_desde, 'Y-m-d'); 
            $ffin = date_format($fecha_hasta, 'Y-m-d');
            // var_dump($fini, $ffin);die();
            $q_ing = $this->db->select("IFNULL(SUM(ddi_valor), 0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses",false)
                ->from("ddi_detalle_ingreso")
                ->join("pla_planilla","pla_id = ddi_id_pla")
                ->where("ddi_id_emp", $emp->emp_id)
                ->where("pla_estado", 3)
                ->where("pla_fecha_inicio >=", $fini)
                ->where("pla_fecha_fin <=", $ffin)
                ->where("ddi_id_tig in ( SELECT deg_id_tig from deg_detalle_agrupador where deg_id_tag = $id_tag_indemnizacion AND deg_id_tig is not null )")
                ->get()->row_array()
            ;
            $q_des = $this->db->select("IFNULL(SUM(ddd_valor),0) AS descuentos",false)
                ->from("ddd_detalle_descuento")
                ->join("pla_planilla","pla_id = ddd_id_pla")
                ->where("ddd_id_emp", $emp->emp_id)
                ->where("pla_estado", 3)
                ->where("pla_fecha_inicio >=", $fini)
                ->where("pla_fecha_fin <=", $ffin)
                ->where("ddd_id_tdc in ( SELECT deg_id_tdc from deg_detalle_agrupador where deg_id_tag = $id_tag_indemnizacion AND deg_id_tdc is not null )")
                ->get()->row_array()
            ; 
            if ($segun_dias_laborados > 0) {
                $where_dias = array('djm_estado' => 1, 'djm_periodo >= ' => formatear_fecha('Ym', $fini), 'djm_periodo <= ' => formatear_fecha('Ym', $ffin));
                $dias_segun_mes = $this->gsatelite->get_tabla('djm_dias_trajado_mes', $where_dias); 
                $array_dias_meses = (count($dias_segun_mes) > 0) ? array_column($dias_segun_mes, 'djm_dias', 'djm_periodo') : array();
                $suma_salarios_com = ($q_ing['ingresos'] > 0) ? ($q_ing['ingresos'] - $q_des['descuentos']) : 0;
                $salario_dia_variable = $salario_emp_indem / $dias_mes;
                // var_dump($salario_dia_variable, $suma_salarios_com);die();//salario x dia base / suma de las comismiones 
                if($suma_salarios_com > 0) {
                    $dias_promediar = 0;
                    foreach ($array_dias_meses as $k => $v) {
                        $dias_promediar += (trim($v) != "") ? intval($v) : 0;
                    }
                    $dias_promediar = ($dias_promediar > 0) ? $dias_promediar : $dias_mes;
                    $salario_dia_variable += (($dias_promediar > 0) ? ($suma_salarios_com / $dias_promediar) : 0);
                    // var_dump($dias_promediar, ($suma_salarios_com / $dias_promediar), $salario_dia_variable);die();

                }
                $salario_emp_indem = ($salario_dia_variable > 0) ? round(($salario_dia_variable * $dias_mes), 2) : $emp->emp_salario;
            } else {
                $salario_emp_indem = ($q_ing['ingresos'] > 0) ? (($q_ing['ingresos'] - $q_des['descuentos']) / $q_ing['meses']) : $emp->emp_salario;
            }
            /*
              // CODIGO ANTERIOR
              $numero_meses = (trim($configuracion_indemnizacion['NUMERO_MESES_PARA_INDEMNIZACION']) > 0 )? $configuracion_indemnizacion['NUMERO_MESES_PARA_INDEMNIZACION']:6;
              $id_tag_indemnizacion = (trim($configuracion_indemnizacion['ID_AGRUPADOR_INDEMNIZACION']) > 0 )? $configuracion_indemnizacion['ID_AGRUPADOR_INDEMNIZACION']:0;
              //preguntar por los meses anteriores excluyendo el actual
              $fecha = date_create($emp->emp_fecha_retiro);
              date_add($fecha, date_interval_create_from_date_string("-1 month")); 
              $ffin_ = date_format($fecha, 'Y-m-01'); 
              $fecha = date_create($ffin_);
              date_add($fecha, date_interval_create_from_date_string("-$numero_meses month")); 
              $fini = date_format($fecha, 'Y-m-01'); 
              $ffin = formatear_fecha('Y-m-t', $ffin_);
              //consultar por los ingresos y descuento segun el agrupador
              $q_ing = $this->db->select("IFNULL(SUM(ddi_valor),0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses",false)
                    ->from("ddi_detalle_ingreso")
                    ->join("pla_planilla","pla_id = ddi_id_pla")
                    ->where("ddi_id_emp", $emp->emp_id)
                    ->where("pla_estado", 3) //solo autorizadas
                    ->where("pla_fecha_inicio >=", $fini)
                    ->where("pla_fecha_fin <=", $ffin)
                    ->where("ddi_id_tig in ( SELECT deg_id_tig from deg_detalle_agrupador where deg_id_tag = $id_tag_indemnizacion AND deg_id_tig is not null )")
                    ->get()->row_array()
              ;
              // if ($emp->emp_id == 170) {  print_r($this->db->last_query()); die();  } //para debuger
              $q_des = $this->db->select("IFNULL(SUM(ddd_valor),0) AS descuentos",false)
                    ->from("ddd_detalle_descuento")
                    ->join("pla_planilla","pla_id = ddd_id_pla")
                    ->where("ddd_id_emp", $emp->emp_id)
                    ->where("pla_estado", 3) //solo autorizadas
                    ->where("pla_fecha_inicio >=", $fini)
                    ->where("pla_fecha_fin <=", $ffin)
                    ->where("ddd_id_tdc in ( SELECT deg_id_tdc from deg_detalle_agrupador where deg_id_tag = $id_tag_indemnizacion AND deg_id_tdc is not null )")
                    ->get()->row_array()
              ;
              //obtener el salario promediado.
              $salario_emp_indem = ($q_ing['ingresos'] > 0 )? (($q_ing['ingresos'] - $q_des['descuentos']) / $q_ing['meses']):$emp->emp_salario;
            */
        } 
        // var_dump($salario_emp_indem);die();
        $salary_by_incomes = $this->get_ultimo_ingreso_plan($emp->emp_id);
        $salario_emp_indem = ($salario_emp_indem > 0) ? $salario_emp_indem : $salary_by_incomes;
        // var_dump($salario_emp_indem); die();
        $ndias_trabaja = $this->gsatelite->get_intervalo_dias($fecha_ult_liq, $fecha_retiro);
        $ndias_trabaja = $ndias_trabaja + 1;//OK   5723
        $emp_fecha_contrato = $this->gsatelite->get_campo('emp_empleado', 'emp_fecha_contrato', array('emp_id' => $emp->emp_id));
        $dias_desde_contrato = ($this->gsatelite->get_intervalo_dias($emp_fecha_contrato, $fecha_retiro) + 1);
        $dias_anio_laboral = ($configuracion_indemnizacion['DIAS_ANIO_LABORAL'] > 0) ? $configuracion_indemnizacion['DIAS_ANIO_LABORAL'] : $configuracion_indemnizacion['DIAS_ANIO_INDEMNIZACION'];
        $suma_salarios = ($base_salario_minimo) ? $salario_minimo : $suma_salarios;

        $ndias_trabaja = ($ndias_trabaja < ($dias_anio_laboral / 2)) ? ($dias_anio_laboral / 2) : $ndias_trabaja;
        // RENUNCIA VOLUNTARIA APLICA AL TENER AL MENOS 2 AÑOS DE SERVICIO
        $ndias_trabaja = ($renuncia_voluntaria > 0 && $dias_desde_contrato < ($dias_anio_laboral * 2)) ? 0 : $ndias_trabaja;

        //De acuerdo con la Ley, la indemnización por despido no puede ser menor al salario básico de 15 días.
        $minimo = ($salario_emp_indem / $dias_mes) * 15;
        
        if ($renuncia_voluntaria > 0) {
            // RENUNCIA VOLUNTARIA ES SALARIO BASICO DE 15 DIAS POR CADA AÑO PERO DICHO SALARIO NO SERA MAYOR QUE 2 SALARIOS MINIMOS
            $salario_emp_indem = ($salario_emp_indem > $suma_salarios) ? $suma_salarios : $salario_emp_indem;
            $salario_emp_indem = ($salario_emp_indem / $dias_mes) * 15;
        } 
        $monto_base = ($salario_emp_indem > $suma_salarios) ?  $suma_salarios : $salario_emp_indem;
        // var_dump($ndias_trabaja, $monto_base, $dias_anio_laboral, ($monto_base / $dias_anio_laboral));die();
        $total_indem = $ndias_trabaja * ($monto_base / $dias_anio_laboral);
        $total_indem = ($total_indem < $minimo && $renuncia_voluntaria == 0) ? $minimo : $total_indem;

        return $total_indem;
    }


    public function get_ultimo_ingreso_plan($emp_id){
        $salario = 0;
        $pla_defecto = $this->gsatelite->get_parametro('ID_TIPO_PLANILLA_DEFECTO');
        $tipo_planillas = ($pla_defecto != "") ? $pla_defecto : 0;
        $where = array("ddi_id_emp" => $emp_id, "pla_estado" => 3, "tpl_id IN ($tipo_planillas)" => null);
        $ingresos = $this->db->select('pla_id, SUM(ddi_valor) AS ddi_valor', false)
                ->from('ddi_detalle_ingreso')
                ->join('pla_planilla', 'pla_id = ddi_id_pla')
                ->join('tpl_tipo_planilla', 'tpl_id = pla_id_tpl')
                ->where($where)
                ->group_by('pla_id')
                ->order_by('pla_fecha_fin', 'DESC')
                ->limit(1)
                ->get()->result_array()
        ;
        foreach ($ingresos as $key => $value) {
            $salario += $value['ddi_valor'];
        }
        return $salario;
    }

    public function datos_retiro_emp($where = null){
        $respuesta = array();
        // DATOS DEL EMPLEADO Y DEL RETIRO
        $this->db->select("*, IFNULL((SELECT GROUP_CONCAT(inn_id) FROM inn_ingreso WHERE inn_id_lqe = lqe_id), '') AS ingresos,
            IFNULL((SELECT GROUP_CONCAT(dss_id) FROM dss_descuento WHERE dss_id_lqe = lqe_id), '') AS descuentos", false)
            ->from('lqe_liquidacion_empleado')
            ->join('rte_retiro_empleado', 'rte_id = lqe_id_rte')
            ->join('emp_empleado', 'emp_id = rte_id_emp')
            ->join('plz_plaza', 'plz_id = emp_id_plz', 'LEFT');
        if ($where) {
            $this->db->where($where);
        }
        $retiro = $this->db->get()->row_array();
        $respuesta['retiro'] = $retiro;
        $tpl_id = $this->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION', null, null, array('ID_TIPO_PLANILLA_LIQ'));
        if ($retiro['ingresos'] != "") {
            $inns = explode(',', $retiro['ingresos']);
            $respuesta['ingresos_lqe'] = $this->db->select()->from('inn_ingreso')
                                            ->join('tig_tipo_ingreso', 'tig_id = inn_id_tig')
                                            ->where_in('inn_id', $inns)->get()->result_array();
        } else {
            $respuesta['ingresos_lqe'] = array();
        }
        if ($retiro['descuentos'] != "") {
            $dsss = explode(',', $retiro['descuentos']);
            $respuesta['descuentos_lqe'] = $this->db->select()->from('dss_descuento')
                                                ->join('tdc_tipo_descuento', 'tdc_id = dss_id_tdc')
                                                ->where_in('dss_id', $dsss)->get()->result_array();
        } else {
            $respuesta['descuentos_lqe'] = array();
        }
        $respuesta['otros_ingresos'] = $this->db->select()->from('inn_ingreso')->join('tig_tipo_ingreso', 'tig_id = inn_id_tig')
                                            ->where('inn_id_emp',$retiro['emp_id'])->where('inn_id_tpl',$tpl_id)->where('inn_id_lqe IS NULL')->get()->result_array();
        $respuesta['otros_descuentos'] = $this->db->select()->from('dss_descuento')->join('tdc_tipo_descuento', 'tdc_id = dss_id_tdc')
                                            ->where('dss_id_emp',$retiro['emp_id'])->where('dss_id_tpl',$tpl_id)->where('dss_id_lqe IS NULL')->get()->result_array();   
        return $respuesta;
    }
    

   /**
   * @author René Castaneda
   * @since 03-09-2018
   * @Description: 
   * función para el cálculo del salario para liquidación de un empleado
   */
    public function calculo_salario_empleado_liq($emp = null, $fecha_hasta = null){
      $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
      $configuracion_liquidacion = $this->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION'); //consultar las configuraciones
      $configuracion_liquidacion = json_decode($configuracion_liquidacion);
      if (!is_object($configuracion_liquidacion)) return null;
      $configuracion_liquidacion = (array) $configuracion_liquidacion;
      $salario_emp = $emp->emp_salario;
      $rte_fecha_retiro = $this->gsatelite->get_tabla('rte_retiro_empleado', array('rte_estado' => 1, 'rte_id_emp' => $emp->emp_id));
      $fecha_retiro = (trim($emp->emp_fecha_retiro) != "") ? $emp->emp_fecha_retiro : formatear_fecha('Y-m-d', $rte_fecha_retiro[0]['rte_fecha_retiro']); 
      // SI ES RETIRO, AQUI DEBERA QUEDAR UNA FECHA Y $fecha_hasta SERA NULL, SINO ES QUE SOLO ESTA PIDIENDO SU TIEMPO
      $fecha_retiro = ($fecha_hasta) ? $fecha_hasta : $fecha_retiro;
      if ($emp->pto_salario_promediado) { //preguntar si es promediado
            $numero_meses = (trim($configuracion_liquidacion['NUMERO_MESES_SALARIO_PROMEDIO']) > 0 )? $configuracion_liquidacion['NUMERO_MESES_SALARIO_PROMEDIO']:6;

            $id_tag_indemnizacion = (trim($configuracion_liquidacion['ID_AGRUPADOR_INDEMNIZACION']) > 0 )? $configuracion_liquidacion['ID_AGRUPADOR_INDEMNIZACION']:0;
            
            //preguntar por los meses anteriores excluyendo el actual
            $fecha = date_create($fecha_retiro);
            date_add($fecha, date_interval_create_from_date_string("-1 month")); 
            $ffin_ = date_format($fecha, 'Y-m-01'); 

            $fecha = date_create($ffin_);
            date_add($fecha, date_interval_create_from_date_string("-$numero_meses month")); 
            $fini = date_format($fecha, 'Y-m-01'); 
            $ffin = formatear_fecha('Y-m-t', $ffin_);


            //consultar por los ingresos y descuento segun el agrupador
            $q_ing = $this->db->select("IFNULL(SUM(ddi_valor),0) AS ingresos, COUNT(DISTINCT DATE_FORMAT(pla_fecha_inicio,'%Y-%m')) AS meses",false)
                         ->from("ddi_detalle_ingreso")
                         ->join("pla_planilla","pla_id = ddi_id_pla")
                         ->where("ddi_id_emp", $emp->emp_id)
                         ->where("pla_estado", 3) //solo autorizadas
                         ->where("pla_fecha_inicio >=", $fini)
                         ->where("pla_fecha_fin <=", $ffin)
                         ->where("ddi_id_tig in ( SELECT deg_id_tig from deg_detalle_agrupador where deg_id_tag = $id_tag_indemnizacion AND deg_id_tig is not null )")
                         ->get()->row_array()
                         ;
           // if ($emp->emp_id == 170) {  print_r($this->db->last_query()); die();  } //para debuger
            $q_des = $this->db->select("IFNULL(SUM(ddd_valor),0) AS descuentos",false)
                         ->from("ddd_detalle_descuento")
                         ->join("pla_planilla","pla_id = ddd_id_pla")
                         ->where("ddd_id_emp", $emp->emp_id)
                         ->where("pla_estado", 3) //solo autorizadas
                         ->where("pla_fecha_inicio >=", $fini)
                         ->where("pla_fecha_fin <=", $ffin)
                         ->where("ddd_id_tdc in ( SELECT deg_id_tdc from deg_detalle_agrupador where deg_id_tag = $id_tag_indemnizacion AND deg_id_tdc is not null )")
                         ->get()->row_array()
                         ;

            //obtener el salario promediado.
            $salario_emp = ($q_ing['ingresos'] > 0 )? (($q_ing['ingresos'] - $q_des['descuentos']) / $q_ing['meses']):$emp->emp_salario;
      } 
      $salary_by_incomes = $this->get_ultimo_ingreso_plan($emp->emp_id);
      $salario_emp = ($salario_emp > 0) ? $salario_emp : $salary_by_incomes;
      $dias_mes = ($this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES')>0)? $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES'):30;
      $ingreso_salario = $this->gsatelite->get_parametro('INGRESO_SALARIO');
      $ingreso_salario = ( trim($ingreso_salario) > 0 )? $ingreso_salario:0;
      //preguntar por la ultima planilla pagada al empleado que sumando 1 dia seria el inicio del pago de la liquidación
      $query = $this->db->select("DATE_ADD(MAX(pla_fecha_fin),INTERVAL 1 DAY) fecha_inicio",false)
          ->from('ddi_detalle_ingreso')
          ->join('pla_planilla','pla_id=ddi_id_pla')
          ->where('pla_estado',3) //autorizadas
          ->where('ddi_id_emp',$emp->emp_id)
          ->limit(1)
      ;
      if ($empresa != 'fya') {
        $this->db->where('ddi_id_tig',$ingreso_salario);
      }
      $qfecha = $query->get()->row_array();
      $qfecha['fecha_inicio'] = (trim($qfecha['fecha_inicio']) !="")? $qfecha['fecha_inicio']: formatear_fecha('Y-m-01',$fecha_retiro);
      //validar las fechas.
      if (intval(str_replace('-', '', $qfecha['fecha_inicio'])) > intval(str_replace('-', '', $fecha_retiro)) ) {
        $qfecha['fecha_inicio'] = formatear_fecha('Y-m-01',$fecha_retiro);
      }
      $n = $this->gsatelite->get_intervalo_dias($qfecha['fecha_inicio'], $fecha_retiro);
      $n_dias = $n + 1; //contabilizar la fecha final
      $sueldo = ($n_dias > 0)? (($salario_emp/$dias_mes) * $n_dias):0;
      return $sueldo;
    }

    public function descuentos_liquidacion($id_tipo){
        $descuentos_base = $this->db->join('tdc_tipo_descuento', 'tdc_id=dtp_id_tdc')
            ->order_by('tdc_orden_calculo', 'asc')
            ->get_where('dtp_descuentoxtipo_planilla', array('dtp_id_tpl' => $id_tipo))
            ->result_array(); 
        return $descuentos_base; 
    }

    function suma_isr_mes($emp_id, $retiro, $tipo_pla){
        $fecha = formatear_fecha('Ym', $retiro);
        $agrupador_isr = $this->gsatelite->get_parametro('AGRUPADOR_ISR');
        $descuento_iss = $this->gsatelite->get_parametro('DESCUENTO_ISS');
        $descuento_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
        $descuento_isr = $this->gsatelite->get_parametro('DESCUENTO_ISR');
        $totales = array('ingreso' => 0, 'isss' => 0, 'afp' => 0, 'isr' => 0);
        $where = array("pla_estado" => 3, "pla_id_tpl <> " => $tipo_pla, "txe_id_emp" => $emp_id, "DATE_FORMAT(pla_fecha_fin, '%Y%m') = '$fecha'" => null);
        $this->db->select("pla_id, pla_id_tpl, pla_codigo, pla_estado,
            IFNULL((SELECT SUM(ddi_valor) FROM ddi_detalle_ingreso WHERE ddi_id_emp = txe_id_emp AND ddi_id_pla = pla_id 
                AND ddi_id_tig IN (SELECT deg_id_tig FROM deg_detalle_agrupador WHERE deg_id_tag = $agrupador_isr)), 0) AS ingresos,
            IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento WHERE ddd_id_emp = txe_id_emp AND ddd_id_pla = pla_id AND ddd_id_tdc = $descuento_iss), 0) AS desc_isss,
            IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento WHERE ddd_id_emp = txe_id_emp AND ddd_id_pla = pla_id AND ddd_id_tdc = $descuento_afp), 0) AS desc_afp,
            IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento WHERE ddd_id_emp = txe_id_emp AND ddd_id_pla = pla_id AND ddd_id_tdc = $descuento_isr), 0) AS desc_isr,
            IFNULL((SELECT SUM(ddd_valor) FROM ddd_detalle_descuento WHERE ddd_id_emp = txe_id_emp AND ddd_id_pla = pla_id 
                AND ddd_id_tdc IN (SELECT deg_id_tdc FROM deg_detalle_agrupador WHERE deg_id_tag = $agrupador_isr AND deg_id_tdc NOT IN ($descuento_iss, $descuento_afp))), 0) AS desc_vac
            ", false)
            ->from('pla_planilla')->join('txe_tipo_planillaxempleado', 'txe_id_tpl =  pla_id_tpl', 'INNER')
            ->where($where)
        ;
        $resultado = $this->db->get()->result_array();
        if (count($resultado) > 0) {
            $inn = $iss = $afp = $isr = $vac = 0;
            foreach ($resultado as $key => $value) {
                if ($value['pla_estado'] == 3) {
                    $inn += $value['ingresos'];
                    $iss += $value['desc_isss'];
                    $afp += $value['desc_afp'];
                    $isr += $value['desc_isr'];
                    $vac += $value['desc_vac'];
                }
            }
            $ingresos = $inn - $vac;
            $totales = array('ingreso' => $ingresos, 'isss' => $iss, 'afp' => $afp, 'isr' => $isr);
        }
        return $totales;
    }

    /****************************************************************************/
    /**
      * @author Elman Ortiz
      * @since 2019-05-03
      * @param array where
      * @author Raul E - Grupo Satélite
      * @since  2021-05-31
      * Se cambio la logica y los permisos que antes se guardaban en la acp_accion_personal vienen en realidad de la hxe_hora_extraxempleado JOIN thf_tipo_hora_faltante
      * * @since  2024-10-31
      * Se agrega sumatoria de las horas de permisos utilizados
      * @return array Obtener Permisos del empleados
      */
    public function get_permisos_empleado($where = NULL) {
        $this->db->select('hxe_id, thf_nombre AS tipo_permiso, (SELECT CONCAT(emp_nombre," ",emp_apellido) FROM emp_empleado WHERE emp_id = hxe_id_emp) AS nombre_completo, hxe_enterado_rrhh,hxe_observacion_revision,
          hxe_fecha AS periodo_desde, hxe_id_emp AS id_emp, hxe_fecha_fin AS periodo_hasta, hxe_hora_inicio AS jornada_desde, hxe_hora_fin AS jornada_hasta, thf_id_tdc, 
          (SELECT mtp_nombre FROM mtp_motivo_permiso WHERE mtp_id = hxe_id_mtp) AS motivo_permiso, hxe_estado AS estado_actual, thf_horas_ley, hxe_observacion AS observacion, 
          IFNULL((SELECT SUM(uhp_numero_horas) FROM uhp_uso_horas_permisos JOIN hxe_hora_extraxempleado AS p ON p.hxe_id = uhp_id_hxe WHERE uhp_id_thf = thf_id AND uhp_autorizado > 0 AND p.hxe_estado = 2 AND p.hxe_id_emp = h.hxe_id_emp), 0) AS utilizadas, hxe_num_hora, 
          IFNULL((SELECT hpe_horas_limite FROM hpe_hora_permiso_x_empleado WHERE hpe_id_emp = hxe_id_emp AND hpe_id_thf = thf_id), 0) AS hora_emp_thf', false)
      ->from('hxe_hora_extraxempleado AS h')
      ->join('thf_tipo_hora_faltante', 'thf_id = h.hxe_id_thf')
      ->where('h.hxe_id_thf IS NOT NULL')
    ;
    if ($where) {
       $this->db->where($where);
    }
    return $this->db->get()->result_array();
  }  

  public function get_compensatorios_empleado($where = NULL) {
    $this->db->select()
      ->from('tce_tiempo_compensatorio_empleado')
      ->join('emp_empleado', 'emp_id = tce_id_emp')
      // ->where('hxe_id_thf IS NOT NULL')
    ;
    if ($where) {
       $this->db->where($where);
    }
    return $this->db->get()->result_array();
  }  

  public function get_configuracion_incapacidad($where = null){
    $this->db->select('*')
         ->from('tnc_tipo_incapacidad')
         ->join('cti_configuracion_tipo_incapacidad', 'cti_id_tnc = tnc_id', 'INNER');
         if ($where !== null) {
          $this->db->where($where);
         }
      return $this->db->get()->result_array();
  }

  public function validar_periodo_vacacion($excluir, $inicio, $final){
    $fini = formatear_fecha('Y-m-d', $inicio);
    $ffin = formatear_fecha('Y-m-d', $final);
    $query = "SELECT * FROM prv_periodo_vacacion WHERE prv_id != $excluir AND ((prv_hasta BETWEEN '$fini' AND '$ffin') OR (prv_desde BETWEEN '$fini' AND '$ffin'))";
    $result = $this->db->query($query);
    return $result->result_array();    
  }

    public function get_informe_trimestral($where=null,$group_by = null) {
        $query= $this->db->select("are_nombre, mtp_nombre, sum(hxe_num_hora) as hxe_num_hora, hxe_fecha, hxe_fecha_fin, are_id,
            sum(DATEDIFF(hxe_fecha_fin,hxe_fecha)) as cant_dias, count(hxe_id) as cantidad, thf_nombre", false)
            ->from('hxe_hora_extraxempleado')
            ->join('emp_empleado','hxe_id_emp = emp_id')
            ->join('are_area','emp_id_are = are_id', 'left')
            ->join('mtp_motivo_permiso','hxe_id_mtp = mtp_id', 'left')
            ->join('thf_tipo_hora_faltante','hxe_id_thf = thf_id', 'left')
            ->order_by('are_id')
        ;
        if ($group_by != null) {
            $this->db->group_by($group_by);
        }
        if($where!=null){
            $this->db->where($where);
        }
        return $query->get()->result_array();                 
    }

    public function get_inc_inf_trimestral($where=null,$group_by = null) {
        $query= $this->db->select("are_nombre, tnc_nombre, inc_fecha_inicio, are_id, SUM(inc_dias) AS inc_dias, COUNT(inc_id) AS cantidad", false)
            ->from('inc_incapacidad')
            ->join('emp_empleado','emp_id = inc_id_emp')
            ->join('are_area','emp_id_are = are_id', 'left')
            ->join('tnc_tipo_incapacidad','tnc_id = inc_id_tnc', 'left')
            ->order_by('are_id')
        ;
        if ($group_by != null) {
            $this->db->group_by($group_by);
        }
        if($where!=null){
            $this->db->where($where);
        }
        return $query->get()->result_array();                 
    }

    public function get_incapacidad($where = null){
        $this->db->select('*')
            ->from('inc_incapacidad')
            ->join('emp_empleado', 'inc_id_emp = emp_id', 'LEFT')
            ->join('tnc_tipo_incapacidad', 'inc_id_tnc = tnc_id', 'LEFT')
            ->join('pla_planilla', 'inc_id_pla = pla_id', 'LEFT')
        ;
        if ($where !== null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_goce_vacacion_reporte($where = null){
        $this->db->select("*, (SELECT plz_nombre FROM plz_plaza WHERE plz_id = emp_id_plz) AS plz_nombre,
          (SELECT plz_codigo FROM plz_plaza WHERE plz_id = emp_id_plz) AS plz_codigo", false)
            ->from('emp_empleado')
            ->join('vac_vacacion', 'vac_id_emp = emp_id', 'LEFT')
            ->join('prv_periodo_vacacion', 'prv_id = vac_id_prv', 'LEFT')
            ->where('emp_estado', 1)
        ;
        if ($where !== null) {
            $this->db->where($where);
        }
        return $this->db->get()->result_array();
    }

    public function get_tiempo_compensatorio($where=null) {
        $query= $this->db->select()
                ->from('tce_tiempo_compensatorio_empleado')
                ->join('emp_empleado','emp_id = tce_id_emp')
                ->group_by('tce_id')
                ->order_by('tce_fecha_desde', 'ASC');
        if($where!=null){
            $this->db->where($where);
        }
         return $query->get()->result_array();       
      }

      function obtener_tiempo_x_empleado($where){

        $query = $this->db->select("
                  tce.tce_id,
                  tce.tce_fecha_desde AS fecha_compensada,
                  tce.tce_hora_inicio AS hora_desde,
                  tce.tce_hora_final AS hora_hasta,
                  tce.tce_num_hora AS cantidad_horas,

                  hxc.hxc_horas AS horas_utilizadas,
                  hxe.hxe_fecha AS fecha_uso,

                  (tce_num_hora - IFNULL(hxc_horas, 0)) AS saldo", false)
              ->from("tce_tiempo_compensatorio_empleado tce")
              ->join("hxc_hora_x_compensatorio hxc"," hxc.hxc_id_tce = tce.tce_id AND hxc.hxc_estado = 1","left")
              ->join("hxe_hora_extraxempleado hxe","hxe.hxe_id = hxc.hxc_id_hxe","left")
              ->order_by('tce.tce_fecha_desde, tce.tce_hora_inicio, hxe.hxe_fecha');

              if ($where !== null) {
                  $this->db->where($where);
              }

              return $query->get()->result_array();  


      }


      function consulta_tiempo_permisos($where){

        $query = $this->db->select("
                  hxc.hxc_id,
                  tce.tce_motivo,
                  tce.tce_hora_inicio AS desde_hora,
                  tce.tce_fecha_desde AS desde_fecha,
                  tce.tce_hora_final AS hasta_hora,
                  tce.tce_fecha_hasta AS hasta_fecha,
                  hxe.hxe_fecha AS fecha_utilizacion,
                  hxc.hxc_horas AS horas_utilizadas", false)
              ->from("hxc_hora_x_compensatorio hxc")
              ->join("tce_tiempo_compensatorio_empleado tce","tce.tce_id = hxc.hxc_id_tce")
              ->join("hxe_hora_extraxempleado hxe","hxe.hxe_id = hxc.hxc_id_hxe")
              ->order_by('hxe.hxe_fecha, hxc.hxc_id');

              if ($where !== null) {
                  $this->db->where($where);
              }

              return $query->get()->result_array();  


      }


}