<?php

class Texto
{

    var $Void = "";
    var $SP = " ";
    var $Dot = ".";
    var $Zero = "0";
    var $Neg = "Menos";

    function limpiar($string) {
        $string = preg_replace("/á|à|â|ã|ª/","a",$string);
        $string = preg_replace("/Á|À|Â|Ã/","A",$string);
        $string = preg_replace("/é|è|ê/","e",$string);
        $string = preg_replace("/É|È|Ê/","E",$string);
        $string = preg_replace("/í|ì|î/","i",$string);
        $string = preg_replace("/Í|Ì|Î/","I",$string);
        $string = preg_replace("/ó|ò|ô|õ|º/","o",$string);
        $string = preg_replace("/Ó|Ò|Ô|Õ/","O",$string);
        $string = preg_replace("/ú|ù|û/","u",$string);
        $string = preg_replace("/Ú|Ù|Û/","U",$string);
        $string = str_replace(" ","_",$string);
        $string = str_replace("ñ","n",$string);
        $string = str_replace("Ñ","N",$string);

        $string = preg_replace('/[^a-zA-Z0-9_\.-]/', '', $string);
        return strtolower($string);
    }

    function ValorEnLetras($x, $Moneda = '')
    {
        //condicion caso especial
        if ($x==100) {
            return "cien";
        }
        $s = "";
        $Ent = "";
        $Frc = "";
        $Signo = "";

        if (floatVal($x) < 0)
            $Signo = $this->Neg . " ";
        else
            $Signo = "";
        if(is_numeric($x)){
         if (intval(number_format($x, 2, '.', '')) != $x){
            //<- averiguar si tiene decimales

            $s = number_format($x, 2, '.', '');

        }
        else
            $s = number_format($x, 0, '.', '');

        $Pto = strpos($s, $this->Dot);
        //var_dump($s);die();
        if ($Pto === false)
        {
            $Ent = $s;
            $Frc = $this->Void;
        } else
        {
            $Ent = substr($s, 0, $Pto);
            $Frc = substr($s, $Pto + 1);
        }

        if ($Ent == $this->Zero || $Ent == $this->Void)
            $s = "Cero ";
        elseif (strlen($Ent) > 7)
        {
            $s = $this->SubValLetra(intval(substr($Ent, 0, strlen($Ent) - 6))) . "Millones " .
            $this->SubValLetra(intval(substr($Ent, -6, 6)));
        } else
        {
            $s = $this->SubValLetra(intval($Ent));
        }

        if (substr($s, -9, 9) == "Millones " || substr($s, -7, 7) == "Millón ")
            $s = $s . "de ";

        $s = $s . $Moneda;

        if ($Frc != $this->Void)
        {
            $s = $s . " Con " . $this->SubValLetra(intval($Frc)) . "Centavos";
            //$s = $s . " " . $Frc . "/100";
        }
        return ($Signo . $s);
    }else{
        return '';
    }
    
}

function SubValLetra_Documento($numero2)
{

    $posicion_guion = strpos($numero2, "-");


    if ($posicion_guion != false)
    {
        $numero = substr($numero2, 0, $posicion_guion);
        $x2 = substr($numero2, $posicion_guion + 1);

    } else
    {
        $numero = $numero2;
        $x2 = "";
    }


    $Ptr = "";
    $n = 0;
    $i = 0;
    $x1 = "";
    $Rtn = "";
    $Tem = "";

    $x1 = trim("$numero");
    $n = strlen($x1);

    $Tem = $this->Void;
    $i = $n;

    while ($i > 0)
    {
        $Tem = $this->Parte(intval(substr($x1, $n - $i, 1) . str_repeat($this->Zero, $i -
            1)));
        if ($Tem != "Cero")
            $Rtn .= $Tem . $this->SP;
        $i = $i - 1;
    }


        //--------------------- GoSub FiltroMil ------------------------------
    $Rtn = str_replace(" Mil Mil", " Un Mil", $Rtn);
    while (1)
    {
        $Ptr = strpos($Rtn, "Mil ");
        if (!($Ptr === false))
        {
            if (!(strpos($Rtn, "Mil ", $Ptr + 1) === false))
                $this->ReplaceStringFrom($Rtn, "Mil ", "", $Ptr);
            else
                break;
        } else
        break;
    }

        //--------------------- GoSub FiltroCiento ------------------------------
    $Ptr = -1;
    do
    {
        $Ptr = strpos($Rtn, "Cien ", $Ptr + 1);
        if (!($Ptr === false))
        {
            $Tem = substr($Rtn, $Ptr + 5, 1);
            if ($Tem == "M" || $Tem == $this->Void)
                ;
            else
                $this->ReplaceStringFrom($Rtn, "Cien", "Ciento", $Ptr);
        }
    } while (!($Ptr === false));

        //--------------------- FiltroEspeciales ------------------------------
    $Rtn = str_replace("Un", "Uno", $Rtn);
    $Rtn = str_replace("Diez Uno", "Once", $Rtn);
    $Rtn = str_replace("Diez Dos", "Doce", $Rtn);
    $Rtn = str_replace("Diez Tres", "Trece", $Rtn);
    $Rtn = str_replace("Diez Cuatro", "Catorce", $Rtn);
    $Rtn = str_replace("Diez Cinco", "Quince", $Rtn);
    $Rtn = str_replace("Diez Seis", "Dieciseis", $Rtn);
    $Rtn = str_replace("Diez Siete", "Diecisiete", $Rtn);
    $Rtn = str_replace("Diez Ocho", "Dieciocho", $Rtn);
    $Rtn = str_replace("Diez Nueve", "Diecinueve", $Rtn);
    $Rtn = str_replace("Veinte Un", "Veintiun", $Rtn);
    $Rtn = str_replace("Veinte Dos", "Veintidos", $Rtn);
    $Rtn = str_replace("Veinte Tres", "Veintitres", $Rtn);
    $Rtn = str_replace("Veinte Cuatro", "Veinticuatro", $Rtn);
    $Rtn = str_replace("Veinte Cinco", "Veinticinco", $Rtn);
    $Rtn = str_replace("Veinte Seis", "Veintiseís", $Rtn);
    $Rtn = str_replace("Veinte Siete", "Veintisiete", $Rtn);
    $Rtn = str_replace("Veinte Ocho", "Veintiocho", $Rtn);
    $Rtn = str_replace("Veinte Nueve", "Veintinueve", $Rtn);

        //--------------------- FiltroUn ------------------------------
    if (substr($Rtn, 0, 1) == "M")
        $Rtn = "Un " . $Rtn;
        //--------------------- Adicionar Y ------------------------------
    for ($i = 65; $i <= 88; $i++)
    {
        if ($i != 77)
            $Rtn = str_replace("a " . Chr($i), "* y " . Chr($i), $Rtn);
    }
    $Rtn = str_replace("*", "a", $Rtn);
    if ($x2 != "")
    {
        return ($Rtn . " - " . $this->SubValLetra($x2));
    } else
    {
        return ($Rtn);
    }


}
function dia_mes($fecha)
{
    $fecha=str_replace('/', '-', $fecha);
    $fecha=date('Y-m-d', strtotime($fecha));
    $fecha=explode('-',$fecha);
    $year = $fecha[0];
    $month = $fecha[1];
    $day = $fecha[2];
    switch ( $month) {
       case "1":
       $mes = "Enero";
       break;
       case "2":
       $mes = "Febrero";
       break;
       case "3":
       $mes = "Marzo";
       break;
       case "4":
       $mes = "Abril";
       break;
       case "5":
       $mes = "Mayo";
       break;
       case "6":
       $mes = "Junio";
       break;
       case "7":
       $mes = "Julio";
       break;
       case "8":
       $mes = "Agosto";
       break;
       case "9":
       $mes = "Septiembre";
       break;
       case "10":
       $mes = "Octubre";
       break;
       case "11":
       $mes = "Noviembre";
       break;
       case "12":
       $mes = "Diciembre";
       break;
   }
   return $this->ValorEnLetras($day)." de ".$mes;
}

function mes_anio($fecha, $anio){
    $fecha=str_replace('/', '-', $fecha);
    $fecha=date('Y-m-d', strtotime($fecha));
    $fecha=explode('-',$fecha);
    $year = $fecha[0];
    $month = $fecha[1];
    $day = $fecha[2];
    switch ( $month) {
       case "1":
       $mes = "Enero";
       break;
       case "2":
       $mes = "Febrero";
       break;
       case "3":
       $mes = "Marzo";
       break;
       case "4":
       $mes = "Abril";
       break;
       case "5":
       $mes = "Mayo";
       break;
       case "6":
       $mes = "Junio";
       break;
       case "7":
       $mes = "Julio";
       break;
       case "8":
       $mes = "Agosto";
       break;
       case "9":
       $mes = "Septiembre";
       break;
       case "10":
       $mes = "Octubre";
       break;
       case "11":
       $mes = "Noviembre";
       break;
       case "12":
       $mes = "Diciembre";
       break;
   }

   if ($anio==2) {
     return number_format($day)." de ".$mes." de ".$year;
 }

 if ($anio==1) {
     return $mes."/".$year;
 }

 if ($anio==0) {
  return $mes." del año ".$year ;
}
}



function SubValLetra($numero)
{
    $Ptr = "";
    $n = 0;
    $i = 0;
    $x = "";
    $Rtn = "";
    $Tem = "";

    $x = trim("$numero");
    $n = strlen($x);

    $Tem = $this->Void;
    $i = $n;

    while ($i > 0)
    {
        $Tem = $this->Parte(intval(substr($x, $n - $i, 1) . str_repeat($this->Zero, $i -
            1)));
        if ($Tem != "Cero")
            $Rtn .= $Tem . $this->SP;
        $i = $i - 1;
    }


        //--------------------- GoSub FiltroMil ------------------------------
    $Rtn = str_replace(" Mil Mil", " Un Mil", $Rtn);
    while (1)
    {
        $Ptr = strpos($Rtn, "Mil ");
        if (!($Ptr === false))
        {
            if (!(strpos($Rtn, "Mil ", $Ptr + 1) === false))
                $this->ReplaceStringFrom($Rtn, "Mil ", "", $Ptr);
            else
                break;
        } else
        break;
    }

        //--------------------- GoSub FiltroCiento ------------------------------
    $Ptr = -1;
    do
    {
        $Ptr = strpos($Rtn, "Cien ", $Ptr + 1);
        if (!($Ptr === false))
        {
            $Tem = substr($Rtn, $Ptr + 5, 1);
            if ($Tem == "M" || $Tem == $this->Void)
                ;
            else
                $this->ReplaceStringFrom($Rtn, "Cien", "Ciento", $Ptr);
        }
    } while (!($Ptr === false));

        //--------------------- FiltroEspeciales ------------------------------
    $Rtn = str_replace("Un", "Uno", $Rtn);
    $Rtn = str_replace("Diez Uno", "Once", $Rtn);
    $Rtn = str_replace("Diez Dos", "Doce", $Rtn);
    $Rtn = str_replace("Diez Tres", "Trece", $Rtn);
    $Rtn = str_replace("Diez Cuatro", "Catorce", $Rtn);
    $Rtn = str_replace("Diez Cinco", "Quince", $Rtn);
    $Rtn = str_replace("Diez Seis", "Dieciseis", $Rtn);
    $Rtn = str_replace("Diez Siete", "Diecisiete", $Rtn);
    $Rtn = str_replace("Diez Ocho", "Dieciocho", $Rtn);
    $Rtn = str_replace("Diez Nueve", "Diecinueve", $Rtn);
    $Rtn = str_replace("Veinte Un", "Veintiun", $Rtn);
    $Rtn = str_replace("Veinte Dos", "Veintidos", $Rtn);
    $Rtn = str_replace("Veinte Tres", "Veintitres", $Rtn);
    $Rtn = str_replace("Veinte Cuatro", "Veinticuatro", $Rtn);
    $Rtn = str_replace("Veinte Cinco", "Veinticinco", $Rtn);
    $Rtn = str_replace("Veinte Seis", "Veintiseís", $Rtn);
    $Rtn = str_replace("Veinte Siete", "Veintisiete", $Rtn);
    $Rtn = str_replace("Veinte Ocho", "Veintiocho", $Rtn);
    $Rtn = str_replace("Veinte Nueve", "Veintinueve", $Rtn);

        //--------------------- FiltroUn ------------------------------
    if (substr($Rtn, 0, 1) == "M")
        $Rtn = "Un " . $Rtn;
        //--------------------- Adicionar Y ------------------------------
    for ($i = 65; $i <= 88; $i++)
    {
        if ($i != 77)
            $Rtn = str_replace("a " . Chr($i), "* y " . Chr($i), $Rtn);
    }
    $Rtn = str_replace("*", "a", $Rtn);
    return ($Rtn);
}


function ReplaceStringFrom(&$x, $OldWrd, $NewWrd, $Ptr)
{
    $x = substr($x, 0, $Ptr) . $NewWrd . substr($x, strlen($OldWrd) + $Ptr);
}


function Parte($x)
{
    $Rtn = '';
    $t = '';
    $i = '';
    do
    {
        switch ($x)
        {
            case 0:
            $t = "Cero";
            break;
            case 1:
            $t = "Un";
            break;
            case 2:
            $t = "Dos";
            break;
            case 3:
            $t = "Tres";
            break;
            case 4:
            $t = "Cuatro";
            break;
            case 5:
            $t = "Cinco";
            break;
            case 6:
            $t = "Seis";
            break;
            case 7:
            $t = "Siete";
            break;
            case 8:
            $t = "Ocho";
            break;
            case 9:
            $t = "Nueve";
            break;
            case 10:
            $t = "Diez";
            break;
            case 20:
            $t = "Veinte";
            break;
            case 30:
            $t = "Treinta";
            break;
            case 40:
            $t = "Cuarenta";
            break;
            case 50:
            $t = "Cincuenta";
            break;
            case 60:
            $t = "Sesenta";
            break;
            case 70:
            $t = "Setenta";
            break;
            case 80:
            $t = "Ochenta";
            break;
            case 90:
            $t = "Noventa";
            break;
            case 100:
            $t = "Cien";
            break;
            case 200:
            $t = "Doscientos";
            break;
            case 300:
            $t = "Trescientos";
            break;
            case 400:
            $t = "Cuatrocientos";
            break;
            case 500:
            $t = "Quinientos";
            break;
            case 600:
            $t = "Seiscientos";
            break;
            case 700:
            $t = "Setecientos";
            break;
            case 800:
            $t = "Ochocientos";
            break;
            case 900:
            $t = "Novecientos";
            break;
            case 1000:
            $t = "Mil";
            break;
            case 1000000:
            $t = "Millón";
            break;
        }

        if ($t == $this->Void)
        {
            $i = $i + 1;
            $x = $x / 1000;
            if ($x == 0)
                $i = 0;
        } else
        break;

    } while ($i != 0);

    $Rtn = $t;
    switch ($i)
    {
        case 0:
        $t = $this->Void;
        break;
        case 1:
        $t = " Mil";
        break;
        case 2:
        $t = " Millones";
        break;
        case 3:
        $t = " Billones";
        break;
    }
    return ($Rtn . $t);
}

function fchtotext($fecha)
{
        //date_default_timezone_set('Europe/Madrid');
    setlocale(LC_TIME, 'spanish');
    $anyo = $this->ValorEnLetras(strftime("%Y", strtotime($fecha)));
    $dia = $this->ValorEnLetras(strftime("%d", strtotime($fecha)));
    $mes = strftime("%B", strtotime($fecha));
    $texto = $dia . ' de ' . $mes . ' de ' . $anyo;
    return strtolower($texto);
}
function anio_text($fecha)
{
        //date_default_timezone_set('Europe/Madrid');
    setlocale(LC_TIME, 'spanish');
    $anyo = $this->ValorEnLetras(strftime("%Y", strtotime($fecha)));
    $dia = $this->ValorEnLetras(strftime("%d", strtotime($fecha)));
    $mes = strftime("%B", strtotime($fecha));
    $texto = $dia . ' de ' . $mes . ' de ' . $anyo;
    return strtolower($texto);
}

function fecha_cuenta($fecha)
{
        //date_default_timezone_set('Europe/Madrid');
    setlocale(LC_TIME, 'spanish');
    $anyo = strftime("%Y", strtotime($fecha));
    $dia = strftime("%d", strtotime($fecha));
    $mes = strftime("%B", strtotime($fecha));
    $texto = $dia . ' de ' . $mes . ' de ' . $anyo;
    return strtolower($texto);
}

function edad($fecha, $fecha2 = 0)
{
    if ($fecha2 == 0)
    {
        $edad = date('Y-m-d') - date('Y-m-d', strtotime($fecha));

        if ($edad <= 0)
        {
            return "";
        } else
        {
            return $edad;
        }


    } else
    {

        $fecha2 = explode("-", $fecha2);

        list($ano, $mes, $dia) = explode("-", $fecha);
        $ano_diferencia = $fecha2[0] - $ano;
        $mes_diferencia = $fecha2[1] - $mes;
        $dia_diferencia = $fecha2[2] - $dia;
        if ($mes_diferencia < 0)
        {
            $ano_diferencia--;
        } 

        if($mes==$fecha2[1] && $dia_diferencia<0)
        {    

            $ano_diferencia--;

        }
        

        if ($ano_diferencia <= 0)
        {
            return "";
        } else
        {
            if($ano_diferencia>1000)
            {
                return "";
            }else{
             return $ano_diferencia;
         }

     }


 }

}

function leer($valor){
    $longitud=strlen($valor);
    $lectura='';
    for ($i=0; $i < $longitud; $i++) { 
        $caracter=substr($valor, $i, 1);
        if(is_numeric($caracter)){
            switch ($caracter) {
                case 0:
                $lectura.=' cero';
                break;

                case 1:
                $lectura.=' uno';
                break;
                case 2:
                $lectura.=' dos';
                break;

                case 3:
                $lectura.=' tres';
                break;

                case 4:
                $lectura.=' cuatro';
                break;

                case 5:
                $lectura.=' cinco';
                break;

                case 6:
                $lectura.=' seis';
                break;

                case 7:
                $lectura.=' siete';
                break;

                case 8:
                $lectura.=' ocho';
                break;

                case 9:
                $lectura.=' nueve';
                break;

                default:
                $lectura.='';
                break;
            }
        }else{
            switch ($caracter) {
                /*case '-':
                $lectura.=' guión ';
                break;*/
                
                default:
                $lectura.=' '.strtoupper($caracter);
                break;
            }
        }
    }
    return trim($lectura);
}

function horatotext($hora)
{
    $fecha = date('H:i', strtotime($hora));
    setlocale(LC_TIME, 'spanish');
    $hora = $this->ValorEnLetras(strftime("%H", strtotime($fecha)));
    $minutos = $this->ValorEnLetras(strftime("%M", strtotime($fecha)));
    $texto = $hora . ' horas ' . $minutos . ' minutos';
    return strtolower($texto);
}
function hora_text($hora)
{
    $fecha = date('H:i', strtotime($hora));
    setlocale(LC_TIME, 'spanish');
    $hora = $this->ValorEnLetras(strftime("%H", strtotime($fecha)));
    return strtolower($hora);
}

public function mes__texto($num_mes = null)
{
    $months = array('Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
    if( ! is_null($num_mes))
    {
        return $months[++$num_mes];
    }

    return '';
}

}
