<?php if ( ! defined ( 'BASEPATH' ) ) exit ( 'No direct script access allowed.' );
class Proceso {

    private $proceso = array();
    private $estado = array();
    private $campos = array();
    private $validaciones = array();
    private $permisos = array();
    private $permisos_especiales = array();
    private $condiciones = array();
    private $relaciones = array();
    private $subflujos = array();
    private $padre = array();
    private $rol = 0;
    private $referencia = "";

    public function __construct ( ) {       
        $this->CI = get_instance ( );
        $this->CI->load->model('proceso_model');
        $this->principal();   
    }

    private function principal()
    {
        $this->set_rol();
        $this->set_proceso();
        $this->set_estado();
        $this->set_campos();
        $this->set_permisos();
        $this->set_permisos_especiales();
        $this->set_condiciones();
        $this->set_relaciones();
        $this->set_subflujos();
        $this->set_padre();
        //$this->set_referencia();
    }

    public function get_rol()
    {
        return $this->rol;        
    }

    private function set_rol()
    {
        $id = $this->CI->tank_auth->get_user_id();
        $rol = $this->CI->proceso_model->get_rol($id);
        $this->rol = $rol['uxr_id_rol'];
    }

    public function get_proceso()
    {
        return $this->proceso;
    }

    private function set_proceso()
    {
        $proceso = $this->CI->proceso_model->get_proceso(strtolower($this->CI->uri->segment(4)));
        $this->proceso = $proceso;
    }

    public function get_estado()
    {
        return $this->estado;
    }

    private function set_estado()
    {
        $estado = $this->CI->proceso_model->get_estado($this->proceso['flu_id'], strtolower($this->CI->uri->segment(5)));
        $this->estado = $estado;
    }

    public function get_campos()
    {
        return $this->campos;
    }

    private function set_campos()
    {
        $campos = $this->CI->proceso_model->get_campos($this->proceso['flu_id']);        
        $this->campos = $campos;
    }

    public function get_validaciones()
    {}

    public function get_relaciones()
    {
        return $this->relaciones;
    }

    private function set_relaciones()
    {
        $relaciones = $this->CI->proceso_model->get_relaciones($this->proceso['flu_id']);
        $this->relaciones = $relaciones;
    }

    public function get_permisos()
    {
        return $this->permisos;
    }

    private function set_permisos()
    {
        $permisos = $this->CI->proceso_model->get_permisos($this->proceso['flu_id'], $this->estado['est_id'], $this->rol);        
        $this->permisos = $permisos;
    }

    public function get_permisos_especiales()
    {
        return $this->permisos_especiales;
    }

    private function set_permisos_especiales()
    {
        $permisos_especiales = $this->CI->proceso_model->get_permisos_especiales($this->proceso['flu_id'], $this->estado['est_id'], $this->rol);
        $this->permisos_especiales = $permisos_especiales;
    }

    public function get_condiciones()
    {
        return $this->condiciones;
    }

    private function set_condiciones()
    {
        $condiciones = $this->CI->proceso_model->get_condiciones($this->proceso['flu_id'], $this->estado['est_id'], $this->rol);
        $this->condiciones = $condiciones;
    }

    public function get_subflujos()
    {
        return $this->subflujos;
    }

    private function set_subflujos()
    {
        $subflujos = $this->CI->proceso_model->get_subflujos($this->proceso['flu_id']);
        $this->subflujos = $subflujos;
    }

    public function get_padre()
    {
        return $this->padre;
    }

    private function set_padre()
    {
        $padre = $this->CI->proceso_model->get_padre($this->proceso['flu_padre']);
        $this->padre = $padre;
    }

    public function get_referencia()
    {
        return $this->referencia;
    }

      public function set_referencia($id)
    {
        $padre = $this->get_padre();
        if(isset($padre['flu_id'])) {
            $referencia = $this->CI->proceso_model->get_referencia($padre,$id);
        }        
        else
            $referencia = null;
       
            
      return $referencia;
    }

    public function set_control()
    {}    

    public function set_historial()
    {}

    public function get_historial()
    {}
}
?>