<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

require_once APPPATH . 'third_party/tcpdf/tcpdf.php';

class Pdf extends TCPDF {

    protected $ci;

    public function __construct() {
        parent::__construct();
        $this->ci = & get_instance();
        ini_set('memory_limit', '256M');
    }

    public function cargarPdf2($parametros = null) {
        include_once APPPATH . '/third_party/mpdf/mpdf.php';
        if ($parametros == null) {
            $parametros = '"utf-8","Letter","","",1,1,1,1,1,1';
        }

        return new mPDF($parametros);
    }

    public function cargarPdf($parametros = null) {
        include_once APPPATH . '/third_party/tcpdf/tcpdf.php';
        if ($parametros == null) {
            $parametros = '"utf-8","Letter","","",1,1,1,1,1,1';
        }

        return new mPDF($parametros);
    }

    public function reportePDF2($html, $estilos = 1, $orientacion = null, $salida='D',$nombre_pdf = null) {
        //Nombre del archivo
        $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $filename = ($nombre_pdf)? $nombre_pdf:$filename;
        //Guardar PDF creado en proyecto/temp/{nombre}
        $ruta_archivo_pdf = APPPATH . "cache/pdf/$filename.pdf";

        //Verificar si el archivo ya existe
        if (file_exists($ruta_archivo_pdf) == false) {
            //Incrementar limite de memoria de proceso
            ini_set('memory_limit', '64M');

            //Adquirir id de consulta
            /* $id_consulta = $this->input->post('id_consulta');
              $filtro = $this->input->post('pdf_filtros');
              //Obtener datos y construir secciones del reporte
              $data['table_header']     = $this->reporteria_model->getNombreColumnas( $id_consulta );
              $data['table_tbody']      = $this->reporteria_model->getResultadoConsultaReporte( $id_consulta, $filtro );
              $data['detalles_reporte'] = $this->reporteria_model->getDetallesReporte( $id_consulta );
              $data['listado_filtros']  = $this->reporteria_model->getListadoFiltrosConsulta( $id_consulta );

              //Llamar vista y guardar el resultado en HTML
              $html = $this->load->view('estadistica/crear/pdf.php', $data, true); */

            $cabecera = '<table>';
            $cabecera .= '<tr>';
            $this->CI = get_instance();
            //$cabecera .= '<td><img width="30%" src="' . base_url('/media/imagenes/sistema/'.$this->CI->gsatelite->get_parametro('SYS_LOGOTIPO').'.png') . '" alt="'.$this->CI->gsatelite->get_parametro('SYS_EMPRESA').'" with="20%" height="15%"/></td>';
            $cabecera .= '<td><h1></h1></td>';
            $cabecera .= '</tr>';
            $cabecera .= '</table>';

            //$metadata = $data['detalles_reporte'];
            //Nueva instancia del creador de PDF
            $pdf = $this->cargarPdf2();
            $pdf->mirrorMargins = 1;
            //Agregar metadata al PDF
            //$pdf->SetTitle( $metadata->que_nombre );
            $pdf->SetAuthor('desarrollado por Grupo Satelite El Salvador');
            //Obtener el contenido de print.css
            if ($estilos == 1) {
                $stylesheet = file_get_contents(base_url('stylesheets/print.css'));
                //Importante! el parametro entero 1 indica que esta es una hoja de estilo para el reporte


                $pdf->WriteHTML($stylesheet, 1);
                $pdf->SetHTMLHeader($cabecera);
                //Crear footer del reporte {sistema} - {Numero Pagina} - {fecha y hora}
                $pdf->SetFooter('|{PAGENO}|' . date("Ymd h:i:s"));
            }
            if ($orientacion != null) {
                $pdf->AddPage($orientacion);
            }
            //Escribir el resultado HTML en el PDF
            $pdf->WriteHTML($html);
            //Guardar el archivo
            $pdf->Output($ruta_archivo_pdf, "$salida");
        }

        //Mostrar PDF creado
        //redirect($ruta_archivo_pdf);
    }

    public function reporteNombrePDF($html, $nombre_pdf = null, $salida = null, $estilos = 1) {
        $cabecera = '<table>';
        $cabecera .= '<tr>';
        $this->CI = get_instance();
        //$cabecera .= '<td><img width="30%" src="' . base_url('/media/imagenes/sistema/'.$this->CI->gsatelite->get_parametro('SYS_LOGOTIPO').'.png') . '" alt="'.$this->CI->gsatelite->get_parametro('SYS_EMPRESA').'" with="20%" height="15%"/></td>';
        $cabecera .= '<td><h1></h1></td>';
        $cabecera .= '</tr>';
        $cabecera .= '</table>';

        $pdf = $this->cargarPdf2();
        $pdf->mirrorMargins = 1;
        //Agregar metadata al PDF
        //$pdf->SetTitle( $metadata->que_nombre );
        $pdf->SetAuthor('desarrollado por Grupo Satelite El Salvador');
        //Obtener el contenido de print.css
        if ($estilos == 1) {
            $stylesheet = file_get_contents(base_url('stylesheets/print.css'));
            //Importante! el parametro entero 1 indica que esta es una hoja de estilo para el reporte
            $pdf->WriteHTML($stylesheet, 1);
            $pdf->SetHTMLHeader($cabecera);
            //Crear footer del reporte {sistema} - {Numero Pagina} - {fecha y hora}
            $pdf->SetFooter('|{PAGENO}|' . date("Ymd h:i:s"));
        }
        //Escribir el resultado HTML en el PDF
        $pdf->WriteHTML($html);
        //Guardar el archivo
        $pdf->Output($nombre_pdf.'.pdf', "$salida");
    }


public function Header($datos = 0) {
    $CI = & get_instance();
    $pie = $CI->gsatelite->get_parametro('COT_APLICA_PIE_PAGINA');
    $es_cotizacion = (isset($GLOBALS['es_cotizacion']) && $GLOBALS['es_cotizacion'] == 1) ? true : false;
    $datos = ($es_cotizacion) ? 1 : 0;

    if (isset($GLOBALS['es_cotizacion']) && $GLOBALS['es_cotizacion'] == 11) {
        // Elimina los márgenes
        $this->SetMargins(0, 0, 0);
        $this->SetTopMargin(35); // O la altura real de tu imagen


        // Obtiene el ancho de la página
        $pageWidth = $this->getPageWidth();

        // Dibuja la imagen ocupando el 100% del ancho sin margen
        $this->Image(FCPATH .'media/logo_per_cotizaciones/header_instruquimica.png', 
                     0, 0,  // X, Y posición
                     $pageWidth, // Ancho completo
                     0, // Alto automático
                     '', '', '', false, 300, '', false, false, 0);

        $pie = 2;
        $datos = 2;
    }
}




    /**
     * @return: $planilla
     */
public function Footer($datos = 0) {
        //$this->gsatelite->get_parametro("SYS_EMPRESA");
        $CI = & get_instance();
        $pie = $CI->gsatelite->get_parametro('COT_APLICA_PIE_PAGINA');
        $es_cotizacion = (isset($GLOBALS['es_cotizacion']) && $GLOBALS['es_cotizacion'] == 1) ? true : false;
        $datos = ($es_cotizacion) ? 1 : 0;

        $detalle_pla = (isset($GLOBALS['detalle_pla'])) ? 1 : null;

        // Fondo
        $this->SetFont('helvetica', 'B', 8);
        if (isset($GLOBALS['es_receta']) && $GLOBALS['es_receta'] == 1) {
            $this->SetFont('helvetica', '', 6);
        }

        if (isset($GLOBALS['es_cotizacion']) && $GLOBALS['es_cotizacion'] == 10) {
            $this->SetY(-30);
            $html2 = '<table border="0" width="100%">
                <tr style="background-color: white;">
                    <td style="text-align:center;"><span style="font-size:8px;">' . $CI->gsatelite->get_parametro('SYS_DIR') . '</span></td>
                </tr>
                <tr style="background-color: white;">
                    <td style="text-align:center;"><span style="font-size:9px;">' . $CI->gsatelite->get_parametro('SYS_TEL') . '</span></td>
                </tr>
            </table>';
            $this->writeHTML($html2, true, 0, true, true);
          //
            $pie = 2;
            $datos = 2;
        }

if (isset($GLOBALS['es_cotizacion']) && $GLOBALS['es_cotizacion'] == 11) {
    // Establecer la posición Y del pie de página
    $this->SetY(-30); // Ajustar a 30, pero si se ven mal las imágenes prueba con otros valores

    // Obtener el ancho de la página (ajustar si es necesario)
    $pageWidth = 190; // Ancho de página en milímetros (TCPDF usa mm, no px)

    // Establecer márgenes
    $this->SetMargins(0, 0); // Márgenes izquierdo, superior y derecho

    // Obtener los datos
    $correo = trim(str_replace("www.", "", $CI->gsatelite->get_parametro("SYS_WEB")));
    $direccion = $CI->gsatelite->get_parametro('SYS_DIR');
    $telefono = $CI->gsatelite->get_parametro('SYS_TEL');

    // Insertar el correo
    $this->SetFont('helvetica', '', 8);
    $this->SetX(10);

    // Definir un ancho fijo para la celda para evitar que se desborde
    $cellWidth = 180; // Ancho de la celda de correo (ajústalo según sea necesario)
    $this->SetTextColor(102, 173, 218);
    $this->MultiCell($cellWidth, 5, $correo, 0, 'R'); // Usar MultiCell para que se ajuste al ancho
    $this->SetTextColor(0, 0, 0);

    // Insertar la imagen del logo
    $logoPath = FCPATH . 'media/logo_per_cotizaciones/barra_instruquimica.png';
    $this->Image($logoPath, 10, $this->GetY(), $pageWidth, 0, 'PNG'); // Ajustar la imagen

    // Insertar una línea de espacio
    $this->Ln(5);

    // Crear las tres columnas con diferentes estilos
    // Columna 1 - Teléfono y Dirección
    $this->SetFont('helvetica', '', 10);
    $this->SetX(10);
    $this->Cell(47.5, 10, '', 0, 0, 'C'); // Espacio en blanco para la columna izquierda

    // Teléfono
    $this->SetFont('helvetica', 'B', 7);
    $telefonoImg = FCPATH . 'media/logo_per_cotizaciones/telefono_instruquimica.png';
    $this->Image($telefonoImg, 10, $this->GetY(), 8, 10, 'PNG');
    $this->SetX(20);
    $this->MultiCell(40, 5, $telefono, 0, 'L'); // Usar MultiCell para que se ajuste el texto

    // Dirección
    $direccionImg = FCPATH . 'media/logo_per_cotizaciones/marker_instruquimica.png';
    $this->Image($direccionImg, 10, $this->GetY(), 8, 10, 'PNG');
    $this->SetX(20);
    $this->MultiCell(40, 5, $direccion, 0, 'L'); // Usar MultiCell para que se ajuste el texto

    $this->SetFont('helvetica', '', 10);

    // Columna 2 - Texto central (celda combinada)
    $this->SetXY(68, $this->GetY() - 13); // Ajuste para que quede al mismo nivel
    $this->SetFont('helvetica', 'B', 14);
    $this->SetTextColor(102, 173, 218); // Color del texto
    $this->MultiCell(80, 5, 'Fortaleciendo la química analítica', 0, 'C', 0, 0); // Celda combinada

    // Columna 3 - Pie de página (número de página)
    $this->SetXY(142.5, $this->GetY() - 5); // Ajustar la posición para pie de página
    $this->SetFont('helvetica', '', 9);
    $this->SetTextColor(0, 0, 0); // Color negro para el pie de página
    $this->Cell(0, 10, 'Página ' . $this->getAliasNumPage() . ' de ' . $this->getAliasNbPages(), 0, 1, 'R');

    // Opcional: Cambiar valores de pie y datos
    $pie = 2;
    $datos = 2;
}




        if (isset($GLOBALS['es_receta']) && $GLOBALS['es_receta'] == 1) {
            $CI->load->model('medico_model');
            $imagen = $CI->medico_model->dato_empresa(array('prm_codigo' =>'SYS_LOGOTIPO_SEGURADORAS'));
            $info_consulta = $CI->medico_model->dato_empresa(array('prm_codigo' =>'SYS_INFORMACION'));
            $SYS_ASEGURADORA_REDES = $CI->medico_model->dato_empresa(array('prm_codigo' =>'SYS_ASEGURADORA_REDES'));
            $html2 = '<table style=" padding-left: 10px!important; ">
                <tr><td colspan="5"><hr color="blue" size=3></td></tr>
                <tr>
                <td width="3%"></td>
                    <td width="50%"><span style="font-size:10px;">' . $info_consulta[0]['prm_valor'] . '</span></td>
                    <td width="4%"></td>
                    <td width="40%" height="40px"><span style="font-size:10px;"><strong>' . $SYS_ASEGURADORA_REDES[0]['prm_valor'] . '</strong></span><br>
                <img src="' . base_url() . 'media/imagenes/sistema/' . $imagen[0]['prm_valor'] . '.png" ></td>
                <td width="3%"></td>
                </tr></table>';
            $this->SetY(-25);
            $this->writeHTML($html2, true, 0, true, true);
            $pie = 1;
            $datos = 2;
        }

        if ($pie == 1) {
            if ($datos == 1) {
                // Posisionamieto a -15 mm del eje y
                $this->SetY(-30);

                $html = '<table border="0" width="100%">
                    <tr style="background-color: white;">
                        <td style="text-align:center;"><span style="font-size:8px; color: #EE2E3E;">' . $CI->gsatelite->get_parametro('SYS_DIR') . '</span></td>
                    </tr>
                    <tr style="background-color: white;">
                        <td style="text-align:center;"><span style="font-size:9px; color: #EE2E3E;">' . $CI->gsatelite->get_parametro('SYS_PBX') . '</span></td>
                    </tr>
                    <tr style="background-color: white;">
                        <td style="text-align:center;"><span style="font-size:9px; color: #EE2E3E;">' . $CI->gsatelite->get_parametro('SYS_WEB') . '</span></td>
                    </tr>
                    <tr style="font-size:3px; background-color: white;"><td></td></tr>
                    <tr style="font-size:3px; background-color: #B9BBBC;"><td></td></tr>
                    <tr style="font-size:3px; background-color: white;"><td></td></tr>
                    <tr style="font-size:9px; background-color: #DA1F1F;">
                        <td width="15%"></td>
                        <td width="24%" cellspacing="2">
                           <ul><li><span style="font-size:9px; color:white; font-weight:bold">Prendas Textiles</li></span></ul>
                        </td>
                        <td width="24%"><ul><li><span style="font-size:9px; color:white; font-weight:bold">  Promocionales</li></span></ul></td>
                        <td width="22%"><ul><li><span style="font-size:9px; color:white; font-weight:bold">  Impresión Digital</li></span></ul></td>
                        <td width="15%"></td>
                    </tr>
                    <tr style="font-size:3px; background-color: white;"><td></td></tr>
                    <tr style="font-size:3px; background-color: #B9BBBC;"><td colspan="5"></td></tr>
                </table>';
                $this->writeHTML($html, true, 0, true, true);
                unset($GLOBALS['es_cotizacion']);
            } else if ($datos != 1 && $datos != 2) {
                // Posisionamieto a -15 mm del eje y
                $this->SetY(-15);
                // Numero de pagina
                $this->Cell(0, 10, 'Página ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
            }
        } else if ($detalle_pla != null) {

            // Posisionamieto a -15 mm del eje y
            $this->SetY(-15);
            // Numero de pagina
            //$this->SetFont('italic', 'B', 12);
            $this->Cell(0, 10, 'Scotiabank El Salvador - Sistema Electrónico de Pagos ', 0, false, '', 0, '', 0, false, 'T', 'M');
            // Numero de pagina
            $this->Cell(0, 10, 'Página ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'R', 0, '', 0, false, 'T', 'M');
        } else if ($pie != 1 && $pie != 2) {
            // Impresion de usuario y fecha en pie de pagina
            $pie_cotizacion = (isset($GLOBALS['pie_cotizacion'])) ? 1 : 0;
            unset($GLOBALS['pie_cotizacion']);
            if ($pie_cotizacion == 1) {

                $this->SetY(-15);

                $html = '<table border="0" width="100%">';
                $html .= '<tr style="background-color: white;">
                        <td colspan="2"  style="text-align:rigth;"><span style="font-size:8px;">' . $CI->tank_auth->get_username() . '</span></td>
                    </tr>
                    <tr style="background-color: white;">
                    <td style="text-align:left;"><span style="font-size:8px;">' . ' Página ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages() . '</span></td>
                    <td style="text-align: right; size: 8;font-weight: bold;" >' . $CI->gsatelite->get_parametro('SYS_DEPARTAMENTO') . ', ' . date('d-m-Y H:i:s a') . '</td>
                    </tr> ';
                $html .= '</table>';

                $this->writeHTML($html, true, 0, true, true);
                // Posisionamieto a -15 mm del eje y
                //$this->SetY(-15);
                // Numero de pagina
                //$this->Cell(0, 10, ' Página ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
            } else {
                $this->SetFont('helvetica', 'B', 6);
                // Posisionamieto a -15 mm del eje y
                $this->SetY(-15);
                // Numero de pagina
                $this->Cell(0, 10, ' Página ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
            }
        }
    }

    public function makePDF($output, $orientacion = '', $reporte = '', $formato = 'Letter', $salida = 'I', $margenes = null) {

        // set document information$titulo,$header,$body,$generado
        $this->setPrintHeader(false);
        $this->SetSubject('Reporte');
        $this->SetKeywords('Reporte, ' . $reporte);
        // set font
        $this->SetFont('dejavusans', '', 8);
        
        if ($margenes == null) {
            $this->SetMargins(10, 10, 10);
        } else {
            $this->SetMargins($margenes[0],$margenes[1],$margenes[2]);
        }
       
        // add a page
        $this->AddPage($orientacion, $formato);

        $this->writeHTML($output, true, false, false, false, '');
        //$this->setPrintFooter(false);
        if (ob_get_contents()) ob_end_clean();
        if (isset($GLOBALS['nombre_reporte'])) {
            $reporte = $GLOBALS['nombre_reporte'];
            unset($GLOBALS['nombre_reporte']);
            $this->Output($reporte . '.pdf', $salida);
        } else {
            $this->Output('Reporte_' . $reporte . '_' . date('Y-m-d_H-m-s') . '.pdf', $salida);
        }
    }

    public function makePDFcertificados($output, $orientacion = '', $reporte = '', $formato = 'Letter', $salida = 'I') {

        // set document information$titulo,$header,$body,$generado
        $this->setPrintHeader(false);
        $this->SetSubject('Reporte');
        $this->SetKeywords('Reporte, ' . $reporte);
        // set font
        $this->SetFont('dejavusans', '', 8);
        $this->SetMargins(0, 0, 0, 0, 0, 0);
        $this->SetAutoPageBreak(true, 0);
        //$this->setFooterMargin (-1000);
        // add a page
        $this->AddPage($orientacion, $formato);

        $this->writeHTML($output, true, false, false, false, '');
        $this->setPrintFooter(false);

        if (ob_get_contents())
            ob_end_clean();
        if (isset($GLOBALS['nombre_reporte'])) {
            $reporte = $GLOBALS['nombre_reporte'];
            unset($GLOBALS['nombre_reporte']);
            $this->Output($reporte . '.pdf', $salida);
        } else {
            $this->Output('Reporte_' . $reporte . '_' . date('Y-m-d_H-m-s') . '.pdf', $salida);
        }
    }

    public function makePDF_cotizacion($output, $orientacion = '', $reporte = '', $formato = 'Letter', $salida = 'I', $footer_ali = '') {
        //$CI =& get_instance();
        // set document information$titulo,$header,$body,$generado
        // $this->setPrintHeader(false);
        $this->SetSubject('Reporte');
        $this->SetKeywords('Reporte, ' . $reporte);
        // set font
        $this->SetFont('dejavusans', '', 8);
        $this->SetMargins(10, 5, 10);

        $normal_footer = $footer_ali? $footer_ali : PDF_MARGIN_BOTTOM - 12;

        $this->SetAutoPageBreak(TRUE, $normal_footer);
        // add a page
        $this->AddPage($orientacion, $formato);

        $this->writeHTML($output, true, false, false, false, '');
        $reporte = ($reporte != "") ? $reporte : 'Reporte_' . date('Y-m-d_H-m-s');
        // if( !$footer ){
        //     $reporte .= $CI->load->view('reporte/footer', array('titulo'=> "Cotización"), true);
        // }
        if (ob_get_contents())
            ob_end_clean();
        $this->Output($reporte . '.pdf', $salida);
    }

    /**
     * Pdf::boletaPDF()
     *
     * @param string $destino D, I
     * @return void
     */
    public function boletaPDF($destino = 'D') {

        // set document information$titulo,$header,$body,$generado
        $this->setPrintHeader(false);
        $this->SetSubject('Boletas de Pago');
        $this->SetKeywords('Reporte, sistema');

        // set font
        //$this->SetFont('dejavusans', '', 2);

        if (ob_get_contents())
            ob_end_clean();
        if($destino == 'E'){
            return $this->Output('Boletas_' . date('Y-m-d-H-m-s') . '.pdf', $destino);    
        }
        else{
            $this->Output('Boletas_' . date('Y-m-d-H-m-s') . '.pdf', $destino);
        }
    }

    public function addBoleta($html, $header = null, $orientacion = "L") {
        $this->SetMargins(3, 3, 3, 3);
        $this->addPagina($html, "$orientacion", array(107, 140), array(
            'family' => 'courier',
            'style' => '',
            'size' => 6
        ));
    }

    public function addBoleta_planilla($html, $header = null, $orientacion = "L", $otra_fuente = "") {
        $this->SetMargins(3, 3, 3, 3);
        $this->addPagina($html, "$orientacion", array(140, 170), array(
            'family' => ($otra_fuente != '') ? $otra_fuente : 'courier',
            'style' => '',
            'size' => 5
        ));
    }

    public function addBoleta_f($html) {

        $this->addPagina($html, 'P', array(
            'family' => 'courier',
            'style' => '',
            'size' => 5
        ));
    }

    public function addPagina($html, $display = '', $size = 'Letter', $font = null, $header = false, $footer = false) {
        if ($font) {
            $this->SetFont($font['family'], $font['style'], $font['size']);
        } else {
            $this->SetFont('dejavusans', '', 8);
        }
        $this->AddPage($display, $size);
        $this->writeHTML($html);

        $this->setPrintFooter($header);
        $this->setPrintFooter($footer);
    }

    public function reportePDF($vista, $data, $titulo, $orientacion = '', $header = null) {

        $CI = & get_instance();
        $reporte = '';
        if ($titulo != '') {
            if (!$header) {
                $reporte .= $CI->load->view('reporte/header_utm', array('titulo' => $titulo), true);
            } else {
                $reporte .= $CI->load->view('reporte/header_' . $header, array('titulo' => $titulo), true);
            }
        }

        $reporte .= $CI->load->view($vista, $data, true);


        $this->makePDF($reporte, $orientacion, $titulo);
    }

    public function reportePDF_PLAN($vista, $data, $reporte, $orientacion = '') {

        $CI = & get_instance();
        $header['titulo'] = $reporte;

        $reporte = $this->CI->load->view('reporte/header', $header, true);

        $reporte .= $this->CI->load->view($vista, $data, true);


        $this->makePDF($reporte, $orientacion, $header['titulo'], '');
    }

    public function reportePDF_UATM($vista, $data, $reporte, $orientacion = '') {
        $CI = & get_instance();
        $header['titulo'] = $reporte;
        $reporte = $this->CI->load->view('reporte/header_uatm', $header, true);
        $reporte .= $this->CI->load->view($vista, $data, true);
        //print_r($reporte);
        //exit();
        $this->makePDF($reporte, $orientacion, $header['titulo'], "UATM");
    }

    public function reportePDF_libro_especie($vista, $data, $reporte, $orientacion = '') {
        $CI = & get_instance();
        $header['titulo'] = $reporte;
        $reporte = $this->CI->load->view('reporte/header_especie', $header, true);
        $reporte .= $this->CI->load->view($vista, $data, true);
        //print_r($reporte);
        //exit();
        $this->makePDF($reporte, $orientacion, $header['titulo']);
    }

    public function Generar_constancia_pdf($view, $data, $reporte, $orientacion = '') {
        $CI = & get_instance();
        $header['titulo'] = $reporte;
        $reporte = $this->CI->load->view('reporte/header_constancia', $header, true);
        $reporte .= $this->CI->load->view($view, $data, true);
        $this->makePDF($reporte, $orientacion, $header['titulo']);
    }

    public function partidaPDF($output, $tabla, $marginaciones = '', $posicion = '') {
        // set document information$titulo,$header,$body,$generado
        $this->setPrintHeader(false);
        $this->setPrintFooter(false);
        $this->SetSubject('Reporte');
        $this->SetKeywords('Reporte, sistema');
        if ($posicion == "L") {
            $margin2 = 0;
        } else {
            $margin2 = -20;
        }
        $this->SetMargins(0, 0, $margin2, false);
        $this->setCellPaddings(-20, -20, -20, -20);
        $this->setFooterMargin(-1000);
        // set font
        $this->SetFont('dejavusans', '', 8);
        $this->SetAutoPageBreak(false);
        // add a page
        $this->AddPage('' . $posicion . '', 'Letter');
        $tbl = '';

        $this->writeHTML($tbl . $output);

        if ($marginaciones != '') {
            $this->SetMargins(20, 20, 20, true);
            /* Orientacion de la imagen */
            $this->AddPage('' . $posicion . '', 'Letter');
            $tbl = '';
            $this->writeHTML($tbl . $marginaciones);
        }


        //$pdf->writeHTML($tbl, true, false, false, false, '');
        // print a line using Cell()
        //$this->Cell(0, 12, 'Example 001 - Sapos Ã¨Ã©Ã¬Ã²Ã¹', 1, 1, 'C');
        //Close and output PDF document
        if (ob_get_contents())
            ob_end_clean();

        $this->Output($tabla . '_' . date('Y-m-d-H-m-s') . '.pdf', 'D');
    }

    /**
     * Pdf::boletaPDF()
     * @author René Castaneda
     * @param string $destino D, I
     * @return void
     */
    public function liquidacionPDF($destino = 'D') {

        // set document information$titulo,$header,$body,$generado
        $this->setPrintHeader(false);
        $this->SetSubject('Generacion de Liquidaciones');
        $this->SetKeywords('Reporte, sistema');

        // set font
        //$this->SetFont('dejavusans', '', 2);


        if (ob_get_contents())
            ob_end_clean();
        $this->Output('Liquidaciones_' . date('Y-m-d-H-m-s') . '.pdf', $destino);
    }

    /**
     *
     * @author  René Castaneda
     * @return Crea un página por cada liquidacion
     *         que se añade a un documento consolidado en pdf.
     */
    public function addLiquidacion($html, $header = null) {
        $this->SetMargins(3, 3, 3, 3);
        $this->addPagina($html, 'P', array(107, 140), array(
            'family' => 'courier',
            'style' => '',
            'size' => 6
        ));
    }

    /**
     *
     * @author  Christian
     * @return Genera una pagina tamaño legal
     *          con orientacion: horizontal
     *
     */
    public function reportePDF_legal($vista, $data, $titulo, $orientacion = '', $header = null, $formato = null) {

        $CI = & get_instance();
        $reporte = '';
        if ($titulo != '') {
            if (!$header) {
                $reporte .= $CI->load->view('reporte/header_utm', array('titulo' => $titulo), true);
            } else {
                $reporte .= $CI->load->view('reporte/header_' . $header, array('titulo' => $titulo), true);
            }
        }

        $reporte .= $CI->load->view($vista, $data, true);

        $this->makePDF($reporte, $orientacion, $titulo, $formato);
    }

    public function PDF_Cierre($html='', $nombre_pdf='', $orientacion='', $formato='Letter',$personalizado = false)
    {
        if($personalizado==true)
        {
        $pdf =new TCPDF();
        // $pdf =new TCPDF('P', 'pt', array(750, 800), true, 'UTF-8', false);
        // $pdf->SetCreator(PDF_CREATOR);
        // $pdf->AddPage();
        // $pdf->writeHTML($html, true, false, true, false, '');
        // $pdf->lastPage();
        // $pdf->Output($nombre_pdf . '.pdf', 'F');

        $pdf->setPrintHeader(false);
        $pdf->setCellPaddings(0, 0, 0, 0);
        $pdf->SetAutoPageBreak(true, 0);

        if ($margenes == null) {
            $pdf->SetMargins(10, 10, 10);
        } else {
            $pdf->SetMargins($margenes[0],$margenes[1],$margenes[2]);
        }

        $pdf->AddPage($orientacion, $formato);
        // $pdf->AddPage('P', array(55, 230), array(
        //       'family' => 'Courier New',
        //       'style' => '',
        //       'size' => 6));
        $pdf->setPrintFooter(false);

        $pdf->writeHTML($html, true, false, false, false, '');
        //$pdf->lastPage();
        if (ob_get_contents())
          ob_end_clean();
        $pdf->Output($nombre_pdf . '.pdf', 'F');
        }
        else {

            // set document information$titulo,$header,$body,$generado
            $this->setPrintHeader(false);
            $this->SetSubject('cinta auditoria');
            $this->SetKeywords('auditoria, sistema');

            // set font
            //$this->SetFont('dejavusans', '', 2);

            if (ob_get_contents())
                ob_end_clean();
            $this->Output($nombre_pdf . '.pdf', 'F');
        }
    }

    public function makePDF2($output, $orientacion = '', $reporte = '', $formato = 'Letter', $salida = 'I', $margenes = null) {

        // set document information$titulo,$header,$body,$generado
        $this->setPrintHeader(false);
        $this->SetSubject('Reporte');
        $this->SetKeywords('Reporte, ' . $reporte);
        // set font
        $this->SetFont('dejavusans', '', 8);
        
        if ($margenes == null) {
            $this->SetMargins(10, 10, 10);
        } else {
            $this->SetMargins($margenes[0],$margenes[1],$margenes[2]);
        }
       
        // add a page
        $this->AddPage($orientacion, $formato);

        $this->writeHTML($output, true, false, false, false, '');
        //$this->setPrintFooter(false);
        if (ob_get_contents()) ob_end_clean();
        if (isset($GLOBALS['nombre_reporte'])) {
            $reporte = $GLOBALS['nombre_reporte'];
            unset($GLOBALS['nombre_reporte']);
            return $this->Output($reporte . '.pdf', $salida);
        } else {
            return $this->Output('Reporte_' . $reporte . '_' . date('Y-m-d_H-m-s') . '.pdf', $salida);
        }
    }    

    }

/* End of file pdf.php */
/* Location: ./application/libraries/pdf.php */
