<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Recursos_validacion
{
    protected $CI;
    public $usuario_id;
    public $expira_en;

    public function __construct()
    {
        $this->CI =& get_instance();
        $this->CI->load->model('api/api_facturacion_model');
    }

    public function validar_token_bearer()
    {
        $respuesta = [
            'status' => 'error',
            'code' => 401
        ];

        if (!function_exists('getallheaders')) {
            $this->responder_error(array_merge($respuesta, [
                'error' => 'Configuration error',
                'message' => 'getallheaders() no está disponible',
                'code' => 500
            ]));
        }

        $headers = getallheaders();
        if (empty($headers['Authorization'])) {
            $this->responder_error(array_merge($respuesta, [
                'error' => 'Authorization error',
                'message' => 'Debe proporcionar un token Bearer'
            ]));
        }

        $authHeader = trim($headers['Authorization']);
        $token = str_ireplace('Bearer ', '', $authHeader);
        $info_token = $this->CI->api_facturacion_model->validar_access_token($token);

        if (!$info_token) {
            $this->responder_error(array_merge($respuesta, [
                'error' => 'Authorization error',
                'message' => 'Token inválido o expirado',
                'error_code' => 'access_expired'
            ]));
        }

        $this->usuario_id = $info_token['usuario_id'];
        $this->expira_en = $info_token['expira_en'];
    }

    public function verificar_firma_json()
    {
        $this->CI->load->database();
        $input_raw = file_get_contents('php://input');
        $datos = json_decode($input_raw, true);

        if (!$datos || !isset($datos['json'], $datos['firma'])) {
            $this->respuesta_json(400, 'Faltan datos necesarios para verificar la firma.');
        }

        $json_firmado = is_array($datos['json']) ? json_encode($datos['json'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) : $datos['json'];
        $firma_base64 = $datos['firma'];

        if (!preg_match('/^[a-zA-Z0-9\/\r\n+]*={0,2}$/', $firma_base64)) {
            $this->respuesta_json(400, 'La firma no tiene un formato Base64 válido.');
        }

        $firma_binaria = base64_decode($firma_base64, true);
        if ($firma_binaria === false) {
            $this->respuesta_json(400, 'La firma no pudo decodificarse correctamente (Base64 inválido).');
        }

        $certificado = $this->CI->api_facturacion_model->verificar_certificado_usuario($this->usuario_id);
        if (!$certificado || empty($certificado->cer_public_key)) {
            $this->respuesta_json(404, 'Certificado no encontrado o inactivo.');
        }

        $public_key_pem = "-----BEGIN PUBLIC KEY-----\n" .
            chunk_split($certificado->cer_public_key, 64, "\n") .
            "-----END PUBLIC KEY-----";

        $ok = openssl_verify($json_firmado, $firma_binaria, $public_key_pem, OPENSSL_ALGO_SHA256);

        if ($ok === 1) {
            $this->respuesta_json(200, 'Firma válida', 'success');
        } elseif ($ok === 0) {
            $this->respuesta_json(401, 'Firma inválida');
        } else {
            $this->respuesta_json(500, 'Error al verificar firma: ' . openssl_error_string());
        }
    }

    public function verificar_firma_directa($json, $firma_base64, $usuario_id)
    {
        $respuesta = [
            'valido' => false,
            'mensaje' => 'Error desconocido'
        ];

        $firma_binaria = base64_decode($firma_base64, true);
        if ($firma_binaria === false) {
            $respuesta['mensaje'] = 'La firma no pudo decodificarse correctamente.';
            return $respuesta;
        }

        $certificado = $this->CI->api_facturacion_model->verificar_certificado_usuario($usuario_id);
        if (!$certificado || empty($certificado->cer_public_key)) {
            $respuesta['mensaje'] = 'Certificado no encontrado.';
            return $respuesta;
        }

        $public_key_pem = "-----BEGIN PUBLIC KEY-----\n" .
            chunk_split($certificado->cer_public_key, 64, "\n") .
            "-----END PUBLIC KEY-----";

        $json_firmado = is_array($json)
            ? json_encode($json, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES)
            : $json;

        $ok = openssl_verify($json_firmado, $firma_binaria, $public_key_pem, OPENSSL_ALGO_SHA256);

        if ($ok === 1) {
            return ['valido' => true];
        } elseif ($ok === 0) {
            $respuesta['mensaje'] = 'Firma inválida';
        } else {
            $respuesta['mensaje'] = 'Error al verificar firma: ' . openssl_error_string();
        }

        return $respuesta;
    }



    public function generar_certificado_empresa()
    {
        $CI = &get_instance();
        $CI->load->helper('file');
        $mensajes = [];
        $empresa_id = 1;

        $CI->db->where('cer_emr_id', $empresa_id);
        $CI->db->update('cer_certificados', ['cer_estado' => '0']);
        $mensajes[] = 'Certificados anteriores desactivados.';

        $config = [
            "private_key_type" => OPENSSL_KEYTYPE_RSA,
            "private_key_bits" => 2048,
        ];



        $pkey = openssl_pkey_new($config);
        if (!$pkey) return ['status' => 'error', 'message' => 'Error al generar clave: ' . openssl_error_string()];
        $mensajes[] = 'Par de claves RSA generado.';

        if (!openssl_pkey_export($pkey, $private_key)) return ['status' => 'error', 'message' => 'No se pudo exportar la clave privada: ' . openssl_error_string()];
        $mensajes[] = 'Clave privada exportada.';

        $key_details = openssl_pkey_get_details($pkey);
        if (!$key_details || !isset($key_details['key'])) return ['status' => 'error', 'message' => 'No se pudo obtener la clave pública: ' . openssl_error_string()];

        $public_key = $key_details['key'];
        $mensajes[] = 'Clave pública extraída.';

        $public_key_pure = trim(str_replace(["-----BEGIN PUBLIC KEY-----", "-----END PUBLIC KEY-----", "\r", "\n"], '', $public_key));
        $private_key_pure = trim(str_replace(["-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----", "\r", "\n"], '', $private_key));
        $mensajes[] = 'Claves limpias listas para guardar.';

        $xml = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?><CertificadoEmpresa></CertificadoEmpresa>');
        $xml->addChild('empresa_id', $empresa_id);
        $pub = $xml->addChild('publicKey', $public_key_pure);
        $pub->addAttribute('keyType', 'PUBLIC');
        $pub->addAttribute('algorithm', 'RSA');
        $pub->addAttribute('format', 'X.509');
        $pri = $xml->addChild('privateKey', $private_key_pure);
        $pri->addAttribute('keyType', 'PRIVATE');
        $pri->addAttribute('algorithm', 'RSA');
        $pri->addAttribute('format', 'PKCS#8');
        $xml->addChild('activo', 'true');
        $mensajes[] = 'XML generado.';

        $carpeta = FCPATH . 'certificados/';
        if (!is_dir($carpeta)) {
            mkdir($carpeta, 0777, true);
            $mensajes[] = 'Carpeta creada: certificados/';
        }

        $nombre_archivo = 'empresa_' . $empresa_id . '_' . date('Ymd_His') . '.xml';
        $ruta = $carpeta . $nombre_archivo;
        $xml_content = $xml->asXML();
        if (substr($xml_content, 0, 3) === "\xEF\xBB\xBF") $xml_content = substr($xml_content, 3);
        file_put_contents($ruta, $xml_content);
        $mensajes[] = "Archivo XML guardado como: $nombre_archivo";

        $CI->db->insert('cer_certificados', [
            'cer_emr_id' => $empresa_id,
            'cer_public_key' => $public_key_pure,
            'cer_private_key' => $private_key_pure,
            'cer_estado' => '1',
            'cer_algoritmo' => 'RSA',
            'cer_formato_publico' => 'X.509',
            'cer_formato_privado' => 'PKCS#8',
            'cer_fecha_creacion' => date('Y-m-d H:i:s'),
            'cer_archivo_xml' => $nombre_archivo
        ]);
        $mensajes[] = 'Certificado guardado en la base de datos.';

        if ($this->CI->input->get('descargar') == '1' && file_exists($ruta)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="' . basename($ruta) . '"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');

                // Leer el contenido
                $contenido = file_get_contents($ruta);

                // Limpiar BOM si existe (UTF-8 BOM: EF BB BF)
                if (substr($contenido, 0, 3) === "\xEF\xBB\xBF") {
                    $contenido = substr($contenido, 3);
                }

                header('Content-Length: ' . strlen($contenido));
                ob_clean();
                echo $contenido;
                exit;
            }
            else{
            return $this->CI->output
            ->set_status_header(200)
            ->set_content_type('application/json')
            ->set_output(json_encode([
                'status' => 'success',
                'message' => 'Certificado generado correctamente.',
                'archivo' => $ruta,
                'pasos' => $mensajes,
                'public_key' => $public_key_pure,
                'private_key' => $private_key_pure
            ]));
        }
    }

    public function firmar_json_con_certificado()
    {
        $CI = &get_instance();
        $CI->load->database();
        $input_raw = file_get_contents('php://input');
        $datos = json_decode($input_raw, true);

        if (!$datos || !isset($datos['json'])) {
            return ['status' => 'error', 'message' => 'Se requiere el campo "json" en el cuerpo de la solicitud.'];
        }

        $json = json_encode($datos['json'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

        $certificado = $this->CI->api_facturacion_model->verificar_certificado_usuario($this->usuario_id);

        if (!$certificado) {
            return ['status' => 'error', 'message' => 'No se encontró un certificado activo para la empresa.'];
        }

        $clave_privada_pem = "-----BEGIN PRIVATE KEY-----\n" . chunk_split($certificado->cer_private_key, 64, "\n") . "-----END PRIVATE KEY-----";
        $private_key = openssl_pkey_get_private($clave_privada_pem);

        if (!$private_key) return ['status' => 'error', 'message' => 'No se pudo cargar la clave privada: ' . openssl_error_string()];

        $ok = openssl_sign($json, $firma_binaria, $private_key, OPENSSL_ALGO_SHA256);
        if (!$ok) return ['status' => 'error', 'message' => 'No se pudo firmar el JSON: ' . openssl_error_string()];

        return [
            'status' => 'success',
            'json' => $datos['json'],
            'code' => 200,
            'firma' => base64_encode($firma_binaria)
        ];
    }


    private function respuesta_json($status_code, $mensaje, $estado = 'error')
    {   
        clean_buffer();
        http_response_code($status_code);
        echo json_encode([
            'status' => $estado,
            'message' => $mensaje
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }

    private function responder_error($data)
    {
        $codigo_http = isset($data['code']) ? (int)$data['code'] : 401;
        $server_protocol = (isset($_SERVER['SERVER_PROTOCOL']) && in_array($_SERVER['SERVER_PROTOCOL'], ['HTTP/1.0', 'HTTP/1.1', 'HTTP/2'], TRUE))
            ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.1';

        header("$server_protocol $codigo_http", TRUE, $codigo_http);
        clean_buffer();
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        exit;
    }
}
