<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class EmailPHPMailer {

    protected $CI;
    protected $mail;

    protected $smtpHost;
    protected $smtpUser;
    protected $provider = 'generic';

    /* -------------------- Carga dinámica PHPMailer v5/v6 -------------------- */
    protected function loadPHPMailerRuntime()
    {
        $forced = getenv('FORCE_PHPMAILER_BRANCH');

        if (!defined('PHP_VERSION_ID')) {
            $v = explode('.', PHP_VERSION);
            define('PHP_VERSION_ID', $v[0]*10000 + $v[1]*100 + $v[2]);
        }

        $useV6 = ($forced === '6') ? true : (($forced === '5') ? false : (PHP_VERSION_ID >= 70000));

        if ($useV6) {
            require_once(APPPATH . 'libraries/PHPMailer7.4/src/PHPMailer.php');
            require_once(APPPATH . 'libraries/PHPMailer7.4/src/SMTP.php');
            require_once(APPPATH . 'libraries/PHPMailer7.4/src/Exception.php');

            if (!class_exists('PHPMailer', false)) {
                class_alias(\PHPMailer\PHPMailer\PHPMailer::class, 'PHPMailer');
            }
            if (!class_exists('SMTP', false)) {
                class_alias(\PHPMailer\PHPMailer\SMTP::class, 'SMTP');
            }
            if (!class_exists('phpmailerException', false)) {
                class_alias(\PHPMailer\PHPMailer\Exception::class, 'phpmailerException');
            }
        } else {
            require_once(APPPATH . 'libraries/PHPMailer5.6/class.phpmailer.php');
            require_once(APPPATH . 'libraries/PHPMailer5.6/class.smtp.php');
        }
    }

    protected function detectProvider($host)
    {
        $h = strtolower($host);
        if (strpos($h, 'office365.com') !== false || strpos($h, 'outlook.office365.com') !== false) return 'o365';
        if (strpos($h, 'smtp.gmail.com') !== false || strpos($h, 'googlemail.com') !== false || strpos($h, 'gmail.com') !== false) return 'gmail';
        if (strpos($h, 'zoho.') !== false) return 'zoho';
        return 'generic';
    }

    /* -------------------- Constructor -------------------- */
    public function __construct()
    {
        $this->CI =& get_instance();
        $this->loadPHPMailerRuntime();

        $json_config = $this->CI->gsatelite->get_parametro_emp('SYS_CONFIGURACION_CORREO');
        $params = json_decode($json_config);

        $host    = isset($params->SERVIDOR) ? trim($params->SERVIDOR)
                 : (isset($params->SMTPHost) ? trim($params->SMTPHost) : 'smtp.office365.com');

        $port    = isset($params->PUERTO) ? (int)$params->PUERTO
                 : (isset($params->SMTPPort) ? (int)$params->SMTPPort : 587);

        $user    = isset($params->CUENTA) ? trim($params->CUENTA)
                 : (isset($params->SMTPUser) ? trim($params->SMTPUser) : '');

        $pass    = isset($params->CLAVE) ? (string)$params->CLAVE
                 : (isset($params->SMTPPass) ? (string)$params->SMTPPass : '');

        $charset = isset($params->charset) ? $params->charset : 'utf-8';
        $debug   = isset($params->debug) ? (bool)$params->debug : false;

        $crypto = '';
        if (isset($params->TLS)) {
            $tls = strtolower((string)$params->TLS);
            $crypto = ($tls === '1' || $tls === 'true' || $tls === 'tls') ? 'tls' : '';
        }
        if ($crypto === '' && isset($params->SMTPCrypto)) {
            $val = strtolower((string)$params->SMTPCrypto);
            if (in_array($val, ['tls','ssl',''])) $crypto = $val;
        }
        // Autodetecta si no vino
        if ($crypto === '') {
            if ($port === 465) $crypto = 'ssl';
            elseif ($port === 587) $crypto = 'tls';
        }

        $authType = null;
        if (!empty($params->AUTH)) {
            $authType = strtoupper(trim($params->AUTH)); // LOGIN|PLAIN|CRAM-MD5|XOAUTH2
        }

        $allowSelfSigned = !empty($params->ALLOW_SELF_SIGNED);

        $this->smtpHost = $host;
        $this->smtpUser = $user;
        $this->provider = $this->detectProvider($host);
        $this->mail = new PHPMailer(true);
        $this->mail->isSMTP();
        $this->mail->Host       = $host;
        $this->mail->SMTPAuth   = true;
        $this->mail->Username   = $user;
        $this->mail->Password   = $pass;
        $this->mail->Port       = $port;
        $this->mail->CharSet    = $charset;
        $this->mail->isHTML(true);
        $this->mail->Encoding   = 'base64';

        if ($authType) {
            $this->mail->AuthType = $authType;
        } else {
            if ($this->provider === 'o365' && property_exists($this->mail, 'AuthType')) {
                $this->mail->AuthType = 'LOGIN';
            }
        }

        $this->mail->Debugoutput = function ($str, $level) {
            log_message('debug', "SMTP[$level] $str");
        };
        if (defined('SMTP::DEBUG_SERVER')) {
            $this->mail->SMTPDebug = $debug ? SMTP::DEBUG_SERVER : SMTP::DEBUG_OFF;
        } else {
            $this->mail->SMTPDebug = $debug ? 2 : 0;
        }

        if ($crypto === 'tls') {
            $this->mail->SMTPSecure = 'tls';
            if (property_exists($this->mail, 'SMTPAutoTLS')) $this->mail->SMTPAutoTLS = true;
        } elseif ($crypto === 'ssl') {
            $this->mail->SMTPSecure = 'ssl';
            if (property_exists($this->mail, 'SMTPAutoTLS')) $this->mail->SMTPAutoTLS = false;
        } else {
            $this->mail->SMTPSecure = '';
            if (property_exists($this->mail, 'SMTPAutoTLS')) $this->mail->SMTPAutoTLS = false;
        }

        if ($allowSelfSigned) {
            $this->mail->SMTPOptions = [
                'ssl' => [
                    'verify_peer'       => false,
                    'verify_peer_name'  => false,
                    'allow_self_signed' => true,
                ]
            ];
        }
    }

    /* -------------------- Enviar -------------------- */
    public function enviar($de, $nombre, $para, $asunto, $mensaje, $cc = null, $bcc = null, $adjunto = null)
    {
        $this->mail->clearAllRecipients();
        $this->mail->clearAttachments();
        if (method_exists($this->mail, 'clearReplyTos')) {
            $this->mail->clearReplyTos();
        }

        if (empty($para)) return false;

        if (is_string($para)) {
            $para = str_replace(';', ',', $para);
            $para = array_map('trim', explode(',', $para));
        }
        foreach ((array)$para as $dest) {
            if (filter_var($dest, FILTER_VALIDATE_EMAIL)) {
                $this->mail->addAddress($dest);
            }
        }
        $toCount = 0;
        if (method_exists($this->mail, 'getToAddresses')) {
            $toCount = count($this->mail->getToAddresses());
        } else {
            $toCount = (is_array($this->mail->to) ? count($this->mail->to) : 0);
        }
        if ($toCount === 0) {
            log_message('error', 'EmailPHPMailer: sin destinatarios válidos');
            return false;
        }

        /* --------- Reglas por proveedor ---------- */
        if ($this->provider === 'o365' || $this->provider === 'zoho') {
            // Envelope sender
            $this->mail->Sender = $this->smtpUser;

            $from = $de ?: $this->smtpUser;
            if (strtolower($from) !== strtolower($this->smtpUser)) {
                if (!empty($de) && filter_var($de, FILTER_VALIDATE_EMAIL)) {
                    $this->mail->addReplyTo($de, $nombre);
                }
                $from = $this->smtpUser;
            }
            $this->mail->setFrom($from, $nombre);
        } else {
            $from = $de ?: $this->smtpUser;
            $this->mail->setFrom($from, $nombre);
            $this->mail->Sender = $this->smtpUser;
        }

        // Asunto
        $this->mail->Subject = $asunto;

        if (is_string($mensaje)) {
            $mensaje = str_replace(['\\r\\n', '\\n', '\\r'], ["\r\n", "\n", "\r"], $mensaje);
            $mensaje = str_replace('\\/', '/', $mensaje);
            $mensaje = preg_replace_callback('/\\\\u([0-9a-fA-F]{4})/', function ($m) {
                $cp = hexdec($m[1]);
                return mb_convert_encoding(pack('n', $cp), 'UTF-8', 'UTF-16BE');
            }, $mensaje);
        }
        $this->mail->Body    = $mensaje;
        $this->mail->AltBody = trim(strip_tags($mensaje));

        // CC
        if ($cc) {
            if (is_string($cc)) {
                $cc = str_replace(';', ',', $cc);
                $cc = array_map('trim', explode(',', $cc));
            }
            foreach ((array)$cc as $c) {
                if (filter_var($c, FILTER_VALIDATE_EMAIL)) {
                    $this->mail->addCC($c);
                }
            }
        }

        // BCC
        if ($bcc) {
            if (is_string($bcc)) {
                $bcc = str_replace(';', ',', $bcc);
                $bcc = array_map('trim', explode(',', $bcc));
            }
            foreach ((array)$bcc as $b) {
                if (filter_var($b, FILTER_VALIDATE_EMAIL)) {
                    $this->mail->addBCC($b);
                }
            }
        }

        // Adjuntos
        if ($adjunto) {
            foreach ((array)$adjunto as $file) {
                if (is_string($file) && file_exists($file)) {
                    $this->mail->addAttachment($file);
                }
            }
        }

        try {
            return $this->mail->send();
        } catch (\Exception $e) {
            $last = '';
            if (method_exists($this->mail, 'getSMTPInstance')) {
                $smtp = $this->mail->getSMTPInstance();
                if ($smtp && method_exists($smtp, 'getLastReply')) {
                    $last = $smtp->getLastReply();
                }
            }
            echo json_encode(['error' => 'PHPMailer Exception: ' . $e->getMessage(), 'smtp' => $last]); exit;
        } catch (\Throwable $t) {
            echo json_encode(['error' => 'PHPMailer Throwable: ' . $t->getMessage()]); exit;
        }
    }
}
