<?php

/**
 * @author alexis
 * @copyright 2014
 * @Modify by: Mario Marquez
 * @since 2017-06-23
 * @return Función para formatear las fechas, dejando en desuso la funcion Strtotime
 * 
 */

function convertirFecha($fecha) {
    // Lista de formatos posibles
    $formatos = [
        "n/j/Y h:i:s A",  // 2/11/2025 12:00:00 AM
        "n/j/Y H:i:s",     // 2/11/2025 23:59:59
        "Y-m-d H:i:s",     // 2025-02-11 23:59:59
        "Y-m-d",           // 2025-02-11
        "d/m/Y",           // 11/02/2025
        "m/d/Y",           // 02/11/2025
        "d-m-Y",           // 11-02-2025
        "m-d-Y",           // 02-11-2025
        "j/n/Y",           // 11/2/2025
        "j-n-Y",           // 11-2-2025
        "Y/m/d",           // 2025/02/11
        "d M Y",           // 11 Feb 2025
        "M d, Y",          // Feb 11, 2025
        "l, F j, Y",       // Tuesday, February 11, 2025
        "D, d M Y",        // Tue, 11 Feb 2025
    ];

    foreach ($formatos as $formato) {
        $fecha_obj = DateTime::createFromFormat($formato, $fecha);
        if ($fecha_obj) {
            return $fecha_obj->format("Y-m-d"); 
        }
    }

    $timestamp = strtotime($fecha);
    if ($timestamp) {
        return date("Y-m-d", $timestamp);
    }

    return $fecha;
}


function formatear_fecha($formato = 'Y-m-d', $fecha)
{

    if ($fecha == '' || $fecha == null) {
        return null;
    }
    if ($fecha == '0000-00-00 00:00:00' || $fecha == '0000-00-00') { //validar que venga una fecha valida.
        return null;
    }
    $fecha = str_replace('/', '-', $fecha);

    try {
        $fechaConvert = new DateTime($fecha);
        return $fechaConvert->format($formato);
    } catch (Exception $e) {
        return null;
    }
}

function print_fecha($fecha, $formato = '')
{

    $str = '';

    if ($fecha == '') {
        return $fecha;
    }

    if ($formato == '') {
        $formato = 'd/m/Y';
    }

    $str = date($formato, strtotime($fecha));

    return $str;
}

function satelite_validar($ajax = false)
{
    $CI = &get_instance();
    if (!$CI->tank_auth->is_logged_in() && !$CI->input->is_ajax_request()) {
        $CI->gsatelite->show_dialog('La sesión ha expirado.', '/auth/login/', 'info'); //redirecciónar y mostrar un mensaje.
        //redirect('/auth/login/');
    }
    $ajax = ($ajax) ? true : ($CI->input->is_ajax_request());

    if (!$CI->tank_auth->is_logged_in() && $ajax) {
        if (!$CI->input->is_ajax_request()) {
            $CI->gsatelite->show_dialog('La sesión ha expirado.', '/auth/login/', 'info'); //redirecciónar y mostrar un mensaje.
        } else {
            $redirec_script = ""; //"<script>crear_alerta('info','La sesi&oacute;n a expirado','favor iniciar nuevamente'); setTimeout( function() { location.href = '".base_url()."'; }, 4000);</script>";
            die("<h2>La sesión ha expirado.</h2><a href='" . base_url() . "'><b>Click para iniciar sesión</b></a>$redirec_script");
        }
    }
}

function generar_codigo_cor($numero = 1, $maximo = 4)
{

    $codigo = "";

    for ($i = 1; $i <= $maximo; $i++) {
        if ($maximo != strlen($numero)) {
            $codigo .= '0';
        }


        if ($i == ($maximo - strlen($numero)) || $maximo == strlen($numero)) {
            $codigo .= $numero;
            break;
        }
    }

    return $codigo;
}

function clean_mysqli_connection($dbc)
{
    while (mysqli_more_results($dbc)) {
        if (mysqli_next_result($dbc)) {
            $result = mysqli_use_result($dbc);

            if (get_class($result) == 'mysqli_stmt') {
                mysqli_stmt_free_result($result);
            } else {
                unset($result);
            }
        }
    }
}

/**
 * @author René Castaneda
 * @since 2017-05-17
 * @return Función cargar vista generica utilizable en todos los controladores (siguiendo la jerarquia para nombrar las vista a partir del url)
 */
function cargarvista($data = 0, $crud = 0, $ruta_vista = null)
{
    $CI = &get_instance();
    $CI->load->view('vacia', $crud);
    if ($data != 0)
        $data = array_merge($data, $CI->masterpage->getUsuario());
    else
        $data = $CI->masterpage->getUsuario();
    $vista = (trim($ruta_vista) != '') ? $ruta_vista : $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
    $CI->masterpage->setMasterPage('masterpage_default');
    $CI->masterpage->addContentPage($vista, 'content', $data);
    $CI->masterpage->show();
}

/**
 * @author Mario Marquez
 * @since 2017-05-17
 * @return Función de conversion de Strings a Float.
 */
function convertirFloat($num)
{
    $dotPos = strrpos($num, '.');
    if ($dotPos == 0) {
        $num .= '.00';
    }
    $dotPos = strrpos($num, '.');
    $commaPos = strrpos($num, ',');
    $sep = (($dotPos > $commaPos) && $dotPos) ? $dotPos : ((($commaPos > $dotPos) && $commaPos) ? $commaPos : false);

    if (!$sep) {
        return floatval(preg_replace("/[^0-9-]/", "", $num));
    }

    return floatval(
        preg_replace("/[^0-9-]/", "", substr($num, 0, $sep)) . '.' .
            preg_replace("/[^0-9-]/", "", substr($num, $sep + 1, strlen($num)))
    );
}


/**
 * @author René Castaneda
 * @since 2017-10-13
 * @return Limpiar de caracteres raros una cadena(string)
 */
function clean_string($string = "", $sustituto_espacio = "_")
{

    $string = trim($string);

    $string = str_replace(
        array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),
        array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),
        $string
    );

    $string = str_replace(
        array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),
        array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),
        $string
    );

    $string = str_replace(
        array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),
        array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),
        $string
    );

    $string = str_replace(
        array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),
        array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),
        $string
    );

    $string = str_replace(
        array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),
        array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),
        $string
    );

    $string = str_replace(
        array('ñ', 'Ñ', 'ç', 'Ç'),
        array('n', 'N', 'c', 'C',),
        $string
    );

    //Esta parte se encarga de eliminar cualquier caracter extraño
    $string = str_replace(
        array(
            "\\", "¨", "º", "-", "~", "*",
            "#", "@", "|", "!", "\"",
            "·", "$", "%", "&", "/",
            "(", ")", "?", "'", "¡",
            "¿", "[", "^", "`", "]",
            "+", "}", "{", "¨", "´",
            ">", "< ", ";", ",", ":",
            ".", " "
        ),
        "$sustituto_espacio",
        $string
    );


    return $string;
}


/**
 * @author René Castaneda
 * @since 2018-05-03
 * @param $array array asociativo multidimencional.
 * @return Retorna un array multidimensional ordenado por una columna especifica.
 */
function array_sort($array, $on, $order = SORT_ASC)
{

    $new_array = array();
    $sortable_array = array();

    if (count($array) > 0) {
        foreach ($array as $k => $v) {
            if (is_array($v)) {
                foreach ($v as $k2 => $v2) {
                    if ($k2 == $on) {
                        $sortable_array[$k] = $v2;
                    }
                }
            } else {
                $sortable_array[$k] = $v;
            }
        }

        switch ($order) {
            case SORT_ASC:
                asort($sortable_array);
                break;
            case SORT_DESC:
                arsort($sortable_array);
                break;
        }

        foreach ($sortable_array as $k => $v) {
            $new_array[$k] = $array[$k];
        }
    }

    return $new_array;
}

/**
 * @author René Castaneda
 * @since 2019-04-26
 * @return a los elementos de un array codificarlos con utf-8 (caracteres "raros") o también una cadena especifica.
 */
function utf8_converter($array)
{
    if (is_array($array) && count($array) > 0) {
        array_walk_recursive($array, function (&$item, $key) {
            if (!mb_detect_encoding($item, 'utf-8', true)) {
                $item = utf8_encode($item);
            }
        });
    } elseif (!is_array($array) && trim($array) != "" && strlen(trim($array)) > 0) { //si el array es un string
        if (!mb_detect_encoding($array, 'utf-8', true)) {
            $array = utf8_encode($array);
        }
    }

    return $array;
}

if (!function_exists('array_column')) {
    function array_column(array $input, $columnKey, $indexKey = null)
    {
        $array = array();
        foreach ($input as $value) {
            if (!array_key_exists($columnKey, $value)) {
                trigger_error("Key \"$columnKey\" does not exist in array");
                return false;
            }
            if (is_null($indexKey)) {
                $array[] = $value[$columnKey];
            } else {
                if (!array_key_exists($indexKey, $value)) {
                    trigger_error("Key \"$indexKey\" does not exist in array");
                    return false;
                }
                if (!is_scalar($value[$indexKey])) {
                    trigger_error("Key \"$indexKey\" does not contain scalar value");
                    return false;
                }
                $array[$value[$indexKey]] = $value[$columnKey];
            }
        }
        return $array;
    }
}
function validarFechaPeriodoContable($fecha)
{
    $CI = &get_instance();
    $periodo_contable = $CI->tank_auth->get_periodo_contable();
    $resultado = false;

    if (count($periodo_contable) > 0) {
        $mesFecha = formatear_fecha('Ym', $fecha);
        $resultado = (in_array($mesFecha, array_column($periodo_contable, 'codigo'))) ? true : false;
    }

    return $resultado;
}

/**
 * @author René Castaneda
 * @since 2020-01-11
 * @return Función cargar vista generica utilizable en todos los controladores (siguiendo la jerarquia para nombrar las vista a partir del url)
 carga las vistas en modal sin entorno de menú de la masterpage
 */
function cargarvista_modal($data = 0, $crud = 0, $ruta_vista = null)
{
    $CI = &get_instance();
    if ($data != 0)
        $data = array_merge($data, $CI->masterpage->getUsuario());
    else
        $data = $CI->masterpage->getUsuario();

    $ubicacion_vista = (trim($ruta_vista) != '') ? $ruta_vista : $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
    if ($crud) {
        $data = array_merge($data, (array) $crud);
    }
    $html = $CI->load->view($ubicacion_vista, $data, true);
    $data['contenido_html'] = $html;
    $CI->load->view('carga_vista_masterpage', $data);
}


/**
 * @author René Castaneda
 * @since 2020-02-25
 * @return String de versión del sistema
 */
function getVersion()
{
    $config = &get_config();
    $CI = &get_instance();
    $version_conf =  (isset($config['sys_version'])) ? $config['sys_version'] : '';
    $version_par = $CI->gsatelite->get_parametro('SYS_VERSION');
    return (trim($version_conf) != '') ? trim($version_conf) : trim($version_par);
}

function get_array_meses()
{

    $meses = array('1' => 'Enero', '2' => 'Febrero', '3' => 'Marzo', '4' => 'Abril', '5' => 'Mayo', '6' => 'Junio', '7' => 'Julio', '8' => 'Agosto', '9' => 'Septiembre', '10' => 'Octubre', '11' => 'Noviembre', '12' => 'Diciembre');

    return $meses;
}

function formatFileSize($sizeInKB) {
    if ($sizeInKB < 1024) {
        return $sizeInKB . ' KB';
    } elseif ($sizeInKB < 1048576) {
        $sizeInMB = $sizeInKB / 1024;
        return number_format($sizeInMB, 2) . ' MB';
    } elseif ($sizeInKB < 1073741824) {
        $sizeInGB = $sizeInKB / 1048576;
        return number_format($sizeInGB, 2) . ' GB';
    } else {
        $sizeInTB = $sizeInKB / 1073741824;
        return number_format($sizeInTB, 2) . ' TB';
            }
        }


function getFileIconClass($url, $returnIcon = false) {
    $ext = pathinfo($url, PATHINFO_EXTENSION);
    $ext = strtolower($ext); // Convertimos la extensión a minúsculas para evitar errores.

    $icons = [
        'pdf' => 'fa-file-pdf',
        'xlsx' => 'fa-file-excel',
        'xls' => 'fa-file-excel',
        'docx' => 'fa-file-word',
        'doc' => 'fa-file-word',
        'zip' => 'fa-file-archive',
        'rar' => 'fa-file-archive',
    ];

    // Si es solo el icono
    if ($returnIcon) {
        return isset($icons[$ext]) ? $icons[$ext] : 'fa-file'; // Default to a generic file icon
    }

    // Si es la clase para el botón
    return 'btn-' . (isset($icons[$ext]) ? $icons[$ext] : 'file');
}

if(!function_exists('getallheaders')) {
    function getallheaders() {
        $headers = [];
        foreach ($_SERVER as $name => $value) {
            // Solo los encabezados HTTP comienzan con "HTTP_"
            if (substr($name, 0, 5) === 'HTTP_') {
                // Convierte el nombre del encabezado de "HTTP_X_FOO" a "X-Foo"
                $headers[str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))))] = $value;
            }
        }
        return $headers;
    }
}


function clean_buffer(){
    if (ob_get_length()) {
        ob_clean();
    }
    return true;
}

    #***********************************************************************************************#
    #************************************LECTOR DE JSON ********************************************#
    #***********************************************************************************************#

function convertCodeToNameTypeDte($type){
        switch ($type) {
            case '01':
                    $tipoDte = "Factura Electrónica";
                break;
            case '02':
                    $tipoDte = "";
                break;
            case '03':
                    $tipoDte = "Comprobante de Crédito Fiscal Electrónico";
                break;
            case '04':
                    $tipoDte = "Nota de Remisión Electrónica";
                break;
            case '05':
                    $tipoDte = "Nota de Crédito Electrónica";
                break;
            case '06':
                    $tipoDte = "Nota de Débito Electrónica";
                break;
            case '07':
                    $tipoDte = "Comprobante de Retención Electrónico";
                break;
            case '08':
                    $tipoDte = "Comprobante de Liquidación Electrónico";
                break;
            case '09':
                    $tipoDte = "Documento Contable de Liquidación Electrónico";
                break;
            case '10':
                    $tipoDte = "Transmision";
                break;
            case '11':
                    $tipoDte = "Facturas de Exportación Electrónica";
                break;
            case '12':
                    $tipoDte = "Transmision";
                break;
            case '13':
                    $tipoDte = "Transmision";
                break;
            case '14':
                    $tipoDte = "Factura de Sujeto Excluido Electrónico";
                break;
            case '15':
                    $tipoDte = "Comprobante de Donación Electrónico";
                break;
            
            default:
                    $tipoDte = "";
                break;
        }

        return $tipoDte;
    }


    function rJson($data, $code = 200, $array = false) {
        while (ob_get_level() > 0) { ob_end_clean(); }

        $CI = &get_instance();
        $json = $array
            ? json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT)
            : (is_string($data) ? $data : json_encode($data, JSON_UNESCAPED_UNICODE));

        if ($json === "null") $json = "";

        $CI->output
            ->set_status_header($code)
            ->set_content_type('application/json', 'utf-8')
            ->set_output($json);

        $CI->output->_display();
        exit;
    }




    if ( ! function_exists('_mt_shorthand_from_bytes')) {
        function _mt_shorthand_from_bytes($bytes) {
            if ($bytes < 0) return '-1';
            $mb = (int)ceil($bytes / (1024 * 1024));
            return $mb . 'M';
        }
    }

    if ( ! function_exists('_mt_emit')) {
    function _mt_emit($text) {
            $CI =& get_instance();
            if (is_object($CI) && is_callable(array($CI, 'emitEvento'))) {
                $CI->emitEvento($text);
                return;
            }
            if (function_exists('log_message')) {
                @log_message('debug', '[memtools] ' . $text);
            }
        }
    }

    if ( ! function_exists('_raise_mem_for_heavy_work')) {

        function _raise_mem_for_heavy_work($target = NULL, $log = TRUE) {
            $prev = ini_get('memory_limit');

            if ($target !== NULL) {
                $tgt = is_numeric($target) ? _mt_shorthand_from_bytes($target) : $target;
                if (@ini_set('memory_limit', $tgt) !== FALSE) {
                    if ($log) _mt_emit('memory_limit: ' . ini_get('memory_limit'));
                    return $prev;
                }
            }

            $candidates = (PHP_INT_SIZE === 4)
                ? array('2048M','1536M','1024M')   // 32-bit
                : array('4096M','3072M','2048M');  // 64-bit

            foreach ($candidates as $m) {
                if (@ini_set('memory_limit', $m) !== FALSE && ini_get('memory_limit') === $m) {
                    if ($log) _mt_emit('memory_limit: ' . $m);
                    return $prev;
                }
            }

            if ($log) _mt_emit('memory_limit (sin cambio): ' . ini_get('memory_limit'));
            return $prev;
        }
    }

    if ( ! function_exists('_restore_memory_limit')) {
        function _restore_memory_limit($prev) {
            if ($prev !== NULL && $prev !== '') {
                @ini_set('memory_limit', $prev);
            }
        }
    }


    function getUnitMedidaByName($code,$campo = 'mep_nombre')
    {
        $CI = &get_instance();
        $CI->load->model('gsatelite');

        $name = $CI->gsatelite->get_campo("mep_medida_producto",$campo,["mep_cogigo_fact_elect"=>$code]);

        return $name ? $name : null;
    }

    function getTypeFacByName($code,$campo = 'tif_nombre')
    {
        $CI = &get_instance();
        $CI->load->model('gsatelite');

        $name = $CI->gsatelite->get_campo("tif_tipo_factura",$campo,["tif_codigo_fact_elect"=>$code]);

        return $name ? $name : null;
    }

    function getTypePayByName($code,$campo = 'tpg_nombre')
    {
        $CI = &get_instance();
        $CI->load->model('gsatelite');

        $name = $CI->gsatelite->get_campo("tpg_tipo_pago",$campo,["tpg_codigo_fact_elect"=>$code]);

        return $name ? $name : null;
    }

    function getImpuestoByName($code,$campo = 'imp_nombre')
    {
        $CI = &get_instance();
        $CI->load->model('gsatelite');

        $name = $CI->gsatelite->get_campo("imp_impuesto",$campo,["imp_codigo_fact_elect"=>$code]);

        return $name ? $name : null;
    }

    if (!function_exists('tipo_persona_proveedor')) {
    function tipo_persona_proveedor($nombre = '', $nombreComercial = '')
    {
        $normalize = function($s){
            if ($s === null) return '';
            $s = trim($s);
            $s = iconv('UTF-8','ASCII//TRANSLIT//IGNORE',$s);
            $s = strtoupper($s);
            $s = preg_replace('/\s+/', ' ', $s);
            return $s;
        };

        $razon = $normalize($nombre);
        $comer = $normalize($nombreComercial);
        $texto = trim($razon.' '.$comer);

        if ($texto === '') {
            return 1; 
        }

        $patterns = array(
            '/\bS\.?\s*A\.?\s*(DE)?\s*C\.?\s*V\.?\b/', 
            '/\bS\.?A\.?S\.?\b/',                    
            '/\bS\.?\s*R\.?\s*L\.?\b/',           
            '/\bLTDA\b/',
            '/\bSOCIEDAD\b/',
            '/\bCOMPAN[IÍ]A\b|\bCOMPA(N|Ñ)IA\b/',
            '/\bCORPORACI[OÓ]N\b/',
            '/\bASOCIACI[OÓ]N\b/',
            '/\bCOOPERATIVA\b/',
            '/\bFUNDACI[OÓ]N\b/',
            '/\bUNIVERSIDAD\b/',
            '/\bIGLESIA\b/',
            '/\bMINISTERIO\b/',
            '/\bALCALD[IÍ]A\b|\bMUNICIPALIDAD\b/',
            '/\bBANCO\b/',
            '/\bGRUPO\b/',
            '/\bINVERSION(ES)?\b/',
            '/\bSERVICIOS\b/',
            '/\bIMPORT(ADORA|ACIONES)\b/',
            '/\bEXPORT(ADORA|ACIONES)\b/',
            '/\bY\s+ASOCIADOS?\b/',
            '/\bCONSTRUCTORA\b|\bDISTRIBUIDORA\b|\bCOMERCIAL\b/'
        );

        foreach ($patterns as $rx) {
            if (preg_match($rx, $texto)) {
                return 2; // Jurídica
            }
        }

        if ($comer && str_word_count($comer) >= 3) {
            if (preg_match('/\b(SERVICIOS|COMERCIAL|IMPORT|EXPORT|INDUSTRIAL|TECNOLOG[IÍ]A|CONSULTORES?)\b/', $texto)) {
                return 2;
            }
        }

        return 1; // Natural
    }
}

    #***********************************************************************************************#
    #********************************** END LECTOR DE JSON *****************************************#
    #***********************************************************************************************#