<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With*');
header("Content-Type: application/json; charset=UTF-8");


if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Web_service_facturacion extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('facturacion_model');
        $this->load->model('gsatelite');
    }

    /**
     * @author Mario Marquez
     * @since 12-11-2018
     * @return 
     */
    function index() {
        
    }

     /**
     * @author Mario Marquez
     * @since 11-10-2019
     * @return Detalles para el POS de una factura en especifico
     */
    function obtener_detalles_factura(){
        if($this->input->post()){
            //Se obtiene el id de la Factura
            $fac_id = $this->input->post('factura');

            $this->db->join('cva_conversion_articulo','cva_id = def_id_cva','inner');
            $this->db->join('mep_medida_producto','mep_id = cva_id_mep','inner');
            $detalles_factura = $this->gsatelite->get_tabla('def_detalle_fact', array('def_id_fac' => $fac_id));

            $json_detalle = array();

            if(count($detalles_factura) > 0){
                foreach ($detalles_factura as $def) {
                    $detalle = array(
                        'cantidad' => $def['def_cantidad'],
                        'descripcion' => $def['def_descripcion'],
                        'idUnidadMedida' => $def['cva_id_mep'],
                        'unidad' => $def['mep_nombre'],
                        'precio' => $def['def_precio'],
                        'descuento' => $def['def_descuento'],
                        'total' => $def['def_subtotal'],
                        'idProducto' => $def['def_id_art'],
                        'idListaPrecios' => $def['def_id_lip'],
                        'porcentaje' => $def['def_porcentaje_descuento'],
                        'totalT' => $def['def_subtotal'] + $def['def_impuesto'] - $def['def_retencion'],
                        'bodega' => $def['def_id_bod'],
                        'aplica_descarga' => 1,
                        'retencion' => $def['def_retencion'],
                        'impuestos' => $def['def_impuesto'],
                        'porcentaje_impuestos' => $def['def_porcentaje_impuesto']
                    );

                    $json_detalle[] = $detalle;
                }
            }


            //echo json_encode($json_detalle);
            echo "jsonPHP".preg_replace("/\xEF\xBB\xBF/", "", json_encode($json_detalle, JSON_UNESCAPED_UNICODE  ));
        }
    }

    /**
     * @author René Castaneda
     * @since 12-11-2018
     * @return Obtener departamentos.
     */
    public function obtener_departamento() {   
        if($_POST){
            //query
            $where['dep_estado'] = 1;

            if (isset($_POST['todos'])) {
                if ($_POST['todos'] == 0) {
                    if (isset($_POST['id_depto'])) 
                    $where['dep_id'] = $_POST['id_depto'];

                    if (isset($_POST['nombre_depto'])) 
                        $where['dep_nombre'] = $_POST['nombre_depto'];
                    
                    if (!isset($_POST['id_depto']) && !isset($_POST['nombre_depto']) ) 
                        $where['dep_id']= 0;

                } else if ($_POST['todos'] == 1) {
                    $where              = null;
                    $where['dep_estado'] = 1;
                } else {
                    $departamentos['info'] = "Formato incorrecto.";
                    echo json_encode($departamentos);
                    die();
                }

                $campos = "dep_id AS id_depto, pai_id AS id_pais, dep_nombre AS nombre_depto, pai_nombre AS nombre_pais";
                $departamentos = $this->cotizaciones_model->obtener_departamento($where,$campos);
                if (count($departamentos)<=0) {
                    $departamentos['info'] = "Sin Registros";
                }
                echo json_encode($departamentos);
                die();
            } else {
                $departamentos['info'] = "Todos es requerido";
                echo json_encode($departamentos);
                die();
            }
        } else {
            $departamentos['info'] = "Acceso Denegado";
            echo json_encode($departamentos);
            die();
        }
    }

    /**
     * @author Francisco Orozco
     * @since 21-12-2018
     * @return Limpiar de caracteres raros una cadena(string)
     */
    function clean_string($string="",$sustituto_espacio="_"){

        $string = trim($string);

        //Esta parte se encarga de eliminar cualquier caracter extraño
        $string = str_replace(
            array("\\", "¨", "º", "-", "~","*",
                "#", "@", "|", "!", "\"",
                "·", "$", "%", "&", "/",
                "(", ")", "?", "'", "¡",
                "¿", "[", "^", "`", "]",
                "+", "}", "{", "¨", "´",
                ">", "< ", ";", ",", ":",
                "."),
            "$sustituto_espacio",
            $string
        );
        return $string;
    }

} // End class
